'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _eventKit = require('event-kit');

class ResolutionProgress {
  constructor() {
    this.emitter = new _eventKit.Emitter();
    this.markerCountByPath = new Map();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  reportMarkerCount(path, count) {
    const previous = this.markerCountByPath.get(path);
    this.markerCountByPath.set(path, count);
    if (count !== previous) {
      this.didUpdate();
    }
  }

  getRemaining(path) {
    return this.markerCountByPath.get(path);
  }

  isEmpty() {
    return this.markerCountByPath.size === 0;
  }
}
exports.default = ResolutionProgress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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