'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _net = require('net');

var _net2 = _interopRequireDefault(_net);

var _eventKit = require('event-kit');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitPromptServer {
  constructor(gitTempDir) {
    this.emitter = new _eventKit.Emitter();
    this.gitTempDir = gitTempDir;
  }

  async start(promptForInput) {
    this.promptForInput = promptForInput;

    await this.gitTempDir.ensure();
    this.server = await this.startListening(this.gitTempDir.getSocketPath());
  }

  startListening(socketPath) {
    return new Promise(resolve => {
      const server = _net2.default.createServer(connection => {
        connection.setEncoding('utf8');

        const parts = [];

        connection.on('data', data => {
          const nullIndex = data.indexOf('\u0000');
          if (nullIndex === -1) {
            parts.push(data);
          } else {
            parts.push(data.substring(0, nullIndex));
            this.handleData(connection, parts.join(''));
          }
        });
      });

      server.listen(socketPath, () => resolve(server));
    });
  }

  handleData(connection, data) {
    let query;
    try {
      query = JSON.parse(data);
    } catch (e) {
      this.emitter.emit('did-cancel');
    }

    Promise.resolve(this.promptForInput(query)).then(answer => connection.end(JSON.stringify(answer), 'utf-8')).catch(() => this.emitter.emit('did-cancel', { handlerPid: query.pid }));
  }

  onDidCancel(cb) {
    return this.emitter.on('did-cancel', cb);
  }

  async terminate() {
    await new Promise(resolve => this.server.close(resolve));
    this.emitter.dispose();
  }
}
exports.default = GitPromptServer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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