'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _helpers = require('../helpers');

var _reporterProxy = require('../reporter-proxy');

var _propTypes3 = require('../prop-types');

var _issueishSearchesController = require('./issueish-searches-controller');

var _issueishSearchesController2 = _interopRequireDefault(_issueishSearchesController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RemoteController extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onCreatePr');
  }

  render() {
    return _react2.default.createElement(_issueishSearchesController2.default, {
      endpoint: this.props.endpoint,
      token: this.props.token,

      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      repository: this.props.repository,

      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,

      onCreatePr: this.onCreatePr
    });
  }

  async onCreatePr() {
    const currentBranch = this.props.branches.getHeadBranch();
    const upstream = currentBranch.getUpstream();
    if (!upstream.isPresent() || this.props.aheadCount > 0) {
      await this.props.onPushBranch();
    }

    let createPrUrl = 'https://github.com/';
    createPrUrl += this.props.remote.getOwner() + '/' + this.props.remote.getRepo();
    createPrUrl += '/compare/' + encodeURIComponent(currentBranch.getName());
    createPrUrl += '?expand=1';

    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(createPrUrl, {}, err => {
        if (err) {
          reject(err);
        } else {
          (0, _reporterProxy.incrementCounter)('create-pull-request');
          resolve();
        }
      });
    });
  }
}
exports.default = RemoteController;
RemoteController.propTypes = {
  // Relay payload
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  // Connection
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Repository derived attributes
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  workspace: _propTypes2.default.object.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  // Actions
  onPushBranch: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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