'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _commitDetailView = require('../views/commit-detail-view');

var _commitDetailView2 = _interopRequireDefault(_commitDetailView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CommitDetailController extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.toggleMessage = () => {
      return new Promise(resolve => {
        this.setState(prevState => ({ messageOpen: !prevState.messageOpen }), resolve);
      });
    };

    this.state = {
      messageCollapsible: this.props.commit.isBodyLong(),
      messageOpen: !this.props.commit.isBodyLong()
    };
  }

  render() {
    return _react2.default.createElement(_commitDetailView2.default, _extends({
      messageCollapsible: this.state.messageCollapsible,
      messageOpen: this.state.messageOpen,
      toggleMessage: this.toggleMessage
    }, this.props));
  }

}
exports.default = CommitDetailController;
CommitDetailController.propTypes = _extends({}, _commitDetailView2.default.drilledPropTypes, {

  commit: _propTypes2.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbW1pdC1kZXRhaWwtY29udHJvbGxlci5qcyJdLCJuYW1lcyI6WyJDb21taXREZXRhaWxDb250cm9sbGVyIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwidG9nZ2xlTWVzc2FnZSIsIlByb21pc2UiLCJyZXNvbHZlIiwic2V0U3RhdGUiLCJwcmV2U3RhdGUiLCJtZXNzYWdlT3BlbiIsInN0YXRlIiwibWVzc2FnZUNvbGxhcHNpYmxlIiwiY29tbWl0IiwiaXNCb2R5TG9uZyIsInJlbmRlciIsInByb3BUeXBlcyIsIkNvbW1pdERldGFpbFZpZXciLCJkcmlsbGVkUHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFBQTs7OztBQUNBOzs7O0FBRUE7Ozs7OztBQUVlLE1BQU1BLHNCQUFOLFNBQXFDQyxnQkFBTUMsU0FBM0MsQ0FBcUQ7O0FBT2xFQyxjQUFZQyxLQUFaLEVBQW1CO0FBQ2pCLFVBQU1BLEtBQU47O0FBRGlCLFNBb0JuQkMsYUFwQm1CLEdBb0JILE1BQU07QUFDcEIsYUFBTyxJQUFJQyxPQUFKLENBQVlDLFdBQVc7QUFDNUIsYUFBS0MsUUFBTCxDQUFjQyxjQUFjLEVBQUNDLGFBQWEsQ0FBQ0QsVUFBVUMsV0FBekIsRUFBZCxDQUFkLEVBQW9FSCxPQUFwRTtBQUNELE9BRk0sQ0FBUDtBQUdELEtBeEJrQjs7QUFHakIsU0FBS0ksS0FBTCxHQUFhO0FBQ1hDLDBCQUFvQixLQUFLUixLQUFMLENBQVdTLE1BQVgsQ0FBa0JDLFVBQWxCLEVBRFQ7QUFFWEosbUJBQWEsQ0FBQyxLQUFLTixLQUFMLENBQVdTLE1BQVgsQ0FBa0JDLFVBQWxCO0FBRkgsS0FBYjtBQUlEOztBQUVEQyxXQUFTO0FBQ1AsV0FDRSw4QkFBQywwQkFBRDtBQUNFLDBCQUFvQixLQUFLSixLQUFMLENBQVdDLGtCQURqQztBQUVFLG1CQUFhLEtBQUtELEtBQUwsQ0FBV0QsV0FGMUI7QUFHRSxxQkFBZSxLQUFLTDtBQUh0QixPQUlNLEtBQUtELEtBSlgsRUFERjtBQVFEOztBQXpCaUU7a0JBQS9DSixzQjtBQUFBQSxzQixDQUNaZ0IsUyxnQkFDRkMsMkJBQWlCQyxnQjs7QUFFcEJMLFVBQVFNLG9CQUFVQyxNQUFWLENBQWlCQyIsImZpbGUiOiJjb21taXQtZGV0YWlsLWNvbnRyb2xsZXIuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvY29udHJvbGxlcnMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IENvbW1pdERldGFpbFZpZXcgZnJvbSAnLi4vdmlld3MvY29tbWl0LWRldGFpbC12aWV3JztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ29tbWl0RGV0YWlsQ29udHJvbGxlciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLi4uQ29tbWl0RGV0YWlsVmlldy5kcmlsbGVkUHJvcFR5cGVzLFxuXG4gICAgY29tbWl0OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcblxuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICBtZXNzYWdlQ29sbGFwc2libGU6IHRoaXMucHJvcHMuY29tbWl0LmlzQm9keUxvbmcoKSxcbiAgICAgIG1lc3NhZ2VPcGVuOiAhdGhpcy5wcm9wcy5jb21taXQuaXNCb2R5TG9uZygpLFxuICAgIH07XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxDb21taXREZXRhaWxWaWV3XG4gICAgICAgIG1lc3NhZ2VDb2xsYXBzaWJsZT17dGhpcy5zdGF0ZS5tZXNzYWdlQ29sbGFwc2libGV9XG4gICAgICAgIG1lc3NhZ2VPcGVuPXt0aGlzLnN0YXRlLm1lc3NhZ2VPcGVufVxuICAgICAgICB0b2dnbGVNZXNzYWdlPXt0aGlzLnRvZ2dsZU1lc3NhZ2V9XG4gICAgICAgIHsuLi50aGlzLnByb3BzfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgdG9nZ2xlTWVzc2FnZSA9ICgpID0+IHtcbiAgICByZXR1cm4gbmV3IFByb21pc2UocmVzb2x2ZSA9PiB7XG4gICAgICB0aGlzLnNldFN0YXRlKHByZXZTdGF0ZSA9PiAoe21lc3NhZ2VPcGVuOiAhcHJldlN0YXRlLm1lc3NhZ2VPcGVufSksIHJlc29sdmUpO1xuICAgIH0pO1xuICB9XG59XG4iXX0=