/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class BeanCreateRule
extends Rule {
    private static Log log = LogFactory.getLog(class$org$apache$commons$betwixt$io$BeanCreateRule == null ? (class$org$apache$commons$betwixt$io$BeanCreateRule = BeanCreateRule.class$("org.apache.commons.betwixt.io.BeanCreateRule")) : class$org$apache$commons$betwixt$io$BeanCreateRule);
    private ElementDescriptor descriptor;
    private Context context;
    private boolean addedChildren;
    private boolean createdBean;
    private Class beanClass;
    private String pathPrefix;
    private boolean matchIDs = true;
    private String classNameAttribute = "className";
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanCreateRule;

    public static void setLog(Log aLog) {
        log = aLog;
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass, String pathPrefix) {
        this(descriptor, beanClass, pathPrefix, true);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass, String pathPrefix, boolean matchIDs) {
        this(descriptor, beanClass, new Context(), pathPrefix, matchIDs);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass) {
        this(descriptor, beanClass, true);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Class beanClass, boolean matchIDs) {
        this(descriptor, beanClass, descriptor.getQualifiedName() + "/", matchIDs);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Context context, String pathPrefix) {
        this(descriptor, context, pathPrefix, true);
    }

    public BeanCreateRule(ElementDescriptor descriptor, Context context, String pathPrefix, boolean matchIDs) {
        this(descriptor, descriptor.getSingularPropertyType(), context, pathPrefix, matchIDs);
    }

    private BeanCreateRule(ElementDescriptor descriptor, Class beanClass, Context context, String pathPrefix, boolean matchIDs) {
        this.descriptor = descriptor;
        this.context = context;
        this.beanClass = beanClass;
        this.pathPrefix = pathPrefix;
        this.matchIDs = matchIDs;
        if (log.isTraceEnabled()) {
            log.trace("Created bean create rule");
            log.trace("Descriptor=" + descriptor);
            log.trace("Class=" + beanClass);
            log.trace("Path prefix=" + pathPrefix);
        }
    }

    public void begin(Attributes attributes) {
        log.debug("Called with descriptor: " + this.descriptor + " propertyType: " + this.descriptor.getPropertyType());
        if (log.isTraceEnabled()) {
            int attributesLength = attributes.getLength();
            if (attributesLength > 0) {
                log.trace("Attributes:");
            }
            int size = attributesLength;
            for (int i = 0; i < size; ++i) {
                log.trace("Local:" + attributes.getLocalName(i));
                log.trace("URI:" + attributes.getURI(i));
                log.trace("QName:" + attributes.getQName(i));
            }
        }
        this.createdBean = false;
        Object instance = null;
        if (this.beanClass != null && (instance = this.createBean(attributes)) != null) {
            String id;
            this.createdBean = true;
            this.context.setBean(instance);
            this.digester.push(instance);
            ElementDescriptor typeDescriptor = this.getElementDescriptor(this.descriptor);
            AttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributeDescriptors();
            if (attributeDescriptors != null) {
                int size = attributeDescriptors.length;
                for (int i = 0; i < size; ++i) {
                    AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                    String value = attributes.getValue(attributeDescriptor.getURI(), attributeDescriptor.getLocalName());
                    if (value == null) {
                        value = attributes.getValue(attributeDescriptor.getQualifiedName());
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Attr URL:" + attributeDescriptor.getURI());
                        log.trace("Attr LocalName:" + attributeDescriptor.getLocalName());
                        log.trace(value);
                    }
                    Updater updater = attributeDescriptor.getUpdater();
                    log.trace(updater);
                    if (updater == null || value == null) continue;
                    updater.update(this.context, value);
                }
            }
            this.addChildRules();
            if (this.matchIDs && (id = attributes.getValue("id")) != null) {
                this.getBeansById().put(id, instance);
            }
        }
    }

    public void end() {
        if (this.createdBean) {
            Updater updater = this.descriptor.getUpdater();
            Object instance = this.context.getBean();
            Object top = this.digester.pop();
            if (this.digester.getCount() == 0) {
                this.context.setBean(null);
            } else {
                this.context.setBean(this.digester.peek());
            }
            if (updater != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Calling updater for: " + this.descriptor + " with: " + instance + " on bean: " + this.context.getBean());
                }
                updater.update(this.context, instance);
            } else if (log.isDebugEnabled()) {
                log.debug("No updater for: " + this.descriptor + " with: " + instance + " on bean: " + this.context.getBean());
            }
        }
    }

    public void finish() {
    }

    public String getClassNameAttribute() {
        return this.classNameAttribute;
    }

    public void setClassNameAttribute(String classNameAttribute) {
        this.classNameAttribute = classNameAttribute;
    }

    protected Object createBean(Attributes attributes) {
        String idref;
        if (this.matchIDs && (idref = attributes.getValue("idref")) != null) {
            log.trace("Found IDREF");
            Object bean = this.getBeansById().get(idref);
            if (bean != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Matched bean " + bean);
                }
                return bean;
            }
            log.trace("No match found");
        }
        Class<?> theClass = this.beanClass;
        try {
            String className = attributes.getValue(this.classNameAttribute);
            if (className != null) {
                theClass = this.getDigester().getClassLoader().loadClass(className);
            }
            if (log.isTraceEnabled()) {
                log.trace("Creating instance of " + theClass);
            }
            return theClass.newInstance();
        }
        catch (Exception e) {
            log.warn("Could not create instance of type: " + theClass.getName());
            return null;
        }
    }

    protected void addChildRules() {
        if (!this.addedChildren) {
            this.addedChildren = true;
            this.addChildRules(this.pathPrefix, this.descriptor);
        }
    }

    protected void addChildRules(String prefix, ElementDescriptor currentDescriptor) {
        ElementDescriptor typeDescriptor;
        ElementDescriptor[] childDescriptors;
        if (log.isTraceEnabled()) {
            log.trace("Adding child rules for " + currentDescriptor + "@" + prefix);
        }
        if ((childDescriptors = (typeDescriptor = this.getElementDescriptor(currentDescriptor)).getElementDescriptors()) != null) {
            int size = childDescriptors.length;
            for (int i = 0; i < size; ++i) {
                String qualifiedName;
                ElementDescriptor childDescriptor = childDescriptors[i];
                if (log.isTraceEnabled()) {
                    log.trace("Processing child " + childDescriptor);
                }
                if ((qualifiedName = childDescriptor.getQualifiedName()) == null) {
                    log.trace("Ignoring");
                    continue;
                }
                String path = prefix + qualifiedName;
                if (qualifiedName.equals(currentDescriptor.getQualifiedName()) && currentDescriptor.getPropertyName() != null) {
                    log.trace("Creating generic rule for recursive elements");
                    int index = -1;
                    if (childDescriptor.isWrapCollectionsInElement()) {
                        index = prefix.indexOf(qualifiedName);
                        if (index == -1) {
                            log.debug("Oops - this shouldn't happen");
                            continue;
                        }
                        int removeSlash = prefix.endsWith("/") ? 1 : 0;
                        path = "*/" + prefix.substring(index, prefix.length() - removeSlash);
                    } else {
                        ElementDescriptor[] desc = currentDescriptor.getElementDescriptors();
                        if (desc.length == 1) {
                            path = "*/" + desc[0].getQualifiedName();
                        }
                    }
                    BeanCreateRule rule = new BeanCreateRule(childDescriptor, this.context, path, this.matchIDs);
                    this.addRule(path, rule);
                    continue;
                }
                if (childDescriptor.getUpdater() != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("Element has updater " + ((MethodUpdater)childDescriptor.getUpdater()).getMethod().getName());
                    }
                    if (childDescriptor.isPrimitiveType()) {
                        this.addPrimitiveTypeRule(path, childDescriptor);
                    } else {
                        Class beanClass;
                        ElementDescriptor grandChild;
                        String grandChildQName;
                        ElementDescriptor[] grandChildren = childDescriptor.getElementDescriptors();
                        if (grandChildren != null && grandChildren.length > 0 && (grandChildQName = (grandChild = grandChildren[0]).getQualifiedName()) != null && grandChildQName.length() > 0) {
                            path = childDescriptor.isWrapCollectionsInElement() ? path + '/' + grandChildQName : prefix + (prefix.endsWith("/") ? "" : "/") + grandChildQName;
                        }
                        if (XMLIntrospectorHelper.isPrimitiveType(beanClass = childDescriptor.getSingularPropertyType())) {
                            this.addPrimitiveTypeRule(path, childDescriptor);
                        } else {
                            BeanCreateRule rule = new BeanCreateRule(childDescriptor, this.context, path + '/', this.matchIDs);
                            this.addRule(path, rule);
                        }
                    }
                } else {
                    log.trace("Element does not have updater");
                }
                ElementDescriptor[] grandChildren = childDescriptor.getElementDescriptors();
                if (grandChildren == null || grandChildren.length <= 0) continue;
                log.trace("Adding grand children");
                this.addChildRules(path + '/', childDescriptor);
            }
        }
    }

    protected BeanReader getBeanReader() {
        return (BeanReader)this.getDigester();
    }

    protected ElementDescriptor getElementDescriptor(ElementDescriptor propertyDescriptor) {
        Class beanClass = propertyDescriptor.getSingularPropertyType();
        if (beanClass != null) {
            XMLIntrospector introspector = this.getBeanReader().getXMLIntrospector();
            try {
                XMLBeanInfo xmlInfo = introspector.introspect(beanClass);
                return xmlInfo.getElementDescriptor();
            }
            catch (Exception e) {
                log.warn("Could not introspect class: " + beanClass, e);
            }
        }
        return propertyDescriptor;
    }

    protected void addPrimitiveTypeRule(String path, final ElementDescriptor childDescriptor) {
        Rule rule = new Rule(){

            public void body(String text) throws Exception {
                childDescriptor.getUpdater().update(BeanCreateRule.this.context, text);
            }
        };
        this.addRule(path, rule);
    }

    protected void addRule(String path, Rule rule) {
        Rules rules = this.digester.getRules();
        List matches = rules.match(null, path);
        if (matches.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Adding digester rule for path: " + path + " rule: " + rule);
            }
            this.digester.addRule(path, rule);
        } else if (log.isDebugEnabled()) {
            log.debug("Ignoring duplicate digester rule for path: " + path + " rule: " + rule);
            log.debug("New rule (not added): " + rule);
            log.debug("Existing rule:" + matches.get(0));
        }
    }

    protected Map getBeansById() {
        HashMap beansById = (HashMap)this.context.getVariable("beans-index");
        if (beansById == null) {
            beansById = new HashMap();
            this.context.setVariable("beans-index", beansById);
            log.trace("Created new index-by-id map");
        }
        return beansById;
    }

    public String toString() {
        return "BeanCreateRule [path prefix=" + this.pathPrefix + " descriptor=" + this.descriptor + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

