/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.thread;

import net.sourceforge.glsof.queries.thread.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

class QueryRunningAnimation
implements Runnable {
    private static final String LOADING_QUERY = "/icons/loading.gif";
    private ImageData[] _animationImages = new ImageLoader().load(this.getClass().getResourceAsStream("/icons/loading.gif"));
    private int _animationIndex = 0;
    private int _delay;
    private TreeItem _treeItem;
    private boolean _running = true;

    public QueryRunningAnimation(TreeItem treeItem) {
        this._treeItem = treeItem;
    }

    @Override
    public void run() {
        if (this._treeItem.isDisposed()) {
            return;
        }
        if (this._running) {
            this._treeItem.setImage(this.getAnimationImage());
            Display.getDefault().timerExec(this._delay, this);
        } else {
            this._treeItem.setImage(new Image[]{null});
            this._treeItem.setExpanded(true);
        }
    }

    private Image getAnimationImage() {
        CompositeImageDescriptor icon = new CompositeImageDescriptor(){

            @Override
            protected void drawCompositeImage(int width, int height) {
                this.drawImage(QueryRunningAnimation.this._animationImages[QueryRunningAnimation.this._animationIndex], 0, 0);
                QueryRunningAnimation.this.updateAnimationIndex();
                QueryRunningAnimation.this.updateDelayTime();
            }

            @Override
            protected Point getSize() {
                return new Point(16, 16);
            }
        };
        return icon.createImage(true, Display.getCurrent());
    }

    private void updateDelayTime() {
        this._delay = this._animationImages[this._animationIndex].delayTime * 10;
    }

    private void updateAnimationIndex() {
        this._animationIndex = this._animationIndex == this._animationImages.length - 1 ? 0 : this._animationIndex + 1;
    }

    public void stop() {
        this._running = false;
    }
}

