/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.thread;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.glsof.common.i18n.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class Logger {
    public static final String START_COLOR = "start";
    public static final String STOP_COLOR = "stop";
    public static final String ERR_COLOR = "err";
    private static final String CLEAR_BUTTON_IMAGE = "/icons/q-clear.png";
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private Map<String, Color> _colors;
    private StyledText _styledText;

    public void create(Composite parent, ArrayList<Integer> start, ArrayList<Integer> stop, ArrayList<Integer> err) {
        Composite main = this.mainContainer(parent);
        this.textLogger(main);
        this.menuLogger(main, start, stop, err);
    }

    private Composite mainContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        composite.setLayout(grid);
        composite.setLayoutData(new GridData(1808));
        return composite;
    }

    private void textLogger(Composite main) {
        Composite composite = new Composite(main, 0);
        this._styledText = new StyledText(composite, 2826);
        GridLayout layoutText = new GridLayout(1, false);
        layoutText.marginWidth = 0;
        layoutText.marginHeight = 0;
        composite.setLayout(layoutText);
        composite.setLayoutData(new GridData(1842));
        this._styledText.setEditable(false);
        this._styledText.setLayout(new GridLayout(1, false));
        this._styledText.setLayoutData(new GridData(1808));
    }

    private void menuLogger(Composite main, ArrayList<Integer> start, ArrayList<Integer> stop, ArrayList<Integer> err) {
        Composite composite = new Composite(main, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout(layout);
        composite.setLayoutData(new GridData(1170));
        this._colors = new HashMap<String, Color>();
        this._colors.put(START_COLOR, new Color(composite.getDisplay(), new RGB(start.get(0), start.get(1), start.get(2))));
        this._colors.put(STOP_COLOR, new Color(composite.getDisplay(), new RGB(stop.get(0), stop.get(1), stop.get(2))));
        this._colors.put(ERR_COLOR, new Color(composite.getDisplay(), new RGB(err.get(0), err.get(1), err.get(2))));
        this.createColorLabel(composite, Messages.NLS("Start"), START_COLOR);
        this.createColorLabel(composite, Messages.NLS("Stop"), STOP_COLOR);
        this.createColorLabel(composite, Messages.NLS("Error"), ERR_COLOR);
        Button clear = new Button(composite, 0);
        clear.setLayoutData(new GridData(768));
        clear.setText(Messages.NLS("Clear"));
        Image clearButtonImage = new Image((Device)composite.getDisplay(), this.getClass().getResourceAsStream(CLEAR_BUTTON_IMAGE));
        clear.setImage(clearButtonImage);
        clearButtonImage.dispose();
        clear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent event) {
                Logger.this._styledText.replaceTextRange(0, Logger.this._styledText.getCharCount(), "");
            }
        });
    }

    private void createColorLabel(final Composite composite, String text, final String logName) {
        Button button = new Button(composite, 0);
        button.setText(text);
        button.setLayoutData(new GridData(800));
        final Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(64));
        label.setText("                  ");
        label.setBackground(this._colors.get(logName));
        button.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                ColorDialog dlg = new ColorDialog(composite.getShell());
                dlg.setRGB(label.getBackground().getRGB());
                dlg.setText(Messages.NLS("Choose_a_Color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                    Color newColor = new Color(composite.getDisplay(), rgb);
                    for (int i = 0; i < Logger.this._styledText.getLineCount(); ++i) {
                        if (Logger.this._styledText.getLineBackground(i) != Logger.this._colors.get(logName)) continue;
                        Logger.this._styledText.setLineBackground(i, 1, null);
                        ((Color)Logger.this._colors.get(logName)).dispose();
                        Logger.this._styledText.setLineBackground(i, 1, newColor);
                    }
                    Logger.this._styledText.redraw();
                    Logger.this._colors.put(logName, newColor);
                    label.setBackground(newColor);
                }
            }
        });
    }

    public void logMessage(String text, String color) {
        if (this._styledText == null) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        this._styledText.append("[" + sdf.format(cal.getTime()) + "] [" + color.toUpperCase() + "] " + text + "\n");
        this._styledText.setLineBackground(this._styledText.getLineCount() - 2, 1, this._colors.get(color));
        ScrollBar vb = this._styledText.getVerticalBar();
        vb.setSelection(vb.getMaximum());
        Event e = new Event();
        e.widget = vb;
        vb.notifyListeners(13, e);
    }

    public Map<String, Color> getColors() {
        return this._colors;
    }
}

