/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.stats;

import java.util.Map;
import net.sourceforge.glsof.common.about.AbstractButtonsDialog;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.queries.stats.QueryStatistics;
import net.sourceforge.glsof.queries.stats.QueryStatisticsChartFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TreeItem;

public class QueryStatisticsDialog
extends AbstractButtonsDialog {
    private QueryStatistics _queryStatistics = new QueryStatistics();
    private String _queryName;
    private boolean _showFirstChart = true;

    public QueryStatisticsDialog(Shell shell, Map<String, Table> tables, TreeItem[] items, String queryName) {
        super(shell, Messages.NLS("Statistics_for_query"));
        this._queryStatistics.calculate(items, tables);
        this._queryName = queryName;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(800, 600);
        Composite main = new Composite(parent, 0);
        main.setLayoutData(new GridData(4, 4, true, true));
        main.setLayout(new GridLayout(2, true));
        Label label = new Label(main, 0);
        label.setText(this._queryName);
        FontData labelFontData = new FontData("Arial", 14, 1);
        Font font = new Font((Device)this.getShell().getDisplay(), labelFontData);
        label.setFont(font);
        font.dispose();
        Button pageButton = new Button(main, 8);
        pageButton.setText(Messages.NLS("Change_chart"));
        pageButton.setLayoutData(new GridData(128));
        final Composite chartsContainer = new Composite(main, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        chartsContainer.setLayoutData(data);
        final StackLayout stackLayout = new StackLayout();
        chartsContainer.setLayout(stackLayout);
        QueryStatisticsChartFactory factory = new QueryStatisticsChartFactory(this.getShell());
        final Composite firstChart = factory.create(chartsContainer, new String[]{Messages.NLS("Processes"), Messages.NLS("Rows"), Messages.NLS("Percent")}, this._queryStatistics.getProcesses(), this._queryStatistics.getTotalRowsCount());
        final Composite secondChart = factory.create(chartsContainer, new String[]{Messages.NLS("Users"), Messages.NLS("Rows"), Messages.NLS("Percent")}, this._queryStatistics.getUsers(), this._queryStatistics.getTotalRowsCount());
        pageButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                QueryStatisticsDialog.this._showFirstChart = !QueryStatisticsDialog.this._showFirstChart;
                stackLayout.topControl = QueryStatisticsDialog.this._showFirstChart ? firstChart : secondChart;
                chartsContainer.layout();
            }
        });
        stackLayout.topControl = firstChart;
        chartsContainer.layout();
        chartsContainer.pack();
        return main;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.NLS("Close"));
    }

    @Override
    protected void buttonPressed(int buttonId) {
        this.close();
    }
}

