/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.stats;

import java.text.DecimalFormat;
import java.util.Map;
import net.sourceforge.glsof.queries.stats.QueriesChartSortListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class QueryStatisticsChartFactory {
    private static final int WIDTH_RATE_COLUMN_1 = 4;
    private static final int WIDTH_RATE_COLUMN_2 = 4;
    private static final int WIDTH_RATE_COLUMN_3 = 2;
    private final Shell _shell;

    public QueryStatisticsChartFactory(Shell shell) {
        this._shell = shell;
    }

    private FillLayout createFillLayout() {
        FillLayout f = new FillLayout();
        f.marginHeight = 0;
        f.marginWidth = 0;
        f.spacing = 0;
        return f;
    }

    public Composite create(Composite chartsContainer, String[] columnsNames, Map<String, Integer> stats, final int totalRowsCount) {
        Composite comp = new Composite(chartsContainer, 2048);
        comp.setLayout(new FillLayout());
        final Table table = new Table(comp, 2048);
        table.setLayout(new FillLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(columnsNames[0]);
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(columnsNames[1]);
        final TableColumn column3 = new TableColumn(table, 0);
        column3.setText(columnsNames[2]);
        for (Map.Entry<String, Integer> entry : stats.entrySet()) {
            Integer rows = entry.getValue();
            TableItem item = new TableItem(table, 0);
            item.setText(0, entry.getKey());
            item.setText(1, Integer.toString(rows));
        }
        column1.addListener(13, new QueriesChartSortListener(table, "t", 3, 0));
        column2.addListener(13, new QueriesChartSortListener(table, "n", 3, 1));
        table.setSortColumn(column1);
        table.setSortColumn(column2);
        table.setSortDirection(128);
        Event e = new Event();
        e.widget = column2;
        column2.notifyListeners(13, e);
        table.addListener(42, new Listener(){
            final Display display;
            {
                this.display = QueryStatisticsChartFactory.this._shell.getDisplay();
            }

            @Override
            public void handleEvent(Event event) {
                if (event.index == 2) {
                    GC gc = event.gc;
                    TableItem item = (TableItem)event.item;
                    double percent = Double.parseDouble(item.getText(1)) * 100.0 / (double)totalRowsCount;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    gc.setForeground(this.display.getSystemColor(3));
                    gc.setBackground(this.display.getSystemColor(7));
                    int width = (column3.getWidth() - 1) * (int)percent / 100;
                    gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
                    gc.drawRectangle(new Rectangle(event.x, event.y, width - 1, event.height - 1));
                    gc.setForeground(this.display.getSystemColor(24));
                    String text = new DecimalFormat("###.##").format(percent) + "%";
                    Point size = event.gc.textExtent(text);
                    int offset = Math.max(0, (event.height - size.y) / 2);
                    gc.drawText(text, event.x, event.y + offset, true);
                    gc.setForeground(background);
                    gc.setBackground(foreground);
                }
            }
        });
        this._shell.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                int width = table.getBounds().width - table.getBorderWidth() * 2;
                column1.setWidth(width / 4);
                column2.setWidth(width / 4);
                column3.setWidth(width / 2);
            }
        });
        return comp;
    }
}

