/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.queries;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.WidgetsUtils;
import net.sourceforge.glsof.queries.editor.QueryPreferencesRepository;
import net.sourceforge.glsof.queries.queries.QueriesSearchBar;
import net.sourceforge.glsof.queries.stats.QueryStatisticsDialog;
import net.sourceforge.glsof.queries.thread.Logger;
import net.sourceforge.glsof.queries.thread.QueryObserver;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class Queries {
    private Tree _queryTree;
    private Map<String, QueryObserver> _queries;
    private Composite _queryTablesContainer;
    private Composite _searchBarContainer;
    private Label _statusBar;
    private Logger _logger;
    private QueryPreferencesRepository _queryPreferencesRepository;

    public Queries(File dir, Tree queryTree, Composite searchBarContainer, Composite queryTablesContainer, Label statusBar) {
        this._queryPreferencesRepository = new QueryPreferencesRepository(dir);
        this._queryTree = queryTree;
        this._queries = new LinkedHashMap<String, QueryObserver>();
        this._queryTablesContainer = queryTablesContainer;
        this._searchBarContainer = searchBarContainer;
        this._statusBar = statusBar;
        new QueriesSearchBar(searchBarContainer, this._queryTree, this._queries);
    }

    public void createLogger(Composite vForm, ArrayList<Integer>[] cols) {
        this._logger = new Logger();
        this._logger.create(vForm, cols[0], cols[1], cols[2]);
    }

    public void loadAllQueries() {
        for (String name : this._queryPreferencesRepository.findAllQueryNames()) {
            TreeItem treeItem = new TreeItem(this._queryTree, 0);
            this.initQueryItem(treeItem, name);
            this._queries.put(name, new QueryObserver(this._searchBarContainer, this._queryTablesContainer, treeItem, this._logger));
        }
    }

    public void createQueryIfPossible(TreeItem treeItem) {
        String queryName = treeItem.getText();
        if (queryName.equals("")) {
            treeItem.dispose();
            return;
        }
        if (this._queries.get(queryName) != null) {
            WidgetsUtils.warningMessage(Messages.NLS("There_is_already_a_query_with_this_name")).open();
            return;
        }
        this._queries.put(queryName, new QueryObserver(this._searchBarContainer, this._queryTablesContainer, treeItem, this._logger));
        if (!this._queryPreferencesRepository.create(queryName)) {
            this._queries.remove(queryName);
            treeItem.dispose();
        }
    }

    public void renameQueryIfPossible(TreeItem treeItem, String newName) {
        if (newName != null && this._queryPreferencesRepository.rename(treeItem.getText(), newName)) {
            this.renameQuery(treeItem, newName);
            treeItem.setText(newName);
        }
    }

    private void renameQuery(TreeItem treeItem, String newName) {
        QueryObserver queryObserver = this._queries.get(treeItem.getText());
        queryObserver.setQueryTreeItem(treeItem);
        this._queries.remove(treeItem.getText());
        this._queries.put(newName, queryObserver);
        treeItem.setText(newName);
    }

    public void edit() {
        this._queryPreferencesRepository.edit(this.getSelectedQueryName());
    }

    public void remove() {
        TreeItem selectedTreeItem = this._queryTree.getSelection()[0];
        String name = selectedTreeItem.getText();
        this._queries.get(name).disposeAll();
        this._queries.remove(name);
        selectedTreeItem.dispose();
        this._queryPreferencesRepository.remove(name);
    }

    public void run() {
        TreeItem selectedTreeItem = this._queryTree.getSelection()[0];
        this._queries.get(selectedTreeItem.getText()).disposeAll();
        for (TreeItem item : selectedTreeItem.getItems()) {
            item.dispose();
        }
        this._queries.get(selectedTreeItem.getText()).runLsof(this._queryPreferencesRepository.getLsofParameters(this.getSelectedQueryName()), this._queryPreferencesRepository.getColumns(this.getSelectedQueryName()));
    }

    public void createStatistics() {
        String name = this.getSelectedQueryName();
        new QueryStatisticsDialog(Display.getCurrent().getActiveShell(), this._queries.get(name).getTables(), this._queries.get(name).getQueryTreeItem().getItems(), name).open();
    }

    public void initQueryItem(TreeItem treeItem, String text) {
        treeItem.setText(text);
        treeItem.setForeground(Display.getCurrent().getSystemColor(4));
        Font font = new Font((Device)Display.getCurrent(), "Arial", 10, 1);
        treeItem.setFont(font);
        font.dispose();
    }

    public void selectQuery() {
        this._queryTree.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                ((StackLayout)((Queries)Queries.this)._queryTablesContainer.getLayout()).topControl = Queries.this.getTableToSelect(item.getText());
                Queries.this._queryTablesContainer.layout();
            }
        });
    }

    private Table getTableToSelect(String name) {
        if (this._queryTree.getSelection().length == 0 || name == null) {
            return null;
        }
        TreeItem item = this._queryTree.getSelection()[0];
        if (item.getParentItem() == null) {
            this._statusBar.setText(Messages.NLS("Query") + " <" + name + ">. " + Messages.NLS("Processes") + ": " + item.getItemCount());
            return null;
        }
        Table table = this._queries.get(item.getParentItem().getText()).getTableForProcess(item.getText());
        this._statusBar.setText(Messages.NLS("Process") + " <" + name + "> " + Messages.NLS("lines") + ": " + table.getItemCount());
        return table;
    }

    public void setColumnsViews(List<Boolean> views, int index) {
        for (Table table : this._queries.get(this.getSelectedQueryName()).getTables().values()) {
            TableColumn column = table.getColumn(index);
            Boolean view = views.get(index);
            column.setWidth(view != false ? 100 : 0);
            column.setResizable(view);
        }
        this._queryPreferencesRepository.setColumns(views, this.getSelectedQueryName());
    }

    public List<Boolean> getColumnsViews() {
        return this._queryPreferencesRepository.getColumns(this.getSelectedQueryName());
    }

    public void stopAllTheQueries() {
        for (QueryObserver queryObserver : this._queries.values()) {
            queryObserver.stop();
        }
    }

    public void stop() {
        this._queries.get(this.getSelectedQueryName()).stop();
    }

    public boolean isSelectedQueryRunning() {
        return this._queries.get(this.getSelectedQueryName()).isRunning();
    }

    private String getSelectedQueryName() {
        return this._queryTree.getSelection()[0].getText();
    }

    public boolean isSelectedQueryReady() {
        TreeItem selectedTreeItem = this._queryTree.getSelection()[0];
        return selectedTreeItem.getItemCount() > 0 && !this._queries.get(selectedTreeItem.getText()).isRunning();
    }

    public Map<String, Color> getLoggerColors() {
        return this._logger.getColors();
    }

    public Tree getQueryTree() {
        return this._queryTree;
    }

    public void expandAllQueries(boolean expand) {
        for (TreeItem item : this._queryTree.getItems()) {
            item.setExpanded(expand);
        }
    }
}

