/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.editor;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.glsof.common.io.XMLRepository;
import net.sourceforge.glsof.queries.editor.PreferencesUIDialog;
import net.sourceforge.glsof.queries.editor.QueriesLsofParametersMaker;
import net.sourceforge.glsof.queries.editor.XMLQueryPreferencesCreator;
import net.sourceforge.glsof.queries.model.FileDescriptorPreferences;
import net.sourceforge.glsof.queries.model.IDPreferences;
import net.sourceforge.glsof.queries.model.OtherPreferences;
import net.sourceforge.glsof.queries.model.Preferences;
import net.sourceforge.glsof.queries.model.QueryPreferences;

public class QueryPreferencesRepository
extends XMLRepository {
    private static final String QUERY_PREFERENCES_BEAN_NAME = "queryPreferences";
    private QueriesLsofParametersMaker _pMaker = new QueriesLsofParametersMaker();

    public QueryPreferencesRepository(File baseDir) {
        super(baseDir);
    }

    public String getLsofParameters(String queryName) {
        QueryPreferences queryPreferences = this.read(queryName);
        return this._pMaker.getLsofParameters(queryPreferences.getPreferences(), queryPreferences.getOtherPreferences());
    }

    public List<Boolean> getColumns(String queryName) {
        return this.read(queryName).getColumns();
    }

    public void setColumns(List<Boolean> views, String queryName) {
        QueryPreferences prefs = this.read(queryName);
        prefs.setColumns(views);
        this.save(prefs);
    }

    QueryPreferences read(String queryName) {
        return (QueryPreferences)this.read(QueryPreferences.class, QUERY_PREFERENCES_BEAN_NAME, queryName, new XMLQueryPreferencesCreator());
    }

    void save(QueryPreferences queryPreferences) {
        this.write(queryPreferences, QUERY_PREFERENCES_BEAN_NAME, queryPreferences.getName());
    }

    public boolean rename(String oldQueryName, String newQueryName) {
        if (this.fileExists(newQueryName)) {
            return false;
        }
        QueryPreferences prefs = this.read(oldQueryName);
        prefs.setName(newQueryName);
        this.save(prefs);
        this.remove(oldQueryName);
        return true;
    }

    public List<String> findAllQueryNames() {
        String[] fileNames = this._baseDir.list();
        LinkedList<String> queryNames = new LinkedList<String>();
        if (fileNames == null) {
            return queryNames;
        }
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".xml")) continue;
            queryNames.add(fileName.substring(0, fileName.indexOf(".xml")));
        }
        return queryNames;
    }

    public boolean remove(String queryName) {
        return new File(this._baseDir, this.getFileName(queryName)).delete();
    }

    public boolean create(String queryName) {
        return this.openDialog(this.createQueryPreferences(queryName));
    }

    public QueryPreferences createQueryPreferences(String queryName) {
        QueryPreferences queryPreferences = new QueryPreferences();
        queryPreferences.setName(queryName);
        for (int i = 0; i < 11; ++i) {
            queryPreferences.addColumn(true);
        }
        queryPreferences.addPreference(this.createPreferences(IDPreferences.PROCESS_ID));
        queryPreferences.addPreference(this.createPreferences(IDPreferences.NETWORK_ID));
        queryPreferences.addPreference(this.createPreferences(IDPreferences.LOGIN_ID));
        queryPreferences.addPreference(this.createPreferences(IDPreferences.FILE_DESCRIPTOR_ID));
        queryPreferences.addPreference(this.createPreferences(IDPreferences.DIRECTORY_ID));
        queryPreferences.addPreference(this.createPreferences("PID"));
        queryPreferences.addPreference(this.createPreferences("PGID"));
        queryPreferences.addPreference(this.createPreferences(IDPreferences.GENERIC_ID));
        queryPreferences.setOtherPreferences(new OtherPreferences());
        return queryPreferences;
    }

    private Preferences createPreferences(String id) {
        Preferences p = id.equals(IDPreferences.FILE_DESCRIPTOR_ID) ? new FileDescriptorPreferences() : new Preferences();
        p.setId(id);
        return p;
    }

    public boolean edit(String queryName) {
        return this.openDialog(this.read(queryName));
    }

    private boolean openDialog(QueryPreferences queryPreferences) {
        PreferencesUIDialog dialog = new PreferencesUIDialog(queryPreferences);
        if (dialog.isClickedOk()) {
            this.save(queryPreferences);
            return true;
        }
        return false;
    }
}

