/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.editor;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.WidgetsUtils;
import net.sourceforge.glsof.queries.dialogs.NumericCheckInputDialog;
import net.sourceforge.glsof.queries.dialogs.TextCheckInputDialog;
import net.sourceforge.glsof.queries.dialogs.TextInputDialog;
import net.sourceforge.glsof.queries.dialogs.TextsCombosInputDialog;
import net.sourceforge.glsof.queries.editor.AbstractPreferencesUIPage;
import net.sourceforge.glsof.queries.editor.DefaultPreferencesUIPage;
import net.sourceforge.glsof.queries.editor.FileDescriptorPreferencesUIPage;
import net.sourceforge.glsof.queries.editor.OtherPreferencesUIPage;
import net.sourceforge.glsof.queries.editor.PreferencesUIPage;
import net.sourceforge.glsof.queries.model.IDPreferences;
import net.sourceforge.glsof.queries.model.Preferences;
import net.sourceforge.glsof.queries.model.QueryPreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

class PreferencesUIDialog {
    private static final String[] IDS = new String[]{IDPreferences.PROCESS_ID, IDPreferences.NETWORK_ID, IDPreferences.LOGIN_ID, IDPreferences.FILE_DESCRIPTOR_ID, IDPreferences.DIRECTORY_ID, "PID", "PGID", IDPreferences.GENERIC_ID, IDPreferences.OTHER_ID};
    private TabFolder _tabFolder;
    private boolean _clickedOk = false;

    public PreferencesUIDialog(QueryPreferences queryPreferences) {
        Shell dialog = this.initDialog();
        this.createButtons(dialog, this.initPreferencesPages(queryPreferences, dialog));
        this.openDialog(dialog);
    }

    private Shell initDialog() {
        Shell dialog = new Shell(Display.getCurrent().getActiveShell(), 67680);
        dialog.setText(Messages.NLS("Edit_query"));
        dialog.setSize(600, 600);
        dialog.setLayout(new GridLayout(1, true));
        return dialog;
    }

    private void createButtons(Shell dialog, Map<String, PreferencesUIPage> preferencesNodeMap) {
        Composite buttonBar = new Composite(dialog, 0);
        GridLayout buttonBarLayout = new GridLayout(2, true);
        buttonBar.setLayout(buttonBarLayout);
        GridData gridData = new GridData(136);
        buttonBar.setLayoutData(gridData);
        this.createCancelButton(dialog, buttonBar);
        this.createOkButton(dialog, buttonBar, preferencesNodeMap);
    }

    private void openDialog(Shell dialog) {
        dialog.open();
        Display display = Display.getCurrent();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private Map<String, PreferencesUIPage> initPreferencesPages(QueryPreferences queryPreferences, Shell dialog) {
        this._tabFolder = this.initTabFolder(dialog);
        Map<String, PreferencesUIPage> preferencesNodeMap = this.convertQueryPreferencesToMap(queryPreferences);
        for (String id : IDS) {
            TabItem tabItem = new TabItem(this._tabFolder, 0);
            tabItem.setText(id);
            tabItem.setControl(preferencesNodeMap.get(id).createContents(this._tabFolder));
        }
        return preferencesNodeMap;
    }

    private TabFolder initTabFolder(Shell dialog) {
        TabFolder tabFolder = new TabFolder(dialog, 0);
        GridData gridData = new GridData(1810);
        gridData.horizontalAlignment = 4;
        tabFolder.setLayoutData(gridData);
        return tabFolder;
    }

    private Map<String, PreferencesUIPage> convertQueryPreferencesToMap(QueryPreferences queryPreferences) {
        HashMap<String, PreferencesUIPage> preferenceNodeMap = new HashMap<String, PreferencesUIPage>();
        for (Preferences preferences : queryPreferences.getPreferences()) {
            preferenceNodeMap.put(preferences.getId(), this.createPreferencePage(preferences));
        }
        preferenceNodeMap.put(IDPreferences.OTHER_ID, new OtherPreferencesUIPage(queryPreferences.getOtherPreferences()));
        return preferenceNodeMap;
    }

    private PreferencesUIPage createPreferencePage(Preferences preferences) {
        return preferences.getId().equals(IDPreferences.FILE_DESCRIPTOR_ID) ? new FileDescriptorPreferencesUIPage(preferences, this.createInputDialog(preferences.getId())) : new DefaultPreferencesUIPage(preferences, this.createInputDialog(preferences.getId()));
    }

    private TextInputDialog createInputDialog(String id) {
        if (id.equals(IDPreferences.DIRECTORY_ID)) {
            return new TextCheckInputDialog(id, new String[]{Messages.NLS("Directory"), Messages.NLS("Full_descent_tree")});
        }
        if (id.equals(IDPreferences.FILE_DESCRIPTOR_ID)) {
            return new TextInputDialog(id, new String[]{Messages.NLS("File_descriptor")});
        }
        if (id.equals("PGID")) {
            return new NumericCheckInputDialog(id, new String[]{"PGID", Messages.NLS("Exclude")});
        }
        if (id.equals(IDPreferences.LOGIN_ID)) {
            return new TextCheckInputDialog(id, new String[]{Messages.NLS("ID_Login_name"), Messages.NLS("Exclude")});
        }
        if (id.equals(IDPreferences.NETWORK_ID)) {
            return new TextsCombosInputDialog(id, new String[]{Messages.NLS("Address"), Messages.NLS("Port"), "IPV", Messages.NLS("Protocol")});
        }
        if (id.equals(IDPreferences.GENERIC_ID)) {
            return new TextInputDialog(id, new String[]{Messages.NLS("Path")});
        }
        if (id.equals("PID")) {
            return new NumericCheckInputDialog(id, new String[]{"PID", Messages.NLS("Exclude")});
        }
        return new TextCheckInputDialog(id, new String[]{Messages.NLS("Process"), Messages.NLS("Exclude")});
    }

    private void createOkButton(final Shell dialog, Composite buttonBar, final Map<String, PreferencesUIPage> preferencesNodeMap) {
        Button ok = new Button(buttonBar, 8);
        ok.setText(Messages.NLS("Ok"));
        ok.setLayoutData(new GridData(4, 4, true, true));
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                for (int i = 0; i < IDS.length - 1; ++i) {
                    if (i == 1 || i == 6 || !((AbstractPreferencesUIPage)preferencesNodeMap.get(IDS[i])).isTableEnabledAndEmpty()) continue;
                    PreferencesUIDialog.this._tabFolder.setSelection(i);
                    WidgetsUtils.warningMessage(IDS[i] + ": " + Messages.NLS("it_s_not_possible_to_enable_an_empty_table")).open();
                    return;
                }
                PreferencesUIDialog.this._clickedOk = true;
                for (String id : IDS) {
                    ((PreferencesUIPage)preferencesNodeMap.get(id)).performOk();
                }
                dialog.close();
            }
        });
    }

    private void createCancelButton(final Shell dialog, Composite buttonBar) {
        Button cancel = new Button(buttonBar, 8);
        cancel.setText(Messages.NLS("Cancel"));
        cancel.setLayoutData(new GridData(4, 4, true, true));
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                dialog.close();
            }
        });
    }

    public boolean isClickedOk() {
        return this._clickedOk;
    }
}

