/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.glsof.common.io.XMLRepository;
import net.sourceforge.glsof.queries.queries.QueriesUIConf;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.ChainedBeanCreator;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class QueriesUIConfRepository
extends XMLRepository {
    private static final String QUERIES_UI_CONF_BEAN_NAME = "queriesUIConf";
    private static final String QUERIES_UI_CONF_FILE_NAME = "queries_ui_conf";

    public QueriesUIConfRepository(File baseDir) {
        super(baseDir);
        if (!new File(baseDir, "queries_ui_conf.xml").exists()) {
            this.createQueriesUIConf();
        }
    }

    private void createQueriesUIConf() {
        QueriesUIConf conf = new QueriesUIConf();
        conf.setWidth(800);
        conf.setHeight(600);
        conf.setPosX(0);
        conf.setPosY(0);
        conf.setQueriesTreeWidth(20);
        conf.setQueriesTablesWidth(80);
        conf.setQueriesHeight(750);
        conf.setLogHeight(250);
        conf.addLogStartColor(0);
        conf.addLogStartColor(255);
        conf.addLogStartColor(0);
        conf.addLogStopColor(255);
        conf.addLogStopColor(255);
        conf.addLogStopColor(0);
        conf.addLogErrColor(127);
        conf.addLogErrColor(127);
        conf.addLogErrColor(127);
        conf.setMenuItemLogs(true);
        conf.setMenuItemStatusBar(true);
        this.write(conf);
    }

    public void save(Point location, Point size, Map<String, Color> colors, int[] queries, int[] logger, boolean menuItemLogs, boolean menuItemStatusBar) {
        QueriesUIConf conf = new QueriesUIConf();
        conf.setWidth(size.x);
        conf.setHeight(size.y);
        conf.setPosX(location.x);
        conf.setPosY(location.y);
        conf.setQueriesTreeWidth(queries[0]);
        conf.setQueriesTablesWidth(queries[1]);
        conf.setQueriesHeight(logger[0]);
        conf.setLogHeight(logger[1]);
        conf.addLogStartColor(colors.get("start").getRed());
        conf.addLogStartColor(colors.get("start").getGreen());
        conf.addLogStartColor(colors.get("start").getBlue());
        conf.addLogStopColor(colors.get("stop").getRed());
        conf.addLogStopColor(colors.get("stop").getGreen());
        conf.addLogStopColor(colors.get("stop").getBlue());
        conf.addLogErrColor(colors.get("err").getRed());
        conf.addLogErrColor(colors.get("err").getGreen());
        conf.addLogErrColor(colors.get("err").getBlue());
        conf.setMenuItemLogs(menuItemLogs);
        conf.setMenuItemStatusBar(menuItemStatusBar);
        this.write(conf);
    }

    private void write(QueriesUIConf conf) {
        this.write(conf, QUERIES_UI_CONF_BEAN_NAME, QUERIES_UI_CONF_FILE_NAME);
    }

    public QueriesUIConf read() {
        return (QueriesUIConf)this.read(QueriesUIConf.class, QUERIES_UI_CONF_BEAN_NAME, QUERIES_UI_CONF_FILE_NAME, new ChainedBeanCreator(){

            @Override
            public Object create(ElementMapping mapping, ReadContext readContext, BeanCreationChain beanCreationChain) {
                if (mapping.getType().equals("int")) {
                    return new ArrayList();
                }
                return new QueriesUIConf();
            }
        });
    }
}

