/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.search;

import net.sourceforge.glsof.common.search.SearchInfo;
import net.sourceforge.glsof.common.search.SearchInterface;
import net.sourceforge.glsof.common.search.TextMatcherInfo;
import org.eclipse.swt.widgets.Table;

public class SearchWholeTable
extends SearchInfo
implements SearchInterface {
    private final TextMatcherInfo _textMatcherInfo;
    private final int _columns;

    public SearchWholeTable(TextMatcherInfo textMatcherInfo, int columns) {
        this._textMatcherInfo = textMatcherInfo;
        this._columns = columns;
    }

    public void init(String text, boolean caseSensitive) {
        if (this._textMatcherInfo.init(text, caseSensitive)) {
            this.reset();
        }
    }

    public void reset() {
        this.setLastSelectedRow(this.getRow());
        this.setRow(-1);
    }

    public void restoreReset() {
        this.setRow(this.getLastSelectedRow());
    }

    public void deselect() {
        int row;
        int n = row = this.getRow() == -1 ? this.getLastSelectedRow() : this.getRow();
        if (this.getTable() != null && row != -1) {
            this.getTable().getItem(row).setBackground(this.getColumn(), this.getColor());
        }
    }

    @Override
    public boolean hasFoundMatch(Table table, String text) {
        int[] startValues = this.startValues(this.getRow(), this.getColumn());
        for (int row = startValues[0]; row < table.getItemCount(); ++row) {
            if (this.matchInARow(table, text, row, startValues[1])) {
                return true;
            }
            startValues[1] = 0;
        }
        return false;
    }

    private int[] startValues(int row, int column) {
        if (row == -1) {
            return new int[]{0, 0};
        }
        if (column == this._columns - 1) {
            return new int[]{row + 1, 0};
        }
        return new int[]{row, column + 1};
    }

    private boolean matchInARow(Table table, String text, int row, int startColumn) {
        for (int column = startColumn; column < this._columns; ++column) {
            if (!this._textMatcherInfo.match(text, table.getItem(row).getText(column))) continue;
            this.deselect();
            this.setTable(table);
            this.setColor(table.getItem(row).getBackground());
            this.setRow(row);
            this.setColumn(column);
            table.getItem(row).setBackground(column, table.getShell().getDisplay().getSystemColor(5));
            table.setTopIndex(row);
            return true;
        }
        return false;
    }
}

