/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.search;

import net.sourceforge.glsof.common.search.SearchInfo;
import net.sourceforge.glsof.common.search.SearchInterface;
import net.sourceforge.glsof.common.search.TextMatcherInfo;
import org.eclipse.swt.widgets.Table;

public class SearchSingleColumn
extends SearchInfo
implements SearchInterface {
    private final TextMatcherInfo _textMatcherInfo;

    public SearchSingleColumn(TextMatcherInfo textMatcherInfo) {
        this._textMatcherInfo = textMatcherInfo;
    }

    public void init(String text, int selectedColumn, boolean caseSensitive) {
        if (this.getColumn() != selectedColumn && this._textMatcherInfo.init(text, caseSensitive)) {
            this.reset(selectedColumn);
        }
    }

    public void reset(int selectedColumn) {
        this.setRow(-1);
        this.setColumn(selectedColumn);
    }

    @Override
    public boolean hasFoundMatch(Table table, String text) {
        for (int row = this.getRow() + 1; row < table.getItemCount(); ++row) {
            if (!this._textMatcherInfo.match(text, table.getItem(row).getText(this.getColumn()))) continue;
            this.setRow(row);
            return true;
        }
        return false;
    }
}

