/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.io;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import net.sourceforge.glsof.common.io.AttributesMapper;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.io.read.BeanCreationList;
import org.apache.commons.betwixt.io.read.ChainedBeanCreator;
import org.xml.sax.SAXException;

public class XMLRepository {
    protected static final String FILE_EXTENSION = ".xml";
    protected File _baseDir;

    protected XMLRepository(File baseDir) {
        if (baseDir != null && !baseDir.exists()) {
            baseDir.mkdirs();
        }
        this._baseDir = baseDir;
    }

    protected Object read(Class beanClass, String beanName, String fileName, ChainedBeanCreator chainedBeanCreator) {
        Object bean = null;
        try {
            BeanReader beanReader = new BeanReader();
            beanReader.getXMLIntrospector().getConfiguration().setSimpleTypeMapper(new AttributesMapper());
            beanReader.getBindingConfiguration().setMapIDs(false);
            beanReader.getReadConfiguration().setBeanCreationChain(this.createChain(chainedBeanCreator));
            beanReader.registerBeanClass(beanName, beanClass);
            bean = beanReader.parse(new FileReader(new File(this._baseDir, this.getFileName(fileName))));
        }
        catch (IOException ioE) {
            ioE.printStackTrace();
        }
        catch (SAXException saxE) {
            saxE.printStackTrace();
        }
        catch (IntrospectionException iE) {
            iE.printStackTrace();
        }
        return bean;
    }

    private BeanCreationList createChain(ChainedBeanCreator chainedBeanCreator) {
        BeanCreationList chain = BeanCreationList.createStandardChain();
        ChainedBeanCreator beanCreator = chainedBeanCreator;
        chain.insertBeanCreator(1, beanCreator);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(Object bean, String beanName, String name) {
        String fileName = this._baseDir.getPath() + File.separator + this.getFileName(name);
        OutputStreamWriter fileWriter = null;
        try {
            StringBuffer xmlBuffer = this.toXMLString(bean, beanName);
            xmlBuffer.insert(0, "<?xml version='1.0' ?>\n");
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            fileWriter = new FileWriter(file);
            fileWriter.write(xmlBuffer.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (Exception e) {}
        }
    }

    private StringBuffer toXMLString(Object bean, String beanName) {
        StringWriter outWriter = new StringWriter();
        BeanWriter beanWriter = new BeanWriter(outWriter);
        XMLIntrospector introspector = new XMLIntrospector();
        introspector.getConfiguration().setSimpleTypeMapper(new AttributesMapper());
        beanWriter.setXMLIntrospector(introspector);
        BindingConfiguration binding = new BindingConfiguration();
        binding.setMapIDs(false);
        beanWriter.setBindingConfiguration(binding);
        beanWriter.enablePrettyPrint();
        try {
            beanWriter.write(beanName, bean);
        }
        catch (IOException ioE) {
            ioE.printStackTrace();
        }
        catch (SAXException saxE) {
            saxE.printStackTrace();
        }
        catch (IntrospectionException iE) {
            iE.printStackTrace();
        }
        return outWriter.getBuffer();
    }

    protected boolean fileExists(String filename) {
        return new File(this._baseDir, this.getFileName(filename)).exists();
    }

    protected String getFileName(String fileName) {
        return fileName + FILE_EXTENSION;
    }
}

