"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var platform = require("platform");
var CommonConfig_1 = require("../config/CommonConfig");
var UNKNOWN_PROPERTY = 'unknown';
var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["ANDROID"] = "OperatingSystem.ANDROID";
    OperatingSystem["IOS"] = "OperatingSystem.IOS";
    OperatingSystem["LINUX"] = "OperatingSystem.LINUX";
    OperatingSystem["MAC"] = "OperatingSystem.MAC";
    OperatingSystem["WINDOWS"] = "OperatingSystem.WINDOWS";
})(OperatingSystem || (OperatingSystem = {}));
exports.OperatingSystem = OperatingSystem;
var Runtime = (function () {
    function Runtime() {
    }
    Runtime.getPlatform = function () {
        return platform || {};
    };
    Runtime.getOSFamily = function () {
        var family = Runtime.getOS().family.toLowerCase();
        if (family.includes('windows')) {
            return OperatingSystem.WINDOWS;
        }
        if (family.includes('android')) {
            return OperatingSystem.ANDROID;
        }
        if (family.includes('ios')) {
            return OperatingSystem.IOS;
        }
        if (['os x', 'mac os'].includes(family)) {
            return OperatingSystem.MAC;
        }
        return OperatingSystem.LINUX;
    };
    Runtime.getBrowserName = function () {
        return (Runtime.getPlatform().name || UNKNOWN_PROPERTY).toLowerCase();
    };
    Runtime.getBrowserVersion = function () {
        var _a = (Runtime.getPlatform().version || UNKNOWN_PROPERTY).split('.'), majorVersion = _a[0], minorVersion = _a[1];
        return { major: parseInt(majorVersion, 10), minor: parseInt(minorVersion, 10) };
    };
    Runtime.getUserAgent = function () {
        return (Runtime.getPlatform().ua || UNKNOWN_PROPERTY).toLowerCase();
    };
    Runtime.isWebappSupportedBrowser = function () {
        if (Runtime.isFranz()) {
            return false;
        }
        return Object.entries(CommonConfig_1.WEBAPP_SUPPORTED_BROWSERS).some(function (_a) {
            var browser = _a[0], supportedVersion = _a[1];
            var isBrowserSupported = Runtime.getBrowserName() === browser;
            var currentVersion = Runtime.getBrowserVersion();
            var isSupportedMajorVersion = currentVersion.major >= supportedVersion.major;
            var isHigherMajorVersion = currentVersion.major > supportedVersion.major;
            var isSupportedMinorVersion = isHigherMajorVersion || currentVersion.minor >= supportedVersion.minor;
            return isBrowserSupported && isSupportedMajorVersion && isSupportedMinorVersion;
        });
    };
    Runtime.getOS = function () {
        return __assign({ architecture: UNKNOWN_PROPERTY, family: UNKNOWN_PROPERTY, version: UNKNOWN_PROPERTY }, platform.os);
    };
    Runtime.isChrome = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.CHROME;
    };
    Runtime.isEdge = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.MS_EDGE;
    };
    Runtime.isFirefox = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.FIREFOX;
    };
    Runtime.isInternetExplorer = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.IE;
    };
    Runtime.isOpera = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.OPERA;
    };
    Runtime.isSafari = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.SAFARI;
    };
    Runtime.isDesktopOS = function () {
        return Runtime.isMacOS() || Runtime.isWindows() || Runtime.isLinux();
    };
    Runtime.isElectron = function () {
        return Runtime.getBrowserName() === CommonConfig_1.BROWSER.ELECTRON;
    };
    Runtime.isDesktopApp = function () {
        return Runtime.isElectron() && Runtime.getUserAgent().includes('wire');
    };
    Runtime.isFranz = function () {
        return Runtime.isElectron() && Runtime.getUserAgent().includes('franz');
    };
    Runtime.isMacOS = function () {
        return Runtime.getOSFamily() === OperatingSystem.MAC;
    };
    Runtime.isWindows = function () {
        return Runtime.getOSFamily() === OperatingSystem.WINDOWS;
    };
    Runtime.isLinux = function () {
        return Runtime.getOSFamily() === OperatingSystem.LINUX;
    };
    Runtime.isMobileOS = function () {
        return Runtime.isAndroid() || Runtime.isIOS();
    };
    Runtime.isAndroid = function () {
        return Runtime.getOSFamily() === OperatingSystem.ANDROID;
    };
    Runtime.isIOS = function () {
        return Runtime.getOSFamily() === OperatingSystem.IOS;
    };
    return Runtime;
}());
exports.Runtime = Runtime;
//# sourceMappingURL=Runtime.js.map