"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var ansiRegex = require("ansi-regex");
var fs = require("fs-extra");
var logdown = require("logdown");
var moment = require("moment");
var path = require("path");
var LogFactory = (function () {
    function LogFactory() {
    }
    LogFactory.getColor = function () {
        LogFactory.COLOR_CODE.R = (LogFactory.COLOR_CODE.R + LogFactory.COLOR_STEP.R) % 256;
        LogFactory.COLOR_CODE.G = (LogFactory.COLOR_CODE.G + LogFactory.COLOR_STEP.G) % 256;
        LogFactory.COLOR_CODE.B = (LogFactory.COLOR_CODE.B + LogFactory.COLOR_STEP.B) % 256;
        var rHex = Number(LogFactory.COLOR_CODE.R)
            .toString(16)
            .padStart(2, '0');
        var gHex = LogFactory.COLOR_CODE.G.toString(16).padStart(2, '0');
        var bHex = LogFactory.COLOR_CODE.B.toString(16).padStart(2, '0');
        return "#" + rHex + gHex + bHex;
    };
    LogFactory.addTimestamp = function (logTransport) {
        if (this.namespace && ~logTransport.msg.indexOf(this.namespace)) {
            logTransport.args.unshift("[" + moment().format('YYYY-MM-DD HH:mm:ss') + "]");
        }
    };
    LogFactory.writeTransport = function (logTransport) {
        return __awaiter(this, void 0, void 0, function () {
            var time, logMessage;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        time = logTransport.args[0];
                        logMessage = time + " " + logTransport.msg;
                        if (!this.logFilePath) return [3, 2];
                        return [4, LogFactory.writeMessage(logMessage, this.logFilePath)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2];
                }
            });
        });
    };
    LogFactory.writeMessage = function (message, logFilePath) {
        return __awaiter(this, void 0, void 0, function () {
            var withoutColor;
            return __generator(this, function (_a) {
                withoutColor = message.replace(ansiRegex(), '');
                return [2, fs.outputFile(logFilePath, withoutColor + "\r\n", {
                        encoding: 'utf8',
                        flag: 'a',
                    })];
            });
        });
    };
    LogFactory.createLoggerName = function (fileName, namespace, separator) {
        if (typeof window === 'undefined') {
            fileName = path.basename(fileName, path.extname(fileName));
        }
        return [namespace, fileName].filter(Boolean).join(separator);
    };
    LogFactory.getLogger = function (name, options) {
        var defaults = {
            color: LogFactory.getColor(),
            forceEnable: false,
            logFilePath: '',
            namespace: typeof window === 'undefined' ? process.env.npm_package_name || '' : '',
            separator: '::',
        };
        var config = __assign({}, defaults, options);
        if (logdown.transports.length === 0) {
            logdown.transports.push(LogFactory.addTimestamp.bind({ namespace: config.namespace }));
            logdown.transports.push(LogFactory.writeTransport.bind({ logFilePath: config.logFilePath }));
        }
        var loggerName = this.createLoggerName(name, config.namespace, config.separator);
        var logger = logdown(loggerName, {
            logger: console,
            markdown: false,
            prefixColor: config.color,
        });
        if (config.forceEnable) {
            logger.state.isEnabled = true;
        }
        return logger;
    };
    LogFactory.logFilePath = undefined;
    LogFactory.namespace = undefined;
    LogFactory.COLOR_STEP = {
        B: 97,
        G: 79,
        R: 31,
    };
    LogFactory.COLOR_CODE = {
        B: 0,
        G: 0,
        R: 0,
    };
    return LogFactory;
}());
exports.LogFactory = LogFactory;
//# sourceMappingURL=LogFactory.js.map