"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var WebViewFocus = (function () {
    function WebViewFocus() {
    }
    WebViewFocus.current = 0;
    WebViewFocus.bindTracker = function (webviewEvent, contents) {
        if (contents.getType() === 'webview') {
            contents.on('focus-change', function (event, isFocus, guestInstanceId) {
                if (isFocus) {
                    WebViewFocus.current = guestInstanceId;
                }
            });
        }
    };
    WebViewFocus.getFocusedWebContents = function () {
        var e_1, _a;
        var webContentFound;
        try {
            for (var _b = __values(electron_1.webContents.getAllWebContents()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var webContent = _c.value;
                if (typeof webContent.viewInstanceId == 'number' &&
                    webContent.viewInstanceId === WebViewFocus.current) {
                    webContentFound = webContent;
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return webContentFound;
    };
    return WebViewFocus;
}());
exports.WebViewFocus = WebViewFocus;
//# sourceMappingURL=webViewFocus.js.map