"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var cp = require("child_process");
var fs = require("fs");
var path = require("path");
var config = require("./config");
var environment = require("./environment");
var getLogger_1 = require("./getLogger");
var lifecycle = require("./lifecycle");
electron_1.app.setAppUserModelId("com.squirrel.wire." + config.NAME.toLowerCase());
var logger = getLogger_1.getLogger('squirrel');
var appFolder = path.resolve(process.execPath, '..');
var rootFolder = path.resolve(appFolder, '..');
var updateDotExe = path.join(rootFolder, 'Update.exe');
var exeName = config.NAME + ".exe";
var linkName = config.NAME + ".lnk";
var windowsAppData = process.env.APPDATA || '';
logger.error('No Windows AppData directory found.');
var taskbarLink = path.resolve(windowsAppData, 'Microsoft/Internet Explorer/Quick Launch/User Pinned/TaskBar');
var shortcutLink = path.resolve(taskbarLink, linkName);
var SQUIRREL_EVENT = {
    CREATE_SHORTCUT: '--createShortcut',
    INSTALL: '--squirrel-install',
    OBSOLETE: '--squirrel-obsolete',
    REMOVE_SHORTCUT: '--removeShortcut',
    UNINSTALL: '--squirrel-uninstall',
    UPDATE: '--update',
    UPDATED: '--squirrel-updated',
};
var spawn = function (command, args, callback) {
    var error;
    var spawnedProcess;
    var stdout = '';
    try {
        spawnedProcess = cp.spawn(command, args);
    }
    catch (_error) {
        error = _error;
        return process.nextTick(function () { return (typeof callback === 'function' ? callback(error, stdout) : void 0); });
    }
    if (spawnedProcess.stdout) {
        spawnedProcess.stdout.on('data', function (data) { return (stdout += data); });
    }
    error = null;
    spawnedProcess.on('error', function (processError) { return (error != null ? error : (error = processError)); });
    spawnedProcess.on('close', function (code, signal) {
        if (code !== 0) {
            if (error == null) {
                error = new Error("Command failed: " + (signal != null ? signal : code));
            }
        }
        if (error != null) {
            if (error.code == null) {
                error.code = code;
            }
        }
        if (error != null) {
            if (error.stdout == null) {
                error.stdout = stdout;
            }
        }
        return typeof callback === 'function' ? callback(error, stdout) : void 0;
    });
};
var spawnUpdate = function (args, callback) {
    spawn(updateDotExe, args, callback);
};
var createStartShortcut = function (callback) {
    spawnUpdate([SQUIRREL_EVENT.CREATE_SHORTCUT, exeName, '-l=StartMenu'], callback);
};
var createDesktopShortcut = function (callback) {
    spawnUpdate([SQUIRREL_EVENT.CREATE_SHORTCUT, exeName, '-l=Desktop'], callback);
};
var removeShortcuts = function (callback) {
    spawnUpdate([SQUIRREL_EVENT.REMOVE_SHORTCUT, exeName, '-l=Desktop,Startup,StartMenu'], function () {
        return fs.unlink(shortcutLink, callback);
    });
};
var installUpdate = function () {
    spawnUpdate([SQUIRREL_EVENT.UPDATE, environment.app.UPDATE_URL_WIN]);
};
exports.installUpdate = installUpdate;
var scheduleUpdate = function () {
    setTimeout(installUpdate, config.UPDATE.DELAY);
    setInterval(installUpdate, config.UPDATE.INTERVAL);
};
var handleSquirrelEvent = function (isFirstInstance) {
    var _a = __read(process.argv, 2), squirrelEvent = _a[1];
    switch (squirrelEvent) {
        case SQUIRREL_EVENT.INSTALL: {
            createStartShortcut(function () {
                createDesktopShortcut(function () {
                    lifecycle.quit();
                });
            });
            return true;
        }
        case SQUIRREL_EVENT.UPDATED: {
            lifecycle.quit();
            return true;
        }
        case SQUIRREL_EVENT.UNINSTALL: {
            removeShortcuts(function () { return lifecycle.quit(); });
            return true;
        }
        case SQUIRREL_EVENT.OBSOLETE: {
            lifecycle.quit();
            return true;
        }
    }
    if (!isFirstInstance) {
        return lifecycle.quit();
    }
    scheduleUpdate();
};
exports.handleSquirrelEvent = handleSquirrelEvent;
//# sourceMappingURL=squirrel.js.map