"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var pkg = require('../../package.json');
var BACKEND_ORIGINS = ['https://staging-nginz-https.zinfra.io', 'https://prod-nginz-https.wire.com'];
exports.BACKEND_ORIGINS = BACKEND_ORIGINS;
var EMBED_DOMAINS = [
    {
        allowedExternalLinks: ['www.youtube.com'],
        hostname: ['www.youtube-nocookie.com'],
        name: 'YouTube',
    },
    {
        allowedExternalLinks: ['vimeo.com', 'player.vimeo.com'],
        hostname: ['player.vimeo.com'],
        name: 'Vimeo',
    },
    {
        allowedExternalLinks: ['soundcloud.com'],
        hostname: ['w.soundcloud.com'],
        name: 'SoundCloud',
    },
    {
        allowedExternalLinks: ['www.spotify.com', 'developer.spotify.com'],
        hostname: ['open.spotify.com', 'embed.spotify.com'],
        name: 'Spotify',
    },
];
exports.EMBED_DOMAINS = EMBED_DOMAINS;
var LOG_FILE_NAME = 'console.log';
exports.LOG_FILE_NAME = LOG_FILE_NAME;
var MAXIMUM_ACCOUNTS = pkg.maximumAccounts || 3;
exports.MAXIMUM_ACCOUNTS = MAXIMUM_ACCOUNTS;
var NAME = pkg.productName || 'Wire';
exports.NAME = NAME;
var RAYGUN_API_KEY = '';
exports.RAYGUN_API_KEY = RAYGUN_API_KEY;
var UPDATE = {
    DELAY: 5 * 60 * 1000,
    INTERVAL: 24 * 60 * 60 * 1000,
};
exports.UPDATE = UPDATE;
var USER_AGENT = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36';
exports.USER_AGENT = USER_AGENT;
var VERSION = pkg.version;
exports.VERSION = VERSION;
var WINDOW = {
    ABOUT: {
        HEIGHT: 256,
        WIDTH: 304,
    },
    AUTH: {
        HEIGHT: 576,
        WIDTH: 400,
    },
    MAIN: {
        DEFAULT_HEIGHT: 768,
        DEFAULT_WIDTH: 1024,
        MIN_HEIGHT: 512,
        MIN_WIDTH: 760,
    },
};
exports.WINDOW = WINDOW;
//# sourceMappingURL=config.js.map