# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.TriUtils is the python interface to the Trilinos utilities
package TriUtils:

    http://trilinos.sandia.gov/packages/triutils

The purpose of TriUtils is to provide some utilities typically needed
when testing Trilinos software.

TriUtils provides the following user-level classes:

    * CrsMatrixGallery  - Provide example CrsMatrix objects
    * VbrMatrixGallery  - Provide example VbrMatrix objects

and function:

    * ReadHB            - Obtain a problem from an HB file

For an examples of usage, please consult the following script in the
example subdirectory of the PyTrilinos package:

    * exIFPACK.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_TriUtils')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_TriUtils')
    _TriUtils = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_TriUtils', [dirname(__file__)])
        except ImportError:
            import _TriUtils
            return _TriUtils
        try:
            _mod = imp.load_module('_TriUtils', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _TriUtils = swig_import_helper()
    del swig_import_helper
else:
    import _TriUtils
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info

def TriUtils_Version(*args):
    """
    TriUtils_Version() -> std::string

    std::string
    Triutils_Version() 
    """
    return _TriUtils.TriUtils_Version(*args)

__version__ = TriUtils_Version().split()[3]


def Trilinos_Util_ReadHb2Epetra_internal(*args):
    """
    Trilinos_Util_ReadHb2Epetra_internal(char const * data_file, Comm comm, bool FakeLongLong)

    void
    Trilinos_Util_ReadHb2Epetra_internal(const char *data_file, const
    Epetra_Comm &comm, Epetra_Map *&map, Epetra_CrsMatrix *&A,
    Epetra_Vector *&x, Epetra_Vector *&b, Epetra_Vector *&xexact, bool
    FakeLongLong) 
    """
    return _TriUtils.Trilinos_Util_ReadHb2Epetra_internal(*args)

def ReadHB(*args):
    """
    ReadHB(char const * data_file, Comm comm)

    void
    Trilinos_Util_ReadHb2Epetra(const char *data_file, const Epetra_Comm
    &comm, Epetra_Map *&map, Epetra_CrsMatrix *&A, Epetra_Vector *&x,
    Epetra_Vector *&b, Epetra_Vector *&xexact) 
    """
    return _TriUtils.ReadHB(*args)

def ReadHB64(*args):
    """
    ReadHB64(char const * data_file, Comm comm)

    void
    Trilinos_Util_ReadHb2Epetra64(const char *data_file, const Epetra_Comm
    &comm, Epetra_Map *&map, Epetra_CrsMatrix *&A, Epetra_Vector *&x,
    Epetra_Vector *&b, Epetra_Vector *&xexact) 
    """
    return _TriUtils.ReadHB64(*args)

def ReadHpc64(*args):
    """
    ReadHpc64(char const * data_file, Comm comm)

    void
    Trilinos_Util_ReadHpc2Epetra(const char *data_file, const Epetra_Comm
    &comm, Epetra_Map *&map, Epetra_CrsMatrix *&A, Epetra_Vector *&x,
    Epetra_Vector *&b, Epetra_Vector *&xexact) 
    """
    return _TriUtils.ReadHpc64(*args)

def Trilinos_Util_ReadHpc2Epetra64(*args):
    """
    Trilinos_Util_ReadHpc2Epetra64(char const * data_file, Comm comm)

    void
    Trilinos_Util_ReadHpc2Epetra64(const char *data_file, const
    Epetra_Comm &comm, Epetra_Map *&map, Epetra_CrsMatrix *&A,
    Epetra_Vector *&x, Epetra_Vector *&b, Epetra_Vector *&xexact) 
    """
    return _TriUtils.Trilinos_Util_ReadHpc2Epetra64(*args)

def ReadHBVbr(*args):
    """
    ReadHBVbr(char const * data_file, char const * partitioning, Comm comm)

    void
    Trilinos_Util_ReadHb2EpetraVbr(const char *data_file, const char
    *partitioning, const Epetra_Comm &comm, Epetra_BlockMap *&map,
    Epetra_VbrMatrix *&A, Epetra_Vector *&x, Epetra_Vector *&b,
    Epetra_Vector *&xexact) 
    """
    return _TriUtils.ReadHBVbr(*args)
MAXNRHS = _TriUtils.MAXNRHS

def GenerateCrsProblem(*args):
    """
    GenerateCrsProblem(int nx, int ny, int npoints, int * xoff, int * yoff, Comm comm, int indexBase=0)
    GenerateCrsProblem(int nx, int ny, int npoints, int * xoff, int * yoff, int nrhs, Comm comm, int indexBase=0)

    void
    Trilinos_Util_GenerateCrsProblem(int nx, int ny, int npoints, int
    *xoff, int *yoff, int nrhs, const Epetra_Comm &comm, Epetra_Map *&map,
    Epetra_CrsMatrix *&A, Epetra_MultiVector *&x, Epetra_MultiVector *&b,
    Epetra_MultiVector *&xexact, int indexBase) 
    """
    return _TriUtils.GenerateCrsProblem(*args)

def GenerateCrsProblem64(*args):
    """
    GenerateCrsProblem64(int nx, int ny, int npoints, int * xoff, int * yoff, Comm comm, long long indexBase=0)
    GenerateCrsProblem64(int nx, int ny, int npoints, int * xoff, int * yoff, int nrhs, Comm comm, long long indexBase=0)

    void
    Trilinos_Util_GenerateCrsProblem64(int nx, int ny, int npoints, int
    *xoff, int *yoff, int nrhs, const Epetra_Comm &comm, Epetra_Map *&map,
    Epetra_CrsMatrix *&A, Epetra_MultiVector *&x, Epetra_MultiVector *&b,
    Epetra_MultiVector *&xexact, long long indexBase) 
    """
    return _TriUtils.GenerateCrsProblem64(*args)

def GenerateVbrProblem(*args):
    """
    GenerateVbrProblem(int nx, int ny, int npoints, int * xoff, int * yoff, int nsizes, int * sizes, Comm comm)
    GenerateVbrProblem(int nx, int ny, int npoints, int * xoff, int * yoff, int nsizes, int * sizes, int nrhs, Comm comm)

    void
    Trilinos_Util_GenerateVbrProblem(int nx, int ny, int npoints, int
    *xoff, int *yoff, int nsizes, int *sizes, int nrhs, const Epetra_Comm
    &comm, Epetra_BlockMap *&map, Epetra_VbrMatrix *&A, Epetra_MultiVector
    *&x, Epetra_MultiVector *&b, Epetra_MultiVector *&xexact) 
    """
    return _TriUtils.GenerateVbrProblem(*args)

def ReadTriples(*args):
    """
    ReadTriples(char const * data_file, bool symmetric, Comm comm, bool NonUniformMap=False, bool TimDavisHeader=False, bool ZeroBased=False) -> int

    int
    Trilinos_Util_ReadTriples2Epetra(const char *data_file, bool
    symmetric, const Epetra_Comm &comm, Epetra_Map *&map, Epetra_CrsMatrix
    *&A, Epetra_Vector *&x, Epetra_Vector *&b, Epetra_Vector *&xexact,
    bool NonUniformMap=false, bool TimDavisHeader=false, bool
    ZeroBased=false) 
    """
    return _TriUtils.ReadTriples(*args)

def ReadTriples64(*args):
    """
    ReadTriples64(char const * data_file, bool symmetric, Comm comm, bool NonUniformMap=False, bool TimDavisHeader=False, bool ZeroBased=False) -> int

    int
    Trilinos_Util_ReadTriples2Epetra64(const char *data_file, bool
    symmetric, const Epetra_Comm &comm, Epetra_Map *&map, Epetra_CrsMatrix
    *&A, Epetra_Vector *&x, Epetra_Vector *&b, Epetra_Vector *&xexact,
    bool NonUniformMap=false, bool TimDavisHeader=false, bool
    ZeroBased=false) 
    """
    return _TriUtils.ReadTriples64(*args)
class CrsMatrixGallery(_object):
    """Proxy of C++ Trilinos_Util::CrsMatrixGallery class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsMatrixGallery, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CrsMatrixGallery, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Trilinos_Util::CrsMatrixGallery self, std::string const name, Comm comm, bool UseLongLong=False) -> CrsMatrixGallery
        __init__(Trilinos_Util::CrsMatrixGallery self, std::string const name, Map map) -> CrsMatrixGallery

        Trilinos_Util::CrsMatrixGallery::CrsMatrixGallery(const std::string
        name, const Epetra_Map &map)

        Creates an Triutils_Gallery object using a given map.

        Create a Triutils_Gallery object using an Epetra_Map. Problem size
        must match the elements in map.

        Parameters:
        -----------

        In:  name - definition of the problem to be created.

        In:  map - Epetra_Map 
        """
        this = _TriUtils.new_CrsMatrixGallery(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _TriUtils.delete_CrsMatrixGallery

    def Set(self, *args):
        """
        Set(CrsMatrixGallery self, std::string const parameter, int const value) -> int
        Set(CrsMatrixGallery self, std::string const parameter, std::string const value) -> int
        Set(CrsMatrixGallery self, std::string const parameter, double const value) -> int
        Set(CrsMatrixGallery self, std::string const parameter, Vector value) -> int
        Set(CrsMatrixGallery self, Trilinos_Util::CommandLineParser & CLP) -> int

        int
        Trilinos_Util::CrsMatrixGallery::Set(Trilinos_Util::CommandLineParser
        &CLP)

        Sets gallery options using values passed from the shell. 
        """
        return _TriUtils.CrsMatrixGallery_Set(self, *args)


    def GetMatrix(self, *args):
        """
        GetMatrix(CrsMatrixGallery self) -> CrsMatrix

        Epetra_CrsMatrix * Trilinos_Util::CrsMatrixGallery::GetMatrix()

        Returns a pointer to the CrsMatrix. 
        """
        return _TriUtils.CrsMatrixGallery_GetMatrix(self, *args)


    def GetMatrixRef(self, *args):
        """
        GetMatrixRef(CrsMatrixGallery self) -> CrsMatrix

        Epetra_CrsMatrix & Trilinos_Util::CrsMatrixGallery::GetMatrixRef() 
        """
        return _TriUtils.CrsMatrixGallery_GetMatrixRef(self, *args)


    def GetExactSolution(self, *args):
        """
        GetExactSolution(CrsMatrixGallery self) -> MultiVector

        Epetra_MultiVector
        * Trilinos_Util::CrsMatrixGallery::GetExactSolution()

        Returns a pointer to the exact solution.

        Returns a pointer to the exact solution.

        Some choices are available to define the exact solution, using
        Set("exact solution", value). value can be: constant: the exact
        solution vector is made up of 1's.

        random: a random solution vector

        linear: value at node i is defined as alpha*i. The double value alpha
        can be set via Set("alpha",DoubleVal). 
        """
        return _TriUtils.CrsMatrixGallery_GetExactSolution(self, *args)


    def GetStartingSolution(self, *args):
        """
        GetStartingSolution(CrsMatrixGallery self) -> MultiVector

        Epetra_MultiVector *
        Trilinos_Util::CrsMatrixGallery::GetStartingSolution()

        Returns a pointer to the starting solution (typically, for HB
        problems).

        Returns a pointer to the starting solution. This is typically used
        while reading a HB problem. However, the user can set a starting
        solution using Set("starting solution", "value"). Value can be
        zero

        random 
        """
        return _TriUtils.CrsMatrixGallery_GetStartingSolution(self, *args)


    def GetRHS(self, *args):
        """
        GetRHS(CrsMatrixGallery self) -> MultiVector

        Epetra_MultiVector * Trilinos_Util::CrsMatrixGallery::GetRHS()

        Returns a pointer to the rhs corresponding to the selected exact
        solution. 
        """
        return _TriUtils.CrsMatrixGallery_GetRHS(self, *args)


    def GetMap(self, *args):
        """
        GetMap(CrsMatrixGallery self) -> Map

        const
        Epetra_Map * Trilinos_Util::CrsMatrixGallery::GetMap()

        Returns a pointer the internally stored Map. 
        """
        return _TriUtils.CrsMatrixGallery_GetMap(self, *args)


    def GetMapRef(self, *args):
        """
        GetMapRef(CrsMatrixGallery self) -> Map

        const Epetra_Map & Trilinos_Util::CrsMatrixGallery::GetMapRef() 
        """
        return _TriUtils.CrsMatrixGallery_GetMapRef(self, *args)


    def GetLinearProblem(self, *args):
        """
        GetLinearProblem(CrsMatrixGallery self) -> Epetra_LinearProblem

        Epetra_LinearProblem *
        Trilinos_Util::CrsMatrixGallery::GetLinearProblem()

        Returns a pointer to Epetra_LinearProblem. 
        """
        return _TriUtils.CrsMatrixGallery_GetLinearProblem(self, *args)


    def ComputeResidual(self, *args):
        """
        ComputeResidual(CrsMatrixGallery self, double * residual)

        void
        Trilinos_Util::CrsMatrixGallery::ComputeResidual(double *residual)

        Computes the 2-norm of the residual. 
        """
        return _TriUtils.CrsMatrixGallery_ComputeResidual(self, *args)


    def ComputeDiffBetweenStartingAndExactSolutions(self, *args):
        """
        ComputeDiffBetweenStartingAndExactSolutions(CrsMatrixGallery self, double * residual)

        void
        Trilinos_Util::CrsMatrixGallery::ComputeDiffBetweenStartingAndExactSolutions(double
        *residual)

        Computes the 2-norm of the difference between the starting solution
        and the exact solution. 
        """
        return _TriUtils.CrsMatrixGallery_ComputeDiffBetweenStartingAndExactSolutions(self, *args)


    def PrintMatrixAndVectors(self, *args):
        """
        PrintMatrixAndVectors(CrsMatrixGallery self, std::ostream & os)
        PrintMatrixAndVectors(CrsMatrixGallery self)

        void
        Trilinos_Util::CrsMatrixGallery::PrintMatrixAndVectors() 
        """
        return _TriUtils.CrsMatrixGallery_PrintMatrixAndVectors(self, *args)


    def GetCartesianCoordinates(self, *args):
        """
        GetCartesianCoordinates(CrsMatrixGallery self, double *& x, double *& y, double *& z)

        void
        Trilinos_Util::CrsMatrixGallery::GetCartesianCoordinates(double *&x,
        double *&y, double *&z)

        Get pointers to double vectors containing coordinates of points. 
        """
        return _TriUtils.CrsMatrixGallery_GetCartesianCoordinates(self, *args)


    def WriteMatrix(self, *args):
        """
        WriteMatrix(CrsMatrixGallery self, std::string const & FileName, bool const UseSparse=True) -> int

        int Trilinos_Util::CrsMatrixGallery::WriteMatrix(const std::string
        &FileName, const bool UseSparse=true)

        Print matrix on file in MATLAB format. 
        """
        return _TriUtils.CrsMatrixGallery_WriteMatrix(self, *args)

CrsMatrixGallery_swigregister = _TriUtils.CrsMatrixGallery_swigregister
CrsMatrixGallery_swigregister(CrsMatrixGallery)

class VbrMatrixGallery(CrsMatrixGallery):
    """Proxy of C++ Trilinos_Util::VbrMatrixGallery class."""

    __swig_setmethods__ = {}
    for _s in [CrsMatrixGallery]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, VbrMatrixGallery, name, value)
    __swig_getmethods__ = {}
    for _s in [CrsMatrixGallery]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, VbrMatrixGallery, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Trilinos_Util::VbrMatrixGallery self, std::string const name, Map map) -> VbrMatrixGallery
        __init__(Trilinos_Util::VbrMatrixGallery self, std::string const name, Comm Comm, bool UseLongLong=False) -> VbrMatrixGallery

        Trilinos_Util::VbrMatrixGallery::VbrMatrixGallery(const std::string
        name, const Epetra_Comm &Comm, bool UseLongLong=false) 
        """
        this = _TriUtils.new_VbrMatrixGallery(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _TriUtils.delete_VbrMatrixGallery

    def GetBlockMap(self, *args):
        """
        GetBlockMap(VbrMatrixGallery self) -> BlockMap

        const Epetra_BlockMap * Trilinos_Util::VbrMatrixGallery::GetBlockMap()

        Returns a pointer the internally stored BlockMap. 
        """
        return _TriUtils.VbrMatrixGallery_GetBlockMap(self, *args)


    def GetBlockMapRef(self, *args):
        """
        GetBlockMapRef(VbrMatrixGallery self) -> BlockMap

        const Epetra_BlockMap &
        Trilinos_Util::VbrMatrixGallery::GetBlockMapRef() 
        """
        return _TriUtils.VbrMatrixGallery_GetBlockMapRef(self, *args)


    def GetVbrMatrix(self, *args):
        """
        GetVbrMatrix(VbrMatrixGallery self, int const NumPDEEqns) -> VbrMatrix
        GetVbrMatrix(VbrMatrixGallery self) -> VbrMatrix

        Epetra_VbrMatrix * Trilinos_Util::VbrMatrixGallery::GetVbrMatrix()

        Returns a VbrMatrix, starting from the CsrMatrix. 
        """
        return _TriUtils.VbrMatrixGallery_GetVbrMatrix(self, *args)


    def GetVbrMatrixRef(self, *args):
        """
        GetVbrMatrixRef(VbrMatrixGallery self) -> VbrMatrix

        Epetra_VbrMatrix &
        Trilinos_Util::VbrMatrixGallery::GetVbrMatrixRef() 
        """
        return _TriUtils.VbrMatrixGallery_GetVbrMatrixRef(self, *args)


    def GetVbrRHS(self, *args):
        """
        GetVbrRHS(VbrMatrixGallery self) -> MultiVector

        Epetra_MultiVector * Trilinos_Util::VbrMatrixGallery::GetVbrRHS()

        Returns a pointer to the RHS for the selected Vbr exact solution.

        Returns a pointer to the RHS corresponding to the selected exact
        solution to the linear systems defined by the Epetra_VbrMatrix. 
        """
        return _TriUtils.VbrMatrixGallery_GetVbrRHS(self, *args)


    def GetVbrExactSolution(self, *args):
        """
        GetVbrExactSolution(VbrMatrixGallery self) -> MultiVector

        Epetra_MultiVector *
        Trilinos_Util::VbrMatrixGallery::GetVbrExactSolution()

        Returns a pointer to the selected Vbr exact solution. 
        """
        return _TriUtils.VbrMatrixGallery_GetVbrExactSolution(self, *args)


    def GetVbrStartingSolution(self, *args):
        """
        GetVbrStartingSolution(VbrMatrixGallery self) -> MultiVector

        Epetra_MultiVector *
        Trilinos_Util::VbrMatrixGallery::GetVbrStartingSolution()

        Returns a pointer to the starting solution for Vbr problems. 
        """
        return _TriUtils.VbrMatrixGallery_GetVbrStartingSolution(self, *args)


    def CreateVbrMatrix(self, *args):
        """
        CreateVbrMatrix(VbrMatrixGallery self)

        void
        Trilinos_Util::VbrMatrixGallery::CreateVbrMatrix(void) 
        """
        return _TriUtils.VbrMatrixGallery_CreateVbrMatrix(self, *args)


    def GetVbrLinearProblem(self, *args):
        """
        GetVbrLinearProblem(VbrMatrixGallery self) -> Epetra_LinearProblem

        Epetra_LinearProblem *
        Trilinos_Util::VbrMatrixGallery::GetVbrLinearProblem()

        Returns a pointer to Epetra_LinearProblem for VBR. 
        """
        return _TriUtils.VbrMatrixGallery_GetVbrLinearProblem(self, *args)


    def ComputeResidualVbr(self, *args):
        """
        ComputeResidualVbr(VbrMatrixGallery self, double * residual)

        void
        Trilinos_Util::VbrMatrixGallery::ComputeResidualVbr(double *residual)

        Computes the 2-norm of the residual for the VBR problem. 
        """
        return _TriUtils.VbrMatrixGallery_ComputeResidualVbr(self, *args)


    def ComputeDiffBetweenStartingAndExactSolutionsVbr(self, *args):
        """
        ComputeDiffBetweenStartingAndExactSolutionsVbr(VbrMatrixGallery self, double * residual)

        void
        Trilinos_Util::VbrMatrixGallery::ComputeDiffBetweenStartingAndExactSolutionsVbr(double
        *residual)

        Computes the 2-norm of the difference between the starting solution
        and the exact solution for the VBR problem. 
        """
        return _TriUtils.VbrMatrixGallery_ComputeDiffBetweenStartingAndExactSolutionsVbr(self, *args)


    def PrintVbrMatrixAndVectors(self, *args):
        """
        PrintVbrMatrixAndVectors(VbrMatrixGallery self, std::ostream & os)
        PrintVbrMatrixAndVectors(VbrMatrixGallery self)

        void
        Trilinos_Util::VbrMatrixGallery::PrintVbrMatrixAndVectors() 
        """
        return _TriUtils.VbrMatrixGallery_PrintVbrMatrixAndVectors(self, *args)

VbrMatrixGallery_swigregister = _TriUtils.VbrMatrixGallery_swigregister
VbrMatrixGallery_swigregister(VbrMatrixGallery)

# This file is compatible with both classic and new-style classes.


