# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Tpetra is the python interface to the Trilinos linear
algebra services package Tpetra:

    http://trilinos.sandia.gov/packages/tpetra

The purpose of Tpetra is to provide fundamental linear algebra
services to the rest of Trilinos.  These services include parallel
decomposition and communication, vectors and multivectors, graphs,
operators, and dense and sparse matrices.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Tpetra')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Tpetra')
    _Tpetra = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Tpetra', [dirname(__file__)])
        except ImportError:
            import _Tpetra
            return _Tpetra
        try:
            _mod = imp.load_module('_Tpetra', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Tpetra = swig_import_helper()
    del swig_import_helper
else:
    import _Tpetra
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_SwigPyIterator

    def value(self, *args):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator_value(self, *args)


    def incr(self, *args):
        """incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_incr(self, *args)


    def decr(self, *args):
        """decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_decr(self, *args)


    def distance(self, *args):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Tpetra.SwigPyIterator_distance(self, *args)


    def equal(self, *args):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Tpetra.SwigPyIterator_equal(self, *args)


    def copy(self, *args):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_copy(self, *args)


    def next(self, *args):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator_next(self, *args)


    def __next__(self, *args):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator___next__(self, *args)


    def previous(self, *args):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator_previous(self, *args)


    def advance(self, *args):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_advance(self, *args)


    def __eq__(self, *args):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Tpetra.SwigPyIterator___eq__(self, *args)


    def __ne__(self, *args):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Tpetra.SwigPyIterator___ne__(self, *args)


    def __iadd__(self, *args):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator___iadd__(self, *args)


    def __isub__(self, *args):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator___isub__(self, *args)


    def __add__(self, *args):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator___add__(self, *args)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Tpetra.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Tpetra.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


import numpy

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info

def class_array_inplace_op(self, op_str, other):
  in_op = getattr(self.array, "__i"+op_str+"__")
  in_op(other.array)
  return self

def class_array_math_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
# Get the equivalent in-place operator for the result
  in_op = getattr(result.array, "__i"+op_str+"__")
  try:
    in_op(other.array)
  except AttributeError:
    in_op(other)
  return result

def class_array_rmath_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
  indices = (slice(None),) * len(self.array.shape)
  result.array[indices] = other
  in_op = getattr(result.array, "__i"+op_str+"__")
  in_op(self.array)
  return result

def class_array_add_math_ops(cls, op_str):
  setattr(cls,
          "__i"+op_str+"__",
          lambda self, other: class_array_inplace_op(self, op_str, other))
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_math_op(self, op_str, other))
  setattr(cls,
          "__r"+op_str+"__",
          lambda self, other: class_array_rmath_op(self, op_str, other))

def class_array_add_math(cls):
  class_array_add_math_ops(cls, "add")
  class_array_add_math_ops(cls, "sub")
  class_array_add_math_ops(cls, "mul")
  class_array_add_math_ops(cls, "add")

def class_array_comp_op(self, op_str, other):
  comp_op = getattr(self.array, "__"+op_str+"__")
  try:
    return comp_op(other.array)
  except AttributeError:
    return comp_op(other)

def class_array_add_comp_op(cls, op_str):
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_comp_op(self, op_str, other))

def class_array_add_comp(cls):
  class_array_add_comp_op(cls, "lt")
  class_array_add_comp_op(cls, "le")
  class_array_add_comp_op(cls, "eq")
  class_array_add_comp_op(cls, "ne")
  class_array_add_comp_op(cls, "gt")
  class_array_add_comp_op(cls, "ge")


KOKKOS_ENABLE_CXX11_DISPATCH_LAMBDA = _Tpetra.KOKKOS_ENABLE_CXX11_DISPATCH_LAMBDA
KOKKOS_ENABLE_PRAGMA_UNROLL = _Tpetra.KOKKOS_ENABLE_PRAGMA_UNROLL
KOKKOS_ENABLE_PRAGMA_LOOPCOUNT = _Tpetra.KOKKOS_ENABLE_PRAGMA_LOOPCOUNT
KOKKOS_ENABLE_PRAGMA_VECTOR = _Tpetra.KOKKOS_ENABLE_PRAGMA_VECTOR
KOKKOS_ENABLE_PRAGMA_SIMD = _Tpetra.KOKKOS_ENABLE_PRAGMA_SIMD
KOKKOS_ALIGN_SIZE = _Tpetra.KOKKOS_ALIGN_SIZE
KOKKOS_ENABLE_ASM = _Tpetra.KOKKOS_ENABLE_ASM
TPETRA_THROWS_EFFICIENCY_WARNINGS = _Tpetra.TPETRA_THROWS_EFFICIENCY_WARNINGS
TPETRA_PRINTS_EFFICIENCY_WARNINGS = _Tpetra.TPETRA_PRINTS_EFFICIENCY_WARNINGS
TPETRA_THROWS_ABUSE_WARNINGS = _Tpetra.TPETRA_THROWS_ABUSE_WARNINGS
TPETRA_PRINTS_ABUSE_WARNINGS = _Tpetra.TPETRA_PRINTS_ABUSE_WARNINGS
LocallyReplicated = _Tpetra.LocallyReplicated
GloballyDistributed = _Tpetra.GloballyDistributed
AllIDsPresent = _Tpetra.AllIDsPresent
IDNotPresent = _Tpetra.IDNotPresent
StaticProfile = _Tpetra.StaticProfile
DynamicProfile = _Tpetra.DynamicProfile
DoOptimizeStorage = _Tpetra.DoOptimizeStorage
DoNotOptimizeStorage = _Tpetra.DoNotOptimizeStorage
COMPUTE_VIEW_CONSTRUCTOR = _Tpetra.COMPUTE_VIEW_CONSTRUCTOR
HOST_VIEW_CONSTRUCTOR = _Tpetra.HOST_VIEW_CONSTRUCTOR
Forward = _Tpetra.Forward
Backward = _Tpetra.Backward
Symmetric = _Tpetra.Symmetric
TPETRA_USE_KOKKOS_DISTOBJECT = _Tpetra.TPETRA_USE_KOKKOS_DISTOBJECT
ADD = _Tpetra.ADD
INSERT = _Tpetra.INSERT
REPLACE = _Tpetra.REPLACE
ABSMAX = _Tpetra.ABSMAX
ZERO = _Tpetra.ZERO

def setCombineModeParameter(*args):
    """setCombineModeParameter(ParameterList plist, std::string const & paramName)"""
    return _Tpetra.setCombineModeParameter(*args)

def version(*args):
    """version() -> std::string"""
    return _Tpetra.version(*args)

__version__ = version()

class Map_default(Teuchos.Describable):
    """


    A parallel distribution of indices over processes.

    Parameters:
    -----------

    LocalOrdinal:  The type of local indices. Currently, this must be int.
    (In Epetra, this is always just int.)

    GlobalOrdinal:  The type of global indices. This must be a built-in
    integer type. We allow either signed or unsigned types here, but
    prefer signed types. Also, we require that GlobalOrdinal be no smaller
    than LocalOrdinal, that is: If LocalOrdinal is int, good models of
    GlobalOrdinal are  int  (if the configure-time option
    Tpetra_INST_INT_INT is set)

    long  (if the configure-time option Tpetra_INST_INT_LONG is set)

    long long (if the configure-time option Tpetra_INST_INT_LONG_LONG is
    set)  If the default GlobalOrdinal is int, then the global number of
    rows or columns in the matrix may be no more than INT_MAX, which for
    typical 32-bit int is $2^{31} - 1$ (about two billion). If you want to
    solve larger problems, you must use a 64-bit integer type here.

    Node:  A class implementing on-node shared-memory parallel operations.
    The default Node type should suffice for most users. The actual
    default type depends on your Trilinos build options. This must be one
    of the following: Kokkos::Compat::KokkosCudaWrapperNode

    Kokkos::Compat::KokkosOpenMPWrapperNode

    Kokkos::Compat::KokkosThreadsWrapperNode

    Kokkos::Compat::KokkosSerialWrapperNode  All of the above are just
    typedefs for
    Kokkos::Compat::KokkosDeviceWrapperNode<ExecutionSpaceType,
    MemorySpaceType>, where ExecutionSpaceType is a Kokkos execution space
    type, and MemorySpaceType is a Kokkos memory space type. If you omit
    MemorySpaceType, Tpetra will use the execution space's default memory
    space.

    This class describes a distribution of data elements over one or more
    processes in a communicator. Each element has a global index (of type
    GlobalOrdinal) uniquely associated to it. Each global index in the Map
    is "owned" by one or more processes in the Map's communicator. The
    user gets to decide what an "element" means; examples include a row
    or column of a sparse matrix (as in CrsMatrix), or a row of one or
    more vectors (as in MultiVector). Prerequisites Before reading the
    rest of this documentation, it helps to know something about the
    following: The Kokkos shared-memory parallel programming model

    The Teuchos memory management classes, especially Teuchos::RCP,
    Teuchos::ArrayRCP, and Teuchos::ArrayView

    MPI (the Message Passing Interface for distributed-memory parallel
    programming)  You will not need to use MPI directly to use Map, but it
    helps to be familiar with the general idea of distributed storage of
    data over a communicator. Map conceptsLocal and global indices The
    distinction between local and global indices and types might confuse
    new Tpetra users. Global indices represent the elements of a
    distributed object (such as rows or columns of a CrsMatrix, or rows of
    a MultiVector) uniquely over the entire object, which may be
    distributed over multiple processes. Local indices are local to the
    process that owns them. If global index G is owned by process P, then
    there is a unique local index L on process P corresponding to G. If
    the local index L is valid on process P, then there is a unique global
    index G owned by P corresponding to the pair (L, P). However, multiple
    processes might own the same global index (an "overlapping Map"), so
    a global index G might correspond to multiple (L, P) pairs. In
    summary, local indices on a process correspond to object elements
    (e.g., sparse matrix rows or columns) owned by that process.

    Tpetra differs from Epetra in that local and global indices may have
    different types. In Epetra, local and global indices both have type
    int. In Tpetra, you get to pick the type of each. For example, you can
    use a 64-bit integer GlobalOrdinal type to solve problems with more
    than $2^{31}$ unknowns, but a 32-bit integer LocalOrdinal type to save
    bandwidth in sparse matrix-vector multiply. Contiguous or
    noncontiguous A contiguous Map divides an interval of global indices
    over the processes in its communicator, such that each process gets a
    contiguous interval of zero or more of those global indices, with the
    indices owned by a process p strictly greater than those owned by
    process q if $p > q$. Formally, we call a Map contiguous when all of
    the following hold: the set of global indices (over all processes)
    forms an interval,

    every global index in that interval is owned by exactly one process in
    the Map's communicator,

    the (ordered) list of global indices on each process p in the Map's
    communicator forms a contiguous interval, and

    if process p owns a global index $g_p$ and process q owns a global
    index $g_q$, and if $p > q$, then $g_p > g_q$.  Different processes
    may own different numbers of global indices. We call a Map uniform if
    it is contiguous, and if the user let the Map divide a global count of
    indices evenly over the Map's communicator's processes. The latter
    happens by calling the version of Map's constructor that takes a
    global count of indices, rather than a local count or an arbitrary
    list of indices.

    Map optimizes for the contiguous case. For example, noncontiguous Maps
    always require communication in order to figure out which process owns
    a particular global index. (This communication happens in
    getRemoteIndexList().) Contiguous but nonuniform Maps may also require
    communication in this case, though we may only need to perform that
    communication once (at Map setup time). Contiguous Maps also can
    convert between global and local indices more efficiently. Globally
    distributed or locally replicated  Globally distributed means that all
    of the following are true: The map's communicator has more than one
    process.

    There is at least one process in the map's communicator, whose local
    number of elements does not equal the number of global elements. (That
    is, not all the elements are replicated over all the processes.)  If
    at least one of the above are not true, then the map is locally
    replicated. (The two are mutually exclusive.)

    Globally distributed objects are partitioned across multiple processes
    in a communicator. Each process owns at least one element in the
    object's Map that is not owned by another process. For locally
    replicated objects, each element in the object's Map is owned
    redundantly by all processes in the object's communicator. Some
    algorithms use objects that are too small to be distributed across all
    processes. The upper Hessenberg matrix in a GMRES iterative solve is a
    good example. In other cases, such as with block iterative methods,
    block dot product functions produce small dense matrices that are
    required by all images. Replicated local objects handle these
    situations.

    C++ includes: Tpetra_Map_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Map_default, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Map_default, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_Map_default

    def isOneToOne(self, *args):
        """
        isOneToOne(Map_default self) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::isOneToOne() const

        Whether the Map is one to one.

        This must be called collectively over all processes in the Map's
        communicator. 
        """
        return _Tpetra.Map_default_isOneToOne(self, *args)


    def getGlobalNumElements(self, *args):
        """
        getGlobalNumElements(Map_default self) -> Tpetra::global_size_t

        global_size_t Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getGlobalNumElements() const

        The number of elements in this Map.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getGlobalNumElements(self, *args)


    def getNodeNumElements(self, *args):
        """
        getNodeNumElements(Map_default self) -> size_t

        size_t
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getNodeNumElements()
        const

        The number of elements belonging to the calling process.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getNodeNumElements(self, *args)


    def getIndexBase(self, *args):
        """
        getIndexBase(Map_default self) -> long long

        GlobalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getIndexBase() const

        The index base for this Map.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getIndexBase(self, *args)


    def getMinLocalIndex(self, *args):
        """
        getMinLocalIndex(Map_default self) -> int

        LocalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getMinLocalIndex()
        const

        The minimum local index.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getMinLocalIndex(self, *args)


    def getMaxLocalIndex(self, *args):
        """
        getMaxLocalIndex(Map_default self) -> int

        LocalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getMaxLocalIndex()
        const

        The maximum local index on the calling process.

        If this process owns no elements, that is, if  getNodeNumElements() ==
        0, then this method returns the same value as
        Teuchos::OrdinalTraits<LocalOrdinal>::invalid().

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getMaxLocalIndex(self, *args)


    def getMinGlobalIndex(self, *args):
        """
        getMinGlobalIndex(Map_default self) -> long long

        GlobalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getMinGlobalIndex()
        const

        The minimum global index owned by the calling process.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getMinGlobalIndex(self, *args)


    def getMaxGlobalIndex(self, *args):
        """
        getMaxGlobalIndex(Map_default self) -> long long

        GlobalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getMaxGlobalIndex()
        const

        The maximum global index owned by the calling process.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getMaxGlobalIndex(self, *args)


    def getMinAllGlobalIndex(self, *args):
        """
        getMinAllGlobalIndex(Map_default self) -> long long

        GlobalOrdinal Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getMinAllGlobalIndex() const

        The minimum global index over all processes in the communicator.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getMinAllGlobalIndex(self, *args)


    def getMaxAllGlobalIndex(self, *args):
        """
        getMaxAllGlobalIndex(Map_default self) -> long long

        GlobalOrdinal Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getMaxAllGlobalIndex() const

        The maximum global index over all processes in the communicator.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getMaxAllGlobalIndex(self, *args)


    def getMyGlobalIndices(self, *args):
        """
        getMyGlobalIndices(Map_default self) -> Kokkos::View< long long const *,Kokkos::LayoutLeft,Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::device_type >

        Map<
        LocalOrdinal, GlobalOrdinal, Node >::global_indices_array_type
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getMyGlobalIndices()
        const

        Return a view of the global indices owned by this process.

        The returned "view" has some type that looks like
        Kokkos::View<const GlobalOrdinal*, ...> or

        Teuchos::ArrayView<const GlobalOrdinal>  It implements operator[] and
        the size() method, and behaves as a one- dimensional array. You may
        not modify its entries.

        WARNING:  You are NOT allowed to refer to the return value's type by
        name. That name is private. Use auto instead.  If you call this method
        on a contiguous Map, it will create and cache the list of global
        indices for later use. Beware of calling this if the calling process
        owns a very large number of global indices. 
        """
        return _Tpetra.Map_default_getMyGlobalIndices(self, *args)


    def getNodeElementList(self, *args):
        """
        getNodeElementList(Map_default self) -> Teuchos::ArrayView< long long const >

        Teuchos::ArrayView< const GlobalOrdinal > Tpetra::Map< LocalOrdinal,
        GlobalOrdinal, Node >::getNodeElementList() const

        Return a NONOWNING view of the global indices owned by this process.

        WARNING:  This method may be deprecated at some point. Please consider
        using getMyGlobalIndices() (see above) instead.  If you call this
        method on a contiguous Map, it will create and cache the list of
        global indices for later use. Beware of calling this if the calling
        process owns a very large number of global indices. 
        """
        return _Tpetra.Map_default_getNodeElementList(self, *args)


    def isNodeLocalElement(self, *args):
        """
        isNodeLocalElement(Map_default self, int localIndex) -> bool

        bool
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::isNodeLocalElement(LocalOrdinal localIndex) const

        Whether the given local index is valid for this Map on the calling
        process.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_isNodeLocalElement(self, *args)


    def isNodeGlobalElement(self, *args):
        """
        isNodeGlobalElement(Map_default self, long long globalIndex) -> bool

        bool
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::isNodeGlobalElement(GlobalOrdinal globalIndex) const

        Whether the given global index is owned by this Map on the calling
        process.

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_isNodeGlobalElement(self, *args)


    def isUniform(self, *args):
        """
        isUniform(Map_default self) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::isUniform() const

        Whether the range of global indices is uniform.

        This is a conservative quantity. It need only be true if the Map was
        constructed using the first (uniform contiguous) constructor or a
        nonmember constructor that calls it. We reserve the right to do more
        work to check this in the future. 
        """
        return _Tpetra.Map_default_isUniform(self, *args)


    def isContiguous(self, *args):
        """
        isContiguous(Map_default self) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::isContiguous() const

        True if this Map is distributed contiguously, else false.

        Currently, creating this Map using the constructor for a user-defined
        arbitrary distribution (that takes a list of global elements owned on
        each process) means that this method always returns false. We
        currently make no effort to test whether the user-provided global
        indices are actually contiguous on all the processes. Many operations
        may be faster for contiguous Maps. Thus, if you know the indices are
        contiguous on all processes, you should consider using one of the
        constructors for contiguous elements. 
        """
        return _Tpetra.Map_default_isContiguous(self, *args)


    def isDistributed(self, *args):
        """
        isDistributed(Map_default self) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::isDistributed() const

        Whether this Map is globally distributed or locally replicated.

        True if this Map is globally distributed, else false.  "Globally
        distributed" means that all of the following are true: The map's
        communicator has more than one process.

        There is at least one process in the map's communicator, whose local
        number of elements does not equal the number of global elements. (That
        is, not all the elements are replicated over all the processes.)

        If at least one of the above are not true, then the map is "locally
        replicated." (The two are mutually exclusive.)

        Calling this method requires no communication or computation, because
        the result is precomputed in Map's constructors. 
        """
        return _Tpetra.Map_default_isDistributed(self, *args)


    def isCompatible(self, *args):
        """
        isCompatible(Map_default self, Map_default map) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::isCompatible(const Map<
        LocalOrdinal, GlobalOrdinal, Node > &map) const

        True if and only if map is compatible with this Map.

        Two Maps are "compatible" if all of the following are true: Their
        communicators have the same numbers of processes. (This is necessary
        even to call this method.)

        They have the same global number of elements.

        They have the same number of local elements on each process.

        Determining #3 requires communication (a reduction over this Map's
        communicator). This method assumes that the input Map is valid on all
        processes in this Map's communicator.

        Compatibility is useful for determining correctness of certain
        operations, like assigning one MultiVector X to another Y. If X and Y
        have the same number of columns, and if their Maps are compatible,
        then it is legal to assign X to Y or to assign Y to X.

        The behavior of this method is undefined if the input Map's
        communicator and this Map's communicator have different numbers of
        processes. This method must be called collectively over this Map's
        communicator. 
        """
        return _Tpetra.Map_default_isCompatible(self, *args)


    def isSameAs(self, *args):
        """
        isSameAs(Map_default self, Map_default map) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::isSameAs(const Map< LocalOrdinal,
        GlobalOrdinal, Node > &map) const

        True if and only if map is identical to this Map.

        "Identical" is stronger than "compatible." Two Maps are identical
        if all of the following are true: Their communicators are congruent
        (have the same number of processes, in the same order: this
        corresponds to the MPI_IDENT or MPI_CONGRUENT return values of
        MPI_Comm_compare).

        They have the same min and max global indices.

        They have the same global number of elements.

        They are either both distributed, or both not distributed.

        Their index bases are the same.

        They have the same number of local elements on each process.

        They have the same global indices on each process.

        "Identical" ( isSameAs()) includes and is stronger than
        "compatible" ( isCompatible()).

        A Map corresponds to a block permutation over process ranks and global
        element indices. Two Maps with different numbers of processes in their
        communicators cannot be compatible, let alone identical. Two identical
        Maps correspond to the same permutation.

        The behavior of this method is undefined if the input Map's
        communicator and this Map's communicator have different numbers of
        processes. This method must be called collectively over this Map's
        communicator. 
        """
        return _Tpetra.Map_default_isSameAs(self, *args)


    def locallySameAs(self, *args):
        """
        locallySameAs(Map_default self, Map_default map) -> bool

        bool Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::locallySameAs(const Map<
        LocalOrdinal, GlobalOrdinal, node_type > &map) const

        Is this Map locally the same as the input Map?

        "Locally the same" means that on the calling process, the two Maps'
        global indices are the same and occur in the same order. 
        """
        return _Tpetra.Map_default_locallySameAs(self, *args)


    def getComm(self, *args):
        """
        getComm(Map_default self) -> Teuchos::RCP< Teuchos::Comm< int > const >

        Teuchos::RCP< const
        Teuchos::Comm< int > > Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getComm() const

        Accessors for the Teuchos::Comm and Kokkos Node objects.

        Get this Map's communicator, as a Teuchos::Comm. 
        """
        return _Tpetra.Map_default_getComm(self, *args)


    def getNode(self, *args):
        """
        getNode(Map_default self) -> Teuchos::RCP< KokkosClassic::DefaultNode::DefaultNodeType >

        Teuchos::RCP< Node >
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::getNode() const

        Get this Map's Node object. 
        """
        return _Tpetra.Map_default_getNode(self, *args)


    def description(self, *args):
        """
        description(Map_default self) -> std::string

        std::string
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node >::description() const

        Implementation of Teuchos::Describable.

        Return a one-line description of this object. 
        """
        return _Tpetra.Map_default_description(self, *args)


    def describe(self, *args):
        """
        describe(Map_default self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Tpetra::Map<
        LocalOrdinal, GlobalOrdinal, Node >::describe(Teuchos::FancyOStream
        &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Describe this object in a human-readable way to the given output
        stream.

        You must call this method as a collective over all processes in this
        object's communicator.

        Parameters:
        -----------

        out:  [out] Output stream to which to write. Only Process 0 in this
        object's communicator may write to the output stream.

        verbLevel:  [in] Verbosity level. This also controls whether this
        method does any communication. At verbosity levels higher (greater)
        than Teuchos::VERB_LOW, this method may behave as a collective over
        the object's communicator.

        Teuchos::FancyOStream wraps std::ostream. It adds features like tab
        levels. If you just want to wrap std::cout, try this: 
        """
        return _Tpetra.Map_default_describe(self, *args)


    def removeEmptyProcesses(self, *args):
        """
        removeEmptyProcesses(Map_default self) -> RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > >
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::removeEmptyProcesses() const

        Return a new Map with processes with zero elements removed.

        WARNING:  This method is only for expert users. Understanding how to
        use this method correctly requires some familiarity with semantics of
        MPI communicators.

        WARNING:  We make no promises of backwards compatibility for this
        method. It may go away or change at any time.  This method first
        computes a new communicator, which contains only those processes in
        this Map's communicator (the "original communicator") that have a
        nonzero number of elements in this Map (the "original Map"). It then
        returns a new Map distributed over the new communicator. The new Map
        represents the same distribution as the original Map, except that
        processes containing zero elements are not included in the new Map or
        its communicator. On processes not included in the new Map or
        communicator, this method returns Teuchos::null.

        The returned Map always has a distinct communicator from this Map's
        original communicator. The new communicator contains a subset of
        processes from the original communicator. Even if the number of
        processes in the new communicator equals the number of processes in
        the original communicator, the new communicator is distinct. (In an
        MPI implementation, the new communicator is created using
        MPI_Comm_split.) Furthermore, a process may have a different rank in
        the new communicator, so be wary of classes that like to store the
        rank rather than asking the communicator for it each time.

        This method must be called collectively on the original communicator.
        It leaves the original Map and communicator unchanged.

        This method was intended for applications such as algebraic multigrid
        or other multilevel preconditioners. Construction of each level of the
        multilevel preconditioner typically requires constructing sparse
        matrices, which in turn requires all-reduces over all participating
        processes at that level. Matrix sizes at successively coarser levels
        shrink geometrically. At the coarsest levels, some processes might be
        left with zero rows of the matrix, or the multigrid implementation
        might "rebalance" (redistribute the matrix) and intentionally leave
        some processes with zero rows. Removing processes with zero rows makes
        the all-reduces and other communication operations cheaper. 
        """
        return _Tpetra.Map_default_removeEmptyProcesses(self, *args)


    def replaceCommWithSubset(self, *args):
        """
        replaceCommWithSubset(Map_default self, Teuchos::RCP< Teuchos::Comm< int > const > const & newComm) -> RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > >
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::replaceCommWithSubset(const Teuchos::RCP< const Teuchos::Comm< int
        > > &newComm) const

        Replace this Map's communicator with a subset communicator.

        WARNING:  This method is only for expert users. Understanding how to
        use this method correctly requires some familiarity with semantics of
        MPI communicators.

        WARNING:  We make no promises of backwards compatibility for this
        method. It may go away or change at any time.

        The input communicator's processes are a subset of this Map's current
        communicator's processes.

        On processes which are not included in the input communicator, the
        input communicator is null.  This method must be called collectively
        on the original communicator. It leaves the original Map and
        communicator unchanged.

        This method differs from removeEmptyProcesses(), in that it does not
        assume that excluded processes have zero entries. For example, one
        might wish to remove empty processes from the row Map of a CrsGraph
        using removeEmptyProcesses(), and then apply the resulting subset
        communicator to the column, domain, and range Maps of the same graph.
        For the latter three Maps, one would in general use this method
        instead of removeEmptyProcesses(), giving the new row Map's
        communicator to this method. 
        """
        return _Tpetra.Map_default_replaceCommWithSubset(self, *args)


    def __init__(self, *args):
        """
        __init__(Tpetra::Map<(int,long long,DefaultNodeType)> self, Tpetra::global_size_t numGlobalElements, long long indexBase, Teuchos::RCP< Teuchos::Comm< int > const > const & comm, Tpetra::LocalGlobal lg) -> Map_default
        __init__(Tpetra::Map<(int,long long,DefaultNodeType)> self, Tpetra::global_size_t numGlobalElements, size_t numLocalElements, long long indexBase, Teuchos::RCP< Teuchos::Comm< int > const > const & comm) -> Map_default
        __init__(Tpetra::Map<(int,long long,DefaultNodeType)> self, Tpetra::global_size_t numGlobalElements, PyObject * elementList, long long indexBase, Teuchos::RCP< Teuchos::Comm< int > const > const & comm) -> Map_default

        Tpetra::Map< LocalOrdinal,
        GlobalOrdinal, Node >::Map()

        Default constructor (that does nothing).

        This creates an empty Map, with 0 (zero) indices total. The Map's
        communicator only includes the calling process; in MPI terms, it
        behaves like MPI_COMM_SELF.

        This constructor exists mainly to support view semantics of Map. That
        is, we can create an empty Map, and then assign a nonempty Map to it
        using operator=. This constructor is also useful in methods like
        clone() and removeEmptyProcesses(), where we have the information to
        initialize the Map more efficiently ourselves, without going through
        one of the three usual Map construction paths. 
        """
        this = _Tpetra.new_Map_default(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getLocalElement(self, *args):
        """
        getLocalElement(Map_default self, long long globalIndex) -> PyObject *

        LocalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getLocalElement(GlobalOrdinal globalIndex) const

        The local index corresponding to the given global index.

        Parameters:
        -----------

        globalIndex:  [in] The global index.

        If the given global index is owned by the calling process, return the
        corresponding local index, else return the same value as
        Teuchos::OrdinalTraits<LocalOrdinal>::invalid().

        This function should be thread safe and thread scalable, assuming that
        you refer to the Map by value or reference, not by Teuchos::RCP. 
        """
        return _Tpetra.Map_default_getLocalElement(self, *args)


    def getGlobalElement(self, *args):
        """
        getGlobalElement(Map_default self, int localIndex) -> PyObject *

        GlobalOrdinal
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getGlobalElement(LocalOrdinal localIndex) const

        The global index corresponding to the given local index.

        Parameters:
        -----------

        localIndex:  [in] The local index.

        If the given local index is valid on the calling process, return the
        corresponding global index, else return the same value as
        Teuchos::OrdinalTraits<GlobalOrdinal>::invalid(). 
        """
        return _Tpetra.Map_default_getGlobalElement(self, *args)


    def getRemoteIndexList(self, *args):
        """
        getRemoteIndexList(Map_default self, PyObject * globalIndexes) -> PyObject *

        LookupStatus
        Tpetra::Map< LocalOrdinal, GlobalOrdinal, Node
        >::getRemoteIndexList(const Teuchos::ArrayView< const GlobalOrdinal >
        &GIDList, const Teuchos::ArrayView< int > &nodeIDList) const

        Return the process ranks for the given global indices.

        This method must always be called as a collective over all processes
        in the Map's communicator. For a distributed noncontiguous Map, this
        operation requires communication.

        Parameters:
        -----------

        GIDList:  [in] List of global indices for which to find process ranks
        and local indices. These global indices need not be owned by the
        calling process. Indeed, they need not be owned by any process.

        nodeIDList:  [out] List of process ranks corresponding to the given
        global indices. If a global index does not belong to any process, the
        resulting process rank is -1.

        nodeIDList.size() == GIDList.size()

        IDNotPresent indicates that for at least one global index, we could
        not find the corresponding process rank. Otherwise, return
        AllIDsPresent.

        For a distributed noncontiguous Map, this operation requires
        communication. This is crucial technology used in Export, Import,
        CrsGraph, and CrsMatrix. 
        """
        return _Tpetra.Map_default_getRemoteIndexList(self, *args)


    def __str__(self, *args):
        """__str__(Map_default self) -> std::string"""
        return _Tpetra.Map_default___str__(self, *args)

Map_default_swigregister = _Tpetra.Map_default_swigregister
Map_default_swigregister(Map_default)


Map = Map_default

class Transfer_default(Teuchos.Describable):
    """


    Common base class of Import and Export.

    WARNING:  This is an implementation detail of Tpetra. We make no
    promises of backwards compatibility with this class.

    C++ includes: Tpetra_Details_Transfer_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Transfer_default, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Transfer_default, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_Transfer_default

    def getNumSameIDs(self, *args):
        """
        getNumSameIDs(Transfer_default self) -> size_t

        virtual size_t Tpetra::Details::Transfer< LO, GO, NT
        >::getNumSameIDs() const =0

        Number of initial identical IDs.

        The number of IDs that are identical between the source and target
        Maps, up to the first different ID. 
        """
        return _Tpetra.Transfer_default_getNumSameIDs(self, *args)


    def getNumPermuteIDs(self, *args):
        """
        getNumPermuteIDs(Transfer_default self) -> size_t

        virtual size_t Tpetra::Details::Transfer< LO, GO, NT
        >::getNumPermuteIDs() const =0

        Number of IDs to permute but not to communicate.

        The number of IDs that are local to the calling process, but not part
        of the first getNumSameIDs() entries. The Import or Export will
        permute these entries locally (without distributed-memory
        communication). 
        """
        return _Tpetra.Transfer_default_getNumPermuteIDs(self, *args)


    def getPermuteFromLIDs(self, *args):
        """
        getPermuteFromLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >

        virtual Teuchos::ArrayView<const LO> Tpetra::Details::Transfer< LO,
        GO, NT >::getPermuteFromLIDs() const =0

        List of local IDs in the source Map that are permuted. 
        """
        return _Tpetra.Transfer_default_getPermuteFromLIDs(self, *args)


    def getPermuteToLIDs(self, *args):
        """
        getPermuteToLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >

        virtual Teuchos::ArrayView<const LO> Tpetra::Details::Transfer< LO,
        GO, NT >::getPermuteToLIDs() const =0

        List of local IDs in the target Map that are permuted. 
        """
        return _Tpetra.Transfer_default_getPermuteToLIDs(self, *args)


    def getNumRemoteIDs(self, *args):
        """
        getNumRemoteIDs(Transfer_default self) -> size_t

        virtual size_t Tpetra::Details::Transfer< LO, GO, NT
        >::getNumRemoteIDs() const =0

        Number of entries not on the calling process. 
        """
        return _Tpetra.Transfer_default_getNumRemoteIDs(self, *args)


    def getRemoteLIDs(self, *args):
        """
        getRemoteLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >

        virtual Teuchos::ArrayView<const LO> Tpetra::Details::Transfer< LO,
        GO, NT >::getRemoteLIDs() const =0

        List of entries in the target Map to receive from other processes. 
        """
        return _Tpetra.Transfer_default_getRemoteLIDs(self, *args)


    def getNumExportIDs(self, *args):
        """
        getNumExportIDs(Transfer_default self) -> size_t

        virtual size_t Tpetra::Details::Transfer< LO, GO, NT
        >::getNumExportIDs() const =0

        Number of entries that must be sent by the calling process to other
        processes. 
        """
        return _Tpetra.Transfer_default_getNumExportIDs(self, *args)


    def getExportLIDs(self, *args):
        """
        getExportLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >

        virtual Teuchos::ArrayView<const LO> Tpetra::Details::Transfer< LO,
        GO, NT >::getExportLIDs() const =0

        List of entries in the source Map that will be sent to other
        processes. 
        """
        return _Tpetra.Transfer_default_getExportLIDs(self, *args)


    def getExportPIDs(self, *args):
        """
        getExportPIDs(Transfer_default self) -> Teuchos::ArrayView< int const >

        virtual Teuchos::ArrayView<const int> Tpetra::Details::Transfer< LO,
        GO, NT >::getExportPIDs() const =0

        List of processes to which entries will be sent.

        The entry with local ID getExportLIDs()[i] will be sent to process
        getExportPiDs()[i]. 
        """
        return _Tpetra.Transfer_default_getExportPIDs(self, *args)


    def getSourceMap(self, *args):
        """
        getSourceMap(Transfer_default self) -> Teuchos::RCP< Tpetra::Details::Transfer< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >

        virtual Teuchos::RCP<const map_type> Tpetra::Details::Transfer< LO,
        GO, NT >::getSourceMap() const =0

        The source Map used to construct this Export or Import. 
        """
        return _Tpetra.Transfer_default_getSourceMap(self, *args)


    def getTargetMap(self, *args):
        """
        getTargetMap(Transfer_default self) -> Teuchos::RCP< Tpetra::Details::Transfer< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >

        virtual Teuchos::RCP<const map_type> Tpetra::Details::Transfer< LO,
        GO, NT >::getTargetMap() const =0

        The target Map used to construct this Export or Import. 
        """
        return _Tpetra.Transfer_default_getTargetMap(self, *args)


    def getDistributor(self, *args):
        """
        getDistributor(Transfer_default self) -> ::Tpetra::Distributor &

        virtual ::Tpetra::Distributor& Tpetra::Details::Transfer< LO, GO, NT
        >::getDistributor() const =0

        The Distributor that this Export or Import object uses to move data.

        """
        return _Tpetra.Transfer_default_getDistributor(self, *args)

Transfer_default_swigregister = _Tpetra.Transfer_default_swigregister
Transfer_default_swigregister(Transfer_default)

class Export_default(Transfer_default):
    """


    Communication plan for data redistribution from a (possibly) multiply-
    owned to a uniquely-owned distribution.

    Parameters:
    -----------

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type. See the documentation of Map for
    requirements.

    Tpetra users should use this class to construct a communication plan
    between two data distributions (i.e., two Map objects). The plan can
    be called repeatedly by computational classes to perform communication
    according to the same pattern. Constructing the plan may be expensive,
    both in terms of communication and computation. However, it can be
    reused inexpensively.

    Tpetra has two classes for data redistribution: Import and Export.
    Import is for redistributing data from a uniquely-owned distribution
    to a possibly multiply-owned distribution. Export is for
    redistributing data from a possibly multiply-owned distribution to a
    uniquely-owned distribution.

    The names "Import" and "Export" have nothing to do with the
    direction in which data moves relative to the calling process; any
    process may do both receives and sends in an Import or Export. Rather,
    the names suggest what happens in their most common use case, the
    communication pattern for sparse matrix-vector multiply. Import
    "brings in" remote source vector data (from the domain Map to the
    column Map) for local computation, and Export "pushes" the result
    back (from the row Map to the range Map). Import and Export have other
    uses as well.

    One use case of Export is finite element assembly. For example, one
    way to compute a distributed forcing term vector is to use an
    overlapping distribution for the basis functions' domains. An Export
    with the SUM combine mode combines each process' contribution to the
    integration into a single nonoverlapping distribution.

    Epetra separated Import and Export for performance reasons. The
    implementation is different, depending on which direction is the
    uniquely-owned Map. Tpetra retains this convention.

    This class is templated on the same template arguments as Map: the
    local ordinal type LocalOrdinal, the global ordinal type
    GlobalOrdinal, and the Kokkos Node type.

    This method accepts an optional list of parameters, either through the
    constructor or through the setParameterList() method. Most users do
    not need to worry about these parameters; the default values are fine.
    However, for expert users, we expose the following parameter:
    "Barrier between receives and sends" ( bool): Whether to execute a
    barrier between receives and sends, when executing the Import (i.e.,
    when calling DistObject's doImport() (forward mode) or doExport()
    (reverse mode)).

    C++ includes: Tpetra_Export_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Transfer_default]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Export_default, name, value)
    __swig_getmethods__ = {}
    for _s in [Transfer_default]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Export_default, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::FancyOStream > const & out) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::FancyOStream > const & out, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Export_default rhs) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Import_default importer) -> Export_default

        Tpetra::Export<
        LocalOrdinal, GlobalOrdinal, Node >::Export(const Import<
        LocalOrdinal, GlobalOrdinal, Node > &importer)

        "Copy" constructor from an Export object.

        This constructor creates an Export object from the "reverse" of the
        given Import object. This method is mainly useful for Tpetra
        developers, for example when building the explicit transpose of a
        sparse matrix. 
        """
        this = _Tpetra.new_Export_default(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Export_default

    def setParameterList(self, *args):
        """
        setParameterList(Export_default self, Teuchos::RCP< Teuchos::ParameterList > const & plist)

        void
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node
        >::setParameterList(const Teuchos::RCP< Teuchos::ParameterList >
        &plist)

        Set parameters.

        Please see the class documentation for a list of all accepted
        parameters and their default values. 
        """
        return _Tpetra.Export_default_setParameterList(self, *args)


    def getNumSameIDs(self, *args):
        """
        getNumSameIDs(Export_default self) -> size_t

        size_t
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >::getNumSameIDs()
        const

        Number of initial identical IDs.

        The number of IDs that are identical between the source and target
        Maps, up to the first different ID. 
        """
        return _Tpetra.Export_default_getNumSameIDs(self, *args)


    def getNumPermuteIDs(self, *args):
        """
        getNumPermuteIDs(Export_default self) -> size_t

        size_t
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node
        >::getNumPermuteIDs() const

        Number of IDs to permute but not to communicate.

        The number of IDs that are local to the calling process, but not part
        of the first getNumSameIDs() entries. The Import will permute these
        entries locally (without distributed-memory communication). 
        """
        return _Tpetra.Export_default_getNumPermuteIDs(self, *args)


    def getPermuteFromLIDs(self, *args):
        """
        getPermuteFromLIDs(Export_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Export< LocalOrdinal,
        GlobalOrdinal, Node >::getPermuteFromLIDs() const

        List of local IDs in the source Map that are permuted. 
        """
        return _Tpetra.Export_default_getPermuteFromLIDs(self, *args)


    def getPermuteToLIDs(self, *args):
        """
        getPermuteToLIDs(Export_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Export< LocalOrdinal,
        GlobalOrdinal, Node >::getPermuteToLIDs() const

        List of local IDs in the target Map that are permuted. 
        """
        return _Tpetra.Export_default_getPermuteToLIDs(self, *args)


    def getNumRemoteIDs(self, *args):
        """
        getNumRemoteIDs(Export_default self) -> size_t

        size_t
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >::getNumRemoteIDs()
        const

        Number of entries not on the calling process. 
        """
        return _Tpetra.Export_default_getNumRemoteIDs(self, *args)


    def getRemoteLIDs(self, *args):
        """
        getRemoteLIDs(Export_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Export< LocalOrdinal,
        GlobalOrdinal, Node >::getRemoteLIDs() const

        List of entries in the target Map to receive from other processes. 
        """
        return _Tpetra.Export_default_getRemoteLIDs(self, *args)


    def getNumExportIDs(self, *args):
        """
        getNumExportIDs(Export_default self) -> size_t

        size_t
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >::getNumExportIDs()
        const

        Number of entries that must be sent by the calling process to other
        processes. 
        """
        return _Tpetra.Export_default_getNumExportIDs(self, *args)


    def getExportLIDs(self, *args):
        """
        getExportLIDs(Export_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Export< LocalOrdinal,
        GlobalOrdinal, Node >::getExportLIDs() const

        List of entries in the source Map that will be sent to other
        processes. 
        """
        return _Tpetra.Export_default_getExportLIDs(self, *args)


    def getExportPIDs(self, *args):
        """
        getExportPIDs(Export_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const int > Tpetra::Export< LocalOrdinal,
        GlobalOrdinal, Node >::getExportPIDs() const

        List of processes to which entries will be sent.

        The entry with local ID getExportLIDs()[i] will be sent to process
        getExportPiDs()[i]. 
        """
        return _Tpetra.Export_default_getExportPIDs(self, *args)


    def getSourceMap(self, *args):
        """
        getSourceMap(Export_default self) -> Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >

        Teuchos::RCP<
        const typename Export< LocalOrdinal, GlobalOrdinal, Node >::map_type >
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >::getSourceMap()
        const

        The source Map used to construct this Export. 
        """
        return _Tpetra.Export_default_getSourceMap(self, *args)


    def getTargetMap(self, *args):
        """
        getTargetMap(Export_default self) -> Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >

        Teuchos::RCP<
        const typename Export< LocalOrdinal, GlobalOrdinal, Node >::map_type >
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >::getTargetMap()
        const

        The target Map used to construct this Export. 
        """
        return _Tpetra.Export_default_getTargetMap(self, *args)


    def getDistributor(self, *args):
        """
        getDistributor(Export_default self) -> Tpetra::Distributor &

        Distributor &
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >::getDistributor()
        const

        The Distributor that this Export object uses to move data. 
        """
        return _Tpetra.Export_default_getDistributor(self, *args)


    def isLocallyComplete(self, *args):
        """
        isLocallyComplete(Export_default self) -> bool

        bool
        Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node
        >::isLocallyComplete() const

        Do all source Map indices on the calling process exist on at least one
        process (not necessarily this one) in the target Map?

        It's not necessarily an error for an Export not to be locally complete
        on one or more processes. Nevertheless, you may find this predicate
        useful for figuring out whether you set up your Maps in the way that
        you expect. 
        """
        return _Tpetra.Export_default_isLocallyComplete(self, *args)


    def describe(self, *args):
        """
        describe(Export_default self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Tpetra::Export<
        LocalOrdinal, GlobalOrdinal, Node >::describe(Teuchos::FancyOStream
        &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Describe this object in a human-readable way to the given output
        stream.

        You must call this method as a collective over all processes in the
        communicator of the source and target Map of this object.

        Parameters:
        -----------

        out:  [out] Output stream to which to write. Only Process 0 in this
        object's communicator may write to the output stream.

        verbLevel:  [in] Verbosity level. This also controls whether this
        method does any communication. At verbosity levels higher (greater)
        than Teuchos::VERB_LOW, this method behaves as a collective over the
        object's communicator.

        Teuchos::FancyOStream wraps std::ostream. It adds features like tab
        levels. If you just want to wrap std::cout, try this: 
        """
        return _Tpetra.Export_default_describe(self, *args)

Export_default_swigregister = _Tpetra.Export_default_swigregister
Export_default_swigregister(Export_default)


Export = Export_default

class Import_default(Transfer_default):
    """


    Communication plan for data redistribution from a uniquely-owned to a
    (possibly) multiply-owned distribution.

    Parameters:
    -----------

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type. See the documentation of Map for
    requirements.

    Tpetra users should use this class to construct a communication plan
    between two data distributions (i.e., two Map objects). The plan can
    be called repeatedly by computational classes to perform communication
    according to the same pattern. Constructing the plan may be expensive,
    both in terms of communication and computation. However, it can be
    reused inexpensively.

    Tpetra has two classes for data redistribution: Import and Export.
    Import is for redistributing data from a uniquely-owned distribution
    to a possibly multiply-owned distribution. Export is for
    redistributing data from a possibly multiply-owned distribution to a
    uniquely-owned distribution.

    The names "Import" and "Export" have nothing to do with the
    direction in which data moves relative to the calling process; any
    process may do both receives and sends in an Import or Export. Rather,
    the names suggest what happens in their most common use case, the
    communication pattern for sparse matrix-vector multiply. Import
    "brings in" remote source vector data (from the domain Map to the
    column Map) for local computation, and Export "pushes" the result
    back (from the row Map to the range Map). Import and Export have other
    uses as well.

    As mentioned above, one use case of Import is bringing in remote
    source vector data for a distributed sparse matrix-vector multiply.
    The source vector itself is uniquely owned, but must be brought in
    into an overlapping distribution so that each process can compute its
    part of the target vector without further communication.

    Epetra separated Import and Export for performance reasons. The
    implementation is different, depending on which direction is the
    uniquely-owned Map. Tpetra retains this convention.

    This class is templated on the same template arguments as Map: the
    local ordinal type LocalOrdinal, the global ordinal type
    GlobalOrdinal, and the Kokkos Node type.

    This method accepts an optional list of parameters, either through the
    constructor or through the setParameterList() method. Most users do
    not need to worry about these parameters; the default values are fine.
    However, for expert users, we expose the following parameter:
    "Barrier between receives and sends" ( bool): Whether to execute a
    barrier between receives and sends, when executing the Import (i.e.,
    when calling DistObject's doImport() (forward mode) or doExport()
    (reverse mode)).

    C++ includes: Tpetra_Import_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Transfer_default]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Import_default, name, value)
    __swig_getmethods__ = {}
    for _s in [Transfer_default]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Import_default, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::FancyOStream > const & out) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::FancyOStream > const & out, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::Array< int > & remotePIDs) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Import_default importer) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Export_default exporter) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & source, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & target, Teuchos::Array< int > & userRemotePIDs, Teuchos::Array< long long > & remoteGIDs, Teuchos::ArrayView< int const > const & userExportLIDs, Teuchos::ArrayView< int const > const & userExportPIDs, bool const useRemotePIDs, Teuchos::RCP< Teuchos::ParameterList > const & plist, Teuchos::RCP< Teuchos::FancyOStream > const & out) -> Import_default

        Tpetra::Import<
        LocalOrdinal, GlobalOrdinal, Node >::Import(const Teuchos::RCP< const
        Map< LocalOrdinal, GlobalOrdinal, Node > > &source, const
        Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > >
        &target, Teuchos::Array< int > &userRemotePIDs, Teuchos::Array<
        GlobalOrdinal > &remoteGIDs, const Teuchos::ArrayView< const
        LocalOrdinal > &userExportLIDs, const Teuchos::ArrayView< const int >
        &userExportPIDs, const bool useRemotePIDs, const Teuchos::RCP<
        Teuchos::ParameterList > &plist=Teuchos::null, const Teuchos::RCP<
        Teuchos::FancyOStream > &out=Teuchos::null)

        \\bief Full Expert constructor Requirements: source and target maps
        are fully correct 
        """
        this = _Tpetra.new_Import_default(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Import_default

    def setParameterList(self, *args):
        """
        setParameterList(Import_default self, Teuchos::RCP< Teuchos::ParameterList > const & plist)

        void
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node
        >::setParameterList(const Teuchos::RCP< Teuchos::ParameterList >
        &plist)

        Set parameters.

        Please see the class documentation for a list of all accepted
        parameters and their default values. 
        """
        return _Tpetra.Import_default_setParameterList(self, *args)


    def getNumSameIDs(self, *args):
        """
        getNumSameIDs(Import_default self) -> size_t

        size_t
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node >::getNumSameIDs()
        const

        Number of initial identical IDs.

        The number of IDs that are identical between the source and target
        Maps, up to the first different ID. 
        """
        return _Tpetra.Import_default_getNumSameIDs(self, *args)


    def getNumPermuteIDs(self, *args):
        """
        getNumPermuteIDs(Import_default self) -> size_t

        size_t
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node
        >::getNumPermuteIDs() const

        Number of IDs to permute but not to communicate.

        The number of IDs that are local to the calling process, but not part
        of the first getNumSameIDs() entries. The Import will permute these
        entries locally (without distributed-memory communication). 
        """
        return _Tpetra.Import_default_getNumPermuteIDs(self, *args)


    def getPermuteFromLIDs(self, *args):
        """
        getPermuteFromLIDs(Import_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Import< LocalOrdinal,
        GlobalOrdinal, Node >::getPermuteFromLIDs() const

        List of local IDs in the source Map that are permuted. 
        """
        return _Tpetra.Import_default_getPermuteFromLIDs(self, *args)


    def getPermuteToLIDs(self, *args):
        """
        getPermuteToLIDs(Import_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Import< LocalOrdinal,
        GlobalOrdinal, Node >::getPermuteToLIDs() const

        List of local IDs in the target Map that are permuted. 
        """
        return _Tpetra.Import_default_getPermuteToLIDs(self, *args)


    def getNumRemoteIDs(self, *args):
        """
        getNumRemoteIDs(Import_default self) -> size_t

        size_t
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node >::getNumRemoteIDs()
        const

        Number of entries not on the calling process. 
        """
        return _Tpetra.Import_default_getNumRemoteIDs(self, *args)


    def getRemoteLIDs(self, *args):
        """
        getRemoteLIDs(Import_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Import< LocalOrdinal,
        GlobalOrdinal, Node >::getRemoteLIDs() const

        List of entries in the target Map to receive from other processes. 
        """
        return _Tpetra.Import_default_getRemoteLIDs(self, *args)


    def getNumExportIDs(self, *args):
        """
        getNumExportIDs(Import_default self) -> size_t

        size_t
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node >::getNumExportIDs()
        const

        Number of entries that must be sent by the calling process to other
        processes. 
        """
        return _Tpetra.Import_default_getNumExportIDs(self, *args)


    def getExportLIDs(self, *args):
        """
        getExportLIDs(Import_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const LocalOrdinal > Tpetra::Import< LocalOrdinal,
        GlobalOrdinal, Node >::getExportLIDs() const

        List of entries in the source Map that will be sent to other
        processes. 
        """
        return _Tpetra.Import_default_getExportLIDs(self, *args)


    def getExportPIDs(self, *args):
        """
        getExportPIDs(Import_default self) -> Teuchos::ArrayView< int const >

        Teuchos::ArrayView< const int > Tpetra::Import< LocalOrdinal,
        GlobalOrdinal, Node >::getExportPIDs() const

        List of processes to which entries will be sent.

        The entry with Local ID  getExportLIDs()[i] will be sent to process
        getExportPIDs()[i]. 
        """
        return _Tpetra.Import_default_getExportPIDs(self, *args)


    def getSourceMap(self, *args):
        """
        getSourceMap(Import_default self) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >

        Teuchos::RCP<
        const typename Import< LocalOrdinal, GlobalOrdinal, Node >::map_type >
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node >::getSourceMap()
        const

        The Source Map used to construct this Import object. 
        """
        return _Tpetra.Import_default_getSourceMap(self, *args)


    def getTargetMap(self, *args):
        """
        getTargetMap(Import_default self) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >

        Teuchos::RCP<
        const typename Import< LocalOrdinal, GlobalOrdinal, Node >::map_type >
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node >::getTargetMap()
        const

        The Target Map used to construct this Import object. 
        """
        return _Tpetra.Import_default_getTargetMap(self, *args)


    def getDistributor(self, *args):
        """
        getDistributor(Import_default self) -> Tpetra::Distributor &

        Distributor &
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node >::getDistributor()
        const

        The Distributor that this Import object uses to move data. 
        """
        return _Tpetra.Import_default_getDistributor(self, *args)


    def isLocallyComplete(self, *args):
        """
        isLocallyComplete(Import_default self) -> bool

        bool
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node
        >::isLocallyComplete() const

        Do all target Map indices on the calling process exist on at least one
        process (not necessarily this one) in the source Map?

        It's not necessarily an error for an Import not to be locally complete
        on one or more processes. For example, this may happen in the common
        use case of "restriction" that is, taking a subset of a large
        object. Nevertheless, you may find this predicate useful for figuring
        out whether you set up your Maps in the way that you expect. 
        """
        return _Tpetra.Import_default_isLocallyComplete(self, *args)


    def setUnion(self, *args):
        """
        setUnion(Import_default self, Import_default rhs) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        setUnion(Import_default self) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP< const
        Import< LocalOrdinal, GlobalOrdinal, Node > > Tpetra::Import<
        LocalOrdinal, GlobalOrdinal, Node >::setUnion() const

        Return the union of this Import this-> getSourceMap()

        This special case of setUnion creates a new Import object such that
        the targetMap of the new object contains all local unknowns in the
        sourceMap (plus whatever remotes were contained in this->
        getSourceMap()).

        The Map that results from this operation does not preserve the input
        order of global indices. All local global indices are ordered in the
        order of the sourceMap, all remotes are ordered as implied by the
        Importer for *this.

        This primitive is useful for adding or multipyling two sparse matrices
        ( CrsMatrix), since its can skip over many of the steps of creating
        the result matrix's column Map from scratch. 
        """
        return _Tpetra.Import_default_setUnion(self, *args)


    def createRemoteOnlyImport(self, *args):
        """
        createRemoteOnlyImport(Import_default self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & remoteTarget) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP< const Import< LocalOrdinal, GlobalOrdinal, Node > >
        Tpetra::Import< LocalOrdinal, GlobalOrdinal, Node
        >::createRemoteOnlyImport(const Teuchos::RCP< const map_type >
        &remoteTarget) const

        Returns an importer that contains only the remote entries of this.

        Returns an importer that contains only the remote entries of this
        importer. It is expected that remoteTarget represents such a map. 
        """
        return _Tpetra.Import_default_createRemoteOnlyImport(self, *args)


    def describe(self, *args):
        """
        describe(Import_default self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Tpetra::Import<
        LocalOrdinal, GlobalOrdinal, Node >::describe(Teuchos::FancyOStream
        &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Describe this object in a human-readable way to the given output
        stream.

        You must call this method as a collective over all processes in the
        communicator of the source and target Map of this object.

        Parameters:
        -----------

        out:  [out] Output stream to which to write. Only Process 0 in this
        object's communicator may write to the output stream.

        verbLevel:  [in] Verbosity level. This also controls whether this
        method does any communication. At verbosity levels higher (greater)
        than Teuchos::VERB_LOW, this method behaves as a collective over the
        object's communicator.

        Teuchos::FancyOStream wraps std::ostream. It adds features like tab
        levels. If you just want to wrap std::cout, try this: 
        """
        return _Tpetra.Import_default_describe(self, *args)

Import_default_swigregister = _Tpetra.Import_default_swigregister
Import_default_swigregister(Import_default)


Import = Import_default

class SrcDistObject(_object):
    """


    Abstract base class for objects that can be the source of an Import or
    Export operation.

    Any object that may be the source of an Import or Export data
    redistribution operation must inherit from this class. This class
    implements no methods, other than a trivial virtual destructor. If a
    subclass X inherits from this class, that indicates that the subclass
    can be the source of an Import or Export, for some set of subclasses
    of DistObject. A subclass Y of DistObject which is the target of the
    Import or Export operation will attempt to cast the input source
    SrcDistObject to a subclass which it knows how to treat as a source
    object. The target subclass Y is responsible for knowing what source
    classes to expect, and how to interpret the resulting source object.

    DistObject inherits from this class, since a DistObject subclass may
    be either the source or the target of an Import or Export. A
    SrcDistObject subclass which does not inherit from DistObject need
    only be a valid source of an Import or Export; it need not be a valid
    target.

    This object compares to the Epetra class Epetra_SrcDistObject. Unlike
    in Epetra, this class in Tpetra does not include a getMap() method.
    This is for two reasons. First, consider the following inheritance
    hierarchy: DistObject and RowGraph inherit from SrcDistObject, and
    CrsGraph inherits from DistObject and RowGraph. If SrcDistObject had a
    virtual getMap method, that would make resolution of the method
    ambiguous. Second, it is not necessary for SrcDistObject to have a
    getMap method, because a SrcDistObject alone does not suffice as the
    source of an Import or Export. Any DistObject subclass must cast the
    SrcDistObject to a subclass which it knows how to treat as the source
    of an Import or Export. Thus, it's not necessary for SrcDistObject to
    have a getMap method, since it needs to be cast anyway before use. In
    general, I prefer to keep interfaces as simple as possible.

    C++ includes: Tpetra_SrcDistObject.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SrcDistObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SrcDistObject, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_SrcDistObject

    def __init__(self, *args):
        """__init__(Tpetra::SrcDistObject self) -> SrcDistObject"""
        this = _Tpetra.new_SrcDistObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SrcDistObject_swigregister = _Tpetra.SrcDistObject_swigregister
SrcDistObject_swigregister(SrcDistObject)


def MultiVector_getattr(self, name):
    if name == "array":
        a = self._extractNumPyArray()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    else:
        raise AttributeError("'%s' not an attribute of MultiVector" % name)
def MultiVector_setattr(self, name, value):
    if name in ("array", "shape", "dtype"):
        raise AttributeError("Cannot change MultiVector '%s' attribute", name)
    else:
        self.__dict__[name] = value
def MultiVector_getitem(self,i):
    if isinstance(i,int):
        return self.getVectorNonConst(i)
    else:
        return self.array.__getitem__(i)
def upgradeMultiVectorClass(cls):
    cls.__getattr__ = MultiVector_getattr
    cls.__setattr__ = MultiVector_setattr
    cls.__getitem__ = MultiVector_getitem
    cls.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
    cls.__len__     = lambda self: self.array.__len__()
    cls.__str__     = lambda self: self.array.__str__()
    cls.copy        = lambda self: cls(self)
    class_array_add_math(cls)
    class_array_add_comp(cls)



def Vector_getattr(self, name):
    if name == "array":
        a = self._extractNumPyArray()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    else:
        raise AttributeError("'%s' not an attribute of Vector" % name)
def Vector_setattr(self, name, value):
    if name in ("array", "shape", "dtype"):
        raise AttributeError("Cannot change Vector '%s' attribute", name)
    else:
        self.__dict__[name] = value
def upgradeVectorClass(cls):
    cls.__getattr__ = Vector_getattr
    cls.__setattr__ = Vector_setattr
    cls.__getitem__ = lambda self, i: self.array.__getitem__(i)
    cls.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
    cls.__len__     = lambda self: self.array.__len__()
    cls.__str__     = lambda self: self.array.__str__()
    cls.copy        = lambda self: cls(self)
    class_array_add_math(cls)
    class_array_add_comp(cls)


class DistObject_int(SrcDistObject, Teuchos.Describable):
    """


    Base class for distributed Tpetra objects that support data
    redistribution.

    DistObject is a base class for all Tpetra distributed global objects,
    including CrsGraph, CrsMatrix, MultiVector, and Vector. Classes that
    inherit from DistObject work as either the source or the target of an
    Export or Import (parallel redistribution) operation. If you want to
    write a class that can work as the source or target of an Export or
    Import operation, that class must inherit from DistObject.

    Parameters:
    -----------

    LocalOrdinal:  The type of local indices. Same as Map's LocalOrdinal
    template parameter. See Map's documentation for a discussion of the
    types that are valid to use here.

    GlobalOrdinal:  The type of global indices. Same as Map's
    GlobalOrdinal template parameter. See Map's documentation for a
    discussion of the types that are valid to use here.

    Node:  Same as Map's Node template parameter. See Map's documentation
    for a discussion of the types that are valid to use here.

    classic:  DO NOT SET THIS EXPLICITLY. This template parameter only
    exists for backwards compatibility. It must always be false.

    Summary Most Tpetra users will only use this class' methods to perform
    data redistribution for subclasses such as CrsGraph, CrsMatrix,
    MultiVector, and Vector. DistObject provides four methods for
    redistributing data: two versions of  doImport(), and two versions of
    doExport(). Import operations redistribute data from a nonoverlapping
    (one-to-one) distribution to a possibly overlapping distribution.
    Export operations redistribute data from a possibly overlapping
    distribution to a nonoverlapping (one-to-one) distribution. Once you
    have precomputed a data redistribution plan (an Import or Export
    object), you may use the plan to redistribute an input object's data
    into this object, by calling one of these methods. The input object of
    doImport() or  doExport() is always the "source" of the
    redistribution operation, which sends the data. The *this object is
    the target, which receives and combines the data. It has the
    distribution given by this-> getMap(). Forward or reverse
    redistribution modes Both Import and Export operations occur in two
    modes: forward and reverse. Forward mode is the usual case, where you
    are calling a method with its matching plan type (  doImport() for an
    Import plan, or  doExport() for an Export plan). In that case, the
    input DistObject must have the same Map as the source Map of the plan,
    and the target DistObject must have the same Map as the target Map of
    the plan. Reverse mode is also possible, where you call a method with
    the opposite plan type (  doImport() for an Export plan, or
    doExport() for an Import plan). In that case, the source DistObject's
    Map must be the same as the target Map of the plan, and the target
    DistObject's Map must be the same as the source Map of the plan. If
    you call  doImport(), we still call this an Import operation, even if
    you are using an Export plan in reverse. Similarly, if you call
    doExport(), we call this an Export operation.

    Most users will want to use forward mode. However, reverse mode is
    useful for some applications. For example, suppose you are solving a
    nonlinear partial differential equation using the finite element
    method, with Newton's method for the nonlinear equation. When
    assembling into a vector, it is convenient and efficient to do local
    assembly first into a vector with an overlapping distribution, then do
    global assembly via forward mode Export into a vector with a
    nonoverlapping distribution. After the linear solve, you may want to
    bring the resulting nonoverlapping distribution vector back to the
    overlapping distribution for another update phase. This would be a
    reverse mode Import, using the precomputed Export object.

    Another use case for reverse mode is in CrsMatrix, for the transpose
    version of distributed sparse matrix-vector multiply ("mat-vec").
    Non-transpose mat-vec (a function from the domain Map to the range
    Map) does an Import to bring in the source vector's data from the
    domain Map to the column Map of the sparse matrix, and an Export (if
    necessary) to bring the results from the row Map of the sparse matrix
    to the range Map. Transpose mat-vec (a function from the range Map to
    the domain Map) uses these precomputed Import and Export objects in
    reverse mode: first the Export in reverse mode to Import the source
    vector's data to the row Map, and then the Import in reverse mode to
    Export the results to the domain Map. Reverse mode lets us reuse the
    precomputed data redistribution plans for the transpose case. How to
    implement a subclass If you want to implement your own DistObject
    subclass, you have two choices of interface to implement: "old"
    (using Teuchos memory management classes, like Teuchos::ArrayRCP and
    Teuchos::ArrayView) or "new" (using Kokkos memory management
    classes, like Kokkos::View and Kokkos::DualView). Prefer new to old.
    The new interface gives you more options for thread parallelism and
    use of the GPU.

    If you intend to implement the new interface, you must override
    useNewInterface() to return true. In that case, your class must
    override the following methods:  constantNumberOfPackets()

    checkSizes()

    copyAndPermuteNew()

    packAndPrepareNew()

    unpackAndCombineNew()  Comments in the implementation of
    doTransferNew() explain how DistObject uses these methods to pack and
    unpack data for redistribution.

    If you choose to implement the old interface (not recommended), you
    should override the following methods instead:
    constantNumberOfPackets()

    checkSizes()

    copyAndPermute()

    packAndPrepare()

    unpackAndCombine()  In this case, you may also wish to implement
    createViews(), createViewsNonConst(), and releaseViews(). Comments in
    the implementation of doTransfer() explain how DistObject uses all
    these methods to pack and unpack data for redistribution.

    DistObject implements SrcDistObject, because we presume that if an
    object can be the target of an Import or Export, it can also be the
    source of an Import or Export.

    C++ includes: Tpetra_DistObject_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SrcDistObject, Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject_int, name, value)
    __swig_getmethods__ = {}
    for _s in [SrcDistObject, Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_DistObject_int

    def doImport(self, *args):
        """
        doImport(DistObject_int self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        doImport(DistObject_int self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::doImport(const SrcDistObject &source, const Export< LocalOrdinal,
        GlobalOrdinal, Node > &exporter, CombineMode CM)

        Import data into this object using an Export object ("reverse
        mode").

        The input DistObject is always the source of the data redistribution
        operation, and the *this object is always the target.

        If you don't know the difference between forward and reverse mode,
        then you probably want forward mode. Use the version of doImport()
        that takes a precomputed Import object in that case.

        Parameters:
        -----------

        source:  [in] The "source" object for redistribution.

        exporter:  [in] Precomputed data redistribution plan. Its target Map
        must be the same as the input DistObject's Map, and its source Map
        must be the same as this-> getMap(). (Note the difference from forward
        mode.)

        CM:  [in] How to combine incoming data with the same global index. 
        """
        return _Tpetra.DistObject_int_doImport(self, *args)


    def doExport(self, *args):
        """
        doExport(DistObject_int self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        doExport(DistObject_int self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::doExport(const SrcDistObject &source, const Import< LocalOrdinal,
        GlobalOrdinal, Node > &importer, CombineMode CM)

        Export data into this object using an Import object ("reverse
        mode").

        The input DistObject is always the source of the data redistribution
        operation, and the *this object is always the target.

        If you don't know the difference between forward and reverse mode,
        then you probably want forward mode. Use the version of doExport()
        that takes a precomputed Export object in that case.

        Parameters:
        -----------

        source:  [in] The "source" object for redistribution.

        importer:  [in] Precomputed data redistribution plan. Its target Map
        must be the same as the input DistObject's Map, and its source Map
        must be the same as this-> getMap(). (Note the difference from forward
        mode.)

        CM:  [in] How to combine incoming data with the same global index. 
        """
        return _Tpetra.DistObject_int_doExport(self, *args)


    def isDistributed(self, *args):
        """
        isDistributed(DistObject_int self) -> bool

        bool
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::isDistributed() const

        Whether this is a globally distributed object.

        For a definition of "globally distributed" (and its opposite,
        "locally replicated"), see the documentation of Map's
        isDistributed() method. 
        """
        return _Tpetra.DistObject_int_isDistributed(self, *args)


    def getMap(self, *args):
        """
        getMap(DistObject_int self) -> Teuchos::RCP< DefaultMapType const >

        virtual
        Teuchos::RCP<const map_type> Tpetra::DistObject< Packet, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getMap() const

        The Map describing the parallel distribution of this object.

        Note that some Tpetra objects might be distributed using multiple Map
        objects. For example, CrsMatrix has both a row Map and a column Map.
        It is up to the subclass to decide which Map to use when invoking the
        DistObject constructor. 
        """
        return _Tpetra.DistObject_int_getMap(self, *args)


    def description(self, *args):
        """
        description(DistObject_int self) -> std::string

        std::string
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::description() const

        One-line descriptiion of this object.

        We declare this method virtual so that subclasses of DistObject may
        override it. 
        """
        return _Tpetra.DistObject_int_description(self, *args)


    def describe(self, *args):
        """
        describe(DistObject_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print a descriptiion of this object to the given output stream.

        We declare this method virtual so that subclasses of Distobject may
        override it. 
        """
        return _Tpetra.DistObject_int_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """
        removeEmptyProcessesInPlace(DistObject_int self, Teuchos::RCP< DefaultMapType const > const & newMap)

        void removeEmptyProcessesInPlace(Teuchos::RCP< Tpetra::DistObject<
        PT, LO, GO, NT > > &input) 
        """
        return _Tpetra.DistObject_int_removeEmptyProcessesInPlace(self, *args)

DistObject_int_swigregister = _Tpetra.DistObject_int_swigregister
DistObject_int_swigregister(DistObject_int)

class MultiVector_int(DistObject_int):
    """


    One or more distributed dense vectors.

    A "multivector" contains one or more dense vectors. All the vectors
    in a multivector have the same distribution of rows in parallel over
    the communicator used to create the multivector. Multivectors
    containing more than one vector are useful for algorithms that solve
    multiple linear systems at once, or that solve for a cluster of
    eigenvalues and their corresponding eigenvectors at once. These
    "block" algorithms often have accuracy or performance advantages
    over corresponding algorithms that solve for only one vector at a
    time. For example, working with multiple vectors at a time allows
    Tpetra to use faster BLAS 3 routines for local computations. It may
    also reduce the number of parallel reductions.

    The Vector class implements the MultiVector interface, so if you only
    wish to work with a single vector at a time, you may simply use Vector
    instead of MultiVector. However, if you are writing solvers or
    preconditioners, you would do better to write to the MultiVector
    interface and always assume that each MultiVector contains more than
    one vector. This will make your solver or preconditioner more
    compatible with other Trilinos packages, and it will also let you
    exploit the performance optimizations mentioned above.

    Parameters:
    -----------

    Scalar:  The type of each entry of the multivector. (You can use real-
    valued or complex-valued types here, unlike in Epetra, where the
    scalar type is always double.)

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type.

    Prerequisites Before reading the rest of this documentation, it helps
    to know a little bit about Kokkos. In particular, you should know
    about execution spaces, memory spaces, and shallow copy semantics. You
    should also know something about the Teuchos memory management
    classes, in particular Teuchos::RCP, though it helps to know a bit
    about Teuchos::ArrayRCP and Teuchos::ArrayView as well. You may also
    want to know about the differences between BLAS 1, 2, and 3
    operations, and learn a little bit about MPI (the Message Passing
    Interface for distributed-memory programming). You won't have to use
    MPI directly to use MultiVector, but it helps to be familiar with the
    general idea of distributed storage of data over a communicator. A
    MultiVector is a view of data A MultiVector is a view of data. A view
    behaves like a pointer; it provides access to the original
    multivector's data without copying the data. This means that the copy
    constructor and assignment operator ( operator=) do shallow copies.
    They do not copy the data; they just copy pointers and other
    "metadata." If you would like to copy a MultiVector into an existing
    MultiVector, call the nonmember function deep_copy(). If you would
    like to create a new MultiVector which is a deep copy of an existing
    MultiVector, call the nonmember function createCopy(), or use the two-
    argument copy constructor with Teuchos::Copy as the second argument.

    Views have the additional property that they automatically handle
    deallocation. They use reference counting for this, much like how
    std::shared_ptr works. That means you do not have to worry about
    "freeing" a MultiVector after it has been created. Furthermore, you
    may pass shallow copies around without needing to worry about which is
    the "master" view of the data. There is no "master" view of the
    data; when the last view falls out of scope, the data will be
    deallocated.

    This is what the documentation means when it speaks of view semantics.
    The opposite of that is copy or container semantics, where the copy
    constructor and operator= do deep copies (of the data). We say that
    "std::vector has container semantics," and "MultiVector has view
    semantics."

    MultiVector also has "subview" methods that give results analogous
    to the Kokkos::subview() function. That is, they return a MultiVector
    which views some subset of another MultiVector's rows and columns. The
    subset of columns in a view need not be contiguous. For example, given
    a multivector X with 43 columns, it is possible to have a multivector
    Y which is a view of columns 1, 3, and 42 (zero-based indices) of X.
    We call such multivectors noncontiguous. They have the the property
    that isConstantStride() returns false.

    Noncontiguous multivectors lose some performance advantages. For
    example, local computations may be slower, since Tpetra cannot use
    BLAS 3 routines (e.g., matrix-matrix multiply) on a noncontiguous
    multivectors without copying into temporary contiguous storage. For
    performance reasons, if you get a Kokkos::View of a noncontiguous
    MultiVector's local data, it does not correspond to the columns that
    the MultiVector views. DualView semantics  Tpetra was designed to
    perform well on many different kinds of computers. Some computers have
    different memory spaces. For example, GPUs (Graphics Processing Units)
    by NVIDIA have "device memory" and "host memory." The GPU has
    faster access to device memory than host memory, but usually there is
    less device memory than host memory. Intel's "Knights Landing"
    architecture has two different memory spaces, also with different
    capacity and performance characteristics. Some architectures let the
    processor address memory in any space, possibly with a performance
    penalty. Others can only access data in certain spaces, and require a
    special system call to copy memory between spaces.

    The Kokkos package provides abstractions for handling multiple memory
    spaces. In particular, Kokkos::DualView lets users "mirror" data
    that live in one space, with data in another space. It also lets users
    manually mark data in one space as modified ( modify()), and
    synchronize ( sync()) data from one space to another. The latter only
    actually copies if the data have been marked as modified. Users can
    access data in a particular space by calling view(). All three of
    these methods modify(), sync(), and view() are templated on the memory
    space. This is how users select the memory space on which they want
    the method to act.

    MultiVector implements "DualView semantics." This means that it
    implements the above three operations:  modify(): Mark data in a
    memory space as modified (or about to be modified)

    sync(): If data in the target memory space are least recently modified
    compared with the other space, copy data to the target memory space

    getLocalView(): Return a Kokkos::View of the data in a given memory
    space

    If your computer only has one memory space, as with conventional
    single-core or multicore processors, you don't have to worry about
    this. You can ignore the modify() and sync() methods in that case. How
    to access the local data The getLocalView() method for getting a
    Kokkos::View is the main way to access a MultiVector's local data. If
    you want to read or write the actual values in a multivector, this is
    what you want. The resulting Kokkos::View behaves like a 2-D array.
    You can address it using an index pair (i,j), where i is the local row
    index, and j is the column index.

    MultiVector also has methods that return an Teuchos::ArrayRCP<Scalar>
    ("1-D view"), or a Teuchos::ArrayRCP<Teuchos::ArrayRCP<Scalar> >
    ("2-D view"). These exist only for backwards compatibility, and also
    give access to the local data.

    All of these views only view local data. This means that the
    corresponding rows of the multivector are owned by the calling (MPI)
    process. You may not use these methods to access remote data, that is,
    rows that do not belong to the calling process.

    MultiVector's public interface also has methods for modifying local
    data, like sumIntoLocalValue() and replaceGlobalValue(). These methods
    act on host data only. To access or modify device data, you must get
    the Kokkos::View and work with it directly. Why won't you give me a
    raw pointer?  Tpetra was designed to allow different data
    representations underneath the same interface. This lets Tpetra run
    correctly and efficiently on many different kinds of hardware. These
    different kinds of hardware all have in common the following: Data
    layout matters a lot for performance

    The right layout for your data depends on the hardware

    Data may be distributed over different memory spaces in hardware, and
    efficient code must respect this, whether or not the programming model
    presents the different memories as a single address space

    Copying between different data layouts or memory spaces is expensive
    and should be avoided whenever possible

    Optimal data layout may require control over initialization of storage
    These conclusions have practical consequences for the MultiVector
    interface. In particular, we have deliberately made it difficult for
    you to access data directly by raw pointer. This is because the
    underlying layout may not be what you expect. The memory might not
    even be accessible from the host CPU. Instead, we give access through
    a Kokkos::View, which behaves like a 2-D array. You can ask the
    Kokkos::View for a raw pointer by calling its ptr_on_device() method,
    but then you are responsible for understanding its layout in memory.
    Parallel distribution of data A MultiVector's rows are distributed
    over processes in its (row) Map's communicator. A MultiVector is a
    DistObject; the Map of the DistObject tells which process in the
    communicator owns which rows. This means that you may use Import and
    Export operations to migrate between different distributions. Please
    refer to the documentation of Map, Import, and Export for more
    information.

    MultiVector includes methods that perform parallel all-reduces. These
    include inner products and various kinds of norms. All of these
    methods have the same blocking semantics as MPI_Allreduce.

    WARNING:  Some computational methods, such as inner products and
    norms, may return incorrect results if the MultiVector's Map is
    overlapping (not one-to-one) but not locally replicated. That is, if
    some but not all rows are shared by more than one process in the
    communicator, then inner products and norms may be wrong. This
    behavior may change in future releases.

    C++ includes: Tpetra_MultiVector_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector_int, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector_int, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, size_t const numVecs, bool const zeroOut=True) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, MultiVector_int source) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, MultiVector_int source, Teuchos::DataAccess const copyOrView) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, Teuchos::ArrayView< int const > const & A, size_t const LDA, size_t const NumVectors) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map, Teuchos::ArrayView< Teuchos::ArrayView< int const > const > const & ArrayOfPtrs, size_t const NumVectors) -> MultiVector_int

        Tpetra::MultiVector< Scalar, LO, GO, Node, classic
        >::MultiVector(const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic > &X, const map_type &subMap, const size_t offset=0)

        "Offset view" constructor; make a view of a contiguous subset of
        rows on each process.

        Return a view of the MultiVector X, which views a subset of the rows
        of X. Specify the subset by a subset Map of this MultiVector's current
        row Map, and an optional (local) offset. "View" means "alias": if
        the original (this) MultiVector's data change, the view will see the
        changed data.

        Parameters:
        -----------

        X:  [in] The MultiVector to view.

        subMap:  [in] The row Map for the new MultiVector. This must be a
        subset Map of the input MultiVector's row Map.

        offset:  [in] The local row offset at which to start the view.

        Suppose that you have a MultiVector X, and you want to view X, on all
        processes in X's (MPI) communicator, as split into two row blocks X1
        and X2. One could express this in Matlab notation as X = [X1; X2],
        except that here, X1 and X2 are views into X, rather than copies of
        X's data. This method assumes that the local indices of X1 and X2 are
        each contiguous, and that the local indices of X2 follow those of X1.
        If that is not the case, you cannot use views to divide X into blocks
        like this; you must instead use the Import or Export functionality,
        which copies the relevant rows of X.

        Here is how you would construct the views X1 and X2.

        It is legal, in the above example, for X1 or X2 to have zero local
        rows on any or all process(es). In that case, the corresponding Map
        must have zero local entries on that / those process(es). In
        particular, if X2 has zero local rows on a process, then the
        corresponding offset on that process would be the number of local rows
        in X (and therefore in X1) on that process. This is the only case in
        which the sum of the local number of entries in subMap (in this case,
        zero) and the offset may equal the number of local entries in *this.

        """
        this = _Tpetra.new_MultiVector_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_MultiVector_int

    def replaceGlobalValue(self, *args):
        """
        replaceGlobalValue(MultiVector_int self, long long globalRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceGlobalValue(GlobalOrdinal globalRow, size_t col,
        const T &value) const

        Like the above replaceGlobalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        This method does not have an "atomic" option like
        sumIntoGlobalValue. This is deliberate. Replacement is not
        commutative, unlike += (modulo rounding error). Concurrent calls to
        replaceGlobalValue on different threads that modify the same entry/ies
        have undefined results. (It's not just that one thread might win; it's
        that the value might get messed up.)

        Parameters:
        -----------

        gblRow:  [in] Global row index of the entry to modify. This must be a
        valid global row index on the calling process with respect to the
        MultiVector's Map.

        col:  [in] Column index of the entry to modify.

        value:  [in] Incoming value to add to the entry. 
        """
        return _Tpetra.MultiVector_int_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """
        sumIntoGlobalValue(MultiVector_int self, long long globalRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::sumIntoGlobalValue(const GlobalOrdinal gblRow, const size_t
        col, const T &val, const bool atomic=useAtomicUpdatesByDefault) const

        Like the above sumIntoGlobalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        Parameters:
        -----------

        gblRow:  [in] Global row index of the entry to modify. This must be a
        valid global row index on the calling process with respect to the
        MultiVector's Map.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.MultiVector_int_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """
        replaceLocalValue(MultiVector_int self, int localRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceLocalValue(const LocalOrdinal lclRow, const size_t
        col, const T &val) const

        Like the above replaceLocalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        This method does not have an "atomic" option like sumIntoLocalValue.
        This is deliberate. Replacement is not commutative, unlike += (modulo
        rounding error). Concurrent calls to replaceLocalValue on different
        threads that modify the same entry/ies have undefined results. (It's
        not just that one thread might win; it's that the value might get
        messed up.)

        Parameters:
        -----------

        lclRow:  [in] Local row index of the entry to modify. Must be a valid
        local index in this MultiVector's Map on the calling process.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry. 
        """
        return _Tpetra.MultiVector_int_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """
        sumIntoLocalValue(MultiVector_int self, int localRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::sumIntoLocalValue(const LocalOrdinal lclRow, const size_t
        col, const T &val, const bool atomic=useAtomicUpdatesByDefault) const

        Like the above sumIntoLocalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        Parameters:
        -----------

        lclRow:  [in] Local row index of the entry to modify.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.MultiVector_int_sumIntoLocalValue(self, *args)


    def putScalar(self, *args):
        """
        putScalar(MultiVector_int self, int const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::putScalar(const T &value)

        Set all values in the multivector with the given value.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U. 
        """
        return _Tpetra.MultiVector_int_putScalar(self, *args)


    def randomize(self, *args):
        """
        randomize(MultiVector_int self)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::randomize(const Scalar &minVal, const Scalar &maxVal)

        Set all values in the multivector to pseudorandom numbers in the given
        range.

        Do not expect repeatable results.

        Behavior of this method may or may not depend on external use of the C
        library routines srand() and rand(). In particular, setting the seed
        there may not affect it here.

        WARNING:  This method does not promise to use a distributed-memory
        parallel pseudorandom number generator. Corresponding values on
        different processes might be correlated. It also does not promise to
        use a high-quality pseudorandom number generator within each process.

        """
        return _Tpetra.MultiVector_int_randomize(self, *args)


    def replaceMap(self, *args):
        """
        replaceMap(MultiVector_int self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceMap(const Teuchos::RCP< const map_type > &map)

        Replace the underlying Map in place.

        WARNING:  The normal use case of this method, with an input Map that
        is compatible with the object's current Map and has the same
        communicator, is safe. However, if the input Map has a different
        communicator (with a different number of processes, in particular)
        than this object's current Map, the semantics of this method are
        tricky. We recommend that only experts try the latter use case.

        If the new Map's communicator is similar to the original Map's
        communicator, then the original Map and new Map must be compatible:
        map->isCompatible (this->getMap ()). "Similar" means that the
        communicators have the same number of processes, though these need not
        be in the same order (have the same assignments of ranks) or represent
        the same communication contexts. It means the same thing as the
        MPI_SIMILAR return value of MPI_COMM_COMPARE. See MPI 3.0 Standard,
        Section 6.4.1.

        If the new Map's communicator contains more processes than the
        original Map's communicator, then the projection of the original Map
        onto the new communicator must be compatible with the new Map.

        If the new Map's communicator contains fewer processes than the
        original Map's communicator, then the projection of the new Map onto
        the original communicator must be compatible with the original Map.
        This method replaces this object's Map with the given Map. This
        relabels the rows of the multivector using the global IDs in the input
        Map. Thus, it implicitly applies a permutation, without actually
        moving data. If the new Map's communicator has more processes than the
        original Map's communicator, it "projects" the MultiVector onto the
        new Map by filling in missing rows with zeros. If the new Map's
        communicator has fewer processes than the original Map's communicator,
        the method "forgets about" any rows that do not exist in the new
        Map. (It mathematical terms, if one considers a MultiVector as a
        function from one vector space to another, this operation restricts
        the range.)

        This method must always be called collectively on the communicator
        with the largest number of processes: either this object's current
        communicator ( this-> getMap()->getComm()), or the new Map's
        communicator ( map->getComm()). If the new Map's communicator has
        fewer processes, then the new Map must be null on processes excluded
        from the original communicator, and the current Map must be nonnull on
        all processes. If the new Map has more processes, then it must be
        nonnull on all those processes, and the original Map must be null on
        those processes which are not in the new Map's communicator. (The
        latter case can only happen to a MultiVector to which a replaceMap()
        operation has happened before.)

        WARNING:  This method must always be called as a collective operation
        on all processes in the original communicator ( this->getMap
        ()->getComm ()). We reserve the right to do checking in debug mode
        that requires this method to be called collectively in order not to
        deadlock.

        This method does not do data redistribution. If you need to move data
        around, use Import or Export. 
        """
        return _Tpetra.MultiVector_int_replaceMap(self, *args)


    def reduce(self, *args):
        """
        reduce(MultiVector_int self)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::reduce()

        Sum values of a locally replicated multivector across all processes.

        WARNING:  This method may only be called for locally replicated
        MultiVectors.

        isDistributed() == false 
        """
        return _Tpetra.MultiVector_int_reduce(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector_int self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subCopy(MultiVector_int self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP<
        MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::subCopy(const Teuchos::ArrayView< const size_t > &cols)
        const

        Return a MultiVector with copies of selected columns. 
        """
        return _Tpetra.MultiVector_int_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector_int self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        subView(MultiVector_int self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::subView(const Teuchos::ArrayView< const size_t > &cols)
        const

        Return a const MultiVector with const views of selected columns. 
        """
        return _Tpetra.MultiVector_int_subView(self, *args)


    def subViewNonConst(self, *args):
        """
        subViewNonConst(MultiVector_int self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subViewNonConst(MultiVector_int self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::subViewNonConst(const Teuchos::ArrayView< const
        size_t > &cols)

        Return a MultiVector with views of selected columns. 
        """
        return _Tpetra.MultiVector_int_subViewNonConst(self, *args)


    def offsetViewNonConst(self, *args):
        """
        offsetViewNonConst(MultiVector_int self, Teuchos::RCP< DefaultMapType const > const & subMap, size_t const offset) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::offsetViewNonConst(const Teuchos::RCP< const map_type
        > &subMap, const size_t offset)

        Return a nonconst view of a subset of rows.

        Return a nonconst (modifiable) view of this MultiVector consisting of
        a subset of the rows, as specified by an offset and a subset Map of
        this MultiVector's current row Map. If you want X1 or X2 to be const
        (nonmodifiable) views, use offsetView() with the same arguments.
        "View" means "alias": if the original (this) MultiVector's data
        change, the view will see the changed data, and if the view's data
        change, the original MultiVector will see the changed data.

        Parameters:
        -----------

        subMap:  [in] The row Map for the new MultiVector. This must be a
        subset Map of this MultiVector's row Map.

        offset:  [in] The local row offset at which to start the view.

        See the documentation of offsetView() for a code example and an
        explanation of edge cases. 
        """
        return _Tpetra.MultiVector_int_offsetViewNonConst(self, *args)


    def getVector(self, *args):
        """
        getVector(MultiVector_int self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getVector(const size_t j) const

        Return a Vector which is a const view of column j. 
        """
        return _Tpetra.MultiVector_int_getVector(self, *args)


    def getVectorNonConst(self, *args):
        """
        getVectorNonConst(MultiVector_int self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::getVectorNonConst(const size_t j)

        Return a Vector which is a nonconst view of column j. 
        """
        return _Tpetra.MultiVector_int_getVectorNonConst(self, *args)


    def getData(self, *args):
        """
        getData(MultiVector_int self, size_t j) -> Teuchos::ArrayRCP< int const >

        Teuchos::ArrayRCP< const Scalar > Tpetra::MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::getData(size_t j) const

        Const view of the local values in a particular vector of this
        multivector. 
        """
        return _Tpetra.MultiVector_int_getData(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(MultiVector_int self, size_t j) -> Teuchos::ArrayRCP< int >

        Teuchos::ArrayRCP< Scalar > Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getDataNonConst(size_t j)

        View of the local values in a particular vector of this multivector.

        """
        return _Tpetra.MultiVector_int_getDataNonConst(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(MultiVector_int self, Teuchos::ArrayView< int > const & A, size_t const LDA)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get1dCopy(const Teuchos::ArrayView< Scalar > &A, const
        size_t LDA) const

        Fill the given array with a copy of this multivector's local values.

        Parameters:
        -----------

        A:  [out] View of the array to fill. We consider A as a matrix with
        column-major storage.

        LDA:  [in] Leading dimension of the matrix A. 
        """
        return _Tpetra.MultiVector_int_get1dCopy(self, *args)


    def get2dCopy(self, *args):
        """
        get2dCopy(MultiVector_int self, Teuchos::ArrayView< Teuchos::ArrayView< int > const > const & ArrayOfPtrs)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get2dCopy(const Teuchos::ArrayView< const
        Teuchos::ArrayView< Scalar > > &ArrayOfPtrs) const

        Fill the given array with a copy of this multivector's local values.

        Parameters:
        -----------

        ArrayOfPtrs:  [out] Array of arrays, one for each column of the
        multivector. On output, we fill ArrayOfPtrs[j] with the data for
        column j of this multivector. 
        """
        return _Tpetra.MultiVector_int_get2dCopy(self, *args)


    def get1dView(self, *args):
        """
        get1dView(MultiVector_int self) -> Teuchos::ArrayRCP< int const >

        Teuchos::ArrayRCP< const Scalar > Tpetra::MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::get1dView() const

        Const persisting (1-D) view of this multivector's local values.

        This method assumes that the columns of the multivector are stored
        contiguously. If not, this method throws std::runtime_error. 
        """
        return _Tpetra.MultiVector_int_get1dView(self, *args)


    def get2dView(self, *args):
        """
        get2dView(MultiVector_int self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< int const > >

        Teuchos::ArrayRCP< Teuchos::ArrayRCP< const Scalar > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get2dView() const

        Return const persisting pointers to values. 
        """
        return _Tpetra.MultiVector_int_get2dView(self, *args)


    def get1dViewNonConst(self, *args):
        """
        get1dViewNonConst(MultiVector_int self) -> Teuchos::ArrayRCP< int >

        Teuchos::ArrayRCP< Scalar > Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::get1dViewNonConst()

        Nonconst persisting (1-D) view of this multivector's local values.

        This method assumes that the columns of the multivector are stored
        contiguously. If not, this method throws std::runtime_error. 
        """
        return _Tpetra.MultiVector_int_get1dViewNonConst(self, *args)


    def get2dViewNonConst(self, *args):
        """
        get2dViewNonConst(MultiVector_int self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< int > >

        Teuchos::ArrayRCP< Teuchos::ArrayRCP< Scalar > > Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::get2dViewNonConst()

        Return non-const persisting pointers to values. 
        """
        return _Tpetra.MultiVector_int_get2dViewNonConst(self, *args)


    def dot(self, *args):
        """
        dot(MultiVector_int self, MultiVector_int A, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type > const & dots)
        dot(MultiVector_int self, MultiVector_int A, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & dots)

        std::enable_if< !
        (std::is_same<dot_type, T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::dot(const
        MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > &A,
        const Kokkos::View< T *, device_type > &dots) const

        Compute the dot product of each corresponding pair of vectors
        (columns) in A and B, storing the result in a device view.

        Parameters:
        -----------

        T:  The output type of the dot products.

        This method only exists if dot_type and T are different types. For
        example, if Scalar and dot_type differ, then this method ensures
        backwards compatibility with the previous interface (that returned dot
        products as Scalar rather than as dot_type). The complicated enable_if
        expression just ensures that the method only exists if dot_type and T
        are different types; the method still returns void, as above. 
        """
        return _Tpetra.MultiVector_int_dot(self, *args)


    def abs(self, *args):
        """
        abs(MultiVector_int self, MultiVector_int A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::abs(const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic > &A)

        Put element-wise absolute values of input Multi-vector in target: A =
        abs(this) 
        """
        return _Tpetra.MultiVector_int_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(MultiVector_int self, MultiVector_int A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::reciprocal(const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &A)

        Put element-wise reciprocal values of input Multi-vector in target,
        this(i,j) = 1/A(i,j). 
        """
        return _Tpetra.MultiVector_int_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector_int self, int const & alpha)
        scale(MultiVector_int self, Teuchos::ArrayView< int const > alpha)
        scale(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const alpha)
        scale(MultiVector_int self, int const & alpha, MultiVector_int A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::scale(const Scalar &alpha, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A)

        Scale in place: this = alpha * A.

        Replace this MultiVector with scaled values of A. This method will
        always multiply, even if alpha is zero. That means, for example, that
        if *this contains NaN entries before calling this method, the NaN
        entries will remain after this method finishes. It is legal for the
        input A to alias this MultiVector. 
        """
        return _Tpetra.MultiVector_int_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector_int self, int const & alpha, MultiVector_int A, int const & beta)
        update(MultiVector_int self, int const & alpha, MultiVector_int A, int const & beta, MultiVector_int B, int const & gamma)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::update(const Scalar &alpha, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A, const Scalar &beta,
        const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        > &B, const Scalar &gamma)

        Update: this = gamma*this + alpha*A + beta*B.

        Update this MultiVector with scaled values of A and B. If gamma is
        zero, overwrite *this unconditionally, even if it contains NaN
        entries. It is legal for the inputs A or B to alias this MultiVector.

        """
        return _Tpetra.MultiVector_int_update(self, *args)


    def norm1(self, *args):
        """
        norm1(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm1(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if< !
        (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm1(const
        Teuchos::ArrayView< T > &norms) const

        Compute the one-norm of each vector (column).

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost norm1() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_int_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm2(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if< !
        (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm2(const
        Teuchos::ArrayView< T > &norms) const

        Compute the two-norm of each vector (column).

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost norm2() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms products as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_int_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        normInf(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if<
        ! (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::normInf(const
        Teuchos::ArrayView< T > &norms) const

        Compute the infinity-norm of each vector (column), storing the result
        in a Teuchos::ArrayView.

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost normInf() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms products as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_int_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type > const & means)

        std::enable_if<! std::is_same<impl_scalar_type, T>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::meanValue(const Teuchos::ArrayView< T > &means) const 
        """
        return _Tpetra.MultiVector_int_meanValue(self, *args)


    def multiply(self, *args):
        """
        multiply(MultiVector_int self, Teuchos::ETransp transA, Teuchos::ETransp transB, int const & alpha, MultiVector_int A, MultiVector_int B, int const & beta)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::multiply(Teuchos::ETransp transA, Teuchos::ETransp transB,
        const Scalar &alpha, const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &A, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &B, const Scalar &beta)

        Matrix-matrix multiplication: this = beta*this + alpha*op(A)*op(B).

        If beta is zero, overwrite *this unconditionally, even if it contains
        NaN entries. This imitates the semantics of analogous BLAS routines
        like DGEMM. 
        """
        return _Tpetra.MultiVector_int_multiply(self, *args)


    def elementWiseMultiply(self, *args):
        """
        elementWiseMultiply(MultiVector_int self, int scalarAB, Vector_int A, MultiVector_int B, int scalarThis)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::elementWiseMultiply(Scalar scalarAB, const Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A, const MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > &B, Scalar
        scalarThis)

        Multiply a Vector A elementwise by a MultiVector B.

        Compute this = scalarThis * this + scalarAB * B @ A where </tt>
        denotes element-wise multiplication. In pseudocode, if C denotes *this
        MultiVector: for all rows i and columns j of C.

        B must have the same dimensions as *this, while A must have the same
        number of rows but a single column.

        We do not require that A, B, and *this have compatible Maps, as long
        as the number of rows in A, B, and *this on each process is the same.
        For example, one or more of these vectors might have a locally
        replicated Map, or a Map with a local communicator ( MPI_COMM_SELF).
        This case may occur in block relaxation algorithms when applying a
        diagonal scaling. 
        """
        return _Tpetra.MultiVector_int_elementWiseMultiply(self, *args)


    def getNumVectors(self, *args):
        """
        getNumVectors(MultiVector_int self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getNumVectors() const

        Number of columns in the multivector. 
        """
        return _Tpetra.MultiVector_int_getNumVectors(self, *args)


    def getLocalLength(self, *args):
        """
        getLocalLength(MultiVector_int self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getLocalLength() const

        Local number of rows on the calling process. 
        """
        return _Tpetra.MultiVector_int_getLocalLength(self, *args)


    def getGlobalLength(self, *args):
        """
        getGlobalLength(MultiVector_int self) -> Tpetra::global_size_t

        global_size_t Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getGlobalLength() const

        Global number of rows in the multivector. 
        """
        return _Tpetra.MultiVector_int_getGlobalLength(self, *args)


    def getStride(self, *args):
        """
        getStride(MultiVector_int self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getStride() const

        Stride between columns in the multivector.

        This is only meaningful if  isConstantStride() returns true.

        WARNING:  This may be different on different processes. 
        """
        return _Tpetra.MultiVector_int_getStride(self, *args)


    def isConstantStride(self, *args):
        """
        isConstantStride(MultiVector_int self) -> bool

        bool
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::isConstantStride() const

        Whether this multivector has constant stride between columns.

        WARNING:  This may be different on different processes. 
        """
        return _Tpetra.MultiVector_int_isConstantStride(self, *args)


    def description(self, *args):
        """
        description(MultiVector_int self) -> std::string

        std::string
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::description() const

        A simple one-line description of this object. 
        """
        return _Tpetra.MultiVector_int_description(self, *args)


    def describe(self, *args):
        """
        describe(MultiVector_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::describe(Teuchos::FancyOStream &out, const
        Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print the object with the given verbosity level to a FancyOStream.

        Parameters:
        -----------

        out:  [out] Output stream to which to print. For verbosity levels
        VERB_LOW and lower, only the process with rank 0 ("Proc 0") in the
        MultiVector's communicator prints. For verbosity levels strictly
        higher than VERB_LOW, all processes in the communicator need to be
        able to print to the output stream.

        verbLevel:  [in] Verbosity level. The default verbosity
        (verbLevel=VERB_DEFAULT) is VERB_LOW.

        The amount and content of what this method prints depends on the
        verbosity level. In the list below, each higher level includes all the
        content of the previous levels, as well as its own content.

        VERB_LOW: Only Proc 0 prints; it prints the same thing as
        description().

        VERB_MEDIUM: Each process prints its local length (the number of rows
        that it owns).

        VERB_HIGH: Each process prints whether the multivector has constant
        stride (see  isConstantStride()), and if so, what that stride is.
        (Stride may differ on different processes.)

        VERB_EXTREME: Each process prints the values in its local part of the
        multivector. This will print out as many rows of data as the global
        number of rows in the multivector, so beware. 
        """
        return _Tpetra.MultiVector_int_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """
        removeEmptyProcessesInPlace(MultiVector_int self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & newMap)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::removeEmptyProcessesInPlace(const Teuchos::RCP< const
        map_type > &newMap)

        Remove processes owning zero rows from the Map and their communicator.

        WARNING:  This method is ONLY for use by experts. We highly recommend
        using the nonmember function of the same name defined in
        Tpetra_DistObject_decl.hpp.

        WARNING:  We make NO promises of backwards compatibility. This method
        may change or disappear at any time.

        Parameters:
        -----------

        newMap:  [in] This must be the result of calling the
        removeEmptyProcesses() method on the row Map. If it is not, this
        method's behavior is undefined. This pointer will be null on excluded
        processes. 
        """
        return _Tpetra.MultiVector_int_removeEmptyProcessesInPlace(self, *args)


    def setCopyOrView(self, *args):
        """
        setCopyOrView(MultiVector_int self, Teuchos::DataAccess const copyOrView)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::setCopyOrView(const Teuchos::DataAccess copyOrView)

        Set whether this has copy (copyOrView = Teuchos::Copy) or view
        (copyOrView = Teuchos::View) semantics.

        WARNING:  The Kokkos refactor version of MultiVector only implements
        view semantics. If you attempt to call this method with copyOrView ==
        Teuchos::Copy, it will throw std::invalid_argument.

        WARNING:  This method is only for expert use. It may change or
        disappear at any time. 
        """
        return _Tpetra.MultiVector_int_setCopyOrView(self, *args)


    def getCopyOrView(self, *args):
        """
        getCopyOrView(MultiVector_int self) -> Teuchos::DataAccess

        Teuchos::DataAccess Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getCopyOrView() const

        Get whether this has copy (copyOrView = Teuchos::Copy) or view
        (copyOrView = Teuchos::View) semantics.

        The Kokkos refactor version of MultiVector only implements view
        semantics. This is not currently true for the "classic" version of
        MultiVector, though that will change in the near future.

        WARNING:  This method is only for expert use. It may change or
        disappear at any time. 
        """
        return _Tpetra.MultiVector_int_getCopyOrView(self, *args)


    def assign(self, *args):
        """
        assign(MultiVector_int self, MultiVector_int src)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::assign(const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &src)

        Copy the contents of src into *this (deep copy).

        Parameters:
        -----------

        src:  [in] Source MultiVector (input of the deep copy).

        ! src.getMap ().is_null () && ! this->getMap ().is_null ()

        src.getMap ()->isCompatible (* (this->getMap ())

        Any outstanding views of src or *this remain valid.

        To implementers: The postcondition implies that the implementation
        must not reallocate any memory of *this, or otherwise change its
        dimensions. This is not an assignment operator; it does not change
        anything in *this other than the contents of storage. 
        """
        return _Tpetra.MultiVector_int_assign(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(MultiVector_int self) -> PyObject *"""
        return _Tpetra.MultiVector_int__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector_int self) -> PyObject *"""
        return _Tpetra.MultiVector_int___distarray__(self, *args)

MultiVector_int_swigregister = _Tpetra.MultiVector_int_swigregister
MultiVector_int_swigregister(MultiVector_int)


upgradeMultiVectorClass(MultiVector_int)

class Vector_int(MultiVector_int):
    """


    A distributed dense vector.

    Parameters:
    -----------

    Scalar:  The type of each entry of the vector. (You can use real-
    valued or complex-valued types here, unlike in Epetra, where the
    scalar type is always double.)

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type. See the documentation of Map for
    requirements.

    classic:  DO NOT SPECIFY THIS EXPLICITLY. This exists only for
    backwards compatibility. It must always be false.

    This class inherits from MultiVector, and has the same template
    parameters. A Vector is a special case of a MultiVector that has only
    one vector (column). It may be used wherever a MultiVector may be
    used. Please see the documentation of MultiVector for more details.

    C++ includes: Tpetra_Vector_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [MultiVector_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_int, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_int, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Vector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, bool const zeroOut=True) -> Vector_int
        __init__(Tpetra::Vector<(int,int,long long,DefaultNodeType)> self, Vector_int source) -> Vector_int
        __init__(Tpetra::Vector<(int,int,long long,DefaultNodeType)> self, Vector_int source, Teuchos::DataAccess const copyOrView) -> Vector_int

        Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::Vector(const
        Teuchos::RCP< const map_type > &map, const dual_view_type &view, const
        dual_view_type &origView)

        Expert mode constructor, that takes a Kokkos::DualView of the Vector's
        data and the "original" Kokkos::DualView of the data, and returns a
        Vector that views those data.

        WARNING:  This constructor is only for expert users. We make no
        promises about backwards compatibility for this interface. It may
        change or go away at any time.  See the documentation of the
        MultiVector (parent class) constructor that takes the same arguments.

        Parameters:
        -----------

        map:  [in] Map describing the distribution of rows.

        view:  [in] View of the data (shallow copy).

        origView:  [in] "Original" view of the data (shallow copy). 
        """
        this = _Tpetra.new_Vector_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Vector_int

    def replaceGlobalValue(self, *args):
        """
        replaceGlobalValue(Vector_int self, long long globalRow, int const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::replaceGlobalValue(const GlobalOrdinal globalRow, const Scalar
        &value) const

        Replace current value at the specified location with specified value.

        globalRow must be a valid global element on this node, according to
        the row map. 
        """
        return _Tpetra.Vector_int_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """
        sumIntoGlobalValue(Vector_int self, long long globalRow, int const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::sumIntoGlobalValue(const GlobalOrdinal globalRow, const Scalar
        &value, const bool atomic=base_type::useAtomicUpdatesByDefault) const

        Add value to existing value, using global (row) index.

        Add the given value to the existing value at row globalRow (a global
        index).

        This method affects the host memory version of the data. If the
        DeviceType template parameter is a device that has two memory spaces,
        and you want to modify the non-host version of the data, you must
        access the device View directly by calling getLocalView(). Please see
        modify(), sync(), and the discussion of DualView semantics elsewhere
        in the documentation.

        Parameters:
        -----------

        globalRow:  [in] Global row index of the entry to modify. This must be
        a valid global row index on the calling process with respect to the
        Vector's Map.

        value:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.Vector_int_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """
        replaceLocalValue(Vector_int self, int myRow, int const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::replaceLocalValue(const LocalOrdinal myRow, const Scalar &value)
        const

        Replace current value at the specified location with specified values.

        localRow must be a valid local element on this node, according to the
        row map. 
        """
        return _Tpetra.Vector_int_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """
        sumIntoLocalValue(Vector_int self, int myRow, int const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::sumIntoLocalValue(const LocalOrdinal myRow, const Scalar &value,
        const bool atomic=base_type::useAtomicUpdatesByDefault) const

        Add value to existing value, using local (row) index.

        Add the given value to the existing value at row localRow (a local
        index).

        This method affects the host memory version of the data. If the
        DeviceType template parameter is a device that has two memory spaces,
        and you want to modify the non-host version of the data, you must
        access the device View directly by calling getLocalView(). Please see
        modify(), sync(), and the discussion of DualView semantics elsewhere
        in the documentation.

        Parameters:
        -----------

        localRow:  [in] Local row index of the entry to modify.

        value:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.Vector_int_sumIntoLocalValue(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(Vector_int self)
        get1dCopy(Vector_int self, Teuchos::ArrayView< int > const & A)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::get1dCopy(const Teuchos::ArrayView< Scalar > &A) const

        Return multi-vector values in user-provided two-dimensional array
        (using Teuchos memory management classes). 
        """
        return _Tpetra.Vector_int_get1dCopy(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(Vector_int self)
        getDataNonConst(Vector_int self) -> Teuchos::ArrayRCP< int >

        Teuchos::ArrayRCP<Scalar> Tpetra::Vector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getDataNonConst()

        View of the local values of this vector. 
        """
        return _Tpetra.Vector_int_getDataNonConst(self, *args)


    def getData(self, *args):
        """
        getData(Vector_int self)
        getData(Vector_int self) -> Teuchos::ArrayRCP< int const >

        Teuchos::ArrayRCP<const Scalar> Tpetra::Vector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getData() const

        Const view of the local values of this vector. 
        """
        return _Tpetra.Vector_int_getData(self, *args)


    def norm2(self, *args):
        """
        norm2(Vector_int self)
        norm2(Vector_int self) -> Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type

        Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::mag_type Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm2() const

        Return the two-norm of this Vector. 
        """
        return _Tpetra.Vector_int_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(Vector_int self)
        normInf(Vector_int self) -> Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type

        Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::mag_type Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::normInf() const

        Return the infinity-norm of this Vector. 
        """
        return _Tpetra.Vector_int_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(Vector_int self)
        meanValue(Vector_int self) -> int

        Scalar
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::meanValue() const

        Compute mean (average) value of this Vector. 
        """
        return _Tpetra.Vector_int_meanValue(self, *args)


    def description(self, *args):
        """
        description(Vector_int self) -> std::string

        std::string
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::description() const

        Return a one-line description of this object. 
        """
        return _Tpetra.Vector_int_description(self, *args)


    def describe(self, *args):
        """
        describe(Vector_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Describe this object in a human-readable way to the given output
        stream.

        You must call this method as a collective over all processes in this
        object's communicator.

        Parameters:
        -----------

        out:  [out] Output stream to which to write. Only Process 0 in this
        object's communicator may write to the output stream.

        verbLevel:  [in] Verbosity level. This also controls whether this
        method does any communication. At verbosity levels higher (greater)
        than Teuchos::VERB_LOW, this method may behave as a collective over
        the object's communicator.

        Teuchos::FancyOStream wraps std::ostream. It adds features like tab
        levels. If you just want to wrap std::cout, try this: 
        """
        return _Tpetra.Vector_int_describe(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(Vector_int self) -> PyObject *"""
        return _Tpetra.Vector_int__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector_int self) -> PyObject *"""
        return _Tpetra.Vector_int___distarray__(self, *args)

Vector_int_swigregister = _Tpetra.Vector_int_swigregister
Vector_int_swigregister(Vector_int)


upgradeVectorClass(Vector_int)

class DistObject_long(SrcDistObject, Teuchos.Describable):
    """


    Base class for distributed Tpetra objects that support data
    redistribution.

    DistObject is a base class for all Tpetra distributed global objects,
    including CrsGraph, CrsMatrix, MultiVector, and Vector. Classes that
    inherit from DistObject work as either the source or the target of an
    Export or Import (parallel redistribution) operation. If you want to
    write a class that can work as the source or target of an Export or
    Import operation, that class must inherit from DistObject.

    Parameters:
    -----------

    LocalOrdinal:  The type of local indices. Same as Map's LocalOrdinal
    template parameter. See Map's documentation for a discussion of the
    types that are valid to use here.

    GlobalOrdinal:  The type of global indices. Same as Map's
    GlobalOrdinal template parameter. See Map's documentation for a
    discussion of the types that are valid to use here.

    Node:  Same as Map's Node template parameter. See Map's documentation
    for a discussion of the types that are valid to use here.

    classic:  DO NOT SET THIS EXPLICITLY. This template parameter only
    exists for backwards compatibility. It must always be false.

    Summary Most Tpetra users will only use this class' methods to perform
    data redistribution for subclasses such as CrsGraph, CrsMatrix,
    MultiVector, and Vector. DistObject provides four methods for
    redistributing data: two versions of  doImport(), and two versions of
    doExport(). Import operations redistribute data from a nonoverlapping
    (one-to-one) distribution to a possibly overlapping distribution.
    Export operations redistribute data from a possibly overlapping
    distribution to a nonoverlapping (one-to-one) distribution. Once you
    have precomputed a data redistribution plan (an Import or Export
    object), you may use the plan to redistribute an input object's data
    into this object, by calling one of these methods. The input object of
    doImport() or  doExport() is always the "source" of the
    redistribution operation, which sends the data. The *this object is
    the target, which receives and combines the data. It has the
    distribution given by this-> getMap(). Forward or reverse
    redistribution modes Both Import and Export operations occur in two
    modes: forward and reverse. Forward mode is the usual case, where you
    are calling a method with its matching plan type (  doImport() for an
    Import plan, or  doExport() for an Export plan). In that case, the
    input DistObject must have the same Map as the source Map of the plan,
    and the target DistObject must have the same Map as the target Map of
    the plan. Reverse mode is also possible, where you call a method with
    the opposite plan type (  doImport() for an Export plan, or
    doExport() for an Import plan). In that case, the source DistObject's
    Map must be the same as the target Map of the plan, and the target
    DistObject's Map must be the same as the source Map of the plan. If
    you call  doImport(), we still call this an Import operation, even if
    you are using an Export plan in reverse. Similarly, if you call
    doExport(), we call this an Export operation.

    Most users will want to use forward mode. However, reverse mode is
    useful for some applications. For example, suppose you are solving a
    nonlinear partial differential equation using the finite element
    method, with Newton's method for the nonlinear equation. When
    assembling into a vector, it is convenient and efficient to do local
    assembly first into a vector with an overlapping distribution, then do
    global assembly via forward mode Export into a vector with a
    nonoverlapping distribution. After the linear solve, you may want to
    bring the resulting nonoverlapping distribution vector back to the
    overlapping distribution for another update phase. This would be a
    reverse mode Import, using the precomputed Export object.

    Another use case for reverse mode is in CrsMatrix, for the transpose
    version of distributed sparse matrix-vector multiply ("mat-vec").
    Non-transpose mat-vec (a function from the domain Map to the range
    Map) does an Import to bring in the source vector's data from the
    domain Map to the column Map of the sparse matrix, and an Export (if
    necessary) to bring the results from the row Map of the sparse matrix
    to the range Map. Transpose mat-vec (a function from the range Map to
    the domain Map) uses these precomputed Import and Export objects in
    reverse mode: first the Export in reverse mode to Import the source
    vector's data to the row Map, and then the Import in reverse mode to
    Export the results to the domain Map. Reverse mode lets us reuse the
    precomputed data redistribution plans for the transpose case. How to
    implement a subclass If you want to implement your own DistObject
    subclass, you have two choices of interface to implement: "old"
    (using Teuchos memory management classes, like Teuchos::ArrayRCP and
    Teuchos::ArrayView) or "new" (using Kokkos memory management
    classes, like Kokkos::View and Kokkos::DualView). Prefer new to old.
    The new interface gives you more options for thread parallelism and
    use of the GPU.

    If you intend to implement the new interface, you must override
    useNewInterface() to return true. In that case, your class must
    override the following methods:  constantNumberOfPackets()

    checkSizes()

    copyAndPermuteNew()

    packAndPrepareNew()

    unpackAndCombineNew()  Comments in the implementation of
    doTransferNew() explain how DistObject uses these methods to pack and
    unpack data for redistribution.

    If you choose to implement the old interface (not recommended), you
    should override the following methods instead:
    constantNumberOfPackets()

    checkSizes()

    copyAndPermute()

    packAndPrepare()

    unpackAndCombine()  In this case, you may also wish to implement
    createViews(), createViewsNonConst(), and releaseViews(). Comments in
    the implementation of doTransfer() explain how DistObject uses all
    these methods to pack and unpack data for redistribution.

    DistObject implements SrcDistObject, because we presume that if an
    object can be the target of an Import or Export, it can also be the
    source of an Import or Export.

    C++ includes: Tpetra_DistObject_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SrcDistObject, Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject_long, name, value)
    __swig_getmethods__ = {}
    for _s in [SrcDistObject, Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject_long, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_DistObject_long

    def doImport(self, *args):
        """
        doImport(DistObject_long self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        doImport(DistObject_long self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::doImport(const SrcDistObject &source, const Export< LocalOrdinal,
        GlobalOrdinal, Node > &exporter, CombineMode CM)

        Import data into this object using an Export object ("reverse
        mode").

        The input DistObject is always the source of the data redistribution
        operation, and the *this object is always the target.

        If you don't know the difference between forward and reverse mode,
        then you probably want forward mode. Use the version of doImport()
        that takes a precomputed Import object in that case.

        Parameters:
        -----------

        source:  [in] The "source" object for redistribution.

        exporter:  [in] Precomputed data redistribution plan. Its target Map
        must be the same as the input DistObject's Map, and its source Map
        must be the same as this-> getMap(). (Note the difference from forward
        mode.)

        CM:  [in] How to combine incoming data with the same global index. 
        """
        return _Tpetra.DistObject_long_doImport(self, *args)


    def doExport(self, *args):
        """
        doExport(DistObject_long self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        doExport(DistObject_long self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::doExport(const SrcDistObject &source, const Import< LocalOrdinal,
        GlobalOrdinal, Node > &importer, CombineMode CM)

        Export data into this object using an Import object ("reverse
        mode").

        The input DistObject is always the source of the data redistribution
        operation, and the *this object is always the target.

        If you don't know the difference between forward and reverse mode,
        then you probably want forward mode. Use the version of doExport()
        that takes a precomputed Export object in that case.

        Parameters:
        -----------

        source:  [in] The "source" object for redistribution.

        importer:  [in] Precomputed data redistribution plan. Its target Map
        must be the same as the input DistObject's Map, and its source Map
        must be the same as this-> getMap(). (Note the difference from forward
        mode.)

        CM:  [in] How to combine incoming data with the same global index. 
        """
        return _Tpetra.DistObject_long_doExport(self, *args)


    def isDistributed(self, *args):
        """
        isDistributed(DistObject_long self) -> bool

        bool
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::isDistributed() const

        Whether this is a globally distributed object.

        For a definition of "globally distributed" (and its opposite,
        "locally replicated"), see the documentation of Map's
        isDistributed() method. 
        """
        return _Tpetra.DistObject_long_isDistributed(self, *args)


    def getMap(self, *args):
        """
        getMap(DistObject_long self) -> Teuchos::RCP< DefaultMapType const >

        virtual
        Teuchos::RCP<const map_type> Tpetra::DistObject< Packet, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getMap() const

        The Map describing the parallel distribution of this object.

        Note that some Tpetra objects might be distributed using multiple Map
        objects. For example, CrsMatrix has both a row Map and a column Map.
        It is up to the subclass to decide which Map to use when invoking the
        DistObject constructor. 
        """
        return _Tpetra.DistObject_long_getMap(self, *args)


    def description(self, *args):
        """
        description(DistObject_long self) -> std::string

        std::string
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::description() const

        One-line descriptiion of this object.

        We declare this method virtual so that subclasses of DistObject may
        override it. 
        """
        return _Tpetra.DistObject_long_description(self, *args)


    def describe(self, *args):
        """
        describe(DistObject_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print a descriptiion of this object to the given output stream.

        We declare this method virtual so that subclasses of Distobject may
        override it. 
        """
        return _Tpetra.DistObject_long_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """
        removeEmptyProcessesInPlace(DistObject_long self, Teuchos::RCP< DefaultMapType const > const & newMap)

        void removeEmptyProcessesInPlace(Teuchos::RCP< Tpetra::DistObject<
        PT, LO, GO, NT > > &input) 
        """
        return _Tpetra.DistObject_long_removeEmptyProcessesInPlace(self, *args)

DistObject_long_swigregister = _Tpetra.DistObject_long_swigregister
DistObject_long_swigregister(DistObject_long)

class MultiVector_long(DistObject_long):
    """


    One or more distributed dense vectors.

    A "multivector" contains one or more dense vectors. All the vectors
    in a multivector have the same distribution of rows in parallel over
    the communicator used to create the multivector. Multivectors
    containing more than one vector are useful for algorithms that solve
    multiple linear systems at once, or that solve for a cluster of
    eigenvalues and their corresponding eigenvectors at once. These
    "block" algorithms often have accuracy or performance advantages
    over corresponding algorithms that solve for only one vector at a
    time. For example, working with multiple vectors at a time allows
    Tpetra to use faster BLAS 3 routines for local computations. It may
    also reduce the number of parallel reductions.

    The Vector class implements the MultiVector interface, so if you only
    wish to work with a single vector at a time, you may simply use Vector
    instead of MultiVector. However, if you are writing solvers or
    preconditioners, you would do better to write to the MultiVector
    interface and always assume that each MultiVector contains more than
    one vector. This will make your solver or preconditioner more
    compatible with other Trilinos packages, and it will also let you
    exploit the performance optimizations mentioned above.

    Parameters:
    -----------

    Scalar:  The type of each entry of the multivector. (You can use real-
    valued or complex-valued types here, unlike in Epetra, where the
    scalar type is always double.)

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type.

    Prerequisites Before reading the rest of this documentation, it helps
    to know a little bit about Kokkos. In particular, you should know
    about execution spaces, memory spaces, and shallow copy semantics. You
    should also know something about the Teuchos memory management
    classes, in particular Teuchos::RCP, though it helps to know a bit
    about Teuchos::ArrayRCP and Teuchos::ArrayView as well. You may also
    want to know about the differences between BLAS 1, 2, and 3
    operations, and learn a little bit about MPI (the Message Passing
    Interface for distributed-memory programming). You won't have to use
    MPI directly to use MultiVector, but it helps to be familiar with the
    general idea of distributed storage of data over a communicator. A
    MultiVector is a view of data A MultiVector is a view of data. A view
    behaves like a pointer; it provides access to the original
    multivector's data without copying the data. This means that the copy
    constructor and assignment operator ( operator=) do shallow copies.
    They do not copy the data; they just copy pointers and other
    "metadata." If you would like to copy a MultiVector into an existing
    MultiVector, call the nonmember function deep_copy(). If you would
    like to create a new MultiVector which is a deep copy of an existing
    MultiVector, call the nonmember function createCopy(), or use the two-
    argument copy constructor with Teuchos::Copy as the second argument.

    Views have the additional property that they automatically handle
    deallocation. They use reference counting for this, much like how
    std::shared_ptr works. That means you do not have to worry about
    "freeing" a MultiVector after it has been created. Furthermore, you
    may pass shallow copies around without needing to worry about which is
    the "master" view of the data. There is no "master" view of the
    data; when the last view falls out of scope, the data will be
    deallocated.

    This is what the documentation means when it speaks of view semantics.
    The opposite of that is copy or container semantics, where the copy
    constructor and operator= do deep copies (of the data). We say that
    "std::vector has container semantics," and "MultiVector has view
    semantics."

    MultiVector also has "subview" methods that give results analogous
    to the Kokkos::subview() function. That is, they return a MultiVector
    which views some subset of another MultiVector's rows and columns. The
    subset of columns in a view need not be contiguous. For example, given
    a multivector X with 43 columns, it is possible to have a multivector
    Y which is a view of columns 1, 3, and 42 (zero-based indices) of X.
    We call such multivectors noncontiguous. They have the the property
    that isConstantStride() returns false.

    Noncontiguous multivectors lose some performance advantages. For
    example, local computations may be slower, since Tpetra cannot use
    BLAS 3 routines (e.g., matrix-matrix multiply) on a noncontiguous
    multivectors without copying into temporary contiguous storage. For
    performance reasons, if you get a Kokkos::View of a noncontiguous
    MultiVector's local data, it does not correspond to the columns that
    the MultiVector views. DualView semantics  Tpetra was designed to
    perform well on many different kinds of computers. Some computers have
    different memory spaces. For example, GPUs (Graphics Processing Units)
    by NVIDIA have "device memory" and "host memory." The GPU has
    faster access to device memory than host memory, but usually there is
    less device memory than host memory. Intel's "Knights Landing"
    architecture has two different memory spaces, also with different
    capacity and performance characteristics. Some architectures let the
    processor address memory in any space, possibly with a performance
    penalty. Others can only access data in certain spaces, and require a
    special system call to copy memory between spaces.

    The Kokkos package provides abstractions for handling multiple memory
    spaces. In particular, Kokkos::DualView lets users "mirror" data
    that live in one space, with data in another space. It also lets users
    manually mark data in one space as modified ( modify()), and
    synchronize ( sync()) data from one space to another. The latter only
    actually copies if the data have been marked as modified. Users can
    access data in a particular space by calling view(). All three of
    these methods modify(), sync(), and view() are templated on the memory
    space. This is how users select the memory space on which they want
    the method to act.

    MultiVector implements "DualView semantics." This means that it
    implements the above three operations:  modify(): Mark data in a
    memory space as modified (or about to be modified)

    sync(): If data in the target memory space are least recently modified
    compared with the other space, copy data to the target memory space

    getLocalView(): Return a Kokkos::View of the data in a given memory
    space

    If your computer only has one memory space, as with conventional
    single-core or multicore processors, you don't have to worry about
    this. You can ignore the modify() and sync() methods in that case. How
    to access the local data The getLocalView() method for getting a
    Kokkos::View is the main way to access a MultiVector's local data. If
    you want to read or write the actual values in a multivector, this is
    what you want. The resulting Kokkos::View behaves like a 2-D array.
    You can address it using an index pair (i,j), where i is the local row
    index, and j is the column index.

    MultiVector also has methods that return an Teuchos::ArrayRCP<Scalar>
    ("1-D view"), or a Teuchos::ArrayRCP<Teuchos::ArrayRCP<Scalar> >
    ("2-D view"). These exist only for backwards compatibility, and also
    give access to the local data.

    All of these views only view local data. This means that the
    corresponding rows of the multivector are owned by the calling (MPI)
    process. You may not use these methods to access remote data, that is,
    rows that do not belong to the calling process.

    MultiVector's public interface also has methods for modifying local
    data, like sumIntoLocalValue() and replaceGlobalValue(). These methods
    act on host data only. To access or modify device data, you must get
    the Kokkos::View and work with it directly. Why won't you give me a
    raw pointer?  Tpetra was designed to allow different data
    representations underneath the same interface. This lets Tpetra run
    correctly and efficiently on many different kinds of hardware. These
    different kinds of hardware all have in common the following: Data
    layout matters a lot for performance

    The right layout for your data depends on the hardware

    Data may be distributed over different memory spaces in hardware, and
    efficient code must respect this, whether or not the programming model
    presents the different memories as a single address space

    Copying between different data layouts or memory spaces is expensive
    and should be avoided whenever possible

    Optimal data layout may require control over initialization of storage
    These conclusions have practical consequences for the MultiVector
    interface. In particular, we have deliberately made it difficult for
    you to access data directly by raw pointer. This is because the
    underlying layout may not be what you expect. The memory might not
    even be accessible from the host CPU. Instead, we give access through
    a Kokkos::View, which behaves like a 2-D array. You can ask the
    Kokkos::View for a raw pointer by calling its ptr_on_device() method,
    but then you are responsible for understanding its layout in memory.
    Parallel distribution of data A MultiVector's rows are distributed
    over processes in its (row) Map's communicator. A MultiVector is a
    DistObject; the Map of the DistObject tells which process in the
    communicator owns which rows. This means that you may use Import and
    Export operations to migrate between different distributions. Please
    refer to the documentation of Map, Import, and Export for more
    information.

    MultiVector includes methods that perform parallel all-reduces. These
    include inner products and various kinds of norms. All of these
    methods have the same blocking semantics as MPI_Allreduce.

    WARNING:  Some computational methods, such as inner products and
    norms, may return incorrect results if the MultiVector's Map is
    overlapping (not one-to-one) but not locally replicated. That is, if
    some but not all rows are shared by more than one process in the
    communicator, then inner products and norms may be wrong. This
    behavior may change in future releases.

    C++ includes: Tpetra_MultiVector_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector_long, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector_long, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, size_t const numVecs, bool const zeroOut=True) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, MultiVector_long source) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, MultiVector_long source, Teuchos::DataAccess const copyOrView) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, Teuchos::ArrayView< long long const > const & A, size_t const LDA, size_t const NumVectors) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map, Teuchos::ArrayView< Teuchos::ArrayView< long long const > const > const & ArrayOfPtrs, size_t const NumVectors) -> MultiVector_long

        Tpetra::MultiVector< Scalar, LO, GO, Node, classic
        >::MultiVector(const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic > &X, const map_type &subMap, const size_t offset=0)

        "Offset view" constructor; make a view of a contiguous subset of
        rows on each process.

        Return a view of the MultiVector X, which views a subset of the rows
        of X. Specify the subset by a subset Map of this MultiVector's current
        row Map, and an optional (local) offset. "View" means "alias": if
        the original (this) MultiVector's data change, the view will see the
        changed data.

        Parameters:
        -----------

        X:  [in] The MultiVector to view.

        subMap:  [in] The row Map for the new MultiVector. This must be a
        subset Map of the input MultiVector's row Map.

        offset:  [in] The local row offset at which to start the view.

        Suppose that you have a MultiVector X, and you want to view X, on all
        processes in X's (MPI) communicator, as split into two row blocks X1
        and X2. One could express this in Matlab notation as X = [X1; X2],
        except that here, X1 and X2 are views into X, rather than copies of
        X's data. This method assumes that the local indices of X1 and X2 are
        each contiguous, and that the local indices of X2 follow those of X1.
        If that is not the case, you cannot use views to divide X into blocks
        like this; you must instead use the Import or Export functionality,
        which copies the relevant rows of X.

        Here is how you would construct the views X1 and X2.

        It is legal, in the above example, for X1 or X2 to have zero local
        rows on any or all process(es). In that case, the corresponding Map
        must have zero local entries on that / those process(es). In
        particular, if X2 has zero local rows on a process, then the
        corresponding offset on that process would be the number of local rows
        in X (and therefore in X1) on that process. This is the only case in
        which the sum of the local number of entries in subMap (in this case,
        zero) and the offset may equal the number of local entries in *this.

        """
        this = _Tpetra.new_MultiVector_long(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_MultiVector_long

    def replaceGlobalValue(self, *args):
        """
        replaceGlobalValue(MultiVector_long self, long long globalRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceGlobalValue(GlobalOrdinal globalRow, size_t col,
        const T &value) const

        Like the above replaceGlobalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        This method does not have an "atomic" option like
        sumIntoGlobalValue. This is deliberate. Replacement is not
        commutative, unlike += (modulo rounding error). Concurrent calls to
        replaceGlobalValue on different threads that modify the same entry/ies
        have undefined results. (It's not just that one thread might win; it's
        that the value might get messed up.)

        Parameters:
        -----------

        gblRow:  [in] Global row index of the entry to modify. This must be a
        valid global row index on the calling process with respect to the
        MultiVector's Map.

        col:  [in] Column index of the entry to modify.

        value:  [in] Incoming value to add to the entry. 
        """
        return _Tpetra.MultiVector_long_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """
        sumIntoGlobalValue(MultiVector_long self, long long globalRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::sumIntoGlobalValue(const GlobalOrdinal gblRow, const size_t
        col, const T &val, const bool atomic=useAtomicUpdatesByDefault) const

        Like the above sumIntoGlobalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        Parameters:
        -----------

        gblRow:  [in] Global row index of the entry to modify. This must be a
        valid global row index on the calling process with respect to the
        MultiVector's Map.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.MultiVector_long_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """
        replaceLocalValue(MultiVector_long self, int localRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceLocalValue(const LocalOrdinal lclRow, const size_t
        col, const T &val) const

        Like the above replaceLocalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        This method does not have an "atomic" option like sumIntoLocalValue.
        This is deliberate. Replacement is not commutative, unlike += (modulo
        rounding error). Concurrent calls to replaceLocalValue on different
        threads that modify the same entry/ies have undefined results. (It's
        not just that one thread might win; it's that the value might get
        messed up.)

        Parameters:
        -----------

        lclRow:  [in] Local row index of the entry to modify. Must be a valid
        local index in this MultiVector's Map on the calling process.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry. 
        """
        return _Tpetra.MultiVector_long_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """
        sumIntoLocalValue(MultiVector_long self, int localRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::sumIntoLocalValue(const LocalOrdinal lclRow, const size_t
        col, const T &val, const bool atomic=useAtomicUpdatesByDefault) const

        Like the above sumIntoLocalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        Parameters:
        -----------

        lclRow:  [in] Local row index of the entry to modify.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.MultiVector_long_sumIntoLocalValue(self, *args)


    def putScalar(self, *args):
        """
        putScalar(MultiVector_long self, long long const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::putScalar(const T &value)

        Set all values in the multivector with the given value.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U. 
        """
        return _Tpetra.MultiVector_long_putScalar(self, *args)


    def randomize(self, *args):
        """
        randomize(MultiVector_long self)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::randomize(const Scalar &minVal, const Scalar &maxVal)

        Set all values in the multivector to pseudorandom numbers in the given
        range.

        Do not expect repeatable results.

        Behavior of this method may or may not depend on external use of the C
        library routines srand() and rand(). In particular, setting the seed
        there may not affect it here.

        WARNING:  This method does not promise to use a distributed-memory
        parallel pseudorandom number generator. Corresponding values on
        different processes might be correlated. It also does not promise to
        use a high-quality pseudorandom number generator within each process.

        """
        return _Tpetra.MultiVector_long_randomize(self, *args)


    def replaceMap(self, *args):
        """
        replaceMap(MultiVector_long self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceMap(const Teuchos::RCP< const map_type > &map)

        Replace the underlying Map in place.

        WARNING:  The normal use case of this method, with an input Map that
        is compatible with the object's current Map and has the same
        communicator, is safe. However, if the input Map has a different
        communicator (with a different number of processes, in particular)
        than this object's current Map, the semantics of this method are
        tricky. We recommend that only experts try the latter use case.

        If the new Map's communicator is similar to the original Map's
        communicator, then the original Map and new Map must be compatible:
        map->isCompatible (this->getMap ()). "Similar" means that the
        communicators have the same number of processes, though these need not
        be in the same order (have the same assignments of ranks) or represent
        the same communication contexts. It means the same thing as the
        MPI_SIMILAR return value of MPI_COMM_COMPARE. See MPI 3.0 Standard,
        Section 6.4.1.

        If the new Map's communicator contains more processes than the
        original Map's communicator, then the projection of the original Map
        onto the new communicator must be compatible with the new Map.

        If the new Map's communicator contains fewer processes than the
        original Map's communicator, then the projection of the new Map onto
        the original communicator must be compatible with the original Map.
        This method replaces this object's Map with the given Map. This
        relabels the rows of the multivector using the global IDs in the input
        Map. Thus, it implicitly applies a permutation, without actually
        moving data. If the new Map's communicator has more processes than the
        original Map's communicator, it "projects" the MultiVector onto the
        new Map by filling in missing rows with zeros. If the new Map's
        communicator has fewer processes than the original Map's communicator,
        the method "forgets about" any rows that do not exist in the new
        Map. (It mathematical terms, if one considers a MultiVector as a
        function from one vector space to another, this operation restricts
        the range.)

        This method must always be called collectively on the communicator
        with the largest number of processes: either this object's current
        communicator ( this-> getMap()->getComm()), or the new Map's
        communicator ( map->getComm()). If the new Map's communicator has
        fewer processes, then the new Map must be null on processes excluded
        from the original communicator, and the current Map must be nonnull on
        all processes. If the new Map has more processes, then it must be
        nonnull on all those processes, and the original Map must be null on
        those processes which are not in the new Map's communicator. (The
        latter case can only happen to a MultiVector to which a replaceMap()
        operation has happened before.)

        WARNING:  This method must always be called as a collective operation
        on all processes in the original communicator ( this->getMap
        ()->getComm ()). We reserve the right to do checking in debug mode
        that requires this method to be called collectively in order not to
        deadlock.

        This method does not do data redistribution. If you need to move data
        around, use Import or Export. 
        """
        return _Tpetra.MultiVector_long_replaceMap(self, *args)


    def reduce(self, *args):
        """
        reduce(MultiVector_long self)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::reduce()

        Sum values of a locally replicated multivector across all processes.

        WARNING:  This method may only be called for locally replicated
        MultiVectors.

        isDistributed() == false 
        """
        return _Tpetra.MultiVector_long_reduce(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector_long self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subCopy(MultiVector_long self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP<
        MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::subCopy(const Teuchos::ArrayView< const size_t > &cols)
        const

        Return a MultiVector with copies of selected columns. 
        """
        return _Tpetra.MultiVector_long_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector_long self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        subView(MultiVector_long self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::subView(const Teuchos::ArrayView< const size_t > &cols)
        const

        Return a const MultiVector with const views of selected columns. 
        """
        return _Tpetra.MultiVector_long_subView(self, *args)


    def subViewNonConst(self, *args):
        """
        subViewNonConst(MultiVector_long self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subViewNonConst(MultiVector_long self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::subViewNonConst(const Teuchos::ArrayView< const
        size_t > &cols)

        Return a MultiVector with views of selected columns. 
        """
        return _Tpetra.MultiVector_long_subViewNonConst(self, *args)


    def offsetViewNonConst(self, *args):
        """
        offsetViewNonConst(MultiVector_long self, Teuchos::RCP< DefaultMapType const > const & subMap, size_t const offset) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::offsetViewNonConst(const Teuchos::RCP< const map_type
        > &subMap, const size_t offset)

        Return a nonconst view of a subset of rows.

        Return a nonconst (modifiable) view of this MultiVector consisting of
        a subset of the rows, as specified by an offset and a subset Map of
        this MultiVector's current row Map. If you want X1 or X2 to be const
        (nonmodifiable) views, use offsetView() with the same arguments.
        "View" means "alias": if the original (this) MultiVector's data
        change, the view will see the changed data, and if the view's data
        change, the original MultiVector will see the changed data.

        Parameters:
        -----------

        subMap:  [in] The row Map for the new MultiVector. This must be a
        subset Map of this MultiVector's row Map.

        offset:  [in] The local row offset at which to start the view.

        See the documentation of offsetView() for a code example and an
        explanation of edge cases. 
        """
        return _Tpetra.MultiVector_long_offsetViewNonConst(self, *args)


    def getVector(self, *args):
        """
        getVector(MultiVector_long self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getVector(const size_t j) const

        Return a Vector which is a const view of column j. 
        """
        return _Tpetra.MultiVector_long_getVector(self, *args)


    def getVectorNonConst(self, *args):
        """
        getVectorNonConst(MultiVector_long self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::getVectorNonConst(const size_t j)

        Return a Vector which is a nonconst view of column j. 
        """
        return _Tpetra.MultiVector_long_getVectorNonConst(self, *args)


    def getData(self, *args):
        """
        getData(MultiVector_long self, size_t j) -> Teuchos::ArrayRCP< long long const >

        Teuchos::ArrayRCP< const Scalar > Tpetra::MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::getData(size_t j) const

        Const view of the local values in a particular vector of this
        multivector. 
        """
        return _Tpetra.MultiVector_long_getData(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(MultiVector_long self, size_t j) -> Teuchos::ArrayRCP< long long >

        Teuchos::ArrayRCP< Scalar > Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getDataNonConst(size_t j)

        View of the local values in a particular vector of this multivector.

        """
        return _Tpetra.MultiVector_long_getDataNonConst(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(MultiVector_long self, Teuchos::ArrayView< long long > const & A, size_t const LDA)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get1dCopy(const Teuchos::ArrayView< Scalar > &A, const
        size_t LDA) const

        Fill the given array with a copy of this multivector's local values.

        Parameters:
        -----------

        A:  [out] View of the array to fill. We consider A as a matrix with
        column-major storage.

        LDA:  [in] Leading dimension of the matrix A. 
        """
        return _Tpetra.MultiVector_long_get1dCopy(self, *args)


    def get2dCopy(self, *args):
        """
        get2dCopy(MultiVector_long self, Teuchos::ArrayView< Teuchos::ArrayView< long long > const > const & ArrayOfPtrs)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get2dCopy(const Teuchos::ArrayView< const
        Teuchos::ArrayView< Scalar > > &ArrayOfPtrs) const

        Fill the given array with a copy of this multivector's local values.

        Parameters:
        -----------

        ArrayOfPtrs:  [out] Array of arrays, one for each column of the
        multivector. On output, we fill ArrayOfPtrs[j] with the data for
        column j of this multivector. 
        """
        return _Tpetra.MultiVector_long_get2dCopy(self, *args)


    def get1dView(self, *args):
        """
        get1dView(MultiVector_long self) -> Teuchos::ArrayRCP< long long const >

        Teuchos::ArrayRCP< const Scalar > Tpetra::MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::get1dView() const

        Const persisting (1-D) view of this multivector's local values.

        This method assumes that the columns of the multivector are stored
        contiguously. If not, this method throws std::runtime_error. 
        """
        return _Tpetra.MultiVector_long_get1dView(self, *args)


    def get2dView(self, *args):
        """
        get2dView(MultiVector_long self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< long long const > >

        Teuchos::ArrayRCP< Teuchos::ArrayRCP< const Scalar > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get2dView() const

        Return const persisting pointers to values. 
        """
        return _Tpetra.MultiVector_long_get2dView(self, *args)


    def get1dViewNonConst(self, *args):
        """
        get1dViewNonConst(MultiVector_long self) -> Teuchos::ArrayRCP< long long >

        Teuchos::ArrayRCP< Scalar > Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::get1dViewNonConst()

        Nonconst persisting (1-D) view of this multivector's local values.

        This method assumes that the columns of the multivector are stored
        contiguously. If not, this method throws std::runtime_error. 
        """
        return _Tpetra.MultiVector_long_get1dViewNonConst(self, *args)


    def get2dViewNonConst(self, *args):
        """
        get2dViewNonConst(MultiVector_long self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< long long > >

        Teuchos::ArrayRCP< Teuchos::ArrayRCP< Scalar > > Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::get2dViewNonConst()

        Return non-const persisting pointers to values. 
        """
        return _Tpetra.MultiVector_long_get2dViewNonConst(self, *args)


    def dot(self, *args):
        """
        dot(MultiVector_long self, MultiVector_long A, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type > const & dots)
        dot(MultiVector_long self, MultiVector_long A, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & dots)

        std::enable_if< !
        (std::is_same<dot_type, T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::dot(const
        MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > &A,
        const Kokkos::View< T *, device_type > &dots) const

        Compute the dot product of each corresponding pair of vectors
        (columns) in A and B, storing the result in a device view.

        Parameters:
        -----------

        T:  The output type of the dot products.

        This method only exists if dot_type and T are different types. For
        example, if Scalar and dot_type differ, then this method ensures
        backwards compatibility with the previous interface (that returned dot
        products as Scalar rather than as dot_type). The complicated enable_if
        expression just ensures that the method only exists if dot_type and T
        are different types; the method still returns void, as above. 
        """
        return _Tpetra.MultiVector_long_dot(self, *args)


    def abs(self, *args):
        """
        abs(MultiVector_long self, MultiVector_long A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::abs(const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic > &A)

        Put element-wise absolute values of input Multi-vector in target: A =
        abs(this) 
        """
        return _Tpetra.MultiVector_long_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(MultiVector_long self, MultiVector_long A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::reciprocal(const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &A)

        Put element-wise reciprocal values of input Multi-vector in target,
        this(i,j) = 1/A(i,j). 
        """
        return _Tpetra.MultiVector_long_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector_long self, long long const & alpha)
        scale(MultiVector_long self, Teuchos::ArrayView< long long const > alpha)
        scale(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const alpha)
        scale(MultiVector_long self, long long const & alpha, MultiVector_long A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::scale(const Scalar &alpha, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A)

        Scale in place: this = alpha * A.

        Replace this MultiVector with scaled values of A. This method will
        always multiply, even if alpha is zero. That means, for example, that
        if *this contains NaN entries before calling this method, the NaN
        entries will remain after this method finishes. It is legal for the
        input A to alias this MultiVector. 
        """
        return _Tpetra.MultiVector_long_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector_long self, long long const & alpha, MultiVector_long A, long long const & beta)
        update(MultiVector_long self, long long const & alpha, MultiVector_long A, long long const & beta, MultiVector_long B, long long const & gamma)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::update(const Scalar &alpha, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A, const Scalar &beta,
        const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        > &B, const Scalar &gamma)

        Update: this = gamma*this + alpha*A + beta*B.

        Update this MultiVector with scaled values of A and B. If gamma is
        zero, overwrite *this unconditionally, even if it contains NaN
        entries. It is legal for the inputs A or B to alias this MultiVector.

        """
        return _Tpetra.MultiVector_long_update(self, *args)


    def norm1(self, *args):
        """
        norm1(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm1(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if< !
        (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm1(const
        Teuchos::ArrayView< T > &norms) const

        Compute the one-norm of each vector (column).

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost norm1() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_long_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm2(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if< !
        (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm2(const
        Teuchos::ArrayView< T > &norms) const

        Compute the two-norm of each vector (column).

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost norm2() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms products as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_long_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        normInf(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if<
        ! (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::normInf(const
        Teuchos::ArrayView< T > &norms) const

        Compute the infinity-norm of each vector (column), storing the result
        in a Teuchos::ArrayView.

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost normInf() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms products as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_long_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type > const & means)

        std::enable_if<! std::is_same<impl_scalar_type, T>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::meanValue(const Teuchos::ArrayView< T > &means) const 
        """
        return _Tpetra.MultiVector_long_meanValue(self, *args)


    def multiply(self, *args):
        """
        multiply(MultiVector_long self, Teuchos::ETransp transA, Teuchos::ETransp transB, long long const & alpha, MultiVector_long A, MultiVector_long B, long long const & beta)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::multiply(Teuchos::ETransp transA, Teuchos::ETransp transB,
        const Scalar &alpha, const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &A, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &B, const Scalar &beta)

        Matrix-matrix multiplication: this = beta*this + alpha*op(A)*op(B).

        If beta is zero, overwrite *this unconditionally, even if it contains
        NaN entries. This imitates the semantics of analogous BLAS routines
        like DGEMM. 
        """
        return _Tpetra.MultiVector_long_multiply(self, *args)


    def elementWiseMultiply(self, *args):
        """
        elementWiseMultiply(MultiVector_long self, long long scalarAB, Vector_long A, MultiVector_long B, long long scalarThis)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::elementWiseMultiply(Scalar scalarAB, const Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A, const MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > &B, Scalar
        scalarThis)

        Multiply a Vector A elementwise by a MultiVector B.

        Compute this = scalarThis * this + scalarAB * B @ A where </tt>
        denotes element-wise multiplication. In pseudocode, if C denotes *this
        MultiVector: for all rows i and columns j of C.

        B must have the same dimensions as *this, while A must have the same
        number of rows but a single column.

        We do not require that A, B, and *this have compatible Maps, as long
        as the number of rows in A, B, and *this on each process is the same.
        For example, one or more of these vectors might have a locally
        replicated Map, or a Map with a local communicator ( MPI_COMM_SELF).
        This case may occur in block relaxation algorithms when applying a
        diagonal scaling. 
        """
        return _Tpetra.MultiVector_long_elementWiseMultiply(self, *args)


    def getNumVectors(self, *args):
        """
        getNumVectors(MultiVector_long self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getNumVectors() const

        Number of columns in the multivector. 
        """
        return _Tpetra.MultiVector_long_getNumVectors(self, *args)


    def getLocalLength(self, *args):
        """
        getLocalLength(MultiVector_long self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getLocalLength() const

        Local number of rows on the calling process. 
        """
        return _Tpetra.MultiVector_long_getLocalLength(self, *args)


    def getGlobalLength(self, *args):
        """
        getGlobalLength(MultiVector_long self) -> Tpetra::global_size_t

        global_size_t Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getGlobalLength() const

        Global number of rows in the multivector. 
        """
        return _Tpetra.MultiVector_long_getGlobalLength(self, *args)


    def getStride(self, *args):
        """
        getStride(MultiVector_long self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getStride() const

        Stride between columns in the multivector.

        This is only meaningful if  isConstantStride() returns true.

        WARNING:  This may be different on different processes. 
        """
        return _Tpetra.MultiVector_long_getStride(self, *args)


    def isConstantStride(self, *args):
        """
        isConstantStride(MultiVector_long self) -> bool

        bool
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::isConstantStride() const

        Whether this multivector has constant stride between columns.

        WARNING:  This may be different on different processes. 
        """
        return _Tpetra.MultiVector_long_isConstantStride(self, *args)


    def description(self, *args):
        """
        description(MultiVector_long self) -> std::string

        std::string
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::description() const

        A simple one-line description of this object. 
        """
        return _Tpetra.MultiVector_long_description(self, *args)


    def describe(self, *args):
        """
        describe(MultiVector_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::describe(Teuchos::FancyOStream &out, const
        Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print the object with the given verbosity level to a FancyOStream.

        Parameters:
        -----------

        out:  [out] Output stream to which to print. For verbosity levels
        VERB_LOW and lower, only the process with rank 0 ("Proc 0") in the
        MultiVector's communicator prints. For verbosity levels strictly
        higher than VERB_LOW, all processes in the communicator need to be
        able to print to the output stream.

        verbLevel:  [in] Verbosity level. The default verbosity
        (verbLevel=VERB_DEFAULT) is VERB_LOW.

        The amount and content of what this method prints depends on the
        verbosity level. In the list below, each higher level includes all the
        content of the previous levels, as well as its own content.

        VERB_LOW: Only Proc 0 prints; it prints the same thing as
        description().

        VERB_MEDIUM: Each process prints its local length (the number of rows
        that it owns).

        VERB_HIGH: Each process prints whether the multivector has constant
        stride (see  isConstantStride()), and if so, what that stride is.
        (Stride may differ on different processes.)

        VERB_EXTREME: Each process prints the values in its local part of the
        multivector. This will print out as many rows of data as the global
        number of rows in the multivector, so beware. 
        """
        return _Tpetra.MultiVector_long_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """
        removeEmptyProcessesInPlace(MultiVector_long self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & newMap)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::removeEmptyProcessesInPlace(const Teuchos::RCP< const
        map_type > &newMap)

        Remove processes owning zero rows from the Map and their communicator.

        WARNING:  This method is ONLY for use by experts. We highly recommend
        using the nonmember function of the same name defined in
        Tpetra_DistObject_decl.hpp.

        WARNING:  We make NO promises of backwards compatibility. This method
        may change or disappear at any time.

        Parameters:
        -----------

        newMap:  [in] This must be the result of calling the
        removeEmptyProcesses() method on the row Map. If it is not, this
        method's behavior is undefined. This pointer will be null on excluded
        processes. 
        """
        return _Tpetra.MultiVector_long_removeEmptyProcessesInPlace(self, *args)


    def setCopyOrView(self, *args):
        """
        setCopyOrView(MultiVector_long self, Teuchos::DataAccess const copyOrView)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::setCopyOrView(const Teuchos::DataAccess copyOrView)

        Set whether this has copy (copyOrView = Teuchos::Copy) or view
        (copyOrView = Teuchos::View) semantics.

        WARNING:  The Kokkos refactor version of MultiVector only implements
        view semantics. If you attempt to call this method with copyOrView ==
        Teuchos::Copy, it will throw std::invalid_argument.

        WARNING:  This method is only for expert use. It may change or
        disappear at any time. 
        """
        return _Tpetra.MultiVector_long_setCopyOrView(self, *args)


    def getCopyOrView(self, *args):
        """
        getCopyOrView(MultiVector_long self) -> Teuchos::DataAccess

        Teuchos::DataAccess Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getCopyOrView() const

        Get whether this has copy (copyOrView = Teuchos::Copy) or view
        (copyOrView = Teuchos::View) semantics.

        The Kokkos refactor version of MultiVector only implements view
        semantics. This is not currently true for the "classic" version of
        MultiVector, though that will change in the near future.

        WARNING:  This method is only for expert use. It may change or
        disappear at any time. 
        """
        return _Tpetra.MultiVector_long_getCopyOrView(self, *args)


    def assign(self, *args):
        """
        assign(MultiVector_long self, MultiVector_long src)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::assign(const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &src)

        Copy the contents of src into *this (deep copy).

        Parameters:
        -----------

        src:  [in] Source MultiVector (input of the deep copy).

        ! src.getMap ().is_null () && ! this->getMap ().is_null ()

        src.getMap ()->isCompatible (* (this->getMap ())

        Any outstanding views of src or *this remain valid.

        To implementers: The postcondition implies that the implementation
        must not reallocate any memory of *this, or otherwise change its
        dimensions. This is not an assignment operator; it does not change
        anything in *this other than the contents of storage. 
        """
        return _Tpetra.MultiVector_long_assign(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(MultiVector_long self) -> PyObject *"""
        return _Tpetra.MultiVector_long__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector_long self) -> PyObject *"""
        return _Tpetra.MultiVector_long___distarray__(self, *args)

MultiVector_long_swigregister = _Tpetra.MultiVector_long_swigregister
MultiVector_long_swigregister(MultiVector_long)


upgradeMultiVectorClass(MultiVector_long)

class Vector_long(MultiVector_long):
    """


    A distributed dense vector.

    Parameters:
    -----------

    Scalar:  The type of each entry of the vector. (You can use real-
    valued or complex-valued types here, unlike in Epetra, where the
    scalar type is always double.)

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type. See the documentation of Map for
    requirements.

    classic:  DO NOT SPECIFY THIS EXPLICITLY. This exists only for
    backwards compatibility. It must always be false.

    This class inherits from MultiVector, and has the same template
    parameters. A Vector is a special case of a MultiVector that has only
    one vector (column). It may be used wherever a MultiVector may be
    used. Please see the documentation of MultiVector for more details.

    C++ includes: Tpetra_Vector_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [MultiVector_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_long, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_long, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Vector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, bool const zeroOut=True) -> Vector_long
        __init__(Tpetra::Vector<(long long,int,long long,DefaultNodeType)> self, Vector_long source) -> Vector_long
        __init__(Tpetra::Vector<(long long,int,long long,DefaultNodeType)> self, Vector_long source, Teuchos::DataAccess const copyOrView) -> Vector_long

        Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::Vector(const
        Teuchos::RCP< const map_type > &map, const dual_view_type &view, const
        dual_view_type &origView)

        Expert mode constructor, that takes a Kokkos::DualView of the Vector's
        data and the "original" Kokkos::DualView of the data, and returns a
        Vector that views those data.

        WARNING:  This constructor is only for expert users. We make no
        promises about backwards compatibility for this interface. It may
        change or go away at any time.  See the documentation of the
        MultiVector (parent class) constructor that takes the same arguments.

        Parameters:
        -----------

        map:  [in] Map describing the distribution of rows.

        view:  [in] View of the data (shallow copy).

        origView:  [in] "Original" view of the data (shallow copy). 
        """
        this = _Tpetra.new_Vector_long(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Vector_long

    def replaceGlobalValue(self, *args):
        """
        replaceGlobalValue(Vector_long self, long long globalRow, long long const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::replaceGlobalValue(const GlobalOrdinal globalRow, const Scalar
        &value) const

        Replace current value at the specified location with specified value.

        globalRow must be a valid global element on this node, according to
        the row map. 
        """
        return _Tpetra.Vector_long_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """
        sumIntoGlobalValue(Vector_long self, long long globalRow, long long const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::sumIntoGlobalValue(const GlobalOrdinal globalRow, const Scalar
        &value, const bool atomic=base_type::useAtomicUpdatesByDefault) const

        Add value to existing value, using global (row) index.

        Add the given value to the existing value at row globalRow (a global
        index).

        This method affects the host memory version of the data. If the
        DeviceType template parameter is a device that has two memory spaces,
        and you want to modify the non-host version of the data, you must
        access the device View directly by calling getLocalView(). Please see
        modify(), sync(), and the discussion of DualView semantics elsewhere
        in the documentation.

        Parameters:
        -----------

        globalRow:  [in] Global row index of the entry to modify. This must be
        a valid global row index on the calling process with respect to the
        Vector's Map.

        value:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.Vector_long_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """
        replaceLocalValue(Vector_long self, int myRow, long long const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::replaceLocalValue(const LocalOrdinal myRow, const Scalar &value)
        const

        Replace current value at the specified location with specified values.

        localRow must be a valid local element on this node, according to the
        row map. 
        """
        return _Tpetra.Vector_long_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """
        sumIntoLocalValue(Vector_long self, int myRow, long long const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::sumIntoLocalValue(const LocalOrdinal myRow, const Scalar &value,
        const bool atomic=base_type::useAtomicUpdatesByDefault) const

        Add value to existing value, using local (row) index.

        Add the given value to the existing value at row localRow (a local
        index).

        This method affects the host memory version of the data. If the
        DeviceType template parameter is a device that has two memory spaces,
        and you want to modify the non-host version of the data, you must
        access the device View directly by calling getLocalView(). Please see
        modify(), sync(), and the discussion of DualView semantics elsewhere
        in the documentation.

        Parameters:
        -----------

        localRow:  [in] Local row index of the entry to modify.

        value:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.Vector_long_sumIntoLocalValue(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(Vector_long self)
        get1dCopy(Vector_long self, Teuchos::ArrayView< long long > const & A)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::get1dCopy(const Teuchos::ArrayView< Scalar > &A) const

        Return multi-vector values in user-provided two-dimensional array
        (using Teuchos memory management classes). 
        """
        return _Tpetra.Vector_long_get1dCopy(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(Vector_long self)
        getDataNonConst(Vector_long self) -> Teuchos::ArrayRCP< long long >

        Teuchos::ArrayRCP<Scalar> Tpetra::Vector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getDataNonConst()

        View of the local values of this vector. 
        """
        return _Tpetra.Vector_long_getDataNonConst(self, *args)


    def getData(self, *args):
        """
        getData(Vector_long self)
        getData(Vector_long self) -> Teuchos::ArrayRCP< long long const >

        Teuchos::ArrayRCP<const Scalar> Tpetra::Vector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getData() const

        Const view of the local values of this vector. 
        """
        return _Tpetra.Vector_long_getData(self, *args)


    def norm2(self, *args):
        """
        norm2(Vector_long self)
        norm2(Vector_long self) -> Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type

        Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::mag_type Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm2() const

        Return the two-norm of this Vector. 
        """
        return _Tpetra.Vector_long_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(Vector_long self)
        normInf(Vector_long self) -> Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type

        Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::mag_type Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::normInf() const

        Return the infinity-norm of this Vector. 
        """
        return _Tpetra.Vector_long_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(Vector_long self)
        meanValue(Vector_long self) -> long long

        Scalar
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::meanValue() const

        Compute mean (average) value of this Vector. 
        """
        return _Tpetra.Vector_long_meanValue(self, *args)


    def description(self, *args):
        """
        description(Vector_long self) -> std::string

        std::string
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::description() const

        Return a one-line description of this object. 
        """
        return _Tpetra.Vector_long_description(self, *args)


    def describe(self, *args):
        """
        describe(Vector_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Describe this object in a human-readable way to the given output
        stream.

        You must call this method as a collective over all processes in this
        object's communicator.

        Parameters:
        -----------

        out:  [out] Output stream to which to write. Only Process 0 in this
        object's communicator may write to the output stream.

        verbLevel:  [in] Verbosity level. This also controls whether this
        method does any communication. At verbosity levels higher (greater)
        than Teuchos::VERB_LOW, this method may behave as a collective over
        the object's communicator.

        Teuchos::FancyOStream wraps std::ostream. It adds features like tab
        levels. If you just want to wrap std::cout, try this: 
        """
        return _Tpetra.Vector_long_describe(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(Vector_long self) -> PyObject *"""
        return _Tpetra.Vector_long__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector_long self) -> PyObject *"""
        return _Tpetra.Vector_long___distarray__(self, *args)

Vector_long_swigregister = _Tpetra.Vector_long_swigregister
Vector_long_swigregister(Vector_long)


upgradeVectorClass(Vector_long)

class DistObject_double(SrcDistObject, Teuchos.Describable):
    """


    Base class for distributed Tpetra objects that support data
    redistribution.

    DistObject is a base class for all Tpetra distributed global objects,
    including CrsGraph, CrsMatrix, MultiVector, and Vector. Classes that
    inherit from DistObject work as either the source or the target of an
    Export or Import (parallel redistribution) operation. If you want to
    write a class that can work as the source or target of an Export or
    Import operation, that class must inherit from DistObject.

    Parameters:
    -----------

    LocalOrdinal:  The type of local indices. Same as Map's LocalOrdinal
    template parameter. See Map's documentation for a discussion of the
    types that are valid to use here.

    GlobalOrdinal:  The type of global indices. Same as Map's
    GlobalOrdinal template parameter. See Map's documentation for a
    discussion of the types that are valid to use here.

    Node:  Same as Map's Node template parameter. See Map's documentation
    for a discussion of the types that are valid to use here.

    classic:  DO NOT SET THIS EXPLICITLY. This template parameter only
    exists for backwards compatibility. It must always be false.

    Summary Most Tpetra users will only use this class' methods to perform
    data redistribution for subclasses such as CrsGraph, CrsMatrix,
    MultiVector, and Vector. DistObject provides four methods for
    redistributing data: two versions of  doImport(), and two versions of
    doExport(). Import operations redistribute data from a nonoverlapping
    (one-to-one) distribution to a possibly overlapping distribution.
    Export operations redistribute data from a possibly overlapping
    distribution to a nonoverlapping (one-to-one) distribution. Once you
    have precomputed a data redistribution plan (an Import or Export
    object), you may use the plan to redistribute an input object's data
    into this object, by calling one of these methods. The input object of
    doImport() or  doExport() is always the "source" of the
    redistribution operation, which sends the data. The *this object is
    the target, which receives and combines the data. It has the
    distribution given by this-> getMap(). Forward or reverse
    redistribution modes Both Import and Export operations occur in two
    modes: forward and reverse. Forward mode is the usual case, where you
    are calling a method with its matching plan type (  doImport() for an
    Import plan, or  doExport() for an Export plan). In that case, the
    input DistObject must have the same Map as the source Map of the plan,
    and the target DistObject must have the same Map as the target Map of
    the plan. Reverse mode is also possible, where you call a method with
    the opposite plan type (  doImport() for an Export plan, or
    doExport() for an Import plan). In that case, the source DistObject's
    Map must be the same as the target Map of the plan, and the target
    DistObject's Map must be the same as the source Map of the plan. If
    you call  doImport(), we still call this an Import operation, even if
    you are using an Export plan in reverse. Similarly, if you call
    doExport(), we call this an Export operation.

    Most users will want to use forward mode. However, reverse mode is
    useful for some applications. For example, suppose you are solving a
    nonlinear partial differential equation using the finite element
    method, with Newton's method for the nonlinear equation. When
    assembling into a vector, it is convenient and efficient to do local
    assembly first into a vector with an overlapping distribution, then do
    global assembly via forward mode Export into a vector with a
    nonoverlapping distribution. After the linear solve, you may want to
    bring the resulting nonoverlapping distribution vector back to the
    overlapping distribution for another update phase. This would be a
    reverse mode Import, using the precomputed Export object.

    Another use case for reverse mode is in CrsMatrix, for the transpose
    version of distributed sparse matrix-vector multiply ("mat-vec").
    Non-transpose mat-vec (a function from the domain Map to the range
    Map) does an Import to bring in the source vector's data from the
    domain Map to the column Map of the sparse matrix, and an Export (if
    necessary) to bring the results from the row Map of the sparse matrix
    to the range Map. Transpose mat-vec (a function from the range Map to
    the domain Map) uses these precomputed Import and Export objects in
    reverse mode: first the Export in reverse mode to Import the source
    vector's data to the row Map, and then the Import in reverse mode to
    Export the results to the domain Map. Reverse mode lets us reuse the
    precomputed data redistribution plans for the transpose case. How to
    implement a subclass If you want to implement your own DistObject
    subclass, you have two choices of interface to implement: "old"
    (using Teuchos memory management classes, like Teuchos::ArrayRCP and
    Teuchos::ArrayView) or "new" (using Kokkos memory management
    classes, like Kokkos::View and Kokkos::DualView). Prefer new to old.
    The new interface gives you more options for thread parallelism and
    use of the GPU.

    If you intend to implement the new interface, you must override
    useNewInterface() to return true. In that case, your class must
    override the following methods:  constantNumberOfPackets()

    checkSizes()

    copyAndPermuteNew()

    packAndPrepareNew()

    unpackAndCombineNew()  Comments in the implementation of
    doTransferNew() explain how DistObject uses these methods to pack and
    unpack data for redistribution.

    If you choose to implement the old interface (not recommended), you
    should override the following methods instead:
    constantNumberOfPackets()

    checkSizes()

    copyAndPermute()

    packAndPrepare()

    unpackAndCombine()  In this case, you may also wish to implement
    createViews(), createViewsNonConst(), and releaseViews(). Comments in
    the implementation of doTransfer() explain how DistObject uses all
    these methods to pack and unpack data for redistribution.

    DistObject implements SrcDistObject, because we presume that if an
    object can be the target of an Import or Export, it can also be the
    source of an Import or Export.

    C++ includes: Tpetra_DistObject_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SrcDistObject, Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject_double, name, value)
    __swig_getmethods__ = {}
    for _s in [SrcDistObject, Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_DistObject_double

    def doImport(self, *args):
        """
        doImport(DistObject_double self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        doImport(DistObject_double self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::doImport(const SrcDistObject &source, const Export< LocalOrdinal,
        GlobalOrdinal, Node > &exporter, CombineMode CM)

        Import data into this object using an Export object ("reverse
        mode").

        The input DistObject is always the source of the data redistribution
        operation, and the *this object is always the target.

        If you don't know the difference between forward and reverse mode,
        then you probably want forward mode. Use the version of doImport()
        that takes a precomputed Import object in that case.

        Parameters:
        -----------

        source:  [in] The "source" object for redistribution.

        exporter:  [in] Precomputed data redistribution plan. Its target Map
        must be the same as the input DistObject's Map, and its source Map
        must be the same as this-> getMap(). (Note the difference from forward
        mode.)

        CM:  [in] How to combine incoming data with the same global index. 
        """
        return _Tpetra.DistObject_double_doImport(self, *args)


    def doExport(self, *args):
        """
        doExport(DistObject_double self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        doExport(DistObject_double self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::doExport(const SrcDistObject &source, const Import< LocalOrdinal,
        GlobalOrdinal, Node > &importer, CombineMode CM)

        Export data into this object using an Import object ("reverse
        mode").

        The input DistObject is always the source of the data redistribution
        operation, and the *this object is always the target.

        If you don't know the difference between forward and reverse mode,
        then you probably want forward mode. Use the version of doExport()
        that takes a precomputed Export object in that case.

        Parameters:
        -----------

        source:  [in] The "source" object for redistribution.

        importer:  [in] Precomputed data redistribution plan. Its target Map
        must be the same as the input DistObject's Map, and its source Map
        must be the same as this-> getMap(). (Note the difference from forward
        mode.)

        CM:  [in] How to combine incoming data with the same global index. 
        """
        return _Tpetra.DistObject_double_doExport(self, *args)


    def isDistributed(self, *args):
        """
        isDistributed(DistObject_double self) -> bool

        bool
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::isDistributed() const

        Whether this is a globally distributed object.

        For a definition of "globally distributed" (and its opposite,
        "locally replicated"), see the documentation of Map's
        isDistributed() method. 
        """
        return _Tpetra.DistObject_double_isDistributed(self, *args)


    def getMap(self, *args):
        """
        getMap(DistObject_double self) -> Teuchos::RCP< DefaultMapType const >

        virtual
        Teuchos::RCP<const map_type> Tpetra::DistObject< Packet, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getMap() const

        The Map describing the parallel distribution of this object.

        Note that some Tpetra objects might be distributed using multiple Map
        objects. For example, CrsMatrix has both a row Map and a column Map.
        It is up to the subclass to decide which Map to use when invoking the
        DistObject constructor. 
        """
        return _Tpetra.DistObject_double_getMap(self, *args)


    def description(self, *args):
        """
        description(DistObject_double self) -> std::string

        std::string
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::description() const

        One-line descriptiion of this object.

        We declare this method virtual so that subclasses of DistObject may
        override it. 
        """
        return _Tpetra.DistObject_double_description(self, *args)


    def describe(self, *args):
        """
        describe(DistObject_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void
        Tpetra::DistObject< Packet, LocalOrdinal, GlobalOrdinal, Node, classic
        >::describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print a descriptiion of this object to the given output stream.

        We declare this method virtual so that subclasses of Distobject may
        override it. 
        """
        return _Tpetra.DistObject_double_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """
        removeEmptyProcessesInPlace(DistObject_double self, Teuchos::RCP< DefaultMapType const > const & newMap)

        void removeEmptyProcessesInPlace(Teuchos::RCP< Tpetra::DistObject<
        PT, LO, GO, NT > > &input) 
        """
        return _Tpetra.DistObject_double_removeEmptyProcessesInPlace(self, *args)

DistObject_double_swigregister = _Tpetra.DistObject_double_swigregister
DistObject_double_swigregister(DistObject_double)

class MultiVector_double(DistObject_double):
    """


    One or more distributed dense vectors.

    A "multivector" contains one or more dense vectors. All the vectors
    in a multivector have the same distribution of rows in parallel over
    the communicator used to create the multivector. Multivectors
    containing more than one vector are useful for algorithms that solve
    multiple linear systems at once, or that solve for a cluster of
    eigenvalues and their corresponding eigenvectors at once. These
    "block" algorithms often have accuracy or performance advantages
    over corresponding algorithms that solve for only one vector at a
    time. For example, working with multiple vectors at a time allows
    Tpetra to use faster BLAS 3 routines for local computations. It may
    also reduce the number of parallel reductions.

    The Vector class implements the MultiVector interface, so if you only
    wish to work with a single vector at a time, you may simply use Vector
    instead of MultiVector. However, if you are writing solvers or
    preconditioners, you would do better to write to the MultiVector
    interface and always assume that each MultiVector contains more than
    one vector. This will make your solver or preconditioner more
    compatible with other Trilinos packages, and it will also let you
    exploit the performance optimizations mentioned above.

    Parameters:
    -----------

    Scalar:  The type of each entry of the multivector. (You can use real-
    valued or complex-valued types here, unlike in Epetra, where the
    scalar type is always double.)

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type.

    Prerequisites Before reading the rest of this documentation, it helps
    to know a little bit about Kokkos. In particular, you should know
    about execution spaces, memory spaces, and shallow copy semantics. You
    should also know something about the Teuchos memory management
    classes, in particular Teuchos::RCP, though it helps to know a bit
    about Teuchos::ArrayRCP and Teuchos::ArrayView as well. You may also
    want to know about the differences between BLAS 1, 2, and 3
    operations, and learn a little bit about MPI (the Message Passing
    Interface for distributed-memory programming). You won't have to use
    MPI directly to use MultiVector, but it helps to be familiar with the
    general idea of distributed storage of data over a communicator. A
    MultiVector is a view of data A MultiVector is a view of data. A view
    behaves like a pointer; it provides access to the original
    multivector's data without copying the data. This means that the copy
    constructor and assignment operator ( operator=) do shallow copies.
    They do not copy the data; they just copy pointers and other
    "metadata." If you would like to copy a MultiVector into an existing
    MultiVector, call the nonmember function deep_copy(). If you would
    like to create a new MultiVector which is a deep copy of an existing
    MultiVector, call the nonmember function createCopy(), or use the two-
    argument copy constructor with Teuchos::Copy as the second argument.

    Views have the additional property that they automatically handle
    deallocation. They use reference counting for this, much like how
    std::shared_ptr works. That means you do not have to worry about
    "freeing" a MultiVector after it has been created. Furthermore, you
    may pass shallow copies around without needing to worry about which is
    the "master" view of the data. There is no "master" view of the
    data; when the last view falls out of scope, the data will be
    deallocated.

    This is what the documentation means when it speaks of view semantics.
    The opposite of that is copy or container semantics, where the copy
    constructor and operator= do deep copies (of the data). We say that
    "std::vector has container semantics," and "MultiVector has view
    semantics."

    MultiVector also has "subview" methods that give results analogous
    to the Kokkos::subview() function. That is, they return a MultiVector
    which views some subset of another MultiVector's rows and columns. The
    subset of columns in a view need not be contiguous. For example, given
    a multivector X with 43 columns, it is possible to have a multivector
    Y which is a view of columns 1, 3, and 42 (zero-based indices) of X.
    We call such multivectors noncontiguous. They have the the property
    that isConstantStride() returns false.

    Noncontiguous multivectors lose some performance advantages. For
    example, local computations may be slower, since Tpetra cannot use
    BLAS 3 routines (e.g., matrix-matrix multiply) on a noncontiguous
    multivectors without copying into temporary contiguous storage. For
    performance reasons, if you get a Kokkos::View of a noncontiguous
    MultiVector's local data, it does not correspond to the columns that
    the MultiVector views. DualView semantics  Tpetra was designed to
    perform well on many different kinds of computers. Some computers have
    different memory spaces. For example, GPUs (Graphics Processing Units)
    by NVIDIA have "device memory" and "host memory." The GPU has
    faster access to device memory than host memory, but usually there is
    less device memory than host memory. Intel's "Knights Landing"
    architecture has two different memory spaces, also with different
    capacity and performance characteristics. Some architectures let the
    processor address memory in any space, possibly with a performance
    penalty. Others can only access data in certain spaces, and require a
    special system call to copy memory between spaces.

    The Kokkos package provides abstractions for handling multiple memory
    spaces. In particular, Kokkos::DualView lets users "mirror" data
    that live in one space, with data in another space. It also lets users
    manually mark data in one space as modified ( modify()), and
    synchronize ( sync()) data from one space to another. The latter only
    actually copies if the data have been marked as modified. Users can
    access data in a particular space by calling view(). All three of
    these methods modify(), sync(), and view() are templated on the memory
    space. This is how users select the memory space on which they want
    the method to act.

    MultiVector implements "DualView semantics." This means that it
    implements the above three operations:  modify(): Mark data in a
    memory space as modified (or about to be modified)

    sync(): If data in the target memory space are least recently modified
    compared with the other space, copy data to the target memory space

    getLocalView(): Return a Kokkos::View of the data in a given memory
    space

    If your computer only has one memory space, as with conventional
    single-core or multicore processors, you don't have to worry about
    this. You can ignore the modify() and sync() methods in that case. How
    to access the local data The getLocalView() method for getting a
    Kokkos::View is the main way to access a MultiVector's local data. If
    you want to read or write the actual values in a multivector, this is
    what you want. The resulting Kokkos::View behaves like a 2-D array.
    You can address it using an index pair (i,j), where i is the local row
    index, and j is the column index.

    MultiVector also has methods that return an Teuchos::ArrayRCP<Scalar>
    ("1-D view"), or a Teuchos::ArrayRCP<Teuchos::ArrayRCP<Scalar> >
    ("2-D view"). These exist only for backwards compatibility, and also
    give access to the local data.

    All of these views only view local data. This means that the
    corresponding rows of the multivector are owned by the calling (MPI)
    process. You may not use these methods to access remote data, that is,
    rows that do not belong to the calling process.

    MultiVector's public interface also has methods for modifying local
    data, like sumIntoLocalValue() and replaceGlobalValue(). These methods
    act on host data only. To access or modify device data, you must get
    the Kokkos::View and work with it directly. Why won't you give me a
    raw pointer?  Tpetra was designed to allow different data
    representations underneath the same interface. This lets Tpetra run
    correctly and efficiently on many different kinds of hardware. These
    different kinds of hardware all have in common the following: Data
    layout matters a lot for performance

    The right layout for your data depends on the hardware

    Data may be distributed over different memory spaces in hardware, and
    efficient code must respect this, whether or not the programming model
    presents the different memories as a single address space

    Copying between different data layouts or memory spaces is expensive
    and should be avoided whenever possible

    Optimal data layout may require control over initialization of storage
    These conclusions have practical consequences for the MultiVector
    interface. In particular, we have deliberately made it difficult for
    you to access data directly by raw pointer. This is because the
    underlying layout may not be what you expect. The memory might not
    even be accessible from the host CPU. Instead, we give access through
    a Kokkos::View, which behaves like a 2-D array. You can ask the
    Kokkos::View for a raw pointer by calling its ptr_on_device() method,
    but then you are responsible for understanding its layout in memory.
    Parallel distribution of data A MultiVector's rows are distributed
    over processes in its (row) Map's communicator. A MultiVector is a
    DistObject; the Map of the DistObject tells which process in the
    communicator owns which rows. This means that you may use Import and
    Export operations to migrate between different distributions. Please
    refer to the documentation of Map, Import, and Export for more
    information.

    MultiVector includes methods that perform parallel all-reduces. These
    include inner products and various kinds of norms. All of these
    methods have the same blocking semantics as MPI_Allreduce.

    WARNING:  Some computational methods, such as inner products and
    norms, may return incorrect results if the MultiVector's Map is
    overlapping (not one-to-one) but not locally replicated. That is, if
    some but not all rows are shared by more than one process in the
    communicator, then inner products and norms may be wrong. This
    behavior may change in future releases.

    C++ includes: Tpetra_MultiVector_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject_double]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject_double]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, size_t const numVecs, bool const zeroOut=True) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, MultiVector_double source) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, MultiVector_double source, Teuchos::DataAccess const copyOrView) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, Teuchos::ArrayView< double const > const & A, size_t const LDA, size_t const NumVectors) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map, Teuchos::ArrayView< Teuchos::ArrayView< double const > const > const & ArrayOfPtrs, size_t const NumVectors) -> MultiVector_double

        Tpetra::MultiVector< Scalar, LO, GO, Node, classic
        >::MultiVector(const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic > &X, const map_type &subMap, const size_t offset=0)

        "Offset view" constructor; make a view of a contiguous subset of
        rows on each process.

        Return a view of the MultiVector X, which views a subset of the rows
        of X. Specify the subset by a subset Map of this MultiVector's current
        row Map, and an optional (local) offset. "View" means "alias": if
        the original (this) MultiVector's data change, the view will see the
        changed data.

        Parameters:
        -----------

        X:  [in] The MultiVector to view.

        subMap:  [in] The row Map for the new MultiVector. This must be a
        subset Map of the input MultiVector's row Map.

        offset:  [in] The local row offset at which to start the view.

        Suppose that you have a MultiVector X, and you want to view X, on all
        processes in X's (MPI) communicator, as split into two row blocks X1
        and X2. One could express this in Matlab notation as X = [X1; X2],
        except that here, X1 and X2 are views into X, rather than copies of
        X's data. This method assumes that the local indices of X1 and X2 are
        each contiguous, and that the local indices of X2 follow those of X1.
        If that is not the case, you cannot use views to divide X into blocks
        like this; you must instead use the Import or Export functionality,
        which copies the relevant rows of X.

        Here is how you would construct the views X1 and X2.

        It is legal, in the above example, for X1 or X2 to have zero local
        rows on any or all process(es). In that case, the corresponding Map
        must have zero local entries on that / those process(es). In
        particular, if X2 has zero local rows on a process, then the
        corresponding offset on that process would be the number of local rows
        in X (and therefore in X1) on that process. This is the only case in
        which the sum of the local number of entries in subMap (in this case,
        zero) and the offset may equal the number of local entries in *this.

        """
        this = _Tpetra.new_MultiVector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_MultiVector_double

    def replaceGlobalValue(self, *args):
        """
        replaceGlobalValue(MultiVector_double self, long long globalRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceGlobalValue(GlobalOrdinal globalRow, size_t col,
        const T &value) const

        Like the above replaceGlobalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        This method does not have an "atomic" option like
        sumIntoGlobalValue. This is deliberate. Replacement is not
        commutative, unlike += (modulo rounding error). Concurrent calls to
        replaceGlobalValue on different threads that modify the same entry/ies
        have undefined results. (It's not just that one thread might win; it's
        that the value might get messed up.)

        Parameters:
        -----------

        gblRow:  [in] Global row index of the entry to modify. This must be a
        valid global row index on the calling process with respect to the
        MultiVector's Map.

        col:  [in] Column index of the entry to modify.

        value:  [in] Incoming value to add to the entry. 
        """
        return _Tpetra.MultiVector_double_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """
        sumIntoGlobalValue(MultiVector_double self, long long globalRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::sumIntoGlobalValue(const GlobalOrdinal gblRow, const size_t
        col, const T &val, const bool atomic=useAtomicUpdatesByDefault) const

        Like the above sumIntoGlobalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        Parameters:
        -----------

        gblRow:  [in] Global row index of the entry to modify. This must be a
        valid global row index on the calling process with respect to the
        MultiVector's Map.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.MultiVector_double_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """
        replaceLocalValue(MultiVector_double self, int localRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceLocalValue(const LocalOrdinal lclRow, const size_t
        col, const T &val) const

        Like the above replaceLocalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        This method does not have an "atomic" option like sumIntoLocalValue.
        This is deliberate. Replacement is not commutative, unlike += (modulo
        rounding error). Concurrent calls to replaceLocalValue on different
        threads that modify the same entry/ies have undefined results. (It's
        not just that one thread might win; it's that the value might get
        messed up.)

        Parameters:
        -----------

        lclRow:  [in] Local row index of the entry to modify. Must be a valid
        local index in this MultiVector's Map on the calling process.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry. 
        """
        return _Tpetra.MultiVector_double_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """
        sumIntoLocalValue(MultiVector_double self, int localRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::sumIntoLocalValue(const LocalOrdinal lclRow, const size_t
        col, const T &val, const bool atomic=useAtomicUpdatesByDefault) const

        Like the above sumIntoLocalValue, but only enabled if T differs from
        impl_scalar_type.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U.

        This method affects the host memory version of the data. If
        device_type is a Kokkos device that has two memory spaces, and you
        want to modify the non-host version of the data, you must access the
        device View directly by calling getLocalView(). Please see modify(),
        sync(), and the discussion of DualView semantics elsewhere in the
        documentation. You are responsible for calling modify() and sync(), if
        needed; this method doesn't do that.

        Parameters:
        -----------

        lclRow:  [in] Local row index of the entry to modify.

        col:  [in] Column index of the entry to modify.

        val:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.MultiVector_double_sumIntoLocalValue(self, *args)


    def putScalar(self, *args):
        """
        putScalar(MultiVector_double self, double const & value)

        std::enable_if<! std::is_same<T, impl_scalar_type>::value &&
        std::is_convertible<T, impl_scalar_type>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::putScalar(const T &value)

        Set all values in the multivector with the given value.

        This method only exists if its template parameter T and
        impl_scalar_type differ, and if it is syntactically possible to
        convert T to impl_scalar_type. This method is mainly useful for
        backwards compatibility, when the Scalar template parameter differs
        from impl_scalar_type. That is commonly only the case when Scalar is
        std::complex<U> for some type U. 
        """
        return _Tpetra.MultiVector_double_putScalar(self, *args)


    def randomize(self, *args):
        """
        randomize(MultiVector_double self)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::randomize(const Scalar &minVal, const Scalar &maxVal)

        Set all values in the multivector to pseudorandom numbers in the given
        range.

        Do not expect repeatable results.

        Behavior of this method may or may not depend on external use of the C
        library routines srand() and rand(). In particular, setting the seed
        there may not affect it here.

        WARNING:  This method does not promise to use a distributed-memory
        parallel pseudorandom number generator. Corresponding values on
        different processes might be correlated. It also does not promise to
        use a high-quality pseudorandom number generator within each process.

        """
        return _Tpetra.MultiVector_double_randomize(self, *args)


    def replaceMap(self, *args):
        """
        replaceMap(MultiVector_double self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::replaceMap(const Teuchos::RCP< const map_type > &map)

        Replace the underlying Map in place.

        WARNING:  The normal use case of this method, with an input Map that
        is compatible with the object's current Map and has the same
        communicator, is safe. However, if the input Map has a different
        communicator (with a different number of processes, in particular)
        than this object's current Map, the semantics of this method are
        tricky. We recommend that only experts try the latter use case.

        If the new Map's communicator is similar to the original Map's
        communicator, then the original Map and new Map must be compatible:
        map->isCompatible (this->getMap ()). "Similar" means that the
        communicators have the same number of processes, though these need not
        be in the same order (have the same assignments of ranks) or represent
        the same communication contexts. It means the same thing as the
        MPI_SIMILAR return value of MPI_COMM_COMPARE. See MPI 3.0 Standard,
        Section 6.4.1.

        If the new Map's communicator contains more processes than the
        original Map's communicator, then the projection of the original Map
        onto the new communicator must be compatible with the new Map.

        If the new Map's communicator contains fewer processes than the
        original Map's communicator, then the projection of the new Map onto
        the original communicator must be compatible with the original Map.
        This method replaces this object's Map with the given Map. This
        relabels the rows of the multivector using the global IDs in the input
        Map. Thus, it implicitly applies a permutation, without actually
        moving data. If the new Map's communicator has more processes than the
        original Map's communicator, it "projects" the MultiVector onto the
        new Map by filling in missing rows with zeros. If the new Map's
        communicator has fewer processes than the original Map's communicator,
        the method "forgets about" any rows that do not exist in the new
        Map. (It mathematical terms, if one considers a MultiVector as a
        function from one vector space to another, this operation restricts
        the range.)

        This method must always be called collectively on the communicator
        with the largest number of processes: either this object's current
        communicator ( this-> getMap()->getComm()), or the new Map's
        communicator ( map->getComm()). If the new Map's communicator has
        fewer processes, then the new Map must be null on processes excluded
        from the original communicator, and the current Map must be nonnull on
        all processes. If the new Map has more processes, then it must be
        nonnull on all those processes, and the original Map must be null on
        those processes which are not in the new Map's communicator. (The
        latter case can only happen to a MultiVector to which a replaceMap()
        operation has happened before.)

        WARNING:  This method must always be called as a collective operation
        on all processes in the original communicator ( this->getMap
        ()->getComm ()). We reserve the right to do checking in debug mode
        that requires this method to be called collectively in order not to
        deadlock.

        This method does not do data redistribution. If you need to move data
        around, use Import or Export. 
        """
        return _Tpetra.MultiVector_double_replaceMap(self, *args)


    def reduce(self, *args):
        """
        reduce(MultiVector_double self)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::reduce()

        Sum values of a locally replicated multivector across all processes.

        WARNING:  This method may only be called for locally replicated
        MultiVectors.

        isDistributed() == false 
        """
        return _Tpetra.MultiVector_double_reduce(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector_double self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subCopy(MultiVector_double self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP<
        MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::subCopy(const Teuchos::ArrayView< const size_t > &cols)
        const

        Return a MultiVector with copies of selected columns. 
        """
        return _Tpetra.MultiVector_double_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector_double self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        subView(MultiVector_double self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::subView(const Teuchos::ArrayView< const size_t > &cols)
        const

        Return a const MultiVector with const views of selected columns. 
        """
        return _Tpetra.MultiVector_double_subView(self, *args)


    def subViewNonConst(self, *args):
        """
        subViewNonConst(MultiVector_double self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subViewNonConst(MultiVector_double self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::subViewNonConst(const Teuchos::ArrayView< const
        size_t > &cols)

        Return a MultiVector with views of selected columns. 
        """
        return _Tpetra.MultiVector_double_subViewNonConst(self, *args)


    def offsetViewNonConst(self, *args):
        """
        offsetViewNonConst(MultiVector_double self, Teuchos::RCP< DefaultMapType const > const & subMap, size_t const offset) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::offsetViewNonConst(const Teuchos::RCP< const map_type
        > &subMap, const size_t offset)

        Return a nonconst view of a subset of rows.

        Return a nonconst (modifiable) view of this MultiVector consisting of
        a subset of the rows, as specified by an offset and a subset Map of
        this MultiVector's current row Map. If you want X1 or X2 to be const
        (nonmodifiable) views, use offsetView() with the same arguments.
        "View" means "alias": if the original (this) MultiVector's data
        change, the view will see the changed data, and if the view's data
        change, the original MultiVector will see the changed data.

        Parameters:
        -----------

        subMap:  [in] The row Map for the new MultiVector. This must be a
        subset Map of this MultiVector's row Map.

        offset:  [in] The local row offset at which to start the view.

        See the documentation of offsetView() for a code example and an
        explanation of edge cases. 
        """
        return _Tpetra.MultiVector_double_offsetViewNonConst(self, *args)


    def getVector(self, *args):
        """
        getVector(MultiVector_double self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getVector(const size_t j) const

        Return a Vector which is a const view of column j. 
        """
        return _Tpetra.MultiVector_double_getVector(self, *args)


    def getVectorNonConst(self, *args):
        """
        getVectorNonConst(MultiVector_double self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >

        Teuchos::RCP< Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic > > Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic >::getVectorNonConst(const size_t j)

        Return a Vector which is a nonconst view of column j. 
        """
        return _Tpetra.MultiVector_double_getVectorNonConst(self, *args)


    def getData(self, *args):
        """
        getData(MultiVector_double self, size_t j) -> Teuchos::ArrayRCP< double const >

        Teuchos::ArrayRCP< const Scalar > Tpetra::MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::getData(size_t j) const

        Const view of the local values in a particular vector of this
        multivector. 
        """
        return _Tpetra.MultiVector_double_getData(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(MultiVector_double self, size_t j) -> Teuchos::ArrayRCP< double >

        Teuchos::ArrayRCP< Scalar > Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getDataNonConst(size_t j)

        View of the local values in a particular vector of this multivector.

        """
        return _Tpetra.MultiVector_double_getDataNonConst(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(MultiVector_double self, Teuchos::ArrayView< double > const & A, size_t const LDA)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get1dCopy(const Teuchos::ArrayView< Scalar > &A, const
        size_t LDA) const

        Fill the given array with a copy of this multivector's local values.

        Parameters:
        -----------

        A:  [out] View of the array to fill. We consider A as a matrix with
        column-major storage.

        LDA:  [in] Leading dimension of the matrix A. 
        """
        return _Tpetra.MultiVector_double_get1dCopy(self, *args)


    def get2dCopy(self, *args):
        """
        get2dCopy(MultiVector_double self, Teuchos::ArrayView< Teuchos::ArrayView< double > const > const & ArrayOfPtrs)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get2dCopy(const Teuchos::ArrayView< const
        Teuchos::ArrayView< Scalar > > &ArrayOfPtrs) const

        Fill the given array with a copy of this multivector's local values.

        Parameters:
        -----------

        ArrayOfPtrs:  [out] Array of arrays, one for each column of the
        multivector. On output, we fill ArrayOfPtrs[j] with the data for
        column j of this multivector. 
        """
        return _Tpetra.MultiVector_double_get2dCopy(self, *args)


    def get1dView(self, *args):
        """
        get1dView(MultiVector_double self) -> Teuchos::ArrayRCP< double const >

        Teuchos::ArrayRCP< const Scalar > Tpetra::MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::get1dView() const

        Const persisting (1-D) view of this multivector's local values.

        This method assumes that the columns of the multivector are stored
        contiguously. If not, this method throws std::runtime_error. 
        """
        return _Tpetra.MultiVector_double_get1dView(self, *args)


    def get2dView(self, *args):
        """
        get2dView(MultiVector_double self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< double const > >

        Teuchos::ArrayRCP< Teuchos::ArrayRCP< const Scalar > >
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::get2dView() const

        Return const persisting pointers to values. 
        """
        return _Tpetra.MultiVector_double_get2dView(self, *args)


    def get1dViewNonConst(self, *args):
        """
        get1dViewNonConst(MultiVector_double self) -> Teuchos::ArrayRCP< double >

        Teuchos::ArrayRCP< Scalar > Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::get1dViewNonConst()

        Nonconst persisting (1-D) view of this multivector's local values.

        This method assumes that the columns of the multivector are stored
        contiguously. If not, this method throws std::runtime_error. 
        """
        return _Tpetra.MultiVector_double_get1dViewNonConst(self, *args)


    def get2dViewNonConst(self, *args):
        """
        get2dViewNonConst(MultiVector_double self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< double > >

        Teuchos::ArrayRCP< Teuchos::ArrayRCP< Scalar > > Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::get2dViewNonConst()

        Return non-const persisting pointers to values. 
        """
        return _Tpetra.MultiVector_double_get2dViewNonConst(self, *args)


    def dot(self, *args):
        """
        dot(MultiVector_double self, MultiVector_double A, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type > const & dots)
        dot(MultiVector_double self, MultiVector_double A, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & dots)

        std::enable_if< !
        (std::is_same<dot_type, T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::dot(const
        MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > &A,
        const Kokkos::View< T *, device_type > &dots) const

        Compute the dot product of each corresponding pair of vectors
        (columns) in A and B, storing the result in a device view.

        Parameters:
        -----------

        T:  The output type of the dot products.

        This method only exists if dot_type and T are different types. For
        example, if Scalar and dot_type differ, then this method ensures
        backwards compatibility with the previous interface (that returned dot
        products as Scalar rather than as dot_type). The complicated enable_if
        expression just ensures that the method only exists if dot_type and T
        are different types; the method still returns void, as above. 
        """
        return _Tpetra.MultiVector_double_dot(self, *args)


    def abs(self, *args):
        """
        abs(MultiVector_double self, MultiVector_double A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::abs(const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal,
        Node, classic > &A)

        Put element-wise absolute values of input Multi-vector in target: A =
        abs(this) 
        """
        return _Tpetra.MultiVector_double_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(MultiVector_double self, MultiVector_double A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::reciprocal(const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &A)

        Put element-wise reciprocal values of input Multi-vector in target,
        this(i,j) = 1/A(i,j). 
        """
        return _Tpetra.MultiVector_double_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector_double self, double const & alpha)
        scale(MultiVector_double self, Teuchos::ArrayView< double const > alpha)
        scale(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const alpha)
        scale(MultiVector_double self, double const & alpha, MultiVector_double A)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::scale(const Scalar &alpha, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A)

        Scale in place: this = alpha * A.

        Replace this MultiVector with scaled values of A. This method will
        always multiply, even if alpha is zero. That means, for example, that
        if *this contains NaN entries before calling this method, the NaN
        entries will remain after this method finishes. It is legal for the
        input A to alias this MultiVector. 
        """
        return _Tpetra.MultiVector_double_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector_double self, double const & alpha, MultiVector_double A, double const & beta)
        update(MultiVector_double self, double const & alpha, MultiVector_double A, double const & beta, MultiVector_double B, double const & gamma)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::update(const Scalar &alpha, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A, const Scalar &beta,
        const MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        > &B, const Scalar &gamma)

        Update: this = gamma*this + alpha*A + beta*B.

        Update this MultiVector with scaled values of A and B. If gamma is
        zero, overwrite *this unconditionally, even if it contains NaN
        entries. It is legal for the inputs A or B to alias this MultiVector.

        """
        return _Tpetra.MultiVector_double_update(self, *args)


    def norm1(self, *args):
        """
        norm1(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm1(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if< !
        (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm1(const
        Teuchos::ArrayView< T > &norms) const

        Compute the one-norm of each vector (column).

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost norm1() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_double_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm2(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if< !
        (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm2(const
        Teuchos::ArrayView< T > &norms) const

        Compute the two-norm of each vector (column).

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost norm2() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms products as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_double_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        normInf(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)

        std::enable_if<
        ! (std::is_same<mag_type,T>::value), void >::type Tpetra::MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::normInf(const
        Teuchos::ArrayView< T > &norms) const

        Compute the infinity-norm of each vector (column), storing the result
        in a Teuchos::ArrayView.

        Parameters:
        -----------

        T:  The output type of the norms.

        See the uppermost normInf() method above for documentation.

        This method only exists if mag_type and T are different types. For
        example, if Teuchos::ScalarTraits<Scalar>::magnitudeType and mag_type
        differ, then this method ensures backwards compatibility with the
        previous interface (that returned norms products as
        Teuchos::ScalarTraits<Scalar>::magnitudeType rather than as mag_type).
        The complicated enable_if expression just ensures that the method only
        exists if mag_type and T are different types; the method still returns
        void, as above. 
        """
        return _Tpetra.MultiVector_double_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type > const & means)

        std::enable_if<! std::is_same<impl_scalar_type, T>::value, void>::type
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::meanValue(const Teuchos::ArrayView< T > &means) const 
        """
        return _Tpetra.MultiVector_double_meanValue(self, *args)


    def multiply(self, *args):
        """
        multiply(MultiVector_double self, Teuchos::ETransp transA, Teuchos::ETransp transB, double const & alpha, MultiVector_double A, MultiVector_double B, double const & beta)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::multiply(Teuchos::ETransp transA, Teuchos::ETransp transB,
        const Scalar &alpha, const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &A, const MultiVector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &B, const Scalar &beta)

        Matrix-matrix multiplication: this = beta*this + alpha*op(A)*op(B).

        If beta is zero, overwrite *this unconditionally, even if it contains
        NaN entries. This imitates the semantics of analogous BLAS routines
        like DGEMM. 
        """
        return _Tpetra.MultiVector_double_multiply(self, *args)


    def elementWiseMultiply(self, *args):
        """
        elementWiseMultiply(MultiVector_double self, double scalarAB, Vector_double A, MultiVector_double B, double scalarThis)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::elementWiseMultiply(Scalar scalarAB, const Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic > &A, const MultiVector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic > &B, Scalar
        scalarThis)

        Multiply a Vector A elementwise by a MultiVector B.

        Compute this = scalarThis * this + scalarAB * B @ A where </tt>
        denotes element-wise multiplication. In pseudocode, if C denotes *this
        MultiVector: for all rows i and columns j of C.

        B must have the same dimensions as *this, while A must have the same
        number of rows but a single column.

        We do not require that A, B, and *this have compatible Maps, as long
        as the number of rows in A, B, and *this on each process is the same.
        For example, one or more of these vectors might have a locally
        replicated Map, or a Map with a local communicator ( MPI_COMM_SELF).
        This case may occur in block relaxation algorithms when applying a
        diagonal scaling. 
        """
        return _Tpetra.MultiVector_double_elementWiseMultiply(self, *args)


    def getNumVectors(self, *args):
        """
        getNumVectors(MultiVector_double self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getNumVectors() const

        Number of columns in the multivector. 
        """
        return _Tpetra.MultiVector_double_getNumVectors(self, *args)


    def getLocalLength(self, *args):
        """
        getLocalLength(MultiVector_double self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getLocalLength() const

        Local number of rows on the calling process. 
        """
        return _Tpetra.MultiVector_double_getLocalLength(self, *args)


    def getGlobalLength(self, *args):
        """
        getGlobalLength(MultiVector_double self) -> Tpetra::global_size_t

        global_size_t Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getGlobalLength() const

        Global number of rows in the multivector. 
        """
        return _Tpetra.MultiVector_double_getGlobalLength(self, *args)


    def getStride(self, *args):
        """
        getStride(MultiVector_double self) -> size_t

        size_t
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::getStride() const

        Stride between columns in the multivector.

        This is only meaningful if  isConstantStride() returns true.

        WARNING:  This may be different on different processes. 
        """
        return _Tpetra.MultiVector_double_getStride(self, *args)


    def isConstantStride(self, *args):
        """
        isConstantStride(MultiVector_double self) -> bool

        bool
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::isConstantStride() const

        Whether this multivector has constant stride between columns.

        WARNING:  This may be different on different processes. 
        """
        return _Tpetra.MultiVector_double_isConstantStride(self, *args)


    def description(self, *args):
        """
        description(MultiVector_double self) -> std::string

        std::string
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::description() const

        A simple one-line description of this object. 
        """
        return _Tpetra.MultiVector_double_description(self, *args)


    def describe(self, *args):
        """
        describe(MultiVector_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::describe(Teuchos::FancyOStream &out, const
        Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print the object with the given verbosity level to a FancyOStream.

        Parameters:
        -----------

        out:  [out] Output stream to which to print. For verbosity levels
        VERB_LOW and lower, only the process with rank 0 ("Proc 0") in the
        MultiVector's communicator prints. For verbosity levels strictly
        higher than VERB_LOW, all processes in the communicator need to be
        able to print to the output stream.

        verbLevel:  [in] Verbosity level. The default verbosity
        (verbLevel=VERB_DEFAULT) is VERB_LOW.

        The amount and content of what this method prints depends on the
        verbosity level. In the list below, each higher level includes all the
        content of the previous levels, as well as its own content.

        VERB_LOW: Only Proc 0 prints; it prints the same thing as
        description().

        VERB_MEDIUM: Each process prints its local length (the number of rows
        that it owns).

        VERB_HIGH: Each process prints whether the multivector has constant
        stride (see  isConstantStride()), and if so, what that stride is.
        (Stride may differ on different processes.)

        VERB_EXTREME: Each process prints the values in its local part of the
        multivector. This will print out as many rows of data as the global
        number of rows in the multivector, so beware. 
        """
        return _Tpetra.MultiVector_double_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """
        removeEmptyProcessesInPlace(MultiVector_double self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & newMap)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::removeEmptyProcessesInPlace(const Teuchos::RCP< const
        map_type > &newMap)

        Remove processes owning zero rows from the Map and their communicator.

        WARNING:  This method is ONLY for use by experts. We highly recommend
        using the nonmember function of the same name defined in
        Tpetra_DistObject_decl.hpp.

        WARNING:  We make NO promises of backwards compatibility. This method
        may change or disappear at any time.

        Parameters:
        -----------

        newMap:  [in] This must be the result of calling the
        removeEmptyProcesses() method on the row Map. If it is not, this
        method's behavior is undefined. This pointer will be null on excluded
        processes. 
        """
        return _Tpetra.MultiVector_double_removeEmptyProcessesInPlace(self, *args)


    def setCopyOrView(self, *args):
        """
        setCopyOrView(MultiVector_double self, Teuchos::DataAccess const copyOrView)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::setCopyOrView(const Teuchos::DataAccess copyOrView)

        Set whether this has copy (copyOrView = Teuchos::Copy) or view
        (copyOrView = Teuchos::View) semantics.

        WARNING:  The Kokkos refactor version of MultiVector only implements
        view semantics. If you attempt to call this method with copyOrView ==
        Teuchos::Copy, it will throw std::invalid_argument.

        WARNING:  This method is only for expert use. It may change or
        disappear at any time. 
        """
        return _Tpetra.MultiVector_double_setCopyOrView(self, *args)


    def getCopyOrView(self, *args):
        """
        getCopyOrView(MultiVector_double self) -> Teuchos::DataAccess

        Teuchos::DataAccess Tpetra::MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getCopyOrView() const

        Get whether this has copy (copyOrView = Teuchos::Copy) or view
        (copyOrView = Teuchos::View) semantics.

        The Kokkos refactor version of MultiVector only implements view
        semantics. This is not currently true for the "classic" version of
        MultiVector, though that will change in the near future.

        WARNING:  This method is only for expert use. It may change or
        disappear at any time. 
        """
        return _Tpetra.MultiVector_double_getCopyOrView(self, *args)


    def assign(self, *args):
        """
        assign(MultiVector_double self, MultiVector_double src)

        void
        Tpetra::MultiVector< Scalar, LocalOrdinal, GlobalOrdinal, Node,
        classic >::assign(const MultiVector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic > &src)

        Copy the contents of src into *this (deep copy).

        Parameters:
        -----------

        src:  [in] Source MultiVector (input of the deep copy).

        ! src.getMap ().is_null () && ! this->getMap ().is_null ()

        src.getMap ()->isCompatible (* (this->getMap ())

        Any outstanding views of src or *this remain valid.

        To implementers: The postcondition implies that the implementation
        must not reallocate any memory of *this, or otherwise change its
        dimensions. This is not an assignment operator; it does not change
        anything in *this other than the contents of storage. 
        """
        return _Tpetra.MultiVector_double_assign(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(MultiVector_double self) -> PyObject *"""
        return _Tpetra.MultiVector_double__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector_double self) -> PyObject *"""
        return _Tpetra.MultiVector_double___distarray__(self, *args)

MultiVector_double_swigregister = _Tpetra.MultiVector_double_swigregister
MultiVector_double_swigregister(MultiVector_double)


upgradeMultiVectorClass(MultiVector_double)

class Vector_double(MultiVector_double):
    """


    A distributed dense vector.

    Parameters:
    -----------

    Scalar:  The type of each entry of the vector. (You can use real-
    valued or complex-valued types here, unlike in Epetra, where the
    scalar type is always double.)

    LocalOrdinal:  The type of local indices. See the documentation of Map
    for requirements.

    GlobalOrdinal:  The type of global indices. See the documentation of
    Map for requirements.

    Node:  The Kokkos Node type. See the documentation of Map for
    requirements.

    classic:  DO NOT SPECIFY THIS EXPLICITLY. This exists only for
    backwards compatibility. It must always be false.

    This class inherits from MultiVector, and has the same template
    parameters. A Vector is a special case of a MultiVector that has only
    one vector (column). It may be used wherever a MultiVector may be
    used. Please see the documentation of MultiVector for more details.

    C++ includes: Tpetra_Vector_decl.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [MultiVector_double]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_double, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector_double]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Vector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, bool const zeroOut=True) -> Vector_double
        __init__(Tpetra::Vector<(double,int,long long,DefaultNodeType)> self, Vector_double source) -> Vector_double
        __init__(Tpetra::Vector<(double,int,long long,DefaultNodeType)> self, Vector_double source, Teuchos::DataAccess const copyOrView) -> Vector_double

        Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::Vector(const
        Teuchos::RCP< const map_type > &map, const dual_view_type &view, const
        dual_view_type &origView)

        Expert mode constructor, that takes a Kokkos::DualView of the Vector's
        data and the "original" Kokkos::DualView of the data, and returns a
        Vector that views those data.

        WARNING:  This constructor is only for expert users. We make no
        promises about backwards compatibility for this interface. It may
        change or go away at any time.  See the documentation of the
        MultiVector (parent class) constructor that takes the same arguments.

        Parameters:
        -----------

        map:  [in] Map describing the distribution of rows.

        view:  [in] View of the data (shallow copy).

        origView:  [in] "Original" view of the data (shallow copy). 
        """
        this = _Tpetra.new_Vector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Vector_double

    def replaceGlobalValue(self, *args):
        """
        replaceGlobalValue(Vector_double self, long long globalRow, double const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::replaceGlobalValue(const GlobalOrdinal globalRow, const Scalar
        &value) const

        Replace current value at the specified location with specified value.

        globalRow must be a valid global element on this node, according to
        the row map. 
        """
        return _Tpetra.Vector_double_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """
        sumIntoGlobalValue(Vector_double self, long long globalRow, double const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::sumIntoGlobalValue(const GlobalOrdinal globalRow, const Scalar
        &value, const bool atomic=base_type::useAtomicUpdatesByDefault) const

        Add value to existing value, using global (row) index.

        Add the given value to the existing value at row globalRow (a global
        index).

        This method affects the host memory version of the data. If the
        DeviceType template parameter is a device that has two memory spaces,
        and you want to modify the non-host version of the data, you must
        access the device View directly by calling getLocalView(). Please see
        modify(), sync(), and the discussion of DualView semantics elsewhere
        in the documentation.

        Parameters:
        -----------

        globalRow:  [in] Global row index of the entry to modify. This must be
        a valid global row index on the calling process with respect to the
        Vector's Map.

        value:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.Vector_double_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """
        replaceLocalValue(Vector_double self, int myRow, double const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::replaceLocalValue(const LocalOrdinal myRow, const Scalar &value)
        const

        Replace current value at the specified location with specified values.

        localRow must be a valid local element on this node, according to the
        row map. 
        """
        return _Tpetra.Vector_double_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """
        sumIntoLocalValue(Vector_double self, int myRow, double const & value)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::sumIntoLocalValue(const LocalOrdinal myRow, const Scalar &value,
        const bool atomic=base_type::useAtomicUpdatesByDefault) const

        Add value to existing value, using local (row) index.

        Add the given value to the existing value at row localRow (a local
        index).

        This method affects the host memory version of the data. If the
        DeviceType template parameter is a device that has two memory spaces,
        and you want to modify the non-host version of the data, you must
        access the device View directly by calling getLocalView(). Please see
        modify(), sync(), and the discussion of DualView semantics elsewhere
        in the documentation.

        Parameters:
        -----------

        localRow:  [in] Local row index of the entry to modify.

        value:  [in] Incoming value to add to the entry.

        atomic:  [in] Whether to use an atomic update. If this class'
        execution space is not Kokkos::Serial, then this is true by default,
        else it is false by default. 
        """
        return _Tpetra.Vector_double_sumIntoLocalValue(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(Vector_double self)
        get1dCopy(Vector_double self, Teuchos::ArrayView< double > const & A)

        void
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::get1dCopy(const Teuchos::ArrayView< Scalar > &A) const

        Return multi-vector values in user-provided two-dimensional array
        (using Teuchos memory management classes). 
        """
        return _Tpetra.Vector_double_get1dCopy(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(Vector_double self)
        getDataNonConst(Vector_double self) -> Teuchos::ArrayRCP< double >

        Teuchos::ArrayRCP<Scalar> Tpetra::Vector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getDataNonConst()

        View of the local values of this vector. 
        """
        return _Tpetra.Vector_double_getDataNonConst(self, *args)


    def getData(self, *args):
        """
        getData(Vector_double self)
        getData(Vector_double self) -> Teuchos::ArrayRCP< double const >

        Teuchos::ArrayRCP<const Scalar> Tpetra::Vector< Scalar, LocalOrdinal,
        GlobalOrdinal, Node, classic >::getData() const

        Const view of the local values of this vector. 
        """
        return _Tpetra.Vector_double_getData(self, *args)


    def norm2(self, *args):
        """
        norm2(Vector_double self)
        norm2(Vector_double self) -> Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type

        Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::mag_type Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::norm2() const

        Return the two-norm of this Vector. 
        """
        return _Tpetra.Vector_double_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(Vector_double self)
        normInf(Vector_double self) -> Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type

        Vector< Scalar,
        LocalOrdinal, GlobalOrdinal, Node, classic >::mag_type Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic >::normInf() const

        Return the infinity-norm of this Vector. 
        """
        return _Tpetra.Vector_double_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(Vector_double self)
        meanValue(Vector_double self) -> double

        Scalar
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::meanValue() const

        Compute mean (average) value of this Vector. 
        """
        return _Tpetra.Vector_double_meanValue(self, *args)


    def description(self, *args):
        """
        description(Vector_double self) -> std::string

        std::string
        Tpetra::Vector< Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::description() const

        Return a one-line description of this object. 
        """
        return _Tpetra.Vector_double_description(self, *args)


    def describe(self, *args):
        """
        describe(Vector_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Tpetra::Vector<
        Scalar, LocalOrdinal, GlobalOrdinal, Node, classic
        >::describe(Teuchos::FancyOStream &out, const Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Describe this object in a human-readable way to the given output
        stream.

        You must call this method as a collective over all processes in this
        object's communicator.

        Parameters:
        -----------

        out:  [out] Output stream to which to write. Only Process 0 in this
        object's communicator may write to the output stream.

        verbLevel:  [in] Verbosity level. This also controls whether this
        method does any communication. At verbosity levels higher (greater)
        than Teuchos::VERB_LOW, this method may behave as a collective over
        the object's communicator.

        Teuchos::FancyOStream wraps std::ostream. It adds features like tab
        levels. If you just want to wrap std::cout, try this: 
        """
        return _Tpetra.Vector_double_describe(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(Vector_double self) -> PyObject *"""
        return _Tpetra.Vector_double__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector_double self) -> PyObject *"""
        return _Tpetra.Vector_double___distarray__(self, *args)

Vector_double_swigregister = _Tpetra.Vector_double_swigregister
Vector_double_swigregister(Vector_double)


upgradeVectorClass(Vector_double)


def MultiVector(*args, **kwargs):
  dtype = None
  if len(args) > 0:
    try:
      dtype = str(args[0].dtype)
    except AttributeError:
      pass
  dtype = kwargs.get("dtype", dtype)
  if dtype is None: dtype = "int64"
  if type(dtype) == str:
    dtype = numpy.dtype(dtype)
  if dtype.type is numpy.int32:
    result = MultiVector_int(*args)
  elif dtype.type is numpy.int64:
    result = MultiVector_long(*args)
#elif dtype.type is numpy.float32:
#  result = MultiVector_float(*args)
  elif dtype.type is numpy.float64:
    result = MultiVector_double(*args)
  else:
    raise TypeError("Unsupported or unrecognized dtype = %s" %
                    str(dtype))
  return result

def Vector(*args, **kwargs):
  dtype = None
  if len(args) > 0:
    try:
      dtype = str(args[0].dtype)
    except AttributeError:
      pass
  dtype = kwargs.get("dtype", dtype)
  if dtype is None: dtype = "int64"
  if type(dtype) == str:
    dtype = numpy.dtype(dtype)
  if dtype.type is numpy.int32:
    result = Vector_int(*args)
  elif dtype.type is numpy.int64:
    result = Vector_long(*args)
#elif dtype.type is numpy.float32:
#  result = Vector_float(*args)
  elif dtype.type is numpy.float64:
    result = Vector_double(*args)
  else:
    raise TypeError("Unsupported or unrecognized dtype = %s" %
                    str(dtype))
  return result

# This file is compatible with both classic and new-style classes.


