# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.StatusTest is the python interface to the namespace
StatusTest in Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.StatusTest is to provide clompletely flexible
specification of stopping tests for NOX algorithms.

NOX.StatusTest provides the following user-level classes:

    * Generic      - Base class for all stopping tests
    * Combo        - Allows combining of stopping tests with AND or OR
    * NormF        - Stopping test based on norm of F
    * NormUpdate   - Stopping test based on norm of update
    * NormWRMS     - Stopping test based on norm of weighted RMS of F
    * MaxIters     - Stopping test based on maximum iterations
    * Stagnation   - Stopping test based on algorithm stagnation
    * FiniteValue  - Stopping test based on detecting NaNs

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_StatusTest')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_StatusTest')
    _StatusTest = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_StatusTest', [dirname(__file__)])
        except ImportError:
            import _StatusTest
            return _StatusTest
        try:
            _mod = imp.load_module('_StatusTest', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _StatusTest = swig_import_helper()
    del swig_import_helper
else:
    import _StatusTest
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _StatusTest.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _StatusTest.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _StatusTest.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _StatusTest.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _StatusTest.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _StatusTest.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _StatusTest.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _StatusTest.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _StatusTest.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
Unevaluated = _StatusTest.Unevaluated
Unconverged = _StatusTest.Unconverged
Converged = _StatusTest.Converged
Failed = _StatusTest.Failed
Complete = _StatusTest.Complete
Minimal = _StatusTest.Minimal
StatusTest_None = _StatusTest.StatusTest_None
class Generic(_object):
    """


    Generic status test to check for convergence or failure of the
    nonlinear solver.

    C++ includes: NOX_StatusTest_Generic.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Generic, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Generic, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _StatusTest.delete_Generic

    def checkStatus(self, *args):
        """
        checkStatus(Generic self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        virtual
        NOX::StatusTest::StatusType
        NOX::StatusTest::Generic::checkStatus(const NOX::Solver::Generic
        &problem, NOX::StatusTest::CheckType checkType)=0

        Test the stopping criterion

        The test can (and should, if possible) be skipped if checkType is
        NOX::StatusType::None. If the test is skipped, then the status should
        be set to NOX::StatusTest::Unevaluated. 
        """
        return _StatusTest.Generic_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(Generic self) -> NOX::StatusTest::StatusType

        virtual
        NOX::StatusTest::StatusType NOX::StatusTest::Generic::getStatus()
        const =0

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.Generic_getStatus(self, *args)


    def __str__(self, *args):
        """__str__(Generic self) -> std::string"""
        return _StatusTest.Generic___str__(self, *args)

Generic_swigregister = _StatusTest.Generic_swigregister
Generic_swigregister(Generic)


def __lshift__(*args):
    """__lshift__(std::ostream & os, NOX::StatusTest::StatusType type) -> std::ostream &"""
    return _StatusTest.__lshift__(*args)
class Combo(Generic):
    """


    Arbitrary combination of status tests.

    In the AND (see NOX::StatusTest::Combo::ComboType) combination, the
    result is Unconverged (see NOX::StatusTest::StatusType) if any of the
    tests is Unconverged. Otherwise, the result is equal to the result of
    the first test in the list that is either Converged or Failed. It is
    not recommended to mix Converged and Failed tests in an AND
    combination.

    In the OR combination, the result is Unconverged if all of the tests
    are Unconverged. Otherwise, it is the result of the first test in the
    list that is either Converged or Failed. Therefore, it will generally
    make sense to put the Failed -type tests at the end of the OR list.

    We call checkStatus on every convergence test, though some may be
    called with the NOX::StatusTest::None option.

    Tammy Kolda (SNL 8950) and Roger Pawlowski (SNL 1416)

    C++ includes: NOX_StatusTest_Combo.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Combo, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Combo, name)
    __repr__ = _swig_repr
    AND = _StatusTest.Combo_AND
    OR = _StatusTest.Combo_OR

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::Combo self, NOX::StatusTest::Combo::ComboType t, NOX::Utils const * u=None) -> Combo
        __init__(NOX::StatusTest::Combo self, NOX::StatusTest::Combo::ComboType t, Teuchos::RCP< NOX::StatusTest::Generic > const & a, NOX::Utils const * u=None) -> Combo
        __init__(NOX::StatusTest::Combo self, NOX::StatusTest::Combo::ComboType t, Teuchos::RCP< NOX::StatusTest::Generic > const & a, Teuchos::RCP< NOX::StatusTest::Generic > const & b, NOX::Utils const * u=None) -> Combo

        NOX::StatusTest::Combo::Combo(ComboType t, const Teuchos::RCP< Generic
        > &a, const Teuchos::RCP< Generic > &b, const NOX::Utils *u=NULL)

        Constructor with two tests. 
        """
        this = _StatusTest.new_Combo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def addStatusTest(self, *args):
        """
        addStatusTest(Combo self, Teuchos::RCP< NOX::StatusTest::Generic > const & a) -> Combo

        NOX::StatusTest::Combo & NOX::StatusTest::Combo::addStatusTest(const
        Teuchos::RCP< Generic > &a)

        Add another test to this combination.

        Calls isSafe() to determine if it is safe to add a to the combination.

        """
        return _StatusTest.Combo_addStatusTest(self, *args)

    __swig_destroy__ = _StatusTest.delete_Combo

    def checkStatus(self, *args):
        """
        checkStatus(Combo self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::Combo::checkStatus(const
        NOX::Solver::Generic &problem, NOX::StatusTest::CheckType checkType)

        Tests stopping criterion.

        See addOp() and orOp() for details. 
        """
        return _StatusTest.Combo_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(Combo self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::Combo::getStatus() const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.Combo_getStatus(self, *args)

Combo_swigregister = _StatusTest.Combo_swigregister
Combo_swigregister(Combo)

class NormF(Generic):
    """


    Various convergence tests based on the norm of the residual.

    Use the constructor to define the test based on the type of scaling
    (see ScaleType) and the type of Tolerance (see Tolerance).

    If checkStatus is called with the type set to NOX::StatusTest::None,
    then the status is set to NOX::StatusTest::Unevaluated and returned.
    (Also #normF is set to 0.0.)

    If checkStatus is called on a problem where the solution group does
    not have F evaluated (i.e., problem.getSolutionGroup().isF() is
    false), then the status is set to NOX::StatusTest::Unconverged and
    returned. (Also #normF is set to -1.0.)

    Finally, we return NOX::StatusTest::Converged if $\\alpha <
    \\beta$, and NOX::StatusTest::Unconverged otherwise. Here
    $\\alpha$ represents the norm of $F(x)$ and $\\beta$ represents
    the tolerance, as described below.

    Let $\\gamma$ denote an optional scale factor defined as

    $\\gamma = \\frac{1}{n}$ if sType in the constructor is
    NOX::NormF::Scaled, and

    Then $\\alpha$ is defined as follows:

    If nType in the constructor is Abstract::Vector::TWO, then \\[
    \\alpha = \\sqrt{ \\gamma \\sum_{i=1}^n F_i^2 } \\]

    If nType in the constructor is Abstract::Vector::ONE, then \\[
    \\alpha = \\gamma \\sum_{i=1}^n | F_i | \\]

    If nType in the constructor is Abstract::Vector::INF, then \\[
    \\alpha = \\gamma \\max_{i} | F_i | \\]

    We set $\\beta$ as follows, based on the value of tolerance in the
    constructor.

    If an initial guess is provided, we use a relative tolerance defined
    by \\[ \\beta = \\alpha_0 * \\mbox{tolerance} \\] Here
    $\\alpha_0$ is the $\\alpha$ (as defined above) associated with
    the initial guess.

    Otherwise, we use an absolute tolerance defined by \\[ \\beta =
    \\mbox{tolerance} \\]

    C++ includes: NOX_StatusTest_NormF.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormF, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormF, name)
    __repr__ = _swig_repr
    Unscaled = _StatusTest.NormF_Unscaled
    Scaled = _StatusTest.NormF_Scaled
    Relative = _StatusTest.NormF_Relative
    Absolute = _StatusTest.NormF_Absolute

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::NormF self, double tolerance, NOX::Abstract::Vector::NormType ntype, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        __init__(NOX::StatusTest::NormF self, double tolerance, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        __init__(NOX::StatusTest::NormF self, Group initialGuess, double tolerance, NOX::Abstract::Vector::NormType ntype, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        __init__(NOX::StatusTest::NormF self, Group initialGuess, double tolerance, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF

        NOX::StatusTest::NormF::NormF(NOX::Abstract::Group &initialGuess,
        double tolerance, ScaleType stype=Scaled, const NOX::Utils *u=NULL)

        Constructor with initial guess (for relative norms)

        This constructor defaults to the Relative ToleranceType and TWO
        NormType. 
        """
        this = _StatusTest.new_NormF(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_NormF

    def checkStatus(self, *args):
        """
        checkStatus(NormF self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::NormF::checkStatus(const
        NOX::Solver::Generic &problem, NOX::StatusTest::CheckType checkType)

        Test the stopping criterion

        The test can (and should, if possible) be skipped if checkType is
        NOX::StatusType::None. If the test is skipped, then the status should
        be set to NOX::StatusTest::Unevaluated. 
        """
        return _StatusTest.NormF_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(NormF self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::NormF::getStatus() const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.NormF_getStatus(self, *args)


    def reset(self, *args):
        """
        reset(NormF self, double tolerance)
        reset(NormF self, Group initialGuess, double tolerance)

        void
        NOX::StatusTest::NormF::reset(NOX::Abstract::Group &initialGuess,
        double tolerance)

        Resets the user specified relative tolerance. 
        """
        return _StatusTest.NormF_reset(self, *args)


    def getNormF(self, *args):
        """
        getNormF(NormF self) -> double

        double
        NOX::StatusTest::NormF::getNormF() const

        Returns the value of the F-norm computed in the last call to
        checkStatus. 
        """
        return _StatusTest.NormF_getNormF(self, *args)


    def getTrueTolerance(self, *args):
        """
        getTrueTolerance(NormF self) -> double

        double NOX::StatusTest::NormF::getTrueTolerance() const

        Returns the true tolerance. 
        """
        return _StatusTest.NormF_getTrueTolerance(self, *args)


    def getSpecifiedTolerance(self, *args):
        """
        getSpecifiedTolerance(NormF self) -> double

        double NOX::StatusTest::NormF::getSpecifiedTolerance() const

        Returns the specified tolerance set in the constructor. 
        """
        return _StatusTest.NormF_getSpecifiedTolerance(self, *args)


    def getInitialTolerance(self, *args):
        """
        getInitialTolerance(NormF self) -> double

        double NOX::StatusTest::NormF::getInitialTolerance() const

        Returns the initial tolerance. 
        """
        return _StatusTest.NormF_getInitialTolerance(self, *args)

NormF_swigregister = _StatusTest.NormF_swigregister
NormF_swigregister(NormF)

class NormUpdate(Generic):
    """


    Various convergence tests based on the norm of the change in the
    solution vector, $ x $, between outer iterations.

    If checkStatusEfficiently is called with the type set to
    NOX::StatusTest::None, then the status is set to
    NOX::StatusTest::Unevaluated and returned. (Also #normUpdate is set to
    -1.0.)

    If checkStatusEfficiently is called on the first iteration, then the
    status is set to NOX::StatusTest::Unconverged and returned. (Also
    #normUpdate is set to -1.0.)

    If checkStatusEfficiently is called on a problem where the solution
    group does not have F evaluated (i.e.,
    problem.getSolutionGroup().isF() is false), then the status is set to
    NOX::StatusTest::Unconverged and returned. (Also #normUpdate is set to
    -1.0.)

    Finally, we return NOX::StatusTest::Converged if $\\alpha <
    \\beta$ and NOX::StatusTest::Uncoverged otherwise. Here $\\alpha$
    represents the norm of $ \\Delta x $ and $\\beta$ represents the
    tolerance. We define:

    \\[ \\Delta x = x_k - x_{k-1} \\]

    where $ x_k $ is the solution vector of the $ k $-th nonlinear
    iterate.

    Let $\\gamma$ denote an optional scale factor defined as

    $\\gamma = \\frac{1}{n}$ if sType in the constructor is
    NOX::NormF::Scaled, and

    $\\gamma = 1$ if sType in the constructor is NOX::NormF::Unscaled.

    Then $\\alpha$ is defined as follows:

    If nType in the constructor is Abstract::Vector::TWO, then \\[
    \\alpha = \\sqrt{ \\gamma \\sum_{i=1}^n \\Delta x_i^2 }
    \\]

    If nType in the constructor is Abstract::Vector::ONE, then \\[
    \\alpha = \\gamma \\sum_{i=1}^n | \\Delta x_i | \\]

    If nType in the constructor is Abstract::Vector::INF, then \\[
    \\alpha = \\gamma \\max_{i} | \\Delta x_i | \\]

    Finally, $\\beta$ is set to the tolerance in the constructor, i.e.,

    \\[ \\beta = \\mbox{tolerance} \\]

    C++ includes: NOX_StatusTest_NormUpdate.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormUpdate, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormUpdate, name)
    __repr__ = _swig_repr
    Unscaled = _StatusTest.NormUpdate_Unscaled
    Scaled = _StatusTest.NormUpdate_Scaled

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::NormUpdate self, double tolerance, NOX::Abstract::Vector::NormType ntype, NOX::StatusTest::NormUpdate::ScaleType stype) -> NormUpdate
        __init__(NOX::StatusTest::NormUpdate self, double tolerance, NOX::StatusTest::NormUpdate::ScaleType stype) -> NormUpdate

        NormUpdate::NormUpdate(double tolerance, ScaleType stype=Scaled)

        Constructor for absolute norm.

        This constructor defaults to the Absolute ToleranceType and TWO
        NormType. 
        """
        this = _StatusTest.new_NormUpdate(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_NormUpdate

    def checkStatus(self, *args):
        """
        checkStatus(NormUpdate self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        StatusType NormUpdate::checkStatus(const NOX::Solver::Generic
        &problem, NOX::StatusTest::CheckType checkType)

        Test the stopping criterion

        The test can (and should, if possible) be skipped if checkType is
        NOX::StatusType::None. If the test is skipped, then the status should
        be set to NOX::StatusTest::Unevaluated. 
        """
        return _StatusTest.NormUpdate_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(NormUpdate self) -> NOX::StatusTest::StatusType

        StatusType NormUpdate::getStatus() const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.NormUpdate_getStatus(self, *args)


    def getNormUpdate(self, *args):
        """
        getNormUpdate(NormUpdate self) -> double

        double NOX::StatusTest::NormUpdate::getNormUpdate() const

        Returns the value of the Update-norm computed in the last call to
        checkStatus. 
        """
        return _StatusTest.NormUpdate_getNormUpdate(self, *args)


    def getTolerance(self, *args):
        """
        getTolerance(NormUpdate self) -> double

        double NOX::StatusTest::NormUpdate::getTolerance() const

        Returns the true tolerance. 
        """
        return _StatusTest.NormUpdate_getTolerance(self, *args)

NormUpdate_swigregister = _StatusTest.NormUpdate_swigregister
NormUpdate_swigregister(NormUpdate)

class NormWRMS(Generic):
    """


    Convergence test based on the weighted root mean square norm fo the
    solution update between iterations.

    ` If the number of iterations is zero, then the status is set to
    NOX::StatusTest::Unconverged and returned. (Also, #value is set to
    1.0e+12.)

    Otherwise, returns NOX::StatusTest::Converged if the three criteria
    listed below are satisfied. Note that use of Criteria #2 and #3 depend
    on the options set in the solver.

    Weigthed root mean square norm is less than a specified tolerance:

    \\[ ||\\delta x^k||_{wrms} < \\mbox{tolerance} \\]

    where

    \\[ ||\\delta x^k||_{wrms} \\equiv C \\sqrt{ \\frac{1}{N}
    \\sum_{i=1}^N \\left( \\frac {(x^k_i-x^{k-1}_i)}{RTOL
    |x^{k-1}_i| + ATOL_i} \\right) ^2 } \\]

    Here:

    $x_i^k$ denotes component $i$ of nonlinear iterate $k$.

    $N$ denotes the number of unknowns

    $RTOL$ denotes the relative error tolerance, specified via rtol in the
    constructor

    $ATOL$ denotes the absolution error tolerance, specified via atol in
    the constructor. This can be a vector or a scalar.

    $C$ denotes a weight, specified via the parameter BDFMultiplier in the
    constructor.

    If a line search based solver is used, the line search step size, $
    \\lambda $, must be greater than a specified step size value, $
    \\alpha $:

    \\[ \\lambda > \\alpha \\]

    The motivation for this test is to avoid detecting stagnation when in
    fact the true problem is that the step size is just small.

    The value of $\\alpha$ is set in the constructor via the argument
    alpha. Setting $\\alpha$ to zero effectively eliminates this part of
    the test.

    The achieved linear solver tolerance, $ \\eta^k $ for nonlinear
    iteration $ k $, must be less than a specified tolerance value, $
    \\beta $; i.e.,

    \\[ \\eta^k < \\beta \\]

    The motivation for this test is to avoid detecting stagnation when in
    fact the true problem is that the linear solve tolerance was not
    accurate enough.

    The value of $\\beta$ is set in the constructor via the argument
    beta. Setting $\\beta$ to 1.0 effectively eliminates this part of
    the test.

    This criteria will only be used if the "Achieved Tolerance"
    parameter (the value of $ \\eta^k $) is set by the linear solver in
    the "Newton"/"Linear Solver"/"Output" sublist. The checkStatus()
    method will search for this parameter.

    References:

    K. E. Brennam, S. L. Cambell, L. R. Petzold, Numerical Solution of
    Initial-Value Problems in Differential-Algebraic Equations, Classics
    in Applied Mathematics 14, SIAM 1996.

    G. D. Byrne and A. C. Hindmarch, PVODE, an ODE Solver for Parallel
    Computers, Technical Report UCRL-JC-132361, Rev. 1, Center for Applied
    Scientific Computing (CASC), Lawrence Livermore National Lab, May
    1999.

    C++ includes: NOX_StatusTest_NormWRMS.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormWRMS, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormWRMS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::NormWRMS self, double rtol, double atol, double BDFMultiplier=1.0, double tolerance=1.0, double alpha=1.0, double beta=0.5, bool disable_implicit_weighting=True) -> NormWRMS
        __init__(NOX::StatusTest::NormWRMS self, double rtol, Teuchos::RCP< NOX::Abstract::Vector const > const & atol, double BDFMultiplier=1.0, double tolerance=1.0, double alpha=1.0, double beta=0.5, bool disable_implicit_weighting=True) -> NormWRMS

        NormWRMS::NormWRMS(double rtol, const Teuchos::RCP< const
        NOX::Abstract::Vector > &atol, double BDFMultiplier=1.0, double
        tolerance=1.0, double alpha=1.0, double beta=0.5, bool
        disable_implicit_weighting=true)

        Constructor where ATOL is a vector. 
        """
        this = _StatusTest.new_NormWRMS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_NormWRMS

    def checkStatus(self, *args):
        """
        checkStatus(NormWRMS self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        StatusType NormWRMS::checkStatus(const NOX::Solver::Generic &problem,
        NOX::StatusTest::CheckType checkType)

        Test the stopping criterion

        The test can (and should, if possible) be skipped if checkType is
        NOX::StatusType::None. If the test is skipped, then the status should
        be set to NOX::StatusTest::Unevaluated. 
        """
        return _StatusTest.NormWRMS_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(NormWRMS self) -> NOX::StatusTest::StatusType

        StatusType NormWRMS::getStatus() const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.NormWRMS_getStatus(self, *args)


    def getNormWRMS(self, *args):
        """
        getNormWRMS(NormWRMS self) -> double

        double
        NormWRMS::getNormWRMS() const

        Returns the value of WRMS norm. 
        """
        return _StatusTest.NormWRMS_getNormWRMS(self, *args)


    def getTolerance(self, *args):
        """
        getTolerance(NormWRMS self) -> double

        double NormWRMS::getTolerance() const

        Returns the requested tolerance set in the constructor. 
        """
        return _StatusTest.NormWRMS_getTolerance(self, *args)


    def getRTOL(self, *args):
        """
        getRTOL(NormWRMS self) -> double

        double
        NormWRMS::getRTOL() const

        Returns the realative tolerance set in the constructor. 
        """
        return _StatusTest.NormWRMS_getRTOL(self, *args)


    def getATOL(self, *args):
        """
        getATOL(NormWRMS self) -> double

        double
        NormWRMS::getATOL() const

        Returns the absolute tolerance set in the constructor. If ATOL is a
        vector, this will return a value of -1.0. 
        """
        return _StatusTest.NormWRMS_getATOL(self, *args)


    def getBDFMultiplier(self, *args):
        """
        getBDFMultiplier(NormWRMS self) -> double

        double NormWRMS::getBDFMultiplier() const

        Returns the value of the BDFMultiplier set in the constructor. 
        """
        return _StatusTest.NormWRMS_getBDFMultiplier(self, *args)


    def getAlpha(self, *args):
        """
        getAlpha(NormWRMS self) -> double

        double
        NormWRMS::getAlpha() const

        Returns the value of 'alpha' set in the constructor. 
        """
        return _StatusTest.NormWRMS_getAlpha(self, *args)


    def getBeta(self, *args):
        """
        getBeta(NormWRMS self) -> double

        double
        NormWRMS::getBeta() const

        Returns the value of 'beta' set in the constructor. 
        """
        return _StatusTest.NormWRMS_getBeta(self, *args)


    def getDisableImplicitWeighting(self, *args):
        """
        getDisableImplicitWeighting(NormWRMS self) -> bool

        bool
        NormWRMS::getDisableImplicitWeighting() const

        Returns true if implicit weighting is disabled during norm
        computation. 
        """
        return _StatusTest.NormWRMS_getDisableImplicitWeighting(self, *args)

NormWRMS_swigregister = _StatusTest.NormWRMS_swigregister
NormWRMS_swigregister(NormWRMS)

class MaxIters(Generic):
    """


    Failure test based on the maximum number of nonlinear solver
    iterations.

    Let $k$ denote the current number of iterations (accessed via
    NOX::Solver::getNumIterations) and $k_{\\max}$ denote the tolerance
    set in the constructor of this status test. This test returns
    NOX::StatusTest::Failed if $ k \\geq k_{\\rm max}. $ Otherwise, it
    returns NOX::StatusTest::Unconverged.

    If checkStatus is called with the type set to NOX::StatusTest::None,
    it then the status is set to to NOX::Status::Unevaluated and returned.
    (Also #niters is set to -1.)

    C++ includes: NOX_StatusTest_MaxIters.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaxIters, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaxIters, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::MaxIters self, int maxIterations, NOX::Utils const * u=None) -> MaxIters

        NOX::StatusTest::MaxIters::MaxIters(int maxIterations, const
        NOX::Utils *u=NULL)

        Constructor. Specify the maximum number of nonlinear solver
        iterations, $k_{\\max}$ ands optinally an error stream for printing
        errors. 
        """
        this = _StatusTest.new_MaxIters(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_MaxIters

    def checkStatus(self, *args):
        """
        checkStatus(MaxIters self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType
        NOX::StatusTest::MaxIters::checkStatus(const NOX::Solver::Generic
        &problem, NOX::StatusTest::CheckType checkType)

        Test the stopping criterion

        The test can (and should, if possible) be skipped if checkType is
        NOX::StatusType::None. If the test is skipped, then the status should
        be set to NOX::StatusTest::Unevaluated. 
        """
        return _StatusTest.MaxIters_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(MaxIters self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::MaxIters::getStatus()
        const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.MaxIters_getStatus(self, *args)


    def getMaxIters(self, *args):
        """
        getMaxIters(MaxIters self) -> int

        int
        NOX::StatusTest::MaxIters::getMaxIters() const

        Returns the Maximum number of iterations set in the constructor. 
        """
        return _StatusTest.MaxIters_getMaxIters(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(MaxIters self) -> int

        int
        NOX::StatusTest::MaxIters::getNumIters() const

        Returns the current number of iterations taken by the solver.

        Returns -1 if the status of this test is NOX::StatusTest::Unevaluated.

        """
        return _StatusTest.MaxIters_getNumIters(self, *args)

MaxIters_swigregister = _StatusTest.MaxIters_swigregister
MaxIters_swigregister(MaxIters)

class Stagnation(Generic):
    """


    Failure test based on the convergence rate between nonlinear
    iterations.

    This status test returns NOX::StatusTest::Failed if we fail to reduce
    the norm of $F$ by a specified tolerance for n consecutive iterations.
    In other words, if

    \\[ \\frac{\\| F_k \\|}{\\| F_{k-1} \\|} \\geq {\\rm
    tolerance}\\]

    for n consecutive iterations, the status is set to
    NOX::StatusTest::Failed and returned. Otherwise, the status is set to
    NOX::StatusTest::Uncoverged and returned. Both n and the tolerance are
    specified in the constructor, by n and tol, respectively.

    Based on experience the following values are recommended:

    For Newton solves: n = 50, tolerance = 1.0

    For Newton solves with a line search: n = 15, tolerance = 0.99

    C++ includes: NOX_StatusTest_Stagnation.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Stagnation, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Stagnation, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::Stagnation self, int n=50, double tol=1.0) -> Stagnation

        NOX::StatusTest::Stagnation::Stagnation(int n=50, double tol=1.0)

        Constructor.

        Parameters:
        -----------

        n:  - Number of consecutive nonlinear iterations

        tol:  - Tolerance for stagnation test 
        """
        this = _StatusTest.new_Stagnation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_Stagnation

    def checkStatus(self, *args):
        """
        checkStatus(Stagnation self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType
        NOX::StatusTest::Stagnation::checkStatus(const NOX::Solver::Generic
        &problem, NOX::StatusTest::CheckType checkType)

        Tests the stopping criterion.

        The nature of this test is such that it must be executed at every
        nonlinear iteration, so we don't use the checkType argument. 
        """
        return _StatusTest.Stagnation_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(Stagnation self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::Stagnation::getStatus()
        const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.Stagnation_getStatus(self, *args)


    def getMaxNumSteps(self, *args):
        """
        getMaxNumSteps(Stagnation self) -> int

        int NOX::StatusTest::Stagnation::getMaxNumSteps() const

        Returns the used specified number of steps that can consecutively fail
        the tolerance test before the test returns a failed status. 
        """
        return _StatusTest.Stagnation_getMaxNumSteps(self, *args)


    def getCurrentNumSteps(self, *args):
        """
        getCurrentNumSteps(Stagnation self) -> int

        int NOX::StatusTest::Stagnation::getCurrentNumSteps() const

        Returns the current number of steps that have consecutively failed the
        tolerance test. 
        """
        return _StatusTest.Stagnation_getCurrentNumSteps(self, *args)


    def getTolerance(self, *args):
        """
        getTolerance(Stagnation self) -> double

        double NOX::StatusTest::Stagnation::getTolerance() const

        Returns the user specified tolerance. 
        """
        return _StatusTest.Stagnation_getTolerance(self, *args)


    def getConvRate(self, *args):
        """
        getConvRate(Stagnation self) -> double

        double NOX::StatusTest::Stagnation::getConvRate() const

        Returns the current convergence rate. 
        """
        return _StatusTest.Stagnation_getConvRate(self, *args)

Stagnation_swigregister = _StatusTest.Stagnation_swigregister
Stagnation_swigregister(Stagnation)

class FiniteValue(Generic):
    """


    Failure test based on whether the norm of a vector has a finite value.

    This test returns NOX::StatusTest::Failed if the norm of a vector is
    calssified as a NaN or Inf. Otherwise, it returns
    NOX::StatusTest::Unconverged. The user can specify whether to use the
    F vector or the solution vector from the current solution group for
    the check. NOX does not have access to vector entries so the number
    used in the NaN/Inf check is based on the norm of a vector.

    If checkStatus is called with the type set to NOX::StatusTest::None,
    then the status is set to NOX::Status::Unevaluated and returned.

    C++ includes: NOX_StatusTest_FiniteValue.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteValue, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteValue, name)
    __repr__ = _swig_repr
    FVector = _StatusTest.FiniteValue_FVector
    SolutionVector = _StatusTest.FiniteValue_SolutionVector

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::FiniteValue self, NOX::StatusTest::FiniteValue::VectorType v, NOX::Abstract::Vector::NormType n) -> FiniteValue

        NOX::StatusTest::FiniteValue::FiniteValue(VectorType v=FVector,
        NOX::Abstract::Vector::NormType n=NOX::Abstract::Vector::TwoNorm)

        Constructor. Specify which vector to check and with what norm to use.

        """
        this = _StatusTest.new_FiniteValue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_FiniteValue

    def checkStatus(self, *args):
        """
        checkStatus(FiniteValue self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType
        NOX::StatusTest::FiniteValue::checkStatus(const NOX::Solver::Generic
        &problem, NOX::StatusTest::CheckType checkType)

        Test the stopping criterion

        The test can (and should, if possible) be skipped if checkType is
        NOX::StatusType::None. If the test is skipped, then the status should
        be set to NOX::StatusTest::Unevaluated. 
        """
        return _StatusTest.FiniteValue_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(FiniteValue self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::StatusTest::FiniteValue::getStatus()
        const

        Return the result of the most recent checkStatus call. 
        """
        return _StatusTest.FiniteValue_getStatus(self, *args)


    def finiteNumberTest(self, *args):
        """
        finiteNumberTest(FiniteValue self, double x) -> int

        int NOX::StatusTest::FiniteValue::finiteNumberTest(double x) const

        The finite number test algorithm.

        Autoconf will test to see if the compiler implements the isnan() and
        isinf() functions in the cmath or math.h headers. If so, we will use
        these. If not, we supply a default implementation. The default
        implementation is only guaranteed to work if the code is IEEE 748/754
        compliant. The checks for isnan and isinf are separate because
        compilers like the old sgi platforms support one but not the other.
        See bug 2019 for more details.

        This method is public so that other objects (solvers, line searches,
        and directions) can use this test on their own values.

        Return Values: 0 = Finite Number

        -1 = NaN

        -2 = Inf 
        """
        return _StatusTest.FiniteValue_finiteNumberTest(self, *args)

FiniteValue_swigregister = _StatusTest.FiniteValue_swigregister
FiniteValue_swigregister(FiniteValue)

# This file is compatible with both classic and new-style classes.


