# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Solver is the python interface to the Solver namespace
of the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Solver is to provide solver manager classes for
NOX.  NOX.Solver provides the following user-level classes:

    * Generic                  - Base class for solver managers
    * LineSearchBased          - Line-search-based solver manager
    * TrustRegionBased         - Trust-region-based solver manager
    * InexactTrustRegionBased  - Inexact-trust-region-based solver
                                 manager
    * TensorBased              - Tensor-based solver manager

in addition to the following factory function:

    * buildSolver              - Recommended method for creating solver
                                 managers (note that without loss of
                                 functionality, the Factory class is not
                                 currently provided).

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Solver')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Solver')
    _Solver = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Solver', [dirname(__file__)])
        except ImportError:
            import _Solver
            return _Solver
        try:
            _mod = imp.load_module('_Solver', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Solver = swig_import_helper()
    del swig_import_helper
else:
    import _Solver
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Abstract
else:
    import Abstract
del _swig_python_version_info
import PyTrilinos.Epetra
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import StatusTest
else:
    import StatusTest
del _swig_python_version_info
class Generic(_object):
    """


    Abstract nonlinear solver method interface.

    Defines the type of access methods into the iterative nonlinear
    solvers.

    Instantiate or reset() the solver.

    Find the solution via solve() or perform a single iterations via
    iterate().

    Get information about the current solver state via getSolutionGroup(),
    getPreviousSolutionGroup(), getNumIterations(), and getList()
    particularily useful for NOX::StatusTest methods.

    Get the current status of the solver via getStatus().

    C++ includes: NOX_Solver_Generic.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Generic, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Generic, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Solver.delete_Generic

    def reset(self, *args):
        """
        reset(Generic self, Vector initial_guess)
        reset(Generic self, Vector initial_guess, Teuchos::RCP< NOX::StatusTest::Generic > const & test)

        virtual void
        NOX::Solver::Generic::reset(const NOX::Abstract::Vector
        &initial_guess, const Teuchos::RCP< NOX::StatusTest::Generic >
        &test)=0

        Resets the solver, sets a new status test, and sets a new initial
        guess. 
        """
        return _Solver.Generic_reset(self, *args)


    def getStatus(self, *args):
        """
        getStatus(Generic self) -> NOX::StatusTest::StatusType

        virtual
        NOX::StatusTest::StatusType NOX::Solver::Generic::getStatus()=0

        Check current convergence and failure status. 
        """
        return _Solver.Generic_getStatus(self, *args)


    def step(self, *args):
        """
        step(Generic self) -> NOX::StatusTest::StatusType

        virtual
        NOX::StatusTest::StatusType NOX::Solver::Generic::step()=0

        Do one nonlinear step in the iteration sequence and return status. 
        """
        return _Solver.Generic_step(self, *args)


    def solve(self, *args):
        """
        solve(Generic self) -> NOX::StatusTest::StatusType

        virtual
        NOX::StatusTest::StatusType NOX::Solver::Generic::solve()=0

        Solve the nonlinear problem and return final status.

        By "solve", we call iterate() until the NOX::StatusTest value is
        either NOX::StatusTest::Converged or NOX::StatusTest::Failed. 
        """
        return _Solver.Generic_solve(self, *args)


    def getNumIterations(self, *args):
        """
        getNumIterations(Generic self) -> int

        virtual int NOX::Solver::Generic::getNumIterations() const =0

        Get number of iterations. 
        """
        return _Solver.Generic_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """
        getSolutionGroup(Generic self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::Generic::getSolutionGroupPtr() const =0

        Return a RCP to the solution group. 
        """
        return _Solver.Generic_getSolutionGroup(self, *args)


    def getPreviousSolutionGroupPtr(self, *args):
        """
        getPreviousSolutionGroupPtr(Generic self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::Generic::getPreviousSolutionGroupPtr() const =0

        Return a RCP to the previous solution group. 
        """
        return _Solver.Generic_getPreviousSolutionGroupPtr(self, *args)


    def getList(self, *args):
        """
        getList(Generic self) -> Teuchos::RCP< Teuchos::ParameterList const >

        virtual
        Teuchos::RCP< const Teuchos::ParameterList >
        NOX::Solver::Generic::getListPtr() const =0

        Return a RCP to the solver parameters. 
        """
        return _Solver.Generic_getList(self, *args)

Generic_swigregister = _Solver.Generic_swigregister
Generic_swigregister(Generic)

class LineSearchBased(Generic):
    """


    Nonlinear solver based on a line search (i.e., damping)

    Solves $F(x)=0$ using an iterative line-search-based method.

    Each iteration, the solver does the following.

    Compute a search direction $d$ via a NOX::Direction method

    Compute a step length $\\lambda$ and update $x$ as $x_{\\rm new} =
    x_{\\rm old} + \\lambda d$ via a NOX::LineSearch method.

    The iterations progress until the status tests (see NOX::StatusTest)
    determine either failure or convergence.

    To support several line searches and status tests, this version of the
    solver has a getStepSize() function that returns $\\lambda$.  Input
    Parameters

    The following parameter list entries are valid for this solver:

    "Line Search" - Sublist of the line search parameters, passed to the
    NOX::LineSearch::Manager constructor. Defaults to an empty list.

    "Direction" - Sublist of the direction parameters, passed to the
    NOX::Direction::Manager constructor. Defaults to an empty list.

    "Solver Options" - Sublist of general solver options. "User Defined
    Pre/Post Operator" is supported. See NOX::Parameter::PrePostOperator
    for more details.

    Output Parameters

    Every time solve() is called, a sublist for output parameters called
    "Output" will be created and contain the following parameters.

    "Output":

    "Nonlinear Iterations" - Number of nonlinear iterations

    "2-Norm of Residual" - Two-norm of final residual

    Tammy Kolda (SNL 8950), Roger Pawlowski (SNL 9233)

    C++ includes: NOX_Solver_LineSearchBased.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LineSearchBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LineSearchBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Solver::LineSearchBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> LineSearchBased

        NOX::Solver::LineSearchBased::LineSearchBased(const Teuchos::RCP<
        NOX::Abstract::Group > &grp, const Teuchos::RCP<
        NOX::StatusTest::Generic > &tests, const Teuchos::RCP<
        Teuchos::ParameterList > &params)

        Constructor.

        See reset(NOX::Abstract::Group&, NOX::StatusTest::Generic&,
        Teuchos::ParameterList&) for description 
        """
        this = _Solver.new_LineSearchBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_LineSearchBased

    def reset(self, *args):
        """
        reset(LineSearchBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(LineSearchBased self, Vector initialGuess)

        void
        NOX::Solver::LineSearchBased::reset(const NOX::Abstract::Vector
        &initialGuess)

        Resets the solver and sets a new initial guess. 
        """
        return _Solver.LineSearchBased_reset(self, *args)


    def getStatus(self, *args):
        """
        getStatus(LineSearchBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::Solver::LineSearchBased::getStatus()

        Check current convergence and failure status. 
        """
        return _Solver.LineSearchBased_getStatus(self, *args)


    def step(self, *args):
        """
        step(LineSearchBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::Solver::LineSearchBased::step()

        Do one nonlinear step in the iteration sequence and return status. 
        """
        return _Solver.LineSearchBased_step(self, *args)


    def solve(self, *args):
        """
        solve(LineSearchBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::Solver::LineSearchBased::solve()

        Solve the nonlinear problem and return final status.

        By "solve", we call iterate() until the NOX::StatusTest value is
        either NOX::StatusTest::Converged or NOX::StatusTest::Failed. 
        """
        return _Solver.LineSearchBased_solve(self, *args)


    def getNumIterations(self, *args):
        """
        getNumIterations(LineSearchBased self) -> int

        int NOX::Solver::LineSearchBased::getNumIterations() const

        Get number of iterations. 
        """
        return _Solver.LineSearchBased_getNumIterations(self, *args)


    def getStepSize(self, *args):
        """
        getStepSize(LineSearchBased self) -> double

        double NOX::Solver::LineSearchBased::getStepSize() const 
        """
        return _Solver.LineSearchBased_getStepSize(self, *args)


    def getSolutionGroup(self, *args):
        """
        getSolutionGroup(LineSearchBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::LineSearchBased::getSolutionGroupPtr() const

        Return a RCP to the solution group. 
        """
        return _Solver.LineSearchBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroupPtr(self, *args):
        """
        getPreviousSolutionGroupPtr(LineSearchBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::LineSearchBased::getPreviousSolutionGroupPtr() const

        Return a RCP to the previous solution group. 
        """
        return _Solver.LineSearchBased_getPreviousSolutionGroupPtr(self, *args)


    def getList(self, *args):
        """
        getList(LineSearchBased self) -> Teuchos::RCP< Teuchos::ParameterList const >

        virtual Teuchos::RCP< const Teuchos::ParameterList >
        NOX::Solver::LineSearchBased::getListPtr() const

        Return a RCP to the solver parameters. 
        """
        return _Solver.LineSearchBased_getList(self, *args)

LineSearchBased_swigregister = _Solver.LineSearchBased_swigregister
LineSearchBased_swigregister(LineSearchBased)

class TrustRegionBased(Generic):
    """


    Newton-like solver using a trust region.

    Our goal is to solve: $ F(x) = 0, $ where $ F:\\Re^n \\rightarrow
    \\Re^n $. Alternatively, we might say that we wish to solve

    $ \\min f(x) \\equiv \\frac{1}{2} \\|F(x)\\|^2_2. $

    The trust region subproblem (TRSP) at iteration $k$ is given by

    $ \\min \\; m_k(s) \\equiv f_k + g_k^T d + \\frac{1}{2} d^T
    B_k d, \\mbox{ s.t. } \\|d\\| \\leq \\Delta_k \\quad
    \\mbox{(TRSP)} $

    where

    $ f_k = f(x_k) = \\frac{1}{2} \\|F(x_k)\\|^2_2 $,

    $ g_k = \\nabla f(x_k) = J(x_k)^T F(x_k) $,

    $ B_k = J(x_k)^T J(x_k) \\approx \\nabla^2 f(x_k) $,

    $ J(x_k)$ is the Jacobian of $F$ at $x_k$, and

    $ \\Delta_k $ is the trust region radius.

    The "improvement ratio" for a given step $ s $ is defined as

    $ \\rho = \\displaystyle\\frac{ f(x_k) - f(x_k + d) } { m_k(0) -
    m_k(d) } $

    An iteration consists of the following steps.

    Compute Newton-like direction: $n$

    Compute Cauchy-like direction: $c$

    If this is the first iteration, initialize $\\Delta$ as follows: If
    $\\|n\\|_2 < \\Delta_{\\min}$, then $\\Delta = 2
    \\Delta_{\\min}$; else, $\\Delta = \\|n\\|_2$.

    Initialize $\\rho = -1$

    While $\\rho < \\rho_{\\min}$ and $\\Delta >
    \\Delta_{\\min}$, do the following.

    Compute the direction $d$ as follows:

    If $\\|n\\|_2 < \\Delta$, then take a Newton step by setting $d
    = n$

    Otherwise if $\\|c\\|_2 > \\Delta$, then take a Cauchy step by
    setting $d = \\displaystyle\\frac{\\Delta}{\\|c\\|_2} c$

    Otherwise, take a Dog Leg step by setting $ d = (1-\\gamma) c +
    \\gamma n $ where $ \\gamma = \\displaystyle\\frac {-c^T a +
    \\sqrt{ (c^Ta)^2 - (c^Tc - \\Delta^2) a^Ta}}{a^Ta} $ with $a =
    n-c$.

    Set $x_{\\rm new} = x + d$ and calculate $f_{\\rm new}$

    If $f_{\\rm new} \\geq f$, then $\\rho = -1$ Otherwise $ \\rho
    = \\displaystyle \\frac {f - f_{\\rm new}} {| d^T J F +
    \\frac{1}{2} (J d)^T (J d)|} $

    Update the solution: $x = x_{\\rm new}$

    Update trust region:

    If $\\rho < \\rho_{\\rm s}$ and $\\|n\\|_2 < \\Delta$,
    then shrink the trust region to the size of the Newton step:
    $\\Delta = \\|n\\|_2$.

    Otherwise if $\\rho < \\rho_{\\rm s}$, then shrink the trust
    region: $\\Delta = \\max \\{ \\beta_{\\rm s} \\Delta,
    \\Delta_{\\min} \\} $.

    Otherwise if $\\rho > \\rho_{\\rm e}$ and $\\|d\\|_2 =
    \\Delta$, then expand the trust region: $\\Delta = \\min \\{
    \\beta_{\\rm e} \\Delta, \\Delta_{\\rm max} \\} $.

    Input Paramters

    The following parameters should be specified in the "Trust Region"
    sublist based to the solver.

    "Direction" - Sublist of the direction parameters for the Newton
    point, passed to the NOX::Direction::Manager constructor. If this
    sublist does not exist, it is created by default. Furthermore, if
    "Method" is not specified in this sublist, it is added with a value
    of "Newton".

    "Cauchy %Direction" - Sublist of the direction parameters for the
    Cauchy point, passed to the NOX::Direction::Manager constructor. If
    this sublist does not exist, it is created by default. Furthremore, if
    "Method" is not specified in this sublist, it is added with a value
    of "Steepest Descent" Finally, if the sub-sublist "Steepest
    Descent" does not exist, it is created and the parameter "Scaling
    Type" is added and set to "Quadratic".

    "Minimum Trust Region Radius" ( $\\Delta_{\\min}$) - Minimum
    allowable trust region radius. Defaults to 1.0e-6.

    "Maximum Trust Region Radius" ( $\\Delta_{\\max}$) - Maximum
    allowable trust region radius. Defaults to 1.0e+10.

    "Minimum Improvement Ratio" ( $\\rho_{\\min}$) - Minimum
    improvement ratio to accept the step. Defaults to 1.0e-4.

    "Contraction Trigger Ratio" ( $\\rho_{\\rm s}$) - If the
    improvement ratio is less than this value, then the trust region is
    contracted by the amount specified by the "Contraction Factor". Must
    be larger than "Minimum   Improvement Ratio". Defaults to 0.1.

    "Contraction Factor" ( $\\beta_{\\rm s}$) - See above. Defaults
    to 0.25.

    "Expansion Trigger Ratio" ( $\\rho_{\\rm e}$) - If the
    improvement ratio is greater than this value, then the trust region is
    contracted by the amount specified by the "Expansion Factor".
    Defaults to 0.75.

    "Expansion Factor" ( $\\beta_{\\rm e}$) - See above. Defaults to
    4.0.

    "Recovery Step" - Defaults to 1.0.

    "Use Ared/Pred Ratio Calculation" (boolean) - Defaults to false. If
    set to true, this option replaces the algorithm used to compute the
    improvement ratio, $ \\rho $, as described above. The improvement
    ratio is replaced by an "Ared/Pred" sufficient decrease criteria
    similar to that used in line search algorithms (see Eisenstat and
    Walker, SIAM Journal on Optimization V4 no. 2 (1994) pp 393-422):
    $\\rho = \\frac{\\|F(x) \\| - \\| F(x + d) \\| } {\\|
    F(x) \\| - \\| F(x) + Jd \\| } $

    "Solver Options" - Sublist of general solver options. "User Defined
    Pre/Post Operator" is supported. See NOX::Parameter::PrePostOperator
    for more details.

    Output Paramters

    A sublist for output parameters called "Output" will be created and
    contain the following parameters:

    "Nonlinear Iterations" - Number of nonlinear iterations

    "2-Norm or Residual" - Two-norm of final residual

    Tammy Kolda (SNL 8950), Roger Pawlowski (SNL 9233)

    C++ includes: NOX_Solver_TrustRegionBased.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrustRegionBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrustRegionBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Solver::TrustRegionBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> TrustRegionBased

        TrustRegionBased::TrustRegionBased(const Teuchos::RCP<
        NOX::Abstract::Group > &grp, const Teuchos::RCP<
        NOX::StatusTest::Generic > &tests, const Teuchos::RCP<
        Teuchos::ParameterList > &params)

        Constructor.

        See reset() for description. 
        """
        this = _Solver.new_TrustRegionBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_TrustRegionBased

    def reset(self, *args):
        """
        reset(TrustRegionBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(TrustRegionBased self, Vector initialGuess)

        void
        TrustRegionBased::reset(const NOX::Abstract::Vector &initialGuess)

        Resets the solver and sets a new initial guess. 
        """
        return _Solver.TrustRegionBased_reset(self, *args)


    def getStatus(self, *args):
        """
        getStatus(TrustRegionBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType TrustRegionBased::getStatus()

        Check current convergence and failure status. 
        """
        return _Solver.TrustRegionBased_getStatus(self, *args)


    def step(self, *args):
        """
        step(TrustRegionBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType TrustRegionBased::step()

        Do one nonlinear step in the iteration sequence and return status. 
        """
        return _Solver.TrustRegionBased_step(self, *args)


    def solve(self, *args):
        """
        solve(TrustRegionBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType TrustRegionBased::solve()

        Solve the nonlinear problem and return final status.

        By "solve", we call iterate() until the NOX::StatusTest value is
        either NOX::StatusTest::Converged or NOX::StatusTest::Failed. 
        """
        return _Solver.TrustRegionBased_solve(self, *args)


    def getNumIterations(self, *args):
        """
        getNumIterations(TrustRegionBased self) -> int

        int TrustRegionBased::getNumIterations() const

        Get number of iterations. 
        """
        return _Solver.TrustRegionBased_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """
        getSolutionGroup(TrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::TrustRegionBased::getSolutionGroupPtr() const

        Return a RCP to the solution group. 
        """
        return _Solver.TrustRegionBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroupPtr(self, *args):
        """
        getPreviousSolutionGroupPtr(TrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::TrustRegionBased::getPreviousSolutionGroupPtr() const

        Return a RCP to the previous solution group. 
        """
        return _Solver.TrustRegionBased_getPreviousSolutionGroupPtr(self, *args)


    def getList(self, *args):
        """
        getList(TrustRegionBased self) -> Teuchos::RCP< Teuchos::ParameterList const >

        virtual Teuchos::RCP< const Teuchos::ParameterList >
        NOX::Solver::TrustRegionBased::getListPtr() const

        Return a RCP to the solver parameters. 
        """
        return _Solver.TrustRegionBased_getList(self, *args)

TrustRegionBased_swigregister = _Solver.TrustRegionBased_swigregister
TrustRegionBased_swigregister(TrustRegionBased)

class InexactTrustRegionBased(Generic):
    """


    Newton-like solver using a trust region.

    Our goal is to solve: $ F(x) = 0, $ where $ F:\\Re^n \\rightarrow
    \\Re^n $. Alternatively, we might say that we wish to solve

    $ \\min f(x) \\equiv \\frac{1}{2} \\|F(x)\\|^2_2. $

    The trust region subproblem (TRSP) at iteration $k$ is given by

    $ \\min \\; m_k(s) \\equiv f_k + g_k^T d + \\frac{1}{2} d^T
    B_k d, \\mbox{ s.t. } \\|d\\| \\leq \\Delta_k \\quad
    \\mbox{(TRSP)} $

    where

    $ f_k = f(x_k) = \\frac{1}{2} \\|F(x_k)\\|^2_2 $,

    $ g_k = \\nabla f(x_k) = J(x_k)^T F(x_k) $,

    $ B_k = J(x_k)^T J(x_k) \\approx \\nabla^2 f(x_k) $,

    $ J(x_k)$ is the Jacobian of $F$ at $x_k$, and

    $ \\Delta_k $ is the trust region radius.

    The "improvement ratio" for a given step $ s $ is defined as

    $ \\rho = \\displaystyle\\frac{ f(x_k) - f(x_k + d) } { m_k(0) -
    m_k(d) } $

    An iteration consists of the following steps.

    Compute Newton-like direction: $n$

    Compute Cauchy-like direction: $c$

    If this is the first iteration, initialize $\\Delta$ as follows: If
    $\\|n\\|_2 < \\Delta_{\\min}$, then $\\Delta = 2
    \\Delta_{\\min}$; else, $\\Delta = \\|n\\|_2$.

    Initialize $\\rho = -1$

    While $\\rho < \\rho_{\\min}$ and $\\Delta >
    \\Delta_{\\min}$, do the following.

    Compute the direction $d$ as follows:

    If $\\|n\\|_2 < \\Delta$, then take a Newton step by setting $d
    = n$

    Otherwise if $\\|c\\|_2 > \\Delta$, then take a Cauchy step by
    setting $d = \\displaystyle\\frac{\\Delta}{\\|c\\|_2} c$

    Otherwise, take a Dog Leg step by setting $ d = (1-\\gamma) c +
    \\gamma n $ where $ \\gamma = \\displaystyle\\frac {-c^T a +
    \\sqrt{ (c^Ta)^2 - (c^Tc - \\Delta^2) a^Ta}}{a^Ta} $ with $a =
    n-c$.

    Set $x_{\\rm new} = x + d$ and calculate $f_{\\rm new}$

    If $f_{\\rm new} \\geq f$, then $\\rho = -1$ Otherwise $ \\rho
    = \\displaystyle \\frac {f - f_{\\rm new}} {| d^T J F +
    \\frac{1}{2} (J d)^T (J d)|} $

    Update the solution: $x = x_{\\rm new}$

    Update trust region:

    If $\\rho < \\rho_{\\rm s}$ and $\\|n\\|_2 < \\Delta$,
    then shrink the trust region to the size of the Newton step:
    $\\Delta = \\|n\\|_2$.

    Otherwise if $\\rho < \\rho_{\\rm s}$, then shrink the trust
    region: $\\Delta = \\max \\{ \\beta_{\\rm s} \\Delta,
    \\Delta_{\\min} \\} $.

    Otherwise if $\\rho > \\rho_{\\rm e}$ and $\\|d\\|_2 =
    \\Delta$, then expand the trust region: $\\Delta = \\min \\{
    \\beta_{\\rm e} \\Delta, \\Delta_{\\rm max} \\} $.

    Input Paramters

    The following parameters should be specified in the "Trust Region"
    sublist based to the solver.

    "Inner Iteration Method" - Choice of trust region algorithm to use.
    Choices are: "Standard Trust Region"

    "Inexact Trust Region"

    "Direction" - Sublist of the direction parameters for the Newton
    point, passed to the NOX::Direction::Manager constructor. If this
    sublist does not exist, it is created by default. Furthermore, if
    "Method" is not specified in this sublist, it is added with a value
    of "Newton".

    "Cauchy %Direction" - Sublist of the direction parameters for the
    Cauchy point, passed to the NOX::Direction::Manager constructor. If
    this sublist does not exist, it is created by default. Furthermore, if
    "Method" is not specified in this sublist, it is added with a value
    of "Steepest Descent" Finally, if the sub-sublist "Steepest
    Descent" does not exist, it is created and the parameter "Scaling
    Type" is added and set to "Quadratic Min Model".

    "Minimum Trust Region Radius" ( $\\Delta_{\\min}$) - Minimum
    allowable trust region radius. Defaults to 1.0e-6.

    "Maximum Trust Region Radius" ( $\\Delta_{\\max}$) - Minimum
    allowable trust region radius. Defaults to 1.0e+10.

    "Minimum Improvement Ratio" ( $\\rho_{\\min}$) - Minimum
    improvement ratio to accept the step. Defaults to 1.0e-4.

    "Contraction Trigger Ratio" ( $\\rho_{\\rm s}$) - If the
    improvement ratio is less than this value, then the trust region is
    contracted by the amount specified by the "Contraction Factor". Must
    be larger than "Minimum   Improvement Ratio". Defaults to 0.1.

    "Contraction Factor" ( $\\beta_{\\rm s}$) - See above. Defaults
    to 0.25.

    "Expansion Trigger Ratio" ( $\\rho_{\\rm e}$) - If the
    improvement ratio is greater than this value, then the trust region is
    contracted by the amount specified by the "Expansion Factor".
    Defaults to 0.75.

    "Expansion Factor" ( $\\beta_{\\rm e}$) - See above. Defaults to
    4.0.

    "Recovery Step" - Defaults to 1.0.

    "Use Ared/Pred Ratio Calculation" (boolean) - Defaults to false. If
    set to true, this option replaces the algorithm used to compute the
    improvement ratio, $ \\rho $, as described above. The improvement
    ratio is replaced by an "Ared/Pred" sufficient decrease criteria
    similar to that used in line search algorithms (see Eisenstat and
    Walker, SIAM Journal on Optimization V4 no. 2 (1994) pp 393-422):
    $\\rho = \\frac{\\|F(x) \\| - \\| F(x + d) \\| } {\\|
    F(x) \\| - \\| F(x) + Jd \\| } $

    "Use Cauchy in Newton Direction" - Boolean. Used only by the
    "Inexact Trust Region" algorithm. If set to true, the initial guess
    for the Newton direction computation will use the Cauchy direction as
    the initial guess. Defaults to false.

    "Use Dogleg Segment Minimization" - Boolean. Used only by the
    "Inexact Trust Region" algorithm. If set to true, the $ \\tau $
    parameter is minimized over the dogleg line segments instead of being
    computed at the trust regioin radius. Used only by the "Inexact Trust
    Region" algorithm. Defaults to false.

    "Use Counters" - Boolean. If set to true, solver statistics will be
    stored. Defaults to true.

    "Write Output Parameters" - Boolean. If set to true, the solver
    statistics will be written to the relevant "Output" sublists (see
    Output Parameters). Defaults to true.

    "Solver Options" - Sublist of general solver options. "User Defined
    Pre/Post Operator" is supported. See NOX::Parameter::PrePostOperator
    for more details.

    Output Paramters

    A sublist called "Output" will be created at the top level of the
    parameter list and contain the following general solver parameters:

    "Nonlinear Iterations" - Number of nonlinear iterations

    "2-Norm or Residual" - Two-norm of final residual

    A sublist called "Output" will be created in the "Trust Region"
    sublist and contain the following trust region specific output
    parameters:

    "Number of Cauchy Steps" - Number of cauchy steps taken during the
    solve.

    "Number of Newton Steps" - Number of Newton steps taken during the
    solve.

    "Number of Dogleg Steps" - Number of Dogleg steps taken during the
    solve.

    "Number of Trust Region Inner Iterations" - Number of inner
    iterations required to adjust the trust region radius.

    "Dogleg Steps: Average Fraction of Newton Step Length" - Average
    value of the fraction a dogleg step took compared to the full Newton
    step. The fractional value is computed as $ \\mbox{frac} =
    \\frac{\\| d \\|}{\\| n\\|} $.

    "Dogleg Steps: Average Fraction Between Cauchy and Newton Direction"
    - Average value of the fraction a dogleg step took between the Cauchy
    and Newton directions. This is the $ \\gamma $ variable in the
    standard dogleg algorithm and the $ \\tau $ parameter in the inexact
    dogleg algorithm. A value of 0.0 is a full step in the Cauchy
    direction and a value of 1.0 is a full step in the Newton direction.

    Tammy Kolda (SNL 8950), Roger Pawlowski (SNL 9233)

    C++ includes: NOX_Solver_InexactTrustRegionBased.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InexactTrustRegionBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InexactTrustRegionBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Solver::InexactTrustRegionBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> InexactTrustRegionBased

        NOX::Solver::InexactTrustRegionBased::InexactTrustRegionBased(const
        Teuchos::RCP< NOX::Abstract::Group > &grp, const Teuchos::RCP<
        NOX::StatusTest::Generic > &tests, const Teuchos::RCP<
        Teuchos::ParameterList > &params)

        Constructor.

        See reset() for description. 
        """
        this = _Solver.new_InexactTrustRegionBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_InexactTrustRegionBased

    def reset(self, *args):
        """
        reset(InexactTrustRegionBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(InexactTrustRegionBased self, Vector initialGuess)

        void NOX::Solver::InexactTrustRegionBased::reset(const
        NOX::Abstract::Vector &initialGuess)

        Resets the solver and sets a new initial guess. 
        """
        return _Solver.InexactTrustRegionBased_reset(self, *args)


    def getStatus(self, *args):
        """
        getStatus(InexactTrustRegionBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType
        NOX::Solver::InexactTrustRegionBased::getStatus()

        Check current convergence and failure status. 
        """
        return _Solver.InexactTrustRegionBased_getStatus(self, *args)


    def step(self, *args):
        """
        step(InexactTrustRegionBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType
        NOX::Solver::InexactTrustRegionBased::step()

        Do one nonlinear step in the iteration sequence and return status. 
        """
        return _Solver.InexactTrustRegionBased_step(self, *args)


    def solve(self, *args):
        """
        solve(InexactTrustRegionBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType
        NOX::Solver::InexactTrustRegionBased::solve()

        Solve the nonlinear problem and return final status.

        By "solve", we call iterate() until the NOX::StatusTest value is
        either NOX::StatusTest::Converged or NOX::StatusTest::Failed. 
        """
        return _Solver.InexactTrustRegionBased_solve(self, *args)


    def getNumIterations(self, *args):
        """
        getNumIterations(InexactTrustRegionBased self) -> int

        int
        NOX::Solver::InexactTrustRegionBased::getNumIterations() const

        Get number of iterations. 
        """
        return _Solver.InexactTrustRegionBased_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """
        getSolutionGroup(InexactTrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::InexactTrustRegionBased::getSolutionGroupPtr() const

        Return a RCP to the solution group. 
        """
        return _Solver.InexactTrustRegionBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroupPtr(self, *args):
        """
        getPreviousSolutionGroupPtr(InexactTrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::InexactTrustRegionBased::getPreviousSolutionGroupPtr()
        const

        Return a RCP to the previous solution group. 
        """
        return _Solver.InexactTrustRegionBased_getPreviousSolutionGroupPtr(self, *args)


    def getList(self, *args):
        """
        getList(InexactTrustRegionBased self) -> Teuchos::RCP< Teuchos::ParameterList const >

        virtual
        Teuchos::RCP< const Teuchos::ParameterList >
        NOX::Solver::InexactTrustRegionBased::getListPtr() const

        Return a RCP to the solver parameters. 
        """
        return _Solver.InexactTrustRegionBased_getList(self, *args)

InexactTrustRegionBased_swigregister = _Solver.InexactTrustRegionBased_swigregister
InexactTrustRegionBased_swigregister(InexactTrustRegionBased)

class TensorBased(Generic):
    """


    Nonlinear solver based on a rank-1 tensor method.

    Solves $F(x)=0$ using a rank-1 tensor method and a linesearch
    globalization.

    At the kth nonlinear iteration, the solver does the following:

    Computes the tensor direction $ d_T $ by finding the root or smallest
    magnitude minimizer of the local model \\[ M_T(x_k+d) = F_k + J_kd +
    a_k(s_k^Td)^2, \\] where \\[ a_k = 2(F_{k-1} - F_k - J_ks_k) /
    (s_k^Ts_k)^2 \\] and \\[ s_k = s_{k-1} - s_k. \\]

    Modifies the step according to a global strategy and updates $x$ as
    $x_{k+1} = x_k + d(\\lambda) $ via a linesearch method, where $
    d(\\lambda) $ is some function of $ \\lambda $. For instance, the
    curvilinear step $ d_{\\lambda T} $ is a function of the linesearch
    parameter $ \\lambda $ and is a parametric step that spans the
    directions of the tensor step and the Newton step. At $ \\lambda=1
    $, the curvilinear step equals the full tensor step, and as $
    \\lambda $ nears 0, the curvilinear step approaches the Newton
    direction. This step provides a monotonic decrease in the norm of the
    local tensor model as $ \\lambda $ varies from 0 to 1.

    The solver iterates until the status tests (see NOX::StatusTest)
    determine either failure or convergence.

    Input Parameters

    To use this solver, set the "Nonlinear Solver" parameter to be
    "Tensor Based". Then, specify the following sublists with the
    appropriate parameters as indicated below.

    "Direction" - Sublist of the direction parameters, passed to the
    NOX::Direction::Factory constructor. Defaults to an empty list.

    "Method" - Name of the direction to be computed in this solver.
    "Tensor" and "Newton" are the only two valid choices. A sublist by
    this name specifies all of the parameters to be passed to the linear
    solver. See below under "Linear Solver".

    "Rescue Bad Newton Solve" (Boolean) - If the linear solve does not
    meet the tolerance specified by the forcing term, then use the step
    anyway. Defaults to true.

    "Linear Solver" - Sublist for the specific linear solver parameters
    that are passed to NOX::Abstract::Group::computeNewton() and
    NOX::Abstract::Group::applyJacobianInverse(). "Linear Solver" is
    itself a sublist of the list specified in "Method" above (i.e.,
    "Tensor" or "Newton"). Below is a partial list of standard
    parameters usually available in common linear solvers. Check with the
    specific linear solver being used for other parameters.

    "Max Iterations" - Maximum number of Arnoldi iterations (also max
    Krylov space dimension)

    "Tolerance" - Relative tolerance for solving local model [default =
    1e-4]

    "Output Frequency" - Print output at every number of iterations
    [default = 20]

    "Line Search" - Sublist of the line search parameters. Because the
    tensor step is not guaranteed to be a descent direction on the
    function, not all "basic" line search approaches would be
    appropriate. Thus, the LineSearch classes available to Newton's method
    (e.g., Polynomial, More-Thuente) are not used here. Instead, this
    solver class approriately handles technical considerations for tensor
    methods with its own set of global strategies. The following
    parameters specify the specific options for this line search:

    "Method" - Name of the line search available to tensor methods Valid
    choices are: <ul>   <li> "Curvilinear" - Backtrack along the
    "curvilinear" path that spans the tensor direction and the Newton
    direction and that maintains monotonicity on the tensor model.
    Recommended because it tends to be more robust and efficient than the
    other choices. [Default]

    "Standard" - Backtrack along tensor direction unless it is not a
    descent direction, in which case backtrack along Newton direction.

    "Dual" - Backtrack along both the Newton and tensor directions and
    choose the better of the two.

    "Full Step" - Only use the full step and do not backtrack along both
    the Newton and tensor directions and choose the better of the
    two.</ul>

    "Lambda selection" - Flag for how to calculate the next linesearch
    parameter lambda. Valid choices are "Quadratic" and "Halving"
    (default). Quadratic constructs a quadratic interpolating polynomial
    from the last trial point and uses the minimum of this function as the
    next trial lambda (bounded by 0.1). Halving divides the linesearch
    parameter by 2 before each trial, which is simpler but tends to
    generate longer steps than quadratic.

    "Default Step" - Starting value of the linesearch parameter
    (defaults to 1.0)

    "Minimum Step" - Minimum acceptable linesearch parameter before the
    linesearch terminates (defaults to 1.0e-12). If there are many
    linesearch failures, then lowering this value is one thing to try.

    "Recovery Step Type" - Determines the step size to take when the
    line search fails. Choices are:

    "Constant" [default] - Uses a constant value set in "Recovery
    Step".

    "Last Computed Step" - Uses the last value computed by the line
    search algorithm.

    "Recovery Step" - Step parameter to take when the line search fails
    (defaults to value for "Default Step")

    "Max Iters" - Maximum number of iterations (i.e., backtracks)

    "Solver Options" - Sublist of general solver options.

    "User Defined Pre/Post Operator" is supported. See
    NOX::Parameter::PrePostOperator for more details.

    Output Parameters

    Every time solve() is called, a sublist for output parameters called
    "Output" will be created and will contain the following parameters:

    "Nonlinear Iterations" - Number of nonlinear iterations

    "2-Norm of Residual" - L-2 norm of the final residual $ F(x_k) $.

    References

    B. W. Bader, Tensor-Krylov methods for solving large-scale systems of
    nonlinear equations, Ph.D. Thesis, 2003, University of Colorado,
    Boulder, Colorado.

    B. W. Bader, Tensor-Krylov methods for solving large-scale systems of
    nonlinear equations, submitted to SIAM J. Numer. Anal.

    B. W. Bader and R. B. Schnabel, Curvilinear linesearch for tensor
    methods, SISC, 25(2):604-622.

    R. B. Schnabel and P. D. Frank, Tensor methods for nonlinear
    equations, SIAM J. Numer. Anal., 21(5):815-843.

    Brett Bader (SNL 9233)

    C++ includes: NOX_Solver_TensorBased.H 
    """

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Solver::TensorBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> TensorBased

        NOX::Solver::TensorBased::TensorBased(const Teuchos::RCP<
        NOX::Abstract::Group > &grp, const Teuchos::RCP<
        NOX::StatusTest::Generic > &tests, const Teuchos::RCP<
        Teuchos::ParameterList > &params)

        Constructor.

        See reset() for description. 
        """
        this = _Solver.new_TensorBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_TensorBased

    def reset(self, *args):
        """
        reset(TensorBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(TensorBased self, Vector initialGuess)

        void
        NOX::Solver::TensorBased::reset(const NOX::Abstract::Vector
        &initialGuess)

        Resets the solver and sets a new initial guess. 
        """
        return _Solver.TensorBased_reset(self, *args)


    def getStatus(self, *args):
        """
        getStatus(TensorBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::Solver::TensorBased::getStatus()

        Check current convergence and failure status. 
        """
        return _Solver.TensorBased_getStatus(self, *args)


    def step(self, *args):
        """
        step(TensorBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::Solver::TensorBased::step()

        Do one nonlinear step in the iteration sequence and return status. 
        """
        return _Solver.TensorBased_step(self, *args)


    def solve(self, *args):
        """
        solve(TensorBased self) -> NOX::StatusTest::StatusType

        NOX::StatusTest::StatusType NOX::Solver::TensorBased::solve()

        Solve the nonlinear problem and return final status.

        By "solve", we call iterate() until the NOX::StatusTest value is
        either NOX::StatusTest::Converged or NOX::StatusTest::Failed. 
        """
        return _Solver.TensorBased_solve(self, *args)


    def getNumIterations(self, *args):
        """
        getNumIterations(TensorBased self) -> int

        int NOX::Solver::TensorBased::getNumIterations() const

        Get number of iterations. 
        """
        return _Solver.TensorBased_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """
        getSolutionGroup(TensorBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::TensorBased::getSolutionGroupPtr() const

        Return a RCP to the solution group. 
        """
        return _Solver.TensorBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroupPtr(self, *args):
        """
        getPreviousSolutionGroupPtr(TensorBased self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP< const NOX::Abstract::Group >
        NOX::Solver::TensorBased::getPreviousSolutionGroupPtr() const

        Return a RCP to the previous solution group. 
        """
        return _Solver.TensorBased_getPreviousSolutionGroupPtr(self, *args)


    def getList(self, *args):
        """
        getList(TensorBased self) -> Teuchos::RCP< Teuchos::ParameterList const >

        virtual
        Teuchos::RCP< const Teuchos::ParameterList >
        NOX::Solver::TensorBased::getListPtr() const

        Return a RCP to the solver parameters. 
        """
        return _Solver.TensorBased_getList(self, *args)

TensorBased_swigregister = _Solver.TensorBased_swigregister
TensorBased_swigregister(TensorBased)


def buildSolver(*args):
    """buildSolver(Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> PyObject *"""
    return _Solver.buildSolver(*args)
# This file is compatible with both classic and new-style classes.


