# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Epetra is the python interface to namespace Epetra for
the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Epetra is to provide a concrete interface beteen
NOX and Epetra.

NOX.Epetra provides the following user-level classes:

    * Group                    - Epetra implementation of Abstract.Group
    * Vector                   - Epetra implementation of Abstract.Vector
    * FiniteDifference         - Class for estimating Jacobian w/finite differences
    * FiniteDifferenceColoring - FiniteDifference class, w/coloring efficiencies
    * MatrixFree               - Base class for Jacobian-free algorithms
    * Scaling                  - Class for controlling scalling of algebraic objects
    * LinearSystem             - Base class for interface to linear solvers
    * LinearSystemAztecOO      - Concrete implementation of LinearSystem

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SwigPyIterator

    def value(self):
        return ___init__.SwigPyIterator_value(self)

    def incr(self, n=1):
        return ___init__.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return ___init__.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return ___init__.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return ___init__.SwigPyIterator_equal(self, x)

    def copy(self):
        return ___init__.SwigPyIterator_copy(self)

    def next(self):
        return ___init__.SwigPyIterator_next(self)

    def __next__(self):
        return ___init__.SwigPyIterator___next__(self)

    def previous(self):
        return ___init__.SwigPyIterator_previous(self)

    def advance(self, n):
        return ___init__.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return ___init__.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return ___init__.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return ___init__.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return ___init__.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return ___init__.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return ___init__.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = ___init__.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos

import sys, os.path as op
thisDir   = op.dirname(op.abspath(__file__))
parentDir = op.normpath(op.join(thisDir,".."))
if not thisDir   in sys.path: sys.path.append(thisDir)
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op
if "delete_Group" not in dir(___init__):
    del ___init__
    from . import ___init__

import Abstract
import Interface
import PyTrilinos.Epetra
import PyTrilinos.EpetraExt
class Group(Abstract.Group):
    """


    Concrete implementation of NOX::Abstract::Group for Trilinos/Epetra.

    This group is set up to use the linear algebra services provided
    through the Trilinos/Epetra package with AztecOO for the linear
    solver.

    C++ includes: NOX_Epetra_Group.H 
    """

    __swig_setmethods__ = {}
    for _s in [Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    for _s in [Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::Group self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess) -> Group
        __init__(NOX::Epetra::Group self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< NOX::Epetra::LinearSystem > const & linSys) -> Group
        __init__(NOX::Epetra::Group self, Group source, NOX::CopyType type) -> Group

        Group::Group(const
        NOX::Epetra::Group &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. If type is DeepCopy, takes ownership of valid shared
        linear system. 
        """
        this = ___init__.new_Group(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Group

    def setX(self, *args):
        """
        setX(Group self, Vector y)
        setX(Group self, Vector y)

        void
        Group::setX(const NOX::Abstract::Vector &y)

        Set the solution vector x to y.

        This should invalidate the function value, Jacobian, gradient, and
        Newton direction.

        Throw an error if the copy fails.

        Reference to this object 
        """
        return ___init__.Group_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(Group self, Group grp, Vector d, double step)
        computeX(Group self, Group grp, Vector d, double step)

        void
        Group::computeX(const NOX::Abstract::Group &grp, const
        NOX::Abstract::Vector &d, double step)

        Compute x = grp.x + step * d.

        Let $x$ denote this group's solution vector. Let $\\hat x$ denote
        the result of grp.getX(). Then set \\[ x = \\hat x +
        \\mbox{step} \\; d. \\]

        This should invalidate the function value, Jacobian, gradient, and
        Newton direction.

        Throw an error if the copy fails.

        Reference to this object 
        """
        return ___init__.Group_computeX(self, *args)


    def computeF(self, *args):
        """
        computeF(Group self) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType Group::computeF()

        Compute and store F(x).

        It's generally useful to also compute and store the 2-norm of F(x) at
        this point for later access by the getNormF() function.

        NOX::Abstract::Group::Failed - If the computation fails in any way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return ___init__.Group_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(Group self) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType Group::computeJacobian()

        Compute and store Jacobian.

        Recall that \\[ F(x) = \\left[ \\begin{array}{c} F_1(x) \\\\
        F_2(x) \\\\ \\vdots \\\\ F_n(x) \\\\ \\end{array}
        \\right]. \\]

        The Jacobian is denoted by $J$ and defined by \\[ J_{ij} =
        \\frac{\\partial F_i}{\\partial x_j} (x). \\]

        If this is a shared object, this group should take ownership of the
        Jacobian before it computes it.

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::Failed - If the computation fails in any other
        way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return ___init__.Group_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """
        computeGradient(Group self) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType Group::computeGradient()

        Compute and store gradient.

        We can pose the nonlinear equation problem $F(x) = 0$ as an
        optimization problem as follows: \\[ \\min f(x) \\equiv
        \\frac{1}{2} \\|F(x)\\|_2^2. \\]

        In that case, the gradient (of $f$) is defined as \\[ g \\equiv
        J^T F. \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If either $F$ or $J$ has not
        been computed

        NOX::Abstract::Group::Failed - If the computation fails in any other
        way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return ___init__.Group_computeGradient(self, *args)


    def computeNewton(self, *args):
        """
        computeNewton(Group self, ParameterList params) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType
        Group::computeNewton(Teuchos::ParameterList &params)

        Compute the Newton direction, using parameters for the linear solve.

        The Newton direction is the solution, s, of \\[ J s = -F. \\]

        The parameters are from the "Linear %Solver" sublist of the
        "Direction" sublist that is passed to solver during construction.

        The "Tolerance" parameter may be added/modified in the sublist of
        "Linear Solver" parameters that is passed into this function. The
        solution should be such that \\[ \\frac{\\| J s - (-F)
        \\|_2}{\\max \\{ 1, \\|F\\|_2\\} } < \\mbox{Tolerance}
        \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If either $F$ or $J$ has not
        been computed

        NOX::Abstract::Group::NotConverged - If the linear solve fails to
        satisfy the "Tolerance" specified in params

        NOX::Abstract::Group::Failed - If the computation fails in any other
        way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return ___init__.Group_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType Group::applyJacobian(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Applies Jacobian to the given input vector and puts the answer in the
        result.

        Computes \\[ v = J u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector.

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If the Jacobian $J$ has not been
        computed

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return ___init__.Group_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType Group::applyJacobianTranspose(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Applies Jacobian-Transpose to the given input vector and puts the
        answer in the result.

        Computes \\[ v = J^T u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector.

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If $J$ has not been computed

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return ___init__.Group_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType
        Group::applyJacobianInverse(Teuchos::ParameterList &params, const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Applies the inverse of the Jacobian matrix to the given input vector
        and puts the answer in result.

        Computes \\[ v = J^{-1} u, \\] where $J$ is the Jacobian, $u$ is
        the input vector, and $v$ is the result vector.

        The "Tolerance" parameter specifies that the solution should be such
        that \\[ \\frac{\\| J v - u \\|_2}{\\max \\{ 1,
        \\|u\\|_2\\} } < \\mbox{Tolerance} \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If $J$ has not been computed

        NOX::Abstract::Group::NotConverged - If the linear solve fails to
        satisfy the "Tolerance" specified in params

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise

        The parameter "Tolerance" may be added/modified in the list of
        parameters - this is the ideal solution tolerance for an iterative
        linear solve. 
        """
        return ___init__.Group_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """
        applyRightPreconditioning(Group self, bool useTranspose, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType
        applyRightPreconditioning(Group self, bool useTranspose, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType Group::applyRightPreconditioning(bool
        useTranspose, Teuchos::ParameterList &params, const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Apply right preconditiong to the given input vector.

        Let $M$ be a right preconditioner for the Jacobian $J$; in other
        words, $M$ is a matrix such that \\[ JM \\approx I. \\]

        Compute \\[ u = M^{-1} v, \\] where $u$ is the input vector and
        $v$ is the result vector.

        If useTranspose is true, then the transpose of the preconditioner is
        applied: \\[ u = {M^{-1}}^T v, \\] The transpose preconditioner is
        currently only required for Tensor methods.

        The "Tolerance" parameter specifies that the solution should be such
        that \\[ \\frac{\\| M v - u \\|_2}{\\max \\{ 1,
        \\|u\\|_2\\} } < \\mbox{Tolerance} \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::NotConverged - If the linear solve fails to
        satisfy the "Tolerance" specified in params

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise

        The parameters are from the "Linear %Solver" sublist of the
        "Direction" sublist that is passed to solver during construction. 
        """
        return ___init__.Group_applyRightPreconditioning(self, *args)


    def isF(self, *args):
        """
        isF(Group self) -> bool

        bool Group::isF()
        const

        Return true if F is valid. 
        """
        return ___init__.Group_isF(self, *args)


    def isJacobian(self, *args):
        """
        isJacobian(Group self) -> bool

        bool
        Group::isJacobian() const

        Return true if the Jacobian is valid.

        Default implementation in NOX::Abstract::Group returns false. 
        """
        return ___init__.Group_isJacobian(self, *args)


    def isGradient(self, *args):
        """
        isGradient(Group self) -> bool

        bool
        Group::isGradient() const

        Return true if the gradient is valid.

        Default implementation in NOX::Abstract::Group returns false. 
        """
        return ___init__.Group_isGradient(self, *args)


    def isNewton(self, *args):
        """
        isNewton(Group self) -> bool

        bool
        Group::isNewton() const

        Return true if the Newton direction is valid.

        Default implementation in NOX::Abstract::Group returns false. 
        """
        return ___init__.Group_isNewton(self, *args)


    def isNormNewtonSolveResidual(self, *args):
        """
        isNormNewtonSolveResidual(Group self) -> bool

        bool Group::isNormNewtonSolveResidual() const

        Returns true if the value of the Norm of the linear model for a full
        Newton step ||Js + f|| is valid with respect to the current solution
        vector. 
        """
        return ___init__.Group_isNormNewtonSolveResidual(self, *args)


    def isPreconditioner(self, *args):
        """
        isPreconditioner(Group self) -> bool

        bool
        Group::isPreconditioner() const

        Returns true if an explicitly constructed preconditioner exists (i.e.
        one that is computed and saved for further use in multiple calls to
        applyRightPreconditioner). 
        """
        return ___init__.Group_isPreconditioner(self, *args)


    def isConditionNumber(self, *args):
        """
        isConditionNumber(Group self) -> bool

        bool
        Group::isConditionNumber() const

        Returns true if the condition number has been computed. 
        """
        return ___init__.Group_isConditionNumber(self, *args)


    def getX(self, *args):
        """
        getX(Group self) -> Vector

        const
        Abstract::Vector & Group::getX() const

        Return solution vector. 
        """
        return ___init__.Group_getX(self, *args)


    def getF(self, *args):
        """
        getF(Group self) -> Vector

        const
        Abstract::Vector & Group::getF() const

        Return F(x) 
        """
        return ___init__.Group_getF(self, *args)


    def getNormF(self, *args):
        """
        getNormF(Group self) -> double

        double
        Group::getNormF() const

        Return 2-norm of F(x).

        In other words, \\[ \\sqrt{\\sum_{i=1}^n F_i^2} \\] 
        """
        return ___init__.Group_getNormF(self, *args)


    def getGradient(self, *args):
        """
        getGradient(Group self) -> Vector

        const
        Abstract::Vector & Group::getGradient() const

        Return gradient. 
        """
        return ___init__.Group_getGradient(self, *args)


    def getNewton(self, *args):
        """
        getNewton(Group self) -> Vector

        const
        Abstract::Vector & Group::getNewton() const

        Return Newton direction. 
        """
        return ___init__.Group_getNewton(self, *args)


    def getNormLastLinearSolveResidual(self, *args):
        """
        getNormLastLinearSolveResidual(Group self, double & residual) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType
        NOX::Epetra::Group::getNormLastLinearSolveResidual(double &residual)
        const

        Returns the 2-norm of the residual of the linear model used in the
        Newton solve computation, ||Js+f||. This does not account for line
        search adjustments to the step length! 
        """
        return ___init__.Group_getNormLastLinearSolveResidual(self, *args)


    def clone(self, *args):
        """
        clone(Group self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >

        Teuchos::RCP<
        NOX::Abstract::Group > Group::clone(CopyType type=DeepCopy) const

        Create a new Group of the same derived type as this one by cloning
        this one, and return a ref count pointer to the new group.

        If type is NOX::DeepCopy, then we need to create an exact replica of
        "this". Otherwise, if type is NOX::ShapeCopy, we need only replicate
        the shape of "this" (only the memory is allocated, the values are
        not copied into the vectors and Jacobian). Returns NULL if clone is
        not supported.

        Any shared data should have its ownership transfered to this group
        from the source for a NOX::DeepCopy. 
        """
        return ___init__.Group_clone(self, *args)


    def getRequiredInterface(self, *args):
        """
        getRequiredInterface(Group self) -> Teuchos::RCP< NOX::Epetra::Interface::Required >

        Teuchos::RCP< NOX::Epetra::Interface::Required >
        Group::getRequiredInterface()

        Return the userInterface. 
        """
        return ___init__.Group_getRequiredInterface(self, *args)


    def getLinearSystem(self, *args):
        """
        getLinearSystem(Group self) -> Teuchos::RCP< NOX::Epetra::LinearSystem const >
        getLinearSystem(Group self) -> Teuchos::RCP< NOX::Epetra::LinearSystem >

        Teuchos::RCP< NOX::Epetra::LinearSystem > Group::getLinearSystem()

        Return the Linear System. 
        """
        return ___init__.Group_getLinearSystem(self, *args)


    def computeJacobianConditionNumber(self, *args):
        """
        computeJacobianConditionNumber(Group self, int maxIters, double tolerance, int krylovSubspaceSize=100, bool printOutput=False) -> NOX::Abstract::Group::ReturnType

        Abstract::Group::ReturnType
        NOX::Epetra::Group::computeJacobianConditionNumber(int maxIters,
        double tolerance, int krylovSubspaceSize=100, bool printOutput=false)

        """
        return ___init__.Group_computeJacobianConditionNumber(self, *args)


    def getJacobianConditionNumber(self, *args):
        """
        getJacobianConditionNumber(Group self) -> double

        double NOX::Epetra::Group::getJacobianConditionNumber() const

        Returns the condition number of the Jacobian matrix. 
        """
        return ___init__.Group_getJacobianConditionNumber(self, *args)


    def disableLinearResidualComputation(self, *args):
        """
        disableLinearResidualComputation(Group self, bool const disableChoice)

        void
        NOX::Epetra::Group::disableLinearResidualComputation(const bool
        disableChoice)

        Sets option to disable linear resid computation. If disabled, this
        saves on a MatVec per Newton but disallows inexact Newton methods. 
        """
        return ___init__.Group_disableLinearResidualComputation(self, *args)

Group_swigregister = ___init__.Group_swigregister
Group_swigregister(Group)

class Vector(Abstract.Vector):
    """


    Implementation of NOX::Abstract::Vector for Epetra vectors.

    C++ includes: NOX_Epetra_Vector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Abstract.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    for _s in [Abstract.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)
    __repr__ = _swig_repr
    CreateView = ___init__.Vector_CreateView
    CreateCopy = ___init__.Vector_CreateCopy

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::Vector self, Teuchos::RCP< Epetra_Vector > const & source, NOX::Epetra::Vector::MemoryType memoryType, NOX::CopyType type, Teuchos::RCP< NOX::Epetra::VectorSpace > vs) -> Vector
        __init__(NOX::Epetra::Vector self, Vector source, NOX::CopyType type, Teuchos::RCP< NOX::Epetra::VectorSpace > vs) -> Vector
        __init__(NOX::Epetra::Vector self, Vector source, NOX::CopyType type) -> Vector

        NOX::Epetra::Vector::Vector(const NOX::Epetra::Vector &source,
        NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = ___init__.new_Vector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Vector

    def getEpetraVector(self, *args):
        """
        getEpetraVector(Vector self) -> Vector

        const
        Epetra_Vector & NOX::Epetra::Vector::getEpetraVector() const

        Get const reference to underlying Epetra vector. 
        """
        return ___init__.Vector_getEpetraVector(self, *args)


    def init(self, *args):
        """
        init(Vector self, double gamma) -> Vector

        NOX::Abstract::Vector & NOX::Epetra::Vector::init(double gamma)

        Initialize every element of this vector with gamma.

        Here x represents this vector, and we update it as \\[ x_i =
        \\gamma \\quad \\mbox{for } i=1,\\dots,n \\] Reference to
        this object 
        """
        return ___init__.Vector_init(self, *args)


    def random(self, *args):
        """
        random(Vector self, bool useSeed=False, int seed=1) -> Vector

        NOX::Abstract::Vector & NOX::Epetra::Vector::random(bool
        useSeed=false, int seed=1)

        Initialize each element of this vector with a random value.

        If useSeed is true, uses the value of seed to seed the random number
        generator before filling the entries of this vector. So, if two calls
        are made where useSeed is true and seed is the same, then the vectors
        returned should be the same.

        Default implementation throw an error. Only referenced by LOCA
        methods.

        Reference to this object 
        """
        return ___init__.Vector_random(self, *args)


    def abs(self, *args):
        """
        abs(Vector self, Vector y) -> Vector
        abs(Vector self, Vector y) -> Vector

        NOX::Abstract::Vector & NOX::Epetra::Vector::abs(const
        NOX::Abstract::Vector &y)

        Put element-wise absolute values of source vector y into this vector.

        Here x represents this vector, and we update it as \\[ x_i = | y_i |
        \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return ___init__.Vector_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(Vector self, Vector y) -> Vector
        reciprocal(Vector self, Vector y) -> Vector

        NOX::Abstract::Vector & NOX::Epetra::Vector::reciprocal(const
        NOX::Abstract::Vector &y)

        Put element-wise reciprocal of source vector y into this vector.

        Here x represents this vector, and we update it as \\[ x_i =
        \\frac{1}{y_i} \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return ___init__.Vector_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(Vector self, double gamma) -> Vector
        scale(Vector self, Vector a) -> Vector
        scale(Vector self, Vector a) -> Vector

        NOX::Abstract::Vector & NOX::Epetra::Vector::scale(const
        NOX::Abstract::Vector &a)

        Scale this vector element-by-element by the vector a.

        Here x represents this vector, and we update it as \\[ x_i = x_i
        \\cdot a_i \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return ___init__.Vector_scale(self, *args)


    def update(self, *args):
        """
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector

        NOX::Abstract::Vector & NOX::Epetra::Vector::update(double alpha,
        const NOX::Abstract::Vector &a, double beta, const
        NOX::Abstract::Vector &b, double gamma=0.0)

        Compute x = (alpha * a) + (beta * b) + (gamma * x) where x is this
        vector.

        Here x represents this vector, and we update it as \\[ x_i =
        \\alpha \\; a_i + \\beta \\; b_i + \\gamma \\; x_i
        \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return ___init__.Vector_update(self, *args)


    def clone(self, *args):
        """
        clone(Vector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP<
        NOX::Abstract::Vector > NOX::Epetra::Vector::clone(CopyType
        type=DeepCopy) const

        Create a new Vector of the same underlying type by cloning "this",
        and return a pointer to the new vector.

        If type is NOX::DeepCopy, then we need to create an exact replica of
        "this". Otherwise, if type is NOX::ShapeCopy, we need only replicate
        the shape of "this" (the memory is allocated for the objects, but
        the current values are not copied into the vector). Note that there is
        no assumption that a vector created by ShapeCopy is initialized to
        zeros.

        Pointer to newly created vector or NULL if clone is not supported. 
        """
        return ___init__.Vector_clone(self, *args)


    def createMultiVector(self, *args):
        """
        createMultiVector(Vector self, NOX::Abstract::Vector const *const * vecs, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        createMultiVector(Vector self, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        NOX::Epetra::Vector::createMultiVector(int numVecs, NOX::CopyType
        type=NOX::DeepCopy) const

        Create a MultiVector with numVecs columns.

        The implementation here creates a NOX::Epetra::MultiVector with either
        Shape or Deep copies of the supplied vector. 
        """
        return ___init__.Vector_createMultiVector(self, *args)


    def norm(self, *args):
        """
        norm(Vector self, NOX::Abstract::Vector::NormType type) -> double
        norm(Vector self, Vector weights) -> double
        norm(Vector self, Vector weights) -> double

        double
        NOX::Epetra::Vector::norm(const NOX::Abstract::Vector &weights) const

        Weighted 2-Norm.

        Here x represents this vector, and we compute its weighted norm as
        follows: \\[ \\|x\\|_w = \\sqrt{\\sum_{i=1}^{n} w_i \\;
        x_i^2} \\]  $ \\|x\\|_w $ 
        """
        return ___init__.Vector_norm(self, *args)


    def innerProduct(self, *args):
        """
        innerProduct(Vector self, Vector y) -> double
        innerProduct(Vector self, Vector y) -> double

        double
        NOX::Epetra::Vector::innerProduct(const NOX::Abstract::Vector &y)
        const

        Inner product with y.

        Here x represents this vector, and we compute its inner product with y
        as follows: \\[ \\langle x,y \\rangle = \\sum_{i=1}^n x_i y_i
        \\]  $\\langle x,y \\rangle$ 
        """
        return ___init__.Vector_innerProduct(self, *args)


    def length(self, *args):
        """
        length(Vector self) -> NOX::size_type

        NOX::size_type
        NOX::Epetra::Vector::length() const

        Return the length of vector.

        The length of this vector

        Even if the vector is distributed across processors, this should
        return the  global length of the vector. 
        """
        return ___init__.Vector_length(self, *args)


    def getVectorSpace(self, *args):
        """
        getVectorSpace(Vector self) -> Teuchos::RCP< NOX::Epetra::VectorSpace >

        Teuchos::RCP< NOX::Epetra::VectorSpace >
        NOX::Epetra::Vector::getVectorSpace() const

        Returns the NOX::Epetra::VectorSpace associated with this vector. 
        """
        return ___init__.Vector_getVectorSpace(self, *args)

Vector_swigregister = ___init__.Vector_swigregister
Vector_swigregister(Vector)

class FiniteDifference(PyTrilinos.Epetra.RowMatrix, Interface.Jacobian, Interface.Preconditioner):
    """


    Concrete implementation for creating an Epetra_RowMatrix Jacobian via
    finite differencing of the residual.

    The Jacobian entries are calculated via 1st order finite differencing.
    This requires $ N + 1 $ calls to computeF() where $ N $ is the number
    of unknowns in the problem.

    \\[ J_{ij} = \\frac{\\partial F_i}{\\partial x_j} =
    \\frac{F_i(x+\\delta\\mathbf{e}_j) - F_i(x)}{\\delta} \\]

    where $J$ is the Jacobian, $F$ is the function evaluation, $x$ is the
    solution vector, and $\\delta$ is a small perturbation to the $x_j$
    entry.

    The perturbation, $ \\delta $, is calculated based on one of the
    following equations:

    \\[ \\delta = \\alpha * | x_j | + \\beta \\] \\[ \\delta
    = \\alpha * | x_j | + \\beta_j \\]

    where $ \\alpha $ is a scalar value (defaults to 1.0e-4) and $
    \\beta $ can be either a scalar or a vector (defaults to a scalar
    value of 1.0e-6). The choice is defined by the type of constructor
    used. All parameters are supplied in the constructor. In addition to
    the forward difference derivative approximation, backward or centered
    differences can be used via the setDifferenceMethod function. Note
    that centered difference provides second order spatial accuracy but at
    the cost of twice as many function evaluations.

    Since this inherits from the Epetra_RowMatrix class, it can be used as
    the preconditioning matrix for AztecOO preconditioners. This method is
    very inefficient when computing the Jacobian and is not recommended
    for large-scale systems but only for debugging purposes.

    C++ includes: NOX_Epetra_FiniteDifference.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.RowMatrix, Interface.Jacobian, Interface.Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifference, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.RowMatrix, Interface.Jacobian, Interface.Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifference, name)
    __repr__ = _swig_repr
    Forward = ___init__.FiniteDifference_Forward
    Backward = ___init__.FiniteDifference_Backward
    Centered = ___init__.FiniteDifference_Centered

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, double beta=1.0e-6, double alpha=1.0e-4) -> FiniteDifference
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_Vector const > const & beta, double alpha=1.0e-4) -> FiniteDifference
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_CrsGraph > const & g, double beta=1.0e-6, double alpha=1.0e-4) -> FiniteDifference
        __init__(NOX::Epetra::FiniteDifference self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_CrsGraph > const & g, Teuchos::RCP< Epetra_Vector const > const & beta, double alpha=1.0e-4) -> FiniteDifference

        FiniteDifference::FiniteDifference(Teuchos::ParameterList
        &printingParams, const Teuchos::RCP< NOX::Epetra::Interface::Required
        > &i, const NOX::Epetra::Vector &initialGuess, const Teuchos::RCP<
        Epetra_CrsGraph > &g, const Teuchos::RCP< const Epetra_Vector > &beta,
        double alpha=1.0e-4)

        Constructor with output control that takes a pre-constructed
        Epetra_CrsGraph so it does not have to determine the non-zero entries
        in the matrix. 
        """
        this = ___init__.new_FiniteDifference(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_FiniteDifference

    def Label(self, *args):
        """
        Label(FiniteDifference self) -> char const *

        const
        char * FiniteDifference::Label() const

        Returns a character std::string describing the name of the operator.

        """
        return ___init__.FiniteDifference_Label(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(FiniteDifference self, bool UseTranspose) -> int

        int FiniteDifference::SetUseTranspose(bool UseTranspose)

        If set true, the transpose of this operator will be applied. 
        """
        return ___init__.FiniteDifference_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(FiniteDifference self, MultiVector X, MultiVector Y) -> int

        int
        FiniteDifference::Apply(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Return the result on an Epetra_Operator applied to an
        Epetra_MultiVector X in Y. 
        """
        return ___init__.FiniteDifference_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(FiniteDifference self, MultiVector X, MultiVector Y) -> int

        int FiniteDifference::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Return the result on an Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y. 
        """
        return ___init__.FiniteDifference_ApplyInverse(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(FiniteDifference self) -> bool

        bool FiniteDifference::UseTranspose() const

        Returns the current use transpose setting. 
        """
        return ___init__.FiniteDifference_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(FiniteDifference self) -> bool

        bool FiniteDifference::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return ___init__.FiniteDifference_HasNormInf(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(FiniteDifference self) -> Map

        const Epetra_Map &
        FiniteDifference::OperatorDomainMap() const

        Returns the Epetra_BlockMap object associated with the domain of this
        matrix operator. 
        """
        return ___init__.FiniteDifference_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(FiniteDifference self) -> Map

        const Epetra_Map & FiniteDifference::OperatorRangeMap() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return ___init__.FiniteDifference_OperatorRangeMap(self, *args)


    def Filled(self, *args):
        """
        Filled(FiniteDifference self) -> bool

        bool
        FiniteDifference::Filled() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_Filled(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(FiniteDifference self, int MyRow, int & NumEntries) -> int

        int FiniteDifference::NumMyRowEntries(int MyRow, int &NumEntries)
        const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumMyRowEntries(self, *args)


    def MaxNumEntries(self, *args):
        """
        MaxNumEntries(FiniteDifference self) -> int

        int FiniteDifference::MaxNumEntries() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_MaxNumEntries(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(FiniteDifference self, int MyRow, int Length, int & NumEntries, double * Values, int * Indices) -> int

        int FiniteDifference::ExtractMyRowCopy(int MyRow, int Length, int
        &NumEntries, double *Values, int *Indices) const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_ExtractMyRowCopy(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(FiniteDifference self, Vector Diagonal) -> int

        int
        FiniteDifference::ExtractDiagonalCopy(Epetra_Vector &Diagonal) const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_ExtractDiagonalCopy(self, *args)


    def Multiply(self, *args):
        """
        Multiply(FiniteDifference self, bool TransA, MultiVector X, MultiVector Y) -> int

        int
        FiniteDifference::Multiply(bool TransA, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve(FiniteDifference self, bool Upper, bool Trans, bool UnitDiagonal, MultiVector X, MultiVector Y) -> int

        int
        FiniteDifference::Solve(bool Upper, bool Trans, bool UnitDiagonal,
        const Epetra_MultiVector &X, Epetra_MultiVector &Y) const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(FiniteDifference self, Vector x) -> int

        int
        FiniteDifference::InvRowSums(Epetra_Vector &x) const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(FiniteDifference self, Vector x) -> int

        int
        FiniteDifference::LeftScale(const Epetra_Vector &x)

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(FiniteDifference self, Vector x) -> int

        int
        FiniteDifference::InvColSums(Epetra_Vector &x) const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(FiniteDifference self, Vector x) -> int

        int
        FiniteDifference::RightScale(const Epetra_Vector &x)

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_RightScale(self, *args)


    def NormInf(self, *args):
        """
        NormInf(FiniteDifference self) -> double

        double
        FiniteDifference::NormInf() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NormInf(self, *args)


    def NormOne(self, *args):
        """
        NormOne(FiniteDifference self) -> double

        double
        FiniteDifference::NormOne() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NormOne(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(FiniteDifference self) -> int

        int
        FiniteDifference::NumGlobalNonzeros() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(FiniteDifference self) -> long long

        long long
        FiniteDifference::NumGlobalNonzeros64() const 
        """
        return ___init__.FiniteDifference_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """
        NumGlobalRows(FiniteDifference self) -> int

        int FiniteDifference::NumGlobalRows() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """
        NumGlobalRows64(FiniteDifference self) -> long long

        long long FiniteDifference::NumGlobalRows64() const 
        """
        return ___init__.FiniteDifference_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """
        NumGlobalCols(FiniteDifference self) -> int

        int FiniteDifference::NumGlobalCols() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """
        NumGlobalCols64(FiniteDifference self) -> long long

        long long FiniteDifference::NumGlobalCols64() const 
        """
        return ___init__.FiniteDifference_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """
        NumGlobalDiagonals(FiniteDifference self) -> int

        int
        FiniteDifference::NumGlobalDiagonals() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """
        NumGlobalDiagonals64(FiniteDifference self) -> long long

        long long
        FiniteDifference::NumGlobalDiagonals64() const 
        """
        return ___init__.FiniteDifference_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(FiniteDifference self) -> int

        int FiniteDifference::NumMyNonzeros() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """
        NumMyRows(FiniteDifference self) -> int

        int
        FiniteDifference::NumMyRows() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """
        NumMyCols(FiniteDifference self) -> int

        int
        FiniteDifference::NumMyCols() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """
        NumMyDiagonals(FiniteDifference self) -> int

        int FiniteDifference::NumMyDiagonals() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_NumMyDiagonals(self, *args)


    def LowerTriangular(self, *args):
        """
        LowerTriangular(FiniteDifference self) -> bool

        bool FiniteDifference::LowerTriangular() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """
        UpperTriangular(FiniteDifference self) -> bool

        bool FiniteDifference::UpperTriangular() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_UpperTriangular(self, *args)


    def Comm(self, *args):
        """
        Comm(FiniteDifference self) -> Comm

        const
        Epetra_Comm & FiniteDifference::Comm() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_Comm(self, *args)


    def RowMatrixRowMap(self, *args):
        """
        RowMatrixRowMap(FiniteDifference self) -> Map

        const Epetra_Map & FiniteDifference::RowMatrixRowMap() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """
        RowMatrixColMap(FiniteDifference self) -> Map

        const Epetra_Map & FiniteDifference::RowMatrixColMap() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """
        RowMatrixImporter(FiniteDifference self) -> Import

        const Epetra_Import
        * FiniteDifference::RowMatrixImporter() const

        See Epetra_RowMatrix documentation. 
        """
        return ___init__.FiniteDifference_RowMatrixImporter(self, *args)


    def Map(self, *args):
        """
        Map(FiniteDifference self) -> BlockMap

        const
        Epetra_BlockMap & FiniteDifference::Map() const

        See Epetra_SrcDistObj documentation. 
        """
        return ___init__.FiniteDifference_Map(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(FiniteDifference self, Vector x, Operator Jac) -> bool
        computeJacobian(FiniteDifference self, Vector x) -> bool

        bool FiniteDifference::computeJacobian(const Epetra_Vector &x)

        Compute Jacobian given the specified input vector, x. Returns true if
        computation was successful. 
        """
        return ___init__.FiniteDifference_computeJacobian(self, *args)


    def computePreconditioner(self, *args):
        """
        computePreconditioner(FiniteDifference self, Vector x, Operator Prec, ParameterList precParams=None) -> bool

        bool
        FiniteDifference::computePreconditioner(const Epetra_Vector &x,
        Epetra_Operator &Prec, Teuchos::ParameterList *precParams=0)

        Compute an Epetra_RowMatrix to be used by Aztec preconditioners given
        the specified input vector, x. Returns true if computation was
        successful. 
        """
        return ___init__.FiniteDifference_computePreconditioner(self, *args)


    def setDifferenceMethod(self, *args):
        """
        setDifferenceMethod(FiniteDifference self, NOX::Epetra::FiniteDifference::DifferenceType type)

        void
        FiniteDifference::setDifferenceMethod(DifferenceType type)

        Set the type of perturbation method used (default is Forward) 
        """
        return ___init__.FiniteDifference_setDifferenceMethod(self, *args)


    def getUnderlyingMatrix(self, *args):
        """
        getUnderlyingMatrix(FiniteDifference self) -> CrsMatrix

        Epetra_CrsMatrix
        & FiniteDifference::getUnderlyingMatrix() const

        An accessor method for the underlying Epetra_CrsMatrix. 
        """
        return ___init__.FiniteDifference_getUnderlyingMatrix(self, *args)


    def setGroupForComputeF(self, *args):
        """
        setGroupForComputeF(FiniteDifference self, Group group)

        void
        FiniteDifference::setGroupForComputeF(NOX::Abstract::Group &group)

        Register a NOX::Abstract::Group derived object and use the computeF()
        method of that group for the perturbation instead of the
        NOX::Epetra::Interface::Required::computeF() method. This is required
        for LOCA to get the operators correct during homotopy. 
        """
        return ___init__.FiniteDifference_setGroupForComputeF(self, *args)

FiniteDifference_swigregister = ___init__.FiniteDifference_swigregister
FiniteDifference_swigregister(FiniteDifference)

class FiniteDifferenceColoring(FiniteDifference):
    """


    Concrete implementation for creating an Epetra_RowMatrix Jacobian via
    finite differencing of the residual using coloring.

    The Jacobian entries are calculated via 1st or 2nd order finite
    differencing. This requires $ N + 1 $ or $ 2N + 1 $ calls to
    computeF(), respectively, where $ N $ is the number of colors.

    \\[ J_{ij} = \\frac{\\partial F_i}{\\partial x_j} =
    \\frac{F_i(x+\\delta\\mathbf{e}_j) - F_i(x)}{\\delta} \\]

    where $J$ is the Jacobian, $F$ is the function evaluation, $x$ is the
    solution vector, and $\\delta$ is a small perturbation to the $x_j$
    entry.

    Instead of perturbing each $ N_{dof} $ problem degrees of freedom
    sequentially and then evaluating all $ N_{dof} $ functions for each
    perturbation, coloring allows several degrees of freedom (all
    belonging to the same color) to be perturbed at the same time. This
    reduces the total number of function evaluations needed to compute
    $\\mathbf{J}$ from $ N_{dof}^2 $ as is required using
    FiniteDifference to $ N\\cdot N_{dof} $, often representing
    substantial computational savings.

    Coloring is based on a user-supplied color map generated using an
    appropriate algorithm, eg greedy-algorithm - Y. Saad, "Iterative
    Methods for Sparse %Linear Systems, 2<sup>nd</sup> ed.," chp. 3,
    SIAM, 2003.. Use can be made of the coloring algorithm provided by the
    EpetraExt package in Trilinos. The 1Dfem_nonlinearColoring and
    Brusselator example problems located in the nox/epetra-examples
    subdirectory demonstrate use of the EpetraExt package, and the
    1Dfem_nonlinearColoring directory also contains a stand-alone coloring
    algorithm very similar to that in EpetraExt.

    The perturbation, $ \\delta $, is calculated using the following
    equation:

    \\[ \\delta = \\alpha * | x_j | + \\beta \\]

    where $ \\alpha $ is a scalar value (defaults to 1.0e-4) and $
    \\beta $ is another scalar (defaults to 1.0e-6).

    Since both FiniteDifferenceColoring and FiniteDifference inherit from
    the Epetra_RowMatrix class, they can be used as preconditioning
    matrices for AztecOO preconditioners.

    As for FiniteDifference, 1st order accurate Forward and Backward
    differences as well as 2nd order accurate Centered difference can be
    specified using setDifferenceMethod with the appropriate enumerated
    type passed as the argument.

    Using FiniteDifferenceColoring in Parallel

    Two ways of using this class in a distributed parallel environment are
    currently supported. From an application standpoint, the two
    approaches differ only in the status of the solution iterate used in
    the residual fill. If an object of this class is contructed with
    parallelColoring = true the solution iterate will be passe back in a
    non-ghosted form. On the contrary, setting this parameter to false in
    the constructor will cause the solution iterate to be in a ghosted
    form when calling back for a residual fill. When using the second
    approach, the user should be aware that the perturbed vector used to
    compute residuals has already been scattered to a form consistent with
    the column space of the Epetra_CrsGraph. In practice, this means that
    the perturbed vector used by computeF() has already been scattered to
    a ghosted or overlapped state. The application should then not perform
    this step but rather simply use the vector provided with the possible
    exception of requiring a local index reordering to bring the column-
    space based vector in sync with a potentially different ghosted index
    ordering. See the Brusselator and %1Dfem_nonlinearColoring example
    problems for details.

    Special Case for Approximate Jacobian Construction

    Provision is made for a simplified and cheaper use of coloring that
    currently provides only for the diagonal of the Jacobian to be
    computed. This is based on using a first-neighbors coloring of the
    original Jacobian graph using the Epetra_Ext MapColoring class with
    the distance1 argument set to true. This same argument should also be
    set to true in the constructor to this class. The result will be a
    diagonal Jacobian filled in a much more efficient manner.

    C++ includes: NOX_Epetra_FiniteDifferenceColoring.H 
    """

    __swig_setmethods__ = {}
    for _s in [FiniteDifference]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifference]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceColoring, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_FiniteDifferenceColoring

    def computeJacobian(self, *args):
        """
        computeJacobian(FiniteDifferenceColoring self, Vector x, Operator Jac) -> bool
        computeJacobian(FiniteDifferenceColoring self, Vector x) -> bool

        bool
        FiniteDifferenceColoring::computeJacobian(const Epetra_Vector &x)

        Compute Jacobian given the specified input vector, x. Returns true if
        computation was successful. 
        """
        return ___init__.FiniteDifferenceColoring_computeJacobian(self, *args)


    def createColorContainers(self, *args):
        """
        createColorContainers(FiniteDifferenceColoring self)

        void
        FiniteDifferenceColoring::createColorContainers()

        Output the coloring map, index map and underlying matrix.

        Create containers for using color and index maps in parallel coloring

        """
        return ___init__.FiniteDifferenceColoring_createColorContainers(self, *args)


    def __init__(self, *args):
        """
        __init__(NOX::Epetra::FiniteDifferenceColoring self, ParameterList printingParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector initialGuess, Teuchos::RCP< Epetra_CrsGraph > const & rawGraph, bool parallelColoring=False, bool distance1=False, double beta=1.0e-6, double alpha=1.0e-4) -> FiniteDifferenceColoring

        FiniteDifferenceColoring::FiniteDifferenceColoring(Teuchos::ParameterList
        &printingParams, const Teuchos::RCP< Interface::Required > &i, const
        NOX::Epetra::Vector &initialGuess, const Teuchos::RCP< Epetra_CrsGraph
        > &rawGraph, const Teuchos::RCP< Epetra_MapColoring > &colorMap, const
        Teuchos::RCP< std::vector< Epetra_IntVector > > &columns, bool
        parallelColoring=false, bool distance1=false, double beta=1.0e-6,
        double alpha=1.0e-4)

        Constructor with output control. 
        """
        this = ___init__.new_FiniteDifferenceColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
FiniteDifferenceColoring_swigregister = ___init__.FiniteDifferenceColoring_swigregister
FiniteDifferenceColoring_swigregister(FiniteDifferenceColoring)

class MatrixFree(PyTrilinos.Epetra.Operator, Interface.Jacobian):
    """


    Concrete implementation for creating an Epetra_Operator Jacobian based
    on the Matrix-Free Newton-Krylov method.

    Matrix-Free Newton-Krylov is a method that takes advantage of the fact
    the Newton Krylov solvers do not require an explicit Jacobian matrix.
    Newton-Krylov solvers only require the matrix-vector product $Jy$ in
    the iteration sequence. This product can approximated by the
    following:

    \\[ Jy = \\frac{F(x + \\delta y) - F(x)}{\\delta} \\]

    where $J$ is the Jacobian, $F$ is the function evaluation, $x$ is the
    solution vector, $y$ is the vector to be operated on, and $\\delta$
    is a scalar perturbation calculated by:

    \\[ \\delta = \\lambda * (\\lambda + \\frac{\\|
    x\\|}{\\| y\\|} ) \\]

    where $ \\lambda = 1.0e-6 $.

    C++ includes: NOX_Epetra_MatrixFree.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator, Interface.Jacobian]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatrixFree, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Epetra.Operator, Interface.Jacobian]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MatrixFree, name)
    __repr__ = _swig_repr
    Forward = ___init__.MatrixFree_Forward
    Backward = ___init__.MatrixFree_Backward
    Centered = ___init__.MatrixFree_Centered

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::MatrixFree self, ParameterList printParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Vector cloneVector, bool useNewPerturbation=False) -> MatrixFree

        MatrixFree::MatrixFree(Teuchos::ParameterList &printParams, const
        Teuchos::RCP< NOX::Epetra::Interface::Required > &i, const
        NOX::Epetra::Vector &cloneVector, bool useNewPerturbation=false)

        Constructor.

        The vector x is used to clone the solution vector. 
        """
        this = ___init__.new_MatrixFree(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_MatrixFree

    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(MatrixFree self, bool UseTranspose) -> int

        int
        MatrixFree::SetUseTranspose(bool UseTranspose)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        UseTranspose:  -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return ___init__.MatrixFree_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(MatrixFree self, MultiVector X, MultiVector Y) -> int

        int
        MatrixFree::Apply(const Epetra_MultiVector &X, Epetra_MultiVector &Y)
        const

        Returns the result of a Epetra_Operator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        X:  - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Y:  -A Epetra_MultiVector of dimension NumVectors containing result.

        Integer error code, set to 0 if successful. 
        """
        return ___init__.MatrixFree_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(MatrixFree self, MultiVector X, MultiVector Y) -> int

        int
        MatrixFree::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        X:  - A Epetra_MultiVector of dimension NumVectors to solve for.

        Y:  -A Epetra_MultiVector of dimension NumVectors containing result.

        Integer error code, set to 0 if successful.

        WARNING:  In order to work with AztecOO, any implementation of this
        method must support the case where X and Y are the same object. 
        """
        return ___init__.MatrixFree_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """
        NormInf(MatrixFree self) -> double

        double
        MatrixFree::NormInf() const

        Returns the infinity norm of the global matrix. 
        """
        return ___init__.MatrixFree_NormInf(self, *args)


    def Label(self, *args):
        """
        Label(MatrixFree self) -> char const *

        const char *
        MatrixFree::Label() const

        Returns a character std::string describing the operator. 
        """
        return ___init__.MatrixFree_Label(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(MatrixFree self) -> bool

        bool
        MatrixFree::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return ___init__.MatrixFree_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(MatrixFree self) -> bool

        bool
        MatrixFree::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return ___init__.MatrixFree_HasNormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(MatrixFree self) -> Comm

        const
        Epetra_Comm & MatrixFree::Comm() const

        Returns a reference to the Epetra_Comm communicator associated with
        this operator. 
        """
        return ___init__.MatrixFree_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(MatrixFree self) -> Map

        const Epetra_Map & MatrixFree::OperatorDomainMap() const

        Returns the Epetra_BlockMap object associated with the domain of this
        matrix operator. 
        """
        return ___init__.MatrixFree_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(MatrixFree self) -> Map

        const Epetra_Map & MatrixFree::OperatorRangeMap() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return ___init__.MatrixFree_OperatorRangeMap(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(MatrixFree self, Vector x, Operator Jac) -> bool

        bool
        MatrixFree::computeJacobian(const Epetra_Vector &x, Epetra_Operator
        &Jac)

        Compute Jacobian given the specified input vector, x. Returns true if
        computation was successful. 
        """
        return ___init__.MatrixFree_computeJacobian(self, *args)


    def setDifferenceMethod(self, *args):
        """
        setDifferenceMethod(MatrixFree self, NOX::Epetra::MatrixFree::DifferenceType type)

        void MatrixFree::setDifferenceMethod(DifferenceType type)

        Set the type of perturbation method used (default is Forward) 
        """
        return ___init__.MatrixFree_setDifferenceMethod(self, *args)


    def setLambda(self, *args):
        """
        setLambda(MatrixFree self, double lambda_)

        void
        MatrixFree::setLambda(double lambda_)

        Allows the user to change the value of $ \\lambda $ in the
        perturbation calculation. 
        """
        return ___init__.MatrixFree_setLambda(self, *args)


    def setComputePerturbation(self, *args):
        """
        setComputePerturbation(MatrixFree self, bool bVal)

        void MatrixFree::setComputePerturbation(bool bVal)

        Flag that toggles whether MatrixFree should compute the perturbation
        parameter $ \\eta $ or use a value supplied by the user through
        setPerturbation(). 
        """
        return ___init__.MatrixFree_setComputePerturbation(self, *args)


    def setPerturbation(self, *args):
        """
        setPerturbation(MatrixFree self, double eta_)

        void
        MatrixFree::setPerturbation(double eta_)

        Set the perturbation parameter $ \\eta $. 
        """
        return ___init__.MatrixFree_setPerturbation(self, *args)


    def getPerturbation(self, *args):
        """
        getPerturbation(MatrixFree self) -> double

        double MatrixFree::getPerturbation() const

        Returns the most recently used value of the perturbation parameter $
        \\eta $. 
        """
        return ___init__.MatrixFree_getPerturbation(self, *args)


    def setGroupForComputeF(self, *args):
        """
        setGroupForComputeF(MatrixFree self, Group group)

        void MatrixFree::setGroupForComputeF(const NOX::Abstract::Group
        &group)

        Clone a NOX::Abstract::Group derived object and use the computeF()
        method of that group for the perturbation instead of the
        NOX::Epetra::Interface::Required::computeF() method. This is required
        for LOCA to get the operators correct during homotopy. 
        """
        return ___init__.MatrixFree_setGroupForComputeF(self, *args)


    def setSolverForComputeJacobian(self, *args):
        """
        setSolverForComputeJacobian(MatrixFree self, Teuchos::RCP< NOX::Solver::Generic > const & slvr)

        void
        MatrixFree::setSolverForComputeJacobian(const Teuchos::RCP<
        NOX::Solver::Generic > &slvr)

        Save a RCP to a solver, and use the Solver's current Group's
        computeF() in the computeJacobian call, which can save a function call
        by respecting the isValid flag. 
        """
        return ___init__.MatrixFree_setSolverForComputeJacobian(self, *args)

MatrixFree_swigregister = ___init__.MatrixFree_swigregister
MatrixFree_swigregister(MatrixFree)

class Scaling(_object):
    """


    Object to control scaling of vectors and linear systems.

    Currently this assumes a diagonal scaling only! Once epetra can do
    matrix-matrix multiplies we will expand this class.

    C++ includes: NOX_Epetra_Scaling.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Scaling, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Scaling, name)
    __repr__ = _swig_repr
    Scaling_None = ___init__.Scaling_Scaling_None
    RowSum = ___init__.Scaling_RowSum
    ColSum = ___init__.Scaling_ColSum
    UserDefined = ___init__.Scaling_UserDefined
    Left = ___init__.Scaling_Left
    Right = ___init__.Scaling_Right

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::Scaling self) -> Scaling

        NOX::Epetra::Scaling::Scaling()

        Constructor. 
        """
        this = ___init__.new_Scaling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Scaling

    def addUserScaling(self, *args):
        """
        addUserScaling(Scaling self, NOX::Epetra::Scaling::ScaleType type, Teuchos::RCP< Epetra_Vector > const & D)

        void
        NOX::Epetra::Scaling::addUserScaling(ScaleType type, const
        Teuchos::RCP< Epetra_Vector > &D)

        Add a user supplied diagonal scale vector to the scaling object. 
        """
        return ___init__.Scaling_addUserScaling(self, *args)


    def addRowSumScaling(self, *args):
        """
        addRowSumScaling(Scaling self, NOX::Epetra::Scaling::ScaleType type, Teuchos::RCP< Epetra_Vector > const & D)

        void
        NOX::Epetra::Scaling::addRowSumScaling(ScaleType type, const
        Teuchos::RCP< Epetra_Vector > &D)

        Add "Row Sum" scaling to the scaling object. The supplied vector is
        used to store the current row sum vector. 
        """
        return ___init__.Scaling_addRowSumScaling(self, *args)


    def addColSumScaling(self, *args):
        """
        addColSumScaling(Scaling self, NOX::Epetra::Scaling::ScaleType type, Teuchos::RCP< Epetra_Vector > const & D)

        void
        NOX::Epetra::Scaling::addColSumScaling(ScaleType type, const
        Teuchos::RCP< Epetra_Vector > &D)

        Add "Col Sum" scaling to the scaling object. The supplied vector is
        used to store the current column sum vector. 
        """
        return ___init__.Scaling_addColSumScaling(self, *args)


    def computeScaling(self, *args):
        """
        computeScaling(Scaling self, Epetra_LinearProblem problem)

        void
        NOX::Epetra::Scaling::computeScaling(const Epetra_LinearProblem
        &problem)

        Computes Row Sum scaling diagonal vectors. Only needs to be called if
        a row or column sum scaling has been requested. 
        """
        return ___init__.Scaling_computeScaling(self, *args)


    def scaleLinearSystem(self, *args):
        """
        scaleLinearSystem(Scaling self, Epetra_LinearProblem problem)

        void
        NOX::Epetra::Scaling::scaleLinearSystem(Epetra_LinearProblem &problem)

        Scales the linear system. 
        """
        return ___init__.Scaling_scaleLinearSystem(self, *args)


    def unscaleLinearSystem(self, *args):
        """
        unscaleLinearSystem(Scaling self, Epetra_LinearProblem problem)

        void NOX::Epetra::Scaling::unscaleLinearSystem(Epetra_LinearProblem
        &problem)

        Remove the scaling from the linear system. 
        """
        return ___init__.Scaling_unscaleLinearSystem(self, *args)


    def applyRightScaling(self, *args):
        """
        applyRightScaling(Scaling self, Vector input, Vector result)

        void
        NOX::Epetra::Scaling::applyRightScaling(const Epetra_Vector &input,
        Epetra_Vector &result)

        Applies any RIGHT scaling vectors to an input vector. 
        """
        return ___init__.Scaling_applyRightScaling(self, *args)


    def applyLeftScaling(self, *args):
        """
        applyLeftScaling(Scaling self, Vector input, Vector result)

        void
        NOX::Epetra::Scaling::applyLeftScaling(const Epetra_Vector &input,
        Epetra_Vector &result)

        Applies any LEFT scaling vectors to an input vector. 
        """
        return ___init__.Scaling_applyLeftScaling(self, *args)

Scaling_swigregister = ___init__.Scaling_swigregister
Scaling_swigregister(Scaling)

class LinearSystem(_object):
    """


    Pure virtual class interface for allowing different linear solvers to
    be used by the NOX::Epetra::Group.

    C++ includes: NOX_Epetra_LinearSystem.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearSystem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LinearSystem, name)
    __repr__ = _swig_repr
    PRPT_REBUILD = ___init__.LinearSystem_PRPT_REBUILD
    PRPT_RECOMPUTE = ___init__.LinearSystem_PRPT_RECOMPUTE
    PRPT_REUSE = ___init__.LinearSystem_PRPT_REUSE

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::LinearSystem self) -> LinearSystem

        NOX::Epetra::LinearSystem::LinearSystem()

        Constructor. 
        """
        if self.__class__ == LinearSystem:
            _self = None
        else:
            _self = self
        this = ___init__.new_LinearSystem(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_LinearSystem

    def applyJacobian(self, *args):
        """
        applyJacobian(LinearSystem self, Vector input, Vector nox_result) -> bool

        virtual bool NOX::Epetra::LinearSystem::applyJacobian(const
        NOX::Epetra::Vector &input, NOX::Epetra::Vector &result) const =0

        Applies Jacobian to the given input vector and puts the answer in the
        result.

        Computes \\[ v = J u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector. Returns true if
        successful. 
        """
        return ___init__.LinearSystem_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(LinearSystem self, Vector input, Vector nox_result) -> bool

        virtual bool
        NOX::Epetra::LinearSystem::applyJacobianTranspose(const
        NOX::Epetra::Vector &input, NOX::Epetra::Vector &result) const =0

        Applies Jacobian-Transpose to the given input vector and puts the
        answer in the result.

        Computes \\[ v = J^T u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector. Returns true if
        successful. 
        """
        return ___init__.LinearSystem_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(LinearSystem self, ParameterList params, Vector input, Vector nox_result) -> bool

        virtual bool
        NOX::Epetra::LinearSystem::applyJacobianInverse(Teuchos::ParameterList
        &params, const NOX::Epetra::Vector &input, NOX::Epetra::Vector
        &result)=0

        Applies the inverse of the Jacobian matrix to the given input vector
        and puts the answer in result.

        Computes \\[ v = J^{-1} u, \\] where $J$ is the Jacobian, $u$ is
        the input vector, and $v$ is the result vector.

        The parameter list contains the linear solver options. 
        """
        return ___init__.LinearSystem_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """
        applyRightPreconditioning(LinearSystem self, bool useTranspose, ParameterList params, Vector input, Vector nox_result) -> bool

        virtual bool
        NOX::Epetra::LinearSystem::applyRightPreconditioning(bool
        useTranspose, Teuchos::ParameterList &params, const
        NOX::Epetra::Vector &input, NOX::Epetra::Vector &result) const =0

        Apply right preconditiong to the given input vector.

        Let $M$ be a right preconditioner for the Jacobian $J$; in other
        words, $M$ is a matrix such that \\[ JM \\approx I. \\]

        Compute \\[ u = M^{-1} v, \\] where $u$ is the input vector and
        $v$ is the result vector.

        If useTranspose is true, then the transpose of the preconditioner is
        applied: \\[ u = {M^{-1}}^T v, \\] The transpose preconditioner is
        currently only required for Tensor methods.

        The parameter list contains the linear solver options. 
        """
        return ___init__.LinearSystem_applyRightPreconditioning(self, *args)


    def getScaling(self, *args):
        """
        getScaling(LinearSystem self) -> Teuchos::RCP< NOX::Epetra::Scaling >

        virtual
        Teuchos::RCP<NOX::Epetra::Scaling>
        NOX::Epetra::LinearSystem::getScaling()=0

        Get the scaling object. 
        """
        return ___init__.LinearSystem_getScaling(self, *args)


    def resetScaling(self, *args):
        """
        resetScaling(LinearSystem self, Teuchos::RCP< NOX::Epetra::Scaling > const & s)

        virtual void NOX::Epetra::LinearSystem::resetScaling(const
        Teuchos::RCP< NOX::Epetra::Scaling > &s)=0

        Sets the diagonal scaling vector(s) used in scaling the linear system.

        See NOX::Epetra::Scaling for details on how to specify scaling of the
        linear system. 
        """
        return ___init__.LinearSystem_resetScaling(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(LinearSystem self, Vector x) -> bool

        virtual bool NOX::Epetra::LinearSystem::computeJacobian(const
        NOX::Epetra::Vector &x)=0

        Evaluates the Jacobian based on the solution vector x. 
        """
        return ___init__.LinearSystem_computeJacobian(self, *args)


    def createPreconditioner(self, *args):
        """
        createPreconditioner(LinearSystem self, Vector x, ParameterList p, bool recomputeGraph) -> bool

        virtual bool NOX::Epetra::LinearSystem::createPreconditioner(const
        NOX::Epetra::Vector &x, Teuchos::ParameterList &p, bool
        recomputeGraph) const =0

        Explicitly constructs a preconditioner based on the solution vector x
        and the parameter list p.

        The user has the option of recomputing the graph when a new
        preconditioner is created. The NOX::Epetra::Group controls the isValid
        flag for the preconditioner and will control when to call this. 
        """
        return ___init__.LinearSystem_createPreconditioner(self, *args)


    def destroyPreconditioner(self, *args):
        """
        destroyPreconditioner(LinearSystem self) -> bool

        virtual bool
        NOX::Epetra::LinearSystem::destroyPreconditioner() const =0

        Deletes the preconditioner.

        The NOX::Epetra::Group controls the isValid flag for the
        preconditioner and will control when to call this. 
        """
        return ___init__.LinearSystem_destroyPreconditioner(self, *args)


    def recomputePreconditioner(self, *args):
        """
        recomputePreconditioner(LinearSystem self, Vector x, ParameterList linearSolverParams) -> bool

        virtual bool
        NOX::Epetra::LinearSystem::recomputePreconditioner(const
        NOX::Epetra::Vector &x, Teuchos::ParameterList &linearSolverParams)
        const =0

        Recalculates the preconditioner using an already allocated graph.

        Use this to compute a new preconditioner while using the same graph
        for the preconditioner. This avoids deleting and reallocating the
        memory required for the preconditioner and results in a big speed-up
        for large-scale jobs. 
        """
        return ___init__.LinearSystem_recomputePreconditioner(self, *args)


    def getPreconditionerPolicy(self, *args):
        """
        getPreconditionerPolicy(LinearSystem self, bool advanceReuseCounter=True) -> NOX::Epetra::LinearSystem::PreconditionerReusePolicyType

        virtual
        PreconditionerReusePolicyType
        NOX::Epetra::LinearSystem::getPreconditionerPolicy(bool
        advanceReuseCounter=true)=0

        Evaluates the preconditioner policy at the current state.

        NOTE: This can change values between nonlienar iterations. It is not a
        static value. 
        """
        return ___init__.LinearSystem_getPreconditionerPolicy(self, *args)


    def isPreconditionerConstructed(self, *args):
        """
        isPreconditionerConstructed(LinearSystem self) -> bool

        virtual bool
        NOX::Epetra::LinearSystem::isPreconditionerConstructed() const =0

        Indicates whether a preconditioner has been constructed. 
        """
        return ___init__.LinearSystem_isPreconditionerConstructed(self, *args)


    def hasPreconditioner(self, *args):
        """
        hasPreconditioner(LinearSystem self) -> bool

        virtual bool NOX::Epetra::LinearSystem::hasPreconditioner() const =0

        Indicates whether the linear system has a preconditioner. 
        """
        return ___init__.LinearSystem_hasPreconditioner(self, *args)


    def getJacobianOperator(self, *args):
        """
        getJacobianOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator const >
        getJacobianOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator >

        virtual Teuchos::RCP<Epetra_Operator>
        NOX::Epetra::LinearSystem::getJacobianOperator()=0

        Return Jacobian operator. 
        """
        return ___init__.LinearSystem_getJacobianOperator(self, *args)


    def getGeneratedPrecOperator(self, *args):
        """
        getGeneratedPrecOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator const >
        getGeneratedPrecOperator(LinearSystem self) -> Teuchos::RCP< Epetra_Operator >

        virtual
        Teuchos::RCP<Epetra_Operator>
        NOX::Epetra::LinearSystem::getGeneratedPrecOperator()=0

        Return preconditioner operator. 
        """
        return ___init__.LinearSystem_getGeneratedPrecOperator(self, *args)


    def setJacobianOperatorForSolve(self, *args):
        """
        setJacobianOperatorForSolve(LinearSystem self, Teuchos::RCP< Epetra_Operator const > const & solveJacOp)

        virtual void
        NOX::Epetra::LinearSystem::setJacobianOperatorForSolve(const
        Teuchos::RCP< const Epetra_Operator > &solveJacOp)=0

        Set Jacobian operator for solve. 
        """
        return ___init__.LinearSystem_setJacobianOperatorForSolve(self, *args)


    def setPrecOperatorForSolve(self, *args):
        """
        setPrecOperatorForSolve(LinearSystem self, Teuchos::RCP< Epetra_Operator const > const & solvePrecOp)

        virtual void
        NOX::Epetra::LinearSystem::setPrecOperatorForSolve(const Teuchos::RCP<
        const Epetra_Operator > &solvePrecOp)=0

        Set preconditioner operator for solve.

        Note: This should only be called if hasPreconditioner() returns true.

        """
        return ___init__.LinearSystem_setPrecOperatorForSolve(self, *args)


    def getNumLinearSolves(self, *args):
        """
        getNumLinearSolves(LinearSystem self) -> int

        virtual int NOX::Epetra::LinearSystem::getNumLinearSolves()

        Statistics for number of times the linear solver has been called (def:
        0) 
        """
        return ___init__.LinearSystem_getNumLinearSolves(self, *args)


    def getLinearItersLastSolve(self, *args):
        """
        getLinearItersLastSolve(LinearSystem self) -> int

        virtual int
        NOX::Epetra::LinearSystem::getLinearItersLastSolve()

        Statistics for number of iterations taken in last linear solve (def:
        0) 
        """
        return ___init__.LinearSystem_getLinearItersLastSolve(self, *args)


    def getLinearItersTotal(self, *args):
        """
        getLinearItersTotal(LinearSystem self) -> int

        virtual int NOX::Epetra::LinearSystem::getLinearItersTotal()

        Statistics for cumulative number of iterations in all linear solve
        (def: 0) 
        """
        return ___init__.LinearSystem_getLinearItersTotal(self, *args)


    def getAchievedTol(self, *args):
        """
        getAchievedTol(LinearSystem self) -> double

        virtual double NOX::Epetra::LinearSystem::getAchievedTol()

        Statistics for the achieved tolerance of last linear solve (def: 0.0)

        """
        return ___init__.LinearSystem_getAchievedTol(self, *args)

    def __disown__(self):
        self.this.disown()
        ___init__.disown_LinearSystem(self)
        return weakref_proxy(self)
LinearSystem_swigregister = ___init__.LinearSystem_swigregister
LinearSystem_swigregister(LinearSystem)

class LinearSystemAztecOO(LinearSystem):
    """


    Concrete implementation of NOX::Epetra::LinearSolver for AztecOO.

    This solver provides the linear algebra services provided through the
    AztecOO parallel iterative linear solver.

    The NOX::Epetra::LinearSystemAztecOO object provides a flexible and
    efficient way to interface an Epetra based application code to the
    Aztec linear solver. This class handles construction of both the
    preconditioners and AztecOO solver. All options are determined through
    parameter lists and the basic constructors.

    Constructing a Linear System

    There are four different constructors that can be used. The difference
    between constructors is based on whether the user supplies a Jacobian,
    a preconditioner, neither or both.

    If a Jacobian is not supplied then this object can create an
    internally constructed Jacobian based on a Finite Difference or
    Matrif-Free object. The user can specify which type of object to use
    by setting the parameter "Jacobian Operator" in the parameter list.
    The choices are "Matrix-Free" or "Finite Difference".

    The user can supply their own preconditioner as an Epetra_Operator, or
    they can supply their own matrix (an Epetra_RowMatrix derived object)
    that can be used by one of the internal preconditioner libraries
    (currently aztecoo or ifpack). If they supply their own preconditioner
    the object must implement the Epetra_Operator::ApplyInverse method.
    This is the method called during the linear solve to introduce
    preconditoning into aztecoo. If the user supplies a matrix to be used
    with an internal preconditioner, it must be derived from the
    Epetra_RowMatrix class and must implement all functionality in the
    Epetra_RowMatrix. If a Preconditioner is not supplied, then this
    object can create an internal preconditioner matrix by finite
    differencing or it can use the Jacobian operator if the Jacobian
    derives from the Epetra_RowMatrix class. The user can specify which
    type of object to use by setting the parameter "Preconditioner
    Operator" in the parameter list. The choices are "Use Jacobian" or
    "Finite Difference".

    The Jacobian and preconditioner each require an interface to update
    the state of the operator with respect to the solution vector and any
    other parameters. There are three interfaces that can be implemented,
    NOX::Epetra::Interface::Required, NOX::Epetra::Interface::Jacobian,
    and NOX::Epetra::Interface::Preconditioner.

    NOX::Epetra::Interface::Required supplies the computeF() function so
    codes can tell NOX what the nonlinear equations are. This is the
    minimum requirement to run nox through the epetra interface.
    LinearSolverAztecOO requires this in some constructors so that if a
    Jacobian or preconditoner is not supplied, it will use computeF from
    the Required interface to estimate the Jacobian or preconditioner via
    finite differences or directional derivatives.

    NOX::Epetra::Interface::Jacobian is used for updating a user supplied
    Jacobian opertor with respect to the solution vector and any other
    parameters. It is required only in constructors in which a user
    supplies a Jacobian operator.

    NOX::Epetra::Interface::Preconditioner is used for updating a user
    supplied preconditioner opertor/matrix with respect to the solution
    vector and any other parameters. It is required only in constructors
    in which a user supplies a preconditioner operator.

    "Linear Solver" sublist parameters

    A Teuchos::ParameterList called linearSolverParams is required in the
    various constructors and during some method calls such as
    applyJacobianInverse() and applyRightPreconditioning(). Typically,
    this list is the "Linear Solver" sublist found in the nox parameter
    list. The following parameters can be set in the linear solver sublist
    and are vaild for the NOX::Epetra::LinearSolverAztecOO object: "Aztec
    Solver" - Determine the iterative technique used in the solve. The
    following options are valid:

    "GMRES" - Restarted generalized minimal residual (default).

    "CG" - Conjugate gradient.

    "CGS" - Conjugate gradient squared.

    "TFQMR" - Transpose-free quasi-minimal reasidual.

    "BiCGStab" - Bi-conjugate gradient with stabilization.

    "LU" - Sparse direct solve (single processor only).

    "Size of Krylov Subspace" - When using restarted GMRES this sets the
    maximum size of the Krylov subspace (defaults to 300).

    "Orthogonalization" - The orthogonalization routine used for the
    Gram-Schmidt orthogonalization procedure in Aztec. The following
    options are valid:

    "Classical" - (default).

    "Modified"

    "Convergence Test" - Algorithm used to calculate the residual that
    is used for determining the convergence of the linear solver. See the
    Aztec 2.1 manual for more information. The following options are
    valid:

    "r0" - (default)

    "rhs"

    "norm"

    "no scaling"

    "sol"

    "Tolerance" - Tolerance used by AztecOO to determine if an iterative
    linear solve has converged.

    "Ill-Conditioning Threshold" - If the upper hessenberg matrix during
    GMRES generates a condition number greater than this parameter value,
    aztec will exit the linear solve returning the it's current solution.
    The default is 1.0e11.

    "Preconditioner Iterations" - Number of iterations an
    AztecOO_Operator should take when solving the preconditioner. This is
    only used if an AztecOO preconditioner is used and the solver makes a
    call to NOX::Epetra::Group::applyRightPreconditioning(). This is NOT a
    recomended approach.

    "Max Iterations" - maximum number of iterations in the linear solve.
    Default is 400.

    "Zero Initial Guess" - boolean. Zero out the initial guess for
    linear solves performed through applyJacobianInverse calls (i.e. zero
    out the result vector before the linear solve). Defaults to false.

    "Throw Error on Prec Failure" - boolean. If set to true, an
    exception will be thrown if the preconditioner fails to initialize or
    recompute/refactor. If set to false, a warning will br printed if the
    NOX::Utils::Warning is enabled in the printing utilities (
    NOX::Utils). Defaults to true.

    "Output Frequency" - number of linear solve iterations between
    output of the linear solve residual. Takes an integer, or one of the
    AztecOO flags: AZ_none, AZ_last, or AZ_all as a value. Defaults to
    AZ_last.

    "Jacobian Operator" - When a constructor does not require a Jacobian
    operator, the linear system will create a default operator using:

    "Matrix-Free" (default)

    "Finite Difference"

    "Preconditioner" - Sets the choice of the preconditioner to use
    during linear solves. The validity of the choice of preconditioner
    will depend on the types of operators that are available for the
    Jacobian and preconditioner. NOTE: This flag will override any
    constructor details. For example, if you supply a preconditioner
    operator in the constructor, it will not be used if this flag is set
    to "None". If you supply an Epetra_Operator for the preconditioner
    but the "Preconditioner" flag is set to "AztecOO" (this requires
    an Epetra_RowMatrix for the preconditioner operator), this object will
    exit with a failure. The valid options and any requirements on the
    operator type are listed below:

    "None" - No preconditioning. (default)

    "AztecOO" - AztecOO internal preconditioner. This requires a
    preconditioner operator that derives from the Epetra_RowMatrix class.

    "Ifpack" - Ifpack internal preconditioner. This requires a
    preconditioner object that derives from the Epetra_RowMatrix class or
    it can use a Jacobian if the Jacobian derives from an
    Epetra_RowMatrix. This option is deprecated. Please use "New
    Ifpack".

    "New Ifpack" - Ifpack internal preconditioner. This requires a
    preconditioner object that derives from the Epetra_RowMatrix class or
    it can use a Jacobian if the Jacobian derives from an
    Epetra_RowMatrix.

    "User Defined" - The user supplies an Epetra_Operator derived class.
    Users must implement at a minimum the ApplyInverse() function of the
    Epetra_Operator class since preconditioning of vectors is accomplished
    through calls to this method.

    "Jacobian Operator" - If a constructor is used that does not supply
    a Jacobian operator, nox will create an internal Jacobian operator.
    This flag is ONLY valid in such cases. This will determine which
    Operator is used: "Matrix-Free" - Create a NOX::Epetra::MatrixFree
    object.

    "Finite Difference" - Create a NOX::Epetra::FiniteDifference object.

    "Preconditioner Operator" - If a constructor is used that does not
    supply a preconditioner operator, nox will create an internal
    preconditioner operator. This flag is ONLY valid in such cases. This
    will determine which Operator is used: "Use Jacobian" - Use the
    Jacobian Operator (it must be an Epetra_RowMatrix derived object).

    "Finite Difference" - Create a NOX::Epetra::FiniteDifference object.

    "Aztec Preconditioner" - If the "Preconditioner" flag is set to
    "AztecOO" then the specific AztecOO preconditioner is specified with
    this flag. Currently supported preconditioners and their corresponding
    parameters that can be set are shown below (See the Aztec 2.1 manual
    for more information):

    "ilu" - ilu preconditioning. This choice allows the following
    additional parameters to be specified: "Overlap" - defaults to 0

    "Graph Fill" - defaults to 0

    "ilut" - ilut preconditioning. This choice allows the following
    additional parameters to be specified: "Overlap" - defaults to 0

    "Fill Factor" - defaults to 1.0

    "Drop Tolerance" - defaults to 1.0e-12

    "Jacobi" - k step Jacobi where k is set by the "Steps" flag:
    "Steps" - defaults to 3.

    "Symmetric Gauss-Siedel" - Non-overlapping domain decomposition k
    step symmetric Gauss-Siedel where k is set by the "Steps" flag:

    "Steps" - defaults to 3.

    "Polynomial" - Neumann polynomial with order set by the parameter:
    "Polynomial Order" - defaults to 3.

    "Least-squares Polynomial" - Least-squares polynomial with order set
    by the parameter: "Polynomial Order" - defaults to 3.

    "Ifpack" - If the "Preconditioner" flag is set to "New Ifpack"
    then any of the options supported by the Ifpack Create factory can be
    specified using a Teuchos::ParameterList containing the Ifpack options
    and then setting this as a parameter named "Ifpack" in the "Linear
    Solver" sublist.

    "ML" - If the "Preconditioner" flag is set to "ML" then any of
    the options supported by the ML factory can be specified using a
    Teuchos::ParameterList containing the ML options and then setting this
    as a parameter named "ML" in the "Linear Solver" sublist.

    "Preconditioner Reuse Policy" - (std::string) Allows the user to set
    how and when the preconditioner should be computed. This flag supports
    native Aztec, Ifpack and ML preconditioners. There are three options:
    "Rebuild" - The "Rebuild" option always completely destroys and
    then rebuilds the preconditioner each time a linear solve is
    requested.

    "Reuse" - The group/linear solver will not recompute the
    preconditioner even if the group's solution vector changes. It just
    blindly reuses what has been constructed. This turns off control of
    preconditioner recalculation. This is a dangerous condition but can
    really speed up the computations if the user knows what they are
    doing. We don't recommend users trying this.

    "Recompute" - Recomputes the preconditioner, but will try to
    efficiently reuse any objects that don't need to be destroyed. How
    efficient the "Recompute" option is depends on the type of
    preconditioner. For example if we are using ILU from the Ifpack
    library, we would like to not destroy and reallocate the graph each
    solve. With this option, we tell Ifpack to reuse the graph from last
    time - e.g the sparisty pattern has not changed between applications
    of the preconditioner.

    "Max Age Of Prec" - (int) If the "Preconditioner Reuse Policy" is
    set to "Reuse", this integer tells the linear system how many times
    to reuse the preconditioner before rebuilding it. Defaults to 1.

    "RCM Reordering" - Enables RCM reordering in conjunction with domain
    decomp incomplete factorization preconditioning. The following options
    are valid:

    "Disabled" - (default).

    "Enabled"

    "Use Adaptive Linear Solve" - Enables the use of AztecOO's
    AdaptiveIterate() method instead of calling the Iterate() method. This
    causes the preconditioning matrix to be modified to make the linear
    solves easier. AztecOO will attempt to solve the linear system
    multiple times now and if the solves are failing it will modify the
    preconditioner and try again. Boolean value, defaults to false. NOTE:
    This only works for internal Aztec preconditioners! The
    "Preconditioning" parameter must be set to "AztecOO: Jacobian
    Matrix" or "AztecOO: User RowMatrix". (NOTE: This parameter is
    currently NOT supported)

    "Max Adaptive Solve Iterations" - (integer) Maximum number of
    attempts that the linear solver will make when trying to solve a
    linear system. Defaults to 5. (NOTE: This parameter is currently NOT
    supported)

    "Compute Scaling Manually" - (boolean) The linear system can be
    scaled if a NOX::Epetra::Scaling object is supplied to
    LinearSystemAztecOO. When to compute the scaling can be handled either
    manually by the user, or this object can automatically compute the
    scaling prior to a linear solve. By setting this flag to true, the
    user will call NOX::Epetra::Scaling::computeScaling() manually - on
    their own! Setting this to false means the LinearSystemAztecOO object
    will call the computeScaling function right before it applies the
    scaling to the matrix in the applyJacobianInverse function. Default is
    true (user will call compute scaling).

    "Output Solver Details" - (boolean) Write the output sublist below
    to the parameter list after each linear solve. default is true.

    "Write Linear System" - (boolean) If set to true, the linear system
    (Epetra_Map, Jacobian, LHS and RHS) is printed to a set of files in
    matrix market format. This option requires building nox with the
    flagenable-nox-debug and building the EpetraExt library.

    "Write Linear System File Prefix" - (std::string) If writing of the
    linear system is enabled (see above parameter) users can change the
    name of the output file prefix. The default is "NOX_LinSys". This
    option requires building nox with the flagenable-nox-debug and
    building the EpetraExt library.

    "Output" sublist

    The parameter list passed in during calls to ApplyJacobianInverse()
    will have an "Output" sublist created that contains the following
    parameters if the flag "Output Solver Details" is set to true:

    "Acheived Tolerance" - Actual tolerance achieved by the linear
    solver computed via the convergence test requested.

    "Number of Linear Iterations" - Number of iterations used by the
    linear solver in the last call to applyJacobianInverse

    "Total Number of Linear Iterations" - Total number of linear solve
    iterations performed by groups that have used this input list

    C++ includes: NOX_Epetra_LinearSystem_AztecOO.H 
    """

    __swig_setmethods__ = {}
    for _s in [LinearSystem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearSystemAztecOO, name, value)
    __swig_getmethods__ = {}
    for _s in [LinearSystem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearSystemAztecOO, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & iReq, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & iReq, Teuchos::RCP< NOX::Epetra::Interface::Jacobian > const & iJac, Teuchos::RCP< Epetra_Operator > const & J, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Required > const & i, Teuchos::RCP< NOX::Epetra::Interface::Preconditioner > const & iPrec, Teuchos::RCP< Epetra_Operator > const & M, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO
        __init__(NOX::Epetra::LinearSystemAztecOO self, ParameterList printingParams, ParameterList linearSolverParams, Teuchos::RCP< NOX::Epetra::Interface::Jacobian > const & iJac, Teuchos::RCP< Epetra_Operator > const & J, Teuchos::RCP< NOX::Epetra::Interface::Preconditioner > const & iPrec, Teuchos::RCP< Epetra_Operator > const & M, Vector cloneVector, Teuchos::RCP< NOX::Epetra::Scaling > const scalingObject) -> LinearSystemAztecOO

        NOX::Epetra::LinearSystemAztecOO::LinearSystemAztecOO(Teuchos::ParameterList
        &printingParams, Teuchos::ParameterList &linearSolverParams, const
        Teuchos::RCP< NOX::Epetra::Interface::Jacobian > &iJac, const
        Teuchos::RCP< Epetra_Operator > &J, const Teuchos::RCP<
        NOX::Epetra::Interface::Preconditioner > &iPrec, const Teuchos::RCP<
        Epetra_Operator > &M, const NOX::Epetra::Vector &cloneVector, const
        Teuchos::RCP< NOX::Epetra::Scaling > scalingObject=Teuchos::null)

        Constructor with user supplied separate objects for the Jacobian (J)
        and Preconditioner (M). linearSolverParams is the "Linear Solver"
        sublist of parameter list. 
        """
        this = ___init__.new_LinearSystemAztecOO(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_LinearSystemAztecOO

    def applyJacobian(self, *args):
        """
        applyJacobian(LinearSystemAztecOO self, Vector input, Vector result) -> bool

        bool NOX::Epetra::LinearSystemAztecOO::applyJacobian(const
        NOX::Epetra::Vector &input, NOX::Epetra::Vector &result) const

        Applies Jacobian to the given input vector and puts the answer in the
        result.

        Computes \\[ v = J u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector. Returns true if
        successful. 
        """
        return ___init__.LinearSystemAztecOO_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(LinearSystemAztecOO self, Vector input, Vector result) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::applyJacobianTranspose(const
        NOX::Epetra::Vector &input, NOX::Epetra::Vector &result) const

        Applies Jacobian-Transpose to the given input vector and puts the
        answer in the result.

        Computes \\[ v = J^T u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector. Returns true if
        successful. 
        """
        return ___init__.LinearSystemAztecOO_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(LinearSystemAztecOO self, ParameterList linearSolverParams, Vector input, Vector result) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::applyJacobianInverse(Teuchos::ParameterList
        &linearSolverParams, const NOX::Epetra::Vector &input,
        NOX::Epetra::Vector &result)

        Applies the inverse of the Jacobian matrix to the given input vector
        and puts the answer in result.

        Computes \\[ v = J^{-1} u, \\] where $J$ is the Jacobian, $u$ is
        the input vector, and $v$ is the result vector.

        The parameter list contains the linear solver options. 
        """
        return ___init__.LinearSystemAztecOO_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """
        applyRightPreconditioning(LinearSystemAztecOO self, bool useTranspose, ParameterList linearSolverParams, Vector input, Vector result) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::applyRightPreconditioning(bool
        useTranspose, Teuchos::ParameterList &linearSolverParams, const
        NOX::Epetra::Vector &input, NOX::Epetra::Vector &result) const

        Apply right preconditiong to the given input vector.

        Let $M$ be a right preconditioner for the Jacobian $J$; in other
        words, $M$ is a matrix such that \\[ JM \\approx I. \\]

        Compute \\[ u = M^{-1} v, \\] where $u$ is the input vector and
        $v$ is the result vector.

        If useTranspose is true, then the transpose of the preconditioner is
        applied: \\[ u = {M^{-1}}^T v, \\] The transpose preconditioner is
        currently only required for Tensor methods.

        The parameter list contains the linear solver options. 
        """
        return ___init__.LinearSystemAztecOO_applyRightPreconditioning(self, *args)


    def createPreconditioner(self, *args):
        """
        createPreconditioner(LinearSystemAztecOO self, Vector x, ParameterList linearSolverParams, bool recomputeGraph) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::createPreconditioner(const
        NOX::Epetra::Vector &x, Teuchos::ParameterList &linearSolverParams,
        bool recomputeGraph) const

        Explicitly constructs a preconditioner based on the solution vector x
        and the parameter list p.

        The user has the option of recomputing the graph when a new
        preconditioner is created. The NOX::Epetra::Group controls the isValid
        flag for the preconditioner and will control when to call this. 
        """
        return ___init__.LinearSystemAztecOO_createPreconditioner(self, *args)


    def destroyPreconditioner(self, *args):
        """
        destroyPreconditioner(LinearSystemAztecOO self) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::destroyPreconditioner() const

        Deletes all objects associated with the chosen preconditioner. This is
        called during linear solves and when the solution vector changes to
        reset the preconditioner. 
        """
        return ___init__.LinearSystemAztecOO_destroyPreconditioner(self, *args)


    def recomputePreconditioner(self, *args):
        """
        recomputePreconditioner(LinearSystemAztecOO self, Vector x, ParameterList linearSolverParams) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::recomputePreconditioner(const
        NOX::Epetra::Vector &x, Teuchos::ParameterList &linearSolverParams)
        const

        Recalculates the preconditioner using an already allocated graph.

        Use this to compute a new preconditioner while using the same graph
        for the preconditioner. This avoids deleting and reallocating the
        memory required for the preconditioner and results in a big speed-up
        for large-scale jobs. 
        """
        return ___init__.LinearSystemAztecOO_recomputePreconditioner(self, *args)


    def getPreconditionerPolicy(self, *args):
        """
        getPreconditionerPolicy(LinearSystemAztecOO self, bool advanceReuseCounter=True) -> NOX::Epetra::LinearSystem::PreconditionerReusePolicyType

        NOX::Epetra::LinearSystem::PreconditionerReusePolicyType
        NOX::Epetra::LinearSystemAztecOO::getPreconditionerPolicy(bool
        advanceReuseCounter=true)

        Evaluates the preconditioner policy at the current state.

        NOTE: This can change values between nonlienar iterations. It is not a
        static value. 
        """
        return ___init__.LinearSystemAztecOO_getPreconditionerPolicy(self, *args)


    def reset(self, *args):
        """
        reset(LinearSystemAztecOO self, ParameterList linearSolverParams)

        void
        NOX::Epetra::LinearSystemAztecOO::reset(Teuchos::ParameterList
        &linearSolverParams)

        Reset the linear solver parameters. 
        """
        return ___init__.LinearSystemAztecOO_reset(self, *args)


    def getScaling(self, *args):
        """
        getScaling(LinearSystemAztecOO self) -> Teuchos::RCP< NOX::Epetra::Scaling >

        Teuchos::RCP< NOX::Epetra::Scaling >
        NOX::Epetra::LinearSystemAztecOO::getScaling()

        Get the scaling object. 
        """
        return ___init__.LinearSystemAztecOO_getScaling(self, *args)


    def resetScaling(self, *args):
        """
        resetScaling(LinearSystemAztecOO self, Teuchos::RCP< NOX::Epetra::Scaling > const & s)

        void NOX::Epetra::LinearSystemAztecOO::resetScaling(const
        Teuchos::RCP< NOX::Epetra::Scaling > &s)

        Sets the diagonal scaling vector(s) used in scaling the linear system.
        See NOX::Epetra::Scaling for details on how to specify scaling of the
        linear system. 
        """
        return ___init__.LinearSystemAztecOO_resetScaling(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(LinearSystemAztecOO self, Vector x) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::computeJacobian(const
        NOX::Epetra::Vector &x)

        Compute the Jacobian. 
        """
        return ___init__.LinearSystemAztecOO_computeJacobian(self, *args)


    def getJacobianInterface(self, *args):
        """
        getJacobianInterface(LinearSystemAztecOO self) -> Teuchos::RCP< NOX::Epetra::Interface::Jacobian const >

        Teuchos::RCP<
        const NOX::Epetra::Interface::Jacobian >
        NOX::Epetra::LinearSystemAztecOO::getJacobianInterface() const

        NOX::Interface::Jacobian accessor. 
        """
        return ___init__.LinearSystemAztecOO_getJacobianInterface(self, *args)


    def getPrecInterface(self, *args):
        """
        getPrecInterface(LinearSystemAztecOO self) -> Teuchos::RCP< NOX::Epetra::Interface::Preconditioner const >

        Teuchos::RCP<
        const NOX::Epetra::Interface::Preconditioner >
        NOX::Epetra::LinearSystemAztecOO::getPrecInterface() const

        NOX::Interface::Preconditioiner accessor. 
        """
        return ___init__.LinearSystemAztecOO_getPrecInterface(self, *args)


    def isPreconditionerConstructed(self, *args):
        """
        isPreconditionerConstructed(LinearSystemAztecOO self) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::isPreconditionerConstructed() const

        Indicates whether a preconditioner has been constructed. 
        """
        return ___init__.LinearSystemAztecOO_isPreconditionerConstructed(self, *args)


    def hasPreconditioner(self, *args):
        """
        hasPreconditioner(LinearSystemAztecOO self) -> bool

        bool
        NOX::Epetra::LinearSystemAztecOO::hasPreconditioner() const

        Indicates whether the linear system has a preconditioner. 
        """
        return ___init__.LinearSystemAztecOO_hasPreconditioner(self, *args)


    def getJacobianOperator(self, *args):
        """
        getJacobianOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator const >
        getJacobianOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator >

        Teuchos::RCP<
        Epetra_Operator >
        NOX::Epetra::LinearSystemAztecOO::getJacobianOperator()

        Jacobian Epetra_Operator accessor. 
        """
        return ___init__.LinearSystemAztecOO_getJacobianOperator(self, *args)


    def getPrecOperator(self, *args):
        """
        getPrecOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator const >

        Teuchos::RCP<
        const Epetra_Operator >
        NOX::Epetra::LinearSystemAztecOO::getPrecOperator() const

        Preconditioner Epetra_Operator accessor (only the base matrix if using
        an internal preconditioner - aztecoo or ifpack). 
        """
        return ___init__.LinearSystemAztecOO_getPrecOperator(self, *args)


    def getGeneratedPrecOperator(self, *args):
        """
        getGeneratedPrecOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator const >
        getGeneratedPrecOperator(LinearSystemAztecOO self) -> Teuchos::RCP< Epetra_Operator >

        Teuchos::RCP< Epetra_Operator >
        NOX::Epetra::LinearSystemAztecOO::getGeneratedPrecOperator()

        Return preconditioner operator generated and stored in AztecOO. 
        """
        return ___init__.LinearSystemAztecOO_getGeneratedPrecOperator(self, *args)


    def getTimeCreatePreconditioner(self, *args):
        """
        getTimeCreatePreconditioner(LinearSystemAztecOO self) -> double

        double
        NOX::Epetra::LinearSystemAztecOO::getTimeCreatePreconditioner() const

        Returns the total time (sec.) spent in createPreconditioner(). 
        """
        return ___init__.LinearSystemAztecOO_getTimeCreatePreconditioner(self, *args)


    def getTimeApplyJacobianInverse(self, *args):
        """
        getTimeApplyJacobianInverse(LinearSystemAztecOO self) -> double

        double
        NOX::Epetra::LinearSystemAztecOO::getTimeApplyJacobianInverse() const

        Returns the total time (sec.) spent in applyJacobianInverse(). 
        """
        return ___init__.LinearSystemAztecOO_getTimeApplyJacobianInverse(self, *args)


    def setJacobianOperatorForSolve(self, *args):
        """
        setJacobianOperatorForSolve(LinearSystemAztecOO self, Teuchos::RCP< Epetra_Operator const > const & solveJacOp)

        void
        NOX::Epetra::LinearSystemAztecOO::setJacobianOperatorForSolve(const
        Teuchos::RCP< const Epetra_Operator > &solveJacOp)

        Set Jacobian operator for solve. 
        """
        return ___init__.LinearSystemAztecOO_setJacobianOperatorForSolve(self, *args)


    def setPrecOperatorForSolve(self, *args):
        """
        setPrecOperatorForSolve(LinearSystemAztecOO self, Teuchos::RCP< Epetra_Operator const > const & solvePrecOp)

        void
        NOX::Epetra::LinearSystemAztecOO::setPrecOperatorForSolve(const
        Teuchos::RCP< const Epetra_Operator > &solvePrecOp)

        Set preconditioner operator for solve.

        Note: This should only be called if hasPreconditioner() returns true.

        """
        return ___init__.LinearSystemAztecOO_setPrecOperatorForSolve(self, *args)

LinearSystemAztecOO_swigregister = ___init__.LinearSystemAztecOO_swigregister
LinearSystemAztecOO_swigregister(LinearSystemAztecOO)

class ModelEvaluatorInterface(Interface.Required, Interface.Jacobian, Interface.Preconditioner):
    """Proxy of C++ NOX::Epetra::ModelEvaluatorInterface class."""

    __swig_setmethods__ = {}
    for _s in [Interface.Required, Interface.Jacobian, Interface.Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ModelEvaluatorInterface, name, value)
    __swig_getmethods__ = {}
    for _s in [Interface.Required, Interface.Jacobian, Interface.Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ModelEvaluatorInterface, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_ModelEvaluatorInterface

    def computeF(self, *args):
        """
        computeF(ModelEvaluatorInterface self, Vector x, Vector F, NOX::Epetra::Interface::Required::FillType const fillFlag) -> bool

        virtual bool NOX::Epetra::Interface::Required::computeF(const
        Epetra_Vector &x, Epetra_Vector &F, const FillType fillFlag)=0

        Compute the function, F, given the specified input vector x. Returns
        true if computation was successful. 
        """
        return ___init__.ModelEvaluatorInterface_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(ModelEvaluatorInterface self, Vector x, Operator Jac) -> bool

        virtual bool
        NOX::Epetra::Interface::Jacobian::computeJacobian(const Epetra_Vector
        &x, Epetra_Operator &Jac)=0

        Compute Jacobian given the specified input vector x. Returns true if
        computation was successful. 
        """
        return ___init__.ModelEvaluatorInterface_computeJacobian(self, *args)


    def computePreconditioner(self, *args):
        """
        computePreconditioner(ModelEvaluatorInterface self, Vector x, Operator M, ParameterList precParams=None) -> bool

        virtual bool
        NOX::Epetra::Interface::Preconditioner::computePreconditioner(const
        Epetra_Vector &x, Epetra_Operator &M, Teuchos::ParameterList
        *precParams=0)=0

        Computes a user defined preconditioner. 
        """
        return ___init__.ModelEvaluatorInterface_computePreconditioner(self, *args)


    def inargs_set_p(self, *args):
        """inargs_set_p(ModelEvaluatorInterface self, Teuchos::RCP< Epetra_Vector const > const p, int const l=0) -> bool"""
        return ___init__.ModelEvaluatorInterface_inargs_set_p(self, *args)


    def set_inargs(self, *args):
        """set_inargs(ModelEvaluatorInterface self, EpetraExt::ModelEvaluator::InArgs const & inargs_in) -> bool"""
        return ___init__.ModelEvaluatorInterface_set_inargs(self, *args)


    def __init__(self, *args):
        """__init__(NOX::Epetra::ModelEvaluatorInterface self, ModelEvaluator eeme) -> ModelEvaluatorInterface"""
        this = ___init__.new_ModelEvaluatorInterface(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
ModelEvaluatorInterface_swigregister = ___init__.ModelEvaluatorInterface_swigregister
ModelEvaluatorInterface_swigregister(ModelEvaluatorInterface)


def defaultNonlinearParameters(comm=None, verbosity=0, outputPrec=3,
                               maxIterations=800, tolerance=1.0e-4):
    """
    defaultNonlinearParameters(comm=None, verbosity=0, outputPrec=3,
                               maxIterations=800, tolerance=1.0e-4) -> dict

    Return a dictionary that can serve as a default list of parameters for a NOX
    solver.  Entries can be altered before passing to a NOX solver constructor.

    comm          - Epetra communicator object.  If not provided, the function
                    uses an Epetra.SerialComm communicator.

    verbosity     - A simple indication of verbosity level.  0: errors and test
                    details.  1: debugging, warnings, details, parameters and
                    linear solver details.  2: inner iteration, outer iteration
                    status test and outer iteration.  Default 0.

    outputPrec    - Number of significant digits to output.  Default 3.

    maxIterations - Maximum allowable linear (inner) iterations.  Default 800.

    tolerance     - Linear solver tolerance level.  Default 1.0e-4.
    """
# Communicator
    if comm is None:
        comm = PyTrilinos.Epetra.SerialComm()
    myPID = comm.MyPID()

# Create the printing parameter list
    Utils = PyTrilinos.NOX.Utils
    outputInfo = Utils.Error + Utils.TestDetails
    if verbosity: outputInfo += Utils.Debug      + \
                                Utils.Warning    + \
                                Utils.Details    + \
                                Utils.Parameters + \
                                Utils.LinearSolverDetails
    if verbosity > 1: outputInfo += Utils.InnerIteration           + \
                                    Utils.OuterIterationStatusTest + \
                                    Utils.OuterIteration
    printParams = {"MyPID"              : myPID,
                   "Output Precision"   : outputPrec,
                   "Output Processor"   : 0,
                   "Output Information" : outputInfo}

# Create the linear solver parameter list
    lsParams = {"Aztec Solver"    : "GMRES",
                "Max Iterations"  : maxIterations,
                "Tolerance"       : tolerance,
                "Preconditioner"  : "Ifpack",
                "Max Age Of Prec" : 5       }

# Create the nonlinear solver parameter list
    nlParams = {"Nonlinear Solver" : "Line Search Based",
                "Printing"         : printParams,
                "Line Search"      : {"Method" : "Full Step"},
                "Direction"        : {"Method" : "Newton"},
                "Newton"           : {"Forcing Term Method" : "Constant"},
                "Linear Solver"    : lsParams,
                "Solver Options"   : {"Status Test Check Type" : "Complete"}
                }

    return nlParams

def defaultGroup(nonlinearParameters, initGuess, reqInterface, jacInterface=None,
                 jacobian=None, precInterface=None, preconditioner=None):
    """
    defaultGroup(nonlinearParameters, initGuess, reqInterface, jacInterface=None,
                 jacobian=None, precInterface=None, preconditioner=None) -> Group

    Return a NOX.Epetra.Group based upon the given input arguments:

    nonlinearParameters - a dict with nonlinear parameters.  Can be obtained
                          from defaultNonlinearParameters()
    initGuess           - an initial guess Epetra.Vector.
    reqInterface        - a NOX.Epetra.Interface.Required object that defines
                          the interface to the nonlinear problem.  May be
                          None if both the Jacobian and preconditioner are
                          provided.
    jacInterface        - a NOX.Epetra.Interface.Jacobian object that defines the
                          Jacobian of the nonlinear problem.  Default None.
    jacobian            - if jacInterface is provided, this is the Epetra.Operator
                          that defines the Jacobian matrix.  Default None.
    precInterface       - a NOX.Epetra.Interface.Preconditioner object that defines
                          the preconditioner to the nonlinear problem.  Default None.
    preconditioner      - if precInterface is provided, this is the
                          Epetra.Operator that defines the preconditioner.
                          Default None.
    """

# Sanity checks to prevent more cryptic problems down the road...
    if jacInterface is None or precInterface is None:
        assert isinstance(reqInterface, Interface.Required)
    if jacInterface is not None:
        assert isinstance(jacInterface, Interface.Jacobian        )
        assert isinstance(jacobian    , PyTrilinos.Epetra.Operator)
    if precInterface is not None:
        assert isinstance(precInterface , Interface.Preconditioner  )
        assert isinstance(preconditioner, PyTrilinos.Epetra.Operator)

# Extract parameter lists
    printParams = nonlinearParameters["Printing"     ]
    lsParams    = nonlinearParameters["Linear Solver"]

# Construct a NOX.Epetra.Vector from the Epetra.Vector
    clone = Vector(initGuess, Vector.CreateView)

# Construct the linear system
    if jacInterface:
        if precInterface:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         jacInterface, jacobian,
                                         precInterface, preconditioner,
                                         clone)
        else:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         reqInterface,
                                         jacInterface, jacobian,
                                         clone)
    else:
        if precInterface:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         reqInterface,
                                         precInterface, preconditioner,
                                         clone)
        else:
            linSys = LinearSystemAztecOO(printParams, lsParams,
                                         reqInterface,
                                         clone)

# Construct and return the default Group
    group = Group(printParams, reqInterface, clone, linSys)
    group.linSys = linSys   ### By adding linSys as an attribute to the Group
### variable, we ensure that linSys does not get
### destroyed.  This is a workaround for a
### Teuchos::RCP wrapper bug.
    return group

def defaultStatusTest(absTol=None, relTol=None, relGroup=None, updateTol=None,
                      wAbsTol=None, wRelTol=None, maxIters=None,
                      finiteValue=False):
    """
    defaultStatusTest(absTol=None, relTol=None, relGroup=None, updateTol=None,
                      wAbsTol=None, wRelTol=None, maxIters=None,
                      finiteValue=False) -> StatusTest

    Return a StatusTest object based upon the input arguments:

    absTol      - if specified, include an absolute residual status test, using
                  this value as the tolerance
    relTol      - if specified, along with relGroup, include a relative residual
                  status test, using this value as the tolerance
    relGroup    - if specified, along with relTol, include a relative residual
                  status test, using this Group to determine the scaling
    updateTol   - if specified, include an update status test, using this value
                  as the tolerance
    wAbsTol     - if specified, along with wRelTol, include a weighted RMS
                  status test, using this value as the absolute tolerance
    wRelTol     - if specified, along with wAbsTol, include a weighted RMS
                  status test, using this value as the relative tolerance
    maxIters    - if specified, include a maximum iterations status test, using
                  this value as the maximum allowable iterations
    finiteValue - if True, include a finite value status test.  Default False.
    """
# Build the convergence portion of the status test
    StatusTest = PyTrilinos.NOX.StatusTest
    converged  = StatusTest.Combo(StatusTest.Combo.AND)
    converged.tests = [ ]   ### By adding this list of tests as an attribute to
### the StatusTest variables, we ensure that linSys
### does not get destroyed.  This is a workaround
### for a Teuchos::RCP wrapper bug.

    if absTol:
        absTest = StatusTest.NormF(absTol)
        converged.addStatusTest(absTest)
        converged.tests.append(absTest)
    if relGroup and relTol:
        relTest = StatusTest.NormF(relGroup,relTol)
        converged.addStatusTest(relTest)
        converged.tests.append(relTest)
    if wAbsTol and wRelTol:
        wrmsTest = StatusTest.NormWRMS(wRelTol,wAbsTol)
        converged.addStatusTest(wrmsTest)
        converged.tests.append(wrmsTest)
    if updateTol:
        updateTest = StatusTest.NormUpdate(updateTol)
        converged.addStatusTest(updateTest)
        converged.tests.append(updateTest)

# Return if done
    if not (maxIters or finiteValue):
        return converged

# Add the divergence portion of the default status test
    combo = StatusTest.Combo(StatusTest.Combo.OR)
    combo.tests = [ ]
    if finiteValue:
        fvTest = StatusTest.FiniteValue()
        combo.addStatusTest(fvTest)
        combo.tests.append(fvTest)
    combo.addStatusTest(converged)
    combo.tests.append(converged)
    if maxIters:
        maxIterTest = StatusTest.MaxIters(maxIters)
        combo.addStatusTest(maxIterTest)
        combo.tests.append(maxIterTest)
    return combo

def defaultSolver(initGuess, reqInterface, jacInterface=None, jacobian=None,
                  precInterface=None, preconditioner=None, nlParams=None,
                  absTol=1.0e-8, relTol=1.0e-2, relGroup=None, updateTol=1.0e-5,
                  wAbsTol=1.0e-8, wRelTol=1.0e-2, maxIters=20, finiteValue=True):
    """
    defaultSolver(initGuess, reqInterface, jacInterface=None, jacobian=None,
                  precInterface=None, preconditioner=None, nlParams=None) -> Solver

    Return a default NOX Solver based on the given arguments:

    initGuess      - an Epetra.Vector initial guess
    reqInterface   - a NOX.Epetra.Interface.Required object that defines
                     the interface to the nonlinear problem.  May be
                     None if both the Jacobian and preconditioner are
                     provided.
    jacInterface   - a NOX.Epetra.Interface.Jacobian object that defines the
                     Jacobian of the nonlinear problem.  Default None.
    jacobian       - if jacInterface is provided, this should also be provided
                     and is the Epetra.Operator that defines the Jacobian
                     matrix.  Default None. 
    precInterface  - a NOX.Epetra.Interface.Preconditioner object that defines
                     the preconditioner to the nonlinear problem.  Default None.
    preconditioner - if precInterface is provided, this should also be provided
                     and is the Epetra.Operator that defines the preconditioner.
                     Default None.
    nlParams       - dict that contains a list of nonlinear parameters.  Default
                     None, in which case defaultNonlinearParameters() is used.
    absTol         - if not None, include an absolute residual status test,
                     using this value as the tolerance.  Default 1.0e-8.
    relTol         - if not None, include a relative residual status test, using
                     this value as the tolerance.  Default 1.0e-2.
    relGroup       - if relTol is specified, use this Group to determine the
                     scaling.  If relGroup is None, use the result of
                     defaultGroup().  Default None.
    updateTol      - if not None, include an update status test, using this
                     value as the tolerance.  Default 1.0e-5.
    wAbsTol        - if not None, along with wRelTol, include a weighted RMS
                     status test, using this value as the absolute tolerance.
                     Default 1.0e-8.
    wRelTol        - if not None, along with wAbsTol, include a weighted RMS
                     status test, using this value as the relative tolerance.
                     Default 1.0e-2.
    maxIters       - if not None, include a maximum nonlinear iterations status
                     test, using this value as the maximum allowable iterations.
                     Default 20. 
    finiteValue    - if True, include a finite value status test.  Default
                     True. 
    """

# Sanity checks to prevent more cryptic problems down the road...
    if jacInterface is None or precInterface is None:
        assert isinstance(reqInterface, Interface.Required)
    if jacInterface is not None:
        assert isinstance(jacInterface, Interface.Jacobian        )
        assert isinstance(jacobian    , PyTrilinos.Epetra.Operator)
    if precInterface is not None:
        assert isinstance(precInterface , Interface.Preconditioner  )
        assert isinstance(preconditioner, PyTrilinos.Epetra.Operator)

# Get the communicator
    comm = initGuess.Comm()

# Get the nonlinear parameters
    if nlParams is None:
        nlParams = defaultNonlinearParameters(comm,2)

# Build the default Group
    group = defaultGroup(nlParams, initGuess, reqInterface, jacInterface,
                         jacobian, precInterface, preconditioner)

# Get the default StatusTest
    if relTol and (relGroup is None): relGroup = group
    statusTest = defaultStatusTest(absTol      = absTol,
                                   relTol      = relTol,
                                   relGroup    = relGroup,
                                   updateTol   = updateTol,
                                   wAbsTol     = wAbsTol,
                                   wRelTol     = wRelTol,
                                   maxIters    = maxIters,
                                   finiteValue = finiteValue)

# Return the default Solver
    solver = PyTrilinos.NOX.Solver.buildSolver(group, statusTest, nlParams)
#solver.group      = group        ### By adding group, statusTest and
    solver.statusTest = statusTest   ### nlParams as attributes to the Solver
    solver.nlParams   = nlParams     ### variable, we ensure that they do not
### get destroyed.  This is a workaround for
### a Teuchos::RCP wrapper bug.
    return solver

# This file is compatible with both classic and new-style classes.


