# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Abstract is the python interface to namespace Abstract
of the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Abstract is to provide base classes from which
concrete NOX interfaces can be derived.  Currently, the only concrete
implementation is for Epetra, in the NOX.Epetra module.

NOX.Abstract provides the following user-level classes:

    * Group            - Class defining a collection of objects needed by NOX
    * PrePostOperator  - Pre- and post-iteration operators
    * MultiVector      - Multivector class
    * Vector           - Vector class

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Abstract')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Abstract')
    _Abstract = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Abstract', [dirname(__file__)])
        except ImportError:
            import _Abstract
            return _Abstract
        try:
            _mod = imp.load_module('_Abstract', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Abstract = swig_import_helper()
    del swig_import_helper
else:
    import _Abstract
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x



import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op

import PyTrilinos.Teuchos
import PyTrilinos.Epetra
class PrePostOperator(_object):
    """


    NOX's pure virtual class to allow users to insert pre and post
    operations into nox's solvers (before and after the
    NOX::Solver::Generic::iterate() and NOX::Solver::Generic::solve()
    methods).

    The user should implement their own concrete implementation of this
    class and register it as a
    Teuchos::RCP<NOX::Abstract::PrePostoperator> in the "Solver Options"
    sublist.

    To create and use a user defined pre/post operators:

    Create a pre/post operator that derives from
    NOX::Abstract::PrePostOperator. For example, the pre/post operator Foo
    might be defined as shown below.

    Create the appropriate entries in the parameter list, as follows.

    Roger Pawlowski (SNL 9233)

    C++ includes: NOX_Abstract_PrePostOperator.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PrePostOperator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PrePostOperator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::Abstract::PrePostOperator self) -> PrePostOperator
        __init__(NOX::Abstract::PrePostOperator self, PrePostOperator arg2) -> PrePostOperator

        NOX::Abstract::PrePostOperator::PrePostOperator(const
        NOX::Abstract::PrePostOperator &)

        Copy constructor (doesnothing) 
        """
        if self.__class__ == PrePostOperator:
            _self = None
        else:
            _self = self
        this = _Abstract.new_PrePostOperator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Abstract.delete_PrePostOperator

    def runPreIterate(self, *args):
        """
        runPreIterate(PrePostOperator self, NOX::Solver::Generic const & solver)

        void NOX::Abstract::PrePostOperator::runPreIterate(const
        NOX::Solver::Generic &solver)

        User defined method that will be executed at the start of a call to
        NOX::Solver::Generic::iterate(). 
        """
        return _Abstract.PrePostOperator_runPreIterate(self, *args)


    def runPostIterate(self, *args):
        """
        runPostIterate(PrePostOperator self, NOX::Solver::Generic const & solver)

        void NOX::Abstract::PrePostOperator::runPostIterate(const
        NOX::Solver::Generic &solver)

        User defined method that will be executed at the end of a call to
        NOX::Solver::Generic::iterate(). 
        """
        return _Abstract.PrePostOperator_runPostIterate(self, *args)


    def runPreSolve(self, *args):
        """
        runPreSolve(PrePostOperator self, NOX::Solver::Generic const & solver)

        void NOX::Abstract::PrePostOperator::runPreSolve(const
        NOX::Solver::Generic &solver)

        User defined method that will be executed at the start of a call to
        NOX::Solver::Generic::solve(). 
        """
        return _Abstract.PrePostOperator_runPreSolve(self, *args)


    def runPostSolve(self, *args):
        """
        runPostSolve(PrePostOperator self, NOX::Solver::Generic const & solver)

        void NOX::Abstract::PrePostOperator::runPostSolve(const
        NOX::Solver::Generic &solver)

        User defined method that will be executed at the end of a call to
        NOX::Solver::Generic::solve(). 
        """
        return _Abstract.PrePostOperator_runPostSolve(self, *args)

    def __disown__(self):
        self.this.disown()
        _Abstract.disown_PrePostOperator(self)
        return weakref_proxy(self)
PrePostOperator_swigregister = _Abstract.PrePostOperator_swigregister
PrePostOperator_swigregister(PrePostOperator)

class MultiVector(_object):
    """


    Abstract interface for multi-vectors used by NOX.

    C++ includes: NOX_Abstract_MultiVector.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Abstract.delete_MultiVector

    def init(self, *args):
        """
        init(MultiVector self, double gamma) -> MultiVector

        virtual
        NOX::Abstract::MultiVector& NOX::Abstract::MultiVector::init(double
        gamma)=0

        Initialize every element of this multi-vector with gamma. 
        """
        return _Abstract.MultiVector_init(self, *args)


    def random(self, *args):
        """
        random(MultiVector self, bool useSeed=False, int seed=1) -> MultiVector

        virtual
        NOX::Abstract::MultiVector& NOX::Abstract::MultiVector::random(bool
        useSeed=false, int seed=1)=0

        Initialize each element of this multi-vector with a random value. 
        """
        return _Abstract.MultiVector_random(self, *args)


    def setBlock(self, *args):
        """
        setBlock(MultiVector self, MultiVector source, std::vector< int,std::allocator< int > > const & index) -> MultiVector

        virtual
        NOX::Abstract::MultiVector& NOX::Abstract::MultiVector::setBlock(const
        NOX::Abstract::MultiVector &source, const std::vector< int > &index)=0

        Copy the vectors in source to a set of vectors in *this. The
        index.size() vectors in source are copied to a subset of vectors in
        *this indicated by the indices given in index. 
        """
        return _Abstract.MultiVector_setBlock(self, *args)


    def augment(self, *args):
        """
        augment(MultiVector self, MultiVector source) -> MultiVector

        virtual
        NOX::Abstract::MultiVector& NOX::Abstract::MultiVector::augment(const
        NOX::Abstract::MultiVector &source)=0

        Append the vectors in source to *this. 
        """
        return _Abstract.MultiVector_augment(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector self, double gamma) -> MultiVector

        virtual
        NOX::Abstract::MultiVector& NOX::Abstract::MultiVector::scale(double
        gamma)=0

        Scale each element of this multivector by gamma. 
        """
        return _Abstract.MultiVector_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector self, double alpha, MultiVector a, double gamma=0.0) -> MultiVector
        update(MultiVector self, double alpha, MultiVector a, double beta, MultiVector b, double gamma=0.0) -> MultiVector
        update(MultiVector self, Teuchos::ETransp transb, double alpha, MultiVector a, NOX::Abstract::MultiVector::DenseMatrix const & b, double gamma=0.0) -> MultiVector

        virtual
        NOX::Abstract::MultiVector&
        NOX::Abstract::MultiVector::update(Teuchos::ETransp transb, double
        alpha, const NOX::Abstract::MultiVector &a, const DenseMatrix &b,
        double gamma=0.0)=0

        Compute x = (alpha * a * op(b)) + (gamma * x) where a is a
        multivector, b is a dense matrix, x = *this, and op(b) = b if transb =
        Teuchos::NO_TRANS and op(b) is b transpose if transb = Teuchos::TRANS.

        """
        return _Abstract.MultiVector_update(self, *args)


    def clone(self, *args):
        """
        clone(MultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        virtual
        Teuchos::RCP<NOX::Abstract::MultiVector>
        NOX::Abstract::MultiVector::clone(int numvecs) const =0

        Creates a new multi-vector with numvecs columns. 
        """
        return _Abstract.MultiVector_clone(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        virtual
        Teuchos::RCP<NOX::Abstract::MultiVector>
        NOX::Abstract::MultiVector::subCopy(const std::vector< int > &index)
        const =0

        Creates a new multi-vector with index.size() columns whose columns are
        copies of the columns of *this given by index. 
        """
        return _Abstract.MultiVector_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        virtual
        Teuchos::RCP<NOX::Abstract::MultiVector>
        NOX::Abstract::MultiVector::subView(const std::vector< int > &index)
        const =0

        Creates a new multi-vector with ndex.size() columns that shares the
        columns of *this given by index. 
        """
        return _Abstract.MultiVector_subView(self, *args)


    def norm(self, *args):
        """
        norm(MultiVector self, std::vector< double,std::allocator< double > > & result, NOX::Abstract::Vector::NormType type)

        virtual void
        NOX::Abstract::MultiVector::norm(std::vector< double > &result,
        NOX::Abstract::Vector::NormType type=NOX::Abstract::Vector::TwoNorm)
        const =0

        Norm. 
        """
        return _Abstract.MultiVector_norm(self, *args)


    def multiply(self, *args):
        """
        multiply(MultiVector self, double alpha, MultiVector y, NOX::Abstract::MultiVector::DenseMatrix & b)

        virtual
        void NOX::Abstract::MultiVector::multiply(double alpha, const
        NOX::Abstract::MultiVector &y, DenseMatrix &b) const =0

        Computes the matrix-matrix product $\\alpha * y^T * (*this)$. 
        """
        return _Abstract.MultiVector_multiply(self, *args)


    def length(self, *args):
        """
        length(MultiVector self) -> NOX::size_type

        virtual
        NOX::size_type NOX::Abstract::MultiVector::length() const =0

        Return the length of multi-vector. 
        """
        return _Abstract.MultiVector_length(self, *args)


    def numVectors(self, *args):
        """
        numVectors(MultiVector self) -> int

        virtual int NOX::Abstract::MultiVector::numVectors() const =0

        Return the number of vectors in the multi-vector. 
        """
        return _Abstract.MultiVector_numVectors(self, *args)


    def _print(self, *args):
        """
        _print(MultiVector self, std::ostream & stream)

        virtual
        void NOX::Abstract::MultiVector::print(std::ostream &stream) const =0

        Print the vector. This is meant for debugging purposes only. 
        """
        return _Abstract.MultiVector__print(self, *args)

MultiVector_swigregister = _Abstract.MultiVector_swigregister
MultiVector_swigregister(MultiVector)

DeepCopy = _Abstract.DeepCopy
ShapeCopy = _Abstract.ShapeCopy
class Vector(_object):
    """


    NOX's pure abstract vector interface for vectors that are used by the
    nonlinear solver.

    This class is a member of the namespace NOX::Abstract.

    The user should implement their own concrete implementation of this
    class or use one of the implementations provided by us.

    Tammy Kolda (SNL 8950), Roger Pawlowski (SNL 9233)

    C++ includes: NOX_Abstract_Vector.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    TwoNorm = _Abstract.Vector_TwoNorm
    OneNorm = _Abstract.Vector_OneNorm
    MaxNorm = _Abstract.Vector_MaxNorm
    __swig_destroy__ = _Abstract.delete_Vector

    def init(self, *args):
        """
        init(Vector self, double gamma) -> Vector

        virtual
        NOX::Abstract::Vector& NOX::Abstract::Vector::init(double gamma)=0

        Initialize every element of this vector with gamma.

        Here x represents this vector, and we update it as \\[ x_i =
        \\gamma \\quad \\mbox{for } i=1,\\dots,n \\] Reference to
        this object 
        """
        return _Abstract.Vector_init(self, *args)


    def random(self, *args):
        """
        random(Vector self, bool useSeed=False, int seed=1) -> Vector

        virtual
        NOX::Abstract::Vector& NOX::Abstract::Vector::random(bool
        useSeed=false, int seed=1)=0

        Initialize each element of this vector with a random value.

        If useSeed is true, uses the value of seed to seed the random number
        generator before filling the entries of this vector. So, if two calls
        are made where useSeed is true and seed is the same, then the vectors
        returned should be the same.

        Default implementation throw an error. Only referenced by LOCA
        methods.

        Reference to this object 
        """
        return _Abstract.Vector_random(self, *args)


    def abs(self, *args):
        """
        abs(Vector self, Vector y) -> Vector

        virtual
        NOX::Abstract::Vector& NOX::Abstract::Vector::abs(const
        NOX::Abstract::Vector &y)=0

        Put element-wise absolute values of source vector y into this vector.

        Here x represents this vector, and we update it as \\[ x_i = | y_i |
        \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return _Abstract.Vector_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(Vector self, Vector y) -> Vector

        virtual
        NOX::Abstract::Vector& NOX::Abstract::Vector::reciprocal(const
        NOX::Abstract::Vector &y)=0

        Put element-wise reciprocal of source vector y into this vector.

        Here x represents this vector, and we update it as \\[ x_i =
        \\frac{1}{y_i} \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return _Abstract.Vector_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(Vector self, double gamma) -> Vector
        scale(Vector self, Vector a) -> Vector

        virtual
        NOX::Abstract::Vector& NOX::Abstract::Vector::scale(const
        NOX::Abstract::Vector &a)=0

        Scale this vector element-by-element by the vector a.

        Here x represents this vector, and we update it as \\[ x_i = x_i
        \\cdot a_i \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return _Abstract.Vector_scale(self, *args)


    def update(self, *args):
        """
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector

        virtual
        NOX::Abstract::Vector& NOX::Abstract::Vector::update(double alpha,
        const NOX::Abstract::Vector &a, double beta, const
        NOX::Abstract::Vector &b, double gamma=0.0)=0

        Compute x = (alpha * a) + (beta * b) + (gamma * x) where x is this
        vector.

        Here x represents this vector, and we update it as \\[ x_i =
        \\alpha \\; a_i + \\beta \\; b_i + \\gamma \\; x_i
        \\quad \\mbox{for } i=1,\\dots,n \\]

        Reference to this object 
        """
        return _Abstract.Vector_update(self, *args)


    def clone(self, *args):
        """
        clone(Vector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >

        virtual
        Teuchos::RCP<NOX::Abstract::Vector>
        NOX::Abstract::Vector::clone(NOX::CopyType type=NOX::DeepCopy) const
        =0

        Create a new Vector of the same underlying type by cloning "this",
        and return a pointer to the new vector.

        If type is NOX::DeepCopy, then we need to create an exact replica of
        "this". Otherwise, if type is NOX::ShapeCopy, we need only replicate
        the shape of "this" (the memory is allocated for the objects, but
        the current values are not copied into the vector). Note that there is
        no assumption that a vector created by ShapeCopy is initialized to
        zeros.

        Pointer to newly created vector or NULL if clone is not supported. 
        """
        return _Abstract.Vector_clone(self, *args)


    def createMultiVector(self, *args):
        """
        createMultiVector(Vector self, NOX::Abstract::Vector const *const * vecs, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        createMultiVector(Vector self, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        NOX::Abstract::Vector::createMultiVector(int numVecs, NOX::CopyType
        type=NOX::DeepCopy) const

        Create a MultiVector with numVecs columns.

        The default implementation creates a generic NOX::MultiVector with
        either Shape or Deep copies of the supplied vector. 
        """
        return _Abstract.Vector_createMultiVector(self, *args)


    def norm(self, *args):
        """
        norm(Vector self, NOX::Abstract::Vector::NormType type) -> double
        norm(Vector self, Vector weights) -> double

        virtual double
        NOX::Abstract::Vector::norm(const NOX::Abstract::Vector &weights)
        const =0

        Weighted 2-Norm.

        Here x represents this vector, and we compute its weighted norm as
        follows: \\[ \\|x\\|_w = \\sqrt{\\sum_{i=1}^{n} w_i \\;
        x_i^2} \\]  $ \\|x\\|_w $ 
        """
        return _Abstract.Vector_norm(self, *args)


    def innerProduct(self, *args):
        """
        innerProduct(Vector self, Vector y) -> double

        virtual
        double NOX::Abstract::Vector::innerProduct(const NOX::Abstract::Vector
        &y) const =0

        Inner product with y.

        Here x represents this vector, and we compute its inner product with y
        as follows: \\[ \\langle x,y \\rangle = \\sum_{i=1}^n x_i y_i
        \\]  $\\langle x,y \\rangle$ 
        """
        return _Abstract.Vector_innerProduct(self, *args)


    def length(self, *args):
        """
        length(Vector self) -> NOX::size_type

        virtual
        NOX::size_type NOX::Abstract::Vector::length() const =0

        Return the length of vector.

        The length of this vector

        Even if the vector is distributed across processors, this should
        return the  global length of the vector. 
        """
        return _Abstract.Vector_length(self, *args)


    def _print(self, *args):
        """
        _print(Vector self, std::ostream & stream)

        void
        NOX::Abstract::Vector::print(std::ostream &stream) const

        Print the vector. To be used for debugging only. 
        """
        return _Abstract.Vector__print(self, *args)

Vector_swigregister = _Abstract.Vector_swigregister
Vector_swigregister(Vector)

class Group(_object):
    """


    NOX pure abstract interface to a "group"; i.e., a solution vector
    and the corresponding F-vector, Jacobian matrix, gradient vector, and
    Newton vector.

    This class is a member of the namespace NOX::Abstract.

    The user should implement their own concrete implementation of this
    class or use one of the implementations provided by us. Typically the
    implementation is also tied to a particular NOX::Abstract::Vector
    implementation.

    The group may be implemented so that multiple groups can share
    underlying memory space. This is particularly important when it comes
    to the Jacobian, which is often to big to be replicated for every
    group. Thus, we have included instructions on how shared data should
    be treated for the operator=() and clone() functions.

    C++ includes: NOX_Abstract_Group.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    Ok = _Abstract.Group_Ok
    NotDefined = _Abstract.Group_NotDefined
    BadDependency = _Abstract.Group_BadDependency
    NotConverged = _Abstract.Group_NotConverged
    Failed = _Abstract.Group_Failed
    __swig_destroy__ = _Abstract.delete_Group

    def setX(self, *args):
        """
        setX(Group self, Vector y)

        virtual void
        NOX::Abstract::Group::setX(const NOX::Abstract::Vector &y)=0

        Set the solution vector x to y.

        This should invalidate the function value, Jacobian, gradient, and
        Newton direction.

        Throw an error if the copy fails.

        Reference to this object 
        """
        return _Abstract.Group_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(Group self, Group grp, Vector d, double step)

        virtual void
        NOX::Abstract::Group::computeX(const NOX::Abstract::Group &grp, const
        NOX::Abstract::Vector &d, double step)=0

        Compute x = grp.x + step * d.

        Let $x$ denote this group's solution vector. Let $\\hat x$ denote
        the result of grp.getX(). Then set \\[ x = \\hat x +
        \\mbox{step} \\; d. \\]

        This should invalidate the function value, Jacobian, gradient, and
        Newton direction.

        Throw an error if the copy fails.

        Reference to this object 
        """
        return _Abstract.Group_computeX(self, *args)


    def computeF(self, *args):
        """
        computeF(Group self) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType NOX::Abstract::Group::computeF()=0

        Compute and store F(x).

        It's generally useful to also compute and store the 2-norm of F(x) at
        this point for later access by the getNormF() function.

        NOX::Abstract::Group::Failed - If the computation fails in any way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(Group self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::computeJacobian()

        Compute and store Jacobian.

        Recall that \\[ F(x) = \\left[ \\begin{array}{c} F_1(x) \\\\
        F_2(x) \\\\ \\vdots \\\\ F_n(x) \\\\ \\end{array}
        \\right]. \\]

        The Jacobian is denoted by $J$ and defined by \\[ J_{ij} =
        \\frac{\\partial F_i}{\\partial x_j} (x). \\]

        If this is a shared object, this group should take ownership of the
        Jacobian before it computes it.

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::Failed - If the computation fails in any other
        way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """
        computeGradient(Group self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::computeGradient()

        Compute and store gradient.

        We can pose the nonlinear equation problem $F(x) = 0$ as an
        optimization problem as follows: \\[ \\min f(x) \\equiv
        \\frac{1}{2} \\|F(x)\\|_2^2. \\]

        In that case, the gradient (of $f$) is defined as \\[ g \\equiv
        J^T F. \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If either $F$ or $J$ has not
        been computed

        NOX::Abstract::Group::Failed - If the computation fails in any other
        way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_computeGradient(self, *args)


    def computeNewton(self, *args):
        """
        computeNewton(Group self, ParameterList params) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::computeNewton(Teuchos::ParameterList &params)

        Compute the Newton direction, using parameters for the linear solve.

        The Newton direction is the solution, s, of \\[ J s = -F. \\]

        The parameters are from the "Linear %Solver" sublist of the
        "Direction" sublist that is passed to solver during construction.

        The "Tolerance" parameter may be added/modified in the sublist of
        "Linear Solver" parameters that is passed into this function. The
        solution should be such that \\[ \\frac{\\| J s - (-F)
        \\|_2}{\\max \\{ 1, \\|F\\|_2\\} } < \\mbox{Tolerance}
        \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If either $F$ or $J$ has not
        been computed

        NOX::Abstract::Group::NotConverged - If the linear solve fails to
        satisfy the "Tolerance" specified in params

        NOX::Abstract::Group::Failed - If the computation fails in any other
        way

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyJacobian(const NOX::Abstract::Vector
        &input, NOX::Abstract::Vector &result) const

        Applies Jacobian to the given input vector and puts the answer in the
        result.

        Computes \\[ v = J u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector.

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If the Jacobian $J$ has not been
        computed

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyJacobianTranspose(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Applies Jacobian-Transpose to the given input vector and puts the
        answer in the result.

        Computes \\[ v = J^T u, \\] where $J$ is the Jacobian, $u$ is the
        input vector, and $v$ is the result vector.

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If $J$ has not been computed

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyJacobianInverse(Teuchos::ParameterList
        &params, const NOX::Abstract::Vector &input, NOX::Abstract::Vector
        &result) const

        Applies the inverse of the Jacobian matrix to the given input vector
        and puts the answer in result.

        Computes \\[ v = J^{-1} u, \\] where $J$ is the Jacobian, $u$ is
        the input vector, and $v$ is the result vector.

        The "Tolerance" parameter specifies that the solution should be such
        that \\[ \\frac{\\| J v - u \\|_2}{\\max \\{ 1,
        \\|u\\|_2\\} } < \\mbox{Tolerance} \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If $J$ has not been computed

        NOX::Abstract::Group::NotConverged - If the linear solve fails to
        satisfy the "Tolerance" specified in params

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise

        The parameter "Tolerance" may be added/modified in the list of
        parameters - this is the ideal solution tolerance for an iterative
        linear solve. 
        """
        return _Abstract.Group_applyJacobianInverse(self, *args)


    def applyRightPreconditioning(self, *args):
        """
        applyRightPreconditioning(Group self, bool useTranspose, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyRightPreconditioning(bool useTranspose,
        Teuchos::ParameterList &params, const NOX::Abstract::Vector &input,
        NOX::Abstract::Vector &result) const

        Apply right preconditiong to the given input vector.

        Let $M$ be a right preconditioner for the Jacobian $J$; in other
        words, $M$ is a matrix such that \\[ JM \\approx I. \\]

        Compute \\[ u = M^{-1} v, \\] where $u$ is the input vector and
        $v$ is the result vector.

        If useTranspose is true, then the transpose of the preconditioner is
        applied: \\[ u = {M^{-1}}^T v, \\] The transpose preconditioner is
        currently only required for Tensor methods.

        The "Tolerance" parameter specifies that the solution should be such
        that \\[ \\frac{\\| M v - u \\|_2}{\\max \\{ 1,
        \\|u\\|_2\\} } < \\mbox{Tolerance} \\]

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::NotConverged - If the linear solve fails to
        satisfy the "Tolerance" specified in params

        NOX::Abstract::Group::Failed - If the computation fails

        NOX::Abstract::Group::Ok - Otherwise

        The parameters are from the "Linear %Solver" sublist of the
        "Direction" sublist that is passed to solver during construction. 
        """
        return _Abstract.Group_applyRightPreconditioning(self, *args)


    def applyJacobianMultiVector(self, *args):
        """
        applyJacobianMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyJacobianMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        applyJacobian for multiple right-hand sides

        The default implementation here calls applyJacobian() for each right
        hand side serially but should be overloaded if a block method is
        available. 
        """
        return _Abstract.Group_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """
        applyJacobianTransposeMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyJacobianTransposeMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        applyJacobianTranspose for multiple right-hand sides

        The default implementation here calls applyJacobianTranspose() for
        each right hand side serially but should be overloaded if a block
        method is available. 
        """
        return _Abstract.Group_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """
        applyJacobianInverseMultiVector(Group self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyJacobianInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const

        applyJacobianInverse for multiple right-hand sides

        The default implementation here calls applyJacobianInverse() for each
        right hand side serially but should be overloaded if a block solver is
        available. 
        """
        return _Abstract.Group_applyJacobianInverseMultiVector(self, *args)


    def applyRightPreconditioningMultiVector(self, *args):
        """
        applyRightPreconditioningMultiVector(Group self, bool useTranspose, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::applyRightPreconditioningMultiVector(bool
        useTranspose, Teuchos::ParameterList &params, const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        applyRightPreconditioning for multiple right-hand sides

        The default implementation here calls applyRightPreconditioning() for
        each right hand side serially but should be overloaded if a block
        method is available. 
        """
        return _Abstract.Group_applyRightPreconditioningMultiVector(self, *args)


    def isF(self, *args):
        """
        isF(Group self) -> bool

        virtual bool
        NOX::Abstract::Group::isF() const =0

        Return true if F is valid. 
        """
        return _Abstract.Group_isF(self, *args)


    def isJacobian(self, *args):
        """
        isJacobian(Group self) -> bool

        bool
        NOX::Abstract::Group::isJacobian() const

        Return true if the Jacobian is valid.

        Default implementation in NOX::Abstract::Group returns false. 
        """
        return _Abstract.Group_isJacobian(self, *args)


    def isGradient(self, *args):
        """
        isGradient(Group self) -> bool

        bool
        NOX::Abstract::Group::isGradient() const

        Return true if the gradient is valid.

        Default implementation in NOX::Abstract::Group returns false. 
        """
        return _Abstract.Group_isGradient(self, *args)


    def isNewton(self, *args):
        """
        isNewton(Group self) -> bool

        bool
        NOX::Abstract::Group::isNewton() const

        Return true if the Newton direction is valid.

        Default implementation in NOX::Abstract::Group returns false. 
        """
        return _Abstract.Group_isNewton(self, *args)


    def getX(self, *args):
        """
        getX(Group self) -> Vector

        virtual const
        NOX::Abstract::Vector& NOX::Abstract::Group::getX() const =0

        Return solution vector. 
        """
        return _Abstract.Group_getX(self, *args)


    def getScaledX(self, *args):
        """
        getScaledX(Group self) -> Vector

        virtual
        const NOX::Abstract::Vector& NOX::Abstract::Group::getScaledX() const

        If right scaling vector exist, return a right scaled vector. Default
        to getX 
        """
        return _Abstract.Group_getScaledX(self, *args)


    def getF(self, *args):
        """
        getF(Group self) -> Vector

        virtual const
        NOX::Abstract::Vector& NOX::Abstract::Group::getF() const =0

        Return F(x) 
        """
        return _Abstract.Group_getF(self, *args)


    def getNormF(self, *args):
        """
        getNormF(Group self) -> double

        virtual double
        NOX::Abstract::Group::getNormF() const =0

        Return 2-norm of F(x).

        In other words, \\[ \\sqrt{\\sum_{i=1}^n F_i^2} \\] 
        """
        return _Abstract.Group_getNormF(self, *args)


    def getGradient(self, *args):
        """
        getGradient(Group self) -> Vector

        virtual
        const NOX::Abstract::Vector& NOX::Abstract::Group::getGradient() const
        =0

        Return gradient. 
        """
        return _Abstract.Group_getGradient(self, *args)


    def getNewton(self, *args):
        """
        getNewton(Group self) -> Vector

        virtual const
        NOX::Abstract::Vector& NOX::Abstract::Group::getNewton() const =0

        Return Newton direction. 
        """
        return _Abstract.Group_getNewton(self, *args)


    def getNormLastLinearSolveResidual(self, *args):
        """
        getNormLastLinearSolveResidual(Group self, double & residual) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        NOX::Abstract::Group::getNormLastLinearSolveResidual(double &residual)
        const

        Return the norm of the last linear solve residual as the result of
        either a call to computeNewton() or applyJacobianInverse().

        NOX::Abstract::Group::NotDefined - Returned by default implementation
        in NOX::Abstract::Group

        NOX::Abstract::Group::BadDependency - If no linear solve has been
        calculated

        NOX::Abstract::Group::Failed - Any other type of failure

        NOX::Abstract::Group::Ok - Otherwise 
        """
        return _Abstract.Group_getNormLastLinearSolveResidual(self, *args)


    def clone(self, *args):
        """
        clone(Group self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >

        virtual
        Teuchos::RCP<NOX::Abstract::Group>
        NOX::Abstract::Group::clone(NOX::CopyType type=NOX::DeepCopy) const =0

        Create a new Group of the same derived type as this one by cloning
        this one, and return a ref count pointer to the new group.

        If type is NOX::DeepCopy, then we need to create an exact replica of
        "this". Otherwise, if type is NOX::ShapeCopy, we need only replicate
        the shape of "this" (only the memory is allocated, the values are
        not copied into the vectors and Jacobian). Returns NULL if clone is
        not supported.

        Any shared data should have its ownership transfered to this group
        from the source for a NOX::DeepCopy. 
        """
        return _Abstract.Group_clone(self, *args)

Group_swigregister = _Abstract.Group_swigregister
Group_swigregister(Group)

# This file is compatible with both classic and new-style classes.


