# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA is the python interface to the Trilinos continuation
algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA is to provide a library of continuation
algorithms.  It includes the following sub-modules:

    * Abstract           - Abstract continuation problem base classes
    * Extended           - Classes that extend NOX.Abstract classes to
                           handle an arbitrary number of multi-vectors
                           and scalars
    * MultiContinuation  - Groups and vectors for multi-parameter continuation
    * TimeDependent      - Abstract group for time dependent problems with a
                           mass matrix
    * TurningPoint       - Groups and vectors for turning point bifurcations
    * Hopf               - Groups and vectors for Hopf bifurcations
    * Pitchfork          - Groups and vectors for pitchfork bifurcations
    * Homotopy           - Groups that allow for Homotopy to be applied
    * PhaseTransition    - Groups and vectors for phase transition bifurcations
    * Parameter          - Centralized library for setting/retrieving numerical
                           parameter values in application codes
    * BorderedSolver     - Strategies for solving bordered systems of equations
    * BorderedSystem     - Interface for groups that are bordered systems
    * Bifurcation        - Strategies for creating bifurcation objects
    * StatusTest         - Status checkers
    * StepSize           - Collection of step size control strategies
    * MultiPredictor     - Predictor direction strategies

and classes:

    * GlobalData      - Container class that holds ref-count pointers to
                        'global' objects, i.e., objects that nearly every LOCA
                        object will need access to
    * ErrorCheck      - Error checking algorithm for NOX/LOCA routines
    * Factory         - Provides a single location for instantiating various
                        strategies based on parameter list choices
    * DerivUtils      - Generic derivative computation class to compute various
                        derivatives via finite differencing
    * Stepper         - Implementation of LOCA.Abstract.Iterator for computing
                        points along a continuation curve
    * ParameterVector - LOCA's container for holding a set of parameters that
                        are used by the LOCA continuation routines

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x



# Fix ___init__ ambiguity
del ___init__
from . import ___init__

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_SwigPyIterator

    def value(self):
        return ___init__.SwigPyIterator_value(self)

    def incr(self, n=1):
        return ___init__.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return ___init__.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return ___init__.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return ___init__.SwigPyIterator_equal(self, x)

    def copy(self):
        return ___init__.SwigPyIterator_copy(self)

    def next(self):
        return ___init__.SwigPyIterator_next(self)

    def __next__(self):
        return ___init__.SwigPyIterator___next__(self)

    def previous(self):
        return ___init__.SwigPyIterator_previous(self)

    def advance(self, n):
        return ___init__.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return ___init__.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return ___init__.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return ___init__.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return ___init__.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return ___init__.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return ___init__.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = ___init__.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import PyTrilinos.NOX.StatusTest

import PyTrilinos.NOX

# LOCA sub-modules
__all__ = ['Extended',
           'MultiContinuation',
           'TimeDependent',
           'TurningPoint',
           'Hopf',
           'Pitchfork',
           'Homotopy',
           'PhaseTransition',
           'Abstract',
           'Parameter',
           'BorderedSolver',
           'BorderedSystem',
           'Bifurcation',
           'StatusTest',
           'StepSize',
           'MultiPredictor',
           'Eigensolver',
           'EigenvalueSort',
           'SaveEigenData',
           'AnasaziOperator'
           ]
from . import Extended
from . import MultiContinuation
from . import TimeDependent
from . import TurningPoint
from . import Hopf
from . import Pitchfork
from . import Homotopy
from . import PhaseTransition
from . import Parameter
from . import BorderedSolver
from . import BorderedSystem
from . import Bifurcation
from . import StatusTest
from . import StepSize
from . import MultiPredictor
from . import Eigensolver
from . import EigenvalueSort
from . import SaveEigenData
from . import AnasaziOperator

class GlobalData(_object):
    """


    Container class to hold "global" LOCA objects.

    GlobalData is a container class that holds ref-count pointers to
    "global" objects, i.e., objects that nearly every LOCA object will
    need access to. By putting them all in one container class, the
    container class can be stored in each LOCA object, and if a new global
    object is needed, it can be added here without modifying the rest of
    the code. This is an alternative to true global or static objects
    which are note safe in many contexts. In particular, this approach
    allows multiple LOCA "invocations" to be in memory at the same time.
    Note that all data members are declared public.

    C++ includes: LOCA_GlobalData.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GlobalData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GlobalData, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::GlobalData self, Teuchos::RCP< NOX::Utils > const & loca_utils, Teuchos::RCP< LOCA::ErrorCheck > const & loca_error_check, Teuchos::RCP< LOCA::Factory > const & loca_factory) -> GlobalData

        LOCA::GlobalData::GlobalData(const Teuchos::RCP< NOX::Utils >
        &loca_utils, const Teuchos::RCP< LOCA::ErrorCheck > &loca_error_check,
        const Teuchos::RCP< LOCA::Factory > &loca_factory)

        Constructor taking a ref-count pointer to each global object. 
        """
        this = ___init__.new_GlobalData(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_GlobalData
    __swig_setmethods__["locaUtils"] = ___init__.GlobalData_locaUtils_set
    __swig_getmethods__["locaUtils"] = ___init__.GlobalData_locaUtils_get
    if _newclass:
        locaUtils = _swig_property(___init__.GlobalData_locaUtils_get, ___init__.GlobalData_locaUtils_set)
    __swig_setmethods__["locaErrorCheck"] = ___init__.GlobalData_locaErrorCheck_set
    __swig_getmethods__["locaErrorCheck"] = ___init__.GlobalData_locaErrorCheck_get
    if _newclass:
        locaErrorCheck = _swig_property(___init__.GlobalData_locaErrorCheck_get, ___init__.GlobalData_locaErrorCheck_set)
    __swig_setmethods__["locaFactory"] = ___init__.GlobalData_locaFactory_set
    __swig_getmethods__["locaFactory"] = ___init__.GlobalData_locaFactory_get
    if _newclass:
        locaFactory = _swig_property(___init__.GlobalData_locaFactory_get, ___init__.GlobalData_locaFactory_set)
    __swig_setmethods__["parsedParams"] = ___init__.GlobalData_parsedParams_set
    __swig_getmethods__["parsedParams"] = ___init__.GlobalData_parsedParams_get
    if _newclass:
        parsedParams = _swig_property(___init__.GlobalData_parsedParams_get, ___init__.GlobalData_parsedParams_set)
GlobalData_swigregister = ___init__.GlobalData_swigregister
GlobalData_swigregister(GlobalData)


def createGlobalData(*args):
    """createGlobalData(Teuchos::RCP< Teuchos::ParameterList > const & paramList, Teuchos::RCP< LOCA::Abstract::Factory > const & userFactory) -> Teuchos::RCP< LOCA::GlobalData >"""
    return ___init__.createGlobalData(*args)

def destroyGlobalData(*args):
    """destroyGlobalData(Teuchos::RCP< LOCA::GlobalData > const & globalData)"""
    return ___init__.destroyGlobalData(*args)
class ErrorCheck(_object):
    """


    An Error checking algorithm for NOX/LOCA routines.

    This object will check the return types on objects and print a warning
    or throw an error if appropriate

    C++ includes: LOCA_ErrorCheck.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ErrorCheck, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ErrorCheck, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::ErrorCheck self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> ErrorCheck

        LOCA::ErrorCheck::ErrorCheck(const Teuchos::RCP< LOCA::GlobalData >
        &global_data)

        Constructor. 
        """
        this = ___init__.new_ErrorCheck(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_ErrorCheck
    ThrowError = ___init__.ErrorCheck_ThrowError
    PrintWarning = ___init__.ErrorCheck_PrintWarning

    def throwError(self, *args):
        """
        throwError(ErrorCheck self, std::string const & callingFunction, std::string const & message, std::string const & throwLabel)

        void
        LOCA::ErrorCheck::throwError(const std::string
        &callingFunction="<Unknown Method>", const std::string
        &message="", const std::string &throwLabel="LOCA Error")

        Generic call to throw that prints info to the screen. 
        """
        return ___init__.ErrorCheck_throwError(self, *args)


    def printWarning(self, *args):
        """
        printWarning(ErrorCheck self, std::string const & callingFunction, std::string const & message)

        void
        LOCA::ErrorCheck::printWarning(const std::string
        &callingFunction="<Unknown Method>", const std::string
        &message="")

        Generic printing algorithm for sending warnings to the screen. 
        """
        return ___init__.ErrorCheck_printWarning(self, *args)


    def checkReturnType(self, *args):
        """
        checkReturnType(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status, std::string const & callingFunction)
        checkReturnType(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status, LOCA::ErrorCheck::ActionType const & action, std::string const & callingFunction, std::string const & message)

        void
        LOCA::ErrorCheck::checkReturnType(const
        NOX::Abstract::Group::ReturnType &status, const ActionType &action,
        const std::string &callingFunction=std::string("<Unknown Method>"),
        const std::string &message=std::string(""))

        Checks the return type for the NOX::AbstractGroup and may throw an
        error or print a warning to the screen based on the ActionType
        requested. 
        """
        return ___init__.ErrorCheck_checkReturnType(self, *args)


    def combineReturnTypes(self, *args):
        """
        combineReturnTypes(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status1, NOX::Abstract::Group::ReturnType const & status2) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::ErrorCheck::combineReturnTypes(const
        NOX::Abstract::Group::ReturnType &status1, const
        NOX::Abstract::Group::ReturnType &status2)

        Combines two return types.

        If either return type is NOX::Abstract::Group::NotDefined, returns
        NotDefined. Otherwise if either is BadDependcy, returns BadDependency,
        if either is Failed, returns Failed, if either is NotConverged,
        returns NotConverged, and otherwise returns Ok. 
        """
        return ___init__.ErrorCheck_combineReturnTypes(self, *args)


    def combineAndCheckReturnTypes(self, *args):
        """
        combineAndCheckReturnTypes(ErrorCheck self, NOX::Abstract::Group::ReturnType const & status1, NOX::Abstract::Group::ReturnType const & status2, std::string const & callingFunction) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::ErrorCheck::combineAndCheckReturnTypes(const
        NOX::Abstract::Group::ReturnType &status1, const
        NOX::Abstract::Group::ReturnType &status2, const std::string
        &callingFunction=std::string("<Unknown Method>"))

        Combines two return types and checks the first.

        First combines status1 and status2 using combineReturnTypes() and
        checks the first using checkReturnType(). 
        """
        return ___init__.ErrorCheck_combineAndCheckReturnTypes(self, *args)

ErrorCheck_swigregister = ___init__.ErrorCheck_swigregister
ErrorCheck_swigregister(ErrorCheck)

class Factory(_object):
    """


    Factory class for creating strategies

    The Factory class provides a single location for instantiating various
    strategies based on parameter list choices. It provides a create()
    method for each type of strategy which instantiates strategy objects
    for that type. Each create method takes as arguments a ref-count
    pointer to a LOCA::Parameter::SublistParser and a parameter list. The
    parameter list determines which strategy to choose and also should
    provide any parameters the strategy requires. The sublist parser
    provides a parsed version of the top-level parameter list and allows
    strategies to easily obtain other sublists from the top-level list. A
    user-supplied factory may also be provided for instantiating user-
    defined strategies. If a user-defined factory is supplied, each create
    method will first attempt to instantiate the strategy using it, and
    then instantiate strategies itself if necessary.

    C++ includes: LOCA_Factory.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> Factory
        __init__(LOCA::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Abstract::Factory > const & userFactory) -> Factory

        LOCA::Factory::Factory(const Teuchos::RCP< LOCA::GlobalData >
        &global_data, const Teuchos::RCP< LOCA::Abstract::Factory >
        &userFactory)

        Constructor with user-supplied factory.

        Parameters:
        -----------

        global_data:  [in] Global data object. The constructor sets the
        factory member of the global data to this.

        userFactory:  [in] A user-supplied factory for instantiating user-
        defined strategies. 
        """
        this = ___init__.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Factory

    def createPredictorStrategy(self, *args):
        """
        createPredictorStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & predictorParams) -> Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy >

        Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy >
        LOCA::Factory::createPredictorStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &predictorParams)

        Create predictor strategy.

        Instantiates a predictor strategy based on the "Method" parameter of
        the "Predictor" sublist. See LOCA::MultiPredictor::Factory for a
        description of available strategies. 
        """
        return ___init__.Factory_createPredictorStrategy(self, *args)


    def createContinuationStrategy(self, *args):
        """
        createContinuationStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepperParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy > const & pred, std::vector< int,std::allocator< int > > const & paramIDs) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >
        LOCA::Factory::createContinuationStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &stepperParams, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &grp, const Teuchos::RCP<
        LOCA::MultiPredictor::AbstractStrategy > &pred, const std::vector< int
        > &paramIDs)

        Create continuation strategy.

        Instantiates a continuation strategy based on the "Continuation
        Method" parameter of the "Stepper" sublist. See
        LOCA::MultiContinuation::Factory for a description of available
        strategies. 
        """
        return ___init__.Factory_createContinuationStrategy(self, *args)


    def createBifurcationStrategy(self, *args):
        """
        createBifurcationStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & bifurcationParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        LOCA::Factory::createBifurcationStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &bifurcationParams, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &grp)

        Create bifurcation strategy.

        Instantiates a bifurcation strategy based on the "Method" parameter
        of the "Bifurcation" sublist. See LOCA::Bifurcation::Factory for a
        description of available strategies. 
        """
        return ___init__.Factory_createBifurcationStrategy(self, *args)


    def createStepSizeStrategy(self, *args):
        """
        createStepSizeStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepsizeParams) -> Teuchos::RCP< LOCA::StepSize::AbstractStrategy >

        Teuchos::RCP< LOCA::StepSize::AbstractStrategy >
        LOCA::Factory::createStepSizeStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &stepsizeParams)

        Create step size control strategy.

        Instantiates a step size control strategy based on the "Method"
        parameter of the "Step Size" sublist. See LOCA::StepSize::Factory
        for a description of available strategies. 
        """
        return ___init__.Factory_createStepSizeStrategy(self, *args)


    def createBorderedSolverStrategy(self, *args):
        """
        createBorderedSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::BorderedSolver::AbstractStrategy >

        Teuchos::RCP< LOCA::BorderedSolver::AbstractStrategy >
        LOCA::Factory::createBorderedSolverStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams)

        Create bordered system solver strategy.

        Instantiates an bordered system solver strategy based on the
        "Bordered Solver Method" parameter of the "Linear Solver" sublist.
        See LOCA::BorderedSolver::Factory for a description of available
        strategies. 
        """
        return ___init__.Factory_createBorderedSolverStrategy(self, *args)


    def createEigensolverStrategy(self, *args):
        """
        createEigensolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::Eigensolver::AbstractStrategy >

        Teuchos::RCP< LOCA::Eigensolver::AbstractStrategy >
        LOCA::Factory::createEigensolverStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams)

        Create eigensolver strategy.

        Instantiates an eigensolver strategy based on the "Method" parameter
        of the "Eigensolver" sublist. See LOCA::Eigensolver::Factory for a
        description of available strategies. 
        """
        return ___init__.Factory_createEigensolverStrategy(self, *args)


    def createEigenvalueSortStrategy(self, *args):
        """
        createEigenvalueSortStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::EigenvalueSort::AbstractStrategy >

        Teuchos::RCP< LOCA::EigenvalueSort::AbstractStrategy >
        LOCA::Factory::createEigenvalueSortStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams)

        Create eigenvalue sort strategy.

        Instantiates an eigenvalue sorting strategy based on the "Sorting
        Method" parameter of the "Eigensolver" sublist. See
        LOCA::EigenvalueSort::Factory for a description of available
        strategies. 
        """
        return ___init__.Factory_createEigenvalueSortStrategy(self, *args)


    def createSaveEigenDataStrategy(self, *args):
        """
        createSaveEigenDataStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy >

        Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy >
        LOCA::Factory::createSaveEigenDataStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams)

        Create strategy to save eigenvector/value data.

        Instantiates a strategy to save eigenvector/value data based on the
        "Save Eigen Data Method" parameter of the "Eigensolver" sublist.
        See LOCA::SaveEigenData::Factory for a description of available
        strategies. 
        """
        return ___init__.Factory_createSaveEigenDataStrategy(self, *args)


    def createAnasaziOperatorStrategy(self, *args):
        """
        createAnasaziOperatorStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< NOX::Abstract::Group > const & grp) -> Teuchos::RCP< LOCA::AnasaziOperator::AbstractStrategy >

        Teuchos::RCP< LOCA::AnasaziOperator::AbstractStrategy >
        LOCA::Factory::createAnasaziOperatorStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, const Teuchos::RCP<
        NOX::Abstract::Group > &grp)

        Create Anasazi operator strategy.

        Instantiates an Anasazi operator strategy based on the "Operator"
        parameter of the "Eigensolver" sublist. See
        LOCA::AnasaziOperator::Factory for a description of available
        strategies. 
        """
        return ___init__.Factory_createAnasaziOperatorStrategy(self, *args)


    def createMooreSpenceTurningPointSolverStrategy(self, *args):
        """
        createMooreSpenceTurningPointSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::TurningPoint::MooreSpence::SolverStrategy >

        Teuchos::RCP< LOCA::TurningPoint::MooreSpence::SolverStrategy >
        LOCA::Factory::createMooreSpenceTurningPointSolverStrategy(const
        Teuchos::RCP< LOCA::Parameter::SublistParser > &topParams, const
        Teuchos::RCP< Teuchos::ParameterList > &solverParams)

        Create Moore-Spence turning point solver strategy.

        Instantiates a solver strategy based on the "Solver Method"
        parameter of the "Bifurcation" sublist. See
        LOCA::TurningPoint::MooreSpence::SolverFactory for a description of
        available strategies. 
        """
        return ___init__.Factory_createMooreSpenceTurningPointSolverStrategy(self, *args)


    def createMooreSpencePitchforkSolverStrategy(self, *args):
        """
        createMooreSpencePitchforkSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::Pitchfork::MooreSpence::SolverStrategy >

        Teuchos::RCP< LOCA::Pitchfork::MooreSpence::SolverStrategy >
        LOCA::Factory::createMooreSpencePitchforkSolverStrategy(const
        Teuchos::RCP< LOCA::Parameter::SublistParser > &topParams, const
        Teuchos::RCP< Teuchos::ParameterList > &solverParams)

        Create Moore-Spence pitchfork solver strategy.

        Instantiates a solver strategy based on the "Solver Method"
        parameter of the "Bifurcation" sublist. See
        LOCA::Pitchfork::MooreSpence::SolverFactory for a description of
        available strategies. 
        """
        return ___init__.Factory_createMooreSpencePitchforkSolverStrategy(self, *args)


    def createMooreSpenceHopfSolverStrategy(self, *args):
        """
        createMooreSpenceHopfSolverStrategy(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::SolverStrategy >

        Teuchos::RCP<
        LOCA::Hopf::MooreSpence::SolverStrategy >
        LOCA::Factory::createMooreSpenceHopfSolverStrategy(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams)

        Create Moore-Spence Hopf solver strategy.

        Instantiates a solver strategy based on the "Solver Method"
        parameter of the "Bifurcation" sublist. See
        LOCA::Hopf::MooreSpence::SolverFactory for a description of available
        strategies. 
        """
        return ___init__.Factory_createMooreSpenceHopfSolverStrategy(self, *args)

Factory_swigregister = ___init__.Factory_swigregister
Factory_swigregister(Factory)

class DerivUtils(_object):
    """


    LOCA's generic derivative computation class to compute various
    derivatives via finite differencing.

    The DerivUtils class provides generic methods to compute the following
    derivatives: \\[ \\frac{\\partial F}{\\partial
    p},\\quad\\frac{\\partial Jn}{\\partial
    p},\\quad\\frac{\\partial Jn}{\\partial x}a \\] where $J =
    \\partial F/\\partial x$ and $n$, $a$ are vectors. These
    quantities are calculate by finite differencing.

    C++ includes: LOCA_DerivUtils.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DerivUtils, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DerivUtils, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::DerivUtils self, Teuchos::RCP< LOCA::GlobalData > const & global_data, double perturb=1.0e-6) -> DerivUtils
        __init__(LOCA::DerivUtils self, DerivUtils arg2) -> DerivUtils

        LOCA::DerivUtils::DerivUtils(const DerivUtils &)

        Copy constructor. 
        """
        this = ___init__.new_DerivUtils(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_DerivUtils

    def clone(self, *args):
        """
        clone(DerivUtils self, NOX::CopyType type) -> Teuchos::RCP< LOCA::DerivUtils >

        Teuchos::RCP<
        LOCA::DerivUtils > LOCA::DerivUtils::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Cloning function. Creates a copy of the DerivUtils object of the same
        type. 
        """
        return ___init__.DerivUtils_clone(self, *args)


    def computeDfDp(self, *args):
        """
        computeDfDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & param_ids, MultiVector result, bool isValidF) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDfDp(LOCA::MultiContinuation::AbstractGroup
        &grp, const std::vector< int > &param_ids, NOX::Abstract::MultiVector
        &result, bool isValidF) const

        Compute derivative of f with respect to parameter, identified by
        param_id. 
        """
        return ___init__.DerivUtils_computeDfDp(self, *args)


    def computeDJnDp(self, *args):
        """
        computeDJnDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & arg2, std::vector< int,std::allocator< int > > const & paramIDs, Vector nullVector, MultiVector result, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDJnDp(LOCA::MultiContinuation::AbstractGroup
        &, const std::vector< int > &paramIDs, const NOX::Abstract::Vector
        &nullVector, NOX::Abstract::MultiVector &result, bool isValid) const

        Compute derivative of Jn with respect to particular parameter
        param_id. 
        """
        return ___init__.DerivUtils_computeDJnDp(self, *args)


    def computeDJnDxa(self, *args):
        """
        computeDJnDxa(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, Vector nullVector, MultiVector aVector, MultiVector result) -> NOX::Abstract::Group::ReturnType
        computeDJnDxa(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, Vector nullVector, MultiVector aVector, Vector JnVector, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDJnDxa(LOCA::MultiContinuation::AbstractGroup
        &grp, const NOX::Abstract::Vector &nullVector, const
        NOX::Abstract::MultiVector &aVector, const NOX::Abstract::Vector
        &JnVector, NOX::Abstract::MultiVector &result) const

        Compute vector (Jn)_{x}a given multi-vector a, given JnVector. 
        """
        return ___init__.DerivUtils_computeDJnDxa(self, *args)


    def computeDwtJnDp(self, *args):
        """
        computeDwtJnDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, Vector nullVector, NOX::Abstract::MultiVector::DenseMatrix & result, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDwtJnDp(LOCA::MultiContinuation::AbstractGroup
        &grp, const std::vector< int > &paramIDs, const NOX::Abstract::Vector
        &w, const NOX::Abstract::Vector &nullVector,
        NOX::Abstract::MultiVector::DenseMatrix &result, bool isValid) const

        Compute derivative of w^TJn with respect to particular parameter
        param_id. 
        """
        return ___init__.DerivUtils_computeDwtJnDp(self, *args)


    def computeDwtJDp(self, *args):
        """
        computeDwtJDp(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, MultiVector result, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDwtJDp(LOCA::MultiContinuation::AbstractGroup
        &grp, const std::vector< int > &paramIDs, const NOX::Abstract::Vector
        &w, NOX::Abstract::MultiVector &result, bool isValid) const

        Compute derivative of w^TJ with respect to particular parameter
        param_id. 
        """
        return ___init__.DerivUtils_computeDwtJDp(self, *args)


    def computeDwtJnDx(self, *args):
        """
        computeDwtJnDx(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, Vector w, Vector nullVector, Vector result) -> NOX::Abstract::Group::ReturnType
        computeDwtJnDx(DerivUtils self, LOCA::MultiContinuation::AbstractGroup & grp, MultiVector w, Vector nullVector, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDwtJnDx(LOCA::MultiContinuation::AbstractGroup
        &grp, const NOX::Abstract::MultiVector &w, const NOX::Abstract::Vector
        &nullVector, NOX::Abstract::MultiVector &result) const

        Compute vector (w^TJn)_{x}. 
        """
        return ___init__.DerivUtils_computeDwtJnDx(self, *args)


    def computeDCeDp(self, *args):
        """
        computeDCeDp(DerivUtils self, LOCA::Hopf::MooreSpence::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector yVector, Vector zVector, double w, MultiVector result_real, MultiVector result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDCeDp(LOCA::Hopf::MooreSpence::AbstractGroup
        &grp, const std::vector< int > &paramIDs, const NOX::Abstract::Vector
        &yVector, const NOX::Abstract::Vector &zVector, double w,
        NOX::Abstract::MultiVector &result_real, NOX::Abstract::MultiVector
        &result_imag, bool isValid) const

        Compute derivative of (J+iwM)(y+iz) with respect to parameter,. 
        """
        return ___init__.DerivUtils_computeDCeDp(self, *args)


    def computeDCeDxa(self, *args):
        """
        computeDCeDxa(DerivUtils self, LOCA::Hopf::MooreSpence::AbstractGroup & grp, Vector yVector, Vector zVector, double w, MultiVector aVector, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        computeDCeDxa(DerivUtils self, LOCA::Hopf::MooreSpence::AbstractGroup & grp, Vector yVector, Vector zVector, double w, MultiVector aVector, Vector Ce_real, Vector Ce_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDCeDxa(LOCA::Hopf::MooreSpence::AbstractGroup
        &grp, const NOX::Abstract::Vector &yVector, const
        NOX::Abstract::Vector &zVector, double w, const
        NOX::Abstract::MultiVector &aVector, const NOX::Abstract::Vector
        &Ce_real, const NOX::Abstract::Vector &Ce_imag,
        NOX::Abstract::MultiVector &result_real, NOX::Abstract::MultiVector
        &result_imag) const

        Compute vector (J+iwM)(y+iz))_{x}a given a and (J+iwM)(y+iz) vector.

        """
        return ___init__.DerivUtils_computeDCeDxa(self, *args)


    def computeDwtCeDp(self, *args):
        """
        computeDwtCeDp(DerivUtils self, LOCA::Hopf::MinimallyAugmented::AbstractGroup & grp, std::vector< int,std::allocator< int > > const & paramIDs, Vector w1, Vector w2, Vector yVector, Vector zVector, double omega, NOX::Abstract::MultiVector::DenseMatrix & result_real, NOX::Abstract::MultiVector::DenseMatrix & result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDwtCeDp(LOCA::Hopf::MinimallyAugmented::AbstractGroup
        &grp, const std::vector< int > &paramIDs, const NOX::Abstract::Vector
        &w1, const NOX::Abstract::Vector &w2, const NOX::Abstract::Vector
        &yVector, const NOX::Abstract::Vector &zVector, double omega,
        NOX::Abstract::MultiVector::DenseMatrix &result_real,
        NOX::Abstract::MultiVector::DenseMatrix &result_imag, bool isValid)
        const

        Compute derivative of (w1+iw2)^T(J+iwM)(y+iz) w.r.t. parameter p. 
        """
        return ___init__.DerivUtils_computeDwtCeDp(self, *args)


    def computeDwtCeDx(self, *args):
        """
        computeDwtCeDx(DerivUtils self, LOCA::Hopf::MinimallyAugmented::AbstractGroup & grp, Vector w1, Vector w2, Vector yVector, Vector zVector, double omega, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::DerivUtils::computeDwtCeDx(LOCA::Hopf::MinimallyAugmented::AbstractGroup
        &grp, const NOX::Abstract::Vector &w1, const NOX::Abstract::Vector
        &w2, const NOX::Abstract::Vector &yVector, const NOX::Abstract::Vector
        &zVector, double omega, NOX::Abstract::Vector &result_real,
        NOX::Abstract::Vector &result_imag) const

        Compute vector (w1+iw2)^T(J+iwM)(y+iz))_{x}. 
        """
        return ___init__.DerivUtils_computeDwtCeDx(self, *args)

DerivUtils_swigregister = ___init__.DerivUtils_swigregister
DerivUtils_swigregister(DerivUtils)

import Abstract

import os.path
if 'NOX' in Abstract.__file__.split(os.path.sep):
  del Abstract
  from . import Abstract

class Stepper(Abstract.Iterator):
    """


    Implementation of LOCA::Abstract::Iterator for computing points along
    a continuation curve.

    The Stepper class implements the pure virtual methods of the
    LOCA::Abstract::Iterator for iteratively computing points along a
    continuation curve.

    C++ includes: LOCA_Stepper.H 
    """

    __swig_setmethods__ = {}
    for _s in [Abstract.Iterator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Stepper, name, value)
    __swig_getmethods__ = {}
    for _s in [Abstract.Iterator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Stepper, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< LOCA::StatusTest::Abstract > const & lt, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> Stepper
        __init__(LOCA::Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> Stepper

        LOCA::Stepper::Stepper(const Teuchos::RCP< LOCA::GlobalData >
        &global_data, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &initialGuess, const
        Teuchos::RCP< NOX::StatusTest::Generic > &nt, const Teuchos::RCP<
        Teuchos::ParameterList > &p)

        Obsolete constructor without LOCA::StatusTest.Deprecated Use the
        constructor with LOCA::StatusTest instead. 
        """
        if self.__class__ == Stepper:
            _self = None
        else:
            _self = self
        this = ___init__.new_Stepper(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_Stepper

    def reset(self, *args):
        """
        reset(Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< LOCA::StatusTest::Abstract > const & lt, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> bool
        reset(Stepper self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & nt, Teuchos::RCP< Teuchos::ParameterList > const & p) -> bool

        bool
        LOCA::Stepper::reset(const Teuchos::RCP< LOCA::GlobalData >
        &global_data, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &initialGuess, const
        Teuchos::RCP< NOX::StatusTest::Generic > &nt, const Teuchos::RCP<
        Teuchos::ParameterList > &p)

        Reset the Stepper to start a new continuation run. Obsolete version
        without LOCA::StatusTest.Deprecated Use reset() with LOCA::StatusTest
        instead. 
        """
        return ___init__.Stepper_reset(self, *args)


    def eigensolverReset(self, *args):
        """
        eigensolverReset(Stepper self, Teuchos::RCP< Teuchos::ParameterList > & newEigensolverList) -> bool

        bool
        LOCA::Stepper::eigensolverReset(Teuchos::RCP< Teuchos::ParameterList >
        &newEigensolverList)

        Replaces the eigensolver parameter list. 
        """
        return ___init__.Stepper_eigensolverReset(self, *args)


    def getSolutionGroup(self, *args):
        """
        getSolutionGroup(Stepper self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >

        Teuchos::RCP<
        const LOCA::MultiContinuation::AbstractGroup >
        LOCA::Stepper::getSolutionGroup() const

        Return the current solution group. 
        """
        return ___init__.Stepper_getSolutionGroup(self, *args)


    def getBifurcationGroup(self, *args):
        """
        getBifurcationGroup(Stepper self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >

        Teuchos::RCP< const LOCA::MultiContinuation::AbstractGroup >
        LOCA::Stepper::getBifurcationGroup() const

        Return the current bifurcation group.

        If the current bifurcation method is "None", then the returned group
        is the same as getSolutionGroup(), otherwise this method returns the
        current bifurcation group (e.g., a turning point group). 
        """
        return ___init__.Stepper_getBifurcationGroup(self, *args)


    def getList(self, *args):
        """
        getList(Stepper self) -> Teuchos::RCP< Teuchos::ParameterList const >

        Teuchos::RCP< const
        Teuchos::ParameterList > LOCA::Stepper::getList() const

        Return the output parameters from the stepper algorithm. 
        """
        return ___init__.Stepper_getList(self, *args)


    def getSolver(self, *args):
        """
        getSolver(Stepper self) -> Teuchos::RCP< NOX::Solver::Generic const >

        Teuchos::RCP< const
        NOX::Solver::Generic > LOCA::Stepper::getSolver() const

        Return the current nonlinear solver pointer.

        Will throw an error if the solver does not exist yet. 
        """
        return ___init__.Stepper_getSolver(self, *args)


    def getContinuationParameter(self, *args):
        """
        getContinuationParameter(Stepper self) -> double

        double LOCA::Stepper::getContinuationParameter() const

        Return the current continuation parameter from the underlying
        LOCA::MultiContinuation::AbstractStrategy. 
        """
        return ___init__.Stepper_getContinuationParameter(self, *args)


    def start(self, *args):
        """start(Stepper self) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_start(self, *args)


    def finish(self, *args):
        """finish(Stepper self, LOCA::Abstract::Iterator::IteratorStatus iteratorStatus) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_finish(self, *args)


    def preprocess(self, *args):
        """preprocess(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_preprocess(self, *args)


    def compute(self, *args):
        """compute(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_compute(self, *args)


    def postprocess(self, *args):
        """postprocess(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_postprocess(self, *args)


    def stop(self, *args):
        """stop(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_stop(self, *args)


    def printInitializationInfo(self, *args):
        """printInitializationInfo(Stepper self)"""
        return ___init__.Stepper_printInitializationInfo(self, *args)


    def printStartStep(self, *args):
        """printStartStep(Stepper self)"""
        return ___init__.Stepper_printStartStep(self, *args)


    def printEndStep(self, *args):
        """printEndStep(Stepper self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return ___init__.Stepper_printEndStep(self, *args)


    def printEndInfo(self, *args):
        """printEndInfo(Stepper self)"""
        return ___init__.Stepper_printEndInfo(self, *args)


    def withinThreshold(self, *args):
        """withinThreshold(Stepper self) -> bool"""
        return ___init__.Stepper_withinThreshold(self, *args)

    def __disown__(self):
        self.this.disown()
        ___init__.disown_Stepper(self)
        return weakref_proxy(self)

    def iterate(self, *args):
        """iterate(Stepper self) -> LOCA::Abstract::Iterator::IteratorStatus"""
        return ___init__.Stepper_iterate(self, *args)


    def setLastIteration(self, *args):
        """setLastIteration(Stepper self)"""
        return ___init__.Stepper_setLastIteration(self, *args)


    def isLastIteration(self, *args):
        """isLastIteration(Stepper self) -> bool"""
        return ___init__.Stepper_isLastIteration(self, *args)


    def computeStepStatus(self, *args):
        """computeStepStatus(Stepper self, LOCA::Abstract::Iterator::StepStatus preStatus, LOCA::Abstract::Iterator::StepStatus compStatus, LOCA::Abstract::Iterator::StepStatus postStatus) -> LOCA::Abstract::Iterator::StepStatus"""
        return ___init__.Stepper_computeStepStatus(self, *args)

Stepper_swigregister = ___init__.Stepper_swigregister
Stepper_swigregister(Stepper)

class ParameterVector(_object):
    """


    LOCA's container for holding a set of parameters that are used by the
    LOCA continuation routines.

    Roger Pawlowski (SNL 9233)

    C++ includes: LOCA_Parameter_Vector.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParameterVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ParameterVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::ParameterVector self) -> ParameterVector
        __init__(LOCA::ParameterVector self, ParameterVector source) -> ParameterVector

        LOCA::ParameterVector::ParameterVector(const ParameterVector &source)

        Copy constructor. 
        """
        this = ___init__.new_ParameterVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def clone(self, *args):
        """
        clone(ParameterVector self) -> ParameterVector

        LOCA::ParameterVector * LOCA::ParameterVector::clone() const

        Clone. 
        """
        return ___init__.ParameterVector_clone(self, *args)

    __swig_destroy__ = ___init__.delete_ParameterVector

    def addParameter(self, *args):
        """
        addParameter(ParameterVector self, std::string label, double value=0.0) -> int

        int
        LOCA::ParameterVector::addParameter(std::string label, double
        value=0.0)

        Adds a parameter to the list. Returns the index value assigned to the
        parameter. 
        """
        return ___init__.ParameterVector_addParameter(self, *args)


    def init(self, *args):
        """
        init(ParameterVector self, double value) -> bool

        bool
        LOCA::ParameterVector::init(double value)

        Initialize the vector. Returns true if successful. 
        """
        return ___init__.ParameterVector_init(self, *args)


    def scale(self, *args):
        """
        scale(ParameterVector self, double value) -> bool
        scale(ParameterVector self, ParameterVector p) -> bool

        bool
        LOCA::ParameterVector::scale(const ParameterVector &p)

        Scales the vactor with another vector (element-wise multiply). Returns
        true if successful. 
        """
        return ___init__.ParameterVector_scale(self, *args)


    def update(self, *args):
        """
        update(ParameterVector self, double alpha, ParameterVector alphaVector, double b) -> bool

        bool
        LOCA::ParameterVector::update(double alpha, const ParameterVector
        &alphaVector, double b)

        Updates the parameter vector: this = alpha * alphaVector + b * this.
        Returns true if successful. 
        """
        return ___init__.ParameterVector_update(self, *args)


    def setValue(self, *args):
        """
        setValue(ParameterVector self, unsigned int i, double value)
        setValue(ParameterVector self, std::string label, double value)

        void
        LOCA::ParameterVector::setValue(std::string label, double value)

        Set the value of the parameter with the corresponding label. Will
        throw an error if "label" is not valid. 
        """
        return ___init__.ParameterVector_setValue(self, *args)


    def getValue(self, *args):
        """
        getValue(ParameterVector self, unsigned int i) -> double
        getValue(ParameterVector self, std::string label) -> double

        double
        LOCA::ParameterVector::getValue(std::string label) const

        Returns the value of the parameter with the corresponding label. Will
        throw an error if "label" is not valid. 
        """
        return ___init__.ParameterVector_getValue(self, *args)


    def getIndex(self, *args):
        """
        getIndex(ParameterVector self, std::string label) -> int

        int
        LOCA::ParameterVector::getIndex(std::string label) const

        Returns the index of the parameter with the corresponding label.
        Returns a -1 if "label" is not found. 
        """
        return ___init__.ParameterVector_getIndex(self, *args)


    def getDoubleArrayPointer(self, *args):
        """
        getDoubleArrayPointer(ParameterVector self) -> double *

        double * LOCA::ParameterVector::getDoubleArrayPointer()

        Returns a pointer to a C-style array of the parameter values. 
        """
        return ___init__.ParameterVector_getDoubleArrayPointer(self, *args)


    def isParameter(self, *args):
        """
        isParameter(ParameterVector self, std::string label) -> bool

        bool
        LOCA::ParameterVector::isParameter(std::string label) const

        Returns true if the parameter std::string "label" corresponds to a
        parameter label in the object. 
        """
        return ___init__.ParameterVector_isParameter(self, *args)


    def getLabel(self, *args):
        """
        getLabel(ParameterVector self, unsigned int i) -> std::string

        std::string
        LOCA::ParameterVector::getLabel(unsigned int i) const

        Returns the label of the parameter with index i. 
        """
        return ___init__.ParameterVector_getLabel(self, *args)


    def length(self, *args):
        """
        length(ParameterVector self) -> int

        int
        LOCA::ParameterVector::length() const

        Returns the length of parameter vector. 
        """
        return ___init__.ParameterVector_length(self, *args)


    def getValuesVector(self, *args):
        """
        getValuesVector(ParameterVector self) -> std::vector< double,std::allocator< double > > const &

        const
        std::vector< double > & LOCA::ParameterVector::getValuesVector() const

        Accessor to get the underlying stl vector with all parameter values.

        """
        return ___init__.ParameterVector_getValuesVector(self, *args)


    def getNamesVector(self, *args):
        """
        getNamesVector(ParameterVector self) -> std::vector< std::string,std::allocator< std::string > > const &

        const
        std::vector< std::string > & LOCA::ParameterVector::getNamesVector()
        const

        Accessor to get the underlying stl vector with all parameter names. 
        """
        return ___init__.ParameterVector_getNamesVector(self, *args)

ParameterVector_swigregister = ___init__.ParameterVector_swigregister
ParameterVector_swigregister(ParameterVector)


def __lshift__(*args):
    """__lshift__(std::ostream & stream, ParameterVector p) -> std::ostream &"""
    return ___init__.__lshift__(*args)


# Epetra namespace
__all__.append("Epetra")
from . import Epetra

# This file is compatible with both classic and new-style classes.


