# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.TurningPoint.MinimallyAugmented is the python
interface to namespace TurningPoint::MinimallyAugmented of the
Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.TurningPoint.MinimallyAugmented is to provide
groups and vectors for locating turning point bifurcations using the
minimally augmented turning point formulation.  The python version of
LOCA.TurningPoint.MinimallyAugmented supports the following classes:

    * AbstractGroup          - Interface to underlying groups for turning point
                               calculations using the minimally augmented
                               formulation
    * FiniteDifferenceGroup  - Concrete class that provides concrete
                               implementations of the derivative computation
                               methods of the LOCA.TurningPoint.Minimally-
                               Augmented.AbstractGroup using first-order finite
                               differencing

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MinimallyAugmented')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MinimallyAugmented')
    _MinimallyAugmented = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MinimallyAugmented', [dirname(__file__)])
        except ImportError:
            import _MinimallyAugmented
            return _MinimallyAugmented
        try:
            _mod = imp.load_module('_MinimallyAugmented', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MinimallyAugmented = swig_import_helper()
    del swig_import_helper
else:
    import _MinimallyAugmented
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
thisDir = op.dirname(op.abspath(__file__))
if not thisDir in sys.path: sys.path.append(thisDir)
del sys, op

import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import MultiContinuation
import MooreSpence
class AbstractGroup(MooreSpence.AbstractGroup):
    """


    Interface to underlying groups for turning point calculations using
    the minimally augmented formulation.

    This abstract class provides the required interface for underlying
    groups to locate turning points using the minimally augmented turning
    point formulation (see
    LOCA::TurningPoint::MinimallyAugmented::ExtendedGroup for a
    description of the governing equations).

    This class is derived from the
    LOCA::TurningPoint::MooreSpence::AbstractGroup and declares several
    pure virtual methods compute various derivatives of $w^TJn$ for a
    given $w$ and $n$. Default implementations for the derivatives using
    finite differencing are implemented in the
    LOCA::TurningPoint::MinimallyAugmented::FiniteDifferenceGroup.

    C++ includes: LOCA_TurningPoint_MinimallyAugmented_AbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [MooreSpence.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [MooreSpence.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MinimallyAugmented.delete_AbstractGroup

    def computeDwtJnDp(self, *args):
        """
        computeDwtJnDp(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, Vector nullVector, NOX::Abstract::MultiVector::DenseMatrix & result, bool isValid) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::TurningPoint::MinimallyAugmented::AbstractGroup::computeDwtJnDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &w, const
        NOX::Abstract::Vector &nullVector,
        NOX::Abstract::MultiVector::DenseMatrix &result, bool isValid)=0

        Computes the derivative $\\partial w^TJn/\\partial p$. 
        """
        return _MinimallyAugmented.AbstractGroup_computeDwtJnDp(self, *args)


    def computeDwtJDp(self, *args):
        """
        computeDwtJDp(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, MultiVector result, bool isValid) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::TurningPoint::MinimallyAugmented::AbstractGroup::computeDwtJDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &w,
        NOX::Abstract::MultiVector &result, bool isValid)=0

        Computes the derivative $\\partial w^TJ/\\partial p$. 
        """
        return _MinimallyAugmented.AbstractGroup_computeDwtJDp(self, *args)


    def computeDwtJnDx(self, *args):
        """
        computeDwtJnDx(AbstractGroup self, Vector w, Vector nullVector, Vector result) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::TurningPoint::MinimallyAugmented::AbstractGroup::computeDwtJnDx(const
        NOX::Abstract::Vector &w, const NOX::Abstract::Vector &nullVector,
        NOX::Abstract::Vector &result)=0

        Computes the derivative $\\frac{\\partial w^TJn}{\\partial x}$.

        """
        return _MinimallyAugmented.AbstractGroup_computeDwtJnDx(self, *args)

AbstractGroup_swigregister = _MinimallyAugmented.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class FiniteDifferenceGroup(AbstractGroup, MooreSpence.FiniteDifferenceGroup):
    """


    Concrete class that provides concrete implementations of the
    derivative computation methods of the
    LOCA::TurningPoint::MinimallyAugmented::AbstractGroup using first-
    order finite differencing.

    The finite-differencing calculations are actually implemented by the
    LOCA::DerivUtils class, and a custom DerivUtils object can be passed
    through the constructor of this class. However, in the future the
    calculations encapsulated in the DerivUtils class may be incorporated
    directly into this class and other finite- differencing child classes.

    C++ includes:
    LOCA_TurningPoint_MinimallyAugmented_FiniteDifferenceGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [AbstractGroup, MooreSpence.FiniteDifferenceGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup, MooreSpence.FiniteDifferenceGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MinimallyAugmented.delete_FiniteDifferenceGroup

    def computeDwtJnDp(self, *args):
        """
        computeDwtJnDp(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, Vector nullVector, NOX::Abstract::MultiVector::DenseMatrix & result, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::TurningPoint::MinimallyAugmented::FiniteDifferenceGroup::computeDwtJnDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &w, const
        NOX::Abstract::Vector &nullVector,
        NOX::Abstract::MultiVector::DenseMatrix &result, bool isValid)

        Computes the derivative $\\partial w^TJn/\\partial p$.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDwtJnDp() method of the passed
        LOCA::DerivUtils object. 
        """
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtJnDp(self, *args)


    def computeDwtJDp(self, *args):
        """
        computeDwtJDp(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w, MultiVector result, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::TurningPoint::MinimallyAugmented::FiniteDifferenceGroup::computeDwtJDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &w,
        NOX::Abstract::MultiVector &result, bool isValid)

        Computes the derivative $\\partial w^TJ/\\partial p$.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDwtJDp() method of the passed
        LOCA::DerivUtils object. 
        """
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtJDp(self, *args)


    def computeDwtJnDx(self, *args):
        """
        computeDwtJnDx(FiniteDifferenceGroup self, Vector w, Vector nullVector, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::TurningPoint::MinimallyAugmented::FiniteDifferenceGroup::computeDwtJnDx(const
        NOX::Abstract::Vector &w, const NOX::Abstract::Vector &nullVector,
        NOX::Abstract::Vector &result)

        Computes the derivative $\\frac{\\partial w^TJn}{\\partial x}$.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDwtJnDx() method of the passed
        LOCA::DerivUtils object. 
        """
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtJnDx(self, *args)

FiniteDifferenceGroup_swigregister = _MinimallyAugmented.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

# This file is compatible with both classic and new-style classes.


