# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.SaveEigenData is the python interface to namespace
SaveEigenData of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.SaveEigenData is to provide the capability to save
eigenvectors and eigenvalues.  The python version of
LOCA.SaveEigenData supports the following classes:

    * Factory          - Factory for creating strategy objects to save
                         eigenvectors/values
    * AbstractStrategy - Abstract class for saving eigenvectors/values
    * DefaultStrategy  - Default class for saving eigenvectors/values

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_SaveEigenData')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_SaveEigenData')
    _SaveEigenData = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_SaveEigenData', [dirname(__file__)])
        except ImportError:
            import _SaveEigenData
            return _SaveEigenData
        try:
            _mod = imp.load_module('_SaveEigenData', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _SaveEigenData = swig_import_helper()
    del swig_import_helper
else:
    import _SaveEigenData
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
class Factory(_object):
    """


    Factory for creating strategy objects to save eigenvectors/values.

    The parameters passed to the create() through the eigenParams argument
    method should specify the "Method" as described below, as well as
    any additional parameters for the particular strategy. "Save Eigen
    Data Method" - Name of the method. Valid choices are "Default" (
    LOCA::SaveEigenData::DefaultStrategy) [Default]

    "User-Defined" - User defined strategy

    User-defined strategies are defined by supplying the parameter "User-
    Defined Save Eigen Data Name" which is the std::string name of the
    strategy, and then a parameter with this name that is of the type
    Teuchos::RCP<LOCA::SaveEigenData::AbstractStrategy>. This allows the
    user to supply a user-defined strategy without providing a factory to
    instantiate it. By supplying the name of the parameter storing the
    strategy, the user can provide multiple strategies in the parameter
    list and select among them by setting "User-Defined Save Eigen Data
    Name" to be the name of the strategy.

    C++ includes: LOCA_SaveEigenData_Factory.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::SaveEigenData::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> Factory

        LOCA::SaveEigenData::Factory::Factory(const Teuchos::RCP<
        LOCA::GlobalData > &global_data)

        Constructor. 
        """
        this = _SaveEigenData.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _SaveEigenData.delete_Factory

    def create(self, *args):
        """
        create(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy >

        Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy >
        LOCA::SaveEigenData::Factory::create(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams)

        Create strategy to save eigenvectors/values.

        Parameters:
        -----------

        topParams:  [in] Parsed top-level parameter list.

        eigenParams:  [in] Eigensolver parameters as described above 
        """
        return _SaveEigenData.Factory_create(self, *args)


    def strategyName(self, *args):
        """
        strategyName(Factory self, ParameterList eigenParams) -> std::string const &

        const std::string &
        LOCA::SaveEigenData::Factory::strategyName(Teuchos::ParameterList
        &eigenParams) const

        Return strategy name given by eigenParams. 
        """
        return _SaveEigenData.Factory_strategyName(self, *args)

Factory_swigregister = _SaveEigenData.Factory_swigregister
Factory_swigregister(Factory)

class AbstractStrategy(_object):
    """


    Abstract interface class strategies to save eigenvector/value data.

    AbstractStrategy defines an abstract interface for saving eigenvectors
    and eigenvalues that are computed at each continuation step. This is
    important because this data is often useful for restarting
    continuations near bifurcation points and gives the user flexibility
    in how this data is stored.

    The interface currently defines one pure virtual method, save(), to
    save any eigenvectors or values as specified by the user. Derived
    classes should implement this method for a particular strategy to save
    this data, which is usually highly application code dependent.
    Constructors for derived classes should be of the form:

    where global_data is the LOCA global data object, topParams is the
    parsed top-level parameter list, and eigenParams is a parameter list
    of eigensolver parameters. This list should also specify which and how
    many eigenvectors/values to save as defined by the strategy.

    This class and its children follow the Strategy pattern as defined in
    Erich Gamma, et al. "Design Patterns:  Elements of Reusable   Object-
    Oriented Software." Addison Wesley, Boston, MA, 1995.

    C++ includes: LOCA_SaveEigenData_AbstractStrategy.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractStrategy, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractStrategy, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _SaveEigenData.delete_AbstractStrategy

    def save(self, *args):
        """
        save(AbstractStrategy self, Teuchos::RCP< std::vector< double,std::allocator< double > > > & evals_r, Teuchos::RCP< std::vector< double,std::allocator< double > > > & evals_i, Teuchos::RCP< NOX::Abstract::MultiVector > & evecs_r, Teuchos::RCP< NOX::Abstract::MultiVector > & evecs_i) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::SaveEigenData::AbstractStrategy::save(Teuchos::RCP< std::vector<
        double > > &evals_r, Teuchos::RCP< std::vector< double > > &evals_i,
        Teuchos::RCP< NOX::Abstract::MultiVector > &evecs_r, Teuchos::RCP<
        NOX::Abstract::MultiVector > &evecs_i)=0

        Save eigenvalues/eigenvectors.

        Parameters:
        -----------

        evals_r:  [out] Real eigenvalues

        evals_i:  [out] Imaginary eigenvalues

        evecs_r:  [out] Real eigenvectors

        evecs_i:  [out] Imaginary eigenvectors

        ReturnType code indicating success or failure 
        """
        return _SaveEigenData.AbstractStrategy_save(self, *args)

AbstractStrategy_swigregister = _SaveEigenData.AbstractStrategy_swigregister
AbstractStrategy_swigregister(AbstractStrategy)

class DefaultStrategy(AbstractStrategy):
    """


    Default strategy for saving eigenvector/value data.

    This class implements a default strategy for saving eigenvectors and
    eigenvalues that does nothing and exists so the LOCA::Stepper always
    has an object to pass eigen data to.

    C++ includes: LOCA_SaveEigenData_DefaultStrategy.H 
    """

    __swig_setmethods__ = {}
    for _s in [AbstractStrategy]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DefaultStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractStrategy]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DefaultStrategy, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::SaveEigenData::DefaultStrategy self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams) -> DefaultStrategy

        LOCA::SaveEigenData::DefaultStrategy::DefaultStrategy(const
        Teuchos::RCP< LOCA::GlobalData > &global_data, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams)

        Constructor. 
        """
        this = _SaveEigenData.new_DefaultStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _SaveEigenData.delete_DefaultStrategy

    def save(self, *args):
        """
        save(DefaultStrategy self, Teuchos::RCP< std::vector< double,std::allocator< double > > > & evals_r, Teuchos::RCP< std::vector< double,std::allocator< double > > > & evals_i, Teuchos::RCP< NOX::Abstract::MultiVector > & evecs_r, Teuchos::RCP< NOX::Abstract::MultiVector > & evecs_i) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::SaveEigenData::DefaultStrategy::save(Teuchos::RCP< std::vector<
        double > > &evals_r, Teuchos::RCP< std::vector< double > > &evals_i,
        Teuchos::RCP< NOX::Abstract::MultiVector > &evecs_r, Teuchos::RCP<
        NOX::Abstract::MultiVector > &evecs_i)

        Save eigenvalues/eigenvectors.

        The implementation here does nothing and always returns
        NOX::Abstract::Group::Ok. 
        """
        return _SaveEigenData.DefaultStrategy_save(self, *args)

DefaultStrategy_swigregister = _SaveEigenData.DefaultStrategy_swigregister
DefaultStrategy_swigregister(DefaultStrategy)

# This file is compatible with both classic and new-style classes.


