# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.MultiContinuation is the python interface to namespace
MultiContinuation of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.MultiContinuation is to provide groups and vectors
for multi-parameter continuation.  The python version of
LOCA.MultiContinuation supports the following classes:

    * AbstractGroup            - LOCA abstract interface for continuation,
                                 derived from the NOX.Abstract.Group.  This
                                 abstract class provides the interface
                                 necessary to perform continuation, i.e.,
                                 compute families of solutions to F(x,p) = 0
    * FiniteDifferenceGroup    - Concrete class that provides a concrete
                                 implementation of the computeDfDp() method of
                                 the LOCA.Continuation.AbstractGroup using
                                 first-order finite differencing
    * ConstraintInterface      - Abstract interface for the constraint portion
                                 of a constrained nonlinear system
    * ConstraintInterfaceMVDX  - Abstract interface for the constraint portion
                                 of a constrained nonlinear system for
                                 constraints that support computing a solution
                                 component derivative as a multi-vector
    * ExtendedMultiVector      - MultiVector class to hold solution vectors,
                                 Newton vectors, etc. for continuation equations
    * ExtendedVector           - Vector class to hold solution vectors, Newton
                                 vectors, etc. for continuation equations
    * Factory                  - Factory for creating continuation strategy
                                 objects

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MultiContinuation')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MultiContinuation')
    _MultiContinuation = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MultiContinuation', [dirname(__file__)])
        except ImportError:
            import _MultiContinuation
            return _MultiContinuation
        try:
            _mod = imp.load_module('_MultiContinuation', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MultiContinuation = swig_import_helper()
    del swig_import_helper
else:
    import _MultiContinuation
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
thisDir = op.dirname(op.abspath(__file__))
if not thisDir in sys.path: sys.path.append(thisDir)
del sys, op

import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import Extended
class AbstractGroup(PyTrilinos.NOX.Abstract.Group):
    """


    LOCA abstract interface for continuation, derived from the
    NOX::Abstract::Group. This abstract class provides the interface
    necessary to perform continuation, i.e., compute families of solutions
    to $ F(x,p) = 0 $.

    Concrete implemenations of this interface must provide implementations
    of all of the methods in the NOX::Abstract::Group interface as well as
    the additional interface defined here.

    C++ includes: LOCA_MultiContinuation_AbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MultiContinuation.delete_AbstractGroup

    def copy(self, *args):
        """
        copy(AbstractGroup self, Group source)

        virtual void LOCA::MultiContinuation::AbstractGroup::copy(const
        NOX::Abstract::Group &source)=0

        Copy the group (replaces operator = ) 
        """
        return _MultiContinuation.AbstractGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """
        setParamsMulti(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        virtual void
        LOCA::MultiContinuation::AbstractGroup::setParamsMulti(const
        std::vector< int > &paramIDs, const
        NOX::Abstract::MultiVector::DenseMatrix &vals)=0

        Set parameters indexed by (integer) paramIDs. 
        """
        return _MultiContinuation.AbstractGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """
        setParams(AbstractGroup self, LOCA::ParameterVector const & p)

        virtual void
        LOCA::MultiContinuation::AbstractGroup::setParams(const
        LOCA::ParameterVector &p)=0

        Set the parameter vector in the group to p (pVector = p). 
        """
        return _MultiContinuation.AbstractGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(AbstractGroup self, int paramID, double val)
        setParam(AbstractGroup self, std::string paramID, double val)

        virtual void
        LOCA::MultiContinuation::AbstractGroup::setParam(std::string paramID,
        double val)=0

        Set parameter indexed by (std::string) paramID. 
        """
        return _MultiContinuation.AbstractGroup_setParam(self, *args)


    def getParams(self, *args):
        """
        getParams(AbstractGroup self) -> LOCA::ParameterVector const &

        virtual const
        LOCA::ParameterVector&
        LOCA::MultiContinuation::AbstractGroup::getParams() const =0

        Return a const reference to the ParameterVector owned by the group. 
        """
        return _MultiContinuation.AbstractGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(AbstractGroup self, int paramID) -> double
        getParam(AbstractGroup self, std::string paramID) -> double

        virtual double
        LOCA::MultiContinuation::AbstractGroup::getParam(std::string paramID)
        const =0

        Return copy of parameter indexed by (std::string) paramID. 
        """
        return _MultiContinuation.AbstractGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """
        computeDfDpMulti(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::AbstractGroup::computeDfDpMulti(const
        std::vector< int > &paramIDs, NOX::Abstract::MultiVector &dfdp, bool
        isValidF)=0

        Compute $\\partial F/\\partial p$ for each parameter $p$ indexed
        by paramIDs. The first column of dfdp holds F, which is valid if
        isValidF is true. Otherwise F must be computed. 
        """
        return _MultiContinuation.AbstractGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(AbstractGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::MultiContinuation::AbstractGroup::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. The default implementation to empty. 
        """
        return _MultiContinuation.AbstractGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(AbstractGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::MultiContinuation::AbstractGroup::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. The
        default implementation to empty. 
        """
        return _MultiContinuation.AbstractGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """
        projectToDraw(AbstractGroup self, Vector x, double * px)

        void
        LOCA::MultiContinuation::AbstractGroup::projectToDraw(const
        NOX::Abstract::Vector &x, double *px) const

        Projects solution to a few scalars for multiparameter continuation.

        This method is called every time a solution is saved by the
        multiparameter continuation code MF for later visualization and should
        project the solution vector down to a few scalars. The array px will
        be preallocated to the proper length given by
        projectToDrawDimension().

        The default implementation is the max norm of the vector. 
        """
        return _MultiContinuation.AbstractGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """
        projectToDrawDimension(AbstractGroup self) -> int

        int
        LOCA::MultiContinuation::AbstractGroup::projectToDrawDimension() const

        Returns the dimension of the project to draw array.

        The default implementation is to return 1 since the default projection
        is the max norm of the vector (a scalar). 
        """
        return _MultiContinuation.AbstractGroup_projectToDrawDimension(self, *args)


    def computeScaledDotProduct(self, *args):
        """
        computeScaledDotProduct(AbstractGroup self, Vector a, Vector b) -> double

        double
        LOCA::MultiContinuation::AbstractGroup::computeScaledDotProduct(const
        NOX::Abstract::Vector &a, const NOX::Abstract::Vector &b) const

        Compute a scaled dot product.

        The default implementation here just computes a.dot(b) but should be
        overloaded for any problem that his difficult scaling. 
        """
        return _MultiContinuation.AbstractGroup_computeScaledDotProduct(self, *args)


    def printSolution(self, *args):
        """
        printSolution(AbstractGroup self, double const conParam)
        printSolution(AbstractGroup self, Vector x_, double const conParam)

        virtual void
        LOCA::MultiContinuation::AbstractGroup::printSolution(const
        NOX::Abstract::Vector &x_, const double conParam) const

        Function to print out a vector and parameter after successful step.

        Empty default definition. 
        """
        return _MultiContinuation.AbstractGroup_printSolution(self, *args)


    def scaleVector(self, *args):
        """
        scaleVector(AbstractGroup self, Vector x)

        void
        LOCA::MultiContinuation::AbstractGroup::scaleVector(NOX::Abstract::Vector
        &x) const

        Scales a vector using scaling vector.

        The default definition here is to do nothing, i.e., no scaling 
        """
        return _MultiContinuation.AbstractGroup_scaleVector(self, *args)

AbstractGroup_swigregister = _MultiContinuation.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class FiniteDifferenceGroup(AbstractGroup):
    """


    Concrete class that provides a concrete implementation of the
    computeDfDp() method of the LOCA::Continuation::AbstractGroup using
    first-order finite differencing.

    The finite-differencing calculations are actually implemented by the
    LOCA::DerivUtils class, and a custom DerivUtils object can be set by
    the setDerivUtils() method. However, in the future the calculations
    encapsulated in the DerivUtils class may be incorporated directly into
    this class and other finite- differencing child classes.

    C++ includes: LOCA_MultiContinuation_FiniteDifferenceGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MultiContinuation.delete_FiniteDifferenceGroup

    def copy(self, *args):
        """
        copy(FiniteDifferenceGroup self, Group source)

        void
        LOCA::MultiContinuation::FiniteDifferenceGroup::copy(const
        NOX::Abstract::Group &source)

        Copy. 
        """
        return _MultiContinuation.FiniteDifferenceGroup_copy(self, *args)


    def setDerivUtils(self, *args):
        """
        setDerivUtils(FiniteDifferenceGroup self, Teuchos::RCP< LOCA::DerivUtils > const & deriv)

        void
        LOCA::MultiContinuation::FiniteDifferenceGroup::setDerivUtils(const
        Teuchos::RCP< LOCA::DerivUtils > &deriv)

        Set the LOCA::DerivUtils object. 
        """
        return _MultiContinuation.FiniteDifferenceGroup_setDerivUtils(self, *args)


    def computeDfDpMulti(self, *args):
        """
        computeDfDpMulti(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::FiniteDifferenceGroup::computeDfDpMulti(const
        std::vector< int > &paramIDs, NOX::Abstract::MultiVector &dfdp, bool
        isValidF)

        Compute $\\partial F/\\partial p$ for each parameter $p$ indexed
        by paramIDs. The first column of dfdp holds F, which is valid if
        isValidF is true. Otherwise F must be computed.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDfDp() method of the passed LOCA::DerivUtils
        object. 
        """
        return _MultiContinuation.FiniteDifferenceGroup_computeDfDpMulti(self, *args)

FiniteDifferenceGroup_swigregister = _MultiContinuation.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

class ConstraintInterface(_object):
    """


    Abstract interface for the constraint portion of a constrained
    nonlinear system.

    This class is used in conjunction with
    LOCA::MultiContinuation::ConstrainedGroup to represent a constrained
    nonlinear system: \\[ f(x,y) = 0 g(x,y) = 0 \\] where $f(x,y)$ is
    represented by a concrete implementation of a
    LOCA::MultiContinuation::AbstractGroup and $g(x,y)$ (the constraint)
    is represented by an implementation of this class. Here it is assumed
    the resulting system is square, i.e., $x\\in\\Re^n$,
    $y\\in\\Re^m$, $f(x,y)\\in\\Re^n$ and $g(x,y)\\in\\Re^m$.

    This class provides an interface to evaluate $g(x,y)$, compute the
    derivatives $g_x$ and $g_y$, and apply the derivative $g_x$ to
    arbitrary multi-vectors (the implementation is never required to
    explicitly store $g_x$ which is impractical in many situations).

    C++ includes: LOCA_MultiContinuation_ConstraintInterface.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstraintInterface, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ConstraintInterface, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::ConstraintInterface self) -> ConstraintInterface

        LOCA::MultiContinuation::ConstraintInterface::ConstraintInterface()

        Constructor. 
        """
        if self.__class__ == ConstraintInterface:
            _self = None
        else:
            _self = self
        this = _MultiContinuation.new_ConstraintInterface(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ConstraintInterface

    def copy(self, *args):
        """
        copy(ConstraintInterface self, ConstraintInterface source)

        virtual void
        LOCA::MultiContinuation::ConstraintInterface::copy(const
        ConstraintInterface &source)=0

        Copy. 
        """
        return _MultiContinuation.ConstraintInterface_copy(self, *args)


    def clone(self, *args):
        """
        clone(ConstraintInterface self, NOX::CopyType type) -> Teuchos::RCP< LOCA::MultiContinuation::ConstraintInterface >

        virtual
        Teuchos::RCP<LOCA::MultiContinuation::ConstraintInterface>
        LOCA::MultiContinuation::ConstraintInterface::clone(NOX::CopyType
        type=NOX::DeepCopy) const =0

        Cloning function. 
        """
        return _MultiContinuation.ConstraintInterface_clone(self, *args)


    def numConstraints(self, *args):
        """
        numConstraints(ConstraintInterface self) -> int

        virtual
        int LOCA::MultiContinuation::ConstraintInterface::numConstraints()
        const =0

        Return number of constraints. 
        """
        return _MultiContinuation.ConstraintInterface_numConstraints(self, *args)


    def setX(self, *args):
        """
        setX(ConstraintInterface self, Vector x)

        virtual void
        LOCA::MultiContinuation::ConstraintInterface::setX(const
        NOX::Abstract::Vector &x)=0

        Set the solution vector to x. 
        """
        return _MultiContinuation.ConstraintInterface_setX(self, *args)


    def setParam(self, *args):
        """
        setParam(ConstraintInterface self, int paramID, double val)

        virtual void
        LOCA::MultiContinuation::ConstraintInterface::setParam(int paramID,
        double val)=0

        Sets parameter indexed by paramID. 
        """
        return _MultiContinuation.ConstraintInterface_setParam(self, *args)


    def setParams(self, *args):
        """
        setParams(ConstraintInterface self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        virtual void
        LOCA::MultiContinuation::ConstraintInterface::setParams(const
        std::vector< int > &paramIDs, const
        NOX::Abstract::MultiVector::DenseMatrix &vals)=0

        Sets parameters indexed by paramIDs. 
        """
        return _MultiContinuation.ConstraintInterface_setParams(self, *args)


    def computeConstraints(self, *args):
        """
        computeConstraints(ConstraintInterface self) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterface::computeConstraints()=0

        Compute constraint residuals. 
        """
        return _MultiContinuation.ConstraintInterface_computeConstraints(self, *args)


    def computeDX(self, *args):
        """
        computeDX(ConstraintInterface self) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterface::computeDX()=0

        Compute derivative of constraints w.r.t. solution vector x. 
        """
        return _MultiContinuation.ConstraintInterface_computeDX(self, *args)


    def computeDP(self, *args):
        """
        computeDP(ConstraintInterface self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix & dgdp, bool isValidG) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterface::computeDP(const
        std::vector< int > &paramIDs, NOX::Abstract::MultiVector::DenseMatrix
        &dgdp, bool isValidG)=0

        Compute derivative of constraints w.r.t. supplied parameters.

        The first column of dgdp should be filled with the constraint
        residuals $g$ if isValidG is false. If isValidG is true, then the dgdp
        contains $g$ on input. 
        """
        return _MultiContinuation.ConstraintInterface_computeDP(self, *args)


    def isConstraints(self, *args):
        """
        isConstraints(ConstraintInterface self) -> bool

        virtual
        bool LOCA::MultiContinuation::ConstraintInterface::isConstraints()
        const =0

        Return true if constraint residuals are valid. 
        """
        return _MultiContinuation.ConstraintInterface_isConstraints(self, *args)


    def isDX(self, *args):
        """
        isDX(ConstraintInterface self) -> bool

        virtual bool
        LOCA::MultiContinuation::ConstraintInterface::isDX() const =0

        Return true if derivative of constraint w.r.t. x is valid. 
        """
        return _MultiContinuation.ConstraintInterface_isDX(self, *args)


    def getConstraints(self, *args):
        """
        getConstraints(ConstraintInterface self) -> NOX::Abstract::MultiVector::DenseMatrix const &

        virtual
        const NOX::Abstract::MultiVector::DenseMatrix&
        LOCA::MultiContinuation::ConstraintInterface::getConstraints() const
        =0

        Return constraint residuals. 
        """
        return _MultiContinuation.ConstraintInterface_getConstraints(self, *args)


    def multiplyDX(self, *args):
        """
        multiplyDX(ConstraintInterface self, double alpha, MultiVector input_x, NOX::Abstract::MultiVector::DenseMatrix & result_p) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterface::multiplyDX(double alpha,
        const NOX::Abstract::MultiVector &input_x,
        NOX::Abstract::MultiVector::DenseMatrix &result_p) const =0

        Compute result_p = alpha * dg/dx * input_x.

        Note that if there are n constraints and input_x has m columns,
        result_p should be a n by m matrix and is equivalent to 
        """
        return _MultiContinuation.ConstraintInterface_multiplyDX(self, *args)


    def addDX(self, *args):
        """
        addDX(ConstraintInterface self, Teuchos::ETransp transb, double alpha, NOX::Abstract::MultiVector::DenseMatrix const & b, double beta, MultiVector result_x) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterface::addDX(Teuchos::ETransp
        transb, double alpha, const NOX::Abstract::MultiVector::DenseMatrix
        &b, double beta, NOX::Abstract::MultiVector &result_x) const =0

        Compute result_x = alpha * dg/dx^T * op(b) + beta * result_x.

        Note that this should be equivalent to 
        """
        return _MultiContinuation.ConstraintInterface_addDX(self, *args)


    def isDXZero(self, *args):
        """
        isDXZero(ConstraintInterface self) -> bool

        virtual bool
        LOCA::MultiContinuation::ConstraintInterface::isDXZero() const =0

        Return true if solution component of constraint derivatives is zero.

        """
        return _MultiContinuation.ConstraintInterface_isDXZero(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(ConstraintInterface self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        virtual void
        LOCA::MultiContinuation::ConstraintInterface::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. The default implementation is empty. 
        """
        return _MultiContinuation.ConstraintInterface_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(ConstraintInterface self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        virtual void
        LOCA::MultiContinuation::ConstraintInterface::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. The
        default implementation is empty. 
        """
        return _MultiContinuation.ConstraintInterface_postProcessContinuationStep(self, *args)

    def __disown__(self):
        self.this.disown()
        _MultiContinuation.disown_ConstraintInterface(self)
        return weakref_proxy(self)
ConstraintInterface_swigregister = _MultiContinuation.ConstraintInterface_swigregister
ConstraintInterface_swigregister(ConstraintInterface)

class ConstraintInterfaceMVDX(ConstraintInterface):
    """


    Abstract interface for the constraint portion of a constrained
    nonlinear system for constraints that support computing a solution
    component derivative as a multi-vector.

    This class extends the LOCA::MultiContinuation::ConstraintInterface to
    support constraints that support computing the entire derivative with
    respect to the solution components (x) and storing the resulting
    derivative as a multivector. This interface adds one additional
    method, getConstraintDerivativesX(), that returns this derivative.
    Additionally, it implements the applyConstraintDerivativesX() methods
    using standard multi-vector operations.

    C++ includes: LOCA_MultiContinuation_ConstraintInterfaceMVDX.H 
    """

    __swig_setmethods__ = {}
    for _s in [ConstraintInterface]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstraintInterfaceMVDX, name, value)
    __swig_getmethods__ = {}
    for _s in [ConstraintInterface]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstraintInterfaceMVDX, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::ConstraintInterfaceMVDX self) -> ConstraintInterfaceMVDX

        LOCA::MultiContinuation::ConstraintInterfaceMVDX::ConstraintInterfaceMVDX()

        Constructor. 
        """
        if self.__class__ == ConstraintInterfaceMVDX:
            _self = None
        else:
            _self = self
        this = _MultiContinuation.new_ConstraintInterfaceMVDX(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ConstraintInterfaceMVDX

    def getDX(self, *args):
        """
        getDX(ConstraintInterfaceMVDX self) -> MultiVector

        virtual
        const NOX::Abstract::MultiVector*
        LOCA::MultiContinuation::ConstraintInterfaceMVDX::getDX() const =0

        Return solution component of constraint derivatives.

        May return NULL if constraint derivative is zero 
        """
        return _MultiContinuation.ConstraintInterfaceMVDX_getDX(self, *args)


    def multiplyDX(self, *args):
        """
        multiplyDX(ConstraintInterfaceMVDX self, double alpha, MultiVector input_x, NOX::Abstract::MultiVector::DenseMatrix & result_p) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterfaceMVDX::multiplyDX(double
        alpha, const NOX::Abstract::MultiVector &input_x,
        NOX::Abstract::MultiVector::DenseMatrix &result_p) const

        Compute result_p = alpha * dg/dx * input_x.

        This method is implemented using getConstraintDerivativesX() and the
        NOX::Abstract::MultiVector::multiply() method. 
        """
        return _MultiContinuation.ConstraintInterfaceMVDX_multiplyDX(self, *args)


    def addDX(self, *args):
        """
        addDX(ConstraintInterfaceMVDX self, Teuchos::ETransp transb, double alpha, NOX::Abstract::MultiVector::DenseMatrix const & b, double beta, MultiVector result_x) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::MultiContinuation::ConstraintInterfaceMVDX::addDX(Teuchos::ETransp
        transb, double alpha, const NOX::Abstract::MultiVector::DenseMatrix
        &b, double beta, NOX::Abstract::MultiVector &result_x) const

        Compute result_x = alpha * dg/dx^T * op(b) + beta * result_x.

        This method is implemented using getConstraintDerivativesX() and the
        NOX::Abstract::MultiVector::update() method. 
        """
        return _MultiContinuation.ConstraintInterfaceMVDX_addDX(self, *args)

    def __disown__(self):
        self.this.disown()
        _MultiContinuation.disown_ConstraintInterfaceMVDX(self)
        return weakref_proxy(self)
ConstraintInterfaceMVDX_swigregister = _MultiContinuation.ConstraintInterfaceMVDX_swigregister
ConstraintInterfaceMVDX_swigregister(ConstraintInterfaceMVDX)

class ExtendedMultiVector(Extended.MultiVector):
    """


    MultiVector class to hold solution vectors, Newton vectors, etc. for
    continuation equations.

    This class uses the LOCA::Extended::MultiVector implementation to
    store the solution and parameter components of the continuation vector
    and merely provides an interface for naming which components of the
    multivector these quantities correspond to.

    C++ includes: LOCA_MultiContinuation_ExtendedMultiVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedMultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedMultiVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector xVec, int nColumns, int nScalarRows, NOX::CopyType type) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector xVec, int nScalarRows) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector xVec, NOX::Abstract::MultiVector::DenseMatrix const & params) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, ExtendedMultiVector source, NOX::CopyType type) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, ExtendedMultiVector source, int nColumns) -> ExtendedMultiVector
        __init__(LOCA::MultiContinuation::ExtendedMultiVector self, ExtendedMultiVector source, std::vector< int,std::allocator< int > > const & index, bool view) -> ExtendedMultiVector

        LOCA::MultiContinuation::ExtendedMultiVector::ExtendedMultiVector(const
        ExtendedMultiVector &source, const std::vector< int > &index, bool
        view)

        Copy constructor that creates a sub copy or view of the given
        multivector. 
        """
        this = _MultiContinuation.new_ExtendedMultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ExtendedMultiVector

    def clone(self, *args):
        """
        clone(ExtendedMultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP<
        NOX::Abstract::MultiVector >
        LOCA::MultiContinuation::ExtendedMultiVector::clone(int numvecs) const

        Creates a new multi-vector with numvecs columns. 
        """
        return _MultiContinuation.ExtendedMultiVector_clone(self, *args)


    def subCopy(self, *args):
        """
        subCopy(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP<
        NOX::Abstract::MultiVector >
        LOCA::MultiContinuation::ExtendedMultiVector::subCopy(const
        std::vector< int > &index) const

        Creates a new multi-vector with index.size() columns whose columns are
        copies of the columns of *this given by index. 
        """
        return _MultiContinuation.ExtendedMultiVector_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP<
        NOX::Abstract::MultiVector >
        LOCA::MultiContinuation::ExtendedMultiVector::subView(const
        std::vector< int > &index) const

        Creates a new multi-vector with index.size() columns that shares the
        columns of *this given by index. 
        """
        return _MultiContinuation.ExtendedMultiVector_subView(self, *args)


    def getXMultiVec(self, *args):
        """
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::MultiContinuation::ExtendedMultiVector::getXMultiVec()

        Returns the solution vector component of extended multivector. 
        """
        return _MultiContinuation.ExtendedMultiVector_getXMultiVec(self, *args)

ExtendedMultiVector_swigregister = _MultiContinuation.ExtendedMultiVector_swigregister
ExtendedMultiVector_swigregister(ExtendedMultiVector)

class ExtendedVector(Extended.Vector):
    """


    Vector class to hold solution vectors, Newton vectors, etc. for
    continuation equations.

    This class uses the LOCA::Extended::Vector implementation to store the
    solution and parameter components of the continuation vector and
    merely provides an interface for naming which components of the
    multivector these quantities correspond to.

    C++ includes: LOCA_MultiContinuation_ExtendedVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::ExtendedVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector xVec, int nScalars) -> ExtendedVector
        __init__(LOCA::MultiContinuation::ExtendedVector self, ExtendedVector source, NOX::CopyType type) -> ExtendedVector

        LOCA::MultiContinuation::ExtendedVector::ExtendedVector(const
        ExtendedVector &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _MultiContinuation.new_ExtendedVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_ExtendedVector

    def clone(self, *args):
        """
        clone(ExtendedVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::MultiContinuation::ExtendedVector::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Assignment operator. 
        """
        return _MultiContinuation.ExtendedVector_clone(self, *args)


    def getXVec(self, *args):
        """
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP<
        NOX::Abstract::Vector >
        LOCA::MultiContinuation::ExtendedVector::getXVec()

        Returns the solution vector component of extended vector. 
        """
        return _MultiContinuation.ExtendedVector_getXVec(self, *args)

ExtendedVector_swigregister = _MultiContinuation.ExtendedVector_swigregister
ExtendedVector_swigregister(ExtendedVector)

class Factory(_object):
    """


    Factory for creating continuation strategy objects.

    The parameters passed to the create() through the stepperParams
    argument method should specify the "Continuation Method" as
    described below, as well as any additional parameters for the
    particular strategy. "Continuation Method" - Name of the
    continuation method. Valid choices are "Arc Length" (
    LOCA::MultiContinuation::ArcLengthGroup) [Default]

    "Natural" ( LOCA::MultiContinuation::NaturalGroup)

    C++ includes: LOCA_MultiContinuation_Factory.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::MultiContinuation::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> Factory

        LOCA::MultiContinuation::Factory::Factory(const Teuchos::RCP<
        LOCA::GlobalData > &global_data)

        Constructor. 
        """
        this = _MultiContinuation.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MultiContinuation.delete_Factory

    def create(self, *args):
        """
        create(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepperParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy > const & pred, std::vector< int,std::allocator< int > > const & paramIDs) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >
        LOCA::MultiContinuation::Factory::create(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &stepperParams, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &grp, const Teuchos::RCP<
        LOCA::MultiPredictor::AbstractStrategy > &pred, const std::vector< int
        > &paramIDs)

        Create continuation strategy.

        Parameters:
        -----------

        topParams:  [in] Parsed top-level parameter list.

        stepperParams:  [in] Stepper parameters as described above

        grp:  [in] Underlying group

        pred:  [in] Predictor strategy

        paramIDs:  [in] Indicies of continuation parameters 
        """
        return _MultiContinuation.Factory_create(self, *args)


    def strategyName(self, *args):
        """
        strategyName(Factory self, ParameterList stepperParams) -> std::string const &

        const std::string &
        LOCA::MultiContinuation::Factory::strategyName(Teuchos::ParameterList
        &stepperParams) const

        Return strategy name given by stepperParams. 
        """
        return _MultiContinuation.Factory_strategyName(self, *args)

Factory_swigregister = _MultiContinuation.Factory_swigregister
Factory_swigregister(Factory)

# This file is compatible with both classic and new-style classes.


