# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Hopf is the python interface to namespace Hopf of the
Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Hopf is to provide groups and vectors for Hopf
bifurcations.  The python version of LOCA.Hopf supports the following
sub-modules:

    * MooreSpence         - Groups and vectors for locating Hopf bifurcations
                            using the Moore-Spence formulation
    * MinimallyAugmented  - Groups and vectors for locating Hopf bifurcations
                            using the minimally augmented Hopf formulation

and classes:

    * ComplexMultiVector  - Multi-vector class to hold two multi-vectors to
                            represent a complex multi-vector
    * ComplexVector       - Vector class to hold two vectors to represent a
                            complex vector

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op
if "delete_ComplexMultiVector" not in dir(___init__):
    del ___init__
    from . import ___init__

import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import Extended

__all__ = ['MooreSpence',
           'MinimallyAugmented'
           ]
import MooreSpence
import MinimallyAugmented

class ComplexMultiVector(Extended.MultiVector):
    """


    Multi-vector class to hold two multi-vectors to represent a complex
    multi-vector.

    This is not a true complex multi-vector. Operations like dot() and
    multiply() are not correct for complex vectors. This class exists to
    make some aspects of the real-equivalent formulation of complex linear
    algebra simpler to implement.

    C++ includes: LOCA_Hopf_ComplexMultiVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexMultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexMultiVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::ComplexMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector cloneVec, int nColumns) -> ComplexMultiVector
        __init__(LOCA::Hopf::ComplexMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector realVec, MultiVector imagVec) -> ComplexMultiVector
        __init__(LOCA::Hopf::ComplexMultiVector self, ComplexMultiVector source, NOX::CopyType type) -> ComplexMultiVector
        __init__(LOCA::Hopf::ComplexMultiVector self, ComplexMultiVector source, int nColumns) -> ComplexMultiVector
        __init__(LOCA::Hopf::ComplexMultiVector self, ComplexMultiVector source, std::vector< int,std::allocator< int > > const & index, bool view) -> ComplexMultiVector

        LOCA::Hopf::ComplexMultiVector::ComplexMultiVector(const
        ComplexMultiVector &source, const std::vector< int > &index, bool
        view)

        Copy constructor that creates a sub copy or view of the given
        multivector. 
        """
        this = ___init__.new_ComplexMultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_ComplexMultiVector

    def clone(self, *args):
        """
        clone(ComplexMultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::ComplexMultiVector::clone(int numvecs) const

        Creates a new multi-vector with numvecs columns. 
        """
        return ___init__.ComplexMultiVector_clone(self, *args)


    def subCopy(self, *args):
        """
        subCopy(ComplexMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::ComplexMultiVector::subCopy(const std::vector< int >
        &index) const

        Creates a new multi-vector with index.size() columns whose columns are
        copies of the columns of *this given by index. 
        """
        return ___init__.ComplexMultiVector_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(ComplexMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::ComplexMultiVector::subView(const std::vector< int >
        &index) const

        Creates a new multi-vector with index.size() columns that shares the
        columns of *this given by index. 
        """
        return ___init__.ComplexMultiVector_subView(self, *args)


    def getRealMultiVec(self, *args):
        """
        getRealMultiVec(ComplexMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getRealMultiVec(ComplexMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::ComplexMultiVector::getRealMultiVec()

        Returns the real component of extended multivector. 
        """
        return ___init__.ComplexMultiVector_getRealMultiVec(self, *args)


    def getImagMultiVec(self, *args):
        """
        getImagMultiVec(ComplexMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getImagMultiVec(ComplexMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::ComplexMultiVector::getImagMultiVec()

        Returns the imaginary component of extended multivector. 
        """
        return ___init__.ComplexMultiVector_getImagMultiVec(self, *args)


    def getColumn(self, *args):
        """
        getColumn(ComplexMultiVector self, int i) -> Teuchos::RCP< LOCA::Hopf::ComplexVector >
        getColumn(ComplexMultiVector self, int i) -> Teuchos::RCP< LOCA::Hopf::ComplexVector const >

        Teuchos::RCP< const LOCA::Hopf::ComplexVector >
        LOCA::Hopf::ComplexMultiVector::getColumn(int i) const

        Returns ith column as an extended vector. 
        """
        return ___init__.ComplexMultiVector_getColumn(self, *args)

ComplexMultiVector_swigregister = ___init__.ComplexMultiVector_swigregister
ComplexMultiVector_swigregister(ComplexMultiVector)

class ComplexVector(Extended.Vector):
    """


    Vector class to hold two vectors to represent a complex vector.

    This is not a true complex vector. Operations like innerProduct() are
    not correct for complex vectors. This class exists to make some
    aspects of the real-equivalent formulation of complex linear algebra
    simpler to implement.

    C++ includes: LOCA_Hopf_ComplexVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::ComplexVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector realVec, Vector imagVec) -> ComplexVector
        __init__(LOCA::Hopf::ComplexVector self, ComplexVector source, NOX::CopyType type) -> ComplexVector

        LOCA::Hopf::ComplexVector::ComplexVector(const ComplexVector &source,
        NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = ___init__.new_ComplexVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = ___init__.delete_ComplexVector

    def clone(self, *args):
        """
        clone(ComplexVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Hopf::ComplexVector::clone(NOX::CopyType type=NOX::DeepCopy)
        const

        Cloning function. 
        """
        return ___init__.ComplexVector_clone(self, *args)


    def setVec(self, *args):
        """
        setVec(ComplexVector self, Vector realVec, Vector imagVec)

        void
        LOCA::Hopf::ComplexVector::setVec(const NOX::Abstract::Vector
        &realVec, const NOX::Abstract::Vector &imagVec)

        Sets the vector by setting its components. 
        """
        return ___init__.ComplexVector_setVec(self, *args)


    def getRealVec(self, *args):
        """
        getRealVec(ComplexVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getRealVec(ComplexVector self) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Hopf::ComplexVector::getRealVec()

        Returns the real component of extended vector. 
        """
        return ___init__.ComplexVector_getRealVec(self, *args)


    def getImagVec(self, *args):
        """
        getImagVec(ComplexVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getImagVec(ComplexVector self) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Hopf::ComplexVector::getImagVec()

        Returns the imaginary component of extended vector. 
        """
        return ___init__.ComplexVector_getImagVec(self, *args)

ComplexVector_swigregister = ___init__.ComplexVector_swigregister
ComplexVector_swigregister(ComplexVector)

# This file is compatible with both classic and new-style classes.


