# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Hopf.MooreSpence is the python interface to namespace
Hopf::MooreSpence of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Hopf.MooreSpence is to provide ***.  The python
version of LOCA.Hopf.MooreSpence supports the following classes:

    * AbstractGroup          - Interface to underlying groups for Hopf point
                               calculations using the Moore-Spence formulation
    * ExtendedGroup          - A group representing the Moore-Spence Hopf
                               equations
    * ExtendedMultiVector    - Multi-vector class to hold solution vectors,
                               Newton vectors, etc.for the Moore-Spence Hopf
                               eqautions
    * ExtendedVector         - Vector class to hold solution vectors, Newton
                               vectors, etc. for Moore-Spence Hopf equations
    * FiniteDifferenceGroup  - Concrete class that provides concrete
                               implementations of the derivative computation
                               methods of the LOCA.Hopf.MooreSpence.-
                               AbstractGroup using first-order finite
                               differencing
    * SolverFactory          - Factory for creating solver objects for solving
                               Moore-Spence Hopf equations
    * SolverStrategy         - Abstract strategy for solving the Moore-Spence
                               Hopf equations
    * SalingerBordering      - Moore-Spence Hopf solver strategy based on
                               'Salinger' bordering.  This is the classic 5-
                               solve Hopf bordering method

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MooreSpence')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MooreSpence')
    _MooreSpence = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MooreSpence', [dirname(__file__)])
        except ImportError:
            import _MooreSpence
            return _MooreSpence
        try:
            _mod = imp.load_module('_MooreSpence', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MooreSpence = swig_import_helper()
    del swig_import_helper
else:
    import _MooreSpence
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op

import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import Extended
import MultiContinuation
import TimeDependent
import TurningPoint.MooreSpence
class AbstractGroup(TurningPoint.MooreSpence.AbstractGroup, TimeDependent.AbstractGroup):
    """


    Interface to underlying groups for Hopf point calculations using the
    Moore-Spence formulation.

    This abstract class provides the required interface for underlying
    groups to locate Hopf bifurcations using the bordering algorithm for
    the Moore-Spence Hopf fomulation (see
    LOCA::Hopf::MooreSpence::ExtendedGroup for a description of the
    governing equations).

    This class is derived from the
    LOCA::TurningPoint::MooreSpence::AbstractGroup and
    LOCa::TimeDependent::AbstractGroup and declares several pure virtual
    methods for applying, solving, and computing derivatives of the
    complex matrix $J+i\\omega B$ where $J$ is the Jacobian matrix, $B$
    is the mass matrix, and $\\omega$ is a (real) scalar.

    C++ includes: LOCA_Hopf_MooreSpence_AbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [TurningPoint.MooreSpence.AbstractGroup, TimeDependent.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [TurningPoint.MooreSpence.AbstractGroup, TimeDependent.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MooreSpence.delete_AbstractGroup

    def isComplex(self, *args):
        """
        isComplex(AbstractGroup self) -> bool

        virtual bool
        LOCA::Hopf::MooreSpence::AbstractGroup::isComplex() const =0

        Is $J+i\\omega B$ valid. 
        """
        return _MooreSpence.AbstractGroup_isComplex(self, *args)


    def computeComplex(self, *args):
        """
        computeComplex(AbstractGroup self, double frequency) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::AbstractGroup::computeComplex(double
        frequency)=0

        Compute $J+i\\omega B$.

        The argument frequency stores $\\omega$. 
        """
        return _MooreSpence.AbstractGroup_computeComplex(self, *args)


    def applyComplex(self, *args):
        """
        applyComplex(AbstractGroup self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::AbstractGroup::applyComplex(const
        NOX::Abstract::Vector &input_real, const NOX::Abstract::Vector
        &input_imag, NOX::Abstract::Vector &result_real, NOX::Abstract::Vector
        &result_imag) const =0

        Compute $(J+i\\omega B)(y+iz)$. 
        """
        return _MooreSpence.AbstractGroup_applyComplex(self, *args)


    def applyComplexMultiVector(self, *args):
        """
        applyComplexMultiVector(AbstractGroup self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::AbstractGroup::applyComplexMultiVector(const
        NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const =0

        Compute $(J+i\\omega B)(y+iz)$. 
        """
        return _MooreSpence.AbstractGroup_applyComplexMultiVector(self, *args)


    def applyComplexInverseMultiVector(self, *args):
        """
        applyComplexInverseMultiVector(AbstractGroup self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::AbstractGroup::applyComplexInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const =0

        Solve $(J+i\\omega B)(y+iz) = a+ib$. 
        """
        return _MooreSpence.AbstractGroup_applyComplexInverseMultiVector(self, *args)


    def computeDCeDp(self, *args):
        """
        computeDCeDp(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector yVector, Vector zVector, double w, MultiVector result_real, MultiVector result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::AbstractGroup::computeDCeDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &yVector,
        const NOX::Abstract::Vector &zVector, double w,
        NOX::Abstract::MultiVector &result_real, NOX::Abstract::MultiVector
        &result_imag, bool isValid)=0

        Computes the derivative $\\frac{\\partial (J+i\\omega
        B)(y+iz)}{\\partial p}$ where $p$ is the parameter indexed by
        paramIDs. 
        """
        return _MooreSpence.AbstractGroup_computeDCeDp(self, *args)


    def computeDCeDxa(self, *args):
        """
        computeDCeDxa(AbstractGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        computeDCeDxa(AbstractGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, Vector Ce_real, Vector Ce_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::AbstractGroup::computeDCeDxa(const
        NOX::Abstract::Vector &yVector, const NOX::Abstract::Vector &zVector,
        double w, const NOX::Abstract::MultiVector &aVector, const
        NOX::Abstract::Vector &Ce_real, const NOX::Abstract::Vector &Ce_imag,
        NOX::Abstract::MultiVector &result_real, NOX::Abstract::MultiVector
        &result_imag)=0

        Computes the directional derivative $\\frac{\\partial
        (J+i\\omega B)(y+iz)}{\\partial x} a$ for the given direction $a$.
        The arguments Ce_real and Ce_imag hold the real and imaginary
        components of $(J+i\\omega B)(y+iz)$. 
        """
        return _MooreSpence.AbstractGroup_computeDCeDxa(self, *args)

AbstractGroup_swigregister = _MooreSpence.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class ExtendedGroup(Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup):
    """


    A group representing the Moore-Spence Hopf equations.

    The LOCA::Hopf::MooreSpence::ExtendedGroup is a concrete
    implementation of the NOX::Abstract::Group,
    LOCA::MultiContinuation::AbstractGroup and
    LOCA::Extended::MultiAbstractGroup that defines the following extended
    set of equations that are regular at a generic Hopf point: \\[ G(z)
    = \\left[ \\begin{array}{c} F(x,p) \\\\ Jy-\\omega Bz
    \\\\ Jz+\\omega By \\\\ l^Ty-1 \\\\ l^Tz \\end{array}
    \\right] = 0 \\] where $z = [x, y, z, \\omega,
    p]\\in\\Re^{3n+2}$, $x$ is the solution vector, $y+i\\omega z$
    is the complex eigenvector of $J$ with corresponding eigenvalues
    $\\pm i\\omega$, $l$ is the length normalization vector and $J$ is
    the Jacobian of F w.r.t $x$.

    The group stores an underlying group of type LOCA::Hopf::MooreSpence
    AbstractGroup to represent the equations $F(x,p) = 0$ and to
    manipulate the underlying Jacobian $J$. Note that the entire extended
    Jacobian $D_z G$ is not stored in memory, rather a block-elimination
    algorithm (bordering algorithm) is used to compute linear solves of
    the extended Jacobian (see LOCA::Hopf::MooreSpence::SolverFactory()
    for more details).

    This class implements all of the NOX::Abstract::Group,
    LOCA::MultiContinuation::AbstractGroup, and
    LOCA::Extended::MultiAbstractGroup methods for this extended set of
    equations and therefore is a complete group which can be passed to
    most NOX solvers to locate a single Hopf point or to the LOCA::Stepper
    to compute a family of Hopf points in a second parameter.

    However, Jacobian-tranpose operations and gradient calculations cannot
    be implemented efficiently and therefore gradient-base nonlinear
    solvers such as steepest descent and Trust region methods cannot be
    used to solve the extended Hopf point equations.

    The class is intialized via the hopfParams parameter list argument to
    the constructor. The parameters this class recognizes are:
    "Bifurcation Parameter" [string] (Must be supplied) Name of the
    bifurcation parameter $p$

    "Length Normalization Vector" [Teuchos::RCP<NOX::Abstract::Vector>]
    (Must be supplied) Vector storing length normalization vector $l$

    "Initial Real Eigenvector" [Teuchos::RCP<NOX::Abstract::Vector>]
    (Must be supplied) Vector storing initial guess for the real component
    of the eigenvector $y$

    "Initial Imaginary Eigenvector"
    [Teuchos::RCP<NOX::Abstract::Vector>] (Must be supplied) Vector
    storing initial guess for the imaginary component of the eigenvector
    $z$

    "Initial Frequency" [double] (Must be supplied) Initial guess for
    the Hopf frequency $\\omega$.

    "Perturb Initial Solution" [bool] (default: false) Flag indicating
    whether to perturb the initial solution

    "Relative Perturbation Size"double Relative perturbation size if
    perturbing the initial solution

    C++ includes: LOCA_Hopf_MooreSpence_ExtendedGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::ExtendedGroup self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hopfParams, Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > const & g) -> ExtendedGroup
        __init__(LOCA::Hopf::MooreSpence::ExtendedGroup self, ExtendedGroup source, NOX::CopyType type) -> ExtendedGroup

        LOCA::Hopf::MooreSpence::ExtendedGroup::ExtendedGroup(const
        ExtendedGroup &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _MooreSpence.new_ExtendedGroup(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_ExtendedGroup

    def clone(self, *args):
        """
        clone(ExtendedGroup self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >

        Teuchos::RCP< NOX::Abstract::Group >
        LOCA::Hopf::MooreSpence::ExtendedGroup::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Cloning function. 
        """
        return _MooreSpence.ExtendedGroup_clone(self, *args)


    def setX(self, *args):
        """
        setX(ExtendedGroup self, Vector y)

        void LOCA::Hopf::MooreSpence::ExtendedGroup::setX(const
        NOX::Abstract::Vector &y)

        Set the solution vector, x, to y. 
        """
        return _MooreSpence.ExtendedGroup_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(ExtendedGroup self, Group g, Vector d, double step)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::computeX(const
        NOX::Abstract::Group &g, const NOX::Abstract::Vector &d, double step)

        Compute this.x = grp.x + step * d. 
        """
        return _MooreSpence.ExtendedGroup_computeX(self, *args)


    def computeF(self, *args):
        """
        computeF(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::computeF()

        Compute the Hopf point equation residual $G$. 
        """
        return _MooreSpence.ExtendedGroup_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::computeJacobian()

        Compute the blocks of the Jacobian derivative of $G$. 
        """
        return _MooreSpence.ExtendedGroup_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """
        computeGradient(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::computeGradient()

        Gradient computation is not defined for this group. 
        """
        return _MooreSpence.ExtendedGroup_computeGradient(self, *args)


    def computeNewton(self, *args):
        """
        computeNewton(ExtendedGroup self, ParameterList params) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::computeNewton(Teuchos::ParameterList
        &params)

        Compute Newton direction using applyJacobianInverse(). 
        """
        return _MooreSpence.ExtendedGroup_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(ExtendedGroup self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::applyJacobian(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Computes the extended Jacobian vector product. 
        """
        return _MooreSpence.ExtendedGroup_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(ExtendedGroup self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::applyJacobianTranspose(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Jacobian transpose product is not defined by this group. 
        """
        return _MooreSpence.ExtendedGroup_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(ExtendedGroup self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::applyJacobianInverse(Teuchos::ParameterList
        &params, const NOX::Abstract::Vector &input, NOX::Abstract::Vector
        &result) const

        Applies the inverse of the extended Jacobian matrix using the
        bordering algorithm.

        This method is a special case of applyJacobianInverseMultiVector() for
        a single right-hand-side. 
        """
        return _MooreSpence.ExtendedGroup_applyJacobianInverse(self, *args)


    def applyJacobianMultiVector(self, *args):
        """
        applyJacobianMultiVector(ExtendedGroup self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::applyJacobianMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Applies Jacobian for extended system. 
        """
        return _MooreSpence.ExtendedGroup_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """
        applyJacobianTransposeMultiVector(ExtendedGroup self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::applyJacobianTransposeMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Jacobian transpose not defined for this system. 
        """
        return _MooreSpence.ExtendedGroup_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """
        applyJacobianInverseMultiVector(ExtendedGroup self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::applyJacobianInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const

        Applies Jacobian inverse for extended system.

        Uses a LOCA::Hopf::MooreSpence::SolverStrategy instantiated by the
        LOCA::Hopf::MooreSpence::SolverFactory to implement the solve. 
        """
        return _MooreSpence.ExtendedGroup_applyJacobianInverseMultiVector(self, *args)


    def isF(self, *args):
        """
        isF(ExtendedGroup self) -> bool

        bool LOCA::Hopf::MooreSpence::ExtendedGroup::isF() const

        Return true if the extended residual $G$ is valid. 
        """
        return _MooreSpence.ExtendedGroup_isF(self, *args)


    def isJacobian(self, *args):
        """
        isJacobian(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MooreSpence::ExtendedGroup::isJacobian() const

        Return true if the extended Jacobian is valid. 
        """
        return _MooreSpence.ExtendedGroup_isJacobian(self, *args)


    def isGradient(self, *args):
        """
        isGradient(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MooreSpence::ExtendedGroup::isGradient() const

        Always returns false. 
        """
        return _MooreSpence.ExtendedGroup_isGradient(self, *args)


    def isNewton(self, *args):
        """
        isNewton(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MooreSpence::ExtendedGroup::isNewton() const

        Return true if the extended Newton direction is valid. 
        """
        return _MooreSpence.ExtendedGroup_isNewton(self, *args)


    def getX(self, *args):
        """
        getX(ExtendedGroup self) -> Vector

        const NOX::Abstract::Vector &
        LOCA::Hopf::MooreSpence::ExtendedGroup::getX() const

        Return extended solution vector $z$. 
        """
        return _MooreSpence.ExtendedGroup_getX(self, *args)


    def getF(self, *args):
        """
        getF(ExtendedGroup self) -> Vector

        const NOX::Abstract::Vector &
        LOCA::Hopf::MooreSpence::ExtendedGroup::getF() const

        Return extended equation residual $G(z)$. 
        """
        return _MooreSpence.ExtendedGroup_getF(self, *args)


    def getNormF(self, *args):
        """
        getNormF(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MooreSpence::ExtendedGroup::getNormF() const

        Return 2-norm of $G(z)$. 
        """
        return _MooreSpence.ExtendedGroup_getNormF(self, *args)


    def getGradient(self, *args):
        """
        getGradient(ExtendedGroup self) -> Vector

        const
        NOX::Abstract::Vector &
        LOCA::Hopf::MooreSpence::ExtendedGroup::getGradient() const

        Vector returned is not valid. 
        """
        return _MooreSpence.ExtendedGroup_getGradient(self, *args)


    def getNewton(self, *args):
        """
        getNewton(ExtendedGroup self) -> Vector

        const
        NOX::Abstract::Vector &
        LOCA::Hopf::MooreSpence::ExtendedGroup::getNewton() const

        Return extended Newton direction. 
        """
        return _MooreSpence.ExtendedGroup_getNewton(self, *args)


    def getNormNewtonSolveResidual(self, *args):
        """
        getNormNewtonSolveResidual(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MooreSpence::ExtendedGroup::getNormNewtonSolveResidual()
        const

        Return the norm of the Newton solve residual. 
        """
        return _MooreSpence.ExtendedGroup_getNormNewtonSolveResidual(self, *args)


    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        LOCA::Hopf::MooreSpence::ExtendedGroup::getUnderlyingGroup()

        Return underlying group. 
        """
        return _MooreSpence.ExtendedGroup_getUnderlyingGroup(self, *args)


    def copy(self, *args):
        """
        copy(ExtendedGroup self, Group source)

        void LOCA::Hopf::MooreSpence::ExtendedGroup::copy(const
        NOX::Abstract::Group &source)

        Assignment operator. 
        """
        return _MooreSpence.ExtendedGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """
        setParamsMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::setParamsMulti(const
        std::vector< int > &paramIDs, const
        NOX::Abstract::MultiVector::DenseMatrix &vals)

        Set parameters indexed by (integer) paramIDs. 
        """
        return _MooreSpence.ExtendedGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """
        setParams(ExtendedGroup self, LOCA::ParameterVector const & p)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::setParams(const
        ParameterVector &p)

        Set the parameter vector in the group to p. 
        """
        return _MooreSpence.ExtendedGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(ExtendedGroup self, int paramID, double val)
        setParam(ExtendedGroup self, std::string paramID, double val)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::setParam(std::string paramID,
        double val)

        Set parameter indexed by paramID. 
        """
        return _MooreSpence.ExtendedGroup_setParam(self, *args)


    def getParams(self, *args):
        """
        getParams(ExtendedGroup self) -> LOCA::ParameterVector const &

        const
        LOCA::ParameterVector &
        LOCA::Hopf::MooreSpence::ExtendedGroup::getParams() const

        Return a const reference to the paramter vector owned by the group. 
        """
        return _MooreSpence.ExtendedGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(ExtendedGroup self, int paramID) -> double
        getParam(ExtendedGroup self, std::string paramID) -> double

        double
        LOCA::Hopf::MooreSpence::ExtendedGroup::getParam(std::string paramID)
        const

        Return copy of parameter indexed by paramID. 
        """
        return _MooreSpence.ExtendedGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """
        computeDfDpMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::ExtendedGroup::computeDfDpMulti(const
        std::vector< int > &paramIDs, NOX::Abstract::MultiVector &dfdp, bool
        isValidF)

        Compute $\\partial F/\\partial p$ for each parameter $p$ indexed
        by paramIDs. The first column of dfdp holds F, which is valid if
        isValidF is true. Otherwise F must be computed. 
        """
        return _MooreSpence.ExtendedGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. 
        """
        return _MooreSpence.ExtendedGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. 
        """
        return _MooreSpence.ExtendedGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """
        projectToDraw(ExtendedGroup self, Vector x, double * px)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::projectToDraw(const
        NOX::Abstract::Vector &x, double *px) const

        Projects solution to a few scalars for multiparameter continuation. 
        """
        return _MooreSpence.ExtendedGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """
        projectToDrawDimension(ExtendedGroup self) -> int

        int
        LOCA::Hopf::MooreSpence::ExtendedGroup::projectToDrawDimension() const

        Returns the dimension of the project to draw array. 
        """
        return _MooreSpence.ExtendedGroup_projectToDrawDimension(self, *args)


    def printSolution(self, *args):
        """
        printSolution(ExtendedGroup self, double const conParam)
        printSolution(ExtendedGroup self, Vector x_, double const conParam)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::printSolution(const
        NOX::Abstract::Vector &x_, const double conParam) const

        Function to print out extended solution and continuation parameter
        after successful continuation step.

        This method prints the solution, null-vector, and parameter components
        of the extended solution vector using the printSolution method of the
        underlying group. 
        """
        return _MooreSpence.ExtendedGroup_printSolution(self, *args)


    def getBifParam(self, *args):
        """
        getBifParam(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MooreSpence::ExtendedGroup::getBifParam() const

        Get bifurcation parameter. 
        """
        return _MooreSpence.ExtendedGroup_getBifParam(self, *args)


    def getFrequency(self, *args):
        """
        getFrequency(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MooreSpence::ExtendedGroup::getFrequency() const

        Get bifurcation frequency. 
        """
        return _MooreSpence.ExtendedGroup_getFrequency(self, *args)


    def lTransNorm(self, *args):
        """
        lTransNorm(ExtendedGroup self, Vector z) -> double
        lTransNorm(ExtendedGroup self, MultiVector z, NOX::Abstract::MultiVector::DenseMatrix & result)

        void
        LOCA::Hopf::MooreSpence::ExtendedGroup::lTransNorm(const
        NOX::Abstract::MultiVector &z, NOX::Abstract::MultiVector::DenseMatrix
        &result) const

        null vector normalization for multivectors

        Note: result should have 1 row and z.numVectors() columns. 
        """
        return _MooreSpence.ExtendedGroup_lTransNorm(self, *args)

ExtendedGroup_swigregister = _MooreSpence.ExtendedGroup_swigregister
ExtendedGroup_swigregister(ExtendedGroup)

class ExtendedMultiVector(Extended.MultiVector):
    """


    Multi-vector class to hold solution vectors, Newton vectors, etc.for
    the Moore-Spence Hopf eqautions.

    This class uses the LOCA::Extended::MultiVector implementation to
    store the solution, real and imaginary eigenvector, frequency and
    parameter components of the Hopf multi vector and merely provides an
    interface for naming which components of the multivector these
    quantities correspond to.

    C++ includes: LOCA_Hopf_MooreSpence_ExtendedMultiVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedMultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedMultiVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector cloneVec, int nColumns) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector xVec, MultiVector realEigenVec, MultiVector imagEigenVec, NOX::Abstract::MultiVector::DenseMatrix const & freqs, NOX::Abstract::MultiVector::DenseMatrix const & bifParams) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, ExtendedMultiVector source, NOX::CopyType type) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, ExtendedMultiVector source, int nColumns) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, ExtendedMultiVector source, std::vector< int,std::allocator< int > > const & index, bool view) -> ExtendedMultiVector

        LOCA::Hopf::MooreSpence::ExtendedMultiVector::ExtendedMultiVector(const
        ExtendedMultiVector &source, const std::vector< int > &index, bool
        view)

        Copy constructor that creates a sub copy or view of the given
        multivector. 
        """
        this = _MooreSpence.new_ExtendedMultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_ExtendedMultiVector

    def clone(self, *args):
        """
        clone(ExtendedMultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP<
        NOX::Abstract::MultiVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::clone(int numvecs) const

        Creates a new multi-vector with numvecs columns. 
        """
        return _MooreSpence.ExtendedMultiVector_clone(self, *args)


    def subCopy(self, *args):
        """
        subCopy(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP<
        NOX::Abstract::MultiVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::subCopy(const
        std::vector< int > &index) const

        Creates a new multi-vector with index.size() columns whose columns are
        copies of the columns of *this given by index. 
        """
        return _MooreSpence.ExtendedMultiVector_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP<
        NOX::Abstract::MultiVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::subView(const
        std::vector< int > &index) const

        Creates a new multi-vector with index.size() columns that shares the
        columns of *this given by index. 
        """
        return _MooreSpence.ExtendedMultiVector_subView(self, *args)


    def getXMultiVec(self, *args):
        """
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::getXMultiVec()

        Returns the solution vector component of extended multivector. 
        """
        return _MooreSpence.ExtendedMultiVector_getXMultiVec(self, *args)


    def getRealEigenMultiVec(self, *args):
        """
        getRealEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getRealEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::getRealEigenMultiVec()

        Returns the real part of the eigenvector component of extended
        multivector. 
        """
        return _MooreSpence.ExtendedMultiVector_getRealEigenMultiVec(self, *args)


    def getImagEigenMultiVec(self, *args):
        """
        getImagEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getImagEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::getImagEigenMultiVec()

        Returns the imaginary part of the eigenvector component of extended
        multivector. 
        """
        return _MooreSpence.ExtendedMultiVector_getImagEigenMultiVec(self, *args)


    def getFrequencies(self, *args):
        """
        getFrequencies(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getFrequencies(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >

        Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::getFrequencies()

        Returns frequency component of extended multi vector. 
        """
        return _MooreSpence.ExtendedMultiVector_getFrequencies(self, *args)


    def getBifParams(self, *args):
        """
        getBifParams(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getBifParams(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >

        Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::getBifParams()

        Returns bifurcation parameter component of extended multi vector. 
        """
        return _MooreSpence.ExtendedMultiVector_getBifParams(self, *args)


    def getColumn(self, *args):
        """
        getColumn(ExtendedMultiVector self, int i) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedVector >
        getColumn(ExtendedMultiVector self, int i) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedVector const >

        Teuchos::RCP< const LOCA::Hopf::MooreSpence::ExtendedVector >
        LOCA::Hopf::MooreSpence::ExtendedMultiVector::getColumn(int i) const

        Returns ith column as an extended vector. 
        """
        return _MooreSpence.ExtendedMultiVector_getColumn(self, *args)

ExtendedMultiVector_swigregister = _MooreSpence.ExtendedMultiVector_swigregister
ExtendedMultiVector_swigregister(ExtendedMultiVector)

class ExtendedVector(Extended.Vector):
    """


    Vector class to hold solution vectors, Newton vectors, etc. for Moore-
    Spence Hopf equations.

    This class uses the LOCA::Extended::Vector implementation to store the
    solution, real and imaginary eigenvector, frequency and parameter
    components of the Hopf vector and merely provides an interface for
    naming which components of the multivector these quantities correspond
    to.

    C++ includes: LOCA_Hopf_MooreSpence_ExtendedVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::ExtendedVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector xVec, Vector realEigenVec, Vector imagEigenVec, double frequency, double bifParam) -> ExtendedVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedVector self, ExtendedVector source, NOX::CopyType type) -> ExtendedVector

        LOCA::Hopf::MooreSpence::ExtendedVector::ExtendedVector(const
        ExtendedVector &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _MooreSpence.new_ExtendedVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_ExtendedVector

    def clone(self, *args):
        """
        clone(ExtendedVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Hopf::MooreSpence::ExtendedVector::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Cloning function. 
        """
        return _MooreSpence.ExtendedVector_clone(self, *args)


    def setVec(self, *args):
        """
        setVec(ExtendedVector self, Vector xVec, Vector realEigenVec, Vector imagEigenVec, double frequency, double bifPar)

        void LOCA::Hopf::MooreSpence::ExtendedVector::setVec(const
        NOX::Abstract::Vector &xVec, const NOX::Abstract::Vector
        &realEigenVec, const NOX::Abstract::Vector &imagEigenVec, double
        frequency, double bifPar)

        Sets the Hopf vector by setting its five components. 
        """
        return _MooreSpence.ExtendedVector_setVec(self, *args)


    def getXVec(self, *args):
        """
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP<
        NOX::Abstract::Vector >
        LOCA::Hopf::MooreSpence::ExtendedVector::getXVec()

        Returns the solution vector component of extended vector. 
        """
        return _MooreSpence.ExtendedVector_getXVec(self, *args)


    def getRealEigenVec(self, *args):
        """
        getRealEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getRealEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Hopf::MooreSpence::ExtendedVector::getRealEigenVec()

        Returns the real part of the eigenvector component of extended vector.

        """
        return _MooreSpence.ExtendedVector_getRealEigenVec(self, *args)


    def getImagEigenVec(self, *args):
        """
        getImagEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getImagEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Hopf::MooreSpence::ExtendedVector::getImagEigenVec()

        Returns the imaginary part of the eigenvector component of extended
        vector. 
        """
        return _MooreSpence.ExtendedVector_getImagEigenVec(self, *args)

ExtendedVector_swigregister = _MooreSpence.ExtendedVector_swigregister
ExtendedVector_swigregister(ExtendedVector)

class FiniteDifferenceGroup(AbstractGroup, TurningPoint.MooreSpence.FiniteDifferenceGroup):
    """


    Concrete class that provides concrete implementations of the
    derivative computation methods of the
    LOCA::Hopf::MooreSpence::AbstractGroup using first-order finite
    differencing.

    The finite-differencing calculations are actually implemented by the
    LOCA::DerivUtils class, and a custom DerivUtils object can be passed
    through the constructor of this class. However, in the future the
    calculations encapsulated in the DerivUtils class may be incorporated
    directly into this class and other finite- differencing child classes.

    C++ includes: LOCA_Hopf_MooreSpence_FiniteDifferenceGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [AbstractGroup, TurningPoint.MooreSpence.FiniteDifferenceGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup, TurningPoint.MooreSpence.FiniteDifferenceGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MooreSpence.delete_FiniteDifferenceGroup

    def computeDCeDp(self, *args):
        """
        computeDCeDp(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector yVector, Vector zVector, double w, MultiVector result_real, MultiVector result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::FiniteDifferenceGroup::computeDCeDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &yVector,
        const NOX::Abstract::Vector &zVector, double w,
        NOX::Abstract::MultiVector &result_real, NOX::Abstract::MultiVector
        &result_imag, bool isValid)

        Computes the derivative $\\frac{\\partial (J+i\\omega
        B)(y+iz)}{\\partial p}$ where $p$ is the parameter indexed by
        paramIDs.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDCeDp() method of the passed LOCA::DerivUtils
        object. 
        """
        return _MooreSpence.FiniteDifferenceGroup_computeDCeDp(self, *args)


    def computeDCeDxa(self, *args):
        """
        computeDCeDxa(FiniteDifferenceGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        computeDCeDxa(FiniteDifferenceGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, Vector Ce_real, Vector Ce_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::FiniteDifferenceGroup::computeDCeDxa(const
        NOX::Abstract::Vector &yVector, const NOX::Abstract::Vector &zVector,
        double w, const NOX::Abstract::MultiVector &aVector, const
        NOX::Abstract::Vector &Ce_real, const NOX::Abstract::Vector &Ce_imag,
        NOX::Abstract::MultiVector &result_real, NOX::Abstract::MultiVector
        &result_imag)

        Computes the directional derivative $\\frac{\\partial
        (J+i\\omega B)(y+iz)}{\\partial x} a$ for the given direction $a$.
        The arguments Ce_real and Ce_imag hold the real and imaginary
        components of $(J+i\\omega B)(y+iz)$.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDCeDxa() method of the passed
        LOCA::DerivUtils object. 
        """
        return _MooreSpence.FiniteDifferenceGroup_computeDCeDxa(self, *args)

FiniteDifferenceGroup_swigregister = _MooreSpence.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

class SolverFactory(_object):
    """


    Factory for creating solver objects for solving Moore-Spence Hopf
    equations.

    The parameters passed to the create() through the solverParams
    argument method should specify the "Solver Method" as described
    below, as well as any additional parameters for the particular
    strategy. "Solver Method" - Name of the method. Valid choices are
    "Salinger Bordering" ( LOCA::Hopf::MooreSpence::SalingerBordering)
    [Default]

    C++ includes: LOCA_Hopf_MooreSpence_SolverFactory.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverFactory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverFactory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::SolverFactory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> SolverFactory

        LOCA::Hopf::MooreSpence::SolverFactory::SolverFactory(const
        Teuchos::RCP< LOCA::GlobalData > &global_data)

        Constructor. 
        """
        this = _MooreSpence.new_SolverFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_SolverFactory

    def create(self, *args):
        """
        create(SolverFactory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::SolverStrategy >

        Teuchos::RCP< LOCA::Hopf::MooreSpence::SolverStrategy >
        LOCA::Hopf::MooreSpence::SolverFactory::create(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams)

        Create solver strategy.

        Parameters:
        -----------

        topParams:  [in] Parsed top-level parameter list.

        solverParams:  [in] Solver parameters as described above 
        """
        return _MooreSpence.SolverFactory_create(self, *args)


    def strategyName(self, *args):
        """
        strategyName(SolverFactory self, ParameterList solverParams) -> std::string const &

        const
        std::string &
        LOCA::Hopf::MooreSpence::SolverFactory::strategyName(Teuchos::ParameterList
        &solverParams) const

        Return strategy name given by solverParams. 
        """
        return _MooreSpence.SolverFactory_strategyName(self, *args)

SolverFactory_swigregister = _MooreSpence.SolverFactory_swigregister
SolverFactory_swigregister(SolverFactory)

class SolverStrategy(_object):
    """


    Abstract strategy for solving the Moore-Spence Hopf equations.

    This class provides an abstract interface for solver strategies to
    solve the Moore-Spence Hopf Newton system: \\[ \\begin{bmatrix} J
    & 0 & 0 & 0 & f_p \\\\ (Jy-wBz)_x & J & -wB & -Bz & (Jy-wBz)_p
    \\\\ (Jz+wBy)_x & wB & J & By & (Jz+wBy)_p \\\\ 0 & \\phi^T
    & 0 & 0 & 0 \\\\ 0 & 0 & \\phi^T & 0 & 0 \\end{bmatrix}
    \\begin{bmatrix} X \\\\ Y \\\\ Z \\\\ \\Omega^T
    \\\\ \\Lambda^T \\end{bmatrix} = \\begin{bmatrix} F \\\\
    G \\\\ H \\\\ U^T \\\\ V^T \\end{bmatrix}. \\] After
    instantiating a solver (via LOCA::Hopf::MooreSpence::SolverFactory),
    the linear system is set up by setBlocks() and can then be solved by
    solve().

    C++ includes: LOCA_Hopf_MooreSpence_SolverStrategy.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverStrategy, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverStrategy, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MooreSpence.delete_SolverStrategy

    def setBlocks(self, *args):
        """
        setBlocks(SolverStrategy self, Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > const & group, Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedGroup > const & hopfGroup, Teuchos::RCP< NOX::Abstract::Vector const > const & yVector, Teuchos::RCP< NOX::Abstract::Vector const > const & zVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeRealVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeImagVector, Teuchos::RCP< NOX::Abstract::Vector const > const & dfdp, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpReal, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpImag, Teuchos::RCP< NOX::Abstract::Vector const > const & ByVector, Teuchos::RCP< NOX::Abstract::Vector const > const & mBzVector, double w)

        virtual void
        LOCA::Hopf::MooreSpence::SolverStrategy::setBlocks(const Teuchos::RCP<
        LOCA::Hopf::MooreSpence::AbstractGroup > &group, const Teuchos::RCP<
        LOCA::Hopf::MooreSpence::ExtendedGroup > &hopfGroup, const
        Teuchos::RCP< const NOX::Abstract::Vector > &yVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &zVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &CeRealVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &CeImagVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &dfdp, const Teuchos::RCP<
        const NOX::Abstract::Vector > &dCedpReal, const Teuchos::RCP< const
        NOX::Abstract::Vector > &dCedpImag, const Teuchos::RCP< const
        NOX::Abstract::Vector > &ByVector, const Teuchos::RCP< const
        NOX::Abstract::Vector > &mBzVector, double w)=0

        Set blocks in extended linear system.

        Parameters:
        -----------

        group:  [in] Underlying group representing J

        hopfGroup:  [in] Hopf group representing the Hopf equations.

        yVector:  [in] Vector representing y

        zVector:  [in] Vector representing z

        CeRealVector:  [in] Vector representing Jy-wBz

        CeImagVector:  [in] Vector representing Jz+wBy

        dfdp:  [in] Vector representing df/dp

        dCedpReal:  [in] Vector representing d(Jy-wBz)/dp

        dCedpImag:  [in] Vector representing d(Jz+wBy)/dp

        ByVector:  [in] Vector representing By

        mBzVector:  [in] Vector representing -Bz

        w:  [in] Bifurcation frequency w 
        """
        return _MooreSpence.SolverStrategy_setBlocks(self, *args)


    def solve(self, *args):
        """
        solve(SolverStrategy self, ParameterList params, ExtendedMultiVector input, ExtendedMultiVector result) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::SolverStrategy::solve(Teuchos::ParameterList
        &params, const LOCA::Hopf::MooreSpence::ExtendedMultiVector &input,
        LOCA::Hopf::MooreSpence::ExtendedMultiVector &result) const =0

        Solves the extended system as defined above.

        The params argument is the linear solver parameters. 
        """
        return _MooreSpence.SolverStrategy_solve(self, *args)

SolverStrategy_swigregister = _MooreSpence.SolverStrategy_swigregister
SolverStrategy_swigregister(SolverStrategy)

class SalingerBordering(SolverStrategy):
    """


    Moore-Spence Hopf solver strategy based on "Salinger" bordering.
    This is the classic 5-solve Hopf bordering method.

    This class solves the Moore-Spence Hopf Newton equations: \\[
    \\begin{bmatrix} J & 0 & 0 & 0 & f_p \\\\ (Jy-wBz)_x & J & -wB &
    -Bz & (Jy-wBz)_p \\\\ (Jz+wBy)_x & wB & J & By & (Jz+wBy)_p
    \\\\ 0 & \\phi^T & 0 & 0 & 0 \\\\ 0 & 0 & \\phi^T & 0 & 0
    \\end{bmatrix} \\begin{bmatrix} X \\\\ Y \\\\ Z \\\\
    \\omega \\\\ \\lambda \\end{bmatrix} = \\begin{bmatrix} F
    \\\\ G \\\\ H \\\\ u \\\\ v \\end{bmatrix}. \\]
    via the following block elimination scheme: \\[ \\begin{split} J
    [A \\; b] &= [F \\; f_p] \\\\ \\begin{bmatrix} J & -wB
    \\\\ wB & J \\end{bmatrix} \\begin{bmatrix} C & e & g \\\\
    D & f & h \\end{bmatrix} &= \\begin{bmatrix} G - (Jy-wBz)_x A &
    (Jy-wBz)_p - (Jy-wBz)_x b & -Bz \\\\ H - (Jz+wBy)_x A & (Jz+wBy)_p
    - (Jy-wBz)_x b & By \\end{bmatrix} \\\\ \\lambda &=
    \\frac{(\\phi^T h)(\\phi^T C-u)-(\\phi^T g)(\\phi^T D-v)}
    {(\\phi^T h)(\\phi^T e)-(\\phi^T g)(\\phi^T f)} \\\\
    \\omega &= \\frac{\\phi^T D - v - (\\phi^T
    f)\\lambda}{\\phi^T h} \\\\ X &= A - b \\lambda \\\\
    \\begin{bmatrix} Y \\\\ Z \\end{bmatrix} &= \\begin{bmatrix}
    C \\\\ D \\end{bmatrix} - \\begin{bmatrix} e \\\\ f
    \\end{bmatrix}\\lambda - \\begin{bmatrix} g \\\\ h
    \\end{bmatrix}\\omega \\end{split} \\]

    C++ includes: LOCA_Hopf_MooreSpence_SalingerBordering.H 
    """

    __swig_setmethods__ = {}
    for _s in [SolverStrategy]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SalingerBordering, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverStrategy]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SalingerBordering, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::SalingerBordering self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> SalingerBordering

        LOCA::Hopf::MooreSpence::SalingerBordering::SalingerBordering(const
        Teuchos::RCP< LOCA::GlobalData > &global_data, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams)

        Constructor.

        Parameters:
        -----------

        global_data:  [in] Global data object

        topParams:  [in] Parsed top-level parameter list

        solverParams:  [in] Bordered solver parameters. Currently none are
        referenced. 
        """
        this = _MooreSpence.new_SalingerBordering(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_SalingerBordering

    def setBlocks(self, *args):
        """
        setBlocks(SalingerBordering self, Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > const & group, Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedGroup > const & hopfGroup, Teuchos::RCP< NOX::Abstract::Vector const > const & yVector, Teuchos::RCP< NOX::Abstract::Vector const > const & zVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeRealVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeImagVector, Teuchos::RCP< NOX::Abstract::Vector const > const & dfdp, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpReal, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpImag, Teuchos::RCP< NOX::Abstract::Vector const > const & ByVector, Teuchos::RCP< NOX::Abstract::Vector const > const & mBzVector, double w)

        void
        LOCA::Hopf::MooreSpence::SalingerBordering::setBlocks(const
        Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > &group, const
        Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedGroup > &hopfGroup,
        const Teuchos::RCP< const NOX::Abstract::Vector > &yVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &zVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &CeRealVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &CeImagVector, const
        Teuchos::RCP< const NOX::Abstract::Vector > &dfdp, const Teuchos::RCP<
        const NOX::Abstract::Vector > &dCedpReal, const Teuchos::RCP< const
        NOX::Abstract::Vector > &dCedpImag, const Teuchos::RCP< const
        NOX::Abstract::Vector > &ByVector, const Teuchos::RCP< const
        NOX::Abstract::Vector > &mBzVector, double w)

        Set blocks in extended linear system.

        Parameters:
        -----------

        group:  [in] Underlying group representing J

        hopfGroup:  [in] Hopf group representing the Hopf equations.

        yVector:  [in] Vector representing y

        zVector:  [in] Vector representing z

        CeRealVector:  [in] Vector representing Jy-wBz

        CeImagVector:  [in] Vector representing Jz+wBy

        dfdp:  [in] Vector representing df/dp

        dCedpReal:  [in] Vector representing d(Jy-wBz)/dp

        dCedpImag:  [in] Vector representing d(Jz+wBy)/dp

        ByVector:  [in] Vector representing By

        mBzVector:  [in] Vector representing -Bz

        w:  [in] Bifurcation frequency w 
        """
        return _MooreSpence.SalingerBordering_setBlocks(self, *args)


    def solve(self, *args):
        """
        solve(SalingerBordering self, ParameterList params, ExtendedMultiVector input, ExtendedMultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MooreSpence::SalingerBordering::solve(Teuchos::ParameterList
        &params, const LOCA::Hopf::MooreSpence::ExtendedMultiVector &input,
        LOCA::Hopf::MooreSpence::ExtendedMultiVector &result) const

        Solves the extended system as defined above.

        The params argument is the linear solver parameters. 
        """
        return _MooreSpence.SalingerBordering_solve(self, *args)

SalingerBordering_swigregister = _MooreSpence.SalingerBordering_swigregister
SalingerBordering_swigregister(SalingerBordering)

# This file is compatible with both classic and new-style classes.


