# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Hopf.MinimallyAugmented is the python interface to
namespace Hopf::MinimallyAugmented of the Trilinos continuation
algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Hopf.MinimallyAugmented is to provide groups and
vectors for locating Hopf bifurcations using the minimally augmented
Hopf formulation.  The python version of LOCA.Hopf.MinimallyAugmented
supports the following classes:

    * Constraint             - Implementation of LOCA.MultiContinuation.-
                               ConstraintInterfaceMVDX for computing Hopf
                               bifurcations for the minimally augmented Hopf
                               formulation
    * AbstractGroup          - Interface to underlying groups for Hopf
                               calculations using the minimally augmented
                               formulation
    * FiniteDifferenceGroup  - Concrete class that provides concrete
                               implementations of the derivative computation
                               methods of the LOCA.Hopf.MinimallyAugmented.-
                               AbstractGroup using first-order finite
                               differencing
    * ExtendedGroup          - Group representing the minimally augemented Hopf
                               equations

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MinimallyAugmented')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MinimallyAugmented')
    _MinimallyAugmented = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MinimallyAugmented', [dirname(__file__)])
        except ImportError:
            import _MinimallyAugmented
            return _MinimallyAugmented
        try:
            _mod = imp.load_module('_MinimallyAugmented', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MinimallyAugmented = swig_import_helper()
    del swig_import_helper
else:
    import _MinimallyAugmented
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op

import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import BorderedSystem
import Extended
import MultiContinuation
import TimeDependent
import TurningPoint.MooreSpence
import MooreSpence
class Constraint(MultiContinuation.ConstraintInterfaceMVDX):
    """


    Implementation of LOCA::MultiContinuation::ConstraintInterfaceMVDX for
    computing Hopf bifurcations for the minimally augmented Hopf
    formulation.

    This class implements the turning point constraint equation
    $\\sigma(x,p,\\omega) = 0$ for the minimally augmented Hopf
    formulation where $\\sigma$ is defined via \\[ \\begin{bmatrix}
    J+i\\omega M & a \\\\ b^H & 0 \\end{bmatrix}
    \\begin{bmatrix} v \\\\ \\sigma_1 \\end{bmatrix} =
    \\begin{bmatrix} 0 \\\\ n \\end{bmatrix}, \\] \\[
    \\begin{bmatrix} J^T-i\\omega M^T & b \\\\ a^H & 0
    \\end{bmatrix} \\begin{bmatrix} w \\\\ \\sigma_2
    \\end{bmatrix} = \\begin{bmatrix} 0 \\\\ n \\end{bmatrix},
    \\] \\[ \\sigma = w^H J+i\\omega M v/n \\] for any vectors
    $a$ and $b$ in $\\mathbb{C}^n$. Using these relationships, it is
    easy to show \\[ \\begin{split} \\sigma_x &= (w^H(J+i\\omega
    M)v)_x/n = w^H(J+i\\omega M)_x v/n \\\\ \\sigma_p &=
    (w^H(J+i\\omega M)v)_p/n = w^H(J+i\\omega M)_p v/n \\end{split}
    \\]

    The class is intialized via the hpfParams parameter list argument to
    the constructor. The parameters this class recognizes are: "Update
    Null Vectors Every Continuation Step" [bool] (default: true) - Flag
    indicating whether to update $a$ and $b$ vectors via $a = w$ and $b =
    v$ every continuation step

    "Update Null Vectors Every Nonlinear Iteration" [bool] (default:
    false) - Flag indicating whether to update $a$ and $b$ vectors via $a
    = w$ and $b = v$ every nonlinear iteration

    C++ includes: LOCA_Hopf_MinimallyAugmented_Constraint.H 
    """

    __swig_setmethods__ = {}
    for _s in [MultiContinuation.ConstraintInterfaceMVDX]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Constraint, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiContinuation.ConstraintInterfaceMVDX]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Constraint, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::Constraint self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hpfParams, Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > const & g, bool is_symmetric, Vector a_real, Vector a_imag, Vector b_real, Vector b_imag, int bif_param, double freq) -> Constraint
        __init__(LOCA::Hopf::MinimallyAugmented::Constraint self, Constraint source, NOX::CopyType type) -> Constraint

        LOCA::Hopf::MinimallyAugmented::Constraint::Constraint(const
        Constraint &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        if self.__class__ == Constraint:
            _self = None
        else:
            _self = self
        this = _MinimallyAugmented.new_Constraint(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_Constraint

    def setGroup(self, *args):
        """
        setGroup(Constraint self, Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > const & g)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::setGroup(const
        Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > &g)

        Set the group pointer.

        This method should be called when ever the constrained group is
        copied, since we don't explicitly copy the underlying group here. 
        """
        return _MinimallyAugmented.Constraint_setGroup(self, *args)


    def setFrequency(self, *args):
        """
        setFrequency(Constraint self, double freq)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::setFrequency(double freq)

        Set Hopf frequency. 
        """
        return _MinimallyAugmented.Constraint_setFrequency(self, *args)


    def getLeftNullVecReal(self, *args):
        """
        getLeftNullVecReal(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >

        Teuchos::RCP< const NOX::Abstract::Vector >
        LOCA::Hopf::MinimallyAugmented::Constraint::getLeftNullVecReal() const

        Returns real component of left null vector w. 
        """
        return _MinimallyAugmented.Constraint_getLeftNullVecReal(self, *args)


    def getLeftNullVecImag(self, *args):
        """
        getLeftNullVecImag(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >

        Teuchos::RCP< const NOX::Abstract::Vector >
        LOCA::Hopf::MinimallyAugmented::Constraint::getLeftNullVecImag() const

        Returns imaginary component of left null vector w. 
        """
        return _MinimallyAugmented.Constraint_getLeftNullVecImag(self, *args)


    def getRightNullVecReal(self, *args):
        """
        getRightNullVecReal(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >

        Teuchos::RCP< const NOX::Abstract::Vector >
        LOCA::Hopf::MinimallyAugmented::Constraint::getRightNullVecReal()
        const

        Returns real component of right null vector v. 
        """
        return _MinimallyAugmented.Constraint_getRightNullVecReal(self, *args)


    def getRightNullVecImag(self, *args):
        """
        getRightNullVecImag(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >

        Teuchos::RCP< const NOX::Abstract::Vector >
        LOCA::Hopf::MinimallyAugmented::Constraint::getRightNullVecImag()
        const

        Returns imaginary component of right null vector v. 
        """
        return _MinimallyAugmented.Constraint_getRightNullVecImag(self, *args)


    def getSigmaReal(self, *args):
        """
        getSigmaReal(Constraint self) -> double

        double
        LOCA::Hopf::MinimallyAugmented::Constraint::getSigmaReal() const

        Returns real component of sigma. 
        """
        return _MinimallyAugmented.Constraint_getSigmaReal(self, *args)


    def getSigmaImag(self, *args):
        """
        getSigmaImag(Constraint self) -> double

        double
        LOCA::Hopf::MinimallyAugmented::Constraint::getSigmaImag() const

        Returns imaginary component of sigma. 
        """
        return _MinimallyAugmented.Constraint_getSigmaImag(self, *args)


    def copy(self, *args):
        """
        copy(Constraint self, ConstraintInterface source)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::copy(const
        LOCA::MultiContinuation::ConstraintInterface &source)

        Copy. 
        """
        return _MinimallyAugmented.Constraint_copy(self, *args)


    def clone(self, *args):
        """
        clone(Constraint self, NOX::CopyType type) -> Teuchos::RCP< LOCA::MultiContinuation::ConstraintInterface >

        Teuchos::RCP<
        LOCA::MultiContinuation::ConstraintInterface >
        LOCA::Hopf::MinimallyAugmented::Constraint::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Cloning function. 
        """
        return _MinimallyAugmented.Constraint_clone(self, *args)


    def numConstraints(self, *args):
        """
        numConstraints(Constraint self) -> int

        int
        LOCA::Hopf::MinimallyAugmented::Constraint::numConstraints() const

        Return number of constraints. 
        """
        return _MinimallyAugmented.Constraint_numConstraints(self, *args)


    def setX(self, *args):
        """
        setX(Constraint self, Vector y)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::setX(const
        NOX::Abstract::Vector &y)

        Set the solution vector to y. 
        """
        return _MinimallyAugmented.Constraint_setX(self, *args)


    def setParam(self, *args):
        """
        setParam(Constraint self, int paramID, double val)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::setParam(int paramID,
        double val)

        Sets parameter indexed by paramID. 
        """
        return _MinimallyAugmented.Constraint_setParam(self, *args)


    def setParams(self, *args):
        """
        setParams(Constraint self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::setParams(const
        std::vector< int > &paramIDs, const
        NOX::Abstract::MultiVector::DenseMatrix &vals)

        Sets parameters indexed by paramIDs. 
        """
        return _MinimallyAugmented.Constraint_setParams(self, *args)


    def computeConstraints(self, *args):
        """
        computeConstraints(Constraint self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::Constraint::computeConstraints()

        Compute continuation constraint equations. 
        """
        return _MinimallyAugmented.Constraint_computeConstraints(self, *args)


    def computeDX(self, *args):
        """
        computeDX(Constraint self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::Constraint::computeDX()

        Compute derivative of constraints w.r.t. solution vector x. 
        """
        return _MinimallyAugmented.Constraint_computeDX(self, *args)


    def computeDP(self, *args):
        """
        computeDP(Constraint self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix & dgdp, bool isValidG) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::Constraint::computeDP(const
        std::vector< int > &paramIDs, NOX::Abstract::MultiVector::DenseMatrix
        &dgdp, bool isValidG)

        Compute derivative of constraints w.r.t. supplied parameters.

        The first column of dgdp should be filled with the constraint
        residuals $g$ if isValidG is false. If isValidG is true, then the dgdp
        contains $g$ on input. 
        """
        return _MinimallyAugmented.Constraint_computeDP(self, *args)


    def isConstraints(self, *args):
        """
        isConstraints(Constraint self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::Constraint::isConstraints() const

        Return true if constraint residuals are valid. 
        """
        return _MinimallyAugmented.Constraint_isConstraints(self, *args)


    def isDX(self, *args):
        """
        isDX(Constraint self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::Constraint::isDX() const

        Return true if derivatives of constraints w.r.t. x are valid. 
        """
        return _MinimallyAugmented.Constraint_isDX(self, *args)


    def getConstraints(self, *args):
        """
        getConstraints(Constraint self) -> NOX::Abstract::MultiVector::DenseMatrix const &

        const
        NOX::Abstract::MultiVector::DenseMatrix &
        LOCA::Hopf::MinimallyAugmented::Constraint::getConstraints() const

        Return constraint residuals. 
        """
        return _MinimallyAugmented.Constraint_getConstraints(self, *args)


    def getDX(self, *args):
        """
        getDX(Constraint self) -> MultiVector

        const
        NOX::Abstract::MultiVector *
        LOCA::Hopf::MinimallyAugmented::Constraint::getDX() const

        Return solution component of constraint derivatives. 
        """
        return _MinimallyAugmented.Constraint_getDX(self, *args)


    def isDXZero(self, *args):
        """
        isDXZero(Constraint self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::Constraint::isDXZero() const

        Return true if solution component of constraint derivatives is zero.

        """
        return _MinimallyAugmented.Constraint_isDXZero(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(Constraint self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Hopf::MinimallyAugmented::Constraint::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful.
        Here we update the $a$ and $b$ vectors to $w$ and $v$ respectively if
        requested. 
        """
        return _MinimallyAugmented.Constraint_postProcessContinuationStep(self, *args)


    def computeDOmega(self, *args):
        """
        computeDOmega(Constraint self, NOX::Abstract::MultiVector::DenseMatrix & domega) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::Constraint::computeDOmega(NOX::Abstract::MultiVector::DenseMatrix
        &domega)

        Compute derivative of sigma w.r.t. frequency omega. 
        """
        return _MinimallyAugmented.Constraint_computeDOmega(self, *args)

    def __disown__(self):
        self.this.disown()
        _MinimallyAugmented.disown_Constraint(self)
        return weakref_proxy(self)
Constraint_swigregister = _MinimallyAugmented.Constraint_swigregister
Constraint_swigregister(Constraint)

class AbstractGroup(MooreSpence.AbstractGroup):
    """


    Interface to underlying groups for Hopf calculations using the
    minimally augmented formulation.

    This abstract class provides the required interface for underlying
    groups to locate Hopfs using the minimally augmented Hopf (see
    LOCA::Hopf::MinimallyAugmented::ExtendedGroup for a description of the
    governing equations).

    This class is derived from the LOCA::Hopf::MooreSpence::AbstractGroup
    and declares several pure virtual methods to compute various
    derivatives of $w^H C e$ for a given $w = w_1 + i w_2$ and $e = y + i
    z$ where $C = J + i \\omega M$. Default implementations for the
    derivatives using finite differencing are implemented in the
    LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup.

    C++ includes: LOCA_Hopf_MinimallyAugmented_AbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [MooreSpence.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [MooreSpence.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::AbstractGroup self) -> AbstractGroup

        LOCA::Hopf::MinimallyAugmented::AbstractGroup::AbstractGroup()

        Default constructor. 
        """
        if self.__class__ == AbstractGroup:
            _self = None
        else:
            _self = self
        this = _MinimallyAugmented.new_AbstractGroup(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_AbstractGroup

    def applyComplexTranspose(self, *args):
        """
        applyComplexTranspose(AbstractGroup self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::AbstractGroup::applyComplexTranspose(const
        NOX::Abstract::Vector &input_real, const NOX::Abstract::Vector
        &input_imag, NOX::Abstract::Vector &result_real, NOX::Abstract::Vector
        &result_imag) const =0

        Computes conjugate-tranpose matrix vector product $ (J+i\\omega M)^H
        (x + iy) $. 
        """
        return _MinimallyAugmented.AbstractGroup_applyComplexTranspose(self, *args)


    def applyComplexTransposeMultiVector(self, *args):
        """
        applyComplexTransposeMultiVector(AbstractGroup self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::AbstractGroup::applyComplexTransposeMultiVector(const
        NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const =0

        Computes conjugate-tranpose matrix vector product $ (J+i\\omega M)^H
        (x + iy) $. 
        """
        return _MinimallyAugmented.AbstractGroup_applyComplexTransposeMultiVector(self, *args)


    def applyComplexTransposeInverseMultiVector(self, *args):
        """
        applyComplexTransposeInverseMultiVector(AbstractGroup self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::AbstractGroup::applyComplexTransposeInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const =0

        Solve $(J+i\\omega M)^H (x + iy) = a+ib$. 
        """
        return _MinimallyAugmented.AbstractGroup_applyComplexTransposeInverseMultiVector(self, *args)


    def computeDwtCeDp(self, *args):
        """
        computeDwtCeDp(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w1, Vector w2, Vector y, Vector z, double omega, NOX::Abstract::MultiVector::DenseMatrix & result_real, NOX::Abstract::MultiVector::DenseMatrix & result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::AbstractGroup::computeDwtCeDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &w1, const
        NOX::Abstract::Vector &w2, const NOX::Abstract::Vector &y, const
        NOX::Abstract::Vector &z, double omega,
        NOX::Abstract::MultiVector::DenseMatrix &result_real,
        NOX::Abstract::MultiVector::DenseMatrix &result_imag, bool isValid)=0

        Computes the derivative $\\partial w^H C e/\\partial p$, $w = w_1
        + i w_2$, $e = y + i z$, $C = J + i \\omega M$. 
        """
        return _MinimallyAugmented.AbstractGroup_computeDwtCeDp(self, *args)


    def computeDwtCeDx(self, *args):
        """
        computeDwtCeDx(AbstractGroup self, Vector w1, Vector w2, Vector y, Vector z, double omega, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::AbstractGroup::computeDwtCeDx(const
        NOX::Abstract::Vector &w1, const NOX::Abstract::Vector &w2, const
        NOX::Abstract::Vector &y, const NOX::Abstract::Vector &z, double
        omega, NOX::Abstract::Vector &result_real, NOX::Abstract::Vector
        &result_imag)=0

        Computes the derivative $\\frac{\\partial w^H C e}{\\partial
        x}$, $w = w_1 + i w_2$, $e = y + i z$, $C = J + i \\omega M$. 
        """
        return _MinimallyAugmented.AbstractGroup_computeDwtCeDx(self, *args)

    def __disown__(self):
        self.this.disown()
        _MinimallyAugmented.disown_AbstractGroup(self)
        return weakref_proxy(self)
AbstractGroup_swigregister = _MinimallyAugmented.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class FiniteDifferenceGroup(AbstractGroup, MooreSpence.FiniteDifferenceGroup):
    """


    Concrete class that provides concrete implementations of the
    derivative computation methods of the
    LOCA::Hopf::MinimallyAugmented::AbstractGroup using first-order finite
    differencing.

    The finite-differencing calculations are actually implemented by the
    LOCA::DerivUtils class, and a custom DerivUtils object can be passed
    through the constructor of this class. However, in the future the
    calculations encapsulated in the DerivUtils class may be incorporated
    directly into this class and other finite- differencing child classes.

    C++ includes: LOCA_Hopf_MinimallyAugmented_FiniteDifferenceGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [AbstractGroup, MooreSpence.FiniteDifferenceGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup, MooreSpence.FiniteDifferenceGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup self) -> FiniteDifferenceGroup
        __init__(LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup self, FiniteDifferenceGroup source, NOX::CopyType type) -> FiniteDifferenceGroup

        LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup::FiniteDifferenceGroup(const
        FiniteDifferenceGroup &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        if self.__class__ == FiniteDifferenceGroup:
            _self = None
        else:
            _self = self
        this = _MinimallyAugmented.new_FiniteDifferenceGroup(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_FiniteDifferenceGroup

    def computeDwtCeDp(self, *args):
        """
        computeDwtCeDp(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w1, Vector w2, Vector y, Vector x, double omega, NOX::Abstract::MultiVector::DenseMatrix & result_real, NOX::Abstract::MultiVector::DenseMatrix & result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup::computeDwtCeDp(const
        std::vector< int > &paramIDs, const NOX::Abstract::Vector &w1, const
        NOX::Abstract::Vector &w2, const NOX::Abstract::Vector &y, const
        NOX::Abstract::Vector &x, double omega,
        NOX::Abstract::MultiVector::DenseMatrix &result_real,
        NOX::Abstract::MultiVector::DenseMatrix &result_imag, bool isValid)

        Computes the derivative $\\partial w^TCe/\\partial p$.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDwtCeDp() method of the passed
        LOCA::DerivUtils object. 
        """
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtCeDp(self, *args)


    def computeDwtCeDx(self, *args):
        """
        computeDwtCeDx(FiniteDifferenceGroup self, Vector w1, Vector w2, Vector y, Vector z, double omega, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup::computeDwtCeDx(const
        NOX::Abstract::Vector &w1, const NOX::Abstract::Vector &w2, const
        NOX::Abstract::Vector &y, const NOX::Abstract::Vector &z, double
        omega, NOX::Abstract::Vector &result_real, NOX::Abstract::Vector
        &result_imag)

        Computes the derivative $\\frac{\\partial w^TCe}{\\partial x}$.

        The calculation is implemented by calling the corresponding
        LOCA::DerivUtils::computeDwtCeDx() method of the passed
        LOCA::DerivUtils object. 
        """
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtCeDx(self, *args)

    def __disown__(self):
        self.this.disown()
        _MinimallyAugmented.disown_FiniteDifferenceGroup(self)
        return weakref_proxy(self)
FiniteDifferenceGroup_swigregister = _MinimallyAugmented.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

class ExtendedGroup(Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup):
    """


    A group representing the minimally augemented Hopf equations.

    The LOCA::Hopf::MinimallyAugmented::ExtendedGroup is a concrete
    implementation of the NOX::Abstract::Group,
    LOCA::MultiContinuation::AbstractGroup and
    LOCA::Extended::MultiAbstractGroup that defines the following extended
    set of equations that are regular at a generic Hopf: \\[ G(z) =
    \\left[ \\begin{array}{c} F(x,p)\\\\ \\sigma \\end{array}
    \\right] = 0 \\] where $z = [x, p, \\omega]\\in\\Re^{n+2}$,
    $x$ is the solution vector, $p$ is the bifurcation parameter,
    $\\omega$ is the Hopf frequency and $\\sigma\\in\\Re$ is a
    measure of the singularity of $J+i\\omega M$ and is defined via
    \\[ \\begin{bmatrix} J+i\\omega M & a \\\\ b^H & 0
    \\end{bmatrix} \\begin{bmatrix} v \\\\ \\sigma_1
    \\end{bmatrix} = \\begin{bmatrix} 0 \\\\ n \\end{bmatrix},
    \\] \\[ \\begin{bmatrix} J^T-i\\omega M^T & b \\\\ a^H & 0
    \\end{bmatrix} \\begin{bmatrix} w \\\\ \\sigma_2
    \\end{bmatrix} = \\begin{bmatrix} 0 \\\\ n \\end{bmatrix},
    \\] \\[ \\sigma = w^H J+i\\omega M v/n \\] for any vectors
    $a$ and $b$ in $\\mathbb{C}^n$. Using these relationships, it is
    easy to show \\[ \\begin{split} \\sigma_x &= (w^H(J+i\\omega
    M)v)_x/n = w^H(J+i\\omega M)_x v/n \\\\ \\sigma_p &=
    (w^H(J+i\\omega M)v)_p/n = w^H(J+i\\omega M)_p v/n \\end{split}
    \\]

    The group stores an underlying group of type
    LOCA::Hopf::MinimallyAugmented::AbstractGroup to represent the
    equations $F(x,p) = 0$ and to manipulate the underlying complex matrix
    $C = J+i\\omega M$. This interface defines methods for computing the
    derivatives $(w^H C v)_x$ and $(w^H C v)_p$. Since LOCA is not able to
    deal with complex vectors and matrices directly, the real-equivalent
    formulation is used for all complex calculations.

    This class implements all of the NOX::Abstract::Group,
    LOCA::MultiContinuation::AbstractGroup, and
    LOCA::Extended::MultiAbstractGroup methods for this extended set of
    equations and therefore is a complete group which can be passed to
    most NOX solvers to locate a single pitchfork or to the LOCA::Stepper
    to compute a family of pitchforks in a second parameter.

    The class is intialized via the hpfParams parameter list argument to
    the constructor. The parameters this class recognizes are:
    "Bifurcation Parameter" [string] (Must be supplied) - Name of the
    bifurcation parameter $p$

    "Initial Frequency" [double] (Must be supplied) Initial guess for
    the Hopf frequency $\\omega$.

    "Bordered Solver Method" [string] (default "Bordering") Method for
    solving bordered systems of equations. See
    LOCA::BorderedSolver::Factory for a description.

    "Symmetric Jacobian" [bool] (default: false) - Flag indicating
    whether Jacobian matrix $J$ is symmetric, in which case we force $a =
    b$ and therefore the second tranpose solve for $w$ is unnecessary

    "Initial Null Vector Compuation" [string] (default: "User
    Provided") - Method to compute initial $a$ and $b$ vectors. Valid
    choices are: "User Provided" - Initial vectors are provided in the
    parameter list, in which case the following parameters are relevant:
    "Initial Real A Vector" [Teuchos::RCP<NOX::Abstract::Vector>] (Must
    be supplied) - Vector storing initial value for the real component of
    the $a$ vector

    "Initial Imaginary A Vector" [Teuchos::RCP<NOX::Abstract::Vector>]
    (Must be supplied) - Vector storing initial value for the imaginary
    component of the $a$ vector

    "Initial Real B Vector" [Teuchos::RCP<NOX::Abstract::Vector>] (Must
    be supplied for nonsymmetric Jacobians) - Vector storing initial value
    for the real component of the $b$ vector

    "Initial Imaginary B Vector" [Teuchos::RCP<NOX::Abstract::Vector>]
    (Must be supplied) - Vector storing initial value for the imaginary
    component of the $b$ vector

    "Solve df/dp" - Compute $a = J^{-T}df/dp$ and $b = J^{-1} df/dp$
    where $p$ is the bifurcation parameter.

    "Update Null Vectors Every Continuation Step" [bool] (default: true)
    - Flag indicating whether to update $a$ and $b$ vectors via $a = w$
    and $b = v$ every continuation step

    "Update Null Vectors Every Nonlinear Iteration" [bool] (default:
    false) - Flag indicating whether to update $a$ and $b$ vectors via $a
    = w$ and $b = v$ every nonlinear iteration

    C++ includes: LOCA_Hopf_MinimallyAugmented_ExtendedGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::ExtendedGroup self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hpfParams, Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > const & grp) -> ExtendedGroup
        __init__(LOCA::Hopf::MinimallyAugmented::ExtendedGroup self, ExtendedGroup source, NOX::CopyType type) -> ExtendedGroup

        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::ExtendedGroup(const
        ExtendedGroup &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _MinimallyAugmented.new_ExtendedGroup(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_ExtendedGroup

    def getBifParam(self, *args):
        """
        getBifParam(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getBifParam() const

        Get bifurcation parameter. 
        """
        return _MinimallyAugmented.ExtendedGroup_getBifParam(self, *args)


    def clone(self, *args):
        """
        clone(ExtendedGroup self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >

        Teuchos::RCP<
        NOX::Abstract::Group >
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Clone function. 
        """
        return _MinimallyAugmented.ExtendedGroup_clone(self, *args)


    def setX(self, *args):
        """
        setX(ExtendedGroup self, Vector y)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::setX(const
        NOX::Abstract::Vector &y)

        Set the solution vector to y. 
        """
        return _MinimallyAugmented.ExtendedGroup_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(ExtendedGroup self, Group g, Vector d, double step)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeX(const
        NOX::Abstract::Group &g, const NOX::Abstract::Vector &d, double step)

        Compute and return solution vector, x, where this.x = grp.x + step *
        d. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeX(self, *args)


    def computeF(self, *args):
        """
        computeF(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeF()

        Compute extended continuation equations. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeJacobian()

        Compute extended continuation jacobian. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """
        computeGradient(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeGradient()

        Gradient is not defined for this system. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeGradient(self, *args)


    def computeNewton(self, *args):
        """
        computeNewton(ExtendedGroup self, ParameterList params) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeNewton(Teuchos::ParameterList
        &params)

        Compute Newton direction for extended continuation system. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(ExtendedGroup self, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::applyJacobian(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Applies Jacobian for extended system. 
        """
        return _MinimallyAugmented.ExtendedGroup_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(ExtendedGroup self, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::applyJacobianTranspose(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Jacobian transpose not defined for this system. 
        """
        return _MinimallyAugmented.ExtendedGroup_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(ExtendedGroup self, ParameterList params, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::applyJacobianInverse(Teuchos::ParameterList
        &params, const NOX::Abstract::Vector &input, NOX::Abstract::Vector
        &result) const

        Applies Jacobian inverse for extended system. 
        """
        return _MinimallyAugmented.ExtendedGroup_applyJacobianInverse(self, *args)


    def applyJacobianMultiVector(self, *args):
        """
        applyJacobianMultiVector(ExtendedGroup self, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::applyJacobianMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Applies Jacobian for extended system. 
        """
        return _MinimallyAugmented.ExtendedGroup_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """
        applyJacobianTransposeMultiVector(ExtendedGroup self, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::applyJacobianTransposeMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Jacobian transpose not defined for this system. 
        """
        return _MinimallyAugmented.ExtendedGroup_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """
        applyJacobianInverseMultiVector(ExtendedGroup self, ParameterList params, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::applyJacobianInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const

        Applies Jacobian inverse for extended system. 
        """
        return _MinimallyAugmented.ExtendedGroup_applyJacobianInverseMultiVector(self, *args)


    def isF(self, *args):
        """
        isF(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isF() const

        Return true if extended residual is valid. 
        """
        return _MinimallyAugmented.ExtendedGroup_isF(self, *args)


    def isJacobian(self, *args):
        """
        isJacobian(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isJacobian() const

        Return true if the extended Jacobian is valid. 
        """
        return _MinimallyAugmented.ExtendedGroup_isJacobian(self, *args)


    def isGradient(self, *args):
        """
        isGradient(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isGradient() const

        Always returns false. 
        """
        return _MinimallyAugmented.ExtendedGroup_isGradient(self, *args)


    def isNewton(self, *args):
        """
        isNewton(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isNewton() const

        Return true if the extended Newton direction is valid. 
        """
        return _MinimallyAugmented.ExtendedGroup_isNewton(self, *args)


    def getX(self, *args):
        """
        getX(ExtendedGroup self) -> Vector

        const
        NOX::Abstract::Vector &
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getX() const

        Return extended solution vector. 
        """
        return _MinimallyAugmented.ExtendedGroup_getX(self, *args)


    def getF(self, *args):
        """
        getF(ExtendedGroup self) -> Vector

        const
        NOX::Abstract::Vector &
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getF() const

        Return extended residual. 
        """
        return _MinimallyAugmented.ExtendedGroup_getF(self, *args)


    def getNormF(self, *args):
        """
        getNormF(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getNormF() const

        Return 2-norm of extended residual. 
        """
        return _MinimallyAugmented.ExtendedGroup_getNormF(self, *args)


    def getGradient(self, *args):
        """
        getGradient(ExtendedGroup self) -> Vector

        const
        NOX::Abstract::Vector &
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getGradient() const

        Gradient is never valid. 
        """
        return _MinimallyAugmented.ExtendedGroup_getGradient(self, *args)


    def getNewton(self, *args):
        """
        getNewton(ExtendedGroup self) -> Vector

        const
        NOX::Abstract::Vector &
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getNewton() const

        Return extended Newton direction. 
        """
        return _MinimallyAugmented.ExtendedGroup_getNewton(self, *args)


    def getNormNewtonSolveResidual(self, *args):
        """
        getNormNewtonSolveResidual(ExtendedGroup self) -> double

        double
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getNormNewtonSolveResidual()
        const

        Returns 2-norm of extended Newton solve residual. 
        """
        return _MinimallyAugmented.ExtendedGroup_getNormNewtonSolveResidual(self, *args)


    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getUnderlyingGroup()

        Return underlying group. 
        """
        return _MinimallyAugmented.ExtendedGroup_getUnderlyingGroup(self, *args)


    def copy(self, *args):
        """
        copy(ExtendedGroup self, Group source)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::copy(const
        NOX::Abstract::Group &source)

        Assignment operator. 
        """
        return _MinimallyAugmented.ExtendedGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """
        setParamsMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::setParamsMulti(const
        std::vector< int > &paramIDs, const
        NOX::Abstract::MultiVector::DenseMatrix &vals)

        Set parameters indexed by (integer) paramIDs. 
        """
        return _MinimallyAugmented.ExtendedGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """
        setParams(ExtendedGroup self, LOCA::ParameterVector const & p)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::setParams(const
        ParameterVector &p)

        Set the parameter vector in the group to p (pVector = p). 
        """
        return _MinimallyAugmented.ExtendedGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(ExtendedGroup self, int paramID, double val)
        setParam(ExtendedGroup self, std::string paramID, double val)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::setParam(std::string
        paramID, double val)

        Set parameter indexed by (std::string) paramID. 
        """
        return _MinimallyAugmented.ExtendedGroup_setParam(self, *args)


    def getParams(self, *args):
        """
        getParams(ExtendedGroup self) -> LOCA::ParameterVector const &

        const
        LOCA::ParameterVector &
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getParams() const

        Return a const reference to the ParameterVector owned by the group. 
        """
        return _MinimallyAugmented.ExtendedGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(ExtendedGroup self, int paramID) -> double
        getParam(ExtendedGroup self, std::string paramID) -> double

        double
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getParam(std::string
        paramID) const

        Return copy of parameter indexed by (std::string) paramID. 
        """
        return _MinimallyAugmented.ExtendedGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """
        computeDfDpMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeDfDpMulti(const
        std::vector< int > &paramIDs, NOX::Abstract::MultiVector &dfdp, bool
        isValidF)

        Compute $\\partial F/\\partial p$ for each parameter $p$ indexed
        by paramIDs. The first column of dfdp holds F, which is valid if
        isValidF is true. Otherwise F must be computed. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. 
        """
        return _MinimallyAugmented.ExtendedGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. 
        """
        return _MinimallyAugmented.ExtendedGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """
        projectToDraw(ExtendedGroup self, Vector x, double * px)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::projectToDraw(const
        NOX::Abstract::Vector &x, double *px) const

        Projects solution to a few scalars for multiparameter continuation. 
        """
        return _MinimallyAugmented.ExtendedGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """
        projectToDrawDimension(ExtendedGroup self) -> int

        int
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::projectToDrawDimension()
        const

        Returns the dimension of the project to draw array. 
        """
        return _MinimallyAugmented.ExtendedGroup_projectToDrawDimension(self, *args)


    def computeScaledDotProduct(self, *args):
        """
        computeScaledDotProduct(ExtendedGroup self, Vector a, Vector b) -> double

        double
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::computeScaledDotProduct(const
        NOX::Abstract::Vector &a, const NOX::Abstract::Vector &b) const

        Compute a scaled dot product. 
        """
        return _MinimallyAugmented.ExtendedGroup_computeScaledDotProduct(self, *args)


    def printSolution(self, *args):
        """
        printSolution(ExtendedGroup self, double const conParam)
        printSolution(ExtendedGroup self, Vector x, double const conParam)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::printSolution(const
        NOX::Abstract::Vector &x, const double conParam) const

        Function to print out a vector and parameter after successful step. 
        """
        return _MinimallyAugmented.ExtendedGroup_printSolution(self, *args)


    def scaleVector(self, *args):
        """
        scaleVector(ExtendedGroup self, Vector x)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::scaleVector(NOX::Abstract::Vector
        &x) const

        Scales a vector using scaling vector. 
        """
        return _MinimallyAugmented.ExtendedGroup_scaleVector(self, *args)


    def getBorderedWidth(self, *args):
        """
        getBorderedWidth(ExtendedGroup self) -> int

        int
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getBorderedWidth()
        const

        Return the total width of the bordered rows/columns. 
        """
        return _MinimallyAugmented.ExtendedGroup_getBorderedWidth(self, *args)


    def getUnborderedGroup(self, *args):
        """
        getUnborderedGroup(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Group const >

        Teuchos::RCP< const NOX::Abstract::Group >
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::getUnborderedGroup()
        const

        Get bottom-level unbordered group. 
        """
        return _MinimallyAugmented.ExtendedGroup_getUnborderedGroup(self, *args)


    def isCombinedAZero(self, *args):
        """
        isCombinedAZero(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isCombinedAZero() const

        Indicates whether combined A block is zero. 
        """
        return _MinimallyAugmented.ExtendedGroup_isCombinedAZero(self, *args)


    def isCombinedBZero(self, *args):
        """
        isCombinedBZero(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isCombinedBZero() const

        Indicates whether combined B block is zero. 
        """
        return _MinimallyAugmented.ExtendedGroup_isCombinedBZero(self, *args)


    def isCombinedCZero(self, *args):
        """
        isCombinedCZero(ExtendedGroup self) -> bool

        bool
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::isCombinedCZero() const

        Indicates whether combined C block is zero. 
        """
        return _MinimallyAugmented.ExtendedGroup_isCombinedCZero(self, *args)


    def extractSolutionComponent(self, *args):
        """
        extractSolutionComponent(ExtendedGroup self, MultiVector v, MultiVector v_x)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::extractSolutionComponent(const
        NOX::Abstract::MultiVector &v, NOX::Abstract::MultiVector &v_x) const

        Given the vector v, extract the underlying solution component
        corresponding to the unbordered group. 
        """
        return _MinimallyAugmented.ExtendedGroup_extractSolutionComponent(self, *args)


    def extractParameterComponent(self, *args):
        """
        extractParameterComponent(ExtendedGroup self, bool use_transpose, MultiVector v, NOX::Abstract::MultiVector::DenseMatrix & v_p)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::extractParameterComponent(bool
        use_transpose, const NOX::Abstract::MultiVector &v,
        NOX::Abstract::MultiVector::DenseMatrix &v_p) const

        Given the vector v, extract the parameter components of all of the
        nested subvectors in v down to the solution component for the
        unbordered group. 
        """
        return _MinimallyAugmented.ExtendedGroup_extractParameterComponent(self, *args)


    def loadNestedComponents(self, *args):
        """
        loadNestedComponents(ExtendedGroup self, MultiVector v_x, NOX::Abstract::MultiVector::DenseMatrix const & v_p, MultiVector v)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::loadNestedComponents(const
        NOX::Abstract::MultiVector &v_x, const
        NOX::Abstract::MultiVector::DenseMatrix &v_p,
        NOX::Abstract::MultiVector &v) const

        Given the solution component v_x and combined parameter components
        v_p, distribute these components through the nested sub-vectors in v.

        """
        return _MinimallyAugmented.ExtendedGroup_loadNestedComponents(self, *args)


    def fillA(self, *args):
        """
        fillA(ExtendedGroup self, MultiVector A)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::fillA(NOX::Abstract::MultiVector
        &A) const

        Fill the combined A block as described above. 
        """
        return _MinimallyAugmented.ExtendedGroup_fillA(self, *args)


    def fillB(self, *args):
        """
        fillB(ExtendedGroup self, MultiVector B)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::fillB(NOX::Abstract::MultiVector
        &B) const

        Fill the combined B block as described above. 
        """
        return _MinimallyAugmented.ExtendedGroup_fillB(self, *args)


    def fillC(self, *args):
        """
        fillC(ExtendedGroup self, NOX::Abstract::MultiVector::DenseMatrix & C)

        void
        LOCA::Hopf::MinimallyAugmented::ExtendedGroup::fillC(NOX::Abstract::MultiVector::DenseMatrix
        &C) const

        Fill the combined C block as described above. 
        """
        return _MinimallyAugmented.ExtendedGroup_fillC(self, *args)

ExtendedGroup_swigregister = _MinimallyAugmented.ExtendedGroup_swigregister
ExtendedGroup_swigregister(ExtendedGroup)

# This file is compatible with both classic and new-style classes.


