# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Homotopy is the python interface to namespace Homotopy
of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Homotopy is to provide groups that allow for
Homotopy to be applied.  The python version of LOCA.Homotopy supports
the following classes:

    * Group          - LOCA's Homotopy algorithm
    * AbstractGroup  - Interface to underlying groups for homotopy calculations
    * DeflatedGroup  - LOCA's deflated Homotopy algorithm

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Homotopy')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Homotopy')
    _Homotopy = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Homotopy', [dirname(__file__)])
        except ImportError:
            import _Homotopy
            return _Homotopy
        try:
            _mod = imp.load_module('_Homotopy', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Homotopy = swig_import_helper()
    del swig_import_helper
else:
    import _Homotopy
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import MultiContinuation
import Extended
import BorderedSystem
class Group(MultiContinuation.AbstractGroup, Extended.MultiAbstractGroup):
    """


    LOCA's Homotopy Algorithm.

    The HomotopyGroup is a concrete implementation of the
    LOCA::Continuation::AbstractGroup that modifies the set of nonlinear
    equations to be solved to allow for Homotopy to be applied to the
    system. This object should be used in conjunction with the
    LOCA::Stepper object to drive the continuation. This algorithm solves
    a system of nonlinear equations supplied by the user ( $ F(x) $)
    through continuation. An artificial parameter $ \\lambda $ is used
    to control the continuation. The idea is to solve a simple equation
    starting at $ \\lambda $ = 0 and, using the solution from the
    previous step, solve systems of equations that gets progressively
    closer to the true system of interest ( at $ \\lambda $ = 1.0 we
    recover the original equations $ F(x) $). By constraining the
    definition of $ g(x, \\lambda) $ and using artificial parameter
    contiuation, the continuation branch should be free of multiplicity
    and bifurcation phenomena.

    The modified system of equations, $ g(x, \\lambda) $, supplied by
    the HomotopyGroup is defined as:

    \\[ g(x, \\lambda) = \\lambda F(x) + (1.0 - \\lambda)(x - a)
    \\]

    where $x$ is the solution vector, $ \\lambda $ is an artificial
    parameter, $ F(x) $ is the set of nonlinear equations the user
    supplies, $ g(x) $ is the corresponding set of homotopy equations that
    LOCA will solve, and $ a $ is a random vector.

    This group requires the loca Stepper for continuation from $
    \\lambda $ = 0.0 (a simple set of equations to solve) to $
    \\lambda $ = 1.0 (the set of equations requested by the user, $ F(x)
    $). The Homotopy::Group will generate the Stepper parameter sublist in
    the parameter list that is passed in to the constructor. The user is
    free to modify this list (it sets default values) before passing it
    into the stepper object but should NOT change the starting and
    stopping values for the continuation parameter.

    References:

    ALGORITHM 652 HOMPACK: A Suite of Codes for Globally Convergent
    Homotopy Algorithms, Watson, L.T., Billups, S.C, and Morgan, A.P., ACM
    Transactions on Mathematical Software, Vol. 13, No. 3, September 1987,
    pp281-310.

    C++ includes: LOCA_Homotopy_Group.H 
    """

    __swig_setmethods__ = {}
    for _s in [MultiContinuation.AbstractGroup, Extended.MultiAbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiContinuation.AbstractGroup, Extended.MultiAbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Homotopy::Group self, ParameterList locaSublist, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Homotopy::AbstractGroup > const & g, double scaleRandom=1.0, double scaleInitialGuess=0.0) -> Group
        __init__(LOCA::Homotopy::Group self, ParameterList locaSublist, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Homotopy::AbstractGroup > const & g, Vector randomVector) -> Group
        __init__(LOCA::Homotopy::Group self, Group source, NOX::CopyType type) -> Group

        LOCA::Homotopy::Group::Group(const Group &source, NOX::CopyType
        type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _Homotopy.new_Group(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Homotopy.delete_Group

    def clone(self, *args):
        """
        clone(Group self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >

        Teuchos::RCP<
        NOX::Abstract::Group > LOCA::Homotopy::Group::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Cloning function. 
        """
        return _Homotopy.Group_clone(self, *args)


    def setX(self, *args):
        """
        setX(Group self, Vector y)

        void
        LOCA::Homotopy::Group::setX(const NOX::Abstract::Vector &y)

        Set the solution vector, x, to y. 
        """
        return _Homotopy.Group_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(Group self, Group g, Vector d, double step)

        void
        LOCA::Homotopy::Group::computeX(const NOX::Abstract::Group &g, const
        NOX::Abstract::Vector &d, double step)

        Compute this.x = grp.x + step * d. 
        """
        return _Homotopy.Group_computeX(self, *args)


    def computeF(self, *args):
        """
        computeF(Group self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType LOCA::Homotopy::Group::computeF()

        Compute the homotopy residual $g$. 
        """
        return _Homotopy.Group_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(Group self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::computeJacobian()

        Compute the Jacobian derivative of the homotopy residual $g$. 
        """
        return _Homotopy.Group_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """
        computeGradient(Group self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::computeGradient()

        Compute gradient of homotopy residual $g$. 
        """
        return _Homotopy.Group_computeGradient(self, *args)


    def computeNewton(self, *args):
        """
        computeNewton(Group self, ParameterList params) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::computeNewton(Teuchos::ParameterList &params)

        Compute Newton direction using applyJacobianInverse. 
        """
        return _Homotopy.Group_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::applyJacobian(const NOX::Abstract::Vector
        &input, NOX::Abstract::Vector &result) const

        Computes the homotopy Jacobian vector product. 
        """
        return _Homotopy.Group_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(Group self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::applyJacobianTranspose(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Computes the homotopy Jacobian-transpose vector product. 
        """
        return _Homotopy.Group_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(Group self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::applyJacobianInverse(Teuchos::ParameterList
        &params, const NOX::Abstract::Vector &input, NOX::Abstract::Vector
        &result) const

        Applies the inverse of the homotopy Jacobian matrix. 
        """
        return _Homotopy.Group_applyJacobianInverse(self, *args)


    def applyJacobianMultiVector(self, *args):
        """
        applyJacobianMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::applyJacobianMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Applies Jacobian for homotopy system. 
        """
        return _Homotopy.Group_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """
        applyJacobianTransposeMultiVector(Group self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::applyJacobianTransposeMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Applies Jacobian-transpose for homotopy system. 
        """
        return _Homotopy.Group_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """
        applyJacobianInverseMultiVector(Group self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::applyJacobianInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const

        Applies Jacobian inverse for homotopy system. 
        """
        return _Homotopy.Group_applyJacobianInverseMultiVector(self, *args)


    def isF(self, *args):
        """
        isF(Group self) -> bool

        bool
        LOCA::Homotopy::Group::isF() const

        Return true if the homotopy residual $g$ is valid. 
        """
        return _Homotopy.Group_isF(self, *args)


    def isJacobian(self, *args):
        """
        isJacobian(Group self) -> bool

        bool
        LOCA::Homotopy::Group::isJacobian() const

        Return true if the homotopy Jacobian is valid. 
        """
        return _Homotopy.Group_isJacobian(self, *args)


    def isGradient(self, *args):
        """
        isGradient(Group self) -> bool

        bool
        LOCA::Homotopy::Group::isGradient() const

        Return true if the homotopy gradient is valid. 
        """
        return _Homotopy.Group_isGradient(self, *args)


    def isNewton(self, *args):
        """
        isNewton(Group self) -> bool

        bool
        LOCA::Homotopy::Group::isNewton() const

        Return true if the homotopy Newton direction is valid. 
        """
        return _Homotopy.Group_isNewton(self, *args)


    def getX(self, *args):
        """
        getX(Group self) -> Vector

        const
        NOX::Abstract::Vector & LOCA::Homotopy::Group::getX() const

        Return homotopy solution vector $x$. 
        """
        return _Homotopy.Group_getX(self, *args)


    def getF(self, *args):
        """
        getF(Group self) -> Vector

        const
        NOX::Abstract::Vector & LOCA::Homotopy::Group::getF() const

        Return homotopy residual $g$. 
        """
        return _Homotopy.Group_getF(self, *args)


    def getNormF(self, *args):
        """
        getNormF(Group self) -> double

        double
        LOCA::Homotopy::Group::getNormF() const

        Return 2-norm of $g$. 
        """
        return _Homotopy.Group_getNormF(self, *args)


    def getGradient(self, *args):
        """
        getGradient(Group self) -> Vector

        const
        NOX::Abstract::Vector & LOCA::Homotopy::Group::getGradient() const

        Return homotopy gradient. 
        """
        return _Homotopy.Group_getGradient(self, *args)


    def getNewton(self, *args):
        """
        getNewton(Group self) -> Vector

        const
        NOX::Abstract::Vector & LOCA::Homotopy::Group::getNewton() const

        Return homotopy Newton direction. 
        """
        return _Homotopy.Group_getNewton(self, *args)


    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(Group self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(Group self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        LOCA::Homotopy::Group::getUnderlyingGroup()

        Return underlying group. 
        """
        return _Homotopy.Group_getUnderlyingGroup(self, *args)


    def copy(self, *args):
        """
        copy(Group self, Group source)

        void
        LOCA::Homotopy::Group::copy(const NOX::Abstract::Group &source)

        Assignment. 
        """
        return _Homotopy.Group_copy(self, *args)


    def setParamsMulti(self, *args):
        """
        setParamsMulti(Group self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        void
        LOCA::Homotopy::Group::setParamsMulti(const std::vector< int >
        &paramIDs, const NOX::Abstract::MultiVector::DenseMatrix &vals)

        Set parameters indexed by (integer) paramIDs. 
        """
        return _Homotopy.Group_setParamsMulti(self, *args)


    def setParams(self, *args):
        """
        setParams(Group self, LOCA::ParameterVector const & p)

        void
        LOCA::Homotopy::Group::setParams(const ParameterVector &p)

        Set the parameter vector in the group to p. 
        """
        return _Homotopy.Group_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(Group self, int paramID, double val)
        setParam(Group self, std::string paramID, double val)

        void
        LOCA::Homotopy::Group::setParam(std::string paramID, double val)

        Set parameter indexed by paramID. 
        """
        return _Homotopy.Group_setParam(self, *args)


    def getParams(self, *args):
        """
        getParams(Group self) -> LOCA::ParameterVector const &

        const
        LOCA::ParameterVector & LOCA::Homotopy::Group::getParams() const

        Return a const reference to the paramter vector owned by the group. 
        """
        return _Homotopy.Group_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(Group self, int paramID) -> double
        getParam(Group self, std::string paramID) -> double

        double
        LOCA::Homotopy::Group::getParam(std::string paramID) const

        Return copy of parameter indexed by paramID. 
        """
        return _Homotopy.Group_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """
        computeDfDpMulti(Group self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::Group::computeDfDpMulti(const std::vector< int >
        &paramIDs, NOX::Abstract::MultiVector &dfdp, bool isValidF)

        Compute $\\partial F/\\partial p$ for each parameter $p$ indexed
        by paramIDs. The first column of dfdp holds F, which is valid if
        isValidF is true. Otherwise F must be computed. 
        """
        return _Homotopy.Group_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(Group self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Homotopy::Group::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. 
        """
        return _Homotopy.Group_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(Group self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Homotopy::Group::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. 
        """
        return _Homotopy.Group_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """
        projectToDraw(Group self, Vector x, double * px)

        void
        LOCA::Homotopy::Group::projectToDraw(const NOX::Abstract::Vector &x,
        double *px) const

        Projects solution to a few scalars for multiparameter continuation. 
        """
        return _Homotopy.Group_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """
        projectToDrawDimension(Group self) -> int

        int LOCA::Homotopy::Group::projectToDrawDimension() const

        Returns the dimension of the project to draw array. 
        """
        return _Homotopy.Group_projectToDrawDimension(self, *args)


    def printSolution(self, *args):
        """
        printSolution(Group self, double const conParam)
        printSolution(Group self, Vector x_, double const conParam)

        void
        LOCA::Homotopy::Group::printSolution(const NOX::Abstract::Vector &x_,
        const double conParam) const

        Function to print out solution and continuation parameter after
        successful continuation step. 
        """
        return _Homotopy.Group_printSolution(self, *args)

Group_swigregister = _Homotopy.Group_swigregister
Group_swigregister(Group)

class AbstractGroup(MultiContinuation.AbstractGroup):
    """


    Interface to underlying groups for homotopy calculations.

    This abstract class provides an interface for a homotopy technique for
    solving nonlinear equations. See LOCA::Homotopy::Group for a
    description of the technique used. This class provides a single pure
    virtual method, augmentJacobianForHomotopy(), which scales the
    diagonal of the Jacobian by a constant times the identity matrix.

    C++ includes: LOCA_Homotopy_AbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [MultiContinuation.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiContinuation.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Homotopy.delete_AbstractGroup

    def augmentJacobianForHomotopy(self, *args):
        """
        augmentJacobianForHomotopy(AbstractGroup self, double a, double b) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::AbstractGroup::augmentJacobianForHomotopy(double a,
        double b)=0

        Replace Jacobian $J$ by $aJ+bI$ where $I$ is the identity matrix. 
        """
        return _Homotopy.AbstractGroup_augmentJacobianForHomotopy(self, *args)

AbstractGroup_swigregister = _Homotopy.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class DeflatedGroup(Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup):
    """


    LOCA's Homotopy Algorithm.

    The HomotopyGroup is a concrete implementation of the
    LOCA::Continuation::AbstractGroup that modifies the set of nonlinear
    equations to be solved to allow for Homotopy to be applied to the
    system. This object should be used in conjunction with the
    LOCA::Stepper object to drive the continuation. This algorithm solves
    a system of nonlinear equations supplied by the user ( $ F(x) $)
    through continuation. An artificial parameter $ \\lambda $ is used
    to control the continuation. The idea is to solve a simple equation
    starting at $ \\lambda $ = 0 and, using the solution from the
    previous step, solve systems of equations that gets progressively
    closer to the true system of interest ( at $ \\lambda $ = 1.0 we
    recover the original equations $ F(x) $). By constraining the
    definition of $ g(x, \\lambda) $ and using artificial parameter
    contiuation, the continuation branch should be free of multiplicity
    and bifurcation phenomena.

    The modified system of equations, $ g(x, \\lambda) $, supplied by
    the HomotopyGroup is defined as:

    \\[ g(x, \\lambda) = \\lambda F(x) + (1.0 - \\lambda)(x -
    a)(S) \\]

    where $x$ is the solution vector, $ \\lambda $ is an artificial
    parameter, $ F(x) $ is the set of nonlinear equations the user
    supplies, $ g(x) $ is the corresponding set of homotopy equations that
    LOCA will solve, $ a $ is a random vector, and $ S $ is a scaling
    factor used to switch sign of the last term (typically valued 1.0 or
    -1.0).

    This group requires the loca Stepper for continuation from $
    \\lambda $ = 0.0 (a simple set of equations to solve) to $
    \\lambda $ = 1.0 (the set of equations requested by the user, $ F(x)
    $). The Homotopy::Group will generate the Stepper parameter sublist in
    the parameter list that is passed in to the constructor. The user is
    free to modify this list (it sets default values) before passing it
    into the stepper object but should NOT change the starting and
    stopping values for the continuation parameter.

    References:

    ALGORITHM 652 HOMPACK: A Suite of Codes for Globally Convergent
    Homotopy Algorithms, Watson, L.T., Billups, S.C, and Morgan, A.P., ACM
    Transactions on Mathematical Software, Vol. 13, No. 3, September 1987,
    pp281-310.

    C++ includes: LOCA_Homotopy_DeflatedGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DeflatedGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DeflatedGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Homotopy::DeflatedGroup self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< Teuchos::ParameterList > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hParams, Teuchos::RCP< LOCA::Homotopy::AbstractGroup > const & grp, Teuchos::RCP< NOX::Abstract::Vector const > const & start_vec, std::vector< Teuchos::RCP< NOX::Abstract::Vector const >,std::allocator< Teuchos::RCP< NOX::Abstract::Vector const > > > const & prev_solns, double const identity_sign=1.0) -> DeflatedGroup
        __init__(LOCA::Homotopy::DeflatedGroup self, DeflatedGroup source, NOX::CopyType type) -> DeflatedGroup

        LOCA::Homotopy::DeflatedGroup::DeflatedGroup(const DeflatedGroup
        &source, NOX::CopyType type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _Homotopy.new_DeflatedGroup(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Homotopy.delete_DeflatedGroup

    def getHomotopyParam(self, *args):
        """
        getHomotopyParam(DeflatedGroup self) -> double

        double LOCA::Homotopy::DeflatedGroup::getHomotopyParam() const

        Get homotopy parameter. 
        """
        return _Homotopy.DeflatedGroup_getHomotopyParam(self, *args)


    def clone(self, *args):
        """
        clone(DeflatedGroup self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >

        Teuchos::RCP< NOX::Abstract::Group >
        LOCA::Homotopy::DeflatedGroup::clone(NOX::CopyType type=NOX::DeepCopy)
        const

        Clone function. 
        """
        return _Homotopy.DeflatedGroup_clone(self, *args)


    def setX(self, *args):
        """
        setX(DeflatedGroup self, Vector y)

        void
        LOCA::Homotopy::DeflatedGroup::setX(const NOX::Abstract::Vector &y)

        Set the solution vector to y. 
        """
        return _Homotopy.DeflatedGroup_setX(self, *args)


    def computeX(self, *args):
        """
        computeX(DeflatedGroup self, Group g, Vector d, double step)

        void
        LOCA::Homotopy::DeflatedGroup::computeX(const NOX::Abstract::Group &g,
        const NOX::Abstract::Vector &d, double step)

        Compute and return solution vector, x, where this.x = grp.x + step *
        d. 
        """
        return _Homotopy.DeflatedGroup_computeX(self, *args)


    def computeF(self, *args):
        """
        computeF(DeflatedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::computeF()

        Compute extended continuation equations. 
        """
        return _Homotopy.DeflatedGroup_computeF(self, *args)


    def computeJacobian(self, *args):
        """
        computeJacobian(DeflatedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::computeJacobian()

        Compute extended continuation jacobian. 
        """
        return _Homotopy.DeflatedGroup_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """
        computeGradient(DeflatedGroup self) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::computeGradient()

        Gradient is not defined for this system. 
        """
        return _Homotopy.DeflatedGroup_computeGradient(self, *args)


    def computeNewton(self, *args):
        """
        computeNewton(DeflatedGroup self, ParameterList params) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::computeNewton(Teuchos::ParameterList
        &params)

        Compute Newton direction for extended continuation system. 
        """
        return _Homotopy.DeflatedGroup_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """
        applyJacobian(DeflatedGroup self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::applyJacobian(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Applies Jacobian for extended system. 
        """
        return _Homotopy.DeflatedGroup_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """
        applyJacobianTranspose(DeflatedGroup self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::applyJacobianTranspose(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Jacobian transpose not defined for this system. 
        """
        return _Homotopy.DeflatedGroup_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """
        applyJacobianInverse(DeflatedGroup self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::applyJacobianInverse(Teuchos::ParameterList
        &params, const NOX::Abstract::Vector &input, NOX::Abstract::Vector
        &result) const

        Applies Jacobian inverse for extended system. 
        """
        return _Homotopy.DeflatedGroup_applyJacobianInverse(self, *args)


    def applyJacobianMultiVector(self, *args):
        """
        applyJacobianMultiVector(DeflatedGroup self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::applyJacobianMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Applies Jacobian for extended system. 
        """
        return _Homotopy.DeflatedGroup_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """
        applyJacobianTransposeMultiVector(DeflatedGroup self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::applyJacobianTransposeMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Jacobian transpose not defined for this system. 
        """
        return _Homotopy.DeflatedGroup_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """
        applyJacobianInverseMultiVector(DeflatedGroup self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::applyJacobianInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const

        Applies Jacobian inverse for extended system. 
        """
        return _Homotopy.DeflatedGroup_applyJacobianInverseMultiVector(self, *args)


    def isF(self, *args):
        """
        isF(DeflatedGroup self) -> bool

        bool
        LOCA::Homotopy::DeflatedGroup::isF() const

        Return true if extended residual is valid. 
        """
        return _Homotopy.DeflatedGroup_isF(self, *args)


    def isJacobian(self, *args):
        """
        isJacobian(DeflatedGroup self) -> bool

        bool LOCA::Homotopy::DeflatedGroup::isJacobian() const

        Return true if the extended Jacobian is valid. 
        """
        return _Homotopy.DeflatedGroup_isJacobian(self, *args)


    def isGradient(self, *args):
        """
        isGradient(DeflatedGroup self) -> bool

        bool LOCA::Homotopy::DeflatedGroup::isGradient() const

        Always returns false. 
        """
        return _Homotopy.DeflatedGroup_isGradient(self, *args)


    def isNewton(self, *args):
        """
        isNewton(DeflatedGroup self) -> bool

        bool
        LOCA::Homotopy::DeflatedGroup::isNewton() const

        Return true if the extended Newton direction is valid. 
        """
        return _Homotopy.DeflatedGroup_isNewton(self, *args)


    def getX(self, *args):
        """
        getX(DeflatedGroup self) -> Vector

        const
        NOX::Abstract::Vector & LOCA::Homotopy::DeflatedGroup::getX() const

        Return extended solution vector. 
        """
        return _Homotopy.DeflatedGroup_getX(self, *args)


    def getF(self, *args):
        """
        getF(DeflatedGroup self) -> Vector

        const
        NOX::Abstract::Vector & LOCA::Homotopy::DeflatedGroup::getF() const

        Return extended residual. 
        """
        return _Homotopy.DeflatedGroup_getF(self, *args)


    def getNormF(self, *args):
        """
        getNormF(DeflatedGroup self) -> double

        double LOCA::Homotopy::DeflatedGroup::getNormF() const

        Return 2-norm of extended residual. 
        """
        return _Homotopy.DeflatedGroup_getNormF(self, *args)


    def getGradient(self, *args):
        """
        getGradient(DeflatedGroup self) -> Vector

        const NOX::Abstract::Vector &
        LOCA::Homotopy::DeflatedGroup::getGradient() const

        Gradient is never valid. 
        """
        return _Homotopy.DeflatedGroup_getGradient(self, *args)


    def getNewton(self, *args):
        """
        getNewton(DeflatedGroup self) -> Vector

        const NOX::Abstract::Vector &
        LOCA::Homotopy::DeflatedGroup::getNewton() const

        Return extended Newton direction. 
        """
        return _Homotopy.DeflatedGroup_getNewton(self, *args)


    def getNormNewtonSolveResidual(self, *args):
        """
        getNormNewtonSolveResidual(DeflatedGroup self) -> double

        double
        LOCA::Homotopy::DeflatedGroup::getNormNewtonSolveResidual() const

        Returns 2-norm of extended Newton solve residual. 
        """
        return _Homotopy.DeflatedGroup_getNormNewtonSolveResidual(self, *args)


    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(DeflatedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(DeflatedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup >
        LOCA::Homotopy::DeflatedGroup::getUnderlyingGroup()

        Return underlying group. 
        """
        return _Homotopy.DeflatedGroup_getUnderlyingGroup(self, *args)


    def copy(self, *args):
        """
        copy(DeflatedGroup self, Group source)

        void
        LOCA::Homotopy::DeflatedGroup::copy(const NOX::Abstract::Group
        &source)

        Assignment operator. 
        """
        return _Homotopy.DeflatedGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """
        setParamsMulti(DeflatedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        void LOCA::Homotopy::DeflatedGroup::setParamsMulti(const std::vector<
        int > &paramIDs, const NOX::Abstract::MultiVector::DenseMatrix &vals)

        Set parameters indexed by (integer) paramIDs. 
        """
        return _Homotopy.DeflatedGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """
        setParams(DeflatedGroup self, LOCA::ParameterVector const & p)

        void
        LOCA::Homotopy::DeflatedGroup::setParams(const ParameterVector &p)

        Set the parameter vector in the group to p (pVector = p). 
        """
        return _Homotopy.DeflatedGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(DeflatedGroup self, int paramID, double val)
        setParam(DeflatedGroup self, std::string paramID, double val)

        void
        LOCA::Homotopy::DeflatedGroup::setParam(std::string paramID, double
        val)

        Set parameter indexed by (std::string) paramID. 
        """
        return _Homotopy.DeflatedGroup_setParam(self, *args)


    def getParams(self, *args):
        """
        getParams(DeflatedGroup self) -> LOCA::ParameterVector const &

        const LOCA::ParameterVector &
        LOCA::Homotopy::DeflatedGroup::getParams() const

        Return a const reference to the ParameterVector owned by the group. 
        """
        return _Homotopy.DeflatedGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(DeflatedGroup self, int paramID) -> double
        getParam(DeflatedGroup self, std::string paramID) -> double

        double LOCA::Homotopy::DeflatedGroup::getParam(std::string paramID)
        const

        Return copy of parameter indexed by (std::string) paramID. 
        """
        return _Homotopy.DeflatedGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """
        computeDfDpMulti(DeflatedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Homotopy::DeflatedGroup::computeDfDpMulti(const std::vector< int
        > &paramIDs, NOX::Abstract::MultiVector &dfdp, bool isValidF)

        Compute $\\partial F/\\partial p$ for each parameter $p$ indexed
        by paramIDs. The first column of dfdp holds F, which is valid if
        isValidF is true. Otherwise F must be computed. 
        """
        return _Homotopy.DeflatedGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(DeflatedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Homotopy::DeflatedGroup::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. 
        """
        return _Homotopy.DeflatedGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(DeflatedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)

        void
        LOCA::Homotopy::DeflatedGroup::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. 
        """
        return _Homotopy.DeflatedGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """
        projectToDraw(DeflatedGroup self, Vector x, double * px)

        void LOCA::Homotopy::DeflatedGroup::projectToDraw(const
        NOX::Abstract::Vector &x, double *px) const

        Projects solution to a few scalars for multiparameter continuation. 
        """
        return _Homotopy.DeflatedGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """
        projectToDrawDimension(DeflatedGroup self) -> int

        int
        LOCA::Homotopy::DeflatedGroup::projectToDrawDimension() const

        Returns the dimension of the project to draw array. 
        """
        return _Homotopy.DeflatedGroup_projectToDrawDimension(self, *args)


    def computeScaledDotProduct(self, *args):
        """
        computeScaledDotProduct(DeflatedGroup self, Vector a, Vector b) -> double

        double
        LOCA::Homotopy::DeflatedGroup::computeScaledDotProduct(const
        NOX::Abstract::Vector &a, const NOX::Abstract::Vector &b) const

        Compute a scaled dot product. 
        """
        return _Homotopy.DeflatedGroup_computeScaledDotProduct(self, *args)


    def printSolution(self, *args):
        """
        printSolution(DeflatedGroup self, double const conParam)
        printSolution(DeflatedGroup self, Vector x, double const conParam)

        void LOCA::Homotopy::DeflatedGroup::printSolution(const
        NOX::Abstract::Vector &x, const double conParam) const

        Function to print out a vector and parameter after successful step. 
        """
        return _Homotopy.DeflatedGroup_printSolution(self, *args)


    def scaleVector(self, *args):
        """
        scaleVector(DeflatedGroup self, Vector x)

        void LOCA::Homotopy::DeflatedGroup::scaleVector(NOX::Abstract::Vector
        &x) const

        Scales a vector using scaling vector. 
        """
        return _Homotopy.DeflatedGroup_scaleVector(self, *args)


    def getBorderedWidth(self, *args):
        """
        getBorderedWidth(DeflatedGroup self) -> int

        int LOCA::Homotopy::DeflatedGroup::getBorderedWidth() const

        Return the total width of the bordered rows/columns. 
        """
        return _Homotopy.DeflatedGroup_getBorderedWidth(self, *args)


    def getUnborderedGroup(self, *args):
        """
        getUnborderedGroup(DeflatedGroup self) -> Teuchos::RCP< NOX::Abstract::Group const >

        Teuchos::RCP<
        const NOX::Abstract::Group >
        LOCA::Homotopy::DeflatedGroup::getUnborderedGroup() const

        Get bottom-level unbordered group. 
        """
        return _Homotopy.DeflatedGroup_getUnborderedGroup(self, *args)


    def isCombinedAZero(self, *args):
        """
        isCombinedAZero(DeflatedGroup self) -> bool

        bool LOCA::Homotopy::DeflatedGroup::isCombinedAZero() const

        Indicates whether combined A block is zero. 
        """
        return _Homotopy.DeflatedGroup_isCombinedAZero(self, *args)


    def isCombinedBZero(self, *args):
        """
        isCombinedBZero(DeflatedGroup self) -> bool

        bool LOCA::Homotopy::DeflatedGroup::isCombinedBZero() const

        Indicates whether combined B block is zero. 
        """
        return _Homotopy.DeflatedGroup_isCombinedBZero(self, *args)


    def isCombinedCZero(self, *args):
        """
        isCombinedCZero(DeflatedGroup self) -> bool

        bool LOCA::Homotopy::DeflatedGroup::isCombinedCZero() const

        Indicates whether combined C block is zero. 
        """
        return _Homotopy.DeflatedGroup_isCombinedCZero(self, *args)


    def extractSolutionComponent(self, *args):
        """
        extractSolutionComponent(DeflatedGroup self, MultiVector v, MultiVector v_x)

        void
        LOCA::Homotopy::DeflatedGroup::extractSolutionComponent(const
        NOX::Abstract::MultiVector &v, NOX::Abstract::MultiVector &v_x) const

        Given the vector v, extract the underlying solution component
        corresponding to the unbordered group. 
        """
        return _Homotopy.DeflatedGroup_extractSolutionComponent(self, *args)


    def extractParameterComponent(self, *args):
        """
        extractParameterComponent(DeflatedGroup self, bool use_transpose, MultiVector v, NOX::Abstract::MultiVector::DenseMatrix & v_p)

        void
        LOCA::Homotopy::DeflatedGroup::extractParameterComponent(bool
        use_transpose, const NOX::Abstract::MultiVector &v,
        NOX::Abstract::MultiVector::DenseMatrix &v_p) const

        Given the vector v, extract the parameter components of all of the
        nested subvectors in v down to the solution component for the
        unbordered group. 
        """
        return _Homotopy.DeflatedGroup_extractParameterComponent(self, *args)


    def loadNestedComponents(self, *args):
        """
        loadNestedComponents(DeflatedGroup self, MultiVector v_x, NOX::Abstract::MultiVector::DenseMatrix const & v_p, MultiVector v)

        void
        LOCA::Homotopy::DeflatedGroup::loadNestedComponents(const
        NOX::Abstract::MultiVector &v_x, const
        NOX::Abstract::MultiVector::DenseMatrix &v_p,
        NOX::Abstract::MultiVector &v) const

        Given the solution component v_x and combined parameter components
        v_p, distribute these components through the nested sub-vectors in v.

        """
        return _Homotopy.DeflatedGroup_loadNestedComponents(self, *args)


    def fillA(self, *args):
        """
        fillA(DeflatedGroup self, MultiVector A)

        void
        LOCA::Homotopy::DeflatedGroup::fillA(NOX::Abstract::MultiVector &A)
        const

        Fill the combined A block as described above. 
        """
        return _Homotopy.DeflatedGroup_fillA(self, *args)


    def fillB(self, *args):
        """
        fillB(DeflatedGroup self, MultiVector B)

        void
        LOCA::Homotopy::DeflatedGroup::fillB(NOX::Abstract::MultiVector &B)
        const

        Fill the combined B block as described above. 
        """
        return _Homotopy.DeflatedGroup_fillB(self, *args)


    def fillC(self, *args):
        """
        fillC(DeflatedGroup self, NOX::Abstract::MultiVector::DenseMatrix & C)

        void
        LOCA::Homotopy::DeflatedGroup::fillC(NOX::Abstract::MultiVector::DenseMatrix
        &C) const

        Fill the combined C block as described above. 
        """
        return _Homotopy.DeflatedGroup_fillC(self, *args)

DeflatedGroup_swigregister = _Homotopy.DeflatedGroup_swigregister
DeflatedGroup_swigregister(DeflatedGroup)

# This file is compatible with both classic and new-style classes.


