# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Extended is the python interface to namespace Extended
of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Extended is to provide classes that extend
NOX.Abstract classes to handle an arbitrary number of multi-vectors
and scalars.  The python version of LOCA.Extended supports the
following classes:

    * MultiVector         - Implemenatation of the NOX.Abstract.MultiVector
                            class for extended multi-vectors comprised of an
                            arbitrary number of multi-vectors and scalars
    * Vector              - Implemenatation of the NOX.Abstract.Vector class
                            for extended multi-vectors comprised of an
                            arbitrary number of multi-vectors and scalars
    * MultiAbstractGroup  - LOCA abstract interface for extended groups,
                            derived from the NOX.Abstract.Group, i.e., an
                            abstract interface for 'super' groups that have an
                            underlying group component

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Extended')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Extended')
    _Extended = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Extended', [dirname(__file__)])
        except ImportError:
            import _Extended
            return _Extended
        try:
            _mod = imp.load_module('_Extended', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Extended = swig_import_helper()
    del swig_import_helper
else:
    import _Extended
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
class MultiVector(PyTrilinos.NOX.Abstract.MultiVector):
    """


    Implemenatation of the NOX::Abstract::MultiVector class for extended
    multi-vectors comprised of an arbitrary number of multi-vectors and
    scalars.

    C++ includes: LOCA_Extended_MultiVector.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Extended::MultiVector self, MultiVector source, NOX::CopyType type) -> MultiVector
        __init__(LOCA::Extended::MultiVector self, MultiVector source, int nColumns) -> MultiVector
        __init__(LOCA::Extended::MultiVector self, MultiVector source, std::vector< int,std::allocator< int > > const & index, bool view) -> MultiVector

        LOCA::Extended::MultiVector::MultiVector(const MultiVector &source,
        const std::vector< int > &index, bool view)

        Copy constructor that creates a sub copy or view of the given
        multivector. 
        """
        this = _Extended.new_MultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Extended.delete_MultiVector

    def init(self, *args):
        """
        init(MultiVector self, double gamma) -> MultiVector

        NOX::Abstract::MultiVector & LOCA::Extended::MultiVector::init(double
        gamma)

        Initialize every element of this multi-vector with gamma. 
        """
        return _Extended.MultiVector_init(self, *args)


    def random(self, *args):
        """
        random(MultiVector self, bool useSeed=False, int seed=1) -> MultiVector

        NOX::Abstract::MultiVector & LOCA::Extended::MultiVector::random(bool
        useSeed=false, int seed=1)

        Initialize each element of this multi-vector with a random value. 
        """
        return _Extended.MultiVector_random(self, *args)


    def setBlock(self, *args):
        """
        setBlock(MultiVector self, MultiVector source, std::vector< int,std::allocator< int > > const & index) -> MultiVector
        setBlock(MultiVector self, MultiVector source, std::vector< int,std::allocator< int > > const & index) -> MultiVector

        NOX::Abstract::MultiVector &
        LOCA::Extended::MultiVector::setBlock(const MultiVector &source, const
        std::vector< int > &index) 
        """
        return _Extended.MultiVector_setBlock(self, *args)


    def augment(self, *args):
        """
        augment(MultiVector self, MultiVector source) -> MultiVector
        augment(MultiVector self, MultiVector source) -> MultiVector

        NOX::Abstract::MultiVector &
        LOCA::Extended::MultiVector::augment(const MultiVector &source) 
        """
        return _Extended.MultiVector_augment(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector self, double gamma) -> MultiVector

        NOX::Abstract::MultiVector & LOCA::Extended::MultiVector::scale(double
        gamma)

        Scale each element of this multivector by gamma. 
        """
        return _Extended.MultiVector_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector self, double alpha, MultiVector a, double gamma=0.0) -> MultiVector
        update(MultiVector self, double alpha, MultiVector a, double gamma=0.0) -> MultiVector
        update(MultiVector self, double alpha, MultiVector a, double beta, MultiVector b, double gamma=0.0) -> MultiVector
        update(MultiVector self, double alpha, MultiVector a, double beta, MultiVector b, double gamma=0.0) -> MultiVector
        update(MultiVector self, Teuchos::ETransp transb, double alpha, MultiVector a, NOX::Abstract::MultiVector::DenseMatrix const & b, double gamma=0.0) -> MultiVector
        update(MultiVector self, Teuchos::ETransp transb, double alpha, MultiVector a, NOX::Abstract::MultiVector::DenseMatrix const & b, double gamma=0.0) -> MultiVector

        NOX::Abstract::MultiVector &
        LOCA::Extended::MultiVector::update(Teuchos::ETransp transb, double
        alpha, const MultiVector &a, const
        NOX::Abstract::MultiVector::DenseMatrix &b, double gamma=0.0) 
        """
        return _Extended.MultiVector_update(self, *args)


    def clone(self, *args):
        """
        clone(MultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Extended::MultiVector::clone(int numvecs) const

        Creates a new multi-vector with numvecs columns. 
        """
        return _Extended.MultiVector_clone(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Extended::MultiVector::subCopy(const std::vector< int > &index)
        const

        Creates a new multi-vector with index.size() columns whose columns are
        copies of the columns of *this given by index. 
        """
        return _Extended.MultiVector_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Extended::MultiVector::subView(const std::vector< int > &index)
        const

        Creates a new multi-vector with index.size() columns that shares the
        columns of *this given by index. 
        """
        return _Extended.MultiVector_subView(self, *args)


    def norm(self, *args):
        """
        norm(MultiVector self, std::vector< double,std::allocator< double > > & result, NOX::Abstract::Vector::NormType type)

        void
        LOCA::Extended::MultiVector::norm(std::vector< double > &result,
        NOX::Abstract::Vector::NormType type=NOX::Abstract::Vector::TwoNorm)
        const

        Norm. 
        """
        return _Extended.MultiVector_norm(self, *args)


    def multiply(self, *args):
        """
        multiply(MultiVector self, double alpha, MultiVector y, NOX::Abstract::MultiVector::DenseMatrix & b)
        multiply(MultiVector self, double alpha, MultiVector y, NOX::Abstract::MultiVector::DenseMatrix & b)

        void
        LOCA::Extended::MultiVector::multiply(double alpha, const MultiVector
        &y, NOX::Abstract::MultiVector::DenseMatrix &b) const 
        """
        return _Extended.MultiVector_multiply(self, *args)


    def length(self, *args):
        """
        length(MultiVector self) -> NOX::size_type

        NOX::size_type LOCA::Extended::MultiVector::length() const

        Return the length of multi-vector. 
        """
        return _Extended.MultiVector_length(self, *args)


    def numVectors(self, *args):
        """
        numVectors(MultiVector self) -> int

        int
        LOCA::Extended::MultiVector::numVectors() const

        Return the number of vectors in the multi-vector. 
        """
        return _Extended.MultiVector_numVectors(self, *args)


    def _print(self, *args):
        """
        _print(MultiVector self, std::ostream & stream)

        void
        LOCA::Extended::MultiVector::print(std::ostream &stream) const

        Print the vector. This is meant for debugging purposes only. 
        """
        return _Extended.MultiVector__print(self, *args)


    def getMultiVector(self, *args):
        """
        getMultiVector(MultiVector self, int i) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getMultiVector(MultiVector self, int i) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Extended::MultiVector::getMultiVector(int i)

        Returns ref-count pointer to the ith multi-vector. 
        """
        return _Extended.MultiVector_getMultiVector(self, *args)


    def getScalars(self, *args):
        """
        getScalars(MultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getScalars(MultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >

        Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        LOCA::Extended::MultiVector::getScalars()

        Returns ref-count pointer to scalar matrix. 
        """
        return _Extended.MultiVector_getScalars(self, *args)


    def getScalarRows(self, *args):
        """
        getScalarRows(MultiVector self, int num_rows, int row) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getScalarRows(MultiVector self, int num_rows, int row) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >

        Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        LOCA::Extended::MultiVector::getScalarRows(int num_rows, int row)

        Returns ref-count pointer to num_rows rows of scalar matrix starting
        at row row. 
        """
        return _Extended.MultiVector_getScalarRows(self, *args)


    def getScalar(self, *args):
        """
        getScalar(MultiVector self, int i, int j) -> double const
        getScalar(MultiVector self, int i, int j) -> double &

        double
        & LOCA::Extended::MultiVector::getScalar(int i, int j)

        Returns reference to the scalar for row i, column j. 
        """
        return _Extended.MultiVector_getScalar(self, *args)


    def getVector(self, *args):
        """
        getVector(MultiVector self, int i) -> Teuchos::RCP< LOCA::Extended::Vector >
        getVector(MultiVector self, int i) -> Teuchos::RCP< LOCA::Extended::Vector const >

        Teuchos::RCP< const LOCA::Extended::Vector >
        LOCA::Extended::MultiVector::getVector(int i) const

        Return a const ref-count pointer to the i-th column of the multivector
        as an abstract vector. 
        """
        return _Extended.MultiVector_getVector(self, *args)


    def getNumScalarRows(self, *args):
        """
        getNumScalarRows(MultiVector self) -> int

        int LOCA::Extended::MultiVector::getNumScalarRows() const

        Returns number of scalars rows. 
        """
        return _Extended.MultiVector_getNumScalarRows(self, *args)


    def getNumMultiVectors(self, *args):
        """
        getNumMultiVectors(MultiVector self) -> int

        int LOCA::Extended::MultiVector::getNumMultiVectors() const

        Returns number of multi vectors. 
        """
        return _Extended.MultiVector_getNumMultiVectors(self, *args)

MultiVector_swigregister = _Extended.MultiVector_swigregister
MultiVector_swigregister(MultiVector)

class Vector(PyTrilinos.NOX.Abstract.Vector):
    """


    Implemenatation of the NOX::Abstract::Vector class for extended
    vectors comprised of an arbitrary number of vectors and scalars.

    Many continuation and bifurcation calculations can be viewed as the
    solution to an extended set of equations. For example, calculating a
    turning point can be viewed as computing a solution to $G(z) = 0$
    where $z = [x, n, p]\\in\\Re^{2n+1}$ and \\[ G(z) = \\left[
    \\begin{array}{c} F(x,p) \\\\ Jn \\\\ n^Tn-1 \\end{array}
    \\right] \\] The extended vector $z$ is comprised of the two
    vectors $x$ and $n$ as well as the scalar $p$. This class provides an
    implementation of the NOX::Abstract::Vector interface for such
    extended vectors. It stores an array of pointers to
    NOX::Abstract::Vector's as well as an array of scalars using the STL
    vector class.

    The implementations of the NOX::Abstract::Vector methods are defined
    in terms of the implementations of each stored abstract vector.

    C++ includes: LOCA_Extended_Vector.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Extended::Vector self, Vector source, NOX::CopyType type) -> Vector

        LOCA::Extended::Vector::Vector(const Vector &source, NOX::CopyType
        type=NOX::DeepCopy)

        Copy constructor. 
        """
        this = _Extended.new_Vector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Extended.delete_Vector

    def clone(self, *args):
        """
        clone(Vector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP<
        NOX::Abstract::Vector > LOCA::Extended::Vector::clone(NOX::CopyType
        type=NOX::DeepCopy) const

        Clone function. Applies clone to each stored vector. 
        """
        return _Extended.Vector_clone(self, *args)


    def createMultiVector(self, *args):
        """
        createMultiVector(Vector self, NOX::Abstract::Vector const *const * vecs, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        createMultiVector(Vector self, int numVecs, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >

        Teuchos::RCP< NOX::Abstract::MultiVector >
        LOCA::Extended::Vector::createMultiVector(int numVecs, NOX::CopyType
        type=NOX::DeepCopy) const

        Create a MultiVector with numVecs columns. 
        """
        return _Extended.Vector_createMultiVector(self, *args)


    def init(self, *args):
        """
        init(Vector self, double gamma) -> Vector

        NOX::Abstract::Vector & LOCA::Extended::Vector::init(double gamma)

        NOX::Abstract::Vector init function. Initializes each stored vector
        and scalar. 
        """
        return _Extended.Vector_init(self, *args)


    def random(self, *args):
        """
        random(Vector self, bool useSeed=False, int seed=1) -> Vector

        NOX::Abstract::Vector & LOCA::Extended::Vector::random(bool
        useSeed=false, int seed=1)

        Initialize every element of this vector with random values. 
        """
        return _Extended.Vector_random(self, *args)


    def abs(self, *args):
        """
        abs(Vector self, Vector y) -> Vector

        NOX::Abstract::Vector & LOCA::Extended::Vector::abs(const
        NOX::Abstract::Vector &y)

        NOX::Abstract::Vector abs function. Compues absolute value of each
        stored vector and scalar. 
        """
        return _Extended.Vector_abs(self, *args)


    def reciprocal(self, *args):
        """
        reciprocal(Vector self, Vector y) -> Vector

        NOX::Abstract::Vector & LOCA::Extended::Vector::reciprocal(const
        NOX::Abstract::Vector &y)

        NOX::Abstract::Vector reciprocal function. Computes reciprocal of each
        stored vector and scalar. 
        """
        return _Extended.Vector_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(Vector self, double gamma) -> Vector
        scale(Vector self, Vector a) -> Vector

        NOX::Abstract::Vector & LOCA::Extended::Vector::scale(const
        NOX::Abstract::Vector &a)

        NOX::Abstract::Vector scale function. Scales each stored vector and
        scalar. 
        """
        return _Extended.Vector_scale(self, *args)


    def update(self, *args):
        """
        update(Vector self, double alpha, Vector a, double gamma=0.0) -> Vector
        update(Vector self, double alpha, Vector a, double beta, Vector b, double gamma=0.0) -> Vector

        NOX::Abstract::Vector & LOCA::Extended::Vector::update(double alpha,
        const NOX::Abstract::Vector &a, double beta, const
        NOX::Abstract::Vector &b, double gamma=0.0)

        NOX::Abstract::Vector update function. Applies vector update to each
        stored vector and scalar. 
        """
        return _Extended.Vector_update(self, *args)


    def norm(self, *args):
        """
        norm(Vector self, NOX::Abstract::Vector::NormType type) -> double
        norm(Vector self, Vector weights) -> double

        double
        LOCA::Extended::Vector::norm(const NOX::Abstract::Vector &weights)
        const

        NOX::Abstract::Vector weighted norm function. Computes weighted norm
        of each stored vector and combines to compute appropriate norm. 
        """
        return _Extended.Vector_norm(self, *args)


    def innerProduct(self, *args):
        """
        innerProduct(Vector self, Vector y) -> double

        double
        LOCA::Extended::Vector::innerProduct(const NOX::Abstract::Vector &y)
        const

        NOX::Abstract::Vector innerProduct function. Computes inner product *
        of each stored vector and combines to compute inner product. 
        """
        return _Extended.Vector_innerProduct(self, *args)


    def length(self, *args):
        """
        length(Vector self) -> NOX::size_type

        NOX::size_type
        LOCA::Extended::Vector::length() const

        NOX::Abstract::Vector length function. Computes sum of lengths of
        stored vectors plus number of scalars. 
        """
        return _Extended.Vector_length(self, *args)


    def _print(self, *args):
        """
        _print(Vector self, std::ostream & stream)

        void
        LOCA::Extended::Vector::print(std::ostream &stream) const

        NOX::Abstract::Vector print function. For debugging purposes. 
        """
        return _Extended.Vector__print(self, *args)


    def setVector(self, *args):
        """
        setVector(Vector self, int i, Vector v)

        void
        LOCA::Extended::Vector::setVector(int i, const NOX::Abstract::Vector
        &v)

        Sets the ith vector. 
        """
        return _Extended.Vector_setVector(self, *args)


    def setVectorView(self, *args):
        """
        setVectorView(Vector self, int i, Teuchos::RCP< NOX::Abstract::Vector > const & v)

        void
        LOCA::Extended::Vector::setVectorView(int i, const Teuchos::RCP<
        NOX::Abstract::Vector > &v)

        Sets the ith vector as a view. 
        """
        return _Extended.Vector_setVectorView(self, *args)


    def setScalar(self, *args):
        """
        setScalar(Vector self, int i, double s)

        void
        LOCA::Extended::Vector::setScalar(int i, double s)

        Sets the ith scalar. 
        """
        return _Extended.Vector_setScalar(self, *args)


    def setScalarArray(self, *args):
        """
        setScalarArray(Vector self, double * sv)

        void
        LOCA::Extended::Vector::setScalarArray(double *sv)

        Sets the scalar array. 
        """
        return _Extended.Vector_setScalarArray(self, *args)


    def getVector(self, *args):
        """
        getVector(Vector self, int i) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getVector(Vector self, int i) -> Teuchos::RCP< NOX::Abstract::Vector >

        Teuchos::RCP< NOX::Abstract::Vector >
        LOCA::Extended::Vector::getVector(int i)

        Returns ref-count pointer to the ith vector. 
        """
        return _Extended.Vector_getVector(self, *args)


    def getScalar(self, *args):
        """
        getScalar(Vector self, int i) -> double

        double &
        LOCA::Extended::Vector::getScalar(int i)

        Returns reference to the ith scalar. 
        """
        return _Extended.Vector_getScalar(self, *args)


    def getScalars(self, *args):
        """
        getScalars(Vector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getScalars(Vector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >

        Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        LOCA::Extended::Vector::getScalars()

        Returns array of scalars. 
        """
        return _Extended.Vector_getScalars(self, *args)


    def getNumScalars(self, *args):
        """
        getNumScalars(Vector self) -> int

        int
        LOCA::Extended::Vector::getNumScalars() const

        Returns number of scalars. 
        """
        return _Extended.Vector_getNumScalars(self, *args)


    def getNumVectors(self, *args):
        """
        getNumVectors(Vector self) -> int

        int
        LOCA::Extended::Vector::getNumVectors() const

        Returns number of vectors. 
        """
        return _Extended.Vector_getNumVectors(self, *args)

Vector_swigregister = _Extended.Vector_swigregister
Vector_swigregister(Vector)

class MultiAbstractGroup(PyTrilinos.NOX.Abstract.Group):
    """


    LOCA abstract interface for extended groups, derived from the
    NOX::Abstract::Group, i.e., an abstract interface for "super" groups
    that have an underlying group component.

    Concrete implemenations of this interface must provide implementations
    of all of the methods in the NOX::Abstract::Group interface as well as
    the additional interface defined here.

    C++ includes: LOCA_Extended_MultiAbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiAbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiAbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Extended.delete_MultiAbstractGroup

    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(MultiAbstractGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(MultiAbstractGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        virtual
        Teuchos::RCP<LOCA::MultiContinuation::AbstractGroup>
        LOCA::Extended::MultiAbstractGroup::getUnderlyingGroup()=0

        Return underlying group.

        This method should the underlying group data member. 
        """
        return _Extended.MultiAbstractGroup_getUnderlyingGroup(self, *args)


    def getBaseLevelUnderlyingGroup(self, *args):
        """
        getBaseLevelUnderlyingGroup(MultiAbstractGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getBaseLevelUnderlyingGroup(MultiAbstractGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >

        Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        LOCA::Extended::MultiAbstractGroup::getBaseLevelUnderlyingGroup()

        Return base-level underlying group.

        This method is intended for composite groups (such as extended
        bifurcation groups) which have an underlying group as a data member.
        This method is supposed to return the base level group and has a
        default recursive implementation that should work in most cases. 
        """
        return _Extended.MultiAbstractGroup_getBaseLevelUnderlyingGroup(self, *args)

MultiAbstractGroup_swigregister = _Extended.MultiAbstractGroup_swigregister
MultiAbstractGroup_swigregister(MultiAbstractGroup)

# This file is compatible with both classic and new-style classes.


