# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Epetra.Interface is the python interface to namespace
Epetra::Interface of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Epetra.Interface is to provide a concrete Epetra
implementation of LOCA interfaces.  The python version of
LOCA.Epetra.Interface supports the following classes:

    * Required                 - Provides a set of interfaces for users to
                                 provide information about the nonlinear
                                 problem to LOCA
    * MassMatrix               - Used by LOCA.Epetra.Group to provide a link
                                 to the external code for the coefficients of
                                 time dependent terms
    * TimeDependent            - Used by LOCA.Epetra.Group to provide a link
                                 to the external code for computing the shifted
                                 matrix
    * TimeDependentMatrixFree  - Used by LOCA.Epetra.Group to provide a link
                                 to the external code for applying the shifted
                                 matrix in a matrix-free setting

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Interface')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Interface')
    _Interface = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Interface', [dirname(__file__)])
        except ImportError:
            import _Interface
            return _Interface
        try:
            _mod = imp.load_module('_Interface', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Interface = swig_import_helper()
    del swig_import_helper
else:
    import _Interface
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Interface.delete_SwigPyIterator

    def value(self):
        return _Interface.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Interface.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Interface.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Interface.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Interface.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Interface.SwigPyIterator_copy(self)

    def next(self):
        return _Interface.SwigPyIterator_next(self)

    def __next__(self):
        return _Interface.SwigPyIterator___next__(self)

    def previous(self):
        return _Interface.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Interface.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Interface.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Interface.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Interface.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Interface.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Interface.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Interface.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Interface.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.NOX.Epetra.Interface
import Abstract
import PyTrilinos.Epetra
class Required(PyTrilinos.NOX.Epetra.Interface.Required):
    """


    Used by LOCA::Epetra::Group to provide a link to the external code for
    setting problem parameters.

    This interface is derived from the NOX::Epetra::Interface::Required
    and additionally provides a method for setting problem parameters.

    C++ includes: LOCA_Epetra_Interface_Required.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Epetra.Interface.Required]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Required, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Epetra.Interface.Required]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Required, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Epetra::Interface::Required self) -> Required

        LOCA::Epetra::Interface::Required::Required()

        Constructor. 
        """
        if self.__class__ == Required:
            _self = None
        else:
            _self = self
        this = _Interface.new_Required(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_Required

    def setParameters(self, *args):
        """
        setParameters(Required self, LOCA::ParameterVector const & p)

        virtual void
        LOCA::Epetra::Interface::Required::setParameters(const ParameterVector
        &p)=0

        Set parameters in the user's application.

        Should be called prior to calling one of the compute functions. 
        """
        return _Interface.Required_setParameters(self, *args)


    def printSolution(self, *args):
        """
        printSolution(Required self, Vector x_, double conParam)

        virtual void
        LOCA::Epetra::Interface::Required::printSolution(const Epetra_Vector
        &x_, double conParam)

        Call user's own print routine for vector-parameter pair. 
        """
        return _Interface.Required_printSolution(self, *args)


    def dataForPrintSolution(self, *args):
        """
        dataForPrintSolution(Required self, int const conStep, int const timeStep, int const totalTimeSteps)

        virtual void
        LOCA::Epetra::Interface::Required::dataForPrintSolution(const int
        conStep, const int timeStep, const int totalTimeSteps)

        Provides data to application for output files.

        This routine is called from Interface::xyzt::printSolution() just
        before the call to Interface::Required::printSolution(x,param), and
        gives the application some indices that can be used for creating a
        unique name/index for the output files. 
        """
        return _Interface.Required_dataForPrintSolution(self, *args)


    def setMultiPointParameter(self, *args):
        """
        setMultiPointParameter(Required self, int const stepNum)

        virtual
        void LOCA::Epetra::Interface::Required::setMultiPointParameter(const
        int stepNum)

        Set multipoint parameter in the user's application.

        Should be called prior to calling one of the compute functions. 
        """
        return _Interface.Required_setMultiPointParameter(self, *args)


    def preProcessContinuationStep(self, *args):
        """
        preProcessContinuationStep(Required self, LOCA::Abstract::Iterator::StepStatus stepStatus, LOCA::Epetra::Group & group)

        virtual void
        LOCA::Epetra::Interface::Required::preProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus, LOCA::Epetra::Group &group)

        Perform any preprocessing before a continuation step starts.

        The stepStatus argument indicates whether the previous step was
        successful. The default implementation here is empty. 
        """
        return _Interface.Required_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """
        postProcessContinuationStep(Required self, LOCA::Abstract::Iterator::StepStatus stepStatus, LOCA::Epetra::Group & group)

        virtual void
        LOCA::Epetra::Interface::Required::postProcessContinuationStep(LOCA::Abstract::Iterator::StepStatus
        stepStatus, LOCA::Epetra::Group &group)

        Perform any postprocessing after a continuation step finishes.

        The stepStatus argument indicates whether the step was successful. The
        default implementation here is empty. 
        """
        return _Interface.Required_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """
        projectToDraw(Required self, NOX::Epetra::Vector const & x, double * px)

        virtual void
        LOCA::Epetra::Interface::Required::projectToDraw(const
        NOX::Epetra::Vector &x, double *px) const

        Projects solution to a few scalars for multiparameter continuation.

        Default implementation is the max norm. 
        """
        return _Interface.Required_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """
        projectToDrawDimension(Required self) -> int

        virtual
        int LOCA::Epetra::Interface::Required::projectToDrawDimension() const

        Returns the dimension of the projection to draw array. 
        """
        return _Interface.Required_projectToDrawDimension(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_Required(self)
        return weakref_proxy(self)
Required_swigregister = _Interface.Required_swigregister
Required_swigregister(Required)

class MassMatrix(_object):
    """


    Used by LOCA::Epetra::Group to provide a link to the external code for
    the MassMatrix (coefficients of time dependent terms).

    This is used for Hopf bifurcation tracking, linear stability analysis,
    and space-time solutions (xyzt).

    C++ includes: LOCA_Epetra_Interface_MassMatrix.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MassMatrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MassMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Epetra::Interface::MassMatrix self) -> MassMatrix

        LOCA::Epetra::Interface::MassMatrix::MassMatrix()

        Constructor. 
        """
        if self.__class__ == MassMatrix:
            _self = None
        else:
            _self = self
        this = _Interface.new_MassMatrix(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_MassMatrix

    def computeMassMatrix(self, *args):
        """
        computeMassMatrix(MassMatrix self, Vector x) -> bool

        virtual bool
        LOCA::Epetra::Interface::MassMatrix::computeMassMatrix(const
        Epetra_Vector &x)=0

        Compute MassMatrix given the specified input vector x. Returns true if
        computation was successful. 
        """
        return _Interface.MassMatrix_computeMassMatrix(self, *args)


    def setOldSolution(self, *args):
        """
        setOldSolution(MassMatrix self, Vector x, int const timeStep)

        virtual void
        LOCA::Epetra::Interface::MassMatrix::setOldSolution(const
        Epetra_Vector &x, const int timeStep)

        Routines used in XYZT to set the old solution, the one from the
        previous time step.

        There is a different routine for first step, where the old solution is
        set by the user and not part of the solution vector. These routines
        are used by space-time (xyzt) problems, where the residual vector is a
        function of the previous solution, which is also being solved for, and
        where the MassMatrix is calculated as a function of a different
        solution vector then the Jacobian (that is, the previous time step).
        The timeStep argument is sent so the use can set the global time, for
        cases when computeF, computeJacobian, computeMassMatrix fills are
        functions of time (nonautonomous systems). 
        """
        return _Interface.MassMatrix_setOldSolution(self, *args)


    def setOldSolutionFirstStep(self, *args):
        """
        setOldSolutionFirstStep(MassMatrix self)

        virtual
        void LOCA::Epetra::Interface::MassMatrix::setOldSolutionFirstStep()

        See setOldSolution description. 
        """
        return _Interface.MassMatrix_setOldSolutionFirstStep(self, *args)


    def dataForPrintSolution(self, *args):
        """
        dataForPrintSolution(MassMatrix self, int const conStep, int const timeStep, int const totalTimeSteps)

        virtual
        void LOCA::Epetra::Interface::MassMatrix::dataForPrintSolution(const
        int conStep, const int timeStep, const int totalTimeSteps)

        Provides data to application for output files.

        This routine is called from Interface::xyzt::printSolution() just
        before the call to Interface::Required::printSolution(x,param), and
        gives the application some indices that can be used for creating a
        unique name/index for the output files. 
        """
        return _Interface.MassMatrix_dataForPrintSolution(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_MassMatrix(self)
        return weakref_proxy(self)
MassMatrix_swigregister = _Interface.MassMatrix_swigregister
MassMatrix_swigregister(MassMatrix)

class TimeDependent(Required):
    """


    Used by LOCA::Epetra::Group to provide a link to the external code for
    computing the shifted matrix.

    This interface is derived from the NOX::Epetra::Interface::Jacobian
    and additionally provides a method for computing the shifted matrix
    $\\alpha J + \\beta M$. This is needed for linear stability
    analysis and Hopf tracking.

    C++ includes: LOCA_Epetra_Interface_TimeDependent.H 
    """

    __swig_setmethods__ = {}
    for _s in [Required]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeDependent, name, value)
    __swig_getmethods__ = {}
    for _s in [Required]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TimeDependent, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Epetra::Interface::TimeDependent self) -> TimeDependent

        LOCA::Epetra::Interface::TimeDependent::TimeDependent()

        Constructor. 
        """
        if self.__class__ == TimeDependent:
            _self = None
        else:
            _self = self
        this = _Interface.new_TimeDependent(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_TimeDependent

    def computeShiftedMatrix(self, *args):
        """
        computeShiftedMatrix(TimeDependent self, double alpha, double beta, Vector x, Operator A) -> bool

        virtual
        bool
        LOCA::Epetra::Interface::TimeDependent::computeShiftedMatrix(double
        alpha, double beta, const Epetra_Vector &x, Epetra_Operator &A)=0

        Call user routine for computing the shifted matrix $\\alpha J +
        \\beta M$ where $J$ is the Jacobian matrix and $M$ is the mass
        matrix. 
        """
        return _Interface.TimeDependent_computeShiftedMatrix(self, *args)


    def setXdot(self, *args):
        """
        setXdot(TimeDependent self, Vector xdot, double const time)

        virtual void LOCA::Epetra::Interface::TimeDependent::setXdot(const
        Epetra_Vector &xdot, const double time)

        Routine used in XYZT to set x_dot and time in the interface.

        The computeF() routine for XYZT problems needs to be a function of
        x_dot, but th NOX/LOCA computeF() does not take x_dot as an argument.
        This is used to set x_dot in the application interface so the
        subsequent call to computeF has the correct x_dot value. The timeStep
        argument is sent so the use can set the global time, for cases when
        computeF, computeJacobian, computeMassMatrix fills are functions of
        time (nonautonomous systems). 
        """
        return _Interface.TimeDependent_setXdot(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_TimeDependent(self)
        return weakref_proxy(self)
TimeDependent_swigregister = _Interface.TimeDependent_swigregister
TimeDependent_swigregister(TimeDependent)

class TimeDependentMatrixFree(Required):
    """


    Used by LOCA::Epetra::Group to provide a link to the external code for
    applying the shifted matrix in a matrix-free setting.

    This interface is derived from the NOX::Epetra::Interface::Required
    and additionally provides a method for applying the shifted matrix
    $\\alpha J + \\beta M$. This is needed for linear stability
    analysis and Hopf tracking.

    C++ includes: LOCA_Epetra_Interface_TimeDependentMatrixFree.H 
    """

    __swig_setmethods__ = {}
    for _s in [Required]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeDependentMatrixFree, name, value)
    __swig_getmethods__ = {}
    for _s in [Required]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TimeDependentMatrixFree, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Epetra::Interface::TimeDependentMatrixFree self) -> TimeDependentMatrixFree

        LOCA::Epetra::Interface::TimeDependentMatrixFree::TimeDependentMatrixFree()

        Constructor. 
        """
        if self.__class__ == TimeDependentMatrixFree:
            _self = None
        else:
            _self = self
        this = _Interface.new_TimeDependentMatrixFree(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Interface.delete_TimeDependentMatrixFree

    def applyShiftedMatrix(self, *args):
        """
        applyShiftedMatrix(TimeDependentMatrixFree self, double alpha, double beta, NOX::Epetra::Vector const & input, NOX::Epetra::Vector & loca_result) -> bool

        virtual bool
        LOCA::Epetra::Interface::TimeDependentMatrixFree::applyShiftedMatrix(double
        alpha, double beta, const NOX::Epetra::Vector &input,
        NOX::Epetra::Vector &result) const =0

        Call user routine for applying the shifted matrix $\\alpha J +
        \\beta M$ where $J$ is the Jacobian matrix and $M$ is the mass
        matrix. 
        """
        return _Interface.TimeDependentMatrixFree_applyShiftedMatrix(self, *args)

    def __disown__(self):
        self.this.disown()
        _Interface.disown_TimeDependentMatrixFree(self)
        return weakref_proxy(self)
TimeDependentMatrixFree_swigregister = _Interface.TimeDependentMatrixFree_swigregister
TimeDependentMatrixFree_swigregister(TimeDependentMatrixFree)

# This file is compatible with both classic and new-style classes.


