# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.BorderedSystem is the python interface to namespace
BorderedSystem of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.BorderedSystem is to provide an interface for
groups that are bordered systems.  The python version of
LOCA.BorderedSystem supports the following classes:

    * AbstractGroup  - Interface for groups that are bordered systems

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_BorderedSystem')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_BorderedSystem')
    _BorderedSystem = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_BorderedSystem', [dirname(__file__)])
        except ImportError:
            import _BorderedSystem
            return _BorderedSystem
        try:
            _mod = imp.load_module('_BorderedSystem', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _BorderedSystem = swig_import_helper()
    del swig_import_helper
else:
    import _BorderedSystem
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
class AbstractGroup(PyTrilinos.NOX.Abstract.Group):
    """


    An interface for groups that are bordered systems.

    This class provides an interface for groups whose Jacobian is of the
    form \\[ \\begin{bmatrix} J & A \\\\ B^T & C \\end{bmatrix}
    \\] where $A$ and $B$ are multivectors and $C$ is a dense matrix. It
    provides methods for determining the width of the bordered
    rows/columns and for extracting these components. It is intended to be
    a recusive interface, in that if the group representing $J$ also has
    this form, the extracted rows/columns should be the combined
    rows/columns of this group and the underlying group (and so on).

    C++ includes: LOCA_BorderedSystem_AbstractGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BorderedSystem.delete_AbstractGroup

    def getBorderedWidth(self, *args):
        """
        getBorderedWidth(AbstractGroup self) -> int

        virtual int
        LOCA::BorderedSystem::AbstractGroup::getBorderedWidth() const =0

        Return the total width of the bordered rows/columns. 
        """
        return _BorderedSystem.AbstractGroup_getBorderedWidth(self, *args)


    def getUnborderedGroup(self, *args):
        """
        getUnborderedGroup(AbstractGroup self) -> Teuchos::RCP< NOX::Abstract::Group const >

        virtual
        Teuchos::RCP<const NOX::Abstract::Group>
        LOCA::BorderedSystem::AbstractGroup::getUnborderedGroup() const =0

        Get bottom-level unbordered group. 
        """
        return _BorderedSystem.AbstractGroup_getUnborderedGroup(self, *args)


    def isCombinedAZero(self, *args):
        """
        isCombinedAZero(AbstractGroup self) -> bool

        virtual bool
        LOCA::BorderedSystem::AbstractGroup::isCombinedAZero() const =0

        Indicates whether combined A block is zero. 
        """
        return _BorderedSystem.AbstractGroup_isCombinedAZero(self, *args)


    def isCombinedBZero(self, *args):
        """
        isCombinedBZero(AbstractGroup self) -> bool

        virtual bool
        LOCA::BorderedSystem::AbstractGroup::isCombinedBZero() const =0

        Indicates whether combined B block is zero. 
        """
        return _BorderedSystem.AbstractGroup_isCombinedBZero(self, *args)


    def isCombinedCZero(self, *args):
        """
        isCombinedCZero(AbstractGroup self) -> bool

        virtual bool
        LOCA::BorderedSystem::AbstractGroup::isCombinedCZero() const =0

        Indicates whether combined C block is zero. 
        """
        return _BorderedSystem.AbstractGroup_isCombinedCZero(self, *args)


    def extractSolutionComponent(self, *args):
        """
        extractSolutionComponent(AbstractGroup self, MultiVector v, MultiVector v_x)

        virtual void
        LOCA::BorderedSystem::AbstractGroup::extractSolutionComponent(const
        NOX::Abstract::MultiVector &v, NOX::Abstract::MultiVector &v_x) const
        =0

        Given the vector v, extract the underlying solution component
        corresponding to the unbordered group. 
        """
        return _BorderedSystem.AbstractGroup_extractSolutionComponent(self, *args)


    def extractParameterComponent(self, *args):
        """
        extractParameterComponent(AbstractGroup self, bool use_transpose, MultiVector v, NOX::Abstract::MultiVector::DenseMatrix & v_p)

        virtual void
        LOCA::BorderedSystem::AbstractGroup::extractParameterComponent(bool
        use_transpose, const NOX::Abstract::MultiVector &v,
        NOX::Abstract::MultiVector::DenseMatrix &v_p) const =0

        Given the vector v, extract the parameter components of all of the
        nested subvectors in v down to the solution component for the
        unbordered group. 
        """
        return _BorderedSystem.AbstractGroup_extractParameterComponent(self, *args)


    def loadNestedComponents(self, *args):
        """
        loadNestedComponents(AbstractGroup self, MultiVector v_x, NOX::Abstract::MultiVector::DenseMatrix const & v_p, MultiVector v)

        virtual
        void LOCA::BorderedSystem::AbstractGroup::loadNestedComponents(const
        NOX::Abstract::MultiVector &v_x, const
        NOX::Abstract::MultiVector::DenseMatrix &v_p,
        NOX::Abstract::MultiVector &v) const =0

        Given the solution component v_x and combined parameter components
        v_p, distribute these components through the nested sub-vectors in v.

        """
        return _BorderedSystem.AbstractGroup_loadNestedComponents(self, *args)


    def fillA(self, *args):
        """
        fillA(AbstractGroup self, MultiVector A)

        virtual void
        LOCA::BorderedSystem::AbstractGroup::fillA(NOX::Abstract::MultiVector
        &A) const =0

        Fill the combined A block as described above. 
        """
        return _BorderedSystem.AbstractGroup_fillA(self, *args)


    def fillB(self, *args):
        """
        fillB(AbstractGroup self, MultiVector B)

        virtual void
        LOCA::BorderedSystem::AbstractGroup::fillB(NOX::Abstract::MultiVector
        &B) const =0

        Fill the combined B block as described above. 
        """
        return _BorderedSystem.AbstractGroup_fillB(self, *args)


    def fillC(self, *args):
        """
        fillC(AbstractGroup self, NOX::Abstract::MultiVector::DenseMatrix & C)

        virtual void
        LOCA::BorderedSystem::AbstractGroup::fillC(NOX::Abstract::MultiVector::DenseMatrix
        &C) const =0

        Fill the combined C block as described above. 
        """
        return _BorderedSystem.AbstractGroup_fillC(self, *args)

AbstractGroup_swigregister = _BorderedSystem.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

# This file is compatible with both classic and new-style classes.


