# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.AnasaziOperator is the python interface to namespace
AnasaziOperator of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.AnasaziOperator is to provide ***.  The python
version of LOCA.AnasaziOperator supports the following classes:

    * AbstractStrategy  - Abstract interface class for Anasazi operator
                          strategies
    * Factory           - Factory for creating Anasazi operator strategy
                          objects

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_AnasaziOperator')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_AnasaziOperator')
    _AnasaziOperator = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_AnasaziOperator', [dirname(__file__)])
        except ImportError:
            import _AnasaziOperator
            return _AnasaziOperator
        try:
            _mod = imp.load_module('_AnasaziOperator', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _AnasaziOperator = swig_import_helper()
    del swig_import_helper
else:
    import _AnasaziOperator
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
class AbstractStrategy(_object):
    """


    Abstract interface class for Anasazi operator strategies.

    AbstractStrategy defines an abstract interface for anasazi operators.
    It is used by LOCA::Eigensolver::AnasaziStrategy to compute different
    kinds of eigenvalues of the steady-state solution after each
    continuation step.

    The interface currently defines several pure virtual methods, apply(),
    to apply the operator, transformEigenvalues() to transform the
    computed eigenvalues back to eigenvalues of untransformed state,
    rayleighQuotient to compute the rayleighQuotient for the operator, and
    label() to return the name of the operator. Derived classes should
    implement these method for a particular operator. Constructors for
    derived classes should be of the form:

    where global_data is the LOCA global data object, topParams is the
    parsed top-level parameter list, eigenParams is a parameter list of
    eigensolver parameters, solverParams is a parameter list of linear
    solver parameters, and grp is the group representing the Jacobian and
    mass matrices.

    This class and its children follow the Strategy pattern as defined in
    Erich Gamma, et al. "Design Patterns:  Elements of Reusable Object-
    Oriented Software." Addison Wesley, Boston, MA, 1995.

    C++ includes: LOCA_AnasaziOperator_AbstractStrategy.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractStrategy, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractStrategy, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::AnasaziOperator::AbstractStrategy self) -> AbstractStrategy

        LOCA::AnasaziOperator::AbstractStrategy::AbstractStrategy()

        Constructor. 
        """
        if self.__class__ == AbstractStrategy:
            _self = None
        else:
            _self = self
        this = _AnasaziOperator.new_AbstractStrategy(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _AnasaziOperator.delete_AbstractStrategy

    def apply(self, *args):
        """
        apply(AbstractStrategy self, NOX::Abstract::MultiVector const & input, NOX::Abstract::MultiVector & output)

        virtual void LOCA::AnasaziOperator::AbstractStrategy::apply(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &output)
        const =0

        Apply the operator to input with the result in output. 
        """
        return _AnasaziOperator.AbstractStrategy_apply(self, *args)


    def preProcessSeedVector(self, *args):
        """
        preProcessSeedVector(AbstractStrategy self, NOX::Abstract::MultiVector & ivec)

        virtual void
        LOCA::AnasaziOperator::AbstractStrategy::preProcessSeedVector(NOX::Abstract::MultiVector
        &ivec)

        Give strategy an opportunit to massage the random seed vector. 
        """
        return _AnasaziOperator.AbstractStrategy_preProcessSeedVector(self, *args)


    def beginPostProcessing(self, *args):
        """
        beginPostProcessing(AbstractStrategy self)

        virtual
        void LOCA::AnasaziOperator::AbstractStrategy::beginPostProcessing()

        Hook to precompute info for subsequent repeated calls to
        tranformEigenvalue and rayleighQuotient. 
        """
        return _AnasaziOperator.AbstractStrategy_beginPostProcessing(self, *args)


    def transformEigenvalue(self, *args):
        """
        transformEigenvalue(AbstractStrategy self, double & ev_r, double & ev_i)

        virtual
        void
        LOCA::AnasaziOperator::AbstractStrategy::transformEigenvalue(double
        &ev_r, double &ev_i) const =0

        Transform eigenvalue in place. 
        """
        return _AnasaziOperator.AbstractStrategy_transformEigenvalue(self, *args)


    def rayleighQuotient(self, *args):
        """
        rayleighQuotient(AbstractStrategy self, NOX::Abstract::Vector & evec_r, NOX::Abstract::Vector & evec_i, double & rq_r, double & rq_i) -> NOX::Abstract::Group::ReturnType

        virtual
        NOX::Abstract::Group::ReturnType
        LOCA::AnasaziOperator::AbstractStrategy::rayleighQuotient(NOX::Abstract::Vector
        &evec_r, NOX::Abstract::Vector &evec_i, double &rq_r, double &rq_i)
        const =0

        Compute Rayleigh quotient. 
        """
        return _AnasaziOperator.AbstractStrategy_rayleighQuotient(self, *args)


    def label(self, *args):
        """
        label(AbstractStrategy self) -> std::string const

        virtual const std::string&
        LOCA::AnasaziOperator::AbstractStrategy::label() const =0

        Return name of this operator. 
        """
        return _AnasaziOperator.AbstractStrategy_label(self, *args)

    def __disown__(self):
        self.this.disown()
        _AnasaziOperator.disown_AbstractStrategy(self)
        return weakref_proxy(self)
AbstractStrategy_swigregister = _AnasaziOperator.AbstractStrategy_swigregister
AbstractStrategy_swigregister(AbstractStrategy)

class Factory(_object):
    """


    Factory for creating Anasazi operator strategy objects.

    The parameters passed to the create() through the eigenParams argument
    method should specify the "Operator" as described below, as well as
    any additional parameters for the particular strategy. "Operator" -
    Name of the Anasazi operator. Valid choices are "Jacobian Inverse" (
    LOCA::AnasaziOperator::JacobianInverse) [Default]

    "Shift-Invert" ( LOCA::AnasaziOperator::ShiftInvert)

    "Cayley" ( LOCA::AnasaziOperator::Cayley)

    There is also an Epetra specific strategy that can be instantiated by
    the LOCA::Epetra::Factory. See LOCA::Epetra::AnasaziOperator::Floquet.

    C++ includes: LOCA_AnasaziOperator_Factory.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::AnasaziOperator::Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> Factory

        LOCA::AnasaziOperator::Factory::Factory(const Teuchos::RCP<
        LOCA::GlobalData > &global_data)

        Constructor. 
        """
        this = _AnasaziOperator.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _AnasaziOperator.delete_Factory

    def create(self, *args):
        """
        create(Factory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< NOX::Abstract::Group > const & grp) -> Teuchos::RCP< LOCA::AnasaziOperator::AbstractStrategy >

        Teuchos::RCP< LOCA::AnasaziOperator::AbstractStrategy >
        LOCA::AnasaziOperator::Factory::create(const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, const Teuchos::RCP<
        NOX::Abstract::Group > &grp)

        Create Anasazi operator strategy.

        Parameters:
        -----------

        topParams:  [in] Parsed top-level parameter list.

        eigenParams:  [in] Eigensolver parameters as described above

        solverParams:  [in] Linear solver parameters

        grp:  [in] Group representing Jacobian/mass matrices 
        """
        return _AnasaziOperator.Factory_create(self, *args)


    def strategyName(self, *args):
        """
        strategyName(Factory self, ParameterList eigenParams) -> std::string const &

        const std::string &
        LOCA::AnasaziOperator::Factory::strategyName(Teuchos::ParameterList
        &eigenParams) const

        Return strategy name given by eigenParams. 
        """
        return _AnasaziOperator.Factory_strategyName(self, *args)

Factory_swigregister = _AnasaziOperator.Factory_swigregister
Factory_swigregister(Factory)

# This file is compatible with both classic and new-style classes.


