# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Abstract is the python interface to namespace Abstract
of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Abstract is to provide abstract continuation
problem base classes.  The python version of LOCA.Abstract supports
the following classes:

    * Group                - Compatiblity class for AbstractGroup hierarchy
    * TransposeSolveGroup  - Abstract group interface class for solving the
                             transpose of the Jacobian
    * Iterator             - Abstract interface for implementing iteration
    * Factory              - Abstract interface for providing a user-defined
                             factory

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Abstract')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Abstract')
    _Abstract = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Abstract', [dirname(__file__)])
        except ImportError:
            import _Abstract
            return _Abstract
        try:
            _mod = imp.load_module('_Abstract', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Abstract = swig_import_helper()
    del swig_import_helper
else:
    import _Abstract
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.Epetra
import MultiContinuation
import Homotopy
import TimeDependent
import TurningPoint.MooreSpence
import TurningPoint.MinimallyAugmented
import Pitchfork.MooreSpence
import Pitchfork.MinimallyAugmented
import Hopf.MooreSpence
import Hopf.MinimallyAugmented
import PhaseTransition
class Group(Homotopy.AbstractGroup, TurningPoint.MinimallyAugmented.FiniteDifferenceGroup, Pitchfork.MinimallyAugmented.AbstractGroup, Hopf.MinimallyAugmented.FiniteDifferenceGroup, PhaseTransition.AbstractGroup):
    """


    Compatiblity class for AbstractGroup hierarchy.

    This class is derived from all LOCA AbstractGroup abstract base
    classes as well as all FiniteDifference groups and any other groups
    that provided default implementations for AbstractGroup pure virtual
    methods. This class provides definitions for all needed assignment
    operators and provides definitions for some pure virtual methods by
    printing error messages. This class exists primarily for compatiblity
    to an older class hierarchy and will most likely be removed in the
    future.

    C++ includes: LOCA_Abstract_Group.H 
    """

    __swig_setmethods__ = {}
    for _s in [Homotopy.AbstractGroup, TurningPoint.MinimallyAugmented.FiniteDifferenceGroup, Pitchfork.MinimallyAugmented.AbstractGroup, Hopf.MinimallyAugmented.FiniteDifferenceGroup, PhaseTransition.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    for _s in [Homotopy.AbstractGroup, TurningPoint.MinimallyAugmented.FiniteDifferenceGroup, Pitchfork.MinimallyAugmented.AbstractGroup, Hopf.MinimallyAugmented.FiniteDifferenceGroup, PhaseTransition.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Abstract.delete_Group

    def augmentJacobianForHomotopy(self, *args):
        """
        augmentJacobianForHomotopy(Group self, double a, double b) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::augmentJacobianForHomotopy(double a, double b)

        Replace Jacobian $J$ by $aJ+bI$ where $I$ is the identity matrix and
        $p$ is a scalar.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_augmentJacobianForHomotopy(self, *args)


    def computeShiftedMatrix(self, *args):
        """
        computeShiftedMatrix(Group self, double alpha, double beta) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::computeShiftedMatrix(double alpha, double beta)

        Compute the shifted matrix.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_computeShiftedMatrix(self, *args)


    def applyShiftedMatrix(self, *args):
        """
        applyShiftedMatrix(Group self, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyShiftedMatrix(const NOX::Abstract::Vector
        &input, NOX::Abstract::Vector &result) const

        Multiply the shifted matrix by a vector.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyShiftedMatrix(self, *args)


    def applyShiftedMatrixMultiVector(self, *args):
        """
        applyShiftedMatrixMultiVector(Group self, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyShiftedMatrixMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Multiply the shifted matrix by a multi-vector.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyShiftedMatrixMultiVector(self, *args)


    def applyShiftedMatrixInverseMultiVector(self, *args):
        """
        applyShiftedMatrixInverseMultiVector(Group self, ParameterList params, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyShiftedMatrixInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const

        Apply the inverse of the shifted matrix by a multi-vector, as needed
        by the shift-and-invert and generalized Cayley transformations.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyShiftedMatrixInverseMultiVector(self, *args)


    def computeSecondShiftedMatrix(self, *args):
        """
        computeSecondShiftedMatrix(Group self, double alpha, double beta) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::computeSecondShiftedMatrix(double alpha, double
        beta)

        Compute the second shifted matrix. Can avoid recomputing if two are
        stored.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_computeSecondShiftedMatrix(self, *args)


    def applySecondShiftedMatrix(self, *args):
        """
        applySecondShiftedMatrix(Group self, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applySecondShiftedMatrix(const
        NOX::Abstract::Vector &input, NOX::Abstract::Vector &result) const

        Multiply the shifted matrix by a vector.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applySecondShiftedMatrix(self, *args)


    def applySecondShiftedMatrixMultiVector(self, *args):
        """
        applySecondShiftedMatrixMultiVector(Group self, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applySecondShiftedMatrixMultiVector(const
        NOX::Abstract::MultiVector &input, NOX::Abstract::MultiVector &result)
        const

        Multiply the shifted matrix by a multi-vector.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applySecondShiftedMatrixMultiVector(self, *args)


    def isComplex(self, *args):
        """
        isComplex(Group self) -> bool

        bool
        LOCA::Abstract::Group::isComplex() const

        Is $J+i\\omega B$ valid.

        The implementation here always returns false. 
        """
        return _Abstract.Group_isComplex(self, *args)


    def computeComplex(self, *args):
        """
        computeComplex(Group self, double frequency) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::computeComplex(double frequency)

        Compute $J+i\\omega B$.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_computeComplex(self, *args)


    def applyComplex(self, *args):
        """
        applyComplex(Group self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyComplex(const NOX::Abstract::Vector
        &input_real, const NOX::Abstract::Vector &input_imag,
        NOX::Abstract::Vector &result_real, NOX::Abstract::Vector
        &result_imag) const

        Compute $(J+i\\omega B)(y+iz)$.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyComplex(self, *args)


    def applyComplexMultiVector(self, *args):
        """
        applyComplexMultiVector(Group self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyComplexMultiVector(const
        NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const

        Compute $(J+i\\omega B)(y+iz)$.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyComplexMultiVector(self, *args)


    def applyComplexInverseMultiVector(self, *args):
        """
        applyComplexInverseMultiVector(Group self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyComplexInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const

        Solve $(J+i\\omega B)(y+iz) = a+ib$.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyComplexInverseMultiVector(self, *args)


    def applyComplexTranspose(self, *args):
        """
        applyComplexTranspose(Group self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyComplexTranspose(const
        NOX::Abstract::Vector &input_real, const NOX::Abstract::Vector
        &input_imag, NOX::Abstract::Vector &result_real, NOX::Abstract::Vector
        &result_imag) const

        Computes conjugate-tranpose matrix vector product $ (J+i\\omega B)^H
        (x + iy) $.

        Implementation here prints an error message and returns
        NOX::Abstract::Group::NotDefined. 
        """
        return _Abstract.Group_applyComplexTranspose(self, *args)


    def applyComplexTransposeMultiVector(self, *args):
        """
        applyComplexTransposeMultiVector(Group self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyComplexTransposeMultiVector(const
        NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const

        Computes conjugate-tranpose matrix vector product $ (J+i\\omega B)^H
        (x + iy) $. 
        """
        return _Abstract.Group_applyComplexTransposeMultiVector(self, *args)


    def applyComplexTransposeInverseMultiVector(self, *args):
        """
        applyComplexTransposeInverseMultiVector(Group self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType

        NOX::Abstract::Group::ReturnType
        LOCA::Abstract::Group::applyComplexTransposeInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input_real, const
        NOX::Abstract::MultiVector &input_imag, NOX::Abstract::MultiVector
        &result_real, NOX::Abstract::MultiVector &result_imag) const

        Solve $(J+i\\omega B)^H (x + iy) = a+ib$. 
        """
        return _Abstract.Group_applyComplexTransposeInverseMultiVector(self, *args)


    def copy(self, *args):
        """
        copy(Group self, Group source)

        void
        LOCA::Abstract::Group::copy(const NOX::Abstract::Group &source)

        Assignment operator. 
        """
        return _Abstract.Group_copy(self, *args)


    def setParamsMulti(self, *args):
        """
        setParamsMulti(Group self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)

        void
        LOCA::Abstract::Group::setParamsMulti(const std::vector< int >
        &paramIDs, const NOX::Abstract::MultiVector::DenseMatrix &vals)

        Set parameters indexed by (integer) paramIDs. 
        """
        return _Abstract.Group_setParamsMulti(self, *args)


    def notifyCompletedStep(self, *args):
        """
        notifyCompletedStep(Group self)

        void LOCA::Abstract::Group::notifyCompletedStep()

        Notify group that the continuation step is completed The default
        implementation here is to do nothing. 
        """
        return _Abstract.Group_notifyCompletedStep(self, *args)


    def computeFreeEnergy(self, *args):
        """
        computeFreeEnergy(Group self) -> double

        double LOCA::Abstract::Group::computeFreeEnergy()

        Computes the free energy at the current solution and parameter values.

        """
        return _Abstract.Group_computeFreeEnergy(self, *args)

Group_swigregister = _Abstract.Group_swigregister
Group_swigregister(Group)

class TransposeSolveGroup(PyTrilinos.NOX.Abstract.Group):
    """


    Abstract group interface class for solving the transpose of the
    Jacobian.

    This interface, derived from NOX::Abstract::Group, provides the
    additional interface for solving the transpose of the Jacobian.

    C++ includes: LOCA_Abstract_TransposeSolveGroup.H 
    """

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TransposeSolveGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.NOX.Abstract.Group]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TransposeSolveGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Abstract.delete_TransposeSolveGroup

    def applyJacobianTransposeInverse(self, *args):
        """
        applyJacobianTransposeInverse(TransposeSolveGroup self, ParameterList params, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Abstract::TransposeSolveGroup::applyJacobianTransposeInverse(Teuchos::ParameterList
        &params, const NOX::Abstract::Vector &input, NOX::Abstract::Vector
        &result) const =0

        Solve Jacobian-tranpose system. 
        """
        return _Abstract.TransposeSolveGroup_applyJacobianTransposeInverse(self, *args)


    def applyJacobianTransposeInverseMultiVector(self, *args):
        """
        applyJacobianTransposeInverseMultiVector(TransposeSolveGroup self, ParameterList params, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType

        virtual NOX::Abstract::Group::ReturnType
        LOCA::Abstract::TransposeSolveGroup::applyJacobianTransposeInverseMultiVector(Teuchos::ParameterList
        &params, const NOX::Abstract::MultiVector &input,
        NOX::Abstract::MultiVector &result) const =0

        Solve Jacobian-tranpose system with multiple right-hand sides. 
        """
        return _Abstract.TransposeSolveGroup_applyJacobianTransposeInverseMultiVector(self, *args)

TransposeSolveGroup_swigregister = _Abstract.TransposeSolveGroup_swigregister
TransposeSolveGroup_swigregister(TransposeSolveGroup)

class Iterator(_object):
    """


    An abstract interface for implementing iteration.

    The LOCA::Abstract::Iterator defines an interface for implementing
    many kinds of iterative processes. In LOCA, this is used to implement
    the Stepper which computes points along a continuation curve.

    Many iterative processes can be abstracted in the following manner:

    Initialize iteration (start)

    Compute iteration (iterate) while iterator is not finished preprocess
    step (preprocess)

    compute step (compute)

    postprocess step (posprocess)

    check iterator status (stop)

    Finalize iteration (finish)

    The run method of the iterator implements this iterative process with
    start, finish, preprocess, compute and postprocess left as pure
    virtual methods to be implemented for the specific iterative process.

    The iterator has one parameter, "Max Steps" (default 100) giving the
    maximum number of steps the iterator should take. The default
    implementation of stop only stops the iterator when this maximum
    number of steps has been reached.

    C++ includes: LOCA_Abstract_Iterator.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Iterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Iterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    LastIteration = _Abstract.Iterator_LastIteration
    Finished = _Abstract.Iterator_Finished
    Failed = _Abstract.Iterator_Failed
    NotFinished = _Abstract.Iterator_NotFinished
    Successful = _Abstract.Iterator_Successful
    Unsuccessful = _Abstract.Iterator_Unsuccessful
    Provisional = _Abstract.Iterator_Provisional
    __swig_destroy__ = _Abstract.delete_Iterator

    def resetIterator(self, *args):
        """
        resetIterator(Iterator self, ParameterList p) -> bool

        bool
        LOCA::Abstract::Iterator::resetIterator(Teuchos::ParameterList &p)

        Reset the iterator to start a new iteration. 
        """
        return _Abstract.Iterator_resetIterator(self, *args)


    def getIteratorStatus(self, *args):
        """
        getIteratorStatus(Iterator self) -> LOCA::Abstract::Iterator::IteratorStatus

        LOCA::Abstract::Iterator::IteratorStatus
        LOCA::Abstract::Iterator::getIteratorStatus() const

        Return the status of the iterator. 
        """
        return _Abstract.Iterator_getIteratorStatus(self, *args)


    def getStepNumber(self, *args):
        """
        getStepNumber(Iterator self) -> int

        int
        LOCA::Abstract::Iterator::getStepNumber() const

        Returns the number of accepted steps. 
        """
        return _Abstract.Iterator_getStepNumber(self, *args)


    def getNumFailedSteps(self, *args):
        """
        getNumFailedSteps(Iterator self) -> int

        int LOCA::Abstract::Iterator::getNumFailedSteps() const

        Returns the number of failed steps. 
        """
        return _Abstract.Iterator_getNumFailedSteps(self, *args)


    def getNumTotalSteps(self, *args):
        """
        getNumTotalSteps(Iterator self) -> int

        int LOCA::Abstract::Iterator::getNumTotalSteps() const

        Returns the total number of steps attempted. 
        """
        return _Abstract.Iterator_getNumTotalSteps(self, *args)


    def run(self, *args):
        """
        run(Iterator self) -> LOCA::Abstract::Iterator::IteratorStatus

        LOCA::Abstract::Iterator::IteratorStatus
        LOCA::Abstract::Iterator::run()

        Run the iterator. 
        """
        return _Abstract.Iterator_run(self, *args)

Iterator_swigregister = _Abstract.Iterator_swigregister
Iterator_swigregister(Iterator)

class Factory(_object):
    """


    Abstract interface for providing a user-defined factory

    LOCA::Abstract::Factory provides an abstract interface for providing
    user-defined factories to the LOCA::Factory. The LOCA::Factory
    provides a mechanism for instantiating different strategies based on
    parameter list choices. This class allows additional strategies to be
    instantiated by the factory without modifying the factory itself. This
    is done by deriving a user-defined factory from this interface,
    implementing any of the create methods for the user-defined
    strategies, and passing an instance of the derived factory to the
    LOCA::Factory object. Any derived class must implement the  init()
    method to set the global data object which the factory can then pass
    to any instantiated strategies.

    C++ includes: LOCA_Abstract_Factory.H 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Abstract.delete_Factory

    def init(self, *args):
        """
        init(Factory self, Teuchos::RCP< LOCA::GlobalData > const & global_data)

        virtual void
        LOCA::Abstract::Factory::init(const Teuchos::RCP< LOCA::GlobalData >
        &global_data)=0

        Initialize factory.

        The LOCA::Factory will call this method to initialize the user
        provided factory. The user-provided factory should perform any needed
        initialization here that cannot occur at construction. 
        """
        return _Abstract.Factory_init(self, *args)


    def createPredictorStrategy(self, *args):
        """
        createPredictorStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & predictorParams, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createPredictorStrategy(const std::string
        &strategyName, const Teuchos::RCP< LOCA::Parameter::SublistParser >
        &topParams, const Teuchos::RCP< Teuchos::ParameterList >
        &predictorParams, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy
        > &strategy)

        Create predictor strategy. 
        """
        return _Abstract.Factory_createPredictorStrategy(self, *args)


    def createContinuationStrategy(self, *args):
        """
        createContinuationStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepperParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp, Teuchos::RCP< LOCA::MultiPredictor::AbstractStrategy > const & pred, std::vector< int,std::allocator< int > > const & paramIDs, Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createContinuationStrategy(const std::string
        &strategyName, const Teuchos::RCP< LOCA::Parameter::SublistParser >
        &topParams, const Teuchos::RCP< Teuchos::ParameterList >
        &stepperParams, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &grp, const Teuchos::RCP<
        LOCA::MultiPredictor::AbstractStrategy > &pred, const std::vector< int
        > &paramIDs, Teuchos::RCP< LOCA::MultiContinuation::AbstractStrategy >
        &strategy)

        Create continuation strategy. 
        """
        return _Abstract.Factory_createContinuationStrategy(self, *args)


    def createBifurcationStrategy(self, *args):
        """
        createBifurcationStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & bifurcationParams, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > const & grp, Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createBifurcationStrategy(const std::string
        &strategyName, const Teuchos::RCP< LOCA::Parameter::SublistParser >
        &topParams, const Teuchos::RCP< Teuchos::ParameterList >
        &bifurcationParams, const Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &grp, Teuchos::RCP<
        LOCA::MultiContinuation::AbstractGroup > &strategy)

        Create bifurcation strategy. 
        """
        return _Abstract.Factory_createBifurcationStrategy(self, *args)


    def createStepSizeStrategy(self, *args):
        """
        createStepSizeStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & stepsizeParams, Teuchos::RCP< LOCA::StepSize::AbstractStrategy > & strategy) -> bool

        bool LOCA::Abstract::Factory::createStepSizeStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &stepsizeParams, Teuchos::RCP<
        LOCA::StepSize::AbstractStrategy > &strategy)

        Create step size strategy. 
        """
        return _Abstract.Factory_createStepSizeStrategy(self, *args)


    def createBorderedSolverStrategy(self, *args):
        """
        createBorderedSolverStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< LOCA::BorderedSolver::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createBorderedSolverStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, Teuchos::RCP<
        LOCA::BorderedSolver::AbstractStrategy > &strategy)

        Create bordered system solver strategy. 
        """
        return _Abstract.Factory_createBorderedSolverStrategy(self, *args)


    def createEigensolverStrategy(self, *args):
        """
        createEigensolverStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< LOCA::Eigensolver::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createEigensolverStrategy(const std::string
        &strategyName, const Teuchos::RCP< LOCA::Parameter::SublistParser >
        &topParams, const Teuchos::RCP< Teuchos::ParameterList > &eigenParams,
        Teuchos::RCP< LOCA::Eigensolver::AbstractStrategy > &strategy)

        Create eigensolver strategy. 
        """
        return _Abstract.Factory_createEigensolverStrategy(self, *args)


    def createEigenvalueSortStrategy(self, *args):
        """
        createEigenvalueSortStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< LOCA::EigenvalueSort::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createEigenvalueSortStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams, Teuchos::RCP<
        LOCA::EigenvalueSort::AbstractStrategy > &strategy)

        Create eigenvalue sorting strategy. 
        """
        return _Abstract.Factory_createEigenvalueSortStrategy(self, *args)


    def createSaveEigenDataStrategy(self, *args):
        """
        createSaveEigenDataStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createSaveEigenDataStrategy(const std::string
        &strategyName, const Teuchos::RCP< LOCA::Parameter::SublistParser >
        &topParams, const Teuchos::RCP< Teuchos::ParameterList > &eigenParams,
        Teuchos::RCP< LOCA::SaveEigenData::AbstractStrategy > &strategy)

        Create strategy to save eigenvector/value data. 
        """
        return _Abstract.Factory_createSaveEigenDataStrategy(self, *args)


    def createAnasaziOperatorStrategy(self, *args):
        """
        createAnasaziOperatorStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & eigenParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< LOCA::AnasaziOperator::AbstractStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createAnasaziOperatorStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &eigenParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, const Teuchos::RCP<
        NOX::Abstract::Group > &grp, Teuchos::RCP<
        LOCA::AnasaziOperator::AbstractStrategy > &strategy)

        Create Anasazi operator. 
        """
        return _Abstract.Factory_createAnasaziOperatorStrategy(self, *args)


    def createMooreSpenceTurningPointSolverStrategy(self, *args):
        """
        createMooreSpenceTurningPointSolverStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< LOCA::TurningPoint::MooreSpence::SolverStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createMooreSpenceTurningPointSolverStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, Teuchos::RCP<
        LOCA::TurningPoint::MooreSpence::SolverStrategy > &strategy)

        Create Moore-Spence turning point solver strategy. 
        """
        return _Abstract.Factory_createMooreSpenceTurningPointSolverStrategy(self, *args)


    def createMooreSpencePitchforkSolverStrategy(self, *args):
        """
        createMooreSpencePitchforkSolverStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< LOCA::Pitchfork::MooreSpence::SolverStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createMooreSpencePitchforkSolverStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, Teuchos::RCP<
        LOCA::Pitchfork::MooreSpence::SolverStrategy > &strategy)

        Create Moore-Spence pitchfork solver strategy. 
        """
        return _Abstract.Factory_createMooreSpencePitchforkSolverStrategy(self, *args)


    def createMooreSpenceHopfSolverStrategy(self, *args):
        """
        createMooreSpenceHopfSolverStrategy(Factory self, std::string const & strategyName, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams, Teuchos::RCP< LOCA::Hopf::MooreSpence::SolverStrategy > & strategy) -> bool

        bool
        LOCA::Abstract::Factory::createMooreSpenceHopfSolverStrategy(const
        std::string &strategyName, const Teuchos::RCP<
        LOCA::Parameter::SublistParser > &topParams, const Teuchos::RCP<
        Teuchos::ParameterList > &solverParams, Teuchos::RCP<
        LOCA::Hopf::MooreSpence::SolverStrategy > &strategy)

        Create Moore-Spence Hopf solver strategy. 
        """
        return _Abstract.Factory_createMooreSpenceHopfSolverStrategy(self, *args)

Factory_swigregister = _Abstract.Factory_swigregister
Factory_swigregister(Factory)

# This file is compatible with both classic and new-style classes.


