# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Komplex is the python interface to the Trilinos complex
linear algebra package Komplex:

    http://trilinos.sandia.gov/packages/komplex

The purpose of Komplex is to define complex (real + imaginary) linear
algebra problems using real-valued Epetra vectors and matrix
operators.  The python version of the Komplex package supports the
following class:

    * LinearProblem - Encapsulate all elements of a complex linear
                      algebra problem

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Komplex')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Komplex')
    _Komplex = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Komplex', [dirname(__file__)])
        except ImportError:
            import _Komplex
            return _Komplex
        try:
            _mod = imp.load_module('_Komplex', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Komplex = swig_import_helper()
    del swig_import_helper
else:
    import _Komplex
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Komplex.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Komplex.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Komplex.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Komplex.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Komplex.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Komplex.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Komplex.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Komplex.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Komplex.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Komplex.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Komplex.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Komplex.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Komplex.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Komplex.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Komplex.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Komplex.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Komplex.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Komplex.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info

def Version(*args):
    """
    Version() -> std::string

    std::string Komplex_Version()

    """
    return _Komplex.Version(*args)

__version__ = Version().split()[2]

class Komplex_LinearProblem(_object):
    """


    Komplex_LinearProblem: A class for forming an equivalent real
    formulation of a complex valued problem.

    The Komplex_LinearProblem class takes a complex linear problem,
    separated into real and imaginary parts, and forms an equivalent real
    valued system of twice the dimension. The resulting system can then be
    solved with any Trilinos solver that understands Epetra objects.

    KOMPLEX solves a complex-valued linear system Ax = b by solving an
    equivalent real-valued system of twice the dimension. Specifically,
    writing in terms of real and imaginary parts, we have

    \\[ (A_r + i*A_i)*(x_r + i*x_i) = (b_r + i*b_i) \\]

    or by separating into real and imaginary equations we have

    \\[ \\left( \\begin{array}{rr} A_r & -A_i\\\\ A_i & A_r
    \\end{array} \\right) \\left( \\begin{array}{r} x_r\\\\
    x_i \\end{array} \\right) = \\left( \\begin{array}{r}
    b_r\\\\ b_i \\end{array} \\right) \\] which is a real-valued
    system of twice the size. If we find xr and xi, we can form the
    solution to the original system as x = xr +i*xi.

    KOMPLEX accepts the user linear system as two real-valued matrices
    with no assumption about the structure of the matrices, except that
    they have compatible RowMap, DomainMap and RangeMap distributions.
    Each matrix is multiplied by user-supplied complex constants.

    Although formally the system is a 2-by-2 block system, we actually
    apply the interleaving at the matrix entry level such that the real
    part of the first complex equation is followed by the imaginary part
    of the first complex equation, and so on. This approach is documented
    in:

    David Day and Michael A. Heroux. Solving complex-valued linear systems
    via equivalent real formulations. SIAM J. Sci. Comput., 23(2):480498,
    2001.

    C++ includes: Komplex_LinearProblem.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Komplex_LinearProblem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Komplex_LinearProblem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Komplex_LinearProblem self, double c0r, double c0i, RowMatrix A0, double c1r, double c1i, RowMatrix A1, MultiVector Xr, MultiVector Xi, MultiVector Br, MultiVector Bi) -> Komplex_LinearProblem

        Komplex_LinearProblem::Komplex_LinearProblem(double c0r, double c0i,
        const Epetra_RowMatrix &A0, double c1r, double c1i, const
        Epetra_RowMatrix &A1, const Epetra_MultiVector &Xr, const
        Epetra_MultiVector &Xi, const Epetra_MultiVector &Br, const
        Epetra_MultiVector &Bi)

        Komplex_LinearProblem constructor.

        Constructs the Komplex operator from the user definition of the
        complex-valued matrix C = (c0r+i*c0i)*A0 +(c1r+i*c1i)*A1. Using this
        general expression for the complex matrix allows easy formulation of a
        variety of common complex problems.

        Parameters:
        -----------

        c0r:  (In) The real part of the complex coefficient multiplying A0.

        c0i:  (In) The imag part of the complex coefficient multiplying A0.

        A0:  (In) An Epetra_RowMatrix that is one of the matrices used to
        define the true complex operator.

        c1r:  (In) The real part of the complex coefficient multiplying A1.

        c1i:  (In) The imag part of the complex coefficient multiplying A1.

        A1:  (In) An Epetra_RowMatrix that is the second of the matrices used
        to define the true complex operator.

        Xr:  (In) The real part of the complex valued LHS.

        Xi:  (In) The imag part of the complex valued LHS.

        Br:  (In) The real part of the complex valued RHS.

        Bi:  (In) The imag part of the complex valued RHS. 
        """
        this = _Komplex.new_Komplex_LinearProblem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Komplex.delete_Komplex_LinearProblem

    def UpdateValues(self, *args):
        """
        UpdateValues(Komplex_LinearProblem self, double c0r, double c0i, RowMatrix A0, double c1r, double c1i, RowMatrix A1, MultiVector Xr, MultiVector Xi, MultiVector Br, MultiVector Bi) -> int

        int
        Komplex_LinearProblem::UpdateValues(double c0r, double c0i, const
        Epetra_RowMatrix &A0, double c1r, double c1i, const Epetra_RowMatrix
        &A1, const Epetra_MultiVector &Xr, const Epetra_MultiVector &Xi, const
        Epetra_MultiVector &Br, const Epetra_MultiVector &Bi)

        Update the values of the equivalent real valued system.

        This method allows the values of an existing Komplex_LinearProblem
        object to be updated. Note that the update that there is no change to
        the pattern of the matrices.

        Error code, set to 0 if no error. 
        """
        return _Komplex.Komplex_LinearProblem_UpdateValues(self, *args)


    def ExtractSolution(self, *args):
        """
        ExtractSolution(Komplex_LinearProblem self, MultiVector Xr, MultiVector Xi) -> int

        int
        Komplex_LinearProblem::ExtractSolution(Epetra_MultiVector &Xr,
        Epetra_MultiVector &Xi)

        Extrac a solution for the original complex-valued problem using the
        solution of the Komplex problem.

        After solving the komplex linear system, this method can be called to
        extract the solution of the original problem, assuming the solution
        for the komplex system is valid.

        Parameters:
        -----------

        Xr:  (Out) An existing Epetra_MultiVector. On exit it will contain the
        real part of the complex valued solution.

        Xi:  (Out) An existing Epetra_MultiVector. On exit it will contain the
        imag part of the complex valued solution. 
        """
        return _Komplex.Komplex_LinearProblem_ExtractSolution(self, *args)


    def KomplexProblem(self, *args):
        """
        KomplexProblem(Komplex_LinearProblem self) -> Epetra_LinearProblem

        Epetra_LinearProblem* Komplex_LinearProblem::KomplexProblem() const

        Returns pointer to the Epetra_LinearProblem object that defines the
        Komplex formulation.

        The pointer returned from this method will contain the address of a
        fully-constructed Epetra_LinearProblem instance that can be used with
        any Trilinos preconditioner or solver. 
        """
        return _Komplex.Komplex_LinearProblem_KomplexProblem(self, *args)

Komplex_LinearProblem_swigregister = _Komplex.Komplex_LinearProblem_swigregister
Komplex_LinearProblem_swigregister(Komplex_LinearProblem)


LinearProblem = Komplex_LinearProblem

# This file is compatible with both classic and new-style classes.


