# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


"""
PyTrilinos.Isorropia is the python interface to the Trilinos
partitioning and load balancing package Isorropia:

    http://trilinos.sandia.gov/packages/isorropia

The purpose of Isorropia is to ....

"""

import os
import sys
sys.path.insert(0, os.path.split(__file__)[0])



from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '___init__')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('___init__')
    ___init__ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('___init__', [dirname(__file__)])
        except ImportError:
            import ___init__
            return ___init__
        try:
            _mod = imp.load_module('___init__', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    ___init__ = swig_import_helper()
    del swig_import_helper
else:
    import ___init__
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

def Isorropia_Version(*args):
    """Isorropia_Version() -> std::string"""
    return ___init__.Isorropia_Version(*args)

__version__ = Isorropia_Version().split()[3]

class Operator(_object):
    """


    Interface (abstract base class) for computing a new
    partitioning/coloring/ ordering and exploiting their results.

    If the accessor methods are called before the computation of the
    result (by a method like compute()) has been called, behavior is not
    well defined. Implementations will either return empty/erroneous data,
    or throw an exception. In most cases, implementations will probably
    call compute_partitioning() internally in a constructor or factory
    method, so this won't usually be an issue.

    C++ includes: Isorropia_Operator.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Operator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Operator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Operator

    def setParameters(self, *args):
        """
        setParameters(Operator self, ParameterList paramlist)

        virtual
        void Isorropia::Operator::setParameters(const Teuchos::ParameterList
        &paramlist)=0

        Set parameters for the Operator instance. The contents of the input
        paramlist object are copied into an internal ParameterList attribute.
        Instances of this interface should not retain a reference to the input
        ParameterList after this method returns.

        Parameters:
        -----------

        paramlist:  List of parameters that the user wants to use. 
        """
        return ___init__.Operator_setParameters(self, *args)


    def compute(self, *args):
        """
        compute(Operator self, bool forceRecomputing=False)

        virtual void
        Isorropia::Operator::compute(bool forceRecomputing=false)=0

        Method which does the work of computing a new
        partitioning/coloring/ordering, depending on the child class used.

        Parameters:
        -----------

        forceRecomputing:  Optional argument defaults to false. Depending on
        the implementation, compute() should only perform a computation the
        first time it is called, and subsequent repeated calls are no-ops. If
        the user's intent is to re- compute the results (e.g., if parameters
        or other inputs have been changed), then setting this flag to true
        will force a new result to be computed. 
        """
        return ___init__.Operator_compute(self, *args)


    def alreadyComputed(self, *args):
        """
        alreadyComputed(Operator self) -> bool

        virtual
        bool Isorropia::Operator::alreadyComputed() const =0

        Query whether the computation has already been called.

        True if the computation has already been done, False otherwise. 
        """
        return ___init__.Operator_alreadyComputed(self, *args)


    def numProperties(self, *args):
        """
        numProperties(Operator self) -> int

        virtual
        int Isorropia::Operator::numProperties() const =0

        Return the number of different values used for "properties".

        For example, the number of colors or the number of parts used for the
        overall graph/matrix.

        Global number of values for properties

        Infact, it returns the upper bound of the interval of taken values.
        For example, for the colors "1,2,4" , it will return "4" 
        """
        return ___init__.Operator_numProperties(self, *args)


    def numLocalProperties(self, *args):
        """
        numLocalProperties(Operator self) -> int

        virtual int Isorropia::Operator::numLocalProperties() const =0

        Return the number of different values used for "properties" for this
        process only.

        Local number of values for properties 
        """
        return ___init__.Operator_numLocalProperties(self, *args)


    def numElemsWithProperty(self, *args):
        """
        numElemsWithProperty(Operator self, int property) -> int

        virtual int Isorropia::Operator::numElemsWithProperty(int property)
        const =0

        Return the number of LOCAL elements with the given property.

        Parameters:
        -----------

        property:  Value of the property to consider.

        Number of local elems which have this property. 
        """
        return ___init__.Operator_numElemsWithProperty(self, *args)


    def elemsWithProperty(self, *args):
        """
        elemsWithProperty(Operator self, int property, int * elementList, int len)

        virtual void Isorropia::Operator::elemsWithProperty(int property, int
        *elementList, int len) const =0

        Fill user-allocated list (of length len) with the local element ids of
        the LOCAL elements with the given property.

        Parameters:
        -----------

        property:  Value of the property to consider.

        elementList:  User allocated array (of size at least len) of local ID
        that have the asked property.

        len:  Maximum lenght for the array. If len is greater than the result
        of numElemsWithProperty() for property, only the first and relevant
        elements are filled.

        Memory space which is not useful in the array is not initialized or
        used in this method. 
        """
        return ___init__.Operator_elemsWithProperty(self, *args)


    def extractPropertiesView(self, *args):
        """
        extractPropertiesView(Operator self, int & size, int const *& array) -> int

        virtual int Isorropia::Operator::extractPropertiesView(int &size,
        const int *&array) const =0

        Give access of the property array that is owned by the current
        processor.

        Parameters:
        -----------

        size:  Number of elements in the array.

        array:  Pointer to the the properties array inside the object.

        This pointer is only significant if the object still exists.
        Otherwise, you must use

        See:   Isorropia::Operator::extractPropertiesCopy().

        See:   Isorropia::Operator::extractPropertiesCopy() 
        """
        return ___init__.Operator_extractPropertiesView(self, *args)


    def extractPropertiesCopy(self, *args):
        """
        extractPropertiesCopy(Operator self, int len, int & size, int * array) -> int

        virtual int Isorropia::Operator::extractPropertiesCopy(int len, int
        &size, int *array) const =0

        Copy a part of the property array.

        Parameters:
        -----------

        len:  of the array given by the user.

        size:  Number of elements in the array.

        array:  Array of properties. Allocated by the user with a size of at
        least len elements.

        Memory space which is not useful in the array is not initialized or
        used in this method.

        See:   Isorropia::Operator::extractPropertiesView() 
        """
        return ___init__.Operator_extractPropertiesCopy(self, *args)

Operator_swigregister = ___init__.Operator_swigregister
Operator_swigregister(Operator)

class Colorer(Operator):
    """


    Interface (abstract base class) for computing a new coloring and
    describing the result.

    The colors returned have values between 1 and C, where C is the number
    of colors used.

    C++ includes: Isorropia_Colorer.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Colorer, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Colorer, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Colorer

    def color(self, *args):
        """
        color(Colorer self, bool forceColoring=False)

        virtual void
        Isorropia::Colorer::color(bool forceColoring=false)=0

        Method which does the work of computing a new coloring.

        Parameters:
        -----------

        forceColoring:  Optional argument defaults to false. Depending on the
        implementation, color() should only perform a coloring the first time
        it is called, and subsequent repeated calls are no-ops. If the user's
        intent is to re- compute the coloring (e.g., if parameters or other
        inputs have been changed), then setting this flag to true will force a
        new coloring to be computed. 
        """
        return ___init__.Colorer_color(self, *args)


    def numColors(self, *args):
        """
        numColors(Colorer self) -> int

        virtual int
        Isorropia::Colorer::numColors() const

        Method which returns the number (global) of colors used.

        The overall number of colors used. All colors used for all vertices
        are between 1 and this value (included).

        See:   Isorropia::Operator::numProperties() 
        """
        return ___init__.Colorer_numColors(self, *args)


    def numElemsWithColor(self, *args):
        """
        numElemsWithColor(Colorer self, int theColor) -> int

        virtual
        int Isorropia::Colorer::numElemsWithColor(int theColor) const

        Return the number of local elements of a given color.

        Parameters:
        -----------

        theColor:  The wanted color.

        The number of local of the asked color.

        See:   Isorropia::Operator::numElemsWithProperty() 
        """
        return ___init__.Colorer_numElemsWithColor(self, *args)


    def extractColorsView(self, *args):
        """
        extractColorsView(Colorer self, int & size, int const *& array) -> int

        virtual
        int Isorropia::Colorer::extractColorsView(int &size, const int
        *&array) const

        Give access of the color assignments array that is owned by the
        current processor.

        Parameters:
        -----------

        size:  Number of elements in the array.

        array:  Pointer to the color assignements array inside the object.

        This pointer is only significant if the object still exists.
        Otherwise, you must use

        See:  Isorropia::Operator::extractPartsCopy()

        See:   Isorropia::Operator::extractPropertiesView() 
        """
        return ___init__.Colorer_extractColorsView(self, *args)


    def extractColorsCopy(self, *args):
        """
        extractColorsCopy(Colorer self, int len, int & size, int * array) -> int

        virtual
        int Isorropia::Colorer::extractColorsCopy(int len, int &size, int
        *array) const

        Copy a part of the color assignments array.

        Parameters:
        -----------

        len:  of the array given by the user.

        size:  Number of elements in the array.

        array:  Array of color assignments. Allocated by the user with a size
        of at least len elements.

        Memory space which is not useful in the array is not initialized or
        used in this method.

        See:   Isorropia::Operator::extractPropertiesCopy() 
        """
        return ___init__.Colorer_extractColorsCopy(self, *args)


    def elemsWithColor(self, *args):
        """
        elemsWithColor(Colorer self, int color) -> PyObject *

        virtual
        void Isorropia::Colorer::elemsWithColor(int theColor, int
        *elementList, int len) const

        Fill user-allocated list (of length len) with the local element ids
        for LOCAL elements of the given color.

        Parameters:
        -----------

        theColor:  the wanted color

        elementList:  an array to receive local elements of the given color

        len:  the number of elements wanted

        See:   Isorropia::Operator::elemsWithProperty() 
        """
        return ___init__.Colorer_elemsWithColor(self, *args)

Colorer_swigregister = ___init__.Colorer_swigregister
Colorer_swigregister(Colorer)

class Partitioner(Operator):
    """


    Interface (abstract base class) for computing a new partitioning and
    describing the layout of elements in the new partition (the parts).

    If the methods which describe the new partitioning (e.g., operator [],
    elemsInPart()) are called before compute_partitioning() has been
    called, behavior is not well defined. Implementations will either
    return empty/erroneous data, or throw an exception. In most cases,
    implementations will probably call compute_partitioning() internally
    in a constructor or factory method, so this won't usually be an issue.

    C++ includes: Isorropia_Partitioner.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Partitioner, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Partitioner, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Partitioner

    def partition(self, *args):
        """
        partition(Partitioner self, bool forceRepartitioning=False)

        virtual
        void Isorropia::Partitioner::partition(bool
        forceRepartitioning=false)=0

        Method which does the work of computing a new partitioning.
        Implementations of this interface will typically be constructed with
        an object or information describing the existing ('old') partitioning.
        This method computes a 'new' rebalanced partitioning for that input
        data.

        Parameters:
        -----------

        forceRepartitioning:  Optional argument defaults to false. Depending
        on the implementation, partitioning() should only perform a
        repartitioning the first time it is called, and subsequent repeated
        calls are no-ops. If the user's intent is to re-compute the
        partitioning (e.g., if parameters or other inputs have been changed),
        then setting this flag to true will force a new partitioning to be
        computed.

        See:   Isorropia::Operator::compute() 
        """
        return ___init__.Partitioner_partition(self, *args)


    def numElemsInPart(self, *args):
        """
        numElemsInPart(Partitioner self, int part) -> int

        virtual int Isorropia::Partitioner::numElemsInPart(int part) const =0

        Return the number of LOCAL elements in a given part.

        Parameters:
        -----------

        part:  the part ID we want to know the number of local elements.

        number of local elements that belongs to the given part.

        See:   Isorropia::Operator::numElemsWithProperty() 
        """
        return ___init__.Partitioner_numElemsInPart(self, *args)


    def elemsInPart(self, *args):
        """
        elemsInPart(Partitioner self, int part, int * elementList, int len)

        virtual
        void Isorropia::Partitioner::elemsInPart(int part, int *elementList,
        int len) const =0

        Fill user-allocated list (of length len) with the local element ids to
        be located in the given part

        Parameters:
        -----------

        part:  the part ID we consider

        elementList:  array of elements that belongs to this part ID, must be
        allocated by user with size at least len

        len:  maximum number of elements we can put in the array. Usually, may
        be the result of Isorropia::Partitioner::numElemsInPart(). .

        See:   Isorropia::Operator::elemsWithProperty() 
        """
        return ___init__.Partitioner_elemsInPart(self, *args)


    def extractPartsView(self, *args):
        """
        extractPartsView(Partitioner self, int & size, int const *& array) -> int

        virtual int Isorropia::Partitioner::extractPartsView(int &size, const
        int *&array) const

        Give access of the part assignments array that is owned by the current
        processor.

        Parameters:
        -----------

        size:  Number of elements in the array.

        array:  Pointer to the the part assignements array inside the object.

        This pointer is only significant if the object still exists.
        Otherwise, you must use

        See:  Isorropia::Operator::extractPartsCopy()

        See:   Isorropia::Operator::extractPropertiesView() 
        """
        return ___init__.Partitioner_extractPartsView(self, *args)


    def extractPartsCopy(self, *args):
        """
        extractPartsCopy(Partitioner self, int len, int & size, int * array) -> int

        virtual int Isorropia::Partitioner::extractPartsCopy(int len, int
        &size, int *array) const

        Copy a part of the part assignment array.

        Parameters:
        -----------

        len:  of the array given by the user.

        size:  Number of elements in the array.

        array:  Array of part assignments. Allocated by the user with a size
        of at least len elements.

        Memory space which is not useful in the array is not initialized or
        used in this method.

        See:   Isorropia::Operator::extractPropertiesCopy() 
        """
        return ___init__.Partitioner_extractPartsCopy(self, *args)

Partitioner_swigregister = ___init__.Partitioner_swigregister
Partitioner_swigregister(Partitioner)

class Redistributor(_object):
    """


    Abstract base class for classes which are constructed with a
    Partitioner instance, and define methods to redistribute their
    objects.

    C++ includes: Isorropia_Redistributor.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Redistributor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Redistributor, name)
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Redistributor

    def __init__(self, *args):
        """__init__(Isorropia::Redistributor self) -> Redistributor"""
        this = ___init__.new_Redistributor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
Redistributor_swigregister = ___init__.Redistributor_swigregister
Redistributor_swigregister(Redistributor)

class CostDescriber(_object):
    """


    Interface (abstract base class) for describing the weights or costs
    associated with the vertices and/or edges or hyperedges of the object
    to be partitioned, ordered or colored.

    A CostDescriber object is created by the application. If no
    CostDescriber is supplied by the application, sensible default weights
    should be used.

    C++ includes: Isorropia_CostDescriber.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CostDescriber, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CostDescriber, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_CostDescriber
CostDescriber_swigregister = ___init__.CostDescriber_swigregister
CostDescriber_swigregister(CostDescriber)

class Orderer(Operator):
    """


    Interface (abstract base class) for computing a new ordering and
    describing the layout of elements in the new order.

    If the methods which describe the new ordering (e.g., operator[],
    etc.) are called before order() has been called, behavior is not well
    defined. Implementations will either return empty/erroneous data, or
    throw an exception. In most cases, implementations will probably call
    order() internally in a constructor or factory method, so this won't
    usually be an issue.

    C++ includes: Isorropia_Orderer.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Orderer, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Orderer, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_Orderer

    def order(self, *args):
        """
        order(Orderer self, bool forceOrdering=False)

        virtual void
        Isorropia::Orderer::order(bool forceOrdering=false)=0

        Method which does the work of computing a new ordering.

        Parameters:
        -----------

        forceOrdering:  Optional argument defaults to false. Depending on the
        implementation, compute_partitioning() should only perform a
        repartitioning the first time it is called, and subsequent repeated
        calls are no-ops. If the user's intent is to re-compute the
        partitioning (e.g., if parameters or other inputs have been changed),
        then setting this flag to true will force a new partitioning to be
        computed. 
        """
        return ___init__.Orderer_order(self, *args)


    def extractPermutationView(self, *args):
        """
        extractPermutationView(Orderer self, int & size, int const *& array) -> int

        virtual int Isorropia::Orderer::extractPermutationView(int &size,
        const int *&array) const

        Give access of the "direct" permutation vector that is owned by the
        current processor.

        Parameters:
        -----------

        size:  Number of elements in the array.

        array:  Pointer to the the part assignements array inside the object.

        This pointer is only significant if the object still exists.
        Otherwise, you must use

        See:  Isorropia::Operator::extractPartsCopy()

        See:   Isorropia::Operator::extractPropertiesView() 
        """
        return ___init__.Orderer_extractPermutationView(self, *args)


    def extractPermutationCopy(self, *args):
        """
        extractPermutationCopy(Orderer self, int len, int & size, int * array) -> int

        virtual int Isorropia::Orderer::extractPermutationCopy(int len, int
        &size, int *array) const

        Copy a part of the "direct" permutation vector.

        Parameters:
        -----------

        len:  of the array given by the user.

        size:  Number of elements in the array.

        array:  Direct permutation vector. Allocated by the user with a size
        of at least len elements.

        Memory space which is not useful in the array is not initialized or
        used in this method.

        See:   Isorropia::Operator::extractPropertiesCopy() 
        """
        return ___init__.Orderer_extractPermutationCopy(self, *args)

Orderer_swigregister = ___init__.Orderer_swigregister
Orderer_swigregister(Orderer)

class LevelScheduler(Operator):
    """


    Interface (abstract base class) for an operator that computes a
    partitioning of local elements into levels. On each process the levels
    begin at 1 and increase by 1. All elements in the same level can be
    used in calculation concurrently. All elements in level i are
    dependent upon the completion of the calculations involving the
    elements in level i-1.

    C++ includes: Isorropia_LevelScheduler.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LevelScheduler, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LevelScheduler, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = ___init__.delete_LevelScheduler

    def schedule(self, *args):
        """
        schedule(LevelScheduler self, bool forceScheduling=False)

        virtual
        void Isorropia::LevelScheduler::schedule(bool forceScheduling=false)=0

        Method which does the work of computing a new level schedule.

        Parameters:
        -----------

        forceScheduling:  Optional argument defaults to false. Depending on
        the implementation, schedule() should only perform a scheduling the
        first time it is called, and subsequent repeated calls are no-ops. If
        the user's intent is to re- compute the scheduling (e.g., if
        parameters or other inputs have been changed), then setting this flag
        to true will force a new scheduling to be computed. 
        """
        return ___init__.LevelScheduler_schedule(self, *args)


    def numLevels(self, *args):
        """
        numLevels(LevelScheduler self) -> int

        virtual
        int Isorropia::LevelScheduler::numLevels() const

        Method which returns the number of levels.

        The number of levels on the local process. Levels begin at 1 and
        increase by 1.

        See:   Isorropia::Operator::numProperties() 
        """
        return ___init__.LevelScheduler_numLevels(self, *args)


    def numElemsWithLevel(self, *args):
        """
        numElemsWithLevel(LevelScheduler self, int level) -> int

        virtual int Isorropia::LevelScheduler::numElemsWithLevel(int level)
        const

        Return the number of elements in a given level.

        Parameters:
        -----------

        level:  The wanted level.

        The number of elements in the level.

        See:   Isorropia::Operator::numElemsWithProperty() 
        """
        return ___init__.LevelScheduler_numElemsWithLevel(self, *args)


    def elemsWithLevel(self, *args):
        """
        elemsWithLevel(LevelScheduler self, int level, int * elementList, int len)

        virtual void Isorropia::LevelScheduler::elemsWithLevel(int level, int
        *elementList, int len) const

        Fill user-allocated list (of length len) with the local ID for each
        element in the given level.

        Parameters:
        -----------

        level:  the wanted level

        elementList:  an array to receive local elements of the given level

        len:  the number of elements wanted

        See:   Isorropia::Operator::elemsWithProperty() 
        """
        return ___init__.LevelScheduler_elemsWithLevel(self, *args)

LevelScheduler_swigregister = ___init__.LevelScheduler_swigregister
LevelScheduler_swigregister(LevelScheduler)


import sys, os.path as op
thisDir = op.dirname(op.abspath(__file__))
if not thisDir   in sys.path: sys.path.append(thisDir  )
del sys, op

# Epetra namespace
__all__ = ['Epetra']
import IsorropiaEpetra as Epetra

# This file is compatible with both classic and new-style classes.


