# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.IFPACK is the python interface to the Trilinos
preconditioner package IFPACK:

    http://trilinos.sandia.gov/packages/ifpack

The purpose of IFPACK is to provide incomplete foctorization
preconditioners to Trilinos.  Note that the C++ version of IFPACK uses
the prefix 'Ifpack_' which has been stripped from the python version.

IFPACK provides the following user-level classes:

    * Factory         - A factory for creating IFPACK preconditioners
    * Preconditioner  - Pure virtual base class for defining interface
    * IC              - Incomplete Cholesky preconditioner
    * ICT             - Incomplete Cholesky preconditioner w/threshold
    * ILU             - Incomplete lower/upper preconditioner
    * ILUT            - Incomplete lower/upper preconditioner w/threshold
    * PointRelaxation - Point relaxation predonditioner
    * Amesos          - Use Amesos factorizations as preconditioners

and functions:

    * AnalyzeMatrix          - Analyze the basic properties of a matrix
    * AnalyzeMatrixElements  - Analyze the distribution of values of a matrix
    * AnalyzeVectorElements  - Analyze the distribution of values of a vector
    * PrintSparsity          - Create PS file with sparsity pattern of matrix

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exIFPACK.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_IFPACK')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_IFPACK')
    _IFPACK = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_IFPACK', [dirname(__file__)])
        except ImportError:
            import _IFPACK
            return _IFPACK
        try:
            _mod = imp.load_module('_IFPACK', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _IFPACK = swig_import_helper()
    del swig_import_helper
else:
    import _IFPACK
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info

def Ifpack_Version(*args):
    """
    Ifpack_Version() -> std::string

    std::string Ifpack_Version()

    """
    return _IFPACK.Ifpack_Version(*args)

Version = Ifpack_Version
__version__ = Version().split()[3]


def Ifpack_PrintLine(*args):
    """
    Ifpack_PrintLine()

    void Ifpack_PrintLine()

    Prints a line of= on cout. 
    """
    return _IFPACK.Ifpack_PrintLine(*args)

def Ifpack_BreakForDebugger(*args):
    """
    Ifpack_BreakForDebugger(Comm Comm)

    void
    Ifpack_BreakForDebugger(Epetra_Comm &Comm)

    Stops the execution of code, so that a debugger can be attached. 
    """
    return _IFPACK.Ifpack_BreakForDebugger(*args)

def Ifpack_CreateOverlappingCrsMatrix(*args):
    """
    Ifpack_CreateOverlappingCrsMatrix(RowMatrix Matrix, int const OverlappingLevel) -> CrsMatrix
    Ifpack_CreateOverlappingCrsMatrix(CrsGraph Graph, int const OverlappingLevel) -> CrsGraph

    Epetra_CrsGraph* Ifpack_CreateOverlappingCrsMatrix(const
    Epetra_CrsGraph *Graph, const int OverlappingLevel)

    Creates an overlapping Epetra_CrsGraph. Returns 0 if OverlappingLevel
    is 0. 
    """
    return _IFPACK.Ifpack_CreateOverlappingCrsMatrix(*args)

def Ifpack_toString(*args):
    """
    Ifpack_toString(int const & x) -> std::string
    Ifpack_toString(double const & x) -> std::string

    std::string
    Ifpack_toString(const double &x)

    Converts a double to std::string. 
    """
    return _IFPACK.Ifpack_toString(*args)

def Ifpack_PrintResidual(*args):
    """
    Ifpack_PrintResidual(char * Label, RowMatrix A, MultiVector X, MultiVector Y) -> int
    Ifpack_PrintResidual(int const iter, RowMatrix A, MultiVector X, MultiVector Y) -> int

    int
    Ifpack_PrintResidual(const int iter, const Epetra_RowMatrix &A, const
    Epetra_MultiVector &X, const Epetra_MultiVector &Y) 
    """
    return _IFPACK.Ifpack_PrintResidual(*args)

def Ifpack_PrintSparsity_Simple(*args):
    """
    Ifpack_PrintSparsity_Simple(RowMatrix A)

    void
    Ifpack_PrintSparsity_Simple(const Epetra_RowMatrix &A) 
    """
    return _IFPACK.Ifpack_PrintSparsity_Simple(*args)

def AnalyzeMatrix(*args):
    """
    AnalyzeMatrix(RowMatrix A, bool const Cheap=False, int const NumPDEEqns=1) -> int

    int Ifpack_Analyze(const
    Epetra_RowMatrix &A, const bool Cheap=false, const int NumPDEEqns=1)

    Analyzes the basic properties of the input matrix A; see ifp_analyze.

    """
    return _IFPACK.AnalyzeMatrix(*args)

def AnalyzeMatrixElements(*args):
    """
    AnalyzeMatrixElements(RowMatrix A, bool const abs=False, int const steps=10) -> int

    int
    Ifpack_AnalyzeMatrixElements(const Epetra_RowMatrix &A, const bool
    abs=false, const int steps=10)

    Analyzes the distribution of values of the input matrix A.

    Parameters:
    -----------

    A:  - (In) matrix to be analyzed.

    abs:  - (In) if true, the function will analyze matrix B, whose
    elements are defined as $ B_{i,i} = | A_{i,i}| $.

    steps:  - (In) number of intervals for the analysis.

    An example of output is reported ifp_matrix. 
    """
    return _IFPACK.AnalyzeMatrixElements(*args)

def AnalyzeVectorElements(*args):
    """
    AnalyzeVectorElements(Vector Diagonal, bool const abs=False, int const steps=10) -> int

    int
    Ifpack_AnalyzeVectorElements(const Epetra_Vector &Diagonal, const bool
    abs=false, const int steps=10)

    Analyzes the distribution of values of the input vector Diagonal.

    Parameters:
    -----------

    Diagonal:  - (In) Vector to be analyzed.

    abs:  - (In) if true, the function will analyze vector B, whose
    elements are defined as $ B_{i} = | D_{i}| $.

    steps:  - (In) number of intervals for the analysis.

    An example of output is reported ifp_vector. 
    """
    return _IFPACK.AnalyzeVectorElements(*args)

def PrintSparsity(*args):
    """
    PrintSparsity(RowMatrix A, char const * FileName=None, int const NumPDEEqns=1) -> int

    int
    Ifpack_PrintSparsity(const Epetra_RowMatrix &A, const char
    *FileName=0, const int NumPDEEqns=1) 
    """
    return _IFPACK.PrintSparsity(*args)
class Ifpack_Element(_object):
    """Proxy of C++ Ifpack_Element class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Ifpack_Element, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Ifpack_Element, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_Element self) -> Ifpack_Element
        __init__(Ifpack_Element self, Ifpack_Element rhs) -> Ifpack_Element

        Ifpack_Element::Ifpack_Element(const Ifpack_Element &rhs) 
        """
        this = _IFPACK.new_Ifpack_Element(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Index(self, *args):
        """
        Index(Ifpack_Element self) -> int

        int
        Ifpack_Element::Index() const 
        """
        return _IFPACK.Ifpack_Element_Index(self, *args)


    def Value(self, *args):
        """
        Value(Ifpack_Element self) -> double

        double
        Ifpack_Element::Value() const 
        """
        return _IFPACK.Ifpack_Element_Value(self, *args)


    def AbsValue(self, *args):
        """
        AbsValue(Ifpack_Element self) -> double

        double
        Ifpack_Element::AbsValue() const 
        """
        return _IFPACK.Ifpack_Element_AbsValue(self, *args)


    def SetIndex(self, *args):
        """
        SetIndex(Ifpack_Element self, int const i)

        void
        Ifpack_Element::SetIndex(const int i) 
        """
        return _IFPACK.Ifpack_Element_SetIndex(self, *args)


    def SetValue(self, *args):
        """
        SetValue(Ifpack_Element self, double const val)

        void
        Ifpack_Element::SetValue(const double val) 
        """
        return _IFPACK.Ifpack_Element_SetValue(self, *args)


    def __lt__(self, *args):
        """__lt__(Ifpack_Element self, Ifpack_Element rhs) -> bool"""
        return _IFPACK.Ifpack_Element___lt__(self, *args)

    __swig_destroy__ = _IFPACK.delete_Ifpack_Element
Ifpack_Element_swigregister = _IFPACK.Ifpack_Element_swigregister
Ifpack_Element_swigregister(Ifpack_Element)

class Preconditioner(Epetra.Operator):
    """


    Ifpack_Preconditioner: basic class for preconditioning in Ifpack.

    Class Ifpack_Preconditioner is a pure virtual class, and it defines
    the structure of all Ifpack preconditioners.

    This class is a simple extension to Epetra_Operator. It provides the
    following additional methods:  Initialize() performs all operations
    based on the graph of the matrix (without considering the numerical
    values);

    IsInitialized() returns true if the preconditioner has been
    successfully initialized;

    Compute() computes all is required to apply the preconditioner, using
    matrix values (and assuming that the sparsity of the matrix has not
    been changed);

    IsComputed() should return true if the preconditioner has been
    successfully computed, false otherwise.

    Condest() returns an estimation of the condition number, or -1.0 if
    not available

    Matrix() returns a reference to the matrix to be preconditioned.

    It is required that Compute() call Initialize() if IsInitialized()
    returns false. The preconditioner is applied by ApplyInverse() (which
    returns if IsComputed() is false). Every time that Initialize() is
    called, the object destroys all the previously allocated information,
    and re-initialize the preconditioner. Every time Compute() is called,
    the object re-computed the actual values of the preconditioner.

    Estimating Preconditioner Condition Numbers

    The condition of a matrix $B$, called $cond_p(B)$, is defined as
    $cond_p(B) = \\|B\\|_p\\|B^{-1}\\|_p$ in some appropriate norm
    $p$. $cond_p(B)$ gives some indication of how many accurate floating
    point digits can be expected from operations involving the matrix and
    its inverse. A condition number approaching the accuracy of a given
    floating point number system, about 15 decimal digits in IEEE double
    precision, means that any results involving $B$ or $B^{-1}$ may be
    meaningless.

    Method Compute() can be use to estimate of the condition number.
    Compute() requires one parameter, of type Ifpack_CondestType (default
    value is Ifpack_Cheap; other valid choices are Ifpack_CG and
    Ifpack_GMRES).

    While Ifpack_CG and Ifpack_GMRES construct and AztecOO solver, and use
    methods AZ_cg_condnum and AZ_gmres_condnum to evaluate an accurate
    (but very expensive) estimate of the condition number, Ifpack_Cheap
    computes $\\|(P)^{-1}e\\|_\\infty$, which is only a very crude
    estimation of the actual condition number. Note that this estimated
    number can be less than 1.0. However, this approach has the following
    advantages: since finding $z$ such that $P z = y$ is a basic kernel
    for applying the preconditioner, computing this estimate of
    $cond_\\infty(P^{-1})$ is performed by setting $y = e$, calling the
    solve kernel to compute $z$ and then computing
    $\\|z\\|_\\infty$;

    the only cost is one application of the preconditioner.

    If this estimate is very large, the application of the computed
    preconditioner may generate large numerical errors. Hence, the user
    may check this number, and decide to recompute the preconditioner is
    the computed estimate is larger than a given threshold. This is
    particularly useful in ICT and RILUK factorizations, as for ill-
    conditioned matrices, we often have difficulty computing usable
    incomplete factorizations. The most common source of problems is that
    the factorization may encounter a small or zero pivot, in which case
    the factorization can fail, or even if the factorization succeeds, the
    factors may be so poorly conditioned that use of them in the iterative
    phase produces meaningless results. Before we can fix this problem, we
    must be able to detect it.

    If IFPACK is configured with Teuchos support, method SetParameters()
    should be adopted. Otherwise, users can set parameters (one
    at-a-time), using methods SetParameter(), for integers and doubles.
    Ifpack_Preconditioner objects overload the << operator. Derived
    classes should specify a Print() method, that will be used in operator
    <<.

    C++ includes: Ifpack_Preconditioner.h 
    """

    __swig_setmethods__ = {}
    for _s in [Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Preconditioner, name, value)
    __swig_getmethods__ = {}
    for _s in [Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Preconditioner, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def SetParameters(self, *args):
        """
        SetParameters(Preconditioner self, ParameterList List) -> int

        virtual
        int Ifpack_Preconditioner::SetParameters(Teuchos::ParameterList
        &List)=0

        Sets all parameters for the preconditioner. 
        """
        return _IFPACK.Preconditioner_SetParameters(self, *args)


    def Initialize(self, *args):
        """
        Initialize(Preconditioner self) -> int

        virtual int
        Ifpack_Preconditioner::Initialize()=0

        Computes all it is necessary to initialize the preconditioner. 
        """
        return _IFPACK.Preconditioner_Initialize(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(Preconditioner self) -> bool

        virtual
        bool Ifpack_Preconditioner::IsInitialized() const =0

        Returns true if the preconditioner has been successfully initialized,
        false otherwise. 
        """
        return _IFPACK.Preconditioner_IsInitialized(self, *args)


    def Compute(self, *args):
        """
        Compute(Preconditioner self) -> int

        virtual int
        Ifpack_Preconditioner::Compute()=0

        Computes all it is necessary to apply the preconditioner. 
        """
        return _IFPACK.Preconditioner_Compute(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(Preconditioner self) -> bool

        virtual
        bool Ifpack_Preconditioner::IsComputed() const =0

        Returns true if the preconditioner has been successfully computed,
        false otherwise. 
        """
        return _IFPACK.Preconditioner_IsComputed(self, *args)


    def Condest(self, *args):
        """
        Condest(Preconditioner self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix=None) -> double

        virtual double
        Ifpack_Preconditioner::Condest() const =0

        Returns the computed condition number estimate, or -1.0 if not
        computed. 
        """
        return _IFPACK.Preconditioner_Condest(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(Preconditioner self, MultiVector X, MultiVector Y) -> int

        virtual
        int Ifpack_Preconditioner::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const =0

        Applies the preconditioner to vector X, returns the result in Y. 
        """
        return _IFPACK.Preconditioner_ApplyInverse(self, *args)


    def Matrix(self, *args):
        """
        Matrix(Preconditioner self) -> RowMatrix

        virtual const
        Epetra_RowMatrix& Ifpack_Preconditioner::Matrix() const =0

        Returns a pointer to the matrix to be preconditioned. 
        """
        return _IFPACK.Preconditioner_Matrix(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(Preconditioner self) -> int

        virtual
        int Ifpack_Preconditioner::NumInitialize() const =0

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.Preconditioner_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(Preconditioner self) -> int

        virtual int
        Ifpack_Preconditioner::NumCompute() const =0

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.Preconditioner_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(Preconditioner self) -> int

        virtual int Ifpack_Preconditioner::NumApplyInverse() const =0

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.Preconditioner_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(Preconditioner self) -> double

        virtual
        double Ifpack_Preconditioner::InitializeTime() const =0

        Returns the time spent in Initialize(). 
        """
        return _IFPACK.Preconditioner_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(Preconditioner self) -> double

        virtual
        double Ifpack_Preconditioner::ComputeTime() const =0

        Returns the time spent in Compute(). 
        """
        return _IFPACK.Preconditioner_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(Preconditioner self) -> double

        virtual double Ifpack_Preconditioner::ApplyInverseTime() const =0

        Returns the time spent in ApplyInverse(). 
        """
        return _IFPACK.Preconditioner_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(Preconditioner self) -> double

        virtual double Ifpack_Preconditioner::InitializeFlops() const =0

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.Preconditioner_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(Preconditioner self) -> double

        virtual
        double Ifpack_Preconditioner::ComputeFlops() const =0

        Returns the number of flops in the computation phase. 
        """
        return _IFPACK.Preconditioner_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(Preconditioner self) -> double

        virtual double Ifpack_Preconditioner::ApplyInverseFlops() const =0

        Returns the number of flops in the application of the preconditioner.

        """
        return _IFPACK.Preconditioner_ApplyInverseFlops(self, *args)


    def __str__(self, *args):
        """__str__(Preconditioner self) -> std::string"""
        return _IFPACK.Preconditioner___str__(self, *args)

    __swig_destroy__ = _IFPACK.delete_Preconditioner
Preconditioner_swigregister = _IFPACK.Preconditioner_swigregister
Preconditioner_swigregister(Preconditioner)

class IC(Preconditioner):
    """


    Ifpack_IC: A class for constructing and using an incomplete Cholesky
    factorization of a given Epetra_RowMatrix.

    The Ifpack_IC class computes a threshold (not level) based incomplete
    LDL^T factorization of a given Epetra_RowMatrix. The factorization
    that is produced is a function of several parameters: Level of fill
    ratio. This defines the maximum number of entries per row/column in
    the factor, relative to the average number of nonzeros per row/col in
    A. The default value of 1.0 keeps the IC factor as sparse as A.

    Diagonal perturbation - Prior to computing the factorization, it is
    possible to modify the diagonal entries of the matrix for which the
    factorization will be computing. If the absolute and relative
    perturbation values are zero and one, respectively, the factorization
    will be compute for the original user matrix A. Otherwise, the
    factorization will computed for a matrix that differs from the
    original user matrix in the diagonal values only. Details can be found
    in ifp_diag_pert.

    C++ includes: Ifpack_IC.h 
    """

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IC, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IC, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_IC self, RowMatrix A) -> IC

        Ifpack_IC::Ifpack_IC(Epetra_RowMatrix *A)

        Ifpack_IC constuctor with variable number of indices per row.

        Creates a Ifpack_IC object and allocates storage.

        Parameters:
        -----------

        In:  A - User matrix to be factored.

        In:  Graph - Graph generated by Ifpack_IlukGraph. 
        """
        this = _IFPACK.new_IC(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_IC

    def SetAbsoluteThreshold(self, *args):
        """
        SetAbsoluteThreshold(IC self, double Athresh)

        void
        Ifpack_IC::SetAbsoluteThreshold(double Athresh)

        Set absolute threshold value. 
        """
        return _IFPACK.IC_SetAbsoluteThreshold(self, *args)


    def SetRelativeThreshold(self, *args):
        """
        SetRelativeThreshold(IC self, double Rthresh)

        void
        Ifpack_IC::SetRelativeThreshold(double Rthresh)

        Set relative threshold value. 
        """
        return _IFPACK.IC_SetRelativeThreshold(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(IC self, ParameterList parameterlis) -> int

        int
        Ifpack_IC::SetParameters(Teuchos::ParameterList &parameterlis)

        Set parameters using a Teuchos::ParameterList object. 
        """
        return _IFPACK.IC_SetParameters(self, *args)


    def SetParameter(self, *args):
        """
        SetParameter(IC self, std::string const Name, int const Value) -> int
        SetParameter(IC self, std::string const Name, double const Value) -> int

        int
        Ifpack_IC::SetParameter(const std::string Name, const double Value) 
        """
        return _IFPACK.IC_SetParameter(self, *args)


    def Matrix(self, *args):
        """
        Matrix(IC self) -> RowMatrix
        Matrix(IC self) -> RowMatrix

        Epetra_RowMatrix&
        Ifpack_IC::Matrix() 
        """
        return _IFPACK.IC_Matrix(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(IC self) -> bool

        bool
        Ifpack_IC::IsInitialized() const

        Returns true if the preconditioner has been successfully initialized,
        false otherwise. 
        """
        return _IFPACK.IC_IsInitialized(self, *args)


    def Initialize(self, *args):
        """
        Initialize(IC self) -> int

        int
        Ifpack_IC::Initialize()

        Initialize L and U with values from user matrix A.

        Copies values from the user's matrix into the nonzero pattern of L and
        U.

        Parameters:
        -----------

        In:  A - User matrix to be factored.

        WARNING:  The graph of A must be identical to the graph passed in to
        Ifpack_IlukGraph constructor. 
        """
        return _IFPACK.IC_Initialize(self, *args)


    def Compute(self, *args):
        """
        Compute(IC self) -> int

        int Ifpack_IC::Compute()

        Compute IC factor U using the specified graph, diagonal perturbation
        thresholds and relaxation parameters.

        This function computes the RILU(k) factors L and U using the current:
        Ifpack_IlukGraph specifying the structure of L and U.

        Value for the RILU(k) relaxation parameter.

        Value for the a priori diagonal threshold values.  InitValues() must
        be called before the factorization can proceed. 
        """
        return _IFPACK.IC_Compute(self, *args)


    def ComputeSetup(self, *args):
        """
        ComputeSetup(IC self) -> int

        int
        Ifpack_IC::ComputeSetup() 
        """
        return _IFPACK.IC_ComputeSetup(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(IC self) -> bool

        bool
        Ifpack_IC::IsComputed() const

        If factor is completed, this query returns true, otherwise it returns
        false. 
        """
        return _IFPACK.IC_IsComputed(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(IC self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_IC::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Ifpack_IC forward/back solve on a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  Trans -If true, solve transpose problem.

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _IFPACK.IC_ApplyInverse(self, *args)


    def Apply(self, *args):
        """
        Apply(IC self, MultiVector X, MultiVector Y) -> int

        int Ifpack_IC::Apply(const
        Epetra_MultiVector &X, Epetra_MultiVector &Y) const 
        """
        return _IFPACK.IC_Apply(self, *args)


    def Condest(self, *args):
        """
        Condest(IC self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double

        double
        Ifpack_IC::Condest() const

        Returns the computed condition number estimate, or -1.0 if not
        computed. 
        """
        return _IFPACK.IC_Condest(self, *args)


    def GetAbsoluteThreshold(self, *args):
        """
        GetAbsoluteThreshold(IC self) -> double

        double
        Ifpack_IC::GetAbsoluteThreshold()

        Get absolute threshold value. 
        """
        return _IFPACK.IC_GetAbsoluteThreshold(self, *args)


    def GetRelativeThreshold(self, *args):
        """
        GetRelativeThreshold(IC self) -> double

        double
        Ifpack_IC::GetRelativeThreshold()

        Get relative threshold value. 
        """
        return _IFPACK.IC_GetRelativeThreshold(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(IC self) -> int

        int
        Ifpack_IC::NumGlobalNonzeros() const

        Returns the number of nonzero entries in the global graph. 
        """
        return _IFPACK.IC_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(IC self) -> long long

        long long
        Ifpack_IC::NumGlobalNonzeros64() const 
        """
        return _IFPACK.IC_NumGlobalNonzeros64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(IC self) -> int

        int
        Ifpack_IC::NumMyNonzeros() const

        Returns the number of nonzero entries in the local graph. 
        """
        return _IFPACK.IC_NumMyNonzeros(self, *args)


    def D(self, *args):
        """
        D(IC self) -> Vector

        const Epetra_Vector&
        Ifpack_IC::D() const

        Returns the address of the D factor associated with this factored
        matrix. 
        """
        return _IFPACK.IC_D(self, *args)


    def U(self, *args):
        """
        U(IC self) -> CrsMatrix

        const Epetra_CrsMatrix&
        Ifpack_IC::U() const

        Returns the address of the U factor associated with this factored
        matrix. 
        """
        return _IFPACK.IC_U(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(IC self, bool UseTranspose_in) -> int

        int
        Ifpack_IC::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose_in -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Always returns 0. 
        """
        return _IFPACK.IC_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """
        NormInf(IC self) -> double

        double
        Ifpack_IC::NormInf() const

        Returns 0.0 because this class cannot compute Inf-norm. 
        """
        return _IFPACK.IC_NormInf(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(IC self) -> bool

        bool
        Ifpack_IC::HasNormInf() const

        Returns false because this class cannot compute an Inf-norm. 
        """
        return _IFPACK.IC_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(IC self) -> bool

        bool
        Ifpack_IC::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _IFPACK.IC_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(IC self) -> Map

        const
        Epetra_Map& Ifpack_IC::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _IFPACK.IC_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(IC self) -> Map

        const Epetra_Map&
        Ifpack_IC::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _IFPACK.IC_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """
        Comm(IC self) -> Comm

        const Epetra_Comm&
        Ifpack_IC::Comm() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return _IFPACK.IC_Comm(self, *args)


    def Label(self, *args):
        """
        Label(IC self) -> char const *

        const char*
        Ifpack_IC::Label() const 
        """
        return _IFPACK.IC_Label(self, *args)


    def SetLabel(self, *args):
        """
        SetLabel(IC self, char const * Label_in) -> int

        int
        Ifpack_IC::SetLabel(const char *Label_in) 
        """
        return _IFPACK.IC_SetLabel(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(IC self) -> int

        virtual int
        Ifpack_IC::NumInitialize() const

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.IC_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(IC self) -> int

        virtual int
        Ifpack_IC::NumCompute() const

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.IC_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(IC self) -> int

        virtual int
        Ifpack_IC::NumApplyInverse() const

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.IC_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(IC self) -> double

        virtual double
        Ifpack_IC::InitializeTime() const

        Returns the time spent in Initialize(). 
        """
        return _IFPACK.IC_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(IC self) -> double

        virtual double
        Ifpack_IC::ComputeTime() const

        Returns the time spent in Compute(). 
        """
        return _IFPACK.IC_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(IC self) -> double

        virtual double
        Ifpack_IC::ApplyInverseTime() const

        Returns the time spent in ApplyInverse(). 
        """
        return _IFPACK.IC_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(IC self) -> double

        virtual double
        Ifpack_IC::InitializeFlops() const

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.IC_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(IC self) -> double

        virtual double
        Ifpack_IC::ComputeFlops() const

        Returns the number of flops in the computation phase. 
        """
        return _IFPACK.IC_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(IC self) -> double

        virtual double
        Ifpack_IC::ApplyInverseFlops() const

        Returns the number of flops in the application of the preconditioner.

        """
        return _IFPACK.IC_ApplyInverseFlops(self, *args)

IC_swigregister = _IFPACK.IC_swigregister
IC_swigregister(IC)

class ICT(Preconditioner):
    """


    Ifpack_ICT: A class for constructing and using an incomplete Cholesky
    factorization of a given Epetra_RowMatrix.

    The Ifpack_ICT class computes a threshold based incomplete LDL^T
    factorization of a given Epetra_RowMatrix. The factorization that is
    produced is a function of several parameters: Maximum number of
    entries per row/column in factor - The factorization will contain at
    most this number of nonzero terms in each row/column of the
    factorization.

    Diagonal perturbation - Prior to computing the factorization, it is
    possible to modify the diagonal entries of the matrix for which the
    factorization will be computing. If the absolute and relative
    perturbation values are zero and one, respectively, the factorization
    will be compute for the original user matrix A. Otherwise, the
    factorization will computed for a matrix that differs from the
    original user matrix in the diagonal values only. Details can be found
    in ifp_diag_pert.

    C++ includes: Ifpack_ICT.h 
    """

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ICT, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ICT, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_ICT self, RowMatrix A) -> ICT

        Ifpack_ICT::Ifpack_ICT(const Epetra_RowMatrix *A)

        Ifpack_ICT constuctor with variable number of indices per row.

        Creates a Ifpack_ICT object and allocates storage.

        Parameters:
        -----------

        In:  A - User matrix to be factored.

        In:  Graph - Graph generated by Ifpack_IlukGraph. 
        """
        this = _IFPACK.new_ICT(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_ICT

    def SetParameters(self, *args):
        """
        SetParameters(ICT self, ParameterList parameterlis) -> int

        int
        Ifpack_ICT::SetParameters(Teuchos::ParameterList &parameterlis)

        Set parameters using a Teuchos::ParameterList object. 
        """
        return _IFPACK.ICT_SetParameters(self, *args)


    def Matrix(self, *args):
        """
        Matrix(ICT self) -> RowMatrix

        const Epetra_RowMatrix&
        Ifpack_ICT::Matrix() const

        Returns a reference to the matrix to be preconditioned. 
        """
        return _IFPACK.ICT_Matrix(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(ICT self) -> bool

        bool
        Ifpack_ICT::IsInitialized() const

        Returns true is the preconditioner has been successfully initialized.

        """
        return _IFPACK.ICT_IsInitialized(self, *args)


    def Initialize(self, *args):
        """
        Initialize(ICT self) -> int

        int
        Ifpack_ICT::Initialize()

        Initialize L and U with values from user matrix A.

        Copies values from the user's matrix into the nonzero pattern of L and
        U.

        Parameters:
        -----------

        In:  A - User matrix to be factored.

        WARNING:  The graph of A must be identical to the graph passed in to
        Ifpack_IlukGraph constructor. 
        """
        return _IFPACK.ICT_Initialize(self, *args)


    def Compute(self, *args):
        """
        Compute(ICT self) -> int

        int Ifpack_ICT::Compute()

        Compute IC factor U using the specified graph, diagonal perturbation
        thresholds and relaxation parameters.

        This function computes the RILU(k) factors L and U using the current:
        Ifpack_IlukGraph specifying the structure of L and U.

        Value for the RILU(k) relaxation parameter.

        Value for the a priori diagonal threshold values.  InitValues() must
        be called before the factorization can proceed. 
        """
        return _IFPACK.ICT_Compute(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(ICT self) -> bool

        bool
        Ifpack_ICT::IsComputed() const

        If factor is completed, this query returns true, otherwise it returns
        false. 
        """
        return _IFPACK.ICT_IsComputed(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(ICT self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_ICT::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Ifpack_ICT forward/back solve on a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  Trans -If true, solve transpose problem.

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _IFPACK.ICT_ApplyInverse(self, *args)


    def Apply(self, *args):
        """
        Apply(ICT self, MultiVector X, MultiVector Y) -> int

        int Ifpack_ICT::Apply(const
        Epetra_MultiVector &X, Epetra_MultiVector &Y) const 
        """
        return _IFPACK.ICT_Apply(self, *args)


    def Condest(self, *args):
        """
        Condest(ICT self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double

        double
        Ifpack_ICT::Condest() const

        Returns the computed condition number estimate, or -1.0 if not
        computed. 
        """
        return _IFPACK.ICT_Condest(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(ICT self) -> int

        int
        Ifpack_ICT::NumGlobalNonzeros() const

        Returns the number of nonzero entries in the global graph. 
        """
        return _IFPACK.ICT_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(ICT self) -> long long

        long long
        Ifpack_ICT::NumGlobalNonzeros64() const 
        """
        return _IFPACK.ICT_NumGlobalNonzeros64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(ICT self) -> int

        int
        Ifpack_ICT::NumMyNonzeros() const

        Returns the number of nonzero entries in the local graph. 
        """
        return _IFPACK.ICT_NumMyNonzeros(self, *args)


    def H(self, *args):
        """
        H(ICT self) -> CrsMatrix

        const Epetra_CrsMatrix&
        Ifpack_ICT::H() const

        Returns the address of the D factor associated with this factored
        matrix. 
        """
        return _IFPACK.ICT_H(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(ICT self, bool UseTranspose_in) -> int

        int
        Ifpack_ICT::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose_in -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Always returns 0. 
        """
        return _IFPACK.ICT_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """
        NormInf(ICT self) -> double

        double
        Ifpack_ICT::NormInf() const

        Returns 0.0 because this class cannot compute Inf-norm. 
        """
        return _IFPACK.ICT_NormInf(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(ICT self) -> bool

        bool
        Ifpack_ICT::HasNormInf() const

        Returns false because this class cannot compute an Inf-norm. 
        """
        return _IFPACK.ICT_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(ICT self) -> bool

        bool
        Ifpack_ICT::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _IFPACK.ICT_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(ICT self) -> Map

        const
        Epetra_Map& Ifpack_ICT::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _IFPACK.ICT_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(ICT self) -> Map

        const
        Epetra_Map& Ifpack_ICT::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _IFPACK.ICT_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """
        Comm(ICT self) -> Comm

        const Epetra_Comm&
        Ifpack_ICT::Comm() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return _IFPACK.ICT_Comm(self, *args)


    def Label(self, *args):
        """
        Label(ICT self) -> char const *

        const char*
        Ifpack_ICT::Label() const 
        """
        return _IFPACK.ICT_Label(self, *args)


    def SetLabel(self, *args):
        """
        SetLabel(ICT self, char const * Label_in) -> int

        int
        Ifpack_ICT::SetLabel(const char *Label_in) 
        """
        return _IFPACK.ICT_SetLabel(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(ICT self) -> int

        virtual int
        Ifpack_ICT::NumInitialize() const

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.ICT_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(ICT self) -> int

        virtual int
        Ifpack_ICT::NumCompute() const

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.ICT_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(ICT self) -> int

        virtual int
        Ifpack_ICT::NumApplyInverse() const

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.ICT_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(ICT self) -> double

        virtual double
        Ifpack_ICT::InitializeTime() const

        Returns the time spent in Initialize(). 
        """
        return _IFPACK.ICT_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(ICT self) -> double

        virtual double
        Ifpack_ICT::ComputeTime() const

        Returns the time spent in Compute(). 
        """
        return _IFPACK.ICT_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(ICT self) -> double

        virtual double
        Ifpack_ICT::ApplyInverseTime() const

        Returns the time spent in ApplyInverse(). 
        """
        return _IFPACK.ICT_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(ICT self) -> double

        virtual double
        Ifpack_ICT::InitializeFlops() const

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.ICT_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(ICT self) -> double

        virtual double
        Ifpack_ICT::ComputeFlops() const

        Returns the number of flops in all applications of Compute(). 
        """
        return _IFPACK.ICT_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(ICT self) -> double

        virtual double
        Ifpack_ICT::ApplyInverseFlops() const

        Returns the number of flops in all applications of ApplyInverse(). 
        """
        return _IFPACK.ICT_ApplyInverseFlops(self, *args)


    def LevelOfFill(self, *args):
        """
        LevelOfFill(ICT self) -> double

        double
        Ifpack_ICT::LevelOfFill() const

        Returns the level-of-fill.

        : if 1.0, then the factored matrix contains approximatively the same
        number of elements of A. 
        """
        return _IFPACK.ICT_LevelOfFill(self, *args)


    def AbsoluteThreshold(self, *args):
        """
        AbsoluteThreshold(ICT self) -> double

        double
        Ifpack_ICT::AbsoluteThreshold() const

        Returns the absolute threshold. 
        """
        return _IFPACK.ICT_AbsoluteThreshold(self, *args)


    def RelativeThreshold(self, *args):
        """
        RelativeThreshold(ICT self) -> double

        double
        Ifpack_ICT::RelativeThreshold() const

        Returns the relative threshold. 
        """
        return _IFPACK.ICT_RelativeThreshold(self, *args)


    def RelaxValue(self, *args):
        """
        RelaxValue(ICT self) -> double

        double
        Ifpack_ICT::RelaxValue() const

        Returns the relaxation value. 
        """
        return _IFPACK.ICT_RelaxValue(self, *args)


    def DropTolerance(self, *args):
        """
        DropTolerance(ICT self) -> double

        double
        Ifpack_ICT::DropTolerance() const

        Returns the drop threshold. 
        """
        return _IFPACK.ICT_DropTolerance(self, *args)

ICT_swigregister = _IFPACK.ICT_swigregister
ICT_swigregister(ICT)

class ILU(Preconditioner):
    """


    Ifpack_ILU: A class for constructing and using an incomplete
    lower/upper (ILU) factorization of a given Epetra_RowMatrix.

    The Ifpack_ILU class computes a "relaxed" ILU factorization with
    level k fill of a given Epetra_RowMatrix. The notion of relaxation is
    the same as described in "Experimental study of ILU preconditioners
    for indefinite matrices" by Chow and Saad.

    Please refer to ifp_ilu for a general description of the ILU
    algorithm.

    The complete list of supported parameters is reported in page
    ifp_params.

    Mike Heroux, Marzio Sala, SNL 9214.

    C++ includes: Ifpack_ILU.h 
    """

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ILU, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ILU, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_ILU self, RowMatrix A) -> ILU

        Ifpack_ILU::Ifpack_ILU(Epetra_RowMatrix *A)

        Constructor. 
        """
        this = _IFPACK.new_ILU(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_ILU

    def Initialize(self, *args):
        """
        Initialize(ILU self) -> int

        int
        Ifpack_ILU::Initialize()

        Initialize the preconditioner, does not touch matrix values. 
        """
        return _IFPACK.ILU_Initialize(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(ILU self) -> bool

        bool
        Ifpack_ILU::IsInitialized() const

        Returns true if the preconditioner has been successfully initialized.

        """
        return _IFPACK.ILU_IsInitialized(self, *args)


    def Compute(self, *args):
        """
        Compute(ILU self) -> int

        int Ifpack_ILU::Compute()

        Compute ILU factors L and U using the specified graph, diagonal
        perturbation thresholds and relaxation parameters.

        This function computes the ILU(k) factors L and U using the current:
        Ifpack_IlukGraph specifying the structure of L and U.

        Value for the ILU(k) relaxation parameter.

        Value for the a priori diagonal threshold values.  InitValues() must
        be called before the factorization can proceed. 
        """
        return _IFPACK.ILU_Compute(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(ILU self) -> bool

        bool
        Ifpack_ILU::IsComputed() const

        If factor is completed, this query returns true, otherwise it returns
        false. 
        """
        return _IFPACK.ILU_IsComputed(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(ILU self, ParameterList parameterlist) -> int

        int
        Ifpack_ILU::SetParameters(Teuchos::ParameterList &parameterlist)

        Set parameters using a Teuchos::ParameterList object. 
        """
        return _IFPACK.ILU_SetParameters(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(ILU self, bool UseTranspose_in) -> int

        int
        Ifpack_ILU::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        UseTranspose_in:  - (In) If true, multiply by the transpose of
        operator, otherwise just use operator.

        Always returns 0. 
        """
        return _IFPACK.ILU_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(ILU self, MultiVector X, MultiVector Y) -> int

        int Ifpack_ILU::Apply(const
        Epetra_MultiVector &X, Epetra_MultiVector &Y) const 
        """
        return _IFPACK.ILU_Apply(self, *args)


    def Multiply(self, *args):
        """
        Multiply(ILU self, bool Trans, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_ILU::Multiply(bool Trans, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const 
        """
        return _IFPACK.ILU_Multiply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(ILU self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_ILU::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        In this implementation, we use several existing attributes to
        determine how virtual method ApplyInverse() should call the concrete
        method Solve(). We pass in the UpperTriangular(), the
        Epetra_CrsMatrix::UseTranspose(), and NoDiagonal() methods. The most
        notable warning is that if a matrix has no diagonal values we assume
        that there is an implicit unit diagonal that should be accounted for
        when doing a triangular solve.

        Parameters:
        -----------

        X:  - (In) A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y - (Out) A Epetra_MultiVector of dimension NumVectors
        containing result.

        Integer error code, set to 0 if successful. 
        """
        return _IFPACK.ILU_ApplyInverse(self, *args)


    def Condest(self, *args):
        """
        Condest(ILU self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double

        double
        Ifpack_ILU::Condest() const

        Returns the computed estimated condition number, or -1.0 if not
        computed. 
        """
        return _IFPACK.ILU_Condest(self, *args)


    def L(self, *args):
        """
        L(ILU self) -> CrsMatrix

        const Epetra_CrsMatrix&
        Ifpack_ILU::L() const

        Returns the address of the L factor associated with this factored
        matrix. 
        """
        return _IFPACK.ILU_L(self, *args)


    def D(self, *args):
        """
        D(ILU self) -> Vector

        const Epetra_Vector&
        Ifpack_ILU::D() const

        Returns the address of the D factor associated with this factored
        matrix. 
        """
        return _IFPACK.ILU_D(self, *args)


    def U(self, *args):
        """
        U(ILU self) -> CrsMatrix

        const Epetra_CrsMatrix&
        Ifpack_ILU::U() const

        Returns the address of the L factor associated with this factored
        matrix. 
        """
        return _IFPACK.ILU_U(self, *args)


    def Label(self, *args):
        """
        Label(ILU self) -> char const *

        const char*
        Ifpack_ILU::Label() const

        Returns a character string describing the operator. 
        """
        return _IFPACK.ILU_Label(self, *args)


    def SetLabel(self, *args):
        """
        SetLabel(ILU self, char const * Label_in) -> int

        int
        Ifpack_ILU::SetLabel(const char *Label_in)

        Sets label for this object. 
        """
        return _IFPACK.ILU_SetLabel(self, *args)


    def NormInf(self, *args):
        """
        NormInf(ILU self) -> double

        double
        Ifpack_ILU::NormInf() const

        Returns 0.0 because this class cannot compute Inf-norm. 
        """
        return _IFPACK.ILU_NormInf(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(ILU self) -> bool

        bool
        Ifpack_ILU::HasNormInf() const

        Returns false because this class cannot compute an Inf-norm. 
        """
        return _IFPACK.ILU_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(ILU self) -> bool

        bool
        Ifpack_ILU::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _IFPACK.ILU_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(ILU self) -> Map

        const
        Epetra_Map& Ifpack_ILU::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _IFPACK.ILU_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(ILU self) -> Map

        const
        Epetra_Map& Ifpack_ILU::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _IFPACK.ILU_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """
        Comm(ILU self) -> Comm

        const Epetra_Comm&
        Ifpack_ILU::Comm() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return _IFPACK.ILU_Comm(self, *args)


    def Matrix(self, *args):
        """
        Matrix(ILU self) -> RowMatrix

        const Epetra_RowMatrix&
        Ifpack_ILU::Matrix() const

        Returns a reference to the matrix to be preconditioned. 
        """
        return _IFPACK.ILU_Matrix(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(ILU self) -> int

        virtual int
        Ifpack_ILU::NumInitialize() const

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.ILU_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(ILU self) -> int

        virtual int
        Ifpack_ILU::NumCompute() const

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.ILU_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(ILU self) -> int

        virtual int
        Ifpack_ILU::NumApplyInverse() const

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.ILU_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(ILU self) -> double

        virtual double
        Ifpack_ILU::InitializeTime() const

        Returns the time spent in Initialize(). 
        """
        return _IFPACK.ILU_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(ILU self) -> double

        virtual double
        Ifpack_ILU::ComputeTime() const

        Returns the time spent in Compute(). 
        """
        return _IFPACK.ILU_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(ILU self) -> double

        virtual double
        Ifpack_ILU::ApplyInverseTime() const

        Returns the time spent in ApplyInverse(). 
        """
        return _IFPACK.ILU_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(ILU self) -> double

        virtual double
        Ifpack_ILU::InitializeFlops() const

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.ILU_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(ILU self) -> double

        virtual double
        Ifpack_ILU::ComputeFlops() const

        Returns the number of flops in the computation phase. 
        """
        return _IFPACK.ILU_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(ILU self) -> double

        virtual double
        Ifpack_ILU::ApplyInverseFlops() const

        Returns the number of flops in the application of the preconditioner.

        """
        return _IFPACK.ILU_ApplyInverseFlops(self, *args)

ILU_swigregister = _IFPACK.ILU_swigregister
ILU_swigregister(ILU)

class ILUT(Preconditioner):
    """


    Ifpack_ILUT: A class for constructing and using an incomplete LU
    factorization of a given Epetra_RowMatrix.

    The Ifpack_ILUT class computes a "Relaxed" ILUT factorization with
    dual threshold dropping of small elements of a given Epetra_RowMatrix.

    This implementation does not use the algorithm that is described in
    ifp_ilu. The algorithm drops entries in a row (i) of matrix A that are
    smaller than drop_tolerance even before the factorization of row i
    then computes the factorization for that row. This is different than
    the usual algorithm where the drop tolerance is applied to the
    factored rows.

    The complete list of supported parameters is reported in page
    ifp_params.

    Marzio Sala, SNL 9214.

    C++ includes: Ifpack_ILUT.h 
    """

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ILUT, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ILUT, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_ILUT self, RowMatrix A) -> ILUT

        Ifpack_ILUT::Ifpack_ILUT(const Epetra_RowMatrix *A)

        Ifpack_ILUT constuctor with variable number of indices per row. 
        """
        this = _IFPACK.new_ILUT(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_ILUT

    def SetParameters(self, *args):
        """
        SetParameters(ILUT self, ParameterList parameterlis) -> int

        int
        Ifpack_ILUT::SetParameters(Teuchos::ParameterList &parameterlis)

        Set parameters using a Teuchos::ParameterList object. 
        """
        return _IFPACK.ILUT_SetParameters(self, *args)


    def Initialize(self, *args):
        """
        Initialize(ILUT self) -> int

        int
        Ifpack_ILUT::Initialize()

        Initialize L and U with values from user matrix A.

        Copies values from the user's matrix into the nonzero pattern of L and
        U.

        Parameters:
        -----------

        In:  A - User matrix to be factored.

        WARNING:  The graph of A must be identical to the graph passed in to
        Ifpack_IlukGraph constructor. 
        """
        return _IFPACK.ILUT_Initialize(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(ILUT self) -> bool

        bool
        Ifpack_ILUT::IsInitialized() const

        Returns true if the preconditioner has been successfully initialized.

        """
        return _IFPACK.ILUT_IsInitialized(self, *args)


    def Compute(self, *args):
        """
        Compute(ILUT self) -> int

        int
        Ifpack_ILUT::Compute()

        Compute IC factor U using the specified graph, diagonal perturbation
        thresholds and relaxation parameters.

        This function computes the RILU(k) factors L and U using the current:
        Ifpack_IlukGraph specifying the structure of L and U.

        Value for the RILU(k) relaxation parameter.

        Value for the a priori diagonal threshold values.  InitValues() must
        be called before the factorization can proceed. 
        """
        return _IFPACK.ILUT_Compute(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(ILUT self) -> bool

        bool
        Ifpack_ILUT::IsComputed() const

        If factor is completed, this query returns true, otherwise it returns
        false. 
        """
        return _IFPACK.ILUT_IsComputed(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(ILUT self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_ILUT::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Ifpack_ILUT forward/back solve on a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        X:  - (In) A Epetra_MultiVector of dimension NumVectors to solve for.

        Y:  - (Out) A Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _IFPACK.ILUT_ApplyInverse(self, *args)


    def Apply(self, *args):
        """
        Apply(ILUT self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_ILUT::Apply(const Epetra_MultiVector &X, Epetra_MultiVector &Y)
        const 
        """
        return _IFPACK.ILUT_Apply(self, *args)


    def Condest(self, *args):
        """
        Condest(ILUT self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double

        double
        Ifpack_ILUT::Condest() const

        Returns the computed estimated condition number, or -1.0 if no
        computed. 
        """
        return _IFPACK.ILUT_Condest(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(ILUT self, bool UseTranspose_in) -> int

        int
        Ifpack_ILUT::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        UseTranspose_in:  - (In) If true, multiply by the transpose of
        operator, otherwise just use operator.

        Always returns 0. 
        """
        return _IFPACK.ILUT_SetUseTranspose(self, *args)


    def NormInf(self, *args):
        """
        NormInf(ILUT self) -> double

        double
        Ifpack_ILUT::NormInf() const

        Returns 0.0 because this class cannot compute Inf-norm. 
        """
        return _IFPACK.ILUT_NormInf(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(ILUT self) -> bool

        bool
        Ifpack_ILUT::HasNormInf() const

        Returns false because this class cannot compute an Inf-norm. 
        """
        return _IFPACK.ILUT_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(ILUT self) -> bool

        bool
        Ifpack_ILUT::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _IFPACK.ILUT_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(ILUT self) -> Map

        const
        Epetra_Map& Ifpack_ILUT::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _IFPACK.ILUT_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(ILUT self) -> Map

        const
        Epetra_Map& Ifpack_ILUT::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _IFPACK.ILUT_OperatorRangeMap(self, *args)


    def Comm(self, *args):
        """
        Comm(ILUT self) -> Comm

        const Epetra_Comm&
        Ifpack_ILUT::Comm() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return _IFPACK.ILUT_Comm(self, *args)


    def Matrix(self, *args):
        """
        Matrix(ILUT self) -> RowMatrix

        const Epetra_RowMatrix&
        Ifpack_ILUT::Matrix() const

        Returns a reference to the matrix to be preconditioned. 
        """
        return _IFPACK.ILUT_Matrix(self, *args)


    def L(self, *args):
        """
        L(ILUT self) -> CrsMatrix

        const Epetra_CrsMatrix&
        Ifpack_ILUT::L() const

        Returns a reference to the L factor. 
        """
        return _IFPACK.ILUT_L(self, *args)


    def U(self, *args):
        """
        U(ILUT self) -> CrsMatrix

        const Epetra_CrsMatrix&
        Ifpack_ILUT::U() const

        Returns a reference to the U factor. 
        """
        return _IFPACK.ILUT_U(self, *args)


    def Label(self, *args):
        """
        Label(ILUT self) -> char const *

        const char*
        Ifpack_ILUT::Label() const

        Returns the label of this object. 
        """
        return _IFPACK.ILUT_Label(self, *args)


    def SetLabel(self, *args):
        """
        SetLabel(ILUT self, char const * Label_in) -> int

        int
        Ifpack_ILUT::SetLabel(const char *Label_in)

        Sets the label for this object. 
        """
        return _IFPACK.ILUT_SetLabel(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(ILUT self) -> int

        virtual int
        Ifpack_ILUT::NumInitialize() const

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.ILUT_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(ILUT self) -> int

        virtual int
        Ifpack_ILUT::NumCompute() const

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.ILUT_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(ILUT self) -> int

        virtual int
        Ifpack_ILUT::NumApplyInverse() const

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.ILUT_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(ILUT self) -> double

        virtual double
        Ifpack_ILUT::InitializeTime() const

        Returns the time spent in Initialize(). 
        """
        return _IFPACK.ILUT_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(ILUT self) -> double

        virtual double
        Ifpack_ILUT::ComputeTime() const

        Returns the time spent in Compute(). 
        """
        return _IFPACK.ILUT_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(ILUT self) -> double

        virtual double
        Ifpack_ILUT::ApplyInverseTime() const

        Returns the time spent in ApplyInverse(). 
        """
        return _IFPACK.ILUT_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(ILUT self) -> double

        virtual double
        Ifpack_ILUT::InitializeFlops() const

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.ILUT_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(ILUT self) -> double

        virtual double
        Ifpack_ILUT::ComputeFlops() const

        Returns the number of flops in the computation phase. 
        """
        return _IFPACK.ILUT_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(ILUT self) -> double

        virtual double
        Ifpack_ILUT::ApplyInverseFlops() const

        Returns the number of flops in the application of the preconditioner.

        """
        return _IFPACK.ILUT_ApplyInverseFlops(self, *args)


    def LevelOfFill(self, *args):
        """
        LevelOfFill(ILUT self) -> double

        double
        Ifpack_ILUT::LevelOfFill() const 
        """
        return _IFPACK.ILUT_LevelOfFill(self, *args)


    def RelaxValue(self, *args):
        """
        RelaxValue(ILUT self) -> double

        double
        Ifpack_ILUT::RelaxValue() const

        Set relative threshold value. 
        """
        return _IFPACK.ILUT_RelaxValue(self, *args)


    def AbsoluteThreshold(self, *args):
        """
        AbsoluteThreshold(ILUT self) -> double

        double
        Ifpack_ILUT::AbsoluteThreshold() const

        Get absolute threshold value. 
        """
        return _IFPACK.ILUT_AbsoluteThreshold(self, *args)


    def RelativeThreshold(self, *args):
        """
        RelativeThreshold(ILUT self) -> double

        double
        Ifpack_ILUT::RelativeThreshold() const

        Get relative threshold value. 
        """
        return _IFPACK.ILUT_RelativeThreshold(self, *args)


    def DropTolerance(self, *args):
        """
        DropTolerance(ILUT self) -> double

        double
        Ifpack_ILUT::DropTolerance() const

        Gets the dropping tolerance. 
        """
        return _IFPACK.ILUT_DropTolerance(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(ILUT self) -> int

        int
        Ifpack_ILUT::NumGlobalNonzeros() const

        Returns the number of nonzero entries in the global graph. 
        """
        return _IFPACK.ILUT_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(ILUT self) -> long long

        long long
        Ifpack_ILUT::NumGlobalNonzeros64() const 
        """
        return _IFPACK.ILUT_NumGlobalNonzeros64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(ILUT self) -> int

        int
        Ifpack_ILUT::NumMyNonzeros() const

        Returns the number of nonzero entries in the local graph. 
        """
        return _IFPACK.ILUT_NumMyNonzeros(self, *args)

ILUT_swigregister = _IFPACK.ILUT_swigregister
ILUT_swigregister(ILUT)

class PointRelaxation(Preconditioner):
    """


    Ifpack_PointRelaxation: a class to define point relaxation
    preconditioners of for Epetra_RowMatrix's.

    The Ifpack_PointRelaxation class enables the construction of point
    relaxation preconditioners of an Epetra_RowMatrix.
    Ifpack_PointRelaxation is derived from the Ifpack_Preconditioner
    class, which is itself derived from Epetra_Operator. Therefore this
    object can be used as preconditioner everywhere an ApplyInverse()
    method is required in the preconditioning step.

    This class enables the construction of the following simple
    preconditioners: Jacobi;

    Gauss-Seidel;

    symmetric Gauss-Seidel.

    We now briefly describe the main features of the above
    preconditioners. Consider a linear system of type \\[ A x = b, \\]
    where $A$ is a square, real matrix, and $x, b$ are two real vectors.
    We begin with the decomposition \\[ A = D - E - F \\] where $D$ is
    the diagonal of A, $-E$ is the strict lower part, and $-F$ is the
    strict upper part. It is assumed that the diagonal entries of $A$ are
    different from zero.

    Given an starting solution $x_0$, an iteration of the (damped) Jacobi
    method can be written in matrix form as follows: \\[ x_{k+1} =
    \\omega D^{-1}(E + F) x_k + D_{-1}b, \\] for $k < k_{max}$, and
    $\\omega $ a damping parameter.

    Using Ifpack_Jacobi, the user can apply the specified number of sweeps
    ( $k_{max}$), and the damping parameter. If only one sweep is used,
    then the class simply applies the inverse of the diagonal of A to the
    input vector.

    Given an starting solution $x_0$, an iteration of the (damped)
    GaussSeidel method can be written in matrix form as follows: \\[ (D
    - E) x_{k+1} = \\omega F x_k + b, \\] for $k < k_{max}$, and
    $\\omega $ a damping parameter. Equivalently, the Gauss-Seidel
    preconditioner can be defined as \\[ P_{GS}^{-1} = (D - E)^{-1}.
    \\] Clearly, the role of E and F can be interchanged. However,
    Ifpack_GaussSeidel does not consider backward Gauss-Seidel methods.

    For a list of supported parameters, please refer to page ifp_params.

    The complete list of supported parameters is reported in page
    ifp_params. For a presentation of basic relaxation schemes, please
    refer to page Ifpack_PointRelaxation.

    Marzio Sala, SNL 9214.

    C++ includes: Ifpack_PointRelaxation.h 
    """

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointRelaxation, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PointRelaxation, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_PointRelaxation self, RowMatrix Matrix) -> PointRelaxation

        Ifpack_PointRelaxation::Ifpack_PointRelaxation(const
        Epetra_RowMatrix *Matrix)

        Ifpack_PointRelaxation constructor with given Epetra_RowMatrix.

        Creates an instance of Ifpack_PointRelaxation class.

        Parameters:
        -----------

        Matrix:  - (In) Pointer to matrix to precondition. 
        """
        this = _IFPACK.new_PointRelaxation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_PointRelaxation

    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(PointRelaxation self, bool UseTranspose_in) -> int

        virtual int Ifpack_PointRelaxation::SetUseTranspose(bool
        UseTranspose_in)

        This flag can be used to apply the preconditioner to the transpose of
        the input operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _IFPACK.PointRelaxation_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(PointRelaxation self, MultiVector X, MultiVector Y) -> int

        virtual int
        Ifpack_PointRelaxation::Apply(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Applies the matrix to an Epetra_MultiVector.

        Parameters:
        -----------

        X:  - (In) A Epetra_MultiVector of dimension NumVectors to multiply
        with matrix.

        Y:  - (Out) A Epetra_MultiVector of dimension NumVectors containing
        the result.

        Integer error code, set to 0 if successful. 
        """
        return _IFPACK.PointRelaxation_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(PointRelaxation self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_PointRelaxation::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Applies the preconditioner to X, returns the result in Y.

        Parameters:
        -----------

        X:  - (In) A Epetra_MultiVector of dimension NumVectors to be
        preconditioned.

        Y:  - (InOut) A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        WARNING:  This routine is NOT AztecOO complaint. 
        """
        return _IFPACK.PointRelaxation_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """
        NormInf(PointRelaxation self) -> double

        virtual
        double Ifpack_PointRelaxation::NormInf() const

        Returns the infinity norm of the global matrix (not implemented) 
        """
        return _IFPACK.PointRelaxation_NormInf(self, *args)


    def Label(self, *args):
        """
        Label(PointRelaxation self) -> char const *

        virtual const
        char* Ifpack_PointRelaxation::Label() const 
        """
        return _IFPACK.PointRelaxation_Label(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(PointRelaxation self) -> bool

        virtual
        bool Ifpack_PointRelaxation::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _IFPACK.PointRelaxation_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(PointRelaxation self) -> bool

        virtual
        bool Ifpack_PointRelaxation::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _IFPACK.PointRelaxation_HasNormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(PointRelaxation self) -> Comm

        const
        Epetra_Comm & Ifpack_PointRelaxation::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _IFPACK.PointRelaxation_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(PointRelaxation self) -> Map

        const Epetra_Map & Ifpack_PointRelaxation::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _IFPACK.PointRelaxation_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(PointRelaxation self) -> Map

        const Epetra_Map & Ifpack_PointRelaxation::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _IFPACK.PointRelaxation_OperatorRangeMap(self, *args)


    def Initialize(self, *args):
        """
        Initialize(PointRelaxation self) -> int

        int
        Ifpack_PointRelaxation::Initialize()

        Computes all it is necessary to initialize the preconditioner. 
        """
        return _IFPACK.PointRelaxation_Initialize(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(PointRelaxation self) -> bool

        virtual
        bool Ifpack_PointRelaxation::IsInitialized() const

        Returns true if the preconditioner has been successfully initialized,
        false otherwise. 
        """
        return _IFPACK.PointRelaxation_IsInitialized(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(PointRelaxation self) -> bool

        virtual
        bool Ifpack_PointRelaxation::IsComputed() const

        Returns true if the preconditioner has been successfully computed. 
        """
        return _IFPACK.PointRelaxation_IsComputed(self, *args)


    def Compute(self, *args):
        """
        Compute(PointRelaxation self) -> int

        int
        Ifpack_PointRelaxation::Compute()

        Computes the preconditioners. 
        """
        return _IFPACK.PointRelaxation_Compute(self, *args)


    def Matrix(self, *args):
        """
        Matrix(PointRelaxation self) -> RowMatrix

        virtual const
        Epetra_RowMatrix& Ifpack_PointRelaxation::Matrix() const

        Returns a pointer to the matrix to be preconditioned. 
        """
        return _IFPACK.PointRelaxation_Matrix(self, *args)


    def Condest(self, *args):
        """
        Condest(PointRelaxation self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix=None) -> double

        virtual
        double Ifpack_PointRelaxation::Condest() const

        Returns the condition number estimate, or -1.0 if not computed. 
        """
        return _IFPACK.PointRelaxation_Condest(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(PointRelaxation self, ParameterList List) -> int

        int
        Ifpack_PointRelaxation::SetParameters(Teuchos::ParameterList &List)

        Sets all the parameters for the preconditioner. 
        """
        return _IFPACK.PointRelaxation_SetParameters(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(PointRelaxation self) -> int

        virtual
        int Ifpack_PointRelaxation::NumInitialize() const

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.PointRelaxation_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(PointRelaxation self) -> int

        virtual
        int Ifpack_PointRelaxation::NumCompute() const

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.PointRelaxation_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(PointRelaxation self) -> int

        virtual int Ifpack_PointRelaxation::NumApplyInverse() const

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.PointRelaxation_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(PointRelaxation self) -> double

        virtual double Ifpack_PointRelaxation::InitializeTime() const

        Returns the time spent in Initialize(). 
        """
        return _IFPACK.PointRelaxation_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(PointRelaxation self) -> double

        virtual
        double Ifpack_PointRelaxation::ComputeTime() const

        Returns the time spent in Compute(). 
        """
        return _IFPACK.PointRelaxation_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(PointRelaxation self) -> double

        virtual double Ifpack_PointRelaxation::ApplyInverseTime() const

        Returns the time spent in ApplyInverse(). 
        """
        return _IFPACK.PointRelaxation_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(PointRelaxation self) -> double

        virtual double Ifpack_PointRelaxation::InitializeFlops() const

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.PointRelaxation_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(PointRelaxation self) -> double

        virtual
        double Ifpack_PointRelaxation::ComputeFlops() const

        Returns the number of flops in the computation phase. 
        """
        return _IFPACK.PointRelaxation_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(PointRelaxation self) -> double

        virtual double Ifpack_PointRelaxation::ApplyInverseFlops() const

        Returns the number of flops for the application of the preconditioner.

        """
        return _IFPACK.PointRelaxation_ApplyInverseFlops(self, *args)

PointRelaxation_swigregister = _IFPACK.PointRelaxation_swigregister
PointRelaxation_swigregister(PointRelaxation)

class Amesos(Preconditioner):
    """


    Ifpack_Amesos: a class to use Amesos' factorizations as
    preconditioners.

    Class Ifpack_Amesos enables the use of Amesos' factorizations as
    Ifpack_Preconditioners.

    Ifpack_Amesos is just a bare-bone wrap to Amesos. Currently, the only
    parameter required recognized by SetParameters() is "amesos: solver
    type" (defaulted to "Amesos_Klu"), which defined the Amesos solver.
    The Teuchos list in input to SetParameters() is copied, then the
    copied list is used to set the parameters of the Amesos object.

    This class works with matrices whose communicator contains only one
    process, that is, either serial matrices, or Ifpack_LocalFilter'd
    matrices.

    WARNING:  The number of flops is NOT updated.

    Marzio Sala, SNL 9214.

    C++ includes: Ifpack_Amesos.h 
    """

    __swig_setmethods__ = {}
    for _s in [Preconditioner]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Amesos, name, value)
    __swig_getmethods__ = {}
    for _s in [Preconditioner]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Amesos, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Ifpack_Amesos self, RowMatrix Matrix) -> Amesos
        __init__(Ifpack_Amesos self, Amesos rhs) -> Amesos

        Ifpack_Amesos::Ifpack_Amesos(const Ifpack_Amesos &rhs)

        Copy constructor. 
        """
        this = _IFPACK.new_Amesos(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_Amesos

    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(Amesos self, bool UseTranspose_in) -> int

        int
        Ifpack_Amesos::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied (not
        implemented).

        This flag allows the transpose of the given operator to be used
        implicitly.

        Parameters:
        -----------

        UseTranspose_in:  - (In) If true, multiply by the transpose of
        operator, otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _IFPACK.Amesos_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(Amesos self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_Amesos::Apply(const Epetra_MultiVector &X, Epetra_MultiVector
        &Y) const

        Applies the matrix to an Epetra_MultiVector.

        Parameters:
        -----------

        X:  - (In) A Epetra_MultiVector of dimension NumVectors to multiply
        with matrix.

        Y:  - (Out) A Epetra_MultiVector of dimension NumVectors containing
        the result.

        Integer error code, set to 0 if successful. 
        """
        return _IFPACK.Amesos_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(Amesos self, MultiVector X, MultiVector Y) -> int

        int
        Ifpack_Amesos::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Applies the preconditioner to X, returns the result in Y.

        Parameters:
        -----------

        X:  - (In) A Epetra_MultiVector of dimension NumVectors to be
        preconditioned.

        Y:  - (Out) A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        WARNING:  In order to work with AztecOO, any implementation of this
        method must support the case where X and Y are the same object. 
        """
        return _IFPACK.Amesos_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """
        NormInf(Amesos self) -> double

        double
        Ifpack_Amesos::NormInf() const

        Returns the infinity norm of the global matrix (not implemented) 
        """
        return _IFPACK.Amesos_NormInf(self, *args)


    def Label(self, *args):
        """
        Label(Amesos self) -> char const *

        const char *
        Ifpack_Amesos::Label() const

        Returns a character string describing the operator. 
        """
        return _IFPACK.Amesos_Label(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(Amesos self) -> bool

        bool
        Ifpack_Amesos::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _IFPACK.Amesos_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(Amesos self) -> bool

        bool
        Ifpack_Amesos::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _IFPACK.Amesos_HasNormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(Amesos self) -> Comm

        const Epetra_Comm &
        Ifpack_Amesos::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _IFPACK.Amesos_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(Amesos self) -> Map

        const
        Epetra_Map & Ifpack_Amesos::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _IFPACK.Amesos_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(Amesos self) -> Map

        const
        Epetra_Map & Ifpack_Amesos::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _IFPACK.Amesos_OperatorRangeMap(self, *args)


    def IsInitialized(self, *args):
        """
        IsInitialized(Amesos self) -> bool

        virtual bool
        Ifpack_Amesos::IsInitialized() const

        Returns true is the preconditioner has been successfully initialized.

        """
        return _IFPACK.Amesos_IsInitialized(self, *args)


    def Initialize(self, *args):
        """
        Initialize(Amesos self) -> int

        int
        Ifpack_Amesos::Initialize()

        Initializes the preconditioners.

        0 if successful, 1 if problems occurred. 
        """
        return _IFPACK.Amesos_Initialize(self, *args)


    def IsComputed(self, *args):
        """
        IsComputed(Amesos self) -> bool

        virtual bool
        Ifpack_Amesos::IsComputed() const

        Returns true if the preconditioner has been successfully computed. 
        """
        return _IFPACK.Amesos_IsComputed(self, *args)


    def Compute(self, *args):
        """
        Compute(Amesos self) -> int

        int
        Ifpack_Amesos::Compute()

        Computes the preconditioners.

        0 if successful, 1 if problems occurred. 
        """
        return _IFPACK.Amesos_Compute(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(Amesos self, ParameterList List) -> int

        int
        Ifpack_Amesos::SetParameters(Teuchos::ParameterList &List)

        Sets all the parameters for the preconditioner.

        Parameters currently supported:  "amesos: solver type" : Specifies
        the solver type for Amesos. Default: Amesos_Klu.

        The input list will be copied, then passed to the Amesos object
        through Amesos::SetParameters(). 
        """
        return _IFPACK.Amesos_SetParameters(self, *args)


    def Matrix(self, *args):
        """
        Matrix(Amesos self) -> RowMatrix

        virtual const
        Epetra_RowMatrix& Ifpack_Amesos::Matrix() const

        Returns a const reference to the internally stored matrix. 
        """
        return _IFPACK.Amesos_Matrix(self, *args)


    def Condest(self, *args):
        """
        Condest(Amesos self, Ifpack_CondestType const CT, int const MaxIters=1550, double const Tol=1e-9, RowMatrix Matrix_in=None) -> double

        virtual double
        Ifpack_Amesos::Condest() const

        Returns the estimated condition number, never computes it. 
        """
        return _IFPACK.Amesos_Condest(self, *args)


    def NumInitialize(self, *args):
        """
        NumInitialize(Amesos self) -> int

        virtual int
        Ifpack_Amesos::NumInitialize() const

        Returns the number of calls to Initialize(). 
        """
        return _IFPACK.Amesos_NumInitialize(self, *args)


    def NumCompute(self, *args):
        """
        NumCompute(Amesos self) -> int

        virtual int
        Ifpack_Amesos::NumCompute() const

        Returns the number of calls to Compute(). 
        """
        return _IFPACK.Amesos_NumCompute(self, *args)


    def NumApplyInverse(self, *args):
        """
        NumApplyInverse(Amesos self) -> int

        virtual int
        Ifpack_Amesos::NumApplyInverse() const

        Returns the number of calls to ApplyInverse(). 
        """
        return _IFPACK.Amesos_NumApplyInverse(self, *args)


    def InitializeTime(self, *args):
        """
        InitializeTime(Amesos self) -> double

        virtual double
        Ifpack_Amesos::InitializeTime() const

        Returns the total time spent in Initialize(). 
        """
        return _IFPACK.Amesos_InitializeTime(self, *args)


    def ComputeTime(self, *args):
        """
        ComputeTime(Amesos self) -> double

        virtual double
        Ifpack_Amesos::ComputeTime() const

        Returns the total time spent in Compute(). 
        """
        return _IFPACK.Amesos_ComputeTime(self, *args)


    def ApplyInverseTime(self, *args):
        """
        ApplyInverseTime(Amesos self) -> double

        virtual
        double Ifpack_Amesos::ApplyInverseTime() const

        Returns the total time spent in ApplyInverse(). 
        """
        return _IFPACK.Amesos_ApplyInverseTime(self, *args)


    def InitializeFlops(self, *args):
        """
        InitializeFlops(Amesos self) -> double

        virtual double
        Ifpack_Amesos::InitializeFlops() const

        Returns the number of flops in the initialization phase. 
        """
        return _IFPACK.Amesos_InitializeFlops(self, *args)


    def ComputeFlops(self, *args):
        """
        ComputeFlops(Amesos self) -> double

        virtual double
        Ifpack_Amesos::ComputeFlops() const

        Returns the total number of flops to computate the preconditioner. 
        """
        return _IFPACK.Amesos_ComputeFlops(self, *args)


    def ApplyInverseFlops(self, *args):
        """
        ApplyInverseFlops(Amesos self) -> double

        virtual
        double Ifpack_Amesos::ApplyInverseFlops() const

        Returns the total number of flops to apply the preconditioner. 
        """
        return _IFPACK.Amesos_ApplyInverseFlops(self, *args)


    def List(self, *args):
        """
        List(Amesos self) -> ParameterList

        virtual const
        Teuchos::ParameterList& Ifpack_Amesos::List() const 
        """
        return _IFPACK.Amesos_List(self, *args)

Amesos_swigregister = _IFPACK.Amesos_swigregister
Amesos_swigregister(Amesos)

class Factory(_object):
    """


    Ifpack: a function class to define Ifpack preconditioners.

    Class Ifpack is a function class, that contains just one method:
    Create(). Using Create(), users can easily define a variety of IFPACK
    preconditioners.

    Create requires 3 arguments: a std::string, indicating the
    preconditioner to be built;

    a pointer to an Epetra_RowMatrix, representing the matrix to be used
    to define the preconditioner;

    an interger (defaulted to 0), that specifies the amount of overlap
    among the processes.

    The first argument can assume the following values:  "point
    relaxation" : returns an instance of
    Ifpack_AdditiveSchwarz<Ifpack_PointRelaxation> (no Additive Schwarz in
    serial)

    "point relaxation stand-alone" : returns an instance of
    Ifpack_PointRelaxation (value of overlap is ignored).

    "block relaxation" : returns an instance of
    Ifpack_AdditiveSchwarz<Ifpack_BlockRelaxation> (no Additive Schwarz in
    serial)

    "block relaxation stand-alone)" : returns an instance of
    Ifpack_BlockRelaxation.

    "Amesos" : returns an instance of
    Ifpack_AdditiveSchwarz<Ifpack_Amesos> (no Additive Schwarz in serial)

    "Amesos stand-alone" : returns an instance of Ifpack_Amesos.

    "IC" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_IC> (no
    Additive Schwarz in serial)

    "IC stand-alone" : returns an instance of Ifpack_IC.

    "ICT" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_ICT>
    (no Additive Schwarz in serial)

    "ICT stand-alone" : returns an instance of Ifpack_ICT.

    "ILU" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_ILU>
    (no Additive Schwarz in serial)

    "ILU stand-alone" : returns an instance of Ifpack_ILU.

    "ILUT" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_ILUT>
    (no Additive Schwarz in serial)

    "ILUT stand-alone" : returns an instance of Ifpack_ILUT.

    otherwise, Create() returns 0.

    Objects in stand-alone mode cannot use reordering, variable overlap,
    and singleton filters. However, their construction can be slightly
    faster than the non stand-alone counterpart.

    The following fragment of code shows the basic usage of this class.

    Marzio Sala, (formally) SNL org. 1414

    C++ includes: Ifpack.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr
    POINT_RELAXATION = _IFPACK.Factory_POINT_RELAXATION
    POINT_RELAXATION_STAND_ALONE = _IFPACK.Factory_POINT_RELAXATION_STAND_ALONE
    BLOCK_RELAXATION = _IFPACK.Factory_BLOCK_RELAXATION
    BLOCK_RELAXATION_STAND_ALONE = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE
    BLOCK_RELAXATION_STAND_ALONE_ILU = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_ILU
    BLOCK_RELAXATION_STAND_ALONE_ILUT = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_ILUT
    BLOCK_RELAXATION_STAND_ALONE_IC = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_IC
    BLOCK_RELAXATION_STAND_ALONE_AMESOS = _IFPACK.Factory_BLOCK_RELAXATION_STAND_ALONE_AMESOS
    BLOCK_RELAXATION_AMESOS = _IFPACK.Factory_BLOCK_RELAXATION_AMESOS
    AMESOS = _IFPACK.Factory_AMESOS
    AMESOS_STAND_ALONE = _IFPACK.Factory_AMESOS_STAND_ALONE
    IC = _IFPACK.Factory_IC
    IC_STAND_ALONE = _IFPACK.Factory_IC_STAND_ALONE
    ICT = _IFPACK.Factory_ICT
    ICT_STAND_ALONE = _IFPACK.Factory_ICT_STAND_ALONE
    ILU = _IFPACK.Factory_ILU
    ILU_STAND_ALONE = _IFPACK.Factory_ILU_STAND_ALONE
    ILUT = _IFPACK.Factory_ILUT
    ILUT_STAND_ALONE = _IFPACK.Factory_ILUT_STAND_ALONE
    CHEBYSHEV = _IFPACK.Factory_CHEBYSHEV
    POLYNOMIAL = _IFPACK.Factory_POLYNOMIAL
    KRYLOV = _IFPACK.Factory_KRYLOV
    IHSS = _IFPACK.Factory_IHSS
    SORA = _IFPACK.Factory_SORA
    TRIDI_RELAXATION = _IFPACK.Factory_TRIDI_RELAXATION
    TRIDI_RELAXATION_STAND_ALONE = _IFPACK.Factory_TRIDI_RELAXATION_STAND_ALONE
    numPrecTypes = _IFPACK.Factory_numPrecTypes
    __swig_setmethods__["precTypeNames"] = _IFPACK.Factory_precTypeNames_set
    __swig_getmethods__["precTypeNames"] = _IFPACK.Factory_precTypeNames_get
    if _newclass:
        precTypeNames = _swig_property(_IFPACK.Factory_precTypeNames_get, _IFPACK.Factory_precTypeNames_set)

    def toString(*args):
        """toString(Ifpack::EPrecType const precType) -> char const *"""
        return _IFPACK.Factory_toString(*args)

    toString = staticmethod(toString)

    def Create(self, *args):
        """
        Create(Factory self, Ifpack::EPrecType PrecType, RowMatrix Matrix, int const overlap=0, bool overrideSerialDefault=False) -> Preconditioner
        Create(Factory self, std::string const PrecType, RowMatrix Matrix, int const overlap=0, bool overrideSerialDefault=False) -> Preconditioner

        Ifpack_Preconditioner *
        Ifpack::Create(const std::string PrecType, Epetra_RowMatrix *Matrix,
        const int overlap=0, bool overrideSerialDefault=false)

        Creates an instance of Ifpack_Preconditioner given the std::string
        name of the preconditioner type (can fail with bad input).

        Parameters:
        -----------

        PrecType:  (In) - String name of preconditioner type to be created.

        Matrix:  (In) - Matrix used to define the preconditioner

        overlap:  (In) - specified overlap, defaulted to 0.

        Returns 0 if the preconditioner with that input name does not exist.
        Otherwise, return a newly created preconditioner object. Note that the
        client is responsible for calling delete on the returned object once
        it is finished using it! 
        """
        return _IFPACK.Factory_Create(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(Factory self, int argc, char *[] argv, ParameterList List, std::string & PrecType, int & Overlap) -> int

        int
        Ifpack::SetParameters(int argc, char *argv[], Teuchos::ParameterList
        &List, std::string &PrecType, int &Overlap)

        Sets the options in List from the command line.

        Note: If you want full support for all parameters, consider reading in
        a parameter list from an XML file as supported by the Teuchos helper
        function Teuchos::updateParametersFromXmlFile() or
        Teuchos::updateParametersFromXmlStream(). 
        """
        return _IFPACK.Factory_SetParameters(self, *args)


    def __init__(self, *args):
        """
        __init__(Ifpack self) -> Factory



        Ifpack: a function class to define Ifpack preconditioners.

        Class Ifpack is a function class, that contains just one method:
        Create(). Using Create(), users can easily define a variety of IFPACK
        preconditioners.

        Create requires 3 arguments: a std::string, indicating the
        preconditioner to be built;

        a pointer to an Epetra_RowMatrix, representing the matrix to be used
        to define the preconditioner;

        an interger (defaulted to 0), that specifies the amount of overlap
        among the processes.

        The first argument can assume the following values:  "point
        relaxation" : returns an instance of
        Ifpack_AdditiveSchwarz<Ifpack_PointRelaxation> (no Additive Schwarz in
        serial)

        "point relaxation stand-alone" : returns an instance of
        Ifpack_PointRelaxation (value of overlap is ignored).

        "block relaxation" : returns an instance of
        Ifpack_AdditiveSchwarz<Ifpack_BlockRelaxation> (no Additive Schwarz in
        serial)

        "block relaxation stand-alone)" : returns an instance of
        Ifpack_BlockRelaxation.

        "Amesos" : returns an instance of
        Ifpack_AdditiveSchwarz<Ifpack_Amesos> (no Additive Schwarz in serial)

        "Amesos stand-alone" : returns an instance of Ifpack_Amesos.

        "IC" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_IC> (no
        Additive Schwarz in serial)

        "IC stand-alone" : returns an instance of Ifpack_IC.

        "ICT" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_ICT>
        (no Additive Schwarz in serial)

        "ICT stand-alone" : returns an instance of Ifpack_ICT.

        "ILU" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_ILU>
        (no Additive Schwarz in serial)

        "ILU stand-alone" : returns an instance of Ifpack_ILU.

        "ILUT" : returns an instance of Ifpack_AdditiveSchwarz<Ifpack_ILUT>
        (no Additive Schwarz in serial)

        "ILUT stand-alone" : returns an instance of Ifpack_ILUT.

        otherwise, Create() returns 0.

        Objects in stand-alone mode cannot use reordering, variable overlap,
        and singleton filters. However, their construction can be slightly
        faster than the non stand-alone counterpart.

        The following fragment of code shows the basic usage of this class.

        Marzio Sala, (formally) SNL org. 1414

        C++ includes: Ifpack.h 
        """
        this = _IFPACK.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _IFPACK.delete_Factory
Factory_swigregister = _IFPACK.Factory_swigregister
Factory_swigregister(Factory)
cvar = _IFPACK.cvar
Factory.precTypeValues = _IFPACK.cvar.Factory_precTypeValues
Factory.supportsUnsymmetric = _IFPACK.cvar.Factory_supportsUnsymmetric

def Factory_toString(*args):
    """Factory_toString(Ifpack::EPrecType const precType) -> char const *"""
    return _IFPACK.Factory_toString(*args)

# This file is compatible with both classic and new-style classes.


