# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Galeri is the python interface to the Trilinos example
matrix package Galeri:

    http://trilinos.sandia.gov/packages/galeri

The purpose of Galeri is to provide a set of example matrices
distributed across a set of common processor decompositions for
testing purposes.

Galeri provides the following user-level functions:

    * CreateCartesianCoordinates  - Create cartesian coordinates
    * GetNeighboursCartesian2d    - Get neighbor nodes from a 2D grid
    * GetNeighboursCartesian3d    - Get neighbor nodes from a 3D grid
    * PrintStencil2D              - Output a 2D stencil
    * CreateMap                   - Create a Map object
    * CreateCrsMatrix             - Create a specified CrsMatrix
    * CreateVbrMatrix             - Create a specified VbrMatrix
    * ReadHB                      - Read a problem definition from an HB file

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exGaleri.py
    * exGaleri_ReadHB.py
    * exAztecOO.py
    * exIFPACK.py
    * exMLAPI_Simple.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Galeri')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Galeri')
    _Galeri = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Galeri', [dirname(__file__)])
        except ImportError:
            import _Galeri
            return _Galeri
        try:
            _mod = imp.load_module('_Galeri', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Galeri = swig_import_helper()
    del swig_import_helper
else:
    import _Galeri
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Galeri.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Galeri.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Galeri.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Galeri.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Galeri.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Galeri.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Galeri.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Galeri.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Galeri.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Galeri.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Galeri.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Galeri.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Galeri.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Galeri.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Galeri.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Galeri.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Galeri.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Galeri.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info

def Galeri_Version(*args):
    """Galeri_Version() -> std::string"""
    return _Galeri.Galeri_Version(*args)

__version__ = Galeri_Version().split()[2]


def CreateCartesianCoordinates(*args):
    """CreateCartesianCoordinates(std::string const CoordType, BlockMap BlockMap, ParameterList List) -> MultiVector"""
    return _Galeri.CreateCartesianCoordinates(*args)

def Solve(*args):
    """
    Solve(Epetra_LinearProblem Problem)
    Solve(RowMatrix Matrix, MultiVector LHS, MultiVector RHS)
    """
    return _Galeri.Solve(*args)

def ComputeNorm(*args):
    """
    ComputeNorm(MultiVector LHS, MultiVector RHS) -> double
    ComputeNorm(RowMatrix A, MultiVector LHS, MultiVector RHS) -> double
    """
    return _Galeri.ComputeNorm(*args)

def toString(*args):
    """
    toString(int const & x) -> std::string
    toString(unsigned int const & x) -> std::string
    toString(long const & x) -> std::string
    toString(unsigned long const & x) -> std::string
    toString(double const & x) -> std::string
    toString(long long const & x) -> std::string
    toString(unsigned long long const & x) -> std::string
    """
    return _Galeri.toString(*args)

def GetNeighboursCartesian2d(*args):
    """
    GetNeighboursCartesian2d(int const i, int const nx, int const ny, int & left, int & right, int & lower, int & upper)
    GetNeighboursCartesian2d(int const i, int const nx, int const ny, int & left, int & right, int & lower, int & upper, int & left2, int & right2, int & lower2, int & upper2)
    """
    return _Galeri.GetNeighboursCartesian2d(*args)

def GetNeighboursCartesian3d(*args):
    """GetNeighboursCartesian3d(int const i, int const nx, int const ny, int const nz, int & left, int & right, int & lower, int & upper, int & below, int & above)"""
    return _Galeri.GetNeighboursCartesian3d(*args)

def PrintStencil2D(*args):
    """PrintStencil2D(CrsMatrix Matrix, int const nx, int const ny, long long GID=-1)"""
    return _Galeri.PrintStencil2D(*args)

def CreateMap(*args):
    """CreateMap(std::string MapType, Comm Comm, ParameterList List) -> Map"""
    return _Galeri.CreateMap(*args)

def CreateMap64(*args):
    """CreateMap64(std::string MapType, Comm Comm, ParameterList List) -> Map"""
    return _Galeri.CreateMap64(*args)

def CreateCrsMatrix(*args):
    """CreateCrsMatrix(std::string MatrixType, Map Map, ParameterList List) -> CrsMatrix"""
    return _Galeri.CreateCrsMatrix(*args)

def CreateVbrMatrix(*args):
    """CreateVbrMatrix(CrsMatrix CrsMatrix, int const NumPDEs) -> VbrMatrix"""
    return _Galeri.CreateVbrMatrix(*args)

def ReadHB(*args):
    """
    ReadHB(str filename, Epetra.Comm comm) -> (Epetra.Map map, Epetra.CrsMatrix A,
                                               Epetra.Vector x, Epetra.Vector b,
                                               Epetra.Vector exact)

    Given an HB filename and an Epetra communicator, return a tuple of
    Epetra objects generated from the problem described in the file.  This
    tuple contains an Epetra.Map, Epetra.CrsMatrix, and Epetra.Vectors for
    the solution, right-hand side and the exact solution.
    """
    return _Galeri.ReadHB(*args)
# This file is compatible with both classic and new-style classes.


