# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.EpetraExt is the python interface to the Trilinos linear
algebra services extension package EpetraExt:

    http://trilinos.sandia.gov/packages/epetraext

The purpose of EpetraExt is to provide various extensions to Epetra
that were not considered appropriate for the Epetra package.  These
extensions include I/O, matrix-matrix operations and graph coloring.

Currently, only a subset of EpetraExt classes and functions have
python interfaces, including the following user-level classes:

    * XMLReader                      - Read Epetra data from an XML file
    * XMLWriter                      - Write Epetra data as an XML file
    * CrsGraph_MapColoring           - Compute a graph coloring
    * CrsGraph_MapColoringIndex      - Compute indexes for a graph coloring

and functions:

    * MatrixMarketFileToBlockMap     - Read a BlockMap from an MM file
    * MatrixMarketFileToBlockMaps    - Read BlockMaps from an MM file
    * MatrixMarketFileToMap          - Read a Map from an MM file
    * MatrixMarketFileToMultiVector  - Read a MultiVector from an MM file
    * MatrixMarketFileToCrsMatrix    - Read a CrsMatrix from an MM file
    * MatlabFileToCrsMatrix          - Read a CrsMatrix from an ML file
    * BlockMapToMatrixMarketFile     - Write a BlockMap to an MM file
    * MultiVectorToMatrixMarketFile  - Write a MultiVector to an MM file
    * MultiVectorToMatlabFile        - Write a MultiVector to an ML file
    * RowMatrixToMatrixMarketFile    - Write a RowMatrix to an MM file
    * RowMatrixToMatlabFile          - Write a RowMatrix to an ML file
    * Add                            - Add two CrsMatrix objects
    * Multiply                       - Multiply two CrsMatrix objects

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exEpetraExt_IO_MatrixMarket.py
    * exEpetraExt_IO_XML.py
    * exEpetraExt_MatrixMatrix.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_EpetraExt')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_EpetraExt')
    _EpetraExt = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_EpetraExt', [dirname(__file__)])
        except ImportError:
            import _EpetraExt
            return _EpetraExt
        try:
            _mod = imp.load_module('_EpetraExt', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _EpetraExt = swig_import_helper()
    del swig_import_helper
else:
    import _EpetraExt
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _EpetraExt.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _EpetraExt.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _EpetraExt.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _EpetraExt.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _EpetraExt.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _EpetraExt.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _EpetraExt.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _EpetraExt.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _EpetraExt.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _EpetraExt.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info

def EpetraExt_Version(*args):
    """
    EpetraExt_Version() -> std::string

    std::string
    EpetraExt::EpetraExt_Version() 
    """
    return _EpetraExt.EpetraExt_Version(*args)

__version__ = EpetraExt_Version().split()[2]

class XMLReader(_object):
    """


    class XMLReader: A class for reading Epetra objects stored in XML
    files.

    Class EpetraExt::XMLReader allows to read several Trilinos objects
    stored in XML files. The XML data format is specified in the
    documentation of class EpetraExt::XMLWriter, which also contains a
    MATLAB script. A typical usage of this class is reported in file
    epetraext/example/inout/XML_IO.cpp.

    This class requires Teuchos to be configured with the option enable-
    teuchos-expat.

    Reading objects from a file requires the following steps. First, we
    define an XMLReader object, Then, we define a set of pointers, Reading
    simply goes as follows: In distributed environments,
    Epetra_MultiVector, Epetra_CrsGraph and Epetra_CrsMatrix objects have
    a linear distribution. Epetra_Map objects can be read only when using
    the same number of processors used for writing.

    WARNING:  All the created objects must be deleted from the user using
    delete.

    Marzio Sala, D-INFK/ETHZ

    C++ includes: EpetraExt_XMLReader.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLReader, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(EpetraExt::XMLReader self, Comm Comm, std::string const & FileName) -> XMLReader

        EpetraExt::XMLReader::XMLReader(const Epetra_Comm &Comm, const
        std::string &FileName)

        ctor 
        """
        this = _EpetraExt.new_XMLReader(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _EpetraExt.delete_XMLReader

    def ReadMap(self, *args):
        """
        ReadMap(XMLReader self, std::string const & name) -> Map


        Return a Map read from an XML file specified by filename 'name'.

        """
        return _EpetraExt.XMLReader_ReadMap(self, *args)


    def ReadMultiVector(self, *args):
        """
        ReadMultiVector(XMLReader self, std::string const & name) -> MultiVector


        Return a MultiVector read from an XML file specified by filename
        'name'.

        """
        return _EpetraExt.XMLReader_ReadMultiVector(self, *args)


    def ReadCrsGraph(self, *args):
        """
        ReadCrsGraph(XMLReader self, std::string const & name) -> CrsGraph


        Return a CrsGraph read from an XML file specified by filename 'name'.

        """
        return _EpetraExt.XMLReader_ReadCrsGraph(self, *args)


    def ReadCrsMatrix(self, *args):
        """
        ReadCrsMatrix(XMLReader self, std::string const & name) -> CrsMatrix


        Return a CrsMatrix read from an XML file specified by filename 'name'.

        """
        return _EpetraExt.XMLReader_ReadCrsMatrix(self, *args)


    def Read64Map(self, *args):
        """Read64Map(XMLReader self, std::string const & name) -> Map"""
        return _EpetraExt.XMLReader_Read64Map(self, *args)


    def Read64MultiVector(self, *args):
        """Read64MultiVector(XMLReader self, std::string const & name) -> MultiVector"""
        return _EpetraExt.XMLReader_Read64MultiVector(self, *args)


    def Read64CrsGraph(self, *args):
        """Read64CrsGraph(XMLReader self, std::string const & name) -> CrsGraph"""
        return _EpetraExt.XMLReader_Read64CrsGraph(self, *args)


    def Read64CrsMatrix(self, *args):
        """Read64CrsMatrix(XMLReader self, std::string const & name) -> CrsMatrix"""
        return _EpetraExt.XMLReader_Read64CrsMatrix(self, *args)

XMLReader_swigregister = _EpetraExt.XMLReader_swigregister
XMLReader_swigregister(XMLReader)

class XMLWriter(_object):
    """


    class XMLWriter: A class for writing Trilinos objects to XML files.

    Class EpetraExt::XMLWriter writes several Trilinos objects in an XML-
    compatible format. The list of supported objects contains: Epetra_Map;

    Epetra_MultiVector;

    Epetra_CrsGraph;

    Epetra_CrsMatrix;

    Epetra_RowMatrix;

    Teuchos::ParameterList.

    All objects can be read and written, with the std::exception of
    Epetra_RowMatrix objects, that can only be written to files.

    An example of usage is reported in file
    epetraext/example/inout/XML_IO.cpp.

    Writing objects goes as follows. Let Map, Matrix, LHS and RHS an
    Epetra_Map, Epetra_CrsMatrix, and two Epetra_MultiVector's,
    respectively. First, we define an XMLWriter object and we open the
    file using MyProblem label: Writing objects simply goes as A
    Teuchos::ParameterList (List), a std::string, and a
    std::vector<std::string> can be written as Finally, we close the file
    Note that only processor 0 writes the Teuchos::ParameterList,
    std::string, and std::vector<std::string>.

    The written file is as follows:

    This class requires Teuchos to be configured with the option enable-
    teuchos-expat.

    Marzio Sala, D-INFK/ETHZ

    C++ includes: EpetraExt_XMLWriter.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLWriter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(EpetraExt::XMLWriter self, Comm Comm, std::string const & FileName) -> XMLWriter

        EpetraExt::XMLWriter::XMLWriter(const Epetra_Comm &Comm, const
        std::string &FileName)

        ctor 
        """
        this = _EpetraExt.new_XMLWriter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _EpetraExt.delete_XMLWriter

    def Create(self, *args):
        """
        Create(XMLWriter self, std::string const & Label)

        void
        EpetraExt::XMLWriter::Create(const std::string &Label)

        Creates the file, giving Label to the whole object. 
        """
        return _EpetraExt.XMLWriter_Create(self, *args)


    def Close(self, *args):
        """
        Close(XMLWriter self)

        void
        EpetraExt::XMLWriter::Close()

        Closes the file. No Write operations can follow. 
        """
        return _EpetraExt.XMLWriter_Close(self, *args)


    def Write(self, *args):
        """
        Write(XMLWriter self, std::string const & Label, Map Map)
        Write(XMLWriter self, std::string const & Label, RowMatrix Matrix)
        Write(XMLWriter self, std::string const & Label, MultiVector MultiVector)
        Write(XMLWriter self, std::string const & Label, std::vector< std::string,std::allocator< std::string > > const & Content)
        Write(XMLWriter self, std::string const & Label, std::string const & Text)
        Write(XMLWriter self, std::string const & Label, ParameterList List)

        void
        EpetraExt::XMLWriter::Write(const std::string &Label,
        Teuchos::ParameterList &List)

        Writes a Teuchos::ParameterList using label Label. 
        """
        return _EpetraExt.XMLWriter_Write(self, *args)

XMLWriter_swigregister = _EpetraExt.XMLWriter_swigregister
XMLWriter_swigregister(XMLWriter)

class Xform_CrsGraph_MapColoring(_object):
    """


    Base Class for all Epetra Transform Operators.

    This is the abstract definition for all Epetra Transform Operators.
    Depending on the type of Transform, several specializations are
    available: Structural, SameType, InPlace, View.

    C++ includes: EpetraExt_Transform.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_MapColoring, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsGraph_MapColoring

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_MapColoring self, CrsGraph orig) -> MapColoring"""
        return _EpetraExt.Xform_CrsGraph_MapColoring___call__(self, *args)


    def fwd(self, *args):
        """
        fwd(Xform_CrsGraph_MapColoring self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::fwd()=0

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsGraph_MapColoring_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(Xform_CrsGraph_MapColoring self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::rvs()=0

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsGraph_MapColoring_rvs(self, *args)


    def analyze(self, *args):
        """
        analyze(Xform_CrsGraph_MapColoring self, CrsGraph orig) -> bool

        bool
        EpetraExt::Transform< T, U >::analyze(OriginalTypeRef orig)

        Initial analysis phase of transform. Returns true if the transform is
        possible allowing methods  construct(),  fwd() and  rvs() to be
        successfully utilized.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation calls method operator() and stores the
        resulting object in an internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsGraph_MapColoring_analyze(self, *args)


    def construct(self, *args):
        """
        construct(Xform_CrsGraph_MapColoring self) -> MapColoring

        Transform< T,
        U >::NewTypeRef EpetraExt::Transform< T, U >::construct()

        Construction of new object as a result of the transform.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsGraph_MapColoring_construct(self, *args)


    def isConstructed(self, *args):
        """
        isConstructed(Xform_CrsGraph_MapColoring self) -> bool

        bool
        EpetraExt::Transform< T, U >::isConstructed()

        Check for whether transformed object has been constructed

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns true if newObj_ != 0. 
        """
        return _EpetraExt.Xform_CrsGraph_MapColoring_isConstructed(self, *args)

Xform_CrsGraph_MapColoring_swigregister = _EpetraExt.Xform_CrsGraph_MapColoring_swigregister
Xform_CrsGraph_MapColoring_swigregister(Xform_CrsGraph_MapColoring)

class Xform_CrsGraph_vecIntVector(_object):
    """


    Base Class for all Epetra Transform Operators.

    This is the abstract definition for all Epetra Transform Operators.
    Depending on the type of Transform, several specializations are
    available: Structural, SameType, InPlace, View.

    C++ includes: EpetraExt_Transform.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_vecIntVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_vecIntVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsGraph_vecIntVector

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_vecIntVector self, CrsGraph orig) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< int >::impl,std::allocator< Epetra_GIDTypeVector< int >::impl > > >::NewTypeRef"""
        return _EpetraExt.Xform_CrsGraph_vecIntVector___call__(self, *args)


    def fwd(self, *args):
        """
        fwd(Xform_CrsGraph_vecIntVector self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::fwd()=0

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsGraph_vecIntVector_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(Xform_CrsGraph_vecIntVector self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::rvs()=0

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsGraph_vecIntVector_rvs(self, *args)


    def analyze(self, *args):
        """
        analyze(Xform_CrsGraph_vecIntVector self, CrsGraph orig) -> bool

        bool
        EpetraExt::Transform< T, U >::analyze(OriginalTypeRef orig)

        Initial analysis phase of transform. Returns true if the transform is
        possible allowing methods  construct(),  fwd() and  rvs() to be
        successfully utilized.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation calls method operator() and stores the
        resulting object in an internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsGraph_vecIntVector_analyze(self, *args)


    def construct(self, *args):
        """
        construct(Xform_CrsGraph_vecIntVector self) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< int >::impl,std::allocator< Epetra_GIDTypeVector< int >::impl > > >::NewTypeRef

        Transform< T,
        U >::NewTypeRef EpetraExt::Transform< T, U >::construct()

        Construction of new object as a result of the transform.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsGraph_vecIntVector_construct(self, *args)


    def isConstructed(self, *args):
        """
        isConstructed(Xform_CrsGraph_vecIntVector self) -> bool

        bool
        EpetraExt::Transform< T, U >::isConstructed()

        Check for whether transformed object has been constructed

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns true if newObj_ != 0. 
        """
        return _EpetraExt.Xform_CrsGraph_vecIntVector_isConstructed(self, *args)

Xform_CrsGraph_vecIntVector_swigregister = _EpetraExt.Xform_CrsGraph_vecIntVector_swigregister
Xform_CrsGraph_vecIntVector_swigregister(Xform_CrsGraph_vecIntVector)

class Xform_CrsGraph_vecLongVector(_object):
    """


    Base Class for all Epetra Transform Operators.

    This is the abstract definition for all Epetra Transform Operators.
    Depending on the type of Transform, several specializations are
    available: Structural, SameType, InPlace, View.

    C++ includes: EpetraExt_Transform.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsGraph_vecLongVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsGraph_vecLongVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsGraph_vecLongVector

    def __call__(self, *args):
        """__call__(Xform_CrsGraph_vecLongVector self, CrsGraph orig) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< long long >::impl,std::allocator< Epetra_GIDTypeVector< long long >::impl > > >::NewTypeRef"""
        return _EpetraExt.Xform_CrsGraph_vecLongVector___call__(self, *args)


    def fwd(self, *args):
        """
        fwd(Xform_CrsGraph_vecLongVector self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::fwd()=0

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsGraph_vecLongVector_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(Xform_CrsGraph_vecLongVector self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::rvs()=0

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsGraph_vecLongVector_rvs(self, *args)


    def analyze(self, *args):
        """
        analyze(Xform_CrsGraph_vecLongVector self, CrsGraph orig) -> bool

        bool
        EpetraExt::Transform< T, U >::analyze(OriginalTypeRef orig)

        Initial analysis phase of transform. Returns true if the transform is
        possible allowing methods  construct(),  fwd() and  rvs() to be
        successfully utilized.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation calls method operator() and stores the
        resulting object in an internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsGraph_vecLongVector_analyze(self, *args)


    def construct(self, *args):
        """
        construct(Xform_CrsGraph_vecLongVector self) -> EpetraExt::Transform< Epetra_CrsGraph,std::vector< Epetra_GIDTypeVector< long long >::impl,std::allocator< Epetra_GIDTypeVector< long long >::impl > > >::NewTypeRef

        Transform< T,
        U >::NewTypeRef EpetraExt::Transform< T, U >::construct()

        Construction of new object as a result of the transform.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsGraph_vecLongVector_construct(self, *args)


    def isConstructed(self, *args):
        """
        isConstructed(Xform_CrsGraph_vecLongVector self) -> bool

        bool
        EpetraExt::Transform< T, U >::isConstructed()

        Check for whether transformed object has been constructed

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns true if newObj_ != 0. 
        """
        return _EpetraExt.Xform_CrsGraph_vecLongVector_isConstructed(self, *args)

Xform_CrsGraph_vecLongVector_swigregister = _EpetraExt.Xform_CrsGraph_vecLongVector_swigregister
Xform_CrsGraph_vecLongVector_swigregister(Xform_CrsGraph_vecLongVector)

class Xform_CrsMatrix_CrsMatrix(_object):
    """


    Base Class for all Epetra Transform Operators.

    This is the abstract definition for all Epetra Transform Operators.
    Depending on the type of Transform, several specializations are
    available: Structural, SameType, InPlace, View.

    C++ includes: EpetraExt_Transform.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Xform_CrsMatrix_CrsMatrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Xform_CrsMatrix_CrsMatrix, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_Xform_CrsMatrix_CrsMatrix

    def __call__(self, *args):
        """__call__(Xform_CrsMatrix_CrsMatrix self, CrsMatrix orig) -> CrsMatrix"""
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix___call__(self, *args)


    def fwd(self, *args):
        """
        fwd(Xform_CrsMatrix_CrsMatrix self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::fwd()=0

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(Xform_CrsMatrix_CrsMatrix self) -> bool

        virtual bool
        EpetraExt::Transform< T, U >::rvs()=0

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_rvs(self, *args)


    def analyze(self, *args):
        """
        analyze(Xform_CrsMatrix_CrsMatrix self, CrsMatrix orig) -> bool

        bool
        EpetraExt::Transform< T, U >::analyze(OriginalTypeRef orig)

        Initial analysis phase of transform. Returns true if the transform is
        possible allowing methods  construct(),  fwd() and  rvs() to be
        successfully utilized.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation calls method operator() and stores the
        resulting object in an internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_analyze(self, *args)


    def construct(self, *args):
        """
        construct(Xform_CrsMatrix_CrsMatrix self) -> CrsMatrix

        Transform< T,
        U >::NewTypeRef EpetraExt::Transform< T, U >::construct()

        Construction of new object as a result of the transform.

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns internal attribute newObj_. 
        """
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_construct(self, *args)


    def isConstructed(self, *args):
        """
        isConstructed(Xform_CrsMatrix_CrsMatrix self) -> bool

        bool
        EpetraExt::Transform< T, U >::isConstructed()

        Check for whether transformed object has been constructed

        Preconditions:

        Invariants:

        Postconditions:

        The default implementation returns true if newObj_ != 0. 
        """
        return _EpetraExt.Xform_CrsMatrix_CrsMatrix_isConstructed(self, *args)

Xform_CrsMatrix_CrsMatrix_swigregister = _EpetraExt.Xform_CrsMatrix_CrsMatrix_swigregister
Xform_CrsMatrix_CrsMatrix_swigregister(Xform_CrsMatrix_CrsMatrix)

class SXform_CrsGraph_MapColoring(Xform_CrsGraph_MapColoring):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,Epetra_MapColoring)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_MapColoring]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_MapColoring]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_MapColoring, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """
        fwd(SXform_CrsGraph_MapColoring self) -> bool

        bool
        EpetraExt::StructuralTransform< T, U >::fwd()

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.SXform_CrsGraph_MapColoring_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(SXform_CrsGraph_MapColoring self) -> bool

        bool
        EpetraExt::StructuralTransform< T, U >::rvs()

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.SXform_CrsGraph_MapColoring_rvs(self, *args)

    __swig_destroy__ = _EpetraExt.delete_SXform_CrsGraph_MapColoring
SXform_CrsGraph_MapColoring_swigregister = _EpetraExt.SXform_CrsGraph_MapColoring_swigregister
SXform_CrsGraph_MapColoring_swigregister(SXform_CrsGraph_MapColoring)

class SXform_CrsGraph_vecIntVector(Xform_CrsGraph_vecIntVector):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(int)>::impl)>)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_vecIntVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_vecIntVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_vecIntVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_vecIntVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """
        fwd(SXform_CrsGraph_vecIntVector self) -> bool

        bool
        EpetraExt::StructuralTransform< T, U >::fwd()

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.SXform_CrsGraph_vecIntVector_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(SXform_CrsGraph_vecIntVector self) -> bool

        bool
        EpetraExt::StructuralTransform< T, U >::rvs()

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.SXform_CrsGraph_vecIntVector_rvs(self, *args)

    __swig_destroy__ = _EpetraExt.delete_SXform_CrsGraph_vecIntVector
SXform_CrsGraph_vecIntVector_swigregister = _EpetraExt.SXform_CrsGraph_vecIntVector_swigregister
SXform_CrsGraph_vecIntVector_swigregister(SXform_CrsGraph_vecIntVector)

class SXform_CrsGraph_vecLongVector(Xform_CrsGraph_vecLongVector):
    """Proxy of C++ EpetraExt::StructuralTransform<(Epetra_CrsGraph,std::vector<(Epetra_GIDTypeVector<(long long)>::impl)>)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsGraph_vecLongVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SXform_CrsGraph_vecLongVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsGraph_vecLongVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SXform_CrsGraph_vecLongVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fwd(self, *args):
        """
        fwd(SXform_CrsGraph_vecLongVector self) -> bool

        bool
        EpetraExt::StructuralTransform< T, U >::fwd()

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.SXform_CrsGraph_vecLongVector_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(SXform_CrsGraph_vecLongVector self) -> bool

        bool
        EpetraExt::StructuralTransform< T, U >::rvs()

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.SXform_CrsGraph_vecLongVector_rvs(self, *args)

    __swig_destroy__ = _EpetraExt.delete_SXform_CrsGraph_vecLongVector
SXform_CrsGraph_vecLongVector_swigregister = _EpetraExt.SXform_CrsGraph_vecLongVector_swigregister
SXform_CrsGraph_vecLongVector_swigregister(SXform_CrsGraph_vecLongVector)

class SameXform_CrsMatrix(Xform_CrsMatrix_CrsMatrix):
    """Proxy of C++ EpetraExt::SameTypeTransform<(Epetra_CrsMatrix)> class."""

    __swig_setmethods__ = {}
    for _s in [Xform_CrsMatrix_CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SameXform_CrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Xform_CrsMatrix_CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SameXform_CrsMatrix, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_SameXform_CrsMatrix
SameXform_CrsMatrix_swigregister = _EpetraExt.SameXform_CrsMatrix_swigregister
SameXform_CrsMatrix_swigregister(SameXform_CrsMatrix)

class CrsGraph_MapColoring(SXform_CrsGraph_MapColoring):
    """


    Map Coloring of independent columns in a Graph

    Generates a Epetra_MapColoring object for which all column indices
    form independent sets.

    C++ includes: EpetraExt_MapColoring.h 
    """

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_MapColoring]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_MapColoring]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoring, name)
    __repr__ = _swig_repr
    GREEDY = _EpetraExt.CrsGraph_MapColoring_GREEDY
    LUBY = _EpetraExt.CrsGraph_MapColoring_LUBY
    JONES_PLASSMAN = _EpetraExt.CrsGraph_MapColoring_JONES_PLASSMAN
    PSEUDO_PARALLEL = _EpetraExt.CrsGraph_MapColoring_PSEUDO_PARALLEL
    __swig_destroy__ = _EpetraExt.delete_CrsGraph_MapColoring

    def __init__(self, *args):
        """
        __init__(EpetraExt::CrsGraph_MapColoring self, EpetraExt::CrsGraph_MapColoring::ColoringAlgorithm algo, int reordering=0, bool distance1=False, int verbosity=0) -> CrsGraph_MapColoring

        EpetraExt::CrsGraph_MapColoring::CrsGraph_MapColoring(ColoringAlgorithm
        algo=GREEDY, int reordering=0, bool distance1=false, int verbosity=0)

        Constructor 
        """
        this = _EpetraExt.new_CrsGraph_MapColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoring self, CrsGraph orig) -> MapColoring"""
        return _EpetraExt.CrsGraph_MapColoring___call__(self, *args)

CrsGraph_MapColoring_swigregister = _EpetraExt.CrsGraph_MapColoring_swigregister
CrsGraph_MapColoring_swigregister(CrsGraph_MapColoring)

class TCrsGraph_MapColoringIndex_int(SXform_CrsGraph_vecIntVector):
    """


    Generates a std::vector of Epetra_IntVector's to be used to map
    perturbation contributions to a CrsGraph/CrsMatrix from a perturbed
    vector.

    C++ includes: EpetraExt_TCrsGraph_MapColoringIndex.h 
    """

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_vecIntVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TCrsGraph_MapColoringIndex_int, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_vecIntVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TCrsGraph_MapColoringIndex_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
TCrsGraph_MapColoringIndex_int_swigregister = _EpetraExt.TCrsGraph_MapColoringIndex_int_swigregister
TCrsGraph_MapColoringIndex_int_swigregister(TCrsGraph_MapColoringIndex_int)

class TCrsGraph_MapColoringIndex_long(SXform_CrsGraph_vecLongVector):
    """


    Generates a std::vector of Epetra_IntVector's to be used to map
    perturbation contributions to a CrsGraph/CrsMatrix from a perturbed
    vector.

    C++ includes: EpetraExt_TCrsGraph_MapColoringIndex.h 
    """

    __swig_setmethods__ = {}
    for _s in [SXform_CrsGraph_vecLongVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TCrsGraph_MapColoringIndex_long, name, value)
    __swig_getmethods__ = {}
    for _s in [SXform_CrsGraph_vecLongVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TCrsGraph_MapColoringIndex_long, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
TCrsGraph_MapColoringIndex_long_swigregister = _EpetraExt.TCrsGraph_MapColoringIndex_long_swigregister
TCrsGraph_MapColoringIndex_long_swigregister(TCrsGraph_MapColoringIndex_long)

class CrsGraph_MapColoringIndex(TCrsGraph_MapColoringIndex_int):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoringIndex class."""

    __swig_setmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoringIndex, name, value)
    __swig_getmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoringIndex, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_CrsGraph_MapColoringIndex

    def __init__(self, *args):
        """
        __init__(EpetraExt::CrsGraph_MapColoringIndex self, MapColoring ColorMap) -> CrsGraph_MapColoringIndex

        EpetraExt::CrsGraph_MapColoringIndex::CrsGraph_MapColoringIndex(const
        Epetra_MapColoring &ColorMap)

        Constructor input param ColorMap defines the perturbation coloring 
        """
        this = _EpetraExt.new_CrsGraph_MapColoringIndex(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoringIndex self, CrsGraph orig) -> std::vector< Epetra_IntVector,std::allocator< Epetra_IntVector > > &"""
        return _EpetraExt.CrsGraph_MapColoringIndex___call__(self, *args)

CrsGraph_MapColoringIndex_swigregister = _EpetraExt.CrsGraph_MapColoringIndex_swigregister
CrsGraph_MapColoringIndex_swigregister(CrsGraph_MapColoringIndex)

class CrsGraph_MapColoringIndex64(TCrsGraph_MapColoringIndex_long):
    """Proxy of C++ EpetraExt::CrsGraph_MapColoringIndex64 class."""

    __swig_setmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph_MapColoringIndex64, name, value)
    __swig_getmethods__ = {}
    for _s in [TCrsGraph_MapColoringIndex_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph_MapColoringIndex64, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_CrsGraph_MapColoringIndex64

    def __init__(self, *args):
        """
        __init__(EpetraExt::CrsGraph_MapColoringIndex64 self, MapColoring ColorMap) -> CrsGraph_MapColoringIndex64

        EpetraExt::CrsGraph_MapColoringIndex64::CrsGraph_MapColoringIndex64(const
        Epetra_MapColoring &ColorMap)

        Constructor input param ColorMap defines the perturbation coloring 
        """
        this = _EpetraExt.new_CrsGraph_MapColoringIndex64(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsGraph_MapColoringIndex64 self, CrsGraph orig) -> std::vector< Epetra_LongLongVector,std::allocator< Epetra_LongLongVector > > &"""
        return _EpetraExt.CrsGraph_MapColoringIndex64___call__(self, *args)

CrsGraph_MapColoringIndex64_swigregister = _EpetraExt.CrsGraph_MapColoringIndex64_swigregister
CrsGraph_MapColoringIndex64_swigregister(CrsGraph_MapColoringIndex64)


def MatrixMarketFileToMultiVector(*args):
    """
    MatrixMarketFileToMultiVector(str filename, Epetra.BlockMap) ->
        Epetra.MultiVector

    Return a MultiVector read from a matix market file.

    int
    EpetraExt::MatrixMarketFileToMultiVector(const char *filename, const
    Epetra_BlockMap &map, Epetra_MultiVector *&A)

    Constructs an Epetra_MultiVector object from a Matrix Market format
    file.

    This function constructs an Epetra_MultiVector object by reading a
    Matrix Market file.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. The multivector
    to be read should be in this file in Matrix Market array format.

    map:  (In) An Epetra_Map or Epetra_BlockMap object describing the
    desired distribution of the multivector.

    A:  (Out) An Epetra_MultiVector object constructed from file contents.

    WARNING:  User must delete!!.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.MatrixMarketFileToMultiVector(*args)

def MultiVectorToMatrixMarketFile(*args):
    """
    MultiVectorToMatrixMarketFile(char const * filename, MultiVector A, char const * matrixName=None, char const * matrixDescription=None, bool writeHeader=True) -> int

    int
    EpetraExt::MultiVectorToMatrixMarketFile(const char *filename, const
    Epetra_MultiVector &A, const char *matrixName=0, const char
    *matrixDescription=0, bool writeHeader=true)

    Writes an Epetra_MultiVector object to a Matrix Market format file.

    This function takes an Epetra_MultiVector object and writes it to the
    specified file. The multivector can be distributed or serial. The user
    can provide a strings containing the object name, a description, and
    specify that header information should or should not be printed to the
    file.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contained any requested header information followed by the matrix
    coefficients. The file will contain a row for each entry. All entries
    for a column are listed before going to the next column.

    A:  (In) An Epetra_MultiVector Object containing the user matrix to be
    dumped to file.

    matrixName:  (In) A C-style string pointer to a name that will be
    stored in the comment field of the file. This is not a required
    argument. Note that it is possible to pass in the method A.Label().

    matrixDescription:  (In) A C-style string pointer to a matrix
    description that will be stored in the comment field of the file.

    writeHeader:  (In) If true, the header will be written, otherwise only
    the matrix entries will be written.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.MultiVectorToMatrixMarketFile(*args)

def MultiVectorToMatlabFile(*args):
    """
    MultiVectorToMatlabFile(char const * filename, MultiVector A) -> int

    int
    EpetraExt::MultiVectorToMatlabFile(const char *filename, const
    Epetra_MultiVector &A)

    Writes an Epetra_MultiVector object to a file that is compatible with
    Matlab.

    This function takes any matrix that implements the Epetra_MultiVector
    interface and writes it to the specified file. The matrix can be
    distributed or serial. This function is a convenience wrapper around
    MultiVectorToMatrixMarketFile. The following Matlab commands can be
    used to read the resulting file and convert to it to a Matlab sparse
    matrix: load filename;  For example: load A.dat;  The above produces a
    dense matrix A with each vector in the multivector as a column in A.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contain a row for each row of the multivector.

    A:  (In) An Epetra_MultiVector Object containing the user matrix to be
    dumped to file.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.MultiVectorToMatlabFile(*args)

def MultiVectorToMatrixMarketHandle(*args):
    """
    MultiVectorToMatrixMarketHandle(std::FILE * handle, MultiVector A) -> int

    int EpetraExt::MultiVectorToMatrixMarketHandle(std::FILE *handle,
    const Epetra_MultiVector &A)

    Writes an Epetra_MultiVector object that is compatible with Matrix
    Market array format to a file handle.

    This function takes an Epetra_MultiVector and writes it to the
    specified file handle.

    Parameters:
    -----------

    handle:  (In) A C-style file handle, already opened. On exit, the file
    associated with this handle will have appended to it a row for each
    multivector row.

    A:  (In) An Epetra_MultiVector Object containing the user object to be
    dumped to file.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.MultiVectorToMatrixMarketHandle(*args)

def MultiVectorToMatlabHandle(*args):
    """
    MultiVectorToMatlabHandle(std::FILE * handle, MultiVector A) -> int

    int
    EpetraExt::MultiVectorToMatlabHandle(std::FILE *handle, const
    Epetra_MultiVector &A)

    Writes an Epetra_MultiVector object that is compatible with Matlab to
    a file handle.

    This function takes an Epetra_MultiVector and writes it to the
    specified file handle.

    Parameters:
    -----------

    handle:  (In) A C-style file handle, already opened. On exit, the file
    associated with this handle will have appended to it a row for each
    multivector row.

    A:  (In) An Epetra_MultiVector Object containing the user object to be
    dumped to file.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.MultiVectorToMatlabHandle(*args)

def MultiVectorToHandle(*args):
    """
    MultiVectorToHandle(std::FILE * handle, MultiVector A, bool mmFormat) -> int

    int
    EpetraExt::MultiVectorToHandle(std::FILE *handle, const
    Epetra_MultiVector &A, bool mmFormat) 
    """
    return _EpetraExt.MultiVectorToHandle(*args)

def writeMultiVector(*args):
    """
    writeMultiVector(std::FILE * handle, MultiVector A, bool mmFormat) -> int

    int
    EpetraExt::writeMultiVector(std::FILE *handle, const
    Epetra_MultiVector &A, bool mmFormat) 
    """
    return _EpetraExt.writeMultiVector(*args)

def MatlabFileToCrsMatrix(*args):
    """
    MatlabFileToCrsMatrix(str filename, Epetra.Comm) -> Epetra.CrsMatrix

    Return a CrsMatrix read from a matlab file.

    int
    EpetraExt::MatlabFileToCrsMatrix(const char *filename, const
    Epetra_Comm &comm, Epetra_CrsMatrix *&A)

    Constructs an Epetra_CrsMatrix object from a Matlab format file,
    distributes rows evenly across processors.

    This function constructs an Epetra_CrsMatrix object by reading a
    Matlab (i,j,value) format file.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. The matrix to
    be read should be in this file in Matlab coordinate format.

    comm:  (In) An Epetra_Comm object. The matrix will have its rows
    distributed evenly by row-count across the parallel machine.

    A:  (Out) An Epetra_CrsMatrix object constructed from file contents.
    The input matrix can be any dimension, square or rectangular.

    WARNING:  User must delete matrix A!!.

    Returns 0 if no error, -1 if any problems with file system.  Notes:
    The file will be read twice: first to get the maximum row and column
    dimensions. Next to insert values.

    The global row and column dimensions will be determined by the maximum
    row and column index, respectively, contained in the file. If some
    rows or columns are empty they will still be present in the matrix.
    The format expected for the input file is a list of nonzero entries
    with one entry per row.  Each row will have   the row index, column
    index and value listed with space in between each item.  The number of
    lines in the file should  be exactly the number of entries of the
    matrix.  For example, consider the following matrix where only the
    nonzero values are stored:

    \\[ \\left[\\begin{array}{cccc} 5 & 7 & 0 & 0 \\\\ 3 & 2 & 0
    & 1 \\\\ 0 & 0 & 0 & 4 \\\\ \\end{array}\\right]. \\]

    A Matlab format file for this matrix would be:1 1 5.0 1 2 7.0 2 1 3.0
    2 2 2.0 2 4 1.0 4 4 4.0

    Note that the entries can be listed in any order and that the matrix
    does not need to be square. Values in the first and second columns
    must be integer values and in those in the third column must be
    floating point format. 
    """
    return _EpetraExt.MatlabFileToCrsMatrix(*args)

def MatrixMarketFileToCrsMatrix(*args):
    """
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.
    MatrixMarketFileToCrsMatrix(str filename, Epetra.Map rowMap, Epetra.Map
        colMap=None, Epetra.Map rangeMap=None, Epetra.Map domainMap=None) ->
        Epetra.CrsMatrix

    Return a CrsMatrix read from a matrix market file.

    int
    EpetraExt::MatrixMarketFileToCrsMatrix(const char *filename, const
    Epetra_Map &rowMap, const Epetra_Map &colMap, const Epetra_Map
    &rangeMap, const Epetra_Map &domainMap, Epetra_CrsMatrix *&A, const
    bool transpose=0, const bool verbose=0)

    Constructs an Epetra_CrsMatrix object from a Matrix Market format
    file, row, column, range and domain map specified; this version is
    seldom required unless you want explicit control over column map.

    Reads an Epetra_CrsMatrix object from a matrix-market file, but uses
    the specified maps for constructing and 'FillComplete()'ing the
    matrix. Successfully creates rectangular matrices.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. The matrix to
    be read should be in this file in Matrix Market coordinate format.

    rowMap:  (In) An Epetra_Map object describing the desired row
    distribution of the matrix.

    colMap:  (In) An Epetra_Map object describing the desired column
    distribution of the matrix.

    rangeMap:  (In) An Epetra_Map object describing the distribution of
    range vectors that will be used with this matrix, must be 1-to-1.

    domainMap:  (In) An Epetra_Map object describing the distribution of
    domain vectors that will be used with this matrix, must be 1-to-1.

    transpose:  (In) A boolean value indicating whether the reader should
    transpose the matrix as it is read into matrix A. (default = 0).

    verbose:  (In) A boolean value indicating whether the reader should
    print diagnostic statements to stdout. (default = 0).

    A:  (Out) An Epetra_CrsMatrix object constructed from file contents.

    WARNING:  User must delete!!.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.MatrixMarketFileToCrsMatrix(*args)

def HypreFileToCrsMatrix(*args):
    """
    HypreFileToCrsMatrix(char const * filename, Comm comm) -> int

    int
    EpetraExt::HypreFileToCrsMatrix(const char *filename, const
    Epetra_Comm &comm, Epetra_CrsMatrix *&A)

    Constructs an Epetra_CrsMatrix object from a Hypre Matrix Print
    command, the row map is specified.

    Reads an Epetra_CrsMatrix object from a Hypre Matrix Printout, the
    matrix should be square.

    Parameters:
    -----------

    filename:  (In) A filename not including the processor id extension,
    including path if desired.

    comm:  (In) An Epetra_Comm object describing the communication among
    processors.

    A:  (Out) An Epetra_CrsMatrix object constructed from file contents.

    WARNING:  User must delete!!.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.HypreFileToCrsMatrix(*args)

def MatrixMarketFileToCrsMatrixHandle(*args):
    """
    MatrixMarketFileToCrsMatrixHandle(char const * filename, Comm comm, Map rowMap=None, Map colMap=None, Map rangeMap=None, Map domainMap=None, bool const transpose=0, bool const verbose=0) -> int

    int EpetraExt::MatrixMarketFileToCrsMatrixHandle(const char *filename,
    const Epetra_Comm &comm, Epetra_CrsMatrix *&A, const Epetra_Map
    *rowMap, const Epetra_Map *colMap, const Epetra_Map *rangeMap, const
    Epetra_Map *domainMap, const bool transpose, const bool verbose) 
    """
    return _EpetraExt.MatrixMarketFileToCrsMatrixHandle(*args)

def MatlabFileToCrsMatrix64(*args):
    """
    MatlabFileToCrsMatrix64(char const * filename, Comm comm) -> int

    int
    EpetraExt::MatlabFileToCrsMatrix64(const char *filename, const
    Epetra_Comm &comm, Epetra_CrsMatrix *&A) 
    """
    return _EpetraExt.MatlabFileToCrsMatrix64(*args)

def MatrixMarketFileToCrsMatrix64(*args):
    """
    MatrixMarketFileToCrsMatrix64(char const * filename, Comm comm, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map rangeMap, Map domainMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map colMap, bool const transpose=0, bool const verbose=0) -> int
    MatrixMarketFileToCrsMatrix64(char const * filename, Map rowMap, Map colMap, Map rangeMap, Map domainMap, bool const transpose=0, bool const verbose=0) -> int

    int
    EpetraExt::MatrixMarketFileToCrsMatrix64(const char *filename, const
    Epetra_Map &rowMap, const Epetra_Map &colMap, const Epetra_Map
    &rangeMap, const Epetra_Map &domainMap, Epetra_CrsMatrix *&A, const
    bool transpose, const bool verbose) 
    """
    return _EpetraExt.MatrixMarketFileToCrsMatrix64(*args)

def HypreFileToCrsMatrix64(*args):
    """
    HypreFileToCrsMatrix64(char const * filename, Comm comm) -> int

    int
    EpetraExt::HypreFileToCrsMatrix64(const char *filename, const
    Epetra_Comm &comm, Epetra_CrsMatrix *&Matrix) 
    """
    return _EpetraExt.HypreFileToCrsMatrix64(*args)

def MatrixMarketFileToCrsMatrixHandle64(*args):
    """
    MatrixMarketFileToCrsMatrixHandle64(char const * filename, Comm comm, Map rowMap=None, Map colMap=None, Map rangeMap=None, Map domainMap=None, bool const transpose=0, bool const verbose=0) -> int

    int EpetraExt::MatrixMarketFileToCrsMatrixHandle64(const char
    *filename, const Epetra_Comm &comm, Epetra_CrsMatrix *&A, const
    Epetra_Map *rowMap, const Epetra_Map *colMap, const Epetra_Map
    *rangeMap, const Epetra_Map *domainMap, const bool transpose, const
    bool verbose) 
    """
    return _EpetraExt.MatrixMarketFileToCrsMatrixHandle64(*args)

def RowMatrixToMatrixMarketFile(*args):
    """
    RowMatrixToMatrixMarketFile(char const * filename, RowMatrix A, char const * matrixName=None, char const * matrixDescription=None, bool writeHeader=True) -> int

    int
    EpetraExt::RowMatrixToMatrixMarketFile(const char *filename, const
    Epetra_RowMatrix &A, const char *matrixName=0, const char
    *matrixDescription=0, bool writeHeader=true)

    Writes an Epetra_RowMatrix object to a Matrix Market format file.

    This function takes any matrix that implements the Epetra_RowMatrix
    interface and writes it to the specified file. The matrix can be
    distributed or serial. The user can provide a strings containing the
    matrix name, a matrix description, and specify that header information
    should or should not be printed to the file.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contained any requested header information followed by the matrix
    coefficients. The file will contain a row for each matrix entry The
    first column is the global row index, using base 1, the second column
    is the global column index of the entry, the third value is the matrix
    value for that entry.

    A:  (In) An Epetra_RowMatrix Object containing the user matrix to be
    dumped to file. Any object that implements the Epetra_RowMatrix
    interface can be passed in. In particular, the Epetra_CrsMatrix,
    Epetra_VbrMatrix, Epetra_FECrsMatrix, Epetra_FEVbrMatrix and
    Epetra_MsrMatrix classes are compatible with this interface.

    matrixName:  (In) A C-style std::string pointer to a name that will be
    stored in the comment field of the file. This is not a required
    argument. Note that it is possible to pass in the method A.Label() if
    the matrix is one of the four types: Epetra_CrsMatrix,
    Epetra_VbrMatrix, Epetra_FECrsMatrix, Epetra_FEVbrMatrix.

    matrixDescription:  (In) A C-style std::string pointer to a matrix
    description that will be stored in the comment field of the file.

    writeHeader:  (In) If true, the header will be written, otherwise only
    the matrix entries will be written.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.RowMatrixToMatrixMarketFile(*args)

def RowMatrixToMatlabFile(*args):
    """
    RowMatrixToMatlabFile(char const * filename, RowMatrix A) -> int

    int
    EpetraExt::RowMatrixToMatlabFile(const char *filename, const
    Epetra_RowMatrix &A)

    Writes an Epetra_RowMatrix object to a file that is compatible with
    Matlab.

    This function takes any matrix that implements the Epetra_RowMatrix
    interface and writes it to the specified file. The matrix can be
    distributed or serial. This function is a convenience wrapper around
    RowMatrixToMatrixMarketFile. The following Matlab commands can be used
    to read the resulting file and convert to it to a Matlab sparse
    matrix: load filename;

    matrix_name = spconvert(filename_root);  For example: load A.dat;

    A = spconvert(filename_root);  The above produces a sparse matrix A.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contain a row for each matrix entry The first column is the global row
    index, using base 1, the second column is the global column index of
    the entry, the third value is the matrix value for that entry.

    A:  (In) An Epetra_RowMatrix Object containing the user matrix to be
    dumped to file. Any object that implements the Epetra_RowMatrix
    interface can be passed in. In particular, the Epetra_CrsMatrix,
    Epetra_VbrMatrix, Epetra_FECrsMatrix, Epetra_FEVbrMatrix and
    Epetra_MsrMatrix classes are compatible with this interface.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.RowMatrixToMatlabFile(*args)

def RowMatrixToHandle(*args):
    """
    RowMatrixToHandle(std::FILE * handle, RowMatrix A) -> int

    int
    EpetraExt::RowMatrixToHandle(std::FILE *handle, const Epetra_RowMatrix
    &A)

    Writes an Epetra_RowMatrix object to a format file that is compatible
    with Matlab.

    This function takes any matrix that implements the Epetra_RowMatrix
    interface and writes it to the specified file handle. The matrix can
    be distributed or serial. This function is a convenience wrapper
    around RowMatrixToMatrixMarketFile.

    Parameters:
    -----------

    handle:  (In) A C-style file handle, already opened. On exit, the file
    associated with this handle will have appended to it a row for each
    matrix entry The first column is the global row index, using base 1,
    the second column is the global column index of the entry, the third
    value is the matrix value for that entry.

    A:  (In) An Epetra_RowMatrix Object containing the user matrix to be
    dumped to file. Any object that implements the Epetra_RowMatrix
    interface can be passed in. In particular, the Epetra_CrsMatrix,
    Epetra_VbrMatrix, Epetra_FECrsMatrix, Epetra_FEVbrMatrix and
    Epetra_MsrMatrix classes are compatible with this interface.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.RowMatrixToHandle(*args)

def writeRowMatrix(*args):
    """
    writeRowMatrix(std::FILE * handle, RowMatrix A) -> int

    int
    EpetraExt::writeRowMatrix(std::FILE *handle, const Epetra_RowMatrix
    &A) 
    """
    return _EpetraExt.writeRowMatrix(*args)

def MatrixMarketFileToBlockMap(*args):
    """
    MatrixMarketFileToBlockMap(str filename, Epetra.Comm) -> Epetra.BlockMap

    Return a BlockMap read from a matrix market file.

    int
    EpetraExt::MatrixMarketFileToBlockMap(const char *filename, const
    Epetra_Comm &comm, Epetra_BlockMap *&blockMap)

    Constructs an Epetra_BlockMap object from a Matrix Market format file.

    This function constructs an Epetra_BlockMap or Epetra_Map object by
    reading a Matrix Market file. If the file was created using the
    EpetraExt::BlockMapOut functions, special information was encoded in
    the comment field of this map that allows for identical reproduction
    of the map, including distribution across processors and element size
    information. If the same of processors is being used to create the
    object as were used to write it, the object will be an exact
    reproduction of the original. Otherwise, a uniform distribution of the
    GIDs will be created.

    The first column of the input file will must be the list of GIDs in
    the map. If the block map has non-uniform sizes, a second column must
    contain the element sizes.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contained any requested header information followed by the map GIDs. A
    second column may be present if the BlockMap has nonuniform sizes.

    comm:  (In) An Epetra_Comm object describing the parallel machine.

    blockMap:  (Out) An Epetra_BlockMap object constructed from file
    contents.

    WARNING:  User must delete!!.

    Returns 0 if no error, -1 if any problems with file system, returns 1
    if number of processors differs from file creator. 
    """
    return _EpetraExt.MatrixMarketFileToBlockMap(*args)

def MatrixMarketFileToBlockMap64(*args):
    """
    MatrixMarketFileToBlockMap64(char const * filename, Comm comm) -> int

    int
    EpetraExt::MatrixMarketFileToBlockMap64(const char *filename, const
    Epetra_Comm &comm, Epetra_BlockMap *&map) 
    """
    return _EpetraExt.MatrixMarketFileToBlockMap64(*args)

def MatrixMarketFileToMap(*args):
    """
    MatrixMarketFileToMap(str filename, Epetra.Comm) -> Epetra.Map

    Return a Map read from a matrix market file.

    int
    EpetraExt::MatrixMarketFileToMap(const char *filename, const
    Epetra_Comm &comm, Epetra_Map *&map)

    Constructs an Epetra_BlockMap object from a Matrix Market format file.

    This function constructs an Epetra_BlockMap or Epetra_Map object by
    reading a Matrix Market file. If the file was created using the
    EpetraExt::BlockMapOut functions, special information was encoded in
    the comment field of this map that allows for identical reproduction
    of the map, including distribution across processors and element size
    information. If the same of processors is being used to create the
    object as were used to write it, the object will be an exact
    reproduction of the original. Otherwise, a uniform distribution of the
    GIDs will be created.

    The first column of the input file will must be the list of GIDs in
    the map. If the block map has non-uniform sizes, a second column must
    contain the element sizes.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contained any requested header information followed by the map GIDs. A
    second column may be present if the BlockMap has nonuniform sizes.

    comm:  (In) An Epetra_Comm object describing the parallel machine.

    map:  (Out) An Epetra_Map object constructed from file contents.

    WARNING:  User must delete!!.

    Returns 0 if no error, -1 if any problems with file system, -2 if file
    contained nontrivial Epetra_BlockMap, 1 if number of processors
    differs from file creator. 
    """
    return _EpetraExt.MatrixMarketFileToMap(*args)

def MatrixMarketFileToMap64(*args):
    """
    MatrixMarketFileToMap64(char const * filename, Comm comm) -> int

    int
    EpetraExt::MatrixMarketFileToMap64(const char *filename, const
    Epetra_Comm &comm, Epetra_Map *&map) 
    """
    return _EpetraExt.MatrixMarketFileToMap64(*args)

def MatrixMarketFileToBlockMaps(*args):
    """
    MatrixMarketFileToBlockMaps(str filename, Epetra.Comm) ->
        (Epetra.BlockMap rowMap, Epetra.BlockMap colMap, Epetra.BlockMap rangeMap,
         Epetra.BlockMap domainMap)

    Return a tuple of BlockMaps read from a matrix market file.  The
    BlockMaps, listed in order, are the row map, the column map, the range
    map and the domain map.

    int
    EpetraExt::MatrixMarketFileToBlockMaps(const char *filename, const
    Epetra_Comm &comm, Epetra_BlockMap *&rowmap, Epetra_BlockMap *&colmap,
    Epetra_BlockMap *&rangemap, Epetra_BlockMap *&domainmap)

    Constructs row,col,range and domain maps from a matrix-market matrix
    file. 
    """
    return _EpetraExt.MatrixMarketFileToBlockMaps(*args)

def MatrixMarketFileToBlockMaps64(*args):
    """
    MatrixMarketFileToBlockMaps64(char const * filename, Comm comm) -> int

    int
    EpetraExt::MatrixMarketFileToBlockMaps64(const char *filename, const
    Epetra_Comm &comm, Epetra_BlockMap *&rowmap, Epetra_BlockMap *&colmap,
    Epetra_BlockMap *&rangemap, Epetra_BlockMap *&domainmap)

    Constructs row,col,range and domain maps from a matrix-market matrix
    file. 
    """
    return _EpetraExt.MatrixMarketFileToBlockMaps64(*args)

def BlockMapToMatrixMarketFile(*args):
    """
    BlockMapToMatrixMarketFile(char const * filename, BlockMap blockMap, char const * mapName=None, char const * mapDescription=None, bool writeHeader=True) -> int

    int
    EpetraExt::BlockMapToMatrixMarketFile(const char *filename, const
    Epetra_BlockMap &blockMap, const char *mapName=0, const char
    *mapDescription=0, bool writeHeader=true)

    Writes an Epetra_BlockMap or Epetra_Map object to a Matrix Market
    format file.

    This function takes an Epetra_BlockMap or Epetra_Map object and writes
    it to the specified file. The map can be distributed or serial. The
    user can provide a strings containing the object name, a description,
    and specify that header information should or should not be printed to
    the file.

    Special information is encoded in the comment field of this map that
    allows for identical reproduction of the map, including distribution
    across processors and element size information.

    The first column of the output file will be the list of GIDs in the
    map. If the block map has non-uniform sizes, a second column will be
    generated containing the element sizes.

    Parameters:
    -----------

    filename:  (In) A filename, including path if desired. If a file with
    this name already exists, it will be deleted. On exit, this file will
    contained any requested header information followed by the map GIDs. A
    second column may be present if the BlockMap has nonuniform sizes.

    blockMap:  (In) An Epetra_BlockMap Object containing the user map to
    be dumped to file.

    mapName:  (In) A C-style string pointer to a name that will be stored
    in the comment field of the file. This is not a required argument.
    Note that it is possible to pass in the method A.Label().

    mapDescription:  (In) A C-style string pointer to a map description
    that will be stored in the comment field of the file.

    writeHeader:  (In) If true, the header will be written, otherwise only
    the map entries will be written.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.BlockMapToMatrixMarketFile(*args)

def BlockMapToHandle(*args):
    """
    BlockMapToHandle(std::FILE * handle, BlockMap blockMap) -> int

    int
    EpetraExt::BlockMapToHandle(std::FILE *handle, const Epetra_BlockMap
    &blockMap)

    Writes an Epetra_BlockMap or Epetra_Map object to a file handle.

    This function takes an Epetra_BlockMap or Epetra_Map object and writes
    it to the specified file handle.

    Parameters:
    -----------

    handle:  (In) A C-style file handle, already opened. On exit, the file
    associated with this handle will have appended to it a row for each
    multivector row.

    blockMap:  (In) An Epetra_BlockMap object containing the user object
    to be dumped to file.

    Returns 0 if no error, -1 if any problems with file system. 
    """
    return _EpetraExt.BlockMapToHandle(*args)

def writeBlockMap(*args):
    """
    writeBlockMap(std::FILE * handle, long long length, int const * v1, int const * v2, bool doSizes) -> int
    writeBlockMap(std::FILE * handle, long long length, long long const * v1, int const * v2, bool doSizes) -> int

    int
    EpetraExt::writeBlockMap(std::FILE *handle, long long length, const
    long long *v1, const int *v2, bool doSizes) 
    """
    return _EpetraExt.writeBlockMap(*args)
class CrsMatrix_SubCopy(SameXform_CrsMatrix):
    """


    Generates a sub-block view of a Epetra_CrsMatrix.

    C++ includes: EpetraExt_SubCopy_CrsMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [SameXform_CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsMatrix_SubCopy, name, value)
    __swig_getmethods__ = {}
    for _s in [SameXform_CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsMatrix_SubCopy, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_CrsMatrix_SubCopy

    def __init__(self, *args):
        """
        __init__(EpetraExt::CrsMatrix_SubCopy self, Map newMap) -> CrsMatrix_SubCopy
        __init__(EpetraExt::CrsMatrix_SubCopy self, Map newRangeAndRowMap, Map newDomainMap) -> CrsMatrix_SubCopy

        EpetraExt::CrsMatrix_SubCopy::CrsMatrix_SubCopy(const Epetra_Map
        &newRangeAndRowMap, const Epetra_Map &newDomainMap)

        Constructor. 
        """
        this = _EpetraExt.new_CrsMatrix_SubCopy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __call__(self, *args):
        """__call__(CrsMatrix_SubCopy self, CrsMatrix orig) -> CrsMatrix"""
        return _EpetraExt.CrsMatrix_SubCopy___call__(self, *args)


    def fwd(self, *args):
        """
        fwd(CrsMatrix_SubCopy self) -> bool

        bool
        EpetraExt::CrsMatrix_SubCopy::fwd()

        Forward transfer of data from orig object input in the operator()
        method call to the new object created in this same call. Returns true
        is operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.CrsMatrix_SubCopy_fwd(self, *args)


    def rvs(self, *args):
        """
        rvs(CrsMatrix_SubCopy self) -> bool

        bool
        EpetraExt::CrsMatrix_SubCopy::rvs()

        Reverse transfer of data from new object created in the operator()
        method call to the orig object input to this same method. Returns true
        if operation is successful.

        Preconditions:

        Invariants:

        Postconditions: 
        """
        return _EpetraExt.CrsMatrix_SubCopy_rvs(self, *args)

CrsMatrix_SubCopy_swigregister = _EpetraExt.CrsMatrix_SubCopy_swigregister
CrsMatrix_SubCopy_swigregister(CrsMatrix_SubCopy)


def Add(*args):
    """
    Add(Epetra.CrsMatrix A, bool flag, float valA, Epetra.CrsMatrix B,
        float valB) -> int

    Compute B <- valA * A + valB * B.  If flag is True, use the transpose
    of A.  B must either have the structure of A+B or not yet have
    FillComplete() called on it.
    """
    return _EpetraExt.Add(*args)

def Multiply(*args):
    """
    Multiply(Epetra.CrsMatrix A, bool transposeA, Epetra.CrsMatrix B, bool
        transposeB, Epetra.CrsMatrix C) -> int

    Compute C <- A * B, where transposeA and transposeB control the
    transposition of A and B respectively.  C must have the structure of A
    * B, or not yet have FillComplete() called on it.
    """
    return _EpetraExt.Multiply(*args)

from PyTrilinos import Epetra
from PyTrilinos import PropertyBase
from PyTrilinos import typed_tuple
from PyTrilinos import tuple_of_int
from PyTrilinos import tuple_of_str
tuple_of_Vector = typed_tuple(Epetra.Vector)



class InArgs(PropertyBase):
    """
    InArgs proxy class.

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    description  - string description of associated ModelEvaluation
    x            - bool or Epetra.Vector: solution vector support.  If True, the
                   solver should allocate the vector.  If False, x is not
                   supported.  If a vector, the solver should use the
                   user-provided data.  (default False)
    x_dot        - bool or Epetra.Vector: time derivative of solution vector
                   support.  If True, the solver should allocate the vector.  If
                   False, x_dot is not supported.  If a vector, the solver
                   should use the user- provided data.  (default False)
    p            - int or tuple_of_Vector: VARIABLE P support.  If an int, the
                   solver should allocate an array of the given number of
                   vectors.  If 0, p is not supported.  If a tuple_of_Vector,
                   the solver should use the user-provided data.  (default 0)
    t            - float: time (default None)
    alpha        - float: VARIABLE ALPHA (default None)
    beta         - float: VARIABLE BETA (default None)
    """
    props = {'description' : str,
             'x'           : (bool, Epetra.Vector),
#'x_poly'      : Teuchos.Polynomial,
             'x_dot'       : (bool, Epetra.Vector),
#'x_dot_poly'  : Teuchos.Polynomial,
             'p'           : (int, tuple_of_Vector),
             't'           : float,
             'alpha'       : float,
             'beta'        : float
             }
    defaults = {'description' : 'WARNING!  THIS INARGS OBJECT IS UNINITALIZED!',
                'x'           : False,
                'x_dot'       : False,
                'p'           : 0
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)



class Evaluation(PropertyBase):
    """
    Evaluation< RCP<Epetra_Vector> > proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    vector  - Epetra.Vector: (default None)
    type    - str: an enumeration limited to 'exact', 'approx_deriv', and
              'very_approx_deriv' (default None)
    """
    props = {'vector' : Epetra.Vector,
             'type'   : ('exact', 'approx_deriv', 'very_approx_deriv')
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)

tuple_of_Evaluation = typed_tuple(Evaluation)



class DerivativeSupport(PropertyBase):
    """
    DerivativeSupport proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    linearOp      - bool: True indicates that derivative is a linear operator
                    (default False)
    mVByCol       - bool: True indicates that derivative is a MultiVector stored
                    by column (defualt False)
    transMVByRow  - bool: True indicates that derivative is a transpose
                    MultiVector stored by row (default False)
    """
    props = {'linearOp'     : bool,
             'mVByCol'      : bool,
             'transMVByRow' : bool
             }
    defaults = {'linearOp'     : False,
                'mVByCol'      : False,
                'transMVByRow' : False
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)
    def none(self):
        noTrue = [True] * len(self.props)
        return (props.values() == noTrue)

tuple_of_DerivativeSupport = typed_tuple(DerivativeSupport)



class DerivativeProperties(PropertyBase):
    """
    DerivativeProperties proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    linearity        - str: an enumeration limited to 'unknown', 'const' and
                       'nonconst' (default 'unknown')
    rank             - str: an enumeration limited to 'unknown', 'full' and
                       'deficient' (default 'unknown')
    supportsAdjoint  - bool: True indicates that the adjoint is supported
                       (default False)
    """
    props = {'linearity'       : ('unknown', 'const', 'nonconst'),
             'rank'            : ('unknown', 'full', 'deficient'),
             'supportsAdjoint' : bool}
    defaults = {'linearity'       : 'unknown',
                'rank'            : 'unknown',
                'supportsAdjoint' : False}
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)

tuple_of_DerivativeProperties = typed_tuple(DerivativeProperties)



class DerivativeMultiVector(PropertyBase):
    """
    DerivativeMultiVector proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    multiVector   - Epetra.MultiVector: (default None)
    orientation   - str: an enumeration limited to 'mv_by_col', and
                    'trans_mv_by_row' (default None)
    paramIndexes  - tuple_of_int: (default None)
    """
    props = {'multiVector'  : Epetra.MultiVector,
             'orientation'  : ('mv_by_col', 'trans_mv_by_row'),
             'paramIndexes' : tuple_of_int
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)



class Derivative(PropertyBase):
    """
    Derivative proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    operator               - Epetra.Operator (default None)
    derivativeMultiVector  - DerivativeMultiVector (default None)

    Only one or the other of these two attributes should be set, to indicate the
    nature of the derivitive evaluation.
    """
    props = {'operator'              : Epetra.Operator,
             'derivativeMultiVector' : DerivativeMultiVector
             }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)
    def isEmpty(self):
        return (self.operator is None) and (self.derivativeMultiVector is None)

tuple_of_Derivative = typed_tuple(Derivative)



class OutArgs(PropertyBase):
    """
    OutArgs proxy class

    This is a 'Property' class restricted to specific attributes that are
    type-checked. These properties are:

    description          - string description of associated ModelEvaluation
    g                    - (int, tuple_of_Evaluation): VARIABLE G support.  If
                           an int, the solver should allocate an array of the
                           given number of Evaluations.  If 0, g is not
                           supported.  If a tuple_of_Evaluation, the solver
                           should use the user-provided data.  (default 0)
    f                    - (bool, Evaluation): VARIABLE F support.  If True, the
                           solver should allocate the Evaluation.  If False, f
                           is not supported.  If an Evaluation, the solver
                           should use the user-supplied data.  (default False)
    W                    - (bool, Epetra.Operator): VARIABLE W support.  If True, the
                           solver should allocate the operator.  If False, W
                           is not supported.  If an operator, the solver
                           should use the user-supplied data.  (default False)
    W_properties         - DerivativeProperties: derivative properties for
                           VARIABLE W.  (default None)
    DfDp                 - (int, tuple_of_Derivative): VARIABLE DFDP support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DfDp is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DfDp_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DFDP.  (default None)
    DgDx                 - (int, tuple_of_Derivative): VARIABLE DGDX support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDx is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDx_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDX.  (default None)
    DgDx_dot             - (int, tuple_of_Derivative): VARIABLE DGDX_DOT support.
                           If an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDx_dot is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDx_dot_properties  - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDX_DOT.  (default None)
    DgDp                 - (int, tuple_of_Derivative): VARIABLE DGDP support.  If
                           an int, the solver should allocate an array of the
                           given number of Derivatives.  If 0, DgDp is not
                           supported.  If a tuple_of_Derivative, the solver
                           should use the user-provided data.  (default 0)
    DgDp_properties      - tuple_of_DerivativeProperties: derivative properties
                           for VARIABLE DGDP.  (default None)
    """
    props = {'description'         : str,
             'g'                   : (int, tuple_of_Evaluation),
             'f'                   : (bool, Evaluation),
             'W'                   : (bool, Epetra.Operator),
             'W_properties'        : DerivativeProperties,
#'f_poly'              : Teuchos.Polynomial,
             'DfDp'                : (int, tuple_of_Derivative),
             'DfDp_properties'     : tuple_of_DerivativeProperties,
             'DgDx'                : (int, tuple_of_Derivative),
             'DgDx_properties'     : tuple_of_DerivativeProperties,
             'DgDx_dot'            : (int, tuple_of_Derivative),
             'DgDx_dot_properties' : tuple_of_DerivativeProperties,
             'DgDp'                : (int, tuple_of_Derivative),
             'DgDp_properties'     : tuple_of_DerivativeProperties
             }
    defaults = {'description' : 'WARNING!  THIS OUTARGS OBJECT IS UNINITALIZED!',
                'g'           : 0,
                'f'           : False,
                'W'           : False,
                'DfDp'        : 0,
                'DgDx'        : 0,
                'DgDx_dot'    : 0,
                'DgDp'        : 0
                }
    def __init__(self, **kwargs):
        PropertyBase.__init__(self, **kwargs)


class ModelEvaluator(Teuchos.Describable):
    """Proxy of C++ EpetraExt::ModelEvaluator class."""

    __swig_setmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ModelEvaluator, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ModelEvaluator, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _EpetraExt.delete_ModelEvaluator

    def get_x_map(self, *args):
        """get_x_map(ModelEvaluator self) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_x_map(self, *args)


    def get_f_map(self, *args):
        """get_f_map(ModelEvaluator self) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_f_map(self, *args)


    def get_p_map(self, *args):
        """get_p_map(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_p_map(self, *args)


    def get_p_names(self, *args):
        """get_p_names(ModelEvaluator self, int l) -> Teuchos::RCP< Teuchos::Array< std::string > const >"""
        return _EpetraExt.ModelEvaluator_get_p_names(self, *args)


    def get_g_map(self, *args):
        """get_g_map(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Map const >"""
        return _EpetraExt.ModelEvaluator_get_g_map(self, *args)


    def get_x_init(self, *args):
        """get_x_init(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_init(self, *args)


    def get_x_dot_init(self, *args):
        """get_x_dot_init(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_dot_init(self, *args)


    def get_p_init(self, *args):
        """get_p_init(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_p_init(self, *args)


    def get_t_init(self, *args):
        """get_t_init(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_get_t_init(self, *args)


    def getInfBound(self, *args):
        """getInfBound(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_getInfBound(self, *args)


    def get_x_lower_bounds(self, *args):
        """get_x_lower_bounds(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_lower_bounds(self, *args)


    def get_x_upper_bounds(self, *args):
        """get_x_upper_bounds(ModelEvaluator self) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_x_upper_bounds(self, *args)


    def get_p_lower_bounds(self, *args):
        """get_p_lower_bounds(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_p_lower_bounds(self, *args)


    def get_p_upper_bounds(self, *args):
        """get_p_upper_bounds(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Vector const >"""
        return _EpetraExt.ModelEvaluator_get_p_upper_bounds(self, *args)


    def get_t_lower_bound(self, *args):
        """get_t_lower_bound(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_get_t_lower_bound(self, *args)


    def get_t_upper_bound(self, *args):
        """get_t_upper_bound(ModelEvaluator self) -> double"""
        return _EpetraExt.ModelEvaluator_get_t_upper_bound(self, *args)


    def create_W(self, *args):
        """create_W(ModelEvaluator self) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_W(self, *args)


    def create_DfDp_op(self, *args):
        """create_DfDp_op(ModelEvaluator self, int l) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DfDp_op(self, *args)


    def create_DgDx_dot_op(self, *args):
        """create_DgDx_dot_op(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DgDx_dot_op(self, *args)


    def create_DgDx_op(self, *args):
        """create_DgDx_op(ModelEvaluator self, int j) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DgDx_op(self, *args)


    def create_DgDp_op(self, *args):
        """create_DgDp_op(ModelEvaluator self, int j, int l) -> Teuchos::RCP< Epetra_Operator >"""
        return _EpetraExt.ModelEvaluator_create_DgDp_op(self, *args)


    def createInArgs(self, *args):
        """createInArgs(ModelEvaluator self) -> EpetraExt::ModelEvaluator::InArgs"""
        return _EpetraExt.ModelEvaluator_createInArgs(self, *args)


    def createOutArgs(self, *args):
        """createOutArgs(ModelEvaluator self) -> EpetraExt::ModelEvaluator::OutArgs"""
        return _EpetraExt.ModelEvaluator_createOutArgs(self, *args)


    def evalModel(self, *args):
        """evalModel(ModelEvaluator self, EpetraExt::ModelEvaluator::InArgs const & inArgs, EpetraExt::ModelEvaluator::OutArgs const & outArgs)"""
        return _EpetraExt.ModelEvaluator_evalModel(self, *args)


    def __init__(self, *args):
        """__init__(EpetraExt::ModelEvaluator self) -> ModelEvaluator"""
        if self.__class__ == ModelEvaluator:
            _self = None
        else:
            _self = self
        this = _EpetraExt.new_ModelEvaluator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _EpetraExt.disown_ModelEvaluator(self)
        return weakref_proxy(self)
ModelEvaluator_swigregister = _EpetraExt.ModelEvaluator_swigregister
ModelEvaluator_swigregister(ModelEvaluator)

# This file is compatible with both classic and new-style classes.


