# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Epetra is the python interface to the Trilinos linear
algebra services package Epetra:

    http://trilinos.sandia.gov/packages/epetra

The purpose of Epetra is to provide fundamental linear algebra
services to the rest of Trilinos.  These services include parallel
decomposition and communication, vectors and multivectors, graphs,
operators, and dense and sparse matrices.  Note that the C++ version
of Epetra uses the prefix 'Epetra_' which has been stripped from the
python version.

Epetra provides the following user-level classes (by category):

    * Communicators: PyComm, SerialComm, MpiComm (if built with mpi
      support)
    * Data distribution maps: Map, BlockMap, LocalMap
    * Vectors: Vector, MultiVector, IntVector
    * Graphs: CrsGraph, FECrsGraph
    * Operators and matrices: Operator, RowMatrix, CrsMatrix,
      FECrsMatrix, VbrMatrix
    * Serial dense objects: SerialDenseVector, SerialDenseMatrix,
      SerialDenseOperator, SerialDenseSolver, IntSerialDenseVector,
      IntSerialDenseMatrix
    * Aggregates: LinearProblem
    * Utilities: Import, Export, Time, MapColoring, Util

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exEpetra.py
    * exEpetra_Comm.py
    * exEpetra_ImportExport.py
    * exEpetra_CrsMatrix_Easy.py
    * exEpetra_CrsMatrix_Efficient.py
    * exEpetra_FECrsMatrix_Easy.py

The Epetra module has been designed to use and interoperate with the
numpy module, which provides multidimensional array support.  Epetra
class constructors or methods that expect C arrays in C++ can
typically accept numpy arrays in python (or any python sequence that
numpy can convert to an array).  Similarly, methods that return C
arrays in C++ will return numpy arrays in python.  Also, certain
Epetra classes that represent contiguous blocks of homogeneous data
have been given the attributes of numpy arrays: Vector, MultiVector,
IntVector, SerialDenseVector, SerialDenseMatrix, IntSerialDenseVector
and IntSerialDenseMatrix.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Epetra')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Epetra')
    _Epetra = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Epetra', [dirname(__file__)])
        except ImportError:
            import _Epetra
            return _Epetra
        try:
            _mod = imp.load_module('_Epetra', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Epetra = swig_import_helper()
    del swig_import_helper
else:
    import _Epetra
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SwigPyIterator

    def value(self, *args):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator_value(self, *args)


    def incr(self, *args):
        """incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_incr(self, *args)


    def decr(self, *args):
        """decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_decr(self, *args)


    def distance(self, *args):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Epetra.SwigPyIterator_distance(self, *args)


    def equal(self, *args):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Epetra.SwigPyIterator_equal(self, *args)


    def copy(self, *args):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_copy(self, *args)


    def next(self, *args):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator_next(self, *args)


    def __next__(self, *args):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator___next__(self, *args)


    def previous(self, *args):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator_previous(self, *args)


    def advance(self, *args):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_advance(self, *args)


    def __eq__(self, *args):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Epetra.SwigPyIterator___eq__(self, *args)


    def __ne__(self, *args):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Epetra.SwigPyIterator___ne__(self, *args)


    def __iadd__(self, *args):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator___iadd__(self, *args)


    def __isub__(self, *args):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator___isub__(self, *args)


    def __add__(self, *args):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator___add__(self, *args)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Epetra.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Epetra.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

SHARED_PTR_DISOWN = _Epetra.SHARED_PTR_DISOWN

# Much of the Epetra module is compatible with the numpy module
import numpy

Error = _Epetra.Error

def class_array_inplace_op(self, op_str, other):
  in_op = getattr(self.array, "__i"+op_str+"__")
  in_op(other.array)
  return self

def class_array_math_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
# Get the equivalent in-place operator for the result
  in_op = getattr(result.array, "__i"+op_str+"__")
  try:
    in_op(other.array)
  except AttributeError:
    in_op(other)
  return result

def class_array_rmath_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
  indices = (slice(None),) * len(self.array.shape)
  result.array[indices] = other
  in_op = getattr(result.array, "__i"+op_str+"__")
  in_op(self.array)
  return result

def class_array_add_math_ops(cls, op_str):
  setattr(cls,
          "__i"+op_str+"__",
          lambda self, other: class_array_inplace_op(self, op_str, other))
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_math_op(self, op_str, other))
  setattr(cls,
          "__r"+op_str+"__",
          lambda self, other: class_array_rmath_op(self, op_str, other))

def class_array_add_math(cls):
  class_array_add_math_ops(cls, "add")
  class_array_add_math_ops(cls, "sub")
  class_array_add_math_ops(cls, "mul")
  class_array_add_math_ops(cls, "add")

def class_array_comp_op(self, op_str, other):
  comp_op = getattr(self.array, "__"+op_str+"__")
  try:
    return comp_op(other.array)
  except AttributeError:
    return comp_op(other)

def class_array_add_comp_op(cls, op_str):
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_comp_op(self, op_str, other))

def class_array_add_comp(cls):
  class_array_add_comp_op(cls, "lt")
  class_array_add_comp_op(cls, "le")
  class_array_add_comp_op(cls, "eq")
  class_array_add_comp_op(cls, "ne")
  class_array_add_comp_op(cls, "gt")
  class_array_add_comp_op(cls, "ge")


def Epetra_Version(*args):
    """
    Epetra_Version() -> std::string

    std::string Epetra_Version()

    """
    return _Epetra.Epetra_Version(*args)

Version = Epetra_Version
__version__ = Version().split()[2]

Add = _Epetra.Add
Zero = _Epetra.Zero
Insert = _Epetra.Insert
InsertAdd = _Epetra.InsertAdd
Average = _Epetra.Average
Epetra_Max = _Epetra.Epetra_Max
Epetra_Min = _Epetra.Epetra_Min
AbsMax = _Epetra.AbsMax
AbsMin = _Epetra.AbsMin
Epetra_AddLocalAlso = _Epetra.Epetra_AddLocalAlso
Copy = _Epetra.Copy
View = _Epetra.View
class Object(_object):
    """
    The base Epetra class.

    The Epetra_Object class provides capabilities common to all Epetra
    objects, such as a label that identifies an object instance, constant
    definitions, enum types.  In C++, it supports a ``Print()`` method
    that takes an output stream as an argument.  In the python
    implementation for this and all derived classes, this method takes an
    optional file object argument whose default value is standard out.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Object, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Object, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Object self, int TracebackModeIn=-1, bool set_label=True) -> Object
        __init__(Epetra_Object self, char const *const Label, int TracebackModeIn=-1) -> Object
        __init__(Epetra_Object self, Object Object) -> Object

        Epetra_Object::Epetra_Object(const Epetra_Object &Object)

        Epetra_Object Copy Constructor.

        Makes an exact copy of an existing Epetra_Object instance. 
        """
        this = _Epetra.new_Object(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Object

    def SetLabel(self, *args):
        """
        SetLabel(Object self, char const *const Label)

        void
        Epetra_Object::SetLabel(const char *const Label)

        Epetra_Object Label definition using char *.

        Defines the label used to describe the this object. 
        """
        return _Epetra.Object_SetLabel(self, *args)


    def Label(self, *args):
        """
        Label(Object self) -> char const *

        const char *
        Epetra_Object::Label() const

        Epetra_Object Label access funtion.

        Returns the string used to define this object. 
        """
        return _Epetra.Object_Label(self, *args)


    def SetTracebackMode(*args):
        """
        SetTracebackMode(int TracebackModeValue)

        void
        Epetra_Object::SetTracebackMode(int TracebackModeValue)

        Set the value of the Epetra_Object error traceback report mode.

        Sets the integer error traceback behavior. TracebackMode controls
        whether or not traceback information is printed when run time integer
        errors are detected:

        <= 0 - No information report

        = 1 - Fatal (negative) values are reported

        >= 2 - All values (except zero) reported.

        Default is set to 1. 
        """
        return _Epetra.Object_SetTracebackMode(*args)

    SetTracebackMode = staticmethod(SetTracebackMode)

    def GetTracebackMode(*args):
        """
        GetTracebackMode() -> int

        int
        Epetra_Object::GetTracebackMode()

        Get the value of the Epetra_Object error report mode. 
        """
        return _Epetra.Object_GetTracebackMode(*args)

    GetTracebackMode = staticmethod(GetTracebackMode)

    def GetTracebackStream(*args):
        """
        GetTracebackStream() -> std::ostream &

        std::ostream & Epetra_Object::GetTracebackStream()

        Get the output stream for error reporting. 
        """
        return _Epetra.Object_GetTracebackStream(*args)

    GetTracebackStream = staticmethod(GetTracebackStream)

    def ReportError(self, *args):
        """
        ReportError(Object self, std::string const Message, int ErrorCode) -> int

        int
        Epetra_Object::ReportError(const std::string Message, int ErrorCode)
        const

        Error reporting method. 
        """
        return _Epetra.Object_ReportError(self, *args)

    __swig_setmethods__["TracebackMode"] = _Epetra.Object_TracebackMode_set
    __swig_getmethods__["TracebackMode"] = _Epetra.Object_TracebackMode_get
    if _newclass:
        TracebackMode = _swig_property(_Epetra.Object_TracebackMode_get, _Epetra.Object_TracebackMode_set)

    def __str__(self, *args):
        """
        __str__(Object self) -> PyObject *

        Returns the results of ``Print()`` in a string, so that
        the python ``print`` command will work on ``Epetra`` objects.  The
        ``Print()`` methods are designed to run correctly in parallel, so do
        not execute ``print`` on an Epetra object conditionally on the
        processor number.  For example, do not do

          ``if comm.MyPID() == 0: print epetra_obj``

        or it will hang your code.
        """
        return _Epetra.Object___str__(self, *args)


    def Print(self, *args):
        """
        Print(Object self, PyObject * pf=None)

        void
        Epetra_Object::Print(std::ostream &os) const

        Print object to an output stream Print method 
        """
        return _Epetra.Object_Print(self, *args)

Object_swigregister = _Epetra.Object_swigregister
Object_swigregister(Object)
cvar = _Epetra.cvar
Epetra_MinDouble = cvar.Epetra_MinDouble
Epetra_MaxDouble = cvar.Epetra_MaxDouble
Epetra_Overflow = cvar.Epetra_Overflow
Epetra_Underflow = cvar.Epetra_Underflow
FormatStdout = cvar.FormatStdout
DefaultTracebackMode = cvar.DefaultTracebackMode

def Object_SetTracebackMode(*args):
    """
    Object_SetTracebackMode(int TracebackModeValue)

    void
    Epetra_Object::SetTracebackMode(int TracebackModeValue)

    Set the value of the Epetra_Object error traceback report mode.

    Sets the integer error traceback behavior. TracebackMode controls
    whether or not traceback information is printed when run time integer
    errors are detected:

    <= 0 - No information report

    = 1 - Fatal (negative) values are reported

    >= 2 - All values (except zero) reported.

    Default is set to 1. 
    """
    return _Epetra.Object_SetTracebackMode(*args)

def Object_GetTracebackMode(*args):
    """
    Object_GetTracebackMode() -> int

    int
    Epetra_Object::GetTracebackMode()

    Get the value of the Epetra_Object error report mode. 
    """
    return _Epetra.Object_GetTracebackMode(*args)

def Object_GetTracebackStream(*args):
    """
    Object_GetTracebackStream() -> std::ostream &

    std::ostream & Epetra_Object::GetTracebackStream()

    Get the output stream for error reporting. 
    """
    return _Epetra.Object_GetTracebackStream(*args)

class CompObject(_object):
    """


    Epetra_CompObject: Functionality and data that is common to all
    computational classes.

    The Epetra_CompObject is a base class for all Epetra computational
    objects. It provides the basic mechanisms and interface specifications
    for floating point operations using Epetra_Flops objects.

    C++ includes: Epetra_CompObject.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CompObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_CompObject self) -> CompObject
        __init__(Epetra_CompObject self, CompObject Source) -> CompObject

        Epetra_CompObject::Epetra_CompObject(const Epetra_CompObject &Source)

        Epetra_CompObject copy constructor. 
        """
        this = _Epetra.new_CompObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_CompObject

    def SetFlopCounter(self, *args):
        """
        SetFlopCounter(CompObject self, FLOPS FlopCounter_in)
        SetFlopCounter(CompObject self, CompObject CompObject)

        void
        Epetra_CompObject::SetFlopCounter(const Epetra_CompObject &CompObject)

        Set the internal Epetra_Flops() pointer to the flop counter of another
        Epetra_CompObject. 
        """
        return _Epetra.CompObject_SetFlopCounter(self, *args)


    def UnsetFlopCounter(self, *args):
        """
        UnsetFlopCounter(CompObject self)

        void
        Epetra_CompObject::UnsetFlopCounter()

        Set the internal Epetra_Flops() pointer to 0 (no flops counted). 
        """
        return _Epetra.CompObject_UnsetFlopCounter(self, *args)


    def GetFlopCounter(self, *args):
        """
        GetFlopCounter(CompObject self) -> FLOPS

        Epetra_Flops* Epetra_CompObject::GetFlopCounter() const

        Get the pointer to the Epetra_Flops() object associated with this
        object, returns 0 if none. 
        """
        return _Epetra.CompObject_GetFlopCounter(self, *args)


    def ResetFlops(self, *args):
        """
        ResetFlops(CompObject self)

        void
        Epetra_CompObject::ResetFlops() const

        Resets the number of floating point operations to zero for this multi-
        vector. 
        """
        return _Epetra.CompObject_ResetFlops(self, *args)


    def Flops(self, *args):
        """
        Flops(CompObject self) -> double

        double
        Epetra_CompObject::Flops() const

        Returns the number of floating point operations with this multi-
        vector. 
        """
        return _Epetra.CompObject_Flops(self, *args)


    def UpdateFlops(self, *args):
        """
        UpdateFlops(CompObject self, long Flops_in)
        UpdateFlops(CompObject self, long long Flops_in)
        UpdateFlops(CompObject self, double Flops_in)

        void
        Epetra_CompObject::UpdateFlops(float Flops_in) const

        Increment Flop count for this object. 
        """
        return _Epetra.CompObject_UpdateFlops(self, *args)

CompObject_swigregister = _Epetra.CompObject_swigregister
CompObject_swigregister(CompObject)

class BLAS(_object):
    """


    Epetra_BLAS: The Epetra BLAS Wrapper Class.

    The Epetra_BLAS class is a wrapper that encapsulates the BLAS (Basic
    Linear Algebra Subprograms). The BLAS provide portable, high-
    performance implementations of kernels such as dense vectoer
    multiplication, dot products, dense matrix-vector multiplication and
    dense matrix-matrix multiplication.

    The standard BLAS interface is Fortran-specific. Unfortunately, the
    interface between C++ and Fortran is not standard across all computer
    platforms. The Epetra_BLAS class provides C++ wrappers for the BLAS
    kernels in order to insulate the rest of Epetra from the details of
    C++ to Fortran translation. A Epetra_BLAS object is essentially
    nothing, but allows access to the BLAS wrapper functions.

    Epetra_BLAS is a serial interface only. This is appropriate since the
    standard BLAS are only specified for serial execution (or shared
    memory parallel).

    C++ includes: Epetra_BLAS.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BLAS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BLAS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_BLAS self) -> BLAS
        __init__(Epetra_BLAS self, BLAS BLAS) -> BLAS

        Epetra_BLAS::Epetra_BLAS(const Epetra_BLAS &BLAS)

        Epetra_BLAS Copy Constructor.

        Makes an exact copy of an existing Epetra_BLAS instance. 
        """
        this = _Epetra.new_BLAS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_BLAS

    def SYRK(self, *args):
        """
        SYRK(BLAS self, char const UPLO, char const TRANS, int const N, int const K, float const ALPHA, float const * A, int const LDA, float const BETA, float * C, int const LDC)
        SYRK(BLAS self, char const UPLO, char const TRANS, int const N, int const K, double const ALPHA, double const * A, int const LDA, double const BETA, double * C, int const LDC)

        void
        Epetra_BLAS::SYRK(const char UPLO, const char TRANS, const int N,
        const int K, const double ALPHA, const double *A, const int LDA, const
        double BETA, double *C, const int LDC) const

        Eperta_BLAS symetric rank k funtion (dsyrk) 
        """
        return _Epetra.BLAS_SYRK(self, *args)

BLAS_swigregister = _Epetra.BLAS_swigregister
BLAS_swigregister(BLAS)

class LAPACK(_object):
    """


    Epetra_LAPACK: The Epetra LAPACK Wrapper Class.

    The Epetra_LAPACK class is a wrapper that encapsulates LAPACK (Linear
    Algebra Package). LAPACK provides portable, high- performance
    implementations of linear, eigen, SVD, etc solvers.

    The standard LAPACK interface is Fortran-specific. Unfortunately, the
    interface between C++ and Fortran is not standard across all computer
    platforms. The Epetra_LAPACK class provides C++ wrappers for the
    LAPACK kernels in order to insulate the rest of Epetra from the
    details of C++ to Fortran translation. A Epetra_LAPACK object is
    essentially nothing, but allows access to the LAPACK wrapper
    functions.

    Epetra_LAPACK is a serial interface only. This is appropriate since
    the standard LAPACK are only specified for serial execution (or shared
    memory parallel).

    C++ includes: Epetra_LAPACK.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LAPACK, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LAPACK, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LAPACK self) -> LAPACK
        __init__(Epetra_LAPACK self, LAPACK LAPACK) -> LAPACK

        Epetra_LAPACK::Epetra_LAPACK(const Epetra_LAPACK &LAPACK)

        Epetra_LAPACK Copy Constructor.

        Makes an exact copy of an existing Epetra_LAPACK instance. 
        """
        this = _Epetra.new_LAPACK(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_LAPACK

    def TRTRS(self, *args):
        """
        TRTRS(LAPACK self, char const UPLO, char const TRANS, char const DIAG, int const N, int const NRHS, float const * A, int const LDA, float * B, int const LDB, int * INFO)
        TRTRS(LAPACK self, char const UPLO, char const TRANS, char const DIAG, int const N, int const NRHS, double const * A, int const LDA, double * B, int const LDB, int * INFO)

        void
        Epetra_LAPACK::TRTRS(const char UPLO, const char TRANS, const char
        DIAG, const int N, const int NRHS, const double *A, const int LDA,
        double *B, const int LDB, int *INFO) const

        Epetra_LAPACK wrapper for TRTRS routine. 
        """
        return _Epetra.LAPACK_TRTRS(self, *args)

LAPACK_swigregister = _Epetra.LAPACK_swigregister
LAPACK_swigregister(LAPACK)

class FLOPS(_object):
    """


    Epetra_Flops: The Epetra Floating Point Operations Class.

    The Epetra_Flops class provides basic support and consistent
    interfaces for counting and reporting floating point operations
    performed in the Epetra computational classes. All classes based on
    the Epetra_CompObject can count flops by the user creating an
    Epetra_Flops object and calling the SetFlopCounter() method for an
    Epetra_CompObject.

    C++ includes: Epetra_Flops.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FLOPS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FLOPS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Flops self) -> FLOPS
        __init__(Epetra_Flops self, FLOPS Flops_in) -> FLOPS

        Epetra_Flops::Epetra_Flops(const Epetra_Flops &Flops_in)

        Epetra_Flops Copy Constructor.

        Makes an exact copy of an existing Epetra_Flops instance. 
        """
        this = _Epetra.new_FLOPS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Flops(self, *args):
        """
        Flops(FLOPS self) -> double

        double
        Epetra_Flops::Flops() const

        Returns the number of floating point operations with this object and
        resets the count. 
        """
        return _Epetra.FLOPS_Flops(self, *args)


    def ResetFlops(self, *args):
        """
        ResetFlops(FLOPS self)

        void
        Epetra_Flops::ResetFlops()

        Resets the number of floating point operations to zero for this multi-
        vector. 
        """
        return _Epetra.FLOPS_ResetFlops(self, *args)

    __swig_destroy__ = _Epetra.delete_FLOPS
FLOPS_swigregister = _Epetra.FLOPS_swigregister
FLOPS_swigregister(FLOPS)

class Time(Object):
    """


    Epetra_Time: The Epetra Timing Class.

    The Epetra_Time class is a wrapper that encapsulates the general
    information needed getting timing information. Currently it return the
    elapsed time for each calling processor.. A Epetra_Comm object is
    required for building all Epetra_Time objects.

    Epetra_Time support both serial execution and (via MPI) parallel
    distributed memory execution. It is meant to insulate the user from
    the specifics of timing across a variety of platforms.

    C++ includes: Epetra_Time.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Time, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Time, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Time self, Comm Comm) -> Time
        __init__(Epetra_Time self, Time Time) -> Time

        Epetra_Time::Epetra_Time(const Epetra_Time &Time)

        Epetra_Time Copy Constructor.

        Makes an exact copy of an existing Epetra_Time instance. 
        """
        this = _Epetra.new_Time(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def WallTime(self, *args):
        """
        WallTime(Time self) -> double

        double
        Epetra_Time::WallTime(void) const

        Epetra_Time wall-clock time function.

        Returns the wall-clock time in seconds. A code section can be timed by
        putting it between two calls to WallTime and taking the difference of
        the times. 
        """
        return _Epetra.Time_WallTime(self, *args)


    def ResetStartTime(self, *args):
        """
        ResetStartTime(Time self)

        void
        Epetra_Time::ResetStartTime(void)

        Epetra_Time function to reset the start time for a timer object.

        Resets the start time for the timer object to the current time A code
        section can be timed by putting it between a call to ResetStartTime
        and ElapsedTime. 
        """
        return _Epetra.Time_ResetStartTime(self, *args)


    def ElapsedTime(self, *args):
        """
        ElapsedTime(Time self) -> double

        double
        Epetra_Time::ElapsedTime(void) const

        Epetra_Time elapsed time function.

        Returns the elapsed time in seconds since the timer object was
        constructed, or since the ResetStartTime function was called. A code
        section can be timed by putting it between the Epetra_Time constructor
        and a call to ElapsedTime, or between a call to ResetStartTime and
        ElapsedTime. 
        """
        return _Epetra.Time_ElapsedTime(self, *args)

    __swig_destroy__ = _Epetra.delete_Time
Time_swigregister = _Epetra.Time_swigregister
Time_swigregister(Time)


def _extractNumPyArrayFromEpetraIntSerialDenseMatrix(source):
    """_extractNumPyArrayFromEpetraIntSerialDenseMatrix(IntSerialDenseMatrix source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraIntSerialDenseMatrix(source)
class IntSerialDenseMatrix(Object):
    """


    Epetra_IntSerialDenseMatrix: A class for constructing and using
    general dense integer matrices.

    The Epetra_IntSerialDenseMatrix class enables the construction and use
    of integer-valued, general dense matrices.

    The Epetra_IntSerialDenseMatrix class is intended to provide very
    basic support for dense rectangular matrices.

    Constructing Epetra_IntSerialDenseMatrix Objects

    There are four Epetra_IntSerialDenseMatrix constructors. The first
    constructs a zero-sized object which should be made to appropriate
    length using the Shape() or Reshape() functions and then filled with
    the [] or () operators. The second constructs an object sized to the
    dimensions specified, which should be filled with the [] or ()
    operators. The third is a constructor that accepts user data as a 2D
    array, and the fourth is a copy constructor. The third constructor has
    two data access modes (specified by the Epetra_DataAccess argument):
    Copy mode - Allocates memory and makes a copy of the user-provided
    data. In this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the object.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  Epetra_IntSerialDenseMatrix constructors will
    throw an exception if an error occurrs. These exceptions will alway be
    negative integer values as follows: -1 Invalid dimension specified.

    -2 Shape returned non-zero.

    -3 Null pointer specified for user's data.

    -99 Internal Epetra_IntSerialDenseMatrix error. Contact developer.

    Other Epetra_IntSerialDenseMatrix functions that do not return an
    integer error code (such as operators () and [] ) will throw an
    exception if an error occurrs. These exceptions will be integer values
    as follows: -1 Invalid row specified.

    -2 Invalid column specified.

    -5 Invalid assignment (type mismatch).

    -99 Internal Epetra_IntSerialDenseMatrix error. Contact developer.

    b Extracting Data from Epetra_IntSerialDenseMatrix Objects

    Once a Epetra_IntSerialDenseMatrix is constructed, it is possible to
    view the data via access functions.

    WARNING:  Use of these access functions cam be extremely dangerous
    from a data hiding perspective.  Vector and Utility Functions

    Once a Epetra_IntSerialDenseMatrix is constructed, several
    mathematical functions can be applied to the object. Specifically:
    Multiplication.

    Norms.

    C++ includes: Epetra_IntSerialDenseMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntSerialDenseMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntSerialDenseMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_IntSerialDenseMatrix

    def Shape(self, NumRows, NumCols):
        """
        Shape(IntSerialDenseMatrix self, int NumRows, int NumCols) -> int

        int
        Epetra_IntSerialDenseMatrix::Shape(int NumRows, int NumCols)

        Set dimensions of a Epetra_IntSerialDenseMatrix object; init values to
        zero.

        Parameters:
        -----------

        In:  NumRows - Number of rows in object.

        In:  NumCols - Number of columns in object.

        Allows user to define the dimensions of a Epetra_IntSerialDenseMatrix
        at any point. This function can be called at any point after
        construction. Any values that were previously in this object are
        destroyed and the resized matrix starts off with all zero values.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.IntSerialDenseMatrix_Shape(self, NumRows, NumCols)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def Reshape(self, NumRows, NumCols):
        """
        Reshape(IntSerialDenseMatrix self, int NumRows, int NumCols) -> int

        int
        Epetra_IntSerialDenseMatrix::Reshape(int NumRows, int NumCols)

        Reshape a Epetra_IntSerialDenseMatrix object.

        Parameters:
        -----------

        In:  NumRows - Number of rows in object.

        In:  NumCols - Number of columns in object.

        Allows user to define the dimensions of a Epetra_IntSerialDenseMatrix
        at any point. This function can be called at any point after
        construction. Any values that were previously in this object are
        copied into the new shape. If the new shape is smaller than the
        original, the upper left portion of the original matrix (the principal
        submatrix) is copied to the new matrix.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.IntSerialDenseMatrix_Reshape(self, NumRows, NumCols)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def OneNorm(self):
        """
        OneNorm(IntSerialDenseMatrix self) -> int

        int
        Epetra_IntSerialDenseMatrix::OneNorm()

        Computes the 1-Norm of the this matrix.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.IntSerialDenseMatrix_OneNorm(self)


    def InfNorm(self):
        """
        InfNorm(IntSerialDenseMatrix self) -> int

        int
        Epetra_IntSerialDenseMatrix::InfNorm()

        Computes the Infinity-Norm of the this matrix. 
        """
        return _Epetra.IntSerialDenseMatrix_InfNorm(self)


    def __eq__(self, rhs):
        """__eq__(IntSerialDenseMatrix self, IntSerialDenseMatrix rhs) -> bool"""
        return _Epetra.IntSerialDenseMatrix___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(IntSerialDenseMatrix self, IntSerialDenseMatrix rhs) -> bool"""
        return _Epetra.IntSerialDenseMatrix___ne__(self, rhs)


    def __call__(self, RowIndex, ColIndex):
        """__call__(IntSerialDenseMatrix self, int RowIndex, int ColIndex) -> int const &"""
        return _Epetra.IntSerialDenseMatrix___call__(self, RowIndex, ColIndex)


    def Random(self):
        """
        Random(IntSerialDenseMatrix self) -> int

        int
        Epetra_IntSerialDenseMatrix::Random()

        Set matrix values to random numbers.

        IntSerialDenseMatrix uses the random number generator provided by
        Epetra_Util.     The matrix values will be set to random values on the
        interval (0, 2^31 - 1).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.IntSerialDenseMatrix_Random(self)


    def M(self):
        """
        M(IntSerialDenseMatrix self) -> int

        int
        Epetra_IntSerialDenseMatrix::M() const

        Returns row dimension of system. 
        """
        return _Epetra.IntSerialDenseMatrix_M(self)


    def N(self):
        """
        N(IntSerialDenseMatrix self) -> int

        int
        Epetra_IntSerialDenseMatrix::N() const

        Returns column dimension of system. 
        """
        return _Epetra.IntSerialDenseMatrix_N(self)


    def A(self):
        """
        A(IntSerialDenseMatrix self) -> int *

        int*
        Epetra_IntSerialDenseMatrix::A()

        Returns pointer to the this matrix. 
        """
        return _Epetra.IntSerialDenseMatrix_A(self)


    def LDA(self):
        """
        LDA(IntSerialDenseMatrix self) -> int

        int
        Epetra_IntSerialDenseMatrix::LDA() const

        Returns the leading dimension of the this matrix. 
        """
        return _Epetra.IntSerialDenseMatrix_LDA(self)


    def CV(self):
        """
        CV(IntSerialDenseMatrix self) -> Epetra_DataAccess

        Epetra_DataAccess Epetra_IntSerialDenseMatrix::CV() const

        Returns the data access mode of the this matrix. 
        """
        return _Epetra.IntSerialDenseMatrix_CV(self)


    def __init__(self, *args):
        """
        __init__(Epetra_IntSerialDenseMatrix self) -> IntSerialDenseMatrix
        __init__(Epetra_IntSerialDenseMatrix self, int NumRows, int NumCols) -> IntSerialDenseMatrix
        __init__(Epetra_IntSerialDenseMatrix self, IntSerialDenseMatrix Source) -> IntSerialDenseMatrix
        __init__(Epetra_IntSerialDenseMatrix self, PyObject * array) -> IntSerialDenseMatrix

        Epetra_IntSerialDenseMatrix::Epetra_IntSerialDenseMatrix(const
        Epetra_IntSerialDenseMatrix &Source)

        Epetra_IntSerialDenseMatrix copy constructor.

        This matrix will take on the data access mode of the Source matrix. 
        """
        this = _Epetra.new_IntSerialDenseMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
IntSerialDenseMatrix_swigregister = _Epetra.IntSerialDenseMatrix_swigregister
IntSerialDenseMatrix_swigregister(IntSerialDenseMatrix)


def IntSerialDenseMatrix_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraIntSerialDenseMatrix(self)
#a = a.transpose()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of IntSerialDenseMatrix" % name)
def IntSerialDenseMatrix_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change IntSerialDenseMatrix 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change IntSerialDenseMatrix 'dtype' attribute")
    else:
        self.__dict__[name] = value
IntSerialDenseMatrix.__getattr__ = IntSerialDenseMatrix_getattr
IntSerialDenseMatrix.__setattr__ = IntSerialDenseMatrix_setattr
IntSerialDenseMatrix.__getitem__ = lambda self, i: self.array.__getitem__(i)
IntSerialDenseMatrix.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
IntSerialDenseMatrix.__len__     = lambda self: self.array.__len__()
IntSerialDenseMatrix.__str__     = lambda self: self.array.__str__()
IntSerialDenseMatrix.A           = lambda self: self.array
class_array_add_math(IntSerialDenseMatrix)
class_array_add_comp(IntSerialDenseMatrix)


def _extractNumPyArrayFromEpetraIntSerialDenseVector(source):
    """_extractNumPyArrayFromEpetraIntSerialDenseVector(IntSerialDenseVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraIntSerialDenseVector(source)
class IntSerialDenseVector(IntSerialDenseMatrix):
    """


    Epetra_IntSerialDenseVector: A class for constructing and using dense
    vectors.

    The Epetra_IntSerialDenseVector class enables the construction and use
    of integer-valued, dense vectors. It derives from the
    Epetra_IntSerialDenseMatrix class.

    The Epetra_IntSerialDenseVector class is intended to provide
    convenient vector notation but derives all signficant functionality
    from Epetra_IntSerialDenseMatrix.

    Constructing Epetra_IntSerialDenseVector Objects

    There are three Epetra_IntSerialDenseVector constructors. The first
    constructs a zero-length object which should be made to appropriate
    length using the Size() or Resize() functions and then filled with the
    [] or () operators. The second constructs an object sized to the
    dimension specified, which should be filled with the [] or ()
    operators. The third is a constructor that accepts user data as a 1D
    array, and the fourth is a copy constructor. The third constructor has
    two data access modes (specified by the Epetra_DataAccess argument):
    Copy mode - Allocates memory and makes a copy of the user-provided
    data. In this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the object.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  Extracting Data from Epetra_IntSerialDenseVector
    Objects

    Once a Epetra_IntSerialDenseVector is constructed, it is possible to
    view the data via access functions.

    WARNING:  Use of these access functions cam be extremely dangerous
    from a data hiding perspective.

    C++ includes: Epetra_IntSerialDenseVector.h 
    """

    __swig_setmethods__ = {}
    for _s in [IntSerialDenseMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntSerialDenseVector, name, value)
    __swig_getmethods__ = {}
    for _s in [IntSerialDenseMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntSerialDenseVector, name)
    __repr__ = _swig_repr

    def Size(self, Length_in):
        """
        Size(IntSerialDenseVector self, int Length_in) -> int

        int
        Epetra_IntSerialDenseVector::Size(int Length_in)

        Set length of a Epetra_IntSerialDenseVector object; init values to
        zero.

        Parameters:
        -----------

        In:  Length - Length of vector object.

        Allows user to define the dimension of a Epetra_IntSerialDenseVector.
        This function can be called at any point after construction. Any
        values that were previously in this object are destroyed and the
        resized vector starts off with all zero values.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.IntSerialDenseVector_Size(self, Length_in)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def Resize(self, Length_in):
        """
        Resize(IntSerialDenseVector self, int Length_in) -> int

        int
        Epetra_IntSerialDenseVector::Resize(int Length_in)

        Resize a Epetra_IntSerialDenseVector object.

        Parameters:
        -----------

        In:  Length - Length of vector object.

        Allows user to define the dimension of a Epetra_IntSerialDenseVector.
        This function can be called at any point after construction. Any
        values that were previously in this object are copied into the new
        size. If the new shape is smaller than the original, the first Length
        values are copied to the new vector.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.IntSerialDenseVector_Resize(self, Length_in)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val

    __swig_destroy__ = _Epetra.delete_IntSerialDenseVector

    def __call__(self, *args):
        """
        __call__(IntSerialDenseVector self, int RowIndex, int ColIndex) -> int const
        __call__(IntSerialDenseVector self, int Index) -> int const &
        """
        return _Epetra.IntSerialDenseVector___call__(self, *args)


    def Random(self):
        """
        Random(IntSerialDenseVector self) -> int

        int
        Epetra_IntSerialDenseVector::Random()

        Set vector values to random numbers.

        IntSerialDenseVector uses the random number generator provided by
        Epetra_Util.     The vector values will be set to random values on the
        interval (0, 2^31 - 1).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.IntSerialDenseVector_Random(self)


    def Length(self):
        """
        Length(IntSerialDenseVector self) -> int

        int
        Epetra_IntSerialDenseVector::Length() const

        Returns length of vector. 
        """
        return _Epetra.IntSerialDenseVector_Length(self)


    def CV(self):
        """
        CV(IntSerialDenseVector self) -> Epetra_DataAccess

        Epetra_DataAccess Epetra_IntSerialDenseVector::CV() const

        Returns the data access mode of the this vector. 
        """
        return _Epetra.IntSerialDenseVector_CV(self)


    def __init__(self, *args):
        """
        __init__(Epetra_IntSerialDenseVector self) -> IntSerialDenseVector
        __init__(Epetra_IntSerialDenseVector self, int Length_in) -> IntSerialDenseVector
        __init__(Epetra_IntSerialDenseVector self, IntSerialDenseVector Source) -> IntSerialDenseVector
        __init__(Epetra_IntSerialDenseVector self, PyObject * array) -> IntSerialDenseVector

        Epetra_IntSerialDenseVector::Epetra_IntSerialDenseVector(const
        Epetra_IntSerialDenseVector &Source)

        Epetra_IntSerialDenseVector copy constructor. 
        """
        this = _Epetra.new_IntSerialDenseVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
IntSerialDenseVector_swigregister = _Epetra.IntSerialDenseVector_swigregister
IntSerialDenseVector_swigregister(IntSerialDenseVector)


def IntSerialDenseVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraIntSerialDenseVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of IntSerialDenseVector" % name)
def IntSerialDenseVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change IntSerialDenseVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change IntSerialDenseVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
IntSerialDenseVector.__getattr__ = IntSerialDenseVector_getattr
IntSerialDenseVector.__setattr__ = IntSerialDenseVector_setattr
IntSerialDenseVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
IntSerialDenseVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
IntSerialDenseVector.__len__     = lambda self: self.array.__len__()
IntSerialDenseVector.__str__     = lambda self: self.array.__str__()
IntSerialDenseVector.Values      = lambda self: self.array
class_array_add_math(IntSerialDenseVector)
class_array_add_comp(IntSerialDenseVector)


class SerialDenseOperator(_object):
    """


    Epetra_SerialDenseOperator: A pure virtual class for using real-valued
    double-precision operators.

    The Epetra_SerialDenseOperator class is a pure virtual class
    (specifies interface only) that enable the use of real-valued double-
    precision operators. It is currently implemented by the
    Epetra_SerialDenseMatrix, Epetra_SerialDenseSolver and
    Epetra_SerialDenseSVD classes.

    C++ includes: Epetra_SerialDenseOperator.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseOperator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseOperator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SerialDenseOperator

    def SetUseTranspose(self, UseTranspose):
        """
        SetUseTranspose(SerialDenseOperator self, bool UseTranspose) -> int

        virtual int Epetra_SerialDenseOperator::SetUseTranspose(bool
        UseTranspose)=0

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Epetra.SerialDenseOperator_SetUseTranspose(self, UseTranspose)


    def Apply(self, X, Y):
        """
        Apply(SerialDenseOperator self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int

        virtual int
        Epetra_SerialDenseOperator::Apply(const Epetra_SerialDenseMatrix &X,
        Epetra_SerialDenseMatrix &Y)=0

        Returns the result of a Epetra_SerialDenseOperator applied to a
        Epetra_SerialDenseMatrix X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_SerialDenseMatrix to multiply with operator.

        Out:  Y -A Epetra_SerialDenseMatrix containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseOperator_Apply(self, X, Y)


    def ApplyInverse(self, X, Y):
        """
        ApplyInverse(SerialDenseOperator self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int

        virtual int Epetra_SerialDenseOperator::ApplyInverse(const
        Epetra_SerialDenseMatrix &X, Epetra_SerialDenseMatrix &Y)=0

        Returns the result of a Epetra_SerialDenseOperator inverse applied to
        an Epetra_SerialDenseMatrix X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_SerialDenseMatrix to solve for.

        Out:  Y -A Epetra_SerialDenseMatrix containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseOperator_ApplyInverse(self, X, Y)


    def NormInf(self):
        """
        NormInf(SerialDenseOperator self) -> double

        virtual
        double Epetra_SerialDenseOperator::NormInf() const =0

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.SerialDenseOperator_NormInf(self)


    def Label(self):
        """
        Label(SerialDenseOperator self) -> char const *

        virtual
        const char* Epetra_SerialDenseOperator::Label() const =0

        Returns a character string describing the operator. 
        """
        return _Epetra.SerialDenseOperator_Label(self)


    def UseTranspose(self):
        """
        UseTranspose(SerialDenseOperator self) -> bool

        virtual bool Epetra_SerialDenseOperator::UseTranspose() const =0

        Returns the current UseTranspose setting. 
        """
        return _Epetra.SerialDenseOperator_UseTranspose(self)


    def HasNormInf(self):
        """
        HasNormInf(SerialDenseOperator self) -> bool

        virtual bool Epetra_SerialDenseOperator::HasNormInf() const =0

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Epetra.SerialDenseOperator_HasNormInf(self)


    def RowDim(self):
        """
        RowDim(SerialDenseOperator self) -> int

        virtual
        int Epetra_SerialDenseOperator::RowDim() const =0

        Returns the row dimension of operator. 
        """
        return _Epetra.SerialDenseOperator_RowDim(self)


    def ColDim(self):
        """
        ColDim(SerialDenseOperator self) -> int

        virtual
        int Epetra_SerialDenseOperator::ColDim() const =0

        Returns the column dimension of operator. 
        """
        return _Epetra.SerialDenseOperator_ColDim(self)

SerialDenseOperator_swigregister = _Epetra.SerialDenseOperator_swigregister
SerialDenseOperator_swigregister(SerialDenseOperator)


def _extractNumPyArrayFromEpetraSerialDenseMatrix(source):
    """_extractNumPyArrayFromEpetraSerialDenseMatrix(SerialDenseMatrix source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraSerialDenseMatrix(source)
class SerialDenseMatrix(CompObject, Object, SerialDenseOperator, BLAS):
    """


    Epetra_SerialDenseMatrix: A class for constructing and using real
    double precision general dense matrices.

    The Epetra_SerialDenseMatrix class enables the construction and use of
    real-valued, general, double-precision dense matrices. It is built on
    the BLAS, and derives from the Epetra_BLAS.

    The Epetra_SerialDenseMatrix class is intended to provide very basic
    support for dense rectangular matrices.

    Constructing Epetra_SerialDenseMatrix Objects

    There are four Epetra_SerialDenseMatrix constructors. The first
    constructs a zero-sized object which should be made to appropriate
    length using the Shape() or Reshape() functions and then filled with
    the [] or () operators. The second constructs an object sized to the
    dimensions specified, which should be filled with the [] or ()
    operators. The third is a constructor that accepts user data as a 2D
    array, and the fourth is a copy constructor. The third constructor has
    two data access modes (specified by the Epetra_DataAccess argument):
    Copy mode - Allocates memory and makes a copy of the user-provided
    data. In this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the object.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  Extracting Data from Epetra_SerialDenseMatrix
    Objects

    Once a Epetra_SerialDenseMatrix is constructed, it is possible to view
    the data via access functions.

    WARNING:  Use of these access functions cam be extremely dangerous
    from a data hiding perspective.  Vector and Utility Functions

    Once a Epetra_SerialDenseMatrix is constructed, several mathematical
    functions can be applied to the object. Specifically: Multiplication.

    Norms.

    Counting floating point operations The Epetra_SerialDenseMatrix class
    has Epetra_CompObject as a base class. Thus, floating point operations
    are counted and accumulated in the Epetra_Flop object (if any) that
    was set using the SetFlopCounter() method in the Epetra_CompObject
    base class.

    C++ includes: Epetra_SerialDenseMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [CompObject, Object, SerialDenseOperator, BLAS]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CompObject, Object, SerialDenseOperator, BLAS]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SerialDenseMatrix

    def Shape(self, NumRows, NumCols):
        """
        Shape(SerialDenseMatrix self, int NumRows, int NumCols) -> int

        int
        Epetra_SerialDenseMatrix::Shape(int NumRows, int NumCols)

        Set dimensions of a Epetra_SerialDenseMatrix object; init values to
        zero.

        Parameters:
        -----------

        In:  NumRows - Number of rows in object.

        In:  NumCols - Number of columns in object.

        Allows user to define the dimensions of a Epetra_SerialDenseMatrix at
        any point. This function can be called at any point after
        construction. Any values that were previously in this object are
        destroyed and the resized matrix starts off with all zero values.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.SerialDenseMatrix_Shape(self, NumRows, NumCols)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def Reshape(self, NumRows, NumCols):
        """
        Reshape(SerialDenseMatrix self, int NumRows, int NumCols) -> int

        int
        Epetra_SerialDenseMatrix::Reshape(int NumRows, int NumCols)

        Reshape a Epetra_SerialDenseMatrix object.

        Parameters:
        -----------

        In:  NumRows - Number of rows in object.

        In:  NumCols - Number of columns in object.

        Allows user to define the dimensions of a Epetra_SerialDenseMatrix at
        any point. This function can be called at any point after
        construction. Any values that were previously in this object are
        copied into the new shape. If the new shape is smaller than the
        original, the upper left portion of the original matrix (the principal
        submatrix) is copied to the new matrix.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.SerialDenseMatrix_Reshape(self, NumRows, NumCols)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def Multiply(self, *args):
        """
        Multiply(SerialDenseMatrix self, char TransA, char TransB, double ScalarAB, SerialDenseMatrix A, SerialDenseMatrix B, double ScalarThis) -> int
        Multiply(SerialDenseMatrix self, bool transA, SerialDenseMatrix x, SerialDenseMatrix y) -> int
        Multiply(SerialDenseMatrix self, char SideA, double ScalarAB, SerialSymDenseMatrix A, SerialDenseMatrix B, double ScalarThis) -> int

        int
        Epetra_SerialDenseMatrix::Multiply(char SideA, double ScalarAB, const
        Epetra_SerialSymDenseMatrix &A, const Epetra_SerialDenseMatrix &B,
        double ScalarThis)

        Matrix-Matrix multiplication with a symmetric matrix A.

        If SideA = 'L', compute this = ScalarThis* this + ScalarAB*A*B. If
        SideA = 'R', compute this = ScalarThis* this + ScalarAB*B*A.

        This function performs a variety of matrix-matrix multiply operations.

        Parameters:
        -----------

        In:  SideA - Specifies order of A relative to B.

        In:  ScalarAB - Scalar to multiply with A*B.

        In:  A - Symmetric Dense Matrix, either upper or lower triangle will
        be used depending on value of A.Upper().

        In:  B - Dense Matrix.

        In:  ScalarThis - Scalar to multiply with this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_Multiply(self, *args)


    def Scale(self, ScalarA):
        """
        Scale(SerialDenseMatrix self, double ScalarA) -> int

        int
        Epetra_SerialDenseMatrix::Scale(double ScalarA)

        Inplace scalar-matrix product A = a A.

        Scale a matrix, entry-by-entry using the value ScalarA.

        Parameters:
        -----------

        ScalarA:  (In) Scalar to multiply with A.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_Scale(self, ScalarA)


    def NormOne(self):
        """
        NormOne(SerialDenseMatrix self) -> double

        double
        Epetra_SerialDenseMatrix::NormOne() const

        Computes the 1-Norm of the this matrix.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_NormOne(self)


    def NormInf(self):
        """
        NormInf(SerialDenseMatrix self) -> double

        double
        Epetra_SerialDenseMatrix::NormInf() const

        Computes the Infinity-Norm of the this matrix. 
        """
        return _Epetra.SerialDenseMatrix_NormInf(self)


    def __eq__(self, rhs):
        """__eq__(SerialDenseMatrix self, SerialDenseMatrix rhs) -> bool"""
        return _Epetra.SerialDenseMatrix___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SerialDenseMatrix self, SerialDenseMatrix rhs) -> bool"""
        return _Epetra.SerialDenseMatrix___ne__(self, rhs)


    def __iadd__(self, Source):
        """__iadd__(SerialDenseMatrix self, SerialDenseMatrix Source) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseMatrix___iadd__(self, Source)


    def __call__(self, RowIndex, ColIndex):
        """__call__(SerialDenseMatrix self, int RowIndex, int ColIndex) -> double const &"""
        return _Epetra.SerialDenseMatrix___call__(self, RowIndex, ColIndex)


    def Random(self):
        """
        Random(SerialDenseMatrix self) -> int

        int
        Epetra_SerialDenseMatrix::Random()

        Set matrix values to random numbers.

        SerialDenseMatrix uses the random number generator provided by
        Epetra_Util. The matrix values will be set to random values on the
        interval (-1.0, 1.0).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_Random(self)


    def M(self):
        """
        M(SerialDenseMatrix self) -> int

        int
        Epetra_SerialDenseMatrix::M() const

        Returns row dimension of system. 
        """
        return _Epetra.SerialDenseMatrix_M(self)


    def N(self):
        """
        N(SerialDenseMatrix self) -> int

        int
        Epetra_SerialDenseMatrix::N() const

        Returns column dimension of system. 
        """
        return _Epetra.SerialDenseMatrix_N(self)


    def A(self):
        """
        A(SerialDenseMatrix self) -> double *

        double*
        Epetra_SerialDenseMatrix::A()

        Returns pointer to the this matrix. 
        """
        return _Epetra.SerialDenseMatrix_A(self)


    def LDA(self):
        """
        LDA(SerialDenseMatrix self) -> int

        int
        Epetra_SerialDenseMatrix::LDA() const

        Returns the leading dimension of the this matrix. 
        """
        return _Epetra.SerialDenseMatrix_LDA(self)


    def CV(self):
        """
        CV(SerialDenseMatrix self) -> Epetra_DataAccess

        Epetra_DataAccess Epetra_SerialDenseMatrix::CV() const

        Returns the data access mode of the this matrix. 
        """
        return _Epetra.SerialDenseMatrix_CV(self)


    def OneNorm(self):
        """
        OneNorm(SerialDenseMatrix self) -> double

        virtual
        double Epetra_SerialDenseMatrix::OneNorm() const

        Computes the 1-Norm of the this matrix (identical to NormOne()
        method).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_OneNorm(self)


    def InfNorm(self):
        """
        InfNorm(SerialDenseMatrix self) -> double

        virtual
        double Epetra_SerialDenseMatrix::InfNorm() const

        Computes the Infinity-Norm of the this matrix (identical to NormInf()
        method). 
        """
        return _Epetra.SerialDenseMatrix_InfNorm(self)


    def SetUseTranspose(self, UseTranspose_in):
        """
        SetUseTranspose(SerialDenseMatrix self, bool UseTranspose_in) -> int

        virtual int Epetra_SerialDenseMatrix::SetUseTranspose(bool
        UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Epetra.SerialDenseMatrix_SetUseTranspose(self, UseTranspose_in)


    def Apply(self, X, Y):
        """
        Apply(SerialDenseMatrix self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int

        int
        Epetra_SerialDenseMatrix::Apply(const Epetra_SerialDenseMatrix &X,
        Epetra_SerialDenseMatrix &Y)

        Returns the result of a Epetra_SerialDenseOperator applied to a
        Epetra_SerialDenseMatrix X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_SerialDenseMatrix to multiply with operator.

        Out:  Y -A Epetra_SerialDenseMatrix containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_Apply(self, X, Y)


    def ApplyInverse(self, X, Y):
        """
        ApplyInverse(SerialDenseMatrix self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int

        virtual int Epetra_SerialDenseMatrix::ApplyInverse(const
        Epetra_SerialDenseMatrix &X, Epetra_SerialDenseMatrix &Y)

        Returns the result of a Epetra_SerialDenseOperator inverse applied to
        an Epetra_SerialDenseMatrix X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_SerialDenseMatrix to solve for.

        Out:  Y -A Epetra_SerialDenseMatrix containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseMatrix_ApplyInverse(self, X, Y)


    def Label(self):
        """
        Label(SerialDenseMatrix self) -> char const *

        virtual const
        char* Epetra_SerialDenseMatrix::Label() const

        Returns a character string describing the operator. 
        """
        return _Epetra.SerialDenseMatrix_Label(self)


    def UseTranspose(self):
        """
        UseTranspose(SerialDenseMatrix self) -> bool

        virtual bool Epetra_SerialDenseMatrix::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Epetra.SerialDenseMatrix_UseTranspose(self)


    def HasNormInf(self):
        """
        HasNormInf(SerialDenseMatrix self) -> bool

        virtual
        bool Epetra_SerialDenseMatrix::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Epetra.SerialDenseMatrix_HasNormInf(self)


    def RowDim(self):
        """
        RowDim(SerialDenseMatrix self) -> int

        virtual int
        Epetra_SerialDenseMatrix::RowDim() const

        Returns the row dimension of operator. 
        """
        return _Epetra.SerialDenseMatrix_RowDim(self)


    def ColDim(self):
        """
        ColDim(SerialDenseMatrix self) -> int

        virtual int
        Epetra_SerialDenseMatrix::ColDim() const

        Returns the column dimension of operator. 
        """
        return _Epetra.SerialDenseMatrix_ColDim(self)


    def __init__(self, *args):
        """
        __init__(Epetra_SerialDenseMatrix self, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, int NumRows, int NumCols, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, int NumRows, int NumCols) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, Epetra_DataAccess CV, double * A_in, int LDA_in, int NumRows, int NumCols, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, Epetra_DataAccess CV, double * A_in, int LDA_in, int NumRows, int NumCols) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, SerialDenseMatrix Source) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, PyObject * array, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, PyObject * array) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix::Epetra_SerialDenseMatrix(const
        Epetra_SerialDenseMatrix &Source)

        Epetra_SerialDenseMatrix copy constructor. 
        """
        this = _Epetra.new_SerialDenseMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SerialDenseMatrix_swigregister = _Epetra.SerialDenseMatrix_swigregister
SerialDenseMatrix_swigregister(SerialDenseMatrix)


def SerialDenseMatrix_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraSerialDenseMatrix(self)
#a = a.transpose()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of SerialDenseMatrix" % name)
def SerialDenseMatrix_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change SerialDenseMatrix 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change SerialDenseMatrix 'dtype' attribute")
    else:
        self.__dict__[name] = value
SerialDenseMatrix.__getattr__ = SerialDenseMatrix_getattr
SerialDenseMatrix.__setattr__ = SerialDenseMatrix_setattr
SerialDenseMatrix.__getitem__ = lambda self, i: self.array.__getitem__(i)
SerialDenseMatrix.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
SerialDenseMatrix.__len__     = lambda self: self.array.__len__()
SerialDenseMatrix.__str__     = lambda self: self.array.__str__()
SerialDenseMatrix.A           = lambda self: self.array
class_array_add_math(SerialDenseMatrix)
class_array_add_comp(SerialDenseMatrix)


class SerialSymDenseMatrix(SerialDenseMatrix):
    """


    Epetra_SerialSymDenseMatrix: A class for constructing and using
    symmetric positive definite dense matrices.

    The Epetra_SerialSymDenseMatrix class enables the construction and use
    of real-valued, symmetric positive definite, double-precision dense
    matrices. It is built on the Epetra_SerialDenseMatrix class which in
    turn is built on the BLAS via the Epetra_BLAS class.

    The Epetra_SerialSymDenseMatrix class is intended to provide full-
    featured support for solving linear and eigen system problems for
    symmetric positive definite matrices. It is written on top of BLAS and
    LAPACK and thus has excellent performance and numerical capabilities.
    Using this class, one can either perform simple factorizations and
    solves or apply all the tricks available in LAPACK to get the best
    possible solution for very ill-conditioned problems.

    Epetra_SerialSymDenseMatrix vs. Epetra_LAPACK

    The Epetra_LAPACK class provides access to most of the same
    functionality as Epetra_SerialSymDenseMatrix. The primary difference
    is that Epetra_LAPACK is a "thin" layer on top of LAPACK and
    Epetra_SerialSymDenseMatrix attempts to provide easy access to the
    more sophisticated aspects of solving dense linear and eigensystems.
    When you should use Epetra_LAPACK: If you are simply looking for a
    convenient wrapper around the Fortran LAPACK routines and you have a
    well-conditioned problem, you should probably use Epetra_LAPACK
    directly.

    When you should use Epetra_SerialSymDenseMatrix: If you want to (or
    potentially want to) solve ill-conditioned problems or want to work
    with a more object-oriented interface, you should probably use
    Epetra_SerialSymDenseMatrix.

    Constructing Epetra_SerialSymDenseMatrix Objects

    There are three Epetra_DenseMatrix constructors. The first constructs
    a zero-sized object which should be made to appropriate length using
    the Shape() or Reshape() functions and then filled with the [] or ()
    operators. The second is a constructor that accepts user data as a 2D
    array, the third is a copy constructor. The second constructor has two
    data access modes (specified by the Epetra_DataAccess argument): Copy
    mode - Allocates memory and makes a copy of the user-provided data. In
    this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the object.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  Extracting Data from Epetra_SerialSymDenseMatrix
    Objects

    Once a Epetra_SerialSymDenseMatrix is constructed, it is possible to
    view the data via access functions.

    WARNING:  Use of these access functions cam be extremely dangerous
    from a data hiding perspective.  Vector and Utility Functions

    Once a Epetra_SerialSymDenseMatrix is constructed, several
    mathematical functions can be applied to the object. Specifically:
    Multiplication.

    Norms.

    Counting floating point operations The Epetra_SerialSymDenseMatrix
    class has Epetra_CompObject as a base class. Thus, floating point
    operations are counted and accumulated in the Epetra_Flop object (if
    any) that was set using the SetFlopCounter() method in the
    Epetra_CompObject base class.

    C++ includes: Epetra_SerialSymDenseMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialSymDenseMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialSymDenseMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_SerialSymDenseMatrix self) -> SerialSymDenseMatrix
        __init__(Epetra_SerialSymDenseMatrix self, Epetra_DataAccess CV, double * A, int LDA, int NumRowsCols) -> SerialSymDenseMatrix
        __init__(Epetra_SerialSymDenseMatrix self, SerialSymDenseMatrix Source) -> SerialSymDenseMatrix

        Epetra_SerialSymDenseMatrix::Epetra_SerialSymDenseMatrix(const
        Epetra_SerialSymDenseMatrix &Source)

        Epetra_SerialSymDenseMatrix copy constructor. 
        """
        this = _Epetra.new_SerialSymDenseMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_SerialSymDenseMatrix

    def Shape(self, *args):
        """
        Shape(SerialSymDenseMatrix self, int NumRows, int NumCols) -> int
        Shape(SerialSymDenseMatrix self, int NumRowsCols) -> int

        int
        Epetra_SerialDenseMatrix::Shape(int NumRows, int NumCols)

        Set dimensions of a Epetra_SerialDenseMatrix object; init values to
        zero.

        Parameters:
        -----------

        In:  NumRows - Number of rows in object.

        In:  NumCols - Number of columns in object.

        Allows user to define the dimensions of a Epetra_SerialDenseMatrix at
        any point. This function can be called at any point after
        construction. Any values that were previously in this object are
        destroyed and the resized matrix starts off with all zero values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialSymDenseMatrix_Shape(self, *args)


    def Reshape(self, *args):
        """
        Reshape(SerialSymDenseMatrix self, int NumRows, int NumCols) -> int
        Reshape(SerialSymDenseMatrix self, int NumRowsCols) -> int

        int
        Epetra_SerialDenseMatrix::Reshape(int NumRows, int NumCols)

        Reshape a Epetra_SerialDenseMatrix object.

        Parameters:
        -----------

        In:  NumRows - Number of rows in object.

        In:  NumCols - Number of columns in object.

        Allows user to define the dimensions of a Epetra_SerialDenseMatrix at
        any point. This function can be called at any point after
        construction. Any values that were previously in this object are
        copied into the new shape. If the new shape is smaller than the
        original, the upper left portion of the original matrix (the principal
        submatrix) is copied to the new matrix.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialSymDenseMatrix_Reshape(self, *args)


    def SetLower(self):
        """
        SetLower(SerialSymDenseMatrix self)

        void
        Epetra_SerialSymDenseMatrix::SetLower()

        Specify that the lower triangle of the this matrix should be used. 
        """
        return _Epetra.SerialSymDenseMatrix_SetLower(self)


    def SetUpper(self):
        """
        SetUpper(SerialSymDenseMatrix self)

        void
        Epetra_SerialSymDenseMatrix::SetUpper()

        Specify that the upper triangle of the this matrix should be used. 
        """
        return _Epetra.SerialSymDenseMatrix_SetUpper(self)


    def Upper(self):
        """
        Upper(SerialSymDenseMatrix self) -> bool

        bool
        Epetra_SerialSymDenseMatrix::Upper() const

        Returns true if upper triangle of this matrix has and will be used. 
        """
        return _Epetra.SerialSymDenseMatrix_Upper(self)


    def UPLO(self):
        """
        UPLO(SerialSymDenseMatrix self) -> char

        char
        Epetra_SerialSymDenseMatrix::UPLO() const

        Returns character value of UPLO used by LAPACK routines. 
        """
        return _Epetra.SerialSymDenseMatrix_UPLO(self)


    def Scale(self, ScalarA):
        """
        Scale(SerialSymDenseMatrix self, double ScalarA) -> int

        int
        Epetra_SerialSymDenseMatrix::Scale(double ScalarA)

        Inplace scalar-matrix product A = a A.

        Scale a matrix, entry-by-entry using the value ScalarA. This method is
        sensitive to the UPLO() parameter.

        Parameters:
        -----------

        ScalarA:  (In) Scalar to multiply with A.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialSymDenseMatrix_Scale(self, ScalarA)


    def NormOne(self):
        """
        NormOne(SerialSymDenseMatrix self) -> double

        double
        Epetra_SerialSymDenseMatrix::NormOne() const

        Computes the 1-Norm of the this matrix.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialSymDenseMatrix_NormOne(self)


    def NormInf(self):
        """
        NormInf(SerialSymDenseMatrix self) -> double

        double
        Epetra_SerialSymDenseMatrix::NormInf() const

        Computes the Infinity-Norm of the this matrix. 
        """
        return _Epetra.SerialSymDenseMatrix_NormInf(self)


    def CopyUPLOMat(self, Upper, A, LDA, NumRows):
        """
        CopyUPLOMat(SerialSymDenseMatrix self, bool Upper, double * A, int LDA, int NumRows)

        void
        Epetra_SerialSymDenseMatrix::CopyUPLOMat(bool Upper, double *A, int
        LDA, int NumRows) 
        """
        return _Epetra.SerialSymDenseMatrix_CopyUPLOMat(self, Upper, A, LDA, NumRows)


    def OneNorm(self):
        """
        OneNorm(SerialSymDenseMatrix self) -> double

        double
        Epetra_SerialSymDenseMatrix::OneNorm() const

        Computes the 1-Norm of the this matrix (identical to NormOne()
        method).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialSymDenseMatrix_OneNorm(self)


    def InfNorm(self):
        """
        InfNorm(SerialSymDenseMatrix self) -> double

        double
        Epetra_SerialSymDenseMatrix::InfNorm() const

        Computes the Infinity-Norm of the this matrix (identical to NormInf()
        method). 
        """
        return _Epetra.SerialSymDenseMatrix_InfNorm(self)

SerialSymDenseMatrix_swigregister = _Epetra.SerialSymDenseMatrix_swigregister
SerialSymDenseMatrix_swigregister(SerialSymDenseMatrix)


def _extractNumPyArrayFromEpetraSerialDenseVector(source):
    """_extractNumPyArrayFromEpetraSerialDenseVector(SerialDenseVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraSerialDenseVector(source)
class SerialDenseVector(SerialDenseMatrix):
    """


    Epetra_SerialDenseVector: A class for constructing and using dense
    vectors.

    The Epetra_SerialDenseVector class enables the construction and use of
    real-valued, double- precision dense vectors. It is built on the BLAS
    and LAPACK and derives from the Epetra_SerialDenseMatrix class.

    The Epetra_SerialDenseVector class is intended to provide convenient
    vector notation but derives all signficant functionality from
    Epetra_SerialDenseMatrix.

    Constructing Epetra_SerialDenseVector Objects

    There are four Epetra_SerialDenseVector constructors. The first
    constructs a zero-length object which should be made to appropriate
    length using the Size() or Resize() functions and then filled with the
    [] or () operators. The second constructs an object sized to the
    dimension specified, which should be filled with the [] or ()
    operators. The third is a constructor that accepts user data as a 1D
    array, and the fourth is a copy constructor. The third constructor has
    two data access modes (specified by the Epetra_DataAccess argument):
    Copy mode - Allocates memory and makes a copy of the user-provided
    data. In this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the object.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  Extracting Data from Epetra_SerialDenseVector
    Objects

    Once a Epetra_SerialDenseVector is constructed, it is possible to view
    the data via access functions.

    WARNING:  Use of these access functions cam be extremely dangerous
    from a data hiding perspective.  The final useful function is Flops().
    Each Epetra_SerialDenseVector object keep track of the number of
    serial floating point operations performed using the specified object
    as the this argument to the function. The Flops() function returns
    this number as a double precision number. Using this information, in
    conjunction with the Epetra_Time class, one can get accurate parallel
    performance numbers.

    C++ includes: Epetra_SerialDenseVector.h 
    """

    __swig_setmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseVector, name, value)
    __swig_getmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SerialDenseVector

    def Size(self, Length_in):
        """
        Size(SerialDenseVector self, int Length_in) -> int

        int
        Epetra_SerialDenseVector::Size(int Length_in)

        Set length of a Epetra_SerialDenseVector object; init values to zero.

        Parameters:
        -----------

        In:  Length - Length of vector object.

        Allows user to define the dimension of a Epetra_SerialDenseVector.
        This function can be called at any point after construction. Any
        values that were previously in this object are destroyed and the
        resized vector starts off with all zero values.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.SerialDenseVector_Size(self, Length_in)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def Resize(self, Length_in):
        """
        Resize(SerialDenseVector self, int Length_in) -> int

        int
        Epetra_SerialDenseVector::Resize(int Length_in)

        Resize a Epetra_SerialDenseVector object.

        Parameters:
        -----------

        In:  Length - Length of vector object.

        Allows user to define the dimension of a Epetra_SerialDenseVector.
        This function can be called at any point after construction. Any
        values that were previously in this object are copied into the new
        size. If the new shape is smaller than the original, the first Length
        values are copied to the new vector.

        Integer error code, set to 0 if successful. 
        """
        val = _Epetra.SerialDenseVector_Resize(self, Length_in)

        if "array" in self.__dict__: del self.__dict__["array"]


        return val


    def __call__(self, *args):
        """
        __call__(SerialDenseVector self, int RowIndex, int ColIndex) -> double const
        __call__(SerialDenseVector self, int Index) -> double const &
        """
        return _Epetra.SerialDenseVector___call__(self, *args)


    def Random(self):
        """
        Random(SerialDenseVector self) -> int

        int
        Epetra_SerialDenseVector::Random()

        Set vector values to random numbers.

        SerialDenseVector uses the random number generator provided by
        Epetra_Util.     The vector values will be set to random values on the
        interval (-1.0, 1.0).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseVector_Random(self)


    def Dot(self, x):
        """
        Dot(SerialDenseVector self, SerialDenseVector x) -> double

        double
        Epetra_SerialDenseVector::Dot(const Epetra_SerialDenseVector &x) const

        Compute 1-norm of each vector in multi-vector.

        Parameters:
        -----------

        x:  (In) Input vector x.

        Dot-product of the this vector and x. 
        """
        return _Epetra.SerialDenseVector_Dot(self, x)


    def Norm1(self):
        """
        Norm1(SerialDenseVector self) -> double

        double
        Epetra_SerialDenseVector::Norm1() const

        Compute 1-norm of each vector in multi-vector.

        1-norm of the vector. 
        """
        return _Epetra.SerialDenseVector_Norm1(self)


    def Norm2(self):
        """
        Norm2(SerialDenseVector self) -> double

        double
        Epetra_SerialDenseVector::Norm2() const

        Compute 2-norm of each vector in multi-vector.

        Parameters:
        -----------

        Out:

        2-norm of the vector. 
        """
        return _Epetra.SerialDenseVector_Norm2(self)


    def NormInf(self):
        """
        NormInf(SerialDenseVector self) -> double

        double
        Epetra_SerialDenseVector::NormInf() const

        Compute Inf-norm of each vector in multi-vector.

        Infinity-norm of the vector. 
        """
        return _Epetra.SerialDenseVector_NormInf(self)


    def Length(self):
        """
        Length(SerialDenseVector self) -> int

        int
        Epetra_SerialDenseVector::Length() const

        Returns length of vector. 
        """
        return _Epetra.SerialDenseVector_Length(self)


    def Values(self):
        """
        Values(SerialDenseVector self) -> double *

        double*
        Epetra_SerialDenseVector::Values() const

        Returns pointer to the values in vector. 
        """
        return _Epetra.SerialDenseVector_Values(self)


    def CV(self):
        """
        CV(SerialDenseVector self) -> Epetra_DataAccess

        Epetra_DataAccess Epetra_SerialDenseVector::CV() const

        Returns the data access mode of the this vector. 
        """
        return _Epetra.SerialDenseVector_CV(self)


    def __init__(self, *args):
        """
        __init__(Epetra_SerialDenseVector self) -> SerialDenseVector
        __init__(Epetra_SerialDenseVector self, int Length) -> SerialDenseVector
        __init__(Epetra_SerialDenseVector self, SerialDenseVector Source) -> SerialDenseVector
        __init__(Epetra_SerialDenseVector self, PyObject * array) -> SerialDenseVector

        Epetra_SerialDenseVector::Epetra_SerialDenseVector(const
        Epetra_SerialDenseVector &Source)

        Epetra_SerialDenseVector copy constructor. 
        """
        this = _Epetra.new_SerialDenseVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SerialDenseVector_swigregister = _Epetra.SerialDenseVector_swigregister
SerialDenseVector_swigregister(SerialDenseVector)


def SerialDenseVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraSerialDenseVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of SerialDenseVector" % name)
def SerialDenseVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change SerialDenseVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change SerialDenseVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
SerialDenseVector.__getattr__ = SerialDenseVector_getattr
SerialDenseVector.__setattr__ = SerialDenseVector_setattr
SerialDenseVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
SerialDenseVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
SerialDenseVector.__len__     = lambda self: self.array.__len__()
SerialDenseVector.__str__     = lambda self: self.array.__str__()
SerialDenseVector.Values      = lambda self: self.array
class_array_add_math(SerialDenseVector)
class_array_add_comp(SerialDenseVector)


class SerialDenseSolver(CompObject, BLAS, LAPACK, Object):
    """


    Epetra_SerialDenseSolver: A class for solving dense linear problems.

    The Epetra_SerialDenseSolver class enables the definition, in terms of
    Epetra_SerialDenseMatrix and Epetra_SerialDenseVector objects, of a
    dense linear problem, followed by the solution of that problem via the
    most sophisticated techniques available in LAPACK.

    The Epetra_SerialDenseSolver class is intended to provide full-
    featured support for solving linear problems for general dense
    rectangular (or square) matrices. It is written on top of BLAS and
    LAPACK and thus has excellent performance and numerical capabilities.
    Using this class, one can either perform simple factorizations and
    solves or apply all the tricks available in LAPACK to get the best
    possible solution for very ill-conditioned problems.

    Epetra_SerialDenseSolver vs. Epetra_LAPACK

    The Epetra_LAPACK class provides access to most of the same
    functionality as Epetra_SerialDenseSolver. The primary difference is
    that Epetra_LAPACK is a "thin" layer on top of LAPACK and
    Epetra_SerialDenseSolver attempts to provide easy access to the more
    sophisticated aspects of solving dense linear and eigensystems. When
    you should use Epetra_LAPACK: If you are simply looking for a
    convenient wrapper around the Fortran LAPACK routines and you have a
    well-conditioned problem, you should probably use Epetra_LAPACK
    directly.

    When you should use Epetra_SerialDenseSolver: If you want to (or
    potentially want to) solve ill-conditioned problems or want to work
    with a more object-oriented interface, you should probably use
    Epetra_SerialDenseSolver.

    Constructing Epetra_SerialDenseSolver Objects

    There is a single Epetra_SerialDenseSolver constructor. However, the
    matrix, right hand side and solution vectors must be set prior to
    executing most methods in this class.

    Setting vectors used for linear solves

    The matrix A, the left hand side X and the right hand side B (when
    solving AX = B, for X), can be set by appropriate set methods. Each of
    these three objects must be an Epetra_SerialDenseMatrix or and
    Epetra_SerialDenseVector object. The set methods are as follows:
    SetMatrix() - Sets the matrix.

    SetVectors() - Sets the left and right hand side vector(s).

    Vector and Utility Functions

    Once a Epetra_SerialDenseSolver is constructed, several mathematical
    functions can be applied to the object. Specifically: Factorizations.

    Solves.

    Condition estimates.

    Equilibration.

    Norms.

    Counting floating point operations The Epetra_SerialDenseSolver class
    has Epetra_CompObject as a base class. Thus, floating point operations
    are counted and accumulated in the Epetra_Flop object (if any) that
    was set using the SetFlopCounter() method in the Epetra_CompObject
    base class.

    Strategies for Solving Linear Systems In many cases, linear systems
    can be accurately solved by simply computing the LU factorization of
    the matrix and then performing a forward back solve with a given set
    of right hand side vectors. However, in some instances, the
    factorization may be very poorly conditioned and this simple approach
    may not work. In these situations, equilibration and iterative
    refinement may improve the accuracy, or prevent a breakdown in the
    factorization.

    Epetra_SerialDenseSolver will use equilibration with the factorization
    if, once the object is constructed and before it is factored, you call
    the function FactorWithEquilibration(true) to force equilibration to
    be used. If you are uncertain if equilibration should be used, you may
    call the function ShouldEquilibrate() which will return true if
    equilibration could possibly help. ShouldEquilibrate() uses guidelines
    specified in the LAPACK User Guide, namely if SCOND < 0.1 and AMAX <
    Underflow or AMAX > Overflow, to determine if equilibration might be
    useful.

    Epetra_SerialDenseSolver will use iterative refinement after a
    forward/back solve if you call SolveToRefinedSolution(true). It will
    also compute forward and backward error estimates if you call
    EstimateSolutionErrors(true). Access to the forward (back) error
    estimates is available via FERR() ( BERR()).

    Examples using Epetra_SerialDenseSolver can be found in the Epetra
    test directories.

    C++ includes: Epetra_SerialDenseSolver.h 
    """

    __swig_setmethods__ = {}
    for _s in [CompObject, BLAS, LAPACK, Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseSolver, name, value)
    __swig_getmethods__ = {}
    for _s in [CompObject, BLAS, LAPACK, Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseSolver, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
        __init__(Epetra_SerialDenseSolver self) -> SerialDenseSolver

        Epetra_SerialDenseSolver::Epetra_SerialDenseSolver()

        Default constructor; matrix should be set using SetMatrix(), LHS and
        RHS set with SetVectors(). 
        """
        this = _Epetra.new_SerialDenseSolver()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_SerialDenseSolver

    def SetMatrix(self, A):
        """
        SetMatrix(SerialDenseSolver self, SerialDenseMatrix A) -> int

        int
        Epetra_SerialDenseSolver::SetMatrix(Epetra_SerialDenseMatrix &A)

        Sets the pointers for coefficient matrix. 
        """
        return _Epetra.SerialDenseSolver_SetMatrix(self, A)


    def SetVectors(self, X, B):
        """
        SetVectors(SerialDenseSolver self, SerialDenseMatrix X, SerialDenseMatrix B) -> int

        int
        Epetra_SerialDenseSolver::SetVectors(Epetra_SerialDenseMatrix &X,
        Epetra_SerialDenseMatrix &B)

        Sets the pointers for left and right hand side vector(s).

        Row dimension of X must match column dimension of matrix A, row
        dimension of B must match row dimension of A. X and B must have the
        same dimensions. 
        """
        return _Epetra.SerialDenseSolver_SetVectors(self, X, B)


    def FactorWithEquilibration(self, Flag):
        """
        FactorWithEquilibration(SerialDenseSolver self, bool Flag)

        void
        Epetra_SerialDenseSolver::FactorWithEquilibration(bool Flag)

        Causes equilibration to be called just before the matrix factorization
        as part of the call to Factor.

        This function must be called before the factorization is performed. 
        """
        return _Epetra.SerialDenseSolver_FactorWithEquilibration(self, Flag)


    def SolveWithTranspose(self, Flag):
        """
        SolveWithTranspose(SerialDenseSolver self, bool Flag)

        void Epetra_SerialDenseSolver::SolveWithTranspose(bool Flag)

        If Flag is true, causes all subsequent function calls to work with the
        transpose of this matrix, otherwise not. 
        """
        return _Epetra.SerialDenseSolver_SolveWithTranspose(self, Flag)


    def SolveToRefinedSolution(self, Flag):
        """
        SolveToRefinedSolution(SerialDenseSolver self, bool Flag)

        void
        Epetra_SerialDenseSolver::SolveToRefinedSolution(bool Flag)

        Causes all solves to compute solution to best ability using iterative
        refinement. 
        """
        return _Epetra.SerialDenseSolver_SolveToRefinedSolution(self, Flag)


    def EstimateSolutionErrors(self, Flag):
        """
        EstimateSolutionErrors(SerialDenseSolver self, bool Flag)

        void
        Epetra_SerialDenseSolver::EstimateSolutionErrors(bool Flag)

        Causes all solves to estimate the forward and backward solution error.

        Error estimates will be in the arrays FERR and BERR, resp, after the
        solve step is complete. These arrays are accessible via the FERR() and
        BERR() access functions. 
        """
        return _Epetra.SerialDenseSolver_EstimateSolutionErrors(self, Flag)


    def Factor(self):
        """
        Factor(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::Factor(void)

        Computes the in-place LU factorization of the matrix using the LAPACK
        routine DGETRF.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseSolver_Factor(self)


    def Solve(self):
        """
        Solve(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::Solve(void)

        Computes the solution X to AX = B for the this matrix and the B
        provided to SetVectors()..

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseSolver_Solve(self)


    def Invert(self):
        """
        Invert(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::Invert(void)

        Inverts the this matrix.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_Invert(self)


    def ComputeEquilibrateScaling(self):
        """
        ComputeEquilibrateScaling(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::ComputeEquilibrateScaling(void)

        Computes the scaling vector S(i) = 1/sqrt(A(i,i)) of the this matrix.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_ComputeEquilibrateScaling(self)


    def EquilibrateMatrix(self):
        """
        EquilibrateMatrix(SerialDenseSolver self) -> int

        int Epetra_SerialDenseSolver::EquilibrateMatrix(void)

        Equilibrates the this matrix.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_EquilibrateMatrix(self)


    def EquilibrateRHS(self):
        """
        EquilibrateRHS(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::EquilibrateRHS(void)

        Equilibrates the current RHS.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_EquilibrateRHS(self)


    def ApplyRefinement(self):
        """
        ApplyRefinement(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::ApplyRefinement(void)

        Apply Iterative Refinement.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_ApplyRefinement(self)


    def UnequilibrateLHS(self):
        """
        UnequilibrateLHS(SerialDenseSolver self) -> int

        int Epetra_SerialDenseSolver::UnequilibrateLHS(void)

        Unscales the solution vectors if equilibration was used to solve the
        system.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_UnequilibrateLHS(self)


    def Transpose(self):
        """
        Transpose(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::Transpose()

        Returns true if transpose of this matrix has and will be used. 
        """
        return _Epetra.SerialDenseSolver_Transpose(self)


    def Factored(self):
        """
        Factored(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::Factored()

        Returns true if matrix is factored (factor available via AF() and
        LDAF()). 
        """
        return _Epetra.SerialDenseSolver_Factored(self)


    def A_Equilibrated(self):
        """
        A_Equilibrated(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::A_Equilibrated()

        Returns true if factor is equilibrated (factor available via AF() and
        LDAF()). 
        """
        return _Epetra.SerialDenseSolver_A_Equilibrated(self)


    def B_Equilibrated(self):
        """
        B_Equilibrated(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::B_Equilibrated()

        Returns true if RHS is equilibrated (RHS available via B() and LDB()).

        """
        return _Epetra.SerialDenseSolver_B_Equilibrated(self)


    def ShouldEquilibrate(self):
        """
        ShouldEquilibrate(SerialDenseSolver self) -> bool

        virtual bool Epetra_SerialDenseSolver::ShouldEquilibrate()

        Returns true if the LAPACK general rules for equilibration suggest you
        should equilibrate the system. 
        """
        return _Epetra.SerialDenseSolver_ShouldEquilibrate(self)


    def SolutionErrorsEstimated(self):
        """
        SolutionErrorsEstimated(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::SolutionErrorsEstimated()

        Returns true if forward and backward error estimated have been
        computed (available via FERR() and BERR()). 
        """
        return _Epetra.SerialDenseSolver_SolutionErrorsEstimated(self)


    def Inverted(self):
        """
        Inverted(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::Inverted()

        Returns true if matrix inverse has been computed (inverse available
        via AF() and LDAF()). 
        """
        return _Epetra.SerialDenseSolver_Inverted(self)


    def ReciprocalConditionEstimated(self):
        """
        ReciprocalConditionEstimated(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::ReciprocalConditionEstimated()

        Returns true if the condition number of the this matrix has been
        computed (value available via ReciprocalConditionEstimate()). 
        """
        return _Epetra.SerialDenseSolver_ReciprocalConditionEstimated(self)


    def Solved(self):
        """
        Solved(SerialDenseSolver self) -> bool

        bool
        Epetra_SerialDenseSolver::Solved()

        Returns true if the current set of vectors has been solved. 
        """
        return _Epetra.SerialDenseSolver_Solved(self)


    def SolutionRefined(self):
        """
        SolutionRefined(SerialDenseSolver self) -> bool

        bool Epetra_SerialDenseSolver::SolutionRefined()

        Returns true if the current set of vectors has been refined. 
        """
        return _Epetra.SerialDenseSolver_SolutionRefined(self)


    def Matrix(self):
        """
        Matrix(SerialDenseSolver self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSolver::Matrix() const

        Returns pointer to current matrix. 
        """
        return _Epetra.SerialDenseSolver_Matrix(self)


    def FactoredMatrix(self):
        """
        FactoredMatrix(SerialDenseSolver self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSolver::FactoredMatrix()
        const

        Returns pointer to factored matrix (assuming factorization has been
        performed). 
        """
        return _Epetra.SerialDenseSolver_FactoredMatrix(self)


    def LHS(self):
        """
        LHS(SerialDenseSolver self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSolver::LHS() const

        Returns pointer to current LHS. 
        """
        return _Epetra.SerialDenseSolver_LHS(self)


    def RHS(self):
        """
        RHS(SerialDenseSolver self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSolver::RHS() const

        Returns pointer to current RHS. 
        """
        return _Epetra.SerialDenseSolver_RHS(self)


    def M(self):
        """
        M(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::M() const

        Returns row dimension of system. 
        """
        return _Epetra.SerialDenseSolver_M(self)


    def N(self):
        """
        N(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::N() const

        Returns column dimension of system. 
        """
        return _Epetra.SerialDenseSolver_N(self)


    def LDA(self):
        """
        LDA(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::LDA() const

        Returns the leading dimension of the this matrix. 
        """
        return _Epetra.SerialDenseSolver_LDA(self)


    def LDB(self):
        """
        LDB(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::LDB() const

        Returns the leading dimension of the RHS. 
        """
        return _Epetra.SerialDenseSolver_LDB(self)


    def NRHS(self):
        """
        NRHS(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::NRHS() const

        Returns the number of current right hand sides and solution vectors.

        """
        return _Epetra.SerialDenseSolver_NRHS(self)


    def LDX(self):
        """
        LDX(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::LDX() const

        Returns the leading dimension of the solution. 
        """
        return _Epetra.SerialDenseSolver_LDX(self)


    def LDAF(self):
        """
        LDAF(SerialDenseSolver self) -> int

        int
        Epetra_SerialDenseSolver::LDAF() const

        Returns the leading dimension of the factored matrix. 
        """
        return _Epetra.SerialDenseSolver_LDAF(self)


    def ANORM(self):
        """
        ANORM(SerialDenseSolver self) -> double

        double
        Epetra_SerialDenseSolver::ANORM() const

        Returns the 1-Norm of the this matrix (returns -1 if not yet
        computed). 
        """
        return _Epetra.SerialDenseSolver_ANORM(self)


    def RCOND(self):
        """
        RCOND(SerialDenseSolver self) -> double

        double
        Epetra_SerialDenseSolver::RCOND() const

        Returns the reciprocal of the condition number of the this matrix
        (returns -1 if not yet computed). 
        """
        return _Epetra.SerialDenseSolver_RCOND(self)


    def ROWCND(self):
        """
        ROWCND(SerialDenseSolver self) -> double

        double
        Epetra_SerialDenseSolver::ROWCND() const

        Ratio of smallest to largest row scale factors for the this matrix
        (returns -1 if not yet computed).

        If ROWCND() is >= 0.1 and AMAX() is not close to overflow or
        underflow, then equilibration is not needed. 
        """
        return _Epetra.SerialDenseSolver_ROWCND(self)


    def COLCND(self):
        """
        COLCND(SerialDenseSolver self) -> double

        double
        Epetra_SerialDenseSolver::COLCND() const

        Ratio of smallest to largest column scale factors for the this matrix
        (returns -1 if not yet computed).

        If COLCND() is >= 0.1 then equilibration is not needed. 
        """
        return _Epetra.SerialDenseSolver_COLCND(self)


    def AMAX(self):
        """
        AMAX(SerialDenseSolver self) -> double

        double
        Epetra_SerialDenseSolver::AMAX() const

        Returns the absolute value of the largest entry of the this matrix
        (returns -1 if not yet computed). 
        """
        return _Epetra.SerialDenseSolver_AMAX(self)


    def IPIV(self):
        """
        IPIV(SerialDenseSolver self) -> PyObject *

        int*
        Epetra_SerialDenseSolver::IPIV() const

        Returns pointer to pivot vector (if factorization has been computed),
        zero otherwise. 
        """
        return _Epetra.SerialDenseSolver_IPIV(self)


    def A(self):
        """
        A(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::A() const

        Returns pointer to the this matrix. 
        """
        return _Epetra.SerialDenseSolver_A(self)


    def B(self):
        """
        B(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::B() const

        Returns pointer to current RHS. 
        """
        return _Epetra.SerialDenseSolver_B(self)


    def X(self):
        """
        X(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::X() const

        Returns pointer to current solution. 
        """
        return _Epetra.SerialDenseSolver_X(self)


    def AF(self):
        """
        AF(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::AF() const

        Returns pointer to the factored matrix (may be the same as A() if
        factorization done in place). 
        """
        return _Epetra.SerialDenseSolver_AF(self)


    def FERR(self):
        """
        FERR(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::FERR() const

        Returns a pointer to the forward error estimates computed by LAPACK.

        """
        return _Epetra.SerialDenseSolver_FERR(self)


    def BERR(self):
        """
        BERR(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::BERR() const

        Returns a pointer to the backward error estimates computed by LAPACK.

        """
        return _Epetra.SerialDenseSolver_BERR(self)


    def R(self):
        """
        R(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::R() const

        Returns a pointer to the row scaling vector used for equilibration. 
        """
        return _Epetra.SerialDenseSolver_R(self)


    def C(self):
        """
        C(SerialDenseSolver self) -> PyObject *

        double*
        Epetra_SerialDenseSolver::C() const

        Returns a pointer to the column scale vector used for equilibration.

        """
        return _Epetra.SerialDenseSolver_C(self)


    def ReciprocalConditionEstimate(self):
        """
        ReciprocalConditionEstimate(SerialDenseSolver self) -> double

        int
        Epetra_SerialDenseSolver::ReciprocalConditionEstimate(double &Value)

        Returns the reciprocal of the 1-norm condition number of the this
        matrix.

        Parameters:
        -----------

        Value:  Out On return contains the reciprocal of the 1-norm condition
        number of the this matrix.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSolver_ReciprocalConditionEstimate(self)

SerialDenseSolver_swigregister = _Epetra.SerialDenseSolver_swigregister
SerialDenseSolver_swigregister(SerialDenseSolver)

class SerialDenseSVD(SerialDenseOperator, CompObject, Object, BLAS, LAPACK):
    """


    Epetra_SerialDenseSVD: A class for SVDing dense linear problems.

    The Epetra_SerialDenseSVD class enables the definition, in terms of
    Epetra_SerialDenseMatrix and Epetra_SerialDenseVector objects, of a
    dense linear problem, followed by the solution of that problem via the
    most sophisticated techniques available in LAPACK.

    The Epetra_SerialDenseSVD class is intended to provide full-featured
    support for solving linear problems for general dense rectangular (or
    square) matrices. It is written on top of BLAS and LAPACK and thus has
    excellent performance and numerical capabilities. Using this class,
    one can either perform simple factorizations and solves or apply all
    the tricks available in LAPACK to get the best possible solution for
    very ill-conditioned problems.

    Epetra_SerialDenseSVD vs. Epetra_LAPACK

    The Epetra_LAPACK class provides access to most of the same
    functionality as Epetra_SerialDenseSolver. The primary difference is
    that Epetra_LAPACK is a "thin" layer on top of LAPACK and
    Epetra_SerialDenseSolver attempts to provide easy access to the more
    sophisticated aspects of solving dense linear and eigensystems. When
    you should use Epetra_LAPACK: If you are simply looking for a
    convenient wrapper around the Fortran LAPACK routines and you have a
    well-conditioned problem, you should probably use Epetra_LAPACK
    directly.

    When you should use Epetra_SerialDenseSolver: If you want to (or
    potentially want to) solve ill-conditioned problems or want to work
    with a more object-oriented interface, you should probably use
    Epetra_SerialDenseSolver.

    Constructing Epetra_SerialDenseSVD Objects

    There is a single Epetra_SerialDenseSVD constructor. However, the
    matrix, right hand side and solution vectors must be set prior to
    executing most methods in this class.

    Setting vectors used for linear solves

    The matrix A, the left hand side X and the right hand side B (when
    solving AX = B, for X), can be set by appropriate set methods. Each of
    these three objects must be an Epetra_SerialDenseMatrix or and
    Epetra_SerialDenseVector object. The set methods are as follows:
    SetMatrix() - Sets the matrix.

    SetVectors() - Sets the left and right hand side vector(s).

    Vector and Utility Functions

    Once a Epetra_SerialDenseSVD is constructed, several mathematical
    functions can be applied to the object. Specifically: Factorizations.

    Solves.

    Condition estimates.

    Norms.

    Counting floating point operations The Epetra_SerialDenseSVD class has
    Epetra_CompObject as a base class. Thus, floating point operations are
    counted and accumulated in the Epetra_Flop object (if any) that was
    set using the SetFlopCounter() method in the Epetra_CompObject base
    class.

    Examples using Epetra_SerialDenseSVD can be found in the Epetra test
    directories.

    C++ includes: Epetra_SerialDenseSVD.h 
    """

    __swig_setmethods__ = {}
    for _s in [SerialDenseOperator, CompObject, Object, BLAS, LAPACK]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseSVD, name, value)
    __swig_getmethods__ = {}
    for _s in [SerialDenseOperator, CompObject, Object, BLAS, LAPACK]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseSVD, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
        __init__(Epetra_SerialDenseSVD self) -> SerialDenseSVD

        Epetra_SerialDenseSVD::Epetra_SerialDenseSVD()

        Default constructor; matrix should be set using SetMatrix(), LHS and
        RHS set with SetVectors(). 
        """
        this = _Epetra.new_SerialDenseSVD()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_SerialDenseSVD

    def SetMatrix(self, A):
        """
        SetMatrix(SerialDenseSVD self, SerialDenseMatrix A) -> int

        int
        Epetra_SerialDenseSVD::SetMatrix(Epetra_SerialDenseMatrix &A)

        Sets the pointers for coefficient matrix. 
        """
        return _Epetra.SerialDenseSVD_SetMatrix(self, A)


    def SetVectors(self, X, B):
        """
        SetVectors(SerialDenseSVD self, SerialDenseMatrix X, SerialDenseMatrix B) -> int

        int
        Epetra_SerialDenseSVD::SetVectors(Epetra_SerialDenseMatrix &X,
        Epetra_SerialDenseMatrix &B)

        Sets the pointers for left and right hand side vector(s).

        Row dimension of X must match column dimension of matrix A, row
        dimension of B must match row dimension of A. X and B must have the
        same dimensions. 
        """
        return _Epetra.SerialDenseSVD_SetVectors(self, X, B)


    def SolveWithTranspose(self, Flag):
        """
        SolveWithTranspose(SerialDenseSVD self, bool Flag)

        void Epetra_SerialDenseSVD::SolveWithTranspose(bool Flag)

        Causes equilibration to be called just before the matrix factorization
        as part of the call to Factor.

        This function must be called before the factorization is performed.If
        Flag is true, causes all subsequent function calls to work with the
        transpose of this matrix, otherwise not. 
        """
        return _Epetra.SerialDenseSVD_SolveWithTranspose(self, Flag)


    def Factor(self):
        """
        Factor(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::Factor(void) 
        """
        return _Epetra.SerialDenseSVD_Factor(self)


    def Solve(self):
        """
        Solve(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::Solve(void)

        Computes the solution X to AX = B for the this matrix and the B
        provided to SetVectors()..

        Inverse of Matrix must be formed Integer error code, set to 0 if
        successful. 
        """
        return _Epetra.SerialDenseSVD_Solve(self)


    def Invert(self, rthresh=0.0, athresh=0.0):
        """
        Invert(SerialDenseSVD self, double rthresh=0.0, double athresh=0.0) -> int
        Invert(SerialDenseSVD self, double rthresh=0.0) -> int
        Invert(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::Invert(double rthresh=0.0, double athresh=0.0)

        Inverts the this matrix.

        Integer error code, set to 0 if successful. Otherwise returns the
        LAPACK error code INFO. 
        """
        return _Epetra.SerialDenseSVD_Invert(self, rthresh, athresh)


    def Transpose(self):
        """
        Transpose(SerialDenseSVD self) -> bool

        bool
        Epetra_SerialDenseSVD::Transpose()

        Returns true if transpose of this matrix has and will be used. 
        """
        return _Epetra.SerialDenseSVD_Transpose(self)


    def Factored(self):
        """
        Factored(SerialDenseSVD self) -> bool

        bool
        Epetra_SerialDenseSVD::Factored()

        Returns true if matrix is factored (factor available via AF() and
        LDAF()). 
        """
        return _Epetra.SerialDenseSVD_Factored(self)


    def Inverted(self):
        """
        Inverted(SerialDenseSVD self) -> bool

        bool
        Epetra_SerialDenseSVD::Inverted()

        Returns true if matrix inverse has been computed (inverse available
        via AF() and LDAF()). 
        """
        return _Epetra.SerialDenseSVD_Inverted(self)


    def Solved(self):
        """
        Solved(SerialDenseSVD self) -> bool

        bool
        Epetra_SerialDenseSVD::Solved()

        Returns true if the current set of vectors has been solved. 
        """
        return _Epetra.SerialDenseSVD_Solved(self)


    def Matrix(self):
        """
        Matrix(SerialDenseSVD self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSVD::Matrix() const

        Returns pointer to current matrix. 
        """
        return _Epetra.SerialDenseSVD_Matrix(self)


    def InvertedMatrix(self):
        """
        InvertedMatrix(SerialDenseSVD self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSVD::InvertedMatrix()
        const

        Returns pointer to inverted matrix (assuming inverse has been
        performed). 
        """
        return _Epetra.SerialDenseSVD_InvertedMatrix(self)


    def LHS(self):
        """
        LHS(SerialDenseSVD self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSVD::LHS() const

        Returns pointer to current LHS. 
        """
        return _Epetra.SerialDenseSVD_LHS(self)


    def RHS(self):
        """
        RHS(SerialDenseSVD self) -> SerialDenseMatrix

        Epetra_SerialDenseMatrix* Epetra_SerialDenseSVD::RHS() const

        Returns pointer to current RHS. 
        """
        return _Epetra.SerialDenseSVD_RHS(self)


    def M(self):
        """
        M(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::M() const

        Returns row dimension of system. 
        """
        return _Epetra.SerialDenseSVD_M(self)


    def N(self):
        """
        N(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::N() const

        Returns column dimension of system. 
        """
        return _Epetra.SerialDenseSVD_N(self)


    def A(self):
        """
        A(SerialDenseSVD self) -> double *

        double*
        Epetra_SerialDenseSVD::A() const

        Returns pointer to the this matrix. 
        """
        return _Epetra.SerialDenseSVD_A(self)


    def LDA(self):
        """
        LDA(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::LDA() const

        Returns the leading dimension of the this matrix. 
        """
        return _Epetra.SerialDenseSVD_LDA(self)


    def B(self):
        """
        B(SerialDenseSVD self) -> double *

        double*
        Epetra_SerialDenseSVD::B() const

        Returns pointer to current RHS. 
        """
        return _Epetra.SerialDenseSVD_B(self)


    def LDB(self):
        """
        LDB(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::LDB() const

        Returns the leading dimension of the RHS. 
        """
        return _Epetra.SerialDenseSVD_LDB(self)


    def NRHS(self):
        """
        NRHS(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::NRHS() const

        Returns the number of current right hand sides and solution vectors.

        """
        return _Epetra.SerialDenseSVD_NRHS(self)


    def X(self):
        """
        X(SerialDenseSVD self) -> double *

        double*
        Epetra_SerialDenseSVD::X() const

        Returns pointer to current solution. 
        """
        return _Epetra.SerialDenseSVD_X(self)


    def LDX(self):
        """
        LDX(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::LDX() const

        Returns the leading dimension of the solution. 
        """
        return _Epetra.SerialDenseSVD_LDX(self)


    def S(self):
        """
        S(SerialDenseSVD self) -> double *

        double*
        Epetra_SerialDenseSVD::S() const 
        """
        return _Epetra.SerialDenseSVD_S(self)


    def AI(self):
        """
        AI(SerialDenseSVD self) -> double *

        double*
        Epetra_SerialDenseSVD::AI() const

        Returns pointer to the inverted matrix (may be the same as A() if
        factorization done in place). 
        """
        return _Epetra.SerialDenseSVD_AI(self)


    def LDAI(self):
        """
        LDAI(SerialDenseSVD self) -> int

        int
        Epetra_SerialDenseSVD::LDAI() const

        Returns the leading dimension of the inverted matrix. 
        """
        return _Epetra.SerialDenseSVD_LDAI(self)


    def ANORM(self):
        """
        ANORM(SerialDenseSVD self) -> double

        double
        Epetra_SerialDenseSVD::ANORM() const

        Returns the 1-Norm of the this matrix (returns -1 if not yet
        computed). 
        """
        return _Epetra.SerialDenseSVD_ANORM(self)


    def SetUseTranspose(self, use_transpose):
        """
        SetUseTranspose(SerialDenseSVD self, bool use_transpose) -> int

        virtual int Epetra_SerialDenseSVD::SetUseTranspose(bool use_transpose)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  use_transpose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Epetra.SerialDenseSVD_SetUseTranspose(self, use_transpose)


    def Apply(self, Xmat, Ymat):
        """
        Apply(SerialDenseSVD self, SerialDenseMatrix Xmat, SerialDenseMatrix Ymat) -> int

        virtual int
        Epetra_SerialDenseSVD::Apply(const Epetra_SerialDenseMatrix &Xmat,
        Epetra_SerialDenseMatrix &Ymat)

        Returns the result of a Epetra_SerialDenseOperator applied to a
        Epetra_SerialDenseMatrix X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_SerialDenseMatrix to multiply with operator.

        Out:  Y -A Epetra_SerialDenseMatrix containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseSVD_Apply(self, Xmat, Ymat)


    def ApplyInverse(self, Xmat, Ymat):
        """
        ApplyInverse(SerialDenseSVD self, SerialDenseMatrix Xmat, SerialDenseMatrix Ymat) -> int

        virtual
        int Epetra_SerialDenseSVD::ApplyInverse(const Epetra_SerialDenseMatrix
        &Xmat, Epetra_SerialDenseMatrix &Ymat)

        Returns the result of a Epetra_SerialDenseOperator inverse applied to
        an Epetra_SerialDenseMatrix X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_SerialDenseMatrix to solve for.

        Out:  Y -A Epetra_SerialDenseMatrix containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.SerialDenseSVD_ApplyInverse(self, Xmat, Ymat)


    def NormInf(self):
        """
        NormInf(SerialDenseSVD self) -> double

        virtual double
        Epetra_SerialDenseSVD::NormInf() const

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.SerialDenseSVD_NormInf(self)


    def Label(self):
        """
        Label(SerialDenseSVD self) -> char const *

        virtual const
        char* Epetra_SerialDenseSVD::Label() const

        Returns a character string describing the operator. 
        """
        return _Epetra.SerialDenseSVD_Label(self)


    def UseTranspose(self):
        """
        UseTranspose(SerialDenseSVD self) -> bool

        virtual
        bool Epetra_SerialDenseSVD::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Epetra.SerialDenseSVD_UseTranspose(self)


    def HasNormInf(self):
        """
        HasNormInf(SerialDenseSVD self) -> bool

        virtual
        bool Epetra_SerialDenseSVD::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Epetra.SerialDenseSVD_HasNormInf(self)


    def RowDim(self):
        """
        RowDim(SerialDenseSVD self) -> int

        virtual int
        Epetra_SerialDenseSVD::RowDim() const

        Returns the row dimension of operator. 
        """
        return _Epetra.SerialDenseSVD_RowDim(self)


    def ColDim(self):
        """
        ColDim(SerialDenseSVD self) -> int

        virtual int
        Epetra_SerialDenseSVD::ColDim() const

        Returns the column dimension of operator. 
        """
        return _Epetra.SerialDenseSVD_ColDim(self)


    def AllocateWORK(self):
        """
        AllocateWORK(SerialDenseSVD self)

        void
        Epetra_SerialDenseSVD::AllocateWORK() 
        """
        return _Epetra.SerialDenseSVD_AllocateWORK(self)


    def AllocateIWORK(self):
        """
        AllocateIWORK(SerialDenseSVD self)

        void
        Epetra_SerialDenseSVD::AllocateIWORK() 
        """
        return _Epetra.SerialDenseSVD_AllocateIWORK(self)


    def InitPointers(self):
        """
        InitPointers(SerialDenseSVD self)

        void
        Epetra_SerialDenseSVD::InitPointers() 
        """
        return _Epetra.SerialDenseSVD_InitPointers(self)


    def DeleteArrays(self):
        """
        DeleteArrays(SerialDenseSVD self)

        void
        Epetra_SerialDenseSVD::DeleteArrays() 
        """
        return _Epetra.SerialDenseSVD_DeleteArrays(self)


    def ResetMatrix(self):
        """
        ResetMatrix(SerialDenseSVD self)

        void
        Epetra_SerialDenseSVD::ResetMatrix() 
        """
        return _Epetra.SerialDenseSVD_ResetMatrix(self)


    def ResetVectors(self):
        """
        ResetVectors(SerialDenseSVD self)

        void
        Epetra_SerialDenseSVD::ResetVectors() 
        """
        return _Epetra.SerialDenseSVD_ResetVectors(self)

    __swig_setmethods__["Transpose_"] = _Epetra.SerialDenseSVD_Transpose__set
    __swig_getmethods__["Transpose_"] = _Epetra.SerialDenseSVD_Transpose__get
    if _newclass:
        Transpose_ = _swig_property(_Epetra.SerialDenseSVD_Transpose__get, _Epetra.SerialDenseSVD_Transpose__set)
    __swig_setmethods__["Factored_"] = _Epetra.SerialDenseSVD_Factored__set
    __swig_getmethods__["Factored_"] = _Epetra.SerialDenseSVD_Factored__get
    if _newclass:
        Factored_ = _swig_property(_Epetra.SerialDenseSVD_Factored__get, _Epetra.SerialDenseSVD_Factored__set)
    __swig_setmethods__["Solved_"] = _Epetra.SerialDenseSVD_Solved__set
    __swig_getmethods__["Solved_"] = _Epetra.SerialDenseSVD_Solved__get
    if _newclass:
        Solved_ = _swig_property(_Epetra.SerialDenseSVD_Solved__get, _Epetra.SerialDenseSVD_Solved__set)
    __swig_setmethods__["Inverted_"] = _Epetra.SerialDenseSVD_Inverted__set
    __swig_getmethods__["Inverted_"] = _Epetra.SerialDenseSVD_Inverted__get
    if _newclass:
        Inverted_ = _swig_property(_Epetra.SerialDenseSVD_Inverted__get, _Epetra.SerialDenseSVD_Inverted__set)
    __swig_setmethods__["TRANS_"] = _Epetra.SerialDenseSVD_TRANS__set
    __swig_getmethods__["TRANS_"] = _Epetra.SerialDenseSVD_TRANS__get
    if _newclass:
        TRANS_ = _swig_property(_Epetra.SerialDenseSVD_TRANS__get, _Epetra.SerialDenseSVD_TRANS__set)
    __swig_setmethods__["M_"] = _Epetra.SerialDenseSVD_M__set
    __swig_getmethods__["M_"] = _Epetra.SerialDenseSVD_M__get
    if _newclass:
        M_ = _swig_property(_Epetra.SerialDenseSVD_M__get, _Epetra.SerialDenseSVD_M__set)
    __swig_setmethods__["N_"] = _Epetra.SerialDenseSVD_N__set
    __swig_getmethods__["N_"] = _Epetra.SerialDenseSVD_N__get
    if _newclass:
        N_ = _swig_property(_Epetra.SerialDenseSVD_N__get, _Epetra.SerialDenseSVD_N__set)
    __swig_setmethods__["Min_MN_"] = _Epetra.SerialDenseSVD_Min_MN__set
    __swig_getmethods__["Min_MN_"] = _Epetra.SerialDenseSVD_Min_MN__get
    if _newclass:
        Min_MN_ = _swig_property(_Epetra.SerialDenseSVD_Min_MN__get, _Epetra.SerialDenseSVD_Min_MN__set)
    __swig_setmethods__["NRHS_"] = _Epetra.SerialDenseSVD_NRHS__set
    __swig_getmethods__["NRHS_"] = _Epetra.SerialDenseSVD_NRHS__get
    if _newclass:
        NRHS_ = _swig_property(_Epetra.SerialDenseSVD_NRHS__get, _Epetra.SerialDenseSVD_NRHS__set)
    __swig_setmethods__["LDA_"] = _Epetra.SerialDenseSVD_LDA__set
    __swig_getmethods__["LDA_"] = _Epetra.SerialDenseSVD_LDA__get
    if _newclass:
        LDA_ = _swig_property(_Epetra.SerialDenseSVD_LDA__get, _Epetra.SerialDenseSVD_LDA__set)
    __swig_setmethods__["LDAI_"] = _Epetra.SerialDenseSVD_LDAI__set
    __swig_getmethods__["LDAI_"] = _Epetra.SerialDenseSVD_LDAI__get
    if _newclass:
        LDAI_ = _swig_property(_Epetra.SerialDenseSVD_LDAI__get, _Epetra.SerialDenseSVD_LDAI__set)
    __swig_setmethods__["LDB_"] = _Epetra.SerialDenseSVD_LDB__set
    __swig_getmethods__["LDB_"] = _Epetra.SerialDenseSVD_LDB__get
    if _newclass:
        LDB_ = _swig_property(_Epetra.SerialDenseSVD_LDB__get, _Epetra.SerialDenseSVD_LDB__set)
    __swig_setmethods__["LDX_"] = _Epetra.SerialDenseSVD_LDX__set
    __swig_getmethods__["LDX_"] = _Epetra.SerialDenseSVD_LDX__get
    if _newclass:
        LDX_ = _swig_property(_Epetra.SerialDenseSVD_LDX__get, _Epetra.SerialDenseSVD_LDX__set)
    __swig_setmethods__["INFO_"] = _Epetra.SerialDenseSVD_INFO__set
    __swig_getmethods__["INFO_"] = _Epetra.SerialDenseSVD_INFO__get
    if _newclass:
        INFO_ = _swig_property(_Epetra.SerialDenseSVD_INFO__get, _Epetra.SerialDenseSVD_INFO__set)
    __swig_setmethods__["LWORK_"] = _Epetra.SerialDenseSVD_LWORK__set
    __swig_getmethods__["LWORK_"] = _Epetra.SerialDenseSVD_LWORK__get
    if _newclass:
        LWORK_ = _swig_property(_Epetra.SerialDenseSVD_LWORK__get, _Epetra.SerialDenseSVD_LWORK__set)
    __swig_setmethods__["IWORK_"] = _Epetra.SerialDenseSVD_IWORK__set
    __swig_getmethods__["IWORK_"] = _Epetra.SerialDenseSVD_IWORK__get
    if _newclass:
        IWORK_ = _swig_property(_Epetra.SerialDenseSVD_IWORK__get, _Epetra.SerialDenseSVD_IWORK__set)
    __swig_setmethods__["ANORM_"] = _Epetra.SerialDenseSVD_ANORM__set
    __swig_getmethods__["ANORM_"] = _Epetra.SerialDenseSVD_ANORM__get
    if _newclass:
        ANORM_ = _swig_property(_Epetra.SerialDenseSVD_ANORM__get, _Epetra.SerialDenseSVD_ANORM__set)
    __swig_setmethods__["Matrix_"] = _Epetra.SerialDenseSVD_Matrix__set
    __swig_getmethods__["Matrix_"] = _Epetra.SerialDenseSVD_Matrix__get
    if _newclass:
        Matrix_ = _swig_property(_Epetra.SerialDenseSVD_Matrix__get, _Epetra.SerialDenseSVD_Matrix__set)
    __swig_setmethods__["LHS_"] = _Epetra.SerialDenseSVD_LHS__set
    __swig_getmethods__["LHS_"] = _Epetra.SerialDenseSVD_LHS__get
    if _newclass:
        LHS_ = _swig_property(_Epetra.SerialDenseSVD_LHS__get, _Epetra.SerialDenseSVD_LHS__set)
    __swig_setmethods__["RHS_"] = _Epetra.SerialDenseSVD_RHS__set
    __swig_getmethods__["RHS_"] = _Epetra.SerialDenseSVD_RHS__get
    if _newclass:
        RHS_ = _swig_property(_Epetra.SerialDenseSVD_RHS__get, _Epetra.SerialDenseSVD_RHS__set)
    __swig_setmethods__["Inverse_"] = _Epetra.SerialDenseSVD_Inverse__set
    __swig_getmethods__["Inverse_"] = _Epetra.SerialDenseSVD_Inverse__get
    if _newclass:
        Inverse_ = _swig_property(_Epetra.SerialDenseSVD_Inverse__get, _Epetra.SerialDenseSVD_Inverse__set)
    __swig_setmethods__["A_"] = _Epetra.SerialDenseSVD_A__set
    __swig_getmethods__["A_"] = _Epetra.SerialDenseSVD_A__get
    if _newclass:
        A_ = _swig_property(_Epetra.SerialDenseSVD_A__get, _Epetra.SerialDenseSVD_A__set)
    __swig_setmethods__["AI_"] = _Epetra.SerialDenseSVD_AI__set
    __swig_getmethods__["AI_"] = _Epetra.SerialDenseSVD_AI__get
    if _newclass:
        AI_ = _swig_property(_Epetra.SerialDenseSVD_AI__get, _Epetra.SerialDenseSVD_AI__set)
    __swig_setmethods__["WORK_"] = _Epetra.SerialDenseSVD_WORK__set
    __swig_getmethods__["WORK_"] = _Epetra.SerialDenseSVD_WORK__get
    if _newclass:
        WORK_ = _swig_property(_Epetra.SerialDenseSVD_WORK__get, _Epetra.SerialDenseSVD_WORK__set)
    __swig_setmethods__["U_"] = _Epetra.SerialDenseSVD_U__set
    __swig_getmethods__["U_"] = _Epetra.SerialDenseSVD_U__get
    if _newclass:
        U_ = _swig_property(_Epetra.SerialDenseSVD_U__get, _Epetra.SerialDenseSVD_U__set)
    __swig_setmethods__["S_"] = _Epetra.SerialDenseSVD_S__set
    __swig_getmethods__["S_"] = _Epetra.SerialDenseSVD_S__get
    if _newclass:
        S_ = _swig_property(_Epetra.SerialDenseSVD_S__get, _Epetra.SerialDenseSVD_S__set)
    __swig_setmethods__["Vt_"] = _Epetra.SerialDenseSVD_Vt__set
    __swig_getmethods__["Vt_"] = _Epetra.SerialDenseSVD_Vt__get
    if _newclass:
        Vt_ = _swig_property(_Epetra.SerialDenseSVD_Vt__get, _Epetra.SerialDenseSVD_Vt__set)
    __swig_setmethods__["B_"] = _Epetra.SerialDenseSVD_B__set
    __swig_getmethods__["B_"] = _Epetra.SerialDenseSVD_B__get
    if _newclass:
        B_ = _swig_property(_Epetra.SerialDenseSVD_B__get, _Epetra.SerialDenseSVD_B__set)
    __swig_setmethods__["X_"] = _Epetra.SerialDenseSVD_X__set
    __swig_getmethods__["X_"] = _Epetra.SerialDenseSVD_X__get
    if _newclass:
        X_ = _swig_property(_Epetra.SerialDenseSVD_X__get, _Epetra.SerialDenseSVD_X__set)
    __swig_setmethods__["UseTranspose_"] = _Epetra.SerialDenseSVD_UseTranspose__set
    __swig_getmethods__["UseTranspose_"] = _Epetra.SerialDenseSVD_UseTranspose__get
    if _newclass:
        UseTranspose_ = _swig_property(_Epetra.SerialDenseSVD_UseTranspose__get, _Epetra.SerialDenseSVD_UseTranspose__set)
SerialDenseSVD_swigregister = _Epetra.SerialDenseSVD_swigregister
SerialDenseSVD_swigregister(SerialDenseSVD)

class Comm(_object):
    """


    Epetra_Comm: The Epetra Communication Abstract Base Class.

    The Epetra_Comm class is an interface that encapsulates the general
    information and services needed for other Epetra classes to run on a
    parallel computer. An Epetra_Comm object is required for building all
    Epetra Map objects, which in turn are required for all other Epetra
    classes.

    Epetra_Comm has default implementations, via Epetra_SerialComm and
    Epetra_MpiComm, for both serial execution and MPI distributed memory
    execution. It is meant to insulate the user from the specifics of
    communication that are not required for normal manipulation of linear
    algebra objects. Most Epetra_Comm interfaces are similar to MPI
    interfaces, except that the type of data is not required as an
    argument since C++ can bind to the appropriate interface based on
    argument typing.

    Any implementation of the Epetra_Comm interface is also responsible
    for generating an Epetra_Distributor and Epetra_Directory object.

    C++ includes: Epetra_Comm.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Comm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Comm, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Clone(self, *args):
        """
        Clone(Comm self) -> Comm

        virtual Epetra_Comm*
        Epetra_Comm::Clone() const =0

        Epetra_Comm clone constructor.

        The clone function will return a new heap-allocated Comm instance. It
        is the responsibility of the caller to ensure that this new instance
        is properly destroyed. 
        """
        return _Epetra.Comm_Clone(self, *args)

    __swig_destroy__ = _Epetra.delete_Comm

    def Barrier(self, *args):
        """
        Barrier(Comm self)

        virtual void
        Epetra_Comm::Barrier() const =0

        Epetra_Comm Barrier function.

        Each processor must wait at the point the barrier is called until all
        processors have arrived. 
        """
        return _Epetra.Comm_Barrier(self, *args)


    def MyPID(self, *args):
        """
        MyPID(Comm self) -> int

        virtual int
        Epetra_Comm::MyPID() const =0

        Return my process ID.

        In MPI mode returns the rank of the calling process. In serial mode
        returns 0. 
        """
        return _Epetra.Comm_MyPID(self, *args)


    def NumProc(self, *args):
        """
        NumProc(Comm self) -> int

        virtual int
        Epetra_Comm::NumProc() const =0

        Returns total number of processes.

        In MPI mode returns the size of the MPI communicator. In serial mode
        returns 1. 
        """
        return _Epetra.Comm_NumProc(self, *args)


    def CreateDistributor(self, *args):
        """
        CreateDistributor(Comm self) -> Distributor

        virtual
        Epetra_Distributor* Epetra_Comm::CreateDistributor() const =0

        Create a distributor object. 
        """
        return _Epetra.Comm_CreateDistributor(self, *args)


    def CreateDirectory(self, *args):
        """
        CreateDirectory(Comm self, BlockMap Map) -> Directory

        virtual
        Epetra_Directory* Epetra_Comm::CreateDirectory(const Epetra_BlockMap
        &Map) const =0

        Create a directory object for the given Epetra_BlockMap. 
        """
        return _Epetra.Comm_CreateDirectory(self, *args)


    def PrintInfo(self, *args):
        """
        PrintInfo(Comm self, std::ostream & os)

        virtual void
        Epetra_Comm::PrintInfo(std::ostream &os) const =0

        Print object to an output stream. 
        """
        return _Epetra.Comm_PrintInfo(self, *args)


    def Broadcast(self, *args):
        """
        Broadcast(self, numpy.ndarray myObj, int root)

        Argument myObj must be a numpy array, so that the Broadcast can be
        performed in-place.  Its scalar data type must be int, long, double or
        string.  In C++, this routine has an integer error return code.  In
        python, a non-zero return code is converted to an exception.

        virtual int
        Epetra_Comm::Broadcast(char *MyVals, int Count, int Root) const =0

        Epetra_Comm Broadcast function.

        Take list of input values from the root processor and sends to all
        other processors.

        Parameters:
        -----------

        MyVals:  InOut On entry, the root processor contains the list of
        values. On exit, all processors will have the same list of values.
        Note that values must be allocated on all processor before the
        broadcast.

        Count:  In On entry, contains the length of the list of Values.

        Root:  In On entry, contains the processor from which all processors
        will receive a copy of Values. 
        """
        return _Epetra.Comm_Broadcast(self, *args)


    def GatherAll(self, *args):
        """
        GatherAll(Comm self, PyObject * myObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_GatherAll(self, *args)


    def SumAll(self, *args):
        """
        SumAll(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_SumAll(self, *args)


    def MaxAll(self, *args):
        """
        MaxAll(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_MaxAll(self, *args)


    def MinAll(self, *args):
        """
        MinAll(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_MinAll(self, *args)


    def ScanSum(self, *args):
        """
        ScanSum(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_ScanSum(self, *args)

Comm_swigregister = _Epetra.Comm_swigregister
Comm_swigregister(Comm)

class SerialComm(Object, Comm):
    """


    Epetra_SerialComm: The Epetra Serial Communication Class.

    The Epetra_SerialComm class is an implementation of Epetra_Comm,
    providing the general information and services needed for other Epetra
    classes to run on a serial computer.

    C++ includes: Epetra_SerialComm.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object, Comm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialComm, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Comm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialComm, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_SerialComm self) -> SerialComm
        __init__(Epetra_SerialComm self, SerialComm Comm) -> SerialComm

        Epetra_SerialComm::Epetra_SerialComm(const Epetra_SerialComm &Comm)

        Epetra_SerialComm Copy Constructor.

        Makes an exact copy of an existing Epetra_SerialComm instance. 
        """
        this = _Epetra.new_SerialComm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Clone(self, *args):
        """
        Clone(SerialComm self) -> Comm

        Epetra_Comm*
        Epetra_SerialComm::Clone() const

        Clone method. 
        """
        return _Epetra.SerialComm_Clone(self, *args)

    __swig_destroy__ = _Epetra.delete_SerialComm

    def Barrier(self, *args):
        """
        Barrier(SerialComm self)

        void
        Epetra_SerialComm::Barrier() const

        Epetra_SerialComm Barrier function.

        A no-op for a serial communicator. 
        """
        return _Epetra.SerialComm_Barrier(self, *args)


    def MyPID(self, *args):
        """
        MyPID(SerialComm self) -> int

        int
        Epetra_SerialComm::MyPID() const

        Return my process ID.

        In MPI mode returns the rank of the calling process. In serial mode
        returns 0. 
        """
        return _Epetra.SerialComm_MyPID(self, *args)


    def NumProc(self, *args):
        """
        NumProc(SerialComm self) -> int

        int
        Epetra_SerialComm::NumProc() const

        Returns total number of processes (always returns 1 for SerialComm).

        """
        return _Epetra.SerialComm_NumProc(self, *args)


    def CreateDistributor(self, *args):
        """
        CreateDistributor(SerialComm self) -> Distributor

        Epetra_Distributor * Epetra_SerialComm::CreateDistributor() const

        Create a distributor object. 
        """
        return _Epetra.SerialComm_CreateDistributor(self, *args)


    def CreateDirectory(self, *args):
        """
        CreateDirectory(SerialComm self, BlockMap Map) -> Directory

        Epetra_Directory * Epetra_SerialComm::CreateDirectory(const
        Epetra_BlockMap &Map) const

        Create a directory object for the given Epetra_BlockMap. 
        """
        return _Epetra.SerialComm_CreateDirectory(self, *args)


    def PrintInfo(self, *args):
        """
        PrintInfo(SerialComm self, std::ostream & os)

        void
        Epetra_SerialComm::PrintInfo(std::ostream &os) const

        Print method that implements Epetra_Comm virtual PrintInfo method. 
        """
        return _Epetra.SerialComm_PrintInfo(self, *args)


    def ReferenceCount(self, *args):
        """
        ReferenceCount(SerialComm self) -> int

        int
        Epetra_SerialComm::ReferenceCount() const

        Returns the reference count of SerialCommData.

        (Intended for testing purposes.) 
        """
        return _Epetra.SerialComm_ReferenceCount(self, *args)


    def DataPtr(self, *args):
        """
        DataPtr(SerialComm self) -> Epetra_SerialCommData const *

        const
        Epetra_SerialCommData* Epetra_SerialComm::DataPtr() const

        Returns a pointer to the SerialCommData instance this SerialComm uses.

        (Intended for developer use only for testing purposes.) 
        """
        return _Epetra.SerialComm_DataPtr(self, *args)

SerialComm_swigregister = _Epetra.SerialComm_swigregister
SerialComm_swigregister(SerialComm)

class Distributor(_object):
    """


    Epetra_Distributor: The Epetra Gather/Scatter Setup Base Class.

    The Epetra_Distributor class is an interface that encapsulates the
    general information and services needed for other Epetra classes to
    perform gather/scatter operations on a parallel computer. An
    Epetra_Distributor object is actually produced by calling a method in
    the Epetra_Comm class.

    Epetra_Distributor has default implementations, via
    Epetra_SerialDistributor and Epetra_MpiDistributor, for both serial
    execution and MPI distributed memory execution. It is meant to
    insulate the user from the specifics of communication that are not
    required for normal manipulation of linear algebra objects..

    C++ includes: Epetra_Distributor.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Distributor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Distributor, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Clone(self, *args):
        """
        Clone(Distributor self) -> Distributor

        virtual
        Epetra_Distributor* Epetra_Distributor::Clone()=0

        Epetra_Distributor clone constructor. 
        """
        return _Epetra.Distributor_Clone(self, *args)


    def ReverseClone(self, *args):
        """
        ReverseClone(Distributor self) -> Distributor

        virtual
        Epetra_Distributor* Epetra_Distributor::ReverseClone()=0

        Create and extract the reverse version of the distributor.

        This is not a const method since a reverse distributor might need to
        be created. This works like Clone, returning a new object the user
        must deallocate. 
        """
        return _Epetra.Distributor_ReverseClone(self, *args)

    __swig_destroy__ = _Epetra.delete_Distributor

    def CreateFromSends(self, *args):
        """
        CreateFromSends(Distributor self, int const & NumExportIDs, int const * ExportPIDs, bool Deterministic, int & NumRemoteIDs) -> int

        virtual
        int Epetra_Distributor::CreateFromSends(const int &NumExportIDs, const
        int *ExportPIDs, bool Deterministic, int &NumRemoteIDs)=0

        Create Distributor object using list of process IDs to which we
        export.

        Take a list of Process IDs and construct a plan for efficiently
        scattering to these processes. Return the number of IDs being sent to
        me.

        Parameters:
        -----------

        NumExportIDs:  In Number of IDs that need to be sent from this
        processor.

        ExportPIDs:  In List of processors that will get the exported IDs.

        Deterministic:  In No op.

        NumRemoteIDs:  Out Number of IDs this processor will be receiving. 
        """
        return _Epetra.Distributor_CreateFromSends(self, *args)


    def CreateFromRecvs(self, *args):
        """
        CreateFromRecvs(Distributor self, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, int *& ExportGIDs, int *& ExportPIDs) -> int
        CreateFromRecvs(Distributor self, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, long long *& ExportGIDs, int *& ExportPIDs) -> int

        virtual
        int Epetra_Distributor::CreateFromRecvs(const int &NumRemoteIDs, const
        long long *RemoteGIDs, const int *RemotePIDs, bool Deterministic, int
        &NumExportIDs, long long *&ExportGIDs, int *&ExportPIDs)=0 
        """
        return _Epetra.Distributor_CreateFromRecvs(self, *args)


    def DoWaits(self, *args):
        """
        DoWaits(Distributor self) -> int

        virtual int
        Epetra_Distributor::DoWaits()=0

        Wait on a set of posts. 
        """
        return _Epetra.Distributor_DoWaits(self, *args)


    def DoReverseWaits(self, *args):
        """
        DoReverseWaits(Distributor self) -> int

        virtual
        int Epetra_Distributor::DoReverseWaits()=0

        Wait on a reverse set of posts. 
        """
        return _Epetra.Distributor_DoReverseWaits(self, *args)


    def Do(self, *args):
        """
        Do(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        Do(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        virtual int
        Epetra_Distributor::Do(char *export_objs, int obj_size, int *&sizes,
        int &len_import_objs, char *&import_objs)=0

        Execute plan on buffer of export objects in a single step (object size
        may vary) 
        """
        return _Epetra.Distributor_Do(self, *args)


    def DoReverse(self, *args):
        """
        DoReverse(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReverse(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        virtual int
        Epetra_Distributor::DoReverse(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)=0

        Execute reverse of plan on buffer of export objects in a single step
        (object size may vary) 
        """
        return _Epetra.Distributor_DoReverse(self, *args)


    def DoPosts(self, *args):
        """
        DoPosts(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoPosts(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        virtual int
        Epetra_Distributor::DoPosts(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)=0

        Post buffer of export objects (can do other local work before
        executing Waits) 
        """
        return _Epetra.Distributor_DoPosts(self, *args)


    def DoReversePosts(self, *args):
        """
        DoReversePosts(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReversePosts(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        virtual
        int Epetra_Distributor::DoReversePosts(char *export_objs, int
        obj_size, int *&sizes, int &len_import_objs, char *&import_objs)=0

        Do reverse post of buffer of export objects (can do other local work
        before executing Waits) 
        """
        return _Epetra.Distributor_DoReversePosts(self, *args)

Distributor_swigregister = _Epetra.Distributor_swigregister
Distributor_swigregister(Distributor)

class Epetra_SerialDistributor(Object, Distributor):
    """


    Epetra_SerialDistributor: The Epetra Serial implementation of the
    Epetra_Distributor Gather/Scatter Setup Class.

    The Epetra_SerialDistributor class is an Serial implement of
    Epetra_Distributor that is essentially a trivial class since a serial
    machine is a trivial parallel machine. An Epetra_SerialDistributor
    object is actually produced by calling a method in the
    Epetra_SerialComm class.

    C++ includes: Epetra_SerialDistributor.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Epetra_SerialDistributor, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Epetra_SerialDistributor, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_SerialDistributor self, SerialComm Comm) -> Epetra_SerialDistributor
        __init__(Epetra_SerialDistributor self, Epetra_SerialDistributor Plan) -> Epetra_SerialDistributor

        Epetra_SerialDistributor::Epetra_SerialDistributor(const
        Epetra_SerialDistributor &Plan)

        Epetra_SerialDistributor Copy Constructor. 
        """
        this = _Epetra.new_Epetra_SerialDistributor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Clone(self, *args):
        """
        Clone(Epetra_SerialDistributor self) -> Distributor

        Epetra_Distributor* Epetra_SerialDistributor::Clone()

        Clone method. 
        """
        return _Epetra.Epetra_SerialDistributor_Clone(self, *args)


    def ReverseClone(self, *args):
        """
        ReverseClone(Epetra_SerialDistributor self) -> Distributor

        Epetra_Distributor* Epetra_SerialDistributor::ReverseClone()

        Create and extract the reverse version of the distributor.

        This is not implemented for SeriaDistributor. 
        """
        return _Epetra.Epetra_SerialDistributor_ReverseClone(self, *args)

    __swig_destroy__ = _Epetra.delete_Epetra_SerialDistributor

    def CreateFromSends(self, *args):
        """
        CreateFromSends(Epetra_SerialDistributor self, int const & NumExportIDs, int const * ExportPIDs, bool Deterministic, int & NumRemoteIDs) -> int

        int
        Epetra_SerialDistributor::CreateFromSends(const int &NumExportIDs,
        const int *ExportPIDs, bool Deterministic, int &NumRemoteIDs)

        Create Distributor object using list of process IDs to which we
        export.

        Take a list of Process IDs and construct a plan for efficiently
        scattering to these processes. Return the number of IDs being sent to
        me.

        Parameters:
        -----------

        NumExportIDs:  In Number of IDs that need to be sent from this
        processor.

        ExportPIDs:  In List of processors that will get the exported IDs.

        Deterministic:  In No op.

        NumRemoteIDs:  Out Number of IDs this processor will be receiving. 
        """
        return _Epetra.Epetra_SerialDistributor_CreateFromSends(self, *args)


    def CreateFromRecvs(self, *args):
        """
        CreateFromRecvs(Epetra_SerialDistributor self, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, int *& ExportGIDs, int *& ExportPIDs) -> int
        CreateFromRecvs(Epetra_SerialDistributor self, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, long long *& ExportGIDs, int *& ExportPIDs) -> int

        int
        Epetra_SerialDistributor::CreateFromRecvs(const int &NumRemoteIDs,
        const long long *RemoteGIDs, const int *RemotePIDs, bool
        Deterministic, int &NumExportIDs, long long *&ExportGIDs, int
        *&ExportPIDs) 
        """
        return _Epetra.Epetra_SerialDistributor_CreateFromRecvs(self, *args)


    def DoWaits(self, *args):
        """
        DoWaits(Epetra_SerialDistributor self) -> int

        int
        Epetra_SerialDistributor::DoWaits()

        Wait on a set of posts. 
        """
        return _Epetra.Epetra_SerialDistributor_DoWaits(self, *args)


    def DoReverseWaits(self, *args):
        """
        DoReverseWaits(Epetra_SerialDistributor self) -> int

        int
        Epetra_SerialDistributor::DoReverseWaits()

        Wait on a reverse set of posts. 
        """
        return _Epetra.Epetra_SerialDistributor_DoReverseWaits(self, *args)


    def Do(self, *args):
        """
        Do(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        Do(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_SerialDistributor::Do(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)

        Execute plan on buffer of export objects in a single step (object size
        may vary) 
        """
        return _Epetra.Epetra_SerialDistributor_Do(self, *args)


    def DoReverse(self, *args):
        """
        DoReverse(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReverse(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_SerialDistributor::DoReverse(char *export_objs, int obj_size,
        int *&sizes, int &len_import_objs, char *&import_objs)

        Execute reverse of plan on buffer of export objects in a single step
        (object size may vary) 
        """
        return _Epetra.Epetra_SerialDistributor_DoReverse(self, *args)


    def DoPosts(self, *args):
        """
        DoPosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoPosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_SerialDistributor::DoPosts(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)

        Post buffer of export objects (can do other local work before
        executing Waits) 
        """
        return _Epetra.Epetra_SerialDistributor_DoPosts(self, *args)


    def DoReversePosts(self, *args):
        """
        DoReversePosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReversePosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_SerialDistributor::DoReversePosts(char *export_objs, int
        obj_size, int *&sizes, int &len_import_objs, char *&import_objs)

        Do reverse post of buffer of export objects (can do other local work
        before executing Waits) 
        """
        return _Epetra.Epetra_SerialDistributor_DoReversePosts(self, *args)

Epetra_SerialDistributor_swigregister = _Epetra.Epetra_SerialDistributor_swigregister
Epetra_SerialDistributor_swigregister(Epetra_SerialDistributor)


def Epetra_MPI_Init_Argv(*args):
    """Epetra_MPI_Init_Argv(PyObject * args) -> PyObject *"""
    return _Epetra.Epetra_MPI_Init_Argv(*args)

def Epetra_MPI_Finalize(*args):
    """Epetra_MPI_Finalize() -> PyObject *"""
    return _Epetra.Epetra_MPI_Finalize(*args)


# Call MPI_Init if appropriate
import sys
calledMpiInit = Epetra_MPI_Init_Argv(sys.argv)

# Proceed according to calledMpiInit.  If calledMpiInit is true, then register a
# call to MPI_Finalize() with the atexit module and use the default value for
# mpiCommunicator, equivalent to MPI_COMM_WORLD.  If calledMpiInit is false, try
# to assess what package is responsible for calling MPI_Init(), currently either
# distarray or mpi4py, and extract the appropriate value for mpiCommunicator.
mpiCommunicator = None
if calledMpiInit:
    import atexit
    atexit.register(Epetra_MPI_Finalize)
else:
    if sys.modules.get("distarray.localapi.mpiutils"):
        dlm = sys.modules["distarray.localapi.mpiutils"]
        mpiCommunicator = dlm.get_base_comm()
    elif sys.modules.get("mpi4py.MPI"):
        MPI = sys.modules["mpi4py.MPI"]
        mpiCommunicator = MPI.COMM_WORLD

class MpiComm(Object, Comm):
    """


    Epetra_MpiComm: The Epetra MPI Communication Class.

    The Epetra_MpiComm class is an implementation of Epetra_Comm that
    encapsulates the general information and services needed for other
    Epetra classes to run on a parallel computer using MPI.

    C++ includes: Epetra_MpiComm.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object, Comm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MpiComm, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Comm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MpiComm, name)
    __repr__ = _swig_repr

    def Clone(self, *args):
        """
        Clone(MpiComm self) -> Comm

        Epetra_Comm*
        Epetra_MpiComm::Clone() const

        Clone method. 
        """
        return _Epetra.MpiComm_Clone(self, *args)

    __swig_destroy__ = _Epetra.delete_MpiComm

    def Barrier(self, *args):
        """
        Barrier(MpiComm self)

        void
        Epetra_MpiComm::Barrier() const

        Epetra_MpiComm Barrier function.

        Causes each processor in the communicator to wait until all processors
        have arrived. 
        """
        return _Epetra.MpiComm_Barrier(self, *args)


    def Comm(self, *args):
        """
        Comm(MpiComm self) -> MPI_Comm

        MPI_Comm
        Epetra_MpiComm::Comm() const

        Extract MPI Communicator from a Epetra_MpiComm object. 
        """
        return _Epetra.MpiComm_Comm(self, *args)


    def MyPID(self, *args):
        """
        MyPID(MpiComm self) -> int

        int
        Epetra_MpiComm::MyPID() const

        Return my process ID.

        In MPI mode returns the rank of the calling process. In serial mode
        returns 0. 
        """
        return _Epetra.MpiComm_MyPID(self, *args)


    def NumProc(self, *args):
        """
        NumProc(MpiComm self) -> int

        int
        Epetra_MpiComm::NumProc() const

        Returns total number of processes.

        In MPI mode returns the size of the MPI communicator. In serial mode
        returns 1. 
        """
        return _Epetra.MpiComm_NumProc(self, *args)


    def CreateDistributor(self, *args):
        """
        CreateDistributor(MpiComm self) -> Distributor

        Epetra_Distributor * Epetra_MpiComm::CreateDistributor() const

        Create a distributor object. 
        """
        return _Epetra.MpiComm_CreateDistributor(self, *args)


    def CreateDirectory(self, *args):
        """
        CreateDirectory(MpiComm self, BlockMap Map) -> Directory

        Epetra_Directory * Epetra_MpiComm::CreateDirectory(const
        Epetra_BlockMap &Map) const

        Create a directory object for the given Epetra_BlockMap. 
        """
        return _Epetra.MpiComm_CreateDirectory(self, *args)


    def GetMpiTag(self, *args):
        """
        GetMpiTag(MpiComm self) -> int

        int
        Epetra_MpiComm::GetMpiTag() const

        Acquire an MPI tag from the Epetra range of 24050-24099, increment
        tag. 
        """
        return _Epetra.MpiComm_GetMpiTag(self, *args)


    def GetMpiComm(self, *args):
        """
        GetMpiComm(MpiComm self) -> MPI_Comm

        MPI_Comm
        Epetra_MpiComm::GetMpiComm() const

        Get the MPI Communicator (identical to Comm() method; used when we
        know we are MPI. 
        """
        return _Epetra.MpiComm_GetMpiComm(self, *args)


    def PrintInfo(self, *args):
        """
        PrintInfo(MpiComm self, std::ostream & os)

        void
        Epetra_MpiComm::PrintInfo(std::ostream &os) const

        Print method that implements Epetra_Comm virtual PrintInfo method. 
        """
        return _Epetra.MpiComm_PrintInfo(self, *args)


    def ReferenceCount(self, *args):
        """
        ReferenceCount(MpiComm self) -> int

        int
        Epetra_MpiComm::ReferenceCount() const

        Returns the reference count of MpiCommData.

        (Intended for testing purposes.) 
        """
        return _Epetra.MpiComm_ReferenceCount(self, *args)


    def DataPtr(self, *args):
        """
        DataPtr(MpiComm self) -> Epetra_MpiCommData const *

        const
        Epetra_MpiCommData* Epetra_MpiComm::DataPtr() const

        Returns a pointer to the MpiCommData instance this MpiComm uses.

        (Intended for developer use only for testing purposes.) 
        """
        return _Epetra.MpiComm_DataPtr(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_MpiComm self, PyObject * dummy=None) -> MpiComm

        Epetra_MpiComm::Epetra_MpiComm(const Epetra_MpiComm &Comm)

        Epetra_MpiComm Copy Constructor.

        Makes an exact copy of an existing Epetra_MpiComm instance. 
        """
        this = _Epetra.new_MpiComm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
MpiComm_swigregister = _Epetra.MpiComm_swigregister
MpiComm_swigregister(MpiComm)

class MpiDistributor(Object, Distributor):
    """


    MPI implementation of Epetra_Distributor.

    This class is an MPI implementation of  Epetra_Distributor. It
    encapsulates the general information and services needed for other
    Epetra classes to perform gather/scatter operations on a parallel
    computer. An Epetra_MpiDistributor instance is actually produced by
    calling a method in the Epetra_MpiComm class.

    C++ includes: Epetra_MpiDistributor.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MpiDistributor, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MpiDistributor, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_MpiDistributor self, MpiComm Comm) -> MpiDistributor
        __init__(Epetra_MpiDistributor self, MpiDistributor Distributor) -> MpiDistributor

        Epetra_MpiDistributor::Epetra_MpiDistributor(const
        Epetra_MpiDistributor &Distributor)

        Copy constructor. 
        """
        this = _Epetra.new_MpiDistributor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Clone(self, *args):
        """
        Clone(MpiDistributor self) -> Distributor

        Epetra_Distributor* Epetra_MpiDistributor::Clone()

        Clone method. 
        """
        return _Epetra.MpiDistributor_Clone(self, *args)


    def ReverseClone(self, *args):
        """
        ReverseClone(MpiDistributor self) -> Distributor

        Epetra_Distributor * Epetra_MpiDistributor::ReverseClone()

        Create and extract the reverse version of the distributor.

        This is not a const method since a reverse distributor might need to
        be created. This works like Clone, returning a new object the user
        must deallocate. 
        """
        return _Epetra.MpiDistributor_ReverseClone(self, *args)

    __swig_destroy__ = _Epetra.delete_MpiDistributor

    def CreateFromSends(self, *args):
        """
        CreateFromSends(MpiDistributor self, int const & NumExportIDs, int const * ExportPIDs, bool Deterministic, int & NumRemoteIDs) -> int

        int
        Epetra_MpiDistributor::CreateFromSends(const int &NumExportIDs, const
        int *ExportPIDs, bool Deterministic, int &NumRemoteIDs)

        Create a communication plan from send list.

        Given a list of process IDs to which to send the given number of data
        IDs, construct a communication plan for efficiently scattering data to
        these processes.

        The number of data IDs being sent to me.

        Parameters:
        -----------

        NumExportIDs:  [in] Number of data IDs that need to be sent from the
        calling process.

        ExportPIDs:  [in] List of process IDs that will get the exported data
        IDs.

        Deterministic:  [in] Currently has no effect.

        NumRemoteIDs:  [out] Number of data IDs the calling process will be
        receiving. 
        """
        return _Epetra.MpiDistributor_CreateFromSends(self, *args)


    def CreateFromRecvs(self, *args):
        """
        CreateFromRecvs(MpiDistributor self, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, int *& ExportGIDs, int *& ExportPIDs) -> int
        CreateFromRecvs(MpiDistributor self, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, long long *& ExportGIDs, int *& ExportPIDs) -> int

        int
        Epetra_MpiDistributor::CreateFromRecvs(const int &NumRemoteIDs, const
        long long *RemoteGIDs, const int *RemotePIDs, bool Deterministic, int
        &NumExportIDs, long long *&ExportGIDs, int *&ExportPIDs) 
        """
        return _Epetra.MpiDistributor_CreateFromRecvs(self, *args)


    def CreateFromSendsAndRecvs(self, *args):
        """
        CreateFromSendsAndRecvs(MpiDistributor self, int const & NumExportIDs, int const * ExportPIDs, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic) -> int
        CreateFromSendsAndRecvs(MpiDistributor self, int const & NumExportIDs, int const * ExportPIDs, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic) -> int

        int Epetra_MpiDistributor::CreateFromSendsAndRecvs(const int
        &NumExportIDs, const int *ExportPIDs, const int &NumRemoteIDs, const
        long long *RemoteGIDs, const int *RemotePIDs, bool Deterministic) 
        """
        return _Epetra.MpiDistributor_CreateFromSendsAndRecvs(self, *args)


    def DoWaits(self, *args):
        """
        DoWaits(MpiDistributor self) -> int

        int
        Epetra_MpiDistributor::DoWaits()

        Wait on a set of posts. 
        """
        return _Epetra.MpiDistributor_DoWaits(self, *args)


    def DoReverseWaits(self, *args):
        """
        DoReverseWaits(MpiDistributor self) -> int

        int
        Epetra_MpiDistributor::DoReverseWaits()

        Wait on a reverse set of posts. 
        """
        return _Epetra.MpiDistributor_DoReverseWaits(self, *args)


    def Do(self, *args):
        """
        Do(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        Do(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_MpiDistributor::Do(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)

        Execute plan on buffer of export objects in a single step (object size
        may vary) 
        """
        return _Epetra.MpiDistributor_Do(self, *args)


    def DoReverse(self, *args):
        """
        DoReverse(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReverse(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_MpiDistributor::DoReverse(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)

        Execute reverse of plan on buffer of export objects in a single step
        (object size may vary) 
        """
        return _Epetra.MpiDistributor_DoReverse(self, *args)


    def DoPosts(self, *args):
        """
        DoPosts(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoPosts(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_MpiDistributor::DoPosts(char *export_objs, int obj_size, int
        *&sizes, int &len_import_objs, char *&import_objs)

        Post buffer of export objects (can do other local work before
        executing Waits) 
        """
        return _Epetra.MpiDistributor_DoPosts(self, *args)


    def DoReversePosts(self, *args):
        """
        DoReversePosts(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReversePosts(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int

        int
        Epetra_MpiDistributor::DoReversePosts(char *export_objs, int obj_size,
        int *&sizes, int &len_import_objs, char *&import_objs)

        Do reverse post of buffer of export objects (can do other local work
        before executing Waits) 
        """
        return _Epetra.MpiDistributor_DoReversePosts(self, *args)


    def NumReceives(self, *args):
        """
        NumReceives(MpiDistributor self) -> int

        int
        Epetra_MpiDistributor::NumReceives() const

        The number of procs from which we will receive data. 
        """
        return _Epetra.MpiDistributor_NumReceives(self, *args)


    def NumSends(self, *args):
        """
        NumSends(MpiDistributor self) -> int

        int
        Epetra_MpiDistributor::NumSends() const

        The number of procs to which we will send data. 
        """
        return _Epetra.MpiDistributor_NumSends(self, *args)


    def MaxSendLength(self, *args):
        """
        MaxSendLength(MpiDistributor self) -> int

        int
        Epetra_MpiDistributor::MaxSendLength() const

        Maximum number of values that this proc is sending to another single
        proc. 
        """
        return _Epetra.MpiDistributor_MaxSendLength(self, *args)


    def TotalReceiveLength(self, *args):
        """
        TotalReceiveLength(MpiDistributor self) -> int

        int
        Epetra_MpiDistributor::TotalReceiveLength() const

        Total number of values that this proc is receiving from other procs.

        """
        return _Epetra.MpiDistributor_TotalReceiveLength(self, *args)


    def ProcsFrom(self, *args):
        """
        ProcsFrom(MpiDistributor self) -> int const *

        const int*
        Epetra_MpiDistributor::ProcsFrom() const

        A list of procs sending values to this proc. 
        """
        return _Epetra.MpiDistributor_ProcsFrom(self, *args)


    def ProcsTo(self, *args):
        """
        ProcsTo(MpiDistributor self) -> int const *

        const int*
        Epetra_MpiDistributor::ProcsTo() const

        A list of procs to which this proc is sending values. 
        """
        return _Epetra.MpiDistributor_ProcsTo(self, *args)


    def LengthsFrom(self, *args):
        """
        LengthsFrom(MpiDistributor self) -> int const *

        const int*
        Epetra_MpiDistributor::LengthsFrom() const

        Number of values we're receiving from each proc.

        We will receive LengthsFrom[i] values from proc ProcsFrom[i]. 
        """
        return _Epetra.MpiDistributor_LengthsFrom(self, *args)


    def LengthsTo(self, *args):
        """
        LengthsTo(MpiDistributor self) -> int const *

        const int*
        Epetra_MpiDistributor::LengthsTo() const

        Number of values we're sending to each proc.

        We will send LengthsTo[i] values to procs ProcsTo[i]. 
        """
        return _Epetra.MpiDistributor_LengthsTo(self, *args)


    def GetLastDoStatistics(self, *args):
        """
        GetLastDoStatistics(MpiDistributor self, int & bytes_sent, int & bytes_recvd)

        void Epetra_MpiDistributor::GetLastDoStatistics(int &bytes_sent, int
        &bytes_recvd) const

        Information on the last call to Do/DoReverse.

        Returns the amount of data sent & recv'd on this processor in bytes 
        """
        return _Epetra.MpiDistributor_GetLastDoStatistics(self, *args)

MpiDistributor_swigregister = _Epetra.MpiDistributor_swigregister
MpiDistributor_swigregister(MpiDistributor)


def PyComm():
    "PyComm() -> Epetra.MpiComm"
    return MpiComm(mpiCommunicator);

class BlockMap(Object):
    """


    Epetra_BlockMap: A class for partitioning block element vectors and
    matrices.

    It is often the case that multiple matrix and vector objects have an
    identical distribution of elements on a parallel machine. The
    Epetra_BlockMap class keeps information that describes this
    distribution for matrices and vectors that have block elements. The
    definition of an element can vary depending on the situation. For
    vectors (and multi-vectors), an element is a span of one or more
    contiguous entries. For matrices, it is a span of one or more matrix
    rows. More generally, an element in the BlockMap class is an ordered
    list of points. (NOTE: Points do not have global ID's.) Two additional
    definitions useful in understanding the BlockMap class follow:
    BlockMap - A distributed ordered list of elements.

    First Point - First ordered point in an element

    This class has a variety of constructors that can be separated into
    two categories: Fixed element size constructors: All map elements have
    an identical size. This corresponds to a block partitioning of
    matrices and vectors where the element size is the same for all
    elements. A common example is multiple degrees of freedom per mesh
    node in finite element computations where the number of degrees of
    freedom is the same for all nodes.

    Variable element size constructor: Map element sizes may vary and are
    individually defined via a list of element sizes. This is the most
    general case and corresponds to a variable block partitioning of the
    matrices and vectors. A common example is multiple degrees of freedom
    per mesh node in finite element computations where the number of
    degrees of freedom varies. This happens, for example, if regions have
    differing material types or there are chemical reactions in the
    simulation.

    Epetra_BlockMap allows the storage and retrieval of the following
    information. Depending on the constructor that is used, some of the
    information is defined by the user and some is determined by the
    constructor. Once an Epetra_BlockMap is constructed any of the
    following can be obtained by calling a query function that has the
    same name as the attribute, e.g. to get the value of
    NumGlobalElements, you can call a function NumGlobalElements(). For
    attributes that are lists, the query functions return the list values
    in a user allocated array.

    NumGlobalElements - The total number of elements across all
    processors. If this parameter and NumMyElements are both passed in to
    the constructor, one of the three cases will apply: If
    NumGlobalElements = NumMyElements (and not equal to zero) the map is
    defined to be a local replicated map. In this case, objects
    constructed using this map will be identically replicated across all
    processors in the communicator.

    If NumGlobalElements = -1 and NumMyElements is passed in then
    NumGlobalElements will be computed as the sum of NumMyElements across
    all processors.

    If neither of the above is true, NumGlobalElements will be checked
    against the sum of NumMyElements across all processors. An error is
    issued if the comparison is not equal.

    NumMyElements - The number of elements owned by the calling processor.

    MyGlobalElements - A list of length NumMyElements that contains the
    global element IDs of the elements owned by the calling processor.

    ElementSize - The size of elements if the size of all elements is the
    same. This will be the case if the query function
    ConstantElementSize() returns true. Otherwise this value will be set
    to zero.

    ElementSizeList - A list of the element sizes for elements owned by
    the calling processor. This list is always accessible, even if the
    element sizes are all one or of constant value. However, in these
    cases, the ElementSizeList will not be generated unless a query for
    the list is called.

    IndexBase - The base integer value for indexed array references.
    Typically this is 0 for C/C++ and 1 for Fortran, but it can be set to
    any integer value.

    Comm - The Epetra_Comm communicator. This communicator can in turn be
    queried for processor rank and size information.

    In addition to the information above that is passed in to or created
    by the Epetra_BlockMap constructor, the following attributes are
    computed and available via query to the user using the same scheme as
    above, e.g., use NumGlobalPoints() to get the value of
    NumGlobalPoints.

    NumGlobalPoints - The total number of points across all processors.

    NumMyPoints - The number of points on the calling processor.

    MinAllGID - The minimum global index value across all processors.

    MaxAllGID - The maximum global index value across all processors.

    MinMyGID - The minimum global index value on the calling processor.

    MaxMyGID - The maximum global index value on the calling processor.

    MinLID - The minimum local index value on the calling processor.

    MaxLID - The maximum local index value on the calling processor.

    MinElementSize - The minimum element size across all processors.

    MaxElementSize - The maximum element size across all processors.

    The following functions allow boolean tests for certain properties.

    ConstantElementSize() - Returns true if the element size for this map
    is the same for all elements.

    LinearMap() - Returns true if the elements are distributed linear
    across processors, i.e., processor 0 gets the first n/p elements,
    processor 1 gets the next n/p elements, etc. where n is the number of
    elements and p is the number of processors.

    DistributedGlobal() - Returns true if the element space of the map
    spans more than one processor. This will be true in most cases, but
    will be false on in serial and for objects that are created via the
    derived Epetra_LocalMap class.

    WARNING:  A Epetra_Comm object is required for all Epetra_BlockMap
    constructors.  \\bf {error handling}

    Most methods in Epetra_BlockMap return an integer error code. If the
    error code is 0, then no error occurred. If > 0 then a warning error
    occurred. If < 0 then a fatal error occurred.

    Epetra_BlockMap constructors will throw an exception of an error
    occurrs. These exceptions will alway be negative integer values as
    follows: -1 NumGlobalElements < -1. Should be >= -1 (Should be >= 0
    for first BlockMap constructor).

    -2 NumMyElements < 0. Should be >= 0.

    -3 ElementSize <= 0. Should be > 0.

    -4 Invalid NumGlobalElements. Should equal sum of MyGlobalElements, or
    set to -1 to compute automatically.

    -5 Minimum global element index is less than index base.

    -99 Internal Epetra_BlockMap error. Contact developer.

    For robust code, Epetra_BlockMap constructor calls should be caught
    using the try {...} catch {...} mechanism. For example:

    try {      Epetra_BlockMap * map = new
    Epetra_BlockMap(NumGlobalElements, ElementSize, IndexBase, Comm);   }
    catch (int Error) {     if (Error==-1) { // handle error }     if
    (Error==-2) ...

    { In the current implementation, Epetra_BlockMap is the base class
    for:  Epetra_Map.

    Epetra_LocalBlockMap.  }

    C++ includes: Epetra_BlockMap.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockMap, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockMap, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_BlockMap

    def LID(self, *args):
        """
        LID(BlockMap self, int GID) -> int
        LID(BlockMap self, long long GID) -> int

        int
        Epetra_BlockMap::LID(long long GID) const 
        """
        return _Epetra.BlockMap_LID(self, *args)


    def GID(self, *args):
        """
        GID(BlockMap self, int LID) -> int

        int
        Epetra_BlockMap::GID(int LID) const

        Returns global ID of local ID, return IndexBase-1 if not found on this
        processor. 
        """
        return _Epetra.BlockMap_GID(self, *args)


    def GID64(self, *args):
        """
        GID64(BlockMap self, int LID) -> long long

        long long
        Epetra_BlockMap::GID64(int LID) const 
        """
        return _Epetra.BlockMap_GID64(self, *args)


    def MyGID(self, *args):
        """
        MyGID(BlockMap self, int GID_in) -> bool
        MyGID(BlockMap self, long long GID_in) -> bool

        bool
        Epetra_BlockMap::MyGID(long long GID_in) const 
        """
        return _Epetra.BlockMap_MyGID(self, *args)


    def MyLID(self, *args):
        """
        MyLID(BlockMap self, int lid) -> bool

        bool
        Epetra_BlockMap::MyLID(int lid) const

        Returns true if the LID passed in belongs to the calling processor in
        this map, otherwise returns false. 
        """
        return _Epetra.BlockMap_MyLID(self, *args)


    def MinAllGID(self, *args):
        """
        MinAllGID(BlockMap self) -> int

        int
        Epetra_BlockMap::MinAllGID() const

        Returns the minimum global ID across the entire map. 
        """
        return _Epetra.BlockMap_MinAllGID(self, *args)


    def MinAllGID64(self, *args):
        """
        MinAllGID64(BlockMap self) -> long long

        long long
        Epetra_BlockMap::MinAllGID64() const 
        """
        return _Epetra.BlockMap_MinAllGID64(self, *args)


    def MaxAllGID(self, *args):
        """
        MaxAllGID(BlockMap self) -> int

        int
        Epetra_BlockMap::MaxAllGID() const

        Returns the maximum global ID across the entire map. 
        """
        return _Epetra.BlockMap_MaxAllGID(self, *args)


    def MaxAllGID64(self, *args):
        """
        MaxAllGID64(BlockMap self) -> long long

        long long
        Epetra_BlockMap::MaxAllGID64() const 
        """
        return _Epetra.BlockMap_MaxAllGID64(self, *args)


    def MinMyGID(self, *args):
        """
        MinMyGID(BlockMap self) -> int

        int
        Epetra_BlockMap::MinMyGID() const

        Returns the minimum global ID owned by this processor. 
        """
        return _Epetra.BlockMap_MinMyGID(self, *args)


    def MinMyGID64(self, *args):
        """
        MinMyGID64(BlockMap self) -> long long

        long long
        Epetra_BlockMap::MinMyGID64() const 
        """
        return _Epetra.BlockMap_MinMyGID64(self, *args)


    def MaxMyGID(self, *args):
        """
        MaxMyGID(BlockMap self) -> int

        int
        Epetra_BlockMap::MaxMyGID() const

        Returns the maximum global ID owned by this processor. 
        """
        return _Epetra.BlockMap_MaxMyGID(self, *args)


    def MaxMyGID64(self, *args):
        """
        MaxMyGID64(BlockMap self) -> long long

        long long
        Epetra_BlockMap::MaxMyGID64() const 
        """
        return _Epetra.BlockMap_MaxMyGID64(self, *args)


    def MinLID(self, *args):
        """
        MinLID(BlockMap self) -> int

        int
        Epetra_BlockMap::MinLID() const

        The minimum local index value on the calling processor. 
        """
        return _Epetra.BlockMap_MinLID(self, *args)


    def MaxLID(self, *args):
        """
        MaxLID(BlockMap self) -> int

        int
        Epetra_BlockMap::MaxLID() const

        The maximum local index value on the calling processor. 
        """
        return _Epetra.BlockMap_MaxLID(self, *args)


    def NumGlobalElements(self, *args):
        """
        NumGlobalElements(BlockMap self) -> int

        int
        Epetra_BlockMap::NumGlobalElements() const

        Number of elements across all processors. 
        """
        return _Epetra.BlockMap_NumGlobalElements(self, *args)


    def NumGlobalElements64(self, *args):
        """
        NumGlobalElements64(BlockMap self) -> long long

        long
        long Epetra_BlockMap::NumGlobalElements64() const 
        """
        return _Epetra.BlockMap_NumGlobalElements64(self, *args)


    def NumMyElements(self, *args):
        """
        NumMyElements(BlockMap self) -> int

        int
        Epetra_BlockMap::NumMyElements() const

        Number of elements on the calling processor. 
        """
        return _Epetra.BlockMap_NumMyElements(self, *args)


    def MyGlobalElementsPtr(self, *args):
        """
        MyGlobalElementsPtr(BlockMap self, int *& MyGlobalElementList) -> int
        MyGlobalElementsPtr(BlockMap self, long long *& MyGlobalElementList) -> int

        int
        Epetra_BlockMap::MyGlobalElementsPtr(long long *&MyGlobalElementList)
        const 
        """
        return _Epetra.BlockMap_MyGlobalElementsPtr(self, *args)


    def ElementSize(self, *args):
        """
        ElementSize(BlockMap self) -> int
        ElementSize(BlockMap self, int LID) -> int

        int
        Epetra_BlockMap::ElementSize(int LID) const

        Size of element for specified LID. 
        """
        return _Epetra.BlockMap_ElementSize(self, *args)


    def FirstPointInElement(self, *args):
        """
        FirstPointInElement(BlockMap self, int LID) -> int

        int
        Epetra_BlockMap::FirstPointInElement(int LID) const

        Returns the requested entry in the FirstPointInElementList; see
        FirstPointInElementList() for details.

        This function provides similar functionality to
        FirstPointInElementList(), but for simple maps may avoid the explicit
        construction of the FirstPointInElementList array. Returns -1 if LID
        is out-of-range. 
        """
        return _Epetra.BlockMap_FirstPointInElement(self, *args)


    def IndexBase(self, *args):
        """
        IndexBase(BlockMap self) -> int

        int
        Epetra_BlockMap::IndexBase() const

        Index base for this map. 
        """
        return _Epetra.BlockMap_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """
        IndexBase64(BlockMap self) -> long long

        long long
        Epetra_BlockMap::IndexBase64() const 
        """
        return _Epetra.BlockMap_IndexBase64(self, *args)


    def NumGlobalPoints(self, *args):
        """
        NumGlobalPoints(BlockMap self) -> int

        int
        Epetra_BlockMap::NumGlobalPoints() const

        Number of global points for this map; equals the sum of all element
        sizes across all processors. 
        """
        return _Epetra.BlockMap_NumGlobalPoints(self, *args)


    def NumGlobalPoints64(self, *args):
        """
        NumGlobalPoints64(BlockMap self) -> long long

        long long
        Epetra_BlockMap::NumGlobalPoints64() const 
        """
        return _Epetra.BlockMap_NumGlobalPoints64(self, *args)


    def NumMyPoints(self, *args):
        """
        NumMyPoints(BlockMap self) -> int

        int
        Epetra_BlockMap::NumMyPoints() const

        Number of local points for this map; equals the sum of all element
        sizes on the calling processor. 
        """
        return _Epetra.BlockMap_NumMyPoints(self, *args)


    def MinMyElementSize(self, *args):
        """
        MinMyElementSize(BlockMap self) -> int

        int
        Epetra_BlockMap::MinMyElementSize() const

        Minimum element size on the calling processor. 
        """
        return _Epetra.BlockMap_MinMyElementSize(self, *args)


    def MaxMyElementSize(self, *args):
        """
        MaxMyElementSize(BlockMap self) -> int

        int
        Epetra_BlockMap::MaxMyElementSize() const

        Maximum element size on the calling processor. 
        """
        return _Epetra.BlockMap_MaxMyElementSize(self, *args)


    def MinElementSize(self, *args):
        """
        MinElementSize(BlockMap self) -> int

        int
        Epetra_BlockMap::MinElementSize() const

        Minimum element size across all processors. 
        """
        return _Epetra.BlockMap_MinElementSize(self, *args)


    def MaxElementSize(self, *args):
        """
        MaxElementSize(BlockMap self) -> int

        int
        Epetra_BlockMap::MaxElementSize() const

        Maximum element size across all processors. 
        """
        return _Epetra.BlockMap_MaxElementSize(self, *args)


    def UniqueGIDs(self, *args):
        """
        UniqueGIDs(BlockMap self) -> bool

        bool
        Epetra_BlockMap::UniqueGIDs() const

        Returns true if map GIDs are 1-to-1.

        Certain operations involving Epetra_BlockMap and Epetra_Map objects
        are well-defined only if the map GIDs are uniquely present in the map.
        In other words, if a GID occurs in the map, it occurs only once on a
        single processor and nowhere else. This boolean test returns true if
        this property is true, otherwise it returns false. 
        """
        return _Epetra.BlockMap_UniqueGIDs(self, *args)


    def GlobalIndicesInt(self, *args):
        """
        GlobalIndicesInt(BlockMap self) -> bool

        bool
        Epetra_BlockMap::GlobalIndicesInt() const

        Returns true if map create with int NumGlobalElements. 
        """
        return _Epetra.BlockMap_GlobalIndicesInt(self, *args)


    def GlobalIndicesLongLong(self, *args):
        """
        GlobalIndicesLongLong(BlockMap self) -> bool

        bool
        Epetra_BlockMap::GlobalIndicesLongLong() const

        Returns true if map create with long long NumGlobalElements. 
        """
        return _Epetra.BlockMap_GlobalIndicesLongLong(self, *args)


    def GlobalIndicesTypeValid(self, *args):
        """
        GlobalIndicesTypeValid(BlockMap self) -> bool

        bool
        Epetra_BlockMap::GlobalIndicesTypeValid() const 
        """
        return _Epetra.BlockMap_GlobalIndicesTypeValid(self, *args)


    def GlobalIndicesTypeMatch(self, *args):
        """
        GlobalIndicesTypeMatch(BlockMap self, BlockMap other) -> bool

        bool
        Epetra_BlockMap::GlobalIndicesTypeMatch(const Epetra_BlockMap &other)
        const 
        """
        return _Epetra.BlockMap_GlobalIndicesTypeMatch(self, *args)


    def ConstantElementSize(self, *args):
        """
        ConstantElementSize(BlockMap self) -> bool

        bool
        Epetra_BlockMap::ConstantElementSize() const

        Returns true if map has constant element size. 
        """
        return _Epetra.BlockMap_ConstantElementSize(self, *args)


    def SameBlockMapDataAs(self, *args):
        """
        SameBlockMapDataAs(BlockMap self, BlockMap Map) -> bool

        bool
        Epetra_BlockMap::SameBlockMapDataAs(const Epetra_BlockMap &Map) const

        Returns true if maps share same block map data underneath. This is a
        very cheap check whether two maps are identical. 
        """
        return _Epetra.BlockMap_SameBlockMapDataAs(self, *args)


    def SameAs(self, *args):
        """
        SameAs(BlockMap self, BlockMap Map) -> bool

        bool
        Epetra_BlockMap::SameAs(const Epetra_BlockMap &Map) const

        Returns true if this and Map are identical maps. 
        """
        return _Epetra.BlockMap_SameAs(self, *args)


    def PointSameAs(self, *args):
        """
        PointSameAs(BlockMap self, BlockMap Map) -> bool

        bool
        Epetra_BlockMap::PointSameAs(const Epetra_BlockMap &Map) const

        Returns true if this and Map have identical point-wise structure.

        If both maps have the same number of global points and the same point
        distribution across processors then this method returns true. 
        """
        return _Epetra.BlockMap_PointSameAs(self, *args)


    def LinearMap(self, *args):
        """
        LinearMap(BlockMap self) -> bool

        bool
        Epetra_BlockMap::LinearMap() const

        Returns true if the global ID space is contiguously divided (but not
        necessarily uniformly) across all processors. 
        """
        return _Epetra.BlockMap_LinearMap(self, *args)


    def DistributedGlobal(self, *args):
        """
        DistributedGlobal(BlockMap self) -> bool

        bool
        Epetra_BlockMap::DistributedGlobal() const

        Returns true if map is defined across more than one processor. 
        """
        return _Epetra.BlockMap_DistributedGlobal(self, *args)


    def MyGlobalElements64(self, *args):
        """
        MyGlobalElements64(BlockMap self) -> long long *

        long long
        * Epetra_BlockMap::MyGlobalElements64() const 
        """
        return _Epetra.BlockMap_MyGlobalElements64(self, *args)


    def Comm(self, *args):
        """
        Comm(BlockMap self) -> Comm

        const Epetra_Comm&
        Epetra_BlockMap::Comm() const

        Access function for Epetra_Comm communicator. 
        """
        return _Epetra.BlockMap_Comm(self, *args)


    def IsOneToOne(self, *args):
        """
        IsOneToOne(BlockMap self) -> bool

        bool
        Epetra_BlockMap::IsOneToOne() const 
        """
        return _Epetra.BlockMap_IsOneToOne(self, *args)


    def RemoveEmptyProcesses(self, *args):
        """
        RemoveEmptyProcesses(BlockMap self) -> BlockMap

        Epetra_BlockMap * Epetra_BlockMap::RemoveEmptyProcesses() const

        Return a new BlockMap with processes with zero elements removed.

        WARNING:  This method is only for expert users. Understanding how to
        use this method correctly requires some familiarity with semantics of
        MPI communicators.

        WARNING:  We make no promises of backwards compatibility for this
        method. It may go away or change at any time.  This method first
        computes a new communicator, which contains only those processes in
        this Map's communicator (the "original communicator") that have a
        nonzero number of elements in this BlockMap (the "original
        BlockMap"). It then returns a new BlockMap distributed over the new
        communicator. The new BlockMap represents the same distribution as the
        original BlockMap, except that processes containing zero elements are
        not included in the new BlockMap or its communicator. On processes not
        included in the new BlockMap or communicator, this method returns
        NULL.

        The returned BlockMap always has a distinct communicator from this
        BlockMap's original communicator. The new communicator contains a
        subset of processes from the original communicator. Even if the number
        of processes in the new communicator equals the number of processes in
        the original communicator, the new communicator is distinct. (In an
        MPI implementation, the new communicator is created using
        MPI_Comm_split.)

        This method must be called collectively on the original communicator.
        It leaves the original Map and communicator unchanged.

        This method was intended for applications such as algebraic multigrid
        or other multilevel preconditioners. Construction of each level of the
        multilevel preconditioner typically requires constructing sparse
        matrices, which in turn requires all-reduces over all participating
        processes at that level. Matrix sizes at successively coarser levels
        shrink geometrically. At the coarsest levels, some processes might be
        left with zero rows of the matrix, or the multigrid implementation
        might "rebalance" (redistribute the matrix) and intentionally leave
        some processes with zero rows. Removing processes with zero rows makes
        the all-reduces and other communication operations cheaper. 
        """
        return _Epetra.BlockMap_RemoveEmptyProcesses(self, *args)


    def ReplaceCommWithSubset(self, *args):
        """
        ReplaceCommWithSubset(BlockMap self, Comm Comm) -> BlockMap

        Epetra_BlockMap * Epetra_BlockMap::ReplaceCommWithSubset(const
        Epetra_Comm *Comm) const

        Replace this BlockMap's communicator with a subset communicator.

        WARNING:  This method is only for expert users. Understanding how to
        use this method correctly requires some familiarity with semantics of
        MPI communicators.

        WARNING:  We make no promises of backwards compatibility for this
        method. It may go away or change at any time.

        The input communicator's processes are a subset of this BlockMap's
        current communicator's processes.

        On processes which are not included in the input communicator, the
        input communicator is null.  This method must be called collectively
        on the original communicator. It leaves the original BlockMap and
        communicator unchanged.

        This method differs from removeEmptyProcesses(), in that it does not
        assume that excluded processes have zero entries. For example, one
        might wish to remove empty processes from the row BlockMap of a
        CrsGraph using removeEmptyProcesses(), and then apply the resulting
        subset communicator to the column, domain, and range Maps of the same
        graph. For the latter three Maps, one would in general use this method
        instead of removeEmptyProcesses(), giving the new row BlockMap's
        communicator to this method. 
        """
        return _Epetra.BlockMap_ReplaceCommWithSubset(self, *args)


    def __init__(self, *args):
        """

        __init__(self, int numGlobalElements, int elementSize, int indexBase,
             Comm comm) -> BlockMap

        BlockMap constructor with implicit local elements and constant element
        size.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             elementSize        - The number of degrees of freedom associated
                                  with every element.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int ElementSize, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int ElementSize, long long IndexBase, Comm Comm) -> BlockMap

        __init__(self, int numGlobalElements, int numMyElements, int elementSize,
             int indexBase, Comm comm) -> BlockMap

        BlockMap constructor with specified number of local elements and
        constant element size.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             numMyElements      - Number of local elements on this processor.
             elementSize        - The number of degrees of freedom associated
                                  with every element.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, int ElementSize, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, int ElementSize, long long IndexBase, Comm Comm) -> BlockMap

        __init__(self, int numGlobalElements, PySequence myGlobalElements,
             int elementSize, int indexBase, Comm comm) -> BlockMap

        BlockMap constructor with specified list of local elements and
        constant element size.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             myGlobalElements   - A sequence of integers specifying the global
                                  element indexes on this processor.
             elementSize        - The number of degrees of freedom associated
                                  with every element.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int ElementSize, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int ElementSize, long long IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int const * ElementSizeList, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int const * ElementSizeList, long long IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, int ElementSize, int indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, int ElementSize, long long indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> BlockMap
        __init__(Epetra_BlockMap self, int NumGlobal_Elements, int NumMy_Elements, int const * myGlobalElements, int ElementSize, int indexBase, Comm comm, bool UserIsDistributedGlobal, int UserMinAllGID, int UserMaxAllGID) -> BlockMap

        __init__(self, BlockMap map) -> BlockMap

        BlockMap copy constructor.

        __init__(self, int numGlobalElements, PySequence myGlobalElements,
             PySequence elementsSizes, int indexBase, Comm comm) -> BlockMap

        BlockMap constructor with specified list of local elements and
        specified list of element sizes.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             myGlobalElements   - A sequence of integers specifying the global
                                  element indexes on this processor.
             elementSizes       - A sequence of integers specifying the number of
                                  degrees of freedom associated with each element
                                  on this processor.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.

        Epetra_BlockMap::Epetra_BlockMap(const Epetra_BlockMap &map)

        Epetra_BlockMap copy constructor. 
        """
        this = _Epetra.new_BlockMap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def RemoteIDList(self, *args):
        """
        RemoteIDList(BlockMap self, int NumIDs, long long const * GIDList, int * PIDList, int * LIDList) -> int
        RemoteIDList(BlockMap self, int NumIDs, long long const * GIDList, int * PIDList, int * LIDList, int * SizeList) -> int
        RemoteIDList(BlockMap self, PyObject * GIDList) -> PyObject *

        ``GIDList`` is a sequence of integer global IDs, and the return
        argument is the three-tuple ``(PIDList, LIDList, sizeList)``, which
        are ``numpy.ndarray`` objects of integers representing the processor
        IDs, local IDs and element sizes, respectively.
        """
        return _Epetra.BlockMap_RemoteIDList(self, *args)


    def FindLocalElementID(self, *args):
        """
        FindLocalElementID(BlockMap self, int pointID) -> PyObject *

        Returns a tuple containing the local ID of the element that contains
        the given local pointID, and the offset of the point in that element.
        """
        return _Epetra.BlockMap_FindLocalElementID(self, *args)


    def MyGlobalElements(self, *args):
        """
        MyGlobalElements(BlockMap self, long long * MyGlobalElementList) -> int
        MyGlobalElements(BlockMap self, int *& IntGIDs, long long *& LLGIDs)
        MyGlobalElements(BlockMap self) -> PyObject *

        Returns a numpy array of integers specifying the list of global IDs on
        the processor.
        """
        return _Epetra.BlockMap_MyGlobalElements(self, *args)


    def FirstPointInElementList(self, *args):
        """
        FirstPointInElementList(BlockMap self) -> PyObject *

        Returns a numpy array of integer first local point numbers for all of
        the local elements.
        """
        return _Epetra.BlockMap_FirstPointInElementList(self, *args)


    def ElementSizeList(self, *args):
        """
        ElementSizeList(BlockMap self) -> PyObject *

        Returns a numpy array of integer sizes for each local element.
        """
        return _Epetra.BlockMap_ElementSizeList(self, *args)


    def PointToElementList(self, *args):
        """
        PointToElementList(BlockMap self) -> PyObject *

        Returns a numpy array of integers such that for each local point, it
        indicates the local element ID that the point belongs to.
        """
        return _Epetra.BlockMap_PointToElementList(self, *args)


    def AsMap(self, *args):
        """
        AsMap(BlockMap self) -> Teuchos::RCP< Epetra_Map >

        Attempt to convert an Epetra.BlockMap to an Epetra.Map. If the
        BlockMap can be downcast, that is what will be done. If not, but the
        element size is one, a new Epetra.Map will be constructed from the
        BlockMap data.
        """
        return _Epetra.BlockMap_AsMap(self, *args)

BlockMap_swigregister = _Epetra.BlockMap_swigregister
BlockMap_swigregister(BlockMap)

class Map(BlockMap):
    """


    Epetra_Map: A class for partitioning vectors and matrices.

    It is often the case that multiple matrix and vector objects have an
    identical distribution of elements on a parallel machine. The
    Epetra_Map class keep information that describes this distribution for
    matrices and vectors.

    Epetra_Map allows the storage and retrieval of the following
    information. Depending on the constructor that is used, some of the
    information is defined by the user and some is determined by the
    constructor. Once a Epetra_Map is constructed any of the following
    attributes can be obtained by calling a query function that has the
    name as the attribute, e.g. to get the value of NumGlobalElements, you
    can call a function NumGlobalElements(). For attributes that are
    lists, the query functions return the list values in a user allocated
    array.

    NumGlobalElements - The total number of elements across all
    processors. If this parameter and NumMyElements are both passed into
    the constructor, one of the three cases will apply: If
    NumGlobalElements = NumMyElements (and not equal to zero) the map is
    defined to be a local replicated map. In this case, objects
    constructed using this map will be identically replicated across all
    processors in the communicator.

    If NumGlobalElements = -1 and NumMyElements is passed in then
    NumGlobalElements will be computed as the sum of NumMyElements across
    all processors.

    If neither of the above is true, NumGlobalElements will be checked
    against the sum of NumMyElements across all processors. An error is
    issued if the comparison is not equal.

    NumMyElements - The number of elements owned by the calling processor.

    MyGlobalElements - A list of length NumMyElements that contains the
    global element IDs of the elements owned by the calling processor.

    IndexBase - The base integer value for indexed array references.
    Typically this is 0 for C/C++ and 1 for Fortran, but it can be set to
    any integer value.

    Comm - The Epetra_Comm communicator. This communicator can in turn be
    queried for processor rank and size information.

    In addition to the information above that is passed in to or created
    by the Epetra_Map constructor, the following attributes are computed
    and available via query to the user using the same scheme as above,
    e.g., use NumGlobalPoints() to get the value of NumGlobalPoints.

    NumGlobalPoints - The total number of points across all processors.

    NumMyPoints - The number of points on the calling processor.

    MinAllGID - The minimum global index value across all processors.

    MaxAllGID - The maximum global index value across all processors.

    MinMyGID - The minimum global index value on the calling processor.

    MaxMyGID - The maximum global index value on the calling processor.

    MinLID - The minimum local index value on the calling processor.

    MaxLID - The maximum local index value on the calling processor.

    The following functions allow boolean tests for certain properties.

    LinearMap() - Returns true if the elements are distributed linear
    across processors, i.e., processor 0 gets the first n/p elements,
    processor 1 gets the next n/p elements, etc. where n is the number of
    elements and p is the number of processors.

    DistributedGlobal() - Returns true if the element space of the map
    spans more than one processor. This will be true in most cases, but
    will be false in serial cases and for objects that are created via the
    derived Epetra_LocalMap class.

    WARNING:  An Epetra_Comm object is required for all Epetra_Map
    constructors.

    In the current implementation, Epetra_BlockMap is the base class for
    Epetra_Map.

    C++ includes: Epetra_Map.h 
    """

    __swig_setmethods__ = {}
    for _s in [BlockMap]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Map, name, value)
    __swig_getmethods__ = {}
    for _s in [BlockMap]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Map, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        __init__(self, int numGlobalElements, int indexBase, Comm comm) -> Map

        Map constructor with implicit number of elements per processor.
        Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_Map self, long long NumGlobalElements, int IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobalElements, long long IndexBase, Comm Comm) -> Map

        __init__(self, int numGlobalElements, int numMyElements, int indexBase,
             Comm comm) -> Map

        Map constructor with specified number of elements per processor.
        Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             numMyElements      - Number of local elements on this processor.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, int IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, long long IndexBase, Comm Comm) -> Map

        __init__(self, int numGlobalElements, PySequence myGlobalElements,
             int indexBase, Comm comm) -> Map

        Map constructor with specified list of global element IDs for each
        processor.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             myGlobalElements   - A sequence of integers specifying the global
                                  element indexes on this processor.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, long long IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, int indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> Map
        __init__(Epetra_Map self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, long long indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> Map
        __init__(Epetra_Map self, int NumGlobal_Elements, int NumMy_Elements, int const * myGlobalElements, int indexBase, Comm comm, bool UserIsDistributedGlobal, int UserMinAllGID, int UserMaxAllGID) -> Map

        __init__(self, Map map) -> Map

        Map copy constructor.

        Epetra_Map::Epetra_Map(const Epetra_Map &map)

        Epetra_Map copy constructor. 
        """
        this = _Epetra.new_Map(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Map

    def RemoveEmptyProcesses(self, *args):
        """
        RemoveEmptyProcesses(Map self) -> Map

        Epetra_Map *
        Epetra_Map::RemoveEmptyProcesses() const

        Return a new BlockMap with processes with zero elements removed.

        WARNING:  This method is only for expert users. Understanding how to
        use this method correctly requires some familiarity with semantics of
        MPI communicators.

        WARNING:  We make no promises of backwards compatibility for this
        method. It may go away or change at any time.  This method first
        computes a new communicator, which contains only those processes in
        this Map's communicator (the "original communicator") that have a
        nonzero number of elements in this BlockMap (the "original
        BlockMap"). It then returns a new BlockMap distributed over the new
        communicator. The new BlockMap represents the same distribution as the
        original BlockMap, except that processes containing zero elements are
        not included in the new BlockMap or its communicator. On processes not
        included in the new BlockMap or communicator, this method returns
        NULL.

        The returned BlockMap always has a distinct communicator from this
        BlockMap's original communicator. The new communicator contains a
        subset of processes from the original communicator. Even if the number
        of processes in the new communicator equals the number of processes in
        the original communicator, the new communicator is distinct. (In an
        MPI implementation, the new communicator is created using
        MPI_Comm_split.)

        This method must be called collectively on the original communicator.
        It leaves the original Map and communicator unchanged.

        This method was intended for applications such as algebraic multigrid
        or other multilevel preconditioners. Construction of each level of the
        multilevel preconditioner typically requires constructing sparse
        matrices, which in turn requires all-reduces over all participating
        processes at that level. Matrix sizes at successively coarser levels
        shrink geometrically. At the coarsest levels, some processes might be
        left with zero rows of the matrix, or the multigrid implementation
        might "rebalance" (redistribute the matrix) and intentionally leave
        some processes with zero rows. Removing processes with zero rows makes
        the all-reduces and other communication operations cheaper. 
        """
        return _Epetra.Map_RemoveEmptyProcesses(self, *args)


    def ReplaceCommWithSubset(self, *args):
        """
        ReplaceCommWithSubset(Map self, Comm Comm) -> Map

        Epetra_Map
        * Epetra_Map::ReplaceCommWithSubset(const Epetra_Comm *Comm) const

        Replace this Map's communicator with a subset communicator.

        WARNING:  This method is only for expert users. Understanding how to
        use this method correctly requires some familiarity with semantics of
        MPI communicators.

        WARNING:  We make no promises of backwards compatibility for this
        method. It may go away or change at any time.

        The input communicator's processes are a subset of this Map's current
        communicator's processes.

        On processes which are not included in the input communicator, the
        input communicator is null.  This method must be called collectively
        on the original communicator. It leaves the original BlockMap and
        communicator unchanged.

        This method differs from removeEmptyProcesses(), in that it does not
        assume that excluded processes have zero entries. For example, one
        might wish to remove empty processes from the row Map of a CrsGraph
        using removeEmptyProcesses(), and then apply the resulting subset
        communicator to the column, domain, and range Maps of the same graph.
        For the latter three Maps, one would in general use this method
        instead of removeEmptyProcesses(), giving the new row Map's
        communicator to this method. 
        """
        return _Epetra.Map_ReplaceCommWithSubset(self, *args)

Map_swigregister = _Epetra.Map_swigregister
Map_swigregister(Map)

class LocalMap(Map):
    """


    Epetra_LocalMap: A class for replicating vectors and matrices across
    multiple processors.

    Small matrix and vector objects are often replicated on distributed
    memory parallel machines. The Epetra_LocalMap class allows
    construction of these replicated local objects and keeps information
    that describes this distribution.

    Epetra_LocalMap allows the storage and retrieval of the following
    information. Once a Epetra_Map is constructed any of the following
    attributes can be obtained by calling a query function that has the
    name as the attribute, e.g. to get the value of NumGlobalPoints, you
    can call a function NumGlobalElements(). For attributes that are
    lists, the query functions return the list values in a user allocated
    array.

    NumMyElements - The number of elements owned by the calling processor.

    IndexBase - The base integer value for indexed array references.
    Typically this is 0 for C/C++ and 1 for Fortran, but it can be set to
    any integer value.

    Comm - The Epetra_Comm communicator. This communicator can in turn be
    queried for processor rank and size information.

    The Epetra_LocalMap class is actually a derived class of Epetra_Map.
    Epetra_Map is in turn derived from Epetra_BlockMap. As such,
    Epetra_LocalMap has full access to all the functions in these other
    map classes.

    In particular, the following function allows a boolean test:

    DistributedGlobal() - Returns false for a Epetra_LocalMap object.

    WARNING:  A Epetra_Comm object is required for all Epetra_LocalMap
    constructors.

    C++ includes: Epetra_LocalMap.h 
    """

    __swig_setmethods__ = {}
    for _s in [Map]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LocalMap, name, value)
    __swig_getmethods__ = {}
    for _s in [Map]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LocalMap, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LocalMap self, int NumMyElements, int IndexBase, Comm Comm) -> LocalMap
        __init__(Epetra_LocalMap self, long long NumMyElements, int IndexBase, Comm Comm) -> LocalMap
        __init__(Epetra_LocalMap self, long long NumMyElements, long long IndexBase, Comm Comm) -> LocalMap
        __init__(Epetra_LocalMap self, LocalMap map) -> LocalMap

        Epetra_LocalMap::Epetra_LocalMap(const Epetra_LocalMap &map)

        Epetra_LocalMap copy constructor. 
        """
        this = _Epetra.new_LocalMap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_LocalMap
LocalMap_swigregister = _Epetra.LocalMap_swigregister
LocalMap_swigregister(LocalMap)

class Directory(_object):
    """


    Epetra_Directory: This class is a pure virtual class whose interface
    allows Epetra_Map and Epetr_BlockMap objects to reference non-local
    elements.

    For Epetra_BlockMap objects, a Epetra_Directory object must be created
    by a call to the Epetra_Comm CreateDirectory method. The Directory is
    needed to allow referencing of non-local elements.

    C++ includes: Epetra_Directory.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Directory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Directory, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_Directory

    def GetDirectoryEntries(self, *args):
        """
        GetDirectoryEntries(Directory self, BlockMap Map, int const NumEntries, int const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int
        GetDirectoryEntries(Directory self, BlockMap Map, int const NumEntries, long long const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int

        virtual
        int Epetra_Directory::GetDirectoryEntries(const Epetra_BlockMap &Map,
        const int NumEntries, const long long *GlobalEntries, int *Procs, int
        *LocalEntries, int *EntrySizes, bool high_rank_sharing_procs=false)
        const =0 
        """
        return _Epetra.Directory_GetDirectoryEntries(self, *args)


    def GIDsAllUniquelyOwned(self, *args):
        """
        GIDsAllUniquelyOwned(Directory self) -> bool

        virtual bool Epetra_Directory::GIDsAllUniquelyOwned() const =0

        GIDsAllUniquelyOwned: returns true if all GIDs appear on just one
        processor.

        If any GIDs are owned by multiple processors, returns false. 
        """
        return _Epetra.Directory_GIDsAllUniquelyOwned(self, *args)

Directory_swigregister = _Epetra.Directory_swigregister
Directory_swigregister(Directory)

class BasicDirectory(Directory):
    """


    Epetra_BasicDirectory: This class allows Epetra_Map objects to
    reference non-local elements.

    For Epetra_BlockMap objects, a Epetra_Directory object must be created
    to allow referencing of non-local elements. The Epetra_BasicDirectory
    produces and contains a uniform linear Epetra_BlockMap and a ProcList_
    allowing blocks of non-local elements to be accessed by dereferencing
    through the Epetra_BasicDirectory.

    This class currently has one constructor, taking a Epetra_BlockMap
    object.

    C++ includes: Epetra_BasicDirectory.h 
    """

    __swig_setmethods__ = {}
    for _s in [Directory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicDirectory, name, value)
    __swig_getmethods__ = {}
    for _s in [Directory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicDirectory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_BasicDirectory self, BlockMap Map) -> BasicDirectory
        __init__(Epetra_BasicDirectory self, BasicDirectory Directory) -> BasicDirectory

        Epetra_BasicDirectory::Epetra_BasicDirectory(const
        Epetra_BasicDirectory &Directory)

        Epetra_BasicDirectory copy constructor. 
        """
        this = _Epetra.new_BasicDirectory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_BasicDirectory

    def GetDirectoryEntries(self, *args):
        """
        GetDirectoryEntries(BasicDirectory self, BlockMap Map, int const NumEntries, int const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int
        GetDirectoryEntries(BasicDirectory self, BlockMap Map, int const NumEntries, long long const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int

        int Epetra_BasicDirectory::GetDirectoryEntries(const Epetra_BlockMap
        &Map, const int NumEntries, const long long *GlobalEntries, int
        *Procs, int *LocalEntries, int *EntrySizes, bool
        high_rank_sharing_procs=false) const 
        """
        return _Epetra.BasicDirectory_GetDirectoryEntries(self, *args)


    def GIDsAllUniquelyOwned(self, *args):
        """
        GIDsAllUniquelyOwned(BasicDirectory self) -> bool

        bool Epetra_BasicDirectory::GIDsAllUniquelyOwned() const

        GIDsAllUniquelyOwned: returns true if all GIDs appear on just one
        processor.

        If any GIDs are owned by multiple processors, returns false. 
        """
        return _Epetra.BasicDirectory_GIDsAllUniquelyOwned(self, *args)

BasicDirectory_swigregister = _Epetra.BasicDirectory_swigregister
BasicDirectory_swigregister(BasicDirectory)

class Import(Object):
    """


    Epetra_Import: This class builds an import object for efficient
    importing of off- processor elements.

    Epetra_Import is used to construct a communication plan that can be
    called repeatedly by computational classes such the Epetra matrix,
    vector and multivector classes to efficiently obtain off-processor
    elements.

    This class currently has one constructor, taking two Epetra_Map or
    Epetra_BlockMap objects. The first map specifies the global IDs of
    elements that we want to import later. The second map specifies the
    global IDs that are owned by the calling processor.

    C++ includes: Epetra_Import.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Import, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Import, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Import self, BlockMap TargetMap, BlockMap SourceMap) -> Import
        __init__(Epetra_Import self, BlockMap TargetMap, BlockMap SourceMap, int NumRemotePIDs, int const * RemotePIDs) -> Import
        __init__(Epetra_Import self, BlockMap TargetMap, BlockMap SourceMap, int NumRemotePIDs, int const * RemotePIDs, int const & NumExportIDs, int const * ExportLIDs, int const * ExportPIDs) -> Import
        __init__(Epetra_Import self, Import Importer) -> Import
        __init__(Epetra_Import self, Export Exporter) -> Import

        Epetra_Import::Epetra_Import(const Epetra_Export &Exporter)

        Epetra_Import pseudo-copy constructor. Creates an Epetra_Import in the
        reverse direction of the Epetra_Export argument. 
        """
        this = _Epetra.new_Import(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Import

    def NumSameIDs(self, *args):
        """
        NumSameIDs(Import self) -> int

        int
        Epetra_Import::NumSameIDs() const

        Returns the number of elements that are identical between the source
        and target maps, up to the first different ID. 
        """
        return _Epetra.Import_NumSameIDs(self, *args)


    def NumPermuteIDs(self, *args):
        """
        NumPermuteIDs(Import self) -> int

        int
        Epetra_Import::NumPermuteIDs() const

        Returns the number of elements that are local to the calling
        processor, but not part of the first NumSameIDs() elements. 
        """
        return _Epetra.Import_NumPermuteIDs(self, *args)


    def NumRemoteIDs(self, *args):
        """
        NumRemoteIDs(Import self) -> int

        int
        Epetra_Import::NumRemoteIDs() const

        Returns the number of elements that are not on the calling processor.

        """
        return _Epetra.Import_NumRemoteIDs(self, *args)


    def NumExportIDs(self, *args):
        """
        NumExportIDs(Import self) -> int

        int
        Epetra_Import::NumExportIDs() const

        Returns the number of elements that must be sent by the calling
        processor to other processors. 
        """
        return _Epetra.Import_NumExportIDs(self, *args)


    def NumSend(self, *args):
        """
        NumSend(Import self) -> int

        int
        Epetra_Import::NumSend() const

        Total number of elements to be sent. 
        """
        return _Epetra.Import_NumSend(self, *args)


    def NumRecv(self, *args):
        """
        NumRecv(Import self) -> int

        int
        Epetra_Import::NumRecv() const

        Total number of elements to be received. 
        """
        return _Epetra.Import_NumRecv(self, *args)


    def SourceMap(self, *args):
        """
        SourceMap(Import self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_Import::SourceMap() const

        Returns the SourceMap used to construct this importer. 
        """
        return _Epetra.Import_SourceMap(self, *args)


    def TargetMap(self, *args):
        """
        TargetMap(Import self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_Import::TargetMap() const

        Returns the TargetMap used to construct this importer. 
        """
        return _Epetra.Import_TargetMap(self, *args)


    def Distributor(self, *args):
        """
        Distributor(Import self) -> Distributor

        Epetra_Distributor& Epetra_Import::Distributor() const 
        """
        return _Epetra.Import_Distributor(self, *args)


    def PermuteFromLIDs(self, *args):
        """
        PermuteFromLIDs(Import self) -> PyObject *

        int*
        Epetra_Import::PermuteFromLIDs() const

        List of elements in the source map that are permuted. 
        """
        return _Epetra.Import_PermuteFromLIDs(self, *args)


    def PermuteToLIDs(self, *args):
        """
        PermuteToLIDs(Import self) -> PyObject *

        int*
        Epetra_Import::PermuteToLIDs() const

        List of elements in the target map that are permuted. 
        """
        return _Epetra.Import_PermuteToLIDs(self, *args)


    def RemoteLIDs(self, *args):
        """
        RemoteLIDs(Import self) -> PyObject *

        int*
        Epetra_Import::RemoteLIDs() const

        List of elements in the target map that are coming from other
        processors. 
        """
        return _Epetra.Import_RemoteLIDs(self, *args)


    def ExportLIDs(self, *args):
        """
        ExportLIDs(Import self) -> PyObject *

        int*
        Epetra_Import::ExportLIDs() const

        List of elements that will be sent to other processors. 
        """
        return _Epetra.Import_ExportLIDs(self, *args)


    def ExportPIDs(self, *args):
        """
        ExportPIDs(Import self) -> PyObject *

        int*
        Epetra_Import::ExportPIDs() const

        List of processors to which elements will be sent, ExportLIDs() [i]
        will be sent to processor ExportPIDs() [i]. 
        """
        return _Epetra.Import_ExportPIDs(self, *args)

Import_swigregister = _Epetra.Import_swigregister
Import_swigregister(Import)

class Export(Object):
    """


    Epetra_Export: This class builds an export object for efficient
    exporting of off- processor elements.

    Epetra_Export is used to construct a communication plan that can be
    called repeatedly by computational classes such the Epetra matrix,
    vector and multivector classes to efficiently send data to a target
    processor.

    This class currently has one constructor, taking two Epetra_Map or
    Epetra_BlockMap objects. The first map specifies the global IDs that
    are owned by the calling processor. The second map specifies the
    global IDs of elements that we want to export to later.

    C++ includes: Epetra_Export.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Export, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Export, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Export self, BlockMap SourceMap, BlockMap TargetMap) -> Export
        __init__(Epetra_Export self, Export Exporter) -> Export
        __init__(Epetra_Export self, Import Exporter) -> Export

        Epetra_Export::Epetra_Export(const Epetra_Import &Exporter)

        Epetra_Export pseudo-copy constructor. Creates an Epetra_Export in the
        reverse direction of the Epetra_Import argument. 
        """
        this = _Epetra.new_Export(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Export

    def NumSameIDs(self, *args):
        """
        NumSameIDs(Export self) -> int

        int
        Epetra_Export::NumSameIDs() const

        Returns the number of elements that are identical between the source
        and target maps, up to the first different ID. 
        """
        return _Epetra.Export_NumSameIDs(self, *args)


    def NumPermuteIDs(self, *args):
        """
        NumPermuteIDs(Export self) -> int

        int
        Epetra_Export::NumPermuteIDs() const

        Returns the number of elements that are local to the calling
        processor, but not part of the first NumSameIDs() elements. 
        """
        return _Epetra.Export_NumPermuteIDs(self, *args)


    def NumRemoteIDs(self, *args):
        """
        NumRemoteIDs(Export self) -> int

        int
        Epetra_Export::NumRemoteIDs() const

        Returns the number of elements that are not on the calling processor.

        """
        return _Epetra.Export_NumRemoteIDs(self, *args)


    def NumExportIDs(self, *args):
        """
        NumExportIDs(Export self) -> int

        int
        Epetra_Export::NumExportIDs() const

        Returns the number of elements that must be sent by the calling
        processor to other processors. 
        """
        return _Epetra.Export_NumExportIDs(self, *args)


    def NumSend(self, *args):
        """
        NumSend(Export self) -> int

        int
        Epetra_Export::NumSend() const

        Total number of elements to be sent. 
        """
        return _Epetra.Export_NumSend(self, *args)


    def NumRecv(self, *args):
        """
        NumRecv(Export self) -> int

        int
        Epetra_Export::NumRecv() const

        Total number of elements to be received. 
        """
        return _Epetra.Export_NumRecv(self, *args)


    def SourceMap(self, *args):
        """
        SourceMap(Export self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_Export::SourceMap() const

        Returns the SourceMap used to construct this exporter. 
        """
        return _Epetra.Export_SourceMap(self, *args)


    def TargetMap(self, *args):
        """
        TargetMap(Export self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_Export::TargetMap() const

        Returns the TargetMap used to construct this exporter. 
        """
        return _Epetra.Export_TargetMap(self, *args)


    def Distributor(self, *args):
        """
        Distributor(Export self) -> Distributor

        Epetra_Distributor& Epetra_Export::Distributor() const 
        """
        return _Epetra.Export_Distributor(self, *args)


    def PermuteFromLIDs(self, *args):
        """
        PermuteFromLIDs(Export self) -> PyObject *

        int*
        Epetra_Export::PermuteFromLIDs() const

        List of elements in the source map that are permuted. 
        """
        return _Epetra.Export_PermuteFromLIDs(self, *args)


    def PermuteToLIDs(self, *args):
        """
        PermuteToLIDs(Export self) -> PyObject *

        int*
        Epetra_Export::PermuteToLIDs() const

        List of elements in the target map that are permuted. 
        """
        return _Epetra.Export_PermuteToLIDs(self, *args)


    def RemoteLIDs(self, *args):
        """
        RemoteLIDs(Export self) -> PyObject *

        int*
        Epetra_Export::RemoteLIDs() const

        List of elements in the target map that are coming from other
        processors. 
        """
        return _Epetra.Export_RemoteLIDs(self, *args)


    def ExportLIDs(self, *args):
        """
        ExportLIDs(Export self) -> PyObject *

        int*
        Epetra_Export::ExportLIDs() const

        List of elements that will be sent to other processors. 
        """
        return _Epetra.Export_ExportLIDs(self, *args)


    def ExportPIDs(self, *args):
        """
        ExportPIDs(Export self) -> PyObject *

        int*
        Epetra_Export::ExportPIDs() const

        List of processors to which elements will be sent, ExportLIDs() [i]
        will be sent to processor ExportPIDs() [i]. 
        """
        return _Epetra.Export_ExportPIDs(self, *args)

Export_swigregister = _Epetra.Export_swigregister
Export_swigregister(Export)

class SrcDistObject(_object):
    """


    Epetra_SrcDistObject: A class for supporting flexible source
    distributed objects for import/export operations.

    The Epetra_SrcDistObject is a base class for all Epetra distributed
    global objects that are potential source objects for the general
    Epetra_DistObject class. It provides a way to send a very general
    distributed object as the potential source object for an import or
    export object. For example, it is possible to pass an Epetra_RowMatrix
    object as the source object for an import/export where the target is
    an Epetra_CrsMatrix, or an Epetra_CrsGraph (where the RowMatrix values
    will be ignored).

    C++ includes: Epetra_SrcDistObject.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SrcDistObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SrcDistObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SrcDistObject

    def Map(self, *args):
        """
        Map(SrcDistObject self) -> BlockMap

        virtual const
        Epetra_BlockMap& Epetra_SrcDistObject::Map() const =0

        Returns a reference to the Epetra_BlockMap for this object. 
        """
        return _Epetra.SrcDistObject_Map(self, *args)

SrcDistObject_swigregister = _Epetra.SrcDistObject_swigregister
SrcDistObject_swigregister(SrcDistObject)

class DistObject(Object, SrcDistObject):
    """


    Epetra_DistObject: A class for constructing and using dense multi-
    vectors, vectors and matrices in parallel.

    The Epetra_DistObject is a base class for all Epetra distributed
    global objects. It provides the basic mechanisms and interface
    specifications for importing and exporting operations using
    Epetra_Import and Epetra_Export objects.

    Distributed Global vs. Replicated Local.

    Distributed Global objects - In most instances, a distributed object
    will be partitioned across multiple memory images associated with
    multiple processors. In this case, there is a unique copy of each
    element and elements are spread across all processors specified by the
    Epetra_Comm communicator.

    Replicated Local Objects - Some algorithms use objects that are too
    small to be distributed across all processors, the Hessenberg matrix
    in a GMRES computation. In other cases, such as with block iterative
    methods, block dot product functions produce small dense matrices that
    are required by all processors. Replicated local objectss handle these
    types of situation.

    C++ includes: Epetra_DistObject.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object, SrcDistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, SrcDistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_DistObject

    def Import(self, *args):
        """
        Import(DistObject self, SrcDistObject A, Import Importer, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int
        Import(DistObject self, SrcDistObject A, Export Exporter, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int

        int
        Epetra_DistObject::Import(const Epetra_SrcDistObject &A, const
        Epetra_Export &Exporter, Epetra_CombineMode CombineMode, const
        Epetra_OffsetIndex *Indexor=0)

        Imports an Epetra_DistObject using the Epetra_Export object.

        Parameters:
        -----------

        In:  Source - Distributed object that will be imported into the
        "\\e this" object.

        In:  Exporter - A Epetra_Export object specifying the communication
        required.

        In:  CombineMode - A Epetra_CombineMode enumerated type specifying how
        results should be combined on the receiving processor.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.DistObject_Import(self, *args)


    def Export(self, *args):
        """
        Export(DistObject self, SrcDistObject A, Import Importer, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int
        Export(DistObject self, SrcDistObject A, Export Exporter, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int

        int
        Epetra_DistObject::Export(const Epetra_SrcDistObject &A, const
        Epetra_Export &Exporter, Epetra_CombineMode CombineMode, const
        Epetra_OffsetIndex *Indexor=0)

        Exports an Epetra_DistObject using the Epetra_Export object.

        Parameters:
        -----------

        In:  Source - Distributed object that will be exported to the "\\e
        this" multivector.

        In:  Exporter - A Epetra_Export object specifying the communication
        required.

        In:  CombineMode - A Epetra_CombineMode enumerated type specifying how
        results should be combined on the receiving processor.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.DistObject_Export(self, *args)


    def Map(self, *args):
        """
        Map(DistObject self) -> BlockMap

        const Epetra_BlockMap&
        Epetra_DistObject::Map() const

        Returns the address of the Epetra_BlockMap for this multi-vector. 
        """
        return _Epetra.DistObject_Map(self, *args)


    def Comm(self, *args):
        """
        Comm(DistObject self) -> Comm

        const Epetra_Comm&
        Epetra_DistObject::Comm() const

        Returns the address of the Epetra_Comm for this multi-vector. 
        """
        return _Epetra.DistObject_Comm(self, *args)


    def DistributedGlobal(self, *args):
        """
        DistributedGlobal(DistObject self) -> bool

        bool
        Epetra_DistObject::DistributedGlobal() const

        Returns true if this multi-vector is distributed global, i.e., not
        local replicated. 
        """
        return _Epetra.DistObject_DistributedGlobal(self, *args)

DistObject_swigregister = _Epetra.DistObject_swigregister
DistObject_swigregister(DistObject)

class MapColoring(DistObject):
    """


    Epetra_MapColoring: A class for coloring Epetra_Map and
    Epetra_BlockMap objects.

    This class allows the user to associate an integer value, i.e., a
    color, to each element of an existing Epetra_Map or Epetra_BlockMap
    object. Colors may be assigned at construction, or via set methods.
    Any elements that are not explicitly assigned a color are assigned the
    color 0 (integer zero).

    This class has the following features:

    A color (arbitrary integer label) can be associated locally with each
    element of a map. Color assignment can be done all-at-once via the
    constructor, or

    via operator[] (using LIDs) one-at-a-time

    operator() (using GIDs) one-at-a-time

    or some combination of the above.

    Any element that is not explicitly colored takes on the default color.
    The default color is implicitly zero, unless specified differently at
    the time of construction.

    Color information may be accessed in the following ways: By local
    element ID (LID) - Returns the color of a specified LID, where the LID
    is associated with the Epetra_Map or BlockMap that was passed in to
    the Epetra_MapColoring constructor.

    By global element ID (GID) - Returns the color of the specified GID.
    There two methods for accessing GIDs, one assumes the request is for
    GIDs owned by the calling processor, the second allows arbitrary
    requested for GIDs, as long as the GID is defined on some processor
    for the Epetra_Map or Epetra_BlockMap.

    By color groups - Elements are grouped by color so that all elements
    of a given color can be accessed.

    Epetra_Map/Epetra_BlockMap pointers for a specified color - This
    facilitates use of coloring with Epetra distributed objects that are
    distributed via the map that was colored. For example, if users want
    to work with all rows of a matrix that have a certain color, they can
    create a map for that color and use it to access only those rows.

    The Epetra_MapColoring class implements the Epetra_DistObject
    interface. Therefore, a map coloring can be computed for a map with a
    given distribution and then redistributed across the parallel machine.
    For example, it would be possible to compute a map coloring on a
    single processor (perhaps because the algorithm for computing the
    color assignment is too difficult to implement in parallel or because
    it is cheap to run and not worth parallelizing), and then re-
    distribute the coloring using an Epetra_Export or Epetra_Import
    object.

    C++ includes: Epetra_MapColoring.h 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MapColoring, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_MapColoring

    def __call__(self, *args):
        """
        __call__(MapColoring self, long long GID) -> int
        __call__(MapColoring self, long long GID) -> int const &
        """
        return _Epetra.MapColoring___call__(self, *args)


    def NumColors(self, *args):
        """
        NumColors(MapColoring self) -> int

        int
        Epetra_MapColoring::NumColors() const

        Returns number of colors on the calling processor. 
        """
        return _Epetra.MapColoring_NumColors(self, *args)


    def MaxNumColors(self, *args):
        """
        MaxNumColors(MapColoring self) -> int

        int
        Epetra_MapColoring::MaxNumColors() const

        Returns maximum over all processors of the number of colors. 
        """
        return _Epetra.MapColoring_MaxNumColors(self, *args)


    def DefaultColor(self, *args):
        """
        DefaultColor(MapColoring self) -> int

        int
        Epetra_MapColoring::DefaultColor() const

        Returns default color. 
        """
        return _Epetra.MapColoring_DefaultColor(self, *args)


    def NumElementsWithColor(self, *args):
        """
        NumElementsWithColor(MapColoring self, int Color) -> int

        int
        Epetra_MapColoring::NumElementsWithColor(int Color) const

        Returns number of map elements on calling processor having specified
        Color. 
        """
        return _Epetra.MapColoring_NumElementsWithColor(self, *args)


    def GenerateMap(self, *args):
        """
        GenerateMap(MapColoring self, int Color) -> Map

        Epetra_Map *
        Epetra_MapColoring::GenerateMap(int Color) const

        Generates an Epetra_Map of the GIDs associated with the specified
        color.

        This method will create an Epetra_Map such that on each processor the
        GIDs associated with the specified color will be part of the map on
        that processor. Note that this method always generates an Epetra_Map,
        not an Epetra_BlockMap, even if the map associated with this map
        coloring is a block map. Once the map is generated, the user is
        responsible for deleting it. 
        """
        return _Epetra.MapColoring_GenerateMap(self, *args)


    def GenerateBlockMap(self, *args):
        """
        GenerateBlockMap(MapColoring self, int Color) -> BlockMap

        Epetra_BlockMap * Epetra_MapColoring::GenerateBlockMap(int Color)
        const

        Generates an Epetra_BlockMap of the GIDs associated with the specified
        color.

        This method will create an Epetra_BlockMap such that on each processor
        the GIDs associated with the specified color will be part of the map
        on that processor. Note that this method will generate an
        Epetra_BlockMap such that each element as the same element size as the
        corresponding element of map associated with the map coloring. Once
        the map is generated, the user is responsible for deleting it. 
        """
        return _Epetra.MapColoring_GenerateBlockMap(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_MapColoring self, BlockMap Map, int const DefaultColor=0) -> MapColoring
        __init__(Epetra_MapColoring self, MapColoring Source) -> MapColoring
        __init__(Epetra_MapColoring self, BlockMap map, int numColors, int const defaultColor=0) -> MapColoring

        Epetra_MapColoring::Epetra_MapColoring(const Epetra_MapColoring
        &Source)

        Epetra_MapColoring copy constructor. 
        """
        this = _Epetra.new_MapColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, *args):
        """__getitem__(MapColoring self, int i) -> int"""
        return _Epetra.MapColoring___getitem__(self, *args)


    def __setitem__(self, *args):
        """__setitem__(MapColoring self, int i, int color)"""
        return _Epetra.MapColoring___setitem__(self, *args)


    def ListOfColors(self, *args):
        """
        ListOfColors(MapColoring self) -> PyObject *

        int*
        Epetra_MapColoring::ListOfColors() const

        Array of length NumColors() containing List of color values used in
        this coloring.

        Color values can be arbitrary integer values. As a result, a user of a
        previously constructed MapColoring object may need to know exactly
        which color values are present. This array contains that information
        as a sorted list of integer values. 
        """
        return _Epetra.MapColoring_ListOfColors(self, *args)


    def ColorLIDList(self, *args):
        """
        ColorLIDList(MapColoring self, int color) -> PyObject *

        int *
        Epetra_MapColoring::ColorLIDList(int Color) const

        Returns pointer to array of Map LIDs associated with the specified
        color.

        Returns a pointer to a list of Map LIDs associated with the specified
        color. This is a purely local list with no information about other
        processors. If there are no LIDs associated with the specified color,
        the pointer is set to zero. 
        """
        return _Epetra.MapColoring_ColorLIDList(self, *args)


    def ElementColors(self, *args):
        """
        ElementColors(MapColoring self) -> PyObject *

        int*
        Epetra_MapColoring::ElementColors() const

        Returns pointer to array of the colors associated with the LIDs on the
        calling processor.

        Returns a pointer to the list of colors associated with the elements
        on this processor such that ElementColor[LID] is the color assigned to
        that LID. 
        """
        return _Epetra.MapColoring_ElementColors(self, *args)

MapColoring_swigregister = _Epetra.MapColoring_swigregister
MapColoring_swigregister(MapColoring)


def _extractNumPyArrayFromEpetraIntVector(*args):
    """_extractNumPyArrayFromEpetraIntVector(IntVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraIntVector(*args)
class IntVector(DistObject):
    """


    Epetra_IntVector: A class for constructing and using dense integer
    vectors on a parallel computer.

    The Epetra_IntVector class enables the construction and use of integer
    dense vectors in a distributed memory environment. The distribution of
    the dense vector is determined in part by a Epetra_Comm object and a
    Epetra_Map (or Epetra_LocalMap or Epetra_BlockMap).

    Distributed Global vs. Replicated Local Distributed Global Vectors -
    In most instances, a multi-vector will be partitioned across multiple
    memory images associated with multiple processors. In this case, there
    is a unique copy of each element and elements are spread across all
    processors specified by the Epetra_Comm communicator.

    Replicated Local Vectors - Some algorithms use vectors that are too
    small to be distributed across all processors. Replicated local
    vectors handle these types of situation.

    Constructing Epetra_IntVectors

    There are four Epetra_IntVector constructors. The first is a basic
    constructor that allocates space and sets all values to zero, the
    second is a copy constructor. The third and fourth constructors work
    with user data. These constructors have two data access modes: Copy
    mode - Allocates memory and makes a copy of the user-provided data. In
    this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the vector.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  All Epetra_IntVector constructors require a map
    argument that describes the layout of elements on the parallel
    machine. Specifically, map is a Epetra_Map, Epetra_LocalMap or
    Epetra_BlockMap object describing the desired memory layout for the
    vector.

    There are four different Epetra_IntVector constructors: Basic - All
    values are zero.

    Copy - Copy an existing vector.

    Copy from or make view of user int array.

    Extracting Data from Epetra_IntVectors

    Once a Epetra_IntVector is constructed, it is possible to extract a
    copy of the values or create a view of them.

    WARNING:  ExtractView functions are extremely dangerous from a data
    hiding perspective. For both ExtractView fuctions, there is a
    corresponding ExtractCopy function. We strongly encourage users to
    develop code using ExtractCopy functions first and only use the
    ExtractView functions in a secondary optimization phase.  There are
    two Extract functions: ExtractCopy - Copy values into a user-provided
    array.

    ExtractView - Set user-provided array to point to Epetra_IntVector
    data.

    WARNING:  A Epetra_Map, Epetra_LocalMap or Epetra_BlockMap object is
    required for all Epetra_IntVector constructors.

    C++ includes: Epetra_IntVector.h 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntVector, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_IntVector

    def PutValue(self, *args):
        """
        PutValue(IntVector self, int Value) -> int

        int
        Epetra_IntVector::PutValue(int Value)

        Set all elements of the vector to Value. 
        """
        return _Epetra.IntVector_PutValue(self, *args)


    def ExtractCopy(self, *args):
        """
        ExtractCopy(IntVector self, int * V) -> int

        int
        Epetra_IntVector::ExtractCopy(int *V) const

        Put vector values into user-provided array.

        Parameters:
        -----------

        Out:  V - Pointer to memory space that will contain the vector values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.IntVector_ExtractCopy(self, *args)


    def ExtractView(self, *args):
        """
        ExtractView(IntVector self, int ** V) -> int

        int
        Epetra_IntVector::ExtractView(int **V) const

        Set user-provided address of V.

        Parameters:
        -----------

        Out:  V - Address of a pointer to that will be set to point to the
        values of the vector.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.IntVector_ExtractView(self, *args)


    def MaxValue(self, *args):
        """
        MaxValue(IntVector self) -> int

        int
        Epetra_IntVector::MaxValue()

        Find maximum value.

        Maximum value across all processors. 
        """
        return _Epetra.IntVector_MaxValue(self, *args)


    def MinValue(self, *args):
        """
        MinValue(IntVector self) -> int

        int
        Epetra_IntVector::MinValue()

        Find minimum value.

        Minimum value across all processors. 
        """
        return _Epetra.IntVector_MinValue(self, *args)


    def MyLength(self, *args):
        """
        MyLength(IntVector self) -> int

        int
        Epetra_IntVector::MyLength() const

        Returns the local vector length on the calling processor of vectors in
        the multi-vector. 
        """
        return _Epetra.IntVector_MyLength(self, *args)


    def GlobalLength(self, *args):
        """
        GlobalLength(IntVector self) -> int

        int
        Epetra_IntVector::GlobalLength() const

        Returns the global vector length of vectors in the multi-vector. 
        """
        return _Epetra.IntVector_GlobalLength(self, *args)


    def GlobalLength64(self, *args):
        """
        GlobalLength64(IntVector self) -> long long

        long long
        Epetra_IntVector::GlobalLength64() const 
        """
        return _Epetra.IntVector_GlobalLength64(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_IntVector self, BlockMap Map, bool zeroOut=True) -> IntVector
        __init__(Epetra_IntVector self, IntVector Source) -> IntVector
        __init__(Epetra_IntVector self, Epetra_DataAccess cv, BlockMap map, PyObject * values) -> IntVector
        __init__(Epetra_IntVector self, BlockMap map, PyObject * values) -> IntVector
        __init__(Epetra_IntVector self, PyObject * values) -> IntVector

        Epetra_IntVector::Epetra_IntVector(Epetra_DataAccess CV, const
        Epetra_BlockMap &Map, int *V)

        Set vector values from user array.

        Parameters:
        -----------

        In:  Epetra_DataAccess - Enumerated type set to Copy or View.

        In:  Map - A Epetra_LocalMap, Epetra_Map or Epetra_BlockMap.

        In:  V - Pointer to an array of integer numbers..

        Integer error code, set to 0 if successful.  See Detailed Description
        section for further discussion. 
        """
        this = _Epetra.new_IntVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __distarray__(self, *args):
        """__distarray__(IntVector self) -> PyObject *"""
        return _Epetra.IntVector___distarray__(self, *args)

IntVector_swigregister = _Epetra.IntVector_swigregister
IntVector_swigregister(IntVector)


def IntVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraIntVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of IntVector" % name)
def IntVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change IntVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change IntVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
IntVector.__getattr__ = IntVector_getattr
IntVector.__setattr__ = IntVector_setattr
IntVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
IntVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
IntVector.__len__     = lambda self: self.array.__len__()
IntVector.__str__     = lambda self: self.array.__str__()
IntVector.copy        = lambda self: IntVector(self)
IntVector.ExtractCopy = lambda self: self.array.copy()
IntVector.ExtractView = lambda self: self.array
IntVector.Values      = lambda self: self.array
class_array_add_math(IntVector)
class_array_add_comp(IntVector)


def _extractNumPyArrayFromEpetraMultiVector(*args):
    """_extractNumPyArrayFromEpetraMultiVector(MultiVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraMultiVector(*args)
class MultiVector(DistObject, CompObject, BLAS):
    """


    Epetra_MultiVector: A class for constructing and using dense multi-
    vectors, vectors and matrices in parallel.

    The Epetra_MultiVector class enables the construction and use of real-
    valued, double- precision dense vectors, multi-vectors, and matrices
    in a distributed memory environment. The dimensions and distribution
    of the dense multi-vectors is determined in part by a Epetra_Comm
    object, a Epetra_Map (or Epetra_LocalMap or Epetra_BlockMap) and the
    number of vectors passed to the constructors described below.

    There are several concepts that important for understanding the
    Epetra_MultiVector class:

    Multi-vectors, Vectors and Matrices. Vector - A list of real-valued,
    double-precision numbers. Also a multi-vector with one vector.

    Multi-Vector - A collection of one or more vectors, all having the
    same length and distribution.

    (Dense) Matrix - A special form of multi-vector such that stride in
    memory between any two consecutive vectors in the multi-vector is the
    same for all vectors. This is identical to a two-dimensional array in
    Fortran and plays an important part in high performance computations.

    Distributed Global vs. Replicated Local. Distributed Global Multi-
    vectors - In most instances, a multi-vector will be partitioned across
    multiple memory images associated with multiple processors. In this
    case, there is a unique copy of each element and elements are spread
    across all processors specified by the Epetra_Comm communicator.

    Replicated Local Multi-vectors - Some algorithms use multi-vectors
    that are too small to be distributed across all processors, the
    Hessenberg matrix in a GMRES computation. In other cases, such as with
    block iterative methods, block dot product functions produce small
    dense matrices that are required by all processors. Replicated local
    multi-vectors handle these types of situation.

    Multi-vector Functions vs. Dense Matrix Functions. Multi-vector
    functions - These functions operate simultaneously but independently
    on each vector in the multi-vector and produce individual results for
    each vector.

    Dense matrix functions - These functions operate on the multi-vector
    as a matrix, providing access to selected dense BLAS and LAPACK
    operations.

    Constructing Epetra_MultiVectors

    Except for the basic constructor and copy constructor,
    Epetra_MultiVector constructors have two data access modes: Copy mode
    - Allocates memory and makes a copy of the user-provided data. In this
    case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the multi-
    vector.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  All Epetra_MultiVector constructors require a map
    argument that describes the layout of elements on the parallel
    machine. Specifically, map is a Epetra_Map, Epetra_LocalMap or
    Epetra_BlockMap object describing the desired memory layout for the
    multi-vector.

    There are six different Epetra_MultiVector constructors: Basic - All
    values are zero.

    Copy - Copy an existing multi-vector.

    Copy from or make view of two-dimensional Fortran style array.

    Copy from or make view of an array of pointers.

    Copy or make view of a list of vectors from another Epetra_MultiVector
    object.

    Copy or make view of a range of vectors from another
    Epetra_MultiVector object.

    Extracting Data from Epetra_MultiVectors

    Once a Epetra_MultiVector is constructed, it is possible to extract a
    copy of the values or create a view of them.

    WARNING:  ExtractView functions are extremely dangerous from a data
    hiding perspective. For both ExtractView fuctions, there is a
    corresponding ExtractCopy function. We strongly encourage users to
    develop code using ExtractCopy functions first and only use the
    ExtractView functions in a secondary optimization phase.  There are
    four Extract functions: ExtractCopy - Copy values into a user-provided
    two-dimensional array.

    ExtractCopy - Copy values into a user-provided array of pointers.

    ExtractView - Set user-provided two-dimensional array parameters to
    point to Epetra_MultiVector data.

    ExtractView - Set user-provided array of pointer parameters to point
    to Epetra_MultiVector data.

    Vector, Matrix and Utility Functions

    Once a Epetra_MultiVector is constructed, a variety of mathematical
    functions can be applied to the individual vectors. Specifically: Dot
    Products.

    Vector Updates.

    p Norms.

    Weighted Norms.

    Minimum, Maximum and Average Values.

    In addition, a matrix-matrix multiply function supports a variety of
    operations on any viable combination of global distributed and local
    replicated multi-vectors using calls to DGEMM, a high performance
    kernel for matrix operations. In the near future we will add support
    for calls to other selected BLAS and LAPACK functions.

    Counting Floating Point Operations

    Each Epetra_MultiVector object keep track of the number of serial
    floating point operations performed using the specified object as the
    this argument to the function. The Flops() function returns this
    number as a double precision number. Using this information, in
    conjunction with the Epetra_Time class, one can get accurate parallel
    performance numbers. The ResetFlops() function resets the floating
    point counter.

    WARNING:  A Epetra_Map, Epetra_LocalMap or Epetra_BlockMap object is
    required for all Epetra_MultiVector constructors.

    C++ includes: Epetra_MultiVector.h 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject, CompObject, BLAS]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject, CompObject, BLAS]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_MultiVector

    def ReplaceGlobalValue(self, *args):
        """
        ReplaceGlobalValue(MultiVector self, int GlobalRow, int VectorIndex, double ScalarValue) -> int
        ReplaceGlobalValue(MultiVector self, long long GlobalRow, int VectorIndex, double ScalarValue) -> int
        ReplaceGlobalValue(MultiVector self, int GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        ReplaceGlobalValue(MultiVector self, long long GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int

        int
        Epetra_MultiVector::ReplaceGlobalValue(long long GlobalBlockRow, int
        BlockRowOffset, int VectorIndex, double ScalarValue) 
        """
        return _Epetra.MultiVector_ReplaceGlobalValue(self, *args)


    def SumIntoGlobalValue(self, *args):
        """
        SumIntoGlobalValue(MultiVector self, int GlobalRow, int VectorIndex, double ScalarValue) -> int
        SumIntoGlobalValue(MultiVector self, long long GlobalRow, int VectorIndex, double ScalarValue) -> int
        SumIntoGlobalValue(MultiVector self, int GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        SumIntoGlobalValue(MultiVector self, long long GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int

        int
        Epetra_MultiVector::SumIntoGlobalValue(long long GlobalBlockRow, int
        BlockRowOffset, int VectorIndex, double ScalarValue) 
        """
        return _Epetra.MultiVector_SumIntoGlobalValue(self, *args)


    def ReplaceMyValue(self, *args):
        """
        ReplaceMyValue(MultiVector self, int MyRow, int VectorIndex, double ScalarValue) -> int
        ReplaceMyValue(MultiVector self, int MyBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int

        int
        Epetra_MultiVector::ReplaceMyValue(int MyBlockRow, int BlockRowOffset,
        int VectorIndex, double ScalarValue)

        Replace current value at the specified (MyBlockRow, BlockRowOffset,
        VectorIndex) location with ScalarValue.

        Replaces the existing value for a single entry in the multivector. The
        specified local block row and block row offset must correspond to a
        GID owned by the map of the multivector on the calling processor. In
        other words, this method does not perform cross-processor
        communication.

        Parameters:
        -----------

        In:  MyBlockRow - BlockRow of Multivector to modify in local index
        space.

        In:  BlockRowOffset - Offset into BlockRow of Multivector to modify in
        local index space.

        In:  VectorIndex - Vector within MultiVector that should to modify.

        In:  ScalarValue - Value to add to existing value.

        Integer error code, set to 0 if successful, set to 1 if MyRow not
        associated with calling processor set to -1 if VectorIndex >=
        NumVectors(), set to -2 if BlockRowOffset is out-of-range. 
        """
        return _Epetra.MultiVector_ReplaceMyValue(self, *args)


    def SumIntoMyValue(self, *args):
        """
        SumIntoMyValue(MultiVector self, int MyRow, int VectorIndex, double ScalarValue) -> int
        SumIntoMyValue(MultiVector self, int MyBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int

        int
        Epetra_MultiVector::SumIntoMyValue(int MyBlockRow, int BlockRowOffset,
        int VectorIndex, double ScalarValue)

        Adds ScalarValue to existing value at the specified (MyBlockRow,
        BlockRowOffset, VectorIndex) location.

        Sums the given value into the existing value for a single entry in the
        multivector. The specified local block row and block row offset must
        correspond to a GID owned by the map of the multivector on the calling
        processor. In other words, this method does not perform cross-
        processor communication.

        Parameters:
        -----------

        In:  MyBlockRow - BlockRow of Multivector to modify in local index
        space.

        In:  BlockRowOffset - Offset into BlockRow of Multivector to modify in
        local index space.

        In:  VectorIndex - Vector within MultiVector that should to modify.

        In:  ScalarValue - Value to add to existing value.

        Integer error code, set to 0 if successful, set to 1 if MyRow not
        associated with calling processor set to -1 if VectorIndex >=
        NumVectors(), set to -2 if BlockRowOffset is out-of-range. 
        """
        return _Epetra.MultiVector_SumIntoMyValue(self, *args)


    def PutScalar(self, *args):
        """
        PutScalar(MultiVector self, double ScalarConstant) -> int

        int
        Epetra_MultiVector::PutScalar(double ScalarConstant)

        Initialize all values in a multi-vector with constant value.

        Parameters:
        -----------

        In:  ScalarConstant - Value to use.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_PutScalar(self, *args)


    def Random(self, *args):
        """
        Random(MultiVector self) -> int

        int
        Epetra_MultiVector::Random()

        Set multi-vector values to random numbers.

        MultiVector uses the random number generator provided by Epetra_Util.
        The multi-vector values will be set to random values on the interval
        (-1.0, 1.0).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_Random(self, *args)


    def Abs(self, *args):
        """
        Abs(MultiVector self, MultiVector A) -> int

        int
        Epetra_MultiVector::Abs(const Epetra_MultiVector &A)

        Puts element-wise absolute values of input Multi-vector in target.

        Parameters:
        -----------

        In:  A - Input Multi-vector.

        Out:   this will contain the absolute values of the entries of A.

        Integer error code, set to 0 if successful.  Note: It is possible to
        use the same argument for A and this. 
        """
        return _Epetra.MultiVector_Abs(self, *args)


    def Reciprocal(self, *args):
        """
        Reciprocal(MultiVector self, MultiVector A) -> int

        int
        Epetra_MultiVector::Reciprocal(const Epetra_MultiVector &A)

        Puts element-wise reciprocal values of input Multi-vector in target.

        Parameters:
        -----------

        In:  A - Input Multi-vector.

        Out:   this will contain the element-wise reciprocal values of the
        entries of A.

        Integer error code, set to 0 if successful. Returns 2 if some entry is
        too small, but not zero. Returns 1 if some entry is zero.  Note: It is
        possible to use the same argument for A and this. Also, if a given
        value of A is smaller than Epetra_DoubleMin (defined in
        Epetra_Epetra.h), but nonzero, then the return code is 2. If an entry
        is zero, the return code is 1. However, in all cases the reciprocal
        value is still used, even if a NaN is the result. 
        """
        return _Epetra.MultiVector_Reciprocal(self, *args)


    def Scale(self, *args):
        """
        Scale(MultiVector self, double ScalarValue) -> int
        Scale(MultiVector self, double ScalarA, MultiVector A) -> int

        int
        Epetra_MultiVector::Scale(double ScalarA, const Epetra_MultiVector &A)

        Replace multi-vector values with scaled values of A, this = ScalarA*A.

        Parameters:
        -----------

        In:  ScalarA - Scale value.

        In:  A - Multi-vector to copy.

        Out:   This - Multi-vector with values overwritten by scaled values of
        A.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_Scale(self, *args)


    def Update(self, *args):
        """
        Update(MultiVector self, double ScalarA, MultiVector A, double ScalarThis) -> int
        Update(MultiVector self, double ScalarA, MultiVector A, double ScalarB, MultiVector B, double ScalarThis) -> int

        int
        Epetra_MultiVector::Update(double ScalarA, const Epetra_MultiVector
        &A, double ScalarB, const Epetra_MultiVector &B, double ScalarThis)

        Update multi-vector with scaled values of A and B, this = ScalarThis*
        this + ScalarA*A + ScalarB*B.

        Parameters:
        -----------

        In:  ScalarA - Scale value for A.

        In:  A - Multi-vector to add.

        In:  ScalarB - Scale value for B.

        In:  B - Multi-vector to add.

        In:  ScalarThis - Scale value for this.

        Out:   This - Multi-vector with updatede values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_Update(self, *args)


    def Multiply(self, *args):
        """
        Multiply(MultiVector self, char TransA, char TransB, double ScalarAB, MultiVector A, MultiVector B, double ScalarThis) -> int
        Multiply(MultiVector self, double ScalarAB, MultiVector A, MultiVector B, double ScalarThis) -> int

        int
        Epetra_MultiVector::Multiply(double ScalarAB, const Epetra_MultiVector
        &A, const Epetra_MultiVector &B, double ScalarThis)

        Multiply a Epetra_MultiVector with another, element-by-element.

        This function supports diagonal matrix multiply. A is usually a single
        vector while B and this may have one or more columns. Note that B and
        this must have the same shape. A can be one vector or have the same
        shape as B. The actual computation is this = ScalarThis * this +
        ScalarAB * B @ A where @ denotes element-wise multiplication. 
        """
        return _Epetra.MultiVector_Multiply(self, *args)


    def ReciprocalMultiply(self, *args):
        """
        ReciprocalMultiply(MultiVector self, double ScalarAB, MultiVector A, MultiVector B, double ScalarThis) -> int

        int
        Epetra_MultiVector::ReciprocalMultiply(double ScalarAB, const
        Epetra_MultiVector &A, const Epetra_MultiVector &B, double ScalarThis)

        Multiply a Epetra_MultiVector by the reciprocal of another, element-
        by-element.

        This function supports diagonal matrix scaling. A is usually a single
        vector while B and this may have one or more columns. Note that B and
        this must have the same shape. A can be one vector or have the same
        shape as B. The actual computation is this = ScalarThis * this +
        ScalarAB * B @ A where @ denotes element-wise division. 
        """
        return _Epetra.MultiVector_ReciprocalMultiply(self, *args)


    def SetSeed(self, *args):
        """
        SetSeed(MultiVector self, unsigned int Seed_in) -> int

        int
        Epetra_MultiVector::SetSeed(unsigned int Seed_in)

        Set seed for Random function.

        Parameters:
        -----------

        In:  Seed - Should be an integer on the interval (0, 2^31-1).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_SetSeed(self, *args)


    def Seed(self, *args):
        """
        Seed(MultiVector self) -> unsigned int

        unsigned int
        Epetra_MultiVector::Seed()

        Get seed from Random function.

        Current random number seed. 
        """
        return _Epetra.MultiVector_Seed(self, *args)


    def NumVectors(self, *args):
        """
        NumVectors(MultiVector self) -> int

        int
        Epetra_MultiVector::NumVectors() const

        Returns the number of vectors in the multi-vector. 
        """
        return _Epetra.MultiVector_NumVectors(self, *args)


    def MyLength(self, *args):
        """
        MyLength(MultiVector self) -> int

        int
        Epetra_MultiVector::MyLength() const

        Returns the local vector length on the calling processor of vectors in
        the multi-vector. 
        """
        return _Epetra.MultiVector_MyLength(self, *args)


    def GlobalLength(self, *args):
        """
        GlobalLength(MultiVector self) -> int

        int
        Epetra_MultiVector::GlobalLength() const

        Returns the global vector length of vectors in the multi-vector. 
        """
        return _Epetra.MultiVector_GlobalLength(self, *args)


    def GlobalLength64(self, *args):
        """
        GlobalLength64(MultiVector self) -> long long

        long long
        Epetra_MultiVector::GlobalLength64() const 
        """
        return _Epetra.MultiVector_GlobalLength64(self, *args)


    def Stride(self, *args):
        """
        Stride(MultiVector self) -> int

        int
        Epetra_MultiVector::Stride() const

        Returns the stride between vectors in the multi-vector (only
        meaningful if ConstantStride() is true). 
        """
        return _Epetra.MultiVector_Stride(self, *args)


    def ConstantStride(self, *args):
        """
        ConstantStride(MultiVector self) -> bool

        bool
        Epetra_MultiVector::ConstantStride() const

        Returns true if this multi-vector has constant stride between vectors.

        """
        return _Epetra.MultiVector_ConstantStride(self, *args)


    def ReplaceMap(self, *args):
        """
        ReplaceMap(MultiVector self, BlockMap map) -> int

        int
        Epetra_MultiVector::ReplaceMap(const Epetra_BlockMap &map)

        Replace map, only if new map has same point-structure as current map.
        return 0 if map is replaced, -1 if not. 
        """
        return _Epetra.MultiVector_ReplaceMap(self, *args)


    def Values(self, *args):
        """
        Values(MultiVector self) -> double *

        double*
        Epetra_MultiVector::Values() const

        Get pointer to MultiVector values. 
        """
        return _Epetra.MultiVector_Values(self, *args)


    def Reduce(self, *args):
        """
        Reduce(MultiVector self) -> int

        int
        Epetra_MultiVector::Reduce() 
        """
        return _Epetra.MultiVector_Reduce(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_MultiVector self, BlockMap Map, int NumVectors, bool zeroOut=True) -> MultiVector
        __init__(Epetra_MultiVector self, MultiVector Source) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess CV, BlockMap Map, double ** ArrayOfPointers, int NumVectors) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess CV, MultiVector Source, int * Indices) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess CV, MultiVector Source, int StartIndex, int NumVectors) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess cv, BlockMap map, PyObject * values, int numVectors) -> MultiVector
        __init__(Epetra_MultiVector self, BlockMap map, PyObject * obj) -> MultiVector
        __init__(Epetra_MultiVector self, PyObject * obj) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess cv, MultiVector source) -> MultiVector

        Epetra_MultiVector::Epetra_MultiVector(Epetra_DataAccess CV, const
        Epetra_MultiVector &Source, int StartIndex, int NumVectors)

        Set multi-vector values from range of vectors in an existing
        Epetra_MultiVector.

        Parameters:
        -----------

        In:  Epetra_DataAccess - Enumerated type set to Copy or View.

        In:  Source - An existing fully constructed Epetra_MultiVector.

        In:  StartIndex - First of the vectors to copy.

        In:  NumVectors - Number of vectors in multi-vector.

        Integer error code, set to 0 if successful.  See Detailed Description
        section for further discussion. 
        """
        this = _Epetra.new_MultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Dot(self, *args):
        """
        Dot(MultiVector self, MultiVector a) -> PyObject *

        int
        Epetra_MultiVector::Dot(const Epetra_MultiVector &A, double *Result)
        const

        Computes dot product of each corresponding pair of vectors.

        Parameters:
        -----------

        In:  A - Multi-vector to be used with the "\\e this" multivector.

        Out:  Result - Result[i] will contain the ith dot product result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_Dot(self, *args)


    def Norm1(self, *args):
        """
        Norm1(MultiVector self) -> PyObject *

        int
        Epetra_MultiVector::Norm1(double *Result) const

        Compute 1-norm of each vector in multi-vector.

        Parameters:
        -----------

        Out:  Result - Result[i] contains 1-norm of ith vector.

        WARNING:  Map of the this multivector must have unique GIDs
        (UniqueGIDs() must return true).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_Norm1(self, *args)


    def Norm2(self, *args):
        """
        Norm2(MultiVector self) -> PyObject *

        int
        Epetra_MultiVector::Norm2(double *Result) const

        Compute 2-norm of each vector in multi-vector.

        Parameters:
        -----------

        Out:  Result - Result[i] contains 2-norm of ith vector.

        WARNING:  Map of the this multivector must have unique GIDs
        (UniqueGIDs() must return true).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_Norm2(self, *args)


    def NormInf(self, *args):
        """
        NormInf(MultiVector self) -> PyObject *

        int
        Epetra_MultiVector::NormInf(double *Result) const

        Compute Inf-norm of each vector in multi-vector.

        Parameters:
        -----------

        Out:  Result - Result[i] contains Inf-norm of ith vector.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_NormInf(self, *args)


    def NormWeighted(self, *args):
        """
        NormWeighted(MultiVector self, MultiVector weights) -> PyObject *

        int
        Epetra_MultiVector::NormWeighted(const Epetra_MultiVector &Weights,
        double *Result) const

        Compute Weighted 2-norm (RMS Norm) of each vector in multi-vector.

        Parameters:
        -----------

        In:  Weights - Multi-vector of weights. If Weights contains a single
        vector, that vector will be used as the weights for all vectors of
        this. Otherwise, Weights should have the same number of vectors as
        this.

        Out:  Result - Result[i] contains the weighted 2-norm of ith vector.
        Specifically if we denote the ith vector in the multivector by $x$,
        and the ith weight vector by $w$ and let j represent the jth entry of
        each vector, on return Result[i] will contain the following result:
        \\[\\sqrt{(1/n)\\sum_{j=1}^n(x_j/w_j)^2}\\], where $n$ is the
        global length of the vectors.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_NormWeighted(self, *args)


    def MinValue(self, *args):
        """
        MinValue(MultiVector self) -> PyObject *

        int
        Epetra_MultiVector::MinValue(double *Result) const

        Compute minimum value of each vector in multi-vector.

        Note that the vector contents must be already initialized for this
        function to compute a well-defined result. The length of the vector
        need not be greater than zero on all processors. If length is greater
        than zero on any processor then a valid result will be computed.

        Parameters:
        -----------

        Out:  Result - Result[i] contains minimum value of ith vector.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_MinValue(self, *args)


    def MaxValue(self, *args):
        """
        MaxValue(MultiVector self) -> PyObject *

        int
        Epetra_MultiVector::MaxValue(double *Result) const

        Compute maximum value of each vector in multi-vector.

        Note that the vector contents must be already initialized for this
        function to compute a well-defined result. The length of the vector
        need not be greater than zero on all processors. If length is greater
        than zero on any processor then a valid result will be computed.

        Parameters:
        -----------

        Out:  Result - Result[i] contains maximum value of ith vector.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_MaxValue(self, *args)


    def MeanValue(self, *args):
        """
        MeanValue(MultiVector self) -> PyObject *

        int
        Epetra_MultiVector::MeanValue(double *Result) const

        Compute mean (average) value of each vector in multi-vector.

        Parameters:
        -----------

        Out:  Result - Result[i] contains mean value of ith vector.

        WARNING:  Map of the this multivector must have unique GIDs
        (UniqueGIDs() must return true).

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.MultiVector_MeanValue(self, *args)


    def __call__(self, *args):
        """__call__(MultiVector self, int i) -> Vector"""
        return _Epetra.MultiVector___call__(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector___distarray__(self, *args)

MultiVector_swigregister = _Epetra.MultiVector_swigregister
MultiVector_swigregister(MultiVector)


def MultiVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraMultiVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of MultiVector" % name)
def MultiVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change MultiVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change MultiVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
def MultiVector_getitem(self,i):
    if isinstance(i,int):
        return self.__call__(i)
    else:
        return self.array.__getitem__(i)
MultiVector.__getattr__ = MultiVector_getattr
MultiVector.__setattr__ = MultiVector_setattr
MultiVector.__getitem__ = MultiVector_getitem
MultiVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
MultiVector.__len__     = lambda self: self.array.__len__()
MultiVector.__str__     = lambda self: self.array.__str__()
MultiVector.copy        = lambda self: MultiVector(self)
MultiVector.ExtractCopy = lambda self: self.array.copy()
MultiVector.ExtractView = lambda self: self.array
class_array_add_math(MultiVector)
class_array_add_comp(MultiVector)


def _extractNumPyArrayFromEpetraVector(*args):
    """_extractNumPyArrayFromEpetraVector(Vector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraVector(*args)
class Vector(MultiVector):
    """


    Epetra_Vector: A class for constructing and using dense vectors on a
    parallel computer.

    The Epetra_Vector class enables the construction and use of real-
    valued, double- precision dense vectors in a distributed memory
    environment. The distribution of the dense vector is determined in
    part by a Epetra_Comm object and a Epetra_Map (or Epetra_LocalMap or
    Epetra_BlockMap).

    This class is derived from the Epetra_MultiVector class. As such, it
    has full access to all of the functionality provided in the
    Epetra_MultiVector class.

    Distributed Global vs. Replicated Local Distributed Global Vectors -
    In most instances, a multi-vector will be partitioned across multiple
    memory images associated with multiple processors. In this case, there
    is a unique copy of each element and elements are spread across all
    processors specified by the Epetra_Comm communicator.

    Replicated Local Vectors - Some algorithms use vectors that are too
    small to be distributed across all processors. Replicated local
    vectors handle these types of situation.

    Constructing Epetra_Vectors

    There are four Epetra_Vector constructors. The first is a basic
    constructor that allocates space and sets all values to zero, the
    second is a copy constructor. The third and fourth constructors work
    with user data. These constructors have two data access modes: Copy
    mode - Allocates memory and makes a copy of the user-provided data. In
    this case, the user data is not needed after construction.

    View mode - Creates a "view" of the user data. In this case, the
    user data is required to remain intact for the life of the vector.

    WARNING:  View mode is extremely dangerous from a data hiding
    perspective. Therefore, we strongly encourage users to develop code
    using Copy mode first and only use the View mode in a secondary
    optimization phase.  All Epetra_Vector constructors require a map
    argument that describes the layout of elements on the parallel
    machine. Specifically, map is a Epetra_Map, Epetra_LocalMap or
    Epetra_BlockMap object describing the desired memory layout for the
    vector.

    There are four different Epetra_Vector constructors: Basic - All
    values are zero.

    Copy - Copy an existing vector.

    Copy from or make view of user double array.

    Copy or make view of a vector from a Epetra_MultiVector object.

    Extracting Data from Epetra_Vectors

    Once a Epetra_Vector is constructed, it is possible to extract a copy
    of the values or create a view of them.

    WARNING:  ExtractView functions are extremely dangerous from a data
    hiding perspective. For both ExtractView fuctions, there is a
    corresponding ExtractCopy function. We strongly encourage users to
    develop code using ExtractCopy functions first and only use the
    ExtractView functions in a secondary optimization phase.  There are
    two Extract functions: ExtractCopy - Copy values into a user-provided
    array.

    ExtractView - Set user-provided array to point to Epetra_Vector data.

    Vector and Utility Functions

    Once a Epetra_Vector is constructed, a variety of mathematical
    functions can be applied to the vector. Specifically: Dot Products.

    Vector Updates.

    p Norms.

    Weighted Norms.

    Minimum, Maximum and Average Values.

    The final useful function is Flops(). Each Epetra_Vector object keep
    track of the number of serial floating point operations performed
    using the specified object as the this argument to the function. The
    Flops() function returns this number as a double precision number.
    Using this information, in conjunction with the Epetra_Time class, one
    can get accurate parallel performance numbers.

    WARNING:  A Epetra_Map, Epetra_LocalMap or Epetra_BlockMap object is
    required for all Epetra_Vector constructors.

    C++ includes: Epetra_Vector.h 
    """

    __swig_setmethods__ = {}
    for _s in [MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_Vector

    def __init__(self, *args):
        """
        __init__(Epetra_Vector self, BlockMap Map, bool zeroOut=True) -> Vector
        __init__(Epetra_Vector self, Vector Source) -> Vector
        __init__(Epetra_Vector self, Epetra_DataAccess CV, MultiVector Source, int Index) -> Vector
        __init__(Epetra_Vector self, Epetra_DataAccess cv, BlockMap map, PyObject * values) -> Vector
        __init__(Epetra_Vector self, BlockMap map, PyObject * obj) -> Vector
        __init__(Epetra_Vector self, PyObject * obj) -> Vector
        __init__(Epetra_Vector self, Epetra_DataAccess cv, Vector source) -> Vector

        Epetra_Vector::Epetra_Vector(Epetra_DataAccess CV, const
        Epetra_MultiVector &Source, int Index)

        Set vector values from a vector in an existing Epetra_MultiVector.

        Parameters:
        -----------

        In:  Epetra_DataAccess - Enumerated type set to Copy or View.

        In:  Map - A Epetra_LocalMap, Epetra_Map or Epetra_BlockMap.

        In:  Source - An existing fully constructed Epetra_MultiVector.

        In:  Index - Index of vector to access.

        Integer error code, set to 0 if successful.  See Detailed Description
        section for further discussion. 
        """
        this = _Epetra.new_Vector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ReplaceGlobalValues(self, *args):
        """
        ReplaceGlobalValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        ReplaceGlobalValues(Vector self, int NumEntries, double const * Values, long long const * Indices) -> int
        ReplaceGlobalValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        ReplaceGlobalValues(Vector self, PyObject * values, PyObject * indices) -> int
        ReplaceGlobalValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int

        int
        Epetra_Vector::ReplaceGlobalValues(int NumEntries, int BlockOffset,
        const double *Values, const int *Indices)

        Replace values in a vector with a given indexed list of values at the
        specified BlockOffset, indices are in global index space.

        Replace the Indices[i] entry in the this object with Values[i], for
        i=0; i<NumEntries. The indices are in global index space. This method
        is intended for vector that are defined using block maps. In this
        situation, an index value is associated with one or more vector
        entries, depending on the element size of the given index. The
        BlockOffset argument indicates which vector entry to modify as an
        offset from the first vector entry associated with the given index.
        The offset is used for each entry in the input list.

        Parameters:
        -----------

        In:  NumEntries - Number of vector entries to modify.

        In:  BlockOffset - Offset from the first vector entry associated with
        each of the given indices.

        In:  Values - Values which will replace existing values in vector, of
        length NumEntries.

        In:  Indices - Indices in global index space corresponding to Values.

        Integer error code, set to 0 if successful, set to 1 if one or more
        indices are not associated with calling processor. 
        """
        return _Epetra.Vector_ReplaceGlobalValues(self, *args)


    def ReplaceMyValues(self, *args):
        """
        ReplaceMyValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        ReplaceMyValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        ReplaceMyValues(Vector self, PyObject * values, PyObject * indices) -> int
        ReplaceMyValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int

        int
        Epetra_Vector::ReplaceMyValues(int NumEntries, int BlockOffset, const
        double *Values, const int *Indices)

        Replace values in a vector with a given indexed list of values at the
        specified BlockOffset, indices are in local index space.

        Replace the (Indices[i], BlockOffset) entry in the this object with
        Values[i], for i=0; i<NumEntries. The indices are in local index
        space. This method is intended for vector that are defined using block
        maps. In this situation, an index value is associated with one or more
        vector entries, depending on the element size of the given index. The
        BlockOffset argument indicates which vector entry to modify as an
        offset from the first vector entry associated with the given index.
        The offset is used for each entry in the input list.

        Parameters:
        -----------

        In:  NumEntries - Number of vector entries to modify.

        In:  BlockOffset - Offset from the first vector entry associated with
        each of the given indices.

        In:  Values - Values which will replace existing values in vector, of
        length NumEntries.

        In:  Indices - Indices in local index space corresponding to Values.

        Integer error code, set to 0 if successful, set to 1 if one or more
        indices are not associated with calling processor. 
        """
        return _Epetra.Vector_ReplaceMyValues(self, *args)


    def SumIntoGlobalValues(self, *args):
        """
        SumIntoGlobalValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        SumIntoGlobalValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        SumIntoGlobalValues(Vector self, PyObject * values, PyObject * indices) -> int
        SumIntoGlobalValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int

        int
        Epetra_Vector::SumIntoGlobalValues(int NumEntries, int BlockOffset,
        const double *Values, const int *Indices)

        Sum values into a vector with a given indexed list of values at the
        specified BlockOffset, indices are in global index space.

        Sum Values[i] into the Indices[i] entry in the this object, for i=0;
        i<NumEntries. The indices are in global index space. This method is
        intended for vector that are defined using block maps. In this
        situation, an index value is associated with one or more vector
        entries, depending on the element size of the given index. The
        BlockOffset argument indicates which vector entry to modify as an
        offset from the first vector entry associated with the given index.
        The offset is used for each entry in the input list.

        Parameters:
        -----------

        In:  NumEntries - Number of vector entries to modify.

        In:  BlockOffset - Offset from the first vector entry associated with
        each of the given indices.

        In:  Values - Values which will replace existing values in vector, of
        length NumEntries.

        In:  Indices - Indices in global index space corresponding to Values.

        Integer error code, set to 0 if successful, set to 1 if one or more
        indices are not associated with calling processor. 
        """
        return _Epetra.Vector_SumIntoGlobalValues(self, *args)


    def SumIntoMyValues(self, *args):
        """
        SumIntoMyValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        SumIntoMyValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        SumIntoMyValues(Vector self, PyObject * values, PyObject * indices) -> int
        SumIntoMyValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int

        int
        Epetra_Vector::SumIntoMyValues(int NumEntries, int BlockOffset, const
        double *Values, const int *Indices)

        Sum values into a vector with a given indexed list of values at the
        specified BlockOffset, indices are in local index space.

        Sum Values[i] into the Indices[i] entry in the this object, for i=0;
        i<NumEntries. The indices are in local index space. This method is
        intended for vector that are defined using block maps. In this
        situation, an index value is associated with one or more vector
        entries, depending on the element size of the given index. The
        BlockOffset argument indicates which vector entry to modify as an
        offset from the first vector entry associated with the given index.
        The offset is used for each entry in the input list.

        Parameters:
        -----------

        In:  NumEntries - Number of vector entries to modify.

        In:  BlockOffset - Offset from the first vector entry associated with
        each of the given indices.

        In:  Values - Values which will replace existing values in vector, of
        length NumEntries.

        In:  Indices - Indices in local index space corresponding to Values.

        Integer error code, set to 0 if successful, set to 1 if one or more
        indices are not associated with calling processor. 
        """
        return _Epetra.Vector_SumIntoMyValues(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector self) -> PyObject *"""
        return _Epetra.Vector___distarray__(self, *args)

Vector_swigregister = _Epetra.Vector_swigregister
Vector_swigregister(Vector)


def Vector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of Vector" % name)
def Vector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change Vector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change Vector 'dtype' attribute")
    else:
        self.__dict__[name] = value
Vector.__getattr__ = Vector_getattr
Vector.__setattr__ = Vector_setattr
Vector.__getitem__ = lambda self, i: self.array.__getitem__(i)
Vector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
Vector.__len__     = lambda self: self.array.__len__()
Vector.__str__     = lambda self: self.array.__str__()
Vector.copy        = lambda self: Vector(self)
Vector.ExtractCopy = lambda self: self.array.copy()
Vector.ExtractView = lambda self: self.array
class_array_add_math(Vector)
class_array_add_comp(Vector)


def _extractNumPyArrayFromEpetraFEVector(*args):
    """_extractNumPyArrayFromEpetraFEVector(FEVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraFEVector(*args)
class FEVector(MultiVector):
    """


    Epetra Finite-Element Vector. This class inherits Epetra_MultiVector
    and thus provides all Epetra_MultiVector functionality.

    The added functionality provided by Epetra_FEVector is the ability to
    perform finite-element style vector assembly. It accepts sub-vector
    contributions, such as those that would come from element-load
    vectors, etc. These sub-vectors need not be owned by the local
    processor. In other words, the user can assemble overlapping data
    (e.g., corresponding to shared finite-element nodes). When the user is
    finished assembling their vector data, they then call the method
    Epetra_FEVector::GlobalAssemble() which gathers the overlapping data
    (all non-local data that was input on each processor) into the data-
    distribution specified by the map with which the Epetra_FEVector was
    constructed.

    C++ includes: Epetra_FEVector.h 
    """

    __swig_setmethods__ = {}
    for _s in [MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FEVector, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FEVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_FEVector

    def GlobalAssemble(self, *args):
        """
        GlobalAssemble(FEVector self, Epetra_CombineMode mode=Add, bool reuse_map_and_exporter=False) -> int

        int
        Epetra_FEVector::GlobalAssemble(Epetra_CombineMode mode=Add, bool
        reuse_map_and_exporter=false)

        Gather any overlapping/shared data into the non-overlapping
        partitioning defined by the Map that was passed to this vector at
        construction time. Data imported from other processors is stored on
        the owning processor with a "sumInto" or accumulate operation. This
        is a collective method every processor must enter it before any will
        complete it.

        Optimization for power-users: The optional parameter
        'reuse_map_and_exporter' defaults to false. By default, a map that
        describes the non-local data is re-created at each call to
        GlobalAssemble, along with an exporter used to do the communication.
        This is expensive. If you know that the layout of your nonlocal data
        has not changed since your previous call to GlobalAssemble, you can
        set this flag to true and it will reuse the previously created map and
        exporter rather than creating new ones. 
        """
        return _Epetra.FEVector_GlobalAssemble(self, *args)


    def setIgnoreNonLocalEntries(self, *args):
        """
        setIgnoreNonLocalEntries(FEVector self, bool flag)

        void Epetra_FEVector::setIgnoreNonLocalEntries(bool flag)

        Set whether or not non-local data values should be ignored. 
        """
        return _Epetra.FEVector_setIgnoreNonLocalEntries(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_FEVector self, BlockMap Map, int numVectors=1, bool ignoreNonLocalEntries=False) -> FEVector
        __init__(Epetra_FEVector self, Epetra_DataAccess CV, BlockMap Map, double ** ArrayOfPointers, int NumVectors, bool ignoreNonLocalEntries=False) -> FEVector
        __init__(Epetra_FEVector self, FEVector source) -> FEVector
        __init__(Epetra_FEVector self, Epetra_DataAccess cv, BlockMap map, PyObject * values, int numVectors, bool ignoreNonLocalEntries=False) -> FEVector

        Epetra_FEVector::Epetra_FEVector(const Epetra_FEVector &source)

        Copy constructor. 
        """
        this = _Epetra.new_FEVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ReplaceGlobalValues(self, *args):
        """
        ReplaceGlobalValues(FEVector self, int numIDs, int const * GIDs, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, int numIDs, long long const * GIDs, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, IntSerialDenseVector GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, Epetra_LongLongSerialDenseVector const & GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, int numIDs, int const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, int numIDs, long long const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, PyObject * gids, PyObject * values, int vectorId=0) -> int

        int
        Epetra_FEVector::ReplaceGlobalValues(int numIDs, const long long
        *GIDs, const int *numValuesPerID, const double *values, int
        vectorIndex=0) 
        """
        return _Epetra.FEVector_ReplaceGlobalValues(self, *args)


    def SumIntoGlobalValues(self, *args):
        """
        SumIntoGlobalValues(FEVector self, int numIDs, int const * GIDs, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, int numIDs, long long const * GIDs, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, IntSerialDenseVector GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, Epetra_LongLongSerialDenseVector const & GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, int numIDs, int const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, int numIDs, long long const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, PyObject * gids, PyObject * values, int vectorId=0) -> int

        int
        Epetra_FEVector::SumIntoGlobalValues(int numIDs, const long long
        *GIDs, const int *numValuesPerID, const double *values, int
        vectorIndex=0) 
        """
        return _Epetra.FEVector_SumIntoGlobalValues(self, *args)


    def __distarray__(self, *args):
        """__distarray__(FEVector self) -> PyObject *"""
        return _Epetra.FEVector___distarray__(self, *args)

FEVector_swigregister = _Epetra.FEVector_swigregister
FEVector_swigregister(FEVector)


def FEVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraFEVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of FEVector" % name)
def FEVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change FEVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change FEVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
FEVector.__getattr__ = FEVector_getattr
FEVector.__setattr__ = FEVector_setattr
FEVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
FEVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i, v)
FEVector.__len__     = lambda self: self.array.__len__()
FEVector.__str__     = lambda self: self.array.__str__()
FEVector.copy        = lambda self: Vector(self)
FEVector.ExtractCopy = lambda self: self.array.copy()
FEVector.ExtractView = lambda self: self.array
class_array_add_math(FEVector)
class_array_add_comp(FEVector)

class CrsGraph(DistObject):
    """


    Epetra_CrsGraph: A class for constructing and using sparse compressed
    row graphs.

    Epetra_CrsGraph enables the piecewise construction and use of sparse
    matrix graphs (the integer structure without values) where entries are
    intended for row access.

    Epetra_CrsGraph is an attribute of all Epetra row-based matrix
    classes, defining their nonzero structure and also holding their
    Epetra_Map attributes.

    Constructing Epetra_CrsGraph objects

    Constructing Epetra_CrsGraph objects is a multi-step process. The
    basic steps are as follows: Create Epetra_CrsGraph instance, including
    some initial storage, via constructor. In addition to the copy
    constructor, Epetra_CrsGraph has four different constructors. All four
    of these constructors have an argument, StaticProfile, which by
    default is set to false. If it is set to true, then the profile (the
    number of indices per row as defined by NumIndicesPerRow) will be
    rigidly enforced. Although this takes away flexibility, it allows a
    single array to be allocated for all indices. This decreases memory
    fragmentation and improves performance across many operations. A more
    detailed discussion of the StaticProfile option is found below. User-
    provided row map, variable nonzero profile: This constructor is used
    to define the row distribution of the graph and specify a varying
    number of nonzero entries per row. It is best to use this constructor
    when the user will be inserting entries using global index values and
    wants every column index to be included in the graph. Note that in
    this case, the column map will be built for the user when
    FillComplete() is called. This constructor is also appropriate for
    when there is a large variation in the number of indices per row. If
    this is not the case, the next constructor may be more convenient to
    use.

    User-provided row map, fixed nonzero profile: This constructor is used
    to define the row distribution of the graph and specify a fixed number
    of nonzero entries per row. It is best to use this constructor when
    the user will be inserting entries using global index values and wants
    every column index to be included in the graph. Note that in this
    case, the column map will be built for the user when FillComplete() is
    called. This constructor is also appropriate for when there is little
    or no variation in the number of indices per row.

    User-provided row map, user-provided column map and variable nonzero
    profile: This constructor is used to define the row and column
    distribution of the graph, and specify a varying number of nonzero
    entries per row. It is best to use this constructor when the user will
    be inserting entries and already knows which columns of the matrix
    should be included on each processor. Note that in this case, the
    column map will not be built for the user when FillComplete() is
    called. Also, if the user attempts to insert a column index whose GID
    is not part of the column map on that process, the index will be
    discarded. This property can be used to "filter out" column entries
    that should be ignored. This constructor is also appropriate for when
    there is a large variation in the number of indices per row. If this
    is not the case, the next constructor may be more convenient to use.

    User-provided row map, user-provided column map and fixed nonzero
    profile: This constructor is used to define the row and column
    distribution of the graph, and specify a fixed number of nonzero
    entries per row. It is best to use this constructor when the user will
    be inserting entries and already knows which columns of the matrix
    should be included on each processor. Note that in this case, the
    column map will not be built for the user when FillComplete() is
    called. Also, if the user attempts to insert a column index whose GID
    is not part of the column map on that process, the index will be
    discarded. This constructor is also appropriate for when there is
    little or no variation in the number of indices per row.

    Enter row and column entry information via calls to the
    InsertGlobalIndices method.

    Complete construction via FillComplete call, which performs the
    following tasks: Transforms indices to local index space (after this,
    IndicesAreLocal()==true)

    Sorts column-indices within each row

    Compresses out any redundant indices within rows

    Computes global data such as num-nonzeros, maximum row-lengths, etc.

    (Optional) Optimize the graph storage via a call to OptimizeStorage.

    Performance Enhancement Issues

    The Epetra_CrsGraph class attempts to address four basic types of
    situations, depending on the user's primary concern:

    Simple, flexible construction over minimal memory use or control of
    column indices: In this case the user wants to provide only a row
    distribution of the graph and insert indices without worrying about
    memory allocation performance. This type of user is best served by the
    constructor that requires only a row map, and a fixed number of
    indices per row. In fact, setting NumIndicesPerRow=0 is probably the
    best option.

    Stronger control over memory allocation performance and use over
    flexibility and simplicity: In this case the user explicitly set
    StaticProfile to true and will provide values, either a single global
    int or an array of int's, for NumIndicesPerRow, such that the actual
    number of indices submitted to the graph will not exceed the
    estimates. Because we know that NumIndicesPerRow will not be exceeded,
    we can pre-allocate all of the storage for the graph as a single
    array. This is typically much more efficient.

    Explicit control over column indices: In this case the user prescribes
    the column map. Given the column map, any index that is submitted for
    entry into the graph will be included only if they are present in the
    list of GIDs for the column map on the processor that submits the
    index. This feature allows the user to define a filter such that only
    certain columns will be kept. The user also prescribes the local
    ordering via this technique, since the ordering of GIDs in the column
    map imposes the local ordering.

    Construction using local indices only: In some situations, users may
    want to build a graph using local index values only. In this case, the
    user must explicitly assign GIDs. This is done by prescribing the
    column map, in the same way as the previous situation.

    Notes: In all but the most advanced uses, users will typically not
    specify the column map. In other words, graph entries will be
    submitted using GIDs not LIDs and all entries that are submitted are
    intended to be inserted into the graph.

    If a user is not particularly worried about performance, or really
    needs the flexibility associated with the first situation, then there
    is no need to explicitly manage the NumIndicesPerRow values or set
    StaticProfile to true. In this case, it is best to set
    NumIndicesPerRow to zero.

    Users who are concerned about performance should carefully manage
    NumIndicesPerRow and set StaticProfile to true. This will give the
    best performance and use the least amount of memory.

    A compromise approach would be to not set StaticProfile to true,
    giving the user flexibility, but then calling OptimizeStorage() once
    FillComplete() has been called. This approach requires additional
    temporary memory because the graph will be copied into an efficient
    data structure and the old memory deleted. However, once the copy has
    been made, the resulting data structure is as efficient as when
    StaticProfile is used.

    Epetra_Map attributes

    Epetra_CrsGraph objects have four Epetra_Map attributes.

    The Epetra_Map attributes can be obtained via these accessor methods:
    RowMap() Describes the numbering and distribution of the rows of the
    graph. The row-map exists and is valid for the entire life of the
    graph, having been passed in as a constructor argument. The set of
    graph rows is defined by the row-map and may not be changed. Rows may
    not be inserted or deleted by the user. The only change that may be
    made is that the user can replace the row-map with a compatible row-
    map (which is the same except for re-numbering) by calling the
    ReplaceRowMap() method.

    ColMap() Describes the set of column-indices that appear in the rows
    in each processor's portion of the graph. Unless provided by the user
    at construction time, a valid column-map doesn't exist until
    FillComplete() is called.

    RangeMap() Describes the range of the matrix operator. e.g., for a
    matrix-vector product operation, the result vector's map must be
    compatible with the range-map of the matrix operator. The range-map is
    usually the same as the row-map. The range-map is set equal to the
    row-map at graph creation time, but may be specified by the user when
    FillComplete() is called.

    DomainMap() Describes the domain of the matrix operator. The domain-
    map can be specified by the user when FillComplete() is called. Until
    then, it is set equal to the row-map.

    It is important to note that while the row-map and the range-map are
    often the same, the column-map and the domain-map are almost never the
    same. The set of entries in a distributed column-map almost always
    form overlapping sets, with entries being associated with more than
    one processor. A domain-map, on the other hand, must be a 1-to-1 map,
    with entries being associated with only a single processor.

    Global versus Local indices

    After creation and before FillComplete() has been called, the column-
    indices of the graph are in the global space as received from the
    user. One of the tasks performed by FillComplete() is to transform the
    indices to a local index space. The query methods IndicesAreGlobal()
    and IndicesAreLocal() return true or false depending on whether this
    transformation has been performed or not.

    Note the behavior of several graph methods:  InsertGlobalIndices()
    returns an error if IndicesAreLocal()==true or
    StorageOptimized()==true

    InsertMyIndices() returns an error if IndicesAreGlobal()==true or
    StorageOptimized()==true

    RemoveGlobalIndices() returns an error if IndicesAreLocal()==true or
    if graph was constructed in View mode

    RemoveMyIndices() returns an error if IndicesAreGlobal()==true or if
    graph was constructed in View mode

    ExtractGlobalRowCopy() works regardless of state of indices

    ExtractMyRowCopy() returns an error if IndicesAreGlobal()==true

    ExtractGlobalRowView() returns an error if IndicesAreLocal()==true

    ExtractMyRowView() returns an error if IndicesAreGlobal()==true

    Note that even after a graph is constructed, it is possible to add or
    remove entries. However, FillComplete must then be called again to
    restore the graph to a consistent state.

    C++ includes: Epetra_CrsGraph.h 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_CrsGraph

    def InsertGlobalIndices(self, *args):
        """
        InsertGlobalIndices(self, int globalRow, PySequence indices) -> int

        Insert a sequence of global indices into the set of nonzero columns
        for the specified global row.  Argument indices can be a numpy array
        of integers or any python sequence that can be converted to a numpy
        array of integers.  The integers represent global IDs that are to be
        inserted into the graph.  An integer error/warning code is returned.

        InsertGlobalIndices(self, int globalRow, PySequence indices) -> int

        Insert a sequence of global indices into the set of nonzero columns
        for the specified global row.  Argument indices can be a numpy array
        of integers or any python sequence that can be converted to a numpy
        array of integers.  The integers represent global IDs that are to be
        inserted into the graph.  An integer error/warning code is returned.


        int
        Epetra_CrsGraph::InsertGlobalIndices(long long GlobalRow, int
        NumIndices, long long *Indices) 
        """
        return _Epetra.CrsGraph_InsertGlobalIndices(self, *args)


    def RemoveGlobalIndices(self, *args):
        """
        RemoveGlobalIndices(self, int globalRow, PySequence indices) -> int

        Remove a sequence of global indices from the set of nonzero columns
        for the specified global row.  Argument indices can be a numpy array
        of integers or any python sequence that can be converted to a numpy
        array of integers.  The integers represent global IDs that are to be
        removed from the graph.  An integer error/warning code is returned.

        RemoveGlobalIndices(CrsGraph self, long long GlobalRow, int NumIndices, long long * Indices) -> int
        RemoveGlobalIndices(CrsGraph self, long long Row) -> int

        int
        Epetra_CrsGraph::RemoveGlobalIndices(long long Row)

        Remove all indices from a specified global row of the graph.

        Parameters:
        -----------

        Row:  - (In) Global row number of indices.

        Integer error code, set to 0 if successful. Returns 1 if data is
        shared.

        IndicesAreGlobal()==true, StorageOptimized()==false 
        """
        return _Epetra.CrsGraph_RemoveGlobalIndices(self, *args)


    def InsertMyIndices(self, *args):
        """
        InsertMyIndices(self, int localRow, PySequence indices) -> int

        Insert a sequence of local indices into the set of nonzero columns for
        the specified local row.  Argument indices can be a numpy array of
        integers or any python sequence that can be converted to a numpy array
        of integers.  The integers represent local IDs that are to be inserted
        into the graph.  An integer error/warning code is returned.


        int
        Epetra_CrsGraph::InsertMyIndices(int LocalRow, int NumIndices, int
        *Indices)

        Enter a list of elements in a specified local row of the graph.

        Parameters:
        -----------

        Row:  - (In) Local row number of indices.

        NumIndices:  - (In) Number of Indices.

        Indices:  - (In) Local column indices to insert.

        Integer error code, set to 0 if successful. If the insertion requires
        that additional memory be allocated for the row, a positive error code
        of 1 is returned. If one or more of the indices is ignored (due to not
        being contained in the column-map), then a positive warning code of 2
        is returned. If the graph is a 'View' mode graph, then a positive
        warning code of 3 will be returned if the specified row already
        exists. Returns 1 if underlying graph data is shared by multiple graph
        instances.

        IndicesAreLocal()==true, StorageOptimized()==false 
        """
        return _Epetra.CrsGraph_InsertMyIndices(self, *args)


    def RemoveMyIndices(self, *args):
        """
        RemoveMyIndices(self, int localRow, PySequence indices) -> int

        Remove a sequence of local indices from the set of nonzero columns for
        the specified local row.  Argument indices can be a numpy array of
        integers or any python sequence that can be converted to a numpy array
        of integers.  The integers represent local IDs that are to be removed
        from the graph.  An integer error/warning code is returned.

        RemoveMyIndices(CrsGraph self, int Row) -> int

        int
        Epetra_CrsGraph::RemoveMyIndices(int Row)

        Remove all indices from a specified local row of the graph.

        Parameters:
        -----------

        Row:  - (In) Local row number of indices.

        Integer error code, set to 0 if successful. Returns 1 if data is
        shared.

        IndicesAreLocal()==true, StorageOptimized()==false 
        """
        return _Epetra.CrsGraph_RemoveMyIndices(self, *args)


    def FillComplete(self, *args):
        """
        FillComplete(CrsGraph self) -> int
        FillComplete(CrsGraph self, BlockMap DomainMap, BlockMap RangeMap) -> int

        int
        Epetra_CrsGraph::FillComplete(const Epetra_BlockMap &DomainMap, const
        Epetra_BlockMap &RangeMap)

        Transform to local index space using specified Domain/Range maps.
        Perform other operations to allow optimal matrix operations.

        Performs this sequence of operations: Transform indices to local index
        space

        Sort column-indices within each row

        Compress out any redundant indices within rows

        Compute global data such as num-nonzeros, maximum row-lengths, etc.

        Integer error code, set to 0 if successful. Returns 1 if data is
        shared (i.e., if the underlying graph-data object has a reference-
        count greater than 1).

        IndicesAreLocal()==true, Filled()==true 
        """
        return _Epetra.CrsGraph_FillComplete(self, *args)


    def OptimizeStorage(self, *args):
        """
        OptimizeStorage(CrsGraph self) -> int

        int
        Epetra_CrsGraph::OptimizeStorage()

        Make consecutive row index sections contiguous, minimize internal
        storage used for constructing graph.

        After construction and during initialization (when indices are being
        added via InsertGlobalIndices() etc.), the column- indices for each
        row are held in a separate piece of allocated memory. This method
        moves the column-indices for all rows into one large contiguous array
        and eliminates internal storage that is not needed after graph
        construction. Calling this method can have a significant impact on
        memory costs and machine performance.

        If this object was constructed in View mode then this method can't
        make non-contiguous indices contiguous and will return a warning code
        of 1 if the viewed data isn't already contiguous. Integer error code,
        set to 0 if successful.

        Filled()==true.

        If CV=View when the graph was constructed, then this method will be
        effective \\only if the indices of the graph were already
        contiguous. In this case, the indices are left untouched and internal
        storage for the graph is minimized.

        StorageOptimized()==true, if successful 
        """
        return _Epetra.CrsGraph_OptimizeStorage(self, *args)


    def ExtractGlobalRowView(self, *args):
        """
        ExtractGlobalRowView(CrsGraph self, long long GlobalRow, int & NumIndices, long long *& Indices) -> int

        int
        Epetra_CrsGraph::ExtractGlobalRowView(long long GlobalRow, int
        &NumIndices, long long *&Indices) const 
        """
        return _Epetra.CrsGraph_ExtractGlobalRowView(self, *args)


    def Filled(self, *args):
        """
        Filled(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::Filled() const

        If FillComplete() has been called, this query returns true, otherwise
        it returns false. 
        """
        return _Epetra.CrsGraph_Filled(self, *args)


    def StorageOptimized(self, *args):
        """
        StorageOptimized(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::StorageOptimized() const

        If OptimizeStorage() has been called, this query returns true,
        otherwise it returns false. 
        """
        return _Epetra.CrsGraph_StorageOptimized(self, *args)


    def IndicesAreGlobal(self, *args):
        """
        IndicesAreGlobal(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::IndicesAreGlobal() const

        If column indices are in global range, this query returns true,
        otherwise it returns false. 
        """
        return _Epetra.CrsGraph_IndicesAreGlobal(self, *args)


    def IndicesAreLocal(self, *args):
        """
        IndicesAreLocal(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::IndicesAreLocal() const

        If column indices are in local range, this query returns true,
        otherwise it returns false. 
        """
        return _Epetra.CrsGraph_IndicesAreLocal(self, *args)


    def LowerTriangular(self, *args):
        """
        LowerTriangular(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::LowerTriangular() const

        If graph is lower triangular in local index space, this query returns
        true, otherwise it returns false.

        Filled()==true 
        """
        return _Epetra.CrsGraph_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """
        UpperTriangular(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::UpperTriangular() const

        If graph is upper triangular in local index space, this query returns
        true, otherwise it returns false.

        Filled()==true 
        """
        return _Epetra.CrsGraph_UpperTriangular(self, *args)


    def NoDiagonal(self, *args):
        """
        NoDiagonal(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::NoDiagonal() const

        If graph has no diagonal entries in global index space, this query
        returns true, otherwise it returns false.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NoDiagonal(self, *args)


    def MyGlobalRow(self, *args):
        """
        MyGlobalRow(CrsGraph self, int GID) -> bool
        MyGlobalRow(CrsGraph self, long long GID) -> bool

        bool
        Epetra_CrsGraph::MyGlobalRow(long long GID) const 
        """
        return _Epetra.CrsGraph_MyGlobalRow(self, *args)


    def HaveColMap(self, *args):
        """
        HaveColMap(CrsGraph self) -> bool

        bool
        Epetra_CrsGraph::HaveColMap() const

        Returns true if we have a well-defined ColMap, and returns false
        otherwise.

        We have a well-defined ColMap if a) a ColMap was passed in at
        construction, or b) the MakeColMap function has been called. (Calling
        either of the FillComplete functions will result in MakeColMap being
        called.) 
        """
        return _Epetra.CrsGraph_HaveColMap(self, *args)


    def NumMyRows(self, *args):
        """
        NumMyRows(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyRows() const

        Returns the number of matrix rows on this processor. 
        """
        return _Epetra.CrsGraph_NumMyRows(self, *args)


    def NumGlobalRows(self, *args):
        """
        NumGlobalRows(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalRows() const

        Returns the number of matrix rows in global matrix. 
        """
        return _Epetra.CrsGraph_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """
        NumGlobalRows64(CrsGraph self) -> long long

        long long
        Epetra_CrsGraph::NumGlobalRows64() const 
        """
        return _Epetra.CrsGraph_NumGlobalRows64(self, *args)


    def NumMyCols(self, *args):
        """
        NumMyCols(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyCols() const

        Returns the number of entries in the set of column-indices that appear
        on this processor.

        The set of column-indices that appear on this processor is the union
        of column-indices that appear in all local rows. The size of this set
        isn't available until FillComplete() has been called.  Filled()==true

        """
        return _Epetra.CrsGraph_NumMyCols(self, *args)


    def NumGlobalCols(self, *args):
        """
        NumGlobalCols(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalCols() const

        Returns the number of matrix columns in global matrix.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """
        NumGlobalCols64(CrsGraph self) -> long long

        long long
        Epetra_CrsGraph::NumGlobalCols64() const 
        """
        return _Epetra.CrsGraph_NumGlobalCols64(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalNonzeros() const

        Returns the number of indices in the global graph.

        Note that if the graph's maps are defined such that some nonzeros
        appear on more than one processor, then those nonzeros will be counted
        more than once. If the user wishes to assemble a graph from
        overlapping data, they can use Epetra_FECrsGraph.  Filled()==true 
        """
        return _Epetra.CrsGraph_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(CrsGraph self) -> long long

        long
        long Epetra_CrsGraph::NumGlobalNonzeros64() const 
        """
        return _Epetra.CrsGraph_NumGlobalNonzeros64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """
        NumGlobalDiagonals(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalDiagonals() const

        Returns the number of diagonal entries in the global graph, based on
        global row/column index comparisons.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """
        NumGlobalDiagonals64(CrsGraph self) -> long long

        long
        long Epetra_CrsGraph::NumGlobalDiagonals64() const 
        """
        return _Epetra.CrsGraph_NumGlobalDiagonals64(self, *args)


    def NumMyDiagonals(self, *args):
        """
        NumMyDiagonals(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyDiagonals() const

        Returns the number of diagonal entries in the local graph, based on
        global row/column index comparisons.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumMyDiagonals(self, *args)


    def NumMyBlockRows(self, *args):
        """
        NumMyBlockRows(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyBlockRows() const

        Returns the number of block matrix rows on this processor. 
        """
        return _Epetra.CrsGraph_NumMyBlockRows(self, *args)


    def NumGlobalBlockRows(self, *args):
        """
        NumGlobalBlockRows(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalBlockRows() const

        Returns the number of Block matrix rows in global matrix. 
        """
        return _Epetra.CrsGraph_NumGlobalBlockRows(self, *args)


    def NumGlobalBlockRows64(self, *args):
        """
        NumGlobalBlockRows64(CrsGraph self) -> long long

        long
        long Epetra_CrsGraph::NumGlobalBlockRows64() const 
        """
        return _Epetra.CrsGraph_NumGlobalBlockRows64(self, *args)


    def NumMyBlockCols(self, *args):
        """
        NumMyBlockCols(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyBlockCols() const

        Returns the number of Block matrix columns on this processor.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumMyBlockCols(self, *args)


    def NumGlobalBlockCols(self, *args):
        """
        NumGlobalBlockCols(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalBlockCols() const

        Returns the number of Block matrix columns in global matrix.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumGlobalBlockCols(self, *args)


    def NumGlobalBlockCols64(self, *args):
        """
        NumGlobalBlockCols64(CrsGraph self) -> long long

        long
        long Epetra_CrsGraph::NumGlobalBlockCols64() const 
        """
        return _Epetra.CrsGraph_NumGlobalBlockCols64(self, *args)


    def NumMyBlockDiagonals(self, *args):
        """
        NumMyBlockDiagonals(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyBlockDiagonals() const

        Returns the number of Block diagonal entries in the local graph, based
        on global row/column index comparisons.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumMyBlockDiagonals(self, *args)


    def NumGlobalBlockDiagonals(self, *args):
        """
        NumGlobalBlockDiagonals(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalBlockDiagonals() const

        Returns the number of Block diagonal entries in the global graph,
        based on global row/column index comparisons.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumGlobalBlockDiagonals(self, *args)


    def NumGlobalBlockDiagonals64(self, *args):
        """
        NumGlobalBlockDiagonals64(CrsGraph self) -> long long

        long long Epetra_CrsGraph::NumGlobalBlockDiagonals64() const 
        """
        return _Epetra.CrsGraph_NumGlobalBlockDiagonals64(self, *args)


    def NumGlobalEntries(self, *args):
        """
        NumGlobalEntries(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumGlobalEntries() const

        Returns the number of entries in the global graph.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumGlobalEntries(self, *args)


    def NumGlobalEntries64(self, *args):
        """
        NumGlobalEntries64(CrsGraph self) -> long long

        long long
        Epetra_CrsGraph::NumGlobalEntries64() const 
        """
        return _Epetra.CrsGraph_NumGlobalEntries64(self, *args)


    def NumMyEntries(self, *args):
        """
        NumMyEntries(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyEntries() const

        Returns the number of entries on this processor.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumMyEntries(self, *args)


    def MaxRowDim(self, *args):
        """
        MaxRowDim(CrsGraph self) -> int

        int
        Epetra_CrsGraph::MaxRowDim() const

        Returns the max row dimension of block entries on the processor.

        Filled()==true 
        """
        return _Epetra.CrsGraph_MaxRowDim(self, *args)


    def GlobalMaxRowDim(self, *args):
        """
        GlobalMaxRowDim(CrsGraph self) -> int

        int
        Epetra_CrsGraph::GlobalMaxRowDim() const

        Returns the max row dimension of block entries across all processors.

        Filled()==true 
        """
        return _Epetra.CrsGraph_GlobalMaxRowDim(self, *args)


    def MaxColDim(self, *args):
        """
        MaxColDim(CrsGraph self) -> int

        int
        Epetra_CrsGraph::MaxColDim() const

        Returns the max column dimension of block entries on the processor.

        Filled()==true 
        """
        return _Epetra.CrsGraph_MaxColDim(self, *args)


    def GlobalMaxColDim(self, *args):
        """
        GlobalMaxColDim(CrsGraph self) -> int

        int
        Epetra_CrsGraph::GlobalMaxColDim() const

        Returns the max column dimension of block entries across all
        processors.

        Filled()==true 
        """
        return _Epetra.CrsGraph_GlobalMaxColDim(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(CrsGraph self) -> int

        int
        Epetra_CrsGraph::NumMyNonzeros() const

        Returns the number of indices in the local graph.

        Filled()==true 
        """
        return _Epetra.CrsGraph_NumMyNonzeros(self, *args)


    def NumGlobalIndices(self, *args):
        """
        NumGlobalIndices(CrsGraph self, long long Row) -> int

        int
        Epetra_CrsGraph::NumGlobalIndices(long long Row) const

        Returns the current number of nonzero entries in specified global row
        on this processor. 
        """
        return _Epetra.CrsGraph_NumGlobalIndices(self, *args)


    def NumAllocatedGlobalIndices(self, *args):
        """
        NumAllocatedGlobalIndices(CrsGraph self, long long Row) -> int

        int Epetra_CrsGraph::NumAllocatedGlobalIndices(long long Row) const

        Returns the allocated number of nonzero entries in specified global
        row on this processor. 
        """
        return _Epetra.CrsGraph_NumAllocatedGlobalIndices(self, *args)


    def MaxNumIndices(self, *args):
        """
        MaxNumIndices(CrsGraph self) -> int

        int
        Epetra_CrsGraph::MaxNumIndices() const

        Returns the maximum number of nonzero entries across all rows on this
        processor.

        Filled()==true 
        """
        return _Epetra.CrsGraph_MaxNumIndices(self, *args)


    def GlobalMaxNumIndices(self, *args):
        """
        GlobalMaxNumIndices(CrsGraph self) -> int

        int
        Epetra_CrsGraph::GlobalMaxNumIndices() const

        Returns the maximun number of nonzero entries across all rows across
        all processors.

        Filled()==true 
        """
        return _Epetra.CrsGraph_GlobalMaxNumIndices(self, *args)


    def MaxNumNonzeros(self, *args):
        """
        MaxNumNonzeros(CrsGraph self) -> int

        int
        Epetra_CrsGraph::MaxNumNonzeros() const

        Returns the maximum number of nonzero points across all rows on this
        processor.

        For each entry in the graph, let i = the GRID of the entry and j = the
        CGID of the entry. Then the entry size is the product of the rowmap
        elementsize of i and the colmap elementsize of i. Let ki = sum of all
        entry sizes for the entries in the ith row. For example, if the ith
        block row had 5 block entries and the element size of each entry was
        4-by-4, ki would be 80. Then this function returns the max over all ki
        for all row on this processor.

        Filled()==true 
        """
        return _Epetra.CrsGraph_MaxNumNonzeros(self, *args)


    def GlobalMaxNumNonzeros(self, *args):
        """
        GlobalMaxNumNonzeros(CrsGraph self) -> int

        int
        Epetra_CrsGraph::GlobalMaxNumNonzeros() const

        Returns the maximun number of nonzero points across all rows across
        all processors.

        This function returns the max over all processor of MaxNumNonzeros().

        Filled()==true 
        """
        return _Epetra.CrsGraph_GlobalMaxNumNonzeros(self, *args)


    def NumMyIndices(self, *args):
        """
        NumMyIndices(CrsGraph self, int Row) -> int

        int
        Epetra_CrsGraph::NumMyIndices(int Row) const

        Returns the current number of nonzero entries in specified local row
        on this processor. 
        """
        return _Epetra.CrsGraph_NumMyIndices(self, *args)


    def NumAllocatedMyIndices(self, *args):
        """
        NumAllocatedMyIndices(CrsGraph self, int Row) -> int

        int
        Epetra_CrsGraph::NumAllocatedMyIndices(int Row) const

        Returns the allocated number of nonzero entries in specified local row
        on this processor. 
        """
        return _Epetra.CrsGraph_NumAllocatedMyIndices(self, *args)


    def IndexBase(self, *args):
        """
        IndexBase(CrsGraph self) -> int

        int
        Epetra_CrsGraph::IndexBase() const

        Returns the index base for row and column indices for this graph.

        Index base for this map. 
        """
        return _Epetra.CrsGraph_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """
        IndexBase64(CrsGraph self) -> long long

        long long
        Epetra_CrsGraph::IndexBase64() const 
        """
        return _Epetra.CrsGraph_IndexBase64(self, *args)


    def RowMap(self, *args):
        """
        RowMap(CrsGraph self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_CrsGraph::RowMap() const

        Returns the RowMap associated with this graph. 
        """
        return _Epetra.CrsGraph_RowMap(self, *args)


    def ReplaceRowMap(self, *args):
        """
        ReplaceRowMap(CrsGraph self, BlockMap newmap) -> int

        int
        Epetra_CrsGraph::ReplaceRowMap(const Epetra_BlockMap &newmap)

        Replaces the current RowMap with the user-specified map object, but
        only if currentmap->PointSameAs(newmap) is true. This is a collective
        function. Returns 0 if map is replaced, -1 if not.

        RowMap().PointSameAs(newmap)==true 
        """
        return _Epetra.CrsGraph_ReplaceRowMap(self, *args)


    def ReplaceColMap(self, *args):
        """
        ReplaceColMap(CrsGraph self, BlockMap newmap) -> int

        int
        Epetra_CrsGraph::ReplaceColMap(const Epetra_BlockMap &newmap)

        Replaces the current ColMap with the user-specified map object, but
        only if no entries have been inserted into the graph yet (both
        IndicesAreLocal() and IndicesAreGlobal() are false) or
        currentmap->PointSameAs(newmap) is true. This is a collective
        function. Returns 0 if map is replaced, -1 if not.

        ( IndicesAreLocal()==false && IndicesAreGlobal()==false) ||
        ColMap().PointSameAs(newmap)==true 
        """
        return _Epetra.CrsGraph_ReplaceColMap(self, *args)


    def ReplaceDomainMapAndImporter(self, *args):
        """
        ReplaceDomainMapAndImporter(CrsGraph self, BlockMap NewDomainMap, Import NewImporter) -> int

        int Epetra_CrsGraph::ReplaceDomainMapAndImporter(const Epetra_BlockMap
        &NewDomainMap, const Epetra_Import *NewImporter)

        Replaces the current DomainMap & Importer with the user-specified map
        object.

        Replaces the current DomainMap and Importer with the user-specified
        map object, but only if the matrix has been FillCompleted, Importer's
        TargetMap matches the ColMap and Importer's SourceMap matches the
        DomainMap (assuming the importer isn't null). If an Importer is passed
        in, Epetra_CrsMatrix will copy it. Returns 0 if map/importer is
        replaced, -1 if not.

        (!NewImporter && ColMap().PointSameAs(NewDomainMap)) || (NewImporter
        && ColMap().PointSameAs(NewImporter->TargetMap()) &&
        NewDomainMap.PointSameAs(NewImporter->SourceMap())) 
        """
        return _Epetra.CrsGraph_ReplaceDomainMapAndImporter(self, *args)


    def RemoveEmptyProcessesInPlace(self, *args):
        """
        RemoveEmptyProcessesInPlace(CrsGraph self, BlockMap NewMap) -> int

        int Epetra_CrsGraph::RemoveEmptyProcessesInPlace(const Epetra_BlockMap
        *NewMap)

        Remove processes owning zero rows from the Maps and their
        communicator.

        Remove processes owning zero rows from the Maps and their
        communicator. WARNING:  This method is ONLY for use by experts.

        WARNING:  We make NO promises of backwards compatibility. This method
        may change or disappear at any time.

        Parameters:
        -----------

        newMap:  [in] This must be the result of calling the
        removeEmptyProcesses() method on the row BlockMap. If it is not, this
        method's behavior is undefined. This pointer will be null on excluded
        processes. 
        """
        return _Epetra.CrsGraph_RemoveEmptyProcessesInPlace(self, *args)


    def ColMap(self, *args):
        """
        ColMap(CrsGraph self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_CrsGraph::ColMap() const

        Returns the Column Map associated with this graph.

        HaveColMap()==true 
        """
        return _Epetra.CrsGraph_ColMap(self, *args)


    def DomainMap(self, *args):
        """
        DomainMap(CrsGraph self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_CrsGraph::DomainMap() const

        Returns the DomainMap associated with this graph.

        Filled()==true 
        """
        return _Epetra.CrsGraph_DomainMap(self, *args)


    def RangeMap(self, *args):
        """
        RangeMap(CrsGraph self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_CrsGraph::RangeMap() const

        Returns the RangeMap associated with this graph.

        Filled()==true 
        """
        return _Epetra.CrsGraph_RangeMap(self, *args)


    def Importer(self, *args):
        """
        Importer(CrsGraph self) -> Import

        const
        Epetra_Import* Epetra_CrsGraph::Importer() const

        Returns the Importer associated with this graph. 
        """
        return _Epetra.CrsGraph_Importer(self, *args)


    def Exporter(self, *args):
        """
        Exporter(CrsGraph self) -> Export

        const
        Epetra_Export* Epetra_CrsGraph::Exporter() const

        Returns the Exporter associated with this graph. 
        """
        return _Epetra.CrsGraph_Exporter(self, *args)


    def Comm(self, *args):
        """
        Comm(CrsGraph self) -> Comm

        const Epetra_Comm&
        Epetra_CrsGraph::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        graph. 
        """
        return _Epetra.CrsGraph_Comm(self, *args)


    def LRID(self, *args):
        """
        LRID(CrsGraph self, int GRID_in) -> int
        LRID(CrsGraph self, long long GRID_in) -> int

        int
        Epetra_CrsGraph::LRID(long long GRID_in) const 
        """
        return _Epetra.CrsGraph_LRID(self, *args)


    def GRID(self, *args):
        """
        GRID(CrsGraph self, int LRID_in) -> int

        int
        Epetra_CrsGraph::GRID(int LRID_in) const

        Returns the global row index for give local row index, returns
        IndexBase-1 if we don't have this local row. 
        """
        return _Epetra.CrsGraph_GRID(self, *args)


    def GRID64(self, *args):
        """
        GRID64(CrsGraph self, int LRID_in) -> long long

        long long
        Epetra_CrsGraph::GRID64(int LRID_in) const 
        """
        return _Epetra.CrsGraph_GRID64(self, *args)


    def LCID(self, *args):
        """
        LCID(CrsGraph self, int GCID_in) -> int
        LCID(CrsGraph self, long long GCID_in) -> int

        int
        Epetra_CrsGraph::LCID(long long GCID_in) const 
        """
        return _Epetra.CrsGraph_LCID(self, *args)


    def GCID(self, *args):
        """
        GCID(CrsGraph self, int LCID_in) -> int

        int
        Epetra_CrsGraph::GCID(int LCID_in) const

        Returns the global column index for give local column index, returns
        IndexBase-1 if we don't have this local column.

        HaveColMap()==true (If HaveColMap()==false, returns -1) 
        """
        return _Epetra.CrsGraph_GCID(self, *args)


    def GCID64(self, *args):
        """
        GCID64(CrsGraph self, int LCID_in) -> long long

        long long
        Epetra_CrsGraph::GCID64(int LCID_in) const 
        """
        return _Epetra.CrsGraph_GCID64(self, *args)


    def MyGRID(self, *args):
        """
        MyGRID(CrsGraph self, int GRID_in) -> bool
        MyGRID(CrsGraph self, long long GRID_in) -> bool

        bool
        Epetra_CrsGraph::MyGRID(long long GRID_in) const 
        """
        return _Epetra.CrsGraph_MyGRID(self, *args)


    def MyLRID(self, *args):
        """
        MyLRID(CrsGraph self, int LRID_in) -> bool

        bool
        Epetra_CrsGraph::MyLRID(int LRID_in) const

        Returns true if the LRID passed in belongs to the calling processor in
        this map, otherwise returns false. 
        """
        return _Epetra.CrsGraph_MyLRID(self, *args)


    def MyGCID(self, *args):
        """
        MyGCID(CrsGraph self, int GCID_in) -> bool
        MyGCID(CrsGraph self, long long GCID_in) -> bool

        bool
        Epetra_CrsGraph::MyGCID(long long GCID_in) const 
        """
        return _Epetra.CrsGraph_MyGCID(self, *args)


    def MyLCID(self, *args):
        """
        MyLCID(CrsGraph self, int LCID_in) -> bool

        bool
        Epetra_CrsGraph::MyLCID(int LCID_in) const

        Returns true if the LRID passed in belongs to the calling processor in
        this map, otherwise returns false.

        HaveColMap()==true (If HaveColMap()==false, returns -1) 
        """
        return _Epetra.CrsGraph_MyLCID(self, *args)


    def PrintGraphData(self, *args):
        """
        PrintGraphData(CrsGraph self, std::ostream & os)
        PrintGraphData(CrsGraph self, std::ostream & os, int level)

        void
        Epetra_CrsGraph::PrintGraphData(std::ostream &os, int level) const 
        """
        return _Epetra.CrsGraph_PrintGraphData(self, *args)


    def ImportMap(self, *args):
        """
        ImportMap(CrsGraph self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_CrsGraph::ImportMap() const

        Use ColMap() instead. 
        """
        return _Epetra.CrsGraph_ImportMap(self, *args)


    def TransformToLocal(self, *args):
        """
        TransformToLocal(CrsGraph self) -> int
        TransformToLocal(CrsGraph self, BlockMap DomainMap, BlockMap RangeMap) -> int

        int
        Epetra_CrsGraph::TransformToLocal(const Epetra_BlockMap *DomainMap,
        const Epetra_BlockMap *RangeMap)

        Use FillComplete(const Epetra_BlockMap& DomainMap, const
        Epetra_BlockMap& RangeMap) instead. 
        """
        return _Epetra.CrsGraph_TransformToLocal(self, *args)


    def ReferenceCount(self, *args):
        """
        ReferenceCount(CrsGraph self) -> int

        int
        Epetra_CrsGraph::ReferenceCount() const

        Returns the reference count of CrsGraphData.

        (Intended for testing purposes.) 
        """
        return _Epetra.CrsGraph_ReferenceCount(self, *args)


    def DataPtr(self, *args):
        """
        DataPtr(CrsGraph self) -> Epetra_CrsGraphData const *

        const
        Epetra_CrsGraphData* Epetra_CrsGraph::DataPtr() const

        Returns a pointer to the CrsGraphData instance this CrsGraph uses.

        (Intended for developer use only for testing purposes.) 
        """
        return _Epetra.CrsGraph_DataPtr(self, *args)


    def SortGhostsAssociatedWithEachProcessor(self, *args):
        """
        SortGhostsAssociatedWithEachProcessor(CrsGraph self, bool Flag)

        void
        Epetra_CrsGraph::SortGhostsAssociatedWithEachProcessor(bool Flag)

        Forces FillComplete() to locally order ghostnodes associated with each
        remote processor in ascending order.

        To be compliant with AztecOO, FillComplete() already locally orders
        ghostnodes such that information received from processor k has a lower
        local numbering than information received from processor j if k is
        less than j. SortGhostsAssociatedWithEachProcessor(True) further
        forces FillComplete() to locally number all ghostnodes received from
        processor k in ascending order. That is, the local numbering of b is
        less than c if the global numbering of b is less than c and if both b
        and c are owned by the same processor. This is done to be compliant
        with some limited block features within ML. In particular, some ML
        features require that a block structure of the matrix be maintained
        even within the ghost variables. 
        """
        return _Epetra.CrsGraph_SortGhostsAssociatedWithEachProcessor(self, *args)


    def __init__(self, *args):
        """

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, int numIndicesPerRow,
            bool staticProfile=False) -> CrsGraph

          Constructor with implicit column map and constant indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            numIndicesPerRow  - Integer number of indices per row
            staticProfile     - Static profile flag

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            int numIndicesPerRow, bool staticProfile=False) -> CrsGraph

          Constructor with specified column map and constant indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            colMap            - Map describing distribution of columns across processors
            numIndicesPerRow  - Integer number of indices per row
            staticProfile     - Static profile flag

        __init__(self, CrsGraph graph) -> CrsGraph

          Copy constructor.  Arguments:

            graph - Source graph for copy constructor

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, PySequence
            numIndicesPerRow, bool staticProfile=False) -> CrsGraph

          Constructor with implicit column map and variable indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            numIndicesPerRow  - Sequence of integers representing the number of indices
                                per row
            staticProfile     - Static profile flag

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            PySequence numIndicesPerRow, bool staticProfile=False) -> CrsGraph

          Constructor with specified column map and variable indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            colMap            - Map describing distribution of columns across processors
            numIndicesPerRow  - Sequence of integers representing the number of indices
                                per row
            staticProfile     - Static profile flag

        Epetra_CrsGraph::Epetra_CrsGraph(const Epetra_CrsGraph &Graph)

        Copy constructor.

        This will create a Level 1 deep copy. This Graph will share ownership
        of the CrsGraphData object with the right hand side Graph. 
        """
        this = _Epetra.new_CrsGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ExtractGlobalRowCopy(self, *args):
        """
        ExtractGlobalRowCopy(CrsGraph self, long long GlobalRow, int LenOfIndices, int & NumIndices, long long * Indices) -> int
        ExtractGlobalRowCopy(CrsGraph self, int globalRow) -> PyObject *

        int
        Epetra_CrsGraph::ExtractGlobalRowCopy(long long GlobalRow, int
        LenOfIndices, int &NumIndices, long long *Indices) const 
        """
        return _Epetra.CrsGraph_ExtractGlobalRowCopy(self, *args)


    def __getitem__(self, *args):
        """__getitem__(CrsGraph self, int i) -> int *"""
        return _Epetra.CrsGraph___getitem__(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(CrsGraph self, int localRow) -> PyObject *

        int
        Epetra_CrsGraph::ExtractMyRowCopy(int LocalRow, int LenOfIndices, int
        &NumIndices, int *Indices) const

        Extract a list of elements in a specified local row of the graph. Put
        into storage allocated by calling routine.

        Parameters:
        -----------

        Row:  - (In) Local row number to get indices.

        LenOfIndices:  - (In) Length of Indices array.

        NumIndices:  - (Out) Number of Indices.

        Indices:  - (Out) Local column indices corresponding to values.

        Integer error code, set to 0 if successful.

        IndicesAreLocal()==true 
        """
        return _Epetra.CrsGraph_ExtractMyRowCopy(self, *args)

CrsGraph_swigregister = _Epetra.CrsGraph_swigregister
CrsGraph_swigregister(CrsGraph)

class OffsetIndex(Object):
    """


    Epetra_OffsetIndex: This class builds index for efficient mapping of
    data from one Epetra_CrsGraph based object to another.

    Epetra_OffsetIndex generates and index of offsets allowing direct
    access to data for Import/Export operations on Epetra_CrsGraph based
    objects such as Epetra_CrsMatrix.

    C++ includes: Epetra_OffsetIndex.h 
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OffsetIndex, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OffsetIndex, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_OffsetIndex self, CrsGraph SourceGraph, CrsGraph TargetGraph, Import Importer) -> OffsetIndex
        __init__(Epetra_OffsetIndex self, CrsGraph SourceGraph, CrsGraph TargetGraph, Export Exporter) -> OffsetIndex
        __init__(Epetra_OffsetIndex self, OffsetIndex Indexor) -> OffsetIndex

        Epetra_OffsetIndex::Epetra_OffsetIndex(const Epetra_OffsetIndex
        &Indexor)

        Epetra_OffsetIndex copy constructor. 
        """
        this = _Epetra.new_OffsetIndex(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_OffsetIndex

    def SameOffsets(self, *args):
        """
        SameOffsets(OffsetIndex self) -> int **

        int**
        Epetra_OffsetIndex::SameOffsets() const

        Accessor. 
        """
        return _Epetra.OffsetIndex_SameOffsets(self, *args)


    def PermuteOffsets(self, *args):
        """
        PermuteOffsets(OffsetIndex self) -> int **

        int**
        Epetra_OffsetIndex::PermuteOffsets() const

        Accessor. 
        """
        return _Epetra.OffsetIndex_PermuteOffsets(self, *args)


    def RemoteOffsets(self, *args):
        """
        RemoteOffsets(OffsetIndex self) -> int **

        int**
        Epetra_OffsetIndex::RemoteOffsets() const

        Accessor. 
        """
        return _Epetra.OffsetIndex_RemoteOffsets(self, *args)

    __swig_setmethods__["NumSame_"] = _Epetra.OffsetIndex_NumSame__set
    __swig_getmethods__["NumSame_"] = _Epetra.OffsetIndex_NumSame__get
    if _newclass:
        NumSame_ = _swig_property(_Epetra.OffsetIndex_NumSame__get, _Epetra.OffsetIndex_NumSame__set)
    __swig_setmethods__["SameOffsets_"] = _Epetra.OffsetIndex_SameOffsets__set
    __swig_getmethods__["SameOffsets_"] = _Epetra.OffsetIndex_SameOffsets__get
    if _newclass:
        SameOffsets_ = _swig_property(_Epetra.OffsetIndex_SameOffsets__get, _Epetra.OffsetIndex_SameOffsets__set)
    __swig_setmethods__["NumPermute_"] = _Epetra.OffsetIndex_NumPermute__set
    __swig_getmethods__["NumPermute_"] = _Epetra.OffsetIndex_NumPermute__get
    if _newclass:
        NumPermute_ = _swig_property(_Epetra.OffsetIndex_NumPermute__get, _Epetra.OffsetIndex_NumPermute__set)
    __swig_setmethods__["PermuteOffsets_"] = _Epetra.OffsetIndex_PermuteOffsets__set
    __swig_getmethods__["PermuteOffsets_"] = _Epetra.OffsetIndex_PermuteOffsets__get
    if _newclass:
        PermuteOffsets_ = _swig_property(_Epetra.OffsetIndex_PermuteOffsets__get, _Epetra.OffsetIndex_PermuteOffsets__set)
    __swig_setmethods__["NumExport_"] = _Epetra.OffsetIndex_NumExport__set
    __swig_getmethods__["NumExport_"] = _Epetra.OffsetIndex_NumExport__get
    if _newclass:
        NumExport_ = _swig_property(_Epetra.OffsetIndex_NumExport__get, _Epetra.OffsetIndex_NumExport__set)
    __swig_setmethods__["NumRemote_"] = _Epetra.OffsetIndex_NumRemote__set
    __swig_getmethods__["NumRemote_"] = _Epetra.OffsetIndex_NumRemote__get
    if _newclass:
        NumRemote_ = _swig_property(_Epetra.OffsetIndex_NumRemote__get, _Epetra.OffsetIndex_NumRemote__set)
    __swig_setmethods__["RemoteOffsets_"] = _Epetra.OffsetIndex_RemoteOffsets__set
    __swig_getmethods__["RemoteOffsets_"] = _Epetra.OffsetIndex_RemoteOffsets__get
    if _newclass:
        RemoteOffsets_ = _swig_property(_Epetra.OffsetIndex_RemoteOffsets__get, _Epetra.OffsetIndex_RemoteOffsets__set)
    __swig_setmethods__["DataOwned_"] = _Epetra.OffsetIndex_DataOwned__set
    __swig_getmethods__["DataOwned_"] = _Epetra.OffsetIndex_DataOwned__get
    if _newclass:
        DataOwned_ = _swig_property(_Epetra.OffsetIndex_DataOwned__get, _Epetra.OffsetIndex_DataOwned__set)
OffsetIndex_swigregister = _Epetra.OffsetIndex_swigregister
OffsetIndex_swigregister(OffsetIndex)

class Operator(_object):
    """

    For cross-language polymorphism to work in python, you must call this
    constructor::

        from PyTrilinos import Epetra
        class MyOperator(Epetra.Operator):
            def __init__(self):
                Epetra.Operator.__init__(self)

    Other than that, the Epetra.Operator class is much more forgiving than
    its C++ counterpart.  Often, you can override just the Label() and
    Apply() methods.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Operator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Operator, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_Operator

    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(Operator self, bool UseTranspose) -> int

        virtual int
        Epetra_Operator::SetUseTranspose(bool UseTranspose)=0

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Epetra.Operator_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.


        virtual int
        Epetra_Operator::Apply(const Epetra_MultiVector &X, Epetra_MultiVector
        &Y) const =0

        Returns the result of a Epetra_Operator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.Operator_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.


        virtual int
        Epetra_Operator::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const =0

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        WARNING:  In order to work with AztecOO, any implementation of this
        method must support the case where X and Y are the same object. 
        """
        return _Epetra.Operator_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """
        NormInf(Operator self) -> double

        virtual double
        Epetra_Operator::NormInf() const =0

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.Operator_NormInf(self, *args)


    def Label(self, *args):
        """
        Label(Operator self) -> char const *

        virtual const char*
        Epetra_Operator::Label() const =0

        Returns a character string describing the operator. 
        """
        return _Epetra.Operator_Label(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(Operator self) -> bool

        virtual bool
        Epetra_Operator::UseTranspose() const =0

        Returns the current UseTranspose setting. 
        """
        return _Epetra.Operator_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(Operator self) -> bool

        virtual bool
        Epetra_Operator::HasNormInf() const =0

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Epetra.Operator_HasNormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(Operator self) -> Comm

        virtual const
        Epetra_Comm& Epetra_Operator::Comm() const =0

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Epetra.Operator_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(Operator self) -> Map

        virtual
        const Epetra_Map& Epetra_Operator::OperatorDomainMap() const =0

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _Epetra.Operator_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(Operator self) -> Map

        virtual
        const Epetra_Map& Epetra_Operator::OperatorRangeMap() const =0

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _Epetra.Operator_OperatorRangeMap(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_Operator self) -> Operator


        For cross-language polymorphism to work in python, you must call this
        constructor::

            from PyTrilinos import Epetra
            class MyOperator(Epetra.Operator):
                def __init__(self):
                    Epetra.Operator.__init__(self)

        Other than that, the Epetra.Operator class is much more forgiving than
        its C++ counterpart.  Often, you can override just the Label() and
        Apply() methods.

        """
        if self.__class__ == Operator:
            _self = None
        else:
            _self = self
        this = _Epetra.new_Operator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _Epetra.disown_Operator(self)
        return weakref_proxy(self)
Operator_swigregister = _Epetra.Operator_swigregister
Operator_swigregister(Operator)

class InvOperator(Operator):
    """


    Epetra_InvOperator: An implementation of the Epetra_Operator class
    that reverses the role of Apply() and ApplyInverse() methods.

    The Epetra_InvOperator class implements Epetra_Operator using another
    pre-constructed Epetra_Operator object. Once constructed, an
    Epetra_InvOperator can be used as the inverse of the input operator
    object as long as the appropriate Apply and ApplyInverse methods are
    implemented in the original Epetra_Operator object.

    C++ includes: Epetra_InvOperator.h 
    """

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvOperator, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvOperator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_InvOperator self, Operator operatorIn) -> InvOperator

        Epetra_InvOperator::Epetra_InvOperator(Epetra_Operator *operatorIn)

        Uses an Epetra_Operator instance to implement the Epetra_Operator
        interface.

        Facilitates the use of an Epetra_Operator instance as an inverse
        operator.

        Parameters:
        -----------

        In:  - A fully-constructed Epetra_Operator object. 
        """
        if self.__class__ == InvOperator:
            _self = None
        else:
            _self = self
        this = _Epetra.new_InvOperator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_InvOperator

    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(InvOperator self, bool UseTranspose_in) -> int

        int
        Epetra_InvOperator::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose_in - If true, multiply by the transpose of operator,
        otherwise just use operator.

        WARNING:  - This method has no effect and returns -1 as error code. 
        """
        return _Epetra.InvOperator_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(InvOperator self, MultiVector X, MultiVector Y) -> int

        int
        Epetra_InvOperator::Apply(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_InvOperator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        WARNING:  - This method has no effect and returns -1 as error code. 
        """
        return _Epetra.InvOperator_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(InvOperator self, MultiVector X, MultiVector Y) -> int

        int
        Epetra_InvOperator::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_InvOperator inverse applied to an
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.InvOperator_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """
        NormInf(InvOperator self) -> double

        double
        Epetra_InvOperator::NormInf() const

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.InvOperator_NormInf(self, *args)


    def Label(self, *args):
        """
        Label(InvOperator self) -> char const *

        const char*
        Epetra_InvOperator::Label() const

        Returns a character std::string describing the operator. 
        """
        return _Epetra.InvOperator_Label(self, *args)


    def Operator(self, *args):
        """
        Operator(InvOperator self) -> Operator

        Epetra_Operator*
        Epetra_InvOperator::Operator() const

        Returns a pointer to the Epetra_Operator operator object that was used
        to create this Epetra_InvOperator object. 
        """
        return _Epetra.InvOperator_Operator(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(InvOperator self) -> bool

        bool
        Epetra_InvOperator::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Epetra.InvOperator_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(InvOperator self) -> bool

        bool
        Epetra_InvOperator::HasNormInf() const

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Epetra.InvOperator_HasNormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(InvOperator self) -> Comm

        const Epetra_Comm&
        Epetra_InvOperator::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Epetra.InvOperator_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(InvOperator self) -> Map

        const
        Epetra_Map& Epetra_InvOperator::OperatorDomainMap() const

        Returns the Epetra_BlockMap object associated with the domain of this
        matrix operator. 
        """
        return _Epetra.InvOperator_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(InvOperator self) -> Map

        const
        Epetra_Map& Epetra_InvOperator::OperatorRangeMap() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return _Epetra.InvOperator_OperatorRangeMap(self, *args)

    def __disown__(self):
        self.this.disown()
        _Epetra.disown_InvOperator(self)
        return weakref_proxy(self)
InvOperator_swigregister = _Epetra.InvOperator_swigregister
InvOperator_swigregister(InvOperator)

class RowMatrix(Operator, SrcDistObject):
    """


    Epetra_RowMatrix: A pure virtual class for using real-valued double-
    precision row matrices.

    The Epetra_RowMatrix class is a pure virtual class (specifies
    interface only) that enable the use of real-valued double-precision
    sparse matrices where matrix entries are intended for row access. It
    is currently implemented by both the Epetra_CrsMatrix and
    Epetra_VbrMatrix classes.

    C++ includes: Epetra_RowMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [Operator, SrcDistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RowMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator, SrcDistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RowMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_RowMatrix

    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        virtual int
        Epetra_RowMatrix::NumMyRowEntries(int MyRow, int &NumEntries) const =0

        Returns the number of nonzero entries in MyRow.

        Parameters:
        -----------

        In:  MyRow - Local row.

        Out:  NumEntries - Number of nonzero values present.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_NumMyRowEntries(self, *args)


    def MaxNumEntries(self, *args):
        """
        MaxNumEntries(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::MaxNumEntries() const =0

        Returns the maximum of NumMyRowEntries() over all rows. 
        """
        return _Epetra.RowMatrix_MaxNumEntries(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(int myRow, int length, numpy.ndarray numEntries,
            numpy.ndarray values, numpy.ndarray indices) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        Arguments values and indices are double* and int*, respectively, in
        C++.  In python, these are provided to you as numpy arrays of the
        given length, so that you may alter their entries in-place.

        virtual
        int Epetra_RowMatrix::ExtractMyRowCopy(int MyRow, int Length, int
        &NumEntries, double *Values, int *Indices) const =0

        Returns a copy of the specified local row in user-provided arrays.

        Parameters:
        -----------

        In:  MyRow - Local row to extract.

        In:  Length - Length of Values and Indices.

        Out:  NumEntries - Number of nonzero entries extracted.

        Out:  Values - Extracted values for this row.

        Out:  Indices - Extracted local column indices for the corresponding
        values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_ExtractMyRowCopy(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(Vector diagonal) -> int

        Argument diagonal is provided to you as a numpy-hybrid Epetra.Vector,
        giving you access to the numpy interface in addition to the
        Epetra_Vector C++ interface.

        virtual
        int Epetra_RowMatrix::ExtractDiagonalCopy(Epetra_Vector &Diagonal)
        const =0

        Returns a copy of the main diagonal in a user-provided vector.

        Parameters:
        -----------

        Out:  Diagonal - Extracted main diagonal.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_ExtractDiagonalCopy(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.

        virtual int
        Epetra_RowMatrix::Multiply(bool TransA, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const =0

        Returns the result of a Epetra_RowMatrix multiplied by a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  TransA -If true, multiply by the transpose of matrix, otherwise
        just use matrix.

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.

        virtual int
        Epetra_RowMatrix::Solve(bool Upper, bool Trans, bool UnitDiagonal,
        const Epetra_MultiVector &X, Epetra_MultiVector &Y) const =0

        Returns result of a local-only solve using a triangular
        Epetra_RowMatrix with Epetra_MultiVectors X and Y.

        This method will perform a triangular solve independently on each
        processor of the parallel machine. No communication is performed.

        Parameters:
        -----------

        In:  Upper -If true, solve Ux = y, otherwise solve Lx = y.

        In:  Trans -If true, solve transpose problem.

        In:  UnitDiagonal -If true, assume diagonal is unit (whether it's
        stored or not).

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.

        virtual int
        Epetra_RowMatrix::InvRowSums(Epetra_Vector &x) const =0

        Computes the sum of absolute values of the rows of the
        Epetra_RowMatrix, results returned in x.

        The vector x will return such that x[i] will contain the inverse of
        sum of the absolute values of the this matrix will be scaled such that
        A(i,j) = x(i)*A(i,j) where i denotes the global row number of A and j
        denotes the global column number of A. Using the resulting vector from
        this function as input to LeftScale() will make the infinity norm of
        the resulting matrix exactly 1.

        Parameters:
        -----------

        Out:  x -A Epetra_Vector containing the row sums of the this matrix.

        WARNING:  It is assumed that the distribution of x is the same as the
        rows of this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.

        virtual int
        Epetra_RowMatrix::LeftScale(const Epetra_Vector &x)=0

        Scales the Epetra_RowMatrix on the left with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(i)*A(i,j) where i
        denotes the row number of A and j denotes the column number of A.

        Parameters:
        -----------

        In:  x -A Epetra_Vector to solve for.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.

        virtual int
        Epetra_RowMatrix::InvColSums(Epetra_Vector &x) const =0

        Computes the sum of absolute values of the columns of the
        Epetra_RowMatrix, results returned in x.

        The vector x will return such that x[j] will contain the inverse of
        sum of the absolute values of the this matrix will be sca such that
        A(i,j) = x(j)*A(i,j) where i denotes the global row number of A and j
        denotes the global column number of A. Using the resulting vector from
        this function as input to RighttScale() will make the one norm of the
        resulting matrix exactly 1.

        Parameters:
        -----------

        Out:  x -A Epetra_Vector containing the column sums of the this
        matrix.

        WARNING:  It is assumed that the distribution of x is the same as the
        rows of this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.

        virtual int
        Epetra_RowMatrix::RightScale(const Epetra_Vector &x)=0

        Scales the Epetra_RowMatrix on the right with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(j)*A(i,j) where i
        denotes the global row number of A and j denotes the global column
        number of A.

        Parameters:
        -----------

        In:  x -The Epetra_Vector used for scaling this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.RowMatrix_RightScale(self, *args)


    def Filled(self, *args):
        """
        Filled(RowMatrix self) -> bool

        virtual bool
        Epetra_RowMatrix::Filled() const =0

        If FillComplete() has been called, this query returns true, otherwise
        it returns false. 
        """
        return _Epetra.RowMatrix_Filled(self, *args)


    def NormInf(self, *args):
        """
        NormInf(RowMatrix self) -> double

        virtual double
        Epetra_RowMatrix::NormInf() const =0

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.RowMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """
        NormOne(RowMatrix self) -> double

        virtual double
        Epetra_RowMatrix::NormOne() const =0

        Returns the one norm of the global matrix. 
        """
        return _Epetra.RowMatrix_NormOne(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(RowMatrix self) -> int

        virtual
        int Epetra_RowMatrix::NumGlobalNonzeros() const =0

        Returns the number of nonzero entries in the global matrix. 
        """
        return _Epetra.RowMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(RowMatrix self) -> long long

        virtual
        long long Epetra_RowMatrix::NumGlobalNonzeros64() const =0 
        """
        return _Epetra.RowMatrix_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """
        NumGlobalRows(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::NumGlobalRows() const =0

        Returns the number of global matrix rows. 
        """
        return _Epetra.RowMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """
        NumGlobalRows64(RowMatrix self) -> long long

        virtual
        long long Epetra_RowMatrix::NumGlobalRows64() const =0 
        """
        return _Epetra.RowMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """
        NumGlobalCols(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::NumGlobalCols() const =0

        Returns the number of global matrix columns. 
        """
        return _Epetra.RowMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """
        NumGlobalCols64(RowMatrix self) -> long long

        virtual
        long long Epetra_RowMatrix::NumGlobalCols64() const =0 
        """
        return _Epetra.RowMatrix_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """
        NumGlobalDiagonals(RowMatrix self) -> int

        virtual
        int Epetra_RowMatrix::NumGlobalDiagonals() const =0

        Returns the number of global nonzero diagonal entries, based on global
        row/column index comparisons. 
        """
        return _Epetra.RowMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """
        NumGlobalDiagonals64(RowMatrix self) -> long long

        virtual long long Epetra_RowMatrix::NumGlobalDiagonals64() const =0 
        """
        return _Epetra.RowMatrix_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::NumMyNonzeros() const =0

        Returns the number of nonzero entries in the calling processor's
        portion of the matrix. 
        """
        return _Epetra.RowMatrix_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """
        NumMyRows(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::NumMyRows() const =0

        Returns the number of matrix rows owned by the calling processor. 
        """
        return _Epetra.RowMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """
        NumMyCols(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::NumMyCols() const =0

        Returns the number of matrix columns owned by the calling processor.

        """
        return _Epetra.RowMatrix_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """
        NumMyDiagonals(RowMatrix self) -> int

        virtual int
        Epetra_RowMatrix::NumMyDiagonals() const =0

        Returns the number of local nonzero diagonal entries, based on global
        row/column index comparisons. 
        """
        return _Epetra.RowMatrix_NumMyDiagonals(self, *args)


    def LowerTriangular(self, *args):
        """
        LowerTriangular(RowMatrix self) -> bool

        virtual
        bool Epetra_RowMatrix::LowerTriangular() const =0

        If matrix is lower triangular in local index space, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.RowMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """
        UpperTriangular(RowMatrix self) -> bool

        virtual
        bool Epetra_RowMatrix::UpperTriangular() const =0

        If matrix is upper triangular in local index space, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.RowMatrix_UpperTriangular(self, *args)


    def RowMatrixRowMap(self, *args):
        """
        RowMatrixRowMap(RowMatrix self) -> Map

        virtual
        const Epetra_Map& Epetra_RowMatrix::RowMatrixRowMap() const =0

        Returns the Epetra_Map object associated with the rows of this matrix.

        """
        return _Epetra.RowMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """
        RowMatrixColMap(RowMatrix self) -> Map

        virtual
        const Epetra_Map& Epetra_RowMatrix::RowMatrixColMap() const =0

        Returns the Epetra_Map object associated with the columns of this
        matrix. 
        """
        return _Epetra.RowMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """
        RowMatrixImporter(RowMatrix self) -> Import

        virtual
        const Epetra_Import* Epetra_RowMatrix::RowMatrixImporter() const =0

        Returns the Epetra_Import object that contains the import operations
        for distributed operations. 
        """
        return _Epetra.RowMatrix_RowMatrixImporter(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_RowMatrix self) -> RowMatrix



        Epetra_RowMatrix: A pure virtual class for using real-valued double-
        precision row matrices.

        The Epetra_RowMatrix class is a pure virtual class (specifies
        interface only) that enable the use of real-valued double-precision
        sparse matrices where matrix entries are intended for row access. It
        is currently implemented by both the Epetra_CrsMatrix and
        Epetra_VbrMatrix classes.

        C++ includes: Epetra_RowMatrix.h 
        """
        if self.__class__ == RowMatrix:
            _self = None
        else:
            _self = self
        this = _Epetra.new_RowMatrix(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _Epetra.disown_RowMatrix(self)
        return weakref_proxy(self)
RowMatrix_swigregister = _Epetra.RowMatrix_swigregister
RowMatrix_swigregister(RowMatrix)

class BasicRowMatrix(CompObject, Object, RowMatrix):
    """


    Epetra_BasicRowMatrix: A class for simplifying the development of
    Epetra_RowMatrix adapters.

    The Epetra_BasicRowMatrix is an adapter class for Epetra_RowMatrix
    that implements most of the Epetra_RowMatrix methods using reasonable
    default implementations. The Epetra_RowMatrix class has 39 pure
    virtual methods, requiring the adapter class to implement all of them.
    Epetra_BasicRowMatrix has only 4 pure virtual methods that must be
    implemented (See Epetra_JadMatrix for an example): ExtractMyRowCopy:
    Provide a row of values and indices for a specified local row.

    ExtractMyEntryView (const and non-const versions): Provide the memory
    address of the ith nonzero term stored on the calling processor, along
    with its corresponding local row and column index, where i goes from 0
    to the NumMyNonzeros()-1. The order in which the nonzeros are
    traversed is not specified and is up to the adapter implementation.

    NumMyRowEntries: Provide the number of entries for a specified local
    row.  An alternative is possible if you do not want to provide a non-
    trivial implementation of the ExtraMyEntryView  methods (See
    Epetra_VbrRowMatrix for an example): Implement ExtractMyRowCopy and
    NumMyRowEntries as above.

    Implement ExtractMyEntryView (both versions) returning a -1 integer
    code with no other executable code.

    Implement the RightScale and LeftScale methods non-trivially.

    In addition, most adapters will probably re-implement the Multiply()
    method and perhaps the Solve() method, although one or the other may
    be implemented to return -1, signaling that there is no valid
    implementation. By default, the Multiply() method is implemented using
    ExtractMyRowCopy, which can usual be improved upon. By default Solve()
    and ApplyInverse() are implemented to return -1 (not implemented).

    All other implemented methods in Epetra_BasicRowMatrix should not
    exhibit a signficant performance degradation, either because they are
    relatively small and fast, or because they are not a significant
    portion of the runtime for most codes. All methods are virtual, so
    they can be re-implemented by the adapter.

    In addition to implementing the above methods, an adapter must inherit
    the Epetra_BasicRowMatrix interface and call the Epetra_BasicRowMatrix
    constructor as part of the adapter constructor. There are two
    constructors. The first requires the user to pass in the RowMap and
    ColMap, both of which are Epetra_Map objects. On each processor the
    RowMap (ColMap) must contain the global IDs (GIDs) of the rows
    (columns) that the processor cares about. The first constructor
    requires only these two maps, assuming that the RowMap will also serve
    as the DomainMap and RangeMap. In this case, the RowMap must be
    1-to-1, meaning that if a global ID appears on one processor, it
    appears only once on that processor and does not appear on any other
    processor. For many sparse matrix data structures, it is the case that
    a given row is completely owned by one processor and that the global
    matrix is square. The first constructor is for this situation.

    The second constructor allows the caller to specify all four maps. In
    this case the DomainMap, the layout of multivectors/vectors that are
    in the domain of the matrix (the x vector if computing y = A*x), must
    be 1-to-1. Also, the RangeMap, the layout of y must be 1-to-1. The
    RowMap and ColMap do not need to be 1-to-1, but the GIDs must be found
    in the RangeMap and DomainMap, respectively.

    Note that Epetra_Operator is a base class for Epetra_RowMatrix, so any
    adapter for Epetra_BasicRowMatrix (or Epetra_RowMatrix) is also an
    adapter for Epetra_Operator.

    An example of how to provide an adapter for Epetra_BasicRowMatrix can
    be found by looking at Epetra_JadMatrix.

    C++ includes: Epetra_BasicRowMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [CompObject, Object, RowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicRowMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CompObject, Object, RowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicRowMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_BasicRowMatrix self, Comm Comm) -> BasicRowMatrix

        Epetra_BasicRowMatrix::Epetra_BasicRowMatrix(const Epetra_Comm &Comm)

        Epetra_BasicRowMatrix constructor.

        This constructor requires a valid Epetra_Comm object as its only
        argument. The constructor will use Comm to build Epetra_Maps objects:
        RowMap, ColMap, DomainMap and RangeMap. However, these will be zero-
        length (trivial) maps that must be reset by calling one of the two
        SetMap() methods listed below.

        Parameters:
        -----------

        Comm:  An Epetra_Comm containing a valid Comm object. 
        """
        if self.__class__ == BasicRowMatrix:
            _self = None
        else:
            _self = self
        this = _Epetra.new_BasicRowMatrix(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_BasicRowMatrix

    def SetMaps(self, *args):
        """
        SetMaps(BasicRowMatrix self, Map RowMap, Map ColMap)
        SetMaps(BasicRowMatrix self, Map RowMap, Map ColMap, Map DomainMap, Map RangeMap)

        void
        Epetra_BasicRowMatrix::SetMaps(const Epetra_Map &RowMap, const
        Epetra_Map &ColMap, const Epetra_Map &DomainMap, const Epetra_Map
        &RangeMap)

        Set maps (Version 2); call this function or the previous, but not
        both.

        This constructor takes a row, column, domain and range map. On each
        processor these maps describe the global rows, columns, domain and
        range, resp, that the processor will care about. The domain and range
        maps must be one-to-one, but note that the row and column maps do not
        have to be one-to-one. In other words, a row ID can appear on more
        than one processor, as can a column ID.

        Parameters:
        -----------

        RowMap:  An Epetra_Map containing on each processor a list of GIDs of
        rows that the processor cares about.

        ColMap:  An Epetra_Map containing on each processor a list of GIDs of
        columns that the processor cares about.

        DomainMap:  An Epetra_Map describing the distribution of domain
        vectors and multivectors.

        RangeMap:  An Epetra_Map describing the distribution of range vectors
        and multivectors. 
        """
        return _Epetra.BasicRowMatrix_SetMaps(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(BasicRowMatrix self, int MyRow, int Length, int & NumEntries, double * Values, int * Indices) -> int

        virtual int Epetra_BasicRowMatrix::ExtractMyRowCopy(int MyRow, int
        Length, int &NumEntries, double *Values, int *Indices) const =0

        Returns a copy of the specified local row in user-provided arrays.

        Parameters:
        -----------

        MyRow:  (In) - Local row to extract.

        Length:  (In) - Length of Values and Indices.

        NumEntries:  (Out) - Number of nonzero entries extracted.

        Values:  (Out) - Extracted values for this row.

        Indices:  (Out) - Extracted global column indices for the
        corresponding values.

        Integer error code, set to 0 if successful, set to -1 if MyRow not
        valid, -2 if Length is too short (NumEntries will have required
        length). 
        """
        return _Epetra.BasicRowMatrix_ExtractMyRowCopy(self, *args)


    def ExtractMyEntryView(self, *args):
        """
        ExtractMyEntryView(BasicRowMatrix self, int CurEntry, double *& Value, int & RowIndex, int & ColIndex) -> int

        virtual int Epetra_BasicRowMatrix::ExtractMyEntryView(int CurEntry,
        double const *&Value, int &RowIndex, int &ColIndex) const =0

        Returns a const reference to the ith entry in the matrix, along with
        its row and column index.

        Parameters:
        -----------

        CurEntry:  (In) - Index of local entry (from 0 to NumMyNonzeros()-1)
        to extract.

        Value:  (Out) - Extracted reference to current values.

        RowIndex:  (Out) - Row index for current entry.

        ColIndex:  (Out) - Column index for current entry.

        Integer error code, set to 0 if successful, set to -1 if CurEntry not
        valid. 
        """
        return _Epetra.BasicRowMatrix_ExtractMyEntryView(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(BasicRowMatrix self, int MyRow, int & NumEntries) -> int

        virtual int Epetra_BasicRowMatrix::NumMyRowEntries(int MyRow, int
        &NumEntries) const =0

        Return the current number of values stored for the specified local
        row.

        Similar to NumMyEntries() except NumEntries is returned as an argument
        and error checking is done on the input value MyRow.

        Parameters:
        -----------

        MyRow:  (In) - Local row.

        NumEntries:  (Out) - Number of nonzero values.

        Integer error code, set to 0 if successful, set to -1 if MyRow not
        valid. 
        """
        return _Epetra.BasicRowMatrix_NumMyRowEntries(self, *args)


    def Multiply(self, *args):
        """
        Multiply(BasicRowMatrix self, bool TransA, MultiVector X, MultiVector Y) -> int

        int
        Epetra_BasicRowMatrix::Multiply(bool TransA, const Epetra_MultiVector
        &X, Epetra_MultiVector &Y) const

        Returns the result of a Epetra_BasicRowMatrix multiplied by a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        TransA:  (In) - If true, multiply by the transpose of matrix,
        otherwise just use matrix.

        X:  (Out) - An Epetra_MultiVector of dimension NumVectors to multiply
        with matrix.

        Y:  (Out) - An Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve(BasicRowMatrix self, bool Upper, bool Trans, bool UnitDiagonal, MultiVector X, MultiVector Y) -> int

        virtual int
        Epetra_BasicRowMatrix::Solve(bool Upper, bool Trans, bool
        UnitDiagonal, const Epetra_MultiVector &X, Epetra_MultiVector &Y)
        const

        Returns the result of a Epetra_BasicRowMatrix solve with a
        Epetra_MultiVector X in Y (not implemented).

        Parameters:
        -----------

        Upper:  (In) - If true, solve Ux = y, otherwise solve Lx = y.

        Trans:  (In) - If true, solve transpose problem.

        UnitDiagonal:  (In) - If true, assume diagonal is unit (whether it's
        stored or not).

        X:  (In) - An Epetra_MultiVector of dimension NumVectors to solve for.

        Y:  (Out) - An Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_Solve(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(BasicRowMatrix self, Vector Diagonal) -> int

        int Epetra_BasicRowMatrix::ExtractDiagonalCopy(Epetra_Vector
        &Diagonal) const

        Returns a copy of the main diagonal in a user-provided vector.

        Parameters:
        -----------

        Diagonal:  (Out) - Extracted main diagonal.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_ExtractDiagonalCopy(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(BasicRowMatrix self, Vector x) -> int

        int
        Epetra_BasicRowMatrix::InvRowSums(Epetra_Vector &x) const

        Computes the sum of absolute values of the rows of the
        Epetra_BasicRowMatrix, results returned in x.

        The vector x will return such that x[i] will contain the inverse of
        sum of the absolute values of the this matrix will be scaled such that
        A(i,j) = x(i)*A(i,j) where i denotes the global row number of A and j
        denotes the global column number of A. Using the resulting vector from
        this function as input to LeftScale() will make the infinity norm of
        the resulting matrix exactly 1.

        Parameters:
        -----------

        x:  (Out) - An Epetra_Vector containing the row sums of the this
        matrix.

        WARNING:  It is assumed that the distribution of x is the same as the
        rows of this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(BasicRowMatrix self, Vector x) -> int

        int
        Epetra_BasicRowMatrix::LeftScale(const Epetra_Vector &x)

        Scales the Epetra_BasicRowMatrix on the left with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(i)*A(i,j) where i
        denotes the row number of A and j denotes the column number of A.

        Parameters:
        -----------

        x:  (In) - An Epetra_Vector to solve for.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(BasicRowMatrix self, Vector x) -> int

        int
        Epetra_BasicRowMatrix::InvColSums(Epetra_Vector &x) const

        Computes the sum of absolute values of the columns of the
        Epetra_BasicRowMatrix, results returned in x.

        The vector x will return such that x[j] will contain the inverse of
        sum of the absolute values of the this matrix will be sca such that
        A(i,j) = x(j)*A(i,j) where i denotes the global row number of A and j
        denotes the global column number of A. Using the resulting vector from
        this function as input to RighttScale() will make the one norm of the
        resulting matrix exactly 1.

        Parameters:
        -----------

        x:  (Out) - An Epetra_Vector containing the column sums of the this
        matrix.

        WARNING:  It is assumed that the distribution of x is the same as the
        rows of this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(BasicRowMatrix self, Vector x) -> int

        int
        Epetra_BasicRowMatrix::RightScale(const Epetra_Vector &x)

        Scales the Epetra_BasicRowMatrix on the right with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(j)*A(i,j) where i
        denotes the global row number of A and j denotes the global column
        number of A.

        Parameters:
        -----------

        x:  (In) - The Epetra_Vector used for scaling this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_RightScale(self, *args)


    def Filled(self, *args):
        """
        Filled(BasicRowMatrix self) -> bool

        virtual bool
        Epetra_BasicRowMatrix::Filled() const

        If FillComplete() has been called, this query returns true, otherwise
        it returns false, presently always returns true. 
        """
        return _Epetra.BasicRowMatrix_Filled(self, *args)


    def LowerTriangular(self, *args):
        """
        LowerTriangular(BasicRowMatrix self) -> bool

        bool
        Epetra_BasicRowMatrix::LowerTriangular() const

        If matrix is lower triangular, this query returns true, otherwise it
        returns false. 
        """
        return _Epetra.BasicRowMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """
        UpperTriangular(BasicRowMatrix self) -> bool

        virtual bool Epetra_BasicRowMatrix::UpperTriangular() const

        If matrix is upper triangular, this query returns true, otherwise it
        returns false. 
        """
        return _Epetra.BasicRowMatrix_UpperTriangular(self, *args)


    def NormInf(self, *args):
        """
        NormInf(BasicRowMatrix self) -> double

        virtual double
        Epetra_BasicRowMatrix::NormInf() const

        Returns the infinity norm of the global matrix.

        Returns the quantity $ \\| A \\|_\\infty$ such that \\[\\| A
        \\|_\\infty = \\max_{1\\lei\\lem} \\sum_{j=1}^n |a_{ij}|
        \\].

        WARNING:  This method is supported if and only if the Epetra_RowMatrix
        Object that was used to create this supports this method. 
        """
        return _Epetra.BasicRowMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """
        NormOne(BasicRowMatrix self) -> double

        virtual double
        Epetra_BasicRowMatrix::NormOne() const

        Returns the one norm of the global matrix.

        Returns the quantity $ \\| A \\|_1$ such that \\[\\| A
        \\|_1= \\max_{1\\lej\\len} \\sum_{i=1}^m |a_{ij}| \\].

        WARNING:  This method is supported if and only if the Epetra_RowMatrix
        Object that was used to create this supports this method. 
        """
        return _Epetra.BasicRowMatrix_NormOne(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(BasicRowMatrix self) -> int

        virtual int Epetra_BasicRowMatrix::NumGlobalNonzeros() const

        Returns the number of nonzero entries in the global matrix.

        Note that if the data decomposition is defined such that some nonzeros
        appear on multiple processors, then those nonzeros will be counted
        multiple times. 
        """
        return _Epetra.BasicRowMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(BasicRowMatrix self) -> long long

        virtual long long Epetra_BasicRowMatrix::NumGlobalNonzeros64() const

        """
        return _Epetra.BasicRowMatrix_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """
        NumGlobalRows(BasicRowMatrix self) -> int

        virtual
        int Epetra_BasicRowMatrix::NumGlobalRows() const

        Returns the number of global matrix rows. 
        """
        return _Epetra.BasicRowMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """
        NumGlobalRows64(BasicRowMatrix self) -> long long

        virtual long long Epetra_BasicRowMatrix::NumGlobalRows64() const 
        """
        return _Epetra.BasicRowMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """
        NumGlobalCols(BasicRowMatrix self) -> int

        virtual
        int Epetra_BasicRowMatrix::NumGlobalCols() const

        Returns the number of global matrix columns. 
        """
        return _Epetra.BasicRowMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """
        NumGlobalCols64(BasicRowMatrix self) -> long long

        virtual long long Epetra_BasicRowMatrix::NumGlobalCols64() const 
        """
        return _Epetra.BasicRowMatrix_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """
        NumGlobalDiagonals(BasicRowMatrix self) -> int

        virtual int Epetra_BasicRowMatrix::NumGlobalDiagonals() const

        Returns the number of global nonzero diagonal entries. 
        """
        return _Epetra.BasicRowMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """
        NumGlobalDiagonals64(BasicRowMatrix self) -> long long

        virtual long long Epetra_BasicRowMatrix::NumGlobalDiagonals64() const

        """
        return _Epetra.BasicRowMatrix_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(BasicRowMatrix self) -> int

        virtual
        int Epetra_BasicRowMatrix::NumMyNonzeros() const

        Returns the number of nonzero entries in the calling processor's
        portion of the matrix. 
        """
        return _Epetra.BasicRowMatrix_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """
        NumMyRows(BasicRowMatrix self) -> int

        virtual int
        Epetra_BasicRowMatrix::NumMyRows() const

        Returns the number of matrix rows owned by the calling processor. 
        """
        return _Epetra.BasicRowMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """
        NumMyCols(BasicRowMatrix self) -> int

        virtual int
        Epetra_BasicRowMatrix::NumMyCols() const

        Returns the number of matrix columns owned by the calling processor.

        """
        return _Epetra.BasicRowMatrix_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """
        NumMyDiagonals(BasicRowMatrix self) -> int

        virtual
        int Epetra_BasicRowMatrix::NumMyDiagonals() const

        Returns the number of local nonzero diagonal entries. 
        """
        return _Epetra.BasicRowMatrix_NumMyDiagonals(self, *args)


    def MaxNumEntries(self, *args):
        """
        MaxNumEntries(BasicRowMatrix self) -> int

        virtual
        int Epetra_BasicRowMatrix::MaxNumEntries() const

        Returns the maximum number of nonzero entries across all rows on this
        processor. 
        """
        return _Epetra.BasicRowMatrix_MaxNumEntries(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(BasicRowMatrix self) -> Map

        virtual const Epetra_Map& Epetra_BasicRowMatrix::OperatorDomainMap()
        const

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _Epetra.BasicRowMatrix_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(BasicRowMatrix self) -> Map

        virtual const Epetra_Map& Epetra_BasicRowMatrix::OperatorRangeMap()
        const

        Returns the Epetra_Map object associated with the range of this
        operator (same as domain). 
        """
        return _Epetra.BasicRowMatrix_OperatorRangeMap(self, *args)


    def Map(self, *args):
        """
        Map(BasicRowMatrix self) -> BlockMap

        virtual const
        Epetra_BlockMap& Epetra_BasicRowMatrix::Map() const

        Implement the Epetra_SrcDistObjec::Map() function. 
        """
        return _Epetra.BasicRowMatrix_Map(self, *args)


    def RowMatrixRowMap(self, *args):
        """
        RowMatrixRowMap(BasicRowMatrix self) -> Map

        virtual const Epetra_Map& Epetra_BasicRowMatrix::RowMatrixRowMap()
        const

        Returns the Row Map object needed for implementing Epetra_RowMatrix.

        """
        return _Epetra.BasicRowMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """
        RowMatrixColMap(BasicRowMatrix self) -> Map

        virtual const Epetra_Map& Epetra_BasicRowMatrix::RowMatrixColMap()
        const

        Returns the Column Map object needed for implementing
        Epetra_RowMatrix. 
        """
        return _Epetra.BasicRowMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """
        RowMatrixImporter(BasicRowMatrix self) -> Import

        virtual const Epetra_Import*
        Epetra_BasicRowMatrix::RowMatrixImporter() const

        Returns the Epetra_Import object that contains the import operations
        for distributed operations. 
        """
        return _Epetra.BasicRowMatrix_RowMatrixImporter(self, *args)


    def Comm(self, *args):
        """
        Comm(BasicRowMatrix self) -> Comm

        virtual const
        Epetra_Comm& Epetra_BasicRowMatrix::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        matrix. 
        """
        return _Epetra.BasicRowMatrix_Comm(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(BasicRowMatrix self, bool use_transpose) -> int

        virtual int Epetra_BasicRowMatrix::SetUseTranspose(bool use_transpose)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        use_transpose:  (In) - If true, multiply by the transpose of operator,
        otherwise just use operator.

        Always returns 0. 
        """
        return _Epetra.BasicRowMatrix_SetUseTranspose(self, *args)


    def Label(self, *args):
        """
        Label(BasicRowMatrix self) -> char const *

        virtual const
        char* Epetra_BasicRowMatrix::Label() const

        Returns a character string describing the operator. 
        """
        return _Epetra.BasicRowMatrix_Label(self, *args)


    def Apply(self, *args):
        """
        Apply(BasicRowMatrix self, MultiVector X, MultiVector Y) -> int

        virtual int
        Epetra_BasicRowMatrix::Apply(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_RowMatrix applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        X:  (In) - A Epetra_MultiVector of dimension NumVectors to multiply
        with matrix.

        Y:  (Out) - A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.BasicRowMatrix_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(BasicRowMatrix self, MultiVector X, MultiVector Y) -> int

        virtual
        int Epetra_BasicRowMatrix::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_RowMatrix inverse applied to an
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        X:  (In) - A Epetra_MultiVector of dimension NumVectors to solve for.

        Y:  (Out) - A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code = -1.

        WARNING:  This method is NOT supported. 
        """
        return _Epetra.BasicRowMatrix_ApplyInverse(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(BasicRowMatrix self) -> bool

        bool
        Epetra_BasicRowMatrix::HasNormInf() const

        Returns true because this class can compute an Inf-norm. 
        """
        return _Epetra.BasicRowMatrix_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(BasicRowMatrix self) -> bool

        virtual
        bool Epetra_BasicRowMatrix::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Epetra.BasicRowMatrix_UseTranspose(self, *args)


    def Importer(self, *args):
        """
        Importer(BasicRowMatrix self) -> Import

        virtual const
        Epetra_Import* Epetra_BasicRowMatrix::Importer() const

        Returns the Epetra_Import object that contains the import operations
        for distributed operations, returns zero if none.

        If RowMatrixColMap!=OperatorDomainMap, then this method returns a
        pointer to an Epetra_Import object that imports objects from an
        OperatorDomainMap layout to a RowMatrixColMap layout. This operation
        is needed for sparse matrix- vector multiplication, y = Ax, to gather
        x elements for local multiplication operations.

        If RowMatrixColMap==OperatorDomainMap, then the pointer will be
        returned as 0.

        Raw pointer to importer. This importer will be valid as long as the
        Epetra_RowMatrix object is valid. 
        """
        return _Epetra.BasicRowMatrix_Importer(self, *args)


    def Exporter(self, *args):
        """
        Exporter(BasicRowMatrix self) -> Export

        virtual const
        Epetra_Export* Epetra_BasicRowMatrix::Exporter() const

        Returns the Epetra_Export object that contains the export operations
        for distributed operations, returns zero if none.

        If RowMatrixRowMap!=OperatorRangeMap, then this method returns a
        pointer to an Epetra_Export object that exports objects from an
        RowMatrixRowMap layout to a OperatorRangeMap layout. This operation is
        needed for sparse matrix- vector multiplication, y = Ax, to scatter-
        add y elements generated during local multiplication operations.

        If RowMatrixRowMap==OperatorRangeMap, then the pointer will be
        returned as 0. For a typical Epetra_RowMatrix object, this pointer
        will be zero since it is often the case that
        RowMatrixRowMap==OperatorRangeMap.

        Raw pointer to exporter. This exporter will be valid as long as the
        Epetra_RowMatrix object is valid. 
        """
        return _Epetra.BasicRowMatrix_Exporter(self, *args)


    def ComputeStructureConstants(self, *args):
        """ComputeStructureConstants(BasicRowMatrix self)"""
        return _Epetra.BasicRowMatrix_ComputeStructureConstants(self, *args)


    def ComputeNumericConstants(self, *args):
        """ComputeNumericConstants(BasicRowMatrix self)"""
        return _Epetra.BasicRowMatrix_ComputeNumericConstants(self, *args)

    def __disown__(self):
        self.this.disown()
        _Epetra.disown_BasicRowMatrix(self)
        return weakref_proxy(self)
BasicRowMatrix_swigregister = _Epetra.BasicRowMatrix_swigregister
BasicRowMatrix_swigregister(BasicRowMatrix)

class CrsMatrix(DistObject, CompObject, BLAS, RowMatrix):
    """


    Epetra_CrsMatrix: A class for constructing and using real-valued
    double-precision sparse compressed row matrices.

    The Epetra_CrsMatrix class is a sparse compressed row matrix object.
    This matrix can be used in a parallel setting, with data distribution
    described by Epetra_Map attributes. The structure or graph of the
    matrix is defined by an Epetra_CrsGraph attribute.

    In addition to coefficient access, the primary operations provided by
    Epetra_CrsMatrix are matrix times vector and matrix times multi-vector
    multiplication.

    Epetra_CrsMatrix matrices can be square or rectangular.

    Creating and filling Epetra_CrsMatrix objects

    Constructing Epetra_CrsMatrix objects is a multi-step process. The
    basic steps are as follows: Create Epetra_CrsMatrix instance,
    including storage, via one of the constructors: Constructor that
    accepts one Epetra_Map object, a row-map defining the distribution of
    matrix rows.

    Constructor that accepts two Epetra_Map objects. (The second map is a
    column-map, and describes the set of column-indices that appear in
    each processor's portion of the matrix. Generally these are
    overlapping sets column-indices may appear on more than one
    processor.)

    Constructor that accepts an Epetra_CrsGraph object, defining the non-
    zero structure of the matrix.  Note that the constructors which accept
    Epetra_Map arguments also accept an argument that gives an estimate of
    the number of nonzeros per row. This allows storage to be pre-
    allocated and can improve the performance of the data input methods.
    The estimate need not be accurate, as additional storage is allocated
    automatically when needed. However, a more accurate estimate helps
    performance by reducing the amount of extra memory allocation.

    Enter values via one or more Insert/Replace/SumInto functions.

    Complete construction by calling FillComplete.

    Note that, even after a matrix is constructed (FillComplete has been
    called), it is possible to update existing matrix entries. It is not
    possible to create new entries.

    Epetra_Map attributes

    Epetra_CrsMatrix objects have four Epetra_Map attributes, which are
    held by the Epetra_CrsGraph attribute.

    The Epetra_Map attributes can be obtained via these accessor methods:
    RowMap() Describes the numbering and distribution of the rows of the
    matrix. The row-map exists and is valid for the entire life of the
    matrix. The set of matrix rows is defined by the row-map and may not
    be changed. Rows may not be inserted or deleted by the user. The only
    change that may be made is that the user can replace the row-map with
    a compatible row-map (which is the same except for re-numbering) by
    calling the ReplaceRowMap() method.

    ColMap() Describes the set of column-indices that appear in the rows
    in each processor's portion of the matrix. Unless provided by the user
    at construction time, a valid column-map doesn't exist until
    FillComplete() is called.

    RangeMap() Describes the range of the matrix operator. e.g., for a
    matrix-vector product operation, the result vector's map must be
    compatible with the range-map of this matrix. The range-map is usually
    the same as the row-map. The range-map is set equal to the row-map at
    matrix creation time, but may be specified by the user when
    FillComplete() is called.

    DomainMap() Describes the domain of the matrix operator. The domain-
    map can be specified by the user when FillComplete() is called. Until
    then, it is set equal to the row-map.

    It is important to note that while the row-map and the range-map are
    often the same, the column-map and the domain-map are almost never the
    same. The set of entries in a distributed column-map almost always
    form overlapping sets, with entries being associated with more than
    one processor. A domain-map, on the other hand, must be a 1-to-1 map,
    with entries being associated with only a single processor.

    Local versus Global Indices

    Epetra_CrsMatrix has query functions IndicesAreLocal() and
    IndicesAreGlobal(), which are used to determine whether the underlying
    Epetra_CrsGraph attribute's column-indices have been transformed into
    a local index space or not. (This transformation occurs when the
    method Epetra_CrsGraph::FillComplete() is called, which happens when
    the method Epetra_CrsMatrix::FillComplete() is called.) The state of
    the indices in the graph determines the behavior of many
    Epetra_CrsMatrix methods. If an Epetra_CrsMatrix instance is
    constructed using one of the constructors that does not accept a pre-
    existing Epetra_CrsGraph object, then an Epetra_CrsGraph attribute is
    created internally and its indices remain untransformed (
    IndicesAreGlobal()==true) until Epetra_CrsMatrix::FillComplete() is
    called. The query function Epetra_CrsMatrix::Filled() returns true if
    Epetra_CrsMatrix::FillComplete() has been called.

    Note the following method characteristics:

    InsertGlobalValues() may only be used to insert new nonzeros in the
    matrix if indices are global.

    SumIntoGlobalValues() may be used regardless of whether indices are
    global or local, but can only be used to update matrix locations that
    already exist; it can never be used to establish new nonzero
    locations.

    ReplaceGlobalValues() may also be used only to update matrix locations
    that already exist, and works regardless of whether indices are local
    or global.

    SumIntoMyValues() and ReplaceMyValues() may only be used if indices
    are local.

    Multiply() may only be used after FillComplete() has been called.

    Most methods have preconditions documented, check documentation for
    specific methods not mentioned here.

    Counting Floating Point Operations

    Each Epetra_CrsMatrix object keeps track of the number of serial
    floating point operations performed using the specified object as the
    this argument to the function. The Flops() function returns this
    number as a double precision number. Using this information, in
    conjunction with the Epetra_Time class, one can get accurate parallel
    performance numbers. The ResetFlops() function resets the floating
    point counter.

    WARNING:  A Epetra_Map is required for the Epetra_CrsMatrix
    constructor.

    C++ includes: Epetra_CrsMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_CrsMatrix

    def PutScalar(self, *args):
        """
        PutScalar(CrsMatrix self, double ScalarConstant) -> int

        int
        Epetra_CrsMatrix::PutScalar(double ScalarConstant)

        Initialize all values in the matrix with constant value.

        Parameters:
        -----------

        ScalarConstant:  - (In) Value to use.

        Integer error code, set to 0 if successful.

        None.

        All values in this set to ScalarConstant. 
        """
        return _Epetra.CrsMatrix_PutScalar(self, *args)


    def Scale(self, *args):
        """
        Scale(CrsMatrix self, double ScalarConstant) -> int

        int
        Epetra_CrsMatrix::Scale(double ScalarConstant)

        Multiply all values in the matrix by a constant value (in place: A <-
        ScalarConstant * A).

        Parameters:
        -----------

        ScalarConstant:  - (In) Value to use.

        Integer error code, set to 0 if successful.

        None.

        All values of this have been multiplied by ScalarConstant. 
        """
        return _Epetra.CrsMatrix_Scale(self, *args)


    def ReplaceDiagonalValues(self, *args):
        """
        ReplaceDiagonalValues(CrsMatrix self, Vector Diagonal) -> int

        int
        Epetra_CrsMatrix::ReplaceDiagonalValues(const Epetra_Vector &Diagonal)

        Replaces diagonal values of the matrix with those in the user-provided
        vector.

        This routine is meant to allow replacement of {\\bf existing}
        diagonal values. If a diagonal value does not exist for a given row,
        the corresponding value in the input Epetra_Vector will be ignored and
        the return code will be set to 1.

        The Epetra_Map associated with the input Epetra_Vector must be
        compatible with the RowMap of the matrix.

        Parameters:
        -----------

        Diagonal:  - (In) New values to be placed in the main diagonal.

        Integer error code, set to 0 if successful, set to 1 on the calling
        processor if one or more diagonal entries not present in matrix.

        Filled()==true

        Diagonal values have been replaced with the values of Diagonal. 
        """
        return _Epetra.CrsMatrix_ReplaceDiagonalValues(self, *args)


    def FillComplete(self, *args):
        """
        FillComplete(CrsMatrix self, bool OptimizeDataStorage=True) -> int
        FillComplete(CrsMatrix self, Map DomainMap, Map RangeMap, bool OptimizeDataStorage=True) -> int

        int
        Epetra_CrsMatrix::FillComplete(const Epetra_Map &DomainMap, const
        Epetra_Map &RangeMap, bool OptimizeDataStorage=true)

        Signal that data entry is complete. Perform transformations to local
        index space. 
        """
        return _Epetra.CrsMatrix_FillComplete(self, *args)


    def OptimizeStorage(self, *args):
        """
        OptimizeStorage(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::OptimizeStorage()

        Make consecutive row index sections contiguous, minimize internal
        storage used for constructing graph.

        After construction and during initialization (when values are being
        added), the matrix coefficients for each row are managed as separate
        segments of memory. This method moves the values for all rows into one
        large contiguous array and eliminates internal storage that is not
        needed after matrix construction. Calling this method can have a
        significant impact on memory costs and machine performance.

        If this object was constructed in View mode then this method can't
        make non-contiguous values contiguous and will return a warning code
        of 1 if the viewed data isn't already contiguous.

        A call to this method will also call the OptimizeStorage method for
        the associated Epetra_CrsGraph object. If the storage for this graph
        has already been optimized this additional call will have no effect.

        Integer error code, set to 0 if successful.

        Filled()==true.

        If CV=View when the graph was constructed, then this method will be
        effective \\only if the indices of the graph were already
        contiguous. In this case, the indices are left untouched and internal
        storage for the graph is minimized.

        StorageOptimized()==true, if successful.

        Graph(). StorageOptimized()==true, if successful. 
        """
        return _Epetra.CrsMatrix_OptimizeStorage(self, *args)


    def MakeDataContiguous(self, *args):
        """
        MakeDataContiguous(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::MakeDataContiguous()

        Eliminates memory that is used for construction. Make consecutive row
        index sections contiguous. 
        """
        return _Epetra.CrsMatrix_MakeDataContiguous(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(CrsMatrix self, Vector Diagonal) -> int

        int
        Epetra_CrsMatrix::ExtractDiagonalCopy(Epetra_Vector &Diagonal) const

        Returns a copy of the main diagonal in a user-provided vector.

        Parameters:
        -----------

        Diagonal:  - (Out) Extracted main diagonal.

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_ExtractDiagonalCopy(self, *args)


    def Multiply(self, *args):
        """
        Multiply(CrsMatrix self, bool TransA, MultiVector X, MultiVector Y) -> int

        int
        Epetra_CrsMatrix::Multiply(bool TransA, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_CrsMatrix multiplied by a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        TransA:  - (In) If true, multiply by the transpose of matrix,
        otherwise just use matrix.

        X:  - (In) An Epetra_MultiVector of dimension NumVectors to multiply
        with matrix.

        Y:  - (Out) An Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_Multiply(self, *args)


    def Multiply1(self, *args):
        """
        Multiply1(CrsMatrix self, bool TransA, MultiVector X, MultiVector Y) -> int

        int
        Epetra_CrsMatrix::Multiply1(bool TransA, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const 
        """
        return _Epetra.CrsMatrix_Multiply1(self, *args)


    def Solve(self, *args):
        """
        Solve(CrsMatrix self, bool Upper, bool Trans, bool UnitDiagonal, MultiVector X, MultiVector Y) -> int

        int
        Epetra_CrsMatrix::Solve(bool Upper, bool Trans, bool UnitDiagonal,
        const Epetra_MultiVector &X, Epetra_MultiVector &Y) const

        Returns the result of a local solve using the Epetra_CrsMatrix a
        Epetra_MultiVector X in Y.

        This method solves a triangular system of equations asynchronously on
        each processor.

        Parameters:
        -----------

        Upper:  - (In) If true, solve Uy = x, otherwise solve Ly = x.

        Trans:  - (In) If true, solve transpose problem.

        UnitDiagonal:  - (In) If true, assume diagonal is unit (whether it's
        stored or not).

        X:  - (In) An Epetra_MultiVector of dimension NumVectors to solve for.

        Y:  - (Out) An Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(CrsMatrix self, Vector x) -> int

        int
        Epetra_CrsMatrix::InvRowSums(Epetra_Vector &x) const

        Computes the inverse of the sum of absolute values of the rows of the
        Epetra_CrsMatrix, results returned in x.

        The vector x will return such that x[i] will contain the inverse of
        the sum of the absolute values of the entries in the ith row of the
        this matrix. Using the resulting vector from this function as input to
        LeftScale() will make the infinity norm of the resulting matrix
        exactly 1. WARNING:  The NormInf() method will not properly calculate
        the infinity norm for a matrix that has entries that are replicated on
        multiple processors. In this case, if the rows are fully replicated,
        NormInf() will return a value equal to the maximum number of
        processors that any individual row of the matrix is replicated on.

        Parameters:
        -----------

        x:  - (Out) An Epetra_Vector containing the inverse of the row sums of
        the this matrix.

        WARNING:  When rows are fully replicated on multiple processors, it is
        assumed that the distribution of x is the same as the rows (
        RowMap())of this. When multiple processors contain partial sums for
        individual entries, the distribution of x is assumed to be the same as
        the RangeMap() of this. When each row of this is uniquely owned, the
        distribution of x can be that of the RowMap() or the RangeMap().

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_InvRowSums(self, *args)


    def InvRowMaxs(self, *args):
        """
        InvRowMaxs(CrsMatrix self, Vector x) -> int

        int
        Epetra_CrsMatrix::InvRowMaxs(Epetra_Vector &x) const

        Computes the inverse of the max of absolute values of the rows of the
        Epetra_CrsMatrix, results returned in x.

        The vector x will return such that x[i] will contain the inverse of
        max of the absolute values of the entries in the ith row of the this
        matrix. WARNING:  This method will not work when multiple processors
        contain partial sums for individual entries.

        Parameters:
        -----------

        x:  - (Out) An Epetra_Vector containing the inverse of the row maxs of
        the this matrix.

        WARNING:  When rows are fully replicated on multiple processors, it is
        assumed that the distribution of x is the same as the rows (
        RowMap())of this. When each row of this is uniquely owned, the
        distribution of x can be that of the RowMap() or the RangeMap().

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_InvRowMaxs(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(CrsMatrix self, Vector x) -> int

        int
        Epetra_CrsMatrix::LeftScale(const Epetra_Vector &x)

        Scales the Epetra_CrsMatrix on the left with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(i)*A(i,j) where i
        denotes the row number of A and j denotes the column number of A.

        Parameters:
        -----------

        x:  - (In) An Epetra_Vector to scale with.

        Integer error code, set to 0 if successful.

        Filled()==true

        The matrix will be scaled as described above. 
        """
        return _Epetra.CrsMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(CrsMatrix self, Vector x) -> int

        int
        Epetra_CrsMatrix::InvColSums(Epetra_Vector &x) const

        Computes the inverse of the sum of absolute values of the columns of
        the Epetra_CrsMatrix, results returned in x.

        The vector x will return such that x[j] will contain the inverse of
        the sum of the absolute values of the entries in the jth column of the
        this matrix. Using the resulting vector from this function as input to
        RightScale() will make the one norm of the resulting matrix exactly 1.
        WARNING:  The NormOne() method will not properly calculate the one
        norm for a matrix that has entries that are replicated on multiple
        processors. In this case, if the columns are fully replicated,
        NormOne() will return a value equal to the maximum number of
        processors that any individual column of the matrix is repliated on.

        Parameters:
        -----------

        x:  - (Out) An Epetra_Vector containing the column sums of the this
        matrix.

        WARNING:  When columns are fully replicated on multiple processors, it
        is assumed that the distribution of x is the same as the columns (
        ColMap()) of this. When multiple processors contain partial sums for
        entries, the distribution of x is assumed to be the same as the
        DomainMap() of this. When each column of this is uniquely owned, the
        distribution of x can be that of the ColMap() or the DomainMap().

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_InvColSums(self, *args)


    def InvColMaxs(self, *args):
        """
        InvColMaxs(CrsMatrix self, Vector x) -> int

        int
        Epetra_CrsMatrix::InvColMaxs(Epetra_Vector &x) const

        Computes the max of absolute values of the columns of the
        Epetra_CrsMatrix, results returned in x.

        The vector x will return such that x[j] will contain the inverse of
        max of the absolute values of the entries in the jth row of the this
        matrix. WARNING:  This method will not work when multiple processors
        contain partial sums for individual entries.

        Parameters:
        -----------

        x:  - (Out) An Epetra_Vector containing the column maxs of the this
        matrix.

        WARNING:  When columns are fully replicated on multiple processors, it
        is assumed that the distribution of x is the same as the columns (
        ColMap()) of this. When each column of this is uniquely owned, the
        distribution of x can be that of the ColMap() or the DomainMap().

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_InvColMaxs(self, *args)


    def RightScale(self, *args):
        """
        RightScale(CrsMatrix self, Vector x) -> int

        int
        Epetra_CrsMatrix::RightScale(const Epetra_Vector &x)

        Scales the Epetra_CrsMatrix on the right with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(j)*A(i,j) where i
        denotes the global row number of A and j denotes the global column
        number of A.

        Parameters:
        -----------

        x:  - (In) The Epetra_Vector used for scaling this.

        Integer error code, set to 0 if successful.

        Filled()==true

        The matrix will be scaled as described above. 
        """
        return _Epetra.CrsMatrix_RightScale(self, *args)


    def Filled(self, *args):
        """
        Filled(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::Filled() const

        If FillComplete() has been called, this query returns true, otherwise
        it returns false. 
        """
        return _Epetra.CrsMatrix_Filled(self, *args)


    def StorageOptimized(self, *args):
        """
        StorageOptimized(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::StorageOptimized() const

        If OptimizeStorage() has been called, this query returns true,
        otherwise it returns false. 
        """
        return _Epetra.CrsMatrix_StorageOptimized(self, *args)


    def IndicesAreGlobal(self, *args):
        """
        IndicesAreGlobal(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::IndicesAreGlobal() const

        If matrix indices has not been transformed to local, this query
        returns true, otherwise it returns false. 
        """
        return _Epetra.CrsMatrix_IndicesAreGlobal(self, *args)


    def IndicesAreLocal(self, *args):
        """
        IndicesAreLocal(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::IndicesAreLocal() const

        If matrix indices has been transformed to local, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.CrsMatrix_IndicesAreLocal(self, *args)


    def IndicesAreContiguous(self, *args):
        """
        IndicesAreContiguous(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::IndicesAreContiguous() const

        If matrix indices are packed into single array (done in
        OptimizeStorage()) return true, otherwise false. 
        """
        return _Epetra.CrsMatrix_IndicesAreContiguous(self, *args)


    def LowerTriangular(self, *args):
        """
        LowerTriangular(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::LowerTriangular() const

        If matrix is lower triangular in local index space, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.CrsMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """
        UpperTriangular(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::UpperTriangular() const

        If matrix is upper triangular in local index space, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.CrsMatrix_UpperTriangular(self, *args)


    def NoDiagonal(self, *args):
        """
        NoDiagonal(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::NoDiagonal() const

        If matrix has no diagonal entries in global index space, this query
        returns true, otherwise it returns false. 
        """
        return _Epetra.CrsMatrix_NoDiagonal(self, *args)


    def NormInf(self, *args):
        """
        NormInf(CrsMatrix self) -> double

        double
        Epetra_CrsMatrix::NormInf() const

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.CrsMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """
        NormOne(CrsMatrix self) -> double

        double
        Epetra_CrsMatrix::NormOne() const

        Returns the one norm of the global matrix. 
        """
        return _Epetra.CrsMatrix_NormOne(self, *args)


    def NormFrobenius(self, *args):
        """
        NormFrobenius(CrsMatrix self) -> double

        double
        Epetra_CrsMatrix::NormFrobenius() const

        Returns the frobenius norm of the global matrix. 
        """
        return _Epetra.CrsMatrix_NormFrobenius(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumGlobalNonzeros() const

        Returns the number of nonzero entries in the global matrix. 
        """
        return _Epetra.CrsMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(CrsMatrix self) -> long long

        long
        long Epetra_CrsMatrix::NumGlobalNonzeros64() const 
        """
        return _Epetra.CrsMatrix_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """
        NumGlobalRows(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumGlobalRows() const

        Returns the number of global matrix rows. 
        """
        return _Epetra.CrsMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """
        NumGlobalRows64(CrsMatrix self) -> long long

        long long
        Epetra_CrsMatrix::NumGlobalRows64() const 
        """
        return _Epetra.CrsMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """
        NumGlobalCols(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumGlobalCols() const

        Returns the number of global matrix columns. 
        """
        return _Epetra.CrsMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """
        NumGlobalCols64(CrsMatrix self) -> long long

        long long
        Epetra_CrsMatrix::NumGlobalCols64() const 
        """
        return _Epetra.CrsMatrix_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """
        NumGlobalDiagonals(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumGlobalDiagonals() const

        Returns the number of global nonzero diagonal entries, based on global
        row/column index comparisons. 
        """
        return _Epetra.CrsMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """
        NumGlobalDiagonals64(CrsMatrix self) -> long long

        long
        long Epetra_CrsMatrix::NumGlobalDiagonals64() const 
        """
        return _Epetra.CrsMatrix_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumMyNonzeros() const

        Returns the number of nonzero entries in the calling processor's
        portion of the matrix. 
        """
        return _Epetra.CrsMatrix_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """
        NumMyRows(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumMyRows() const

        Returns the number of matrix rows owned by the calling processor. 
        """
        return _Epetra.CrsMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """
        NumMyCols(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumMyCols() const

        Returns the number of entries in the set of column-indices that appear
        on this processor.

        The set of column-indices that appear on this processor is the union
        of column-indices that appear in all local rows. The size of this set
        isn't available until FillComplete() has been called.  Filled()==true

        """
        return _Epetra.CrsMatrix_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """
        NumMyDiagonals(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::NumMyDiagonals() const

        Returns the number of local nonzero diagonal entries, based on global
        row/column index comparisons.

        Filled()==true 
        """
        return _Epetra.CrsMatrix_NumMyDiagonals(self, *args)


    def NumGlobalEntries(self, *args):
        """
        NumGlobalEntries(CrsMatrix self, long long Row) -> int

        int
        Epetra_CrsMatrix::NumGlobalEntries(long long Row) const

        Returns the current number of nonzero entries in specified global row
        on this processor. 
        """
        return _Epetra.CrsMatrix_NumGlobalEntries(self, *args)


    def NumAllocatedGlobalEntries(self, *args):
        """
        NumAllocatedGlobalEntries(CrsMatrix self, int Row) -> int

        int Epetra_CrsMatrix::NumAllocatedGlobalEntries(int Row) const

        Returns the allocated number of nonzero entries in specified global
        row on this processor. 
        """
        return _Epetra.CrsMatrix_NumAllocatedGlobalEntries(self, *args)


    def MaxNumEntries(self, *args):
        """
        MaxNumEntries(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::MaxNumEntries() const

        Returns the maximum number of nonzero entries across all rows on this
        processor.

        Filled()==true 
        """
        return _Epetra.CrsMatrix_MaxNumEntries(self, *args)


    def GlobalMaxNumEntries(self, *args):
        """
        GlobalMaxNumEntries(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::GlobalMaxNumEntries() const

        Returns the maximum number of nonzero entries across all rows on all
        processors.

        Filled()==true 
        """
        return _Epetra.CrsMatrix_GlobalMaxNumEntries(self, *args)


    def NumMyEntries(self, *args):
        """
        NumMyEntries(CrsMatrix self, int Row) -> int

        int
        Epetra_CrsMatrix::NumMyEntries(int Row) const

        Returns the current number of nonzero entries in specified local row
        on this processor. 
        """
        return _Epetra.CrsMatrix_NumMyEntries(self, *args)


    def NumAllocatedMyEntries(self, *args):
        """
        NumAllocatedMyEntries(CrsMatrix self, int Row) -> int

        int
        Epetra_CrsMatrix::NumAllocatedMyEntries(int Row) const

        Returns the allocated number of nonzero entries in specified local row
        on this processor. 
        """
        return _Epetra.CrsMatrix_NumAllocatedMyEntries(self, *args)


    def IndexBase(self, *args):
        """
        IndexBase(CrsMatrix self) -> int

        int
        Epetra_CrsMatrix::IndexBase() const

        Returns the index base for row and column indices for this graph.

        Index base for this map. 
        """
        return _Epetra.CrsMatrix_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """
        IndexBase64(CrsMatrix self) -> long long

        long long
        Epetra_CrsMatrix::IndexBase64() const 
        """
        return _Epetra.CrsMatrix_IndexBase64(self, *args)


    def StaticGraph(self, *args):
        """
        StaticGraph(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::StaticGraph()

        Returns true if the graph associated with this matrix was pre-
        constructed and therefore not changeable. 
        """
        return _Epetra.CrsMatrix_StaticGraph(self, *args)


    def Graph(self, *args):
        """
        Graph(CrsMatrix self) -> CrsGraph

        const
        Epetra_CrsGraph& Epetra_CrsMatrix::Graph() const

        Returns a reference to the Epetra_CrsGraph object associated with this
        matrix. 
        """
        return _Epetra.CrsMatrix_Graph(self, *args)


    def RowMap(self, *args):
        """
        RowMap(CrsMatrix self) -> Map

        const Epetra_Map&
        Epetra_CrsMatrix::RowMap() const

        Returns the Epetra_Map object associated with the rows of this matrix.

        """
        return _Epetra.CrsMatrix_RowMap(self, *args)


    def ReplaceRowMap(self, *args):
        """
        ReplaceRowMap(CrsMatrix self, BlockMap newmap) -> int

        int
        Epetra_CrsMatrix::ReplaceRowMap(const Epetra_BlockMap &newmap)

        Replaces the current RowMap with the user-specified map object.

        Replaces the current RowMap with the user-specified map object, but
        only if currentmap->PointSameAs(newmap) is true. This is a collective
        function. Returns 0 if map is replaced, -1 if not.

        RowMap().PointSameAs(newmap)==true 
        """
        return _Epetra.CrsMatrix_ReplaceRowMap(self, *args)


    def HaveColMap(self, *args):
        """
        HaveColMap(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::HaveColMap() const

        Returns true if we have a well-defined ColMap, and returns false
        otherwise.

        We have a well-defined ColMap if a) a ColMap was passed in at
        construction, or b) the MakeColMap function has been called. (Calling
        either of the FillComplete functions will result in MakeColMap being
        called.) 
        """
        return _Epetra.CrsMatrix_HaveColMap(self, *args)


    def ReplaceColMap(self, *args):
        """
        ReplaceColMap(CrsMatrix self, BlockMap newmap) -> int

        int
        Epetra_CrsMatrix::ReplaceColMap(const Epetra_BlockMap &newmap)

        Replaces the current ColMap with the user-specified map object.

        Replaces the current ColMap with the user-specified map object, but
        only if no entries have been inserted into the matrix (both
        IndicesAreLocal() and IndicesAreGlobal() are false) or
        currentmap->PointSameAs(newmap) is true. This is a collective
        function. Returns 0 if map is replaced, -1 if not.

        ( IndicesAreLocal()==false && IndicesAreGlobal()==false) ||
        ColMap().PointSameAs(newmap)==true 
        """
        return _Epetra.CrsMatrix_ReplaceColMap(self, *args)


    def ReplaceDomainMapAndImporter(self, *args):
        """
        ReplaceDomainMapAndImporter(CrsMatrix self, Map NewDomainMap, Import NewImporter) -> int

        int Epetra_CrsMatrix::ReplaceDomainMapAndImporter(const Epetra_Map
        &NewDomainMap, const Epetra_Import *NewImporter)

        Replaces the current DomainMap & Importer with the user-specified map
        object.

        Replaces the current DomainMap and Importer with the user-specified
        map object, but only if the matrix has been FillCompleted, Importer's
        TargetMap matches the ColMap and Importer's SourceMap matches the
        DomainMap (assuming the importer isn't null). If an Importer is passed
        in, Epetra_CrsMatrix will copy it.

        Returns 0 if map/importer is replaced, -1 if not.

        (!NewImporter && ColMap().PointSameAs(NewDomainMap)) || (NewImporter
        && ColMap().PointSameAs(NewImporter->TargetMap()) &&
        NewDomainMap.PointSameAs(NewImporter->SourceMap())) 
        """
        return _Epetra.CrsMatrix_ReplaceDomainMapAndImporter(self, *args)


    def RemoveEmptyProcessesInPlace(self, *args):
        """
        RemoveEmptyProcessesInPlace(CrsMatrix self, BlockMap NewMap) -> int

        int Epetra_CrsMatrix::RemoveEmptyProcessesInPlace(const
        Epetra_BlockMap *NewMap)

        Remove processes owning zero rows from the Maps and their
        communicator.

        Remove processes owning zero rows from the Maps and their
        communicator. WARNING:  This method is ONLY for use by experts.

        WARNING:  We make NO promises of backwards compatibility. This method
        may change or disappear at any time.

        Parameters:
        -----------

        newMap:  [in] This must be the result of calling the
        removeEmptyProcesses() method on the row Map. If it is not, this
        method's behavior is undefined. This pointer will be null on excluded
        processes. 
        """
        return _Epetra.CrsMatrix_RemoveEmptyProcessesInPlace(self, *args)


    def ColMap(self, *args):
        """
        ColMap(CrsMatrix self) -> Map

        const Epetra_Map&
        Epetra_CrsMatrix::ColMap() const

        Returns the Epetra_Map object that describes the set of column-indices
        that appear in each processor's locally owned matrix rows.

        Note that if the matrix was constructed with only a row-map, then
        until FillComplete() is called, this method returns a column-map that
        is a copy of the row-map. That 'initial' column-map is replaced with a
        computed column- map (that contains the set of column-indices
        appearing in each processor's local portion of the matrix) when
        FillComplete() is called.

        HaveColMap()==true 
        """
        return _Epetra.CrsMatrix_ColMap(self, *args)


    def DomainMap(self, *args):
        """
        DomainMap(CrsMatrix self) -> Map

        const Epetra_Map&
        Epetra_CrsMatrix::DomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        matrix operator.

        Filled()==true 
        """
        return _Epetra.CrsMatrix_DomainMap(self, *args)


    def RangeMap(self, *args):
        """
        RangeMap(CrsMatrix self) -> Map

        const Epetra_Map&
        Epetra_CrsMatrix::RangeMap() const

        Returns the Epetra_Map object associated with the range of this matrix
        operator.

        Filled()==true 
        """
        return _Epetra.CrsMatrix_RangeMap(self, *args)


    def Importer(self, *args):
        """
        Importer(CrsMatrix self) -> Import

        const
        Epetra_Import* Epetra_CrsMatrix::Importer() const

        Returns the Epetra_Import object that contains the import operations
        for distributed operations. 
        """
        return _Epetra.CrsMatrix_Importer(self, *args)


    def Exporter(self, *args):
        """
        Exporter(CrsMatrix self) -> Export

        const
        Epetra_Export* Epetra_CrsMatrix::Exporter() const

        Returns the Epetra_Export object that contains the export operations
        for distributed operations. 
        """
        return _Epetra.CrsMatrix_Exporter(self, *args)


    def Comm(self, *args):
        """
        Comm(CrsMatrix self) -> Comm

        const Epetra_Comm&
        Epetra_CrsMatrix::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        matrix. 
        """
        return _Epetra.CrsMatrix_Comm(self, *args)


    def LRID(self, *args):
        """
        LRID(CrsMatrix self, int GRID_in) -> int
        LRID(CrsMatrix self, long long GRID_in) -> int

        int
        Epetra_CrsMatrix::LRID(long long GRID_in) const 
        """
        return _Epetra.CrsMatrix_LRID(self, *args)


    def GRID(self, *args):
        """
        GRID(CrsMatrix self, int LRID_in) -> int

        int
        Epetra_CrsMatrix::GRID(int LRID_in) const

        Returns the global row index for give local row index, returns
        IndexBase-1 if we don't have this local row. 
        """
        return _Epetra.CrsMatrix_GRID(self, *args)


    def GRID64(self, *args):
        """
        GRID64(CrsMatrix self, int LRID_in) -> long long

        long long
        Epetra_CrsMatrix::GRID64(int LRID_in) const 
        """
        return _Epetra.CrsMatrix_GRID64(self, *args)


    def LCID(self, *args):
        """
        LCID(CrsMatrix self, int GCID_in) -> int
        LCID(CrsMatrix self, long long GCID_in) -> int

        int
        Epetra_CrsMatrix::LCID(long long GCID_in) const 
        """
        return _Epetra.CrsMatrix_LCID(self, *args)


    def GCID(self, *args):
        """
        GCID(CrsMatrix self, int LCID_in) -> int

        int
        Epetra_CrsMatrix::GCID(int LCID_in) const

        Returns the global column index for give local column index, returns
        IndexBase-1 if we don't have this local column.

        HaveColMap()==true (If HaveColMap()==false, returns -1) 
        """
        return _Epetra.CrsMatrix_GCID(self, *args)


    def GCID64(self, *args):
        """
        GCID64(CrsMatrix self, int LCID_in) -> long long

        long long
        Epetra_CrsMatrix::GCID64(int LCID_in) const 
        """
        return _Epetra.CrsMatrix_GCID64(self, *args)


    def MyGRID(self, *args):
        """
        MyGRID(CrsMatrix self, int GRID_in) -> bool
        MyGRID(CrsMatrix self, long long GRID_in) -> bool

        bool
        Epetra_CrsMatrix::MyGRID(long long GRID_in) const 
        """
        return _Epetra.CrsMatrix_MyGRID(self, *args)


    def MyLRID(self, *args):
        """
        MyLRID(CrsMatrix self, int LRID_in) -> bool

        bool
        Epetra_CrsMatrix::MyLRID(int LRID_in) const

        Returns true if the LRID passed in belongs to the calling processor in
        this map, otherwise returns false. 
        """
        return _Epetra.CrsMatrix_MyLRID(self, *args)


    def MyGCID(self, *args):
        """
        MyGCID(CrsMatrix self, int GCID_in) -> bool
        MyGCID(CrsMatrix self, long long GCID_in) -> bool

        bool
        Epetra_CrsMatrix::MyGCID(long long GCID_in) const 
        """
        return _Epetra.CrsMatrix_MyGCID(self, *args)


    def MyLCID(self, *args):
        """
        MyLCID(CrsMatrix self, int LCID_in) -> bool

        bool
        Epetra_CrsMatrix::MyLCID(int LCID_in) const

        Returns true if the LRID passed in belongs to the calling processor in
        this map, otherwise returns false.

        HaveColMap()==true (If HaveColMap()==false, returns -1) 
        """
        return _Epetra.CrsMatrix_MyLCID(self, *args)


    def MyGlobalRow(self, *args):
        """
        MyGlobalRow(CrsMatrix self, int GID) -> bool
        MyGlobalRow(CrsMatrix self, long long GID) -> bool

        bool
        Epetra_CrsMatrix::MyGlobalRow(long long GID) const 
        """
        return _Epetra.CrsMatrix_MyGlobalRow(self, *args)


    def Label(self, *args):
        """
        Label(CrsMatrix self) -> char const *

        const char*
        Epetra_CrsMatrix::Label() const

        Returns a character string describing the operator. 
        """
        return _Epetra.CrsMatrix_Label(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(CrsMatrix self, bool UseTranspose_in) -> int

        int
        Epetra_CrsMatrix::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        UseTranspose:  - (In) If true, multiply by the transpose of operator,
        otherwise just use operator.

        Always returns 0. 
        """
        return _Epetra.CrsMatrix_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(CrsMatrix self, MultiVector X, MultiVector Y) -> int

        int
        Epetra_CrsMatrix::Apply(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_Operator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        X:  - (In) An Epetra_MultiVector of dimension NumVectors to multiply
        with matrix.

        Y:  -(Out) An Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(CrsMatrix self, MultiVector X, MultiVector Y) -> int

        int
        Epetra_CrsMatrix::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        In this implementation, we use several existing attributes to
        determine how virtual method ApplyInverse() should call the concrete
        method Solve(). We pass in the UpperTriangular(), the
        Epetra_CrsMatrix::UseTranspose(), and NoDiagonal() methods. The most
        notable warning is that if a matrix has no diagonal values we assume
        that there is an implicit unit diagonal that should be accounted for
        when doing a triangular solve.

        Parameters:
        -----------

        X:  - (In) An Epetra_MultiVector of dimension NumVectors to solve for.

        Y:  - (Out) An Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        Filled()==true

        Unchanged. 
        """
        return _Epetra.CrsMatrix_ApplyInverse(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::HasNormInf() const

        Returns true because this class can compute an Inf-norm. 
        """
        return _Epetra.CrsMatrix_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(CrsMatrix self) -> bool

        bool
        Epetra_CrsMatrix::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Epetra.CrsMatrix_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(CrsMatrix self) -> Map

        const
        Epetra_Map& Epetra_CrsMatrix::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        matrix operator. 
        """
        return _Epetra.CrsMatrix_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(CrsMatrix self) -> Map

        const
        Epetra_Map& Epetra_CrsMatrix::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this matrix
        operator. 
        """
        return _Epetra.CrsMatrix_OperatorRangeMap(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(CrsMatrix self, int MyRow, int & NumEntries) -> int

        int
        Epetra_CrsMatrix::NumMyRowEntries(int MyRow, int &NumEntries) const

        Return the current number of values stored for the specified local
        row.

        Similar to NumMyEntries() except NumEntries is returned as an argument
        and error checking is done on the input value MyRow.

        Parameters:
        -----------

        MyRow:  - (In) Local row.

        NumEntries:  - (Out) Number of nonzero values.

        Integer error code, set to 0 if successful.

        None.

        Unchanged. 
        """
        return _Epetra.CrsMatrix_NumMyRowEntries(self, *args)


    def Map(self, *args):
        """
        Map(CrsMatrix self) -> BlockMap

        const Epetra_BlockMap&
        Epetra_CrsMatrix::Map() const

        Map() method inherited from Epetra_DistObject. 
        """
        return _Epetra.CrsMatrix_Map(self, *args)


    def RowMatrixRowMap(self, *args):
        """
        RowMatrixRowMap(CrsMatrix self) -> Map

        const
        Epetra_Map& Epetra_CrsMatrix::RowMatrixRowMap() const

        Returns the Epetra_Map object associated with the rows of this matrix.

        """
        return _Epetra.CrsMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """
        RowMatrixColMap(CrsMatrix self) -> Map

        const
        Epetra_Map& Epetra_CrsMatrix::RowMatrixColMap() const

        Returns the Epetra_Map object associated with columns of this matrix.

        """
        return _Epetra.CrsMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """
        RowMatrixImporter(CrsMatrix self) -> Import

        const
        Epetra_Import* Epetra_CrsMatrix::RowMatrixImporter() const

        Returns the Epetra_Import object that contains the import operations
        for distributed operations. 
        """
        return _Epetra.CrsMatrix_RowMatrixImporter(self, *args)


    def ExpertExtractIndexOffset(self, *args):
        """
        ExpertExtractIndexOffset(CrsMatrix self) -> IntSerialDenseVector

        Epetra_IntSerialDenseVector &
        Epetra_CrsMatrix::ExpertExtractIndexOffset()

        Returns a reference to the Epetra_IntSerialDenseVector used to hold
        the local IndexOffsets (CRS rowptr)

        WARNING:  This method is intended for experts only, its use may
        require user code modifications in future versions of Epetra. 
        """
        return _Epetra.CrsMatrix_ExpertExtractIndexOffset(self, *args)


    def ExpertExtractIndices(self, *args):
        """
        ExpertExtractIndices(CrsMatrix self) -> IntSerialDenseVector

        Epetra_IntSerialDenseVector & Epetra_CrsMatrix::ExpertExtractIndices()

        Returns a reference to the Epetra_IntSerialDenseVector used to hold
        the local All_Indices (CRS colind)

        WARNING:  This method is intended for experts only, its use may
        require user code modifications in future versions of Epetra. 
        """
        return _Epetra.CrsMatrix_ExpertExtractIndices(self, *args)


    def ExpertExtractValues(self, *args):
        """
        ExpertExtractValues(CrsMatrix self) -> double *&

        double*& Epetra_CrsMatrix::ExpertExtractValues()

        Returns a reference to the double* used to hold the values array.

        WARNING:  This method is intended for experts only, its use may
        require user code modifications in future versions of Epetra. 
        """
        return _Epetra.CrsMatrix_ExpertExtractValues(self, *args)


    def ExpertStaticFillComplete(self, *args):
        """
        ExpertStaticFillComplete(CrsMatrix self, Map DomainMap, Map RangeMap, Import Importer=None, Export Exporter=None, int NumMyDiagonals=-1) -> int

        int Epetra_CrsMatrix::ExpertStaticFillComplete(const Epetra_Map
        &DomainMap, const Epetra_Map &RangeMap, const Epetra_Import
        *Importer=0, const Epetra_Export *Exporter=0, int NumMyDiagonals=-1)

        Performs a FillComplete on an object that aready has filled CRS data.

        Performs a lightweight FillComplete on an object that already has
        filled IndexOffsets, All_Indices and All_Values. This routine is
        needed to support the EpetraExt::MatrixMatrix::Multiply and should not
        be called by users. WARNING:   Epetra_CrsMatrix will assume ownership
        of the Importer/Exporter you pass in. You should not deallocate it
        afterwards.

        WARNING:  This method is intended for expert developer use only, and
        should never be called by user code. 
        """
        return _Epetra.CrsMatrix_ExpertStaticFillComplete(self, *args)


    def ExpertMakeUniqueCrsGraphData(self, *args):
        """
        ExpertMakeUniqueCrsGraphData(CrsMatrix self) -> int

        int Epetra_CrsMatrix::ExpertMakeUniqueCrsGraphData()

        Makes sure this matrix has a unique CrsGraphData object.

        This routine is needed to support the
        EpetraExt::MatrixMatrix::Multiply and should not be called by users.
        WARNING:  This method is intended for expert developer use only, and
        should never be called by user code. 
        """
        return _Epetra.CrsMatrix_ExpertMakeUniqueCrsGraphData(self, *args)


    def SortGhostsAssociatedWithEachProcessor(self, *args):
        """
        SortGhostsAssociatedWithEachProcessor(CrsMatrix self, bool Flag) -> int

        int
        Epetra_CrsMatrix::SortGhostsAssociatedWithEachProcessor(bool Flag)

        Forces FillComplete() to locally order ghostnodes associated with each
        remote processor in ascending order.

        To be compliant with AztecOO, FillComplete() already locally orders
        ghostnodes such that information received from processor k has a lower
        local numbering than information received from processor j if k is
        less than j. SortGhostsAssociatedWithEachProcessor(True) further
        forces FillComplete() to locally number all ghostnodes received from
        processor k in ascending order. That is, the local numbering of b is
        less than c if the global numbering of b is less than c and if both b
        and c are owned by the same processor. This is done to be compliant
        with some limited block features within ML. In particular, some ML
        features require that a block structure of the matrix be maintained
        even within the ghost variables. Always returns 0. 
        """
        return _Epetra.CrsMatrix_SortGhostsAssociatedWithEachProcessor(self, *args)


    def ImportMap(self, *args):
        """
        ImportMap(CrsMatrix self) -> Map

        const Epetra_Map&
        Epetra_CrsMatrix::ImportMap() const

        Use ColMap() instead. 
        """
        return _Epetra.CrsMatrix_ImportMap(self, *args)


    def TransformToLocal(self, *args):
        """
        TransformToLocal(CrsMatrix self) -> int
        TransformToLocal(CrsMatrix self, Map DomainMap, Map RangeMap) -> int

        int
        Epetra_CrsMatrix::TransformToLocal(const Epetra_Map *DomainMap, const
        Epetra_Map *RangeMap)

        Use FillComplete(const Epetra_Map& DomainMap, const Epetra_Map&
        RangeMap) instead. 
        """
        return _Epetra.CrsMatrix_TransformToLocal(self, *args)


    def FusedImport(self, *args):
        """
        FusedImport(CrsMatrix self, CrsMatrix SourceMatrix, Import RowImporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator)
        FusedImport(CrsMatrix self, CrsMatrix SourceMatrix, Import RowImporter, Import DomainImporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator)

        void
        Epetra_CrsMatrix::FusedImport(const Epetra_CrsMatrix &SourceMatrix,
        const Epetra_Import &RowImporter, const Epetra_Import *DomainImporter,
        const Epetra_Map *DomainMap, const Epetra_Map *RangeMap, bool
        RestrictCommunicator) 
        """
        return _Epetra.CrsMatrix_FusedImport(self, *args)


    def FusedExport(self, *args):
        """
        FusedExport(CrsMatrix self, CrsMatrix SourceMatrix, Export RowExporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator)
        FusedExport(CrsMatrix self, CrsMatrix SourceMatrix, Export RowExporter, Export DomainExporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator)

        void
        Epetra_CrsMatrix::FusedExport(const Epetra_CrsMatrix &SourceMatrix,
        const Epetra_Export &RowExporter, const Epetra_Export *DomainExporter,
        const Epetra_Map *DomainMap, const Epetra_Map *RangeMap, bool
        RestrictCommunicator) 
        """
        return _Epetra.CrsMatrix_FusedExport(self, *args)


    def InsertGlobalValues(self, *args):
        """
        InsertGlobalValues(self, int globalRow, PySequence values, PySequence
            indices) -> int

          Arguments:

            globalRow - global row index
            values    - a sequence of doubles that represent the values to insert
            indices   - a sequence of integers that represent the indices to insert

        InsertGlobalValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to insert
            cols    - a sequence of integers that represent the column indices to
                      insert
            values  - a sequence of doubles that represent the values to insert


        int
        Epetra_CrsMatrix::InsertGlobalValues(long long GlobalRow, int
        NumEntries, double *Values, long long *Indices) 
        """
        return _Epetra.CrsMatrix_InsertGlobalValues(self, *args)


    def ReplaceGlobalValues(self, *args):
        """
        ReplaceGlobalValues(self, int globalRow, PySequence values, PySequence
            indices) -> int

          Arguments:

            globalRow - global row index
            values    - a sequence of doubles that represent the values to replace
            indices   - a sequence of integers that represent the indices to replace

        ReplaceGlobalValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to replace
            cols    - a sequence of integers that represent the column indices to
                      replace
            values  - a sequence of doubles that represent the values to replace


        int
        Epetra_CrsMatrix::ReplaceGlobalValues(long long GlobalRow, int
        NumEntries, const double *Values, const long long *Indices) 
        """
        return _Epetra.CrsMatrix_ReplaceGlobalValues(self, *args)


    def SumIntoGlobalValues(self, *args):
        """
        SumIntoGlobalValues(self, int globalRow, PySequence values, PySequence
            indices) -> int

          Arguments:

            globalRow - global row index
            values    - a sequence of doubles that represent the values to sum into
            indices   - a sequence of integers that represent the indices to sum into

        SumIntoGlobalValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to sum into
            cols    - a sequence of integers that represent the column indices to
                      sum into
            values  - a sequence of doubles that represent the values to sum into


        int
        Epetra_CrsMatrix::SumIntoGlobalValues(long long GlobalRow, int
        NumEntries, const double *Values, const long long *Indices) 
        """
        return _Epetra.CrsMatrix_SumIntoGlobalValues(self, *args)


    def InsertMyValues(self, *args):
        """
        InsertMyValues(CrsMatrix self, int MyRow, int NumEntries, double const * Values, int const * Indices) -> int
        InsertMyValues(self, int myRow, PySequence values, PySequence indices) -> int

          Arguments:

            myRow     - local row index
            values    - a sequence of doubles that represent the values to insert
            indices   - a sequence of integers that represent the indices to insert

        InsertMyValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to insert
            cols    - a sequence of integers that represent the column indices to
                      insert
            values  - a sequence of doubles that represent the values to insert


        int
        Epetra_CrsMatrix::InsertMyValues(int MyRow, int NumEntries, double
        *Values, int *Indices)

        Insert a list of elements in a given local row of the matrix.

        Parameters:
        -----------

        MyRow:  - (In) Row number (in local coordinates) to put elements.

        NumEntries:  - (In) Number of entries.

        Values:  - (In) Values to enter.

        Indices:  - (In) Local column indices corresponding to values.

        Integer error code, set to 0 if successful. Note that if the allocated
        length of the row has to be expanded, a positive warning code will be
        returned.

        IndicesAreGlobal()==false && ( IndicesAreContiguous()==false ||
        CV_==View)

        The given local row of the matrix has been updated as described above.

        """
        return _Epetra.CrsMatrix_InsertMyValues(self, *args)


    def ReplaceMyValues(self, *args):
        """
        ReplaceMyValues(CrsMatrix self, int MyRow, int NumEntries, double const * Values, int const * Indices) -> int
        ReplaceMyValues(self, int myRow, PySequence values, PySequence indices) -> int

          Arguments:

            myRow     - local row index
            values    - a sequence of doubles that represent the values to replace
            indices   - a sequence of integers that represent the indices to replace

        ReplaceMyValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to replace
            cols    - a sequence of integers that represent the column indices to
                      replace
            values  - a sequence of doubles that represent the values to replace


        int
        Epetra_CrsMatrix::ReplaceMyValues(int MyRow, int NumEntries, const
        double *Values, const int *Indices)

        Replace current values with this list of entries for a given local row
        of the matrix.

        Parameters:
        -----------

        MyRow:  - (In) Row number (in local coordinates) to put elements.

        NumEntries:  - (In) Number of entries.

        Values:  - (In) Values to enter.

        Indices:  - (In) Local column indices corresponding to values.

        Integer error code, set to 0 if successful. Note that if a value is
        not already present for the specified location in the matrix, the
        input value will be ignored and a positive warning code will be
        returned.

        IndicesAreLocal()==true

        MyRow contains the given list of Values at the given Indices. 
        """
        return _Epetra.CrsMatrix_ReplaceMyValues(self, *args)


    def SumIntoMyValues(self, *args):
        """
        SumIntoMyValues(CrsMatrix self, int MyRow, int NumEntries, double const * Values, int const * Indices) -> int
        SumIntoMyValues(self, int myRow, PySequence values, PySequence indices) -> int

          Arguments:

            myRow     - local row index
            values    - a sequence of doubles that represent the values to sum into
            indices   - a sequence of integers that represent the indices to sum into

        SumIntoMyValues(CrsMatrix self, PyObject * Rows, PyObject * Cols, PyObject * Values) -> int

        int
        Epetra_CrsMatrix::SumIntoMyValues(int MyRow, int NumEntries, const
        double *Values, const int *Indices)

        Add this list of entries to existing values for a given local row of
        the matrix.

        Parameters:
        -----------

        MyRow:  - (In) Row number (in local coordinates) to put elements.

        NumEntries:  - (In) Number of entries.

        Values:  - (In) Values to enter.

        Indices:  - (In) Local column indices corresponding to values.

        Integer error code, set to 0 if successful. Note that if the allocated
        length of the row has to be expanded, a positive warning code will be
        returned.

        IndicesAreLocal()==true

        The given Values at the given Indices have been summed into the
        entries of MyRow. 
        """
        return _Epetra.CrsMatrix_SumIntoMyValues(self, *args)


    def __init__(self, *args):
        """
        __init__(self, Epetra_DataAccess CV, Map rowMap, int numEntriesPerRow, 
            bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with implicit column map and constant number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            numEntriesPerRow  - constant number of entries per row
            staticProfile     - static profile flag

        __init__(self, Epetra_DataAccess CV, Map rowMap, Map colMap, int numEntriesPerRow, 
            bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with specified column map and constant number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            colMap            - describes distribution of columns across processors
            numEntriesPerRow  - constant number of entries per row
            staticProfile     - static profile flag

        __init__(self, Epetra_DataAccess CV, CrsGraph graph) -> CrsMatrix

          CrsMatrix constructor with CrsGraph.  Arguments:

            CV     - Epetra.Copy or Epetra.View
            graph  - CrsGraph describing structure of matrix

        __init__(Epetra_CrsMatrix self, CrsMatrix SourceMatrix, Import RowImporter, Map DomainMap=None, Map RangeMap=None, bool RestrictCommunicator=False) -> CrsMatrix
        __init__(Epetra_CrsMatrix self, CrsMatrix SourceMatrix, Import RowImporter, Import DomainImporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator) -> CrsMatrix
        __init__(Epetra_CrsMatrix self, CrsMatrix SourceMatrix, Export RowExporter, Map DomainMap=None, Map RangeMap=None, bool RestrictCommunicator=False) -> CrsMatrix
        __init__(Epetra_CrsMatrix self, CrsMatrix SourceMatrix, Export RowExporter, Export DomainExporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator) -> CrsMatrix
        __init__(self, CrsMatrix matrix) -> CrsMatrix

          CrsMatrix copy constructor.  Argument:

            matrix  - source CrsMatrix

        __init__(self, Epetra_DataAccess CV, Map rowMap, PySequence numEntriesPerRow, 
            bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with implicit column map and variable number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            numEntriesPerRow  - variable number of entries per row
            staticProfile     - static profile flag

        __init__(self, Epetra_DataAccess CV, Map rowMap, Map colMap, PySequence
            numEntriesPerRow, bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with specified column map and variable number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            colMap            - describes distribution of columns across processors
            numEntriesPerRow  - variable number of entries per row
            staticProfile     - static profile flag


        Epetra_CrsMatrix::Epetra_CrsMatrix(const Epetra_CrsMatrix &Matrix)

        Copy constructor. 
        """
        this = _Epetra.new_CrsMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ExtractGlobalRowCopy(self, *args):
        """
        ExtractGlobalRowCopy(self, int globalRow) -> (numpy.ndarray,numpy.ndarray)

          Returns a two-tuple of numpy arrays of the same size; the first is
          an array of integers that represent the nonzero columns on the
          matrix; the second is an array of doubles that represent the values
          of the matrix entries.  The input argument is a global row index.

        int
        Epetra_CrsMatrix::ExtractGlobalRowCopy(long long GlobalRow, int
        Length, int &NumEntries, double *Values) const 
        """
        return _Epetra.CrsMatrix_ExtractGlobalRowCopy(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(self, int myRow) -> (numpy.ndarray,numpy.ndarray)

          Returns a two-tuple of numpy arrays of the same size; the first is
          an array of integers that represent the nonzero columns on the
          matrix; the second is an array of doubles that represent the values
          of the matrix entries.  The input argument is a local row index.

        int
        Epetra_CrsMatrix::ExtractMyRowCopy(int MyRow, int Length, int
        &NumEntries, double *Values) const

        Returns a copy of the specified local row values in user-provided
        array.

        Parameters:
        -----------

        MyRow:  - (In) Local row to extract.

        Length:  - (In) Length of Values.

        NumEntries:  - (Out) Number of nonzero entries extracted.

        Values:  - (Out) Extracted values for this row.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.CrsMatrix_ExtractMyRowCopy(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(self, PyTuple index, double val)

        The __setitem__() method is called when square-bracket indexing is
        used to set a value of the matrix.  For example, the last line of::

            comm = Epetra.SerialComm()
            m = Epetra.CrsMatrix(9,0,comm)
            m[0,0] = 3.14

        calls::

            m.__setitem__((0,0), 3.14)

        Thus, argument 'index' is a tuple filled with whatever indices you
        give the square-bracket operator when setting.  For __setitem__(),
        this raises an IndexError unless 'index' is a two-tuple of integers.
        Argument 'val' must be convertible to a double.  Under the covers,
        __setitem__() calls ReplaceGlobalValues() or InsertGlobalValues() as
        necessary, so the indices are expected to be global IDs.  Note that if
        you use __setitem__() to insert a new matrix element, you will need to
        call FillComplete() again, whether or not you have called it before.

        """
        return _Epetra.CrsMatrix___setitem__(self, *args)


    def __getitem__(self, *args):
        """

        __getitem__(self, PyTuple index) -> double
        __getitem__(self, int row) -> numpy.ndarray

        The __getitem__() method is called when square-bracket indexing is
        used to get a value from the matrix.  For example, the last two lines
        of::

            comm = Epetra.SerialComm()
            m = Epetra.CrsMatrix(9,0,comm)
            m.InsertGlobalValues(0, [0.0, 1.0, 2.0], [0,1,2])
            diag = m[0,0]
            row  = m[0]

        call::

            m.__getitem__((0,0))
            m.__getitem__(0)

        The __getitem__() method behaves according to the following table:

                            FillComplete()    #    
            Index               called      procs  Return value
            --------------  --------------  -----  ---------------------------
            single integer       true        any   numpy array of doubles
            single integer       false        1    numpy array of doubles
            single integer       false       >1    raise IndexError
            two integers         either      any   double

        You should provide global IDs as the integer indices if FillComplete()
        has been called.  If not, you should provide local IDs.  If you
        reference a matrix element that is off-processor, __getitem__() will
        raise an IndexError.

        Under the covers, __getitem__() will call ExtractGlobalRowView() if
        FillComplete() has been called, or ExtractMyRowView() if it has not.
        If either of these return a non-zero return code, this is converted to
        a python RuntimeError.  The resulting data is copied to the output
        array.

        """
        return _Epetra.CrsMatrix___getitem__(self, *args)

CrsMatrix_swigregister = _Epetra.CrsMatrix_swigregister
CrsMatrix_swigregister(CrsMatrix)

class FECrsMatrix(CrsMatrix):
    """


    Epetra Finite-Element CrsMatrix. This class provides the ability to
    input finite-element style sub-matrix data, including sub-matrices
    with non-local rows (which could correspond to shared finite-element
    nodes for example). This class inherits Epetra_CrsMatrix, and so all
    Epetra_CrsMatrix functionality is also available.

    It is intended that this class will be used as follows: Construct with
    either a map or graph that describes a (non- overlapping) data
    distribution.

    Input data, including non-local data, using the methods
    InsertGlobalValues(), SumIntoGlobalValues() and/or
    ReplaceGlobalValues().

    Call the method GlobalAssemble(), which gathers all non-local data
    onto the owning processors as determined by the map provided at
    construction. Users should note that the GlobalAssemble() method has
    an optional argument which determines whether GlobalAssemble() in turn
    calls FillComplete() after the data-exchange has occurred. If not
    explicitly supplied, this argument defaults to true. NOTE***: When
    GlobalAssemble() calls FillComplete(), it passes the arguments '
    DomainMap()' and ' RangeMap()', which are the map attributes held by
    the base-class CrsMatrix and its graph. If a rectangular matrix is
    being assembled, the correct domain-map and range-map must be passed
    to GlobalAssemble (there are two overloadings of this method)
    otherwise, it has no way of knowing what these maps should really be.

    Sub-matrix data, which is assumed to be a rectangular 'table' of
    coefficients accompanied by 'scatter-indices', can be provided in
    three forms: Fortran-style packed 1-D array.

    C-style double-pointer, or list-of-rows.

    Epetra_SerialDenseMatrix object.  In all cases, a "format" parameter
    specifies whether the data is laid out in row-major or column-major
    order (i.e., whether coefficients for a row lie contiguously or
    whether coefficients for a column lie contiguously). See the
    documentation for the methods SumIntoGlobalValues() and
    ReplaceGlobalValues().

    Important notes: Since Epetra_FECrsMatrix inherits Epetra_CrsMatrix,
    the semantics of the Insert/SumInto/Replace methods are the same as
    they are on Epetra_CrsMatrix, which is:  InsertGlobalValues() inserts
    values into the matrix only if the graph has not yet been finalized (
    FillComplete() has not yet been called). For non-local values, the
    call to InsertGlobalValues() may succeed but the GlobalAssemble()
    method may then fail because the non-local data is not actually
    inserted in the underlying matrix until GlobalAssemble() is called.

    SumIntoGlobalValues() and ReplaceGlobalValues() only work for values
    that already exist in the matrix. In other words, these methods can
    not be used to put new values into the matrix.

    C++ includes: Epetra_FECrsMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FECrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FECrsMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, int * NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, int NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, Map ColMap, int * NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, Map ColMap, int NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, CrsGraph Graph, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Epetra_FECrsGraph const & Graph, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, FECrsMatrix src) -> FECrsMatrix

        Epetra_FECrsMatrix::Epetra_FECrsMatrix(const Epetra_FECrsMatrix &src)

        Copy Constructor. 
        """
        this = _Epetra.new_FECrsMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_FECrsMatrix
    ROW_MAJOR = _Epetra.FECrsMatrix_ROW_MAJOR
    COLUMN_MAJOR = _Epetra.FECrsMatrix_COLUMN_MAJOR

    def GlobalAssemble(self, *args):
        """
        GlobalAssemble(FECrsMatrix self, bool callFillComplete=True, Epetra_CombineMode combineMode=Add, bool save_off_and_reuse_map_exporter=False) -> int
        GlobalAssemble(FECrsMatrix self, Map domain_map, Map range_map, bool callFillComplete=True, Epetra_CombineMode combineMode=Add, bool save_off_and_reuse_map_exporter=False) -> int

        int
        Epetra_FECrsMatrix::GlobalAssemble(const Epetra_Map &domain_map, const
        Epetra_Map &range_map, bool callFillComplete=true, Epetra_CombineMode
        combineMode=Add, bool save_off_and_reuse_map_exporter=false)

        Gather any overlapping/shared data into the non-overlapping
        partitioning defined by the Map that was passed to this matrix at
        construction time. Data imported from other processors is stored on
        the owning processor with a "sumInto" or accumulate operation. This
        is a collective method every processor must enter it before any will
        complete it.

        NOTE***: When GlobalAssemble() (the other overloading of this method)
        calls FillComplete(), it passes the arguments ' DomainMap()' and '
        RangeMap()', which are the map attributes already held by the base-
        class CrsMatrix and its graph. If a rectangular matrix is being
        assembled, the domain-map and range-map must be specified. Otherwise,
        GlobalAssemble() has no way of knowing what these maps should really
        be.

        Parameters:
        -----------

        domain_map:  user-supplied domain map for this matrix

        range_map:  user-supplied range map for this matrix

        callFillComplete:  option argument, defaults to true. Determines
        whether GlobalAssemble() internally calls the FillComplete() method on
        this matrix.

        error-code 0 if successful, non-zero if some error occurs 
        """
        return _Epetra.FECrsMatrix_GlobalAssemble(self, *args)


    def setIgnoreNonLocalEntries(self, *args):
        """
        setIgnoreNonLocalEntries(FECrsMatrix self, bool flag)

        void Epetra_FECrsMatrix::setIgnoreNonLocalEntries(bool flag)

        Set whether or not non-local data values should be ignored. By
        default, non-local data values are NOT ignored. 
        """
        return _Epetra.FECrsMatrix_setIgnoreNonLocalEntries(self, *args)


    def __setitem__(self, *args):
        """__setitem__(FECrsMatrix self, PyObject * args, double val)"""
        return _Epetra.FECrsMatrix___setitem__(self, *args)


    def __getitem__(self, *args):
        """__getitem__(FECrsMatrix self, PyObject * args) -> PyObject *"""
        return _Epetra.FECrsMatrix___getitem__(self, *args)


    def InsertGlobalValues(self, *args):
        """
        InsertGlobalValues(FECrsMatrix self, int const row, int const size, SerialDenseVector values, IntSerialDenseVector entries) -> int
        InsertGlobalValues(FECrsMatrix self, IntSerialDenseVector rows, IntSerialDenseVector cols, SerialDenseMatrix values, int format) -> int

        int
        Epetra_CrsMatrix::InsertGlobalValues(long long GlobalRow, int
        NumEntries, double *Values, long long *Indices) 
        """
        return _Epetra.FECrsMatrix_InsertGlobalValues(self, *args)


    def InsertGlobalValue(self, *args):
        """InsertGlobalValue(FECrsMatrix self, int i, int j, double val) -> int"""
        return _Epetra.FECrsMatrix_InsertGlobalValue(self, *args)

FECrsMatrix_swigregister = _Epetra.FECrsMatrix_swigregister
FECrsMatrix_swigregister(FECrsMatrix)

class CrsSingletonFilter(_object):
    """


    Epetra_CrsSingletonFilter: A class for explicitly eliminating matrix
    rows and columns.

    The Epetra_CrsSingletonFilter class takes an existing
    Epetra_LinearProblem object, analyzes it structure and explicitly
    eliminates singleton rows and columns from the matrix and
    appropriately modifies the RHS and LHS of the linear problem. The
    result of this process is a reduced system of equations that is itself
    an Epetra_LinearProblem object. The reduced system can then be solved
    using any solver that is understands an Epetra_LinearProblem. The
    solution for the full system is obtained by calling
    ComputeFullSolution().

    Singleton rows are defined to be rows that have a single nonzero entry
    in the matrix. The equation associated with this row can be explicitly
    eliminated because it involved only one variable. For example if row i
    has a single nonzero value in column j, call it A(i,j), we can
    explicitly solve for x(j) = b(i)/A(i,j), where b(i) is the ith entry
    of the RHS and x(j) is the jth entry of the LHS.

    Singleton columns are defined to be columns that have a single nonzero
    entry in the matrix. The variable associated with this column is fully
    dependent, meaning that the solution for all other variables does not
    depend on it. If this entry is A(i,j) then the ith row and jth column
    can be removed from the system and x(j) can be solved after the
    solution for all other variables is determined.

    By removing singleton rows and columns, we can often produce a reduced
    system that is smaller and far less dense, and in general having
    better numerical properties.

    The basic procedure for using this class is as follows: Construct full
    problem: Construct and Epetra_LinearProblem containing the "full"
    matrix, RHS and LHS. This is done outside of Epetra_CrsSingletonFilter
    class. Presumably, you have some reason to believe that this system
    may contain singletons.

    Construct an Epetra_CrsSingletonFilter instance: Constructor needs no
    arguments.

    Analyze matrix: Invoke the Analyze() method, passing in the
    Epetra_RowMatrix object from your full linear problem mentioned in the
    first step above.

    Go/No Go decision to construct reduced problem: Query the results of
    the Analyze method using the SingletonsDetected() method. This method
    returns "true" if there were singletons found in the matrix. You can
    also query any of the other methods in the Filter Statistics section
    to determine if you want to proceed with the construction of the
    reduced system.

    Construct reduced problem: If, in the previous step, you determine
    that you want to proceed with the construction of the reduced problem,
    you should next call the ConstructReducedProblem() method, passing in
    the full linear problem object from the first step. This method will
    use the information from the Analyze() method to construct a reduce
    problem that has explicitly eliminated the singleton rows, solved for
    the corresponding LHS values and updated the RHS. This step will also
    remove singleton columns from the reduced system. Once the solution of
    the reduced problem is is computed (via any solver that understands an
    Epetra_LinearProblem), you should call the ComputeFullSolution()
    method to compute the LHS values assocaited with the singleton
    columns.

    Solve reduced problem: Obtain a pointer to the reduced problem using
    the ReducedProblem() method. Using the solver of your choice, solve
    the reduced system.

    Compute solution to full problem: Once the solution the reduced
    problem is determined, the ComputeFullSolution() method will place the
    reduced solution values into the appropriate locations of the full
    solution LHS and then compute the values associated with column
    singletons. At this point, you have a complete solution to the
    original full problem.

    Solve a subsequent full problem that differs from the original problem
    only in values: It is often the case that the structure of a problem
    will be the same for a sequence of linear problems. In this case, the
    UpdateReducedProblem() method can be useful. After going through the
    above process one time, if you have a linear problem that is
    structural identical to the previous problem, you can minimize memory
    and time costs by using the UpdateReducedProblem() method, passing in
    the subsequent problem. Once you have called the
    UpdateReducedProblem() method, you can then solve the reduce problem
    problem as you wish, and then compute the full solution as before. The
    pointer generated by ReducedProblem() will not change when
    UpdateReducedProblem() is called.

    C++ includes: Epetra_CrsSingletonFilter.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsSingletonFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CrsSingletonFilter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_CrsSingletonFilter self) -> CrsSingletonFilter

        Epetra_CrsSingletonFilter::Epetra_CrsSingletonFilter()

        Epetra_CrsSingletonFilter default constructor. 
        """
        this = _Epetra.new_CrsSingletonFilter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_CrsSingletonFilter

    def Analyze(self, *args):
        """
        Analyze(CrsSingletonFilter self, RowMatrix FullMatrix) -> int

        int
        Epetra_CrsSingletonFilter::Analyze(Epetra_RowMatrix *FullMatrix)

        Analyze the input matrix, removing row/column pairs that have
        singletons.

        Analyzes the user's input matrix to determine rows and columns that
        should be explicitly eliminated to create the reduced system. Look for
        rows and columns that have single entries. These rows/columns can
        easily be removed from the problem. The results of calling this method
        are two MapColoring objects accessible via RowMapColors() and
        ColMapColors() accessor methods. All rows/columns that would be
        eliminated in the reduced system have a color of 1 in the
        corresponding RowMapColors/ColMapColors object. All kept rows/cols
        have a color of 0. 
        """
        return _Epetra.CrsSingletonFilter_Analyze(self, *args)


    def SingletonsDetected(self, *args):
        """
        SingletonsDetected(CrsSingletonFilter self) -> bool

        bool Epetra_CrsSingletonFilter::SingletonsDetected() const

        Returns true if singletons were detected in this matrix (must be
        called after Analyze() to be effective). 
        """
        return _Epetra.CrsSingletonFilter_SingletonsDetected(self, *args)


    def ConstructReducedProblem(self, *args):
        """
        ConstructReducedProblem(CrsSingletonFilter self, Epetra_LinearProblem Problem) -> int

        int
        Epetra_CrsSingletonFilter::ConstructReducedProblem(Epetra_LinearProblem
        *Problem)

        Return a reduced linear problem based on results of Analyze().

        Creates a new Epetra_LinearProblem object based on the results of the
        Analyze phase. A pointer to the reduced problem is obtained via a call
        to ReducedProblem().

        Error code, set to 0 if no error. 
        """
        return _Epetra.CrsSingletonFilter_ConstructReducedProblem(self, *args)


    def UpdateReducedProblem(self, *args):
        """
        UpdateReducedProblem(CrsSingletonFilter self, Epetra_LinearProblem Problem) -> int

        int
        Epetra_CrsSingletonFilter::UpdateReducedProblem(Epetra_LinearProblem
        *Problem)

        Update a reduced linear problem using new values.

        Updates an existing Epetra_LinearProblem object using new matrix, LHS
        and RHS values. The matrix structure must be identical to the matrix
        that was used to construct the original reduced problem.

        Error code, set to 0 if no error. 
        """
        return _Epetra.CrsSingletonFilter_UpdateReducedProblem(self, *args)


    def ComputeFullSolution(self, *args):
        """
        ComputeFullSolution(CrsSingletonFilter self) -> int

        int Epetra_CrsSingletonFilter::ComputeFullSolution()

        Compute a solution for the full problem using the solution of the
        reduced problem, put in LHS of FullProblem().

        After solving the reduced linear system, this method can be called to
        compute the solution to the original problem, assuming the solution
        for the reduced system is valid. The solution of the unreduced,
        original problem will be in the LHS of the original
        Epetra_LinearProblem. 
        """
        return _Epetra.CrsSingletonFilter_ComputeFullSolution(self, *args)


    def NumRowSingletons(self, *args):
        """
        NumRowSingletons(CrsSingletonFilter self) -> int

        int Epetra_CrsSingletonFilter::NumRowSingletons() const

        Return number of rows that contain a single entry, returns -1 if
        Analysis not performed yet. 
        """
        return _Epetra.CrsSingletonFilter_NumRowSingletons(self, *args)


    def NumColSingletons(self, *args):
        """
        NumColSingletons(CrsSingletonFilter self) -> int

        int Epetra_CrsSingletonFilter::NumColSingletons() const

        Return number of columns that contain a single entry that are not
        associated with singleton row, returns -1 if Analysis not performed
        yet. 
        """
        return _Epetra.CrsSingletonFilter_NumColSingletons(self, *args)


    def NumSingletons(self, *args):
        """
        NumSingletons(CrsSingletonFilter self) -> int

        int
        Epetra_CrsSingletonFilter::NumSingletons() const

        Return total number of singletons detected, returns -1 if Analysis not
        performed yet.

        Return total number of singletons detected across all processors. This
        method will not return a valid result until after the Analyze() method
        is called. The dimension of the reduced system can be computed by
        subtracting this number from dimension of full system. WARNING:  This
        method returns -1 if Analyze() method has not been called. 
        """
        return _Epetra.CrsSingletonFilter_NumSingletons(self, *args)


    def RatioOfDimensions(self, *args):
        """
        RatioOfDimensions(CrsSingletonFilter self) -> double

        double Epetra_CrsSingletonFilter::RatioOfDimensions() const

        Returns ratio of reduced system to full system dimensions, returns
        -1.0 if reduced problem not constructed. 
        """
        return _Epetra.CrsSingletonFilter_RatioOfDimensions(self, *args)


    def RatioOfNonzeros(self, *args):
        """
        RatioOfNonzeros(CrsSingletonFilter self) -> double

        double Epetra_CrsSingletonFilter::RatioOfNonzeros() const

        Returns ratio of reduced system to full system nonzero count, returns
        -1.0 if reduced problem not constructed. 
        """
        return _Epetra.CrsSingletonFilter_RatioOfNonzeros(self, *args)


    def FullProblem(self, *args):
        """
        FullProblem(CrsSingletonFilter self) -> Epetra_LinearProblem

        Epetra_LinearProblem* Epetra_CrsSingletonFilter::FullProblem() const

        Returns pointer to the original unreduced Epetra_LinearProblem. 
        """
        return _Epetra.CrsSingletonFilter_FullProblem(self, *args)


    def ReducedProblem(self, *args):
        """
        ReducedProblem(CrsSingletonFilter self) -> Epetra_LinearProblem

        Epetra_LinearProblem* Epetra_CrsSingletonFilter::ReducedProblem()
        const

        Returns pointer to the derived reduced Epetra_LinearProblem. 
        """
        return _Epetra.CrsSingletonFilter_ReducedProblem(self, *args)


    def FullMatrix(self, *args):
        """
        FullMatrix(CrsSingletonFilter self) -> RowMatrix

        Epetra_RowMatrix* Epetra_CrsSingletonFilter::FullMatrix() const

        Returns pointer to Epetra_CrsMatrix from full problem. 
        """
        return _Epetra.CrsSingletonFilter_FullMatrix(self, *args)


    def ReducedMatrix(self, *args):
        """
        ReducedMatrix(CrsSingletonFilter self) -> CrsMatrix

        Epetra_CrsMatrix* Epetra_CrsSingletonFilter::ReducedMatrix() const

        Returns pointer to Epetra_CrsMatrix from full problem. 
        """
        return _Epetra.CrsSingletonFilter_ReducedMatrix(self, *args)


    def RowMapColors(self, *args):
        """
        RowMapColors(CrsSingletonFilter self) -> MapColoring

        Epetra_MapColoring* Epetra_CrsSingletonFilter::RowMapColors() const

        Returns pointer to Epetra_MapColoring object: color 0 rows are part of
        reduced system. 
        """
        return _Epetra.CrsSingletonFilter_RowMapColors(self, *args)


    def ColMapColors(self, *args):
        """
        ColMapColors(CrsSingletonFilter self) -> MapColoring

        Epetra_MapColoring* Epetra_CrsSingletonFilter::ColMapColors() const

        Returns pointer to Epetra_MapColoring object: color 0 columns are part
        of reduced system. 
        """
        return _Epetra.CrsSingletonFilter_ColMapColors(self, *args)


    def ReducedMatrixRowMap(self, *args):
        """
        ReducedMatrixRowMap(CrsSingletonFilter self) -> Map

        Epetra_Map* Epetra_CrsSingletonFilter::ReducedMatrixRowMap() const

        Returns pointer to Epetra_Map describing the reduced system row
        distribution. 
        """
        return _Epetra.CrsSingletonFilter_ReducedMatrixRowMap(self, *args)


    def ReducedMatrixColMap(self, *args):
        """
        ReducedMatrixColMap(CrsSingletonFilter self) -> Map

        Epetra_Map* Epetra_CrsSingletonFilter::ReducedMatrixColMap() const

        Returns pointer to Epetra_Map describing the reduced system column
        distribution. 
        """
        return _Epetra.CrsSingletonFilter_ReducedMatrixColMap(self, *args)


    def ReducedMatrixDomainMap(self, *args):
        """
        ReducedMatrixDomainMap(CrsSingletonFilter self) -> Map

        Epetra_Map*
        Epetra_CrsSingletonFilter::ReducedMatrixDomainMap() const

        Returns pointer to Epetra_Map describing the domain map for the
        reduced system. 
        """
        return _Epetra.CrsSingletonFilter_ReducedMatrixDomainMap(self, *args)


    def ReducedMatrixRangeMap(self, *args):
        """
        ReducedMatrixRangeMap(CrsSingletonFilter self) -> Map

        Epetra_Map*
        Epetra_CrsSingletonFilter::ReducedMatrixRangeMap() const

        Returns pointer to Epetra_Map describing the range map for the reduced
        system. 
        """
        return _Epetra.CrsSingletonFilter_ReducedMatrixRangeMap(self, *args)

CrsSingletonFilter_swigregister = _Epetra.CrsSingletonFilter_swigregister
CrsSingletonFilter_swigregister(CrsSingletonFilter)

class VbrMatrix(DistObject, CompObject, BLAS, RowMatrix):
    """


    Epetra_VbrMatrix: A class for the construction and use of real-valued
    double-precision variable block-row sparse matrices.

    The Epetra_VbrMatrix class is a sparse variable block row matrix
    object. This matrix can be used in a parallel setting, with data
    distribution described by Epetra_Map attributes. The structure or
    graph of the matrix is defined by an Epetra_CrsGraph attribute.

    In addition to coefficient access, the primary operations provided by
    Epetra_VbrMatrix are matrix times vector and matrix times multi-vector
    multiplication.

    Creating and filling Epetra_VbrMatrix objects

    Constructing Epetra_VbrMatrix objects is a multi-step process. The
    basic steps are as follows: Create Epetra_VbrMatrix instance via one
    of the constructors: Constructor that accepts one Epetra_Map object, a
    row-map defining the distribution of matrix rows.

    Constructor that accepts two Epetra_Map objects. (The second map is a
    column-map, and describes the set of column-indices that appear in
    each processor's portion of the matrix. Generally these are
    overlapping sets column-indices may appear on more than one
    processor.)

    Constructor that accepts an Epetra_CrsGraph object, defining the non-
    zero structure of the matrix.

    Input coefficient values (more detail on this below).

    Complete construction by calling FillComplete.

    Note that even after FillComplete() has been called, it is possible to
    update existing matrix entries but it is not possible to create new
    entries.

    Using Epetra_VbrMatrix as an Epetra_RowMatrix

    Although Epetra_VbrMatrix does inherit from Epetra_RowMatrix, a design
    flaw in the inheritance structure of Epetra prohibits the use of an
    Epetra_VbrMatrix object as an Epetra_RowMatrix in some important
    situations. Therefore we recommend the use of the Epetra_VbrRowMatrix
    class to wrap an Epetra_VbrMatrix object for use as an
    Epetra_RowMatrix. The Epetra_VbrRowMatrix object does not duplicate
    data in the Epetra_VbrMatrix object, but uses it to satisfy the
    Epetra_RowMatrix interface.

    Epetra_Map attributes

    Epetra_VbrMatrix objects have four Epetra_Map attributes, which are
    held by the Epetra_CrsGraph attribute.

    The Epetra_Map attributes can be obtained via these accessor methods:
    RowMap() Describes the numbering and distribution of the rows of the
    matrix. The row-map exists and is valid for the entire life of the
    matrix. The set of matrix rows is defined by the row-map and may not
    be changed. Rows may not be inserted or deleted by the user. The only
    change that may be made is that the user can replace the row-map with
    a compatible row-map (which is the same except for re-numbering) by
    calling the ReplaceRowMap() method.

    ColMap() Describes the set of column-indices that appear in the rows
    in each processor's portion of the matrix. Unless provided by the user
    at construction time, a valid column-map doesn't exist until
    FillComplete() is called.

    RangeMap() Describes the range of the matrix operator. e.g., for a
    matrix-vector product operation, the result vector's map must be
    compatible with the range-map of this matrix. The range-map is usually
    the same as the row-map. The range-map is set equal to the row-map at
    matrix creation time, but may be specified by the user when
    FillComplete() is called.

    DomainMap() Describes the domain of the matrix operator. The domain-
    map can be specified by the user when FillComplete() is called. Until
    then, it is set equal to the row-map.

    It is important to note that while the row-map and the range-map are
    often the same, the column-map and the domain-map are almost never the
    same. The set of entries in a distributed column-map almost always
    form overlapping sets, with entries being associated with more than
    one processor. A domain-map, on the other hand, must be a 1-to-1 map,
    with entries being associated with only a single processor.

    Local versus Global Indices

    Epetra_VbrMatrix has query functions IndicesAreLocal() and
    IndicesAreGlobal(), which are used to determine whether the underlying
    Epetra_CrsGraph attribute's column-indices have been transformed into
    a local index space or not. (This transformation occurs when the
    method Epetra_CrsGraph::FillComplete() is called, which happens when
    the method Epetra_VbrMatrix::FillComplete() is called.) The state of
    the indices in the graph determines the behavior of many
    Epetra_VbrMatrix methods. If an Epetra_VbrMatrix instance is
    constructed using one of the constructors that does not accept a pre-
    existing Epetra_CrsGraph object, then an Epetra_CrsGraph attribute is
    created internally and its indices remain untransformed (
    IndicesAreGlobal()==true) until Epetra_VbrMatrix::FillComplete() is
    called. The query function Epetra_VbrMatrix::Filled() returns true if
    Epetra_VbrMatrix::FillComplete() has been called.

    Inputting coefficient values

    The process for inputting block-entry coefficients is as follows:
    Indicate that values for a specified row are about to be provided by
    calling one of these methods which specify a block-row and a list of
    block-column-indices:  BeginInsertGlobalValues()

    BeginInsertMyValues()

    BeginReplaceGlobalValues()

    BeginReplaceMyValues()

    BeginSumIntoGlobalValues()

    BeginSumIntoMyValues()

    Loop over the list of block-column-indices and pass each block-entry
    to the matrix using the method SubmitBlockEntry().

    Complete the process for the specified block-row by calling the method
    EndSubmitEntries().

    Note that the 'GlobalValues' methods have the precondition that
    IndicesAreGlobal() must be true, and the 'MyValues' methods have the
    precondition that IndicesAreLocal() must be true. Furthermore, the
    'SumInto' and 'Replace' methods may only be used to update matrix
    entries which already exist, and the 'Insert' methods may only be used
    if IndicesAreContiguous() is false.

    Counting Floating Point Operations

    Each Epetra_VbrMatrix object keeps track of the number of serial
    floating point operations performed using the specified object as the
    this argument to the function. The Flops() function returns this
    number as a double precision number. Using this information, in
    conjunction with the Epetra_Time class, one can get accurate parallel
    performance numbers. The ResetFlops() function resets the floating
    point counter.

    C++ includes: Epetra_VbrMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, VbrMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, VbrMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_VbrMatrix

    def PutScalar(self, *args):
        """
        PutScalar(VbrMatrix self, double ScalarConstant) -> int

        int
        Epetra_VbrMatrix::PutScalar(double ScalarConstant)

        Initialize all values in graph of the matrix with constant value.

        Parameters:
        -----------

        In:  ScalarConstant - Value to use.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_PutScalar(self, *args)


    def Scale(self, *args):
        """
        Scale(VbrMatrix self, double ScalarConstant) -> int

        int
        Epetra_VbrMatrix::Scale(double ScalarConstant)

        Multiply all values in the matrix by a constant value (in place: A <-
        ScalarConstant * A).

        Parameters:
        -----------

        In:  ScalarConstant - Value to use.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_Scale(self, *args)


    def DirectSubmitBlockEntry(self, *args):
        """
        DirectSubmitBlockEntry(VbrMatrix self, int GlobalBlockRow, int GlobalBlockCol, double const * values, int LDA, int NumRows, int NumCols, bool sum_into) -> int

        int
        Epetra_VbrMatrix::DirectSubmitBlockEntry(int GlobalBlockRow, int
        GlobalBlockCol, const double *values, int LDA, int NumRows, int
        NumCols, bool sum_into)

        Submit a block-entry directly into the matrix (without using a
        begin/end sequence)

        Experimental method which allows submitting a block-entry without
        first calling BeginInsertGlobalValues. This method copies the input
        data directly into the matrix storage. The block-entry is specified by
        global block-row and block-col indices. 
        """
        return _Epetra.VbrMatrix_DirectSubmitBlockEntry(self, *args)


    def BeginInsertGlobalValues(self, *args):
        """
        BeginInsertGlobalValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int

        int
        Epetra_VbrMatrix::BeginInsertGlobalValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate insertion of a list of elements in a given global row of the
        matrix, values are inserted via SubmitEntry().

        Parameters:
        -----------

        In:  BlockRow - Block Row number (in global coordinates) to put
        elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Global column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginInsertGlobalValues(self, *args)


    def BeginInsertMyValues(self, *args):
        """
        BeginInsertMyValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int

        int
        Epetra_VbrMatrix::BeginInsertMyValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate insertion of a list of elements in a given local row of the
        matrix, values are inserted via SubmitEntry().

        Parameters:
        -----------

        In:  BlockRow - Block Row number (in local coordinates) to put
        elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Local column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginInsertMyValues(self, *args)


    def BeginReplaceGlobalValues(self, *args):
        """
        BeginReplaceGlobalValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int

        int Epetra_VbrMatrix::BeginReplaceGlobalValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate replacement of current values with this list of entries for a
        given global row of the matrix, values are replaced via SubmitEntry()

        Parameters:
        -----------

        In:  Row - Block Row number (in global coordinates) to put elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Global column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginReplaceGlobalValues(self, *args)


    def BeginReplaceMyValues(self, *args):
        """
        BeginReplaceMyValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int

        int
        Epetra_VbrMatrix::BeginReplaceMyValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate replacement of current values with this list of entries for a
        given local row of the matrix, values are replaced via SubmitEntry()

        Parameters:
        -----------

        In:  Row - Block Row number (in local coordinates) to put elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Local column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginReplaceMyValues(self, *args)


    def BeginSumIntoGlobalValues(self, *args):
        """
        BeginSumIntoGlobalValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int

        int Epetra_VbrMatrix::BeginSumIntoGlobalValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate summing into current values with this list of entries for a
        given global row of the matrix, values are replaced via SubmitEntry()

        Parameters:
        -----------

        In:  Row - Block Row number (in global coordinates) to put elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Global column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginSumIntoGlobalValues(self, *args)


    def BeginSumIntoMyValues(self, *args):
        """
        BeginSumIntoMyValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int

        int
        Epetra_VbrMatrix::BeginSumIntoMyValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate summing into current values with this list of entries for a
        given local row of the matrix, values are replaced via SubmitEntry()

        Parameters:
        -----------

        In:  Row - Block Row number (in local coordinates) to put elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Local column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginSumIntoMyValues(self, *args)


    def SubmitBlockEntry(self, *args):
        """
        SubmitBlockEntry(VbrMatrix self, double * Values, int LDA, int NumRows, int NumCols) -> int
        SubmitBlockEntry(VbrMatrix self, SerialDenseMatrix Mat) -> int

        int
        Epetra_VbrMatrix::SubmitBlockEntry(Epetra_SerialDenseMatrix &Mat)

        Submit a block entry to the indicated block row and column specified
        in the Begin routine. 
        """
        return _Epetra.VbrMatrix_SubmitBlockEntry(self, *args)


    def EndSubmitEntries(self, *args):
        """
        EndSubmitEntries(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::EndSubmitEntries()

        Completes processing of all data passed in for the current block row.

        This function completes the processing of all block entries submitted
        via SubmitBlockEntry(). It also checks to make sure that
        SubmitBlockEntry was called the correct number of times as specified
        by the Begin routine that initiated the entry process. 
        """
        return _Epetra.VbrMatrix_EndSubmitEntries(self, *args)


    def ReplaceDiagonalValues(self, *args):
        """
        ReplaceDiagonalValues(VbrMatrix self, Vector Diagonal) -> int

        int
        Epetra_VbrMatrix::ReplaceDiagonalValues(const Epetra_Vector &Diagonal)

        Replaces diagonal values of the with those in the user-provided
        vector.

        This routine is meant to allow replacement of {\\bf existing}
        diagonal values. If a diagonal value does not exist for a given row,
        the corresponding value in the input Epetra_Vector will be ignored and
        the return code will be set to 1.

        The Epetra_Map associated with the input Epetra_Vector must be
        compatible with the RowMap of the matrix.

        Parameters:
        -----------

        Diagonal:  (In) - New values to be placed in the main diagonal.

        Integer error code, set to 0 if successful, 1 of one or more diagonal
        entries not present in matrix. 
        """
        return _Epetra.VbrMatrix_ReplaceDiagonalValues(self, *args)


    def FillComplete(self, *args):
        """
        FillComplete(VbrMatrix self) -> int
        FillComplete(VbrMatrix self, BlockMap DomainMap, BlockMap RangeMap) -> int

        int
        Epetra_VbrMatrix::FillComplete(const Epetra_BlockMap &DomainMap, const
        Epetra_BlockMap &RangeMap)

        Signal that data entry is complete, perform transformations to local
        index space. 
        """
        return _Epetra.VbrMatrix_FillComplete(self, *args)


    def Filled(self, *args):
        """
        Filled(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::Filled() const

        If FillComplete() has been called, this query returns true, otherwise
        it returns false. 
        """
        return _Epetra.VbrMatrix_Filled(self, *args)


    def ExtractGlobalBlockRowPointers(self, *args):
        """
        ExtractGlobalBlockRowPointers(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int

        int Epetra_VbrMatrix::ExtractGlobalBlockRowPointers(int BlockRow,
        int MaxNumBlockEntries, int &RowDim, int &NumBlockEntries, int
        *BlockIndices, Epetra_SerialDenseMatrix **&Values) const

        Copy the block indices into user-provided array, set pointers for rest
        of data for specified global block row.

        This function provides the lightest weight approach to accessing a
        global block row when the matrix may be be stored in local or global
        index space. In other words, this function will always work because
        the block indices are returned in user-provided space. All other array
        arguments are independent of whether or not indices are local or
        global. Other than the BlockIndices array, all other array argument
        are returned as pointers to internal data.

        Parameters:
        -----------

        In:  BlockRow - Global block row to extract.

        In:  MaxNumBlockEntries - Length of user-provided BlockIndices array.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries actually extracted.

        Out:  BlockIndices - Extracted global column indices for the
        corresponding block entries.

        Out:  Values - Pointer to list of pointers to block entries. Note that
        the actual values are not copied.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractGlobalBlockRowPointers(self, *args)


    def ExtractMyBlockRowPointers(self, *args):
        """
        ExtractMyBlockRowPointers(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int

        int Epetra_VbrMatrix::ExtractMyBlockRowPointers(int BlockRow, int
        MaxNumBlockEntries, int &RowDim, int &NumBlockEntries, int
        *BlockIndices, Epetra_SerialDenseMatrix **&Values) const

        Copy the block indices into user-provided array, set pointers for rest
        of data for specified local block row.

        This function provides the lightest weight approach to accessing a
        local block row when the matrix may be be stored in local or global
        index space. In other words, this function will always work because
        the block indices are returned in user-provided space. All other array
        arguments are independent of whether or not indices are local or
        global. Other than the BlockIndices array, all other array argument
        are returned as pointers to internal data.

        Parameters:
        -----------

        In:  BlockRow - Local block row to extract.

        In:  MaxNumBlockEntries - Length of user-provided BlockIndices array.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries actually extracted.

        Out:  BlockIndices - Extracted local column indices for the
        corresponding block entries.

        Out:  Values - Pointer to list of pointers to block entries. Note that
        the actual values are not copied.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractMyBlockRowPointers(self, *args)


    def BeginExtractGlobalBlockRowCopy(self, *args):
        """
        BeginExtractGlobalBlockRowCopy(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, int * ColDims) -> int

        int
        Epetra_VbrMatrix::BeginExtractGlobalBlockRowCopy(int BlockRow, int
        MaxNumBlockEntries, int &RowDim, int &NumBlockEntries, int
        *BlockIndices, int *ColDims) const

        Initiates a copy of the specified global row in user-provided arrays.

        Parameters:
        -----------

        In:  BlockRow - Global block row to extract.

        In:  MaxNumBlockEntries - Length of user-provided BlockIndices,
        ColDims, and LDAs arrays.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries actually extracted.

        Out:  BlockIndices - Extracted global column indices for the
        corresponding block entries.

        Out:  ColDim - List of column dimensions for each corresponding block
        entry that will be extracted.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginExtractGlobalBlockRowCopy(self, *args)


    def BeginExtractMyBlockRowCopy(self, *args):
        """
        BeginExtractMyBlockRowCopy(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, int * ColDims) -> int

        int Epetra_VbrMatrix::BeginExtractMyBlockRowCopy(int BlockRow, int
        MaxNumBlockEntries, int &RowDim, int &NumBlockEntries, int
        *BlockIndices, int *ColDims) const

        Initiates a copy of the specified local row in user-provided arrays.

        Parameters:
        -----------

        In:  BlockRow - Local block row to extract.

        In:  MaxNumBlockEntries - Length of user-provided BlockIndices,
        ColDims, and LDAs arrays.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries actually extracted.

        Out:  BlockIndices - Extracted local column indices for the
        corresponding block entries.

        Out:  ColDim - List of column dimensions for each corresponding block
        entry that will be extracted.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginExtractMyBlockRowCopy(self, *args)


    def ExtractEntryCopy(self, *args):
        """
        ExtractEntryCopy(VbrMatrix self, int SizeOfValues, double * Values, int LDA, bool SumInto) -> int

        int
        Epetra_VbrMatrix::ExtractEntryCopy(int SizeOfValues, double *Values,
        int LDA, bool SumInto) const

        Extract a copy of an entry from the block row specified by one of the
        BeginExtract routines.

        Once BeginExtractGlobalBlockRowCopy() or BeginExtractMyBlockRowCopy()
        is called, you can extract the block entries of specified block row
        one-entry-at-a-time. The entries will be extracted in an order
        corresponding to the BlockIndices list that was returned by the
        BeginExtract routine.

        Parameters:
        -----------

        In:  SizeOfValues - Amount of memory associated with Values. This must
        be at least as big as LDA*NumCol, where NumCol is the column dimension
        of the block entry being copied

        InOut:  Values - Starting location where the block entry will be
        copied.

        In:  LDA - Specifies the stride that will be used when copying columns
        into Values.

        In:  SumInto - If set to true, the block entry values will be summed
        into existing values. 
        """
        return _Epetra.VbrMatrix_ExtractEntryCopy(self, *args)


    def BeginExtractGlobalBlockRowView(self, *args):
        """
        BeginExtractGlobalBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices) -> int

        int
        Epetra_VbrMatrix::BeginExtractGlobalBlockRowView(int BlockRow, int
        &RowDim, int &NumBlockEntries, int *&BlockIndices) const

        Initiates a view of the specified global row, only works if matrix
        indices are in global mode.

        Parameters:
        -----------

        In:  BlockRow - Global block row to view.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries to be viewed.

        Out:  BlockIndices - Pointer to global column indices for the
        corresponding block entries.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginExtractGlobalBlockRowView(self, *args)


    def BeginExtractMyBlockRowView(self, *args):
        """
        BeginExtractMyBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices) -> int

        int Epetra_VbrMatrix::BeginExtractMyBlockRowView(int BlockRow, int
        &RowDim, int &NumBlockEntries, int *&BlockIndices) const

        Initiates a view of the specified local row, only works if matrix
        indices are in local mode.

        Parameters:
        -----------

        In:  BlockRow - Local block row to view.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries to be viewed.

        Out:  BlockIndices - Pointer to local column indices for the
        corresponding block entries.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginExtractMyBlockRowView(self, *args)


    def ExtractEntryView(self, *args):
        """
        ExtractEntryView(VbrMatrix self, Epetra_SerialDenseMatrix *& entry) -> int

        int
        Epetra_VbrMatrix::ExtractEntryView(Epetra_SerialDenseMatrix *&entry)
        const

        Returns a pointer to the current block entry.

        After a call to BeginExtractGlobal() or
        BlockRowViewBeginExtractMyBlockRowView(), ExtractEntryView() can be
        called up to NumBlockEntries times to get each block entry in the
        specified block row.

        Parameters:
        -----------

        InOut:  entry - A pointer that will be set to the current block entry.

        """
        return _Epetra.VbrMatrix_ExtractEntryView(self, *args)


    def ExtractGlobalBlockRowView(self, *args):
        """
        ExtractGlobalBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int

        int Epetra_VbrMatrix::ExtractGlobalBlockRowView(int BlockRow, int
        &RowDim, int &NumBlockEntries, int *&BlockIndices,
        Epetra_SerialDenseMatrix **&Values) const

        Initiates a view of the specified global row, only works if matrix
        indices are in global mode.

        Parameters:
        -----------

        In:  BlockRow - Global block row to view.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries to be viewed.

        Out:  BlockIndices - Pointer to global column indices for the
        corresponding block entries.

        Out:  Values - Pointer to an array of pointers to the block entries in
        the specified block row.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractGlobalBlockRowView(self, *args)


    def ExtractMyBlockRowView(self, *args):
        """
        ExtractMyBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int

        int
        Epetra_VbrMatrix::ExtractMyBlockRowView(int BlockRow, int &RowDim, int
        &NumBlockEntries, int *&BlockIndices, Epetra_SerialDenseMatrix
        **&Values) const

        Initiates a view of the specified local row, only works if matrix
        indices are in local mode.

        Parameters:
        -----------

        In:  BlockRow - Local block row to view.

        Out:  RowDim - Number of equations in the requested block row.

        Out:  NumBlockEntries - Number of nonzero entries to be viewed.

        Out:  BlockIndices - Pointer to local column indices for the
        corresponding block entries.

        Out:  Values - Pointer to an array of pointers to the block entries in
        the specified block row.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractMyBlockRowView(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(VbrMatrix self, Vector Diagonal) -> int

        int
        Epetra_VbrMatrix::ExtractDiagonalCopy(Epetra_Vector &Diagonal) const

        Returns a copy of the main diagonal in a user-provided vector.

        Parameters:
        -----------

        Out:  Diagonal - Extracted main diagonal.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractDiagonalCopy(self, *args)


    def BeginExtractBlockDiagonalCopy(self, *args):
        """
        BeginExtractBlockDiagonalCopy(VbrMatrix self, int MaxNumBlockDiagonalEntries, int & NumBlockDiagonalEntries, int * RowColDims) -> int

        int Epetra_VbrMatrix::BeginExtractBlockDiagonalCopy(int
        MaxNumBlockDiagonalEntries, int &NumBlockDiagonalEntries, int
        *RowColDims) const

        Initiates a copy of the block diagonal entries to user-provided
        arrays.

        Parameters:
        -----------

        In:  MaxNumBlockDiagonalEntries - Length of user-provided RowColDims
        array.

        Out:  NumBlockDiagonalEntries - Number of block diagonal entries that
        can actually be extracted.

        Out:  RowColDim - List of row and column dimension for corresponding
        block diagonal entries.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginExtractBlockDiagonalCopy(self, *args)


    def ExtractBlockDiagonalEntryCopy(self, *args):
        """
        ExtractBlockDiagonalEntryCopy(VbrMatrix self, int SizeOfValues, double * Values, int LDA, bool SumInto) -> int

        int Epetra_VbrMatrix::ExtractBlockDiagonalEntryCopy(int
        SizeOfValues, double *Values, int LDA, bool SumInto) const

        Extract a copy of a block diagonal entry from the matrix.

        Once BeginExtractBlockDiagonalCopy() is called, you can extract the
        block diagonal entries one-entry- at-a-time. The entries will be
        extracted in ascending order.

        Parameters:
        -----------

        In:  SizeOfValues - Amount of memory associated with Values. This must
        be at least as big as LDA*NumCol, where NumCol is the column dimension
        of the block entry being copied

        InOut:  Values - Starting location where the block entry will be
        copied.

        In:  LDA - Specifies the stride that will be used when copying columns
        into Values.

        In:  SumInto - If set to true, the block entry values will be summed
        into existing values. 
        """
        return _Epetra.VbrMatrix_ExtractBlockDiagonalEntryCopy(self, *args)


    def BeginExtractBlockDiagonalView(self, *args):
        """
        BeginExtractBlockDiagonalView(VbrMatrix self, int & NumBlockDiagonalEntries, int *& RowColDims) -> int

        int Epetra_VbrMatrix::BeginExtractBlockDiagonalView(int
        &NumBlockDiagonalEntries, int *&RowColDims) const

        Initiates a view of the block diagonal entries.

        Parameters:
        -----------

        Out:  NumBlockDiagonalEntries - Number of block diagonal entries that
        can be viewed.

        Out:  RowColDim - Pointer to list of row and column dimension for
        corresponding block diagonal entries.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_BeginExtractBlockDiagonalView(self, *args)


    def ExtractBlockDiagonalEntryView(self, *args):
        """
        ExtractBlockDiagonalEntryView(VbrMatrix self, double *& Values, int & LDA) -> int

        int Epetra_VbrMatrix::ExtractBlockDiagonalEntryView(double *&Values,
        int &LDA) const

        Extract a view of a block diagonal entry from the matrix.

        Once BeginExtractBlockDiagonalView() is called, you can extract a view
        of the block diagonal entries one- entry-at-a-time. The views will be
        extracted in ascending order.

        Parameters:
        -----------

        Out:  Values - Pointer to internal copy of block entry.

        Out:  LDA - Column stride of Values. 
        """
        return _Epetra.VbrMatrix_ExtractBlockDiagonalEntryView(self, *args)


    def Multiply1(self, *args):
        """
        Multiply1(VbrMatrix self, bool TransA, Vector x, Vector y) -> int

        int
        Epetra_VbrMatrix::Multiply1(bool TransA, const Epetra_Vector &x,
        Epetra_Vector &y) const

        Returns the result of a Epetra_VbrMatrix multiplied by a Epetra_Vector
        x in y.

        Parameters:
        -----------

        In:  TransA - If true, multiply by the transpose of matrix, otherwise
        just use matrix.

        In:  x - A Epetra_Vector to multiply by.

        Out:  y - A Epetra_Vector containing result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_Multiply1(self, *args)


    def Multiply(self, *args):
        """
        Multiply(VbrMatrix self, bool TransA, MultiVector X, MultiVector Y) -> int

        int
        Epetra_VbrMatrix::Multiply(bool TransA, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_VbrMatrix multiplied by a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  TransA -If true, multiply by the transpose of matrix, otherwise
        just use matrix.

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve(VbrMatrix self, bool Upper, bool Trans, bool UnitDiagonal, MultiVector X, MultiVector Y) -> int

        int
        Epetra_VbrMatrix::Solve(bool Upper, bool Trans, bool UnitDiagonal,
        const Epetra_MultiVector &X, Epetra_MultiVector &Y) const

        Returns the result of a Epetra_VbrMatrix multiplied by a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  Upper -If true, solve Ux = y, otherwise solve Lx = y.

        In:  Trans -If true, solve transpose problem.

        In:  UnitDiagonal -If true, assume diagonal is unit (whether it's
        stored or not).

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(VbrMatrix self, Vector x) -> int

        int
        Epetra_VbrMatrix::InvRowSums(Epetra_Vector &x) const

        Computes the sum of absolute values of the rows of the
        Epetra_VbrMatrix, results returned in x.

        The vector x will return such that x[i] will contain the inverse of
        sum of the absolute values of the this matrix will be scaled such that
        A(i,j) = x(i)*A(i,j) where i denotes the global row number of A and j
        denotes the global column number of A. Using the resulting vector from
        this function as input to LeftScale() will make the infinity norm of
        the resulting matrix exactly 1.

        Parameters:
        -----------

        Out:  x -A Epetra_Vector containing the row sums of the this matrix.

        WARNING:  It is assumed that the distribution of x is the same as the
        rows of this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(VbrMatrix self, Vector x) -> int

        int
        Epetra_VbrMatrix::LeftScale(const Epetra_Vector &x)

        Scales the Epetra_VbrMatrix on the left with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(i)*A(i,j) where i
        denotes the row number of A and j denotes the column number of A.

        Parameters:
        -----------

        In:  x -A Epetra_Vector to solve for.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(VbrMatrix self, Vector x) -> int

        int
        Epetra_VbrMatrix::InvColSums(Epetra_Vector &x) const

        Computes the sum of absolute values of the columns of the
        Epetra_VbrMatrix, results returned in x.

        The vector x will return such that x[j] will contain the inverse of
        sum of the absolute values of the this matrix will be sca such that
        A(i,j) = x(j)*A(i,j) where i denotes the global row number of A and j
        denotes the global column number of A. Using the resulting vector from
        this function as input to RighttScale() will make the one norm of the
        resulting matrix exactly 1.

        Parameters:
        -----------

        Out:  x -A Epetra_Vector containing the column sums of the this
        matrix.

        WARNING:  It is assumed that the distribution of x is the same as the
        rows of this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(VbrMatrix self, Vector x) -> int

        int
        Epetra_VbrMatrix::RightScale(const Epetra_Vector &x)

        Scales the Epetra_VbrMatrix on the right with a Epetra_Vector x.

        The this matrix will be scaled such that A(i,j) = x(j)*A(i,j) where i
        denotes the global row number of A and j denotes the global column
        number of A.

        Parameters:
        -----------

        In:  x -The Epetra_Vector used for scaling this.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_RightScale(self, *args)


    def OptimizeStorage(self, *args):
        """
        OptimizeStorage(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::OptimizeStorage()

        Eliminates memory that is used for construction. Make consecutive row
        index sections contiguous. 
        """
        return _Epetra.VbrMatrix_OptimizeStorage(self, *args)


    def StorageOptimized(self, *args):
        """
        StorageOptimized(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::StorageOptimized() const

        If OptimizeStorage() has been called, this query returns true,
        otherwise it returns false. 
        """
        return _Epetra.VbrMatrix_StorageOptimized(self, *args)


    def IndicesAreGlobal(self, *args):
        """
        IndicesAreGlobal(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::IndicesAreGlobal() const

        If matrix indices has not been transformed to local, this query
        returns true, otherwise it returns false. 
        """
        return _Epetra.VbrMatrix_IndicesAreGlobal(self, *args)


    def IndicesAreLocal(self, *args):
        """
        IndicesAreLocal(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::IndicesAreLocal() const

        If matrix indices has been transformed to local, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.VbrMatrix_IndicesAreLocal(self, *args)


    def IndicesAreContiguous(self, *args):
        """
        IndicesAreContiguous(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::IndicesAreContiguous() const

        If matrix indices are packed into single array (done in
        OptimizeStorage()) return true, otherwise false. 
        """
        return _Epetra.VbrMatrix_IndicesAreContiguous(self, *args)


    def LowerTriangular(self, *args):
        """
        LowerTriangular(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::LowerTriangular() const

        If matrix is lower triangular in local index space, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.VbrMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """
        UpperTriangular(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::UpperTriangular() const

        If matrix is upper triangular in local index space, this query returns
        true, otherwise it returns false. 
        """
        return _Epetra.VbrMatrix_UpperTriangular(self, *args)


    def NoDiagonal(self, *args):
        """
        NoDiagonal(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::NoDiagonal() const

        If matrix has no diagonal entries based on global row/column index
        comparisons, this query returns true, otherwise it returns false. 
        """
        return _Epetra.VbrMatrix_NoDiagonal(self, *args)


    def NormInf(self, *args):
        """
        NormInf(VbrMatrix self) -> double

        double
        Epetra_VbrMatrix::NormInf() const

        Returns the infinity norm of the global matrix. 
        """
        return _Epetra.VbrMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """
        NormOne(VbrMatrix self) -> double

        double
        Epetra_VbrMatrix::NormOne() const

        Returns the one norm of the global matrix. 
        """
        return _Epetra.VbrMatrix_NormOne(self, *args)


    def NormFrobenius(self, *args):
        """
        NormFrobenius(VbrMatrix self) -> double

        double
        Epetra_VbrMatrix::NormFrobenius() const

        Returns the frobenius norm of the global matrix. 
        """
        return _Epetra.VbrMatrix_NormFrobenius(self, *args)


    def MaxRowDim(self, *args):
        """
        MaxRowDim(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::MaxRowDim() const

        Returns the maximum row dimension of all block entries on this
        processor. 
        """
        return _Epetra.VbrMatrix_MaxRowDim(self, *args)


    def MaxColDim(self, *args):
        """
        MaxColDim(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::MaxColDim() const

        Returns the maximum column dimension of all block entries on this
        processor. 
        """
        return _Epetra.VbrMatrix_MaxColDim(self, *args)


    def GlobalMaxRowDim(self, *args):
        """
        GlobalMaxRowDim(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::GlobalMaxRowDim() const

        Returns the maximum row dimension of all block entries across all
        processors. 
        """
        return _Epetra.VbrMatrix_GlobalMaxRowDim(self, *args)


    def GlobalMaxColDim(self, *args):
        """
        GlobalMaxColDim(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::GlobalMaxColDim() const

        Returns the maximum column dimension of all block entries across all
        processors. 
        """
        return _Epetra.VbrMatrix_GlobalMaxColDim(self, *args)


    def NumMyRows(self, *args):
        """
        NumMyRows(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyRows() const

        Returns the number of matrix rows owned by the calling processor. 
        """
        return _Epetra.VbrMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """
        NumMyCols(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyCols() const

        Returns the number of matrix columns owned by the calling processor.

        """
        return _Epetra.VbrMatrix_NumMyCols(self, *args)


    def NumMyNonzeros(self, *args):
        """
        NumMyNonzeros(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyNonzeros() const

        Returns the number of nonzero entriesowned by the calling processor .

        """
        return _Epetra.VbrMatrix_NumMyNonzeros(self, *args)


    def NumGlobalRows(self, *args):
        """
        NumGlobalRows(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalRows() const

        Returns the number of global matrix rows. 
        """
        return _Epetra.VbrMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """
        NumGlobalRows64(VbrMatrix self) -> long long

        long long
        Epetra_VbrMatrix::NumGlobalRows64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """
        NumGlobalCols(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalCols() const

        Returns the number of global matrix columns. 
        """
        return _Epetra.VbrMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """
        NumGlobalCols64(VbrMatrix self) -> long long

        long long
        Epetra_VbrMatrix::NumGlobalCols64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalCols64(self, *args)


    def NumGlobalNonzeros(self, *args):
        """
        NumGlobalNonzeros(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalNonzeros() const

        Returns the number of nonzero entries in the global matrix. 
        """
        return _Epetra.VbrMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """
        NumGlobalNonzeros64(VbrMatrix self) -> long long

        long
        long Epetra_VbrMatrix::NumGlobalNonzeros64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalNonzeros64(self, *args)


    def NumMyBlockRows(self, *args):
        """
        NumMyBlockRows(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyBlockRows() const

        Returns the number of Block matrix rows owned by the calling
        processor. 
        """
        return _Epetra.VbrMatrix_NumMyBlockRows(self, *args)


    def NumMyBlockCols(self, *args):
        """
        NumMyBlockCols(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyBlockCols() const

        Returns the number of Block matrix columns owned by the calling
        processor. 
        """
        return _Epetra.VbrMatrix_NumMyBlockCols(self, *args)


    def NumMyBlockDiagonals(self, *args):
        """
        NumMyBlockDiagonals(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyBlockDiagonals() const

        Returns the number of local nonzero block diagonal entries, based on
        global row/column index comparisons. 
        """
        return _Epetra.VbrMatrix_NumMyBlockDiagonals(self, *args)


    def NumMyDiagonals(self, *args):
        """
        NumMyDiagonals(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumMyDiagonals() const

        Returns the number of local nonzero diagonal entries, based on global
        row/column index comparisons. 
        """
        return _Epetra.VbrMatrix_NumMyDiagonals(self, *args)


    def NumGlobalBlockRows(self, *args):
        """
        NumGlobalBlockRows(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalBlockRows() const

        Returns the number of global Block matrix rows. 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockRows(self, *args)


    def NumGlobalBlockRows64(self, *args):
        """
        NumGlobalBlockRows64(VbrMatrix self) -> long long

        long
        long Epetra_VbrMatrix::NumGlobalBlockRows64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockRows64(self, *args)


    def NumGlobalBlockCols(self, *args):
        """
        NumGlobalBlockCols(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalBlockCols() const

        Returns the number of global Block matrix columns. 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockCols(self, *args)


    def NumGlobalBlockCols64(self, *args):
        """
        NumGlobalBlockCols64(VbrMatrix self) -> long long

        long
        long Epetra_VbrMatrix::NumGlobalBlockCols64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockCols64(self, *args)


    def NumGlobalBlockEntries64(self, *args):
        """
        NumGlobalBlockEntries64(VbrMatrix self) -> long long

        long long Epetra_VbrMatrix::NumGlobalBlockEntries64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockEntries64(self, *args)


    def NumGlobalBlockDiagonals(self, *args):
        """
        NumGlobalBlockDiagonals(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalBlockDiagonals() const

        Returns the number of global nonzero block diagonal entries, based on
        global row/column index comparisions. 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockDiagonals(self, *args)


    def NumGlobalBlockDiagonals64(self, *args):
        """
        NumGlobalBlockDiagonals64(VbrMatrix self) -> long long

        long long Epetra_VbrMatrix::NumGlobalBlockDiagonals64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockDiagonals64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """
        NumGlobalDiagonals(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::NumGlobalDiagonals() const

        Returns the number of global nonzero diagonal entries, based on global
        row/column index comparisions. 
        """
        return _Epetra.VbrMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """
        NumGlobalDiagonals64(VbrMatrix self) -> long long

        long
        long Epetra_VbrMatrix::NumGlobalDiagonals64() const 
        """
        return _Epetra.VbrMatrix_NumGlobalDiagonals64(self, *args)


    def NumGlobalBlockEntries(self, *args):
        """
        NumGlobalBlockEntries(VbrMatrix self) -> int
        NumGlobalBlockEntries(VbrMatrix self, int Row) -> int

        int
        Epetra_VbrMatrix::NumGlobalBlockEntries(int Row) const

        Returns the current number of nonzero Block entries in specified
        global row on this processor. 
        """
        return _Epetra.VbrMatrix_NumGlobalBlockEntries(self, *args)


    def NumAllocatedGlobalBlockEntries(self, *args):
        """
        NumAllocatedGlobalBlockEntries(VbrMatrix self, int Row) -> int

        int
        Epetra_VbrMatrix::NumAllocatedGlobalBlockEntries(int Row) const

        Returns the allocated number of nonzero Block entries in specified
        global row on this processor. 
        """
        return _Epetra.VbrMatrix_NumAllocatedGlobalBlockEntries(self, *args)


    def MaxNumBlockEntries(self, *args):
        """
        MaxNumBlockEntries(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::MaxNumBlockEntries() const

        Returns the maximum number of nonzero entries across all rows on this
        processor. 
        """
        return _Epetra.VbrMatrix_MaxNumBlockEntries(self, *args)


    def GlobalMaxNumBlockEntries(self, *args):
        """
        GlobalMaxNumBlockEntries(VbrMatrix self) -> int

        int Epetra_VbrMatrix::GlobalMaxNumBlockEntries() const

        Returns the maximum number of nonzero entries across all rows on this
        processor. 
        """
        return _Epetra.VbrMatrix_GlobalMaxNumBlockEntries(self, *args)


    def NumMyBlockEntries(self, *args):
        """
        NumMyBlockEntries(VbrMatrix self) -> int
        NumMyBlockEntries(VbrMatrix self, int Row) -> int

        int
        Epetra_VbrMatrix::NumMyBlockEntries(int Row) const

        Returns the current number of nonzero Block entries in specified local
        row on this processor. 
        """
        return _Epetra.VbrMatrix_NumMyBlockEntries(self, *args)


    def NumAllocatedMyBlockEntries(self, *args):
        """
        NumAllocatedMyBlockEntries(VbrMatrix self, int Row) -> int

        int Epetra_VbrMatrix::NumAllocatedMyBlockEntries(int Row) const

        Returns the allocated number of nonzero Block entries in specified
        local row on this processor. 
        """
        return _Epetra.VbrMatrix_NumAllocatedMyBlockEntries(self, *args)


    def MaxNumNonzeros(self, *args):
        """
        MaxNumNonzeros(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::MaxNumNonzeros() const

        Returns the maximum number of nonzero entries across all block rows on
        this processor.

        Let ki = the number of nonzero values in the ith block row of the
        VbrMatrix object. For example, if the ith block row had 5 block
        entries and the size of each entry was 4-by-4, ki would be 80. Then
        this function return the max over all ki for all row on this
        processor. 
        """
        return _Epetra.VbrMatrix_MaxNumNonzeros(self, *args)


    def GlobalMaxNumNonzeros(self, *args):
        """
        GlobalMaxNumNonzeros(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::GlobalMaxNumNonzeros() const

        Returns the maximum number of nonzero entries across all block rows on
        all processors.

        This function returns the max over all processor of MaxNumNonzeros().

        """
        return _Epetra.VbrMatrix_GlobalMaxNumNonzeros(self, *args)


    def IndexBase(self, *args):
        """
        IndexBase(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::IndexBase() const

        Returns the index base for row and column indices for this graph.

        Index base for this map. 
        """
        return _Epetra.VbrMatrix_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """
        IndexBase64(VbrMatrix self) -> long long

        long long
        Epetra_VbrMatrix::IndexBase64() const 
        """
        return _Epetra.VbrMatrix_IndexBase64(self, *args)


    def Graph(self, *args):
        """
        Graph(VbrMatrix self) -> CrsGraph

        const
        Epetra_CrsGraph& Epetra_VbrMatrix::Graph() const

        Returns a pointer to the Epetra_CrsGraph object associated with this
        matrix. 
        """
        return _Epetra.VbrMatrix_Graph(self, *args)


    def Importer(self, *args):
        """
        Importer(VbrMatrix self) -> Import

        const
        Epetra_Import* Epetra_VbrMatrix::Importer() const

        Returns the Epetra_Import object that contains the import operations
        for distributed operations. 
        """
        return _Epetra.VbrMatrix_Importer(self, *args)


    def Exporter(self, *args):
        """
        Exporter(VbrMatrix self) -> Export

        const
        Epetra_Export* Epetra_VbrMatrix::Exporter() const

        Returns the Epetra_Export object that contains the export operations
        for distributed operations. 
        """
        return _Epetra.VbrMatrix_Exporter(self, *args)


    def DomainMap(self, *args):
        """
        DomainMap(VbrMatrix self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_VbrMatrix::DomainMap() const

        Returns the Epetra_BlockMap object associated with the domain of this
        matrix operator. 
        """
        return _Epetra.VbrMatrix_DomainMap(self, *args)


    def RangeMap(self, *args):
        """
        RangeMap(VbrMatrix self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_VbrMatrix::RangeMap() const

        Returns the Epetra_BlockMap object associated with the range of this
        matrix operator. 
        """
        return _Epetra.VbrMatrix_RangeMap(self, *args)


    def RowMap(self, *args):
        """
        RowMap(VbrMatrix self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_VbrMatrix::RowMap() const

        Returns the RowMap object as an Epetra_BlockMap (the Epetra_Map base
        class) needed for implementing Epetra_RowMatrix. 
        """
        return _Epetra.VbrMatrix_RowMap(self, *args)


    def ColMap(self, *args):
        """
        ColMap(VbrMatrix self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_VbrMatrix::ColMap() const

        Returns the ColMap as an Epetra_BlockMap (the Epetra_Map base class)
        needed for implementing Epetra_RowMatrix. 
        """
        return _Epetra.VbrMatrix_ColMap(self, *args)


    def Comm(self, *args):
        """
        Comm(VbrMatrix self) -> Comm

        const Epetra_Comm&
        Epetra_VbrMatrix::Comm() const

        Fills a matrix with rows from a source matrix based on the specified
        importer.

        Returns a pointer to the Epetra_Comm communicator associated with this
        matrix. 
        """
        return _Epetra.VbrMatrix_Comm(self, *args)


    def LRID(self, *args):
        """
        LRID(VbrMatrix self, int GRID_in) -> int
        LRID(VbrMatrix self, long long GRID_in) -> int

        int
        Epetra_VbrMatrix::LRID(long long GRID_in) const 
        """
        return _Epetra.VbrMatrix_LRID(self, *args)


    def GRID(self, *args):
        """
        GRID(VbrMatrix self, int LRID_in) -> int

        int
        Epetra_VbrMatrix::GRID(int LRID_in) const

        Returns the global row index for give local row index, returns
        IndexBase-1 if we don't have this local row. 
        """
        return _Epetra.VbrMatrix_GRID(self, *args)


    def GRID64(self, *args):
        """
        GRID64(VbrMatrix self, int LRID_in) -> long long

        long long
        Epetra_VbrMatrix::GRID64(int LRID_in) const 
        """
        return _Epetra.VbrMatrix_GRID64(self, *args)


    def LCID(self, *args):
        """
        LCID(VbrMatrix self, int GCID_in) -> int
        LCID(VbrMatrix self, long long GCID_in) -> int

        int
        Epetra_VbrMatrix::LCID(long long GCID_in) const 
        """
        return _Epetra.VbrMatrix_LCID(self, *args)


    def GCID(self, *args):
        """
        GCID(VbrMatrix self, int LCID_in) -> int

        int
        Epetra_VbrMatrix::GCID(int LCID_in) const

        Returns the global column index for give local column index, returns
        IndexBase-1 if we don't have this local column. 
        """
        return _Epetra.VbrMatrix_GCID(self, *args)


    def GCID64(self, *args):
        """
        GCID64(VbrMatrix self, int LCID_in) -> long long

        long long
        Epetra_VbrMatrix::GCID64(int LCID_in) const 
        """
        return _Epetra.VbrMatrix_GCID64(self, *args)


    def MyGRID(self, *args):
        """
        MyGRID(VbrMatrix self, int GRID_in) -> bool
        MyGRID(VbrMatrix self, long long GRID_in) -> bool

        bool
        Epetra_VbrMatrix::MyGRID(long long GRID_in) const 
        """
        return _Epetra.VbrMatrix_MyGRID(self, *args)


    def MyLRID(self, *args):
        """
        MyLRID(VbrMatrix self, int LRID_in) -> bool

        bool
        Epetra_VbrMatrix::MyLRID(int LRID_in) const

        Returns true if the LRID passed in belongs to the calling processor in
        this map, otherwise returns false. 
        """
        return _Epetra.VbrMatrix_MyLRID(self, *args)


    def MyGCID(self, *args):
        """
        MyGCID(VbrMatrix self, int GCID_in) -> bool
        MyGCID(VbrMatrix self, long long GCID_in) -> bool

        bool
        Epetra_VbrMatrix::MyGCID(long long GCID_in) const 
        """
        return _Epetra.VbrMatrix_MyGCID(self, *args)


    def MyLCID(self, *args):
        """
        MyLCID(VbrMatrix self, int LCID_in) -> bool

        bool
        Epetra_VbrMatrix::MyLCID(int LCID_in) const

        Returns true if the LRID passed in belongs to the calling processor in
        this map, otherwise returns false. 
        """
        return _Epetra.VbrMatrix_MyLCID(self, *args)


    def MyGlobalBlockRow(self, *args):
        """
        MyGlobalBlockRow(VbrMatrix self, int GID) -> bool
        MyGlobalBlockRow(VbrMatrix self, long long GID) -> bool

        bool
        Epetra_VbrMatrix::MyGlobalBlockRow(long long GID) const 
        """
        return _Epetra.VbrMatrix_MyGlobalBlockRow(self, *args)


    def Label(self, *args):
        """
        Label(VbrMatrix self) -> char const *

        const char*
        Epetra_VbrMatrix::Label() const

        Returns a character string describing the operator. 
        """
        return _Epetra.VbrMatrix_Label(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(VbrMatrix self, bool UseTranspose_in) -> int

        int
        Epetra_VbrMatrix::SetUseTranspose(bool UseTranspose_in)

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Always returns 0. 
        """
        return _Epetra.VbrMatrix_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(VbrMatrix self, MultiVector X, MultiVector Y) -> int

        int
        Epetra_VbrMatrix::Apply(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_Operator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(VbrMatrix self, MultiVector X, MultiVector Y) -> int

        int
        Epetra_VbrMatrix::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        In this implementation, we use several existing attributes to
        determine how virtual method ApplyInverse() should call the concrete
        method Solve(). We pass in the UpperTriangular(), the
        Epetra_VbrMatrix::UseTranspose(), and NoDiagonal() methods. The most
        notable warning is that if a matrix has no diagonal values we assume
        that there is an implicit unit diagonal that should be accounted for
        when doing a triangular solve.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ApplyInverse(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::HasNormInf() const

        Returns true because this class can compute an Inf-norm. 
        """
        return _Epetra.VbrMatrix_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(VbrMatrix self) -> bool

        bool
        Epetra_VbrMatrix::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Epetra.VbrMatrix_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(VbrMatrix self) -> Map

        const
        Epetra_Map& Epetra_VbrMatrix::OperatorDomainMap() const

        Returns the Epetra_Map object associated with the domain of this
        matrix operator. 
        """
        return _Epetra.VbrMatrix_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(VbrMatrix self) -> Map

        const
        Epetra_Map& Epetra_VbrMatrix::OperatorRangeMap() const

        Returns the Epetra_Map object associated with the range of this matrix
        operator. 
        """
        return _Epetra.VbrMatrix_OperatorRangeMap(self, *args)


    def ExtractGlobalRowCopy(self, *args):
        """
        ExtractGlobalRowCopy(VbrMatrix self, int GlobalRow, int Length, int & NumEntries, double * Values, int * Indices) -> int

        int
        Epetra_VbrMatrix::ExtractGlobalRowCopy(int GlobalRow, int Length, int
        &NumEntries, double *Values, int *Indices) const

        Returns a copy of the specified global row in user-provided arrays.

        Parameters:
        -----------

        In:  GlobalRow - Global row to extract.

        In:  Length - Length of Values and Indices.

        Out:  NumEntries - Number of nonzero entries extracted.

        Out:  Values - Extracted values for this row.

        Out:  Indices - Extracted global column indices for the corresponding
        values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractGlobalRowCopy(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(VbrMatrix self, int MyRow, int Length, int & NumEntries, double * Values, int * Indices) -> int

        int
        Epetra_VbrMatrix::ExtractMyRowCopy(int MyRow, int Length, int
        &NumEntries, double *Values, int *Indices) const

        Returns a copy of the specified local row in user-provided arrays.

        Parameters:
        -----------

        In:  MyRow - Local row to extract.

        In:  Length - Length of Values and Indices.

        Out:  NumEntries - Number of nonzero entries extracted.

        Out:  Values - Extracted values for this row.

        Out:  Indices - Extracted local column indices for the corresponding
        values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_ExtractMyRowCopy(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(VbrMatrix self, int MyRow, int & NumEntries) -> int

        int
        Epetra_VbrMatrix::NumMyRowEntries(int MyRow, int &NumEntries) const

        Return the current number of values stored for the specified local
        row.

        Parameters:
        -----------

        In:  MyRow - Local row.

        Out:  NumEntries - Number of nonzero values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.VbrMatrix_NumMyRowEntries(self, *args)


    def MaxNumEntries(self, *args):
        """
        MaxNumEntries(VbrMatrix self) -> int

        int
        Epetra_VbrMatrix::MaxNumEntries() const

        Returns the maximum of NumMyRowEntries() over all rows. 
        """
        return _Epetra.VbrMatrix_MaxNumEntries(self, *args)


    def Map(self, *args):
        """
        Map(VbrMatrix self) -> BlockMap

        const Epetra_BlockMap&
        Epetra_VbrMatrix::Map() const

        Map() method inherited from Epetra_DistObject. 
        """
        return _Epetra.VbrMatrix_Map(self, *args)


    def RowMatrixRowMap(self, *args):
        """
        RowMatrixRowMap(VbrMatrix self) -> Map

        const
        Epetra_Map& Epetra_VbrMatrix::RowMatrixRowMap() const

        Returns the EpetraMap object associated with the rows of this matrix.

        """
        return _Epetra.VbrMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """
        RowMatrixColMap(VbrMatrix self) -> Map

        const
        Epetra_Map& Epetra_VbrMatrix::RowMatrixColMap() const

        Returns the Epetra_Map object associated with columns of this matrix.

        """
        return _Epetra.VbrMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """
        RowMatrixImporter(VbrMatrix self) -> Import

        const
        Epetra_Import* Epetra_VbrMatrix::RowMatrixImporter() const

        Returns the Epetra_Import object that contains the import operations
        for distributed operations. 
        """
        return _Epetra.VbrMatrix_RowMatrixImporter(self, *args)


    def BlockImportMap(self, *args):
        """
        BlockImportMap(VbrMatrix self) -> BlockMap

        const
        Epetra_BlockMap& Epetra_VbrMatrix::BlockImportMap() const

        Use BlockColMap() instead. 
        """
        return _Epetra.VbrMatrix_BlockImportMap(self, *args)


    def TransformToLocal(self, *args):
        """
        TransformToLocal(VbrMatrix self) -> int
        TransformToLocal(VbrMatrix self, BlockMap DomainMap, BlockMap RangeMap) -> int

        int
        Epetra_VbrMatrix::TransformToLocal(const Epetra_BlockMap *DomainMap,
        const Epetra_BlockMap *RangeMap)

        Use FillComplete(const Epetra_BlockMap& DomainMap, const
        Epetra_BlockMap& RangeMap) instead. 
        """
        return _Epetra.VbrMatrix_TransformToLocal(self, *args)


    def __init__(self, *args):
        """

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, int
            numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with implicit column map and constant number
          of block entries per row.


        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            int numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with specified column map and constant number
          of block entries per row.



        __init__(self, Epetra_DataAccess CV, CrsGraph graph) -> VbrMatrix

          CrsGraph constructor.


        __init__(self, VbrMatrix matrix) -> VbrMatrix

          Copy constructor.


        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, PySequence
            numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with implicit column map and variable number
          of block entries per row.



        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            PySequence numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with specified column map and variable number
          of block entries per row.



        Epetra_VbrMatrix::Epetra_VbrMatrix(const Epetra_VbrMatrix &Matrix)

        Copy constructor. 
        """
        this = _Epetra.new_VbrMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
VbrMatrix_swigregister = _Epetra.VbrMatrix_swigregister
VbrMatrix_swigregister(VbrMatrix)

class FEVbrMatrix(VbrMatrix):
    """


    Epetra Finite-Element VbrMatrix. This class provides the ability to
    input finite-element style sub-matrix data, including sub-matrices
    with non-local rows (which could correspond to shared finite-element
    nodes for example). This class inherits Epetra_VbrMatrix, and so all
    Epetra_VbrMatrix functionality is also available.

    C++ includes: Epetra_FEVbrMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [VbrMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FEVbrMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [VbrMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FEVbrMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, int * NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, int NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, BlockMap ColMap, int * NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, BlockMap ColMap, int NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, CrsGraph Graph, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, FEVbrMatrix src) -> FEVbrMatrix

        Epetra_FEVbrMatrix::Epetra_FEVbrMatrix(const Epetra_FEVbrMatrix &src)

        Copy Constructor. 
        """
        this = _Epetra.new_FEVbrMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_FEVbrMatrix

    def PutScalar(self, *args):
        """
        PutScalar(FEVbrMatrix self, double ScalarConstant) -> int

        int
        Epetra_FEVbrMatrix::PutScalar(double ScalarConstant)

        Initialize all values in graph of the matrix with constant value.

        Parameters:
        -----------

        In:  ScalarConstant - Value to use.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.FEVbrMatrix_PutScalar(self, *args)


    def BeginInsertGlobalValues(self, *args):
        """
        BeginInsertGlobalValues(FEVbrMatrix self, int BlockRow, int NumBlockEntries, int * BlockIndices) -> int

        int Epetra_FEVbrMatrix::BeginInsertGlobalValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate insertion of a list of elements in a given global row of the
        matrix, values are inserted via SubmitEntry().

        Parameters:
        -----------

        In:  BlockRow - Block Row number (in global coordinates) to put
        elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Global column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.FEVbrMatrix_BeginInsertGlobalValues(self, *args)


    def BeginReplaceGlobalValues(self, *args):
        """
        BeginReplaceGlobalValues(FEVbrMatrix self, int BlockRow, int NumBlockEntries, int * BlockIndices) -> int

        int Epetra_FEVbrMatrix::BeginReplaceGlobalValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate replacement of current values with this list of entries for a
        given global row of the matrix, values are replaced via SubmitEntry()

        Parameters:
        -----------

        In:  Row - Block Row number (in global coordinates) to put elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Global column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.FEVbrMatrix_BeginReplaceGlobalValues(self, *args)


    def BeginSumIntoGlobalValues(self, *args):
        """
        BeginSumIntoGlobalValues(FEVbrMatrix self, int BlockRow, int NumBlockEntries, int * BlockIndices) -> int

        int Epetra_FEVbrMatrix::BeginSumIntoGlobalValues(int BlockRow, int
        NumBlockEntries, int *BlockIndices)

        Initiate summing into current values with this list of entries for a
        given global row of the matrix, values are replaced via SubmitEntry()

        Parameters:
        -----------

        In:  Row - Block Row number (in global coordinates) to put elements.

        In:  NumBlockEntries - Number of entries.

        In:  Indices - Global column indices corresponding to values.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.FEVbrMatrix_BeginSumIntoGlobalValues(self, *args)


    def SubmitBlockEntry(self, *args):
        """
        SubmitBlockEntry(FEVbrMatrix self, SerialDenseMatrix Mat) -> int
        SubmitBlockEntry(FEVbrMatrix self, double * Values, int LDA, int NumRows, int NumCols) -> int

        int
        Epetra_VbrMatrix::SubmitBlockEntry(Epetra_SerialDenseMatrix &Mat)

        Submit a block entry to the indicated block row and column specified
        in the Begin routine. 
        """
        return _Epetra.FEVbrMatrix_SubmitBlockEntry(self, *args)


    def EndSubmitEntries(self, *args):
        """
        EndSubmitEntries(FEVbrMatrix self) -> int

        int
        Epetra_FEVbrMatrix::EndSubmitEntries()

        Completes processing of all data passed in for the current block row.

        This function completes the processing of all block entries submitted
        via SubmitBlockEntry(). It also checks to make sure that
        SubmitBlockEntry was called the correct number of times as specified
        by the Begin routine that initiated the entry process. 
        """
        return _Epetra.FEVbrMatrix_EndSubmitEntries(self, *args)


    def GlobalAssemble(self, *args):
        """
        GlobalAssemble(FEVbrMatrix self, bool callFillComplete=True) -> int

        int
        Epetra_FEVbrMatrix::GlobalAssemble(bool callFillComplete=true) 
        """
        return _Epetra.FEVbrMatrix_GlobalAssemble(self, *args)

FEVbrMatrix_swigregister = _Epetra.FEVbrMatrix_swigregister
FEVbrMatrix_swigregister(FEVbrMatrix)

class JadMatrix(BasicRowMatrix):
    """


    Epetra_JadMatrix: A class for constructing matrix objects optimized
    for common kernels.

    The Epetra_JadMatrix class takes an existing Epetra_RowMatrix ojbect,
    analyzes it and builds a jagged diagonal equivalent of it. Once
    constructed, it is also possible to update the values of the matrix
    with values from another Epetra_RowMatrix that has the identical
    structure.

    C++ includes: Epetra_JadMatrix.h 
    """

    __swig_setmethods__ = {}
    for _s in [BasicRowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JadMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [BasicRowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, JadMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_JadMatrix self, RowMatrix Matrix) -> JadMatrix

        Epetra_JadMatrix::Epetra_JadMatrix(const Epetra_RowMatrix &Matrix)

        Epetra_JadMatrix constuctor. 
        """
        this = _Epetra.new_JadMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_JadMatrix

    def UpdateValues(self, *args):
        """
        UpdateValues(JadMatrix self, RowMatrix Matrix, bool CheckStructure=False) -> int

        int
        Epetra_JadMatrix::UpdateValues(const Epetra_RowMatrix &Matrix, bool
        CheckStructure=false)

        Update values using a matrix with identical structure. 
        """
        return _Epetra.JadMatrix_UpdateValues(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(JadMatrix self, int MyRow, int Length, int & NumEntries, double * Values, int * Indices) -> int

        int
        Epetra_JadMatrix::ExtractMyRowCopy(int MyRow, int Length, int
        &NumEntries, double *Values, int *Indices) const

        Returns a copy of the specified local row in user-provided arrays.

        Parameters:
        -----------

        MyRow:  (In) - Local row to extract.

        Length:  (In) - Length of Values and Indices.

        NumEntries:  (Out) - Number of nonzero entries extracted.

        Values:  (Out) - Extracted values for this row.

        Indices:  (Out) - Extracted global column indices for the
        corresponding values.

        Integer error code, set to 0 if successful, set to -1 if MyRow not
        valid, -2 if Length is too short (NumEntries will have required
        length). 
        """
        return _Epetra.JadMatrix_ExtractMyRowCopy(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(JadMatrix self, int MyRow, int & NumEntries) -> int

        int
        Epetra_JadMatrix::NumMyRowEntries(int MyRow, int &NumEntries) const

        Return the current number of values stored for the specified local
        row.

        Similar to NumMyEntries() except NumEntries is returned as an argument
        and error checking is done on the input value MyRow.

        Parameters:
        -----------

        MyRow:  - (In) Local row.

        NumEntries:  - (Out) Number of nonzero values.

        Integer error code, set to 0 if successful, set to -1 if MyRow not
        valid.

        None.

        Unchanged. 
        """
        return _Epetra.JadMatrix_NumMyRowEntries(self, *args)


    def Multiply(self, *args):
        """
        Multiply(JadMatrix self, bool TransA, MultiVector X, MultiVector Y) -> int

        int
        Epetra_JadMatrix::Multiply(bool TransA, const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const

        Returns the result of a Epetra_JadMatrix multiplied by a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  TransA -If true, multiply by the transpose of matrix, otherwise
        just use matrix.

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectorscontaining
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.JadMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve(JadMatrix self, bool Upper, bool Trans, bool UnitDiagonal, MultiVector X, MultiVector Y) -> int

        int
        Epetra_JadMatrix::Solve(bool Upper, bool Trans, bool UnitDiagonal,
        const Epetra_MultiVector &X, Epetra_MultiVector &Y) const

        Returns the result of a Epetra_JadMatrix solve with a
        Epetra_MultiVector X in Y (not implemented).

        Parameters:
        -----------

        In:  Upper -If true, solve Ux = y, otherwise solve Lx = y.

        In:  Trans -If true, solve transpose problem.

        In:  UnitDiagonal -If true, assume diagonal is unit (whether it's
        stored or not).

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.JadMatrix_Solve(self, *args)

JadMatrix_swigregister = _Epetra.JadMatrix_swigregister
JadMatrix_swigregister(JadMatrix)

easy = _Epetra.easy
moderate = _Epetra.moderate
hard = _Epetra.hard
unsure = _Epetra.unsure
class Epetra_LinearProblem(_object):
    """


    Epetra_LinearProblem: The Epetra Linear Problem Class.

    The Epetra_LinearProblem class is a wrapper that encapsulates the
    general information needed for solving a linear system of equations.
    Currently it accepts a Epetra matrix, initial guess and RHS and
    returns the solution. the elapsed time for each calling processor.

    C++ includes: Epetra_LinearProblem.h 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Epetra_LinearProblem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Epetra_LinearProblem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LinearProblem self) -> Epetra_LinearProblem
        __init__(Epetra_LinearProblem self, RowMatrix A, MultiVector X, MultiVector B) -> Epetra_LinearProblem
        __init__(Epetra_LinearProblem self, Operator A, MultiVector X, MultiVector B) -> Epetra_LinearProblem
        __init__(Epetra_LinearProblem self, Epetra_LinearProblem Problem) -> Epetra_LinearProblem

        Epetra_LinearProblem::Epetra_LinearProblem(const Epetra_LinearProblem
        &Problem)

        Epetra_LinearProblem Copy Constructor.

        Makes copy of an existing Epetra_LinearProblem instance. 
        """
        this = _Epetra.new_Epetra_LinearProblem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Epetra_LinearProblem

    def CheckInput(self, *args):
        """
        CheckInput(Epetra_LinearProblem self) -> int

        int
        Epetra_LinearProblem::CheckInput() const

        Check input parameters for existence and size consistency.

        Returns 0 if all input parameters are valid. Returns +1 if operator is
        not a matrix. This is not necessarily an error, but no scaling can be
        done if the user passes in an Epetra_Operator that is not an
        Epetra_Matrix 
        """
        return _Epetra.Epetra_LinearProblem_CheckInput(self, *args)


    def AssertSymmetric(self, *args):
        """
        AssertSymmetric(Epetra_LinearProblem self)

        void
        Epetra_LinearProblem::AssertSymmetric() 
        """
        return _Epetra.Epetra_LinearProblem_AssertSymmetric(self, *args)


    def SetPDL(self, *args):
        """
        SetPDL(Epetra_LinearProblem self, ProblemDifficultyLevel PDL)

        void
        Epetra_LinearProblem::SetPDL(ProblemDifficultyLevel PDL)

        Set problem difficulty level.

        Sets Aztec options and parameters based on a definition of easy
        moderate or hard problem. Relieves the user from explicitly setting a
        large number of individual parameter values. This function can be used
        in conjunction with the SetOptions() and SetParams() functions. 
        """
        return _Epetra.Epetra_LinearProblem_SetPDL(self, *args)


    def SetOperator(self, *args):
        """
        SetOperator(Epetra_LinearProblem self, RowMatrix A)
        SetOperator(Epetra_LinearProblem self, Operator A)

        void
        Epetra_LinearProblem::SetOperator(Epetra_Operator *A)

        Set Operator A of linear problem AX = B using an Epetra_Operator.

        Sets a pointer to a Epetra_Operator. No copy of the operator is made.

        """
        return _Epetra.Epetra_LinearProblem_SetOperator(self, *args)


    def SetLHS(self, *args):
        """
        SetLHS(Epetra_LinearProblem self, MultiVector X)

        void
        Epetra_LinearProblem::SetLHS(Epetra_MultiVector *X)

        Set left-hand-side X of linear problem AX = B.

        Sets a pointer to a Epetra_MultiVector. No copy of the object is made.

        """
        return _Epetra.Epetra_LinearProblem_SetLHS(self, *args)


    def SetRHS(self, *args):
        """
        SetRHS(Epetra_LinearProblem self, MultiVector B)

        void
        Epetra_LinearProblem::SetRHS(Epetra_MultiVector *B)

        Set right-hand-side B of linear problem AX = B.

        Sets a pointer to a Epetra_MultiVector. No copy of the object is made.

        """
        return _Epetra.Epetra_LinearProblem_SetRHS(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Epetra_LinearProblem self, Vector D) -> int

        int
        Epetra_LinearProblem::LeftScale(const Epetra_Vector &D)

        Perform left scaling of a linear problem.

        Applies the scaling vector D to the left side of the matrix A() and to
        the right hand side B(). Note that the operator must be an
        Epetra_RowMatrix, not just an Epetra_Operator (the base class of
        Epetra_RowMatrix).

        Parameters:
        -----------

        In:  D - Vector containing scaling values. D[i] will be applied to the
        ith row of A() and B().

        Integer error code, set to 0 if successful. Return -1 if operator is
        not a matrix. 
        """
        return _Epetra.Epetra_LinearProblem_LeftScale(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Epetra_LinearProblem self, Vector D) -> int

        int
        Epetra_LinearProblem::RightScale(const Epetra_Vector &D)

        Perform right scaling of a linear problem.

        Applies the scaling vector D to the right side of the matrix A().
        Apply the inverse of D to the initial guess. Note that the operator
        must be an Epetra_RowMatrix, not just an Epetra_Operator (the base
        class of Epetra_RowMatrix).

        Parameters:
        -----------

        In:  D - Vector containing scaling values. D[i] will be applied to the
        ith row of A(). 1/D[i] will be applied to the ith row of B().

        Integer error code, set to 0 if successful. Return -1 if operator is
        not a matrix. 
        """
        return _Epetra.Epetra_LinearProblem_RightScale(self, *args)


    def GetOperator(self, *args):
        """
        GetOperator(Epetra_LinearProblem self) -> Operator

        Epetra_Operator* Epetra_LinearProblem::GetOperator() const

        Get a pointer to the operator A. 
        """
        return _Epetra.Epetra_LinearProblem_GetOperator(self, *args)


    def GetMatrix(self, *args):
        """
        GetMatrix(Epetra_LinearProblem self) -> RowMatrix

        Epetra_RowMatrix* Epetra_LinearProblem::GetMatrix() const

        Get a pointer to the matrix A. 
        """
        return _Epetra.Epetra_LinearProblem_GetMatrix(self, *args)


    def GetLHS(self, *args):
        """
        GetLHS(Epetra_LinearProblem self) -> MultiVector

        Epetra_MultiVector* Epetra_LinearProblem::GetLHS() const

        Get a pointer to the left-hand-side X. 
        """
        return _Epetra.Epetra_LinearProblem_GetLHS(self, *args)


    def GetRHS(self, *args):
        """
        GetRHS(Epetra_LinearProblem self) -> MultiVector

        Epetra_MultiVector* Epetra_LinearProblem::GetRHS() const

        Get a pointer to the right-hand-side B. 
        """
        return _Epetra.Epetra_LinearProblem_GetRHS(self, *args)


    def GetPDL(self, *args):
        """
        GetPDL(Epetra_LinearProblem self) -> ProblemDifficultyLevel

        ProblemDifficultyLevel Epetra_LinearProblem::GetPDL() const

        Get problem difficulty level. 
        """
        return _Epetra.Epetra_LinearProblem_GetPDL(self, *args)


    def IsOperatorSymmetric(self, *args):
        """
        IsOperatorSymmetric(Epetra_LinearProblem self) -> bool

        bool Epetra_LinearProblem::IsOperatorSymmetric() const

        Get operator symmetry bool. 
        """
        return _Epetra.Epetra_LinearProblem_IsOperatorSymmetric(self, *args)

Epetra_LinearProblem_swigregister = _Epetra.Epetra_LinearProblem_swigregister
Epetra_LinearProblem_swigregister(Epetra_LinearProblem)

class LinearProblem(Epetra_LinearProblem):
    """Proxy of C++ PyTrilinos::LinearProblem class."""

    __swig_setmethods__ = {}
    for _s in [Epetra_LinearProblem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearProblem, name, value)
    __swig_getmethods__ = {}
    for _s in [Epetra_LinearProblem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearProblem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(PyTrilinos::LinearProblem self) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, Teuchos::RCP< Epetra_RowMatrix > const matrix, Teuchos::RCP< Epetra_MultiVector > const x, Teuchos::RCP< Epetra_MultiVector > const b) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, Teuchos::RCP< Epetra_Operator > const op, Teuchos::RCP< Epetra_MultiVector > const x, Teuchos::RCP< Epetra_MultiVector > const b) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, LinearProblem source) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, Epetra_LinearProblem source) -> LinearProblem
        """
        this = _Epetra.new_LinearProblem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_LinearProblem

    def CheckInput(self, *args):
        """
        CheckInput(LinearProblem self) -> int

        int
        Epetra_LinearProblem::CheckInput() const

        Check input parameters for existence and size consistency.

        Returns 0 if all input parameters are valid. Returns +1 if operator is
        not a matrix. This is not necessarily an error, but no scaling can be
        done if the user passes in an Epetra_Operator that is not an
        Epetra_Matrix 
        """
        return _Epetra.LinearProblem_CheckInput(self, *args)


    def AssertSymmetric(self, *args):
        """
        AssertSymmetric(LinearProblem self)

        void
        Epetra_LinearProblem::AssertSymmetric() 
        """
        return _Epetra.LinearProblem_AssertSymmetric(self, *args)


    def SetPDL(self, *args):
        """
        SetPDL(LinearProblem self, ProblemDifficultyLevel PDL)

        void
        Epetra_LinearProblem::SetPDL(ProblemDifficultyLevel PDL)

        Set problem difficulty level.

        Sets Aztec options and parameters based on a definition of easy
        moderate or hard problem. Relieves the user from explicitly setting a
        large number of individual parameter values. This function can be used
        in conjunction with the SetOptions() and SetParams() functions. 
        """
        return _Epetra.LinearProblem_SetPDL(self, *args)


    def SetOperator(self, *args):
        """
        SetOperator(LinearProblem self, Teuchos::RCP< Epetra_RowMatrix > & matrix)
        SetOperator(LinearProblem self, Teuchos::RCP< Epetra_Operator > & op)

        void
        Epetra_LinearProblem::SetOperator(Epetra_Operator *A)

        Set Operator A of linear problem AX = B using an Epetra_Operator.

        Sets a pointer to a Epetra_Operator. No copy of the operator is made.

        """
        return _Epetra.LinearProblem_SetOperator(self, *args)


    def SetLHS(self, *args):
        """
        SetLHS(LinearProblem self, Teuchos::RCP< Epetra_MultiVector > & x)

        void
        Epetra_LinearProblem::SetLHS(Epetra_MultiVector *X)

        Set left-hand-side X of linear problem AX = B.

        Sets a pointer to a Epetra_MultiVector. No copy of the object is made.

        """
        return _Epetra.LinearProblem_SetLHS(self, *args)


    def SetRHS(self, *args):
        """
        SetRHS(LinearProblem self, Teuchos::RCP< Epetra_MultiVector > & b)

        void
        Epetra_LinearProblem::SetRHS(Epetra_MultiVector *B)

        Set right-hand-side B of linear problem AX = B.

        Sets a pointer to a Epetra_MultiVector. No copy of the object is made.

        """
        return _Epetra.LinearProblem_SetRHS(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(LinearProblem self, Vector D) -> int

        int
        Epetra_LinearProblem::LeftScale(const Epetra_Vector &D)

        Perform left scaling of a linear problem.

        Applies the scaling vector D to the left side of the matrix A() and to
        the right hand side B(). Note that the operator must be an
        Epetra_RowMatrix, not just an Epetra_Operator (the base class of
        Epetra_RowMatrix).

        Parameters:
        -----------

        In:  D - Vector containing scaling values. D[i] will be applied to the
        ith row of A() and B().

        Integer error code, set to 0 if successful. Return -1 if operator is
        not a matrix. 
        """
        return _Epetra.LinearProblem_LeftScale(self, *args)


    def RightScale(self, *args):
        """
        RightScale(LinearProblem self, Vector D) -> int

        int
        Epetra_LinearProblem::RightScale(const Epetra_Vector &D)

        Perform right scaling of a linear problem.

        Applies the scaling vector D to the right side of the matrix A().
        Apply the inverse of D to the initial guess. Note that the operator
        must be an Epetra_RowMatrix, not just an Epetra_Operator (the base
        class of Epetra_RowMatrix).

        Parameters:
        -----------

        In:  D - Vector containing scaling values. D[i] will be applied to the
        ith row of A(). 1/D[i] will be applied to the ith row of B().

        Integer error code, set to 0 if successful. Return -1 if operator is
        not a matrix. 
        """
        return _Epetra.LinearProblem_RightScale(self, *args)


    def GetMatrix(self, *args):
        """
        GetMatrix(LinearProblem self) -> Teuchos::RCP< Epetra_RowMatrix >

        Epetra_RowMatrix* Epetra_LinearProblem::GetMatrix() const

        Get a pointer to the matrix A. 
        """
        return _Epetra.LinearProblem_GetMatrix(self, *args)


    def GetOperator(self, *args):
        """
        GetOperator(LinearProblem self) -> Teuchos::RCP< Epetra_Operator >

        Epetra_Operator* Epetra_LinearProblem::GetOperator() const

        Get a pointer to the operator A. 
        """
        return _Epetra.LinearProblem_GetOperator(self, *args)


    def GetLHS(self, *args):
        """
        GetLHS(LinearProblem self) -> Teuchos::RCP< Epetra_MultiVector >

        Epetra_MultiVector* Epetra_LinearProblem::GetLHS() const

        Get a pointer to the left-hand-side X. 
        """
        return _Epetra.LinearProblem_GetLHS(self, *args)


    def GetRHS(self, *args):
        """
        GetRHS(LinearProblem self) -> Teuchos::RCP< Epetra_MultiVector >

        Epetra_MultiVector* Epetra_LinearProblem::GetRHS() const

        Get a pointer to the right-hand-side B. 
        """
        return _Epetra.LinearProblem_GetRHS(self, *args)


    def GetPDL(self, *args):
        """
        GetPDL(LinearProblem self) -> ProblemDifficultyLevel

        ProblemDifficultyLevel Epetra_LinearProblem::GetPDL() const

        Get problem difficulty level. 
        """
        return _Epetra.LinearProblem_GetPDL(self, *args)


    def IsOperatorSymmetric(self, *args):
        """
        IsOperatorSymmetric(LinearProblem self) -> bool

        bool Epetra_LinearProblem::IsOperatorSymmetric() const

        Get operator symmetry bool. 
        """
        return _Epetra.LinearProblem_IsOperatorSymmetric(self, *args)

LinearProblem_swigregister = _Epetra.LinearProblem_swigregister
LinearProblem_swigregister(LinearProblem)

class Util(_object):
    """
    Epetra Util Wrapper Class.

    The Epetra.Util class is a collection of useful functions that cut
    across a broad set of other classes.  A random number generator is
    provided, along with methods to set and retrieve the random-number
    seed.

    The random number generator is a multiplicative linear congruential
    generator, with multiplier 16807 and modulus 2^31 - 1. It is based on
    the algorithm described in 'Random Number Generators: Good Ones Are
    Hard To Find', S. K. Park and K. W. Miller, Communications of the ACM,
    vol. 31, no. 10, pp. 1192-1201.

    The C++ Sort() method is not supported in python.

    A static function is provided for creating a new Epetra.Map object
    with 1-to-1 ownership of entries from an existing map which may have
    entries that appear on multiple processors.

    Epetra.Util is a serial interface only.  This is appropriate since the
    standard utilities are only specified for serial execution (or shared
    memory parallel).
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Util, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Util, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Util self) -> Util
        __init__(Epetra_Util self, Util Util) -> Util

        Epetra_Util::Epetra_Util(const Epetra_Util &Util)

        Epetra_Util Copy Constructor.

        Makes an exact copy of an existing Epetra_Util instance. 
        """
        this = _Epetra.new_Util(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Util

    def RandomInt(self, *args):
        """
        RandomInt(Util self) -> unsigned int

        unsigned int
        Epetra_Util::RandomInt()

        Returns a random integer on the interval (0, 2^31-1) 
        """
        return _Epetra.Util_RandomInt(self, *args)


    def RandomDouble(self, *args):
        """
        RandomDouble(Util self) -> double

        double
        Epetra_Util::RandomDouble()

        Returns a random double on the interval (-1.0,1.0) 
        """
        return _Epetra.Util_RandomDouble(self, *args)


    def Seed(self, *args):
        """
        Seed(Util self) -> unsigned int

        unsigned int
        Epetra_Util::Seed() const

        Get seed from Random function.

        Current random number seed. 
        """
        return _Epetra.Util_Seed(self, *args)


    def SetSeed(self, *args):
        """
        SetSeed(Util self, unsigned int Seed_in) -> int

        int
        Epetra_Util::SetSeed(unsigned int Seed_in)

        Set seed for Random function.

        Parameters:
        -----------

        In:  Seed - An integer on the interval [1, 2^31-2]

        Integer error code, set to 0 if successful. 
        """
        return _Epetra.Util_SetSeed(self, *args)


    def Create_Root_Map(*args):
        """Create_Root_Map(Map usermap, int root=0) -> Map"""
        return _Epetra.Util_Create_Root_Map(*args)

    Create_Root_Map = staticmethod(Create_Root_Map)

    def Create_OneToOne_Map(*args):
        """Create_OneToOne_Map(Map usermap, bool high_rank_proc_owns_shared=False) -> Map"""
        return _Epetra.Util_Create_OneToOne_Map(*args)

    Create_OneToOne_Map = staticmethod(Create_OneToOne_Map)

    def Create_OneToOne_BlockMap(*args):
        """Create_OneToOne_BlockMap(BlockMap usermap, bool high_rank_proc_owns_shared=False) -> BlockMap"""
        return _Epetra.Util_Create_OneToOne_BlockMap(*args)

    Create_OneToOne_BlockMap = staticmethod(Create_OneToOne_BlockMap)

    def SortCrsEntries(*args):
        """SortCrsEntries(int NumRows, int const * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
        return _Epetra.Util_SortCrsEntries(*args)

    SortCrsEntries = staticmethod(SortCrsEntries)

    def SortAndMergeCrsEntries(*args):
        """SortAndMergeCrsEntries(int NumRows, int * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
        return _Epetra.Util_SortAndMergeCrsEntries(*args)

    SortAndMergeCrsEntries = staticmethod(SortAndMergeCrsEntries)

    def GetPidGidPairs(*args):
        """
        GetPidGidPairs(Import Importer, std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > & gpids, bool use_minus_one_for_local) -> int
        GetPidGidPairs(Import Importer, std::vector< std::pair< int,long long >,std::allocator< std::pair< int,long long > > > & gpids, bool use_minus_one_for_local) -> int
        """
        return _Epetra.Util_GetPidGidPairs(*args)

    GetPidGidPairs = staticmethod(GetPidGidPairs)

    def GetPids(*args):
        """GetPids(Import Importer, std::vector< int,std::allocator< int > > & pids, bool use_minus_one_for_local) -> int"""
        return _Epetra.Util_GetPids(*args)

    GetPids = staticmethod(GetPids)

    def GetRemotePIDs(*args):
        """GetRemotePIDs(Import Importer, std::vector< int,std::allocator< int > > & RemotePIDs) -> int"""
        return _Epetra.Util_GetRemotePIDs(*args)

    GetRemotePIDs = staticmethod(GetRemotePIDs)

    def Chop(*args):
        """Chop(double const & Value) -> double"""
        return _Epetra.Util_Chop(*args)

    Chop = staticmethod(Chop)
Util_swigregister = _Epetra.Util_swigregister
Util_swigregister(Util)

def Util_Create_Root_Map(*args):
    """Util_Create_Root_Map(Map usermap, int root=0) -> Map"""
    return _Epetra.Util_Create_Root_Map(*args)

def Util_Create_OneToOne_Map(*args):
    """Util_Create_OneToOne_Map(Map usermap, bool high_rank_proc_owns_shared=False) -> Map"""
    return _Epetra.Util_Create_OneToOne_Map(*args)

def Util_Create_OneToOne_BlockMap(*args):
    """Util_Create_OneToOne_BlockMap(BlockMap usermap, bool high_rank_proc_owns_shared=False) -> BlockMap"""
    return _Epetra.Util_Create_OneToOne_BlockMap(*args)

def Util_SortCrsEntries(*args):
    """Util_SortCrsEntries(int NumRows, int const * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
    return _Epetra.Util_SortCrsEntries(*args)

def Util_SortAndMergeCrsEntries(*args):
    """Util_SortAndMergeCrsEntries(int NumRows, int * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
    return _Epetra.Util_SortAndMergeCrsEntries(*args)

def Util_GetPidGidPairs(*args):
    """
    GetPidGidPairs(Import Importer, std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > & gpids, bool use_minus_one_for_local) -> int
    Util_GetPidGidPairs(Import Importer, std::vector< std::pair< int,long long >,std::allocator< std::pair< int,long long > > > & gpids, bool use_minus_one_for_local) -> int
    """
    return _Epetra.Util_GetPidGidPairs(*args)

def Util_GetPids(*args):
    """Util_GetPids(Import Importer, std::vector< int,std::allocator< int > > & pids, bool use_minus_one_for_local) -> int"""
    return _Epetra.Util_GetPids(*args)

def Util_GetRemotePIDs(*args):
    """Util_GetRemotePIDs(Import Importer, std::vector< int,std::allocator< int > > & RemotePIDs) -> int"""
    return _Epetra.Util_GetRemotePIDs(*args)

def Util_Chop(*args):
    """Util_Chop(double const & Value) -> double"""
    return _Epetra.Util_Chop(*args)
Util.chopVal_ = _Epetra.cvar.Util_chopVal_


def Epetra_Util_binary_search(*args):
    """
    Epetra_Util_binary_search(int item, int const * list, int len, int & insertPoint) -> int
    Epetra_Util_binary_search(long long item, long long const * list, int len, int & insertPoint) -> int

    EPETRA_LIB_DLL_EXPORT int Epetra_Util_binary_search(long long item,
    const long long *list, int len, int &insertPoint) 
    """
    return _Epetra.Epetra_Util_binary_search(*args)

def Epetra_Util_binary_search_aux(*args):
    """
    Epetra_Util_binary_search_aux(int item, int const * list, int const * aux_list, int len, int & insertPoint) -> int
    Epetra_Util_binary_search_aux(long long item, int const * list, long long const * aux_list, int len, int & insertPoint) -> int

    EPETRA_LIB_DLL_EXPORT int Epetra_Util_binary_search_aux(long long
    item, const int *list, const long long *aux_list, int len, int
    &insertPoint) 
    """
    return _Epetra.Epetra_Util_binary_search_aux(*args)

def Epetra_Util_ExtractHbData(*args):
    """
    Epetra_Util_ExtractHbData(CrsMatrix A, MultiVector LHS, MultiVector RHS, int & M, int & N, int & nz, int *& ptr, int *& ind, double *& val, int & Nrhs, double *& rhs, int & ldrhs, double *& lhs, int & ldlhs) -> int

    int
    Epetra_Util_ExtractHbData(Epetra_CrsMatrix *A, Epetra_MultiVector
    *LHS, Epetra_MultiVector *RHS, int &M, int &N, int &nz, int *&ptr, int
    *&ind, double *&val, int &Nrhs, double *&rhs, int &ldrhs, double
    *&lhs, int &ldlhs)

    Harwell-Boeing data extraction routine.

    This routine will extract data from an existing Epetra_Crs Matrix, and
    optionally from related rhs and lhs objects in a form that is
    compatible with software that requires the Harwell-Boeing data format.
    The matrix must be passed in, but the RHS and LHS arguments may be set
    to zero (either or both of them). For each of the LHS or RHS
    arguments, if non-trivial and contain more than one vector, the
    vectors must have strided access. If both LHS and RHS are non-trivial,
    they must have the same number of vectors. If the input objects are
    distributed, the returned matrices will contain the local part of the
    matrix and vectors only.

    Parameters:
    -----------

    A:  (In) Epetra_CrsMatrix.

    LHS:  (In) Left hand side multivector. Set to zero if none not
    available or needed.

    RHS:  (In) Right hand side multivector. Set to zero if none not
    available or needed.

    M:  (Out) Local row dimension of matrix.

    N:  (Out) Local column dimension of matrix.

    nz:  (Out) Number of nonzero entries in matrix.

    ptr:  (Out) Offsets into ind and val arrays pointing to start of each
    row's data.

    ind:  (Out) Column indices of the matrix, in compressed form.

    val:  (Out) Matrix values, in compressed form corresponding to the ind
    array.

    Nrhs:  (Out) Number of right/left hand sides found (if any) in RHS and
    LHS.

    rhs:  (Out) Fortran-style 2D array of RHS values.

    ldrhs:  (Out) Stride between columns of rhs.

    lhs:  (Out) Fortran-style 2D array of LHS values.

    ldrhs:  (Out) Stride between columns of lhs. 
    """
    return _Epetra.Epetra_Util_ExtractHbData(*args)
# This file is compatible with both classic and new-style classes.


