# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Domi is the python interface to the Trilinos structured,
multi-dimensional, distrivuted linear algebra servise package Domi:

    http://trilinos.sandia.gov/packages/domi

Domi supports the structured decomposition of structured vectors
(arrays), maps, and communicators.  It also supports the conversion of
these objects to Epetra and Tpetra Vectors, MultiVectors, and Maps
(including as views where possible), so that they can be used with
other Trilinos solver technologies.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Domi')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Domi')
    _Domi = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Domi', [dirname(__file__)])
        except ImportError:
            import _Domi
            return _Domi
        try:
            _mod = imp.load_module('_Domi', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Domi = swig_import_helper()
    del swig_import_helper
else:
    import _Domi
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Domi.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Domi.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Domi.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Domi.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Domi.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Domi.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Domi.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Domi.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Domi.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Domi.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Domi.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Domi.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Domi.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Domi.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Domi.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Domi.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Domi.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Domi.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


import numpy

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Tpetra
else:
    import Tpetra
del _swig_python_version_info
C_ORDER = _Domi.C_ORDER
FORTRAN_ORDER = _Domi.FORTRAN_ORDER
ROW_MAJOR = _Domi.ROW_MAJOR
COLUMN_MAJOR = _Domi.COLUMN_MAJOR
LAST_INDEX_FASTEST = _Domi.LAST_INDEX_FASTEST
FIRST_INDEX_FASTEST = _Domi.FIRST_INDEX_FASTEST
DEFAULT_ORDER = _Domi.DEFAULT_ORDER

def factor(*args):
    """factor(int n) -> Teuchos::Array< int >"""
    return _Domi.factor(*args)

def indexOfMax(*args):
    """indexOfMax(Teuchos::ArrayView< float const > const & seq) -> int"""
    return _Domi.indexOfMax(*args)

def decomposeProcs(*args):
    """decomposeProcs(int nprocs, Teuchos::ArrayView< Domi::dim_type > const & dimensions) -> Teuchos::Array< int >"""
    return _Domi.decomposeProcs(*args)

def createArrayOfInts(*args):
    """createArrayOfInts(int numDims, Teuchos::ArrayView< int const > const & source) -> Teuchos::Array< int >"""
    return _Domi.createArrayOfInts(*args)

def class_array_inplace_op(self, op_str, other):
  in_op = getattr(self.array, "__i"+op_str+"__")
  in_op(other.array)
  return self

def class_array_math_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
# Get the equivalent in-place operator for the result
  in_op = getattr(result.array, "__i"+op_str+"__")
  try:
    in_op(other.array)
  except AttributeError:
    in_op(other)
  return result

def class_array_rmath_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
  indices = (slice(None),) * len(self.array.shape)
  result.array[indices] = other
  in_op = getattr(result.array, "__i"+op_str+"__")
  in_op(self.array)
  return result

def class_array_add_math_ops(cls, op_str):
  setattr(cls,
          "__i"+op_str+"__",
          lambda self, other: class_array_inplace_op(self, op_str, other))
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_math_op(self, op_str, other))
  setattr(cls,
          "__r"+op_str+"__",
          lambda self, other: class_array_rmath_op(self, op_str, other))

def class_array_add_math(cls):
  class_array_add_math_ops(cls, "add")
  class_array_add_math_ops(cls, "sub")
  class_array_add_math_ops(cls, "mul")
  class_array_add_math_ops(cls, "add")

def class_array_comp_op(self, op_str, other):
  comp_op = getattr(self.array, "__"+op_str+"__")
  try:
    return comp_op(other.array)
  except AttributeError:
    return comp_op(other)

def class_array_add_comp_op(cls, op_str):
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_comp_op(self, op_str, other))

def class_array_add_comp(cls):
  class_array_add_comp_op(cls, "lt")
  class_array_add_comp_op(cls, "le")
  class_array_add_comp_op(cls, "eq")
  class_array_add_comp_op(cls, "ne")
  class_array_add_comp_op(cls, "gt")
  class_array_add_comp_op(cls, "ge")



def Version(*args):
    """Version() -> std::string"""
    return _Domi.Version(*args)

__version__ = Version().split()[2]


def getValidParameters(*args):
    """getValidParameters() -> Teuchos::RCP< Teuchos::ParameterList const >"""
    return _Domi.getValidParameters(*args)
class MDComm(_object):
    """


    Multi-dimensional communicator object.

    The  MDComm is a relatively simple class that contains a
    Teuchos::RCP<const Teuchos::Comm<int> > and arranges the processor
    ranks of that communicator in a multi- dimensional grid suitable for
    decomposing a multi-dimensional data structure.

    To construct an  MDComm, the user provides the number of dimensions,
    an array of sizes along each axis, or both. The user can request the
    constructor to compute some of the decomposition by making the axis
    sizes list shorter than the number of dimensions, or by providing axis
    sizes that are negative. Currently, the algorithm assigns all
    remaining processors to the first unspecified axis size, and assigns
    all the rest to be one.

    An  MDComm can also be constructed that is a slice of a parent
    MDComm. Such an object is constructed by providing an RCP of the
    parent and an array of Slices that define the sub-communicator. When
    you construct a sub-communicator, you run the risk of calling methods
    of the  MDComm object or of objects built on top of the  MDComm object
    from processors that are not a part of the sub-communicator. You can
    always check whether this is safe with the

    method.

    The  MDComm class provides two methods that return the processor rank
    of neighboring processors in the grid of arrays:

    This should be sufficient to provide the necessary processor ranks for
    conducting communication padding updates.

    C++ includes: Domi_MDComm.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MDComm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MDComm, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Domi::MDComm self, Teuchos::ArrayView< int const > const & commDims, Teuchos::ArrayView< int const > const & periodic) -> MDComm
        __init__(Domi::MDComm self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, Teuchos::ArrayView< int const > const & commDims, Teuchos::ArrayView< int const > const & periodic) -> MDComm
        __init__(Domi::MDComm self, ParameterList plist) -> MDComm
        __init__(Domi::MDComm self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, ParameterList plist) -> MDComm
        __init__(Domi::MDComm self, int numDims) -> MDComm
        __init__(Domi::MDComm self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, int numDims) -> MDComm
        __init__(Domi::MDComm self, int numDims, Teuchos::ArrayView< int const > const & commDims, Teuchos::ArrayView< int const > const & periodic) -> MDComm
        __init__(Domi::MDComm self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, int numDims, Teuchos::ArrayView< int const > const & commDims, Teuchos::ArrayView< int const > const & periodic) -> MDComm
        __init__(Domi::MDComm self, MDComm parent, int axis, int axisRank) -> MDComm
        __init__(Domi::MDComm self, MDComm parent, int axis, Slice slice) -> MDComm
        __init__(Domi::MDComm self, MDComm parent, Teuchos::ArrayView< Domi::Slice > const & slices) -> MDComm
        __init__(Domi::MDComm self, MDComm source) -> MDComm

        Domi::MDComm::MDComm(const MDComm &source)

        Copy constructor.

        Parameters:
        -----------

        source:  [in] Source MDComm to be copied 
        """
        this = _Domi.new_MDComm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Domi.delete_MDComm

    def onSubcommunicator(self, *args):
        """
        onSubcommunicator(MDComm self) -> bool

        bool
        Domi::MDComm::onSubcommunicator() const

        Query whether this processor is on the sub-communicator.

        Sub-communicators are formed when a parent MDComm is sliced by using
        the (parent,slices) constructor. For a full communicator, this method
        will always return true. 
        """
        return _Domi.MDComm_onSubcommunicator(self, *args)


    def getTeuchosComm(self, *args):
        """
        getTeuchosComm(MDComm self) -> Teuchos::RCP< Teuchos::Comm< int > const >

        Teuchos::RCP<
        const Teuchos::Comm< int > > Domi::MDComm::getTeuchosComm() const

        Get the Teuchos communicator.

        Note that if the communicator is not a full communicator, i.e. a sub-
        communicator, that the underlying Comm pointer may be NULL, depending
        on this processor's rank. 
        """
        return _Domi.MDComm_getTeuchosComm(self, *args)


    def getEpetraComm(self, *args):
        """getEpetraComm(MDComm self) -> Teuchos::RCP< Epetra_Comm const >"""
        return _Domi.MDComm_getEpetraComm(self, *args)


    def numDims(self, *args):
        """
        numDims(MDComm self) -> int

        int
        Domi::MDComm::numDims() const

        Get the number of dimensions.

        This method will return 0 if the communicator is a sub-communicator
        and this processor does not belong to the sub-communicator. 
        """
        return _Domi.MDComm_numDims(self, *args)


    def getCommDims(self, *args):
        """
        getCommDims(MDComm self) -> Teuchos::Array< int >

        Teuchos::Array< int
        > Domi::MDComm::getCommDims() const

        Get the communicator sizes along each axis.

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDComm_getCommDims(self, *args)


    def getCommDim(self, *args):
        """
        getCommDim(MDComm self, int axis) -> int

        int
        Domi::MDComm::getCommDim(int axis) const

        Get the communicator size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDComm_getCommDim(self, *args)


    def isPeriodic(self, *args):
        """
        isPeriodic(MDComm self, int axis) -> bool

        bool
        Domi::MDComm::isPeriodic(int axis) const

        Return the periodic flag for the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDComm_isPeriodic(self, *args)


    def getCommIndex(self, *args):
        """
        getCommIndex(MDComm self, int axis) -> int

        int
        Domi::MDComm::getCommIndex(int axis) const

        Get the comm index along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDComm_getCommIndex(self, *args)


    def getLowerNeighbor(self, *args):
        """
        getLowerNeighbor(MDComm self, int axis) -> int

        int
        Domi::MDComm::getLowerNeighbor(int axis) const

        Get the rank of the lower neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is zero, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is zero, then the returned lower neighbor will
        be the highest axis rank processor along this axis. 
        """
        return _Domi.MDComm_getLowerNeighbor(self, *args)


    def getUpperNeighbor(self, *args):
        """
        getUpperNeighbor(MDComm self, int axis) -> int

        int
        Domi::MDComm::getUpperNeighbor(int axis) const

        Get the rank of the upper neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is the highest axis rank along the axis, then
        this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is the highest axis rank along the axis, then
        this method will return axis rank zero. 
        """
        return _Domi.MDComm_getUpperNeighbor(self, *args)


    def getAxisComms(self, *args):
        """
        getAxisComms(MDComm self) -> Teuchos::ArrayView< Teuchos::RCP< Domi::MDComm const > >

        Teuchos::ArrayView< Teuchos::RCP< const MDComm > >
        Domi::MDComm::getAxisComms() const

        Return array of all axis communicators.

        An axis communicator is a 1D MDComm sub-communicator that represents
        the comms on a given axis. Further, this sub-communicator will always
        be valid for the processor on which it was constructed. 
        """
        return _Domi.MDComm_getAxisComms(self, *args)


    def getAxisComm(self, *args):
        """
        getAxisComm(MDComm self, int axis) -> Teuchos::RCP< Domi::MDComm const >

        Teuchos::RCP< const
        MDComm > Domi::MDComm::getAxisComm(int axis) const

        Return an axis communicator for the given axis.

        Parameters:
        -----------

        axis:  [in] The axis of the requested axis communicator

        An axis communicator is a 1D MDComm sub-communicator that represents
        the comms on a given axis. Further, this sub-communicator will always
        be valid for the processor on which it was constructed. 
        """
        return _Domi.MDComm_getAxisComm(self, *args)


    def __getitem__(self, *args):
        """__getitem__(MDComm self, PyObject * indexes) -> MDComm"""
        return _Domi.MDComm___getitem__(self, *args)

MDComm_swigregister = _Domi.MDComm_swigregister
MDComm_swigregister(MDComm)
cvar = _Domi.cvar
MDComm.commLayout = _Domi.cvar.MDComm_commLayout

class MDMap_default(_object):
    """


    Multi-dimensional map.

    The  MDMap class is intended to perform the functions of Epetra or
    Tpetra maps, except that the data is multi-dimensional. Rather than
    taking a Teuchos::Comm object in its constructor, an  MDMap object
    takes a  Domi::MDComm object. An  MDComm object is ordered in a
    structured way, with processors assigned to each axis, whose product
    of lengths is the total number of processors of its underlying
    communicator.

    At a bare minimum, an  MDMap constructor requires an  MDComm and an
    array of dimensions indicating the size and shape of the data
    structure(s) the  MDMap will describe. Each dimension will be
    decomposed along each axis, according to the number of processors
    along that axis in the  MDComm, in as even a fashion as is possible.

    Each axis may be flagged as periodic when constructing the  MDComm.
    This attribute is transferred to the  MDMap at construction.

    There are two distinct buffer padding concepts employed by MDMaps,
    communication padding and boundary padding. Communication padding
    refers to local extensions of the data structure used to receive
    communication from neighboring processors. Boundary padding refers to
    points added to the exterior of the global domain that are useful, for
    example, in certain finite differencing algorithms. They are treated
    separately from the dimensions so that the decomposition will be
    performed relative to the dimensions only, and not influenced by the
    size of the boundary padding.

    From a global perspective, the only padding points that are visible
    are boundary padding points. Communication padding is internal and
    essentially invisible from this perspective. From a local perspective,
    a local buffer can have padding on all sides. Some of this padding
    could be boundary padding, some could be communication padding, and
    some could be both.

    The sizes of boundary and communication padding can be different along
    each axis, and the sizes of boundary and communication padding on any
    given axis can be different from each other.

    When you want to loop over the elements of a data structure described
    by an  MDMap, you can obtain the local looping bounds along a given
    axis with the getLocalBounds(int axis) method. This returns a  Slice
    object, whose start() and stop() methods return the loop bounds (
    stop() is non-inclusive). This method also takes a boolean flag
    indicating whether the bounds should include the communication
    padding, which defaults to false.

    There are two methods for obtaining global loop bounds,
    getGlobalBounds(int axis) and getGlobalRankBounds(int axis). The first
    returns the global bounds for the full data structure and the second
    returns the bounds on this processor.

    Note that all indexes start at zero, whether global or local, whether
    unique 1D IDs or multidimensional indexes, whether boundary or
    communication padding is present. This allows negative indexes to
    represent reverse indexing from the end of a dimension.

    C++ includes: Domi_MDMap.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MDMap_default, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MDMap_default, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDComm const > const mdComm, Teuchos::ArrayView< Domi::dim_type const > const & dimensions, Teuchos::ArrayView< int const > const & commPad, Teuchos::ArrayView< int const > const & bndryPad, Teuchos::ArrayView< int const > const & replicatedBoundary, Domi::Layout const layout) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, ParameterList plist) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, ParameterList plist) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDComm const > const mdComm, ParameterList plist) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDComm const > const mdComm, Teuchos::ArrayView< Domi::Slice > const & myGlobalBounds, Teuchos::ArrayView< Domi::padding_type > const & padding, Teuchos::ArrayView< int const > const & replicatedBoundary, Domi::Layout const layout) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, MDMap_default source) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, MDMap_default parent, int axis, Domi::dim_type index) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, MDMap_default parent, int axis, Slice slice, int bndryPad=0) -> MDMap_default
        __init__(Domi::MDMap<(Domi::DefaultNode::DefaultNodeType)> self, MDMap_default parent, Teuchos::ArrayView< Domi::Slice > const & slices, Teuchos::ArrayView< int > const & bndryPad) -> MDMap_default

        Domi::MDMap< Node
        >::MDMap(const MDMap< Node > &parent, const Teuchos::ArrayView< Slice
        > &slices, const Teuchos::ArrayView< int >
        &bndryPad=Teuchos::ArrayView< int >())

        Parent/array of slices sub-map constructor.

        Parameters:
        -----------

        parent:  [in] an MDMap, from which this sub-map will be derived.

        slices:  [in] an array of Slices of global axis indexes that defines
        the sub- map. These slices must not include indexes from the boundary
        padding along each axis.

        bndryPad:  [in] The boundary padding of the new sub-map. These may
        include indexes from the boundary padding of the parent MDMap, but
        they do not have to. 
        """
        this = _Domi.new_MDMap_default(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Domi.delete_MDMap_default

    def getMDComm(self, *args):
        """
        getMDComm(MDMap_default self) -> Teuchos::RCP< Domi::MDComm const >

        Teuchos::RCP< const
        MDComm > Domi::MDMap< Node >::getMDComm() const

        Access the underlying MDComm object.

        Return a reference counted pointer to the Domi::MDComm object upon
        which this MDMap is built. 
        """
        return _Domi.MDMap_default_getMDComm(self, *args)


    def onSubcommunicator(self, *args):
        """
        onSubcommunicator(MDMap_default self) -> bool

        bool
        Domi::MDMap< Node >::onSubcommunicator() const

        Query whether this processor is on the sub-communicator.

        Sub-communicators are formed when a parent MDComm is sliced by using
        the (parent,ordinal) or (parent,slices) constructor. For a full
        communicator, this method will always return true. 
        """
        return _Domi.MDMap_default_onSubcommunicator(self, *args)


    def getTeuchosComm(self, *args):
        """
        getTeuchosComm(MDMap_default self) -> Teuchos::RCP< Teuchos::Comm< int > const >

        Teuchos::RCP<
        const Teuchos::Comm< int > > Domi::MDMap< Node >::getTeuchosComm()
        const

        Get the Teuchos communicator.

        Note that if the communicator is not a full communicator, i.e. a sub-
        communicator, that the underlying Comm pointer may be NULL, depending
        on this processor's rank. 
        """
        return _Domi.MDMap_default_getTeuchosComm(self, *args)


    def numDims(self, *args):
        """
        numDims(MDMap_default self) -> int

        int Domi::MDMap< Node
        >::numDims() const

        Get the number of dimensions.

        This method will return 0 if the communicator is a sub-communicator
        and this processor does not belong to the sub-communicator. 
        """
        return _Domi.MDMap_default_numDims(self, *args)


    def getCommDims(self, *args):
        """
        getCommDims(MDMap_default self) -> Teuchos::Array< int >

        Teuchos::Array< int
        > Domi::MDMap< Node >::getCommDims() const

        Get the communicator sizes along each axis.

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDMap_default_getCommDims(self, *args)


    def getCommDim(self, *args):
        """
        getCommDim(MDMap_default self, int axis) -> int

        int Domi::MDMap< Node
        >::getCommDim(int axis) const

        Get the communicator size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDMap_default_getCommDim(self, *args)


    def isPeriodic(self, *args):
        """
        isPeriodic(MDMap_default self, int axis) -> bool

        bool Domi::MDMap<
        Node >::isPeriodic(int axis) const

        Return the periodic flag for the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDMap_default_isPeriodic(self, *args)


    def getCommIndex(self, *args):
        """
        getCommIndex(MDMap_default self, int axis) -> int

        int Domi::MDMap<
        Node >::getCommIndex(int axis) const

        Get the axis rank of this processor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDMap_default_getCommIndex(self, *args)


    def getLowerNeighbor(self, *args):
        """
        getLowerNeighbor(MDMap_default self, int axis) -> int

        int
        Domi::MDMap< Node >::getLowerNeighbor(int axis) const

        Get the rank of the lower neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is zero, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then the returned lower neighbor will be zero. 
        """
        return _Domi.MDMap_default_getLowerNeighbor(self, *args)


    def getUpperNeighbor(self, *args):
        """
        getUpperNeighbor(MDMap_default self, int axis) -> int

        int
        Domi::MDMap< Node >::getUpperNeighbor(int axis) const

        Get the rank of the upper neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is zero, then the returned lower neighbor will
        be the highest axis rank processor along this axis. 
        """
        return _Domi.MDMap_default_getUpperNeighbor(self, *args)


    def getGlobalDims(self, *args):
        """
        getGlobalDims(MDMap_default self) -> Teuchos::Array< Domi::dim_type >

        Teuchos::Array<
        dim_type > Domi::MDMap< Node >::getGlobalDims() const

        Get an array of the the global dimensions, including boundary padding.

        """
        return _Domi.MDMap_default_getGlobalDims(self, *args)


    def getGlobalDim(self, *args):
        """
        getGlobalDim(MDMap_default self, int axis, bool withBndryPad=False) -> Domi::dim_type

        dim_type
        Domi::MDMap< Node >::getGlobalDim(int axis, bool withBndryPad=false)
        const

        Get the global dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the dimension should include
        boundary padding or not 
        """
        return _Domi.MDMap_default_getGlobalDim(self, *args)


    def getGlobalBounds(self, *args):
        """
        getGlobalBounds(MDMap_default self, int axis, bool withBndryPad=False) -> Slice

        Slice
        Domi::MDMap< Node >::getGlobalBounds(int axis, bool
        withBndryPad=false) const

        Get the bounds of the global problem.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the bounds should include boundary
        padding or not 
        """
        return _Domi.MDMap_default_getGlobalBounds(self, *args)


    def getGlobalRankBounds(self, *args):
        """
        getGlobalRankBounds(MDMap_default self, int axis, bool withBndryPad=False) -> Slice

        Slice
        Domi::MDMap< Node >::getGlobalRankBounds(int axis, bool
        withBndryPad=false) const

        Get the global loop bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the dimension should include
        boundary padding or not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDMap_default_getGlobalRankBounds(self, *args)


    def getLocalDims(self, *args):
        """
        getLocalDims(MDMap_default self) -> Teuchos::Array< Domi::dim_type >

        Teuchos::Array<
        dim_type > Domi::MDMap< Node >::getLocalDims() const

        Get an array of the local dimensions, including padding. 
        """
        return _Domi.MDMap_default_getLocalDims(self, *args)


    def getLocalDim(self, *args):
        """
        getLocalDim(MDMap_default self, int axis, bool withPad=False) -> Domi::dim_type

        dim_type
        Domi::MDMap< Node >::getLocalDim(int axis, bool withPad=false) const

        Get the local dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withPad:  [in] specify whether the dimension should include padding or
        not 
        """
        return _Domi.MDMap_default_getLocalDim(self, *args)


    def getLocalBounds(self, *args):
        """
        getLocalBounds(MDMap_default self) -> Teuchos::ArrayView< Domi::Slice const >
        getLocalBounds(MDMap_default self, int axis, bool withPad=False) -> Slice

        Slice
        Domi::MDMap< Node >::getLocalBounds(int axis, bool withPad=false)
        const

        Get the local loop bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withPad:  [in] specify whether the dimension should include padding or
        not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDMap_default_getLocalBounds(self, *args)


    def getLocalInteriorBounds(self, *args):
        """
        getLocalInteriorBounds(MDMap_default self, int axis) -> Slice

        Slice
        Domi::MDMap< Node >::getLocalInteriorBounds(int axis) const

        Get the local interior loop bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Local interior loop bounds are the same as local loop bounds without
        padding, except that for non-periodic axes the global end points of
        the given axis are excluded. For periodic axes, the local interior
        loop bounds are exactly the same as local loop bounds without padding.

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDMap_default_getLocalInteriorBounds(self, *args)


    def hasPadding(self, *args):
        """
        hasPadding(MDMap_default self) -> bool

        bool Domi::MDMap<
        Node >::hasPadding() const

        Return true if there is any padding stored locally.

        Note that it is not as simple as whether there were communication
        padding specified in the constructor. Suppose non-zero communication
        padding was specified, but the problem is on one processor and no
        boundary padding was specified: this method will return false.
        Similarly, if no communication padding was specified but boundary
        padding was, then boundary processors will have padding and this
        method will return true. 
        """
        return _Domi.MDMap_default_hasPadding(self, *args)


    def getLowerPadSize(self, *args):
        """
        getLowerPadSize(MDMap_default self, int axis) -> int

        int Domi::MDMap<
        Node >::getLowerPadSize(int axis) const

        Get the size of the lower padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDMap_default_getLowerPadSize(self, *args)


    def getUpperPadSize(self, *args):
        """
        getUpperPadSize(MDMap_default self, int axis) -> int

        int Domi::MDMap<
        Node >::getUpperPadSize(int axis) const

        Get the size of the upper padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDMap_default_getUpperPadSize(self, *args)


    def getCommPadSize(self, *args):
        """
        getCommPadSize(MDMap_default self, int axis) -> int

        int Domi::MDMap<
        Node >::getCommPadSize(int axis) const

        Get the communication padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the communication padding along the given
        axis at the time of construction, regardless of the processor's
        position relative to the domain boundary. 
        """
        return _Domi.MDMap_default_getCommPadSize(self, *args)


    def getLowerBndryPad(self, *args):
        """
        getLowerBndryPad(MDMap_default self, int axis) -> int

        int
        Domi::MDMap< Node >::getLowerBndryPad(int axis) const

        Get the size of the lower boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDMap_default_getLowerBndryPad(self, *args)


    def getUpperBndryPad(self, *args):
        """
        getUpperBndryPad(MDMap_default self, int axis) -> int

        int
        Domi::MDMap< Node >::getUpperBndryPad(int axis) const

        Get the size of the upper boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDMap_default_getUpperBndryPad(self, *args)


    def getBndryPadSizes(self, *args):
        """
        getBndryPadSizes(MDMap_default self) -> Teuchos::Array< int >

        Teuchos::Array<
        int > Domi::MDMap< Node >::getBndryPadSizes() const

        Get the boundary padding sizes along each axis.

        This returns an array of the boundary padding along each axis at the
        time of construction, regardless of whether a subsequent sub-map
        reduced these values. 
        """
        return _Domi.MDMap_default_getBndryPadSizes(self, *args)


    def getBndryPadSize(self, *args):
        """
        getBndryPadSize(MDMap_default self, int axis) -> int

        int Domi::MDMap<
        Node >::getBndryPadSize(int axis) const

        Get the boundary padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the boundary padding along the given axis at
        the time of construction, regardless of whether a sub-map reduced
        these values. 
        """
        return _Domi.MDMap_default_getBndryPadSize(self, *args)


    def isPad(self, *args):
        """
        isPad(MDMap_default self, Teuchos::ArrayView< Domi::dim_type > const & index) -> bool

        bool Domi::MDMap< Node
        >::isPad(const Teuchos::ArrayView< dim_type > &index) const 
        """
        return _Domi.MDMap_default_isPad(self, *args)


    def isCommPad(self, *args):
        """
        isCommPad(MDMap_default self, Teuchos::ArrayView< Domi::dim_type > const & index) -> bool

        bool Domi::MDMap< Node
        >::isCommPad(const Teuchos::ArrayView< dim_type > &index) const 
        """
        return _Domi.MDMap_default_isCommPad(self, *args)


    def isBndryPad(self, *args):
        """
        isBndryPad(MDMap_default self, Teuchos::ArrayView< Domi::dim_type > const & index) -> bool

        bool Domi::MDMap<
        Node >::isBndryPad(const Teuchos::ArrayView< dim_type > &index) const

        """
        return _Domi.MDMap_default_isBndryPad(self, *args)


    def isReplicatedBoundary(self, *args):
        """
        isReplicatedBoundary(MDMap_default self, int axis) -> bool

        bool
        Domi::MDMap< Node >::isReplicatedBoundary(int axis) const

        Return whether the given axis supports a replicated boundary. 
        """
        return _Domi.MDMap_default_isReplicatedBoundary(self, *args)


    def getLayout(self, *args):
        """
        getLayout(MDMap_default self) -> Domi::Layout

        Layout Domi::MDMap<
        Node >::getLayout() const

        Get the storage order. 
        """
        return _Domi.MDMap_default_getLayout(self, *args)


    def getNode(self, *args):
        """
        getNode(MDMap_default self) -> Teuchos::RCP< Domi::DefaultNode::DefaultNodeType >

        Teuchos::RCP< Node >
        Domi::MDMap< Node >::getNode() const

        Get the Kokkos node. 
        """
        return _Domi.MDMap_default_getNode(self, *args)


    def getAxisMaps(self, *args):
        """
        getAxisMaps(MDMap_default self) -> Teuchos::ArrayView< Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > >

        Teuchos::ArrayView<
        Teuchos::RCP< const MDMap< Node > > > Domi::MDMap< Node
        >::getAxisMaps() const

        Return an array of axis maps.

        An axis map is a 1D map along a given axis. 
        """
        return _Domi.MDMap_default_getAxisMaps(self, *args)


    def getAxisMap(self, *args):
        """
        getAxisMap(MDMap_default self, int axis) -> Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP< const
        MDMap< Node > > Domi::MDMap< Node >::getAxisMap(int axis) const

        Return an axis map for the given axis.

        An axis map is a 1D map along a given axis. 
        """
        return _Domi.MDMap_default_getAxisMap(self, *args)


    def getAugmentedMDMap(self, *args):
        """
        getAugmentedMDMap(MDMap_default self, Domi::dim_type const leadingDim, Domi::dim_type const trailingDim=0) -> Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const >

        Teuchos::RCP<
        const MDMap< Node > > Domi::MDMap< Node >::getAugmentedMDMap(const
        dim_type leadingDim, const dim_type trailingDim=0) const

        Return an RCP to a new MDMap that is a simple augmentation of this
        MDMap.

        Parameters:
        -----------

        leadingDim:  [in] If this value is greater than 0, then add a
        dimension to the new MDMap that comes before the existing dimensions
        and has this many degrees of freedom.

        trailingDim:  [in] If this value is greater than 0, then add a
        dimension to the new MDMap that comes after the existing dimensions
        and has this many degrees of freedom.

        Note that the new dimension(s) will not be distributed; i.e. the
        commDim for the new leading dimension (if requested) will be 1 and the
        commDim for the trailing dimension (if requested) will be 1. 
        """
        return _Domi.MDMap_default_getAugmentedMDMap(self, *args)


    def getEpetraMap(self, *args):
        """getEpetraMap(MDMap_default self, bool withCommPad=True) -> Teuchos::RCP< Epetra_Map const >"""
        return _Domi.MDMap_default_getEpetraMap(self, *args)


    def getEpetraAxisMap(self, *args):
        """getEpetraAxisMap(MDMap_default self, int axis, bool withCommPad=True) -> Teuchos::RCP< Epetra_Map const >"""
        return _Domi.MDMap_default_getEpetraAxisMap(self, *args)


    def getGlobalIndex(self, *args):
        """
        getGlobalIndex(MDMap_default self, Domi::size_type globalID) -> Teuchos::Array< Domi::dim_type >

        Teuchos::Array<
        dim_type > Domi::MDMap< Node >::getGlobalIndex(size_type globalID)
        const

        Convert a global ID to a global index.

        Parameters:
        -----------

        globalID:  [in] a unique 1D global identifier 
        """
        return _Domi.MDMap_default_getGlobalIndex(self, *args)


    def getLocalIndex(self, *args):
        """
        getLocalIndex(MDMap_default self, Domi::size_type localID) -> Teuchos::Array< Domi::dim_type >

        Teuchos::Array<
        dim_type > Domi::MDMap< Node >::getLocalIndex(size_type localID) const

        Convert a local ID to a local index.

        Parameters:
        -----------

        localID:  [in] a unique 1D local identifier 
        """
        return _Domi.MDMap_default_getLocalIndex(self, *args)


    def getGlobalID(self, *args):
        """
        getGlobalID(MDMap_default self, Domi::size_type localID) -> Domi::size_type
        getGlobalID(MDMap_default self, Teuchos::ArrayView< Domi::dim_type > const & globalIndex) -> Domi::size_type

        size_type
        Domi::MDMap< Node >::getGlobalID(const Teuchos::ArrayView< dim_type >
        &globalIndex) const

        convert a global index to a global ID

        Parameters:
        -----------

        globalIndex:  [in] a global index 
        """
        return _Domi.MDMap_default_getGlobalID(self, *args)


    def getLocalID(self, *args):
        """
        getLocalID(MDMap_default self, Domi::size_type globalID) -> Domi::size_type
        getLocalID(MDMap_default self, Teuchos::ArrayView< Domi::dim_type > const & localIndex) -> Domi::size_type

        size_type
        Domi::MDMap< Node >::getLocalID(const Teuchos::ArrayView< dim_type >
        &localIndex) const

        Convert a local index to a local ID.

        Parameters:
        -----------

        localIndex:  [in] a local index 
        """
        return _Domi.MDMap_default_getLocalID(self, *args)


    def isCompatible(self, *args):
        """
        isCompatible(MDMap_default self, MDMap_default mdMap) -> bool

        bool Domi::MDMap<
        Node >::isCompatible(const MDMap< Node > &mdMap) const

        True if two MDMaps are "compatible".

        Parameters:
        -----------

        mdMap:  [in] MDMap to compare against

        Two MDMaps are considered "compatible" if all of the following are
        true: The commDims of their underlying MDComms are identical.

        Their global dimensions are identical.

        Their local dimensions, not including padding, are identical. 
        """
        return _Domi.MDMap_default_isCompatible(self, *args)


    def isSameAs(self, *args):
        """
        isSameAs(MDMap_default self, MDMap_default mdMap, int const verbose=0) -> bool

        bool Domi::MDMap< Node
        >::isSameAs(const MDMap< Node > &mdMap, const int verbose=0) const

        True if two MDMaps are "identical".

        Parameters:
        -----------

        mdMap:  [in] MDMap to compare against

        verbose:  [in] set to one to print why MDMaps are not the same

        Two MDMaps are considered "identical" if all of the following are
        true: They are compatible.

        Their underlying communicators are congruent (have the same number of
        processes, in the same order: this corresponds to the MPI_IDENT or
        MPI_CONGRUENT return values of MPI_Comm_compare).

        Both are distributed or not distributed.

        Their global bounds identical on each process.

        Their local dimensions, including padding, are identical. 
        """
        return _Domi.MDMap_default_isSameAs(self, *args)


    def isContiguous(self, *args):
        """
        isContiguous(MDMap_default self) -> bool

        bool Domi::MDMap<
        Node >::isContiguous() const

        True if there are no stride gaps on any processor.

        An MDMap constructed from a communicator and dimensions will always be
        contiguous. An MDMap that is a slice of a parent MDMap will generally
        be non-contiguous, with some exceptions. There are cases where some
        local data is contiguous and some is not, but this method returns True
        only if all processes' local data is contiguous. 
        """
        return _Domi.MDMap_default_isContiguous(self, *args)


    def getTpetraMap(self, *args):
        """getTpetraMap(MDMap_default self, bool withCommPad=True) -> Teuchos::RCP< Tpetra::Map< int,long long,DefaultNodeType > const >"""
        return _Domi.MDMap_default_getTpetraMap(self, *args)


    def getTpetraAxisMap(self, *args):
        """getTpetraAxisMap(MDMap_default self, int axis, bool withCommPad=True) -> Teuchos::RCP< Tpetra::Map< int,long long,DefaultNodeType > const >"""
        return _Domi.MDMap_default_getTpetraAxisMap(self, *args)

MDMap_default_swigregister = _Domi.MDMap_default_swigregister
MDMap_default_swigregister(MDMap_default)


MDMap = MDMap_default


def MDVector_getattr(self, name):
    if name == "array":
        a = self.getData()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    else:
        raise AttributeError("'%s' not an attribute of MDVector" % name)
def MDVector_setattr(self, name, value):
    if name in ("array", "shape", "dtype"):
        raise AttributeError("Cannot change MDVector '%s' attribute", name)
    else:
        self.__dict__[name] = value
def upgradeMDVectorClass(cls):
    cls.__getattr__ = MDVector_getattr
    cls.__setattr__ = MDVector_setattr
    cls.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
    cls.__len__     = lambda self: self.array.__len__()
    cls.__str__     = lambda self: self.array.__str__()
    cls.copy        = lambda self: cls(self)
    class_array_add_math(cls)
    class_array_add_comp(cls)


class MDVector_int(Teuchos.Describable):
    """


    Multi-dimensional distributed vector.

    The  MDVector class is intended to perform the functions of Epetra or
    Tpetra MultiVectors (or Vectors), with the additional capability that
    the data can be multi-dimensional. (Note that Epetra and Tpetra
    MultiVectors are 2 dimensional and distributed in an unstructured
    manner along only one of those dimensions.  MDVectors can be any
    number of dimensions, and can be distributed in a structured fashion
    along all of them.)

    Where Epetra and Tpetra MultiVectors are built on top of Epetra_Maps
    and Tpetra::Maps, respectively, the  MDVector is built on top of an
    MDMap. As such, they support boundary padding, communication padding,
    and periodicity.

    The basic  MDVector constructor takes an MDMap and an optional boolean
    flag providing instruction whether to zero out the data or not. A
    slightly more advanced constructor takes an MDMap, a leading
    dimension, an optional trailing dimension, and an optional zero-out
    flag. This allows the user to augment the given  MDMap with an
    undistributed dimension. This can be helpful when the user wants to
    store an array of quantities at each grid point. These quantities can
    be clustered or strided in memory depending on whether a leading or
    trailing dimension is specified, and what the data Layout is.

    There are additional constructors as well, based on copying data,
    using Teuchos::ParameterLists to specify the  MDVector layout, and
    parent/slice constructors, where slicing of the parent can be
    performed with an ordinal or a Slice.

    The ability to slice a parent  MDVector and obtain a sub-vector is an
    important feature of the  MDVector class. When you take a slice of a
    parent  MDVector, the resulting sub-vector may have a new, reduced
    communicator (both a new  MDComm and Teuchos::Comm). When accessing a
    sub-vector, you should always use the onSubcommunicator() method to
    determine that the sub-vector exists on the current processor.

    Like the Teuchos::MultiVector, the user cannot index directly into an
    MDVector. Rather, he or she must use the  getData() and
    getDataNonConst() methods to obtain an  MDArrayView of the data for
    manipulation. This is a little different than the Tpetra behavior,
    where an ArrayRCP is returned to the user. For  MDVector, and
    MDArrayView is returned, as this supports the slicing semantics of the
    class. Note that each  MDVector stores an internal  MDArrayRCP of
    either its original data or its parent's data, and then it also stores
    an  MDArrayView that is a view into the  MDArrayRCP. So the
    MDArrayView passed to the user will be valid as long as the reference
    count of its  MDArrayRCP is greater than zero. Looping bounds for this
    data can be obtained using the  getLocalBounds() method, which returns
    a concrete  Slice object, and takes a boolean that specifies whether
    padding should be included in the start and stop indexes.

    There are a variety of methods for converting  MDVectors to Epetra or
    Tpetra MultiVectors or Vectors, using either view or copy semantics.
    The view semantic is only available when the  MDVector is contiguous
    in memory, meaning there are no stride gaps due to slicing. The copy
    semantic is always available. True Epetra or Tpetra MultiVectors, in
    which the number of vectors is greater than 1, are only available when
    there is a non-distributed leading dimension and the layout is
    C-order, or there is a non-distributed trailing dimension and the
    layout is Fortran-order.

    If the  MDVector was built with communication padding, then the user
    may use the  updateCommPad() method to communicate via message passing
    data from the owning processors into the communication padding
    buffers. If communication along a single axis is desired, then the
    overloaded updateCommPad(int axis) method can be called instead. If
    asynchronous communication is desired, where computations can be
    performed between posting and receiving messages, then the
    startUpdateCommPad(int axis) and endUpdateCommPad(int axis) methods
    can be called. Note that the message data structures needed to
    coordinate these methods are stored internally.

    C++ includes: Domi_MDVector.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MDVector_int, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MDVector_int, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, bool zeroOut=True) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::dim_type const leadingDim, Domi::dim_type const trailingDim=0, bool zeroOut=True) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::MDArrayView< int > const & source) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::MDArrayRCP< int > const & source) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, MDVector_int source, Teuchos::DataAccess access) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, ParameterList plist) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDComm const > const mdComm, ParameterList plist) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, MDVector_int parent, int axis, Domi::dim_type index) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, MDVector_int parent, int axis, Slice slice, int bndryPad=0) -> MDVector_int
        __init__(Domi::MDVector<(int,Domi::DefaultNode::DefaultNodeType)> self, MDVector_int parent, Teuchos::ArrayView< Domi::Slice > const & slices, Teuchos::ArrayView< int > const & bndryPad) -> MDVector_int

        Domi::MDVector<
        Scalar, Node >::MDVector(const MDVector< Scalar, Node > &parent, const
        Teuchos::ArrayView< Slice > &slices, const Teuchos::ArrayView< int >
        &bndryPad=Teuchos::ArrayView< int >())

        Parent/array of slices sub-vector constructor.

        Parameters:
        -----------

        parent:  [in] an MDVector, from which this sub-vector will be derived.

        slices:  [in] an array of Slices of global axis indexes that defines
        the sub- vector. These slices must not include indexes from the
        boundary padding along each axis.

        bndryPad:  [in] The boundary padding of the new sub-vector. These may
        include indexes from the boundary padding of the parent MDVector, but
        they do not have to. 
        """
        this = _Domi.new_MDVector_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Domi.delete_MDVector_int

    def getMDMap(self, *args):
        """
        getMDMap(MDVector_int self) -> Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const

        const Teuchos::RCP<
        const MDMap< Node > > Domi::MDVector< Scalar, Node >::getMDMap() const

        MDMap accessor method. 
        """
        return _Domi.MDVector_int_getMDMap(self, *args)


    def onSubcommunicator(self, *args):
        """
        onSubcommunicator(MDVector_int self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::onSubcommunicator() const

        Query whether this processor is on the sub-communicator.

        Sub-communicators are formed when a parent MDVector is sliced by using
        the (parent,ordinal) or (parent,slice) constructors. For a full
        communicator, this method will always return true. 
        """
        return _Domi.MDVector_int_onSubcommunicator(self, *args)


    def getTeuchosComm(self, *args):
        """
        getTeuchosComm(MDVector_int self) -> Teuchos::RCP< Teuchos::Comm< int > const >

        Teuchos::RCP<
        const Teuchos::Comm< int > > Domi::MDVector< Scalar, Node
        >::getTeuchosComm() const

        Get the Teuchos communicator.

        Note that if the communicator is not a full communicator, i.e. a sub-
        communicator, that the underlying Comm pointer may be NULL, depending
        on this processor's rank. 
        """
        return _Domi.MDVector_int_getTeuchosComm(self, *args)


    def numDims(self, *args):
        """
        numDims(MDVector_int self) -> int

        int Domi::MDVector<
        Scalar, Node >::numDims() const

        Get the number of dimensions.

        This method will return 0 if the communicator is a sub-communicator
        and this processor does not belong to the sub-communicator. 
        """
        return _Domi.MDVector_int_numDims(self, *args)


    def getCommDim(self, *args):
        """
        getCommDim(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommDim(int axis) const

        Get the communicator size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_int_getCommDim(self, *args)


    def isPeriodic(self, *args):
        """
        isPeriodic(MDVector_int self, int axis) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isPeriodic(int axis) const

        Return the periodic flag for the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_int_isPeriodic(self, *args)


    def getCommIndex(self, *args):
        """
        getCommIndex(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommIndex(int axis) const

        Get the axis rank of this processor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_int_getCommIndex(self, *args)


    def getLowerNeighbor(self, *args):
        """
        getLowerNeighbor(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerNeighbor(int axis) const

        Get the rank of the lower neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is zero, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then the returned lower neighbor will be zero. 
        """
        return _Domi.MDVector_int_getLowerNeighbor(self, *args)


    def getUpperNeighbor(self, *args):
        """
        getUpperNeighbor(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperNeighbor(int axis) const

        Get the rank of the upper neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is zero, then the returned lower neighbor will
        be the highest axis rank processor along this axis. 
        """
        return _Domi.MDVector_int_getUpperNeighbor(self, *args)


    def getGlobalDim(self, *args):
        """
        getGlobalDim(MDVector_int self, int axis, bool withBndryPad=False) -> Domi::dim_type

        dim_type
        Domi::MDVector< Scalar, Node >::getGlobalDim(int axis, bool
        withBndryPad=false) const

        Get the global dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the dimension should include
        boundary padding or not 
        """
        return _Domi.MDVector_int_getGlobalDim(self, *args)


    def getGlobalBounds(self, *args):
        """
        getGlobalBounds(MDVector_int self, int axis, bool withBndryPadding=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getGlobalBounds(int axis, bool
        withBndryPadding=false) const

        Get the bounds of the global problem.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the bounds should include boundary
        padding or not 
        """
        return _Domi.MDVector_int_getGlobalBounds(self, *args)


    def getGlobalRankBounds(self, *args):
        """
        getGlobalRankBounds(MDVector_int self, int axis, bool withBndryPad=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getGlobalRankBounds(int axis, bool
        withBndryPad=false) const

        Get the global loop bounds on this processor along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPadding:  [in] specify whether the dimension should include
        boundary padding or not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_int_getGlobalRankBounds(self, *args)


    def getLocalDim(self, *args):
        """
        getLocalDim(MDVector_int self, int axis, bool withCommPad=False) -> Domi::dim_type

        dim_type
        Domi::MDVector< Scalar, Node >::getLocalDim(int axis, bool
        withCommPad=false) const

        Get the local dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withCommPad:  [in] specify whether the dimension should include
        communication padding or not 
        """
        return _Domi.MDVector_int_getLocalDim(self, *args)


    def getLocalBounds(self, *args):
        """
        getLocalBounds(MDVector_int self) -> Teuchos::ArrayView< Domi::Slice const >
        getLocalBounds(MDVector_int self, int axis, bool withPad=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getLocalBounds(int axis, bool
        withPad=false) const

        Get the local looping bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withPad:  [in] specify whether the dimension should include padding or
        not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_int_getLocalBounds(self, *args)


    def getLocalInteriorBounds(self, *args):
        """
        getLocalInteriorBounds(MDVector_int self, int axis) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getLocalInteriorBounds(int axis) const

        Get the local interior looping bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Local interior loop bounds are the same as local loop bounds without
        padding, except that for non-periodic axes the global end points of
        the given axis are excluded. For periodic axes, the local interior
        loop bounds are exactly the same as local loop bounds without padding.

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_int_getLocalInteriorBounds(self, *args)


    def hasPadding(self, *args):
        """
        hasPadding(MDVector_int self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::hasPadding() const

        Return true if there is any padding stored locally.

        Note that it is not as simple as whether there were communication
        padding specified in the constructor. Suppose non-zero communication
        padding was specified, but the problem is on one processor and no
        boundary padding was specified: this method will return false.
        Similarly, if no communication padding was specified but boundary
        padding was, then boundary processors will have padding and this
        method will return true. 
        """
        return _Domi.MDVector_int_hasPadding(self, *args)


    def getLowerPadSize(self, *args):
        """
        getLowerPadSize(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerPadSize(int axis) const

        Get the size of the lower padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDVector_int_getLowerPadSize(self, *args)


    def getUpperPadSize(self, *args):
        """
        getUpperPadSize(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperPadSize(int axis) const

        Get the size of the upper padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDVector_int_getUpperPadSize(self, *args)


    def getCommPadSize(self, *args):
        """
        getCommPadSize(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommPadSize(int axis) const

        Get the communication padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the communication padding along the given
        axis at the time of construction, regardless of the processor's
        position relative to the domain boundary. 
        """
        return _Domi.MDVector_int_getCommPadSize(self, *args)


    def getLowerBndryPad(self, *args):
        """
        getLowerBndryPad(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerBndryPad(int axis) const

        Get the size of the lower boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDVector_int_getLowerBndryPad(self, *args)


    def getUpperBndryPad(self, *args):
        """
        getUpperBndryPad(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperBndryPad(int axis) const

        Get the size of the upper boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDVector_int_getUpperBndryPad(self, *args)


    def getBndryPadSize(self, *args):
        """
        getBndryPadSize(MDVector_int self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getBndryPadSize(int axis) const

        Get the boundary padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the boundary padding along the given axis at
        the time of construction, regardless of whether a sub-map reduced
        these values. 
        """
        return _Domi.MDVector_int_getBndryPadSize(self, *args)


    def setLowerPad(self, *args):
        """
        setLowerPad(MDVector_int self, int axis, int const value)

        void
        Domi::MDVector< Scalar, Node >::setLowerPad(int axis, const Scalar
        value)

        Assign all elements of the lower pad a constant value.

        Parameters:
        -----------

        axis:  [in] the axis along which the lower padding is chosen

        value:  [in] the value to be assigned to all elements of the lower
        padding 
        """
        return _Domi.MDVector_int_setLowerPad(self, *args)


    def setUpperPad(self, *args):
        """
        setUpperPad(MDVector_int self, int axis, int const value)

        void
        Domi::MDVector< Scalar, Node >::setUpperPad(int axis, const Scalar
        value)

        Assign all elements of the upper pad a constant value.

        Parameters:
        -----------

        axis:  [in] the axis along which the upper padding is chosen

        value:  [in] the value to be assigned to all elements of the upper
        padding 
        """
        return _Domi.MDVector_int_setUpperPad(self, *args)


    def isReplicatedBoundary(self, *args):
        """
        isReplicatedBoundary(MDVector_int self, int axis) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isReplicatedBoundary(int axis) const

        Return whether the given axis supports a replicated boundary. 
        """
        return _Domi.MDVector_int_isReplicatedBoundary(self, *args)


    def getLayout(self, *args):
        """
        getLayout(MDVector_int self) -> Domi::Layout

        Layout
        Domi::MDVector< Scalar, Node >::getLayout() const

        Get the storage order. 
        """
        return _Domi.MDVector_int_getLayout(self, *args)


    def isContiguous(self, *args):
        """
        isContiguous(MDVector_int self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isContiguous() const

        True if there are no stride gaps on any processor.

        An MDVector constructed from a communicator and dimensions will always
        be contiguous. An MDVector that is a slice of a parent MDMVector will
        generally be non- contiguous, with some exceptions. There are cases
        where some local data is contiguous and some is not, but this method
        returns True only if all processes' local data is contiguous. 
        """
        return _Domi.MDVector_int_isContiguous(self, *args)


    def getEpetraIntVectorView(self, *args):
        """getEpetraIntVectorView(MDVector_int self) -> Teuchos::RCP< Epetra_IntVector >"""
        return _Domi.MDVector_int_getEpetraIntVectorView(self, *args)


    def getEpetraVectorView(self, *args):
        """getEpetraVectorView(MDVector_int self) -> Teuchos::RCP< Epetra_Vector >"""
        return _Domi.MDVector_int_getEpetraVectorView(self, *args)


    def getEpetraMultiVectorView(self, *args):
        """getEpetraMultiVectorView(MDVector_int self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Domi.MDVector_int_getEpetraMultiVectorView(self, *args)


    def getEpetraIntVectorCopy(self, *args):
        """getEpetraIntVectorCopy(MDVector_int self) -> Teuchos::RCP< Epetra_IntVector >"""
        return _Domi.MDVector_int_getEpetraIntVectorCopy(self, *args)


    def getEpetraVectorCopy(self, *args):
        """getEpetraVectorCopy(MDVector_int self) -> Teuchos::RCP< Epetra_Vector >"""
        return _Domi.MDVector_int_getEpetraVectorCopy(self, *args)


    def getEpetraMultiVectorCopy(self, *args):
        """getEpetraMultiVectorCopy(MDVector_int self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Domi.MDVector_int_getEpetraMultiVectorCopy(self, *args)


    def getLowerPadDataNonConst(self, *args):
        """
        getLowerPadDataNonConst(MDVector_int self, int axis) -> Domi::MDArrayView< int >

        MDArrayView< Scalar > Domi::MDVector< Scalar, Node
        >::getLowerPadDataNonConst(int axis)

        Get a non-const view of the lower padding data along the given axis as
        an MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the lower padding 
        """
        return _Domi.MDVector_int_getLowerPadDataNonConst(self, *args)


    def getLowerPadData(self, *args):
        """
        getLowerPadData(MDVector_int self, int axis) -> Domi::MDArrayView< int const >

        MDArrayView<
        const Scalar > Domi::MDVector< Scalar, Node >::getLowerPadData(int
        axis) const

        Get a const view of the lower padding data along the given axis as an
        MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the lower padding 
        """
        return _Domi.MDVector_int_getLowerPadData(self, *args)


    def getUpperPadDataNonConst(self, *args):
        """
        getUpperPadDataNonConst(MDVector_int self, int axis) -> Domi::MDArrayView< int >

        MDArrayView< Scalar > Domi::MDVector< Scalar, Node
        >::getUpperPadDataNonConst(int axis)

        Get a non-const view of the upper padding data along the given axis as
        an MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the upper padding 
        """
        return _Domi.MDVector_int_getUpperPadDataNonConst(self, *args)


    def getUpperPadData(self, *args):
        """
        getUpperPadData(MDVector_int self, int axis) -> Domi::MDArrayView< int const >

        MDArrayView<
        const Scalar > Domi::MDVector< Scalar, Node >::getUpperPadData(int
        axis) const

        Get a const view of the upper padding data along the given axis as an
        MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the upper padding 
        """
        return _Domi.MDVector_int_getUpperPadData(self, *args)


    def dot(self, *args):
        """
        dot(MDVector_int self, MDVector_int a) -> int

        Scalar Domi::MDVector<
        Scalar, Node >::dot(const MDVector< Scalar, Node > &a) const

        Compute the dot product of this MDVector and MDVector a.

        Parameters:
        -----------

        a:  [in] partner MDVector for performing dot product 
        """
        return _Domi.MDVector_int_dot(self, *args)


    def norm1(self, *args):
        """
        norm1(MDVector_int self) -> Teuchos::ScalarTraits< int >::magnitudeType

        Teuchos::ScalarTraits<
        Scalar >::magnitudeType Domi::MDVector< Scalar, Node >::norm1() const

        Compute the 1-norm of this MDVector. 
        """
        return _Domi.MDVector_int_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MDVector_int self) -> Teuchos::ScalarTraits< int >::magnitudeType

        Teuchos::ScalarTraits<
        Scalar >::magnitudeType Domi::MDVector< Scalar, Node >::norm2() const

        Compute the 2-norm of this MDVector. 
        """
        return _Domi.MDVector_int_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MDVector_int self) -> Teuchos::ScalarTraits< int >::magnitudeType

        Teuchos::ScalarTraits< Scalar >::magnitudeType Domi::MDVector< Scalar,
        Node >::normInf() const

        Compute the infinity-norm of this MDVector. 
        """
        return _Domi.MDVector_int_normInf(self, *args)


    def normWeighted(self, *args):
        """
        normWeighted(MDVector_int self, MDVector_int weights) -> Teuchos::ScalarTraits< int >::magnitudeType

        Teuchos::ScalarTraits< Scalar >::magnitudeType Domi::MDVector< Scalar,
        Node >::normWeighted(const MDVector< Scalar, Node > &weights) const

        Compute the weighted norm of this.

        Parameters:
        -----------

        weights:  [in] MDVector of weights for weighted norm 
        """
        return _Domi.MDVector_int_normWeighted(self, *args)


    def meanValue(self, *args):
        """
        meanValue(MDVector_int self) -> int

        Scalar
        Domi::MDVector< Scalar, Node >::meanValue() const

        Compute the mean (average) value of this MDVector. 
        """
        return _Domi.MDVector_int_meanValue(self, *args)


    def description(self, *args):
        """
        description(MDVector_int self) -> std::string

        std::string
        Domi::MDVector< Scalar, Node >::description() const

        A simple one-line description of this MDVector. 
        """
        return _Domi.MDVector_int_description(self, *args)


    def describe(self, *args):
        """
        describe(MDVector_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Domi::MDVector<
        Scalar, Node >::describe(Teuchos::FancyOStream &out, const
        Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print the object with some verbosity level to a FancyOStream.

        Parameters:
        -----------

        out:  [in] output stream

        verbLevel:  [in] verbosity level 
        """
        return _Domi.MDVector_int_describe(self, *args)


    def putScalar(self, *args):
        """
        putScalar(MDVector_int self, int const & value, bool includePadding=True)

        void
        Domi::MDVector< Scalar, Node >::putScalar(const Scalar &value, bool
        includePadding=true)

        Set all values in the multivector with the given value.

        Parameters:
        -----------

        value:  [in] assignment value

        includePadding:  [in] if true, assign values to the boundary and
        communication padding as well 
        """
        return _Domi.MDVector_int_putScalar(self, *args)


    def randomize(self, *args):
        """
        randomize(MDVector_int self)

        void
        Domi::MDVector< Scalar, Node >::randomize()

        Set all values in the multivector to pseudorandom numbers. 
        """
        return _Domi.MDVector_int_randomize(self, *args)


    def updateCommPad(self, *args):
        """
        updateCommPad(MDVector_int self)
        updateCommPad(MDVector_int self, int axis)

        void
        Domi::MDVector< Scalar, Node >::updateCommPad(int axis) 
        """
        return _Domi.MDVector_int_updateCommPad(self, *args)


    def startUpdateCommPad(self, *args):
        """
        startUpdateCommPad(MDVector_int self, int axis)

        void
        Domi::MDVector< Scalar, Node >::startUpdateCommPad(int axis)

        Start an asyncronous update of the communication padding.

        Parameters:
        -----------

        axis:  [in] the axis along which communication will be performed

        Post the non-blocking sends and receives for the communication padding
        along the given axis 
        """
        return _Domi.MDVector_int_startUpdateCommPad(self, *args)


    def endUpdateCommPad(self, *args):
        """
        endUpdateCommPad(MDVector_int self, int axis)

        void
        Domi::MDVector< Scalar, Node >::endUpdateCommPad(int axis)

        Complete an asyncronous update of the communication padding.

        Parameters:
        -----------

        axis:  [in] the axis along which communication will be performed

        Wait for all of the non-blocking updates for the communication padding
        along the given axis to complete 
        """
        return _Domi.MDVector_int_endUpdateCommPad(self, *args)


    def writeBinary(self, *args):
        """
        writeBinary(MDVector_int self, std::string const & filename, bool includeBndryPad=False)

        void
        Domi::MDVector< Scalar, Node >::writeBinary(const std::string
        &filename, bool includeBndryPad=false) const

        Write the MDVector to a binary file.

        Parameters:
        -----------

        filename:  [in] name of the output file

        includeBndryPad:  [in] if true, include the boundary pad with the
        output data 
        """
        return _Domi.MDVector_int_writeBinary(self, *args)


    def readBinary(self, *args):
        """
        readBinary(MDVector_int self, std::string const & filename, bool includeBndryPad=False)

        void
        Domi::MDVector< Scalar, Node >::readBinary(const std::string
        &filename, bool includeBndryPad=false)

        Read the MDVector from a binary file.

        Parameters:
        -----------

        filename:  [in] name of the input file

        includeBndryPad:  [in] if true, include the boundary pad with the
        input data 
        """
        return _Domi.MDVector_int_readBinary(self, *args)


    def __getitem__(self, *args):
        """__getitem__(MDVector_int self, PyObject * indexes) -> MDVector_int"""
        return _Domi.MDVector_int___getitem__(self, *args)


    def getData(self, *args):
        """
        getData(MDVector_int self, bool includePadding=True) -> Domi::MDArrayView< int >

        MDArrayView< const
        Scalar > Domi::MDVector< Scalar, Node >::getData(bool
        includePadding=true) const

        Get a const view of the data as an MDArrayView.

        Parameters:
        -----------

        includePadding:  [in] if true, include the boundary and communication
        padding in the returned MDArrayView 
        """
        return _Domi.MDVector_int_getData(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MDVector_int self) -> PyObject *"""
        return _Domi.MDVector_int___distarray__(self, *args)


    def getTpetraVectorView(self, *args):
        """getTpetraVectorView(MDVector_int self) -> Teuchos::RCP< Tpetra::Vector< int,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_int_getTpetraVectorView(self, *args)


    def getTpetraVectorCopy(self, *args):
        """getTpetraVectorCopy(MDVector_int self) -> Teuchos::RCP< Tpetra::Vector< int,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_int_getTpetraVectorCopy(self, *args)


    def getTpetraMultiVectorView(self, *args):
        """getTpetraMultiVectorView(MDVector_int self) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_int_getTpetraMultiVectorView(self, *args)


    def getTpetraMultiVectorCopy(self, *args):
        """getTpetraMultiVectorCopy(MDVector_int self) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_int_getTpetraMultiVectorCopy(self, *args)

MDVector_int_swigregister = _Domi.MDVector_int_swigregister
MDVector_int_swigregister(MDVector_int)


upgradeMDVectorClass(MDVector_int)

class MDVector_long(Teuchos.Describable):
    """


    Multi-dimensional distributed vector.

    The  MDVector class is intended to perform the functions of Epetra or
    Tpetra MultiVectors (or Vectors), with the additional capability that
    the data can be multi-dimensional. (Note that Epetra and Tpetra
    MultiVectors are 2 dimensional and distributed in an unstructured
    manner along only one of those dimensions.  MDVectors can be any
    number of dimensions, and can be distributed in a structured fashion
    along all of them.)

    Where Epetra and Tpetra MultiVectors are built on top of Epetra_Maps
    and Tpetra::Maps, respectively, the  MDVector is built on top of an
    MDMap. As such, they support boundary padding, communication padding,
    and periodicity.

    The basic  MDVector constructor takes an MDMap and an optional boolean
    flag providing instruction whether to zero out the data or not. A
    slightly more advanced constructor takes an MDMap, a leading
    dimension, an optional trailing dimension, and an optional zero-out
    flag. This allows the user to augment the given  MDMap with an
    undistributed dimension. This can be helpful when the user wants to
    store an array of quantities at each grid point. These quantities can
    be clustered or strided in memory depending on whether a leading or
    trailing dimension is specified, and what the data Layout is.

    There are additional constructors as well, based on copying data,
    using Teuchos::ParameterLists to specify the  MDVector layout, and
    parent/slice constructors, where slicing of the parent can be
    performed with an ordinal or a Slice.

    The ability to slice a parent  MDVector and obtain a sub-vector is an
    important feature of the  MDVector class. When you take a slice of a
    parent  MDVector, the resulting sub-vector may have a new, reduced
    communicator (both a new  MDComm and Teuchos::Comm). When accessing a
    sub-vector, you should always use the onSubcommunicator() method to
    determine that the sub-vector exists on the current processor.

    Like the Teuchos::MultiVector, the user cannot index directly into an
    MDVector. Rather, he or she must use the  getData() and
    getDataNonConst() methods to obtain an  MDArrayView of the data for
    manipulation. This is a little different than the Tpetra behavior,
    where an ArrayRCP is returned to the user. For  MDVector, and
    MDArrayView is returned, as this supports the slicing semantics of the
    class. Note that each  MDVector stores an internal  MDArrayRCP of
    either its original data or its parent's data, and then it also stores
    an  MDArrayView that is a view into the  MDArrayRCP. So the
    MDArrayView passed to the user will be valid as long as the reference
    count of its  MDArrayRCP is greater than zero. Looping bounds for this
    data can be obtained using the  getLocalBounds() method, which returns
    a concrete  Slice object, and takes a boolean that specifies whether
    padding should be included in the start and stop indexes.

    There are a variety of methods for converting  MDVectors to Epetra or
    Tpetra MultiVectors or Vectors, using either view or copy semantics.
    The view semantic is only available when the  MDVector is contiguous
    in memory, meaning there are no stride gaps due to slicing. The copy
    semantic is always available. True Epetra or Tpetra MultiVectors, in
    which the number of vectors is greater than 1, are only available when
    there is a non-distributed leading dimension and the layout is
    C-order, or there is a non-distributed trailing dimension and the
    layout is Fortran-order.

    If the  MDVector was built with communication padding, then the user
    may use the  updateCommPad() method to communicate via message passing
    data from the owning processors into the communication padding
    buffers. If communication along a single axis is desired, then the
    overloaded updateCommPad(int axis) method can be called instead. If
    asynchronous communication is desired, where computations can be
    performed between posting and receiving messages, then the
    startUpdateCommPad(int axis) and endUpdateCommPad(int axis) methods
    can be called. Note that the message data structures needed to
    coordinate these methods are stored internally.

    C++ includes: Domi_MDVector.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MDVector_long, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MDVector_long, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, bool zeroOut=True) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::dim_type const leadingDim, Domi::dim_type const trailingDim=0, bool zeroOut=True) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::MDArrayView< long long > const & source) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::MDArrayRCP< long long > const & source) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, MDVector_long source, Teuchos::DataAccess access) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, ParameterList plist) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDComm const > const mdComm, ParameterList plist) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, MDVector_long parent, int axis, Domi::dim_type index) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, MDVector_long parent, int axis, Slice slice, int bndryPad=0) -> MDVector_long
        __init__(Domi::MDVector<(long long,Domi::DefaultNode::DefaultNodeType)> self, MDVector_long parent, Teuchos::ArrayView< Domi::Slice > const & slices, Teuchos::ArrayView< int > const & bndryPad) -> MDVector_long

        Domi::MDVector<
        Scalar, Node >::MDVector(const MDVector< Scalar, Node > &parent, const
        Teuchos::ArrayView< Slice > &slices, const Teuchos::ArrayView< int >
        &bndryPad=Teuchos::ArrayView< int >())

        Parent/array of slices sub-vector constructor.

        Parameters:
        -----------

        parent:  [in] an MDVector, from which this sub-vector will be derived.

        slices:  [in] an array of Slices of global axis indexes that defines
        the sub- vector. These slices must not include indexes from the
        boundary padding along each axis.

        bndryPad:  [in] The boundary padding of the new sub-vector. These may
        include indexes from the boundary padding of the parent MDVector, but
        they do not have to. 
        """
        this = _Domi.new_MDVector_long(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Domi.delete_MDVector_long

    def getMDMap(self, *args):
        """
        getMDMap(MDVector_long self) -> Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const

        const Teuchos::RCP<
        const MDMap< Node > > Domi::MDVector< Scalar, Node >::getMDMap() const

        MDMap accessor method. 
        """
        return _Domi.MDVector_long_getMDMap(self, *args)


    def onSubcommunicator(self, *args):
        """
        onSubcommunicator(MDVector_long self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::onSubcommunicator() const

        Query whether this processor is on the sub-communicator.

        Sub-communicators are formed when a parent MDVector is sliced by using
        the (parent,ordinal) or (parent,slice) constructors. For a full
        communicator, this method will always return true. 
        """
        return _Domi.MDVector_long_onSubcommunicator(self, *args)


    def getTeuchosComm(self, *args):
        """
        getTeuchosComm(MDVector_long self) -> Teuchos::RCP< Teuchos::Comm< int > const >

        Teuchos::RCP<
        const Teuchos::Comm< int > > Domi::MDVector< Scalar, Node
        >::getTeuchosComm() const

        Get the Teuchos communicator.

        Note that if the communicator is not a full communicator, i.e. a sub-
        communicator, that the underlying Comm pointer may be NULL, depending
        on this processor's rank. 
        """
        return _Domi.MDVector_long_getTeuchosComm(self, *args)


    def numDims(self, *args):
        """
        numDims(MDVector_long self) -> int

        int Domi::MDVector<
        Scalar, Node >::numDims() const

        Get the number of dimensions.

        This method will return 0 if the communicator is a sub-communicator
        and this processor does not belong to the sub-communicator. 
        """
        return _Domi.MDVector_long_numDims(self, *args)


    def getCommDim(self, *args):
        """
        getCommDim(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommDim(int axis) const

        Get the communicator size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_long_getCommDim(self, *args)


    def isPeriodic(self, *args):
        """
        isPeriodic(MDVector_long self, int axis) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isPeriodic(int axis) const

        Return the periodic flag for the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_long_isPeriodic(self, *args)


    def getCommIndex(self, *args):
        """
        getCommIndex(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommIndex(int axis) const

        Get the axis rank of this processor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_long_getCommIndex(self, *args)


    def getLowerNeighbor(self, *args):
        """
        getLowerNeighbor(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerNeighbor(int axis) const

        Get the rank of the lower neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is zero, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then the returned lower neighbor will be zero. 
        """
        return _Domi.MDVector_long_getLowerNeighbor(self, *args)


    def getUpperNeighbor(self, *args):
        """
        getUpperNeighbor(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperNeighbor(int axis) const

        Get the rank of the upper neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is zero, then the returned lower neighbor will
        be the highest axis rank processor along this axis. 
        """
        return _Domi.MDVector_long_getUpperNeighbor(self, *args)


    def getGlobalDim(self, *args):
        """
        getGlobalDim(MDVector_long self, int axis, bool withBndryPad=False) -> Domi::dim_type

        dim_type
        Domi::MDVector< Scalar, Node >::getGlobalDim(int axis, bool
        withBndryPad=false) const

        Get the global dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the dimension should include
        boundary padding or not 
        """
        return _Domi.MDVector_long_getGlobalDim(self, *args)


    def getGlobalBounds(self, *args):
        """
        getGlobalBounds(MDVector_long self, int axis, bool withBndryPadding=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getGlobalBounds(int axis, bool
        withBndryPadding=false) const

        Get the bounds of the global problem.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the bounds should include boundary
        padding or not 
        """
        return _Domi.MDVector_long_getGlobalBounds(self, *args)


    def getGlobalRankBounds(self, *args):
        """
        getGlobalRankBounds(MDVector_long self, int axis, bool withBndryPad=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getGlobalRankBounds(int axis, bool
        withBndryPad=false) const

        Get the global loop bounds on this processor along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPadding:  [in] specify whether the dimension should include
        boundary padding or not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_long_getGlobalRankBounds(self, *args)


    def getLocalDim(self, *args):
        """
        getLocalDim(MDVector_long self, int axis, bool withCommPad=False) -> Domi::dim_type

        dim_type
        Domi::MDVector< Scalar, Node >::getLocalDim(int axis, bool
        withCommPad=false) const

        Get the local dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withCommPad:  [in] specify whether the dimension should include
        communication padding or not 
        """
        return _Domi.MDVector_long_getLocalDim(self, *args)


    def getLocalBounds(self, *args):
        """
        getLocalBounds(MDVector_long self) -> Teuchos::ArrayView< Domi::Slice const >
        getLocalBounds(MDVector_long self, int axis, bool withPad=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getLocalBounds(int axis, bool
        withPad=false) const

        Get the local looping bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withPad:  [in] specify whether the dimension should include padding or
        not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_long_getLocalBounds(self, *args)


    def getLocalInteriorBounds(self, *args):
        """
        getLocalInteriorBounds(MDVector_long self, int axis) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getLocalInteriorBounds(int axis) const

        Get the local interior looping bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Local interior loop bounds are the same as local loop bounds without
        padding, except that for non-periodic axes the global end points of
        the given axis are excluded. For periodic axes, the local interior
        loop bounds are exactly the same as local loop bounds without padding.

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_long_getLocalInteriorBounds(self, *args)


    def hasPadding(self, *args):
        """
        hasPadding(MDVector_long self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::hasPadding() const

        Return true if there is any padding stored locally.

        Note that it is not as simple as whether there were communication
        padding specified in the constructor. Suppose non-zero communication
        padding was specified, but the problem is on one processor and no
        boundary padding was specified: this method will return false.
        Similarly, if no communication padding was specified but boundary
        padding was, then boundary processors will have padding and this
        method will return true. 
        """
        return _Domi.MDVector_long_hasPadding(self, *args)


    def getLowerPadSize(self, *args):
        """
        getLowerPadSize(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerPadSize(int axis) const

        Get the size of the lower padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDVector_long_getLowerPadSize(self, *args)


    def getUpperPadSize(self, *args):
        """
        getUpperPadSize(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperPadSize(int axis) const

        Get the size of the upper padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDVector_long_getUpperPadSize(self, *args)


    def getCommPadSize(self, *args):
        """
        getCommPadSize(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommPadSize(int axis) const

        Get the communication padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the communication padding along the given
        axis at the time of construction, regardless of the processor's
        position relative to the domain boundary. 
        """
        return _Domi.MDVector_long_getCommPadSize(self, *args)


    def getLowerBndryPad(self, *args):
        """
        getLowerBndryPad(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerBndryPad(int axis) const

        Get the size of the lower boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDVector_long_getLowerBndryPad(self, *args)


    def getUpperBndryPad(self, *args):
        """
        getUpperBndryPad(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperBndryPad(int axis) const

        Get the size of the upper boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDVector_long_getUpperBndryPad(self, *args)


    def getBndryPadSize(self, *args):
        """
        getBndryPadSize(MDVector_long self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getBndryPadSize(int axis) const

        Get the boundary padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the boundary padding along the given axis at
        the time of construction, regardless of whether a sub-map reduced
        these values. 
        """
        return _Domi.MDVector_long_getBndryPadSize(self, *args)


    def setLowerPad(self, *args):
        """
        setLowerPad(MDVector_long self, int axis, long long const value)

        void
        Domi::MDVector< Scalar, Node >::setLowerPad(int axis, const Scalar
        value)

        Assign all elements of the lower pad a constant value.

        Parameters:
        -----------

        axis:  [in] the axis along which the lower padding is chosen

        value:  [in] the value to be assigned to all elements of the lower
        padding 
        """
        return _Domi.MDVector_long_setLowerPad(self, *args)


    def setUpperPad(self, *args):
        """
        setUpperPad(MDVector_long self, int axis, long long const value)

        void
        Domi::MDVector< Scalar, Node >::setUpperPad(int axis, const Scalar
        value)

        Assign all elements of the upper pad a constant value.

        Parameters:
        -----------

        axis:  [in] the axis along which the upper padding is chosen

        value:  [in] the value to be assigned to all elements of the upper
        padding 
        """
        return _Domi.MDVector_long_setUpperPad(self, *args)


    def isReplicatedBoundary(self, *args):
        """
        isReplicatedBoundary(MDVector_long self, int axis) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isReplicatedBoundary(int axis) const

        Return whether the given axis supports a replicated boundary. 
        """
        return _Domi.MDVector_long_isReplicatedBoundary(self, *args)


    def getLayout(self, *args):
        """
        getLayout(MDVector_long self) -> Domi::Layout

        Layout
        Domi::MDVector< Scalar, Node >::getLayout() const

        Get the storage order. 
        """
        return _Domi.MDVector_long_getLayout(self, *args)


    def isContiguous(self, *args):
        """
        isContiguous(MDVector_long self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isContiguous() const

        True if there are no stride gaps on any processor.

        An MDVector constructed from a communicator and dimensions will always
        be contiguous. An MDVector that is a slice of a parent MDMVector will
        generally be non- contiguous, with some exceptions. There are cases
        where some local data is contiguous and some is not, but this method
        returns True only if all processes' local data is contiguous. 
        """
        return _Domi.MDVector_long_isContiguous(self, *args)


    def getEpetraIntVectorView(self, *args):
        """getEpetraIntVectorView(MDVector_long self) -> Teuchos::RCP< Epetra_IntVector >"""
        return _Domi.MDVector_long_getEpetraIntVectorView(self, *args)


    def getEpetraVectorView(self, *args):
        """getEpetraVectorView(MDVector_long self) -> Teuchos::RCP< Epetra_Vector >"""
        return _Domi.MDVector_long_getEpetraVectorView(self, *args)


    def getEpetraMultiVectorView(self, *args):
        """getEpetraMultiVectorView(MDVector_long self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Domi.MDVector_long_getEpetraMultiVectorView(self, *args)


    def getEpetraIntVectorCopy(self, *args):
        """getEpetraIntVectorCopy(MDVector_long self) -> Teuchos::RCP< Epetra_IntVector >"""
        return _Domi.MDVector_long_getEpetraIntVectorCopy(self, *args)


    def getEpetraVectorCopy(self, *args):
        """getEpetraVectorCopy(MDVector_long self) -> Teuchos::RCP< Epetra_Vector >"""
        return _Domi.MDVector_long_getEpetraVectorCopy(self, *args)


    def getEpetraMultiVectorCopy(self, *args):
        """getEpetraMultiVectorCopy(MDVector_long self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Domi.MDVector_long_getEpetraMultiVectorCopy(self, *args)


    def getLowerPadDataNonConst(self, *args):
        """
        getLowerPadDataNonConst(MDVector_long self, int axis) -> Domi::MDArrayView< long long >

        MDArrayView< Scalar > Domi::MDVector< Scalar, Node
        >::getLowerPadDataNonConst(int axis)

        Get a non-const view of the lower padding data along the given axis as
        an MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the lower padding 
        """
        return _Domi.MDVector_long_getLowerPadDataNonConst(self, *args)


    def getLowerPadData(self, *args):
        """
        getLowerPadData(MDVector_long self, int axis) -> Domi::MDArrayView< long long const >

        MDArrayView<
        const Scalar > Domi::MDVector< Scalar, Node >::getLowerPadData(int
        axis) const

        Get a const view of the lower padding data along the given axis as an
        MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the lower padding 
        """
        return _Domi.MDVector_long_getLowerPadData(self, *args)


    def getUpperPadDataNonConst(self, *args):
        """
        getUpperPadDataNonConst(MDVector_long self, int axis) -> Domi::MDArrayView< long long >

        MDArrayView< Scalar > Domi::MDVector< Scalar, Node
        >::getUpperPadDataNonConst(int axis)

        Get a non-const view of the upper padding data along the given axis as
        an MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the upper padding 
        """
        return _Domi.MDVector_long_getUpperPadDataNonConst(self, *args)


    def getUpperPadData(self, *args):
        """
        getUpperPadData(MDVector_long self, int axis) -> Domi::MDArrayView< long long const >

        MDArrayView<
        const Scalar > Domi::MDVector< Scalar, Node >::getUpperPadData(int
        axis) const

        Get a const view of the upper padding data along the given axis as an
        MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the upper padding 
        """
        return _Domi.MDVector_long_getUpperPadData(self, *args)


    def dot(self, *args):
        """
        dot(MDVector_long self, MDVector_long a) -> long long

        Scalar Domi::MDVector<
        Scalar, Node >::dot(const MDVector< Scalar, Node > &a) const

        Compute the dot product of this MDVector and MDVector a.

        Parameters:
        -----------

        a:  [in] partner MDVector for performing dot product 
        """
        return _Domi.MDVector_long_dot(self, *args)


    def norm1(self, *args):
        """
        norm1(MDVector_long self) -> Teuchos::ScalarTraits< long long >::magnitudeType

        Teuchos::ScalarTraits<
        Scalar >::magnitudeType Domi::MDVector< Scalar, Node >::norm1() const

        Compute the 1-norm of this MDVector. 
        """
        return _Domi.MDVector_long_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MDVector_long self) -> Teuchos::ScalarTraits< long long >::magnitudeType

        Teuchos::ScalarTraits<
        Scalar >::magnitudeType Domi::MDVector< Scalar, Node >::norm2() const

        Compute the 2-norm of this MDVector. 
        """
        return _Domi.MDVector_long_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MDVector_long self) -> Teuchos::ScalarTraits< long long >::magnitudeType

        Teuchos::ScalarTraits< Scalar >::magnitudeType Domi::MDVector< Scalar,
        Node >::normInf() const

        Compute the infinity-norm of this MDVector. 
        """
        return _Domi.MDVector_long_normInf(self, *args)


    def normWeighted(self, *args):
        """
        normWeighted(MDVector_long self, MDVector_long weights) -> Teuchos::ScalarTraits< long long >::magnitudeType

        Teuchos::ScalarTraits< Scalar >::magnitudeType Domi::MDVector< Scalar,
        Node >::normWeighted(const MDVector< Scalar, Node > &weights) const

        Compute the weighted norm of this.

        Parameters:
        -----------

        weights:  [in] MDVector of weights for weighted norm 
        """
        return _Domi.MDVector_long_normWeighted(self, *args)


    def meanValue(self, *args):
        """
        meanValue(MDVector_long self) -> long long

        Scalar
        Domi::MDVector< Scalar, Node >::meanValue() const

        Compute the mean (average) value of this MDVector. 
        """
        return _Domi.MDVector_long_meanValue(self, *args)


    def description(self, *args):
        """
        description(MDVector_long self) -> std::string

        std::string
        Domi::MDVector< Scalar, Node >::description() const

        A simple one-line description of this MDVector. 
        """
        return _Domi.MDVector_long_description(self, *args)


    def describe(self, *args):
        """
        describe(MDVector_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Domi::MDVector<
        Scalar, Node >::describe(Teuchos::FancyOStream &out, const
        Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print the object with some verbosity level to a FancyOStream.

        Parameters:
        -----------

        out:  [in] output stream

        verbLevel:  [in] verbosity level 
        """
        return _Domi.MDVector_long_describe(self, *args)


    def putScalar(self, *args):
        """
        putScalar(MDVector_long self, long long const & value, bool includePadding=True)

        void
        Domi::MDVector< Scalar, Node >::putScalar(const Scalar &value, bool
        includePadding=true)

        Set all values in the multivector with the given value.

        Parameters:
        -----------

        value:  [in] assignment value

        includePadding:  [in] if true, assign values to the boundary and
        communication padding as well 
        """
        return _Domi.MDVector_long_putScalar(self, *args)


    def randomize(self, *args):
        """
        randomize(MDVector_long self)

        void
        Domi::MDVector< Scalar, Node >::randomize()

        Set all values in the multivector to pseudorandom numbers. 
        """
        return _Domi.MDVector_long_randomize(self, *args)


    def updateCommPad(self, *args):
        """
        updateCommPad(MDVector_long self)
        updateCommPad(MDVector_long self, int axis)

        void
        Domi::MDVector< Scalar, Node >::updateCommPad(int axis) 
        """
        return _Domi.MDVector_long_updateCommPad(self, *args)


    def startUpdateCommPad(self, *args):
        """
        startUpdateCommPad(MDVector_long self, int axis)

        void
        Domi::MDVector< Scalar, Node >::startUpdateCommPad(int axis)

        Start an asyncronous update of the communication padding.

        Parameters:
        -----------

        axis:  [in] the axis along which communication will be performed

        Post the non-blocking sends and receives for the communication padding
        along the given axis 
        """
        return _Domi.MDVector_long_startUpdateCommPad(self, *args)


    def endUpdateCommPad(self, *args):
        """
        endUpdateCommPad(MDVector_long self, int axis)

        void
        Domi::MDVector< Scalar, Node >::endUpdateCommPad(int axis)

        Complete an asyncronous update of the communication padding.

        Parameters:
        -----------

        axis:  [in] the axis along which communication will be performed

        Wait for all of the non-blocking updates for the communication padding
        along the given axis to complete 
        """
        return _Domi.MDVector_long_endUpdateCommPad(self, *args)


    def writeBinary(self, *args):
        """
        writeBinary(MDVector_long self, std::string const & filename, bool includeBndryPad=False)

        void
        Domi::MDVector< Scalar, Node >::writeBinary(const std::string
        &filename, bool includeBndryPad=false) const

        Write the MDVector to a binary file.

        Parameters:
        -----------

        filename:  [in] name of the output file

        includeBndryPad:  [in] if true, include the boundary pad with the
        output data 
        """
        return _Domi.MDVector_long_writeBinary(self, *args)


    def readBinary(self, *args):
        """
        readBinary(MDVector_long self, std::string const & filename, bool includeBndryPad=False)

        void
        Domi::MDVector< Scalar, Node >::readBinary(const std::string
        &filename, bool includeBndryPad=false)

        Read the MDVector from a binary file.

        Parameters:
        -----------

        filename:  [in] name of the input file

        includeBndryPad:  [in] if true, include the boundary pad with the
        input data 
        """
        return _Domi.MDVector_long_readBinary(self, *args)


    def __getitem__(self, *args):
        """__getitem__(MDVector_long self, PyObject * indexes) -> MDVector_long"""
        return _Domi.MDVector_long___getitem__(self, *args)


    def getData(self, *args):
        """
        getData(MDVector_long self, bool includePadding=True) -> Domi::MDArrayView< long long >

        MDArrayView< const
        Scalar > Domi::MDVector< Scalar, Node >::getData(bool
        includePadding=true) const

        Get a const view of the data as an MDArrayView.

        Parameters:
        -----------

        includePadding:  [in] if true, include the boundary and communication
        padding in the returned MDArrayView 
        """
        return _Domi.MDVector_long_getData(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MDVector_long self) -> PyObject *"""
        return _Domi.MDVector_long___distarray__(self, *args)


    def getTpetraVectorView(self, *args):
        """getTpetraVectorView(MDVector_long self) -> Teuchos::RCP< Tpetra::Vector< long long,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_long_getTpetraVectorView(self, *args)


    def getTpetraVectorCopy(self, *args):
        """getTpetraVectorCopy(MDVector_long self) -> Teuchos::RCP< Tpetra::Vector< long long,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_long_getTpetraVectorCopy(self, *args)


    def getTpetraMultiVectorView(self, *args):
        """getTpetraMultiVectorView(MDVector_long self) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_long_getTpetraMultiVectorView(self, *args)


    def getTpetraMultiVectorCopy(self, *args):
        """getTpetraMultiVectorCopy(MDVector_long self) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_long_getTpetraMultiVectorCopy(self, *args)

MDVector_long_swigregister = _Domi.MDVector_long_swigregister
MDVector_long_swigregister(MDVector_long)


upgradeMDVectorClass(MDVector_long)

class MDVector_double(Teuchos.Describable):
    """


    Multi-dimensional distributed vector.

    The  MDVector class is intended to perform the functions of Epetra or
    Tpetra MultiVectors (or Vectors), with the additional capability that
    the data can be multi-dimensional. (Note that Epetra and Tpetra
    MultiVectors are 2 dimensional and distributed in an unstructured
    manner along only one of those dimensions.  MDVectors can be any
    number of dimensions, and can be distributed in a structured fashion
    along all of them.)

    Where Epetra and Tpetra MultiVectors are built on top of Epetra_Maps
    and Tpetra::Maps, respectively, the  MDVector is built on top of an
    MDMap. As such, they support boundary padding, communication padding,
    and periodicity.

    The basic  MDVector constructor takes an MDMap and an optional boolean
    flag providing instruction whether to zero out the data or not. A
    slightly more advanced constructor takes an MDMap, a leading
    dimension, an optional trailing dimension, and an optional zero-out
    flag. This allows the user to augment the given  MDMap with an
    undistributed dimension. This can be helpful when the user wants to
    store an array of quantities at each grid point. These quantities can
    be clustered or strided in memory depending on whether a leading or
    trailing dimension is specified, and what the data Layout is.

    There are additional constructors as well, based on copying data,
    using Teuchos::ParameterLists to specify the  MDVector layout, and
    parent/slice constructors, where slicing of the parent can be
    performed with an ordinal or a Slice.

    The ability to slice a parent  MDVector and obtain a sub-vector is an
    important feature of the  MDVector class. When you take a slice of a
    parent  MDVector, the resulting sub-vector may have a new, reduced
    communicator (both a new  MDComm and Teuchos::Comm). When accessing a
    sub-vector, you should always use the onSubcommunicator() method to
    determine that the sub-vector exists on the current processor.

    Like the Teuchos::MultiVector, the user cannot index directly into an
    MDVector. Rather, he or she must use the  getData() and
    getDataNonConst() methods to obtain an  MDArrayView of the data for
    manipulation. This is a little different than the Tpetra behavior,
    where an ArrayRCP is returned to the user. For  MDVector, and
    MDArrayView is returned, as this supports the slicing semantics of the
    class. Note that each  MDVector stores an internal  MDArrayRCP of
    either its original data or its parent's data, and then it also stores
    an  MDArrayView that is a view into the  MDArrayRCP. So the
    MDArrayView passed to the user will be valid as long as the reference
    count of its  MDArrayRCP is greater than zero. Looping bounds for this
    data can be obtained using the  getLocalBounds() method, which returns
    a concrete  Slice object, and takes a boolean that specifies whether
    padding should be included in the start and stop indexes.

    There are a variety of methods for converting  MDVectors to Epetra or
    Tpetra MultiVectors or Vectors, using either view or copy semantics.
    The view semantic is only available when the  MDVector is contiguous
    in memory, meaning there are no stride gaps due to slicing. The copy
    semantic is always available. True Epetra or Tpetra MultiVectors, in
    which the number of vectors is greater than 1, are only available when
    there is a non-distributed leading dimension and the layout is
    C-order, or there is a non-distributed trailing dimension and the
    layout is Fortran-order.

    If the  MDVector was built with communication padding, then the user
    may use the  updateCommPad() method to communicate via message passing
    data from the owning processors into the communication padding
    buffers. If communication along a single axis is desired, then the
    overloaded updateCommPad(int axis) method can be called instead. If
    asynchronous communication is desired, where computations can be
    performed between posting and receiving messages, then the
    startUpdateCommPad(int axis) and endUpdateCommPad(int axis) methods
    can be called. Note that the message data structures needed to
    coordinate these methods are stored internally.

    C++ includes: Domi_MDVector.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MDVector_double, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MDVector_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, bool zeroOut=True) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::dim_type const leadingDim, Domi::dim_type const trailingDim=0, bool zeroOut=True) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::MDArrayView< double > const & source) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const & mdMap, Domi::MDArrayRCP< double > const & source) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, MDVector_double source, Teuchos::DataAccess access) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, ParameterList plist) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, Teuchos::RCP< Domi::MDComm const > const mdComm, ParameterList plist) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, MDVector_double parent, int axis, Domi::dim_type index) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, MDVector_double parent, int axis, Slice slice, int bndryPad=0) -> MDVector_double
        __init__(Domi::MDVector<(double,Domi::DefaultNode::DefaultNodeType)> self, MDVector_double parent, Teuchos::ArrayView< Domi::Slice > const & slices, Teuchos::ArrayView< int > const & bndryPad) -> MDVector_double

        Domi::MDVector<
        Scalar, Node >::MDVector(const MDVector< Scalar, Node > &parent, const
        Teuchos::ArrayView< Slice > &slices, const Teuchos::ArrayView< int >
        &bndryPad=Teuchos::ArrayView< int >())

        Parent/array of slices sub-vector constructor.

        Parameters:
        -----------

        parent:  [in] an MDVector, from which this sub-vector will be derived.

        slices:  [in] an array of Slices of global axis indexes that defines
        the sub- vector. These slices must not include indexes from the
        boundary padding along each axis.

        bndryPad:  [in] The boundary padding of the new sub-vector. These may
        include indexes from the boundary padding of the parent MDVector, but
        they do not have to. 
        """
        this = _Domi.new_MDVector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Domi.delete_MDVector_double

    def getMDMap(self, *args):
        """
        getMDMap(MDVector_double self) -> Teuchos::RCP< Domi::MDMap< Domi::DefaultNode::DefaultNodeType > const > const

        const Teuchos::RCP<
        const MDMap< Node > > Domi::MDVector< Scalar, Node >::getMDMap() const

        MDMap accessor method. 
        """
        return _Domi.MDVector_double_getMDMap(self, *args)


    def onSubcommunicator(self, *args):
        """
        onSubcommunicator(MDVector_double self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::onSubcommunicator() const

        Query whether this processor is on the sub-communicator.

        Sub-communicators are formed when a parent MDVector is sliced by using
        the (parent,ordinal) or (parent,slice) constructors. For a full
        communicator, this method will always return true. 
        """
        return _Domi.MDVector_double_onSubcommunicator(self, *args)


    def getTeuchosComm(self, *args):
        """
        getTeuchosComm(MDVector_double self) -> Teuchos::RCP< Teuchos::Comm< int > const >

        Teuchos::RCP<
        const Teuchos::Comm< int > > Domi::MDVector< Scalar, Node
        >::getTeuchosComm() const

        Get the Teuchos communicator.

        Note that if the communicator is not a full communicator, i.e. a sub-
        communicator, that the underlying Comm pointer may be NULL, depending
        on this processor's rank. 
        """
        return _Domi.MDVector_double_getTeuchosComm(self, *args)


    def numDims(self, *args):
        """
        numDims(MDVector_double self) -> int

        int Domi::MDVector<
        Scalar, Node >::numDims() const

        Get the number of dimensions.

        This method will return 0 if the communicator is a sub-communicator
        and this processor does not belong to the sub-communicator. 
        """
        return _Domi.MDVector_double_numDims(self, *args)


    def getCommDim(self, *args):
        """
        getCommDim(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommDim(int axis) const

        Get the communicator size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_double_getCommDim(self, *args)


    def isPeriodic(self, *args):
        """
        isPeriodic(MDVector_double self, int axis) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isPeriodic(int axis) const

        Return the periodic flag for the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_double_isPeriodic(self, *args)


    def getCommIndex(self, *args):
        """
        getCommIndex(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommIndex(int axis) const

        Get the axis rank of this processor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator. 
        """
        return _Domi.MDVector_double_getCommIndex(self, *args)


    def getLowerNeighbor(self, *args):
        """
        getLowerNeighbor(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerNeighbor(int axis) const

        Get the rank of the lower neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is zero, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then the returned lower neighbor will be zero. 
        """
        return _Domi.MDVector_double_getLowerNeighbor(self, *args)


    def getUpperNeighbor(self, *args):
        """
        getUpperNeighbor(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperNeighbor(int axis) const

        Get the rank of the upper neighbor.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This method will throw a Domi::SubcommunicatorError if the
        communicator is a sub-communicator and this processor does not belong
        to the sub-communicator.

        If the periodic flag for the given axis is off, and the axis rank of
        the calling processor is the highest axis rank processor along this
        axis, then this method returns -1.

        If the periodic flag for the given axis is on, and the axis rank of
        the calling processor is zero, then the returned lower neighbor will
        be the highest axis rank processor along this axis. 
        """
        return _Domi.MDVector_double_getUpperNeighbor(self, *args)


    def getGlobalDim(self, *args):
        """
        getGlobalDim(MDVector_double self, int axis, bool withBndryPad=False) -> Domi::dim_type

        dim_type
        Domi::MDVector< Scalar, Node >::getGlobalDim(int axis, bool
        withBndryPad=false) const

        Get the global dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the dimension should include
        boundary padding or not 
        """
        return _Domi.MDVector_double_getGlobalDim(self, *args)


    def getGlobalBounds(self, *args):
        """
        getGlobalBounds(MDVector_double self, int axis, bool withBndryPadding=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getGlobalBounds(int axis, bool
        withBndryPadding=false) const

        Get the bounds of the global problem.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPad:  [in] specify whether the bounds should include boundary
        padding or not 
        """
        return _Domi.MDVector_double_getGlobalBounds(self, *args)


    def getGlobalRankBounds(self, *args):
        """
        getGlobalRankBounds(MDVector_double self, int axis, bool withBndryPad=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getGlobalRankBounds(int axis, bool
        withBndryPad=false) const

        Get the global loop bounds on this processor along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withBndryPadding:  [in] specify whether the dimension should include
        boundary padding or not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_double_getGlobalRankBounds(self, *args)


    def getLocalDim(self, *args):
        """
        getLocalDim(MDVector_double self, int axis, bool withCommPad=False) -> Domi::dim_type

        dim_type
        Domi::MDVector< Scalar, Node >::getLocalDim(int axis, bool
        withCommPad=false) const

        Get the local dimension along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withCommPad:  [in] specify whether the dimension should include
        communication padding or not 
        """
        return _Domi.MDVector_double_getLocalDim(self, *args)


    def getLocalBounds(self, *args):
        """
        getLocalBounds(MDVector_double self) -> Teuchos::ArrayView< Domi::Slice const >
        getLocalBounds(MDVector_double self, int axis, bool withPad=False) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getLocalBounds(int axis, bool
        withPad=false) const

        Get the local looping bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        withPad:  [in] specify whether the dimension should include padding or
        not

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_double_getLocalBounds(self, *args)


    def getLocalInteriorBounds(self, *args):
        """
        getLocalInteriorBounds(MDVector_double self, int axis) -> Slice

        Slice
        Domi::MDVector< Scalar, Node >::getLocalInteriorBounds(int axis) const

        Get the local interior looping bounds along the specified axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Local interior loop bounds are the same as local loop bounds without
        padding, except that for non-periodic axes the global end points of
        the given axis are excluded. For periodic axes, the local interior
        loop bounds are exactly the same as local loop bounds without padding.

        The loop bounds are returned in the form of a  Slice, in which the
        start() method returns the loop begin value, and the stop() method
        returns the non-inclusive end value. 
        """
        return _Domi.MDVector_double_getLocalInteriorBounds(self, *args)


    def hasPadding(self, *args):
        """
        hasPadding(MDVector_double self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::hasPadding() const

        Return true if there is any padding stored locally.

        Note that it is not as simple as whether there were communication
        padding specified in the constructor. Suppose non-zero communication
        padding was specified, but the problem is on one processor and no
        boundary padding was specified: this method will return false.
        Similarly, if no communication padding was specified but boundary
        padding was, then boundary processors will have padding and this
        method will return true. 
        """
        return _Domi.MDVector_double_hasPadding(self, *args)


    def getLowerPadSize(self, *args):
        """
        getLowerPadSize(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerPadSize(int axis) const

        Get the size of the lower padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDVector_double_getLowerPadSize(self, *args)


    def getUpperPadSize(self, *args):
        """
        getUpperPadSize(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperPadSize(int axis) const

        Get the size of the upper padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        Note that the returned padding can be either communication padding or
        boundary padding as appropriate. 
        """
        return _Domi.MDVector_double_getUpperPadSize(self, *args)


    def getCommPadSize(self, *args):
        """
        getCommPadSize(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getCommPadSize(int axis) const

        Get the communication padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the communication padding along the given
        axis at the time of construction, regardless of the processor's
        position relative to the domain boundary. 
        """
        return _Domi.MDVector_double_getCommPadSize(self, *args)


    def getLowerBndryPad(self, *args):
        """
        getLowerBndryPad(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getLowerBndryPad(int axis) const

        Get the size of the lower boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDVector_double_getLowerBndryPad(self, *args)


    def getUpperBndryPad(self, *args):
        """
        getUpperBndryPad(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getUpperBndryPad(int axis) const

        Get the size of the upper boundary padding along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1) 
        """
        return _Domi.MDVector_double_getUpperBndryPad(self, *args)


    def getBndryPadSize(self, *args):
        """
        getBndryPadSize(MDVector_double self, int axis) -> int

        int
        Domi::MDVector< Scalar, Node >::getBndryPadSize(int axis) const

        Get the boundary padding size along the given axis.

        Parameters:
        -----------

        axis:  [in] the index of the axis (from zero to the number of
        dimensions - 1)

        This returns the value of the boundary padding along the given axis at
        the time of construction, regardless of whether a sub-map reduced
        these values. 
        """
        return _Domi.MDVector_double_getBndryPadSize(self, *args)


    def setLowerPad(self, *args):
        """
        setLowerPad(MDVector_double self, int axis, double const value)

        void
        Domi::MDVector< Scalar, Node >::setLowerPad(int axis, const Scalar
        value)

        Assign all elements of the lower pad a constant value.

        Parameters:
        -----------

        axis:  [in] the axis along which the lower padding is chosen

        value:  [in] the value to be assigned to all elements of the lower
        padding 
        """
        return _Domi.MDVector_double_setLowerPad(self, *args)


    def setUpperPad(self, *args):
        """
        setUpperPad(MDVector_double self, int axis, double const value)

        void
        Domi::MDVector< Scalar, Node >::setUpperPad(int axis, const Scalar
        value)

        Assign all elements of the upper pad a constant value.

        Parameters:
        -----------

        axis:  [in] the axis along which the upper padding is chosen

        value:  [in] the value to be assigned to all elements of the upper
        padding 
        """
        return _Domi.MDVector_double_setUpperPad(self, *args)


    def isReplicatedBoundary(self, *args):
        """
        isReplicatedBoundary(MDVector_double self, int axis) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isReplicatedBoundary(int axis) const

        Return whether the given axis supports a replicated boundary. 
        """
        return _Domi.MDVector_double_isReplicatedBoundary(self, *args)


    def getLayout(self, *args):
        """
        getLayout(MDVector_double self) -> Domi::Layout

        Layout
        Domi::MDVector< Scalar, Node >::getLayout() const

        Get the storage order. 
        """
        return _Domi.MDVector_double_getLayout(self, *args)


    def isContiguous(self, *args):
        """
        isContiguous(MDVector_double self) -> bool

        bool
        Domi::MDVector< Scalar, Node >::isContiguous() const

        True if there are no stride gaps on any processor.

        An MDVector constructed from a communicator and dimensions will always
        be contiguous. An MDVector that is a slice of a parent MDMVector will
        generally be non- contiguous, with some exceptions. There are cases
        where some local data is contiguous and some is not, but this method
        returns True only if all processes' local data is contiguous. 
        """
        return _Domi.MDVector_double_isContiguous(self, *args)


    def getEpetraIntVectorView(self, *args):
        """getEpetraIntVectorView(MDVector_double self) -> Teuchos::RCP< Epetra_IntVector >"""
        return _Domi.MDVector_double_getEpetraIntVectorView(self, *args)


    def getEpetraVectorView(self, *args):
        """getEpetraVectorView(MDVector_double self) -> Teuchos::RCP< Epetra_Vector >"""
        return _Domi.MDVector_double_getEpetraVectorView(self, *args)


    def getEpetraMultiVectorView(self, *args):
        """getEpetraMultiVectorView(MDVector_double self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Domi.MDVector_double_getEpetraMultiVectorView(self, *args)


    def getEpetraIntVectorCopy(self, *args):
        """getEpetraIntVectorCopy(MDVector_double self) -> Teuchos::RCP< Epetra_IntVector >"""
        return _Domi.MDVector_double_getEpetraIntVectorCopy(self, *args)


    def getEpetraVectorCopy(self, *args):
        """getEpetraVectorCopy(MDVector_double self) -> Teuchos::RCP< Epetra_Vector >"""
        return _Domi.MDVector_double_getEpetraVectorCopy(self, *args)


    def getEpetraMultiVectorCopy(self, *args):
        """getEpetraMultiVectorCopy(MDVector_double self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Domi.MDVector_double_getEpetraMultiVectorCopy(self, *args)


    def getLowerPadDataNonConst(self, *args):
        """
        getLowerPadDataNonConst(MDVector_double self, int axis) -> Domi::MDArrayView< double >

        MDArrayView< Scalar > Domi::MDVector< Scalar, Node
        >::getLowerPadDataNonConst(int axis)

        Get a non-const view of the lower padding data along the given axis as
        an MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the lower padding 
        """
        return _Domi.MDVector_double_getLowerPadDataNonConst(self, *args)


    def getLowerPadData(self, *args):
        """
        getLowerPadData(MDVector_double self, int axis) -> Domi::MDArrayView< double const >

        MDArrayView<
        const Scalar > Domi::MDVector< Scalar, Node >::getLowerPadData(int
        axis) const

        Get a const view of the lower padding data along the given axis as an
        MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the lower padding 
        """
        return _Domi.MDVector_double_getLowerPadData(self, *args)


    def getUpperPadDataNonConst(self, *args):
        """
        getUpperPadDataNonConst(MDVector_double self, int axis) -> Domi::MDArrayView< double >

        MDArrayView< Scalar > Domi::MDVector< Scalar, Node
        >::getUpperPadDataNonConst(int axis)

        Get a non-const view of the upper padding data along the given axis as
        an MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the upper padding 
        """
        return _Domi.MDVector_double_getUpperPadDataNonConst(self, *args)


    def getUpperPadData(self, *args):
        """
        getUpperPadData(MDVector_double self, int axis) -> Domi::MDArrayView< double const >

        MDArrayView<
        const Scalar > Domi::MDVector< Scalar, Node >::getUpperPadData(int
        axis) const

        Get a const view of the upper padding data along the given axis as an
        MDArrayView.

        Parameters:
        -----------

        axis:  [in] the axis from which to extract the upper padding 
        """
        return _Domi.MDVector_double_getUpperPadData(self, *args)


    def dot(self, *args):
        """
        dot(MDVector_double self, MDVector_double a) -> double

        Scalar Domi::MDVector<
        Scalar, Node >::dot(const MDVector< Scalar, Node > &a) const

        Compute the dot product of this MDVector and MDVector a.

        Parameters:
        -----------

        a:  [in] partner MDVector for performing dot product 
        """
        return _Domi.MDVector_double_dot(self, *args)


    def norm1(self, *args):
        """
        norm1(MDVector_double self) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits<
        Scalar >::magnitudeType Domi::MDVector< Scalar, Node >::norm1() const

        Compute the 1-norm of this MDVector. 
        """
        return _Domi.MDVector_double_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MDVector_double self) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits<
        Scalar >::magnitudeType Domi::MDVector< Scalar, Node >::norm2() const

        Compute the 2-norm of this MDVector. 
        """
        return _Domi.MDVector_double_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MDVector_double self) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< Scalar >::magnitudeType Domi::MDVector< Scalar,
        Node >::normInf() const

        Compute the infinity-norm of this MDVector. 
        """
        return _Domi.MDVector_double_normInf(self, *args)


    def normWeighted(self, *args):
        """
        normWeighted(MDVector_double self, MDVector_double weights) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< Scalar >::magnitudeType Domi::MDVector< Scalar,
        Node >::normWeighted(const MDVector< Scalar, Node > &weights) const

        Compute the weighted norm of this.

        Parameters:
        -----------

        weights:  [in] MDVector of weights for weighted norm 
        """
        return _Domi.MDVector_double_normWeighted(self, *args)


    def meanValue(self, *args):
        """
        meanValue(MDVector_double self) -> double

        Scalar
        Domi::MDVector< Scalar, Node >::meanValue() const

        Compute the mean (average) value of this MDVector. 
        """
        return _Domi.MDVector_double_meanValue(self, *args)


    def description(self, *args):
        """
        description(MDVector_double self) -> std::string

        std::string
        Domi::MDVector< Scalar, Node >::description() const

        A simple one-line description of this MDVector. 
        """
        return _Domi.MDVector_double_description(self, *args)


    def describe(self, *args):
        """
        describe(MDVector_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)

        void Domi::MDVector<
        Scalar, Node >::describe(Teuchos::FancyOStream &out, const
        Teuchos::EVerbosityLevel
        verbLevel=Teuchos::Describable::verbLevel_default) const

        Print the object with some verbosity level to a FancyOStream.

        Parameters:
        -----------

        out:  [in] output stream

        verbLevel:  [in] verbosity level 
        """
        return _Domi.MDVector_double_describe(self, *args)


    def putScalar(self, *args):
        """
        putScalar(MDVector_double self, double const & value, bool includePadding=True)

        void
        Domi::MDVector< Scalar, Node >::putScalar(const Scalar &value, bool
        includePadding=true)

        Set all values in the multivector with the given value.

        Parameters:
        -----------

        value:  [in] assignment value

        includePadding:  [in] if true, assign values to the boundary and
        communication padding as well 
        """
        return _Domi.MDVector_double_putScalar(self, *args)


    def randomize(self, *args):
        """
        randomize(MDVector_double self)

        void
        Domi::MDVector< Scalar, Node >::randomize()

        Set all values in the multivector to pseudorandom numbers. 
        """
        return _Domi.MDVector_double_randomize(self, *args)


    def updateCommPad(self, *args):
        """
        updateCommPad(MDVector_double self)
        updateCommPad(MDVector_double self, int axis)

        void
        Domi::MDVector< Scalar, Node >::updateCommPad(int axis) 
        """
        return _Domi.MDVector_double_updateCommPad(self, *args)


    def startUpdateCommPad(self, *args):
        """
        startUpdateCommPad(MDVector_double self, int axis)

        void
        Domi::MDVector< Scalar, Node >::startUpdateCommPad(int axis)

        Start an asyncronous update of the communication padding.

        Parameters:
        -----------

        axis:  [in] the axis along which communication will be performed

        Post the non-blocking sends and receives for the communication padding
        along the given axis 
        """
        return _Domi.MDVector_double_startUpdateCommPad(self, *args)


    def endUpdateCommPad(self, *args):
        """
        endUpdateCommPad(MDVector_double self, int axis)

        void
        Domi::MDVector< Scalar, Node >::endUpdateCommPad(int axis)

        Complete an asyncronous update of the communication padding.

        Parameters:
        -----------

        axis:  [in] the axis along which communication will be performed

        Wait for all of the non-blocking updates for the communication padding
        along the given axis to complete 
        """
        return _Domi.MDVector_double_endUpdateCommPad(self, *args)


    def writeBinary(self, *args):
        """
        writeBinary(MDVector_double self, std::string const & filename, bool includeBndryPad=False)

        void
        Domi::MDVector< Scalar, Node >::writeBinary(const std::string
        &filename, bool includeBndryPad=false) const

        Write the MDVector to a binary file.

        Parameters:
        -----------

        filename:  [in] name of the output file

        includeBndryPad:  [in] if true, include the boundary pad with the
        output data 
        """
        return _Domi.MDVector_double_writeBinary(self, *args)


    def readBinary(self, *args):
        """
        readBinary(MDVector_double self, std::string const & filename, bool includeBndryPad=False)

        void
        Domi::MDVector< Scalar, Node >::readBinary(const std::string
        &filename, bool includeBndryPad=false)

        Read the MDVector from a binary file.

        Parameters:
        -----------

        filename:  [in] name of the input file

        includeBndryPad:  [in] if true, include the boundary pad with the
        input data 
        """
        return _Domi.MDVector_double_readBinary(self, *args)


    def __getitem__(self, *args):
        """__getitem__(MDVector_double self, PyObject * indexes) -> MDVector_double"""
        return _Domi.MDVector_double___getitem__(self, *args)


    def getData(self, *args):
        """
        getData(MDVector_double self, bool includePadding=True) -> Domi::MDArrayView< double >

        MDArrayView< const
        Scalar > Domi::MDVector< Scalar, Node >::getData(bool
        includePadding=true) const

        Get a const view of the data as an MDArrayView.

        Parameters:
        -----------

        includePadding:  [in] if true, include the boundary and communication
        padding in the returned MDArrayView 
        """
        return _Domi.MDVector_double_getData(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MDVector_double self) -> PyObject *"""
        return _Domi.MDVector_double___distarray__(self, *args)


    def getTpetraVectorView(self, *args):
        """getTpetraVectorView(MDVector_double self) -> Teuchos::RCP< Tpetra::Vector< double,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_double_getTpetraVectorView(self, *args)


    def getTpetraVectorCopy(self, *args):
        """getTpetraVectorCopy(MDVector_double self) -> Teuchos::RCP< Tpetra::Vector< double,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_double_getTpetraVectorCopy(self, *args)


    def getTpetraMultiVectorView(self, *args):
        """getTpetraMultiVectorView(MDVector_double self) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_double_getTpetraMultiVectorView(self, *args)


    def getTpetraMultiVectorCopy(self, *args):
        """getTpetraMultiVectorCopy(MDVector_double self) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,DefaultNodeType > >"""
        return _Domi.MDVector_double_getTpetraMultiVectorCopy(self, *args)

MDVector_double_swigregister = _Domi.MDVector_double_swigregister
MDVector_double_swigregister(MDVector_double)


upgradeMDVectorClass(MDVector_double)


def from_DistArray_int(*args):
    """from_DistArray_int(Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, PyObject * distArrayObj) -> Teuchos::RCP< Domi::MDVector< int,Domi::DefaultNode::DefaultNodeType > >"""
    return _Domi.from_DistArray_int(*args)

def from_DistArray_long(*args):
    """from_DistArray_long(Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, PyObject * distArrayObj) -> Teuchos::RCP< Domi::MDVector< long long,Domi::DefaultNode::DefaultNodeType > >"""
    return _Domi.from_DistArray_long(*args)

def from_DistArray_double(*args):
    """from_DistArray_double(Teuchos::RCP< Teuchos::Comm< int > const > const teuchosComm, PyObject * distArrayObj) -> Teuchos::RCP< Domi::MDVector< double,Domi::DefaultNode::DefaultNodeType > >"""
    return _Domi.from_DistArray_double(*args)

def from_DistArray(comm, distarray):
    protocol = distarray.__distarray__()
    dtype = protocol["buffer"].dtype
    if dtype.type is numpy.int32:
        return from_DistArray_int(comm, protocol)
    elif dtype.type is numpy.int64:
        return from_DistArray_long(comm, protocol)
#elif dtype.type is numpy.float32:
#    return from_DistArray_float(comm, protocol)
    elif dtype.type is numpy.float64:
        return from_DistArray_double(comm, protocol)
    else:
        raise TypeError("Unsupported or unrecognized dtype = %s" % str(dtype))


# My first cut at MDVector was to make it a wrapper class.  I now prefer the
# idea of MDVector being a factory function.  There is a bit of non-trivial work
# that went into the wrapper class, though, so I comment it out rather than
# delete it.  Who knows, I may want to go back to it some day...

# class MDVector(object):
#     def __init__(self, *args, **kwargs):
#         dtype       = kwargs.get("dtype"      , "int64")
#         zeroOut     = kwargs.get("zeroOut"    , False  )
#         leadingDim  = kwargs.get("leadingDim" , 0      )
#         trailingDim = kwargs.get("trailingDim", 0      )
#         if type(dtype) == str:
#             dtype = numpy.dtype(dtype)
# 
#         # Factory for arg is MDMap
#         if isinstance(args[0], MDMap):
#             if dtype.type is numpy.int32:
#                 self._vector = MDVector_int(args[0],
#                                             leadingDim,
#                                             trailingDim,
#                                             zeroOut)
#             elif dtype.type is numpy.int64:
#                 self._vector = MDVector_long(args[0],
#                                              leadingDim,
#                                              trailingDim,
#                                              zeroOut)
#             elif dtype.type is numpy.float32:
#                 self._vector = MDVector_float(args[0],
#                                               leadingDim,
#                                               trailingDim,
#                                               zeroOut)
#             elif dtype.type is numpy.float64:
#                 self._vector = MDVector_double(args[0],
#                                                leadingDim,
#                                                trailingDim,
#                                                zeroOut)
#             else:
#                 raise TypeError("Unsupported or unrecognized dtype = %s" %
#                                 str(dtype))
# 
#         # Factory for arg is DistArray
#         elif hasattr(arg, '__distarray__'):
#             self._vector = from_DistArray(*args)
# 
#         self.dtype = dtype
# 
#     def __getattribute__(self, name):
#         if name in ('__class__', '__dir__', '__getitem__', '_vector', 'dtype'):
#             return object.__getattribute__(self, name)
#         return getattr(object.__getattribute__(self, '_vector'), name)
# 
#     def __dir__(self):
#         return sorted(set(dir(self._vector) + dir(MDVector)))
# 
#     def __getitem__(self, args):
#         return self._vector.__getitem__(args)

def MDVector(*args, **kwargs):
    dtype = None
    if len(args) > 0:
        try:
            dtype = str(args[0].dtype())
            if dtype == "int": dtype = "i"
        except AttributeError:
            pass
    dtype = kwargs.get("dtype", dtype)
    if dtype is None: dtype = "int64"
    if type(dtype) == str:
        dtype = numpy.dtype(dtype)
    if dtype.type is numpy.int32:
        result = MDVector_int(*args)
    elif dtype.type is numpy.int64:
        result = MDVector_long(*args)
#elif dtype.type is numpy.float32:
#    result = MDVector_float(*args)
    elif dtype.type is numpy.float64:
        result = MDVector_double(*args)
    else:
        raise TypeError("Unsupported or unrecognized dtype = %s" %
                        str(dtype))
    return result


# This file is compatible with both classic and new-style classes.


