# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Anasazi is the python interface to the Trilinos eigensolver
package Anasazi:

    http://trilinos.sandia.gov/packages/anasazi

Anasazi is a collection of eigensolver technologies.  The C++ version
makes liberal use of templates to abstract out the scalar type,
multivector type and operator type.  Currently, the python version
supports only an Epetra interface, so that the scalar type is float
(C++ double), the multivector type is Epetra.MultiVector and the
operator type is Epetra.Operator.  The following python factories
produce python wrappers to underlying C++ instances of the given C++
names with concrete Epetra implementations:

    * SortManager
    * BasicSort
    * Eigenproblem
    * BasicEigenproblem
    * StatusTest
    * StatusTestCombo
    * StatusTestMaxIters
    * StatusTestOutput
    * StatusTestResNorm
    * OrthoManager
    * MatOrthoManager
    * SVQBOrthoManager
    * Eigensolver
    * SolverManager
    * BlockDavidson
    * BlockDavidsonSolMgr
    * BlockKrylovSchur
    * BlockKrylovSchurSolMgr
    * LOBPCG
    * LOBPCGSolMgr
    * Eigensolution

For an example of usage of Anasazi to solve an eigenproblem, see the
following script in the example subdirectory of the PyTrilinos
package:

    * exAnasazi_BlockDavidson.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Anasazi')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Anasazi')
    _Anasazi = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Anasazi', [dirname(__file__)])
        except ImportError:
            import _Anasazi
            return _Anasazi
        try:
            _mod = imp.load_module('_Anasazi', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Anasazi = swig_import_helper()
    del swig_import_helper
else:
    import _Anasazi
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


HAVE_EPETRA_THYRA = _Anasazi.HAVE_EPETRA_THYRA
class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Anasazi.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Anasazi.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Anasazi.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Anasazi.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Anasazi.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Anasazi.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Anasazi.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Anasazi.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info

def Anasazi_Version(*args):
    """Anasazi_Version() -> std::string"""
    return _Anasazi.Anasazi_Version(*args)

__version__ = Anasazi_Version().split()[2]

class AnasaziError(_object):
    """


    An exception class parent to all Anasazi exceptions.

    C++ includes: AnasaziTypes.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AnasaziError, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AnasaziError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::AnasaziError self, std::string const & what_arg) -> AnasaziError

        Anasazi::AnasaziError::AnasaziError(const std::string &what_arg) 
        """
        this = _Anasazi.new_AnasaziError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_AnasaziError
AnasaziError_swigregister = _Anasazi.AnasaziError_swigregister
AnasaziError_swigregister(AnasaziError)

Converged = _Anasazi.Converged
Unconverged = _Anasazi.Unconverged
NO_CONJ = _Anasazi.NO_CONJ
CONJ = _Anasazi.CONJ
Passed = _Anasazi.Passed
Failed = _Anasazi.Failed
Undefined = _Anasazi.Undefined
RES_ORTH = _Anasazi.RES_ORTH
RES_2NORM = _Anasazi.RES_2NORM
RITZRES_2NORM = _Anasazi.RITZRES_2NORM
Errors = _Anasazi.Errors
Warnings = _Anasazi.Warnings
IterationDetails = _Anasazi.IterationDetails
OrthoDetails = _Anasazi.OrthoDetails
FinalSummary = _Anasazi.FinalSummary
TimingDetails = _Anasazi.TimingDetails
StatusTestDetails = _Anasazi.StatusTestDetails
Debug = _Anasazi.Debug
class ValueDouble(_object):
    """


    This struct is used for storing eigenvalues and Ritz values, as a pair
    of real values.

    C++ includes: AnasaziTypes.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ValueDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ValueDouble, name)
    __repr__ = _swig_repr
    __swig_setmethods__["realpart"] = _Anasazi.ValueDouble_realpart_set
    __swig_getmethods__["realpart"] = _Anasazi.ValueDouble_realpart_get
    if _newclass:
        realpart = _swig_property(_Anasazi.ValueDouble_realpart_get, _Anasazi.ValueDouble_realpart_set)
    __swig_setmethods__["imagpart"] = _Anasazi.ValueDouble_imagpart_set
    __swig_getmethods__["imagpart"] = _Anasazi.ValueDouble_imagpart_get
    if _newclass:
        imagpart = _swig_property(_Anasazi.ValueDouble_imagpart_get, _Anasazi.ValueDouble_imagpart_set)

    def set(self, *args):
        """
        set(ValueDouble self, Teuchos::ScalarTraits< double >::magnitudeType const & rp, Teuchos::ScalarTraits< double >::magnitudeType const & ip)

        void Anasazi::Value<
        ScalarType >::set(const typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType &rp, const typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType &ip) 
        """
        return _Anasazi.ValueDouble_set(self, *args)


    def __str__(self, *args):
        """__str__(ValueDouble self) -> std::string"""
        return _Anasazi.ValueDouble___str__(self, *args)


    def __init__(self, *args):
        """__init__(Anasazi::Value<(double)> self) -> ValueDouble"""
        this = _Anasazi.new_ValueDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_ValueDouble
ValueDouble_swigregister = _Anasazi.ValueDouble_swigregister
ValueDouble_swigregister(ValueDouble)

class OutputManagerDouble(_object):
    """


    Output managers remove the need for the eigensolver to know any
    information about the required output. Calling isVerbosity( MsgType
    type ) informs the solver if it is supposed to output the information
    corresponding to the message type.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziOutputManager.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutputManagerDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OutputManagerDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_OutputManagerDouble

    def setVerbosity(self, *args):
        """
        setVerbosity(OutputManagerDouble self, int vb)

        virtual
        void Anasazi::OutputManager< ScalarType >::setVerbosity(int vb)

        Set the message output types for this manager. 
        """
        return _Anasazi.OutputManagerDouble_setVerbosity(self, *args)


    def getVerbosity(self, *args):
        """
        getVerbosity(OutputManagerDouble self) -> int

        virtual
        int Anasazi::OutputManager< ScalarType >::getVerbosity() const

        Get the message output types for this manager. 
        """
        return _Anasazi.OutputManagerDouble_getVerbosity(self, *args)


    def isVerbosity(self, *args):
        """
        isVerbosity(OutputManagerDouble self, Anasazi::MsgType type) -> bool

        virtual
        bool Anasazi::OutputManager< ScalarType >::isVerbosity(MsgType type)
        const =0

        Find out whether we need to print out information for this message
        type.

        This method is used by the solver to determine whether computations
        are necessary for this message type. 
        """
        return _Anasazi.OutputManagerDouble_isVerbosity(self, *args)


    def stream(self, *args):
        """
        stream(OutputManagerDouble self, Anasazi::MsgType type) -> std::ostream &

        virtual
        std::ostream& Anasazi::OutputManager< ScalarType >::stream(MsgType
        type)=0

        Create a stream for outputting to. 
        """
        return _Anasazi.OutputManagerDouble_stream(self, *args)

OutputManagerDouble_swigregister = _Anasazi.OutputManagerDouble_swigregister
OutputManagerDouble_swigregister(OutputManagerDouble)

class BasicOutputManagerDouble(OutputManagerDouble):
    """


    Anasazi's basic output manager for sending information of select
    verbosity levels to the appropriate output stream.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziBasicOutputManager.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [OutputManagerDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicOutputManagerDouble, name, value)
    __swig_getmethods__ = {}
    for _s in [OutputManagerDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicOutputManagerDouble, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BasicOutputManager<(double)> self, int vb, Teuchos::RCP< Anasazi::ostream > os, int printingRank=0) -> BasicOutputManagerDouble

        Anasazi::BasicOutputManager< ScalarType >::BasicOutputManager(int
        vb=Anasazi::Errors, Teuchos::RCP< ostream >
        os=Teuchos::rcpFromRef(std::cout), int printingRank=0)

        Default constructor. 
        """
        this = _Anasazi.new_BasicOutputManagerDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicOutputManagerDouble

    def setOStream(self, *args):
        """
        setOStream(BasicOutputManagerDouble self, Teuchos::RCP< Anasazi::ostream > os)

        void
        Anasazi::BasicOutputManager< ScalarType >::setOStream(Teuchos::RCP<
        ostream > os)

        Set the output stream for this manager. 
        """
        return _Anasazi.BasicOutputManagerDouble_setOStream(self, *args)


    def getOStream(self, *args):
        """
        getOStream(BasicOutputManagerDouble self) -> Teuchos::RCP< Anasazi::ostream >

        Teuchos::RCP< ostream > Anasazi::BasicOutputManager< ScalarType
        >::getOStream()

        Get the output stream for this manager. 
        """
        return _Anasazi.BasicOutputManagerDouble_getOStream(self, *args)


    def isVerbosity(self, *args):
        """
        isVerbosity(BasicOutputManagerDouble self, Anasazi::MsgType type) -> bool

        bool
        Anasazi::BasicOutputManager< ScalarType >::isVerbosity(MsgType type)
        const

        Find out whether we need to print out information for this message
        type.

        This method is used by the solver to determine whether computations
        are necessary for this message type. 
        """
        return _Anasazi.BasicOutputManagerDouble_isVerbosity(self, *args)


    def stream(self, *args):
        """
        stream(BasicOutputManagerDouble self, Anasazi::MsgType type) -> Anasazi::ostream &

        ostream &
        Anasazi::BasicOutputManager< ScalarType >::stream(MsgType type)

        Return a stream for outputting to. 
        """
        return _Anasazi.BasicOutputManagerDouble_stream(self, *args)

BasicOutputManagerDouble_swigregister = _Anasazi.BasicOutputManagerDouble_swigregister
BasicOutputManagerDouble_swigregister(BasicOutputManagerDouble)

class SortManagerError(AnasaziError):
    """


    SortManagerError is thrown when the Anasazi::SortManager is unable to
    sort the numbers, due to some failure of the sort method or error in
    calling it.

    C++ includes: AnasaziSortManager.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SortManagerError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SortManagerError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::SortManagerError self, std::string const & what_arg) -> SortManagerError

        Anasazi::SortManagerError::SortManagerError(const std::string
        &what_arg) 
        """
        this = _Anasazi.new_SortManagerError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_SortManagerError
SortManagerError_swigregister = _Anasazi.SortManagerError_swigregister
SortManagerError_swigregister(SortManagerError)

class MultiVecDouble(_object):
    """


    Interface for multivectors used by Anasazi's linear solvers.

    Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    Parameters:
    -----------

    ScalarType:  The type of entries of the multivector.

    Anasazi accesses multivectors through a traits interface called
    MultiVecTraits. If you want to use Anasazi with your own multivector
    class MV, you may either specialize MultiVecTraits for MV, or you may
    wrap MV in your own class that implements MultiVec. Specializing
    MultiVecTraits works via compile-time polymorphism, whereas
    implementing the MultiVec interface works via run-time polymorphism.
    You may pick whichever option you like. However, specializing
    MultiVecTraits is the preferred method. This is because Anasazi's
    linear solvers always use a specialization of MultiVecTraits to access
    multivector operations. They only use MultiVec through a
    specialization of the MultiVecTraits traits class, which is
    implemented below in this header file.

    If you want your multivector class (or a wrapper thereof) to implement
    the MultiVec interface, you should inherit from MultiVec<ScalarType>,
    where ScalarType is the type of entries in the multivector. For
    example, a multivector with entries of type double would inherit from
    MultiVec<double>.

    C++ includes: AnasaziMultiVec.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVecDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVecDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_MultiVecDouble

    def Clone(self, *args):
        """
        Clone(MultiVecDouble self, int const numvecs) -> MultiVecDouble

        virtual
        MultiVec<ScalarType>* Anasazi::MultiVec< ScalarType >::Clone(const int
        numvecs) const =0

        Create a new MultiVec with numvecs columns.

        Pointer to the new multivector with uninitialized values. 
        """
        return _Anasazi.MultiVecDouble_Clone(self, *args)


    def CloneCopy(self, *args):
        """
        CloneCopy(MultiVecDouble self) -> MultiVecDouble
        CloneCopy(MultiVecDouble self, VectorInt index) -> MultiVecDouble

        virtual
        MultiVec<ScalarType>* Anasazi::MultiVec< ScalarType >::CloneCopy(const
        std::vector< int > &index) const =0

        Creates a new Anasazi::MultiVec and copies the selected contents of
        *this into the new vector (deep copy). The copied vectors from *this
        are indicated by the index.size() indices in index.

        Pointer to the new multivector 
        """
        return _Anasazi.MultiVecDouble_CloneCopy(self, *args)


    def CloneViewNonConst(self, *args):
        """
        CloneViewNonConst(MultiVecDouble self, VectorInt index) -> MultiVecDouble

        virtual
        MultiVec<ScalarType>* Anasazi::MultiVec< ScalarType
        >::CloneViewNonConst(const std::vector< int > &index)=0

        Creates a new Anasazi::MultiVec that shares the selected contents of
        *this. The index of the numvecs vectors shallow copied from *this are
        indicated by the indices given in index.

        Pointer to the new multivector 
        """
        return _Anasazi.MultiVecDouble_CloneViewNonConst(self, *args)


    def CloneView(self, *args):
        """
        CloneView(MultiVecDouble self, VectorInt index) -> MultiVecDouble

        virtual const
        MultiVec<ScalarType>* Anasazi::MultiVec< ScalarType >::CloneView(const
        std::vector< int > &index) const =0

        Creates a new Anasazi::MultiVec that shares the selected contents of
        *this. The index of the numvecs vectors shallow copied from *this are
        indicated by the indices given in index.

        Pointer to the new multivector 
        """
        return _Anasazi.MultiVecDouble_CloneView(self, *args)


    def GetGlobalLength(self, *args):
        """
        GetGlobalLength(MultiVecDouble self) -> ptrdiff_t

        virtual
        ptrdiff_t Anasazi::MultiVec< ScalarType >::GetGlobalLength() const =0

        The number of rows in the multivector. 
        """
        return _Anasazi.MultiVecDouble_GetGlobalLength(self, *args)


    def GetNumberVecs(self, *args):
        """
        GetNumberVecs(MultiVecDouble self) -> int

        virtual int
        Anasazi::MultiVec< ScalarType >::GetNumberVecs() const =0

        The number of vectors (i.e., columns) in the multivector. 
        """
        return _Anasazi.MultiVecDouble_GetNumberVecs(self, *args)


    def MvTimesMatAddMv(self, *args):
        """
        MvTimesMatAddMv(MultiVecDouble self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta)

        virtual
        void Anasazi::MultiVec< ScalarType >::MvTimesMatAddMv(ScalarType
        alpha, const MultiVec< ScalarType > &A, const
        Teuchos::SerialDenseMatrix< int, ScalarType > &B, ScalarType beta)=0

        Update *this with alpha * A * B + beta * ( *this). 
        """
        return _Anasazi.MultiVecDouble_MvTimesMatAddMv(self, *args)


    def MvAddMv(self, *args):
        """
        MvAddMv(MultiVecDouble self, double alpha, MultiVecDouble A, double beta, MultiVecDouble B)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvAddMv(ScalarType alpha, const
        MultiVec< ScalarType > &A, ScalarType beta, const MultiVec< ScalarType
        > &B)=0

        Replace *this with alpha * A + beta * B. 
        """
        return _Anasazi.MultiVecDouble_MvAddMv(self, *args)


    def MvScale(self, *args):
        """
        MvScale(MultiVecDouble self, double alpha)
        MvScale(MultiVecDouble self, std::vector< double,std::allocator< double > > const & alpha)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvScale(const std::vector< ScalarType
        > &alpha)=0

        Scale each element of the i-th vector in *this with alpha[i]. 
        """
        return _Anasazi.MultiVecDouble_MvScale(self, *args)


    def MvTransMv(self, *args):
        """
        MvTransMv(MultiVecDouble self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > & B)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvTransMv(ScalarType alpha, const
        MultiVec< ScalarType > &A, Teuchos::SerialDenseMatrix< int, ScalarType
        > &B) const =0

        Compute a dense matrix B through the matrix-matrix multiply alpha *
        A^T * ( *this). 
        """
        return _Anasazi.MultiVecDouble_MvTransMv(self, *args)


    def MvDot(self, *args):
        """
        MvDot(MultiVecDouble self, MultiVecDouble A, std::vector< double,std::allocator< double > > & b)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvDot(const MultiVec< ScalarType >
        &A, std::vector< ScalarType > &b) const =0

        Compute the dot product of each column of *this with the corresponding
        column of A.

        Compute a vector b whose entries are the individual dot-products. That
        is, b[i] = A[i]^H * (*this)[i] where A[i] is the i-th column of A. 
        """
        return _Anasazi.MultiVecDouble_MvDot(self, *args)


    def MvNorm(self, *args):
        """
        MvNorm(MultiVecDouble self, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvNorm(std::vector< typename
        Teuchos::ScalarTraits< ScalarType >::magnitudeType > &normvec) const
        =0

        Compute the 2-norm of each vector in *this.

        Parameters:
        -----------

        normvec:  [out] On output, normvec[i] holds the 2-norm of the i-th
        vector of *this. 
        """
        return _Anasazi.MultiVecDouble_MvNorm(self, *args)


    def SetBlock(self, *args):
        """
        SetBlock(MultiVecDouble self, MultiVecDouble A, VectorInt index)

        virtual void
        Anasazi::MultiVec< ScalarType >::SetBlock(const MultiVec< ScalarType >
        &A, const std::vector< int > &index)=0

        Copy the vectors in A to a set of vectors in *this.

        The numvecs vectors in A are copied to a subset of vectors in *this
        indicated by the indices given in index. 
        """
        return _Anasazi.MultiVecDouble_SetBlock(self, *args)


    def MvRandom(self, *args):
        """
        MvRandom(MultiVecDouble self)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvRandom()=0

        Fill all the vectors in *this with random numbers. 
        """
        return _Anasazi.MultiVecDouble_MvRandom(self, *args)


    def MvInit(self, *args):
        """
        MvInit(MultiVecDouble self, double alpha)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvInit(ScalarType alpha)=0

        Replace each element of the vectors in *this with alpha. 
        """
        return _Anasazi.MultiVecDouble_MvInit(self, *args)


    def MvPrint(self, *args):
        """
        MvPrint(MultiVecDouble self, std::ostream & os)

        virtual void
        Anasazi::MultiVec< ScalarType >::MvPrint(std::ostream &os) const =0

        Print *this multivector to the os output stream. 
        """
        return _Anasazi.MultiVecDouble_MvPrint(self, *args)

MultiVecDouble_swigregister = _Anasazi.MultiVecDouble_swigregister
MultiVecDouble_swigregister(MultiVecDouble)

class OperatorError(AnasaziError):
    """


    Exceptions thrown to signal error in operator application.

    C++ includes: AnasaziOperatorTraits.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperatorError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OperatorError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::OperatorError self, std::string const & what_arg) -> OperatorError

        Anasazi::OperatorError::OperatorError(const std::string &what_arg) 
        """
        this = _Anasazi.new_OperatorError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_OperatorError
OperatorError_swigregister = _Anasazi.OperatorError_swigregister
OperatorError_swigregister(OperatorError)

class OperatorDouble(_object):
    """


    Anasazi's templated virtual class for constructing an operator that
    can interface with the OperatorTraits class used by the eigensolvers.

    A concrete implementation of this class is necessary. The user can
    create their own implementation if those supplied are not suitable for
    their needs.

    Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziOperator.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperatorDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OperatorDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_OperatorDouble

    def Apply(self, *args):
        """
        Apply(OperatorDouble self, MultiVecDouble x, MultiVecDouble y)

        virtual void
        Anasazi::Operator< ScalarType >::Apply(const MultiVec< ScalarType >
        &x, MultiVec< ScalarType > &y) const =0

        This method takes the Anasazi::MultiVec x and applies the operator to
        it resulting in the Anasazi::MultiVec y. 
        """
        return _Anasazi.OperatorDouble_Apply(self, *args)

OperatorDouble_swigregister = _Anasazi.OperatorDouble_swigregister
OperatorDouble_swigregister(OperatorDouble)

class StatusTestError(AnasaziError):
    """


    Exception thrown to signal error in a status test during
    Anasazi::StatusTest::checkStatus().

    C++ includes: AnasaziStatusTest.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::StatusTestError self, std::string const & what_arg) -> StatusTestError

        Anasazi::StatusTestError::StatusTestError(const std::string &what_arg)

        """
        this = _Anasazi.new_StatusTestError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestError
StatusTestError_swigregister = _Anasazi.StatusTestError_swigregister
StatusTestError_swigregister(StatusTestError)

class ResNormNaNError(AnasaziError):
    """


    ResNormNaNError is thrown from StatusTestResNorm::checkStatus() when a
    NaN ("not a number") is detected among the residual norms returned
    by the eigensolver.

    This behavior is optional and is controlled by flag to
    StatusTestResNorm::StatusTestResNorm().

    C++ includes: AnasaziStatusTestResNorm.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResNormNaNError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResNormNaNError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::ResNormNaNError self, std::string const & what_arg) -> ResNormNaNError

        Anasazi::ResNormNaNError::ResNormNaNError(const std::string &what_arg)

        """
        this = _Anasazi.new_ResNormNaNError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_ResNormNaNError
ResNormNaNError_swigregister = _Anasazi.ResNormNaNError_swigregister
ResNormNaNError_swigregister(ResNormNaNError)

class OrthoError(AnasaziError):
    """


    Exception thrown to signal error in an orthogonalization manager
    method.

    C++ includes: AnasaziOrthoManager.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthoError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthoError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::OrthoError self, std::string const & what_arg) -> OrthoError

        Anasazi::OrthoError::OrthoError(const std::string &what_arg) 
        """
        this = _Anasazi.new_OrthoError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_OrthoError
OrthoError_swigregister = _Anasazi.OrthoError_swigregister
OrthoError_swigregister(OrthoError)

class BlockDavidsonInitFailure(AnasaziError):
    """


    BlockDavidsonInitFailure is thrown when the BlockDavidson solver is
    unable to generate an initial iterate in the
    BlockDavidson::initialize() routine.

    This exception is thrown from the BlockDavidson::initialize() method,
    which is called by the user or from the BlockDavidson::iterate()
    method if isInitialized() == false.

    In the case that this exception is thrown,
    BlockDavidson::isInitialized() will be false and the user will need to
    provide a new initial iterate to the solver.

    C++ includes: AnasaziBlockDavidson.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonInitFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonInitFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockDavidsonInitFailure self, std::string const & what_arg) -> BlockDavidsonInitFailure

        Anasazi::BlockDavidsonInitFailure::BlockDavidsonInitFailure(const
        std::string &what_arg) 
        """
        this = _Anasazi.new_BlockDavidsonInitFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonInitFailure
BlockDavidsonInitFailure_swigregister = _Anasazi.BlockDavidsonInitFailure_swigregister
BlockDavidsonInitFailure_swigregister(BlockDavidsonInitFailure)

class BlockDavidsonOrthoFailure(AnasaziError):
    """


    BlockDavidsonOrthoFailure is thrown when the orthogonalization manager
    is unable to orthogonalize the preconditioned residual against (a.k.a.
    H) the current basis (a.k.a. V).

    This exception is thrown from the BlockDavidson::iterate() method.

    C++ includes: AnasaziBlockDavidson.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonOrthoFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonOrthoFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockDavidsonOrthoFailure self, std::string const & what_arg) -> BlockDavidsonOrthoFailure

        Anasazi::BlockDavidsonOrthoFailure::BlockDavidsonOrthoFailure(const
        std::string &what_arg) 
        """
        this = _Anasazi.new_BlockDavidsonOrthoFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonOrthoFailure
BlockDavidsonOrthoFailure_swigregister = _Anasazi.BlockDavidsonOrthoFailure_swigregister
BlockDavidsonOrthoFailure_swigregister(BlockDavidsonOrthoFailure)

class BlockKrylovSchurInitFailure(AnasaziError):
    """


    BlockKrylovSchurInitFailure is thrown when the BlockKrylovSchur solver
    is unable to generate an initial iterate in the
    BlockKrylovSchur::initialize() routine.

    This exception is thrown from the BlockKrylovSchur::initialize()
    method, which is called by the user or from the
    BlockKrylovSchur::iterate() method if isInitialized() == false.

    In the case that this exception is thrown,
    BlockKrylovSchur::isInitialized() will be false and the user will need
    to provide a new initial iterate to the solver.

    C++ includes: AnasaziBlockKrylovSchur.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurInitFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurInitFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockKrylovSchurInitFailure self, std::string const & what_arg) -> BlockKrylovSchurInitFailure

        Anasazi::BlockKrylovSchurInitFailure::BlockKrylovSchurInitFailure(const
        std::string &what_arg) 
        """
        this = _Anasazi.new_BlockKrylovSchurInitFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurInitFailure
BlockKrylovSchurInitFailure_swigregister = _Anasazi.BlockKrylovSchurInitFailure_swigregister
BlockKrylovSchurInitFailure_swigregister(BlockKrylovSchurInitFailure)

class BlockKrylovSchurOrthoFailure(AnasaziError):
    """


    BlockKrylovSchurOrthoFailure is thrown when the orthogonalization
    manager is unable to generate orthonormal columns from the new basis
    vectors.

    This exception is thrown from the BlockKrylovSchur::iterate() method.

    C++ includes: AnasaziBlockKrylovSchur.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurOrthoFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurOrthoFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockKrylovSchurOrthoFailure self, std::string const & what_arg) -> BlockKrylovSchurOrthoFailure

        Anasazi::BlockKrylovSchurOrthoFailure::BlockKrylovSchurOrthoFailure(const
        std::string &what_arg) 
        """
        this = _Anasazi.new_BlockKrylovSchurOrthoFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurOrthoFailure
BlockKrylovSchurOrthoFailure_swigregister = _Anasazi.BlockKrylovSchurOrthoFailure_swigregister
BlockKrylovSchurOrthoFailure_swigregister(BlockKrylovSchurOrthoFailure)

class LOBPCGRitzFailure(AnasaziError):
    """


    LOBPCGRitzFailure is thrown when the LOBPCG solver is unable to
    continue a call to LOBPCG::iterate() due to a failure of the
    algorithm.

    This signals that the Rayleigh-Ritz analysis over the subspace
    colsp([X H P]) detected ill-conditioning of the projected mass matrix
    and the inability to generate a set of orthogonal eigenvectors for the
    projected problem.

    This exception is only thrown from the LOBPCG::iterate() routine.
    After catching this exception, the user can recover the subspace via
    LOBPCG::getState(). This information can be used to restart the
    solver.

    C++ includes: AnasaziLOBPCG.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGRitzFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGRitzFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::LOBPCGRitzFailure self, std::string const & what_arg) -> LOBPCGRitzFailure

        Anasazi::LOBPCGRitzFailure::LOBPCGRitzFailure(const std::string
        &what_arg) 
        """
        this = _Anasazi.new_LOBPCGRitzFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGRitzFailure
LOBPCGRitzFailure_swigregister = _Anasazi.LOBPCGRitzFailure_swigregister
LOBPCGRitzFailure_swigregister(LOBPCGRitzFailure)

class LOBPCGInitFailure(AnasaziError):
    """


    LOBPCGInitFailure is thrown when the LOBPCG solver is unable to
    generate an initial iterate in the LOBPCG::initialize() routine.

    This exception is thrown from the LOBPCG::initialize() method, which
    is called by the user or from the LOBPCG::iterate() method when
    isInitialized() == false.

    In the case that this exception is thrown, LOBPCG::hasP() and
    LOBPCG::isInitialized() will be false and the user will need to
    provide a new initial iterate to the solver.

    C++ includes: AnasaziLOBPCG.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGInitFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGInitFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::LOBPCGInitFailure self, std::string const & what_arg) -> LOBPCGInitFailure

        Anasazi::LOBPCGInitFailure::LOBPCGInitFailure(const std::string
        &what_arg) 
        """
        this = _Anasazi.new_LOBPCGInitFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGInitFailure
LOBPCGInitFailure_swigregister = _Anasazi.LOBPCGInitFailure_swigregister
LOBPCGInitFailure_swigregister(LOBPCGInitFailure)

class LOBPCGOrthoFailure(AnasaziError):
    """


    LOBPCGOrthoFailure is thrown when an orthogonalization attempt fails.

    This is thrown in one of two scenarstd::ios. After preconditioning the
    residual, the orthogonalization manager is asked to orthogonalize the
    preconditioned residual (H) against the auxiliary vectors. If full
    orthogonalization is enabled, H is also orthogonalized against X and P
    and normalized.

    The second scenario involves the generation of new X and P from the
    basis [X H P]. When full orthogonalization is enabled, an attempt is
    made to select coefficients for X and P so that they will be mutually
    orthogonal and orthonormal.

    If either of these attempts fail, the solver throws an
    LOBPCGOrthoFailure exception.

    C++ includes: AnasaziLOBPCG.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGOrthoFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGOrthoFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::LOBPCGOrthoFailure self, std::string const & what_arg) -> LOBPCGOrthoFailure

        Anasazi::LOBPCGOrthoFailure::LOBPCGOrthoFailure(const std::string
        &what_arg) 
        """
        this = _Anasazi.new_LOBPCGOrthoFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGOrthoFailure
LOBPCGOrthoFailure_swigregister = _Anasazi.LOBPCGOrthoFailure_swigregister
LOBPCGOrthoFailure_swigregister(LOBPCGOrthoFailure)

class EpetraMultiVecFailure(AnasaziError):
    """Proxy of C++ Anasazi::EpetraMultiVecFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraMultiVecFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraMultiVecFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraMultiVecFailure self, std::string const & what_arg) -> EpetraMultiVecFailure"""
        this = _Anasazi.new_EpetraMultiVecFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraMultiVecFailure
EpetraMultiVecFailure_swigregister = _Anasazi.EpetraMultiVecFailure_swigregister
EpetraMultiVecFailure_swigregister(EpetraMultiVecFailure)

class EpetraOpFailure(AnasaziError):
    """Proxy of C++ Anasazi::EpetraOpFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraOpFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraOpFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraOpFailure self, std::string const & what_arg) -> EpetraOpFailure"""
        this = _Anasazi.new_EpetraOpFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraOpFailure
EpetraOpFailure_swigregister = _Anasazi.EpetraOpFailure_swigregister
EpetraOpFailure_swigregister(EpetraOpFailure)

class EpetraMultiVecAccessor(_object):
    """Proxy of C++ Anasazi::EpetraMultiVecAccessor class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraMultiVecAccessor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraMultiVecAccessor, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_EpetraMultiVecAccessor

    def GetEpetraMultiVec(self, *args):
        """
        GetEpetraMultiVec(EpetraMultiVecAccessor self) -> MultiVector
        GetEpetraMultiVec(EpetraMultiVecAccessor self) -> MultiVector
        """
        return _Anasazi.EpetraMultiVecAccessor_GetEpetraMultiVec(self, *args)


    def __init__(self, *args):
        """__init__(Anasazi::EpetraMultiVecAccessor self) -> EpetraMultiVecAccessor"""
        this = _Anasazi.new_EpetraMultiVecAccessor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
EpetraMultiVecAccessor_swigregister = _Anasazi.EpetraMultiVecAccessor_swigregister
EpetraMultiVecAccessor_swigregister(EpetraMultiVecAccessor)

class EpetraMultiVec(MultiVecDouble, Epetra.MultiVector, EpetraMultiVecAccessor):
    """Proxy of C++ Anasazi::EpetraMultiVec class."""

    __swig_setmethods__ = {}
    for _s in [MultiVecDouble, Epetra.MultiVector, EpetraMultiVecAccessor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraMultiVec, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVecDouble, Epetra.MultiVector, EpetraMultiVecAccessor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraMultiVec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::EpetraMultiVec self, BlockMap Map_in, int const numvecs) -> EpetraMultiVec
        __init__(Anasazi::EpetraMultiVec self, MultiVector P_vec) -> EpetraMultiVec
        __init__(Anasazi::EpetraMultiVec self, BlockMap Map_in, double * array, int const numvecs, int const stride=0) -> EpetraMultiVec
        __init__(Anasazi::EpetraMultiVec self, Epetra_DataAccess CV, MultiVector P_vec, VectorInt index) -> EpetraMultiVec
        """
        this = _Anasazi.new_EpetraMultiVec(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraMultiVec

    def Clone(self, *args):
        """Clone(EpetraMultiVec self, int const numvecs) -> MultiVecDouble"""
        return _Anasazi.EpetraMultiVec_Clone(self, *args)


    def CloneCopy(self, *args):
        """
        CloneCopy(EpetraMultiVec self) -> MultiVecDouble
        CloneCopy(EpetraMultiVec self, VectorInt index) -> MultiVecDouble
        """
        return _Anasazi.EpetraMultiVec_CloneCopy(self, *args)


    def CloneViewNonConst(self, *args):
        """CloneViewNonConst(EpetraMultiVec self, VectorInt index) -> MultiVecDouble"""
        return _Anasazi.EpetraMultiVec_CloneViewNonConst(self, *args)


    def CloneView(self, *args):
        """CloneView(EpetraMultiVec self, VectorInt index) -> MultiVecDouble"""
        return _Anasazi.EpetraMultiVec_CloneView(self, *args)


    def GetGlobalLength(self, *args):
        """GetGlobalLength(EpetraMultiVec self) -> ptrdiff_t"""
        return _Anasazi.EpetraMultiVec_GetGlobalLength(self, *args)


    def GetNumberVecs(self, *args):
        """GetNumberVecs(EpetraMultiVec self) -> int"""
        return _Anasazi.EpetraMultiVec_GetNumberVecs(self, *args)


    def MvTimesMatAddMv(self, *args):
        """MvTimesMatAddMv(EpetraMultiVec self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta)"""
        return _Anasazi.EpetraMultiVec_MvTimesMatAddMv(self, *args)


    def MvAddMv(self, *args):
        """MvAddMv(EpetraMultiVec self, double alpha, MultiVecDouble A, double beta, MultiVecDouble B)"""
        return _Anasazi.EpetraMultiVec_MvAddMv(self, *args)


    def MvTransMv(self, *args):
        """MvTransMv(EpetraMultiVec self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > & B)"""
        return _Anasazi.EpetraMultiVec_MvTransMv(self, *args)


    def MvDot(self, *args):
        """MvDot(EpetraMultiVec self, MultiVecDouble A, std::vector< double,std::allocator< double > > & b)"""
        return _Anasazi.EpetraMultiVec_MvDot(self, *args)


    def MvScale(self, *args):
        """
        MvScale(EpetraMultiVec self, double alpha)
        MvScale(EpetraMultiVec self, std::vector< double,std::allocator< double > > const & alpha)
        """
        return _Anasazi.EpetraMultiVec_MvScale(self, *args)


    def MvNorm(self, *args):
        """MvNorm(EpetraMultiVec self, std::vector< double,std::allocator< double > > & normvec)"""
        return _Anasazi.EpetraMultiVec_MvNorm(self, *args)


    def SetBlock(self, *args):
        """SetBlock(EpetraMultiVec self, MultiVecDouble A, VectorInt index)"""
        return _Anasazi.EpetraMultiVec_SetBlock(self, *args)


    def MvRandom(self, *args):
        """MvRandom(EpetraMultiVec self)"""
        return _Anasazi.EpetraMultiVec_MvRandom(self, *args)


    def MvInit(self, *args):
        """MvInit(EpetraMultiVec self, double alpha)"""
        return _Anasazi.EpetraMultiVec_MvInit(self, *args)


    def GetEpetraMultiVec(self, *args):
        """
        GetEpetraMultiVec(EpetraMultiVec self) -> MultiVector
        GetEpetraMultiVec(EpetraMultiVec self) -> MultiVector
        """
        return _Anasazi.EpetraMultiVec_GetEpetraMultiVec(self, *args)


    def MvPrint(self, *args):
        """MvPrint(EpetraMultiVec self, std::ostream & os)"""
        return _Anasazi.EpetraMultiVec_MvPrint(self, *args)

EpetraMultiVec_swigregister = _Anasazi.EpetraMultiVec_swigregister
EpetraMultiVec_swigregister(EpetraMultiVec)

class EpetraOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraOp self, Teuchos::RCP< Epetra_Operator > const & Op) -> EpetraOp"""
        this = _Anasazi.new_EpetraOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraOp

    def Apply(self, *args):
        """Apply(EpetraOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraOp_Apply(self, *args)

EpetraOp_swigregister = _Anasazi.EpetraOp_swigregister
EpetraOp_swigregister(EpetraOp)

class EpetraGenOp(OperatorDouble, Epetra.Operator):
    """Proxy of C++ Anasazi::EpetraGenOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble, Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraGenOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble, Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraGenOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraGenOp self, Teuchos::RCP< Epetra_Operator > const & AOp, Teuchos::RCP< Epetra_Operator > const & MOp, bool isAInverse=True) -> EpetraGenOp"""
        this = _Anasazi.new_EpetraGenOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraGenOp

    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.


        virtual int
        Epetra_Operator::Apply(const Epetra_MultiVector &X, Epetra_MultiVector
        &Y) const =0

        Returns the result of a Epetra_Operator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Anasazi.EpetraGenOp_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.


        virtual int
        Epetra_Operator::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const =0

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        WARNING:  In order to work with AztecOO, any implementation of this
        method must support the case where X and Y are the same object. 
        """
        return _Anasazi.EpetraGenOp_ApplyInverse(self, *args)


    def Label(self, *args):
        """
        Label(EpetraGenOp self) -> char const *

        virtual const char*
        Epetra_Operator::Label() const =0

        Returns a character string describing the operator. 
        """
        return _Anasazi.EpetraGenOp_Label(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(EpetraGenOp self) -> bool

        virtual bool
        Epetra_Operator::UseTranspose() const =0

        Returns the current UseTranspose setting. 
        """
        return _Anasazi.EpetraGenOp_UseTranspose(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(EpetraGenOp self, bool arg2) -> int

        virtual int
        Epetra_Operator::SetUseTranspose(bool UseTranspose)=0

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Anasazi.EpetraGenOp_SetUseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(EpetraGenOp self) -> bool

        virtual bool
        Epetra_Operator::HasNormInf() const =0

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Anasazi.EpetraGenOp_HasNormInf(self, *args)


    def NormInf(self, *args):
        """
        NormInf(EpetraGenOp self) -> double

        virtual double
        Epetra_Operator::NormInf() const =0

        Returns the infinity norm of the global matrix. 
        """
        return _Anasazi.EpetraGenOp_NormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(EpetraGenOp self) -> Comm

        virtual const
        Epetra_Comm& Epetra_Operator::Comm() const =0

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Anasazi.EpetraGenOp_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(EpetraGenOp self) -> Map

        virtual
        const Epetra_Map& Epetra_Operator::OperatorDomainMap() const =0

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _Anasazi.EpetraGenOp_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(EpetraGenOp self) -> Map

        virtual
        const Epetra_Map& Epetra_Operator::OperatorRangeMap() const =0

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _Anasazi.EpetraGenOp_OperatorRangeMap(self, *args)

EpetraGenOp_swigregister = _Anasazi.EpetraGenOp_swigregister
EpetraGenOp_swigregister(EpetraGenOp)

class EpetraSymOp(OperatorDouble, Epetra.Operator):
    """Proxy of C++ Anasazi::EpetraSymOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble, Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraSymOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble, Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraSymOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraSymOp self, Teuchos::RCP< Epetra_Operator > const & Op, bool isTrans=False) -> EpetraSymOp"""
        this = _Anasazi.new_EpetraSymOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraSymOp

    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.


        virtual int
        Epetra_Operator::Apply(const Epetra_MultiVector &X, Epetra_MultiVector
        &Y) const =0

        Returns the result of a Epetra_Operator applied to a
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to multiply with
        matrix.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful. 
        """
        return _Anasazi.EpetraSymOp_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.


        virtual int
        Epetra_Operator::ApplyInverse(const Epetra_MultiVector &X,
        Epetra_MultiVector &Y) const =0

        Returns the result of a Epetra_Operator inverse applied to an
        Epetra_MultiVector X in Y.

        Parameters:
        -----------

        In:  X - A Epetra_MultiVector of dimension NumVectors to solve for.

        Out:  Y -A Epetra_MultiVector of dimension NumVectors containing
        result.

        Integer error code, set to 0 if successful.

        WARNING:  In order to work with AztecOO, any implementation of this
        method must support the case where X and Y are the same object. 
        """
        return _Anasazi.EpetraSymOp_ApplyInverse(self, *args)


    def Label(self, *args):
        """
        Label(EpetraSymOp self) -> char const *

        virtual const char*
        Epetra_Operator::Label() const =0

        Returns a character string describing the operator. 
        """
        return _Anasazi.EpetraSymOp_Label(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(EpetraSymOp self) -> bool

        virtual bool
        Epetra_Operator::UseTranspose() const =0

        Returns the current UseTranspose setting. 
        """
        return _Anasazi.EpetraSymOp_UseTranspose(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(EpetraSymOp self, bool arg2) -> int

        virtual int
        Epetra_Operator::SetUseTranspose(bool UseTranspose)=0

        If set true, transpose of this operator will be applied.

        This flag allows the transpose of the given operator to be used
        implicitly. Setting this flag affects only the Apply() and
        ApplyInverse() methods. If the implementation of this interface does
        not support transpose use, this method should return a value of -1.

        Parameters:
        -----------

        In:  UseTranspose -If true, multiply by the transpose of operator,
        otherwise just use operator.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Anasazi.EpetraSymOp_SetUseTranspose(self, *args)


    def HasNormInf(self, *args):
        """
        HasNormInf(EpetraSymOp self) -> bool

        virtual bool
        Epetra_Operator::HasNormInf() const =0

        Returns true if the this object can provide an approximate Inf-norm,
        false otherwise. 
        """
        return _Anasazi.EpetraSymOp_HasNormInf(self, *args)


    def NormInf(self, *args):
        """
        NormInf(EpetraSymOp self) -> double

        virtual double
        Epetra_Operator::NormInf() const =0

        Returns the infinity norm of the global matrix. 
        """
        return _Anasazi.EpetraSymOp_NormInf(self, *args)


    def Comm(self, *args):
        """
        Comm(EpetraSymOp self) -> Comm

        virtual const
        Epetra_Comm& Epetra_Operator::Comm() const =0

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Anasazi.EpetraSymOp_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """
        OperatorDomainMap(EpetraSymOp self) -> Map

        virtual
        const Epetra_Map& Epetra_Operator::OperatorDomainMap() const =0

        Returns the Epetra_Map object associated with the domain of this
        operator. 
        """
        return _Anasazi.EpetraSymOp_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """
        OperatorRangeMap(EpetraSymOp self) -> Map

        virtual
        const Epetra_Map& Epetra_Operator::OperatorRangeMap() const =0

        Returns the Epetra_Map object associated with the range of this
        operator. 
        """
        return _Anasazi.EpetraSymOp_OperatorRangeMap(self, *args)

EpetraSymOp_swigregister = _Anasazi.EpetraSymOp_swigregister
EpetraSymOp_swigregister(EpetraSymOp)

class EpetraSymMVOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraSymMVOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraSymMVOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraSymMVOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraSymMVOp self, Teuchos::RCP< Epetra_MultiVector const > const & MV, bool isTrans=False) -> EpetraSymMVOp"""
        this = _Anasazi.new_EpetraSymMVOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraSymMVOp

    def Apply(self, *args):
        """Apply(EpetraSymMVOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraSymMVOp_Apply(self, *args)

EpetraSymMVOp_swigregister = _Anasazi.EpetraSymMVOp_swigregister
EpetraSymMVOp_swigregister(EpetraSymMVOp)

class EpetraWSymMVOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraWSymMVOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraWSymMVOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraWSymMVOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraWSymMVOp self, Teuchos::RCP< Epetra_MultiVector const > const & MV, Teuchos::RCP< Epetra_Operator > const & OP) -> EpetraWSymMVOp"""
        this = _Anasazi.new_EpetraWSymMVOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraWSymMVOp

    def Apply(self, *args):
        """Apply(EpetraWSymMVOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraWSymMVOp_Apply(self, *args)

EpetraWSymMVOp_swigregister = _Anasazi.EpetraWSymMVOp_swigregister
EpetraWSymMVOp_swigregister(EpetraWSymMVOp)

class EpetraW2SymMVOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraW2SymMVOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraW2SymMVOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraW2SymMVOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraW2SymMVOp self, Teuchos::RCP< Epetra_MultiVector const > const & MV, Teuchos::RCP< Epetra_Operator > const & OP) -> EpetraW2SymMVOp"""
        this = _Anasazi.new_EpetraW2SymMVOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraW2SymMVOp

    def Apply(self, *args):
        """Apply(EpetraW2SymMVOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraW2SymMVOp_Apply(self, *args)

EpetraW2SymMVOp_swigregister = _Anasazi.EpetraW2SymMVOp_swigregister
EpetraW2SymMVOp_swigregister(EpetraW2SymMVOp)

class SortManagerEpetra(_object):
    """


    Anasazi's templated pure virtual class for managing the sorting of
    approximate eigenvalues computed by the eigensolver. A concrete
    implementation of this class is necessary.

    Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziSortManager.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SortManagerEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SortManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_SortManagerEpetra

    def sort(self, *args):
        """
        sort(SortManagerEpetra self, std::vector< double,std::allocator< double > > & evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)
        sort(SortManagerEpetra self, std::vector< double,std::allocator< double > > & r_evals, std::vector< double,std::allocator< double > > & i_evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)

        virtual void
        Anasazi::SortManager< MagnitudeType >::sort(std::vector< MagnitudeType
        > &r_evals, std::vector< MagnitudeType > &i_evals, Teuchos::RCP<
        std::vector< int > > perm=Teuchos::null, int n=-1) const =0

        Sort complex eigenvalues, optionally returning the permutation vector.

        This routine takes two vectors, one for each part of a complex
        eigenvalue. This is helpful for solving real, non-symmetric eigenvalue
        problems.

        Parameters:
        -----------

        r_evals:  [in/out] Vector of length at least n containing the real
        part of the eigenvalues to be sorted.  On output, the first n
        eigenvalues will be sorted. The rest will be unchanged.

        i_evals:  [in/out] Vector of length at least n containing the
        imaginary part of the eigenvalues to be sorted.  On output, the first
        n eigenvalues will be sorted. The rest will be unchanged.

        perm:  [out] Vector of length at least n to store the permutation
        index (optional).  If specified, on output the first n eigenvalues
        will contain the permutation indices, in the range [0,n-1], such that
        r_evals_out[i] = r_evals_in[perm[i]] and similarly for i_evals.

        n:  [in] Number of values in r_evals, i_evals to be sorted. If n ==
        -1, all values will be sorted. 
        """
        return _Anasazi.SortManagerEpetra_sort(self, *args)

SortManagerEpetra_swigregister = _Anasazi.SortManagerEpetra_swigregister
SortManagerEpetra_swigregister(SortManagerEpetra)

class BasicSortEpetra(SortManagerEpetra):
    """


    An implementation of the Anasazi::SortManager that performs a
    collection of common sorting techniques.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziBasicSort.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SortManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicSortEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SortManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicSortEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BasicSort<(double)> self, ParameterList pl) -> BasicSortEpetra
        __init__(Anasazi::BasicSort<(double)> self, std::string const & which) -> BasicSortEpetra

        Anasazi::BasicSort< MagnitudeType >::BasicSort(const std::string
        &which="LM")

        String driven constructor.

        Directly pass the string specifying sort strategy. See setSortType()
        for valid options. 
        """
        this = _Anasazi.new_BasicSortEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicSortEpetra

    def setSortType(self, *args):
        """
        setSortType(BasicSortEpetra self, std::string const & which)

        void
        Anasazi::BasicSort< MagnitudeType >::setSortType(const std::string
        &which)

        Set sort type.

        Parameters:
        -----------

        which:  [in] The eigenvalues of interest for this eigenproblem.
        "LM" - Largest Magnitude [ default ]

        "SM" - Smallest Magnitude

        "LR" - Largest Real

        "SR" - Smallest Real

        "LI" - Largest Imaginary

        "SI" - Smallest Imaginary 
        """
        return _Anasazi.BasicSortEpetra_setSortType(self, *args)


    def sort(self, *args):
        """
        sort(BasicSortEpetra self, std::vector< double,std::allocator< double > > & evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)
        sort(BasicSortEpetra self, std::vector< double,std::allocator< double > > & r_evals, std::vector< double,std::allocator< double > > & i_evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)

        void
        Anasazi::BasicSort< MagnitudeType >::sort(std::vector< MagnitudeType >
        &r_evals, std::vector< MagnitudeType > &i_evals, Teuchos::RCP<
        std::vector< int > > perm=Teuchos::null, int n=-1) const

        Sort complex eigenvalues, optionally returning the permutation vector.

        This routine takes two vectors, one for each part of a complex
        eigenvalue. This is helpful for solving real, non-symmetric eigenvalue
        problems.

        Parameters:
        -----------

        r_evals:  [in/out] Vector of length at least n containing the real
        part of the eigenvalues to be sorted.  On output, the first n
        eigenvalues will be sorted. The rest will be unchanged.

        i_evals:  [in/out] Vector of length at least n containing the
        imaginary part of the eigenvalues to be sorted.  On output, the first
        n eigenvalues will be sorted. The rest will be unchanged.

        perm:  [out] Vector of length at least n to store the permutation
        index (optional).  If specified, on output the first n eigenvalues
        will contain the permutation indices, in the range [0,n-1], such that
        r_evals_out[i] = r_evals_in[perm[i]] and similarly for i_evals.

        n:  [in] Number of values in r_evals, i_evals to be sorted. If n ==
        -1, all values will be sorted, as decided by the minimum of the length
        of r_evals and the length of i_evals. 
        """
        return _Anasazi.BasicSortEpetra_sort(self, *args)

BasicSortEpetra_swigregister = _Anasazi.BasicSortEpetra_swigregister
BasicSortEpetra_swigregister(BasicSortEpetra)

class MultiVecTraitsEpetra(_object):
    """Proxy of C++ Anasazi::MultiVecTraits<(double,Epetra_MultiVector)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVecTraitsEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVecTraitsEpetra, name)
    __repr__ = _swig_repr

    def Clone(*args):
        """
        Clone(MultiVector mv, int const outNumVecs) -> Teuchos::RCP< Epetra_MultiVector >

        static
        Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
        >::Clone(const MV &mv, const int numvecs)

        Creates a new empty MV containing numvecs columns.

        Reference-counted pointer to the new multivector of type MV. 
        """
        return _Anasazi.MultiVecTraitsEpetra_Clone(*args)

    Clone = staticmethod(Clone)

    def CloneCopy(*args):
        """
        CloneCopy(MultiVector mv) -> Teuchos::RCP< Epetra_MultiVector >
        CloneCopy(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
        CloneCopy(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >

        static
        Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
        >::CloneCopy(const MV &mv, const Teuchos::Range1D &index)

        Deep copy of specified columns of mv.

        Create a new MV, and copy (deep copy) the columns of mv specified by
        the given inclusive index range into the new multivector.

        Parameters:
        -----------

        mv:  [in] Multivector to copy

        index:  [in] Inclusive index range of columns of mv

        Reference-counted pointer to the new multivector of type MV. 
        """
        return _Anasazi.MultiVecTraitsEpetra_CloneCopy(*args)

    CloneCopy = staticmethod(CloneCopy)

    def CloneViewNonConst(*args):
        """
        CloneViewNonConst(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
        CloneViewNonConst(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >

        static Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
        >::CloneViewNonConst(MV &mv, const Teuchos::Range1D &index)

        Non-const view of specified columns of mv.

        Return a non-const view of the columns of mv specified by the given
        inclusive index range.

        Parameters:
        -----------

        mv:  [in] Multivector to view (shallow non-const copy)

        index:  [in] Inclusive index range of columns of mv

        Reference-counted pointer to the non-const view of specified columns
        of mv 
        """
        return _Anasazi.MultiVecTraitsEpetra_CloneViewNonConst(*args)

    CloneViewNonConst = staticmethod(CloneViewNonConst)

    def CloneView(*args):
        """
        CloneView(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >

        static
        Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
        >::CloneView(MV &mv, const Teuchos::Range1D &index)

        Const view of specified columns of mv.

        Return a const view of the columns of mv specified by the given
        inclusive index range.

        Parameters:
        -----------

        mv:  [in] Multivector to view (shallow const copy)

        index:  [in] Inclusive index range of columns of mv

        Reference-counted pointer to the const view of specified columns of mv

        """
        return _Anasazi.MultiVecTraitsEpetra_CloneView(*args)

    CloneView = staticmethod(CloneView)

    def GetGlobalLength(*args):
        """
        GetGlobalLength(MultiVector mv) -> ptrdiff_t

        static ptrdiff_t Anasazi::MultiVecTraits< ScalarType, MV
        >::GetGlobalLength(const MV &mv)

        Return the number of rows in the given multivector mv. 
        """
        return _Anasazi.MultiVecTraitsEpetra_GetGlobalLength(*args)

    GetGlobalLength = staticmethod(GetGlobalLength)

    def GetNumberVecs(*args):
        """
        GetNumberVecs(MultiVector mv) -> int

        static
        int Anasazi::MultiVecTraits< ScalarType, MV >::GetNumberVecs(const MV
        &mv)

        Obtain the number of vectors in mv. 
        """
        return _Anasazi.MultiVecTraitsEpetra_GetNumberVecs(*args)

    GetNumberVecs = staticmethod(GetNumberVecs)

    def HasConstantStride(*args):
        """HasConstantStride(MultiVector mv) -> bool"""
        return _Anasazi.MultiVecTraitsEpetra_HasConstantStride(*args)

    HasConstantStride = staticmethod(HasConstantStride)

    def MvTimesMatAddMv(*args):
        """
        MvTimesMatAddMv(double alpha, MultiVector A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta, MultiVector mv)

        static void Anasazi::MultiVecTraits< ScalarType, MV
        >::MvTimesMatAddMv(const ScalarType alpha, const MV &A, const
        Teuchos::SerialDenseMatrix< int, ScalarType > &B, const ScalarType
        beta, MV &mv)

        Update mv with $ \\alpha AB + \\beta mv $. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvTimesMatAddMv(*args)

    MvTimesMatAddMv = staticmethod(MvTimesMatAddMv)

    def MvAddMv(*args):
        """
        MvAddMv(double alpha, MultiVector A, double beta, MultiVector B, MultiVector mv)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvAddMv(const ScalarType
        alpha, const MV &A, const ScalarType beta, const MV &B, MV &mv)

        Replace mv with $\\alpha A + \\beta B$. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvAddMv(*args)

    MvAddMv = staticmethod(MvAddMv)

    def MvTransMv(*args):
        """
        MvTransMv(double alpha, MultiVector A, MultiVector mv, Teuchos::SerialDenseMatrix< int,double > & B)

        static
        void Anasazi::MultiVecTraits< ScalarType, MV >::MvTransMv(const
        ScalarType alpha, const MV &A, const MV &B,
        Teuchos::SerialDenseMatrix< int, ScalarType > &C)

        Compute C := alpha * A^H B.

        The result C is a dense, globally replicated matrix. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvTransMv(*args)

    MvTransMv = staticmethod(MvTransMv)

    def MvDot(*args):
        """
        MvDot(MultiVector A, MultiVector B, std::vector< double,std::allocator< double > > & b)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvDot(const MV &mv, const
        MV &A, std::vector< ScalarType > &b)

        Compute a vector b where the components are the individual dot-
        products of the i-th columns of A and mv, i.e. $b[i] = A[i]^Hmv[i]$.

        """
        return _Anasazi.MultiVecTraitsEpetra_MvDot(*args)

    MvDot = staticmethod(MvDot)

    def MvNorm(*args):
        """
        MvNorm(MultiVector mv, std::vector< double,std::allocator< double > > & normvec)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvNorm(const MV &mv,
        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > &normvec)

        Compute the 2-norm of each individual vector of mv. Upon return,
        normvec[i] holds the value of $||mv_i||_2$, the i-th column of mv. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvNorm(*args)

    MvNorm = staticmethod(MvNorm)

    def SetBlock(*args):
        """
        SetBlock(MultiVector A, VectorInt index, MultiVector mv)
        SetBlock(MultiVector A, Teuchos::Range1D const & index, MultiVector mv)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::SetBlock(const MV &A, const
        Teuchos::Range1D &index, MV &mv)

        Deep copy of A into specified columns of mv.

        (Deeply) copy the first index.size() columns of A into the columns of
        mv specified by the given index range.

        Postcondition: mv[i] = A[i - index.lbound()] for all i in
        [index.lbound(), index.ubound()]

        Parameters:
        -----------

        A:  [in] Source multivector

        index:  [in] Inclusive index range of columns of mv; index set of the
        target

        mv:  [out] Target multivector 
        """
        return _Anasazi.MultiVecTraitsEpetra_SetBlock(*args)

    SetBlock = staticmethod(SetBlock)

    def Assign(*args):
        """
        Assign(MultiVector A, MultiVector mv)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::Assign(const MV &A, MV &mv)

        mv := A

        Assign (deep copy) A into mv. 
        """
        return _Anasazi.MultiVecTraitsEpetra_Assign(*args)

    Assign = staticmethod(Assign)

    def MvScale(*args):
        """
        MvScale(MultiVector mv, double alpha)
        MvScale(MultiVector mv, std::vector< double,std::allocator< double > > const & alpha)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvScale(MV &mv, const
        std::vector< ScalarType > &alpha)

        Scale each element of the i-th vector in mv with alpha[i]. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvScale(*args)

    MvScale = staticmethod(MvScale)

    def MvRandom(*args):
        """
        MvRandom(MultiVector mv)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvRandom(MV &mv)

        Replace the vectors in mv with random vectors. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvRandom(*args)

    MvRandom = staticmethod(MvRandom)

    def MvInit(*args):
        """
        MvInit(MultiVector mv, double alpha)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvInit(MV &mv, const
        ScalarType alpha=Teuchos::ScalarTraits< ScalarType >::zero())

        Replace each element of the vectors in mv with alpha. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvInit(*args)

    MvInit = staticmethod(MvInit)

    def MvPrint(*args):
        """
        MvPrint(MultiVector mv, std::ostream & os)

        static void
        Anasazi::MultiVecTraits< ScalarType, MV >::MvPrint(const MV &mv,
        std::ostream &os)

        Print the mv multi-vector to the os output stream. 
        """
        return _Anasazi.MultiVecTraitsEpetra_MvPrint(*args)

    MvPrint = staticmethod(MvPrint)

    def __init__(self, *args):
        """__init__(Anasazi::MultiVecTraits<(double,Epetra_MultiVector)> self) -> MultiVecTraitsEpetra"""
        this = _Anasazi.new_MultiVecTraitsEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_MultiVecTraitsEpetra
MultiVecTraitsEpetra_swigregister = _Anasazi.MultiVecTraitsEpetra_swigregister
MultiVecTraitsEpetra_swigregister(MultiVecTraitsEpetra)

def MultiVecTraitsEpetra_Clone(*args):
    """
    MultiVecTraitsEpetra_Clone(MultiVector mv, int const outNumVecs) -> Teuchos::RCP< Epetra_MultiVector >

    static
    Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
    >::Clone(const MV &mv, const int numvecs)

    Creates a new empty MV containing numvecs columns.

    Reference-counted pointer to the new multivector of type MV. 
    """
    return _Anasazi.MultiVecTraitsEpetra_Clone(*args)

def MultiVecTraitsEpetra_CloneCopy(*args):
    """
    CloneCopy(MultiVector mv) -> Teuchos::RCP< Epetra_MultiVector >
    CloneCopy(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
    MultiVecTraitsEpetra_CloneCopy(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >

    static
    Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
    >::CloneCopy(const MV &mv, const Teuchos::Range1D &index)

    Deep copy of specified columns of mv.

    Create a new MV, and copy (deep copy) the columns of mv specified by
    the given inclusive index range into the new multivector.

    Parameters:
    -----------

    mv:  [in] Multivector to copy

    index:  [in] Inclusive index range of columns of mv

    Reference-counted pointer to the new multivector of type MV. 
    """
    return _Anasazi.MultiVecTraitsEpetra_CloneCopy(*args)

def MultiVecTraitsEpetra_CloneViewNonConst(*args):
    """
    CloneViewNonConst(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
    MultiVecTraitsEpetra_CloneViewNonConst(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >

    static Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
    >::CloneViewNonConst(MV &mv, const Teuchos::Range1D &index)

    Non-const view of specified columns of mv.

    Return a non-const view of the columns of mv specified by the given
    inclusive index range.

    Parameters:
    -----------

    mv:  [in] Multivector to view (shallow non-const copy)

    index:  [in] Inclusive index range of columns of mv

    Reference-counted pointer to the non-const view of specified columns
    of mv 
    """
    return _Anasazi.MultiVecTraitsEpetra_CloneViewNonConst(*args)

def MultiVecTraitsEpetra_CloneView(*args):
    """
    MultiVecTraitsEpetra_CloneView(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >

    static
    Teuchos::RCP<MV> Anasazi::MultiVecTraits< ScalarType, MV
    >::CloneView(MV &mv, const Teuchos::Range1D &index)

    Const view of specified columns of mv.

    Return a const view of the columns of mv specified by the given
    inclusive index range.

    Parameters:
    -----------

    mv:  [in] Multivector to view (shallow const copy)

    index:  [in] Inclusive index range of columns of mv

    Reference-counted pointer to the const view of specified columns of mv

    """
    return _Anasazi.MultiVecTraitsEpetra_CloneView(*args)

def MultiVecTraitsEpetra_GetGlobalLength(*args):
    """
    MultiVecTraitsEpetra_GetGlobalLength(MultiVector mv) -> ptrdiff_t

    static ptrdiff_t Anasazi::MultiVecTraits< ScalarType, MV
    >::GetGlobalLength(const MV &mv)

    Return the number of rows in the given multivector mv. 
    """
    return _Anasazi.MultiVecTraitsEpetra_GetGlobalLength(*args)

def MultiVecTraitsEpetra_GetNumberVecs(*args):
    """
    MultiVecTraitsEpetra_GetNumberVecs(MultiVector mv) -> int

    static
    int Anasazi::MultiVecTraits< ScalarType, MV >::GetNumberVecs(const MV
    &mv)

    Obtain the number of vectors in mv. 
    """
    return _Anasazi.MultiVecTraitsEpetra_GetNumberVecs(*args)

def MultiVecTraitsEpetra_HasConstantStride(*args):
    """MultiVecTraitsEpetra_HasConstantStride(MultiVector mv) -> bool"""
    return _Anasazi.MultiVecTraitsEpetra_HasConstantStride(*args)

def MultiVecTraitsEpetra_MvTimesMatAddMv(*args):
    """
    MultiVecTraitsEpetra_MvTimesMatAddMv(double alpha, MultiVector A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta, MultiVector mv)

    static void Anasazi::MultiVecTraits< ScalarType, MV
    >::MvTimesMatAddMv(const ScalarType alpha, const MV &A, const
    Teuchos::SerialDenseMatrix< int, ScalarType > &B, const ScalarType
    beta, MV &mv)

    Update mv with $ \\alpha AB + \\beta mv $. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvTimesMatAddMv(*args)

def MultiVecTraitsEpetra_MvAddMv(*args):
    """
    MultiVecTraitsEpetra_MvAddMv(double alpha, MultiVector A, double beta, MultiVector B, MultiVector mv)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvAddMv(const ScalarType
    alpha, const MV &A, const ScalarType beta, const MV &B, MV &mv)

    Replace mv with $\\alpha A + \\beta B$. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvAddMv(*args)

def MultiVecTraitsEpetra_MvTransMv(*args):
    """
    MultiVecTraitsEpetra_MvTransMv(double alpha, MultiVector A, MultiVector mv, Teuchos::SerialDenseMatrix< int,double > & B)

    static
    void Anasazi::MultiVecTraits< ScalarType, MV >::MvTransMv(const
    ScalarType alpha, const MV &A, const MV &B,
    Teuchos::SerialDenseMatrix< int, ScalarType > &C)

    Compute C := alpha * A^H B.

    The result C is a dense, globally replicated matrix. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvTransMv(*args)

def MultiVecTraitsEpetra_MvDot(*args):
    """
    MultiVecTraitsEpetra_MvDot(MultiVector A, MultiVector B, std::vector< double,std::allocator< double > > & b)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvDot(const MV &mv, const
    MV &A, std::vector< ScalarType > &b)

    Compute a vector b where the components are the individual dot-
    products of the i-th columns of A and mv, i.e. $b[i] = A[i]^Hmv[i]$.

    """
    return _Anasazi.MultiVecTraitsEpetra_MvDot(*args)

def MultiVecTraitsEpetra_MvNorm(*args):
    """
    MultiVecTraitsEpetra_MvNorm(MultiVector mv, std::vector< double,std::allocator< double > > & normvec)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvNorm(const MV &mv,
    std::vector< typename Teuchos::ScalarTraits< ScalarType
    >::magnitudeType > &normvec)

    Compute the 2-norm of each individual vector of mv. Upon return,
    normvec[i] holds the value of $||mv_i||_2$, the i-th column of mv. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvNorm(*args)

def MultiVecTraitsEpetra_SetBlock(*args):
    """
    SetBlock(MultiVector A, VectorInt index, MultiVector mv)
    MultiVecTraitsEpetra_SetBlock(MultiVector A, Teuchos::Range1D const & index, MultiVector mv)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::SetBlock(const MV &A, const
    Teuchos::Range1D &index, MV &mv)

    Deep copy of A into specified columns of mv.

    (Deeply) copy the first index.size() columns of A into the columns of
    mv specified by the given index range.

    Postcondition: mv[i] = A[i - index.lbound()] for all i in
    [index.lbound(), index.ubound()]

    Parameters:
    -----------

    A:  [in] Source multivector

    index:  [in] Inclusive index range of columns of mv; index set of the
    target

    mv:  [out] Target multivector 
    """
    return _Anasazi.MultiVecTraitsEpetra_SetBlock(*args)

def MultiVecTraitsEpetra_Assign(*args):
    """
    MultiVecTraitsEpetra_Assign(MultiVector A, MultiVector mv)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::Assign(const MV &A, MV &mv)

    mv := A

    Assign (deep copy) A into mv. 
    """
    return _Anasazi.MultiVecTraitsEpetra_Assign(*args)

def MultiVecTraitsEpetra_MvScale(*args):
    """
    MvScale(MultiVector mv, double alpha)
    MultiVecTraitsEpetra_MvScale(MultiVector mv, std::vector< double,std::allocator< double > > const & alpha)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvScale(MV &mv, const
    std::vector< ScalarType > &alpha)

    Scale each element of the i-th vector in mv with alpha[i]. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvScale(*args)

def MultiVecTraitsEpetra_MvRandom(*args):
    """
    MultiVecTraitsEpetra_MvRandom(MultiVector mv)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvRandom(MV &mv)

    Replace the vectors in mv with random vectors. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvRandom(*args)

def MultiVecTraitsEpetra_MvInit(*args):
    """
    MultiVecTraitsEpetra_MvInit(MultiVector mv, double alpha)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvInit(MV &mv, const
    ScalarType alpha=Teuchos::ScalarTraits< ScalarType >::zero())

    Replace each element of the vectors in mv with alpha. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvInit(*args)

def MultiVecTraitsEpetra_MvPrint(*args):
    """
    MultiVecTraitsEpetra_MvPrint(MultiVector mv, std::ostream & os)

    static void
    Anasazi::MultiVecTraits< ScalarType, MV >::MvPrint(const MV &mv,
    std::ostream &os)

    Print the mv multi-vector to the os output stream. 
    """
    return _Anasazi.MultiVecTraitsEpetra_MvPrint(*args)

class OperatorTraitsEpetra(_object):
    """Proxy of C++ Anasazi::OperatorTraits<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperatorTraitsEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OperatorTraitsEpetra, name)
    __repr__ = _swig_repr

    def Apply(*args):
        """
        Apply(Operator Op, MultiVector x, MultiVector y)

        static void
        Anasazi::OperatorTraits< ScalarType, MV, OP >::Apply(const OP &Op,
        const MV &x, MV &y)

        Application method which performs operation y = Op*x. An OperatorError
        exception is thrown if there is an error. 
        """
        return _Anasazi.OperatorTraitsEpetra_Apply(*args)

    Apply = staticmethod(Apply)

    def __init__(self, *args):
        """__init__(Anasazi::OperatorTraits<(double,Epetra_MultiVector,Epetra_Operator)> self) -> OperatorTraitsEpetra"""
        this = _Anasazi.new_OperatorTraitsEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_OperatorTraitsEpetra
OperatorTraitsEpetra_swigregister = _Anasazi.OperatorTraitsEpetra_swigregister
OperatorTraitsEpetra_swigregister(OperatorTraitsEpetra)

def OperatorTraitsEpetra_Apply(*args):
    """
    OperatorTraitsEpetra_Apply(Operator Op, MultiVector x, MultiVector y)

    static void
    Anasazi::OperatorTraits< ScalarType, MV, OP >::Apply(const OP &Op,
    const MV &x, MV &y)

    Application method which performs operation y = Op*x. An OperatorError
    exception is thrown if there is an error. 
    """
    return _Anasazi.OperatorTraitsEpetra_Apply(*args)

class EigenproblemEpetra(_object):
    """


    This class defines the interface required by an eigensolver and status
    test class to compute solutions to an eigenproblem.

    C++ includes: AnasaziEigenproblem.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EigenproblemEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EigenproblemEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_EigenproblemEpetra

    def setOperator(self, *args):
        """
        setOperator(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Op)

        virtual
        void Anasazi::Eigenproblem< ScalarType, MV, OP >::setOperator(const
        Teuchos::RCP< const OP > &Op)=0

        Set the operator for which eigenvalues will be computed.

        This may be different from the A if a spectral transformation is
        employed. For example, this operator may apply the operation
        $(A-\\sigma I)^{-1}$ if you are looking for eigenvalues of A around
        $\\sigma$. 
        """
        return _Anasazi.EigenproblemEpetra_setOperator(self, *args)


    def setA(self, *args):
        """
        setA(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & A)

        virtual void
        Anasazi::Eigenproblem< ScalarType, MV, OP >::setA(const Teuchos::RCP<
        const OP > &A)=0

        Set the operator A of the eigenvalue problem $Ax=\\lambda Mx$. 
        """
        return _Anasazi.EigenproblemEpetra_setA(self, *args)


    def setM(self, *args):
        """
        setM(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & M)

        virtual void
        Anasazi::Eigenproblem< ScalarType, MV, OP >::setM(const Teuchos::RCP<
        const OP > &M)=0

        Set the operator M of the eigenvalue problem $Ax=\\lambda Mx$. 
        """
        return _Anasazi.EigenproblemEpetra_setM(self, *args)


    def setPrec(self, *args):
        """
        setPrec(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Prec)

        virtual void
        Anasazi::Eigenproblem< ScalarType, MV, OP >::setPrec(const
        Teuchos::RCP< const OP > &Prec)=0

        Set the preconditioner for this eigenvalue problem $Ax=\\lambda Mx$.

        """
        return _Anasazi.EigenproblemEpetra_setPrec(self, *args)


    def setInitVec(self, *args):
        """
        setInitVec(EigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector > const & InitVec)

        virtual
        void Anasazi::Eigenproblem< ScalarType, MV, OP >::setInitVec(const
        Teuchos::RCP< MV > &InitVec)=0

        Set the initial guess.

        This multivector should have the same number of columns as the
        blocksize. 
        """
        return _Anasazi.EigenproblemEpetra_setInitVec(self, *args)


    def setAuxVecs(self, *args):
        """
        setAuxVecs(EigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector const > const & AuxVecs)

        virtual
        void Anasazi::Eigenproblem< ScalarType, MV, OP >::setAuxVecs(const
        Teuchos::RCP< const MV > &AuxVecs)=0

        Set auxiliary vectors.

        This multivector can have any number of columns, and most likely will
        contain vectors that will be used by the eigensolver to orthogonalize
        against. 
        """
        return _Anasazi.EigenproblemEpetra_setAuxVecs(self, *args)


    def setNEV(self, *args):
        """
        setNEV(EigenproblemEpetra self, int nev)

        virtual void
        Anasazi::Eigenproblem< ScalarType, MV, OP >::setNEV(int nev)=0

        The number of eigenvalues (NEV) that are requested. 
        """
        return _Anasazi.EigenproblemEpetra_setNEV(self, *args)


    def setHermitian(self, *args):
        """
        setHermitian(EigenproblemEpetra self, bool isSym)

        virtual
        void Anasazi::Eigenproblem< ScalarType, MV, OP >::setHermitian(bool
        isSym)=0

        Specify the symmetry of the eigenproblem.

        This knowledge may allow the solver to take advantage of the
        eigenproblems' symmetry. Some computational work may be avoided by
        setting this properly. 
        """
        return _Anasazi.EigenproblemEpetra_setHermitian(self, *args)


    def setProblem(self, *args):
        """
        setProblem(EigenproblemEpetra self) -> bool

        virtual
        bool Anasazi::Eigenproblem< ScalarType, MV, OP >::setProblem()=0

        Specify that this eigenproblem is fully defined.

        This routine serves multiple purpose: sanity check that the
        eigenproblem has been fully and consistently defined

        opportunity for the eigenproblem to allocate internal storage for
        eigenvalues and eigenvectors (to be used by eigensolvers and solver
        managers)

        The user MUST call this routine before they send the eigenproblem to
        any solver or solver manager.

        true signifies success, false signifies error. 
        """
        return _Anasazi.EigenproblemEpetra_setProblem(self, *args)


    def setSolution(self, *args):
        """
        setSolution(EigenproblemEpetra self, EigensolutionEpetra sol)

        virtual
        void Anasazi::Eigenproblem< ScalarType, MV, OP >::setSolution(const
        Eigensolution< ScalarType, MV > &sol)=0

        Set the solution to the eigenproblem.

        This mechanism allows an Eigensolution struct to be associated with an
        Eigenproblem object. setSolution() is usually called by a solver
        manager at the end of its SolverManager::solve() routine. 
        """
        return _Anasazi.EigenproblemEpetra_setSolution(self, *args)


    def getOperator(self, *args):
        """
        getOperator(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        virtual
        Teuchos::RCP<const OP> Anasazi::Eigenproblem< ScalarType, MV, OP
        >::getOperator() const =0

        Get a pointer to the operator for which eigenvalues will be computed.

        """
        return _Anasazi.EigenproblemEpetra_getOperator(self, *args)


    def getA(self, *args):
        """
        getA(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        virtual
        Teuchos::RCP<const OP> Anasazi::Eigenproblem< ScalarType, MV, OP
        >::getA() const =0

        Get a pointer to the operator A of the eigenproblem $AX=\\lambda
        Mx$. 
        """
        return _Anasazi.EigenproblemEpetra_getA(self, *args)


    def getM(self, *args):
        """
        getM(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        virtual
        Teuchos::RCP<const OP> Anasazi::Eigenproblem< ScalarType, MV, OP
        >::getM() const =0

        Get a pointer to the operator M of the eigenproblem $AX=\\lambda
        Mx$. 
        """
        return _Anasazi.EigenproblemEpetra_getM(self, *args)


    def getPrec(self, *args):
        """
        getPrec(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        virtual
        Teuchos::RCP<const OP> Anasazi::Eigenproblem< ScalarType, MV, OP
        >::getPrec() const =0

        Get a pointer to the preconditioner. 
        """
        return _Anasazi.EigenproblemEpetra_getPrec(self, *args)


    def getInitVec(self, *args):
        """
        getInitVec(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        virtual
        Teuchos::RCP<const MV> Anasazi::Eigenproblem< ScalarType, MV, OP
        >::getInitVec() const =0

        Get a pointer to the initial vector. 
        """
        return _Anasazi.EigenproblemEpetra_getInitVec(self, *args)


    def getAuxVecs(self, *args):
        """
        getAuxVecs(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        virtual
        Teuchos::RCP<const MV> Anasazi::Eigenproblem< ScalarType, MV, OP
        >::getAuxVecs() const =0

        Get a pointer to the auxiliary vector. 
        """
        return _Anasazi.EigenproblemEpetra_getAuxVecs(self, *args)


    def getNEV(self, *args):
        """
        getNEV(EigenproblemEpetra self) -> int

        virtual int
        Anasazi::Eigenproblem< ScalarType, MV, OP >::getNEV() const =0

        Get the number of eigenvalues (NEV) that are required by this
        eigenproblem. 
        """
        return _Anasazi.EigenproblemEpetra_getNEV(self, *args)


    def isHermitian(self, *args):
        """
        isHermitian(EigenproblemEpetra self) -> bool

        virtual
        bool Anasazi::Eigenproblem< ScalarType, MV, OP >::isHermitian() const
        =0

        Get the symmetry information for this eigenproblem. 
        """
        return _Anasazi.EigenproblemEpetra_isHermitian(self, *args)


    def isProblemSet(self, *args):
        """
        isProblemSet(EigenproblemEpetra self) -> bool

        virtual
        bool Anasazi::Eigenproblem< ScalarType, MV, OP >::isProblemSet() const
        =0

        If the problem has been set, this method will return true. 
        """
        return _Anasazi.EigenproblemEpetra_isProblemSet(self, *args)


    def getSolution(self, *args):
        """
        getSolution(EigenproblemEpetra self) -> EigensolutionEpetra

        virtual
        const Eigensolution<ScalarType,MV>& Anasazi::Eigenproblem< ScalarType,
        MV, OP >::getSolution() const =0

        Get the solution to the eigenproblem.

        There is no computation associated with this method. It only provides
        a mechanism for associating an Eigensolution with a Eigenproblem. 
        """
        return _Anasazi.EigenproblemEpetra_getSolution(self, *args)

EigenproblemEpetra_swigregister = _Anasazi.EigenproblemEpetra_swigregister
EigenproblemEpetra_swigregister(EigenproblemEpetra)

class BasicEigenproblemEpetra(EigenproblemEpetra):
    """


    This provides a basic implementation for defining standard or
    generalized eigenvalue problems.

    C++ includes: AnasaziBasicEigenproblem.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [EigenproblemEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicEigenproblemEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigenproblemEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicEigenproblemEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self) -> BasicEigenproblemEpetra
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > const & Op, Teuchos::RCP< Epetra_MultiVector > const & InitVec) -> BasicEigenproblemEpetra
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > const & Op, Teuchos::RCP< Epetra_Operator const > const & B, Teuchos::RCP< Epetra_MultiVector > const & InitVec) -> BasicEigenproblemEpetra
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self, BasicEigenproblemEpetra Problem) -> BasicEigenproblemEpetra

        Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::BasicEigenproblem(const BasicEigenproblem< ScalarType, MV, OP >
        &Problem)

        Copy Constructor. 
        """
        this = _Anasazi.new_BasicEigenproblemEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicEigenproblemEpetra

    def setOperator(self, *args):
        """
        setOperator(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Op)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setOperator(const
        Teuchos::RCP< const OP > &Op)

        Set the operator for which eigenvalues will be computed.

        This may be different from the A if a spectral transformation is
        employed. For example, this operator may apply the operation
        $(A-\\sigma I)^{-1}$ if you are looking for eigenvalues of A around
        $\\sigma$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setOperator(self, *args)


    def setA(self, *args):
        """
        setA(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & A)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setA(const
        Teuchos::RCP< const OP > &A)

        Set the operator A of the eigenvalue problem $Ax=Mx\\lambda$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setA(self, *args)


    def setM(self, *args):
        """
        setM(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & M)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setM(const
        Teuchos::RCP< const OP > &M)

        Set the operator M of the eigenvalue problem $Ax = Mx\\lambda$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setM(self, *args)


    def setPrec(self, *args):
        """
        setPrec(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Prec)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setPrec(const
        Teuchos::RCP< const OP > &Prec)

        Set the preconditioner for this eigenvalue problem $Ax =
        Mx\\lambda$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setPrec(self, *args)


    def setInitVec(self, *args):
        """
        setInitVec(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector > const & InitVec)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setInitVec(const
        Teuchos::RCP< MV > &InitVec)

        Set the initial guess.

        This vector is required to create all the space needed by Anasazi to
        solve the eigenvalue problem.

        Even if an initial guess is not known by the user, an initial vector
        must be passed in. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setInitVec(self, *args)


    def setAuxVecs(self, *args):
        """
        setAuxVecs(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector const > const & AuxVecs)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setAuxVecs(const
        Teuchos::RCP< const MV > &AuxVecs)

        Set auxiliary vectors.

        This multivector can have any number of columns, and most likely will
        contain vectors that will be used by the eigensolver to orthogonalize
        against. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setAuxVecs(self, *args)


    def setNEV(self, *args):
        """
        setNEV(BasicEigenproblemEpetra self, int nev)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setNEV(int nev)

        Specify the number of eigenvalues (NEV) that are requested. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setNEV(self, *args)


    def setHermitian(self, *args):
        """
        setHermitian(BasicEigenproblemEpetra self, bool isSym)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setHermitian(bool
        isSym)

        Specify the symmetry of this eigenproblem.

        This knowledge may allow the solver to take advantage of the
        eigenproblems' symmetry. Some computational work can be avoided by
        setting this properly. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setHermitian(self, *args)


    def setProblem(self, *args):
        """
        setProblem(BasicEigenproblemEpetra self) -> bool

        bool
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setProblem()

        Specify that this eigenproblem is fully defined.

        This routine serves multiple purpose: sanity check that the
        eigenproblem has been fully and consistently defined

        opportunity for the eigenproblem to allocate internal storage for
        eigenvalues and eigenvectors (to be used by eigensolvers and solver
        managers)

        This method reallocates internal storage, so that any previously
        retrieved references to internal storage (eigenvectors or eigenvalues)
        are invalidated.

        The user MUST call this routine before they send the eigenproblem to
        any solver or solver manager.

        true signifies success, false signifies error. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setProblem(self, *args)


    def setSolution(self, *args):
        """
        setSolution(BasicEigenproblemEpetra self, EigensolutionEpetra sol)

        void
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::setSolution(const
        Eigensolution< ScalarType, MV > &sol)

        Set the solution to the eigenproblem.

        This mechanism allows an Eigensolution struct to be associated with an
        Eigenproblem object. setSolution() is usually called by a solver
        manager at the end of its SolverManager::solve() routine. 
        """
        return _Anasazi.BasicEigenproblemEpetra_setSolution(self, *args)


    def getOperator(self, *args):
        """
        getOperator(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        Teuchos::RCP<const OP> Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::getOperator() const

        Get a pointer to the operator for which eigenvalues will be computed.

        """
        return _Anasazi.BasicEigenproblemEpetra_getOperator(self, *args)


    def getA(self, *args):
        """
        getA(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        Teuchos::RCP<const OP> Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::getA() const

        Get a pointer to the operator A of the eigenproblem $Ax=\\lambda
        Mx$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getA(self, *args)


    def getM(self, *args):
        """
        getM(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        Teuchos::RCP<const OP> Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::getM() const

        Get a pointer to the operator M of the eigenproblem $Ax=\\lambda
        Mx$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getM(self, *args)


    def getPrec(self, *args):
        """
        getPrec(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        Teuchos::RCP<const OP> Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::getPrec() const

        Get a pointer to the preconditioner of the eigenproblem $Ax=\\lambda
        Mx$. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getPrec(self, *args)


    def getInitVec(self, *args):
        """
        getInitVec(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        Teuchos::RCP<const MV> Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::getInitVec() const

        Get a pointer to the initial vector. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getInitVec(self, *args)


    def getAuxVecs(self, *args):
        """
        getAuxVecs(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        Teuchos::RCP<const MV> Anasazi::BasicEigenproblem< ScalarType, MV, OP
        >::getAuxVecs() const

        Get a pointer to the auxiliary vector. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getAuxVecs(self, *args)


    def getNEV(self, *args):
        """
        getNEV(BasicEigenproblemEpetra self) -> int

        int
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::getNEV() const

        Get the number of eigenvalues (NEV) that are required by this
        eigenproblem. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getNEV(self, *args)


    def isHermitian(self, *args):
        """
        isHermitian(BasicEigenproblemEpetra self) -> bool

        bool
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::isHermitian() const

        Get the symmetry information for this eigenproblem. 
        """
        return _Anasazi.BasicEigenproblemEpetra_isHermitian(self, *args)


    def isProblemSet(self, *args):
        """
        isProblemSet(BasicEigenproblemEpetra self) -> bool

        bool
        Anasazi::BasicEigenproblem< ScalarType, MV, OP >::isProblemSet() const

        If the problem has been set, this method will return true. 
        """
        return _Anasazi.BasicEigenproblemEpetra_isProblemSet(self, *args)


    def getSolution(self, *args):
        """
        getSolution(BasicEigenproblemEpetra self) -> EigensolutionEpetra

        const
        Eigensolution<ScalarType,MV>& Anasazi::BasicEigenproblem< ScalarType,
        MV, OP >::getSolution() const

        Get the solution to the eigenproblem.

        There is no computation associated with this method. It only provides
        a mechanism for associating an Eigensolution with a Eigenproblem. 
        """
        return _Anasazi.BasicEigenproblemEpetra_getSolution(self, *args)


    def computeCurrResVec(self, *args):
        """
        computeCurrResVec(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        Teuchos::RCP< const MV > Anasazi::BasicEigenproblem< ScalarType, MV,
        OP >::computeCurrResVec() const

        Returns the residual vector corresponding to the computed solution.

        If there is no computed solution, returns Teuchos::null.

        If A has not been set, this function will compute $R = OpX-
        MX\\Lambda$ If you are using a spectral transformation, this may not
        be what you want. 
        """
        return _Anasazi.BasicEigenproblemEpetra_computeCurrResVec(self, *args)

BasicEigenproblemEpetra_swigregister = _Anasazi.BasicEigenproblemEpetra_swigregister
BasicEigenproblemEpetra_swigregister(BasicEigenproblemEpetra)

class StatusTestEpetra(_object):
    """


    Common interface of stopping criteria for Anasazi's solvers.

    StatusTest is an interface that can be implemented to create
    convergence tests for all Anasazi solvers. Almost any kind of test can
    be expressed using this mechanism, including composite tests (see
    StatusTestCombo).

    C++ includes: AnasaziStatusTestDecl.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_StatusTestEpetra

    def checkStatus(self, *args):
        """
        checkStatus(StatusTestEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus

        virtual
        TestStatus Anasazi::StatusTest< ScalarType, MV, OP
        >::checkStatus(Eigensolver< ScalarType, MV, OP > *solver)=0

        Check status as defined by test.

        TestStatus indicating whether the test passed or failed. 
        """
        return _Anasazi.StatusTestEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(StatusTestEpetra self) -> Anasazi::TestStatus

        virtual
        TestStatus Anasazi::StatusTest< ScalarType, MV, OP >::getStatus()
        const =0

        Return the result of the most recent checkStatus call, or undefined if
        it has not been run. 
        """
        return _Anasazi.StatusTestEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """
        whichVecs(StatusTestEpetra self) -> VectorInt

        virtual
        std::vector<int> Anasazi::StatusTest< ScalarType, MV, OP
        >::whichVecs() const =0

        Get the indices for the vectors that passed the test. 
        """
        return _Anasazi.StatusTestEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """
        howMany(StatusTestEpetra self) -> int

        virtual int
        Anasazi::StatusTest< ScalarType, MV, OP >::howMany() const =0

        Get the number of vectors that passed the test. 
        """
        return _Anasazi.StatusTestEpetra_howMany(self, *args)


    def reset(self, *args):
        """
        reset(StatusTestEpetra self)

        virtual void
        Anasazi::StatusTest< ScalarType, MV, OP >::reset()=0

        Informs the status test that it should reset its internal
        configuration to the uninitialized state.

        This is necessary for the case when the status test is being reused by
        another solver or for another eigenvalue problem. The status test may
        have information that pertains to a particular problem or solver
        state. The internal information will be reset back to the
        uninitialized state. The user specified information that the
        convergence test uses will remain. 
        """
        return _Anasazi.StatusTestEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """
        clearStatus(StatusTestEpetra self)

        virtual void
        Anasazi::StatusTest< ScalarType, MV, OP >::clearStatus()=0

        Clears the results of the last status test.

        This should be distinguished from the reset() method, as it only
        clears the cached result from the last status test, so that a call to
        getStatus() will return ::Undefined. This is necessary for the SEQOR
        and SEQAND tests in the StatusTestCombo class, which may short circuit
        and not evaluate all of the StatusTests contained in them. 
        """
        return _Anasazi.StatusTestEpetra_clearStatus(self, *args)

StatusTestEpetra_swigregister = _Anasazi.StatusTestEpetra_swigregister
StatusTestEpetra_swigregister(StatusTestEpetra)

class StatusTestComboEpetra(StatusTestEpetra):
    """


    Status test for forming logical combinations of other status tests.

    Test types include StatusTestCombo::OR, StatusTestCombo::AND,
    StatusTestCombo::SEQOR and StatusTestCombo::SEQAND. The
    StatusTestCombo::OR and StatusTestCombo::AND tests evaluate all of the
    tests, in the order they were passed to the StatusTestCombo. The
    StatusTestCombo::SEQOR and StatusTestCombo::SEQAND run only the tests
    necessary to determine the final outcome, short- circuiting on the
    first test that conclusively decides the outcome. More formally,
    StatusTestCombo::SEQAND runs the tests in the order they were given to
    the StatusTestCombo class and stops after the first test that
    evaluates ::Failed. StatusTestCombo::SEQOR run the tests in the order
    they were given to the StatusTestCombo class and stops after the first
    test that evaluates ::Passed.

    C++ includes: AnasaziStatusTestCombo.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestComboEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestComboEpetra, name)
    __repr__ = _swig_repr
    OR = _Anasazi.StatusTestComboEpetra_OR
    AND = _Anasazi.StatusTestComboEpetra_AND
    SEQOR = _Anasazi.StatusTestComboEpetra_SEQOR
    SEQAND = _Anasazi.StatusTestComboEpetra_SEQAND

    def __init__(self, *args):
        """
        __init__(Anasazi::StatusTestCombo<(double,Epetra_MultiVector,Epetra_Operator)> self) -> StatusTestComboEpetra
        __init__(Anasazi::StatusTestCombo<(double,Epetra_MultiVector,Epetra_Operator)> self, Anasazi::StatusTestCombo< double,Epetra_MultiVector,Epetra_Operator >::ComboType type, Teuchos::Array< Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > > tests) -> StatusTestComboEpetra

        Anasazi::StatusTestCombo< ScalarType, MV, OP
        >::StatusTestCombo(ComboType type, Teuchos::Array< Teuchos::RCP<
        StatusTest< ScalarType, MV, OP > > > tests)

        Constructor specifying the StatusTestCombo::ComboType and the tests.

        Constructor 
        """
        this = _Anasazi.new_StatusTestComboEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestComboEpetra

    def checkStatus(self, *args):
        """
        checkStatus(StatusTestComboEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestCombo< ScalarType, MV, OP
        >::checkStatus(Eigensolver< ScalarType, MV, OP > *solver)

        Check status as defined by test.

        TestStatus indicating whether the test passed or failed. 
        """
        return _Anasazi.StatusTestComboEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(StatusTestComboEpetra self) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestCombo< ScalarType, MV, OP >::getStatus()
        const

        Return the result of the most recent checkStatus call. 
        """
        return _Anasazi.StatusTestComboEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """
        whichVecs(StatusTestComboEpetra self) -> VectorInt

        std::vector<int> Anasazi::StatusTestCombo< ScalarType, MV, OP
        >::whichVecs() const

        Get the indices for the vectors that passed the test.

        This returns some combination of the passing vectors from the tests
        comprising the StatusTestCombo. The nature of the combination depends
        on the StatusTestCombo::ComboType:  StatusTestCombo::SEQOR,
        StatusTestCombo::OR - whichVecs() returns the union of whichVecs()
        from all evaluated constituent tests

        StatusTestCombo::SEQAND, StatusTestCombo::AND - whichVecs() returns
        the intersection of whichVecs() from all evaluated constituent tests

        """
        return _Anasazi.StatusTestComboEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """
        howMany(StatusTestComboEpetra self) -> int

        int
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::howMany() const

        Get the number of vectors that passed the test. 
        """
        return _Anasazi.StatusTestComboEpetra_howMany(self, *args)


    def setComboType(self, *args):
        """
        setComboType(StatusTestComboEpetra self, Anasazi::StatusTestCombo< double,Epetra_MultiVector,Epetra_Operator >::ComboType type)

        void
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::setComboType(ComboType
        type)

        Set the maximum number of iterations. This also resets the test status
        to ::Undefined. 
        """
        return _Anasazi.StatusTestComboEpetra_setComboType(self, *args)


    def getComboType(self, *args):
        """
        getComboType(StatusTestComboEpetra self) -> Anasazi::StatusTestCombo< double,Epetra_MultiVector,Epetra_Operator >::ComboType

        ComboType Anasazi::StatusTestCombo< ScalarType, MV, OP
        >::getComboType() const

        Get the maximum number of iterations. 
        """
        return _Anasazi.StatusTestComboEpetra_getComboType(self, *args)


    def setTests(self, *args):
        """
        setTests(StatusTestComboEpetra self, Teuchos::Array< Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > > tests)

        void
        Anasazi::StatusTestCombo< ScalarType, MV, OP
        >::setTests(Teuchos::Array< Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > > tests)

        Set the tests This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestComboEpetra_setTests(self, *args)


    def getTests(self, *args):
        """
        getTests(StatusTestComboEpetra self) -> Teuchos::Array< Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > >

        Teuchos::Array<Teuchos::RCP<StatusTest<ScalarType,MV,OP> > >
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::getTests() const

        Get the tests. 
        """
        return _Anasazi.StatusTestComboEpetra_getTests(self, *args)


    def addTest(self, *args):
        """
        addTest(StatusTestComboEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)

        void
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::addTest(Teuchos::RCP<
        StatusTest< ScalarType, MV, OP > > test)

        Add a test to the combination.

        This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestComboEpetra_addTest(self, *args)


    def removeTest(self, *args):
        """
        removeTest(StatusTestComboEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & test)

        void
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::removeTest(const
        Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &test)

        Removes a test from the combination, if it exists in the tester.

        This also resets the test status to ::Undefined, if a test was
        removed. 
        """
        return _Anasazi.StatusTestComboEpetra_removeTest(self, *args)


    def reset(self, *args):
        """
        reset(StatusTestComboEpetra self)

        void
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::reset()

        Informs the status test that it should reset its internal
        configuration to the uninitialized state.

        The StatusTestCombo class has no internal state, but children classes
        might, so this method will call reset() on all child status tests. It
        also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestComboEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """
        clearStatus(StatusTestComboEpetra self)

        void
        Anasazi::StatusTestCombo< ScalarType, MV, OP >::clearStatus()

        Clears the results of the last status test.

        This should be distinguished from the reset() method, as it only
        clears the cached result from the last status test, so that a call to
        getStatus() will return ::Undefined. This is necessary for the
        StatusTestCombo::SEQOR and StatusTestCombo::SEQAND tests in the
        StatusTestCombo class, which may short circuit and not evaluate all of
        the StatusTests contained in them. 
        """
        return _Anasazi.StatusTestComboEpetra_clearStatus(self, *args)

StatusTestComboEpetra_swigregister = _Anasazi.StatusTestComboEpetra_swigregister
StatusTestComboEpetra_swigregister(StatusTestComboEpetra)

class StatusTestMaxItersEpetra(StatusTestEpetra):
    """


    A status test for testing the number of iterations.

    Anasazi::StatusTestMaxIters will test true when an eigensolver has
    reached some number of iterations. Specifically,                  {
    Passed,  if solver->getNumIters() >= maxIter status(solver) = {
    { Failed,  if solver->getNumIters()  < maxIter where maxIter is the
    parameter given to the status tester.

    This status test also supports negation, so that it negates the need
    for a StatusTestMinIters status tester. In this way, all tests on the
    range of iterations can be constructed through the appropriate use of
    StatusTestMaxIters and StatusTestCombo.

    C++ includes: AnasaziStatusTestMaxIters.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestMaxItersEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestMaxItersEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::StatusTestMaxIters<(double,Epetra_MultiVector,Epetra_Operator)> self, int maxIter, bool negate=False) -> StatusTestMaxItersEpetra

        Anasazi::StatusTestMaxIters< ScalarType, MV, OP
        >::StatusTestMaxIters(int maxIter, bool negate=false)

        Constructor. 
        """
        this = _Anasazi.new_StatusTestMaxItersEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestMaxItersEpetra

    def checkStatus(self, *args):
        """
        checkStatus(StatusTestMaxItersEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestMaxIters< ScalarType, MV, OP
        >::checkStatus(Eigensolver< ScalarType, MV, OP > *solver)

        Check status as defined by test.

        TestStatus indicating whether the test passed or failed. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(StatusTestMaxItersEpetra self) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestMaxIters< ScalarType, MV, OP
        >::getStatus() const

        Return the result of the most recent checkStatus call. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """
        whichVecs(StatusTestMaxItersEpetra self) -> VectorInt

        std::vector<int> Anasazi::StatusTestMaxIters< ScalarType, MV, OP
        >::whichVecs() const

        Get the indices for the vectors that passed the test. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """
        howMany(StatusTestMaxItersEpetra self) -> int

        int
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::howMany() const

        Get the number of vectors that passed the test. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_howMany(self, *args)


    def setMaxIters(self, *args):
        """
        setMaxIters(StatusTestMaxItersEpetra self, int maxIters)

        void
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::setMaxIters(int
        maxIters)

        Set the maximum number of iterations.

        This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_setMaxIters(self, *args)


    def getMaxIters(self, *args):
        """
        getMaxIters(StatusTestMaxItersEpetra self) -> int

        int
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::getMaxIters()

        Get the maximum number of iterations. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_getMaxIters(self, *args)


    def setNegate(self, *args):
        """
        setNegate(StatusTestMaxItersEpetra self, bool negate)

        void
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::setNegate(bool
        negate)

        Set the negation policy for the status test.

        This also reset the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_setNegate(self, *args)


    def getNegate(self, *args):
        """
        getNegate(StatusTestMaxItersEpetra self) -> bool

        bool
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::getNegate() const

        Get the negation policy for the status test. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_getNegate(self, *args)


    def reset(self, *args):
        """
        reset(StatusTestMaxItersEpetra self)

        void
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::reset()

        Informs the status test that it should reset its internal
        configuration to the uninitialized state.

        The StatusTestMaxIters class has no internal state, so this call is
        equivalent to calling clearStatus(). eigenvalue problem. The status
        test may have information that pertains to a particular problem or
        solver state. The internal information will be reset back to the
        uninitialized state. The user specified information that the
        convergence test uses will remain. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """
        clearStatus(StatusTestMaxItersEpetra self)

        void
        Anasazi::StatusTestMaxIters< ScalarType, MV, OP >::clearStatus()

        Clears the results of the last status test.

        This should be distinguished from the reset() method, as it only
        clears the cached result from the last status test, so that a call to
        getStatus() will return ::Undefined. This is necessary for the SEQOR
        and SEQAND tests in the StatusTestCombo class, which may short circuit
        and not evaluate all of the StatusTests contained in them. 
        """
        return _Anasazi.StatusTestMaxItersEpetra_clearStatus(self, *args)

StatusTestMaxItersEpetra_swigregister = _Anasazi.StatusTestMaxItersEpetra_swigregister
StatusTestMaxItersEpetra_swigregister(StatusTestMaxItersEpetra)

class StatusTestOutputEpetra(StatusTestEpetra):
    """


    A special StatusTest for printing other status tests.

    StatusTestOutput is a wrapper around another StatusTest that calls
    StatusTest::print() on the underlying object on calls to
    StatusTestOutput::checkStatus(). The frequency and occasion of the
    printing can be dictated according to some parameters passed to
    StatusTestOutput::StatusTestOutput().

    C++ includes: AnasaziStatusTestOutput.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestOutputEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestOutputEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::StatusTestOutput<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test, int mod=1, int printStates) -> StatusTestOutputEpetra

        Anasazi::StatusTestOutput< ScalarType, MV, OP
        >::StatusTestOutput(const Teuchos::RCP< OutputManager< ScalarType > >
        &printer, Teuchos::RCP< StatusTest< ScalarType, MV, OP > > test, int
        mod=1, int printStates=Passed)

        Constructor.

        The StatusTestOutput requires an OutputManager for printing the
        underlying StatusTest on calls to checkStatus(), as well as an
        underlying StatusTest.

        StatusTestOutput can be initialized with a null pointer for argument
        test. However, calling checkStatus() with a null child pointer will
        result in a StatusTestError exception being thrown. See checkStatus()
        for more information.

        The last two parameters, described below, in addition to the verbosity
        level of the OutputManager, control when printing is called. When both
        the mod criterion and the printStates criterion are satisfied, the
        status test will be printed to the OutputManager with ::MsgType of
        ::StatusTestDetails.

        Parameters:
        -----------

        mod:  A positive number describes how often the output should be
        printed. On every call to checkStatus(), an internal counter is
        incremented. Printing may only occur when this counter is congruent to
        zero modulo mod. Default: 1 (attempt to print on every call to
        checkStatus())

        printStates:  A combination of ::TestStatus values for which the
        output may be printed. Default: ::Passed (attempt to print whenever
        checkStatus() will return ::Passed) 
        """
        this = _Anasazi.new_StatusTestOutputEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestOutputEpetra

    def checkStatus(self, *args):
        """
        checkStatus(StatusTestOutputEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestOutput< ScalarType, MV, OP
        >::checkStatus(Eigensolver< ScalarType, MV, OP > *solver)

        Check and return status of underlying StatusTest.

        This method calls checkStatus() on the StatusTest object passed in the
        constructor. If appropriate, the method will follow this call with a
        call to print() on the underlying object, using the OutputManager
        passed via the constructor with verbosity level ::StatusTestDetails.

        The internal counter will be incremented during this call, but only
        after performing the tests to decide whether or not to print the
        underlying StatusTest. This way, the very first call to checkStatus()
        following initialization or reset() will enable the underlying
        StatusTest to be printed, regardless of the mod parameter, as the
        current number of calls will be zero.

        If the specified Teuchos::RCP for the child class is Teuchos::null,
        then calling checkStatus() will result in a StatusTestError exception
        being thrown.

        ::TestStatus indicating whether the underlying test passed or failed.

        """
        return _Anasazi.StatusTestOutputEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(StatusTestOutputEpetra self) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestOutput< ScalarType, MV, OP
        >::getStatus() const

        Return the result of the most recent checkStatus call, or undefined if
        it has not been run. 
        """
        return _Anasazi.StatusTestOutputEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """
        whichVecs(StatusTestOutputEpetra self) -> VectorInt

        std::vector<int> Anasazi::StatusTestOutput< ScalarType, MV, OP
        >::whichVecs() const

        Get the indices for the vectors that passed the test. 
        """
        return _Anasazi.StatusTestOutputEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """
        howMany(StatusTestOutputEpetra self) -> int

        int
        Anasazi::StatusTestOutput< ScalarType, MV, OP >::howMany() const

        Get the number of vectors that passed the test. 
        """
        return _Anasazi.StatusTestOutputEpetra_howMany(self, *args)


    def setChild(self, *args):
        """
        setChild(StatusTestOutputEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)

        void
        Anasazi::StatusTestOutput< ScalarType, MV, OP
        >::setChild(Teuchos::RCP< StatusTest< ScalarType, MV, OP > > test)

        Set child test.

        This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestOutputEpetra_setChild(self, *args)


    def getChild(self, *args):
        """
        getChild(StatusTestOutputEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >

        Teuchos::RCP<StatusTest<ScalarType,MV,OP> > Anasazi::StatusTestOutput<
        ScalarType, MV, OP >::getChild() const

        Get child test. 
        """
        return _Anasazi.StatusTestOutputEpetra_getChild(self, *args)


    def reset(self, *args):
        """
        reset(StatusTestOutputEpetra self)

        void
        Anasazi::StatusTestOutput< ScalarType, MV, OP >::reset()

        Informs the status test that it should reset its internal
        configuration to the uninitialized state.

        This resets the cached state to an ::Undefined state and calls reset()
        on the underlying test. It also resets the counter for the number of
        calls to checkStatus(). 
        """
        return _Anasazi.StatusTestOutputEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """
        clearStatus(StatusTestOutputEpetra self)

        void
        Anasazi::StatusTestOutput< ScalarType, MV, OP >::clearStatus()

        Clears the results of the last status test. This resets the cached
        state to an ::Undefined state and calls clearStatus() on the
        underlying test. 
        """
        return _Anasazi.StatusTestOutputEpetra_clearStatus(self, *args)

StatusTestOutputEpetra_swigregister = _Anasazi.StatusTestOutputEpetra_swigregister
StatusTestOutputEpetra_swigregister(StatusTestOutputEpetra)

class StatusTestResNormEpetra(StatusTestEpetra):
    """


    A status test for testing the norm of the eigenvectors residuals.

    StatusTestResNorm was designed to be used as a test for convergence.
    The tester compares the norms of the residual vectors against a user
    specified tolerance.

    In addition to specifying the tolerance, the user may specify: the
    norm to be used: 2-norm or OrthoManager::norm() or
    Eigensolver::getRitzRes2Norms()

    the scale: absolute or relative to magnitude of Ritz value

    the quorum: the number of vectors required for the test to evaluate as
    ::Passed.

    C++ includes: AnasaziStatusTestResNorm.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestResNormEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestResNormEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::StatusTestResNorm<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::ScalarTraits< double >::magnitudeType tol, int quorum=-1, Anasazi::ResType whichNorm, bool scaled=True, bool throwExceptionOnNaN=True) -> StatusTestResNormEpetra

        Anasazi::StatusTestResNorm< ScalarType, MV, OP
        >::StatusTestResNorm(typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType tol, int quorum=-1, ResType whichNorm=RES_ORTH, bool
        scaled=true, bool throwExceptionOnNaN=true)

        Constructor. 
        """
        this = _Anasazi.new_StatusTestResNormEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestResNormEpetra

    def checkStatus(self, *args):
        """
        checkStatus(StatusTestResNormEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestResNorm< ScalarType, MV, OP
        >::checkStatus(Eigensolver< ScalarType, MV, OP > *solver)

        Check status as defined by test.

        TestStatus indicating whether the test passed or failed. 
        """
        return _Anasazi.StatusTestResNormEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """
        getStatus(StatusTestResNormEpetra self) -> Anasazi::TestStatus

        TestStatus Anasazi::StatusTestResNorm< ScalarType, MV, OP
        >::getStatus() const

        Return the result of the most recent checkStatus call, or undefined if
        it has not been run. 
        """
        return _Anasazi.StatusTestResNormEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """
        whichVecs(StatusTestResNormEpetra self) -> VectorInt

        std::vector<int> Anasazi::StatusTestResNorm< ScalarType, MV, OP
        >::whichVecs() const

        Get the indices for the vectors that passed the test. 
        """
        return _Anasazi.StatusTestResNormEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """
        howMany(StatusTestResNormEpetra self) -> int

        int
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::howMany() const

        Get the number of vectors that passed the test. 
        """
        return _Anasazi.StatusTestResNormEpetra_howMany(self, *args)


    def setQuorum(self, *args):
        """
        setQuorum(StatusTestResNormEpetra self, int quorum)

        void
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::setQuorum(int
        quorum)

        Set quorum.

        Setting quorum to -1 signifies that all residuals from the solver must
        meet the tolerance. This also resets the test status to ::Undefined.

        """
        return _Anasazi.StatusTestResNormEpetra_setQuorum(self, *args)


    def getQuorum(self, *args):
        """
        getQuorum(StatusTestResNormEpetra self) -> int

        int
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::getQuorum() const

        Get quorum. 
        """
        return _Anasazi.StatusTestResNormEpetra_getQuorum(self, *args)


    def setTolerance(self, *args):
        """
        setTolerance(StatusTestResNormEpetra self, Teuchos::ScalarTraits< double >::magnitudeType tol)

        void
        Anasazi::StatusTestResNorm< ScalarType, MV, OP
        >::setTolerance(typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType tol)

        Set tolerance. This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestResNormEpetra_setTolerance(self, *args)


    def getTolerance(self, *args):
        """
        getTolerance(StatusTestResNormEpetra self) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits<ScalarType>::magnitudeType
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::getTolerance()

        Get tolerance. 
        """
        return _Anasazi.StatusTestResNormEpetra_getTolerance(self, *args)


    def setWhichNorm(self, *args):
        """
        setWhichNorm(StatusTestResNormEpetra self, Anasazi::ResType whichNorm)

        void
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::setWhichNorm(ResType
        whichNorm)

        Set the residual norm to be used by the status test.

        This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestResNormEpetra_setWhichNorm(self, *args)


    def getWhichNorm(self, *args):
        """
        getWhichNorm(StatusTestResNormEpetra self) -> Anasazi::ResType

        ResType Anasazi::StatusTestResNorm< ScalarType, MV, OP
        >::getWhichNorm()

        Return the residual norm used by the status test. 
        """
        return _Anasazi.StatusTestResNormEpetra_getWhichNorm(self, *args)


    def setScale(self, *args):
        """
        setScale(StatusTestResNormEpetra self, bool relscale)

        void
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::setScale(bool
        relscale)

        Instruct test to scale norms by eigenvalue estimates (relative scale).
        This also resets the test status to ::Undefined. 
        """
        return _Anasazi.StatusTestResNormEpetra_setScale(self, *args)


    def getScale(self, *args):
        """
        getScale(StatusTestResNormEpetra self) -> bool

        bool
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::getScale()

        Returns true if the test scales the norms by the eigenvalue estimates
        (relative scale). 
        """
        return _Anasazi.StatusTestResNormEpetra_getScale(self, *args)


    def reset(self, *args):
        """
        reset(StatusTestResNormEpetra self)

        void
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::reset()

        Informs the status test that it should reset its internal
        configuration to the uninitialized state.

        This is necessary for the case when the status test is being reused by
        another solver or for another eigenvalue problem. The status test may
        have information that pertains to a particular problem or solver
        state. The internal information will be reset back to the
        uninitialized state. The user specified information that the
        convergence test uses will remain. 
        """
        return _Anasazi.StatusTestResNormEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """
        clearStatus(StatusTestResNormEpetra self)

        void
        Anasazi::StatusTestResNorm< ScalarType, MV, OP >::clearStatus()

        Clears the results of the last status test.

        This should be distinguished from the reset() method, as it only
        clears the cached result from the last status test, so that a call to
        getStatus() will return ::Undefined. This is necessary for the SEQOR
        and SEQAND tests in the StatusTestCombo class, which may short circuit
        and not evaluate all of the StatusTests contained in them. 
        """
        return _Anasazi.StatusTestResNormEpetra_clearStatus(self, *args)

StatusTestResNormEpetra_swigregister = _Anasazi.StatusTestResNormEpetra_swigregister
StatusTestResNormEpetra_swigregister(StatusTestResNormEpetra)

class OrthoManagerEpetra(_object):
    """


    Anasazi's templated virtual class for providing routines for
    orthogonalization and orthonormalization of multivectors.

    This class defines concepts of orthogonality through the definition of
    an inner product. It also provides computational routines for
    orthogonalization.

    A concrete implementation of this class is necessary. The user can
    create their own implementation if those supplied are not suitable for
    their needs.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziOrthoManager.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OrthoManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_OrthoManagerEpetra

    def innerProd(self, *args):
        """
        innerProd(OrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::SerialDenseMatrix< int,double > & Z)

        virtual void
        Anasazi::OrthoManager< ScalarType, MV >::innerProd(const MV &X, const
        MV &Y, Teuchos::SerialDenseMatrix< int, ScalarType > &Z) const =0

        Provides the inner product defining the orthogonality concepts.

        All concepts of orthogonality discussed in this class are defined with
        respect to this inner product.

        This is potentially different from MultiVecTraits::MvTransMv(). For
        example, it is customary in many eigensolvers to exploit a mass matrix
        M for the inner product: $x^HMx$.

        Parameters:
        -----------

        Z:  [out] Z(i,j) contains the inner product of X[i] and Y[i]: \\[
        Z(i,j) = \\langle X[i], Y[i] \\rangle \\] 
        """
        return _Anasazi.OrthoManagerEpetra_innerProd(self, *args)


    def norm(self, *args):
        """
        norm(OrthoManagerEpetra self, MultiVector X, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec)

        virtual void
        Anasazi::OrthoManager< ScalarType, MV >::norm(const MV &X,
        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > &normvec) const =0

        Provides the norm induced by innerProd().

        This computes the norm for each column of a multivector. This is the
        norm induced by innerProd(): \\[ \\|x\\| = \\sqrt{\\langle
        x, x \\rangle} \\]

        Parameters:
        -----------

        normvec:  [out] Vector of norms, whose i-th entry corresponds to the
        i-th column of X

        normvec.size() == GetNumberVecs(X) 
        """
        return _Anasazi.OrthoManagerEpetra_norm(self, *args)


    def normalize(self, *args):
        """
        normalize(OrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,double > > B) -> int

        virtual int
        Anasazi::OrthoManager< ScalarType, MV >::normalize(MV &X,
        Teuchos::RCP< Teuchos::SerialDenseMatrix< int, ScalarType > >
        B=Teuchos::null) const =0

        This method takes a multivector X and attempts to compute a basis for
        $colspan(X)$. This basis is orthonormal with respect to innerProd().

        This routine returns an integer rank stating the rank of the computed
        basis. If X does not have full rank and the normalize() routine does
        not attempt to augment the subspace, then rank may be smaller than the
        number of columns in X. In this case, only the first rank columns of
        output X and first rank rows of B will be valid.

        Parameters:
        -----------

        X:  [in/out] The multivector to be modified.  On output, the first
        rank columns of X satisfy \\[ \\langle X[i], X[j] \\rangle =
        \\delta_{ij}\\ . \\] Also, \\[ X_{in}(1:m,1:n) =
        X_{out}(1:m,1:rank) B(1:rank,1:n)\\ , \\] where m is the number of
        rows in X and n is the number of columns in X.

        B:  [out] The coefficients of the original X with respect to the
        computed basis. If B is a non-null pointer and B matches the
        dimensions of B, then the coefficients computed during the
        orthogonalization routine will be stored in B, similar to calling If B
        points to a Teuchos::SerialDenseMatrix with size inconsistent with X,
        then a std::invalid_argument exception will be thrown.  Otherwise, if
        B is null, the caller will not have access to the computed
        coefficients.

        This matrix is not necessarily triangular (as in a QR factorization);
        see the documentation of specific orthogonalization managers.

        Rank of the basis computed by this method, less than or equal to the
        number of columns in X. This specifies how many columns in the
        returned X and rows in the returned B are valid. 
        """
        return _Anasazi.OrthoManagerEpetra_normalize(self, *args)


    def orthonormError(self, *args):
        """
        orthonormError(OrthoManagerEpetra self, MultiVector X) -> Teuchos::ScalarTraits< double >::magnitudeType

        virtual
        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::OrthoManager< ScalarType, MV >::orthonormError(const MV &X)
        const =0

        This method computes the error in orthonormality of a multivector.

        This method return some measure of $\\| \\langle X, X \\rangle -
        I \\| $.  See the documentation of specific orthogonalization
        managers. 
        """
        return _Anasazi.OrthoManagerEpetra_orthonormError(self, *args)


    def orthogError(self, *args):
        """
        orthogError(OrthoManagerEpetra self, MultiVector X1, MultiVector X2) -> Teuchos::ScalarTraits< double >::magnitudeType

        virtual
        Teuchos::ScalarTraits<ScalarType>::magnitudeType
        Anasazi::OrthoManager< ScalarType, MV >::orthogError(const MV &X1,
        const MV &X2) const =0

        This method computes the error in orthogonality of two multivectors.

        This method return some measure of $\\| \\langle X1, X2 \\rangle
        \\| $.  See the documentation of specific orthogonalization
        managers. 
        """
        return _Anasazi.OrthoManagerEpetra_orthogError(self, *args)

OrthoManagerEpetra_swigregister = _Anasazi.OrthoManagerEpetra_swigregister
OrthoManagerEpetra_swigregister(OrthoManagerEpetra)

class MatOrthoManagerEpetra(OrthoManagerEpetra):
    """


    Anasazi's templated virtual class for providing routines for
    orthogonalization and orthonormalization of multivectors using matrix-
    based inner products.

    This class extends Anasazi::OrthoManager by providing extra calling
    arguments to orthogonalization routines, to reduce the cost of
    applying the inner product in cases where the user already has the
    image of target multivectors under the inner product matrix.

    A concrete implementation of this class is necessary. The user can
    create their own implementation if those supplied are not suitable for
    their needs.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziMatOrthoManager.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [OrthoManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatOrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthoManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MatOrthoManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_MatOrthoManagerEpetra

    def setOp(self, *args):
        """
        setOp(MatOrthoManagerEpetra self, Teuchos::RCP< Epetra_Operator const > Op)

        void
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::setOp(Teuchos::RCP<
        const OP > Op)

        Set operator used for inner product. 
        """
        return _Anasazi.MatOrthoManagerEpetra_setOp(self, *args)


    def getOp(self, *args):
        """
        getOp(MatOrthoManagerEpetra self) -> Teuchos::RCP< Epetra_Operator const >

        Teuchos::RCP<
        const OP > Anasazi::MatOrthoManager< ScalarType, MV, OP >::getOp()
        const

        Get operator used for inner product. 
        """
        return _Anasazi.MatOrthoManagerEpetra_getOp(self, *args)


    def getOpCounter(self, *args):
        """
        getOpCounter(MatOrthoManagerEpetra self) -> int

        int
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::getOpCounter() const

        Retrieve operator counter.

        This counter returns the number of applications of the operator
        specifying the inner product. When the operator is applied to a
        multivector, the counter is incremented by the number of vectors in
        the multivector. If the operator is not specified, the counter is
        never incremented. 
        """
        return _Anasazi.MatOrthoManagerEpetra_getOpCounter(self, *args)


    def resetOpCounter(self, *args):
        """
        resetOpCounter(MatOrthoManagerEpetra self)

        void
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::resetOpCounter()

        Reset the operator counter to zero.

        See getOpCounter() for more details. 
        """
        return _Anasazi.MatOrthoManagerEpetra_resetOpCounter(self, *args)


    def innerProdMat(self, *args):
        """
        innerProdMat(MatOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::SerialDenseMatrix< int,double > & Z, Teuchos::RCP< Epetra_MultiVector const > MX, Teuchos::RCP< Epetra_MultiVector const > MY)

        void
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::innerProdMat(const MV
        &X, const MV &Y, Teuchos::SerialDenseMatrix< int, ScalarType > &Z,
        Teuchos::RCP< const MV > MX=Teuchos::null, Teuchos::RCP< const MV >
        MY=Teuchos::null) const

        Provides a matrix-based inner product.

        Provides the inner product \\[ \\langle x, y \\rangle = x^H M y
        \\] Optionally allows the provision of $M y$ and/or $M x$. See
        OrthoManager::innerProd() for more details. 
        """
        return _Anasazi.MatOrthoManagerEpetra_innerProdMat(self, *args)


    def normMat(self, *args):
        """
        normMat(MatOrthoManagerEpetra self, MultiVector X, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec, Teuchos::RCP< Epetra_MultiVector const > MX)

        void
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::normMat(const MV &X,
        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > &normvec, Teuchos::RCP< const MV >
        MX=Teuchos::null) const

        Provides the norm induced by the matrix-based inner product.

        Provides the norm: \\[ \\|x\\|_M = \\sqrt{x^H M y} \\]
        Optionally allows the provision of $M x$. See OrthoManager::norm() for
        more details. 
        """
        return _Anasazi.MatOrthoManagerEpetra_normMat(self, *args)


    def normalizeMat(self, *args):
        """
        normalizeMat(MatOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,double > > B, Teuchos::RCP< Epetra_MultiVector > MX) -> int

        virtual int Anasazi::MatOrthoManager< ScalarType, MV, OP
        >::normalizeMat(MV &X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,
        ScalarType > > B=Teuchos::null, Teuchos::RCP< MV > MX=Teuchos::null)
        const =0

        Provides matrix-based orthonormalization method.

        This method optionally allows the provision of $M X$. See
        orthoManager::normalize() for more details.

        Parameters:
        -----------

        X:  B:  [in/out] As in OrthoManager::normalize()

        MX:  [in/out] If specified by the user, on input MX is required to be
        the image of X under the operator getOp(). On output, MX will be
        updated to reflect the changes in X.

        Rank of the basis computed by this method, less than or equal to the
        number of columns in X. This specifies how many columns in the
        returned X and MX and rows in the returned B are valid. 
        """
        return _Anasazi.MatOrthoManagerEpetra_normalizeMat(self, *args)


    def orthonormErrorMat(self, *args):
        """
        orthonormErrorMat(MatOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Epetra_MultiVector const > MX) -> Teuchos::ScalarTraits< double >::magnitudeType

        virtual Teuchos::ScalarTraits<ScalarType>::magnitudeType
        Anasazi::MatOrthoManager< ScalarType, MV, OP
        >::orthonormErrorMat(const MV &X, Teuchos::RCP< const MV >
        MX=Teuchos::null) const =0

        This method computes the error in orthonormality of a multivector.

        This method optionally allows optionally exploits a caller-provided
        MX. 
        """
        return _Anasazi.MatOrthoManagerEpetra_orthonormErrorMat(self, *args)


    def orthogErrorMat(self, *args):
        """
        orthogErrorMat(MatOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::RCP< Epetra_MultiVector const > MX, Teuchos::RCP< Epetra_MultiVector const > MY) -> Teuchos::ScalarTraits< double >::magnitudeType

        virtual Teuchos::ScalarTraits<ScalarType>::magnitudeType
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::orthogErrorMat(const
        MV &X, const MV &Y, Teuchos::RCP< const MV > MX=Teuchos::null,
        Teuchos::RCP< const MV > MY=Teuchos::null) const =0

        This method computes the error in orthogonality of two multivectors.

        This method optionally allows optionally exploits a caller-provided MX
        and/or MY. 
        """
        return _Anasazi.MatOrthoManagerEpetra_orthogErrorMat(self, *args)


    def innerProd(self, *args):
        """
        innerProd(MatOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::SerialDenseMatrix< int,double > & Z)

        void
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::innerProd(const MV &X,
        const MV &Y, Teuchos::SerialDenseMatrix< int, ScalarType > &Z) const

        Implements the interface OrthoManager::innerProd().

        This method calls 
        """
        return _Anasazi.MatOrthoManagerEpetra_innerProd(self, *args)


    def norm(self, *args):
        """
        norm(MatOrthoManagerEpetra self, MultiVector X, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec)

        void
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::norm(const MV &X,
        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > &normvec) const

        Implements the interface OrthoManager::norm().

        This method calls 
        """
        return _Anasazi.MatOrthoManagerEpetra_norm(self, *args)


    def normalize(self, *args):
        """
        normalize(MatOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,double > > B) -> int

        int
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::normalize(MV &X,
        Teuchos::RCP< Teuchos::SerialDenseMatrix< int, ScalarType > >
        B=Teuchos::null) const

        Implements the interface OrthoManager::normalize().

        This method calls 
        """
        return _Anasazi.MatOrthoManagerEpetra_normalize(self, *args)


    def orthonormError(self, *args):
        """
        orthonormError(MatOrthoManagerEpetra self, MultiVector X) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::orthonormError(const
        MV &X) const

        Implements the interface OrthoManager::orthonormError().

        This method calls 
        """
        return _Anasazi.MatOrthoManagerEpetra_orthonormError(self, *args)


    def orthogError(self, *args):
        """
        orthogError(MatOrthoManagerEpetra self, MultiVector X1, MultiVector X2) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::MatOrthoManager< ScalarType, MV, OP >::orthogError(const MV
        &X1, const MV &X2) const

        Implements the interface OrthoManager::orthogError().

        This method calls 
        """
        return _Anasazi.MatOrthoManagerEpetra_orthogError(self, *args)

MatOrthoManagerEpetra_swigregister = _Anasazi.MatOrthoManagerEpetra_swigregister
MatOrthoManagerEpetra_swigregister(MatOrthoManagerEpetra)

class BasicOrthoManagerEpetra(MatOrthoManagerEpetra):
    """


    An implementation of the Anasazi::MatOrthoManager that performs
    orthogonalization using (potentially) multiple steps of classical
    Gram-Schmidt.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziBasicOrthoManager.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicOrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicOrthoManagerEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BasicOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > Op, Teuchos::ScalarTraits< double >::magnitudeType kappa=1.41421356, Teuchos::ScalarTraits< double >::magnitudeType eps=0.0, Teuchos::ScalarTraits< double >::magnitudeType tol=0.20) -> BasicOrthoManagerEpetra

        Anasazi::BasicOrthoManager< ScalarType, MV, OP
        >::BasicOrthoManager(Teuchos::RCP< const OP > Op=Teuchos::null,
        typename Teuchos::ScalarTraits< ScalarType >::magnitudeType
        kappa=1.41421356, typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType eps=0.0, typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType tol=0.20)

        Constructor specifying re-orthogonalization tolerance. 
        """
        this = _Anasazi.new_BasicOrthoManagerEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicOrthoManagerEpetra

    def orthonormErrorMat(self, *args):
        """
        orthonormErrorMat(BasicOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Epetra_MultiVector const > MX) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::BasicOrthoManager< ScalarType, MV, OP
        >::orthonormErrorMat(const MV &X, Teuchos::RCP< const MV >
        MX=Teuchos::null) const

        This method computes the error in orthonormality of a multivector,
        measured as the Frobenius norm of the difference innerProd(X,Y) - I.
        The method has the option of exploiting a caller-provided MX. 
        """
        return _Anasazi.BasicOrthoManagerEpetra_orthonormErrorMat(self, *args)


    def orthogErrorMat(self, *args):
        """
        orthogErrorMat(BasicOrthoManagerEpetra self, MultiVector X1, MultiVector X2, Teuchos::RCP< Epetra_MultiVector const > MX1, Teuchos::RCP< Epetra_MultiVector const > MX2) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::BasicOrthoManager< ScalarType, MV, OP >::orthogErrorMat(const
        MV &X1, const MV &X2, Teuchos::RCP< const MV > MX1, Teuchos::RCP<
        const MV > MX2) const

        This method computes the error in orthogonality of two multivectors,
        measured as the Frobenius norm of innerProd(X,Y). The method has the
        option of exploiting a caller-provided MX. 
        """
        return _Anasazi.BasicOrthoManagerEpetra_orthogErrorMat(self, *args)


    def setKappa(self, *args):
        """
        setKappa(BasicOrthoManagerEpetra self, Teuchos::ScalarTraits< double >::magnitudeType kappa)

        void
        Anasazi::BasicOrthoManager< ScalarType, MV, OP >::setKappa(typename
        Teuchos::ScalarTraits< ScalarType >::magnitudeType kappa)

        Set parameter for re-orthogonalization threshold. 
        """
        return _Anasazi.BasicOrthoManagerEpetra_setKappa(self, *args)


    def getKappa(self, *args):
        """
        getKappa(BasicOrthoManagerEpetra self) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits<ScalarType>::magnitudeType
        Anasazi::BasicOrthoManager< ScalarType, MV, OP >::getKappa() const

        Return parameter for re-orthogonalization threshold. 
        """
        return _Anasazi.BasicOrthoManagerEpetra_getKappa(self, *args)

BasicOrthoManagerEpetra_swigregister = _Anasazi.BasicOrthoManagerEpetra_swigregister
BasicOrthoManagerEpetra_swigregister(BasicOrthoManagerEpetra)

class SVQBOrthoManagerEpetra(MatOrthoManagerEpetra):
    """


    An implementation of the Anasazi::MatOrthoManager that performs
    orthogonalization using the SVQB iterative orthogonalization technique
    described by Stathapoulos and Wu. This orthogonalization routine,
    while not returning the upper triangular factors of the popular Gram-
    Schmidt method, has a communication cost (measured in number of
    communication calls) that is independent of the number of columns in
    the basis.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, and Heidi Thornquist

    C++ includes: AnasaziSVQBOrthoManager.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SVQBOrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SVQBOrthoManagerEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::SVQBOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > Op, bool debug=False) -> SVQBOrthoManagerEpetra

        Anasazi::SVQBOrthoManager< ScalarType, MV, OP
        >::SVQBOrthoManager(Teuchos::RCP< const OP > Op=Teuchos::null, bool
        debug=false)

        Constructor specifying re-orthogonalization tolerance. 
        """
        this = _Anasazi.new_SVQBOrthoManagerEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_SVQBOrthoManagerEpetra

    def orthonormErrorMat(self, *args):
        """
        orthonormErrorMat(SVQBOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Epetra_MultiVector const > MX) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::SVQBOrthoManager< ScalarType, MV, OP
        >::orthonormErrorMat(const MV &X, Teuchos::RCP< const MV >
        MX=Teuchos::null) const

        This method computes the error in orthonormality of a multivector,
        measured as the Frobenius norm of the difference innerProd(X,Y) - I.
        The method has the option of exploiting a caller-provided MX. 
        """
        return _Anasazi.SVQBOrthoManagerEpetra_orthonormErrorMat(self, *args)


    def orthogErrorMat(self, *args):
        """
        orthogErrorMat(SVQBOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::RCP< Epetra_MultiVector const > MX, Teuchos::RCP< Epetra_MultiVector const > MY) -> Teuchos::ScalarTraits< double >::magnitudeType

        Teuchos::ScalarTraits< ScalarType >::magnitudeType
        Anasazi::SVQBOrthoManager< ScalarType, MV, OP >::orthogErrorMat(const
        MV &X, const MV &Y, Teuchos::RCP< const MV > MX=Teuchos::null,
        Teuchos::RCP< const MV > MY=Teuchos::null) const

        This method computes the error in orthogonality of two multivectors,
        measured as the Frobenius norm of innerProd(X,Y). The method has the
        option of exploiting a caller-provided MX. 
        """
        return _Anasazi.SVQBOrthoManagerEpetra_orthogErrorMat(self, *args)

SVQBOrthoManagerEpetra_swigregister = _Anasazi.SVQBOrthoManagerEpetra_swigregister
SVQBOrthoManagerEpetra_swigregister(SVQBOrthoManagerEpetra)

class EigensolverEpetra(_object):
    """


    The Eigensolver is a templated virtual base class that defines the
    basic interface that any eigensolver will support.

    This interface is mainly concerned with providing a set of eigensolver
    status method that can be requested from any eigensolver by an
    StatusTest object.

    C++ includes: AnasaziEigensolverDecl.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EigensolverEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EigensolverEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_EigensolverEpetra

    def iterate(self, *args):
        """
        iterate(EigensolverEpetra self)

        virtual void
        Anasazi::Eigensolver< ScalarType, MV, OP >::iterate()=0

        This method performs eigensolvers iterations until the status test
        indicates the need to stop or an error occurs (in which case, an
        exception is thrown). 
        """
        return _Anasazi.EigensolverEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(EigensolverEpetra self)

        virtual void
        Anasazi::Eigensolver< ScalarType, MV, OP >::initialize()=0

        Initialize the solver with the initial vectors from the eigenproblem
        or random data. 
        """
        return _Anasazi.EigensolverEpetra_initialize(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(EigensolverEpetra self) -> int

        virtual int
        Anasazi::Eigensolver< ScalarType, MV, OP >::getNumIters() const =0

        Get the current iteration count. 
        """
        return _Anasazi.EigensolverEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """
        resetNumIters(EigensolverEpetra self)

        virtual
        void Anasazi::Eigensolver< ScalarType, MV, OP >::resetNumIters()=0

        Reset the iteration count. 
        """
        return _Anasazi.EigensolverEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """
        getRitzVectors(EigensolverEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        virtual
        Teuchos::RCP<const MV> Anasazi::Eigensolver< ScalarType, MV, OP
        >::getRitzVectors()=0

        Get the Ritz vectors from the previous iteration. These are indexed
        using getRitzIndex().

        For a description of the indexing scheme, see getRitzIndex(). 
        """
        return _Anasazi.EigensolverEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """
        getRitzValues(EigensolverEpetra self) -> VectorValueDouble

        virtual
        std::vector<Value<ScalarType> > Anasazi::Eigensolver< ScalarType, MV,
        OP >::getRitzValues()=0

        Get the Ritz values from the previous iteration. 
        """
        return _Anasazi.EigensolverEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """
        getRitzIndex(EigensolverEpetra self) -> VectorInt

        virtual
        std::vector<int> Anasazi::Eigensolver< ScalarType, MV, OP
        >::getRitzIndex()=0

        Get the index used for indexing the compressed storage used for Ritz
        vectors for real, non-Hermitian problems.

        index has length numVecs, where each entry is 0, +1, or -1. These have
        the following interpretation: index[i] == 0: signifies that the
        corresponding eigenvector is stored as the i column of Evecs. This
        will usually be the case when ScalarType is complex, an eigenproblem
        is Hermitian, or a real, non- Hermitian eigenproblem has a real
        eigenvector.

        index[i] == +1: signifies that the corresponding eigenvector is stored
        in two vectors: the real part in the i column of Evecs and the
        positive imaginary part in the i+1 column of Evecs.

        index[i] == -1: signifies that the corresponding eigenvector is stored
        in two vectors: the real part in the i-1 column of Evecs and the
        negative imaginary part in the i column of Evecs 
        """
        return _Anasazi.EigensolverEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """
        getResNorms(EigensolverEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        virtual
        std::vector<typename Teuchos::ScalarTraits<ScalarType>::magnitudeType>
        Anasazi::Eigensolver< ScalarType, MV, OP >::getResNorms()=0

        Get the current residual norms.

        A vector of length blockSize containing the norms of the residuals,
        according to the orthogonalization manager norm() method. 
        """
        return _Anasazi.EigensolverEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """
        getRes2Norms(EigensolverEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        virtual
        std::vector<typename Teuchos::ScalarTraits<ScalarType>::magnitudeType>
        Anasazi::Eigensolver< ScalarType, MV, OP >::getRes2Norms()=0

        Get the current residual 2-norms A vector of length blockSize
        containing the 2-norms of the residuals. 
        """
        return _Anasazi.EigensolverEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """
        getRitzRes2Norms(EigensolverEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        virtual std::vector<typename
        Teuchos::ScalarTraits<ScalarType>::magnitudeType>
        Anasazi::Eigensolver< ScalarType, MV, OP >::getRitzRes2Norms()=0

        Get the 2-norms of the Ritz residuals. A vector of length blockSize
        containing the 2-norms of the Ritz residuals. 
        """
        return _Anasazi.EigensolverEpetra_getRitzRes2Norms(self, *args)


    def getCurSubspaceDim(self, *args):
        """
        getCurSubspaceDim(EigensolverEpetra self) -> int

        virtual int Anasazi::Eigensolver< ScalarType, MV, OP
        >::getCurSubspaceDim() const =0

        Get the dimension of the search subspace used to generate the current
        eigenvectors and eigenvalues. 
        """
        return _Anasazi.EigensolverEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """
        getMaxSubspaceDim(EigensolverEpetra self) -> int

        virtual int Anasazi::Eigensolver< ScalarType, MV, OP
        >::getMaxSubspaceDim() const =0

        Get the maximum dimension allocated for the search subspace. 
        """
        return _Anasazi.EigensolverEpetra_getMaxSubspaceDim(self, *args)


    def setStatusTest(self, *args):
        """
        setStatusTest(EigensolverEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)

        virtual
        void Anasazi::Eigensolver< ScalarType, MV, OP
        >::setStatusTest(Teuchos::RCP< StatusTest< ScalarType, MV, OP > >
        test)=0

        Set a new StatusTest for the solver. 
        """
        return _Anasazi.EigensolverEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """
        getStatusTest(EigensolverEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >

        virtual
        Teuchos::RCP<StatusTest<ScalarType,MV,OP> > Anasazi::Eigensolver<
        ScalarType, MV, OP >::getStatusTest() const =0

        Get the current StatusTest used by the solver. 
        """
        return _Anasazi.EigensolverEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """
        getProblem(EigensolverEpetra self) -> EigenproblemEpetra

        virtual
        const Eigenproblem<ScalarType,MV,OP>& Anasazi::Eigensolver<
        ScalarType, MV, OP >::getProblem() const =0

        Get a constant reference to the eigenvalue problem. 
        """
        return _Anasazi.EigensolverEpetra_getProblem(self, *args)


    def getBlockSize(self, *args):
        """
        getBlockSize(EigensolverEpetra self) -> int

        virtual
        int Anasazi::Eigensolver< ScalarType, MV, OP >::getBlockSize() const
        =0

        Get the blocksize to be used by the iterative solver in solving this
        eigenproblem. 
        """
        return _Anasazi.EigensolverEpetra_getBlockSize(self, *args)


    def setBlockSize(self, *args):
        """
        setBlockSize(EigensolverEpetra self, int blockSize)

        virtual
        void Anasazi::Eigensolver< ScalarType, MV, OP >::setBlockSize(int
        blockSize)=0

        Set the blocksize to be used by the iterative solver in solving this
        eigenproblem. 
        """
        return _Anasazi.EigensolverEpetra_setBlockSize(self, *args)


    def setAuxVecs(self, *args):
        """
        setAuxVecs(EigensolverEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)

        virtual void
        Anasazi::Eigensolver< ScalarType, MV, OP >::setAuxVecs(const
        Teuchos::Array< Teuchos::RCP< const MV > > &auxvecs)=0

        Set the auxiliary vectors for the solver. 
        """
        return _Anasazi.EigensolverEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """
        getAuxVecs(EigensolverEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >

        virtual
        Teuchos::Array<Teuchos::RCP<const MV> > Anasazi::Eigensolver<
        ScalarType, MV, OP >::getAuxVecs() const =0

        Get the auxiliary vectors for the solver. 
        """
        return _Anasazi.EigensolverEpetra_getAuxVecs(self, *args)


    def isInitialized(self, *args):
        """
        isInitialized(EigensolverEpetra self) -> bool

        virtual
        bool Anasazi::Eigensolver< ScalarType, MV, OP >::isInitialized() const
        =0

        States whether the solver has been initialized or not. 
        """
        return _Anasazi.EigensolverEpetra_isInitialized(self, *args)


    def currentStatus(self, *args):
        """
        currentStatus(EigensolverEpetra self, std::ostream & os)

        virtual
        void Anasazi::Eigensolver< ScalarType, MV, OP
        >::currentStatus(std::ostream &os)=0

        This method requests that the solver print out its current status to
        screen. 
        """
        return _Anasazi.EigensolverEpetra_currentStatus(self, *args)

EigensolverEpetra_swigregister = _Anasazi.EigensolverEpetra_swigregister
EigensolverEpetra_swigregister(EigensolverEpetra)

class SolverManagerEpetra(_object):
    """


    The Anasazi::SolverManager is a templated virtual base class that
    defines the basic interface that any solver manager will support.

    C++ includes: AnasaziSolverManager.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverManagerEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_SolverManagerEpetra

    def getProblem(self, *args):
        """
        getProblem(SolverManagerEpetra self) -> EigenproblemEpetra

        virtual
        const Eigenproblem<ScalarType,MV,OP>& Anasazi::SolverManager<
        ScalarType, MV, OP >::getProblem() const =0

        Return the eigenvalue problem. 
        """
        return _Anasazi.SolverManagerEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(SolverManagerEpetra self) -> int

        virtual
        int Anasazi::SolverManager< ScalarType, MV, OP >::getNumIters() const
        =0

        Get the iteration count for the most recent call to  solve(). 
        """
        return _Anasazi.SolverManagerEpetra_getNumIters(self, *args)


    def getTimers(self, *args):
        """
        getTimers(SolverManagerEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >

        virtual
        Teuchos::Array<Teuchos::RCP<Teuchos::Time> > Anasazi::SolverManager<
        ScalarType, MV, OP >::getTimers() const

        Return the timers for this object. 
        """
        return _Anasazi.SolverManagerEpetra_getTimers(self, *args)


    def solve(self, *args):
        """
        solve(SolverManagerEpetra self) -> Anasazi::ReturnType

        virtual
        ReturnType Anasazi::SolverManager< ScalarType, MV, OP >::solve()=0

        This method performs possibly repeated calls to the underlying
        eigensolver's iterate() routine until the problem has been solved (as
        decided by the solver manager) or the solver manager decides to quit.

        ::ReturnType specifying: ::Converged: the eigenproblem was solved to
        the specification required by the solver manager.

        ::Unconverged: the eigenproblem was not solved to the specification
        desired by the solver manager 
        """
        return _Anasazi.SolverManagerEpetra_solve(self, *args)

SolverManagerEpetra_swigregister = _Anasazi.SolverManagerEpetra_swigregister
SolverManagerEpetra_swigregister(SolverManagerEpetra)

class BlockDavidsonEpetra(EigensolverEpetra):
    """


    This class implements a Block Davidson iteration, a preconditioned
    iteration for solving linear Hermitian eigenproblems.

    This method is described in A Comparison of Eigensolvers for Large-
    scale 3D Modal Analysis Using AMG-Preconditioned Iterative Methods, P.
    Arbenz, U. L. Hetmaniuk, R. B. Lehoucq, R. S. Tuminaro, Internat. J.
    for Numer. Methods Engrg., 64, pp. 204-236 (2005)

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, Heidi Thornquist

    C++ includes: AnasaziBlockDavidson.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockDavidson<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, Teuchos::RCP< Anasazi::SortManager< Teuchos::ScalarTraits< double >::magnitudeType > > const & sorter, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & tester, Teuchos::RCP< Anasazi::MatOrthoManager< double,Epetra_MultiVector,Epetra_Operator > > const & ortho, ParameterList params) -> BlockDavidsonEpetra

        Anasazi::BlockDavidson< ScalarType, MV, OP >::BlockDavidson(const
        Teuchos::RCP< Eigenproblem< ScalarType, MV, OP > > &problem, const
        Teuchos::RCP< SortManager< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > > &sorter, const Teuchos::RCP< OutputManager<
        ScalarType > > &printer, const Teuchos::RCP< StatusTest< ScalarType,
        MV, OP > > &tester, const Teuchos::RCP< MatOrthoManager< ScalarType,
        MV, OP > > &ortho, Teuchos::ParameterList &params)

        BlockDavidson constructor with eigenproblem, solver utilities, and
        parameter list of solver options.

        This constructor takes pointers required by the eigensolver, in
        addition to a parameter list of options for the eigensolver. These
        options include the following: "Block Size" - an int specifying the
        block size used by the algorithm. This can also be specified using the
        setBlockSize() method.

        "Num Blocks" - an int specifying the maximum number of blocks
        allocated for the solver basis. 
        """
        this = _Anasazi.new_BlockDavidsonEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonEpetra

    def iterate(self, *args):
        """
        iterate(BlockDavidsonEpetra self)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP >::iterate()

        This method performs BlockDavidson iterations until the status test
        indicates the need to stop or an error occurs (in which case, an
        appropriate exception is thrown).

        iterate() will first determine whether the solver is uninitialized; if
        not, it will call initialize(). After initialization, the solver
        performs block Davidson iterations until the status test evaluates as
        ::Passed, at which point the method returns to the caller.

        The block Davidson iteration proceeds as follows: The current residual
        (R) is preconditioned to form H

        H is orthogonalized against the auxiliary vectors and the previous
        basis vectors, and made orthonormal.

        The current basis is expanded with H and used to project the problem
        matrix.

        The projected eigenproblem is solved, and the desired eigenvectors and
        eigenvalues are selected.

        These are used to form the new eigenvector estimates (X).

        The new residual (R) is formed.

        The status test is queried at the beginning of the iteration.

        Possible exceptions thrown include std::invalid_argument or one of the
        BlockDavidson-specific exceptions. 
        """
        return _Anasazi.BlockDavidsonEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(BlockDavidsonEpetra self, Anasazi::BlockDavidsonState< double,Epetra_MultiVector > & newstate)
        initialize(BlockDavidsonEpetra self)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP >::initialize()

        Initialize the solver with the initial vectors from the eigenproblem
        or random data. 
        """
        return _Anasazi.BlockDavidsonEpetra_initialize(self, *args)


    def isInitialized(self, *args):
        """
        isInitialized(BlockDavidsonEpetra self) -> bool

        bool
        Anasazi::BlockDavidson< ScalarType, MV, OP >::isInitialized() const

        Indicates whether the solver has been initialized or not.

        bool indicating the state of the solver.

        If isInitialized() == true:  getCurSubspaceDim() > 0 and is a multiple
        of getBlockSize()

        the first getCurSubspaceDim() vectors of V are orthogonal to auxiliary
        vectors and have orthonormal columns

        the principal submatrix of order getCurSubspaceDim() of KK contains
        the project eigenproblem matrix

        X contains the Ritz vectors with respect to the current Krylov basis

        T contains the Ritz values with respect to the current Krylov basis

        KX == Op*X

        MX == M*X if M != Teuchos::null  Otherwise, MX == Teuchos::null

        R contains the residual vectors with respect to X 
        """
        return _Anasazi.BlockDavidsonEpetra_isInitialized(self, *args)


    def getState(self, *args):
        """
        getState(BlockDavidsonEpetra self) -> Anasazi::BlockDavidsonState< double,Epetra_MultiVector >

        BlockDavidsonState< ScalarType, MV > Anasazi::BlockDavidson<
        ScalarType, MV, OP >::getState() const

        Get access to the current state of the eigensolver.

        The data is only valid if isInitialized() == true.

        The data for the preconditioned residual is only meaningful in the
        scenario that the solver throws a ::BlockDavidsonRitzFailure exception
        during iterate().

        A BlockDavidsonState object containing const pointers to the current
        solver state. Note, these are direct pointers to the multivectors;
        they are not pointers to views of the multivectors. 
        """
        return _Anasazi.BlockDavidsonEpetra_getState(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(BlockDavidsonEpetra self) -> int

        int
        Anasazi::BlockDavidson< ScalarType, MV, OP >::getNumIters() const

        Get the current iteration count. 
        """
        return _Anasazi.BlockDavidsonEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """
        resetNumIters(BlockDavidsonEpetra self)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP >::resetNumIters()

        Reset the iteration count. 
        """
        return _Anasazi.BlockDavidsonEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """
        getRitzVectors(BlockDavidsonEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        Teuchos::RCP< const MV > Anasazi::BlockDavidson< ScalarType, MV, OP
        >::getRitzVectors()

        Get access to the current Ritz vectors.

        A multivector with getBlockSize() vectors containing the sorted Ritz
        vectors corresponding to the most significant Ritz values. The i-th
        vector of the return corresponds to the i-th Ritz vector; there is no
        need to use getRitzIndex(). 
        """
        return _Anasazi.BlockDavidsonEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """
        getRitzValues(BlockDavidsonEpetra self) -> VectorValueDouble

        std::vector< Value< ScalarType > > Anasazi::BlockDavidson< ScalarType,
        MV, OP >::getRitzValues()

        Get the Ritz values for the previous iteration.

        A vector of length getCurSubspaceDim() containing the Ritz values from
        the previous projected eigensolve. 
        """
        return _Anasazi.BlockDavidsonEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """
        getRitzIndex(BlockDavidsonEpetra self) -> VectorInt

        std::vector< int > Anasazi::BlockDavidson< ScalarType, MV, OP
        >::getRitzIndex()

        Get the index used for extracting individual Ritz vectors from
        getRitzVectors().

        Because BlockDavidson is a Hermitian solver, all Ritz values are real
        and all Ritz vectors can be represented in a single column of a
        multivector. Therefore, getRitzIndex() is not needed when using the
        output from getRitzVectors().

        An int vector of size getCurSubspaceDim() composed of zeros. 
        """
        return _Anasazi.BlockDavidsonEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """
        getResNorms(BlockDavidsonEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > Anasazi::BlockDavidson< ScalarType, MV, OP
        >::getResNorms()

        Get the current residual norms, computing the norms if they are not
        up-to-date with the current residual vectors.

        A vector of length getCurSubspaceDim() containing the norms of the
        residuals, with respect to the orthogonalization manager's norm()
        method. 
        """
        return _Anasazi.BlockDavidsonEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """
        getRes2Norms(BlockDavidsonEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > Anasazi::BlockDavidson< ScalarType, MV, OP
        >::getRes2Norms()

        Get the current residual 2-norms, computing the norms if they are not
        up-to-date with the current residual vectors.

        A vector of length getCurSubspaceDim() containing the 2-norms of the
        current residuals. 
        """
        return _Anasazi.BlockDavidsonEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """
        getRitzRes2Norms(BlockDavidsonEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > Anasazi::BlockDavidson< ScalarType, MV, OP
        >::getRitzRes2Norms()

        Get the 2-norms of the residuals.

        The Ritz residuals are not defined for the LOBPCG iteration. Hence,
        this method returns the 2-norms of the direct residuals, and is
        equivalent to calling getRes2Norms().

        A vector of length getBlockSize() containing the 2-norms of the direct
        residuals. 
        """
        return _Anasazi.BlockDavidsonEpetra_getRitzRes2Norms(self, *args)


    def getCurSubspaceDim(self, *args):
        """
        getCurSubspaceDim(BlockDavidsonEpetra self) -> int

        int
        Anasazi::BlockDavidson< ScalarType, MV, OP >::getCurSubspaceDim()
        const

        Get the dimension of the search subspace used to generate the current
        eigenvectors and eigenvalues.

        An integer specifying the rank of the Krylov subspace currently in use
        by the eigensolver. If isInitialized() == false, the return is 0.
        Otherwise, it will be some strictly positive multiple of
        getBlockSize(). 
        """
        return _Anasazi.BlockDavidsonEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """
        getMaxSubspaceDim(BlockDavidsonEpetra self) -> int

        int
        Anasazi::BlockDavidson< ScalarType, MV, OP >::getMaxSubspaceDim()
        const

        Get the maximum dimension allocated for the search subspace. For
        BlockDavidson, this always returns numBlocks*blockSize. 
        """
        return _Anasazi.BlockDavidsonEpetra_getMaxSubspaceDim(self, *args)


    def setStatusTest(self, *args):
        """
        setStatusTest(BlockDavidsonEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP
        >::setStatusTest(Teuchos::RCP< StatusTest< ScalarType, MV, OP > >
        test)

        Set a new StatusTest for the solver. 
        """
        return _Anasazi.BlockDavidsonEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """
        getStatusTest(BlockDavidsonEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >

        Teuchos::RCP< StatusTest< ScalarType, MV, OP > >
        Anasazi::BlockDavidson< ScalarType, MV, OP >::getStatusTest() const

        Get the current StatusTest used by the solver. 
        """
        return _Anasazi.BlockDavidsonEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """
        getProblem(BlockDavidsonEpetra self) -> EigenproblemEpetra

        const
        Eigenproblem< ScalarType, MV, OP > & Anasazi::BlockDavidson<
        ScalarType, MV, OP >::getProblem() const

        Get a constant reference to the eigenvalue problem. 
        """
        return _Anasazi.BlockDavidsonEpetra_getProblem(self, *args)


    def setBlockSize(self, *args):
        """
        setBlockSize(BlockDavidsonEpetra self, int blockSize)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP >::setBlockSize(int
        blockSize)

        Set the blocksize.

        This method is required to support the interface provided by
        Eigensolver. However, the preferred method of setting the allocated
        size for the BlockDavidson eigensolver is setSize(). In fact,
        setBlockSize() simply calls setSize(), maintaining the current number
        of blocks.

        The block size determines the number of Ritz vectors and values that
        are computed on each iteration, thereby determining the increase in
        the Krylov subspace at each iteration. 
        """
        return _Anasazi.BlockDavidsonEpetra_setBlockSize(self, *args)


    def getBlockSize(self, *args):
        """
        getBlockSize(BlockDavidsonEpetra self) -> int

        int
        Anasazi::BlockDavidson< ScalarType, MV, OP >::getBlockSize() const

        Get the blocksize used by the iterative solver. 
        """
        return _Anasazi.BlockDavidsonEpetra_getBlockSize(self, *args)


    def setAuxVecs(self, *args):
        """
        setAuxVecs(BlockDavidsonEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP >::setAuxVecs(const
        Teuchos::Array< Teuchos::RCP< const MV > > &auxvecs)

        Set the auxiliary vectors for the solver.

        Because the current basis V cannot be assumed orthogonal to the new
        auxiliary vectors, a call to setAuxVecs() will reset the solver to the
        uninitialized state. This happens only in the case where the new
        auxiliary vectors have a combined dimension of greater than zero.

        In order to preserve the current state, the user will need to extract
        it from the solver using getState(), orthogonalize it against the new
        auxiliary vectors, and reinitialize using initialize(). 
        """
        return _Anasazi.BlockDavidsonEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """
        getAuxVecs(BlockDavidsonEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >

        Teuchos::Array< Teuchos::RCP< const MV > > Anasazi::BlockDavidson<
        ScalarType, MV, OP >::getAuxVecs() const

        Get the auxiliary vectors for the solver. 
        """
        return _Anasazi.BlockDavidsonEpetra_getAuxVecs(self, *args)


    def setSize(self, *args):
        """
        setSize(BlockDavidsonEpetra self, int blockSize, int numBlocks)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP >::setSize(int blockSize,
        int numBlocks)

        Set the blocksize and number of blocks to be used by the iterative
        solver in solving this eigenproblem.

        Changing either the block size or the number of blocks will reset the
        solver to an uninitialized state.

        The requested block size must be strictly positive; the number of
        blocks must be greater than one. Invalid arguments will result in a
        std::invalid_argument exception. 
        """
        return _Anasazi.BlockDavidsonEpetra_setSize(self, *args)


    def currentStatus(self, *args):
        """
        currentStatus(BlockDavidsonEpetra self, std::ostream & os)

        void
        Anasazi::BlockDavidson< ScalarType, MV, OP
        >::currentStatus(std::ostream &os)

        This method requests that the solver print out its current status to
        the given output stream. 
        """
        return _Anasazi.BlockDavidsonEpetra_currentStatus(self, *args)

BlockDavidsonEpetra_swigregister = _Anasazi.BlockDavidsonEpetra_swigregister
BlockDavidsonEpetra_swigregister(BlockDavidsonEpetra)

class BlockDavidsonSolMgrEpetra(SolverManagerEpetra):
    """


    The BlockDavidsonSolMgr provides a powerful solver manager over the
    BlockDavidson eigensolver.

    This solver manager implements a hard-locking mechanism, whereby
    eigenpairs designated to be locked are moved from the eigensolver and
    placed in auxilliary storage. The eigensolver is then restarted and
    continues to iterate, orthogonal to the locked eigenvectors.

    The solver manager provides to the solver a StatusTestCombo object
    constructed as follows: combo = globaltest OR lockingtest OR debugtest
    where  globaltest terminates computation when global convergence has
    been detected.  It is encapsulated in a StatusTestWithOrdering object,
    to ensure that computation is terminated only after the most
    significant eigenvalues/eigenvectors have met the convergence
    criteria.  If not specified via setGlobalStatusTest(), globaltest is a
    StatusTestResNorm object which tests the M-norms of the direct
    residuals relative to the Ritz values.

    lockingtest halts BlockDavidson::iterate() in order to deflate
    converged eigenpairs for locking.  It will query the underlying
    BlockDavidson eigensolver to determine when eigenvectors should be
    locked.  If not specified via setLockingStatusTest(), lockingtest is a
    StatusTestResNorm object.

    debugtest allows a user to specify additional monitoring of the
    iteration, encapsulated in a StatusTest object  If not specified via
    setDebugStatusTest(), debugtest is ignored.  In most cases, it should
    return ::Failed; if it returns ::Passed, solve() will throw an
    AnasaziError exception.

    Additionally, the solver manager will terminate solve() after a
    specified number of restarts.

    Much of this behavior is controlled via parameters and options passed
    to the solver manager. For more information, see
    BlockDavidsonSolMgr().

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, Heidi Thornquist

    C++ includes: AnasaziBlockDavidsonSolMgr.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonSolMgrEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonSolMgrEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockDavidsonSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, ParameterList pl) -> BlockDavidsonSolMgrEpetra

        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP
        >::BlockDavidsonSolMgr(const Teuchos::RCP< Eigenproblem< ScalarType,
        MV, OP > > &problem, Teuchos::ParameterList &pl)

        Basic constructor for BlockDavidsonSolMgr.

        This constructor accepts the Eigenproblem to be solved in addition to
        a parameter list of options for the solver manager. These options
        include the following: Solver parameters  "Which" - a string
        specifying the desired eigenvalues: SM, LM, SR or LR. Default: "SR"

        "Block Size" - a int specifying the block size to be used by the
        underlying block Davidson solver. Default: problem->getNEV()

        "Num Blocks" - a int specifying the number of blocks allocated for
        the Krylov basis. Default: 2

        "Maximum Restarts" - a int specifying the maximum number of restarts
        the underlying solver is allowed to perform. Default: 20

        "Verbosity" - a sum of MsgType specifying the verbosity. Default:
        ::Errors

        Convergence parameters (if using default convergence test; see
        setGlobalStatusTest())  "Convergence Tolerance" - a MagnitudeType
        specifying the level that residual norms must reach to decide
        convergence. Default: machine precision.

        "Relative Convergence Tolerance" - a bool specifying whether
        residuals norms should be scaled by their eigenvalues for the
        purposing of deciding convergence. Default: true

        "Convergence Norm" - a string specifying the norm for convergence
        testing: "2" or "M"

        Locking parameters (if using default locking test; see
        setLockingStatusTest())  "Use Locking" - a bool specifying whether
        the algorithm should employ locking of converged eigenpairs. Default:
        false

        "Max Locked" - a int specifying the maximum number of eigenpairs to
        be locked. Default: problem->getNEV()

        "Locking Quorum" - a int specifying the number of eigenpairs that
        must meet the locking criteria before locking actually occurs.
        Default: 1

        "Locking Tolerance" - a MagnitudeType specifying the level that
        residual norms must reach to decide locking. Default: 0.1*convergence
        tolerance

        "Relative Locking Tolerance" - a bool specifying whether residuals
        norms should be scaled by their eigenvalues for the purposing of
        deciding locking. Default: true

        "Locking Norm" - a string specifying the norm for locking testing:
        "2" or "M" 
        """
        this = _Anasazi.new_BlockDavidsonSolMgrEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonSolMgrEpetra

    def getProblem(self, *args):
        """
        getProblem(BlockDavidsonSolMgrEpetra self) -> EigenproblemEpetra

        const Eigenproblem<ScalarType,MV,OP>& Anasazi::BlockDavidsonSolMgr<
        ScalarType, MV, OP >::getProblem() const

        Return the eigenvalue problem. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(BlockDavidsonSolMgrEpetra self) -> int

        int
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP >::getNumIters()
        const

        Get the iteration count for the most recent call to  solve(). 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_getNumIters(self, *args)


    def getTimers(self, *args):
        """
        getTimers(BlockDavidsonSolMgrEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >

        Teuchos::Array<Teuchos::RCP<Teuchos::Time> >
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP >::getTimers() const

        Return the timers for this object.

        The timers are ordered as follows: time spent in solve() routine

        time spent restarting

        time spent locking converged eigenvectors 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_getTimers(self, *args)


    def solve(self, *args):
        """
        solve(BlockDavidsonSolMgrEpetra self) -> Anasazi::ReturnType

        ReturnType Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP >::solve()

        This method performs possibly repeated calls to the underlying
        eigensolver's iterate() routine until the problem has been solved (as
        decided by the solver manager) or the solver manager decides to quit.

        This method calls BlockDavidson::iterate(), which will return either
        because a specially constructed status test evaluates to ::Passed or
        an exception is thrown.

        A return from BlockDavidson::iterate() signifies one of the following
        scenarios: the maximum number of restarts has been exceeded. In this
        scenario, the solver manager will place  all converged eigenpairs into
        the eigenproblem and return ::Unconverged.

        the locking conditions have been met. In this scenario, some of the
        current eigenpairs will be removed  from the eigensolver and placed
        into auxiliary storage. The eigensolver will be restarted with the
        remaining part of the Krylov subspace  and some random information to
        replace the removed subspace.

        global convergence has been met. In this case, the most significant
        NEV eigenpairs in the solver and locked storage  have met the
        convergence criterion. (Here, NEV refers to the number of eigenpairs
        requested by the Eigenproblem.)  In this scenario, the solver manager
        will return ::Converged.

        ::ReturnType specifying: ::Converged: the eigenproblem was solved to
        the specification required by the solver manager.

        ::Unconverged: the eigenproblem was not solved to the specification
        desired by the solver manager. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_solve(self, *args)


    def setGlobalStatusTest(self, *args):
        """
        setGlobalStatusTest(BlockDavidsonSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & arg2)

        void
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP
        >::setGlobalStatusTest(const Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > &global)

        Set the status test defining global convergence. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_setGlobalStatusTest(self, *args)


    def getGlobalStatusTest(self, *args):
        """
        getGlobalStatusTest(BlockDavidsonSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const
        Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP
        >::getGlobalStatusTest() const

        Get the status test defining global convergence. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_getGlobalStatusTest(self, *args)


    def setLockingStatusTest(self, *args):
        """
        setLockingStatusTest(BlockDavidsonSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & locking)

        void
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP
        >::setLockingStatusTest(const Teuchos::RCP< StatusTest< ScalarType,
        MV, OP > > &locking)

        Set the status test defining locking. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_setLockingStatusTest(self, *args)


    def getLockingStatusTest(self, *args):
        """
        getLockingStatusTest(BlockDavidsonSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const
        Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP
        >::getLockingStatusTest() const

        Get the status test defining locking. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_getLockingStatusTest(self, *args)


    def setDebugStatusTest(self, *args):
        """
        setDebugStatusTest(BlockDavidsonSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & debug)

        void
        Anasazi::BlockDavidsonSolMgr< ScalarType, MV, OP
        >::setDebugStatusTest(const Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > &debug)

        Set the status test for debugging. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_setDebugStatusTest(self, *args)


    def getDebugStatusTest(self, *args):
        """
        getDebugStatusTest(BlockDavidsonSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const Teuchos::RCP<
        StatusTest< ScalarType, MV, OP > > & Anasazi::BlockDavidsonSolMgr<
        ScalarType, MV, OP >::getDebugStatusTest() const

        Get the status test for debugging. 
        """
        return _Anasazi.BlockDavidsonSolMgrEpetra_getDebugStatusTest(self, *args)

BlockDavidsonSolMgrEpetra_swigregister = _Anasazi.BlockDavidsonSolMgrEpetra_swigregister
BlockDavidsonSolMgrEpetra_swigregister(BlockDavidsonSolMgrEpetra)

class BlockKrylovSchurEpetra(EigensolverEpetra):
    """


    This class implements the block Krylov-Schur iteration, for solving
    linear eigenvalue problems.

    This method is a block version of the iteration presented by G.W.
    Stewart in "A Krylov-Schur Algorithm for Large Eigenproblems", SIAM
    J. Matrix Anal. Appl., Vol 23(2001), No. 3, pp. 601-614.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, Heidi Thornquist

    C++ includes: AnasaziBlockKrylovSchur.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockKrylovSchur<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, Teuchos::RCP< Anasazi::SortManager< Teuchos::ScalarTraits< double >::magnitudeType > > const & sorter, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & tester, Teuchos::RCP< Anasazi::OrthoManager< double,Epetra_MultiVector > > const & ortho, ParameterList params) -> BlockKrylovSchurEpetra

        Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::BlockKrylovSchur(const Teuchos::RCP< Eigenproblem< ScalarType, MV,
        OP > > &problem, const Teuchos::RCP< SortManager< typename
        Teuchos::ScalarTraits< ScalarType >::magnitudeType > > &sorter, const
        Teuchos::RCP< OutputManager< ScalarType > > &printer, const
        Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &tester, const
        Teuchos::RCP< OrthoManager< ScalarType, MV > > &ortho,
        Teuchos::ParameterList &params)

        BlockKrylovSchur constructor with eigenproblem, solver utilities, and
        parameter list of solver options.

        This constructor takes pointers required by the eigensolver, in
        addition to a parameter list of options for the eigensolver. These
        options include the following: "Block Size" - an int specifying the
        block size used by the algorithm. This can also be specified using the
        setBlockSize() method. Default: 1

        "Num Blocks" - an int specifying the maximum number of blocks
        allocated for the solver basis. Default: 3*problem->getNEV()

        "Step Size" - an int specifying how many iterations are performed
        between computations of eigenvalues and eigenvectors.  Note: This
        parameter is mandatory.

        "Number of Ritz Vectors" - an int specifying how many Ritz vectors
        are computed on calls to getRitzVectors(). Default: 0

        "Print Number of Ritz Values" - an int specifying how many Ritz
        values are printed on calls to currentStatus(). Default: "Block
        Size" 
        """
        this = _Anasazi.new_BlockKrylovSchurEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurEpetra

    def iterate(self, *args):
        """
        iterate(BlockKrylovSchurEpetra self)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::iterate()

        This method performs Block Krylov-Schur iterations until the status
        test indicates the need to stop or an error occurs (in which case, an
        exception is thrown).

        iterate() will first determine whether the solver is inintialized; if
        not, it will call initialize() using default arguments. After
        initialization, the solver performs Block Krylov-Schur iterations
        until the status test evaluates as ::Passed, at which point the method
        returns to the caller.

        The Block Krylov-Schur iteration proceeds as follows: The operator
        problem->getOperator() is applied to the newest blockSize vectors in
        the Krylov basis.

        The resulting vectors are orthogonalized against the auxiliary vectors
        and the previous basis vectors, and made orthonormal.

        The Hessenberg matrix is updated.

        If we have performed stepSize iterations since the last update, update
        the Ritz values and Ritz residuals.

        The status test is queried at the beginning of the iteration.

        Possible exceptions thrown include the BlockKrylovSchurOrthoFailure.

        """
        return _Anasazi.BlockKrylovSchurEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(BlockKrylovSchurEpetra self, Anasazi::BlockKrylovSchurState< double,Epetra_MultiVector > & state)
        initialize(BlockKrylovSchurEpetra self)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::initialize()

        Initialize the solver with the initial vectors from the eigenproblem
        or random data. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_initialize(self, *args)


    def isInitialized(self, *args):
        """
        isInitialized(BlockKrylovSchurEpetra self) -> bool

        bool
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::isInitialized() const

        Indicates whether the solver has been initialized or not.

        bool indicating the state of the solver.

        If isInitialized() == true: the first getCurSubspaceDim() vectors of V
        are orthogonal to auxiliary vectors and have orthonormal columns

        the principal Hessenberg submatrix of of H contains the Hessenberg
        matrix associated with V 
        """
        return _Anasazi.BlockKrylovSchurEpetra_isInitialized(self, *args)


    def getState(self, *args):
        """
        getState(BlockKrylovSchurEpetra self) -> Anasazi::BlockKrylovSchurState< double,Epetra_MultiVector >

        BlockKrylovSchurState<ScalarType,MV> Anasazi::BlockKrylovSchur<
        ScalarType, MV, OP >::getState() const

        Get the current state of the eigensolver.

        The data is only valid if isInitialized() == true.

        A BlockKrylovSchurState object containing const pointers to the
        current solver state. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getState(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(BlockKrylovSchurEpetra self) -> int

        int
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getNumIters() const

        Get the current iteration count. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """
        resetNumIters(BlockKrylovSchurEpetra self)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::resetNumIters()

        Reset the iteration count. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """
        getRitzVectors(BlockKrylovSchurEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        Teuchos::RCP<const MV> Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::getRitzVectors()

        Get the Ritz vectors.

        A multivector of columns not exceeding the maximum dimension of the
        subspace containing the Ritz vectors from the most recent call to
        computeRitzVectors().

        To see if the returned Ritz vectors are current, call
        isRitzVecsCurrent(). 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """
        getRitzValues(BlockKrylovSchurEpetra self) -> VectorValueDouble

        std::vector<Value<ScalarType> > Anasazi::BlockKrylovSchur< ScalarType,
        MV, OP >::getRitzValues()

        Get the Ritz values.

        A vector of length not exceeding the maximum dimension of the subspace
        containing the Ritz values from the most recent Schur form update.

        To see if the returned Ritz values are current, call
        isRitzValsCurrent(). 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """
        getRitzIndex(BlockKrylovSchurEpetra self) -> VectorInt

        std::vector<int> Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::getRitzIndex()

        Get the Ritz index vector.

        A vector of length not exceeding the maximum dimension of the subspace
        containing the index vector for the Ritz values and Ritz vectors, if
        they are computed. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """
        getResNorms(BlockKrylovSchurEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector<typename Teuchos::ScalarTraits<ScalarType>::magnitudeType>
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getResNorms()

        Get the current residual norms.

        Block Krylov-Schur cannot provide this so a zero length vector will be
        returned. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """
        getRes2Norms(BlockKrylovSchurEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector<typename Teuchos::ScalarTraits<ScalarType>::magnitudeType>
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getRes2Norms()

        Get the current residual 2-norms.

        Block Krylov-Schur cannot provide this so a zero length vector will be
        returned. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """
        getRitzRes2Norms(BlockKrylovSchurEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector<typename Teuchos::ScalarTraits<ScalarType>::magnitudeType>
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getRitzRes2Norms()

        Get the current Ritz residual 2-norms.

        A vector of length blockSize containing the 2-norms of the Ritz
        residuals. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getRitzRes2Norms(self, *args)


    def setStatusTest(self, *args):
        """
        setStatusTest(BlockKrylovSchurEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::setStatusTest(Teuchos::RCP< StatusTest< ScalarType, MV, OP > >
        test)

        Set a new StatusTest for the solver. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """
        getStatusTest(BlockKrylovSchurEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >

        Teuchos::RCP< StatusTest< ScalarType, MV, OP > >
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getStatusTest() const

        Get the current StatusTest used by the solver. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """
        getProblem(BlockKrylovSchurEpetra self) -> EigenproblemEpetra

        const
        Eigenproblem<ScalarType,MV,OP>& Anasazi::BlockKrylovSchur< ScalarType,
        MV, OP >::getProblem() const

        Get a constant reference to the eigenvalue problem. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getProblem(self, *args)


    def setSize(self, *args):
        """
        setSize(BlockKrylovSchurEpetra self, int blockSize, int numBlocks)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::setSize(int
        blockSize, int numBlocks)

        Set the blocksize and number of blocks to be used by the iterative
        solver in solving this eigenproblem.

        Changing either the block size or the number of blocks will reset the
        solver to an uninitialized state. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_setSize(self, *args)


    def setBlockSize(self, *args):
        """
        setBlockSize(BlockKrylovSchurEpetra self, int blockSize)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::setBlockSize(int
        blockSize)

        Set the blocksize. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_setBlockSize(self, *args)


    def setStepSize(self, *args):
        """
        setStepSize(BlockKrylovSchurEpetra self, int stepSize)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::setStepSize(int
        stepSize)

        Set the step size. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_setStepSize(self, *args)


    def setNumRitzVectors(self, *args):
        """
        setNumRitzVectors(BlockKrylovSchurEpetra self, int numRitzVecs)

        void Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::setNumRitzVectors(int numRitzVecs)

        Set the number of Ritz vectors to compute. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_setNumRitzVectors(self, *args)


    def getStepSize(self, *args):
        """
        getStepSize(BlockKrylovSchurEpetra self) -> int

        int
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getStepSize() const

        Get the step size. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getStepSize(self, *args)


    def getBlockSize(self, *args):
        """
        getBlockSize(BlockKrylovSchurEpetra self) -> int

        int
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::getBlockSize() const

        Get the blocksize to be used by the iterative solver in solving this
        eigenproblem. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getBlockSize(self, *args)


    def getNumRitzVectors(self, *args):
        """
        getNumRitzVectors(BlockKrylovSchurEpetra self) -> int

        int Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::getNumRitzVectors() const

        Get the number of Ritz vectors to compute. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getNumRitzVectors(self, *args)


    def getCurSubspaceDim(self, *args):
        """
        getCurSubspaceDim(BlockKrylovSchurEpetra self) -> int

        int Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::getCurSubspaceDim() const

        Get the dimension of the search subspace used to generate the current
        eigenvectors and eigenvalues.

        An integer specifying the rank of the Krylov subspace currently in use
        by the eigensolver. If isInitialized() == false, the return is 0. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """
        getMaxSubspaceDim(BlockKrylovSchurEpetra self) -> int

        int Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::getMaxSubspaceDim() const

        Get the maximum dimension allocated for the search subspace. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getMaxSubspaceDim(self, *args)


    def setAuxVecs(self, *args):
        """
        setAuxVecs(BlockKrylovSchurEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::setAuxVecs(const
        Teuchos::Array< Teuchos::RCP< const MV > > &auxvecs)

        Set the auxiliary vectors for the solver.

        Because the current Krylov subspace cannot be assumed orthogonal to
        the new auxiliary vectors, a call to setAuxVecs() will reset the
        solver to the uninitialized state. This happens only in the case where
        the new auxiliary vectors have a combined dimension of greater than
        zero.

        In order to preserve the current state, the user will need to extract
        it from the solver using getState(), orthogonalize it against the new
        auxiliary vectors, and reinitialize using initialize(). 
        """
        return _Anasazi.BlockKrylovSchurEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """
        getAuxVecs(BlockKrylovSchurEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >

        Teuchos::Array<Teuchos::RCP<const MV> > Anasazi::BlockKrylovSchur<
        ScalarType, MV, OP >::getAuxVecs() const

        Get the auxiliary vectors for the solver. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_getAuxVecs(self, *args)


    def currentStatus(self, *args):
        """
        currentStatus(BlockKrylovSchurEpetra self, std::ostream & os)

        void
        Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::currentStatus(std::ostream &os)

        This method requests that the solver print out its current status to
        screen. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_currentStatus(self, *args)


    def isRitzVecsCurrent(self, *args):
        """
        isRitzVecsCurrent(BlockKrylovSchurEpetra self) -> bool

        bool Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::isRitzVecsCurrent() const

        Get the status of the Ritz vectors currently stored in the
        eigensolver. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_isRitzVecsCurrent(self, *args)


    def isRitzValsCurrent(self, *args):
        """
        isRitzValsCurrent(BlockKrylovSchurEpetra self) -> bool

        bool Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::isRitzValsCurrent() const

        Get the status of the Ritz values currently stored in the eigensolver.

        """
        return _Anasazi.BlockKrylovSchurEpetra_isRitzValsCurrent(self, *args)


    def isSchurCurrent(self, *args):
        """
        isSchurCurrent(BlockKrylovSchurEpetra self) -> bool

        bool Anasazi::BlockKrylovSchur< ScalarType, MV, OP >::isSchurCurrent()
        const

        Get the status of the Schur form currently stored in the eigensolver.

        """
        return _Anasazi.BlockKrylovSchurEpetra_isSchurCurrent(self, *args)


    def computeRitzVectors(self, *args):
        """
        computeRitzVectors(BlockKrylovSchurEpetra self)

        void Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::computeRitzVectors()

        Compute the Ritz vectors using the current Krylov factorization. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_computeRitzVectors(self, *args)


    def computeRitzValues(self, *args):
        """
        computeRitzValues(BlockKrylovSchurEpetra self)

        void Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::computeRitzValues()

        Compute the Ritz values using the current Krylov factorization. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_computeRitzValues(self, *args)


    def computeSchurForm(self, *args):
        """
        computeSchurForm(BlockKrylovSchurEpetra self, bool const sort=True)

        void Anasazi::BlockKrylovSchur< ScalarType, MV, OP
        >::computeSchurForm(const bool sort=true)

        Compute the Schur form of the projected eigenproblem from the current
        Krylov factorization. 
        """
        return _Anasazi.BlockKrylovSchurEpetra_computeSchurForm(self, *args)

BlockKrylovSchurEpetra_swigregister = _Anasazi.BlockKrylovSchurEpetra_swigregister
BlockKrylovSchurEpetra_swigregister(BlockKrylovSchurEpetra)

class BlockKrylovSchurSolMgrEpetra(SolverManagerEpetra):
    """


    The Anasazi::BlockKrylovSchurSolMgr provides a flexible solver manager
    over the BlockKrylovSchur eigensolver.

    The solver manager provides to the solver a StatusTestCombo object
    constructed as follows: combo = globaltest OR debugtest  where
    globaltest terminates computation when global convergence has been
    detected.  It is encapsulated in a StatusTestWithOrdering object, to
    ensure that computation is terminated only after the most significant
    eigenvalues/eigenvectors have met the convergence criteria.  If not
    specified via setGlobalStatusTest(), this test is a StatusTestResNorm
    object which tests the 2-norms of the Ritz residuals relative to the
    Ritz values.

    debugtest allows a user to specify additional monitoring of the
    iteration, encapsulated in a StatusTest object  If not specified via
    setDebugStatusTest(), debugtest is ignored.  In most cases, it should
    return ::Failed; if it returns ::Passed, solve() will throw an
    AnasaziError exception.

    Additionally, the solver manager will terminate solve() after a
    specified number of restarts.

    Much of this behavior is controlled via parameters and options passed
    to the solver manager. For more information, see
    BlockKrylovSchurSolMgr().

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, Heidi Thornquist

    C++ includes: AnasaziBlockKrylovSchurSolMgr.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurSolMgrEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurSolMgrEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BlockKrylovSchurSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, ParameterList pl) -> BlockKrylovSchurSolMgrEpetra

        Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::BlockKrylovSchurSolMgr(const Teuchos::RCP< Eigenproblem<
        ScalarType, MV, OP > > &problem, Teuchos::ParameterList &pl)

        Basic constructor for BlockKrylovSchurSolMgr.

        This constructor accepts the Eigenproblem to be solved in addition to
        a parameter list of options for the solver manager. These options
        include the following: Solver parameters  "Which" - a string
        specifying the desired eigenvalues: SM, LM, SR or LR. Default: "LM"

        "Block Size" - a int specifying the block size to be used by the
        underlying block Krylov- Schur solver. Default: 1

        "Num Blocks" - a int specifying the number of blocks allocated for
        the Krylov basis. Default: 3*nev

        "Extra NEV Blocks" - a int specifying the number of extra blocks the
        solver should keep in addition to those required to compute the number
        of eigenvalues requested. Default: 0

        "Maximum Restarts" - a int specifying the maximum number of restarts
        the underlying solver is allowed to perform. Default: 20

        "Orthogonalization" - a string specifying the desired
        orthogonalization: DGKS and SVQB. Default: "SVQB"

        "Verbosity" - a sum of MsgType specifying the verbosity. Default:
        Anasazi::Errors

        Convergence parameters  "Convergence Tolerance" - a MagnitudeType
        specifying the level that residual norms must reach to decide
        convergence. Default: machine precision.

        "Relative Convergence Tolerance" - a bool specifying whether
        residuals norms should be scaled by their eigenvalues for the
        purposing of deciding convergence. Default: true 
        """
        this = _Anasazi.new_BlockKrylovSchurSolMgrEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurSolMgrEpetra

    def getProblem(self, *args):
        """
        getProblem(BlockKrylovSchurSolMgrEpetra self) -> EigenproblemEpetra

        const Eigenproblem<ScalarType,MV,OP>& Anasazi::BlockKrylovSchurSolMgr<
        ScalarType, MV, OP >::getProblem() const

        Return the eigenvalue problem. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(BlockKrylovSchurSolMgrEpetra self) -> int

        int Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::getNumIters() const

        Get the iteration count for the most recent call to  solve(). 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getNumIters(self, *args)


    def getRitzValues(self, *args):
        """
        getRitzValues(BlockKrylovSchurSolMgrEpetra self) -> VectorValueDouble

        std::vector<Value<ScalarType> > Anasazi::BlockKrylovSchurSolMgr<
        ScalarType, MV, OP >::getRitzValues() const

        Return the Ritz values from the most recent solve. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getRitzValues(self, *args)


    def getTimers(self, *args):
        """
        getTimers(BlockKrylovSchurSolMgrEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >

        Teuchos::Array<Teuchos::RCP<Teuchos::Time> >
        Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP >::getTimers()
        const

        Return the timers for this object.

        The timers are ordered as follows: time spent in solve() routine

        time spent restarting 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getTimers(self, *args)


    def solve(self, *args):
        """
        solve(BlockKrylovSchurSolMgrEpetra self) -> Anasazi::ReturnType

        ReturnType Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::solve()

        This method performs possibly repeated calls to the underlying
        eigensolver's iterate() routine until the problem has been solved (as
        decided by the solver manager) or the solver manager decides to quit.

        This method calls BlockKrylovSchur::iterate(), which will return
        either because a specially constructed status test evaluates to
        ::Passed or an exception is thrown.

        A return from BlockKrylovSchur::iterate() signifies one of the
        following scenarios: the maximum number of restarts has been exceeded.
        In this scenario, the solver manager will place  all converged
        eigenpairs into the eigenproblem and return ::Unconverged.

        global convergence has been met. In this case, the most significant
        NEV eigenpairs in the solver and locked storage  have met the
        convergence criterion. (Here, NEV refers to the number of eigenpairs
        requested by the Eigenproblem.)  In this scenario, the solver manager
        will return ::Converged.

        ::ReturnType specifying: ::Converged: the eigenproblem was solved to
        the specification required by the solver manager.

        ::Unconverged: the eigenproblem was not solved to the specification
        desired by the solver manager. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_solve(self, *args)


    def setGlobalStatusTest(self, *args):
        """
        setGlobalStatusTest(BlockKrylovSchurSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & arg2)

        void
        Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::setGlobalStatusTest(const Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > &global)

        Set the status test defining global convergence. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_setGlobalStatusTest(self, *args)


    def getGlobalStatusTest(self, *args):
        """
        getGlobalStatusTest(BlockKrylovSchurSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const
        Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::getGlobalStatusTest() const

        Get the status test defining global convergence. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getGlobalStatusTest(self, *args)


    def setDebugStatusTest(self, *args):
        """
        setDebugStatusTest(BlockKrylovSchurSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & debug)

        void
        Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::setDebugStatusTest(const Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > &debug)

        Set the status test for debugging. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_setDebugStatusTest(self, *args)


    def getDebugStatusTest(self, *args):
        """
        getDebugStatusTest(BlockKrylovSchurSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const
        Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::BlockKrylovSchurSolMgr< ScalarType, MV, OP
        >::getDebugStatusTest() const

        Get the status test for debugging. 
        """
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getDebugStatusTest(self, *args)

BlockKrylovSchurSolMgrEpetra_swigregister = _Anasazi.BlockKrylovSchurSolMgrEpetra_swigregister
BlockKrylovSchurSolMgrEpetra_swigregister(BlockKrylovSchurSolMgrEpetra)

class LOBPCGEpetra(EigensolverEpetra):
    """


    This class provides the Locally Optimal Block Preconditioned Conjugate
    Gradient (LOBPCG) iteration, a preconditioned iteration for solving
    linear Hermitian eigenproblems.

    This implementation is a modification of the one found in A. Knyazev,
    "Toward the optimal preconditioned eigensolver: Locally optimal block
    preconditioner conjugate gradient method", SIAM J. Sci. Comput., vol
    23, n 2, pp. 517-541.

    The modification consists of the orthogonalization steps recommended
    in U. Hetmaniuk and R. Lehoucq, "Basis Selection in LOBPCG", Journal
    of Computational Physics.

    These modifcation are referred to as full orthogonalization, and
    consist of also conducting the local optimization using an orthonormal
    basis.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, Heidi Thornquist

    C++ includes: AnasaziLOBPCG.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::LOBPCG<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, Teuchos::RCP< Anasazi::SortManager< Teuchos::ScalarTraits< double >::magnitudeType > > const & sorter, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & tester, Teuchos::RCP< Anasazi::MatOrthoManager< double,Epetra_MultiVector,Epetra_Operator > > const & ortho, ParameterList params) -> LOBPCGEpetra

        Anasazi::LOBPCG<
        ScalarType, MV, OP >::LOBPCG(const Teuchos::RCP< Eigenproblem<
        ScalarType, MV, OP > > &problem, const Teuchos::RCP< SortManager<
        typename Teuchos::ScalarTraits< ScalarType >::magnitudeType > >
        &sorter, const Teuchos::RCP< OutputManager< ScalarType > > &printer,
        const Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &tester, const
        Teuchos::RCP< MatOrthoManager< ScalarType, MV, OP > > &ortho,
        Teuchos::ParameterList &params)

        LOBPCG constructor with eigenproblem, solver utilities, and parameter
        list of solver options.

        This constructor takes pointers required by the eigensolver, in
        addition to a parameter list of options for the eigensolver. These
        options include the following: "Block Size" - an int specifying the
        block size used by the algorithm. This can also be specified using the
        setBlockSize() method.

        "Full Ortho" - a bool specifying whether the solver should employ a
        full orthogonalization technique. This can also be specified using the
        setFullOrtho() method. 
        """
        this = _Anasazi.new_LOBPCGEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGEpetra

    def iterate(self, *args):
        """
        iterate(LOBPCGEpetra self)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::iterate()

        This method performs LOBPCG iterations until the status test indicates
        the need to stop or an error occurs (in which case, an exception is
        thrown).

        iterate() will first determine whether the solver is initialized; if
        not, it will call initialize() using default arguments. After
        initialization, the solver performs LOBPCG iterations until the status
        test evaluates as Passed, at which point the method returns to the
        caller.

        The LOBPCG iteration proceeds as follows: The current residual (R) is
        preconditioned to form H

        H is orthogonalized against the auxiliary vectors and, if full
        orthogonalization  is enabled, against X and P.

        The basis [X H P] is used to project the problem matrices.

        The projected eigenproblem is solved, and the desired eigenvectors and
        eigenvalues are selected.

        These are used to form the new eigenvector estimates (X) and the
        search directions (P).  If full orthogonalization is enabled, these
        are generated to be mutually orthogonal and with orthonormal columns.

        The new residual (R) is formed.

        The status test is queried at the beginning of the iteration.

        Possible exceptions thrown include std::logic_error,
        std::invalid_argument or one of the LOBPCG-specific exceptions. 
        """
        return _Anasazi.LOBPCGEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(LOBPCGEpetra self, Anasazi::LOBPCGState< double,Epetra_MultiVector > & newstate)
        initialize(LOBPCGEpetra self)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::initialize()

        Initialize the solver with the initial vectors from the eigenproblem
        or random data. 
        """
        return _Anasazi.LOBPCGEpetra_initialize(self, *args)


    def isInitialized(self, *args):
        """
        isInitialized(LOBPCGEpetra self) -> bool

        bool
        Anasazi::LOBPCG< ScalarType, MV, OP >::isInitialized() const

        Indicates whether the solver has been initialized or not.

        bool indicating the state of the solver.

        If isInitialized() == true: X is orthogonal to auxiliary vectors and
        has orthonormal columns

        KX == Op*X

        MX == M*X if M != Teuchos::null  Otherwise, MX == Teuchos::null

        getRitzValues() returns the sorted Ritz values with respect to X

        getResNorms(), getRes2Norms(), getRitzResNorms() are correct

        If hasP() == true, P orthogonal to auxiliary vectors

        If getFullOrtho() == true, P is orthogonal to X and has orthonormal
        columns

        KP == Op*P

        MP == M*P if M != Teuchos::null  Otherwise, MP == Teuchos::null 
        """
        return _Anasazi.LOBPCGEpetra_isInitialized(self, *args)


    def getState(self, *args):
        """
        getState(LOBPCGEpetra self) -> Anasazi::LOBPCGState< double,Epetra_MultiVector >

        LOBPCGState<
        ScalarType, MV > Anasazi::LOBPCG< ScalarType, MV, OP >::getState()
        const

        Get the current state of the eigensolver.

        The data is only valid if isInitialized() == true. The data for the
        search directions P is only meaningful if hasP() == true. Finally, the
        data for the preconditioned residual (H) is only meaningful in the
        situation where the solver throws an ::LOBPCGRitzFailure exception
        during iterate().

        An LOBPCGState object containing const views to the current solver
        state. 
        """
        return _Anasazi.LOBPCGEpetra_getState(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(LOBPCGEpetra self) -> int

        int
        Anasazi::LOBPCG< ScalarType, MV, OP >::getNumIters() const

        Get the current iteration count. 
        """
        return _Anasazi.LOBPCGEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """
        resetNumIters(LOBPCGEpetra self)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::resetNumIters()

        Reset the iteration count. 
        """
        return _Anasazi.LOBPCGEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """
        getRitzVectors(LOBPCGEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >

        Teuchos::RCP<
        const MV > Anasazi::LOBPCG< ScalarType, MV, OP >::getRitzVectors()

        Get the Ritz vectors from the previous iteration.

        A multivector with getBlockSize() vectors containing the sorted Ritz
        vectors corresponding to the most significant Ritz values. The i-th
        vector of the return corresponds to the i-th Ritz vector; there is no
        need to use getRitzIndex(). 
        """
        return _Anasazi.LOBPCGEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """
        getRitzValues(LOBPCGEpetra self) -> VectorValueDouble

        std::vector<
        Value< ScalarType > > Anasazi::LOBPCG< ScalarType, MV, OP
        >::getRitzValues()

        Get the Ritz values from the previous iteration.

        A vector of length getCurSubspaceDim() containing the Ritz values from
        the previous projected eigensolve. 
        """
        return _Anasazi.LOBPCGEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """
        getRitzIndex(LOBPCGEpetra self) -> VectorInt

        std::vector<
        int > Anasazi::LOBPCG< ScalarType, MV, OP >::getRitzIndex()

        Get the index used for extracting Ritz vectors from getRitzVectors().

        Because BlockDavidson is a Hermitian solver, all Ritz values are real
        and all Ritz vectors can be represented in a single column of a
        multivector. Therefore, getRitzIndex() is not needed when using the
        output from getRitzVectors().

        An int vector of size getCurSubspaceDim() composed of zeros. 
        """
        return _Anasazi.LOBPCGEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """
        getResNorms(LOBPCGEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector<
        typename Teuchos::ScalarTraits< ScalarType >::magnitudeType >
        Anasazi::LOBPCG< ScalarType, MV, OP >::getResNorms()

        Get the current residual norms.

        A vector of length getBlockSize() containing the norms of the
        residuals, with respect to the orthogonalization manager norm()
        method. 
        """
        return _Anasazi.LOBPCGEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """
        getRes2Norms(LOBPCGEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector<
        typename Teuchos::ScalarTraits< ScalarType >::magnitudeType >
        Anasazi::LOBPCG< ScalarType, MV, OP >::getRes2Norms()

        Get the current residual 2-norms.

        A vector of length getBlockSize() containing the 2-norms of the
        residuals. 
        """
        return _Anasazi.LOBPCGEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """
        getRitzRes2Norms(LOBPCGEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >

        std::vector< typename Teuchos::ScalarTraits< ScalarType
        >::magnitudeType > Anasazi::LOBPCG< ScalarType, MV, OP
        >::getRitzRes2Norms()

        Get the 2-norms of the residuals.

        The Ritz residuals are not defined for the LOBPCG iteration. Hence,
        this method returns the 2-norms of the direct residuals, and is
        equivalent to calling getRes2Norms().

        A vector of length getBlockSize() containing the 2-norms of the direct
        residuals. 
        """
        return _Anasazi.LOBPCGEpetra_getRitzRes2Norms(self, *args)


    def getCurSubspaceDim(self, *args):
        """
        getCurSubspaceDim(LOBPCGEpetra self) -> int

        int
        Anasazi::LOBPCG< ScalarType, MV, OP >::getCurSubspaceDim() const

        Get the dimension of the search subspace used to generate the current
        eigenvectors and eigenvalues.

        LOBPCG employs a sequential subspace iteration, maintaining a fixed-
        rank basis, as opposed to an expanding subspace mechanism employed by
        Krylov-subspace solvers like BlockKrylovSchur and BlockDavidson.

        An integer specifying the rank of the subspace generated by the
        eigensolver. If isInitialized() == false, the return is 0. Otherwise,
        the return will be 2*getBlockSize() or 3*getBlockSize(). 
        """
        return _Anasazi.LOBPCGEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """
        getMaxSubspaceDim(LOBPCGEpetra self) -> int

        int
        Anasazi::LOBPCG< ScalarType, MV, OP >::getMaxSubspaceDim() const

        Get the maximum dimension allocated for the search subspace. For
        LOBPCG, this always returns 3*getBlockSize(), the dimension of the
        subspace colspan([X H P]). 
        """
        return _Anasazi.LOBPCGEpetra_getMaxSubspaceDim(self, *args)


    def setStatusTest(self, *args):
        """
        setStatusTest(LOBPCGEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::setStatusTest(Teuchos::RCP<
        StatusTest< ScalarType, MV, OP > > test)

        Set a new StatusTest for the solver. 
        """
        return _Anasazi.LOBPCGEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """
        getStatusTest(LOBPCGEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >

        Teuchos::RCP<
        StatusTest< ScalarType, MV, OP > > Anasazi::LOBPCG< ScalarType, MV, OP
        >::getStatusTest() const

        Get the current StatusTest used by the solver. 
        """
        return _Anasazi.LOBPCGEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """
        getProblem(LOBPCGEpetra self) -> EigenproblemEpetra

        const
        Eigenproblem< ScalarType, MV, OP > & Anasazi::LOBPCG< ScalarType, MV,
        OP >::getProblem() const

        Get a constant reference to the eigenvalue problem. 
        """
        return _Anasazi.LOBPCGEpetra_getProblem(self, *args)


    def setBlockSize(self, *args):
        """
        setBlockSize(LOBPCGEpetra self, int blockSize)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::setBlockSize(int blockSize)

        Set the blocksize to be used by the iterative solver in solving this
        eigenproblem.

        If the block size is reduced, then the new iterate (and residual and
        search direction) are chosen as the subset of the current iterate
        preferred by the sort manager. Otherwise, the solver state is set to
        uninitialized. 
        """
        return _Anasazi.LOBPCGEpetra_setBlockSize(self, *args)


    def getBlockSize(self, *args):
        """
        getBlockSize(LOBPCGEpetra self) -> int

        int
        Anasazi::LOBPCG< ScalarType, MV, OP >::getBlockSize() const

        Get the blocksize to be used by the iterative solver in solving this
        eigenproblem. 
        """
        return _Anasazi.LOBPCGEpetra_getBlockSize(self, *args)


    def setAuxVecs(self, *args):
        """
        setAuxVecs(LOBPCGEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::setAuxVecs(const
        Teuchos::Array< Teuchos::RCP< const MV > > &auxvecs)

        Set the auxiliary vectors for the solver.

        Because the current iterate X and search direction P cannot be assumed
        orthogonal to the new auxiliary vectors, a call to setAuxVecs() with a
        non-empty argument will reset the solver to the uninitialized state.

        In order to preserve the current state, the user will need to extract
        it from the solver using getState(), orthogonalize it against the new
        auxiliary vectors, and manually reinitialize the solver using
        initialize(). 
        """
        return _Anasazi.LOBPCGEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """
        getAuxVecs(LOBPCGEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >

        Teuchos::Array<
        Teuchos::RCP< const MV > > Anasazi::LOBPCG< ScalarType, MV, OP
        >::getAuxVecs() const

        Get the current auxiliary vectors. 
        """
        return _Anasazi.LOBPCGEpetra_getAuxVecs(self, *args)


    def setFullOrtho(self, *args):
        """
        setFullOrtho(LOBPCGEpetra self, bool fullOrtho)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::setFullOrtho(bool fullOrtho)

        Instruct the LOBPCG iteration to use full orthogonality.

        If the getFullOrtho() == false and isInitialized() == true and hasP()
        == true, then P will be invalidated by setting full orthogonalization
        to true. 
        """
        return _Anasazi.LOBPCGEpetra_setFullOrtho(self, *args)


    def getFullOrtho(self, *args):
        """
        getFullOrtho(LOBPCGEpetra self) -> bool

        bool
        Anasazi::LOBPCG< ScalarType, MV, OP >::getFullOrtho() const

        Determine if the LOBPCG iteration is using full orthogonality. 
        """
        return _Anasazi.LOBPCGEpetra_getFullOrtho(self, *args)


    def hasP(self, *args):
        """
        hasP(LOBPCGEpetra self) -> bool

        bool Anasazi::LOBPCG<
        ScalarType, MV, OP >::hasP()

        Indicates whether the search direction given by getState() is valid.

        """
        return _Anasazi.LOBPCGEpetra_hasP(self, *args)


    def currentStatus(self, *args):
        """
        currentStatus(LOBPCGEpetra self, std::ostream & os)

        void
        Anasazi::LOBPCG< ScalarType, MV, OP >::currentStatus(std::ostream &os)

        This method requests that the solver print out its current status to
        screen. 
        """
        return _Anasazi.LOBPCGEpetra_currentStatus(self, *args)

LOBPCGEpetra_swigregister = _Anasazi.LOBPCGEpetra_swigregister
LOBPCGEpetra_swigregister(LOBPCGEpetra)

class LOBPCGSolMgrEpetra(SolverManagerEpetra):
    """


    User interface for the LOBPCG eigensolver.

    This class provides a user interface for the LOBPCG (Locally Optimal
    Block Preconditioned Conjugate Gradient) eigensolver. It provides the
    following features:

    Locking of converged eigenpairs

    Global convergence on only the significant eigenpairs (instead of any
    eigenpairs with low residual)

    recovery from orthogonalization failures ( LOBPCGRitzFailure) when
    full orthogonalization is disabled

    Much of this behavior is controlled via parameters and options passed
    to the solver manager. For more information, see the default (zero-
    argument) constructor of this class.

    For an example that defines a custom StatusTest so that Anasazi's
    solver LOBPCG converges correctly with spectrum folding, see the
    LOBPCGCustomStatusTest.cpp example (associated with StatusTest).

    LOBPCG stops iterating if it has reached the maximum number of
    iterations, or ig lobal convergence is detected (uses
    StatusTestWithOrdering to ensure that only the most significant
    eigenvalues/eigenvectors have converged). If not specified via
    setGlobalStatusTest(), the convergence test is a StatusTestResNorm
    instance which tests the M-norms of the direct residuals relative to
    the Ritz values.

    LOBPCG also includes a "locking test" which deflates converged
    eigenpairs for locking. It will query the underlying LOBPCG
    eigensolver to determine when eigenvectors should be locked. If not
    specified via setLockingStatusTest(), the locking test is a
    StatusTestResNorm object.

    Users may specify an optional "debug test." This lets users specify
    additional monitoring of the iteration. If not specified via
    setDebugStatusTest(), this is ignored. In most cases, the user's debug
    test should return ::Failed; if it returns ::Passed, solve() will
    throw an AnasaziError exception.

    Chris Baker, Ulrich Hetmaniuk, Rich Lehoucq, Heidi Thornquist

    C++ includes: AnasaziLOBPCGSolMgr.hpp 
    """

    __swig_setmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGSolMgrEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGSolMgrEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::LOBPCGSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, ParameterList pl) -> LOBPCGSolMgrEpetra

        Anasazi::LOBPCGSolMgr< ScalarType, MV, OP >::LOBPCGSolMgr(const
        Teuchos::RCP< Eigenproblem< ScalarType, MV, OP > > &problem,
        Teuchos::ParameterList &pl)

        Basic constructor for LOBPCGSolMgr.

        This constructor accepts the Eigenproblem to be solved in addition to
        a parameter list of options for the solver manager. These options
        include the following: Solver parameters  "Which" - a string
        specifying the desired eigenvalues: SM, LM, SR or LR. Default: "SR"

        "Block Size" - a int specifying the block size to be used by the
        underlying LOBPCG solver. Default: problem->getNEV()

        "Full Ortho" - a bool specifying whether the underlying solver
        should employ the full orthogonalization scheme. Default: true

        "Recover" - a bool specifying whether the solver manager should
        attempt to recover in the case of a LOBPCGRitzFailure when full
        orthogonalization is disabled. Default: true

        "Verbosity" - a sum of MsgType specifying the verbosity. Default:
        ::Errors

        "Init" - a LOBPCGState<ScalarType,MV> struct used to initialize the
        LOBPCG eigensolver.

        Convergence parameters (if using default convergence test; see
        setGlobalStatusTest())  "Maximum Iterations" - a int specifying the
        maximum number of iterations the underlying solver is allowed to
        perform. Default: 100

        "Convergence Tolerance" - a MagnitudeType specifying the level that
        residual norms must reach to decide convergence. Default: machine
        precision.

        "Relative Convergence Tolerance" - a bool specifying whether
        residuals norms should be scaled by their eigenvalues for the
        purposing of deciding convergence. Default: true

        "Convergence Norm" - a string specifying the norm for convergence
        testing: "2" or "M"

        Locking parameters (if using default locking test; see
        setLockingStatusTest())  "Use Locking" - a bool specifying whether
        the algorithm should employ locking of converged eigenpairs. Default:
        false

        "Max Locked" - a int specifying the maximum number of eigenpairs to
        be locked. Default: problem->getNEV()

        "Locking Quorum" - a int specifying the number of eigenpairs that
        must meet the locking criteria before locking actually occurs.
        Default: 1

        "Locking Tolerance" - a MagnitudeType specifying the level that
        residual norms must reach to decide locking. Default: 0.1*convergence
        tolerance

        "Relative Locking Tolerance" - a bool specifying whether residuals
        norms should be scaled by their eigenvalues for the purposing of
        deciding locking. Default: true

        "Locking Norm" - a string specifying the norm for locking testing:
        "2" or "M" 
        """
        this = _Anasazi.new_LOBPCGSolMgrEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGSolMgrEpetra

    def getProblem(self, *args):
        """
        getProblem(LOBPCGSolMgrEpetra self) -> EigenproblemEpetra

        const
        Eigenproblem<ScalarType,MV,OP>& Anasazi::LOBPCGSolMgr< ScalarType, MV,
        OP >::getProblem() const

        Return the eigenvalue problem. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """
        getNumIters(LOBPCGSolMgrEpetra self) -> int

        int
        Anasazi::LOBPCGSolMgr< ScalarType, MV, OP >::getNumIters() const

        Get the iteration count for the most recent call to  solve(). 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_getNumIters(self, *args)


    def getTimers(self, *args):
        """
        getTimers(LOBPCGSolMgrEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >

        Teuchos::Array<Teuchos::RCP<Teuchos::Time> > Anasazi::LOBPCGSolMgr<
        ScalarType, MV, OP >::getTimers() const

        Return the timers for this object.

        The timers are ordered as follows: time spent in solve() routine

        time spent locking converged eigenvectors 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_getTimers(self, *args)


    def solve(self, *args):
        """
        solve(LOBPCGSolMgrEpetra self) -> Anasazi::ReturnType

        ReturnType
        Anasazi::LOBPCGSolMgr< ScalarType, MV, OP >::solve()

        This method performs possibly repeated calls to the underlying
        eigensolver's iterate() routine until the problem has been solved (as
        decided by the solver manager) or the solver manager decides to quit.

        This method calls LOBPCG::iterate(), which will return either because
        a specially constructed status test evaluates to ::Passed or an
        exception is thrown.

        A return from LOBPCG::iterate() signifies one of the following
        scenarios: the maximum number of iterations has been exceeded. In this
        scenario, the solver manager will place  all converged eigenpairs into
        the eigenproblem and return ::Unconverged.

        the locking conditions have been met. In this scenario, some of the
        current eigenpairs will be removed  from the eigensolver and placed
        into auxiliary storage. The eigensolver will be restarted with the
        remaining  eigenpairs and some random information to replace the
        removed eigenpairs.

        global convergence has been met. In this case, the most significant
        NEV eigenpairs in the solver and locked storage  have met the
        convergence criterion. (Here, NEV refers to the number of eigenpairs
        requested by the Eigenproblem.)  In this scenario, the solver manager
        will return ::Converged.

        an LOBPCGRitzFailure exception has been thrown. If full
        orthogonalization is enabled and recovery from this exception  is
        requested, the solver manager will attempt to recover from this
        exception by gathering the current eigenvectors,  preconditioned
        residual, and search directions from the eigensolver,
        orthogonormalizing the basis composed of these  three, projecting the
        eigenproblem, and restarting the eigensolver with the solution of the
        project eigenproblem. Any  additional failure that occurs during this
        recovery effort will result in the eigensolver returning
        ::Unconverged.

        ::ReturnType specifying: ::Converged: the eigenproblem was solved to
        the specification required by the solver manager.

        ::Unconverged: the eigenproblem was not solved to the specification
        desired by the solver manager 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_solve(self, *args)


    def setGlobalStatusTest(self, *args):
        """
        setGlobalStatusTest(LOBPCGSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & arg2)

        void Anasazi::LOBPCGSolMgr< ScalarType, MV, OP
        >::setGlobalStatusTest(const Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > &global)

        Set the status test defining global convergence. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_setGlobalStatusTest(self, *args)


    def getGlobalStatusTest(self, *args):
        """
        getGlobalStatusTest(LOBPCGSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::LOBPCGSolMgr< ScalarType, MV, OP >::getGlobalStatusTest()
        const

        Get the status test defining global convergence. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_getGlobalStatusTest(self, *args)


    def setLockingStatusTest(self, *args):
        """
        setLockingStatusTest(LOBPCGSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & locking)

        void Anasazi::LOBPCGSolMgr< ScalarType, MV, OP
        >::setLockingStatusTest(const Teuchos::RCP< StatusTest< ScalarType,
        MV, OP > > &locking)

        Set the status test defining locking. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_setLockingStatusTest(self, *args)


    def getLockingStatusTest(self, *args):
        """
        getLockingStatusTest(LOBPCGSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::LOBPCGSolMgr< ScalarType, MV, OP >::getLockingStatusTest()
        const

        Get the status test defining locking. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_getLockingStatusTest(self, *args)


    def setDebugStatusTest(self, *args):
        """
        setDebugStatusTest(LOBPCGSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & debug)

        void Anasazi::LOBPCGSolMgr< ScalarType, MV, OP
        >::setDebugStatusTest(const Teuchos::RCP< StatusTest< ScalarType, MV,
        OP > > &debug)

        Set the status test for debugging. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_setDebugStatusTest(self, *args)


    def getDebugStatusTest(self, *args):
        """
        getDebugStatusTest(LOBPCGSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &

        const Teuchos::RCP< StatusTest< ScalarType, MV, OP > > &
        Anasazi::LOBPCGSolMgr< ScalarType, MV, OP >::getDebugStatusTest()
        const

        Get the status test for debugging. 
        """
        return _Anasazi.LOBPCGSolMgrEpetra_getDebugStatusTest(self, *args)

LOBPCGSolMgrEpetra_swigregister = _Anasazi.LOBPCGSolMgrEpetra_swigregister
LOBPCGSolMgrEpetra_swigregister(LOBPCGSolMgrEpetra)

class EigensolutionEpetra(_object):
    """


    Struct for storing an eigenproblem solution.

    C++ includes: AnasaziTypes.hpp 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EigensolutionEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EigensolutionEpetra, name)
    __repr__ = _swig_repr
    __swig_setmethods__["index"] = _Anasazi.EigensolutionEpetra_index_set
    __swig_getmethods__["index"] = _Anasazi.EigensolutionEpetra_index_get
    if _newclass:
        index = _swig_property(_Anasazi.EigensolutionEpetra_index_get, _Anasazi.EigensolutionEpetra_index_set)
    __swig_setmethods__["numVecs"] = _Anasazi.EigensolutionEpetra_numVecs_set
    __swig_getmethods__["numVecs"] = _Anasazi.EigensolutionEpetra_numVecs_get
    if _newclass:
        numVecs = _swig_property(_Anasazi.EigensolutionEpetra_numVecs_get, _Anasazi.EigensolutionEpetra_numVecs_set)

    def __init__(self, *args):
        """
        __init__(Anasazi::Eigensolution<(double,Epetra_MultiVector)> self) -> EigensolutionEpetra

        Anasazi::Eigensolution< ScalarType, MV >::Eigensolution() 
        """
        this = _Anasazi.new_EigensolutionEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def evals(self, *args):
        """evals(EigensolutionEpetra self) -> VectorValueDouble"""
        return _Anasazi.EigensolutionEpetra_evals(self, *args)


    def evecs(self, *args):
        """evecs(EigensolutionEpetra self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Anasazi.EigensolutionEpetra_evecs(self, *args)


    def espace(self, *args):
        """espace(EigensolutionEpetra self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Anasazi.EigensolutionEpetra_espace(self, *args)

    __swig_destroy__ = _Anasazi.delete_EigensolutionEpetra
EigensolutionEpetra_swigregister = _Anasazi.EigensolutionEpetra_swigregister
EigensolutionEpetra_swigregister(EigensolutionEpetra)


EigensolutionEpetra.Evals  = EigensolutionEpetra.evals
EigensolutionEpetra.Evecs  = EigensolutionEpetra.evecs
EigensolutionEpetra.Espace = EigensolutionEpetra.espace

class VectorValueDouble(_object):
    """Proxy of C++ std::vector<(Anasazi::Value<(double)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorValueDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorValueDouble, name)
    __repr__ = _swig_repr

    def iterator(self, *args):
        """iterator(VectorValueDouble self) -> SwigPyIterator"""
        return _Anasazi.VectorValueDouble_iterator(self, *args)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self, *args):
        """__nonzero__(VectorValueDouble self) -> bool"""
        return _Anasazi.VectorValueDouble___nonzero__(self, *args)


    def __bool__(self, *args):
        """__bool__(VectorValueDouble self) -> bool"""
        return _Anasazi.VectorValueDouble___bool__(self, *args)


    def __len__(self, *args):
        """__len__(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::size_type"""
        return _Anasazi.VectorValueDouble___len__(self, *args)


    def __getslice__(self, *args):
        """__getslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j) -> VectorValueDouble"""
        return _Anasazi.VectorValueDouble___getslice__(self, *args)


    def __setslice__(self, *args):
        """
        __setslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j)
        __setslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j, VectorValueDouble v)
        """
        return _Anasazi.VectorValueDouble___setslice__(self, *args)


    def __delslice__(self, *args):
        """__delslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j)"""
        return _Anasazi.VectorValueDouble___delslice__(self, *args)


    def __delitem__(self, *args):
        """
        __delitem__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i)
        __delitem__(VectorValueDouble self, PySliceObject * slice)
        """
        return _Anasazi.VectorValueDouble___delitem__(self, *args)


    def __getitem__(self, *args):
        """
        __getitem__(VectorValueDouble self, PySliceObject * slice) -> VectorValueDouble
        __getitem__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i) -> ValueDouble
        """
        return _Anasazi.VectorValueDouble___getitem__(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(VectorValueDouble self, PySliceObject * slice, VectorValueDouble v)
        __setitem__(VectorValueDouble self, PySliceObject * slice)
        __setitem__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, ValueDouble x)
        """
        return _Anasazi.VectorValueDouble___setitem__(self, *args)


    def pop(self, *args):
        """pop(VectorValueDouble self) -> ValueDouble"""
        return _Anasazi.VectorValueDouble_pop(self, *args)


    def append(self, *args):
        """append(VectorValueDouble self, ValueDouble x)"""
        return _Anasazi.VectorValueDouble_append(self, *args)


    def empty(self, *args):
        """empty(VectorValueDouble self) -> bool"""
        return _Anasazi.VectorValueDouble_empty(self, *args)


    def size(self, *args):
        """size(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::size_type"""
        return _Anasazi.VectorValueDouble_size(self, *args)


    def swap(self, *args):
        """swap(VectorValueDouble self, VectorValueDouble v)"""
        return _Anasazi.VectorValueDouble_swap(self, *args)


    def begin(self, *args):
        """begin(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::iterator"""
        return _Anasazi.VectorValueDouble_begin(self, *args)


    def end(self, *args):
        """end(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::iterator"""
        return _Anasazi.VectorValueDouble_end(self, *args)


    def rbegin(self, *args):
        """rbegin(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::reverse_iterator"""
        return _Anasazi.VectorValueDouble_rbegin(self, *args)


    def rend(self, *args):
        """rend(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::reverse_iterator"""
        return _Anasazi.VectorValueDouble_rend(self, *args)


    def clear(self, *args):
        """clear(VectorValueDouble self)"""
        return _Anasazi.VectorValueDouble_clear(self, *args)


    def get_allocator(self, *args):
        """get_allocator(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::allocator_type"""
        return _Anasazi.VectorValueDouble_get_allocator(self, *args)


    def pop_back(self, *args):
        """pop_back(VectorValueDouble self)"""
        return _Anasazi.VectorValueDouble_pop_back(self, *args)


    def erase(self, *args):
        """
        erase(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator pos) -> std::vector< Anasazi::Value< double > >::iterator
        erase(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator first, std::vector< Anasazi::Value< double > >::iterator last) -> std::vector< Anasazi::Value< double > >::iterator
        """
        return _Anasazi.VectorValueDouble_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(std::vector<(Anasazi::Value<(double)>)> self) -> VectorValueDouble
        __init__(std::vector<(Anasazi::Value<(double)>)> self, VectorValueDouble arg2) -> VectorValueDouble
        __init__(std::vector<(Anasazi::Value<(double)>)> self, std::vector< Anasazi::Value< double > >::size_type size) -> VectorValueDouble
        __init__(std::vector<(Anasazi::Value<(double)>)> self, std::vector< Anasazi::Value< double > >::size_type size, ValueDouble value) -> VectorValueDouble
        """
        this = _Anasazi.new_VectorValueDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, *args):
        """push_back(VectorValueDouble self, ValueDouble x)"""
        return _Anasazi.VectorValueDouble_push_back(self, *args)


    def front(self, *args):
        """front(VectorValueDouble self) -> ValueDouble"""
        return _Anasazi.VectorValueDouble_front(self, *args)


    def back(self, *args):
        """back(VectorValueDouble self) -> ValueDouble"""
        return _Anasazi.VectorValueDouble_back(self, *args)


    def assign(self, *args):
        """assign(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type n, ValueDouble x)"""
        return _Anasazi.VectorValueDouble_assign(self, *args)


    def resize(self, *args):
        """
        resize(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type new_size)
        resize(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type new_size, ValueDouble x)
        """
        return _Anasazi.VectorValueDouble_resize(self, *args)


    def insert(self, *args):
        """
        insert(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator pos, ValueDouble x) -> std::vector< Anasazi::Value< double > >::iterator
        insert(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator pos, std::vector< Anasazi::Value< double > >::size_type n, ValueDouble x)
        """
        return _Anasazi.VectorValueDouble_insert(self, *args)


    def reserve(self, *args):
        """reserve(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type n)"""
        return _Anasazi.VectorValueDouble_reserve(self, *args)


    def capacity(self, *args):
        """capacity(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::size_type"""
        return _Anasazi.VectorValueDouble_capacity(self, *args)

    __swig_destroy__ = _Anasazi.delete_VectorValueDouble
VectorValueDouble_swigregister = _Anasazi.VectorValueDouble_swigregister
VectorValueDouble_swigregister(VectorValueDouble)

class VectorInt(_object):
    """Proxy of C++ std::vector<(int)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorInt, name)
    __repr__ = _swig_repr

    def iterator(self, *args):
        """iterator(VectorInt self) -> SwigPyIterator"""
        return _Anasazi.VectorInt_iterator(self, *args)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self, *args):
        """__nonzero__(VectorInt self) -> bool"""
        return _Anasazi.VectorInt___nonzero__(self, *args)


    def __bool__(self, *args):
        """__bool__(VectorInt self) -> bool"""
        return _Anasazi.VectorInt___bool__(self, *args)


    def __len__(self, *args):
        """__len__(VectorInt self) -> std::vector< int >::size_type"""
        return _Anasazi.VectorInt___len__(self, *args)


    def __getslice__(self, *args):
        """__getslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j) -> VectorInt"""
        return _Anasazi.VectorInt___getslice__(self, *args)


    def __setslice__(self, *args):
        """
        __setslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)
        __setslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j, VectorInt v)
        """
        return _Anasazi.VectorInt___setslice__(self, *args)


    def __delslice__(self, *args):
        """__delslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)"""
        return _Anasazi.VectorInt___delslice__(self, *args)


    def __delitem__(self, *args):
        """
        __delitem__(VectorInt self, std::vector< int >::difference_type i)
        __delitem__(VectorInt self, PySliceObject * slice)
        """
        return _Anasazi.VectorInt___delitem__(self, *args)


    def __getitem__(self, *args):
        """
        __getitem__(VectorInt self, PySliceObject * slice) -> VectorInt
        __getitem__(VectorInt self, std::vector< int >::difference_type i) -> std::vector< int >::value_type const &
        """
        return _Anasazi.VectorInt___getitem__(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(VectorInt self, PySliceObject * slice, VectorInt v)
        __setitem__(VectorInt self, PySliceObject * slice)
        __setitem__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::value_type const & x)
        """
        return _Anasazi.VectorInt___setitem__(self, *args)


    def pop(self, *args):
        """pop(VectorInt self) -> std::vector< int >::value_type"""
        return _Anasazi.VectorInt_pop(self, *args)


    def append(self, *args):
        """append(VectorInt self, std::vector< int >::value_type const & x)"""
        return _Anasazi.VectorInt_append(self, *args)


    def empty(self, *args):
        """empty(VectorInt self) -> bool"""
        return _Anasazi.VectorInt_empty(self, *args)


    def size(self, *args):
        """size(VectorInt self) -> std::vector< int >::size_type"""
        return _Anasazi.VectorInt_size(self, *args)


    def swap(self, *args):
        """swap(VectorInt self, VectorInt v)"""
        return _Anasazi.VectorInt_swap(self, *args)


    def begin(self, *args):
        """begin(VectorInt self) -> std::vector< int >::iterator"""
        return _Anasazi.VectorInt_begin(self, *args)


    def end(self, *args):
        """end(VectorInt self) -> std::vector< int >::iterator"""
        return _Anasazi.VectorInt_end(self, *args)


    def rbegin(self, *args):
        """rbegin(VectorInt self) -> std::vector< int >::reverse_iterator"""
        return _Anasazi.VectorInt_rbegin(self, *args)


    def rend(self, *args):
        """rend(VectorInt self) -> std::vector< int >::reverse_iterator"""
        return _Anasazi.VectorInt_rend(self, *args)


    def clear(self, *args):
        """clear(VectorInt self)"""
        return _Anasazi.VectorInt_clear(self, *args)


    def get_allocator(self, *args):
        """get_allocator(VectorInt self) -> std::vector< int >::allocator_type"""
        return _Anasazi.VectorInt_get_allocator(self, *args)


    def pop_back(self, *args):
        """pop_back(VectorInt self)"""
        return _Anasazi.VectorInt_pop_back(self, *args)


    def erase(self, *args):
        """
        erase(VectorInt self, std::vector< int >::iterator pos) -> std::vector< int >::iterator
        erase(VectorInt self, std::vector< int >::iterator first, std::vector< int >::iterator last) -> std::vector< int >::iterator
        """
        return _Anasazi.VectorInt_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(std::vector<(int)> self) -> VectorInt
        __init__(std::vector<(int)> self, VectorInt arg2) -> VectorInt
        __init__(std::vector<(int)> self, std::vector< int >::size_type size) -> VectorInt
        __init__(std::vector<(int)> self, std::vector< int >::size_type size, std::vector< int >::value_type const & value) -> VectorInt
        """
        this = _Anasazi.new_VectorInt(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, *args):
        """push_back(VectorInt self, std::vector< int >::value_type const & x)"""
        return _Anasazi.VectorInt_push_back(self, *args)


    def front(self, *args):
        """front(VectorInt self) -> std::vector< int >::value_type const &"""
        return _Anasazi.VectorInt_front(self, *args)


    def back(self, *args):
        """back(VectorInt self) -> std::vector< int >::value_type const &"""
        return _Anasazi.VectorInt_back(self, *args)


    def assign(self, *args):
        """assign(VectorInt self, std::vector< int >::size_type n, std::vector< int >::value_type const & x)"""
        return _Anasazi.VectorInt_assign(self, *args)


    def resize(self, *args):
        """
        resize(VectorInt self, std::vector< int >::size_type new_size)
        resize(VectorInt self, std::vector< int >::size_type new_size, std::vector< int >::value_type const & x)
        """
        return _Anasazi.VectorInt_resize(self, *args)


    def insert(self, *args):
        """
        insert(VectorInt self, std::vector< int >::iterator pos, std::vector< int >::value_type const & x) -> std::vector< int >::iterator
        insert(VectorInt self, std::vector< int >::iterator pos, std::vector< int >::size_type n, std::vector< int >::value_type const & x)
        """
        return _Anasazi.VectorInt_insert(self, *args)


    def reserve(self, *args):
        """reserve(VectorInt self, std::vector< int >::size_type n)"""
        return _Anasazi.VectorInt_reserve(self, *args)


    def capacity(self, *args):
        """capacity(VectorInt self) -> std::vector< int >::size_type"""
        return _Anasazi.VectorInt_capacity(self, *args)

    __swig_destroy__ = _Anasazi.delete_VectorInt
VectorInt_swigregister = _Anasazi.VectorInt_swigregister
VectorInt_swigregister(VectorInt)


def Value(*args):
    """
    Factory function for class Value.  Currently, this returns a python
    wrapper around class Value<double>.
    """
    return ValueDouble(*args)


def OutputManager(*args):
    """
    Factory function for class OutputManager.  Currently, this returns a python
    wrapper around class OutputManager<double>.
    """
    return OutputManagerDouble(*args)


def BasicOutputManager(*args):
    """
    Factory function for class BasicOutputManager.  Currently, this returns a python
    wrapper around class BasicOutputManager<double>.
    """
    return BasicOutputManagerDouble(*args)


def MultiVec(*args):
    """
    Factory function for class MultiVec.  Currently, this returns a python
    wrapper around class MultiVec<double>.
    """
    return MultiVecDouble(*args)


def Operator(*args):
    """
    Factory function for class Operator.  Currently, this returns a python
    wrapper around class Operator<double>.
    """
    return OperatorDouble(*args)


def SortManager(*args):
    """
    Factory function for class SortManager.  Currently, this returns a python
    wrapper around class SortManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return SortManagerEpetra(*args)


def BasicSort(*args):
    """
    Factory function for class BasicSort.  Currently, this returns a python
    wrapper around class BasicSort<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BasicSortEpetra(*args)


def MultiVecTraits(*args):
    """
    Factory function for class MultiVecTraits.  Currently, this returns a python
    wrapper around class MultiVecTraits<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return MultiVecTraitsEpetra(*args)


def OperatorTraits(*args):
    """
    Factory function for class OperatorTraits.  Currently, this returns a python
    wrapper around class OperatorTraits<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return OperatorTraitsEpetra(*args)


def Eigenproblem(*args):
    """
    Factory function for class Eigenproblem.  Currently, this returns a python
    wrapper around class Eigenproblem<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return EigenproblemEpetra(*args)


def BasicEigenproblem(*args):
    """
    Factory function for class BasicEigenproblem.  Currently, this returns a python
    wrapper around class BasicEigenproblem<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BasicEigenproblemEpetra(*args)


def StatusTest(*args):
    """
    Factory function for class StatusTest.  Currently, this returns a python
    wrapper around class StatusTest<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestEpetra(*args)


def StatusTestCombo(*args):
    """
    Factory function for class StatusTestCombo.  Currently, this returns a python
    wrapper around class StatusTestCombo<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestComboEpetra(*args)


def StatusTestMaxIters(*args):
    """
    Factory function for class StatusTestMaxIters.  Currently, this returns a python
    wrapper around class StatusTestMaxIters<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestMaxItersEpetra(*args)


def StatusTestOutput(*args):
    """
    Factory function for class StatusTestOutput.  Currently, this returns a python
    wrapper around class StatusTestOutput<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestOutputEpetra(*args)


def StatusTestResNorm(*args):
    """
    Factory function for class StatusTestResNorm.  Currently, this returns a python
    wrapper around class StatusTestResNorm<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestResNormEpetra(*args)


def OrthoManager(*args):
    """
    Factory function for class OrthoManager.  Currently, this returns a python
    wrapper around class OrthoManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return OrthoManagerEpetra(*args)


def MatOrthoManager(*args):
    """
    Factory function for class MatOrthoManager.  Currently, this returns a python
    wrapper around class MatOrthoManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return MatOrthoManagerEpetra(*args)


def SVQBOrthoManager(*args):
    """
    Factory function for class SVQBOrthoManager.  Currently, this returns a python
    wrapper around class SVQBOrthoManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return SVQBOrthoManagerEpetra(*args)


def Eigensolver(*args):
    """
    Factory function for class Eigensolver.  Currently, this returns a python
    wrapper around class Eigensolver<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return EigensolverEpetra(*args)


def SolverManager(*args):
    """
    Factory function for class SolverManager.  Currently, this returns a python
    wrapper around class SolverManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return SolverManagerEpetra(*args)


def BlockDavidson(*args):
    """
    Factory function for class BlockDavidson.  Currently, this returns a python
    wrapper around class BlockDavidson<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockDavidsonEpetra(*args)


def BlockDavidsonSolMgr(*args):
    """
    Factory function for class BlockDavidsonSolMgr.  Currently, this returns a python
    wrapper around class BlockDavidsonSolMgr<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockDavidsonSolMgrEpetra(*args)


def BlockKrylovSchur(*args):
    """
    Factory function for class BlockKrylovSchur.  Currently, this returns a python
    wrapper around class BlockKrylovSchur<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockKrylovSchurEpetra(*args)


def BlockKrylovSchurSolMgr(*args):
    """
    Factory function for class BlockKrylovSchurSolMgr.  Currently, this returns a python
    wrapper around class BlockKrylovSchurSolMgr<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockKrylovSchurSolMgrEpetra(*args)


def LOBPCG(*args):
    """
    Factory function for class LOBPCG.  Currently, this returns a python
    wrapper around class LOBPCG<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return LOBPCGEpetra(*args)


def LOBPCGSolMgr(*args):
    """
    Factory function for class LOBPCGSolMgr.  Currently, this returns a python
    wrapper around class LOBPCGSolMgr<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return LOBPCGSolMgrEpetra(*args)


def Eigensolution(*args):
    """
    Factory function for class Eigensolution.  Currently, this returns a python
    wrapper around class Eigensolution<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return EigensolutionEpetra(*args)

# This file is compatible with both classic and new-style classes.


