# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Amesos is the python interface to the Trilinos direct
linear solver package Amesos:

    http://trilinos.sandia.gov/packages/amesos

The purpose of Amesos is to provide a common interface to a variety of
third-party direct solvers, made compatible with PyTrilinos.Epetra.
Note that the C++ version of Amesos uses the prefix 'Amesos_', which
has been stripped from the python implementation.

The most important classes of the Amesos module are:

    * Factory      - Factory class
    * Lapack       - LAPACK interface
    * Klu          - KLU interface
    * Umfpack      - UMFPACK interface
    * Scalapack    - SCALAPACK interface
    * Superlu      - SuperLU interface
    * Superludist  - SuperLU_DIST interface
    * Dscpack      - DSCPACK interface
    * Mumps        - MUMPS interface

Use dir(Amesos) to see what specific interfaces have been enabled on
your platform.  For examples of usage, please consult the examples
subdirectory of the PyTrilinos package, scripts exAmesos_Simple.py and
exAmesos_Factory.py.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Amesos')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Amesos')
    _Amesos = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Amesos', [dirname(__file__)])
        except ImportError:
            import _Amesos
            return _Amesos
        try:
            _mod = imp.load_module('_Amesos', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Amesos = swig_import_helper()
    del swig_import_helper
else:
    import _Amesos
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Amesos.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Amesos.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Amesos.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Amesos.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Amesos.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Amesos.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Amesos.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Amesos.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Amesos.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Amesos.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Amesos.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Teuchos
else:
    import Teuchos
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import Epetra
else:
    import Epetra
del _swig_python_version_info
class Factory(_object):
    """Proxy of C++ Amesos class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Factory, name)
    __repr__ = _swig_repr

    def Create(self, *args):
        """
        Create(Factory self, char const * ClassType, Epetra_LinearProblem LinearProblem) -> BaseSolver
        Create(Factory self, std::string const CT, Epetra_LinearProblem LinearProblem) -> BaseSolver
        """
        return _Amesos.Factory_Create(self, *args)


    def Query(self, *args):
        """
        Query(Factory self, char const * ClassType) -> bool
        Query(Factory self, std::string const CT) -> bool
        """
        return _Amesos.Factory_Query(self, *args)


    def GetValidParameters(*args):
        """GetValidParameters() -> ParameterList"""
        return _Amesos.Factory_GetValidParameters(*args)

    GetValidParameters = staticmethod(GetValidParameters)

    def __init__(self, *args):
        """__init__(Amesos self) -> Factory"""
        this = _Amesos.new_Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Amesos.delete_Factory
Factory_swigregister = _Amesos.Factory_swigregister
Factory_swigregister(Factory)

def Factory_GetValidParameters(*args):
    """Factory_GetValidParameters() -> ParameterList"""
    return _Amesos.Factory_GetValidParameters(*args)

class BaseSolver(Teuchos.ParameterListAcceptor):
    """


    Amesos_BaseSolver: A pure virtual class for direct solution of real-
    valued double- precision operators.

    Pure virtual class for all Amesos concrete implementions.

    The Amesos_BaseSolver class is a pure virtual class (that is, it
    specifies interface only) that enables the use of real-valued double-
    precision direct sparse solvers. Every Amesos class named Amesos_
    SolverName derives from Amesos_BaseSolver.

    Usage Examples

    Basic calling sequence

    The basic calling sequence solves A x = b or AT x = b without
    specifying how A has changed between each call to Solve().

    Re-using the symbolic factorization

    The following calling sequence performs multiple solves of A x = b or
    AT x = b in cases where the non-zero structure of A remains unchanged
    between each call to Solve().

    Re-using the numeric factorization

    The following calling sequence performs multiple solves of A x = b or
    AT x = b provided that A remains unchanged between each call to
    Solve().

    Constructor requirements

    Every Amesos_SolverName class should accept an Epetra_LinearProblem

    Mathematical methods

    Four mathematical methods are defined in the base class
    Amesos_BaseSolver: SymbolicFactorization(), NumericFactorization(),
    and Solve().

    Switching concrete classes

    Different concrete classes, each based on a different third party
    solver, will have different performance characteristics and will
    accept different parameters.

    Changing the values of the underlying matrix operator.

    Any changes to the values of a matrix must be accompanied by a call to
    NumericFactorization() before the next call to Solve() or the behavior
    of Solve() is undefined. Any changes to the numerical structure of the
    matrix must be followed by a call to SymbolicFactorization() and
    NumericalFactorization() before the next call to Solve().

    Once SymbolicFactorization() has been called, classes implementing
    this interface may assume that any change made to the non-zero
    structure of the underlying matrix will be accompanied by a call to
    SymbolicFactorization() prior to a subsequent call to
    NumericFactorization or Solve().

    Named Parameters

    Parameters can be changed or added at any time by calling
    SetParameters(ParamList) with the new parameters specified in
    ParamList.

    It is left to the user to be sure that changes made to the parameters
    are appropriate for the concrete class that they are using.

    Examples of appropriate changes in parameters include:  Changing
    iterative refinement rules between calls to Solve()

    Changing drop tolerance rules between calls to NumericFactorization()

    Examples of inappropriate changes in parameters include:  Changing
    drop tolerance rules between solve steps.
    Solver.NumericFactorization();
    Solver.getList()->set("DropTolerance",.001); Solver.Solve();
    Results of making inappropriate changes in parameters is unpredictable
    and could include an error return, a bogus result or ignoring the
    parameter change.

    Transpose solve

    Any class implementing Amesos_BaseSolver should handle calls to
    SetUseTranspose() at any point. However, the result of a call to
    SetUseTranspose() which is not followed by a call to
    SymbolicFactorization() and NumericFactorization() is implementation
    dependent. Some third party libraries are able to solve AT x = b and
    Ax = b using the same factorization. Others will require a new
    factorization anytime that a call to SetUseTranspose() changes the
    intended solve from AT x = b to Ax = b or vice-versa.

    Performance expectations

    The following is a list of performance guidelines that classes which
    implement the Amesos_BaseSolver class are expected to maintain.

    Memory usage:

    For serial codes, no more than one extra copy of the original matrix
    should be required. Except that some codes require matrix transpostion
    which requires additional copies of the input matrix.

    For distributed memory codes, no serial copies of the original matrix
    should be required.

    Robustness requirements

    Failures should be caught by AMESOS_CHK_ERR().

    The following error codes should be used: 1: Singular matrix

    2: Non-symmetric matrix

    3: Matrix is not positive definite

    4: Insufficient memory

    Because we do not check to see if a matrix has changed between the
    call to SymbolicFactorization() and the call to
    NumericFactorization(), it is possible that a change to the matrix
    will cause a potentially catastrophic error.

    C++ includes: Amesos_BaseSolver.h 
    """

    __swig_setmethods__ = {}
    for _s in [Teuchos.ParameterListAcceptor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BaseSolver, name, value)
    __swig_getmethods__ = {}
    for _s in [Teuchos.ParameterListAcceptor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BaseSolver, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def getParameterList(self, *args):
        """
        getParameterList(BaseSolver self) -> Teuchos::RCP< Teuchos::ParameterList const >

        Teuchos::RCP< const
        Teuchos::ParameterList >
        Teuchos::ParameterListAcceptor::getParameterList() const

        Get const version of the parameter list that was set using
        setParameterList().

        The default implementation returns: 
        """
        return _Amesos.BaseSolver_getParameterList(self, *args)

    __swig_destroy__ = _Amesos.delete_BaseSolver

    def SymbolicFactorization(self, *args):
        """
        SymbolicFactorization(BaseSolver self) -> int

        virtual int Amesos_BaseSolver::SymbolicFactorization()=0

        Performs SymbolicFactorization on the matrix A.

        In addition to performing symbolic factorization on the matrix A, the
        call to SymbolicFactorization() implies that no change will be made to
        the non-zero structure of the underlying matrix without a subsequent
        call to SymbolicFactorization().

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        <br >Postconditions: Symbolic Factorization will be performed (or
        marked to be performed) allowing NumericFactorization() and Solve() to
        be called.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.BaseSolver_SymbolicFactorization(self, *args)


    def NumericFactorization(self, *args):
        """
        NumericFactorization(BaseSolver self) -> int

        virtual int Amesos_BaseSolver::NumericFactorization()=0

        Performs NumericFactorization on the matrix A.

        In addition to performing numeric factorization on the matrix A, the
        call to NumericFactorization() implies that no change will be made to
        the underlying matrix without a subsequent call to
        NumericFactorization().

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        The non-zero structure of the matrix should not have changed since the
        last call to SymbolicFactorization().

        (return -2 if the number of non-zeros changes) Other changes can have
        arbitrary consequences.

        The distribution of the matrix should not have changed since the last
        call to SymbolicFactorization()

        The matrix should be indexed from 0 to n-1, unless the parameter
        "Reindex" was set to "true" prior to the call to
        SymbolicFactorization().

        (return -3 - if caught)

        The paremeter "Reindex" should not be set to "true" except on
        CrsMatrices. (return -4)

        The paremeter "Reindex" should not be set to "true" unless Amesos
        was built with EpetraExt, i.e. withenable-epetraext on the configure
        line. (return -4)

        Internal errors retur -5.

        <br >Postconditions: Numeric Factorization will be performed (or
        marked to be performed) allowing Solve() to be performed correctly
        despite a potential change in in the matrix values (though not in the
        non-zero structure).

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.BaseSolver_NumericFactorization(self, *args)


    def Solve(self, *args):
        """
        Solve(BaseSolver self) -> int

        virtual int
        Amesos_BaseSolver::Solve()=0

        Solves A X = B (or AT x = B)

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        GetProblem()->CheckInput (see Epetra_LinearProblem::CheckInput() for
        return values)

        The non-zero structure of the matrix should not have changed since the
        last call to SymbolicFactorization().

        The distribution of the matrix should not have changed since the last
        call to SymbolicFactorization()

        The matrix should not have changed since the last call to
        NumericFactorization().

        <br >Postconditions: X will be set such that A X = B (or AT X = B),
        within the limits of the accuracy of the underlying solver.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.BaseSolver_Solve(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(BaseSolver self, bool UseTranspose) -> int

        virtual
        int Amesos_BaseSolver::SetUseTranspose(bool UseTranspose)=0

        If set true, X will be set to the solution of AT X = B (not A X = B)

        If the implementation of this interface does not support transpose
        use, this method should return a value of -1.

        <br >Preconditions:  SetUseTranspose() should be called prior to the
        call to SymbolicFactorization() If NumericFactorization() or Solve()
        is called after SetUseTranspose() without an intervening call to
        SymbolicFactorization() the result is implementation dependent.

        <br >Postconditions: The next factorization and solve will be
        performed with the new value of UseTranspose.

        Parameters:
        -----------

        UseTranspose:   (In) If true, solve AT X = B, otherwise solve A X = B.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Amesos.BaseSolver_SetUseTranspose(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(BaseSolver self) -> bool

        virtual bool
        Amesos_BaseSolver::UseTranspose() const =0

        Returns the current UseTranspose setting. 
        """
        return _Amesos.BaseSolver_UseTranspose(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(BaseSolver self, ParameterList ParameterList) -> int

        virtual int
        Amesos_BaseSolver::SetParameters(Teuchos::ParameterList
        &ParameterList)=0

        Updates internal variables.

        <br \\>Preconditions:<ul>   <li>None.</li>   </ul>    <br
        \\>Postconditions:<ul>    <li>Internal variables controlling the
        factorization and solve will   be updated and take effect on all
        subseuent calls to NumericFactorization()    and Solve().</li> <li>All
        parameters whose value are to differ from the default values must be
        included in ParameterList. Parameters not specified in ParameterList
        revert to their default values.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.BaseSolver_SetParameters(self, *args)


    def GetProblem(self, *args):
        """
        GetProblem(BaseSolver self) -> Epetra_LinearProblem

        virtual const
        Epetra_LinearProblem* Amesos_BaseSolver::GetProblem() const =0

        Returns the Epetra_LinearProblem.

        Warning! Do not call return->SetOperator(...) to attempt to change the
        Epetra_Operator object (even if the new matrix has the same
        structure). This new operator matrix will be ignored! 
        """
        return _Amesos.BaseSolver_GetProblem(self, *args)


    def MatrixShapeOK(self, *args):
        """
        MatrixShapeOK(BaseSolver self) -> bool

        virtual bool
        Amesos_BaseSolver::MatrixShapeOK() const =0

        Returns true if the solver can handle this matrix shape.

        Returns true if the matrix shape is one that the underlying sparse
        direct solver can handle. Classes that work only on square matrices
        should return false for rectangular matrices. Classes that work only
        on symmetric matrices whould return false for non-symmetric matrices.

        """
        return _Amesos.BaseSolver_MatrixShapeOK(self, *args)


    def Comm(self, *args):
        """
        Comm(BaseSolver self) -> Comm

        virtual const
        Epetra_Comm& Amesos_BaseSolver::Comm() const =0

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Amesos.BaseSolver_Comm(self, *args)


    def NumSymbolicFact(self, *args):
        """
        NumSymbolicFact(BaseSolver self) -> int

        virtual
        int Amesos_BaseSolver::NumSymbolicFact() const =0

        Returns the number of symbolic factorizations performed by this
        object. 
        """
        return _Amesos.BaseSolver_NumSymbolicFact(self, *args)


    def NumNumericFact(self, *args):
        """
        NumNumericFact(BaseSolver self) -> int

        virtual int
        Amesos_BaseSolver::NumNumericFact() const =0

        Returns the number of numeric factorizations performed by this object.

        """
        return _Amesos.BaseSolver_NumNumericFact(self, *args)


    def NumSolve(self, *args):
        """
        NumSolve(BaseSolver self) -> int

        virtual int
        Amesos_BaseSolver::NumSolve() const =0

        Returns the number of solves performed by this object. 
        """
        return _Amesos.BaseSolver_NumSolve(self, *args)


    def PrintStatus(self, *args):
        """
        PrintStatus(BaseSolver self)

        virtual void
        Amesos_BaseSolver::PrintStatus() const =0

        Prints status information about the current solver. 
        """
        return _Amesos.BaseSolver_PrintStatus(self, *args)


    def PrintTiming(self, *args):
        """
        PrintTiming(BaseSolver self)

        virtual void
        Amesos_BaseSolver::PrintTiming() const =0

        Prints timing information about the current solver. 
        """
        return _Amesos.BaseSolver_PrintTiming(self, *args)


    def setParameterList(self, *args):
        """
        setParameterList(BaseSolver self, Teuchos::RCP< Teuchos::ParameterList > const & paramList)

        virtual
        void Amesos_BaseSolver::setParameterList(Teuchos::RCP<
        Teuchos::ParameterList > const &paramList)

        Redefined from Teuchos::ParameterListAcceptor (Does Not Work) 
        """
        return _Amesos.BaseSolver_setParameterList(self, *args)


    def getNonconstParameterList(self, *args):
        """
        getNonconstParameterList(BaseSolver self) -> Teuchos::RCP< Teuchos::ParameterList >

        virtual Teuchos::RCP<Teuchos::ParameterList>
        Amesos_BaseSolver::getNonconstParameterList()

        This is an empty stub. 
        """
        return _Amesos.BaseSolver_getNonconstParameterList(self, *args)


    def unsetParameterList(self, *args):
        """
        unsetParameterList(BaseSolver self) -> Teuchos::RCP< Teuchos::ParameterList >

        virtual
        Teuchos::RCP<Teuchos::ParameterList>
        Amesos_BaseSolver::unsetParameterList()

        This is an empty stub. 
        """
        return _Amesos.BaseSolver_unsetParameterList(self, *args)


    def GetTiming(self, *args):
        """
        GetTiming(BaseSolver self, ParameterList TimingParameterList)

        virtual void
        Amesos_BaseSolver::GetTiming(Teuchos::ParameterList
        &TimingParameterList) const

        Extracts timing information from the current solver and places it in
        the parameter list. (Does Not Work) 
        """
        return _Amesos.BaseSolver_GetTiming(self, *args)

BaseSolver_swigregister = _Amesos.BaseSolver_swigregister
BaseSolver_swigregister(BaseSolver)
cvar = _Amesos.cvar
StructurallySingularMatrixError = cvar.StructurallySingularMatrixError
NumericallySingularMatrixError = cvar.NumericallySingularMatrixError

class Lapack(BaseSolver):
    """


    Amesos_Lapack: an interface to LAPACK.

    Class Amesos_Lapack enables the solution of the distributed linear
    system, defined by an Epetra_LinearProblem, using LAPACK.

    Amesos_Lapack stores the lineaar system matrix as an
    Epetra_SerialDensMatrix. The linear problem is an
    Epetra_SerialDenseProblem. Amesos_Lapack factorizes the matrix using
    DGETRF().

    Marzio Sala, 9214.

    C++ includes: Amesos_Lapack.h 
    """

    __swig_setmethods__ = {}
    for _s in [BaseSolver]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Lapack, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseSolver]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Lapack, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Amesos_Lapack self, Epetra_LinearProblem LinearProblem) -> Lapack

        Amesos_Lapack::Amesos_Lapack(const Epetra_LinearProblem
        &LinearProblem)

        Amesos_Lapack Constructor.

        Creates an Amesos_Lapack instance, using an Epetra_LinearProblem,
        passing in an already- defined Epetra_LinearProblem object.

        Note: The operator in LinearProblem must be an Epetra_RowMatrix. 
        """
        this = _Amesos.new_Lapack(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Amesos.delete_Lapack

    def SymbolicFactorization(self, *args):
        """
        SymbolicFactorization(Lapack self) -> int

        int
        Amesos_Lapack::SymbolicFactorization()

        Performs SymbolicFactorization on the matrix A.

        In addition to performing symbolic factorization on the matrix A, the
        call to SymbolicFactorization() implies that no change will be made to
        the non-zero structure of the underlying matrix without a subsequent
        call to SymbolicFactorization().

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        <br >Postconditions: Symbolic Factorization will be performed (or
        marked to be performed) allowing NumericFactorization() and Solve() to
        be called.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Lapack_SymbolicFactorization(self, *args)


    def NumericFactorization(self, *args):
        """
        NumericFactorization(Lapack self) -> int

        int
        Amesos_Lapack::NumericFactorization()

        Performs NumericFactorization on the matrix A.

        In addition to performing numeric factorization on the matrix A, the
        call to NumericFactorization() implies that no change will be made to
        the underlying matrix without a subsequent call to
        NumericFactorization().

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        The non-zero structure of the matrix should not have changed since the
        last call to SymbolicFactorization().

        (return -2 if the number of non-zeros changes) Other changes can have
        arbitrary consequences.

        The distribution of the matrix should not have changed since the last
        call to SymbolicFactorization()

        The matrix should be indexed from 0 to n-1, unless the parameter
        "Reindex" was set to "true" prior to the call to
        SymbolicFactorization().

        (return -3 - if caught)

        The paremeter "Reindex" should not be set to "true" except on
        CrsMatrices. (return -4)

        The paremeter "Reindex" should not be set to "true" unless Amesos
        was built with EpetraExt, i.e. withenable-epetraext on the configure
        line. (return -4)

        Internal errors retur -5.

        <br >Postconditions: Numeric Factorization will be performed (or
        marked to be performed) allowing Solve() to be performed correctly
        despite a potential change in in the matrix values (though not in the
        non-zero structure).

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Lapack_NumericFactorization(self, *args)


    def Solve(self, *args):
        """
        Solve(Lapack self) -> int

        int
        Amesos_Lapack::Solve()

        Solves A X = B (or AT x = B)

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        GetProblem()->CheckInput (see Epetra_LinearProblem::CheckInput() for
        return values)

        The non-zero structure of the matrix should not have changed since the
        last call to SymbolicFactorization().

        The distribution of the matrix should not have changed since the last
        call to SymbolicFactorization()

        The matrix should not have changed since the last call to
        NumericFactorization().

        <br >Postconditions: X will be set such that A X = B (or AT X = B),
        within the limits of the accuracy of the underlying solver.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Lapack_Solve(self, *args)


    def GetProblem(self, *args):
        """
        GetProblem(Lapack self) -> Epetra_LinearProblem

        const
        Epetra_LinearProblem* Amesos_Lapack::GetProblem() const

        Returns the Epetra_LinearProblem.

        Warning! Do not call return->SetOperator(...) to attempt to change the
        Epetra_Operator object (even if the new matrix has the same
        structure). This new operator matrix will be ignored! 
        """
        return _Amesos.Lapack_GetProblem(self, *args)


    def MatrixShapeOK(self, *args):
        """
        MatrixShapeOK(Lapack self) -> bool

        bool
        Amesos_Lapack::MatrixShapeOK() const

        Returns true if the solver can handle this matrix shape.

        Returns true if the matrix shape is one that the underlying sparse
        direct solver can handle. Classes that work only on square matrices
        should return false for rectangular matrices. Classes that work only
        on symmetric matrices whould return false for non-symmetric matrices.

        """
        return _Amesos.Lapack_MatrixShapeOK(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(Lapack self, bool UseTranspose_in) -> int

        int
        Amesos_Lapack::SetUseTranspose(bool UseTranspose_in)

        If set true, X will be set to the solution of AT X = B (not A X = B)

        If the implementation of this interface does not support transpose
        use, this method should return a value of -1.

        <br >Preconditions:  SetUseTranspose() should be called prior to the
        call to SymbolicFactorization() If NumericFactorization() or Solve()
        is called after SetUseTranspose() without an intervening call to
        SymbolicFactorization() the result is implementation dependent.

        <br >Postconditions: The next factorization and solve will be
        performed with the new value of UseTranspose.

        Parameters:
        -----------

        UseTranspose:   (In) If true, solve AT X = B, otherwise solve A X = B.

        Integer error code, set to 0 if successful. Set to -1 if this
        implementation does not support transpose. 
        """
        return _Amesos.Lapack_SetUseTranspose(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(Lapack self) -> bool

        bool
        Amesos_Lapack::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Amesos.Lapack_UseTranspose(self, *args)


    def Comm(self, *args):
        """
        Comm(Lapack self) -> Comm

        const Epetra_Comm&
        Amesos_Lapack::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Amesos.Lapack_Comm(self, *args)


    def setParameterList(self, *args):
        """
        setParameterList(Lapack self, Teuchos::RCP< Teuchos::ParameterList > const & paramList)

        void
        Amesos_Lapack::setParameterList(Teuchos::RCP< Teuchos::ParameterList >
        const &paramList)

        Use this parameter list to read values from.

        Redefined from Teuchos::ParameterListAcceptor 
        """
        return _Amesos.Lapack_setParameterList(self, *args)


    def unsetParameterList(self, *args):
        """
        unsetParameterList(Lapack self) -> Teuchos::RCP< Teuchos::ParameterList >

        Teuchos::RCP< Teuchos::ParameterList >
        Amesos_Lapack::unsetParameterList()

        This is an empty stub. 
        """
        return _Amesos.Lapack_unsetParameterList(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(Lapack self, ParameterList ParameterList) -> int

        int
        Amesos_Lapack::SetParameters(Teuchos::ParameterList &ParameterList)

        Deprecated - Sets parameters. 
        """
        return _Amesos.Lapack_SetParameters(self, *args)


    def GEEV(self, *args):
        """
        GEEV(Lapack self, Vector Er, Vector Ei) -> int

        int
        Amesos_Lapack::GEEV(Epetra_Vector &Er, Epetra_Vector &Ei)

        Computes the eigenvalues of the linear system matrix using DGEEV.

        Parameters:
        -----------

        Er:  - (Out) On processor zero only, it will contain the real
        component of the eigenvalues.

        Ei:  - (Out) On processor zero only, it will contain the imaginary
        component of the eigenvalues.

        Er and Ei must have been allocated so that the local length on
        processor 0 equals the global size of the matrix. 
        """
        return _Amesos.Lapack_GEEV(self, *args)


    def NumSymbolicFact(self, *args):
        """
        NumSymbolicFact(Lapack self) -> int

        int
        Amesos_Lapack::NumSymbolicFact() const

        Returns the number of symbolic factorizations performed by this
        object. 
        """
        return _Amesos.Lapack_NumSymbolicFact(self, *args)


    def NumNumericFact(self, *args):
        """
        NumNumericFact(Lapack self) -> int

        int
        Amesos_Lapack::NumNumericFact() const

        Returns the number of numeric factorizations performed by this object.

        """
        return _Amesos.Lapack_NumNumericFact(self, *args)


    def NumSolve(self, *args):
        """
        NumSolve(Lapack self) -> int

        int
        Amesos_Lapack::NumSolve() const

        Returns the number of solves performed by this object. 
        """
        return _Amesos.Lapack_NumSolve(self, *args)


    def PrintTiming(self, *args):
        """
        PrintTiming(Lapack self)

        void
        Amesos_Lapack::PrintTiming() const

        Print timing information. 
        """
        return _Amesos.Lapack_PrintTiming(self, *args)


    def PrintStatus(self, *args):
        """
        PrintStatus(Lapack self)

        void
        Amesos_Lapack::PrintStatus() const

        Print information about the factorization and solution phases. 
        """
        return _Amesos.Lapack_PrintStatus(self, *args)


    def GetTiming(self, *args):
        """
        GetTiming(Lapack self, ParameterList TimingParameterList)

        void
        Amesos_Lapack::GetTiming(Teuchos::ParameterList &TimingParameterList)
        const

        Extracts timing information from the current solver and places it in
        the parameter list. 
        """
        return _Amesos.Lapack_GetTiming(self, *args)

Lapack_swigregister = _Amesos.Lapack_swigregister
Lapack_swigregister(Lapack)

class Klu(BaseSolver):
    """


    Interface to KLU internal solver.

    Interface to UMFPACK.

    C++ includes: Amesos_Umfpack.h 
    """

    __swig_setmethods__ = {}
    for _s in [BaseSolver]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Klu, name, value)
    __swig_getmethods__ = {}
    for _s in [BaseSolver]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Klu, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Amesos_Klu self, Epetra_LinearProblem LinearProblem) -> Klu

        Amesos_Klu::Amesos_Klu(const Epetra_LinearProblem &LinearProblem)

        Amesos_Klu Constructor.

        Creates an Amesos_Klu instance, using an Epetra_LinearProblem, passing
        in an already- defined Epetra_LinearProblem object.

        Note: The operator in LinearProblem must be an Epetra_RowMatrix. 
        """
        this = _Amesos.new_Klu(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Amesos.delete_Klu

    def SymbolicFactorization(self, *args):
        """
        SymbolicFactorization(Klu self) -> int

        int
        Amesos_Klu::SymbolicFactorization()

        Performs SymbolicFactorization on the matrix A.

        In addition to performing symbolic factorization on the matrix A, the
        call to SymbolicFactorization() implies that no change will be made to
        the non-zero structure of the underlying matrix without a subsequent
        call to SymbolicFactorization().

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        <br >Postconditions: Symbolic Factorization will be performed (or
        marked to be performed) allowing NumericFactorization() and Solve() to
        be called.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Klu_SymbolicFactorization(self, *args)


    def NumericFactorization(self, *args):
        """
        NumericFactorization(Klu self) -> int

        int
        Amesos_Klu::NumericFactorization()

        Performs NumericFactorization on the matrix A.

        In addition to performing numeric factorization on the matrix A, the
        call to NumericFactorization() implies that no change will be made to
        the underlying matrix without a subsequent call to
        NumericFactorization().

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        The non-zero structure of the matrix should not have changed since the
        last call to SymbolicFactorization().

        (return -2 if the number of non-zeros changes) Other changes can have
        arbitrary consequences.

        The distribution of the matrix should not have changed since the last
        call to SymbolicFactorization()

        The matrix should be indexed from 0 to n-1, unless the parameter
        "Reindex" was set to "true" prior to the call to
        SymbolicFactorization().

        (return -3 - if caught)

        The paremeter "Reindex" should not be set to "true" except on
        CrsMatrices. (return -4)

        The paremeter "Reindex" should not be set to "true" unless Amesos
        was built with EpetraExt, i.e. withenable-epetraext on the configure
        line. (return -4)

        Internal errors retur -5.

        <br >Postconditions: Numeric Factorization will be performed (or
        marked to be performed) allowing Solve() to be performed correctly
        despite a potential change in in the matrix values (though not in the
        non-zero structure).

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Klu_NumericFactorization(self, *args)


    def Solve(self, *args):
        """
        Solve(Klu self) -> int

        int Amesos_Klu::Solve()

        Solves A X = B (or AT x = B)

        <br >Preconditions:  GetProblem().GetOperator() != 0 (return -1)

        MatrixShapeOk( GetProblem().GetOperator()) == true (return -6)

        GetProblem()->CheckInput (see Epetra_LinearProblem::CheckInput() for
        return values)

        The non-zero structure of the matrix should not have changed since the
        last call to SymbolicFactorization().

        The distribution of the matrix should not have changed since the last
        call to SymbolicFactorization()

        The matrix should not have changed since the last call to
        NumericFactorization().

        <br >Postconditions: X will be set such that A X = B (or AT X = B),
        within the limits of the accuracy of the underlying solver.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Klu_Solve(self, *args)


    def GetProblem(self, *args):
        """
        GetProblem(Klu self) -> Epetra_LinearProblem

        const
        Epetra_LinearProblem* Amesos_Klu::GetProblem() const

        Get a pointer to the Problem. 
        """
        return _Amesos.Klu_GetProblem(self, *args)


    def MatrixShapeOK(self, *args):
        """
        MatrixShapeOK(Klu self) -> bool

        bool
        Amesos_Klu::MatrixShapeOK() const

        Returns true if KLU can handle this matrix shape.

        Returns true if the matrix shape is one that KLU can handle. KLU only
        works with square matrices. 
        """
        return _Amesos.Klu_MatrixShapeOK(self, *args)


    def SetUseTranspose(self, *args):
        """
        SetUseTranspose(Klu self, bool UseTranspose_in) -> int

        int
        Amesos_Klu::SetUseTranspose(bool UseTranspose_in)

        SetUseTranpose(true) is more efficient in Amesos_Klu.

        If SetUseTranspose() is set to true, $A^T X = B$ is computed. 
        """
        return _Amesos.Klu_SetUseTranspose(self, *args)


    def UseTranspose(self, *args):
        """
        UseTranspose(Klu self) -> bool

        bool
        Amesos_Klu::UseTranspose() const

        Returns the current UseTranspose setting. 
        """
        return _Amesos.Klu_UseTranspose(self, *args)


    def Comm(self, *args):
        """
        Comm(Klu self) -> Comm

        const Epetra_Comm&
        Amesos_Klu::Comm() const

        Returns a pointer to the Epetra_Comm communicator associated with this
        operator. 
        """
        return _Amesos.Klu_Comm(self, *args)


    def SetParameters(self, *args):
        """
        SetParameters(Klu self, ParameterList ParameterList) -> int

        int
        Amesos_Klu::SetParameters(Teuchos::ParameterList &ParameterList)

        Updates internal variables.

        <br \\>Preconditions:<ul>   <li>None.</li>   </ul>    <br
        \\>Postconditions:<ul>    <li>Internal variables controlling the
        factorization and solve will   be updated and take effect on all
        subseuent calls to NumericFactorization()    and Solve().</li> <li>All
        parameters whose value are to differ from the default values must be
        included in ParameterList. Parameters not specified in ParameterList
        revert to their default values.

        Integer error code, set to 0 if successful. 
        """
        return _Amesos.Klu_SetParameters(self, *args)


    def NumSymbolicFact(self, *args):
        """
        NumSymbolicFact(Klu self) -> int

        int
        Amesos_Klu::NumSymbolicFact() const

        Returns the number of symbolic factorizations performed by this
        object. 
        """
        return _Amesos.Klu_NumSymbolicFact(self, *args)


    def NumNumericFact(self, *args):
        """
        NumNumericFact(Klu self) -> int

        int
        Amesos_Klu::NumNumericFact() const

        Returns the number of numeric factorizations performed by this object.

        """
        return _Amesos.Klu_NumNumericFact(self, *args)


    def NumSolve(self, *args):
        """
        NumSolve(Klu self) -> int

        int
        Amesos_Klu::NumSolve() const

        Returns the number of solves performed by this object. 
        """
        return _Amesos.Klu_NumSolve(self, *args)


    def PrintTiming(self, *args):
        """
        PrintTiming(Klu self)

        void
        Amesos_Klu::PrintTiming() const

        Prints timing information. 
        """
        return _Amesos.Klu_PrintTiming(self, *args)


    def PrintStatus(self, *args):
        """
        PrintStatus(Klu self)

        void
        Amesos_Klu::PrintStatus() const

        Prints information about the factorization and solution phases. 
        """
        return _Amesos.Klu_PrintStatus(self, *args)


    def GetTiming(self, *args):
        """
        GetTiming(Klu self, ParameterList TimingParameterList)

        void
        Amesos_Klu::GetTiming(Teuchos::ParameterList &TimingParameterList)
        const

        Extracts timing information and places in parameter list. 
        """
        return _Amesos.Klu_GetTiming(self, *args)

Klu_swigregister = _Amesos.Klu_swigregister
Klu_swigregister(Klu)

# This file is compatible with both classic and new-style classes.


