# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/SEACASBlot clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################


# Include guard
IF (SEACASBlot_CONFIG_INCLUDED)
  RETURN()
ENDIF()
SET(SEACASBlot_CONFIG_INCLUDED TRUE)

# Make sure CMAKE_CURRENT_LIST_DIR is usable
IF (NOT DEFINED CMAKE_CURRENT_LIST_DIR)
  GET_FILENAME_COMPONENT(_THIS_SCRIPT_PATH ${CMAKE_CURRENT_LIST_FILE} PATH)
  SET(CMAKE_CURRENT_LIST_DIR ${_THIS_SCRIPT_PATH})
ENDIF()


## ---------------------------------------------------------------------------
## Compilers used by Trilinos/SEACASBlot build
## ---------------------------------------------------------------------------

SET(SEACASBlot_CXX_COMPILER "/usr/bin/mpicxx")

SET(SEACASBlot_C_COMPILER "/usr/bin/mpicc")

SET(SEACASBlot_FORTRAN_COMPILER "/usr/bin/mpif90")


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/SEACASBlot build
## ---------------------------------------------------------------------------

## Set compiler flags, including those determined by build type
SET(SEACASBlot_CXX_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -std=c++11 -O3 -DNDEBUG")

SET(SEACASBlot_C_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -O3 -DNDEBUG")

SET(SEACASBlot_FORTRAN_FLAGS " -O3")

## Extra link flags (e.g., specification of fortran libraries)
SET(SEACASBlot_EXTRA_LD_FLAGS "")

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
SET(SEACASBlot_SHARED_LIB_RPATH_COMMAND "-Wl,-rpath,/usr/lib")
SET(SEACASBlot_BUILD_SHARED_LIBS "ON")

SET(SEACASBlot_LINKER /usr/bin/ld)
SET(SEACASBlot_AR /usr/bin/ar)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## List of package include dirs
SET(SEACASBlot_INCLUDE_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../include")

## List of package library paths
SET(SEACASBlot_LIBRARY_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../lib")

## List of package libraries
SET(SEACASBlot_LIBRARIES "blotlib;plt;svdi_cgi;svdi_cdr;suplib;supes;exodus_for;exodus")

## Specification of directories for TPL headers
SET(SEACASBlot_TPL_INCLUDE_DIRS "/usr/include;/usr/include")

## Specification of directories for TPL libraries
SET(SEACASBlot_TPL_LIBRARY_DIRS "")

## List of required TPLs
SET(SEACASBlot_TPL_LIBRARIES "/usr/lib/libX11.so;/usr/lib/libnetcdf.so")

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

SET(SEACASBlot_MPI_LIBRARIES "")
SET(SEACASBlot_MPI_LIBRARY_DIRS "")
SET(SEACASBlot_MPI_INCLUDE_DIRS "")
SET(SEACASBlot_MPI_EXEC "/usr/bin/mpiexec")
SET(SEACASBlot_MPI_EXEC_MAX_NUMPROCS "4")
SET(SEACASBlot_MPI_EXEC_NUMPROCS_FLAG "-np")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

## The packages enabled for this project
SET(SEACASBlot_PACKAGE_LIST "SEACASBlot;SEACASPLT;SEACASSVDI;SEACASSuplib;SEACASSupes;SEACASExodus_for;SEACASExodus")

## The TPLs enabled for this project
SET(SEACASBlot_TPL_LIST "X11;Netcdf;MPI")


# Include configuration of dependent packages
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASPLT/SEACASPLTConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSVDI/SEACASSVDIConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplib/SEACASSuplibConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSupes/SEACASSupesConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus_for/SEACASExodus_forConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")

# Import SEACASBlot targets
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/SEACASBlotTargets.cmake")
